/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdRectangle
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_TOP = 2;
    private static final int POS_LEFT = 3;
    private static final int POS_RIGHT = 1;
    private static final int POS_BOTTOM = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;

    public void replay(WmfFile file) {
        Graphics2D graph = file.getGraphics2D();
        Rectangle rec = this.getScaledBounds();
        MfDcState state = file.getCurrentState();
        if (state.getLogBrush().isVisible()) {
            state.preparePaint();
            graph.fill(rec);
            state.postPaint();
        }
        if (state.getLogPen().isVisible()) {
            state.prepareDraw();
            graph.draw(rec);
            state.postDraw();
        }
    }

    public MfCmd getInstance() {
        return new MfCmdRectangle();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[RECTANGLE] bounds=");
        b.append(this.getBounds());
        return b.toString();
    }

    public void setRecord(MfRecord record) {
        int bottom = record.getParam(0);
        int right = record.getParam(1);
        int top = record.getParam(2);
        int left = record.getParam(3);
        this.setBounds(left, top, right - left, bottom - top);
    }

    public MfRecord getRecord() {
        Rectangle rc = this.getBounds();
        MfRecord record = new MfRecord(4);
        record.setParam(0, (int)(rc.getY() + rc.getHeight()));
        record.setParam(1, (int)(rc.getX() + rc.getWidth()));
        record.setParam(2, (int)rc.getY());
        record.setParam(3, (int)rc.getX());
        return record;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getScaledBounds() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public int getFunction() {
        return 1051;
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
    }
}

