import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6

Rectangle {
    id: toparea
    width: 1080
    height: 720
    color: "#26384c"
    opacity: 1
    visible: true
    Video {
        id: video
        width: 1080
        height: 720
        //source: "video.avi"
        opacity: (toggleinfo.checked) ? 0.3 : 1.0
        loops: Animation.Infinite

        visible: togglevisualizer.checked
    }

    Image {
        id: gradient2
        x: 0
        y: 456
        width: 1080
        height: 256
        fillMode: Image.Stretch
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0
        source: "img/darkgradient.png"
    }

    Image {
        id: gradient3
        x: 0
        width: 1080
        anchors.top: parent.top
        anchors.topMargin: 0
        rotation: 180
        fillMode: Image.Stretch
        source: "img/darkgradient.png"
    }

    ToggleSwitch {
        id: toggleinfo
        x: 68
        y: 610
        checked: true
        graphicSource: "img/info.png"
        graphicpressedSource: "img/infoP.png"
    }

    ToggleSwitch {
        id: togglevisualizer
        x: 943
        y: 610
        graphicSource: "img/viz.png"
        graphicpressedSource: "img/vizP.png"
    }

    Rectangle {
        id: infoholder
        x: 0
        y: 0
        width: 1080
        height: 720
        opacity: 1
        color: "#00ffffff"
        anchors.fill: parent
        anchors.bottomMargin: 0
        anchors.leftMargin: 0
        anchors.rightMargin: 0
        anchors.topMargin: 0
        visible: toggleinfo.checked

        Image {
            id: albumcover
            x: 65
            y: 88
            width: 400
            height: 400
            source: "img/cover.jpg"
            fillMode: Image.PreserveAspectFit
        }

        Text {
            id: musicnamefield
            x: 497
            y: 262
            width: 555
            height: 90
            color: "#f7f7f7"
            text: qsTr(playMusic.band + " - " + playMusic.song)
            font.pixelSize: 60
            horizontalAlignment: Text.AlignHCenter
        }

        Rectangle {
            id: rectangle1
            x: 285
            y: 585
            width: 605
            height: 105
            color: "#00000000"

            PushButton {
                id: nextsong
                x: 335
                y: 31
                graphicpressedMirror: true
                graphicMirror: true
                graphicSource: "img/next.png"
                graphicpressedSource: "img/nextP.png"
                onPressed: playMusic.musicid += playMusic.play()
            }
            MusicList {
                id: music
            }
            Audio {
                property var musicid: 0
                property var band: music.musiclist[musicid].band
                property var song: music.musiclist[musicid].song
                id: playMusic
                source: music.musiclist[musicid].source
                volume: volume.value
            }
            PushButton {
                id: pushButton2
                x: 250
                y: 31
                graphicSource: "img/play.png"
                graphicpressedSource: "img/playP.png"
                onPressed: playMusic.play(),video.play()
            }

            PushButton {
                id: pushButton1
                x: 164
                y: 31
                graphicSource: "img/pause.png"
                graphicpressedSource: "img/pauseP.png"
                onPressed: playMusic.pause(),video.pause()
            }

            PushButton {
                id: previoussong
                x: 28
                y: 31
                graphicSource: "img/next.png"
                graphicpressedSource: "img/nextP.png"
                onPressed: playMusic.musicid -= playMusic.play()
            }

            PushButton {
                id: pushButton4
                x: -46
                y: 30
                graphicpressedSource: "img/10secb.png"
                graphicSource: "img/10secb.png"
                onPressed: playMusic.seek(playMusic.position - 10000)
            }

            PushButton {
                id: pushButton5
                x: 460
                y: 30
                graphicpressedSource: "img/10secf.png"
                graphicSource: "img/10secf.png"
                onPressed: playMusic.seek(playMusic.position + 10000)
            }
        }

        Slider {
            id: slider
            x: 65
            y: 506
            width: 987
            height: 42
            font.pointSize: 20
            value: playMusic.position
            from: 0
            to: playMusic.duration
            background: Rectangle {
                x: slider.leftPadding
                y: slider.topPadding + slider.availableHeight / 2 - height / 2
                implicitWidth: 200
                implicitHeight: 4
                width: slider.availableWidth
                height: implicitHeight
                radius: 2
                color: "black"

                Rectangle {
                    width: slider.visualPosition * parent.width
                    height: parent.height
                    color: "red"
                    radius: 2
                }
            }

            onPositionChanged: if (pressed) {
                                   playMusic.seek(slider.value)
                               }
            handle: Rectangle {
                x: slider.leftPadding + slider.visualPosition * (slider.availableWidth - width)
                y: slider.topPadding + slider.availableHeight / 2 - height / 2
                implicitWidth: 26
                implicitHeight: 26
                radius: 13
                color: slider.pressed ? "#f0f0f0" : "#f6f6f6"
                border.color: "#bdbebf"

                //on:  playMusic.seek(slider.position)
            }
        }

        Slider {
            id: volume
            x: 15
            y: 675
            width: 308
            height: 40
            value: 0.5
            ToolTip {
                background: Rectangle {
                    implicitWidth: 26
                    implicitHeight: 26
                    radius: 13
                    color: "transparent"
                    Text {
                        id: musictimetext
                        text: Math.floor(volume.value * 50)
                        color: "white"
                        font.pixelSize: 20
                    }
                }
                parent: volume.handle
                visible: volume.pressed
            }
        }
    }

    Text {
        id: time
        x: 909
        y: 8
        width: 163
        height: 56
        color: "#f7f7f7"
        text: clock.hours + ":" + (clock.minutes < 10 ? "0" : "") + clock.minutes
        font.pixelSize: 40
        horizontalAlignment: Text.AlignRight
    }

    Text {

        function millisToMinutesAndSeconds(millis) {
            var minutes = Math.floor(millis / 60000)
            var seconds = ((millis % 60000) / 1000).toFixed(0)
            return minutes + ":" + (seconds < 10 ? '0' : '') + seconds
        }
        id: currentTime
        x: 68
        y: 550
        width: 60
        height: 31
        color: "#f9f9f9"
        text: millisToMinutesAndSeconds(playMusic.position)
        font.pixelSize: 20
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    Text {
        function millisToMinutesAndSeconds(millis) {
            var minutes = Math.floor(millis / 60000)
            var seconds = ((millis % 60000) / 1000).toFixed(0)
            return minutes + ":" + (seconds < 10 ? '0' : '') + seconds
        }
        id: totalTime
        x: 985
        y: 550
        width: 60
        height: 31
        color: "#f9f9f9"
        text: millisToMinutesAndSeconds(playMusic.duration)
        font.pixelSize: 20
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }
}

/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/
