//import QtQuick 2.12
import highendivisystem 1.0
import QtQuick 2.15
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6
import Quick3DAssets.Plane 1.0
import QtQuick3D.Materials 1.14
import QtQuick3D.Materials 1.15

Rectangle {
    id: bg
    width: 1080
    height: 1920
    color: "#1c2630"

    Clock {
        id: clock
    }
    Toparea {
        id: toparea
        x: 0
        y: 0
        color: bg.color
    }
    Centerarea {
        id: centerarea
        x: 0
        y: 720
        color: bg.color
        //Clear sun
        weathericonsClearOpacity: (cloudctrl.value < 0.3
                                   && rainctrl.value < 0.01 && !tornado.checked
                                   && !thunder.checked
                                   && !night.checked) ? 1.0 : 0.0
        //Clear moon
        weathericonsClearnightOpacity: (cloudctrl.value < 0.3
                                        && rainctrl.value < 0.01
                                        && !tornado.checked && !thunder.checked
                                        && night.checked) ? 1.0 : 0.0
        //Rain sun
        weathericonsRainsunOpacity: (cloudctrl.value < 0.3
                                     && rainctrl.value > 0.01
                                     && !tornado.checked
                                     && !night.checked) ? 1.0 : 0.0
        //Rain moon
        weathericonsRainmoonOpacity: (cloudctrl.value < 0.3
                                      && rainctrl.value > 0.01
                                      && !tornado.checked
                                      && night.checked) ? 1.0 : 0.0
        //Brokenclouds
        weathericonsBrokencloudsOpacity: (cloudctrl.value >= 0.01
                                          && cloudctrl.value < 0.3
                                          && rainctrl.value < 0.01
                                          && !tornado.checked
                                          && !thunder.checked) ? 1.0 : 0.0
        //Overcast
        weathericonsOvercastOpacity: (cloudctrl.value >= 0.3
                                      && rainctrl.value < 0.01
                                      && !tornado.checked
                                      && !thunder.checked) ? 1.0 : 0.0
        //Rain
        weathericonsLightrainOpacity: (tempctrl.value > 1.0
                                       && rainctrl.value > 0
                                       && rainctrl.value < 0.3
                                       && !tornado.checked
                                       && !thunder.checked) ? 1.0 : 0.0
        weathericonsRainOpacity: (tempctrl.value > 1.0 && rainctrl.value >= 0.3
                                  && rainctrl.value < 0.7 && !tornado.checked
                                  && !thunder.checked) ? 1.0 : 0.0
        weathericonsHeavyrainOpacity: (tempctrl.value > 1.0
                                       && rainctrl.value >= 0.7
                                       && !tornado.checked
                                       && !thunder.checked) ? 1.0 : 0.0
        //Wintermix
        weathericonsWintermixOpacity: (tempctrl.value < 1.5
                                       && tempctrl.value >= -0.5
                                       && rainctrl.value > 0 && !tornado.checked
                                       && !thunder.checked) ? 1.0 : 0.0
        //Snow
        weathericonsLightsnowOpacity: (tempctrl.value < -0.5
                                       && rainctrl.value > 0
                                       && rainctrl.value < 0.3
                                       && !tornado.checked
                                       && !thunder.checked) ? 1.0 : 0.0
        weathericonsSnowOpacity: (tempctrl.value < -0.5 && rainctrl.value >= 0.3
                                  && !tornado.checked
                                  && !thunder.checked) ? 1.0 : 0.0

        // Hot and Cold
        //weathericonsHotOpacity: (tempctrl.value > 35) ? 1.0 : 0.0
        //weathericonsColdOpacity: (tempctrl.value < -35) ? 1.0 : 0.0

        //wind
        weathericonsWindyOpacity: (windctrl.value > 0.5
                                   && !tornado.checked) ? 1.0 : 0.0
        weathericonsThunderOpacity: (thunder.checked
                                     && !tornado.checked) ? 1.0 : 0.0
        weathericonsTornadoOpacity: (tornado.checked
                                     && !thunder.checked) ? 1.0 : 0.0
    }

    Ac {
        id: ac
        x: 0
        y: 1440
        color: "#1c2630"
    }

    Rectangle {
        id: reverseCamera
        x: 0
        y: 720
        width: 1080
        height: 720
        visible: gearreverse.checked && centerarea.rearinterruptionChecked
        color: "#000000"

        Image {
            id: reverseimage
            x: 0
            y: 0
            source: "img/reverseimage.jpg"
            fillMode: Image.PreserveAspectFit
        }

        View3D {
            id: view3D
            x: 0
            y: 0
            width: 1080
            height: 720
            SceneEnvironment {
                id: sceneEnvironment
                antialiasingQuality: SceneEnvironment.High
                antialiasingMode: SceneEnvironment.MSAA
            }

            Node {
                id: scene
                DirectionalLight {
                    id: directionalLight
                }

                PerspectiveCamera {
                    id: camera
                    x: 0
                    y: 38.12
                    eulerRotation.z: -0.85688
                    eulerRotation.y: 0.71156
                    eulerRotation.x: -3.57328
                    z: 346.80728
                }

                Model {
                    id: leftWheeltrack
                    x: -283.958
                    y: -195.832
                    source: "plane.mesh"
                    materials: lanematerial1
                    z: 0.01033
                    scale.z: 100
                    scale.y: 19.12852
                    scale.x: 100
                    eulerRotation.z: 90
                    eulerRotation.x: -90
                    eulerRotation.y: -179.99791

                    Lanematerial {
                        id: lanematerial1
                        midTweak: 0
                        end: -40
                        start: -1
                        bend: (-1.0 + (2 * steeringslider.value)) / 10
                    }
                }

                Model {
                    id: rightwheeltrack
                    x: 267.305
                    y: -195.832
                    source: "plane.mesh"
                    materials: lanematerial
                    eulerRotation.x: -90
                    eulerRotation.z: 90
                    scale.z: 100
                    z: -0.00982
                    eulerRotation.y: -179.99791
                    scale.x: 100
                    scale.y: 19.12852

                    Lanematerial {
                        id: lanematerial
                        midTweak: 0
                        end: -40
                        start: -1
                        bend: (-1.0 + (2 * steeringslider.value)) / 10
                    }
                }
            }
            environment: sceneEnvironment
        }
    }

    Rectangle {
        id: controlgroup
        x: -9
        y: 1434
        width: 1080
        height: 480
        color: "#00979797"

        CheckBox {
            id: controltoggle
            x: 1035
            y: -48
            visible: true
            checked: false
        }

        Rectangle {
            id: rectangle3
            visible: controltoggle.checked
            x: 780
            y: 8
            width: 309
            height: 478
            color: "#4d4d4d"
        }

        Rectangle {
            id: rectangle1
            visible: controltoggle.checked
            x: 292
            y: 8
            width: 287
            height: 478
            color: "#4d4d4d"
        }

        Rectangle {
            id: rectangle
            visible: controltoggle.checked
            x: 9
            y: 8
            width: 287
            height: 478
            color: "#ffffff"
        }

        Rectangle {
            id: rectangle2
            visible: controltoggle.checked
            x: 579
            y: 8
            width: 201
            height: 478
            color: "#ffffff"
        }

        Rectangle {
            id: controlpanel
            x: 9
            y: 6
            width: 1080
            height: 480
            color: "#b9979797"
            visible: controltoggle.checked

            Slider {
                id: tempctrl
                x: 20
                y: 94
                to: 40
                from: -40
                value: 12
            }

            Slider {
                id: rainctrl
                x: 20
                y: 156
                value: 0
            }

            Text {
                id: weathertext
                x: 40
                y: 15
                width: 206
                height: 56
                text: qsTr("Weather")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
            }

            Text {
                id: raintext
                x: 23
                y: 116
                width: 206
                height: 56
                text: qsTr("Rain")
                font.pixelSize: 20
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: temptext
                x: 23
                y: 70
                width: 206
                height: 32
                text: qsTr("Temp")
                font.pixelSize: 20
                horizontalAlignment: Text.AlignHCenter
            }

            Text {
                id: doortext
                x: 824
                y: 15
                width: 206
                height: 56
                text: qsTr("Doors")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
            }

            CheckBox {
                id: hoodf
                x: 825
                y: 86
                text: qsTr("Hood")
                font.pointSize: 12
            }

            CheckBox {
                id: doorfl
                x: 825
                y: 132
                text: qsTr("Door FL")
                font.pointSize: 12
            }

            CheckBox {
                id: doorfr
                x: 940
                y: 132
                text: qsTr("Door FR")
                font.pointSize: 12
            }

            CheckBox {
                id: doorrl
                x: 825
                y: 184
                text: qsTr("Door RL")
                font.pointSize: 12
            }

            CheckBox {
                id: doorrr
                x: 940
                y: 184
                text: qsTr("Door RR")
                font.pointSize: 12
            }

            CheckBox {
                id: trunkr
                x: 825
                y: 230
                text: qsTr("Trunk")
                font.pointSize: 12
            }

            Text {
                id: cloudtext
                x: 23
                y: 178
                width: 206
                height: 56
                text: qsTr("Clouds")
                font.pixelSize: 20
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Slider {
                id: cloudctrl
                x: 23
                y: 214
                value: 0
            }

            Text {
                id: temptext1
                x: 229
                y: 86
                width: 93
                height: 56
                text: tempctrl.value.toString()
                font.pixelSize: 30
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: temptext2
                x: 226
                y: 148
                width: 93
                height: 56
                text: rainctrl.value.toString()
                font.pixelSize: 30
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: temptext3
                x: 229
                y: 206
                width: 93
                height: 56
                text: cloudctrl.value.toString()
                font.pixelSize: 30
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }

            CheckBox {
                id: thunder
                x: 146
                y: 334
                text: qsTr("Thunder")
            }

            CheckBox {
                id: tornado
                x: 26
                y: 387
                text: qsTr("Tornado")
            }

            CheckBox {
                id: night
                x: 26
                y: 334
                text: qsTr("Night")
            }

            Slider {
                id: windctrl
                x: 23
                y: 276
                value: 0
            }

            Text {
                id: windtext
                x: 26
                y: 241
                width: 206
                height: 56
                text: qsTr("Wind")
                font.pixelSize: 20
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: temptext4
                x: 232
                y: 268
                width: 93
                height: 56
                text: windctrl.value.toString()
                font.pixelSize: 30
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }

            Switch {
                id: gearpark
                x: 663
                y: 92
                text: qsTr("")
                checked: gearslider.value == 0
            }

            Switch {
                id: gearreverse
                x: 663
                y: 155
                text: qsTr("")
                checked: gearslider.value == 0.2
            }

            Switch {
                id: gearneutral
                x: 663
                y: 219
                text: qsTr("")
                checked: gearslider.value == 0.4
            }

            Switch {
                id: geardrive
                x: 663
                y: 280
                text: qsTr("")
                checked: gearslider.value > 0.59 && gearslider.value < 0.61
            }

            Switch {
                id: gearone
                x: 663
                y: 341
                text: qsTr("")
                checked: gearslider.value == 0.8
            }

            Switch {
                id: gearonetwo
                x: 663
                y: 402
                text: qsTr("")
                checked: gearslider.value == 1
            }
            Slider {
                id: gearslider
                x: 431
                y: 247
                width: 350
                stepSize: 0.2
                snapMode: Slider.SnapAlways
                to: 1
                rotation: 90
                value: 0
            }

            Text {
                id: cartext1
                x: 626
                y: 88
                width: 40
                height: 48
                text: qsTr("P")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: cartext2
                x: 626
                y: 151
                width: 40
                height: 48
                text: qsTr("R")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: cartext3
                x: 626
                y: 215
                width: 40
                height: 48
                text: qsTr("N")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: cartext4
                x: 626
                y: 276
                width: 40
                height: 48
                text: qsTr("D")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: cartext5
                x: 626
                y: 337
                width: 40
                height: 48
                text: qsTr("1")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: cartext6
                x: 626
                y: 398
                width: 40
                height: 48
                text: qsTr("2")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Slider {
                id: steeringslider
                x: 313
                y: 410
                width: 221
                height: 40
                value: 0.5
            }

            Slider {
                id: flwindowslider
                x: 807
                y: 367
                width: 120
                height: 31
                to: 0.4
                rotation: 90
                value: 0
            }

            Slider {
                id: frwindowslider
                x: 845
                y: 368
                width: 120
                height: 31
                to: 0.4
                value: 0
                rotation: 90
            }

            Slider {
                id: rlwindowslider
                x: 897
                y: 368
                width: 120
                height: 31
                to: 0.4
                value: 0
                rotation: 90
            }

            Slider {
                id: rrwindowslider
                x: 935
                y: 368
                width: 120
                height: 31
                to: 0.4
                value: 0
                rotation: 90
            }

            CheckBox {
                id: drivelight
                x: 308
                y: 139
                text: qsTr("Drivelight")
                font.pointSize: 12
            }

            CheckBox {
                id: brakelight
                x: 308
                y: 235
                text: qsTr("Brakelight")
                font.pointSize: 12
            }

            CheckBox {
                id: turnleftlight
                x: 308
                y: 287
                text: qsTr("Turn L")
                font.pointSize: 12
            }

            CheckBox {
                id: turnrightlight
                x: 434
                y: 287
                text: qsTr("Turn R")
                font.pointSize: 12
            }

            CheckBox {
                id: foglight
                x: 308
                y: 185
                text: qsTr("Foglight")
                font.pointSize: 12
            }

            CheckBox {
                id: highbeam
                x: 434
                y: 139
                text: qsTr("Highbeam")
                font.pointSize: 12
            }

            Slider {
                id: lightheight
                x: 348
                y: 94
                width: 150
                rotation: 0
                snapMode: Slider.NoSnap
                value: 0.5
                stepSize: 0
                to: 1
            }

            CheckBox {
                id: emergency
                x: 308
                y: 335
                text: qsTr("Emergency")
                font.pointSize: 12
            }

            Text {
                id: lightstext
                x: 320
                y: 15
                width: 206
                height: 56
                text: qsTr("Lights")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
            }

            Text {
                id: geartext
                x: 564
                y: 15
                width: 206
                height: 56
                text: qsTr("Gear")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
            }

            Text {
                id: steeringtext
                x: 320
                y: 365
                width: 206
                height: 56
                text: qsTr("Steering")
                font.pixelSize: 20
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }

            Text {
                id: windowtext
                x: 824
                y: 268
                width: 206
                height: 56
                text: qsTr("Windows")
                font.pixelSize: 40
                horizontalAlignment: Text.AlignHCenter
            }
        }
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: 1000
                to: 1000
                running: false
                from: 0
                loops: 1
            }
        ]
        endFrame: 20000
        startFrame: 0
        enabled: false
        currentFrame: 1000 * realscroll.position

        KeyframeGroup {
            target: glow
            property: "color"

            Keyframe {
                frame: 0
                value: "#f20e44"
            }

            Keyframe {
                frame: 1000
                value: "#0e66f2"
            }
        }
    }

    Timeline {
        id: car
        animations: [
            TimelineAnimation {
                id: rotate
                running: true
                duration: 20000
                loops: -1
                to: 20000
                from: 0
            }
        ]
        endFrame: 20000
        enabled: true
        startFrame: 0

        KeyframeGroup {
            target: cargroup
            property: "eulerRotation.y"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 20000
                value: 360
            }
        }

        KeyframeGroup {
            target: cargroup1
            property: "eulerRotation.y"
            Keyframe {
                frame: 0
                value: 360
            }

            Keyframe {
                frame: 20000
                value: 0
            }
        }

        KeyframeGroup {
            target: carshadow8
            property: "eulerRotation.z"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 20000
                value: 360
            }
        }
    }

    ColumnLayout {
        id: columnLayout
        x: 0
        y: 1228
        width: 320
        height: 212
        spacing: -70

        Rectangle {
            Layout.alignment: Qt.AlignBottom
            id: popuplatch
            width: 250
            height: 70
            visible: centerarea.doorbackrightIsOpen
                     || centerarea.doorbackleftIsOpen
                     || centerarea.doorfrontleftIsOpen
                     || centerarea.doorfrontrightIsOpen
                     || centerarea.trunkIsOpen || centerarea.hoodIsOpen
            color: "#00000000"

            Image {
                id: image
                x: 15
                y: 15
                width: 49
                height: 40
                source: "img/warning.png"
                fillMode: Image.PreserveAspectFit
            }

            Text {
                id: element
                x: 78
                y: 9
                width: 267
                height: 52
                color: "#fdfdfd"
                text: qsTr("Latch open")
                font.pixelSize: 30
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }
        }

        Rectangle {

            id: popupice
            visible: tempctrl.value < 1
            width: 250
            height: 70
            color: "#00000000"
            Layout.alignment: Qt.AlignBottom
            Image {
                id: image4
                x: 15
                y: 15
                width: 49
                height: 40
                source: "img/warning.png"
                fillMode: Image.PreserveAspectFit
            }

            Text {
                id: element5
                x: 78
                y: 9
                width: 267
                height: 52
                color: "#fdfdfd"
                text: qsTr("Ice possible")
                font.pixelSize: 30
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }
        }

        Rectangle {
            id: aquaplaning
            width: 250
            height: 70
            visible: rainctrl.value > 0.4 && tempctrl.value > 0.5
            color: "#00000000"
            Layout.alignment: Qt.AlignBottom
            Image {
                id: image5
                x: 15
                y: 15
                width: 49
                height: 40
                source: "img/warning.png"
                fillMode: Image.PreserveAspectFit
            }

            Text {
                id: element6
                x: 78
                y: 9
                width: 267
                height: 52
                color: "#fdfdfd"
                text: qsTr("Aquaplaning")
                font.pixelSize: 30
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }
        }

        Rectangle {
            id: visibility
            width: 250
            height: 70
            visible: rainctrl.value > 0.8
            color: "#00000000"
            Layout.alignment: Qt.AlignBottom
            Image {
                id: image6
                x: 15
                y: 15
                width: 49
                height: 40
                source: "img/warning.png"
                fillMode: Image.PreserveAspectFit
            }

            Text {
                id: element7
                x: 78
                y: 9
                width: 267
                height: 52
                color: "#fdfdfd"
                text: qsTr("Visibility")
                font.pixelSize: 30
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }
        }
    }
    Splashscreen {
        id: splashscreen
        x: 0
        y: 0
        visible: false
    }
}

/*##^##
Designer {
    D{i:0;active3dScene:378;formeditorZoom:0.25}D{i:33;invisible:true}D{i:34;invisible:true}
D{i:35;invisible:true}D{i:36;invisible:true}D{i:37;invisible:true}D{i:38;invisible:true}
D{i:39;invisible:true}D{i:40;invisible:true}D{i:42;invisible:true}D{i:43;invisible:true}
D{i:44;invisible:true}D{i:57;invisible:true}D{i:58;invisible:true}D{i:64;invisible:true}
D{i:65;invisible:true}D{i:66;invisible:true}D{i:67;invisible:true}D{i:68;invisible:true}
D{i:69;invisible:true}D{i:70;invisible:true}D{i:71;invisible:true}D{i:79;invisible:true}
D{i:80;invisible:true}D{i:78;invisible:true}D{i:77;invisible:true}D{i:76;invisible:true}
D{i:84;invisible:true}D{i:85;invisible:true}D{i:83;invisible:true}D{i:87;invisible:true}
D{i:88;invisible:true}D{i:86;invisible:true}D{i:90;invisible:true}D{i:91;invisible:true}
D{i:89;invisible:true}D{i:82;invisible:true}D{i:81;invisible:true}
}
##^##*/

