import highendivisystem 1.0
import QtQuick 2.15
import QtQuick3D 1.15
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6
import Quick3DAssets.CarLights 1.0
import QtQuick3D.Materials 1.14
import QtQuick3D.Materials 1.15

Model {
    id: highBeam
    x: 0
    visible: highbeam.checked
    source: "asset_imports/Quick3DAssets/HighBeam/meshes/highBeam.mesh"
    receivesShadows: false
    castsShadows: false
    materials: defaultMaterial2
    scale.z: 128.25404
    scale.y: 100
    scale.x: 100
    z: 176.38983
    eulerRotation.x: 15

    DefaultMaterial {
        id: defaultMaterial2
        diffuseMap: texture2
        lighting: DefaultMaterial.NoLighting
        diffuseColor: "#ffffff"

        Texture {
            id: texture2
            source: "img/conelight.png"
        }
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                loops: 1
                duration: 1000
                running: true
                to: 1000
                from: 0
            }
        ]
        enabled: true
        endFrame: 1000
        startFrame: 0
        currentFrame: lightheight.value * 1000

        KeyframeGroup {
            target: highBeam
            property: "eulerRotation.x"
            Keyframe {
                frame: 1000
                value: -15
            }

            Keyframe {
                frame: 0
                value: 15
            }
        }
    }
}
