import QtQuick
import QtQuick.Controls
import QtQuick.Timeline
import Generated.DesignSystem

Rectangle {
    id: trackView
    width: 234
    height: 253
    color: "transparent"
    property alias paceValueText: paceValue.text
    property alias titleText: title.text
    property alias minutesPerMileText: minutesPerMile.text
    property alias paceText: pace.text
    property alias timeValueText: timeValue.text
    property alias timeline: timeline
    property bool paused: false
    property alias timelineAnimation: timelineAnimation

    Image {
        id: track
        x: 1
        y: 129
        source: "assets/track.png"
    }

    Rectangle {
        id: paceDisplay
        x: 61
        y: 159
        width: 113
        height: 70
        color: "transparent"
        Text {
            id: paceValue
            x: 21
            y: 0
            width: 71
            height: 40
            color: Colors.currentTheme.primary
            text: qsTr("0:00")
            font.pixelSize: 32
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            wrapMode: Text.NoWrap
            font.weight: Font.DemiBold
            font.family: "Exo"
        }

        Text {
            id: minutesPerMile
            x: 48
            y: 47
            width: 66
            height: 19
            color: Colors.currentTheme.primary
            text: qsTr("(MINS/Mi)")
            font.pixelSize: 14
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            wrapMode: Text.NoWrap
            font.weight: Font.Medium
            font.family: "Exo"
        }

        Text {
            id: pace
            x: 0
            y: 43
            width: 49
            height: 27
            color: Colors.currentTheme.primary
            text: qsTr("PACE")
            font.pixelSize: 20
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            wrapMode: Text.NoWrap
            font.weight: Font.Medium
            font.family: "Exo"
        }
    }

    Rectangle {
        id: timeDisplay
        x: 15
        y: 0
        width: 204
        height: 113
        color: "transparent"
        Text {
            id: timeValue
            x: 0
            y: 17
            width: 205
            height: 96
            color: Colors.currentTheme.primary
            text: qsTr("00:00")
            font.pixelSize: 72
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignTop
            wrapMode: Text.NoWrap
            font.weight: Font.DemiBold
            font.family: "Exo"
        }

        Text {
            id: title
            x: 95
            y: 0
            width: 47
            height: 28
            color: Colors.currentTheme.primary
            text: qsTr("Time")
            font.pixelSize: 20
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            wrapMode: Text.NoWrap
            font.weight: Font.Medium
            font.family: "Exo"
        }

        Image {
            id: paceIconDark
            x: 65
            y: 4
            source: "assets/paceIconDark.png"
        }
    }

    Image {
        id: trackView_merge_1
        x: 46
        y: 116
        source: "assets/trackView_merge_1.png"
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                running: false
                loops: -1
                duration: trackView.paused ? 10000 - timeline.currentFrame * 10 : 10000
                to: 1000
                from: trackView.paused ? timeline.currentFrame : 0
            }
        ]
        startFrame: 0
        endFrame: 1000
        enabled: true

        KeyframeGroup {
            target: trackView_merge_1
            property: "x"
            Keyframe {
                value: 44
                frame: 0
            }

            Keyframe {
                value: 158
                frame: 200
            }

            Keyframe {
                value: 168
                frame: 220
            }

            Keyframe {
                value: 178
                frame: 240
            }

            Keyframe {
                value: 188
                frame: 260
            }

            Keyframe {
                value: 198
                frame: 280
            }

            Keyframe {
                value: 204
                frame: 300
            }

            Keyframe {
                value: 210
                frame: 320
            }

            Keyframe {
                value: 211
                frame: 340
            }

            Keyframe {
                value: 210
                frame: 380
            }

            Keyframe {
                value: 204
                frame: 400
            }

            Keyframe {
                value: 198
                frame: 420
            }

            Keyframe {
                value: 188
                frame: 440
            }

            Keyframe {
                value: 178
                frame: 460
            }

            Keyframe {
                value: 168
                frame: 480
            }

            Keyframe {
                value: 158
                frame: 500
            }

            Keyframe {
                value: 44
                frame: 700
            }

            Keyframe {
                value: 34
                frame: 720
            }

            Keyframe {
                value: 24
                frame: 740
            }

            Keyframe {
                value: 14
                frame: 760
            }

            Keyframe {
                value: 4
                frame: 780
            }

            Keyframe {
                value: -2
                frame: 800
            }

            Keyframe {
                value: -6
                frame: 820
            }

            Keyframe {
                value: -9
                frame: 840
            }

            Keyframe {
                value: -9
                frame: 860
            }

            Keyframe {
                value: -6
                frame: 880
            }

            Keyframe {
                value: -2
                frame: 900
            }

            Keyframe {
                value: 4
                frame: 920
            }

            Keyframe {
                value: 14
                frame: 940
            }

            Keyframe {
                value: 24
                frame: 960
            }

            Keyframe {
                value: 34
                frame: 980
            }

            Keyframe {
                value: 44
                frame: 1000
            }
        }

        KeyframeGroup {
            target: trackView_merge_1
            property: "y"
            Keyframe {
                value: 119
                frame: 0
            }

            Keyframe {
                value: 120
                frame: 220
            }

            Keyframe {
                value: 123
                frame: 240
            }

            Keyframe {
                value: 128
                frame: 260
            }

            Keyframe {
                value: 136
                frame: 280
            }

            Keyframe {
                value: 146
                frame: 300
            }

            Keyframe {
                value: 157
                frame: 320
            }

            Keyframe {
                value: 171
                frame: 340
            }

            Keyframe {
                value: 185
                frame: 360
            }

            Keyframe {
                value: 196
                frame: 380
            }

            Keyframe {
                value: 207
                frame: 400
            }

            Keyframe {
                value: 215
                frame: 420
            }

            Keyframe {
                value: 221
                frame: 440
            }

            Keyframe {
                value: 226
                frame: 460
            }

            Keyframe {
                value: 230
                frame: 480
            }

            Keyframe {
                value: 231
                frame: 500
            }

            Keyframe {
                value: 119
                frame: 200
            }

            Keyframe {
                value: 230
                frame: 720
            }

            Keyframe {
                value: 226
                frame: 740
            }

            Keyframe {
                value: 221
                frame: 760
            }

            Keyframe {
                value: 215
                frame: 780
            }

            Keyframe {
                value: 207
                frame: 800
            }

            Keyframe {
                value: 196
                frame: 820
            }

            Keyframe {
                value: 185
                frame: 840
            }

            Keyframe {
                value: 171
                frame: 860
            }

            Keyframe {
                value: 157
                frame: 880
            }

            Keyframe {
                value: 146
                frame: 900
            }

            Keyframe {
                value: 136
                frame: 920
            }

            Keyframe {
                value: 128
                frame: 940
            }

            Keyframe {
                value: 123
                frame: 960
            }

            Keyframe {
                value: 120
                frame: 980
            }

            Keyframe {
                value: 119
                frame: 1000
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"3b098de0-ec98-563c-abac-58cb6bf7179e"}D{i:1;uuid:"7879acd8-c309-5914-89fd-7a2d06cb823b"}
D{i:2;uuid:"67891169-a02c-5d17-852d-24e955048362"}D{i:3;uuid:"898d2fe2-7e19-52a6-b2f7-a2a0a28209d6"}
D{i:4;uuid:"b3a98191-af06-51a6-8d93-00ed7d9013a4"}D{i:5;uuid:"c14e9385-ecb2-546d-ac09-ed6b438931fa"}
D{i:6;uuid:"b1372238-7627-5fec-8b9c-4dc43bfee601"}D{i:7;uuid:"e5de1b60-29e2-5867-804e-8674b41c24e5"}
D{i:8;uuid:"59f1b576-9e94-534d-9429-7f16683fc266"}D{i:9;uuid:"b5f5a4c1-9058-59ef-9928-493eb889612c"}
D{i:10;uuid:"925a5292-5dec-57d4-a259-120ecd6d303e"}
}
##^##*/

