import QtQuick
import QtQuick.Controls
import Generated.DesignSystem

Button {
    id: modeSwitch
    width: 88
    height: 28
    checkable: true
    background: Item {}

    Rectangle {
        id: background1
        x: 0
        y: 0
        width: 88
        height: 28
        color: Colors.currentTheme.black
        radius: 20
    }

    Rectangle {
        id: autoHandle
        x: 46
        y: 2
        width: 40
        height: 24
        visible: modeSwitch.checked
        color: Colors.currentTheme.secondary
        radius: 20
    }

    Rectangle {
        id: manualHandle
        x: 2
        y: 2
        width: 40
        height: 24
        visible: !modeSwitch.checked
        color: Colors.currentTheme.secondary
        radius: 20
    }

    Image {
        id: autoModeIcon
        x: 57
        y: 5
        source: "assets/autoModeIcon.png"
    }

    Image {
        id: manualModeIcon
        x: 13
        y: 5
        source: "assets/manualModeIcon.png"
    }
}

/*##^##
Designer {
    D{i:0;uuid:"f8e699f5-63e9-55b8-bdaf-ff5998d72e8b"}D{i:1;uuid:"29300941-aaa5-5444-b515-6e15037da9eb"}
D{i:2;uuid:"d2f2b4db-7191-58d5-b0f9-b1fb2f37659f"}D{i:3;uuid:"6c0ff5c2-fe5f-5b19-a106-ea279a0faf39"}
D{i:4;uuid:"11816c57-6d6e-58f0-8b01-f17deadd60ae"}D{i:5;uuid:"9d79e41e-1708-5267-aeb0-29e1bbb4cee3"}
}
##^##*/

