import QtQuick
import QtQuick.Controls
import Generated.DesignSystem

Rectangle {
    id: infoPanel
    width: 120
    height: 120
    color: "transparent"
    property alias panelTitleText: panelTitle.text
    property alias infoPanelIcon: infoPanelIcon
    property alias counterText: counter.text

    Text {
        id: counter
        x: 31
        y: 60
        width: 60
        height: 40
        color: Colors.currentTheme.black
        text: qsTr("000")
        font.pixelSize: 30
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.NoWrap
        font.weight: Font.DemiBold
        font.family: "Exo"
    }

    Text {
        id: panelTitle
        x: 14
        y: 37
        width: 94
        height: 28
        color: Colors.currentTheme.black
        text: qsTr("HEART RATE")
        font.pixelSize: 16
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.NoWrap
        font.weight: Font.Medium
        font.family: "Exo"
    }

    Image {
        id: infoPanelIcon
        x: 49
        y: 16
        source: "assets/infoPanelIcon.png"
    }
}

/*##^##
Designer {
    D{i:0;uuid:"d7906bba-dc5f-5dcb-a6fc-4a791f4eb8b8"}D{i:1;uuid:"e9848834-6fb1-52a2-82c2-dfa02c96de91"}
D{i:2;uuid:"ace4b238-f653-5858-a239-0b208dacbc9f"}D{i:3;uuid:"dd4c0414-51d1-58bc-be46-0488e2413e9b"}
}
##^##*/

