import QtQuick
import QtQuick.Controls

Item {
    id: controlOverlay

    property alias displaceButton: displaceButton
    property alias rainAndThunderButton: rainAndThunderButton
    property alias noiseButton: noiseButton
    property alias glowAndSwirlButton: glowAndSwirlButton

    width: 1280
    height: 800

    Text {
        width: parent.width
        height: parent.height / 8
        color: "#e6ffffff"
        text: qsTr("Effect Composer Example")
        font.pixelSize: Math.min(parent.width / 20, parent.height / 15)
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.styleName: "Regular"
        font.family: "Titillium Web"
    }

    ArrowButton {
        id: arrowButton

        iconText:  noiseButton.checked || rainAndThunderButton.checked ? qsTr("<") : qsTr(">")
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: parent.left
        visible: false
        iconRotation: topControlPanel.visible ? 180 : 0

        Connections {
            onClicked: {
                topControlPanel.visible = !topControlPanel.visible
                if (controlOverlay.state === "glowAndSwirl" || controlOverlay.state === "rainAndThunder")
                    bottomControlPanel.visible = !bottomControlPanel.visible
            }
        }
    }

    ControlPanel {
        id: topControlPanel

        width: Math.min(spacer.width, controlOverlay.height * 0.45)
        height: childrenRect.height - panelTitleHeight
        anchors.left: spacer.left
        anchors.bottom: spacer.top
        visible: false

        EffectSlider {
            id: firstTopSlider

            width: parent.width * 0.9
            height: visible ? width / 4 : 0
            anchors.horizontalCenter: parent.horizontalCenter
        }

        EffectSlider {
            id: secondTopSlider

            width: parent.width * 0.9
            height: visible ? width / 4 : 0
            anchors.top: firstTopSlider.bottom
            anchors.horizontalCenter: parent.horizontalCenter
        }

        EffectSlider {
            id: thirdTopSlider

            width: parent.width * 0.9
            height: visible ? width / 4 : 0
            anchors.top: secondTopSlider.bottom
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Item {
        id: spacer

        width: controlOverlay.width / 3.6
        height: topControlPanel.panelTitleHeight
        anchors.verticalCenter: controlOverlay.verticalCenter
        anchors.left: arrowButton.right
    }

    ControlPanel {
        id: bottomControlPanel

        width: Math.min(spacer.width, controlOverlay.height * 0.45)
        height: childrenRect.height - panelTitleHeight
        anchors.left: spacer.left
        anchors.top: spacer.bottom
        visible: false

        EffectSlider {
            id: firstBottomSlider

            width: parent.width * 0.9
            height: visible ? width / 4 : 0
            anchors.horizontalCenter: parent.horizontalCenter
        }

        EffectSlider {
            id: secondBottomSlider

            width: parent.width * 0.9
            height: visible ? width / 4 : 0
            anchors.top: firstBottomSlider.bottom
            anchors.horizontalCenter: parent.horizontalCenter
        }

        EffectSlider {
            id: thirdBottomSlider

            width: parent.width * 0.9
            height: visible ? width / 4 : 0
            anchors.top: secondBottomSlider.bottom
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Row {
        id: buttonLayout

        height: parent.height / 8
        anchors.bottom: parent.bottom
        anchors.horizontalCenter: parent.horizontalCenter
        spacing: 5

        SelectionButton {
            id: displaceButton

            width: controlOverlay.width / 5
            height: controlOverlay.height / 10
            text: qsTr("Displace")

            Connections {
                onClicked: {
                    glowAndSwirlButton.checked = false
                    noiseButton.checked = false
                    rainAndThunderButton.checked = false
                }
            }
        }

        SelectionButton {
            id: glowAndSwirlButton

            width: controlOverlay.width / 5
            height: controlOverlay.height / 10
            text: qsTr("Glow and Swirl")

            Connections {
                onClicked: {
                    displaceButton.checked = false
                    noiseButton.checked = false
                    rainAndThunderButton.checked = false
                }
            }
        }

        SelectionButton {
            id: noiseButton

            width: controlOverlay.width / 5
            height: controlOverlay.height / 10
            text: qsTr("Noise")

            Connections {
                onClicked: {
                    displaceButton.checked = false
                    glowAndSwirlButton.checked = false
                    rainAndThunderButton.checked = false
                }
            }
        }

        SelectionButton {
            id: rainAndThunderButton

            width: controlOverlay.width / 5
            height: controlOverlay.height / 10
            text: qsTr("Rain and Thunder")

            Connections {
                onClicked: {
                    displaceButton.checked = false
                    glowAndSwirlButton.checked = false
                    noiseButton.checked = false
                }
            }
        }
    }

    states: [
        State {
            name: "noEffect"
            when: !welcomeOverlay.visible && !displaceButton.checked && !glowAndSwirlButton.checked && !noiseButton.checked && !rainAndThunderButton.checked
        },

        State {
            name: "displace"
            when: displaceButton.checked

            PropertyChanges {
                target: topControlPanel
                visible: true
                titleText: "Displace"
            }

            PropertyChanges {
                target: firstTopSlider
                visible: true
                sliderTitle: "Displacement"
                sliderFrom: -1
                sliderTo: 1
                sliderValue: root.displaceValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "displace")
                        root.displaceValue = firstTopSlider.sliderValue
                }
            }

            PropertyChanges {
                target: secondTopSlider
                visible: false
            }

            PropertyChanges {
                target: thirdTopSlider
                visible: false
            }

            PropertyChanges {
                target: arrowButton
                visible: true
            }
        },

        State {
            name: "glowAndSwirl"
            when: glowAndSwirlButton.checked

            PropertyChanges {
                target: topControlPanel
                visible: true
                titleText: "Glow"
            }

            PropertyChanges {
                target: firstTopSlider
                visible: true
                sliderTitle: "Bloom"
                sliderFrom: 0
                sliderTo: 2
                sliderValue: root.bloomValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "glowAndSwirl")
                        root.bloomValue = firstTopSlider.sliderValue
                }
            }

            PropertyChanges {
                target: secondTopSlider
                visible: true
                sliderTitle: "Blur Amount"
                sliderFrom: 0
                sliderTo: 1
                sliderValue: root.blurValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "glowAndSwirl")
                        root.blurValue = secondTopSlider.sliderValue
                }
            }

            PropertyChanges {
                target: thirdTopSlider
                visible: true
                sliderTitle: "Max Brightness"
                sliderFrom: 0
                sliderTo: 1
                sliderValue: root.brightnessValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "glowAndSwirl")
                        root.brightnessValue = thirdTopSlider.sliderValue
                }
            }

            PropertyChanges {
                target: bottomControlPanel
                visible: true
                titleText: "Swirl"
            }

            PropertyChanges {
                target: firstBottomSlider
                visible: true
                sliderTitle: "Wavelength"
                sliderFrom: 0
                sliderTo: 10
                sliderValue: root.wavelengthValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "glowAndSwirl")
                        root.wavelengthValue = firstBottomSlider.sliderValue
                }
            }

            PropertyChanges {
                target: secondBottomSlider
                visible: true
                sliderTitle: "Amplitude"
                sliderFrom: 0
                sliderTo: 0.5
                sliderValue: root.amplitudeValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "glowAndSwirl")
                        root.amplitudeValue = secondBottomSlider.sliderValue
                }
            }

            PropertyChanges {
                target: thirdBottomSlider
                visible: true
                sliderTitle: "Phase"
                sliderFrom: 0
                sliderTo: 1
                sliderValue: root.phaseValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "glowAndSwirl")
                        root.phaseValue = thirdBottomSlider.sliderValue
                }
            }

            PropertyChanges {
                target: arrowButton
                visible: true
            }
        },

        State {
            name: "noise"
            when: noiseButton.checked

            AnchorChanges {
                target: arrowButton
                anchors.left: undefined
                anchors.right: parent.right
            }

            AnchorChanges {
                target: spacer
                anchors.left: undefined
                anchors.right: arrowButton.left
            }

            PropertyChanges {
                target: topControlPanel
                visible: true
                titleText: "Noise"
            }

            PropertyChanges {
                target: firstTopSlider
                visible: true
                sliderTitle: "Amount"
                sliderFrom: 0
                sliderTo: 1
                sliderValue: root.noiseValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "noise")
                        root.noiseValue = firstTopSlider.sliderValue
                }
            }

            PropertyChanges {
                target: secondTopSlider
                visible: false
            }

            PropertyChanges {
                target: thirdTopSlider
                visible: false
            }

            PropertyChanges {
                target: arrowButton
                visible: true
            }
        },

        State {
            name: "rainAndThunder"
            when: rainAndThunderButton.checked

            AnchorChanges {
                target: arrowButton
                anchors.left: undefined
                anchors.right: parent.right
            }

            AnchorChanges {
                target: spacer
                anchors.left: undefined
                anchors.right: arrowButton.left
            }

            PropertyChanges {
                target: topControlPanel
                visible: true
                titleText: "Rain"
            }

            PropertyChanges {
                target: firstTopSlider
                visible: true
                sliderTitle: "Layers"
                sliderFrom: 0
                sliderTo: 10
                sliderValue: root.rainLayerValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "rainAndThunder")
                        root.rainLayerValue = firstTopSlider.sliderValue
                }
            }

            PropertyChanges {
                target: secondTopSlider
                visible: true
                sliderTitle: "Wind"
                sliderFrom: -1
                sliderTo: 1
                sliderValue: root.windValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "rainAndThunder")
                        root.windValue = secondTopSlider.sliderValue
                }
            }

            PropertyChanges {
                target: thirdTopSlider
                visible: false
            }

            PropertyChanges {
                target: bottomControlPanel
                visible: true
                titleText: "Thunder"
            }

            PropertyChanges {
                target: firstBottomSlider
                visible: true
                sliderTitle: "Strike Occurrence"
                sliderFrom: 0
                sliderTo: 1
                sliderValue: root.strikeValue
                onSliderValueChanged: {
                    if (controlOverlay.state === "rainAndThunder")
                        root.strikeValue = firstBottomSlider.sliderValue
                }
            }

            PropertyChanges {
                target: secondBottomSlider
                visible: false
            }

            PropertyChanges {
                target: thirdBottomSlider
                visible: false
            }

            PropertyChanges {
                target: arrowButton
                visible: true
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0}D{i:65;transitionDuration:2000}
}
##^##*/
