import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Effects
import QtQuick3D.Particles3D
//import QtQuick3D.ParticleEffects
import EosADAS
import Generated.QtQuick3D.Road_Bend 1.0
import Generated.QtQuick3D.Generic_SUV_2019_uv 1.0
import Generated.QtQuick3D.Generic_SUV_2019_game_low 1.0
import Generated.QtQuick3D.LaneAssist 1.0
import Generated.QtQuick3D.DangerArrow 1.0
import QtQuick.Timeline
import backend.Data 1.0 as Data

View3D {
    id: view3D

    width: 1267
    height: 634

    // Current weather mode
    // 0 = clear, 1 = mist, 2 = rain, 3 = snow
    property int currentWeather: 0
    readonly property int effectiveCurrentWeather: view3D.state == "ToSide" ? 0 : currentWeather

    // Turn signal state
    property bool signaling: laneAssist.lane < 0
    property bool turning: "Turning" === state

    property alias lanelines: lanelines
    property alias timelineAnimationAdas: timelineAnimationAdas

    environment: sceneEnvironment

    // Lighting modes
    Keys.onDigit1Pressed: dynamicLighting.state = ""
    Keys.onDigit2Pressed: dynamicLighting.state = "Day"
    Keys.onDigit3Pressed: dynamicLighting.state = "Dusk"

    // Weather modes
    Keys.onDigit4Pressed: currentWeather = 0
    Keys.onDigit5Pressed: currentWeather = 1
    Keys.onDigit6Pressed: currentWeather = 2
    Keys.onDigit7Pressed: currentWeather = 3

    // Drive states
    Keys.onDigit0Pressed: turning ? state = state : state = "Startup"
    Keys.onDigit8Pressed: turning ? state = state : (state = (state
                                                              == "ToSide") ? "FromSide" : "Adas")
    Keys.onDigit9Pressed: turning ? state = state : state = "ToSide"
    Keys.onSpacePressed: turning ? state = state : state = "Turning"

    // Realtime reflections
    Keys.onTabPressed: reflectionProbe.refreshMode = reflectionProbe.refreshMode
                       == ReflectionProbe.FirstFrame ? ReflectionProbe.EveryFrame : ReflectionProbe.FirstFrame

    Connections {
        target: Data.Values

        onVehicleModelStateChanged: {
            switch (state) {
            case "viewAdas":
                if (!view3D.turning) {
                    view3D.state = "Adas"
                }
                break
            case "viewSide":
                if (!view3D.turning) {
                    view3D.state = "ToSide"
                }
                break
            case "viewAnimation":
                if (!view3D.turning) {
                    view3D.state = "Startup"
                }
                break
            case "viewTurning":
                if (!view3D.turning) {
                    view3D.state = "Turning"
                }
                break
            case "lightingDay":
                dynamicLighting.state = "Day"
                break
            case "lightingDusk":
                dynamicLighting.state = "Dusk"
                break
            case "lightingDawn":
                dynamicLighting.state = ""
                break
            case "weatherClear":
                currentWeather = 0
                break
            case "weatherMist":
                currentWeather = 1
                break
            case "weatherSnow":
                currentWeather = 3
                break
            case "weatherRain":
                currentWeather = 2
                break
            }
        }
    }

    SceneEnvironment {
        id: sceneEnvironment
        backgroundMode: SceneEnvironment.Color
        lightProbe: studio_small_07_2k
        //aoDither: false
        //aoBias: 0
        //aoSoftness: 50
        //aoDistance: 50
        //aoSampleRate: 4
        //aoStrength: 100
        effects: [fxaa, vignette]
        probeOrientation.y: 10
        probeOrientation.x: dynamicLighting.probeRotation
        probeHorizon: 0.5
        probeExposure: 0.5
        //temporalAAEnabled: true
        antialiasingMode: SceneEnvironment.SSAA
        antialiasingQuality: SceneEnvironment.VeryHigh

        Fxaa {
            id: fxaa
        }

        Vignette {
            id: vignette
            vignetteRadius: 1.5
            vignetteStrength: 15
            vignetteColor: Qt.vector3d(0, 0, 0)
        }

        Texture {
            id: studio_small_07_2k
            source: "images/studio_small_07_2k.hdr"
            mappingMode: Texture.LightProbe
        }
    }

    Node {
        id: scene

        PointLight {
            id: light
            x: 31.97
            y: 50.059
            position: dynamicLighting.lightPosition
            color: dynamicLighting.color
            z: -47.5094
            brightness: dynamicLighting.brightness
            ambientColor: dynamicLighting.ambientColor
        }

        PerspectiveCamera {
            id: camera
            x: 200
            y: 50
            fieldOfView: 45
            eulerRotation.z: 0
            eulerRotation.y: 90
            eulerRotation.x: -22.5
            z: 0
        }

        LaneAssist {
            id: laneAssist
            x: -60
            y: 0.5
            opacity: 0
            visible: true
            lane: 0
            end: -15
            scale.z: 10
            scale.y: 10
            scale.x: 10
            z: 0
        }

        Road_Bend {
            id: laneMarkerRight
            x: 155.744
            scale.z: 11.6
            z: 4.14491
            scale.x: 11.6
            eulerRotation.y: 180
            bendPhase: road.turningPhase
            mat: lanelineMaterial
            bias: -10
        }

        Road_Bend {
            id: laneMarkerLeft
            x: 155.729
            mat: lanelineMaterial
            scale.z: 11.6
            scale.x: 11.6
            z: 44.09698
            eulerRotation.y: 180
            bendPhase: road.turningPhase
            bias: -10
        }

        Generic_SUV_2019_game_low {
            id: npcCar
            x: 200
            y: 0
            z: -38.76495

            SpotLight {
                id: warningCarLight
                x: 0
                y: 30
                color: "#ff0000"
                quadraticFade: 4.4
                constantFade: 0.6
                coneAngle: 90
                innerConeAngle: 0
                brightness: 1
                ambientColor: "#000000"
                scope: road
                z: 0
                eulerRotation.x: -90
                eulerRotation.y: 0
            }
        }

        Generic_SUV_2019_uv {
            id: generic_SUV_2019_uv
            x: 80
            scale.z: 0.1
            scale.y: 0.1
            scale.x: 0.1
            eulerRotation.x: -90
            eulerRotation.y: -90
        }

        ReflectionProbe {
            id: reflectionProbe
            x: 110
            y: 16
            visible: true
            parallaxCorrection: true
            //debugView: true
            timeSlicing: ReflectionProbe.AllFacesAtOnce
            boxSize.z: 25
            boxSize.y: 25
            boxSize.x: 100
            quality: ReflectionProbe.Low
            z: 0
            //nodes: [ generic_SUV_2019_uv, generic_SUV_2019_uv1 ]
            //excludeNodes: true
        }

        Node {
            id: weatherEffectsNode
            x: generic_SUV_2019_uv.x
            eulerRotation.y: generic_SUV_2019_uv.eulerRotation.y + 90

            MistEffect {
                id: mistEffect
                show: effectiveCurrentWeather == 1
                x: -generic_SUV_2019_uv.x
            }
            RainEffect {
                id: rainEffect
                show: effectiveCurrentWeather == 2
                x: -generic_SUV_2019_uv.x
            }
            SnowEffect {
                id: snowEffect
                show: effectiveCurrentWeather == 3
                x: -generic_SUV_2019_uv.x
            }
        }

        Model {
            id: sideViewFloor
            source: "#Rectangle"
            z: 0.0001
            materials: floorMaterial
            visible: false
            opacity: 0
            x: 359.419
            y: -0
            scale.z: 2
            scale.y: 2
            scale.x: 2
            eulerRotation.x: -90
            eulerRotation.y: 90
            property real scaletexture: 24
        }

        DangerArrow {
            id: dangerArrow
            x: 100
            y: 1.9
            z: 0
            opacity: 0
            eulerRotation.y: -90
            scale.z: 3.5
            scale.y: 1
            scale.x: 3.5

            Model {
                id: arrowTrail
                source: "#Rectangle"
                x: -0.915
                y: -1.199
                pivot.y: 17
                pivot.x: 0
                scale.z: 0.08
                scale.y: 0.11
                scale.x: 0.06
                eulerRotation.x: -90
                eulerRotation.y: 90
                z: -5.37123
                materials: trailMaterial
            }

            Model {
                id: arrowTrail2
                source: "#Rectangle"
                x: 0.146
                y: -1
                opacity: 0.6
                materials: trailMaterial
                pivot.x: -24
                z: -5.86
                scale.z: 0.1
                scale.y: 0.05
                scale.x: 0.05
                eulerRotation.y: 33
                eulerRotation.x: -90
            }

            SpotLight {
                id: warningTrailLight
                x: 2.499
                y: 16.157
                visible: false
                color: "#ff0000"
                innerConeAngle: 23
                quadraticFade: 3.7
                eulerRotation.z: 19.08
                constantFade: 0.9
                coneAngle: 73
                linearFade: 8.6
                brightness: 1
                eulerRotation.x: -19.94708
                eulerRotation.y: 160.92
                z: -8.01074
            }
        }

        Node {
            id: road
            scale.z: 11.6
            scale.y: 11.6
            scale.x: 11.6
            eulerRotation.y: 180
            opacity: 1
            property int turningPhase: 5034

            Road_Bend {
                id: road_Mid
                x: -13.3
                y: 0
                z: -2.105
                bendPhase: road.turningPhase
                bias: 50
            }

            Road_Bend {
                id: road_Left
                x: -13.3
                y: 0
                z: -5.55
                bendPhase: road.turningPhase
            }

            Road_Bend {
                id: road_Right
                x: -13.3
                y: 0
                z: 1.35
                bendPhase: road.turningPhase
            }
        }

        Generic_SUV_2019_uv {
            id: generic_SUV_2019_uv1
            x: 80
            scale.y: 0.1
            scale.x: 0.1
            scale.z: 0.1
            eulerRotation.y: -90
            eulerRotation.x: -90
        }
    }

    DynamicLighting {
        id: dynamicLighting
    }

    Timeline {
        id: timelineStartup
        animations: [
            TimelineAnimation {
                id: timelineAnimationStartup
                onFinished: view3D.state = "Adas"
                duration: 10000
                loops: 1
                running: true
                to: 1000
                from: 0
            }
        ]
        enabled: true
        startFrame: 0
        endFrame: 1000

        KeyframeGroup {
            target: camera
            property: "x"
            Keyframe {
                easing.bezierCurve: [0.445, 0.05, 0.55, 0.95, 1, 1]
                value: 130
                frame: 0
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 127
                frame: 250
            }

            Keyframe {
                easing.bezierCurve: [0.55, 0.055, 0.675, 0.19, 1, 1]
                value: 200
                frame: 1000
            }
        }

        KeyframeGroup {
            target: camera
            property: "y"
            Keyframe {
                easing.bezierCurve: [0.445, 0.05, 0.55, 0.95, 1, 1]
                value: 20
                frame: 0
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 20
                frame: 250
            }

            Keyframe {
                easing.bezierCurve: [0.55, 0.055, 0.675, 0.19, 1, 1]
                value: 50
                frame: 1000
            }
        }

        KeyframeGroup {
            target: camera
            property: "eulerRotation.x"
            Keyframe {
                easing.bezierCurve: [0.445, 0.05, 0.55, 0.95, 1, 1]
                value: -20
                frame: 0
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: -21
                frame: 250
            }

            Keyframe {
                easing.bezierCurve: [0.55, 0.055, 0.675, 0.19, 1, 1]
                value: -22.5
                frame: 1000
            }
        }

        KeyframeGroup {
            target: camera
            property: "z"
            Keyframe {
                easing.bezierCurve: [0.445, 0.05, 0.55, 0.95, 1, 1]
                value: -5
                frame: 0
            }

            Keyframe {
                easing.bezierCurve: [0.645, 0.045, 0.355, 1, 1, 1]
                value: -5
                frame: 500
            }

            Keyframe {
                easing.bezierCurve: [0.55, 0.055, 0.675, 0.19, 1, 1]
                value: 0
                frame: 1000
            }
        }

        KeyframeGroup {
            target: light
            property: "brightness"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 250
                value: dynamicLighting.brightness
            }
        }

        KeyframeGroup {
            target: light
            property: "ambientColor"
            Keyframe {
                frame: 0
                value: "black"
            }

            Keyframe {
                frame: 250
                value: dynamicLighting.ambientColor
            }
        }

        // Comment this out if the reflection probe is used and the bug is still there
        KeyframeGroup {
            target: sceneEnvironment
            property: "probeExposure"

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 250
                value: 0.5
            }
        }

        KeyframeGroup {
            target: lanelineMaterial
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 250
            }
        }

        KeyframeGroup {
            target: laneAssist
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 750
            }

            Keyframe {
                value: 0.85
                frame: 1000
            }
        }

        KeyframeGroup {
            target: road_Left
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 500
            }
        }

        KeyframeGroup {
            target: road_Right
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 500
            }
        }
    }

    Timeline {
        id: timelineAdas
        animations: [
            TimelineAnimation {
                id: timelineAnimationAdas
                pingPong: false
                duration: 10000
                loops: 1
                running: false
                to: 2000
                from: 0
            }
        ]
        enabled: false
        startFrame: 0
        endFrame: 2000

        KeyframeGroup {
            target: npcCar
            property: "x"
            Keyframe {
                value: 200
                frame: 1000
            }

            Keyframe {
                value: -400
                frame: 2000
            }
        }

        KeyframeGroup {
            target: npcCar
            property: "opacity"
            Keyframe {
                value: 1
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 1921
            }

            Keyframe {
                value: 0
                frame: 2000
            }
        }

        KeyframeGroup {
            target: warningCarLight
            property: "brightness"
            Keyframe {
                value: 1
                frame: 1000
            }

            Keyframe {
                value: 10
                frame: 1150
            }

            Keyframe {
                value: 50
                frame: 1200
            }

            Keyframe {
                value: 10
                frame: 1250
            }

            Keyframe {
                value: 50
                frame: 1300
            }

            Keyframe {
                value: 10
                frame: 1350
            }

            Keyframe {
                value: 1
                frame: 1500
            }

            Keyframe {
                value: 0
                frame: 2000
            }
        }

        KeyframeGroup {
            target: dangerArrow
            property: "arrowCount"
            Keyframe {
                frame: 0
                value: 4
            }

            Keyframe {
                frame: 1050
                value: 4
            }

            Keyframe {
                frame: 1050
                value: 3
            }

            Keyframe {
                frame: 1100
                value: 3
            }

            Keyframe {
                frame: 1100
                value: 1
            }
        }

        KeyframeGroup {
            target: dangerArrow
            property: "opacity"
            Keyframe {
                frame: 850
                value: 0
            }

            Keyframe {
                frame: 950
                value: 1
            }
        }

        KeyframeGroup {
            target: dangerArrow
            property: "eulerRotation.y"
            Keyframe {
                frame: 0
                value: -90
            }

            Keyframe {
                frame: 950
                value: -90
            }

            Keyframe {
                frame: 1200
                value: 0
            }

            Keyframe {
                frame: 1450
                value: 90
            }
        }

        KeyframeGroup {
            target: arrowTrail
            property: "scale.x"
            Keyframe {
                value: 0.06
                frame: 950
            }

            Keyframe {
                value: 0.03
                frame: 1068
            }

            Keyframe {
                value: 0
                frame: 1405
            }
        }

        KeyframeGroup {
            target: arrowTrail
            property: "scale.y"
            Keyframe {
                value: 0.06
                frame: 950
            }

            Keyframe {
                value: 0.15
                frame: 1068
            }

            Keyframe {
                value: 0.1
                frame: 1071
            }

            Keyframe {
                value: 0.05
                frame: 1191
            }

            Keyframe {
                value: 0
                frame: 1405
            }
        }

        KeyframeGroup {
            target: arrowTrail2
            property: "scale.x"
            Keyframe {
                value: 0.05
                frame: 950
            }

            Keyframe {
                value: 0.1
                frame: 1068
            }

            Keyframe {
                value: 0.02
                frame: 1191
            }

            Keyframe {
                value: 0
                frame: 1400
            }
        }

        KeyframeGroup {
            target: arrowTrail2
            property: "scale.y"
            Keyframe {
                value: 0.05
                frame: 950
            }

            Keyframe {
                value: 0
                frame: 1400
            }
        }

        KeyframeGroup {
            target: warningTrailLight
            property: "brightness"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 852
            }

            Keyframe {
                value: 1
                frame: 852
            }

            Keyframe {
                value: 49.78
                frame: 947
            }

            Keyframe {
                value: 20
                frame: 1181
            }

            Keyframe {
                value: 0
                frame: 1288
            }
        }

        KeyframeGroup {
            target: laneAssist
            property: "lane"
            Keyframe {
                value: 0
                frame: 600
            }

            Keyframe {
                value: -4
                frame: 800
            }

            Keyframe {
                value: -4
                frame: 1200
            }

            Keyframe {
                value: 0
                frame: 1400
            }
        }
    }

    Timeline {
        id: timelineSide
        animations: [
            TimelineAnimation {
                id: timelineAnimationSide
                duration: 2500
                loops: 1
                running: false
                to: 350
                from: 0
            }
        ]
        enabled: false
        startFrame: 0
        endFrame: 350

        KeyframeGroup {
            target: laneAssist
            property: "opacity"
            Keyframe {
                value: 0.85
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 100
            }
        }

        KeyframeGroup {
            target: lanelineMaterial
            property: "opacity"
            Keyframe {
                value: 1
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 100
            }
        }

        KeyframeGroup {
            target: road
            property: "opacity"
            Keyframe {
                value: 1
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 100
            }
        }

        KeyframeGroup {
            target: camera
            property: "x"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 160
                frame: 250
            }
        }

        KeyframeGroup {
            target: camera
            property: "y"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 18
                frame: 250
            }
        }

        KeyframeGroup {
            target: camera
            property: "eulerRotation.x"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: -10
                frame: 250
            }
        }

        KeyframeGroup {
            target: camera
            property: "fieldOfView"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 30
                frame: 250
            }
        }

        KeyframeGroup {
            target: generic_SUV_2019_uv
            property: "eulerRotation.y"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 50
                frame: 250
            }
        }

        // Uncomment this if reflection probe is used and the bug still exists


        /*
        KeyframeGroup {
            target: sceneEnvironment
            property: "probeExposure"

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 250
                value: 0
            }

            Keyframe {
                frame: 350
                value: 0.5
            }
        }
        */
        KeyframeGroup {
            target: sideViewFloor
            property: "opacity"
            Keyframe {
                value: 0
                frame: 67
            }

            Keyframe {
                value: 1
                frame: 119
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: generic_SUV_2019_uv1
            property: "visible"
            Keyframe {
                value: false
                frame: 110
            }

            Keyframe {
                value: true
                frame: 130
            }
        }
    }

    Timeline {
        id: timelineFromSide
        animations: [
            TimelineAnimation {
                id: timelineAnimationFromSide
                onFinished: view3D.state = "Adas"
                running: false
                duration: 2500
                loops: 1
                to: 250
                from: 0
            }
        ]
        endFrame: 250
        enabled: false
        startFrame: 0

        KeyframeGroup {
            target: laneAssist
            property: "opacity"
            Keyframe {
                value: 0
                frame: 150
            }

            Keyframe {
                value: 0.85
                frame: 250
            }
        }

        KeyframeGroup {
            target: lanelineMaterial
            property: "opacity"
            Keyframe {
                value: 0
                frame: 150
            }

            Keyframe {
                value: 1
                frame: 250
            }
        }

        KeyframeGroup {
            target: road
            property: "opacity"
            Keyframe {
                value: 0
                frame: 78
            }

            Keyframe {
                value: 1
                frame: 172
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: camera
            property: "x"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 200
                frame: 250
            }

            Keyframe {
                value: 160
                frame: 0
            }
        }

        KeyframeGroup {
            target: camera
            property: "y"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 50
                frame: 250
            }

            Keyframe {
                value: 18
                frame: 0
            }
        }

        KeyframeGroup {
            target: camera
            property: "eulerRotation.x"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: -22.5
                frame: 250
            }

            Keyframe {
                value: -10
                frame: 0
            }
        }

        KeyframeGroup {
            target: camera
            property: "fieldOfView"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 45
                frame: 250
            }

            Keyframe {
                value: 30
                frame: 0
            }
        }

        KeyframeGroup {
            target: generic_SUV_2019_uv
            property: "eulerRotation.y"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: -90
                frame: 250
            }
        }

        // Uncomment this if reflection probe is used and the bug still exists


        /*
        KeyframeGroup {
            target: sceneEnvironment
            property: "probeExposure"

            Keyframe {
                frame: 0
                value: 0.5
            }

            Keyframe {
                frame: 50
                value: 0
            }
        }
        */
        KeyframeGroup {
            target: sideViewFloor
            property: "opacity"
            Keyframe {
                value: 1
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 77
            }
        }
    }

    Timeline {
        id: timelineTurning
        animations: [
            TimelineAnimation {
                id: timelineAnimationTurning
                onFinished: view3D.state = "Adas"
                running: false
                duration: 20000
                loops: 1
                to: 1100
                from: 0
            }
        ]
        endFrame: 1100
        enabled: false
        startFrame: 0

        KeyframeGroup {
            target: camera
            property: "fieldOfView"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 45
                frame: 0
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 30
                frame: 100
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 30
                frame: 1000
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 45
                frame: 1100
            }
        }

        KeyframeGroup {
            target: camera
            property: "eulerRotation.x"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: -22.5
                frame: 0
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: -13
                frame: 100
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: -13
                frame: 1000
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: -22.5
                frame: 1100
            }
        }

        KeyframeGroup {
            target: camera
            property: "y"
            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 50
                frame: 0
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 30
                frame: 100
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 30
                frame: 1000
            }

            Keyframe {
                easing.bezierCurve: [0.455, 0.03, 0.515, 0.955, 1, 1]
                value: 50
                frame: 1100
            }
        }

        KeyframeGroup {
            target: laneAssist
            property: "opacity"
            Keyframe {
                frame: 100
                value: 0
            }

            Keyframe {
                frame: 1000
                value: 0
            }

            Keyframe {
                frame: 1100
                value: 0.85
            }
        }

        KeyframeGroup {
            target: road
            property: "turningPhase"
            Keyframe {
                frame: 0
                value: 5034
            }

            Keyframe {
                frame: 100
                value: 5034
            }

            Keyframe {
                frame: 400
                value: 34
            }

            Keyframe {
                frame: 700
                value: 10034
            }

            Keyframe {
                frame: 1000
                value: 5034
            }
        }
    }

    Item {
        id: __materialLibrary__
        DefaultMaterial {
            id: lanelineMaterial
            diffuseColor: "#ffffff"
            diffuseMap: lanelines
            Texture {
                id: lanelines
                source: "images/lanelines.png"
                tilingModeHorizontal: Texture.Repeat
                tilingModeVertical: Texture.Repeat
            }
            objectName: "lanelineMaterial"
            depthDrawMode: Material.NeverDepthDraw
        }

        PrincipledMaterial {
            id: floorMaterial
            roughness: 1
            metalness: 1
            baseColor: "#383838"
            normalMap: Texture {
                source: "images/Road_DiagonalLightBrushing_normal.png"
                mipFilter: Texture.Linear
                scaleU: sideViewFloor.scaletexture
                generateMipmaps: true
                scaleV: sideViewFloor.scaletexture
            }
            roughnessChannel: Material.G
            baseColorMap: Texture {
                source: "images/Road_DiagonalLightBrushing_color.png"
                mipFilter: Texture.Linear
                scaleU: sideViewFloor.scaletexture
                generateMipmaps: true
                scaleV: sideViewFloor.scaletexture
            }
            alphaMode: PrincipledMaterial.Opaque
            roughnessMap: Texture {
                source: "images/Road_DiagonalLightBrushing_occlusionRoughnessMetallic.png"
                mipFilter: Texture.Linear
                scaleU: sideViewFloor.scaletexture
                generateMipmaps: true
                scaleV: sideViewFloor.scaletexture
            }
            opacityChannel: Material.A
            metalnessChannel: Material.B
            objectName: "floorMaterial"
            metalnessMap: Texture {
                source: "images/Road_DiagonalLightBrushing_occlusionRoughnessMetallic.png"
                mipFilter: Texture.Linear
                scaleU: sideViewFloor.scaletexture
                generateMipmaps: true
                scaleV: sideViewFloor.scaletexture
            }
            opacityMap: Texture {
                id: spheregradient5
                source: "images/sphere-gradient-5.png"
            }
        }

        DefaultMaterial {
            id: trailMaterial
            opacity: 0.5
            diffuseColor: "#ffffff"
            diffuseMap: warningarrow_glow
            Texture {
                id: warningarrow_glow
                source: "images/warningarrow_glow.png"
            }
            objectName: "trailMaterial"
            lighting: DefaultMaterial.NoLighting
            emissiveMap: warningarrow_glow
        }
    }

    states: [
        State {
            name: "Startup"

            PropertyChanges {
                target: reflectionProbe
                boxSize.z: 25
            }

            PropertyChanges {
                target: timelineStartup
                enabled: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationStartup
                running: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAdas
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationAdas
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineSide
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationSide
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: lanelineMaterial
                opacity: 0
                restoreEntryValues: false
            }

            PropertyChanges {
                target: laneAssist
                opacity: 0
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationFromSide
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: road
                opacity: 1
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineFromSide
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineTurning
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationTurning
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: warningTrailLight
                brightness: 0
                restoreEntryValues: false
            }

            PropertyChanges {
                target: camera
                fieldOfView: 45
                restoreEntryValues: false
            }

            PropertyChanges {
                target: sideViewFloor
                x: 359.037
                y: -0
                z: 0.0001
            }

            PropertyChanges {
                target: sceneEnvironment
                probeExposure: 0
            }

            PropertyChanges {
                target: light
                ambientColor: dynamicLighting.ambientColor
                brightness: dynamicLighting.brightness
                color: dynamicLighting.color
                position: dynamicLighting.lightPosition
            }
        },
        State {
            name: "Adas"

            PropertyChanges {
                target: reflectionProbe
                boxSize.z: 25
            }

            PropertyChanges {
                target: timelineStartup
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationStartup
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAdas
                enabled: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationAdas
                running: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineSide
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationSide
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: laneAssist
                opacity: 0.85
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationFromSide
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineFromSide
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: camera
                x: 200
                y: 50
                z: 0
                eulerRotation.x: -22.5
                restoreEntryValues: false
            }

            PropertyChanges {
                target: generic_SUV_2019_uv
                eulerRotation.y: -90
                restoreEntryValues: false
            }

            PropertyChanges {
                target: sideViewFloor
                x: 351.646
                y: -0
                visible: false
                z: 0.0001
                restoreEntryValues: false
            }

            PropertyChanges {
                target: laneAssist
                opacity: 0.75
                restoreEntryValues: false
            }

            PropertyChanges {
                target: lanelineMaterial
                opacity: 1
                depthDrawMode: Material.NeverDepthDraw
                restoreEntryValues: false
            }

            PropertyChanges {
                target: road
                opacity: 1
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineFromSide
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineTurning
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationTurning
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: camera
                fieldOfView: 45
                restoreEntryValues: false
            }

            PropertyChanges {
                target: generic_SUV_2019_uv1
                opacity: 0
                visible: false
                eulerRotation.x: 90
                eulerRotation.y: generic_SUV_2019_uv.eulerRotation.y
                eulerRotation.z: 180
            }

            PropertyChanges {
                target: npcCar
                scale.z: 1
            }

            PropertyChanges {
                target: mistEffect
                show: effectiveCurrentWeather == 1
            }

            PropertyChanges {
                target: warningCarLight
                x: 0.001
                y: 30
                quadraticFade: 4.4
                coneAngle: 90
                eulerRotation.z: 0
                eulerRotation.y: 0
                z: 0
                eulerRotation.x: -90
                innerConeAngle: 0
                constantFade: 0.6
                ambientColor: "#000000"
                brightness: 20
            }

            PropertyChanges {
                target: warningTrailLight
                visible: true
                brightness: 1
            }

            PropertyChanges {
                target: light
                ambientColor: dynamicLighting.ambientColor
                brightness: dynamicLighting.brightness
                color: dynamicLighting.color
                position: dynamicLighting.lightPosition
            }

            // Uncomment this if reflection probe is used and the bug still exists


            /*
            PropertyChanges {
                target: sceneEnvironment
                probeExposure: 0
            }
            */
        },
        State {
            name: "ToSide"

            PropertyChanges {
                target: reflectionProbe
                boxSize.z: 60
            }

            PropertyChanges {
                target: timelineStartup
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationStartup
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAdas
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationAdas
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineSide
                enabled: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationSide
                running: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: sideViewFloor
                x: 40
                y: -0
                visible: true
                z: 0.00001
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationFromSide
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineFromSide
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: camera
                x: 200
                y: 50
                eulerRotation.x: -22.5
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineTurning
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationTurning
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: warningTrailLight
                brightness: 0
                restoreEntryValues: false
            }

            PropertyChanges {
                target: generic_SUV_2019_uv1
                opacity: 1
                visible: true
                eulerRotation.y: generic_SUV_2019_uv.eulerRotation.y
                eulerRotation.z: 180
                eulerRotation.x: 90
            }

            PropertyChanges {
                target: floorMaterial
                opacity: 0.95
                metalness: 0
                specularAmount: 0.1
                roughness: 0.3
                baseColor: "#141414"
            }

            PropertyChanges {
                target: light
                ambientColor: dynamicLighting.ambientColor
                brightness: dynamicLighting.brightness
                color: dynamicLighting.color
                position: dynamicLighting.lightPosition
            }

            // Uncomment this if reflection probe is used and the bug still exists


            /*
            PropertyChanges {
                target: sceneEnvironment
                probeExposure: 0
            }
            */
        },
        State {
            name: "FromSide"

            PropertyChanges {
                target: reflectionProbe
                boxSize.z: 60
            }

            PropertyChanges {
                target: timelineStartup
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationStartup
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAdas
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationAdas
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineFromSide
                enabled: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationFromSide
                running: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: sideViewFloor
                x: 40
                visible: true
                restoreEntryValues: false
            }

            PropertyChanges {
                target: camera
                z: 0
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineTurning
                enabled: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: timelineAnimationTurning
                running: false
                restoreEntryValues: false
            }

            PropertyChanges {
                target: warningTrailLight
                brightness: 0
                restoreEntryValues: false
            }

            PropertyChanges {
                target: generic_SUV_2019_uv1
                visible: false
                eulerRotation.x: 90
                eulerRotation.y: generic_SUV_2019_uv.eulerRotation.y
                eulerRotation.z: 180
            }

            PropertyChanges {
                target: floorMaterial
                opacity: 0.95
                roughness: 0.3
                specularAmount: 0.1
                metalness: 0
                baseColor: "#141414"
            }

            PropertyChanges {
                target: light
                ambientColor: dynamicLighting.ambientColor
                brightness: dynamicLighting.brightness
                color: dynamicLighting.color
                position: dynamicLighting.lightPosition
            }

            // Uncomment this if reflection probe is used and the bug still exists


            /*
            PropertyChanges {
                target: sceneEnvironment
                probeExposure: 0.5
            }
            */
        },
        State {
            name: "Turning"
            PropertyChanges {
                target: timelineStartup
                enabled: false
            }

            PropertyChanges {
                target: timelineAnimationStartup
                running: false
            }

            PropertyChanges {
                target: timelineAdas
                enabled: false
            }

            PropertyChanges {
                target: timelineAnimationAdas
                running: false
            }

            PropertyChanges {
                target: timelineSide
                enabled: false
            }

            PropertyChanges {
                target: timelineAnimationSide
                running: false
            }

            PropertyChanges {
                target: timelineAnimationFromSide
                running: false
            }

            PropertyChanges {
                target: timelineFromSide
                enabled: false
            }

            PropertyChanges {
                target: camera
                x: 200
                y: 50
                z: 0
                eulerRotation.x: -22.5
            }

            PropertyChanges {
                target: generic_SUV_2019_uv
                eulerRotation.y: -90
            }

            PropertyChanges {
                target: sideViewFloor
                x: 528.422
                y: -21.298
                opacity: 0
                visible: false
                z: 0.00012
            }

            PropertyChanges {
                target: road
                opacity: 1
            }

            PropertyChanges {
                target: timelineFromSide
                enabled: false
            }

            PropertyChanges {
                target: timelineTurning
                enabled: true
            }

            PropertyChanges {
                target: timelineAnimationTurning
                running: true
            }

            PropertyChanges {
                target: warningTrailLight
                brightness: 0
            }

            PropertyChanges {
                target: camera
                fieldOfView: 45
            }

            PropertyChanges {
                target: generic_SUV_2019_uv1
                opacity: 0
            }

            // Uncomment this if reflection probe is used and the bug still exists


            /*
            PropertyChanges {
                target: sceneEnvironment
                probeExposure: 0
            }
            */
        }
    ]
}

/*##^##
Designer {
    D{i:0;formeditorZoom:4;height:0;matPrevEnvDoc:"SkyBox";matPrevEnvValueDoc:"preview_studio";matPrevModelDoc:"#Sphere";width:0}
D{i:6;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}
}
##^##*/
