import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Shapes 1.0

Rectangle {
    id: indicator
    width: 68
    height: 68
    color: "transparent"

    Rectangle {
        id: buttonBack
        radius: 7
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        gradient: Gradient {
            id: buttonBack_Gradient
            GradientStop {
                id: buttonBack_GradientStop_0
                position: 1
                color: "#ff616161"
            }

            GradientStop {
                id: buttonBack_GradientStop_1
                position: 0
                color: "#ff535353"
            }
            orientation: Gradient.Horizontal
        }
        DesignEffect {
            id: buttonBack_DesignEffect
            visible: true
            effects: [
                DesignInnerShadow {
                    id: buttonBack_DesignInnerShadow_0
                    visible: true
                    color: "#5e000000"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 20
                },
                DesignInnerShadow {
                    id: buttonBack_DesignInnerShadow_1
                    visible: true
                    color: "#40ffffff"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 2
                }
            ]
        }
    }

    ArcItem {
        id: buttonRim
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 3
        anchors.rightMargin: 3
        anchors.topMargin: 3
        anchors.bottomMargin: 3
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        gradient: LinearGradient {
            id: buttonRim_LinearGradient
            y2: 62
            y1: 0
            x2: 31
            x1: 31
            GradientStop {
                id: buttonRim_GradientStop_0
                position: 0
                color: "#ff4e4e4e"
            }

            GradientStop {
                id: buttonRim_GradientStop_1
                position: 1
                color: "#ff909090"
            }
        }
        end: 450.00001
        DesignEffect {
            id: buttonRim_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignInnerShadow {
                    id: buttonRim_DesignInnerShadow_0
                    visible: true
                    color: "#26000000"
                    spread: 0
                    offsetY: 2
                    offsetX: 0
                    blur: 2
                },
                DesignInnerShadow {
                    id: buttonRim_DesignInnerShadow_1
                    visible: true
                    color: "#59ffffff"
                    spread: 0
                    offsetY: 1
                    offsetX: 0
                    blur: 1
                },
                DesignInnerShadow {
                    id: buttonRim_DesignInnerShadow_2
                    visible: true
                    color: "#14ffffff"
                    spread: 0
                    offsetY: -2
                    offsetX: 4
                    blur: 6
                },
                DesignInnerShadow {
                    id: buttonRim_DesignInnerShadow_3
                    visible: true
                    color: "#0affffff"
                    spread: 0
                    offsetY: -6
                    offsetX: -1
                    blur: 5
                },
                DesignDropShadow {
                    id: buttonRim_DesignDropShadow_4
                    visible: true
                    color: "#40000000"
                    spread: 0
                    offsetY: 1
                    offsetX: 0
                    blur: 4
                }
            ]
        }
        begin: 90
        arcWidth: 31
        antialiasing: true
    }

    ArcItem {
        id: indicatorBack
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 25
        anchors.rightMargin: 26
        anchors.topMargin: 25
        anchors.bottomMargin: 26
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#404040"
        end: 450.00001
        DesignEffect {
            id: indicatorBack_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: indicatorBack_DesignDropShadow_0
                    visible: true
                    color: "#61ffffff"
                    spread: 0
                    offsetY: 1
                    offsetX: 0
                    blur: 3
                }
            ]
        }
        begin: 90
        arcWidth: 8.64655
        antialiasing: true
    }

    ArcItem {
        id: indicatorLight
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 25
        anchors.rightMargin: 26
        anchors.topMargin: 25
        anchors.bottomMargin: 26
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#09fed8"
        end: 450.00001
        DesignEffect {
            id: indicatorLight_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: indicatorLight_DesignDropShadow_0
                    visible: true
                    color: "#ff0afed8"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 8
                }
            ]
        }
        begin: 90
        arcWidth: 8.5
        antialiasing: true
    }
}

/*##^##
Designer {
    D{i:0;uuid:"6cf78064-f2f4-534b-8314-119814c35970"}D{i:1;uuid:"55b313b5-9653-5e34-83f6-b9acfcd4d8e5"}
D{i:5;uuid:"55b313b5-9653-5e34-83f6-b9acfcd4d8e5_DesignEffect"}D{i:6;uuid:"55b313b5-9653-5e34-83f6-b9acfcd4d8e5_DesignInnerShadow_0"}
D{i:7;uuid:"55b313b5-9653-5e34-83f6-b9acfcd4d8e5_DesignInnerShadow_1"}D{i:2;uuid:"55b313b5-9653-5e34-83f6-b9acfcd4d8e5_Gradient"}
D{i:3;uuid:"55b313b5-9653-5e34-83f6-b9acfcd4d8e5_GradientStop_0"}D{i:4;uuid:"55b313b5-9653-5e34-83f6-b9acfcd4d8e5_GradientStop_1"}
D{i:8;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646"}D{i:12;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_DesignEffect"}
D{i:13;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_DesignInnerShadow_0"}D{i:14;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_DesignInnerShadow_1"}
D{i:15;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_DesignInnerShadow_2"}D{i:16;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_DesignInnerShadow_3"}
D{i:17;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_DesignDropShadow_4"}D{i:9;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_LinearGradient"}
D{i:10;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_GradientStop_0"}D{i:11;uuid:"fd5a9eed-09ad-59f4-931d-d3e4b94a6646_GradientStop_1"}
D{i:18;uuid:"9c3fb798-9204-5411-8c30-9ed6afeb4f0a"}D{i:19;uuid:"9c3fb798-9204-5411-8c30-9ed6afeb4f0a_DesignEffect"}
D{i:20;uuid:"9c3fb798-9204-5411-8c30-9ed6afeb4f0a_DesignDropShadow_0"}D{i:21;uuid:"adc534aa-7af2-5de1-a1cd-6c9506ee308c"}
D{i:22;uuid:"adc534aa-7af2-5de1-a1cd-6c9506ee308c_DesignEffect"}D{i:23;uuid:"adc534aa-7af2-5de1-a1cd-6c9506ee308c_DesignDropShadow_0"}
}
##^##*/

