#version 440

layout(location = 0) in vec2 texCoord;
layout(location = 1) in vec2 fragCoord;
layout(location = 0) out vec4 fragColor;

layout(std140, binding = 0) uniform buf {
    mat4 qt_Matrix;
    float qt_Opacity;
    float iTime;
    vec3 iResolution;
    vec4 plasmaColors;
    float plasmaScale;
    vec3 levelAdjustGamma;
    vec4 levelAdjustMaximumInput;
    vec4 levelAdjustMaximumOutput;
    vec4 levelAdjustMinimumInput;
    vec4 levelAdjustMinimumOutput;
};


#define PLASMA_ENABLE_SPECULAR 0

#define PI 3.14159265359
#define TAU 6.28318530718
#define SQRT2 1.41421356237

mat2 rotate2d(float a) {
    const float c = cos(a);
    const float s = sin(a);
    return mat2(c, -s, s, c);
}
float linearstep2(float e0, float e1, float x)
{
    return clamp((x - e0) / (e1 - e0), 0.0, 1.0);
}

void main() {
    fragColor = vec4(1.0);
    {
        vec2 position = (fragCoord.xy/iResolution.xy);
        float cX = position.x - 0.5;
        float cY = position.y - 0.5;
        float newX = log(sqrt(cX*cX + cY*cY));
        float newY = atan(cX, cY);
        float numBands = 5.0;
        float numDiagBands = 10.0;
        float numArms = 5.0;
        float numRings = 5.0;
        float spiralAngle = PI/3.0;
        float color = 0.0;
        float t = iTime;
        color += cos(numBands*cX - t*0.5);
        color += cos(2.0*numDiagBands*(cX*sin(spiralAngle) + cY*cos(spiralAngle)) + t);
        color += cos(numRings*newX - t);
        color += cos(2.0*numArms*(newX*sin(spiralAngle) + newY*cos(spiralAngle)) + t);
        fragColor = vec4( vec3( sin( color + t*0.2) * 0.95, sin( color + t*0.2 + 0.45)* 0.45, color*0.1 ), 1.0 );
    }
    {
        float time = iTime * 0.2;
        vec2 a = vec2(iResolution.x / iResolution.y, 1.0);
        vec2 c = texCoord.xy * a * 2.0 + time * 0.45;
        float k = 0.25 + cos(c.y + sin(.148 - time)) + 3.2 * time;
        float w = 0.9 + sin(c.x + cos(.628 + time)) - 1.2 * time;
        float d = length(c);
        float s = (2.0 / (plasmaScale + 0.02)) * cos(d+w) * sin(k+w);
        vec4 plasma = vec4(0.5 + 0.5 * cos(s + plasmaColors.rgb), 1.0);
    #if PLASMA_ENABLE_SPECULAR == 1
        vec4 plasmaSpecularColor = vec4(0.8, 0.6, 0.4, 1.0);
        float plasmaSpecularDamper = 2.0;
        plasma *= (plasmaSpecularColor
            *  pow(max(normalize(vec3(length(dFdx(plasma)), length(dFdy(plasma)), 0.5/iResolution.y)).z, 0.0), plasmaSpecularDamper)
                + 1.0);
    #endif
        fragColor = mix(fragColor, plasma * fragColor.a, plasmaColors.a);
    }
    {
        vec4 adjustedColor = vec4(fragColor.rgb / max(1.0/256.0, fragColor.a), fragColor.a);

        adjustedColor.r = linearstep2(levelAdjustMinimumInput.r, levelAdjustMaximumInput.r, adjustedColor.r);
        adjustedColor.g = linearstep2(levelAdjustMinimumInput.g, levelAdjustMaximumInput.g, adjustedColor.g);
        adjustedColor.b = linearstep2(levelAdjustMinimumInput.b, levelAdjustMaximumInput.b, adjustedColor.b);
        adjustedColor.a = linearstep2(levelAdjustMinimumInput.a, levelAdjustMaximumInput.a, adjustedColor.a);

        vec3 adjustedGamma = vec3(1.0 / max(levelAdjustGamma.x, 0.0001), 1.0 / max(levelAdjustGamma.y, 0.0001), 1.0 / max(levelAdjustGamma.z, 0.0001));
        adjustedColor.rgb = pow(adjustedColor.rgb, adjustedGamma);

        adjustedColor.r = levelAdjustMinimumOutput.r + adjustedColor.r * (levelAdjustMaximumOutput.r - levelAdjustMinimumOutput.r);
        adjustedColor.g = levelAdjustMinimumOutput.g + adjustedColor.g * (levelAdjustMaximumOutput.g - levelAdjustMinimumOutput.g);
        adjustedColor.b = levelAdjustMinimumOutput.b + adjustedColor.b * (levelAdjustMaximumOutput.b - levelAdjustMinimumOutput.b);
        adjustedColor.a = levelAdjustMinimumOutput.a + adjustedColor.a * (levelAdjustMaximumOutput.a - levelAdjustMinimumOutput.a);

        fragColor = vec4(adjustedColor.rgb * adjustedColor.a, adjustedColor.a);
    }
    fragColor = fragColor * qt_Opacity;
}
