/****************************************************************************
**
** Copyright (C) 2016 BogDan Vatra <bog_dan_ro@yahoo.com>
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include "android_global.h"

#include <QAbstractItemModel>
#include <QStringList>

namespace ProjectExplorer { class BuildSystem; }

namespace Android {

class ANDROID_EXPORT AndroidExtraLibraryListModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    AndroidExtraLibraryListModel(ProjectExplorer::BuildSystem *buildSystem, QObject *parent);

    QModelIndex index(int row, int column, const QModelIndex &parent) const override;
    QModelIndex parent(const QModelIndex &child) const override;
    int rowCount(const QModelIndex &parent) const override;
    int columnCount(const QModelIndex &parent) const override;
    QVariant data(const QModelIndex &index, int role) const override;

    void removeEntries(QModelIndexList list);
    void addEntries(const QStringList &list);

signals:
    void enabledChanged(bool);

private:
    void updateModel();

    ProjectExplorer::BuildSystem *m_buildSystem;
    QStringList m_entries;
};

} // namespace Android
