# Deploying and running gtests on Fuchsia.

Fuchsia gtest binaries are deployed and executed via scripts that are
automatically generated by the `test()` GN target. For each test, three wrapper
scripts are created:

1. deploy_<test_target_name>, for deploying the Fuchsia package onto a device
2. run_<test_target_name>, for running the Fuchsia package on the device
3. <test_target_name>, for running the Fuchsia package on the device

The first two executables are found in ${OUTPUT_DIR}/bin whereas the last one
will be found directly in the output directory.

The aforementioned devices can be either emulators started by the scripts
themselves, an existing emulator instance, or a physical device. To build a
gtest binary, check this [documentation](build_instructions.md).

For the sake of this example, we will be using `base_unittests` as the package
we wish to install and/or execute.

## Hermetic emulation

The test script brings up an emulator, runs the tests on it, and
shuts the emulator down when finished.
```bash
$ out/fuchsia/base_unittests
```

The flag `--custom-image` can be used to specify the Fuchsia boot image used
by the emulator. For instance, setting
`--custom-image=workstation.qemu-x64-release` would run the test on a
workstation image.

## Run on an physical device

Note the `-d` flag, which is an alias for `--device`.

```bash
$ out/fuchsia/base_unittests -d
```

## Run on a device paved with Fuchsia built from source

Make sure that the CPU architecture of your Chromium output directory matches
the architecture of the Fuchsia output directory (x64==x64, arm64==arm64, etc.).

```bash
$ out/fuchsia/base_unittests -d
--fuchsia-out-dir=/path/to/fuchsia/outdir
```

If you are frequently deploying to Fuchsia built from source, you might want to
add the following entry to your `args.gn`:

```
default_fuchsia_build_dir_for_installation = "/path/to/fuchsia/outdir"
```

With this flag in place, the `--fuchsia-out-dir` flag will automatically be
used whenever you use the wrapper scripts to run or deploy Fuchsia packages,
making your command lines much shorter:

```bash
$ out/fuchsia/base_unittests -d
```

## Install on a device running Fuchsia built from source

```bash
$ out/fuchsia/bin/deploy_base_unittests
--fuchsia-out-dir=/path/to/fuchsia/outdir
```

You will need to run the package manually on your device. In this case, run the
following from your Fuchsia directory:

```
$ fx shell run fuchsia-pkg://fuchsia.com/base_unittests#meta/base_unittests.cmx
```

## Run on a device the host is connected to remotely via ssh

Note the `--ssh-config` flag, which should point to the config file used to set
up the connection between the host and the remote device.

```bash
$ out/fuchsia/base_unittests -d
--host=localhost --ssh-config=/path/to/ssh/config
```

## Troubleshooting a test

To troubleshoot a specific test, consider a combination of the following
arguments to the test runner script:

* `--gtest_filter="[TestSuite.TestName]"` to only run a specific test, or a
  comma-separated list to run a set of tests. Wildcards can also be used to run
  a set of tests or an entire test suite, e.g. `--gtest_filter="[TestSuite.*]"`.
* `--test-launcher-jobs=1` to only have one batch of tests running at a time.
  This bypasses the test launcher buffering of test log output, making it
  possible to access the log output from successful test runs.
* `--single-process-tests` to run all the tests in the same process. Unlike the
  above option, this will run the tests directly in the test launcher process,
  making it easier to attach a debugger.
* "--logs-dir=[/path/to/log/directory]` to specify the directory to write logs
  to. By default, Chromium logs are written to the "system_log" file in that
  directory.
* `--gtest_repeat=[number] --gtest_break_on_failure` to run a test or test suite
  a certain number of times until it fails. This is useful to investigate flaky
  tests.
