# Accessibility Release Notes

## TL;DR
Any change to accessibility-related files requires specifying an **AX-Relnotes**
field within the commit message, which describes the user-impacts the change
will have. Please see below for some examples of what this could look like:

* 'AX-Relnotes: ChromeVox now supports ...'
* 'AX-Relnotes: Fixed an issue where ... happened because of ...'
* 'AX-Relnotes: n/a', if the change has no user-facing effects.

If your change has user-impact, but is behind a feature flag, please use ‘n/a’.
At the time you remove the feature flag, the AX-Relnotes should mention that the
feature is being launched.

## What Are Release Notes
Every release cycle, the Chrome & Chrome OS Accessibility Team compiles release
notes for users, which detail any user-facing changes that have been made in
the upcoming release. These help our users stay informed about the features
and bugs our team works on, and are utilized by multiple testing teams.

## The Release Notes Process
Release notes are a collaborative effort and usually involve two or three team
members who own the process. The process is as follows:
1. One owner generates a list of commits for the release and pastes the output
in a shared Google Document. For more details on how to generate this list, see
the how-to section below.
2. The commits are split evenly among the owners.
3. Each owner parses their assigned commits, removing irrelevant information,
summarizing important content, contacting developers for clarification, and
categorizing commits with user-impact.
4. Once all commits have been categorized or deleted, one owner forwards the
release notes to the team's PgMs.
5. The PgMs take a final pass over the document, then forward it to relevant
stakeholders.

## How to generate a list of accessibility-related commits
There are a few prerequisites needed before you can generate a list of
accessibility-related commits. Run the following commands:

```
$ gcert # login with your ldap and password.
$ git clone "sso://team/chrome-a11y-core/release-notes"
$ cd release-notes
$ pip3 install -t lib/ -r requirements.txt
```

Now that you've cloned the repository and installed requirements, there is one
final step needed before you can generate commits. The team-milestone-stats
script relies on a json file that isn't committed to the repository for security
reasons. Please follow the below steps to add the json file:

1. Create a new file named 'chrome-accessibility-749c56b5a435.json' in the same
directory as the team-milestone-stats script; leave this open for editing.
2. In a browser, visit valentine.corp.google.com
3. Search for "Chrome release notes json key"
4. Copy the secret to your clipboard using the 'copy to clipboard' button
5. Paste the secret into the new json file. Then save and close the file.

Please reach out to akihiroota@, meredithl@, or chrishall@ if you run into
any problems during this process. Note: Please do not share this file with
anyone outside of Google.

At this point, you can generate a list of commits with a single command:

```
$ python3 team-milestone-stats.py <path-to-chromium-src> <target-milestone> --html --file
```

The above command will run a script to generate a list of accessibility-related
commits for the specified milestons. The '--html' parameter specifies that we
want to generate an HTML file, and the '--file' parameter specifies that we want
to save the generated output into a file, as opposed to standard terminal
output.

To get the contents of the file into a Google Doc:
1. Go to docs.google.com
2. Select the file picker, which should have a tooltip with the title 'Open file
picker'.
3. Navigate to the 'Upload' tab.
4. Upload the html file that was generated by the script.

At this point, you should be all set. Please see bullet #2 in the
'Release Notes Process' section for further instructions.

## Why AX-Relnotes
We require our developers to include an AX-Relnotes field in their commit
messages to make the release notes process more distributed and accurate.
Developers have the most context about how their changes affect users, and
having developers summarize their changes saves time and effort for the
release notes owners.

## Questions?
If you have any questions regarding accessibility release notes that have not
been answered in this document, please contact a member of
ui/accessibility/OWNERS.