// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {decorate} from 'chrome://resources/js/cr/ui.m.js';

import {BrowserBridge} from './browser_bridge.js';
import {makeInfoView} from './info_view.js';

// Injected script from C++ or test environments may reference `browserBridge`
// as a property of the global object.
window.browserBridge = new BrowserBridge();

/**
 * Main entry point. called once the page has loaded.
 */
function onLoad() {
  // Create the views.
  decorate('#info-view', makeInfoView(window.browserBridge));

  // Because of inherent raciness (between the deprecated DevTools API which
  // telemtry uses to drive the relevant tests, and the asynchronous loading of
  // JS modules like this one) it's possible for telemetry tests to inject code
  // *before* `browserBridge` is set and the DOM is populated. This flag is used
  // to synchronize script injection by tests to prevent such races.
  window.gpuPagePopulated = true;
}

document.addEventListener('DOMContentLoaded', onLoad);
