// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/segmentation_platform/public/service_proxy.h"

namespace segmentation_platform {

ServiceProxy::SegmentStatus::SegmentStatus(OptimizationTarget segment_id,
                                           const std::string& segment_metadata,
                                           const std::string& prediction_result,
                                           bool can_execute_segment)
    : segment_id(segment_id),
      segment_metadata(segment_metadata),
      prediction_result(prediction_result),
      can_execute_segment(can_execute_segment) {}

ServiceProxy::ClientInfo::ClientInfo(const std::string& segmentation_key,
                                     OptimizationTarget selected_segment)
    : segmentation_key(segmentation_key), selected_segment(selected_segment) {}

ServiceProxy::ClientInfo::~ClientInfo() = default;

ServiceProxy::ClientInfo::ClientInfo(const ClientInfo& other) = default;

}  // namespace segmentation_platform