// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SEGMENTATION_PLATFORM_INTERNAL_EXECUTION_MOCK_FEATURE_AGGREGATOR_H_
#define COMPONENTS_SEGMENTATION_PLATFORM_INTERNAL_EXECUTION_MOCK_FEATURE_AGGREGATOR_H_

#include <vector>

#include "components/segmentation_platform/internal/execution/feature_aggregator.h"
#include "testing/gmock/include/gmock/gmock.h"

namespace segmentation_platform {

// Mock of feature aggregator class. Used for testing.
class MockFeatureAggregator : public FeatureAggregator {
 public:
  MockFeatureAggregator();
  ~MockFeatureAggregator() override;
  MOCK_METHOD(std::vector<float>,
              Process,
              (proto::SignalType signal_type,
               proto::Aggregation aggregation,
               uint64_t bucket_count,
               const base::Time& end_time,
               const base::TimeDelta& bucket_duration,
               const std::vector<SignalDatabase::Sample>& samples),
              (const override));
  MOCK_METHOD(void,
              FilterEnumSamples,
              (const std::vector<int32_t>& accepted_enum_ids,
               std::vector<SignalDatabase::Sample>& samples),
              (const override));
};

}  // namespace segmentation_platform

#endif  // COMPONENTS_SEGMENTATION_PLATFORM_INTERNAL_EXECUTION_MOCK_FEATURE_AGGREGATOR_H_