/****************************************************************************
**
** Copyright (C) 2014 Klaralvdalens Datakonsult AB (KDAB).
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <assimp/cimport.h>
#include <assimp/scene.h>
#include <assimp/postprocess.h>
#include <assimp/Importer.hpp>
#include <assimp/DefaultLogger.hpp>
#include <assimp/anim.h>
#include <assimp/material.h>
#include <assimp/GltfMaterial.h>
#include <assimp/camera.h>

int main(int , char **)
{
  Assimp::Importer importer;
  Assimp::DefaultLogger::create("AssimpLog.txt", Assimp::Logger::VERBOSE);

  // SET THIS TO REMOVE POINTS AND LINES -> HAVE ONLY TRIANGLES
  importer.SetPropertyInteger(AI_CONFIG_PP_SBP_REMOVE, aiPrimitiveType_LINE|aiPrimitiveType_POINT);

  // Check for new version by setting animation morph channels.
  aiAnimation anim;
  anim.mNumMorphMeshChannels = 0;

  // Check for something that was set in a recent version
  aiMaterial aiM;
  (void)aiM.GetName();

  // Chack that the version includes the new camera member
  aiCamera aiC;
  aiC.mOrthographicWidth = 0.0;

  return 0;
}
