// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'chrome://resources/cr_elements/cr_button/cr_button.m.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.m.js';
import 'chrome://resources/cr_elements/shared_vars_css.m.js';
import './shared_css.js';

import {focusWithoutInk} from 'chrome://resources/js/cr/ui/focus_without_ink.m.js';
import {I18nBehavior} from 'chrome://resources/js/i18n_behavior.m.js';
import {afterNextRender, html, mixinBehaviors, PolymerElement} from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';

import {AutogeneratedThemeColorInfo} from '../manage_profiles_browser_proxy.js';
import {navigateToPreviousRoute} from '../navigation_mixin.js';

export interface AccountSelectionLacrosElement {
  $: {
    backButton: HTMLElement,
  };
}

const AccountSelectionLacrosElementBase =
    mixinBehaviors([I18nBehavior], PolymerElement) as
    {new (): PolymerElement & I18nBehavior};

export class AccountSelectionLacrosElement extends
    AccountSelectionLacrosElementBase {
  static get is() {
    return 'account-selection-lacros';
  }

  static get template() {
    return html`{__html_template__}`;
  }

  static get properties() {
    return {
      profileThemeInfo: Object,
    };
  }

  profileThemeInfo: AutogeneratedThemeColorInfo;

  ready() {
    super.ready();
    this.addEventListener('view-enter-start', this.onViewEnterStart_);
  }

  private onViewEnterStart_() {
    afterNextRender(this, () => focusWithoutInk(this.$.backButton));
  }

  private onBackClick_() {
    navigateToPreviousRoute();
  }

  private getBackButtonAriaLabel_(): string {
    return this.i18n(
        'backButtonAriaLabel', this.i18n('accountSelectionLacrosTitle'));
  }
}

customElements.define(
    AccountSelectionLacrosElement.is, AccountSelectionLacrosElement);
