/*
 * Copyright (C) 2016 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.i18n.addressinput.common;

/**
 * If autocomplete is enabled on the AddressWidget, setting an OnAddressSelectedListener
 * will cause onAddressSelected to be called when the user clicks on an autocomplete
 * suggestion in the dropdown list.
 */
public interface OnAddressSelectedListener {
  void onAddressSelected(AddressData addressData);
}
