// Copyright 2016 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// NOTE: This is a generated file.  Do not edit.

// clang-format off

/** @fileoverview @nocompile */
(function() {
var $jscomp=$jscomp||{};$jscomp.scope={};$jscomp.ASSUME_ES5=false;$jscomp.ASSUME_NO_NATIVE_MAP=false;$jscomp.ASSUME_NO_NATIVE_SET=false;$jscomp.SIMPLE_FROUND_POLYFILL=false;$jscomp.defineProperty=$jscomp.ASSUME_ES5||typeof Object.defineProperties=="function"?Object.defineProperty:function(target,property,descriptor){descriptor=descriptor;if(target==Array.prototype||target==Object.prototype)return;target[property]=descriptor.value};
$jscomp.getGlobal=function(maybeGlobal){return typeof window!="undefined"&&window===maybeGlobal?maybeGlobal:typeof global!="undefined"&&global!=null?global:maybeGlobal};$jscomp.global=$jscomp.getGlobal(this);
$jscomp.polyfill=function(target,polyfill,fromLang,toLang){if(!polyfill)return;var obj=$jscomp.global;var split=target.split(".");for(var i=0;i<split.length-1;i++){var key=split[i];if(!(key in obj))obj[key]={};obj=obj[key]}var property=split[split.length-1];var orig=obj[property];var impl=polyfill(orig);if(impl==orig||impl==null)return;$jscomp.defineProperty(obj,property,{configurable:true,writable:true,value:impl})};
$jscomp.polyfill("Array.prototype.copyWithin",function(orig){if(orig)return orig;var polyfill=function(target,start,opt_end){var len=this.length;target=toInteger(target);start=toInteger(start);var end=opt_end===undefined?len:toInteger(opt_end);var to=target<0?Math.max(len+target,0):Math.min(target,len);var from=start<0?Math.max(len+start,0):Math.min(start,len);var final=end<0?Math.max(len+end,0):Math.min(end,len);if(to<from)while(from<final)if(from in this)this[to++]=this[from++];else{delete this[to++];
from++}else{final=Math.min(final,len+from-to);to+=final-from;while(final>from)if(--final in this)this[--to]=this[final];else delete this[--to]}return this};function toInteger(arg){var n=Number(arg);if(n===Infinity||n===-Infinity)return n;return n|0}return polyfill},"es6","es3");$jscomp.arrayIteratorImpl=function(array){var index=0;return function(){if(index<array.length)return{done:false,value:array[index++]};else return{done:true}}};$jscomp.arrayIterator=function(array){return{next:$jscomp.arrayIteratorImpl(array)}};
$jscomp.SYMBOL_PREFIX="jscomp_symbol_";$jscomp.initSymbol=function(){$jscomp.initSymbol=function(){};if(!$jscomp.global["Symbol"])$jscomp.global["Symbol"]=$jscomp.Symbol};$jscomp.SymbolClass=function(id,opt_description){this.$jscomp$symbol$id_=id;this.description;$jscomp.defineProperty(this,"description",{configurable:true,writable:true,value:opt_description})};$jscomp.SymbolClass.prototype.toString=function(){return this.$jscomp$symbol$id_};
$jscomp.Symbol=function(){var counter=0;function Symbol(opt_description){if(this instanceof Symbol)throw new TypeError("Symbol is not a constructor");return new $jscomp.SymbolClass($jscomp.SYMBOL_PREFIX+(opt_description||"")+"_"+counter++,opt_description)}return Symbol}();
$jscomp.initSymbolIterator=function(){$jscomp.initSymbol();var symbolIterator=$jscomp.global["Symbol"].iterator;if(!symbolIterator)symbolIterator=$jscomp.global["Symbol"].iterator=$jscomp.global["Symbol"]("Symbol.iterator");if(typeof Array.prototype[symbolIterator]!="function")$jscomp.defineProperty(Array.prototype,symbolIterator,{configurable:true,writable:true,value:function(){return $jscomp.iteratorPrototype($jscomp.arrayIteratorImpl(this))}});$jscomp.initSymbolIterator=function(){}};
$jscomp.initSymbolAsyncIterator=function(){$jscomp.initSymbol();var symbolAsyncIterator=$jscomp.global["Symbol"].asyncIterator;if(!symbolAsyncIterator)symbolAsyncIterator=$jscomp.global["Symbol"].asyncIterator=$jscomp.global["Symbol"]("Symbol.asyncIterator");$jscomp.initSymbolAsyncIterator=function(){}};$jscomp.iteratorPrototype=function(next){$jscomp.initSymbolIterator();var iterator={next:next};iterator[$jscomp.global["Symbol"].iterator]=function(){return this};return iterator};
$jscomp.iteratorFromArray=function(array,transform){$jscomp.initSymbolIterator();if(array instanceof String)array=array+"";var i=0;var iter={next:function(){if(i<array.length){var index=i++;return{value:transform(index,array[index]),done:false}}iter.next=function(){return{done:true,value:void 0}};return iter.next()}};iter[Symbol.iterator]=function(){return iter};return iter};
$jscomp.polyfill("Array.prototype.entries",function(orig){if(orig)return orig;var polyfill=function(){return $jscomp.iteratorFromArray(this,function(i,v){return[i,v]})};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.fill",function(orig){if(orig)return orig;var polyfill=function(value,opt_start,opt_end){var length=this.length||0;if(opt_start<0)opt_start=Math.max(0,length+opt_start);if(opt_end==null||opt_end>length)opt_end=length;opt_end=Number(opt_end);if(opt_end<0)opt_end=Math.max(0,length+opt_end);for(var i=Number(opt_start||0);i<opt_end;i++)this[i]=value;return this};return polyfill},"es6","es3");
$jscomp.findInternal=function(array,callback,thisArg){if(array instanceof String)array=String(array);var len=array.length;for(var i=0;i<len;i++){var value=array[i];if(callback.call(thisArg,value,i,array))return{i:i,v:value}}return{i:-1,v:void 0}};$jscomp.polyfill("Array.prototype.find",function(orig){if(orig)return orig;var polyfill=function(callback,opt_thisArg){return $jscomp.findInternal(this,callback,opt_thisArg).v};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.findIndex",function(orig){if(orig)return orig;var polyfill=function(callback,opt_thisArg){return $jscomp.findInternal(this,callback,opt_thisArg).i};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.flat",function(orig){if(orig)return orig;var flat=function(depth){depth=depth===undefined?1:depth;var flattened=[];for(var i=0;i<this.length;i++){var element=this[i];if(Array.isArray(element)&&depth>0){var inner=Array.prototype.flat.call(element,depth-1);flattened.push.apply(flattened,inner)}else flattened.push(element)}return flattened};return flat},"es9","es5");
$jscomp.polyfill("Array.prototype.flatMap",function(orig){if(orig)return orig;var flatMap=function(callback,thisArg){var mapped=[];for(var i=0;i<this.length;i++){var result=callback.call(thisArg,this[i],i,this);if(Array.isArray(result))mapped.push.apply(mapped,result);else mapped.push(result)}return mapped};return flatMap},"es9","es5");
$jscomp.polyfill("Array.from",function(orig){if(orig)return orig;var polyfill=function(arrayLike,opt_mapFn,opt_thisArg){opt_mapFn=opt_mapFn!=null?opt_mapFn:function(x){return x};var result=[];var iteratorFunction=typeof Symbol!="undefined"&&Symbol.iterator&&arrayLike[Symbol.iterator];if(typeof iteratorFunction=="function"){arrayLike=iteratorFunction.call(arrayLike);var next;var k=0;while(!(next=arrayLike.next()).done)result.push(opt_mapFn.call(opt_thisArg,next.value,k++))}else{var len=arrayLike.length;
for(var i=0;i<len;i++)result.push(opt_mapFn.call(opt_thisArg,arrayLike[i],i))}return result};return polyfill},"es6","es3");$jscomp.polyfill("Object.is",function(orig){if(orig)return orig;var polyfill=function(left,right){if(left===right)return left!==0||1/left===1/right;else return left!==left&&right!==right};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.includes",function(orig){if(orig)return orig;var includes=function(searchElement,opt_fromIndex){var array=this;if(array instanceof String)array=String(array);var len=array.length;var i=opt_fromIndex||0;if(i<0)i=Math.max(i+len,0);for(;i<len;i++){var element=array[i];if(element===searchElement||Object.is(element,searchElement))return true}return false};return includes},"es7","es3");
$jscomp.polyfill("Array.prototype.keys",function(orig){if(orig)return orig;var polyfill=function(){return $jscomp.iteratorFromArray(this,function(i){return i})};return polyfill},"es6","es3");$jscomp.polyfill("Array.of",function(orig){if(orig)return orig;var polyfill=function(var_args){return Array.from(arguments)};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.values",function(orig){if(orig)return orig;var polyfill=function(){return $jscomp.iteratorFromArray(this,function(k,v){return v})};return polyfill},"es8","es3");$jscomp.makeIterator=function(iterable){var iteratorFunction=typeof Symbol!="undefined"&&Symbol.iterator&&iterable[Symbol.iterator];return iteratorFunction?iteratorFunction.call(iterable):$jscomp.arrayIterator(iterable)};$jscomp.FORCE_POLYFILL_PROMISE=false;
$jscomp.polyfill("Promise",function(NativePromise){if(NativePromise&&!$jscomp.FORCE_POLYFILL_PROMISE)return NativePromise;function AsyncExecutor(){this.batch_=null}AsyncExecutor.prototype.asyncExecute=function(f){if(this.batch_==null){this.batch_=[];var self=this;this.asyncExecuteFunction(function(){self.executeBatch_()})}this.batch_.push(f)};var nativeSetTimeout=$jscomp.global["setTimeout"];AsyncExecutor.prototype.asyncExecuteFunction=function(f){nativeSetTimeout(f,0)};AsyncExecutor.prototype.executeBatch_=
function(){while(this.batch_&&this.batch_.length){var executingBatch=this.batch_;this.batch_=[];for(var i=0;i<executingBatch.length;++i){var f=executingBatch[i];executingBatch[i]=null;try{f()}catch(error){this.asyncThrow_(error)}}}this.batch_=null};AsyncExecutor.prototype.asyncThrow_=function(exception){this.asyncExecuteFunction(function(){throw exception;})};var PromiseState={PENDING:0,FULFILLED:1,REJECTED:2};var PolyfillPromise=function(executor){this.state_=PromiseState.PENDING;this.result_=undefined;
this.onSettledCallbacks_=[];var resolveAndReject=this.createResolveAndReject_();try{executor(resolveAndReject.resolve,resolveAndReject.reject)}catch(e){resolveAndReject.reject(e)}};PolyfillPromise.prototype.createResolveAndReject_=function(){var thisPromise=this;var alreadyCalled=false;function firstCallWins(method){return function(x){if(!alreadyCalled){alreadyCalled=true;method.call(thisPromise,x)}}}return{resolve:firstCallWins(this.resolveTo_),reject:firstCallWins(this.reject_)}};PolyfillPromise.prototype.resolveTo_=
function(value){if(value===this)this.reject_(new TypeError("A Promise cannot resolve to itself"));else if(value instanceof PolyfillPromise)this.settleSameAsPromise_(value);else if(isObject(value))this.resolveToNonPromiseObj_(value);else this.fulfill_(value)};PolyfillPromise.prototype.resolveToNonPromiseObj_=function(obj){var thenMethod=undefined;try{thenMethod=obj.then}catch(error){this.reject_(error);return}if(typeof thenMethod=="function")this.settleSameAsThenable_(thenMethod,obj);else this.fulfill_(obj)};
function isObject(value){switch(typeof value){case "object":return value!=null;case "function":return true;default:return false}}PolyfillPromise.prototype.reject_=function(reason){this.settle_(PromiseState.REJECTED,reason)};PolyfillPromise.prototype.fulfill_=function(value){this.settle_(PromiseState.FULFILLED,value)};PolyfillPromise.prototype.settle_=function(settledState,valueOrReason){if(this.state_!=PromiseState.PENDING)throw new Error("Cannot settle("+settledState+", "+valueOrReason+"): Promise already settled in state"+
this.state_);this.state_=settledState;this.result_=valueOrReason;this.executeOnSettledCallbacks_()};PolyfillPromise.prototype.executeOnSettledCallbacks_=function(){if(this.onSettledCallbacks_!=null){for(var i=0;i<this.onSettledCallbacks_.length;++i)asyncExecutor.asyncExecute(this.onSettledCallbacks_[i]);this.onSettledCallbacks_=null}};var asyncExecutor=new AsyncExecutor;PolyfillPromise.prototype.settleSameAsPromise_=function(promise){var methods=this.createResolveAndReject_();promise.callWhenSettled_(methods.resolve,
methods.reject)};PolyfillPromise.prototype.settleSameAsThenable_=function(thenMethod,thenable){var methods=this.createResolveAndReject_();try{thenMethod.call(thenable,methods.resolve,methods.reject)}catch(error){methods.reject(error)}};PolyfillPromise.prototype.then=function(onFulfilled,onRejected){var resolveChild;var rejectChild;var childPromise=new PolyfillPromise(function(resolve,reject){resolveChild=resolve;rejectChild=reject});function createCallback(paramF,defaultF){if(typeof paramF=="function")return function(x){try{resolveChild(paramF(x))}catch(error){rejectChild(error)}};
else return defaultF}this.callWhenSettled_(createCallback(onFulfilled,resolveChild),createCallback(onRejected,rejectChild));return childPromise};PolyfillPromise.prototype.catch=function(onRejected){return this.then(undefined,onRejected)};PolyfillPromise.prototype.callWhenSettled_=function(onFulfilled,onRejected){var thisPromise=this;function callback(){switch(thisPromise.state_){case PromiseState.FULFILLED:onFulfilled(thisPromise.result_);break;case PromiseState.REJECTED:onRejected(thisPromise.result_);
break;default:throw new Error("Unexpected state: "+thisPromise.state_);}}if(this.onSettledCallbacks_==null)asyncExecutor.asyncExecute(callback);else this.onSettledCallbacks_.push(callback)};function resolvingPromise(opt_value){if(opt_value instanceof PolyfillPromise)return opt_value;else return new PolyfillPromise(function(resolve,reject){resolve(opt_value)})}PolyfillPromise["resolve"]=resolvingPromise;PolyfillPromise["reject"]=function(opt_reason){return new PolyfillPromise(function(resolve,reject){reject(opt_reason)})};
PolyfillPromise["race"]=function(thenablesOrValues){return new PolyfillPromise(function(resolve,reject){var iterator=$jscomp.makeIterator(thenablesOrValues);for(var iterRec=iterator.next();!iterRec.done;iterRec=iterator.next())resolvingPromise(iterRec.value).callWhenSettled_(resolve,reject)})};PolyfillPromise["all"]=function(thenablesOrValues){var iterator=$jscomp.makeIterator(thenablesOrValues);var iterRec=iterator.next();if(iterRec.done)return resolvingPromise([]);else return new PolyfillPromise(function(resolveAll,
rejectAll){var resultsArray=[];var unresolvedCount=0;function onFulfilled(i){return function(ithResult){resultsArray[i]=ithResult;unresolvedCount--;if(unresolvedCount==0)resolveAll(resultsArray)}}do{resultsArray.push(undefined);unresolvedCount++;resolvingPromise(iterRec.value).callWhenSettled_(onFulfilled(resultsArray.length-1),rejectAll);iterRec=iterator.next()}while(!iterRec.done)})};return PolyfillPromise},"es6","es3");
$jscomp.makeAsyncIterator=function(iterable){$jscomp.initSymbolAsyncIterator();var asyncIteratorFunction=iterable[Symbol.asyncIterator];if(asyncIteratorFunction!==undefined)return asyncIteratorFunction.call(iterable);return new $jscomp.AsyncIteratorFromSyncWrapper($jscomp.makeIterator(iterable))};
$jscomp.AsyncIteratorFromSyncWrapper=function(iterator){this[Symbol.asyncIterator]=function(){return this};this[Symbol.iterator]=function(){return iterator};this.next=function(param){return Promise.resolve(iterator.next(param))};if(iterator["throw"]!==undefined)this["throw"]=function(param){return Promise.resolve(iterator["throw"](param))};if(iterator["return"]!==undefined)this["return"]=function(param){return Promise.resolve(iterator["return"](param))}};
$jscomp.AsyncGeneratorWrapper$ActionEnum={YIELD_VALUE:0,YIELD_STAR:1,AWAIT_VALUE:2};$jscomp.AsyncGeneratorWrapper$ActionRecord=function(action,value){this.action=action;this.value=value};$jscomp.AsyncGeneratorWrapper$GeneratorMethod={NEXT:"next",THROW:"throw",RETURN:"return"};$jscomp.AsyncGeneratorWrapper$ExecutionFrame_=function(method,param,resolve,reject){this.method=method;this.param=param;this.resolve=resolve;this.reject=reject};
$jscomp.AsyncGeneratorWrapper$ExecutionNode_=function(frame,next){this.frame=frame;this.next=next};$jscomp.AsyncGeneratorWrapper$ExecutionQueue_=function(){this.head_=null;this.tail_=null};$jscomp.AsyncGeneratorWrapper$ExecutionQueue_.prototype.isEmpty=function(){return this.head_===null};$jscomp.AsyncGeneratorWrapper$ExecutionQueue_.prototype.first=function(){if(this.head_)return this.head_.frame;else throw new Error("no frames in executionQueue");};
$jscomp.AsyncGeneratorWrapper$ExecutionQueue_.prototype.drop=function(){if(this.head_){this.head_=this.head_.next;if(!this.head_)this.tail_=null}};$jscomp.AsyncGeneratorWrapper$ExecutionQueue_.prototype.enqueue=function(newFrame){var node=new $jscomp.AsyncGeneratorWrapper$ExecutionNode_(newFrame,null);if(this.tail_){this.tail_.next=node;this.tail_=node}else{this.head_=node;this.tail_=node}};
$jscomp.AsyncGeneratorWrapper=function(generator){this.generator_=generator;this.delegate_=null;this.executionQueue_=new $jscomp.AsyncGeneratorWrapper$ExecutionQueue_;$jscomp.initSymbolAsyncIterator();this[Symbol.asyncIterator]=function(){return this};var self=this;this.boundHandleDelegateResult_=function(record){self.handleDelegateResult_(record)};this.boundHandleDelegateError_=function(thrownError){self.handleDelegateError_(thrownError)};this.boundRejectAndClose_=function(err){self.rejectAndClose_(err)}};
$jscomp.AsyncGeneratorWrapper.prototype.enqueueMethod_=function(method,param){var self=this;return new Promise(function(resolve,reject){var wasEmpty=self.executionQueue_.isEmpty();self.executionQueue_.enqueue(new $jscomp.AsyncGeneratorWrapper$ExecutionFrame_(method,param,resolve,reject));if(wasEmpty)self.runFrame_()})};$jscomp.AsyncGeneratorWrapper.prototype.next=function(opt_value){return this.enqueueMethod_($jscomp.AsyncGeneratorWrapper$GeneratorMethod.NEXT,opt_value)};
$jscomp.AsyncGeneratorWrapper.prototype.return=function(value){return this.enqueueMethod_($jscomp.AsyncGeneratorWrapper$GeneratorMethod.RETURN,new $jscomp.AsyncGeneratorWrapper$ActionRecord($jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE,value))};$jscomp.AsyncGeneratorWrapper.prototype.throw=function(exception){return this.enqueueMethod_($jscomp.AsyncGeneratorWrapper$GeneratorMethod.THROW,exception)};
$jscomp.AsyncGeneratorWrapper.prototype.runFrame_=function(){if(!this.executionQueue_.isEmpty())try{if(this.delegate_)this.runDelegateFrame_();else this.runGeneratorFrame_()}catch(err){this.rejectAndClose_(err)}};
$jscomp.AsyncGeneratorWrapper.prototype.runGeneratorFrame_=function(){var self=this;var frame=this.executionQueue_.first();try{var genRec=this.generator_[frame.method](frame.param);if(genRec.value instanceof $jscomp.AsyncGeneratorWrapper$ActionRecord)switch(genRec.value.action){case $jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE:Promise.resolve(genRec.value.value).then(function(resolvedValue){frame.resolve({value:resolvedValue,done:genRec.done});self.executionQueue_.drop();self.runFrame_()},
function(e){frame.reject(e);self.executionQueue_.drop();self.runFrame_()}).catch(this.boundRejectAndClose_);return;case $jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_STAR:self.delegate_=$jscomp.makeAsyncIterator(genRec.value.value);frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.NEXT;frame.param=undefined;self.runFrame_();return;case $jscomp.AsyncGeneratorWrapper$ActionEnum.AWAIT_VALUE:Promise.resolve(genRec.value.value).then(function(resolvedValue){frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.NEXT;
frame.param=resolvedValue;self.runFrame_()},function(thrownErr){frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.THROW;frame.param=thrownErr;self.runFrame_()}).catch(this.boundRejectAndClose_);return;default:throw new Error("Unrecognized AsyncGeneratorWrapper$ActionEnum");}else{frame.resolve(genRec);self.executionQueue_.drop();self.runFrame_()}}catch(e){frame.reject(e);self.executionQueue_.drop();self.runFrame_()}};
$jscomp.AsyncGeneratorWrapper.prototype.runDelegateFrame_=function(){if(!this.delegate_)throw new Error("no delegate to perform execution");var frame=this.executionQueue_.first();if(frame.method in this.delegate_)try{this.delegate_[frame.method](frame.param).then(this.boundHandleDelegateResult_,this.boundHandleDelegateError_).catch(this.boundRejectAndClose_)}catch(err){this.handleDelegateError_(err)}else{this.delegate_=null;this.runFrame_()}};
$jscomp.AsyncGeneratorWrapper.prototype.handleDelegateResult_=function(record){var frame=this.executionQueue_.first();if(record.done===true){this.delegate_=null;frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.NEXT;frame.param=record.value;this.runFrame_()}else{frame.resolve({value:record.value,done:false});this.executionQueue_.drop();this.runFrame_()}};
$jscomp.AsyncGeneratorWrapper.prototype.handleDelegateError_=function(thrownError){var frame=this.executionQueue_.first();this.delegate_=null;frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.THROW;frame.param=thrownError;this.runFrame_()};
$jscomp.AsyncGeneratorWrapper.prototype.rejectAndClose_=function(err){if(!this.executionQueue_.isEmpty()){this.executionQueue_.first().reject(err);this.executionQueue_.drop()}if(this.delegate_&&"return"in this.delegate_){this.delegate_["return"](undefined);this.delegate_=null}this.generator_["return"](undefined);this.runFrame_()};$jscomp.underscoreProtoCanBeSet=function(){var x={a:true};var y={};try{y.__proto__=x;return y.a}catch(e){}return false};
$jscomp.setPrototypeOf=typeof Object.setPrototypeOf=="function"?Object.setPrototypeOf:$jscomp.underscoreProtoCanBeSet()?function(target,proto){target.__proto__=proto;if(target.__proto__!==proto)throw new TypeError(target+" is not extensible");return target}:null;$jscomp.generator={};$jscomp.generator.ensureIteratorResultIsObject_=function(result){if(result instanceof Object)return;throw new TypeError("Iterator result "+result+" is not an object");};
$jscomp.generator.Context=function(){this.isRunning_=false;this.yieldAllIterator_=null;this.yieldResult=undefined;this.nextAddress=1;this.catchAddress_=0;this.finallyAddress_=0;this.abruptCompletion_=null;this.finallyContexts_=null};$jscomp.generator.Context.prototype.start_=function(){if(this.isRunning_)throw new TypeError("Generator is already running");this.isRunning_=true};$jscomp.generator.Context.prototype.stop_=function(){this.isRunning_=false};
$jscomp.generator.Context.prototype.jumpToErrorHandler_=function(){this.nextAddress=this.catchAddress_||this.finallyAddress_};$jscomp.generator.Context.prototype.next_=function(value){this.yieldResult=value};$jscomp.generator.Context.prototype.throw_=function(e){this.abruptCompletion_={exception:e,isException:true};this.jumpToErrorHandler_()};$jscomp.generator.Context.prototype.return=function(value){this.abruptCompletion_={return:value};this.nextAddress=this.finallyAddress_};
$jscomp.generator.Context.prototype.jumpThroughFinallyBlocks=function(nextAddress){this.abruptCompletion_={jumpTo:nextAddress};this.nextAddress=this.finallyAddress_};$jscomp.generator.Context.prototype.yield=function(value,resumeAddress){this.nextAddress=resumeAddress;return{value:value}};
$jscomp.generator.Context.prototype.yieldAll=function(iterable,resumeAddress){var iterator=$jscomp.makeIterator(iterable);var result=iterator.next();$jscomp.generator.ensureIteratorResultIsObject_(result);if(result.done){this.yieldResult=result.value;this.nextAddress=resumeAddress;return}this.yieldAllIterator_=iterator;return this.yield(result.value,resumeAddress)};$jscomp.generator.Context.prototype.jumpTo=function(nextAddress){this.nextAddress=nextAddress};
$jscomp.generator.Context.prototype.jumpToEnd=function(){this.nextAddress=0};$jscomp.generator.Context.prototype.setCatchFinallyBlocks=function(catchAddress,finallyAddress){this.catchAddress_=catchAddress;if(finallyAddress!=undefined)this.finallyAddress_=finallyAddress};$jscomp.generator.Context.prototype.setFinallyBlock=function(finallyAddress){this.catchAddress_=0;this.finallyAddress_=finallyAddress||0};
$jscomp.generator.Context.prototype.leaveTryBlock=function(nextAddress,catchAddress){this.nextAddress=nextAddress;this.catchAddress_=catchAddress||0};$jscomp.generator.Context.prototype.enterCatchBlock=function(nextCatchBlockAddress){this.catchAddress_=nextCatchBlockAddress||0;var exception=this.abruptCompletion_.exception;this.abruptCompletion_=null;return exception};
$jscomp.generator.Context.prototype.enterFinallyBlock=function(nextCatchAddress,nextFinallyAddress,finallyDepth){if(!finallyDepth)this.finallyContexts_=[this.abruptCompletion_];else this.finallyContexts_[finallyDepth]=this.abruptCompletion_;this.catchAddress_=nextCatchAddress||0;this.finallyAddress_=nextFinallyAddress||0};
$jscomp.generator.Context.prototype.leaveFinallyBlock=function(nextAddress,finallyDepth){var preservedContext=this.finallyContexts_.splice(finallyDepth||0)[0];var abruptCompletion=this.abruptCompletion_=this.abruptCompletion_||preservedContext;if(abruptCompletion){if(abruptCompletion.isException)return this.jumpToErrorHandler_();if(abruptCompletion.jumpTo!=undefined&&this.finallyAddress_<abruptCompletion.jumpTo){this.nextAddress=abruptCompletion.jumpTo;this.abruptCompletion_=null}else this.nextAddress=
this.finallyAddress_}else this.nextAddress=nextAddress};$jscomp.generator.Context.prototype.forIn=function(object){return new $jscomp.generator.Context.PropertyIterator(object)};$jscomp.generator.Context.PropertyIterator=function(object){this.object_=object;this.properties_=[];for(var property in object)this.properties_.push(property);this.properties_.reverse()};
$jscomp.generator.Context.PropertyIterator.prototype.getNext=function(){while(this.properties_.length>0){var property=this.properties_.pop();if(property in this.object_)return property}return null};$jscomp.generator.Engine_=function(program){this.context_=new $jscomp.generator.Context;this.program_=program};
$jscomp.generator.Engine_.prototype.next_=function(value){this.context_.start_();if(this.context_.yieldAllIterator_)return this.yieldAllStep_(this.context_.yieldAllIterator_.next,value,this.context_.next_);this.context_.next_(value);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.return_=function(value){this.context_.start_();var yieldAllIterator=this.context_.yieldAllIterator_;if(yieldAllIterator){var returnFunction="return"in yieldAllIterator?yieldAllIterator["return"]:function(v){return{value:v,done:true}};return this.yieldAllStep_(returnFunction,value,this.context_.return)}this.context_.return(value);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.throw_=function(exception){this.context_.start_();if(this.context_.yieldAllIterator_)return this.yieldAllStep_(this.context_.yieldAllIterator_["throw"],exception,this.context_.next_);this.context_.throw_(exception);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.yieldAllStep_=function(action,value,nextAction){try{var result=action.call(this.context_.yieldAllIterator_,value);$jscomp.generator.ensureIteratorResultIsObject_(result);if(!result.done){this.context_.stop_();return result}var resultValue=result.value}catch(e){this.context_.yieldAllIterator_=null;this.context_.throw_(e);return this.nextStep_()}this.context_.yieldAllIterator_=null;nextAction.call(this.context_,resultValue);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.nextStep_=function(){while(this.context_.nextAddress)try{var yieldValue=this.program_(this.context_);if(yieldValue){this.context_.stop_();return{value:yieldValue.value,done:false}}}catch(e){this.context_.yieldResult=undefined;this.context_.throw_(e)}this.context_.stop_();if(this.context_.abruptCompletion_){var abruptCompletion=this.context_.abruptCompletion_;this.context_.abruptCompletion_=null;if(abruptCompletion.isException)throw abruptCompletion.exception;return{value:abruptCompletion.return,
done:true}}return{value:undefined,done:true}};$jscomp.generator.Generator_=function(engine){this.next=function(opt_value){return engine.next_(opt_value)};this.throw=function(exception){return engine.throw_(exception)};this.return=function(value){return engine.return_(value)};$jscomp.initSymbolIterator();this[Symbol.iterator]=function(){return this}};
$jscomp.generator.createGenerator=function(generator,program){var result=new $jscomp.generator.Generator_(new $jscomp.generator.Engine_(program));if($jscomp.setPrototypeOf)$jscomp.setPrototypeOf(result,generator.prototype);return result};
$jscomp.asyncExecutePromiseGenerator=function(generator){function passValueToGenerator(value){return generator.next(value)}function passErrorToGenerator(error){return generator.throw(error)}return new Promise(function(resolve,reject){function handleGeneratorRecord(genRec){if(genRec.done)resolve(genRec.value);else Promise.resolve(genRec.value).then(passValueToGenerator,passErrorToGenerator).then(handleGeneratorRecord,reject)}handleGeneratorRecord(generator.next())})};
$jscomp.asyncExecutePromiseGeneratorFunction=function(generatorFunction){return $jscomp.asyncExecutePromiseGenerator(generatorFunction())};$jscomp.asyncExecutePromiseGeneratorProgram=function(program){return $jscomp.asyncExecutePromiseGenerator(new $jscomp.generator.Generator_(new $jscomp.generator.Engine_(program)))};
$jscomp.checkEs6ConformanceViaProxy=function(){try{var proxied={};var proxy=Object.create(new $jscomp.global["Proxy"](proxied,{"get":function(target,key,receiver){return target==proxied&&key=="q"&&receiver==proxy}}));return proxy["q"]===true}catch(err){return false}};$jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS=false;$jscomp.ES6_CONFORMANCE=$jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS&&$jscomp.checkEs6ConformanceViaProxy();
$jscomp.owns=function(obj,prop){return Object.prototype.hasOwnProperty.call(obj,prop)};
$jscomp.polyfill("WeakMap",function(NativeWeakMap){function isConformant(){if(!NativeWeakMap||!Object.seal)return false;try{var x=Object.seal({});var y=Object.seal({});var map=new NativeWeakMap([[x,2],[y,3]]);if(map.get(x)!=2||map.get(y)!=3)return false;map.delete(x);map.set(y,4);return!map.has(x)&&map.get(y)==4}catch(err){return false}}if($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS){if(NativeWeakMap&&$jscomp.ES6_CONFORMANCE)return NativeWeakMap}else if(isConformant())return NativeWeakMap;var prop=
"$jscomp_hidden_"+Math.random();function WeakMapMembership(){}function isValidKey(key){var type=typeof key;return type==="object"&&key!==null||type==="function"}function insert(target){if(!$jscomp.owns(target,prop)){var obj=new WeakMapMembership;$jscomp.defineProperty(target,prop,{value:obj})}}function patch(name){var prev=Object[name];if(prev)Object[name]=function(target){if(target instanceof WeakMapMembership)return target;else{insert(target);return prev(target)}}}patch("freeze");patch("preventExtensions");
patch("seal");var index=0;var PolyfillWeakMap=function(opt_iterable){this.id_=(index+=Math.random()+1).toString();if(opt_iterable){var iter=$jscomp.makeIterator(opt_iterable);var entry;while(!(entry=iter.next()).done){var item=entry.value;this.set(item[0],item[1])}}};PolyfillWeakMap.prototype.set=function(key,value){if(!isValidKey(key))throw new Error("Invalid WeakMap key");insert(key);if(!$jscomp.owns(key,prop))throw new Error("WeakMap key fail: "+key);key[prop][this.id_]=value;return this};PolyfillWeakMap.prototype.get=
function(key){return isValidKey(key)&&$jscomp.owns(key,prop)?key[prop][this.id_]:undefined};PolyfillWeakMap.prototype.has=function(key){return isValidKey(key)&&$jscomp.owns(key,prop)&&$jscomp.owns(key[prop],this.id_)};PolyfillWeakMap.prototype.delete=function(key){if(!isValidKey(key)||!$jscomp.owns(key,prop)||!$jscomp.owns(key[prop],this.id_))return false;return delete key[prop][this.id_]};return PolyfillWeakMap},"es6","es3");
$jscomp.MapEntry=function(){this.previous;this.next;this.head;this.key;this.value};
$jscomp.polyfill("Map",function(NativeMap){function isConformant(){if($jscomp.ASSUME_NO_NATIVE_MAP||!NativeMap||typeof NativeMap!="function"||!NativeMap.prototype.entries||typeof Object.seal!="function")return false;try{NativeMap=NativeMap;var key=Object.seal({x:4});var map=new NativeMap($jscomp.makeIterator([[key,"s"]]));if(map.get(key)!="s"||map.size!=1||map.get({x:4})||map.set({x:4},"t")!=map||map.size!=2)return false;var iter=map.entries();var item=iter.next();if(item.done||item.value[0]!=key||
item.value[1]!="s")return false;item=iter.next();if(item.done||item.value[0].x!=4||item.value[1]!="t"||!iter.next().done)return false;return true}catch(err){return false}}if($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS){if(NativeMap&&$jscomp.ES6_CONFORMANCE)return NativeMap}else if(isConformant())return NativeMap;$jscomp.initSymbolIterator();var idMap=new WeakMap;var PolyfillMap=function(opt_iterable){this.data_={};this.head_=createHead();this.size=0;if(opt_iterable){var iter=$jscomp.makeIterator(opt_iterable);
var entry;while(!(entry=iter.next()).done){var item=entry.value;this.set(item[0],item[1])}}};PolyfillMap.prototype.set=function(key,value){key=key===0?0:key;var r=maybeGetEntry(this,key);if(!r.list)r.list=this.data_[r.id]=[];if(!r.entry){r.entry={next:this.head_,previous:this.head_.previous,head:this.head_,key:key,value:value};r.list.push(r.entry);this.head_.previous.next=r.entry;this.head_.previous=r.entry;this.size++}else r.entry.value=value;return this};PolyfillMap.prototype.delete=function(key){var r=
maybeGetEntry(this,key);if(r.entry&&r.list){r.list.splice(r.index,1);if(!r.list.length)delete this.data_[r.id];r.entry.previous.next=r.entry.next;r.entry.next.previous=r.entry.previous;r.entry.head=null;this.size--;return true}return false};PolyfillMap.prototype.clear=function(){this.data_={};this.head_=this.head_.previous=createHead();this.size=0};PolyfillMap.prototype.has=function(key){return!!maybeGetEntry(this,key).entry};PolyfillMap.prototype.get=function(key){var entry=maybeGetEntry(this,key).entry;
return entry&&entry.value};PolyfillMap.prototype.entries=function(){return makeIterator(this,function(entry){return[entry.key,entry.value]})};PolyfillMap.prototype.keys=function(){return makeIterator(this,function(entry){return entry.key})};PolyfillMap.prototype.values=function(){return makeIterator(this,function(entry){return entry.value})};PolyfillMap.prototype.forEach=function(callback,opt_thisArg){var iter=this.entries();var item;while(!(item=iter.next()).done){var entry=item.value;callback.call(opt_thisArg,
entry[1],entry[0],this)}};PolyfillMap.prototype[Symbol.iterator]=PolyfillMap.prototype.entries;var maybeGetEntry=function(map,key){var id=getId(key);var list=map.data_[id];if(list&&$jscomp.owns(map.data_,id))for(var index=0;index<list.length;index++){var entry=list[index];if(key!==key&&entry.key!==entry.key||key===entry.key)return{id:id,list:list,index:index,entry:entry}}return{id:id,list:list,index:-1,entry:undefined}};var makeIterator=function(map,func){var entry=map.head_;return $jscomp.iteratorPrototype(function(){if(entry){while(entry.head!=
map.head_)entry=entry.previous;while(entry.next!=entry.head){entry=entry.next;return{done:false,value:func(entry)}}entry=null}return{done:true,value:void 0}})};var createHead=function(){var head={};head.previous=head.next=head.head=head;return head};var mapIndex=0;var getId=function(obj){var type=obj&&typeof obj;if(type=="object"||type=="function"){obj=obj;if(!idMap.has(obj)){var id=""+ ++mapIndex;idMap.set(obj,id);return id}return idMap.get(obj)}return"p_"+obj};return PolyfillMap},"es6","es3");
$jscomp.polyfill("Math.acosh",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);return Math.log(x+Math.sqrt(x*x-1))};return polyfill},"es6","es3");$jscomp.polyfill("Math.asinh",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(x===0)return x;var y=Math.log(Math.abs(x)+Math.sqrt(x*x+1));return x<0?-y:y};return polyfill},"es6","es3");
$jscomp.polyfill("Math.log1p",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(x<.25&&x>-.25){var y=x;var d=1;var z=x;var zPrev=0;var s=1;while(zPrev!=z){y*=x;s*=-1;z=(zPrev=z)+s*y/++d}return z}return Math.log(1+x)};return polyfill},"es6","es3");$jscomp.polyfill("Math.atanh",function(orig){if(orig)return orig;var log1p=Math.log1p;var polyfill=function(x){x=Number(x);return(log1p(x)-log1p(-x))/2};return polyfill},"es6","es3");
$jscomp.polyfill("Math.cbrt",function(orig){if(orig)return orig;var polyfill=function(x){if(x===0)return x;x=Number(x);var y=Math.pow(Math.abs(x),1/3);return x<0?-y:y};return polyfill},"es6","es3");
$jscomp.polyfill("Math.clz32",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x)>>>0;if(x===0)return 32;var result=0;if((x&4294901760)===0){x<<=16;result+=16}if((x&4278190080)===0){x<<=8;result+=8}if((x&4026531840)===0){x<<=4;result+=4}if((x&3221225472)===0){x<<=2;result+=2}if((x&2147483648)===0)result++;return result};return polyfill},"es6","es3");
$jscomp.polyfill("Math.cosh",function(orig){if(orig)return orig;var exp=Math.exp;var polyfill=function(x){x=Number(x);return(exp(x)+exp(-x))/2};return polyfill},"es6","es3");$jscomp.polyfill("Math.expm1",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(x<.25&&x>-.25){var y=x;var d=1;var z=x;var zPrev=0;while(zPrev!=z){y*=x/++d;z=(zPrev=z)+y}return z}return Math.exp(x)-1};return polyfill},"es6","es3");
$jscomp.polyfill("Math.fround",function(orig){if(orig)return orig;if($jscomp.SIMPLE_FROUND_POLYFILL||typeof Float32Array!=="function")return function(arg){return arg};var arr=new Float32Array(1);var polyfill=function(arg){arr[0]=arg;return arr[0]};return polyfill},"es6","es3");
$jscomp.polyfill("Math.hypot",function(orig){if(orig)return orig;var polyfill=function(var_args){if(arguments.length<2)return arguments.length?Math.abs(arguments[0]):0;var i,z,sum,max;for(max=0,i=0;i<arguments.length;i++)max=Math.max(max,Math.abs(arguments[i]));if(max>1E100||max<1E-100){if(!max)return max;sum=0;for(i=0;i<arguments.length;i++){z=Number(arguments[i])/max;sum+=z*z}return Math.sqrt(sum)*max}else{sum=0;for(i=0;i<arguments.length;i++){z=Number(arguments[i]);sum+=z*z}return Math.sqrt(sum)}};
return polyfill},"es6","es3");$jscomp.polyfill("Math.imul",function(orig){if(orig)return orig;var polyfill=function(a,b){a=Number(a);b=Number(b);var ah=a>>>16&65535;var al=a&65535;var bh=b>>>16&65535;var bl=b&65535;var lh=ah*bl+al*bh<<16>>>0;return al*bl+lh|0};return polyfill},"es6","es3");$jscomp.polyfill("Math.log10",function(orig){if(orig)return orig;var polyfill=function(x){return Math.log(x)/Math.LN10};return polyfill},"es6","es3");
$jscomp.polyfill("Math.log2",function(orig){if(orig)return orig;var polyfill=function(x){return Math.log(x)/Math.LN2};return polyfill},"es6","es3");$jscomp.polyfill("Math.sign",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);return x===0||isNaN(x)?x:x>0?1:-1};return polyfill},"es6","es3");$jscomp.polyfill("Math.sinh",function(orig){if(orig)return orig;var exp=Math.exp;var polyfill=function(x){x=Number(x);if(x===0)return x;return(exp(x)-exp(-x))/2};return polyfill},"es6","es3");
$jscomp.polyfill("Math.tanh",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(x===0)return x;var y=Math.exp(-2*Math.abs(x));var z=(1-y)/(1+y);return x<0?-z:z};return polyfill},"es6","es3");$jscomp.polyfill("Math.trunc",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(isNaN(x)||x===Infinity||x===-Infinity||x===0)return x;var y=Math.floor(Math.abs(x));return x<0?-y:y};return polyfill},"es6","es3");
$jscomp.polyfill("Number.EPSILON",function(orig){return Math.pow(2,-52)},"es6","es3");$jscomp.polyfill("Number.MAX_SAFE_INTEGER",function(){return 9007199254740991},"es6","es3");$jscomp.polyfill("Number.MIN_SAFE_INTEGER",function(){return-9007199254740991},"es6","es3");$jscomp.polyfill("Number.isFinite",function(orig){if(orig)return orig;var polyfill=function(x){if(typeof x!=="number")return false;return!isNaN(x)&&x!==Infinity&&x!==-Infinity};return polyfill},"es6","es3");
$jscomp.polyfill("Number.isInteger",function(orig){if(orig)return orig;var polyfill=function(x){if(!Number.isFinite(x))return false;return x===Math.floor(x)};return polyfill},"es6","es3");$jscomp.polyfill("Number.isNaN",function(orig){if(orig)return orig;var polyfill=function(x){return typeof x==="number"&&isNaN(x)};return polyfill},"es6","es3");
$jscomp.polyfill("Number.isSafeInteger",function(orig){if(orig)return orig;var polyfill=function(x){return Number.isInteger(x)&&Math.abs(x)<=Number.MAX_SAFE_INTEGER};return polyfill},"es6","es3");$jscomp.polyfill("Number.parseFloat",function(orig){return orig||parseFloat},"es6","es3");$jscomp.polyfill("Number.parseInt",function(orig){return orig||parseInt},"es6","es3");
$jscomp.assign=typeof Object.assign=="function"?Object.assign:function(target,var_args){for(var i=1;i<arguments.length;i++){var source=arguments[i];if(!source)continue;for(var key in source)if($jscomp.owns(source,key))target[key]=source[key]}return target};$jscomp.polyfill("Object.assign",function(orig){return orig||$jscomp.assign},"es6","es3");
$jscomp.polyfill("Object.entries",function(orig){if(orig)return orig;var entries=function(obj){var result=[];for(var key in obj)if($jscomp.owns(obj,key))result.push([key,obj[key]]);return result};return entries},"es8","es3");
$jscomp.polyfill("Object.fromEntries",function(orig){if(orig)return orig;function fromEntries(iter){var obj={};$jscomp.initSymbolIterator();if(!(Symbol.iterator in iter))throw new TypeError(""+iter+" is not iterable");var iteratorFn=iter[Symbol.iterator];var iterator=iteratorFn.call(iter);for(var result=iterator.next();!result.done;result=iterator.next()){var pair=result.value;if(Object(pair)!==pair)throw new TypeError("iterable for fromEntries should yield objects");var key=pair[0];var val=pair[1];
obj[key]=val}return obj}return fromEntries},"es_2019","es3");$jscomp.polyfill("Object.getOwnPropertySymbols",function(orig){if(orig)return orig;return function(){return[]}},"es6","es5");
$jscomp.polyfill("Reflect.ownKeys",function(orig){if(orig)return orig;var symbolPrefix="jscomp_symbol_";function isSymbol(key){return key.substring(0,symbolPrefix.length)==symbolPrefix}var polyfill=function(target){var keys=[];var names=Object.getOwnPropertyNames(target);var symbols=Object.getOwnPropertySymbols(target);for(var i=0;i<names.length;i++)(isSymbol(names[i])?symbols:keys).push(names[i]);return keys.concat(symbols)};return polyfill},"es6","es5");
$jscomp.polyfill("Object.getOwnPropertyDescriptors",function(orig){if(orig)return orig;var getOwnPropertyDescriptors=function(obj){var result={};var keys=Reflect.ownKeys(obj);for(var i=0;i<keys.length;i++)result[keys[i]]=Object.getOwnPropertyDescriptor(obj,keys[i]);return result};return getOwnPropertyDescriptors},"es8","es5");$jscomp.polyfill("Object.setPrototypeOf",function(orig){return orig||$jscomp.setPrototypeOf},"es6","es5");
$jscomp.polyfill("Object.values",function(orig){if(orig)return orig;var values=function(obj){var result=[];for(var key in obj)if($jscomp.owns(obj,key))result.push(obj[key]);return result};return values},"es8","es3");
$jscomp.polyfill("Promise.allSettled",function(orig){if(orig)return orig;function fulfilledResult(value){return{status:"fulfilled",value:value}}function rejectedResult(reason){return{status:"rejected",reason:reason}}var polyfill=function(thenablesOrValues){var PromiseConstructor=this;function convertToAllSettledResult(maybeThenable){return PromiseConstructor.resolve(maybeThenable).then(fulfilledResult,rejectedResult)}var wrappedResults=Array.from(thenablesOrValues,convertToAllSettledResult);return PromiseConstructor.all(wrappedResults)};
return polyfill},"es_next","es3");$jscomp.polyfill("Promise.prototype.finally",function(orig){if(orig)return orig;var polyfill=function(onFinally){return this.then(function(value){var promise=Promise.resolve(onFinally());return promise.then(function(){return value})},function(reason){var promise=Promise.resolve(onFinally());return promise.then(function(){throw reason;})})};return polyfill},"es9","es3");
$jscomp.polyfill("Reflect.apply",function(orig){if(orig)return orig;var apply=Function.prototype.apply;var polyfill=function(target,thisArg,argList){return apply.call(target,thisArg,argList)};return polyfill},"es6","es3");$jscomp.objectCreate=$jscomp.ASSUME_ES5||typeof Object.create=="function"?Object.create:function(prototype){var ctor=function(){};ctor.prototype=prototype;return new ctor};
$jscomp.construct=function(){function reflectConstructWorks(){function Base(){}function Derived(){}new Base;Reflect.construct(Base,[],Derived);return new Base instanceof Base}if(typeof Reflect!="undefined"&&Reflect.construct){if(reflectConstructWorks())return Reflect.construct;var brokenConstruct=Reflect.construct;var patchedConstruct=function(target,argList,opt_newTarget){var out=brokenConstruct(target,argList);if(opt_newTarget)Reflect.setPrototypeOf(out,opt_newTarget.prototype);return out};return patchedConstruct}function construct(target,
argList,opt_newTarget){if(opt_newTarget===undefined)opt_newTarget=target;var proto=opt_newTarget.prototype||Object.prototype;var obj=$jscomp.objectCreate(proto);var apply=Function.prototype.apply;var out=apply.call(target,obj,argList);return out||obj}return construct}();$jscomp.polyfill("Reflect.construct",function(orig){return $jscomp.construct},"es6","es3");
$jscomp.polyfill("Reflect.defineProperty",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey,attributes){try{Object.defineProperty(target,propertyKey,attributes);var desc=Object.getOwnPropertyDescriptor(target,propertyKey);if(!desc)return false;return desc.configurable===(attributes.configurable||false)&&desc.enumerable===(attributes.enumerable||false)&&("value"in desc?desc.value===attributes.value&&desc.writable===(attributes.writable||false):desc.get===attributes.get&&desc.set===
attributes.set)}catch(err){return false}};return polyfill},"es6","es5");$jscomp.polyfill("Reflect.deleteProperty",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey){if(!$jscomp.owns(target,propertyKey))return true;try{return delete target[propertyKey]}catch(err){return false}};return polyfill},"es6","es3");$jscomp.polyfill("Reflect.getOwnPropertyDescriptor",function(orig){return orig||Object.getOwnPropertyDescriptor},"es6","es5");
$jscomp.polyfill("Reflect.getPrototypeOf",function(orig){return orig||Object.getPrototypeOf},"es6","es5");$jscomp.findDescriptor=function(target,propertyKey){var obj=target;while(obj){var property=Reflect.getOwnPropertyDescriptor(obj,propertyKey);if(property)return property;obj=Reflect.getPrototypeOf(obj)}return undefined};
$jscomp.polyfill("Reflect.get",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey,opt_receiver){if(arguments.length<=2)return target[propertyKey];var property=$jscomp.findDescriptor(target,propertyKey);if(property)return property.get?property.get.call(opt_receiver):property.value;return undefined};return polyfill},"es6","es5");
$jscomp.polyfill("Reflect.has",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey){return propertyKey in target};return polyfill},"es6","es3");$jscomp.polyfill("Reflect.isExtensible",function(orig){if(orig)return orig;if($jscomp.ASSUME_ES5||typeof Object.isExtensible=="function")return Object.isExtensible;return function(){return true}},"es6","es3");
$jscomp.polyfill("Reflect.preventExtensions",function(orig){if(orig)return orig;if(!($jscomp.ASSUME_ES5||typeof Object.preventExtensions=="function"))return function(){return false};var polyfill=function(target){Object.preventExtensions(target);return!Object.isExtensible(target)};return polyfill},"es6","es3");
$jscomp.polyfill("Reflect.set",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey,value,opt_receiver){var property=$jscomp.findDescriptor(target,propertyKey);if(!property){if(Reflect.isExtensible(target)){target[propertyKey]=value;return true}return false}if(property.set){property.set.call(arguments.length>3?opt_receiver:target,value);return true}else if(property.writable&&!Object.isFrozen(target)){target[propertyKey]=value;return true}return false};return polyfill},"es6",
"es5");$jscomp.polyfill("Reflect.setPrototypeOf",function(orig){if(orig)return orig;else if($jscomp.setPrototypeOf){var setPrototypeOf=$jscomp.setPrototypeOf;var polyfill=function(target,proto){try{setPrototypeOf(target,proto);return true}catch(e){return false}};return polyfill}else return null},"es6","es5");
$jscomp.polyfill("Set",function(NativeSet){function isConformant(){if($jscomp.ASSUME_NO_NATIVE_SET||!NativeSet||typeof NativeSet!="function"||!NativeSet.prototype.entries||typeof Object.seal!="function")return false;try{NativeSet=NativeSet;var value=Object.seal({x:4});var set=new NativeSet($jscomp.makeIterator([value]));if(!set.has(value)||set.size!=1||set.add(value)!=set||set.size!=1||set.add({x:4})!=set||set.size!=2)return false;var iter=set.entries();var item=iter.next();if(item.done||item.value[0]!=
value||item.value[1]!=value)return false;item=iter.next();if(item.done||item.value[0]==value||item.value[0].x!=4||item.value[1]!=item.value[0])return false;return iter.next().done}catch(err){return false}}if($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS){if(NativeSet&&$jscomp.ES6_CONFORMANCE)return NativeSet}else if(isConformant())return NativeSet;$jscomp.initSymbolIterator();var PolyfillSet=function(opt_iterable){this.map_=new Map;if(opt_iterable){var iter=$jscomp.makeIterator(opt_iterable);var entry;
while(!(entry=iter.next()).done){var item=entry.value;this.add(item)}}this.size=this.map_.size};PolyfillSet.prototype.add=function(value){value=value===0?0:value;this.map_.set(value,value);this.size=this.map_.size;return this};PolyfillSet.prototype.delete=function(value){var result=this.map_.delete(value);this.size=this.map_.size;return result};PolyfillSet.prototype.clear=function(){this.map_.clear();this.size=0};PolyfillSet.prototype.has=function(value){return this.map_.has(value)};PolyfillSet.prototype.entries=
function(){return this.map_.entries()};PolyfillSet.prototype.values=function(){return this.map_.values()};PolyfillSet.prototype.keys=PolyfillSet.prototype.values;PolyfillSet.prototype[Symbol.iterator]=PolyfillSet.prototype.values;PolyfillSet.prototype.forEach=function(callback,opt_thisArg){var set=this;this.map_.forEach(function(value){return callback.call(opt_thisArg,value,value,set)})};return PolyfillSet},"es6","es3");
$jscomp.checkStringArgs=function(thisArg,arg,func){if(thisArg==null)throw new TypeError("The 'this' value for String.prototype."+func+" must not be null or undefined");if(arg instanceof RegExp)throw new TypeError("First argument to String.prototype."+func+" must not be a regular expression");return thisArg+""};
$jscomp.polyfill("String.prototype.codePointAt",function(orig){if(orig)return orig;var polyfill=function(position){var string=$jscomp.checkStringArgs(this,null,"codePointAt");var size=string.length;position=Number(position)||0;if(!(position>=0&&position<size))return void 0;position=position|0;var first=string.charCodeAt(position);if(first<55296||first>56319||position+1===size)return first;var second=string.charCodeAt(position+1);if(second<56320||second>57343)return first;return(first-55296)*1024+
second+9216};return polyfill},"es6","es3");$jscomp.polyfill("String.prototype.endsWith",function(orig){if(orig)return orig;var polyfill=function(searchString,opt_position){var string=$jscomp.checkStringArgs(this,searchString,"endsWith");searchString=searchString+"";if(opt_position===void 0)opt_position=string.length;var i=Math.max(0,Math.min(opt_position|0,string.length));var j=searchString.length;while(j>0&&i>0)if(string[--i]!=searchString[--j])return false;return j<=0};return polyfill},"es6","es3");
$jscomp.polyfill("String.fromCodePoint",function(orig){if(orig)return orig;var polyfill=function(var_args){var result="";for(var i=0;i<arguments.length;i++){var code=Number(arguments[i]);if(code<0||code>1114111||code!==Math.floor(code))throw new RangeError("invalid_code_point "+code);if(code<=65535)result+=String.fromCharCode(code);else{code-=65536;result+=String.fromCharCode(code>>>10&1023|55296);result+=String.fromCharCode(code&1023|56320)}}return result};return polyfill},"es6","es3");
$jscomp.polyfill("String.prototype.includes",function(orig){if(orig)return orig;var polyfill=function(searchString,opt_position){var string=$jscomp.checkStringArgs(this,searchString,"includes");return string.indexOf(searchString,opt_position||0)!==-1};return polyfill},"es6","es3");
$jscomp.polyfill("String.prototype.repeat",function(orig){if(orig)return orig;var polyfill=function(copies){var string=$jscomp.checkStringArgs(this,null,"repeat");if(copies<0||copies>1342177279)throw new RangeError("Invalid count value");copies=copies|0;var result="";while(copies){if(copies&1)result+=string;if(copies>>>=1)string+=string}return result};return polyfill},"es6","es3");
$jscomp.stringPadding=function(padString,padLength){var padding=padString!==undefined?String(padString):" ";if(!(padLength>0)||!padding)return"";var repeats=Math.ceil(padLength/padding.length);return padding.repeat(repeats).substring(0,padLength)};
$jscomp.polyfill("String.prototype.padEnd",function(orig){if(orig)return orig;var padEnd=function(targetLength,opt_padString){var string=$jscomp.checkStringArgs(this,null,"padStart");var padLength=targetLength-string.length;return string+$jscomp.stringPadding(opt_padString,padLength)};return padEnd},"es8","es3");
$jscomp.polyfill("String.prototype.padStart",function(orig){if(orig)return orig;var padStart=function(targetLength,opt_padString){var string=$jscomp.checkStringArgs(this,null,"padStart");var padLength=targetLength-string.length;return $jscomp.stringPadding(opt_padString,padLength)+string};return padStart},"es8","es3");
$jscomp.polyfill("String.prototype.startsWith",function(orig){if(orig)return orig;var polyfill=function(searchString,opt_position){var string=$jscomp.checkStringArgs(this,searchString,"startsWith");searchString=searchString+"";var strLen=string.length;var searchLen=searchString.length;var i=Math.max(0,Math.min(opt_position|0,string.length));var j=0;while(j<searchLen&&i<strLen)if(string[i++]!=searchString[j++])return false;return j>=searchLen};return polyfill},"es6","es3");
$jscomp.polyfill("String.prototype.trimRight",function(orig){function polyfill(){return this.replace(/[\s\xa0]+$/,"")}return orig||polyfill},"es_2019","es3");$jscomp.polyfill("String.prototype.trimEnd",function(orig){return orig||String.prototype.trimRight},"es_2019","es3");$jscomp.polyfill("String.prototype.trimLeft",function(orig){function polyfill(){return this.replace(/^[\s\xa0]+/,"")}return orig||polyfill},"es_2019","es3");
$jscomp.polyfill("String.prototype.trimStart",function(orig){return orig||String.prototype.trimLeft},"es_2019","es3");$jscomp.arrayFromIterator=function(iterator){var i;var arr=[];while(!(i=iterator.next()).done)arr.push(i.value);return arr};$jscomp.arrayFromIterable=function(iterable){if(iterable instanceof Array)return iterable;else return $jscomp.arrayFromIterator($jscomp.makeIterator(iterable))};
$jscomp.inherits=function(childCtor,parentCtor){childCtor.prototype=$jscomp.objectCreate(parentCtor.prototype);childCtor.prototype.constructor=childCtor;if($jscomp.setPrototypeOf){var setPrototypeOf=$jscomp.setPrototypeOf;setPrototypeOf(childCtor,parentCtor)}else for(var p in parentCtor){if(p=="prototype")continue;if(Object.defineProperties){var descriptor=Object.getOwnPropertyDescriptor(parentCtor,p);if(descriptor)Object.defineProperty(childCtor,p,descriptor)}else childCtor[p]=parentCtor[p]}childCtor.superClass_=
parentCtor.prototype};
$jscomp.polyfill("WeakSet",function(NativeWeakSet){function isConformant(){if(!NativeWeakSet||!Object.seal)return false;try{var x=Object.seal({});var y=Object.seal({});var set=new NativeWeakSet([x]);if(!set.has(x)||set.has(y))return false;set.delete(x);set.add(y);return!set.has(x)&&set.has(y)}catch(err){return false}}if($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS){if(NativeWeakSet&&$jscomp.ES6_CONFORMANCE)return NativeWeakSet}else if(isConformant())return NativeWeakSet;var PolyfillWeakSet=function(opt_iterable){this.map_=
new WeakMap;if(opt_iterable){var iter=$jscomp.makeIterator(opt_iterable);var entry;while(!(entry=iter.next()).done){var item=entry.value;this.add(item)}}};PolyfillWeakSet.prototype.add=function(elem){this.map_.set(elem,true);return this};PolyfillWeakSet.prototype.has=function(elem){return this.map_.has(elem)};PolyfillWeakSet.prototype.delete=function(elem){return this.map_.delete(elem)};return PolyfillWeakSet},"es6","es3");
(function(){var Module=function(id,opt_exports){this.id=id;this.exports=opt_exports||{}};Module.prototype.exportAllFrom=function(other){var module=this;var define={};for(var key in other){if(key=="default"||key in module.exports||key in define)continue;define[key]={enumerable:true,get:function(key){return function(){return other[key]}}(key)}}$jscomp.global.Object.defineProperties(module.exports,define)};var CacheEntry=function(def,module,path){this.def=def;this.module=module;this.path=path;this.blockingDeps=
new Set};CacheEntry.prototype.load=function(){if(this.def){var def=this.def;this.def=null;callRequireCallback(def,this.module)}return this.module.exports};function callRequireCallback(callback,opt_module){var oldPath=currentModulePath;try{if(opt_module){currentModulePath=opt_module.id;callback.call(opt_module,createRequire(opt_module),opt_module.exports,opt_module)}else callback($jscomp.require)}finally{currentModulePath=oldPath}}var moduleCache=new Map;var currentModulePath="";function normalizePath(path){var components=
path.split("/");var i=0;while(i<components.length)if(components[i]==".")components.splice(i,1);else if(i&&components[i]==".."&&components[i-1]&&components[i-1]!="..")components.splice(--i,2);else i++;return components.join("/")}$jscomp.getCurrentModulePath=function(){return currentModulePath};function getCacheEntry(id){var cacheEntry=moduleCache.get(id);if(cacheEntry===undefined)throw new Error("Module "+id+" does not exist.");return cacheEntry}var ensureMap=new Map;var CallbackEntry=function(requireSet,
callback){this.requireSet=requireSet;this.callback=callback};function maybeNormalizePath(root,absOrRelativePath){if(absOrRelativePath.startsWith("./")||absOrRelativePath.startsWith("../"))return normalizePath(root+"/../"+absOrRelativePath);else return absOrRelativePath}function createRequire(opt_module){function require(absOrRelativePath){var absPath=absOrRelativePath;if(opt_module)absPath=maybeNormalizePath(opt_module.id,absPath);return getCacheEntry(absPath).load()}function requireEnsure(requires,
callback){if(currentModulePath)for(var i=0;i<requires.length;i++)requires[i]=maybeNormalizePath(currentModulePath,requires[i]);var blockingRequires=[];for(var i=0;i<requires.length;i++){var required=moduleCache.get(requires[i]);if(!required||required.blockingDeps.size)blockingRequires.push(requires[i])}if(blockingRequires.length){var requireSet=new Set(blockingRequires);var callbackEntry=new CallbackEntry(requireSet,callback);requireSet.forEach(function(require){var arr=ensureMap.get(require);if(!arr){arr=
[];ensureMap.set(require,arr)}arr.push(callbackEntry)})}else callback(require)}require.ensure=requireEnsure;return require}$jscomp.require=createRequire();$jscomp.hasModule=function(id){return moduleCache.has(id)};function markAvailable(absModulePath){var ensures=ensureMap.get(absModulePath);if(ensures){for(var i=0;i<ensures.length;i++){var entry=ensures[i];entry.requireSet.delete(absModulePath);if(!entry.requireSet.size){ensures.splice(i--,1);callRequireCallback(entry.callback)}}if(!ensures.length)ensureMap.delete(absModulePath)}}
$jscomp.registerModule=function(moduleDef,absModulePath,opt_shallowDeps){if(moduleCache.has(absModulePath))throw new Error("Module "+absModulePath+" has already been registered.");if(currentModulePath)throw new Error("Cannot nest modules.");var shallowDeps=opt_shallowDeps||[];for(var i=0;i<shallowDeps.length;i++)shallowDeps[i]=maybeNormalizePath(absModulePath,shallowDeps[i]);var blockingDeps=new Set;for(var i=0;i<shallowDeps.length;i++)getTransitiveBlockingDepsOf(shallowDeps[i]).forEach(function(transitive){blockingDeps.add(transitive)});
blockingDeps.delete(absModulePath);var cacheEntry=new CacheEntry(moduleDef,new Module(absModulePath),absModulePath);moduleCache.set(absModulePath,cacheEntry);blockingDeps.forEach(function(blocker){addAsBlocking(cacheEntry,blocker)});if(!blockingDeps.size)markAvailable(cacheEntry.module.id);removeAsBlocking(cacheEntry)};function getTransitiveBlockingDepsOf(moduleId){var cacheEntry=moduleCache.get(moduleId);var blocking=new Set;if(cacheEntry)cacheEntry.blockingDeps.forEach(function(dep){getTransitiveBlockingDepsOf(dep).forEach(function(transitive){blocking.add(transitive)})});
else blocking.add(moduleId);return blocking}var blockingModulePathToBlockedModules=new Map;function addAsBlocking(blocked,blocker){if(blocked.module.id!=blocker){var blockedModules=blockingModulePathToBlockedModules.get(blocker);if(!blockedModules){blockedModules=new Set;blockingModulePathToBlockedModules.set(blocker,blockedModules)}blockedModules.add(blocked);blocked.blockingDeps.add(blocker)}}function removeAsBlocking(cacheEntry){var blocked=blockingModulePathToBlockedModules.get(cacheEntry.module.id);
if(blocked){blockingModulePathToBlockedModules.delete(cacheEntry.module.id);blocked.forEach(function(blockedCacheEntry){blockedCacheEntry.blockingDeps.delete(cacheEntry.module.id);cacheEntry.blockingDeps.forEach(function(blocker){addAsBlocking(blockedCacheEntry,blocker)});if(!blockedCacheEntry.blockingDeps.size){removeAsBlocking(blockedCacheEntry);markAvailable(blockedCacheEntry.module.id)}})}}$jscomp.registerAndLoadModule=function(moduleDef,absModulePath,shallowDeps){$jscomp.require.ensure([absModulePath],
function(require){require(absModulePath)});$jscomp.registerModule(moduleDef,absModulePath,shallowDeps)};$jscomp.registerEs6ModuleExports=function(absModulePath,exports){if(moduleCache.has(absModulePath))throw new Error("Module at path "+absModulePath+" is already registered.");var entry=new CacheEntry(null,new Module(absModulePath,exports),absModulePath);moduleCache.set(absModulePath,entry);markAvailable(absModulePath)};$jscomp.clearModules=function(){moduleCache.clear()}})();
(function(){var globalRef=function(){if(typeof window!="undefined")return window;else if(this)return this;else if(typeof global!="undefined")return global;else if(typeof self!="undefined")return self;else throw Error("Cannot infer global object.");}();var localJscomp=$jscomp;var globalJscomp=globalRef["$jscomp"];if(localJscomp==globalJscomp)return;if(globalJscomp)for(var key in globalJscomp)localJscomp[key]=globalJscomp[key];globalRef["$jscomp"]=localJscomp})();var g;function aaa(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}}var aa="function"==typeof Object.defineProperties?Object.defineProperty:function(a,b,c){a!=Array.prototype&&a!=Object.prototype&&(a[b]=c.value)},ba="undefined"!=typeof window&&window===this?this:"undefined"!=typeof global&&null!=global?global:this;function ca(){ca=function(){};ba.Symbol||(ba.Symbol=baa)}function caa(a,b){this.a=a;aa(this,"description",{configurable:!0,writable:!0,value:b})}
caa.prototype.toString=function(){return this.a};var baa=function(){function a(c){if(this instanceof a)throw new TypeError("Symbol is not a constructor");return new caa("jscomp_symbol_"+(c||"")+"_"+b++,c)}var b=0;return a}();function da(){ca();var a=ba.Symbol.iterator;a||(a=ba.Symbol.iterator=ba.Symbol("Symbol.iterator"));"function"!=typeof Array.prototype[a]&&aa(Array.prototype,a,{configurable:!0,writable:!0,value:function(){return daa(aaa(this))}});da=function(){}}
function daa(a){da();a={next:a};a[ba.Symbol.iterator]=function(){return this};return a}function eaa(a){var b="undefined"!=typeof Symbol&&Symbol.iterator&&a[Symbol.iterator];return b?b.call(a):{next:aaa(a)}}var faa="function"==typeof Object.create?Object.create:function(a){function b(){}b.prototype=a;return new b},gaa;
if("function"==typeof Object.setPrototypeOf)gaa=Object.setPrototypeOf;else{var haa;a:{var iaa={Sn:!0},jaa={};try{jaa.__proto__=iaa;haa=jaa.Sn;break a}catch(a){}haa=!1}gaa=haa?function(a,b){a.__proto__=b;if(a.__proto__!==b)throw new TypeError(a+" is not extensible");return a}:null}var kaa=gaa;
function l(a,b){a.prototype=faa(b.prototype);a.prototype.constructor=a;if(kaa)kaa(a,b);else for(var c in b)if("prototype"!=c)if(Object.defineProperties){var d=Object.getOwnPropertyDescriptor(b,c);d&&Object.defineProperty(a,c,d)}else a[c]=b[c]}function laa(a,b){da();a instanceof String&&(a+="");var c=0,d={next:function(){if(c<a.length){var e=c++;return{value:b(e,a[e]),done:!1}}d.next=function(){return{done:!0,value:void 0}};return d.next()}};d[Symbol.iterator]=function(){return d};return d}
function ea(a,b){if(b){var c=ba;a=a.split(".");for(var d=0;d<a.length-1;d++){var e=a[d];e in c||(c[e]={});c=c[e]}a=a[a.length-1];d=c[a];b=b(d);b!=d&&null!=b&&aa(c,a,{configurable:!0,writable:!0,value:b})}}ea("Array.prototype.values",function(a){return a?a:function(){return laa(this,function(b,c){return c})}});function fa(a,b){return Object.prototype.hasOwnProperty.call(a,b)}
ea("WeakMap",function(a){function b(m){this.a=(k+=Math.random()+1).toString();if(m){m=eaa(m);for(var p;!(p=m.next()).done;)p=p.value,this.set(p[0],p[1])}}function c(){}function d(m){var p=typeof m;return"object"===p&&null!==m||"function"===p}function e(m){if(!fa(m,h)){var p=new c;aa(m,h,{value:p})}}function f(m){var p=Object[m];p&&(Object[m]=function(t){if(t instanceof c)return t;e(t);return p(t)})}if(function(){if(!a||!Object.seal)return!1;try{var m=Object.seal({}),p=Object.seal({}),t=new a([[m,
2],[p,3]]);if(2!=t.get(m)||3!=t.get(p))return!1;t.delete(m);t.set(p,4);return!t.has(m)&&4==t.get(p)}catch(v){return!1}}())return a;var h="$jscomp_hidden_"+Math.random();f("freeze");f("preventExtensions");f("seal");var k=0;b.prototype.set=function(m,p){if(!d(m))throw Error("Invalid WeakMap key");e(m);if(!fa(m,h))throw Error("WeakMap key fail: "+m);m[h][this.a]=p;return this};b.prototype.get=function(m){return d(m)&&fa(m,h)?m[h][this.a]:void 0};b.prototype.has=function(m){return d(m)&&fa(m,h)&&fa(m[h],
this.a)};b.prototype.delete=function(m){return d(m)&&fa(m,h)&&fa(m[h],this.a)?delete m[h][this.a]:!1};return b});
ea("Map",function(a){function b(){var k={};return k.Ef=k.next=k.head=k}function c(k,m){var p=k.a;return daa(function(){if(p){for(;p.head!=k.a;)p=p.Ef;for(;p.next!=p.head;)return p=p.next,{done:!1,value:m(p)};p=null}return{done:!0,value:void 0}})}function d(k,m){var p=m&&typeof m;"object"==p||"function"==p?f.has(m)?p=f.get(m):(p=""+ ++h,f.set(m,p)):p="p_"+m;var t=k.b[p];if(t&&fa(k.b,p))for(k=0;k<t.length;k++){var v=t[k];if(m!==m&&v.key!==v.key||m===v.key)return{id:p,list:t,index:k,vd:v}}return{id:p,
list:t,index:-1,vd:void 0}}function e(k){this.b={};this.a=b();this.size=0;if(k){k=eaa(k);for(var m;!(m=k.next()).done;)m=m.value,this.set(m[0],m[1])}}if(function(){if(!a||"function"!=typeof a||!a.prototype.entries||"function"!=typeof Object.seal)return!1;try{var k=Object.seal({x:4}),m=new a(eaa([[k,"s"]]));if("s"!=m.get(k)||1!=m.size||m.get({x:4})||m.set({x:4},"t")!=m||2!=m.size)return!1;var p=m.entries(),t=p.next();if(t.done||t.value[0]!=k||"s"!=t.value[1])return!1;t=p.next();return t.done||4!=t.value[0].x||
"t"!=t.value[1]||!p.next().done?!1:!0}catch(v){return!1}}())return a;da();var f=new WeakMap;e.prototype.set=function(k,m){k=0===k?0:k;var p=d(this,k);p.list||(p.list=this.b[p.id]=[]);p.vd?p.vd.value=m:(p.vd={next:this.a,Ef:this.a.Ef,head:this.a,key:k,value:m},p.list.push(p.vd),this.a.Ef.next=p.vd,this.a.Ef=p.vd,this.size++);return this};e.prototype.delete=function(k){k=d(this,k);return k.vd&&k.list?(k.list.splice(k.index,1),k.list.length||delete this.b[k.id],k.vd.Ef.next=k.vd.next,k.vd.next.Ef=k.vd.Ef,
k.vd.head=null,this.size--,!0):!1};e.prototype.clear=function(){this.b={};this.a=this.a.Ef=b();this.size=0};e.prototype.has=function(k){return!!d(this,k).vd};e.prototype.get=function(k){return(k=d(this,k).vd)&&k.value};e.prototype.entries=function(){return c(this,function(k){return[k.key,k.value]})};e.prototype.keys=function(){return c(this,function(k){return k.key})};e.prototype.values=function(){return c(this,function(k){return k.value})};e.prototype.forEach=function(k,m){for(var p=this.entries(),
t;!(t=p.next()).done;)t=t.value,k.call(m,t[1],t[0],this)};e.prototype[Symbol.iterator]=e.prototype.entries;var h=0;return e});
var maa=function(){function a(){function c(){}new c;Reflect.construct(c,[],function(){});return new c instanceof c}if("undefined"!=typeof Reflect&&Reflect.construct){if(a())return Reflect.construct;var b=Reflect.construct;return function(c,d,e){c=b(c,d);e&&Reflect.setPrototypeOf(c,e.prototype);return c}}return function(c,d,e){void 0===e&&(e=c);e=faa(e.prototype||Object.prototype);return Function.prototype.apply.call(c,e,d)||e}}();ea("Reflect.construct",function(){return maa});
var naa="function"==typeof Object.assign?Object.assign:function(a,b){for(var c=1;c<arguments.length;c++){var d=arguments[c];if(d)for(var e in d)fa(d,e)&&(a[e]=d[e])}return a};ea("Object.assign",function(a){return a||naa});var ha=this||self,oaa="closure_uid_"+(1E9*Math.random()>>>0),paa=0;function ia(a,b,c,d){d=d?d(b):b;return Object.prototype.hasOwnProperty.call(a,d)?a[d]:a[d]=c(b)}
function qaa(a){return ia(a.prototype,"$$generatedClassName",function(){return"Class$obf_"+{valueOf:function(){return++raa}}})}var raa=1E3;function n(){}n.prototype.J=function(a){return q(this,a)};n.prototype.P=function(){return ja(this)};n.prototype.toString=function(){return r(ka(la(ma(this))))+"@"+r(na(this.P()))};function saa(a){return null!=a}function oa(){}l(oa,n);function pa(a){qa(a);ra(a)}function sa(a,b){qa(a);a.b=b;ra(a)}function ta(a,b,c){qa(a);a.g=c;a.b=b;ra(a)}
function ua(a,b){qa(a);if(a.g=b)a.b=b.toString();ra(a)}oa.prototype.a=function(a){this.s=a;if(a instanceof Object)try{a.Rn=this}catch(b){}};function taa(a,b){if(q(b,a))throw va("Exception can not suppress itself.").s;a.o[a.o.length]=b}function ra(a){a.s instanceof Error&&(Error.captureStackTrace?Error.captureStackTrace(a.s):a.s.stack=Error().stack);a.c=null}oa.prototype.toString=function(){var a=ka(la(ma(this))),b=this.b;return null==b?a:r(a)+": "+r(b)};
function wa(a){if(null!=a){var b=a.Rn;if(null!=b)return b}a instanceof TypeError?(b=new xa,sa(b,r(a)),za(b),b.f=a,b.a(new TypeError(b)),a=b):(b=new Aa,sa(b,r(a)),za(b),b.f=a,b.a(Error(b)),a=b);return a}function qa(a){a.o=Ba([0],oa,uaa,oa.a);a.c=Ba([0],Ca,Da,Ca.a)}function uaa(a){return a instanceof oa}oa.prototype.ba=!0;function Ea(){}l(Ea,oa);function Fa(a){return a instanceof Ea}function vaa(){}l(vaa,Ea);function Ga(a){return a instanceof vaa}function Ha(){}l(Ha,Ea);
function Ia(a){var b=new Ha;sa(b,a);b.a(Error(b));return b}function Ja(a,b){var c=new Ha;ta(c,a,b);c.a(Error(c));return c}function waa(a){var b=new Ha;ua(b,a);b.a(Error(b));return b}function Ka(){}l(Ka,Ha);function xaa(){var a=new Ka;pa(a);a.a(Error(a));return a}function La(a){var b=new Ka;sa(b,a);b.a(Error(b));return b}function q(a,b){return a===b||null==a&&null==b}function ma(a){return a.constructor}function Ma(a,b){this.b=a;this.a=b}l(Ma,n);
function ka(a){var b=qaa(a.b);0!=a.a&&(b="L"+r(b)+";");return r(yaa("[",a.a))+r(b)}function zaa(a){a=r(qaa(a.b))+r(yaa("[]",a.a));return Na(a,a.lastIndexOf(".")+1)}Ma.prototype.toString=function(){return"class "+r(ka(this))};function yaa(a,b){for(var c="",d=0;d<b;d++)c=r(c)+r(a);return c}Ma.prototype.ba=!0;function la(a,b){var c=b||0;return ia(a.prototype,"$$class/"+c,function(){return new Ma(a,c)})}function ja(a){return a.lm||(Object.defineProperties(a,{lm:{value:++Aaa,enumerable:!1}}),a.lm)}
var Aaa=0;function Oa(){}l(Oa,Ha);function Baa(a){var b=new Oa;sa(b,a);b.a(Error(b));return b}function Caa(){}l(Caa,Ka);function Daa(a){var b=new Caa;sa(b,a);b.a(Error(b));return b}function Pa(){}l(Pa,oa);function Qa(a){var b=new Pa;sa(b,a);b.a(Error(b));return b}function Ra(a){return a instanceof Pa}function Sa(a,b){this.a=a|0;this.b=b|0}function Ua(a){return 4294967296*a.b+(a.a>>>0)}g=Sa.prototype;
g.toString=function(a){a=a||10;if(2>a||36<a)throw Error("radix out of range: "+a);var b=this.b>>21;if(0==b||-1==b&&(0!=this.a||-2097152!=this.b))return b=Ua(this),10==a?""+b:b.toString(a);b=14-(a>>2);var c=Math.pow(a,b),d=Va(c,c/4294967296);c=Xa(this,d);d=Math.abs(Ua(Ya(this,Za(c,d))));var e=10==a?""+d:d.toString(a);e.length<b&&(e="0000000000000".substr(e.length-b)+e);d=Ua(c);return(10==a?d:d.toString(a))+e};function $a(a){return 0==a.a&&0==a.b}g.J=function(a){return this.a==a.a&&this.b==a.b};
function ab(a,b){return a.b==b.b?a.a==b.a?0:a.a>>>0>b.a>>>0?1:-1:a.b>b.b?1:-1}function bb(a){var b=~a.a+1|0;return Va(b,~a.b+!b|0)}g.add=function(a){var b=this.b>>>16,c=this.b&65535,d=this.a>>>16,e=a.b>>>16,f=a.b&65535,h=a.a>>>16;a=(this.a&65535)+(a.a&65535);h=(a>>>16)+(d+h);d=h>>>16;d+=c+f;b=(d>>>16)+(b+e)&65535;return Va((h&65535)<<16|a&65535,b<<16|d&65535)};function Ya(a,b){return a.add(bb(b))}
function Za(a,b){if($a(a))return a;if($a(b))return b;var c=a.b>>>16,d=a.b&65535,e=a.a>>>16;a=a.a&65535;var f=b.b>>>16,h=b.b&65535,k=b.a>>>16;b=b.a&65535;var m=a*b;var p=(m>>>16)+e*b;var t=p>>>16;p=(p&65535)+a*k;t+=p>>>16;t+=d*b;var v=t>>>16;t=(t&65535)+e*k;v+=t>>>16;t=(t&65535)+a*h;v=v+(t>>>16)+(c*b+d*k+e*h+a*f)&65535;return Va((p&65535)<<16|m&65535,v<<16|t&65535)}
function Xa(a,b){if($a(b))throw Error("division by zero");if(0>a.b){if(a.J(cb)){if(b.J(db)||b.J(Eaa))return cb;if(b.J(cb))return db;var c=1;if(0==c)c=a;else{var d=a.b;c=32>c?Va(a.a>>>c|d<<32-c,d>>c):Va(d>>c-32,0<=d?0:-1)}c=eb(Xa(c,b),1);if(c.J(fb))return 0>b.b?db:Eaa;a=Ya(a,Za(b,c));return c.add(Xa(a,b))}return 0>b.b?Xa(bb(a),bb(b)):bb(Xa(bb(a),b))}if($a(a))return fb;if(0>b.b)return b.J(cb)?fb:bb(Xa(a,bb(b)));for(d=fb;0<=ab(a,b);){c=Math.max(1,Math.floor(Ua(a)/Ua(b)));var e=Math.ceil(Math.log(c)/
Math.LN2);e=48>=e?1:Math.pow(2,e-48);for(var f=gb(c),h=Za(f,b);0>h.b||0<ab(h,a);)c-=e,f=gb(c),h=Za(f,b);$a(f)&&(f=db);d=d.add(f);a=Ya(a,h)}return d}function Faa(a){return Va(~a.a,~a.b)}g.and=function(a){return Va(this.a&a.a,this.b&a.b)};g.or=function(a){return Va(this.a|a.a,this.b|a.b)};g.xor=function(a){return Va(this.a^a.a,this.b^a.b)};function eb(a,b){b&=63;if(0==b)return a;var c=a.a;return 32>b?Va(c<<b,a.b<<b|c>>>32-b):Va(0,c<<b-32)}
function Gaa(a,b){b&=63;if(0==b)return a;var c=a.b;return 32>b?Va(a.a>>>b|c<<32-b,c>>>b):32==b?Va(c,0):Va(c>>>b-32,0)}function hb(a){a|=0;return-128<=a&&128>a?Haa(a):new Sa(a,0>a?-1:0)}function gb(a){return 0<a?0x7fffffffffffffff<=a?Iaa:new Sa(a,a/4294967296):0>a?-9223372036854775808>=a?cb:bb(new Sa(-a,-a/4294967296)):fb}function Va(a,b){return new Sa(a,b)}var Jaa={};function Haa(a){return ia(Jaa,a,function(b){return new Sa(b,0>b?-1:0)})}
var fb=Va(0,0),db=Va(1,0),Eaa=Va(-1,-1),Iaa=Va(4294967295,2147483647),cb=Va(0,2147483648);function Kaa(){}l(Kaa,Pa);function ib(){var a=new Kaa;pa(a);a.a(Error(a));return a}function jb(a){var b=new Kaa,c=r(a);ta(b,c,uaa(a)?a:null);b.a(Error(b));return b}function kb(){}l(kb,Ha);function lb(){var a=new kb;pa(a);a.a(Error(a));return a}function va(a){var b=new kb;sa(b,a);b.a(Error(b));return b}function Laa(a,b){var c=new kb;ta(c,a,b);c.a(Error(c));return c}function mb(a){return a instanceof kb}
function nb(){}l(nb,Ha);function ob(){var a=new nb;pa(a);a.a(Error(a));return a}function pb(a){var b=new nb;sa(b,a);b.a(Error(b));return b}function Aa(){}l(Aa,Ha);Aa.prototype.a=function(a){Ha.prototype.a.call(this,"__noinit__"===this.f?a:this.f)};function za(a){a.f="__noinit__"}function xa(){}l(xa,Aa);function qb(){var a=new xa;pa(a);za(a);a.a(new TypeError(a));return a}function rb(a){var b=new xa;sa(b,a);za(b);b.a(new TypeError(b));return b}function sb(a){return a instanceof xa}
function tb(a){this.a=a}l(tb,n);function ub(){}l(ub,Ha);function vb(){var a=new ub;pa(a);a.a(Error(a));return a}function wb(a){var b=new ub;sa(b,a);b.a(Error(b));return b}function xb(a){return a instanceof ub}function yb(a){return new Maa(a)}function Maa(a){this.a=a}l(Maa,n);Maa.prototype.Ob=function(a){var b=this.a;b(a)};function zb(a,b){for(;a.i();)b.Ob(a.j())}function Naa(){}function Oaa(){return!0}Naa.prototype.kf=!0;function Ab(a){return hb(a|0)}function Paa(a,b){return Xa(a,b)}
function Qaa(a,b){return a.J(b)}function Bb(a){return 0<=ab(a,hb(0))}function Db(a,b){return Ya(a,b)}function Eb(a,b){return a.or(b)}function Raa(a,b){return Za(a,b)}function Fb(a){return Math.max(Math.min(a,2147483647),-2147483648)|0}function Gb(){}var Saa;l(Gb,n);Gb.prototype.ba=!0;function Taa(){}l(Taa,Gb);function Uaa(a,b){return a<b?-1:a>b?1:a==b?0==a?Uaa(1/a,1/b):0:isNaN(a)?isNaN(b)?0:1:-1}function Hb(a){return!isNaN(a)&&!isFinite(a)}
function Ib(a){Saa||(Saa=/^\s*[+-]?(NaN|Infinity|((\d+\.?\d*)|(\.\d+))([eE][+-]?\d+)?[dDfF]?)\s*$/);if(!Saa.test(a))throw Jb(a).s;return parseFloat(a)}var Vaa;function Waa(){Waa=function(){};Vaa=Ba([256],Lb,Mb,Lb.a)}function Nb(a,b){return 0<ab(a,b)?a:b}function Xaa(a){return 0==a||isNaN(a)?a:0>a?-1:1}function Ob(){}function Pb(){return!0}Ob.prototype.kf=!0;function Qb(){}function Yaa(){return!0}var Zaa=hb(0);Qb.prototype.kf=!0;function Lb(){this.a=hb(0)}l(Lb,Gb);
function $aa(a,b){return 0>ab(a,b)?-1:0<ab(a,b)?1:0}function aba(a){if(0<ab(a,Ab(-129))&&0>ab(a,hb(128))){var b=a.a+128,c=(Waa(),Vaa)[b];c||(c=Vaa[b]=bba(a));return c}return bba(a)}function Rb(a,b){var c=1<<b;if(0>=ab(Ab(-2147483648),a)&&0>=ab(a,Ab(2147483647)))return cba(a.a,c);--c;var d=(64/b|0)+1,e=Ba([d],Ob,Pb,0),f=d;do{var h=--f,k=a.a&c,m=k-10;e[h]=(0>m?48+k:97+m)&65535;a=Gaa(a,b)}while(!a.J(hb(0)));return Tb(e,f,d-f)}function bba(a){var b=new Lb;b.a=a;return b}g=Lb.prototype;g.Em=function(){return Ua(this.a)};
g.J=function(a){return Mb(a)&&a.a.J(this.a)};g.P=function(){return this.a.a};g.Mb=function(){return this.a.a};g.Pk=function(){return this.a};g.toString=function(){return""+this.a};g.R=function(a){return $aa(this.a,a.a)};function Mb(a){return a instanceof Lb}var Ub=Va(-1,2147483647),dba=Va(0,-2147483648);function eba(){}function fba(){return u(function(a){return a})}function u(a){return new Xb(a)}function gba(a){return null!=a&&!!a.Tc}eba.prototype.Tc=!0;function Xb(a){this.a=a}l(Xb,n);
Xb.prototype.f=function(a){var b;return b=this.a,b(a)};Xb.prototype.Tc=!0;function Yb(a){this.a=a}l(Yb,n);function hba(a,b){var c;return c=a.a,c(b)}function Zb(a,b){return new iba(function(c,d){return b.Oa(a.f(c),a.f(d))})}function $b(a){return new jba(function(b,c){return kba(hba(a,b),hba(a,c))})}function ac(a,b){return new lba(function(c,d){var e=a.Oa(c,d);return 0!=e?e:b.Oa(c,d)})}function bc(a,b){return a.ic(Zb(b,ec()))}function lba(a){this.a=a}l(lba,n);g=lba.prototype;
g.Oa=function(a,b){var c;return c=this.a,c(a,b)};g.ac=function(){return gc(this)};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.ba=!0;function iba(a){this.a=a}l(iba,n);g=iba.prototype;g.Oa=function(a,b){var c;return c=this.a,c(a,b)};g.ac=function(){return gc(this)};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.ba=!0;function jba(a){this.a=a}l(jba,n);g=jba.prototype;g.Oa=function(a,b){var c;return c=this.a,c(a,b)};g.ac=function(){return gc(this)};
g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.ba=!0;function hc(a){this.a=a}l(hc,n);hc.prototype.Oa=function(a,b){var c;return c=this.a,c(a,b)};hc.prototype.ac=function(){return gc(this)};hc.prototype.ic=function(a){return ac(this,a)};hc.prototype.oc=function(a){return bc(this,a)};function ic(a,b){var c=typeof a;if("number"==c)a=Uaa(a,b);else if("boolean"==c)a=a==b?0:a?1:-1;else{var d;"string"==c?d=jc(a,b):d=a.R(b);a=d}return a}function lc(){}l(lc,n);g=lc.prototype;
g.ac=function(){return mc(),mba};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.Oa=function(a,b){return ic(a,b)};g.ba=!0;function nba(){}l(nba,n);g=nba.prototype;g.ac=function(){return mc(),oba};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.Oa=function(a,b){return ic(b,a)};g.ba=!0;var mba,oba,pba;function ec(){mc();return oba}function nc(a){mc();return a?a:pba}function mc(){mc=function(){};pba=new lc;oba=new lc;mba=new nba}function qba(){}
l(qba,n);function gc(a){var b=new qba;b.a=a;return b}g=qba.prototype;g.Oa=function(a,b){return this.a.Oa(b,a)};g.ac=function(){return this.a};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.ba=!0;function oc(a,b){for(;a.wb(b););}function pc(a,b){return 0!=(a.sd()&b)}function qc(){}function sc(){return!0}qc.prototype.kf=!0;function rba(){}function sba(){return!0}rba.prototype.kf=!0;function tba(){}function uba(){return!0}tba.prototype.kf=!0;function tc(){}
function uc(a,b){for(a=a.h();a.i();){var c=a.j();b.Ob(c)}}function wc(a){a=a.h();var b=new xc;b.a=a;b.b=0;b.c=Ub;return b}function Ac(a){return null!=a&&!!a.Wa}tc.prototype.Wa=!0;function Bc(a){this.a=a}l(Bc,n);Bc.prototype.h=function(){var a;return a=this.a,a()};Bc.prototype.Z=function(a){uc(this,a)};Bc.prototype.W=function(){return wc(this)};Bc.prototype.Wa=!0;function Cc(a){this.a=a}l(Cc,n);Cc.prototype.Ei=function(a){var b=this.a;b(a)};Cc.prototype.Wj=!0;
function vba(a,b){null!=b&&b.Wj?wba(a,b):wba(a,new Cc(function(c){b.Ob(Dc(c))}))}function Ec(a,b){return null!=b&&b.Wj?a.Bf(b):a.Bf(new Cc(function(c){b.Ob(Dc(c))}))}function Fc(a,b){null!=b&&b.Wj?a.bg(b):a.bg(new Cc(function(c){b.Ob(Dc(c))}))}function Gc(){this.f=this.b=this.a=0}l(Gc,n);g=Gc.prototype;g.sd=function(){return this.f};g.nd=function(){return Ab(this.b-this.a)};g.bg=function(a){for(;this.a<this.b;){var b=this.a++;a.Ei(this.c[b])}};
g.Bf=function(a){if(this.a<this.b){var b=this.a++;a.Ei(this.c[b]);return!0}return!1};g.da=function(a){oc(this,a)};g.gc=function(a){return pc(this,a)};function xba(){this.a=!1}l(xba,n);g=xba.prototype;g.Ob=function(a){this.b=a};g.i=function(){this.a||(this.a=this.c.wb(this));return this.a};g.j=function(){Ic(this.i());this.a=!1;var a=this.b;this.b=null;return a};g.da=function(a){zb(this,a)};g.ka=function(){throw vb().s;};function Jc(){this.f=0;this.g=hb(0)}l(Jc,n);
function Kc(a,b,c){a.g=b;a.f=0!=(c&64)?c|16384:c}Jc.prototype.sd=function(){return this.f};Jc.prototype.nd=function(){return this.g};Jc.prototype.da=function(a){oc(this,a)};Jc.prototype.gc=function(a){return pc(this,a)};function Lc(){}var yba,zba;l(Lc,n);g=Lc.prototype;g.sd=function(){return 16448};g.nd=function(){return hb(0)};g.bg=function(){};g.Bf=function(){return!1};g.da=function(a){oc(this,a)};g.gc=function(a){return pc(this,a)};function Aba(){Aba=function(){};yba=new Nc;zba=new Oc}
function Oc(){}l(Oc,Lc);Oc.prototype.da=function(a){Fc(this,a)};Oc.prototype.wb=function(a){return Ec(this,a)};Oc.prototype.gc=function(a){return pc(this,a)};function Nc(){}l(Nc,Lc);Nc.prototype.gc=function(a){return pc(this,a)};Nc.prototype.bg=function(a){this.da(a)};Nc.prototype.da=function(a){Lc.prototype.bg.call(this,a)};Nc.prototype.wb=function(a){return Lc.prototype.Bf.call(this,a)};function Pc(){Gc.call(this)}l(Pc,Gc);Pc.prototype.da=function(a){Fc(this,a)};
Pc.prototype.wb=function(a){return Ec(this,a)};Pc.prototype.gc=function(a){return pc(this,a)};function Bba(){this.b=0;this.a=!1}l(Bba,n);function Cba(a){var b=new Bba;b.a=!1;b.c=a;return b}g=Bba.prototype;g.Ei=function(a){this.b=a};g.i=function(){this.a||(this.a=this.c.Bf(this));return this.a};function Dba(a){Ic(a.i());a.a=!1;return a.b}function wba(a,b){for(;a.i();)b.Ei(Dba(a))}g.da=function(a){vba(this,a)};g.j=function(){return Dc(Dba(this))};g.ka=function(){throw vb().s;};g.Wj=!0;
function Qc(){Jc.call(this)}l(Qc,Jc);Qc.prototype.da=function(a){Fc(this,a)};Qc.prototype.wb=function(a){return Ec(this,a)};Qc.prototype.bg=function(a){for(;this.Bf(a););};Qc.prototype.gc=function(a){return pc(this,a)};function xc(){this.b=0;this.c=hb(0)}l(xc,n);function Sc(a,b){var c=new xc;c.f=a;c.b=0==(b&4096)?b|16448:b;return c}function Iba(a,b,c){var d=new xc;d.a=a;d.b=0==(c&4096)?c|16448:c;d.c=b;return d}g=xc.prototype;g.sd=function(){return this.b};g.nd=function(){Jba(this);return this.c};
g.da=function(a){Jba(this);this.a.da(a)};g.wb=function(a){Jba(this);return this.a.i()?(a.Ob(this.a.j()),!0):!1};function Jba(a){a.a||(a.a=a.f.h(),a.c=Ab(a.f.w()))}g.gc=function(a){return pc(this,a)};function Uc(a){return new Kba(a)}function Kba(a){this.a=a}l(Kba,n);Kba.prototype.Na=function(){var a;return a=this.a,a()};function Vc(){}function Lba(){return!0}Vc.prototype.kf=!0;function w(){}function Wc(){return!0}w.prototype.kf=!0;function Xc(a,b){return q(a,b)||null!=a&&Yc(a,b)}
function Zc(a){return null!=a?$c(a):0}function ad(a){return new bd(a)}function dd(a){return ad(function(b){return!a.Ca(b)})}function bd(a){this.a=a}l(bd,n);bd.prototype.Ca=function(a){var b;return b=this.a,b(a)};bd.prototype.cb=function(){return dd(this)};function ed(a,b){var c=!1;for(a=a.h();a.i();)b.Ca(a.j())&&(a.ka(),c=!0);return c}function fd(a){a=a.W();return hd(null,a)}function jd(a){return null!=a&&!!a.yb}function kd(a,b){var c=a.qc();md(c,b);for(b=0;b<c.length;b++)a.Ub(b,c[b])}
function nd(a){return Sc(a,16)}function od(a){return null!=a&&!!a.Xg}function pd(a){return null!=a&&!!a.Je}function qd(){this.a=this.b=0}l(qd,n);qd.prototype.i=function(){return this.b<this.c.a.length};qd.prototype.j=function(){this.i();this.a=this.b++;return this.c.a[this.a]};qd.prototype.ka=function(){this.c.Ya(this.b=this.a);this.a=-1};qd.prototype.da=function(a){zb(this,a)};function sd(a,b){a.Bh=b.Bh;return a}function ud(a,b){return sd(a.slice(0,b),a)}
function vd(a,b,c,d,e,f){q(a,c)&&(a=a.slice(b,b+e),b=0);var h=b;for(b+=e;h<b;){var k=Math.min(h+1E4,b);e=k-h;h=a.slice(h,k);h.splice(0,0,d,f?e:0);Array.prototype.splice.apply(c,h);h=k;d+=e}}function wd(){}l(wd,n);g=wd.prototype;g.add=function(){throw wb("Add not supported on this collection").s;};g.na=function(a){var b=!1;for(a=a.h();a.i();){var c=a.j();b=!!(+b|+this.add(c))}return b};g.ia=function(){for(var a=this.h();a.i();)a.j(),a.ka()};g.B=function(a){return Mba(this,a,!1)};
g.Db=function(a){for(a=a.h();a.i();){var b=a.j();if(!this.B(b))return!1}return!0};g.G=function(){return 0==this.w()};g.ra=function(a){return Mba(this,a,!0)};g.Qb=function(a){for(var b=!1,c=this.h();c.i();){var d=c.j();a.B(d)&&(c.ka(),b=!0)}return b};g.qc=function(){return this.ob(Array(this.w()))};g.ob=function(a){var b=this.w();a.length<b&&(a=sd(Array(b),a));for(var c=a,d=this.h(),e=0;e<b;++e)xd(c,e,d.j());a.length>b&&(a[b]=null);return a};
g.toString=function(){for(var a=yd("[","]"),b=this.h();b.i();){var c=b.j();zd(a,q(c,this)?"(this Collection)":r(c))}return a.toString()};function Mba(a,b,c){for(a=a.h();a.i();){var d=a.j();if(Xc(b,d))return c&&a.ka(),!0}return!1}g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;function Bd(){}l(Bd,wd);g=Bd.prototype;g.add=function(a){this.lc(this.w(),a);return!0};
g.lc=function(){throw wb("Add not supported on this list").s;};g.ia=function(){this.Vl(0,this.w())};g.J=function(a){if(q(a,this))return!0;if(!od(a)||this.w()!=a.w())return!1;a=a.h();for(var b=this.h();b.i();){var c=b.j(),d=a.j();if(!Xc(c,d))return!1}return!0};g.P=function(){Cd();for(var a=1,b=this.h();b.i();){var c=b.j();a=31*a+Zc(c);a|=0}return a};g.indexOf=function(a){for(var b=0,c=this.w();b<c;++b)if(Xc(a,this.F(b)))return b;return-1};g.h=function(){var a=new Dd;a.c=this;a.a=0;a.b=-1;return a};
g.lastIndexOf=function(a){for(var b=this.w()-1;-1<b;--b)if(Xc(a,this.F(b)))return b;return-1};g.ae=function(){return this.Bb(0)};g.Bb=function(a){var b=new Nba;b.f=this;b.c=this;b.a=0;b.b=-1;this.w();b.a=a;return b};g.Ya=function(){throw wb("Remove not supported on this list").s;};g.Ub=function(){throw wb("Set not supported on this list").s;};
g.Nb=function(a,b){var c=new Oba,d=this.w();if(0>a||b>d)throw La("fromIndex: "+a+", toIndex: "+b+", size: "+d).s;if(a>b)throw va("fromIndex: "+a+" > toIndex: "+b).s;c.c=this;c.a=a;c.b=b-a;return c};g.Vl=function(a,b){for(var c=this.Bb(a);a<b;++a)c.j(),c.ka()};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Xg=!0;function Gd(){}l(Gd,Bd);
function x(){var a=new Gd;a.a=[];return a}function Hd(a){var b=new Gd;b.a=[];a=a.qc();vd(a,0,b.a,0,a.length,!1);return b}function Jd(){var a=new Gd;a.a=[];return a}g=Gd.prototype;g.add=function(a){this.a[this.a.length]=a;return!0};g.lc=function(a,b){this.a.splice(a,0,b)};g.na=function(a){a=a.qc();if(0==a.length)return!1;vd(a,0,this.a,this.a.length,a.length,!1);return!0};g.ia=function(){this.a=[]};g.B=function(a){return-1!=this.indexOf(a)};g.F=function(a){return this.a[a]};
g.indexOf=function(a){a:{for(var b=0;b<this.a.length;++b)if(Xc(a,this.a[b])){a=b;break a}a=-1}return a};g.h=function(){var a=new qd;a.c=this;a.b=0;a.a=-1;return a};g.Z=function(a){for(var b=this.a,c=0;c<b.length;c++)a.Ob(b[c])};g.G=function(){return 0==this.a.length};g.lastIndexOf=function(a){a:{for(var b=this.w()-1;0<=b;--b)if(Xc(a,this.a[b])){a=b;break a}a=-1}return a};g.Ya=function(a){var b=this.F(a);this.a.splice(a,1);return b};g.ra=function(a){a=this.indexOf(a);if(-1==a)return!1;this.Ya(a);return!0};
g.ca=function(a){for(var b=null,c=0,d=0;d<this.a.length;++d){var e=this.a[d];a.Ca(e)?b||(b=ud(this.a,d),c=d):b&&xd(b,c++,e)}if(!b)return!1;this.a=b;return!0};g.Ub=function(a,b){var c=this.F(a);this.a[a]=b;return c};g.w=function(){return this.a.length};g.nb=function(a){var b=this.a,c=this.a.length;Kd(0,c,b.length);Pba(b,c,a)};g.qc=function(){return ud(this.a,this.a.length)};
g.ob=function(a){var b=this.a.length;a.length<b&&(a=sd(Array(b),a));for(var c=0;c<b;++c)a[c]=this.a[c];a.length>b&&(a[b]=null);return a};g.Vl=function(a,b){this.a.splice(a,b-a)};g.W=function(){return nd(this)};g.T=function(){return fd(this)};g.Wa=!0;g.yb=!0;g.Xg=!0;g.Je=!0;g.ba=!0;function Qba(){}l(Qba,Bd);g=Qba.prototype;g.B=function(){return!1};g.F=function(){return null};g.h=function(){return Rba()};g.ae=function(){Cd();return Sba(),Tba};g.w=function(){return 0};g.nb=function(a){kd(this,a)};
g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Je=!0;g.ba=!0;function Uba(){}l(Uba,Ha);function Ld(){var a=new Uba;pa(a);a.a(Error(a));return a}function Md(a){return a instanceof Uba}function Vba(){}var Tba;l(Vba,n);g=Vba.prototype;g.te=function(){throw vb().s;};g.i=function(){return!1};g.Ec=function(){return!1};g.j=function(){throw Ld().s;};g.pd=function(){return 0};g.Gc=function(){throw Ld().s;};g.Od=function(){return-1};
g.ka=function(){throw ob().s;};g.Ed=function(){throw ob().s;};g.da=function(a){zb(this,a)};function Sba(){Sba=function(){};Tba=new Vba}function Nd(){}function Od(a){return null!=a&&!!a.tg}Nd.prototype.tg=!0;function Qd(a){return Sc(a,1)}function Rd(a){return null!=a&&!!a.Sc}function Sd(a){return new Wba(a)}function Wba(a){this.a=a}l(Wba,n);function Td(a){this.b=a}l(Td,n);Td.prototype.a=function(a,b){var c;return c=this.b,c(a,b)};
function Ud(a,b,c){var d=a.get(b);null==d&&(d=c.f(b),null!=d&&a.C(b,d));return d}function Vd(a,b){for(a=a.X().h();a.i();){var c=a.j(),d=c.M();c=c.N();var e=b.a;e(d,c)}}function Xd(a,b,c){var d=a.get(b);return null!=d||a.V(b)?d:c}function Yd(a,b,c,d){var e=a.get(b);c=null==e?c:d.a(e,c);null==c?a.za(b):a.C(b,c)}function $d(a,b,c){var d=a.get(b);return null!=d?d:a.C(b,c)}function ae(a,b,c){var d=a.get(b);if(!Xc(d,c)||null==d&&!a.V(b))return!1;a.za(b);return!0}
function ee(a,b){for(a=a.X().h();a.i();){var c=a.j();c.Qc(b.a(c.M(),c.N()))}}function fe(a){return null!=a&&!!a.td}function ge(){}l(ge,wd);g=ge.prototype;g.J=function(a){return q(a,this)?!0:Rd(a)?a.w()!=this.w()?!1:this.Db(a):!1};g.P=function(){return Xba(this)};g.Qb=function(a){var b=this.w();if(b<a.w())for(var c=this.h();c.i();){var d=c.j();a.B(d)&&c.ka()}else for(a=a.h();a.i();)c=a.j(),this.ra(c);return b!=this.w()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;function he(){}l(he,n);he.prototype.i=function(){return this.a.i()};he.prototype.j=function(){return this.a.j().M()};he.prototype.ka=function(){this.a.ka()};he.prototype.da=function(a){zb(this,a)};function Yba(){}l(Yba,ge);g=Yba.prototype;g.ia=function(){this.a.Aa()};g.B=function(a){return this.a.V(a)};g.h=function(){var a=this.a.X().h(),b=new he;b.a=a;return b};g.ra=function(a){return this.a.V(a)?(this.a.za(a),!0):!1};g.w=function(){return this.a.va()};
g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function ie(){}l(ie,n);ie.prototype.i=function(){return this.a.i()};ie.prototype.j=function(){return this.a.j().N()};ie.prototype.ka=function(){this.a.ka()};ie.prototype.da=function(a){zb(this,a)};function Zba(){}l(Zba,wd);g=Zba.prototype;g.ia=function(){this.a.Aa()};g.B=function(a){return this.a.Uc(a)};g.h=function(){var a=this.a.X().h(),b=new ie;b.a=a;return b};g.w=function(){return this.a.va()};
g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function je(){}l(je,n);g=je.prototype;g.M=function(){return this.f};g.N=function(){return this.c};g.Qc=function(a){var b=this.c;this.c=a;return b};g.J=function(a){return Od(a)?Xc(this.f,a.M())&&Xc(this.c,a.N()):!1};g.P=function(){return Zc(this.f)^Zc(this.c)};g.toString=function(){return r(this.f)+"="+r(this.c)};g.tg=!0;function ke(){}l(ke,je);
function $ba(a,b){var c=new ke;c.f=a;c.c=b;return c}function aca(a){return"number"==typeof a?a:a.Em()}function le(a){return"string"==typeof a?a.length:a.Qa()}function me(a,b){return"string"==typeof a?a.charCodeAt(b):a.$a.charCodeAt(b)}function bca(a,b,c){return"string"==typeof a?ne(a,b,c):ne(a.$a,b,c)}function oe(){}l(oe,n);function cca(a){var b=new oe;dca(b,a,"","");return b}function yd(a,b){var c=new oe;dca(c,", ",a,b);return c}
function dca(a,b,c,d){a.f=b.toString();a.b=c.toString();a.c=d.toString();a.g=r(a.b)+r(a.c)}function zd(a,b){eca(a);te(a.a,b)}oe.prototype.toString=function(){return this.a?ue(this.c)?this.a.toString():r(this.a.toString())+r(this.c):this.g};function eca(a){a.a?y(a.a,a.f):a.a=ve(a.b)}function we(){}l(we,n);g=we.prototype;g.Aa=function(){this.X().ia()};g.V=function(a){return!!fca(this,a,!1)};g.Uc=function(a){for(var b=this.X().h();b.i();){var c=b.j().N();if(Xc(a,c))return!0}return!1};
g.eh=function(a){var b=a.M();a=a.N();var c=this.get(b);return!Xc(a,c)||null==c&&!this.V(b)?!1:!0};g.J=function(a){if(q(a,this))return!0;if(!fe(a)||this.va()!=a.va())return!1;for(a=a.X().h();a.i();){var b=a.j();if(!this.eh(b))return!1}return!0};g.get=function(a){return xe(fca(this,a,!1))};g.P=function(){return Xba(this.X())};g.Ka=function(){return 0==this.va()};g.pa=function(){var a=new Yba;a.a=this;return a};g.C=function(){throw wb("Put not supported on this map").s;};
g.Hd=function(a){for(a=a.X().h();a.i();){var b=a.j();this.C(b.M(),b.N())}};g.za=function(a){return xe(fca(this,a,!0))};g.va=function(){return this.X().w()};g.toString=function(){for(var a=yd("{","}"),b=this.X().h();b.i();){var c=b.j();c=r(gca(this,c.M()))+"="+r(gca(this,c.N()));zd(a,c)}return a.toString()};function gca(a,b){return q(b,a)?"(this Map)":r(b)}g.values=function(){var a=new Zba;a.a=this;return a};function xe(a){return a?a.N():null}
function fca(a,b,c){for(a=a.X().h();a.i();){var d=a.j(),e=d.M();if(Xc(b,e))return c&&(d=$ba(d.M(),d.N()),a.ka()),d}return null}g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.td=!0;function hca(){}l(hca,we);g=hca.prototype;g.V=function(){return!1};g.Uc=function(){return!1};
g.X=function(){return Cd(),ye};g.get=function(){return null};g.pa=function(){return Cd(),ye};g.va=function(){return 0};g.values=function(){return Cd(),ica};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.ba=!0;function jca(){}l(jca,ge);g=jca.prototype;g.B=function(){return!1};g.h=function(){return Rba()};
g.w=function(){return 0};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.ba=!0;function kca(){}l(kca,wd);g=kca.prototype;g.add=function(a){this.Ul(a);return!0};g.na=function(a){return wd.prototype.na.call(this,a)};g.ia=function(){for(;null!=this.xj(););};g.yg=function(){return this.Pa()};g.Tg=function(){return this.xj()};g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;function lca(){}l(lca,ge);g=lca.prototype;g.add=function(a){return null==this.a.C(a,!0)};g.ia=function(){this.a.Aa()};g.B=function(a){return this.a.V(a)};g.J=function(a){return q(a,this)||Yc(Ae(this),a)};g.P=function(){return $c(Ae(this))};g.h=function(){return Ae(this).h()};g.ra=function(a){return null!=this.a.za(a)};g.w=function(){return Ae(this).w()};g.toString=function(){return Be(Ae(this))};function Ae(a){a.b||(a.b=a.a.pa());return a.b}g.W=function(){return Qd(this)};
g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.ba=!0;function mca(){}l(mca,Bd);g=mca.prototype;g.B=function(a){return Xc(this.a,a)};g.F=function(){return this.a};g.w=function(){return 1};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.ba=!0;function Ce(){}l(Ce,n);Ce.prototype.i=function(){return this.b.i()};Ce.prototype.j=function(){return this.b.j()};
Ce.prototype.ka=function(){throw vb().s;};Ce.prototype.da=function(a){zb(this,a)};function Ee(){}l(Ee,n);function nca(a){var b=new Ee;b.a=a;return b}g=Ee.prototype;g.add=function(){throw vb().s;};g.na=function(){throw vb().s;};g.ia=function(){throw vb().s;};g.B=function(a){return this.a.B(a)};g.Db=function(a){return this.a.Db(a)};g.G=function(){return this.a.G()};g.h=function(){var a=this.a.h(),b=new Ce;b.b=a;return b};g.ra=function(){throw vb().s;};g.Qb=function(){throw vb().s;};
g.ca=function(){throw vb().s;};g.w=function(){return this.a.w()};g.qc=function(){return this.a.qc()};g.ob=function(a){return this.a.ob(a)};g.toString=function(){return Be(this.a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;function oca(){}l(oca,Ce);g=oca.prototype;g.te=function(){throw vb().s;};g.Ec=function(){return this.a.Ec()};g.pd=function(){return this.a.pd()};g.Gc=function(){return this.a.Gc()};g.Od=function(){return this.a.Od()};
g.Ed=function(){throw vb().s;};g.da=function(a){zb(this,a)};function Fe(){}l(Fe,Ee);function pca(a){var b=new Fe;b.a=a;b.b=a;return b}g=Fe.prototype;g.lc=function(){throw vb().s;};g.J=function(a){return Yc(this.b,a)};g.F=function(a){return this.b.F(a)};g.P=function(){return $c(this.b)};g.indexOf=function(a){return this.b.indexOf(a)};g.G=function(){return this.b.G()};g.lastIndexOf=function(a){return this.b.lastIndexOf(a)};g.ae=function(){return this.Bb(0)};
g.Bb=function(a){a=this.b.Bb(a);var b=new oca;b.b=a;b.a=a;return b};g.nb=function(){throw vb().s;};g.Ya=function(){throw vb().s;};g.Ub=function(){throw vb().s;};g.Nb=function(a,b){return pca(this.b.Nb(a,b))};g.W=function(){return nd(this)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Xg=!0;function Ge(){}l(Ge,Ee);function qca(a){var b=new Ge;b.a=a;return b}g=Ge.prototype;g.J=function(a){return Yc(this.a,a)};g.P=function(){return $c(this.a)};g.W=function(){return Qd(this)};
g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;function rca(){}l(rca,n);function sca(a){var b=new rca;b.a=a;return b}g=rca.prototype;g.J=function(a){return this.a.J(a)};g.M=function(){return this.a.M()};g.N=function(){return this.a.N()};g.P=function(){return this.a.P()};g.Qc=function(){throw vb().s;};g.toString=function(){return Be(this.a)};g.tg=!0;function Ke(){}l(Ke,n);Ke.prototype.i=function(){return this.a.i()};Ke.prototype.j=function(){return sca(this.a.j())};
Ke.prototype.ka=function(){throw vb().s;};Ke.prototype.da=function(a){zb(this,a)};function tca(){}l(tca,Ge);g=tca.prototype;g.B=function(a){return this.a.B(a)};g.Db=function(a){return this.a.Db(a)};g.h=function(){var a=this.a.h(),b=new Ke;b.a=a;return b};g.qc=function(){var a=Ge.prototype.qc.call(this);uca(a,a.length);return a};g.ob=function(a){a=Ge.prototype.ob.call(this,a);uca(a,this.a.w());return a};function uca(a,b){for(var c=0;c<b;++c)a[c]=sca(a[c])}g.W=function(){return Qd(this)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function Le(){}l(Le,n);g=Le.prototype;g.Aa=function(){throw vb().s;};g.V=function(a){return this.a.V(a)};g.Uc=function(a){return this.a.Uc(a)};g.X=function(){if(!this.c){var a=this.a.X(),b=new tca;b.a=a;this.c=b}return this.c};g.J=function(a){return Yc(this.a,a)};g.get=function(a){return this.a.get(a)};g.P=function(){return $c(this.a)};g.Ka=function(){return this.a.Ka()};g.pa=function(){this.f||(this.f=qca(this.a.pa()));return this.f};g.C=function(){throw vb().s;};
g.Hd=function(){throw vb().s;};g.za=function(){throw vb().s;};g.va=function(){return this.a.va()};g.toString=function(){return Be(this.a)};g.values=function(){this.g||(this.g=nca(this.a.values()));return this.g};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.td=!0;function Me(){}l(Me,Fe);
Me.prototype.W=function(){return nd(this)};Me.prototype.T=function(){return fd(this)};Me.prototype.Z=function(a){uc(this,a)};Me.prototype.Je=!0;function vca(a){return null!=a&&!!a.Eh}function wca(){}l(wca,Le);function xca(a){var b=new wca;b.a=a;b.b=a;return b}g=wca.prototype;g.ce=function(){return this.b.ce()};g.J=function(a){return Yc(this.b,a)};g.P=function(){return $c(this.b)};g.Af=function(a){return xca(this.b.Af(a))};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};
g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.td=!0;g.Eh=!0;function yca(){xc.call(this)}l(yca,xc);function Ne(a){var b=new yca;b.f=a;b.b=16469;return b}yca.prototype.gc=function(a){return pc(this,a)};function zca(){}l(zca,Ge);g=zca.prototype;g.Fd=function(){return this.b.Fd()};g.J=function(a){return Yc(this.b,a)};g.P=function(){return $c(this.b)};g.W=function(){return Ne(this)};
g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;function Aca(){}l(Aca,Ha);function Oe(){var a=new Aca;pa(a);a.a(Error(a));return a}function Pe(){this.b=!1}l(Pe,n);Pe.prototype.i=function(){return this.b};function Bca(a){if(a.a.i())return!0;if(!q(a.a,a.g))return!1;a.a=a.c.b.h();return a.a.i()}Pe.prototype.j=function(){this.i();this.f=this.a;var a=this.a.j();this.b=Bca(this);return a};Pe.prototype.ka=function(){this.f.ka();this.f=null;this.b=Bca(this)};
Pe.prototype.da=function(a){zb(this,a)};function Cca(){}l(Cca,ge);g=Cca.prototype;g.ia=function(){this.a.Aa()};g.B=function(a){return Od(a)?this.a.eh(a):!1};g.h=function(){var a=new Pe;a.c=this.a;a.g=a.c.f.h();a.a=a.g;a.b=Bca(a);return a};g.ra=function(a){return this.B(a)?(a=a.M(),this.a.za(a),!0):!1};g.w=function(){return this.a.va()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Qe(){this.a=0}l(Qe,n);
Qe.prototype.i=function(){if(this.a<this.b.length)return!0;var a=this.g.next();return a.done?!1:(this.b=a.value[1],this.a=0,!0)};Qe.prototype.j=function(){return this.c=this.b[this.a++]};Qe.prototype.ka=function(){Dca(this.f,this.c.M());0!=this.a&&this.a--};Qe.prototype.da=function(a){zb(this,a)};function Re(){this.c=0}l(Re,n);function Eca(a,b,c){var d=null==b?0:a.a.uk(b),e=Fca(a,d);if(0==e.length)a.b.set(d,e);else if(d=Gca(a,b,e))return d.Qc(c);e[e.length]=$ba(b,c);a.c++;return null}
function Dca(a,b){for(var c=null==b?0:a.a.uk(b),d=Fca(a,c),e=0;e<d.length;e++){var f=d[e];if(a.a.pk(b,f.M()))return 1==d.length?(d.length=0,b=a.b,b["delete"].call(b,c)):d.splice(e,1),a.c--,f.N()}return null}function Te(a,b){return Gca(a,b,Fca(a,null==b?0:a.a.uk(b)))}function Gca(a,b,c){for(var d=0;d<c.length;d++){var e=c[d];if(a.a.pk(b,e.M()))return e}return null}Re.prototype.h=function(){var a=new Qe;a.f=this;a.g=a.f.b.entries();a.a=0;a.b=[];a.c=null;return a};
function Fca(a,b){return(a=a.b.get(b))?a:[]}Re.prototype.Z=function(a){uc(this,a)};Re.prototype.W=function(){return wc(this)};Re.prototype.Wa=!0;function Ue(){}l(Ue,n);Ue.prototype.i=function(){return!this.b.done};Ue.prototype.j=function(){this.f=this.b;this.b=this.c.next();var a=new Ve,b=this.f,c=this.a.b;a.b=this.a;a.a=b;a.c=c;return a};Ue.prototype.ka=function(){Hca(this.a,this.f.value[0])};Ue.prototype.da=function(a){zb(this,a)};function We(){}l(We,n);
We.prototype.J=function(a){return Od(a)?Xc(this.M(),a.M())&&Xc(this.N(),a.N()):!1};We.prototype.P=function(){return Zc(this.M())^Zc(this.N())};We.prototype.toString=function(){return r(this.M())+"="+r(this.N())};We.prototype.tg=!0;function Ve(){this.c=0}l(Ve,We);Ve.prototype.M=function(){return this.a.value[0]};Ve.prototype.N=function(){return this.b.b!=this.c?this.b.a.get(this.a.value[0]):this.a.value[1]};Ve.prototype.Qc=function(a){return Ica(this.b,this.a.value[0],a)};
function Xe(){this.b=this.c=0}l(Xe,n);function Ica(a,b,c){var d=a.a.get(b);a.a.set(b,void 0===c?null:c);void 0===d?a.c++:a.b++;return d}function Hca(a,b){var c=a.a.get(b);if(void 0===c)a.b++;else{var d=a.a;d["delete"].call(d,b);a.c--}return c}Xe.prototype.h=function(){var a=new Ue;a.a=this;a.c=a.a.a.entries();a.b=a.c.next();return a};Xe.prototype.Z=function(a){uc(this,a)};Xe.prototype.W=function(){return wc(this)};Xe.prototype.Wa=!0;function Ye(){}l(Ye,we);g=Ye.prototype;g.Aa=function(){Ze(this)};
function Ze(a){var b=new Re;b.b=new Map;b.a=a;a.b=b;b=new Xe;b.a=new Map;b.f=a;a.f=b}g.V=function(a){var b;z(a)?b=null==a?!!Te(this.b,null):void 0!==this.f.a.get(a):b=!!Te(this.b,a);return b};g.Uc=function(a){return Jca(this,a,this.f)||Jca(this,a,this.b)};function Jca(a,b,c){for(c=c.h();c.i();){var d=c.j();if(a.pk(b,d.N()))return!0}return!1}g.X=function(){var a=new Cca;a.a=this;return a};g.get=function(a){var b;z(a)?b=null==a?xe(Te(this.b,null)):this.f.a.get(a):b=xe(Te(this.b,a));return b};
g.C=function(a,b){var c;z(a)?c=null==a?Eca(this.b,null,b):Ica(this.f,a,b):c=Eca(this.b,a,b);return c};g.za=function(a){var b;z(a)?b=null==a?Dca(this.b,null):Hca(this.f,a):b=Dca(this.b,a);return b};g.va=function(){return this.b.c+this.f.c};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};
function $e(){}l($e,Ye);function af(){var a=new $e;Ze(a);return a}function bf(){var a=new $e;Ze(a);return a}function Kca(a){var b=new $e;Ze(b);b.Hd(a);return b}g=$e.prototype;g.pk=function(a,b){return Xc(a,b)};g.uk=function(a){return $c(a)|0};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};
g.ba=!0;function ef(){}l(ef,ge);function ff(){var a=new ef;a.a=af();return a}function hf(a){var b=new ef;b.a=bf(a.w());b.na(a);return b}function jf(){var a=new ef;a.a=bf();return a}g=ef.prototype;g.add=function(a){return null==this.a.C(a,this)};g.ia=function(){this.a.Aa()};g.B=function(a){return this.a.V(a)};g.G=function(){return this.a.Ka()};g.h=function(){return this.a.pa().h()};g.ra=function(a){return null!=this.a.za(a)};g.w=function(){return this.a.va()};g.W=function(){return Qd(this)};
g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;g.ba=!0;var ye,ica,Lca;function Mca(a,b){Cd();for(var c=!1,d=0;d<b.length;d++)c=!!(+c|+a.add(b[d]))}function Rba(){Cd();return Sba(),Tba}function kf(){Cd();return ica}function Nca(){Cd();return Lca}function lf(){Cd();return ye}function mf(){var a=sf();Cd();a.Ka();var b=new lca;b.a=a;return b}function Oca(a,b){Cd();for(var c=x(),d=0;d<a;++d)c.add(b);return tf(c)}
function Pca(a,b){Cd();var c=bf();c.C(a,b);return uf(c)}function Qca(a){Cd();a.nb(null)}function Rca(a,b){Cd();a.nb(b)}function vf(a){Cd();return nca(a)}function tf(a){Cd();if(pd(a)){var b=new Me;b.a=a;b.b=a;a=b}else a=pca(a);return a}function uf(a){Cd();var b=new Le;b.a=a;return b}function xf(a){Cd();return qca(a)}function Sca(a){Cd();return xca(a)}function Tca(a){Cd();var b=new zca;b.a=a;b.b=a;return b}function Xba(a){Cd();var b=0;for(a=a.h();a.i();){var c=a.j();b+=Zc(c);b|=0}return b}
function Cd(){Cd=function(){};ica=new Qba;Lca=new hca;ye=new jca}function yf(){}var Uca;l(yf,n);function zf(){Vca();return Uca}function Wca(a){Vca();return Xca(Af(a))}function Xca(a){var b=new yf;b.a=a;return b}function Bf(a){Ic(null!=a.a);return a.a}function Yca(a){return null!=a.a?a.a:null}yf.prototype.J=function(a){return q(a,this)?!0:a instanceof yf?Xc(this.a,a.a):!1};yf.prototype.P=function(){return Zc(this.a)};
yf.prototype.toString=function(){return null!=this.a?"Optional.of("+r(r(this.a))+")":"Optional.empty()"};function Vca(){Vca=function(){};Uca=Xca(null)}function Cf(a){this.b=a}l(Cf,n);Cf.prototype.a=function(a,b){var c;return c=this.b,c(a,b)};function Zca(a){this.a=a}l(Zca,n);function $ca(a,b){var c;return c=a.a,c(b)}function A(){this.a=0}l(A,n);A.prototype.name=function(){return null!=this.b?this.b:""+this.a};A.prototype.c=function(a){return this.a-a.a};A.prototype.toString=function(){return this.name()};
A.prototype.ba=!0;function ada(a){for(var b=new Map,c=0;c<a.length;c++){var d=a[c].name();b.set(d,a[c])}return b}function bda(a,b){if(null==a)throw lb().s;a=b.get(a);if(null==a)throw lb().s;return a}function Df(){this.a=0}var cda;l(Df,A);function dda(){var a=new Df;a.b="IDENTITY_FINISH";a.a=1;return a}Df.prototype.R=function(a){return A.prototype.c.call(this,a)};function eda(){eda=function(){};cda=dda()}function fda(a){return a instanceof Df}
function Ef(a,b,c,d){B([],Df,fda,1);var e=new gda;e.c=a;e.a=b;lf();e.f=c;e.b=d;return e}function hda(a,b,c){B([(eda(),cda)],Df,fda,1);var d=new gda,e=fba();d.c=a;d.a=b;lf();d.f=c;d.b=e;return d}function gda(){}l(gda,n);function Gf(){this.c=!1}l(Gf,n);function ida(a,b){a.c=!1;b?(a.b=b,a.f=null):(a.b=null,a.f=x())}function Hf(a){if(a.b)Hf(a.b);else if(a.c)throw pb("Stream already terminated, can't be modified or used").s;}function If(a){a.b?If(a.b):(Hf(a),a.c=!0)}
function jda(a,b){a.b?jda(a.b,b):a.f.add(b);return a}Gf.prototype.g=function(){this.b?this.b.g():(this.c=!0,kda(this))};function kda(a){var b=x();a.f.Z(yb(function(f){try{var h=f.a;h()}catch(k){k=wa(k),b.add(k)}}));a.f.ia();if(!b.G()){a=b.F(0);for(var c=1,d=b.w();c<d;++c){var e=b.F(c);q(e,a)||taa(a,e)}if(a instanceof Ha)throw a.s;if(Ra(a))throw a.s;}}function Kf(){Jc.call(this)}l(Kf,Jc);Kf.prototype.da=function(a){oc(this,a)};Kf.prototype.gc=function(a){return pc(this,a)};
function lda(a){this.a=a}l(lda,n);function mda(){}l(mda,ke);function nda(a){var b=a.g.a.b;a.b=b;a.a=a.g.a;b.a=a.g.a.b=a}function Lf(a){a.a.b=a.b;a.b.a=a.a;a.a=a.b=null}function Mf(){}l(Mf,n);Mf.prototype.i=function(){return!q(this.b,this.c.a.a)};Mf.prototype.j=function(){Ic(this.i());this.a=this.b;this.b=this.b.a;return this.a};Mf.prototype.ka=function(){Lf(this.a);this.c.a.c.za(this.a.M());this.a=null};Mf.prototype.da=function(a){zb(this,a)};function oda(){}l(oda,ge);g=oda.prototype;g.ia=function(){this.a.Aa()};
g.B=function(a){return Od(a)?this.a.eh(a):!1};g.h=function(){var a=new Mf;a.c=this;a.b=this.a.a.a;return a};g.ra=function(a){return this.B(a)?(a=a.M(),this.a.za(a),!0):!1};g.w=function(){return this.a.va()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Nf(){this.g=!1}l(Nf,$e);function Of(){var a=new Nf;Ze(a);Sf(a);Tf(a);return a}function Uf(){var a=new Nf;Ze(a);Sf(a);Tf(a);return a}
function Vf(a){var b=new Nf;Ze(b);Sf(b);Tf(b);b.Hd(a);return b}g=Nf.prototype;g.Aa=function(){this.c.Aa();Tf(this)};function Tf(a){a.a.b=a.a;a.a.a=a.a}g.V=function(a){return this.c.V(a)};g.Uc=function(a){for(var b=this.a.a;!q(b,this.a);){if(Xc(b.N(),a))return!0;b=b.a}return!1};g.X=function(){var a=new oda;a.a=this;return a};g.get=function(a){return(a=this.c.get(a))?(this.g&&(Lf(a),nda(a)),a.N()):null};
g.C=function(a,b){var c=this.c.get(a);if(c)return a=c.Qc(b),this.g&&(Lf(c),nda(c)),a;c=new mda;c.g=this;c.f=a;c.c=b;this.c.C(a,c);nda(c);a=this.a.a;this.an(a)&&(Lf(a),this.c.za(a.M()));return null};g.za=function(a){return(a=this.c.za(a))?(Lf(a),a.N()):null};g.va=function(){return this.c.va()};g.an=function(){return!1};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};
g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Sf(a){var b=new mda;b.g=a;b.f=null;b.c=null;a.a=b;a.c=af()}g.td=!0;function pda(){return Ef(Uc(function(){return yd("","")}),Sd(function(a,b){zd(a,b)}),new Cf(function(a,b){if(b.a){var c=b.a.Qa();eca(a);Wf(a.a,b.a,b.b.length,c)}return a}),u(function(a){return a.toString()}))}function qda(a){return hda(a,Sd(function(b,c){b.add(c)}),new Cf(function(b,c){b.na(c);return b}))}
function rda(){return qda(Uc(function(){return x()}))}function Xf(){Jc.call(this)}l(Xf,Kf);Xf.prototype.wb=function(a){for(;sda(this);){if(this.a.wb(a))return!0;this.b.g();this.a=this.b=null}return!1};function sda(a){for(;!a.a;)if(!a.c.wb(yb(function(b){b&&(a.b=b,a.a=b.Ie())})))return!1;return!0}Xf.prototype.da=function(a){oc(this,a)};Xf.prototype.gc=function(a){return pc(this,a)};function bg(){Jc.call(this)}l(bg,Kf);
bg.prototype.wb=function(a){if(!this.a){var b=x();this.b.a.da(yb(function(c){b.add(c)}));Rca(b,this.c);this.a=b.W()}return this.a.wb(a)};bg.prototype.da=function(a){oc(this,a)};bg.prototype.gc=function(a){return pc(this,a)};function cg(){Jc.call(this);this.a=!1}l(cg,Kf);cg.prototype.wb=function(a){var b=this;for(this.a=!1;!this.a&&this.c.wb(yb(function(c){b.b.Ca(c)&&(b.a=!0,a.Ob(c))})););return this.a};cg.prototype.da=function(a){oc(this,a)};cg.prototype.gc=function(a){return pc(this,a)};
function dg(){Jc.call(this);this.b=hb(0);this.a=0}l(dg,Kf);dg.prototype.wb=function(a){if(0<=ab(Ab(this.a),this.b))return!1;a=this.c.wb(a);this.a++;return a};dg.prototype.da=function(a){oc(this,a)};dg.prototype.gc=function(a){return pc(this,a)};function eg(){Jc.call(this)}l(eg,Kf);function tda(a,b){var c=new eg,d=b.nd();Kc(c,d,b.sd()&-6);c.a=a;c.b=b;return c}eg.prototype.wb=function(a){var b=this;return this.b.wb(yb(function(c){a.Ob(b.a.f(c))}))};eg.prototype.da=function(a){oc(this,a)};
eg.prototype.gc=function(a){return pc(this,a)};function fg(){Jc.call(this);this.a=hb(0)}l(fg,Kf);fg.prototype.wb=function(a){for(;0<ab(this.a,hb(0));){if(!this.b.wb(yb(function(){})))return!1;this.a=Ya(this.a,hb(1))}return this.b.wb(a)};fg.prototype.da=function(a){oc(this,a)};fg.prototype.gc=function(a){return pc(this,a)};function gg(){}l(gg,n);gg.prototype.Ob=function(a){this.a=a};function uda(){}
function vda(a,b){var c=hg(B([a,b],uda,wda,1)).W();c=xda(c);c=hd(null,c);return jda(jda(c,new tb(function(){a.g()})),new tb(function(){b.g()}))}function wda(a){return null!=a&&!!a.km}uda.prototype.km=!0;function ig(){this.c=!1}var yda;l(ig,Gf);function hd(a,b){zda();var c=new ig;ida(c,a);c.a=b;return c}ig.prototype.Ie=function(){If(this);return this.a};ig.prototype.o=function(){var a=this.Ie(),b=new xba;b.a=!1;b.c=a;return b};function jg(a,b){If(a);a.a.da(b)}
function kg(a,b){return b.b.f(Ada(a,b.c.Na(),new Td(function(c,d){var e=b.a.a;e(c,d);return c})))}function Bda(a){If(a);var b=new gg;return a.a.wb(b)?Wca(b.a):zf()}function lg(a,b){b=b.cb();return!mg(a,b).Ie().wb(yda)}function Cda(a,b,c){return Ada(a,b,c)}function Ada(a,b,c){If(a);var d=new gg;d.a=b;a.a.da(yb(function(e){d.Ob(c.a(d.a,e))}));return d.a}function mg(a,b){Hf(a);var c=new cg,d=a.a,e=d.nd();Kc(c,e,d.sd()&-16449);c.b=b;c.c=d;return hd(a,c)}
function sg(a,b){Hf(a);return hd(a,tda(b,a.a))}function tg(a,b){Hf(a);b=tda(b,a.a);var c=new Xf;c.c=b;Kc(c,Ub,0);return hd(a,c)}function Dda(a){Hf(a);var b=ff();return mg(a,ad(function(c){return b.add(c)}))}function ug(a){Hf(a);var b=ec();return Eda(a,b)}function Eda(a,b){Hf(a);var c=a.a.nd(),d=new bg,e=a.a.sd()|4;d.b=a;d.c=b;Kc(d,c,e);d.a=null;return hd(a,d)}function zda(){zda=function(){};yda=yb(function(){})}ig.prototype.km=!0;function vg(){this.c=!1}l(vg,Gf);
function Fda(){var a=new vg;ida(a,null);return a}vg.prototype.o=function(){return Cba(this.Ie())};vg.prototype.Ie=function(){If(this);return Aba(),zba};function wg(){this.c=!1}l(wg,Gf);function Gda(a){var b=new wg;ida(b,null);b.a=a;return b}wg.prototype.Ie=function(){If(this);return this.a};wg.prototype.o=function(){return Cba(this.Ie())};function xg(){Jc.call(this)}l(xg,Kf);function xda(a){var b=new xg;b.b=a;Kc(b,Ub,0);return b}
xg.prototype.wb=function(a){for(;Hda(this);){if(this.a.wb(a))return!0;this.a=null}return!1};function Hda(a){for(;!a.a;)if(!a.b.wb(yb(function(b){b&&(a.a=b.Ie())})))return!1;return!0}xg.prototype.da=function(a){oc(this,a)};xg.prototype.gc=function(a){return pc(this,a)};function Dd(){this.b=this.a=0}l(Dd,n);Dd.prototype.i=function(){return this.a<this.c.w()};Dd.prototype.j=function(){this.i();return this.c.F(this.b=this.a++)};Dd.prototype.ka=function(){this.c.Ya(this.b);this.a=this.b;this.b=-1};
Dd.prototype.da=function(a){zb(this,a)};function Nba(){Dd.call(this)}l(Nba,Dd);g=Nba.prototype;g.te=function(a){this.f.lc(this.a,a);this.a++;this.b=-1};g.Ec=function(){return 0<this.a};g.pd=function(){return this.a};g.Gc=function(){this.Ec();return this.f.F(this.b=--this.a)};g.Od=function(){return this.a-1};g.Ed=function(a){this.f.Ub(this.b,a)};g.da=function(a){zb(this,a)};function Oba(){this.b=this.a=0}l(Oba,Bd);g=Oba.prototype;g.lc=function(a,b){this.c.lc(this.a+a,b);this.b++};
g.F=function(a){return this.c.F(this.a+a)};g.Ya=function(a){a=this.c.Ya(this.a+a);this.b--;return a};g.Ub=function(a,b){return this.c.Ub(this.a+a,b)};g.w=function(){return this.b};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Ida(){}l(Ida,Bd);function hg(a){var b=new Ida;b.a=a;return b}g=Ida.prototype;g.B=function(a){return-1!=this.indexOf(a)};
g.Z=function(a){for(var b=this.a,c=0;c<b.length;c++)a.Ob(b[c])};g.F=function(a){this.w();return this.a[a]};g.Ub=function(a,b){var c=this.F(a);this.a[a]=b;return c};g.w=function(){return this.a.length};g.nb=function(a){var b=this.a,c=this.a.length;Kd(0,c,b.length);Pba(b,c,a)};g.qc=function(){return this.ob(Array(this.a.length))};g.ob=function(a){var b=this.a.length;a.length<b&&(a=sd(Array(b),a));for(var c=0;c<b;++c)a[c]=this.a[c];a.length>b&&(a[b]=null);return a};g.W=function(){return nd(this)};
g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Je=!0;g.ba=!0;function Jda(a,b,c){var d=0;for(--b;d<=b;){var e=d+(b-d>>1),f=a[e];if(f<c)d=e+1;else if(f>c)b=e-1;else return e}return-d-1}function yg(a,b){return Kda(a,Ba([b],w,Wc,0),0,b)}function zg(a,b){a=ud(a,b);a.length=b;return a}function Kda(a,b,c,d){vd(a,c,b,0,Math.min(d,a.length)-c,!0);return b}
function Lda(a,b){if(q(a,b))return!0;if(!a||!b||a.length!=b.length)return!1;for(var c=0;c<a.length;++c)if(a[c]!=b[c])return!1;return!0}function Mda(a,b){if(q(a,b))return!0;if(!a||!b||a.length!=b.length)return!1;for(var c=0;c<a.length;++c)if(a[c]!=b[c])return!1;return!0}function Nda(a,b,c,d){for(;b<c;++b)a[b]=d}function Ag(a,b,c){for(var d=0;d<b;++d)a[d]=c}function Bg(a){if(!a)return 0;for(var b=1,c=0;c<a.length;c++)b=31*b+Zc(a[c]),b|=0;return b}function md(a,b){Pba(a,a.length,b)}
function Oda(a){if(!a)return"null";for(var b=yd("[","]"),c=0;c<a.length;c++)zd(b,Ig(a[c]));return b.toString()}
function Pda(a,b){if(!a)return"null";if(!b.add(a))return"[...]";for(var c=yd("[","]"),d=0;d<a.length;d++){var e=a[d];if(null!=e&&0!=Jg(e).a)if(Kg(e,n,saa))if(b.B(e))zd(c,"[...]");else{var f=hf(b);zd(c,Pda(e,f))}else if(Kg(e,Vc,Lba)){if(e){f=yd("[","]");for(var h=0;h<e.length;h++)zd(f,""+e[h]);e=f.toString()}else e="null";zd(c,e)}else if(Kg(e,qc,sc)){if(e){f=yd("[","]");for(h=0;h<e.length;h++)zd(f,""+e[h]);e=f.toString()}else e="null";zd(c,e)}else if(Kg(e,Ob,Pb))zd(c,Oda(e));else if(Kg(e,tba,uba)){if(e){f=
yd("[","]");for(h=0;h<e.length;h++)zd(f,""+e[h]);e=f.toString()}else e="null";zd(c,e)}else if(Kg(e,w,Wc)){if(e){f=yd("[","]");for(h=0;h<e.length;h++)zd(f,""+e[h]);e=f.toString()}else e="null";zd(c,e)}else if(Kg(e,Qb,Yaa)){if(e){f=yd("[","]");for(h=0;h<e.length;h++)zd(f,""+e[h]);e=f.toString()}else e="null";zd(c,e)}else if(Kg(e,rba,sba)){if(e){f=yd("[","]");for(h=0;h<e.length;h++)zd(f,""+e[h]);e=f.toString()}else e="null";zd(c,e)}else{if(Kg(e,Naa,Oaa)){if(e){f=yd("[","]");for(h=0;h<e.length;h++)zd(f,
""+e[h]);e=f.toString()}else e="null";zd(c,e)}}else zd(c,r(e))}return c.toString()}function Pba(a,b,c){c=nc(c);Qda(a.slice(0,b),a,0,b,-0,c)}function Qda(a,b,c,d,e,f){if(7>d-c){a=c;for(var h=a+1;h<d;++h)for(var k=h;k>a&&0<f.Oa(b[k-1],b[k]);--k)c=b[k],b[k]=b[k-1],b[k-1]=c}else{var m=c+e;h=d+e;k=m+(h-m>>1);Qda(b,a,m,k,-e,f);Qda(b,a,k,h,-e,f);if(0>=f.Oa(a[k-1],a[k]))for(;c<d;)xd(b,c++,a[m++]);else for(e=m,m=k;c<d;)m>=h||e<k&&0>=f.Oa(a[e],a[m])?xd(b,c++,a[e++]):xd(b,c++,a[m++])}}
function Rda(){return function(a,b){return a-b}}function Sda(){Jc.call(this);this.b=this.c=this.a=0}l(Sda,Qc);g=Sda.prototype;g.da=function(a){Fc(this,a)};g.wb=function(a){return Ec(this,a)};g.bg=function(a){for(;this.Bf(a););};g.gc=function(a){return pc(this,a)};g.Bf=function(a){this.a<=this.b?(a.Ei(this.a++),a=!0):a=!1;return a};function Lg(){}l(Lg,n);Lg.prototype.Qa=function(){return this.$a.length};Lg.prototype.toString=function(){return this.$a};Lg.prototype.im=!0;function Mg(){}l(Mg,Lg);
function Ng(){var a=new Mg;a.$a="";return a}function Og(){var a=new Mg;a.$a="";return a}function ve(a){var b=new Mg;b.$a=a;return b}function Pg(a,b){a.$a=r(a.$a)+Ig(b);return a}function Tda(a,b){a.$a=r(a.$a)+r(Qg(b))}function te(a,b){a.$a=r(a.$a)+r(b);return a}function Wf(a,b,c,d){a.$a=r(a.$a)+r(ne(r(b),c,d));return a}function Rg(a,b){a.$a=r(a.$a)+b;return a}function Sg(a,b){a.$a=r(a.$a)+r(b);return a}function y(a,b){a.$a=r(a.$a)+r(b);return a}
function Tg(a,b,c){a.$a=r(ne(a.$a,0,b))+r(c)+r(a.$a.substr(b));return a}function Uda(){}l(Uda,Ka);function Ic(a){if(!a)throw Ld().s;}function Af(a){if(null==a)throw qb().s;return a}function Kd(a,b,c){if(a>b)throw va("fromIndex: "+a+" > toIndex: "+b).s;if(0>a||b>c)throw Daa("fromIndex: "+a+", toIndex: "+b+", length: "+c).s;}function Vda(){}l(Vda,n);Vda.prototype.ba=!0;function Wda(){}function Xda(){}l(Xda,n);function Yc(a,b){return a.J?a.J(b):a===b}
function $c(a){if(a.P)return a.P();var b=typeof a;return"number"==b?Fb(a):"boolean"==b?a?1231:1237:"string"==b?Yg(a):ja(a)}function Be(a){var b;Array.isArray(a)?b=ka(Yda(a))+"@"+na(ja(a)):b=a.toString();return b}function Jg(a){var b=typeof a;if("number"==b)return la(Taa);if("boolean"==b)return la(Vda);if("string"==b)return la(D);if(Array.isArray(a))return Yda(a);if(a instanceof n)return la(a.constructor);if(a)return la("function"==b?Wda:Xda);throw new TypeError("null.getClass");}
function Ba(a,b,c,d){return Zda(a,d,Zg(b,c,a.length))}function Zda(a,b,c){var d=a[0];if(null==d)return null;var e=[];e.length=d;c&&(e.Bh=c);if(1<a.length){a=a.slice(1);c=c&&Zg(c.Di,c.wm,c.$g-1);for(var f=0;f<d;f++)e[f]=Zda(a,b,c)}else if(void 0!==b)for(a=0;a<d;a++)e[a]=b;return e}function B(a,b,c,d){return $da(a,Zg(b,c,d))}function $da(a,b){a.Bh=b;if(1<b.$g){b=Zg(b.Di,b.wm,b.$g-1);for(var c=0;c<a.length;c++){var d=a[c];d&&$da(d,b)}}return a}function xd(a,b,c){return a[b]=c}
function Kg(a,b,c){if(null==a||!Array.isArray(a))return!1;a=a.Bh||{Di:n,$g:1};var d=a.$g;return 1==d?(a=a.Di,a===b?!0:b&&b.prototype.kf||a&&a.prototype.kf?!1:c(a.prototype)):1<d?n==b:!1}function Yda(a){return(a=a.Bh)?la(a.Di,a.$g):la(n,1)}function Zg(a,b,c){return{Di:a,wm:b,$g:c}}var aea;function bea(){bea=function(){};aea=Ba([128],$g,ah,$g.a)}function $g(){this.a=0}var cea,dea,eea;l($g,n);
function bh(a,b){return 2>b||36<b?-1:48<=a&&a<48+Math.min(b,10)?a-48:97<=a&&a<b+97-10?a-97+10:65<=a&&a<b+65-10?a-65+10:-1}function fea(a){cea||(cea=/\d/);return cea.test(Ig(a))}function ch(a){dea||(dea=/[A-Z]/i);return dea.test(Ig(a))}function gea(a){eea||(eea=/[A-Z\d]/i);return eea.test(Ig(a))}function dh(a){return Ig(a).toUpperCase().charCodeAt(0)==a&&ch(a)}
function hea(a){if(!(0<=a&&1114111>=a))throw lb().s;return 65536<=a?B([55296+(a-65536>>10&1023)&65535,56320+(a-65536&1023)&65535],Ob,Pb,1):B([a&65535],Ob,Pb,1)}function eh(a){if(128>a){var b=(bea(),aea)[a];b||(b=aea[a]=iea(a));return b}return iea(a)}function iea(a){var b=new $g;b.a=a;return b}g=$g.prototype;g.J=function(a){return ah(a)&&a.a==this.a};g.P=function(){return this.a};g.toString=function(){return Ig(this.a)};g.R=function(a){return this.a-a.a};function ah(a){return a instanceof $g}
g.ba=!0;var jea,kea,fh,lea;function mea(){mea=function(){};kea=B([-1,-1,30,19,15,13,11,11,10,9,9,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5],w,Wc,1);fh=Ba([37],w,Wc,0);jea=B([-1,-1,63,40,32,28,25,23,21,20,19,19,18,18,17,17,16,16,16,15,15,15,15,14,14,14,14,14,14,13,13,13,13,13,13,13,13],w,Wc,1);lea=Ba([37],Qb,Yaa,Zaa);for(var a=2;36>=a;a++)fh[a]=Fb(Math.pow(a,kea[a])),xd(lea,a,Xa(Ub,Ab(fh[a])))}function nea(){}l(nea,kb);function Jb(a){return gh('For input string: "'+r(a)+'"')}
function gh(a){var b=new nea;sa(b,a);b.a(Error(b));return b}function hh(a){return a instanceof nea}var oea;function pea(){pea=function(){};oea=Ba([256],ih,jh,ih.a)}var qea;function rea(){rea=function(){};qea=B([0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15],w,Wc,1)}function ih(){this.a=0}l(ih,Gb);function kh(a){a-=a>>1&1431655765;a=(a>>2&858993459)+(a&858993459);a=(a>>4)+a&252645135;a+=a>>8;return a+(a>>16)&63}function kba(a,b){return a<b?-1:a>b?1:0}
function ph(a){if(0>a)return-2147483648;if(0==a)return 0;var b;for(b=1073741824;0==(b&a);b>>=1);return b}function qh(a){if(0>a)return 0;if(0==a)return 32;var b=-(a>>16)>>16&16;var c=16-b;a>>=b;b=a-256>>16&8;c+=b;a<<=b;b=a-4096>>16&4;c+=b;a<<=b;b=a-16384>>16&2;c+=b;a=a<<b>>14;return c+2-(a&~(a>>1))}function sea(a){if(0==a)return 32;for(var b=0,c=1;0==(c&a);c<<=1)b++;return b}
function rh(a,b){if(null==a)throw gh("null").s;if(2>b||36<b)throw gh("radix "+b+" out of range").s;for(var c=a.length,d=0<c&&(45==a.charCodeAt(0)||43==a.charCodeAt(0))?1:0;d<c;d++)if(-1==bh(a.charCodeAt(d),b))throw Jb(a).s;b=parseInt(a,b);c=-2147483648>b;if(isNaN(b))throw Jb(a).s;if(c||2147483647<b)throw Jb(a).s;return b}function sh(a){var b=(rea(),qea);return b[a>>>28|0]|b[a>>24&15]<<4|b[a>>20&15]<<8|b[a>>16&15]<<12|b[a>>12&15]<<16|b[a>>8&15]<<20|b[a>>4&15]<<24|b[a&15]<<28}
function na(a){return(a>>>0).toString(16)}function cba(a,b){return 10==b||2>b||36<b?""+a:a.toString(b)}function Dc(a){if(-129<a&&128>a){var b=a+128,c=(pea(),oea)[b];c||(c=oea[b]=tea(a));return c}return tea(a)}function tea(a){var b=new ih;b.a=a;return b}g=ih.prototype;g.Em=function(){return this.a};g.J=function(a){return jh(a)&&a.a==this.a};g.P=function(){return this.a};g.Mb=function(){return this.a};g.Pk=function(){return Ab(this.a)};g.toString=function(){return""+this.a};
g.R=function(a){return kba(this.a,a.a)};function jh(a){return a instanceof ih}var th,uea;function Yg(a){vea();var b=":"+r(a),c=th[b];if(null!=c)return Fb(c);c=uea[b];if(null==c){c=0;for(var d=a.length,e=d-4,f=0;f<e;)c=a.charCodeAt(f+3)+31*(a.charCodeAt(f+2)+31*(a.charCodeAt(f+1)+31*(a.charCodeAt(f)+31*c))),c|=0,f+=4;for(;f<d;)c=31*c+uh(a,f++);a=c|0}else a=Fb(c);256==vh&&(uea=th,th=new n,vh=0);++vh;return th[b]=a}function vea(){vea=function(){};uea=new n;vh=0;th=new n}var vh=0;
function wh(a){switch(typeof a){case "string":return Yg(a);case "number":return Fb(a);case "boolean":return a?1231:1237;default:return null==a?0:ja(a)}}function wea(a){return null!=a&&!!a.jm}function xea(){}l(xea,je);xea.prototype.Qc=function(){throw vb().s;};function xh(){}l(xh,we);g=xh.prototype;g.V=function(a){return!!this.Ag(a)};g.sf=function(){var a=new yea;a.a=this;return a};g.X=function(){return zea(this)};g.get=function(a){return xe(this.Ag(a))};g.pa=function(){return this.Sk()};
g.Sk=function(){var a=new Aea;a.a=this;return a};g.Af=function(a){return this.Ee(a,!0)};g.eh=function(a){var b=a.M();b=this.Ag(b);return!!b&&Xc(b.N(),a.N())};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.td=!0;g.Eh=!0;g.jm=!0;function yea(){}l(yea,xh);g=yea.prototype;g.Aa=function(){this.a.Aa()};
g.ce=function(){var a=this.a.ce();Cd();a?a=a.ac():(mc(),a=mba);return a};g.sf=function(){return this.a};g.ph=function(a,b){return this.a.Ee(a,b).sf()};g.C=function(a,b){return this.a.C(a,b)};g.za=function(a){return this.a.za(a)};g.va=function(){return this.a.va()};g.Zf=function(a,b,c,d){return this.a.Zf(c,d,a,b).sf()};g.Ee=function(a,b){return this.a.ph(a,b).sf()};g.Al=function(){return this.a.$i()};g.$i=function(){return this.a.Al()};g.Ag=function(a){return this.a.Ag(a)};g.ej=function(){return this.a.vk()};
g.vk=function(){return this.a.ej()};g.cj=function(a){return this.a.fj(a)};g.fj=function(a){return this.a.cj(a)};g.gj=function(a){return this.a.ij(a)};g.ij=function(a){return this.a.gj(a)};g.Og=function(a){return this.a.Og(a)};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function yh(){}
l(yh,ge);function zea(a){var b=new yh;b.a=a;return b}g=yh.prototype;g.B=function(a){return Od(a)&&this.a.eh(a)};g.h=function(){return this.a.$i()};g.ra=function(a){return Od(a)?this.a.Og(a):!1};g.w=function(){return this.a.va()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function zh(){}l(zh,n);zh.prototype.i=function(){return this.a.i()};zh.prototype.j=function(){return this.a.j().M()};zh.prototype.ka=function(){this.a.ka()};
zh.prototype.da=function(a){zb(this,a)};function Aea(){}l(Aea,ge);g=Aea.prototype;g.ia=function(){this.a.Aa()};g.Fd=function(){return this.a.ce()};g.B=function(a){return this.a.V(a)};g.Jf=function(){return this.a.sf().Sk()};g.h=function(){var a=this.a.X().h(),b=new zh;b.a=a;return b};g.ra=function(a){return this.a.V(a)?(this.a.za(a),!0):!1};g.w=function(){return this.a.va()};g.Qg=function(a,b){return this.a.Ee(a,b).Sk()};g.W=function(){return Ne(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;g.Yg=!0;function Ah(){this.a=0}var Bea,Cea,Dea,Eea;l(Ah,A);function Fea(){var a=new Ah;a.b="All";a.a=0;return a}Ah.prototype.f=function(){return!1};Ah.prototype.g=function(){return!1};Ah.prototype.R=function(a){return A.prototype.c.call(this,a)};function Bh(){Bh=function(){};Bea=Fea();Cea=Gea();Dea=Hea();Eea=Iea()}function Ch(){this.a=0}l(Ch,Ah);function Gea(){Bh();var a=new Ch;a.b="Head";a.a=1;return a}Ch.prototype.g=function(){return!0};
Ch.prototype.R=function(a){return Ah.prototype.c.call(this,a)};function Ih(){this.a=0}l(Ih,Ah);function Hea(){Bh();var a=new Ih;a.b="Range";a.a=2;return a}Ih.prototype.f=function(){return!0};Ih.prototype.g=function(){return!0};Ih.prototype.R=function(a){return Ah.prototype.c.call(this,a)};function Jh(){this.a=0}l(Jh,Ah);function Iea(){Bh();var a=new Jh;a.b="Tail";a.a=3;return a}Jh.prototype.f=function(){return!0};Jh.prototype.R=function(a){return Ah.prototype.c.call(this,a)};function Kh(){}l(Kh,n);
Kh.prototype.i=function(){return this.a.Ec()};Kh.prototype.j=function(){return this.c=this.a.Gc()};Kh.prototype.ka=function(){this.a.ka();this.b.Og(this.c);this.c=null};Kh.prototype.da=function(a){zb(this,a)};function Lh(){}l(Lh,n);Lh.prototype.i=function(){return this.a.i()};Lh.prototype.j=function(){return this.c=this.a.j()};Lh.prototype.ka=function(){this.a.ka();this.b.Og(this.c);this.c=null};Lh.prototype.da=function(a){zb(this,a)};function Jea(){}l(Jea,yh);g=Jea.prototype;g.ia=function(){this.b.Aa()};
g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Mh(){this.b=!1}l(Mh,ke);function Kea(a,b){var c=new Mh;c.f=a;c.c=b;c.a=Ba([2],Mh,Lea,Mh.a);c.b=!0;return c}function Lea(a){return a instanceof Mh}function Nh(){this.c=this.b=!1}l(Nh,n);Nh.prototype.toString=function(){return"State: mv="+this.c+" value="+r(this.a)+" done=false found="+this.b};function Mea(){this.o=this.g=!1}l(Mea,xh);
function Nea(a,b,c,d,e,f){var h=new Mea;h.a=a;switch(b.a){case 2:if(0>a.b.Oa(e,c))throw va("subMap: "+r(e)+" less than "+r(c)).s;break;case 1:a.b.Oa(e,e);break;case 3:a.b.Oa(c,c)}h.f=b;h.b=c;h.g=d;h.c=e;h.o=f;return h}g=Mea.prototype;g.ce=function(){return this.a.ce()};g.X=function(){return zea(this)};g.ph=function(a,b){if(this.f.g()&&0<this.a.b.Oa(a,this.c))throw va("subMap: "+r(a)+" greater than "+r(this.c)).s;return this.f.f()?this.a.Zf(this.b,this.g,a,b):this.a.ph(a,b)};
g.C=function(a,b){if(!Th(this,a))throw va(r(a)+" outside the range "+r(this.b)+" to "+r(this.c)).s;return this.a.C(a,b)};g.za=function(a){return Th(this,a)?this.a.za(a):null};g.va=function(){if(!this.ej())return 0;for(var a=0,b=this.$i();b.i();b.j())a++;return a};g.Zf=function(a,b,c,d){if(this.f.f()&&0>this.a.b.Oa(a,this.b))throw va("subMap: "+r(a)+" less than "+r(this.b)).s;if(this.f.g()&&0<this.a.b.Oa(c,this.c))throw va("subMap: "+r(c)+" greater than "+r(this.c)).s;return this.a.Zf(a,b,c,d)};
g.Ee=function(a,b){if(this.f.f()&&0>this.a.b.Oa(a,this.b))throw va("subMap: "+r(a)+" less than "+r(this.b)).s;return this.f.g()?this.a.Zf(a,b,this.c,this.o):this.a.Ee(a,b)};g.Al=function(){var a=new Kh,b=this.a,c=this.f,d=this.b,e=this.g,f=this.c,h=this.o;a.b=b;var k=x();Uh(b,k,c,b.a,d,e,f,h);a.a=k.Bb(k.w());return a};g.$i=function(){var a=new Lh,b=this.a,c=this.f,d=this.b,e=this.g,f=this.c,h=this.o;a.b=b;var k=x();Uh(b,k,c,b.a,d,e,f,h);a.a=k.ae();return a};g.Ag=function(a){return Vh(this,this.a.Ag(a))};
g.ej=function(){var a=this.f.f()?this.g?this.a.cj(this.b):this.a.gj(this.b):this.a.ej();return Vh(this,a)};g.vk=function(){var a=this.f.g()?this.o?this.a.fj(this.c):this.a.ij(this.c):this.a.vk();return Vh(this,a)};g.cj=function(a){return Vh(this,this.a.cj(a))};g.fj=function(a){return Vh(this,this.a.fj(a))};g.gj=function(a){return Vh(this,this.a.gj(a))};g.ij=function(a){return Vh(this,this.a.ij(a))};g.Og=function(a){return Th(this,a.M())&&this.a.Og(a)};
function Vh(a,b){return b&&Th(a,b.M())?b:null}function Th(a,b){var c=a.a,d=a.f,e=a.c,f=a.o;return d.f()&&Oea(c,b,a.b,!a.g)||d.g()&&Pea(c,b,e,!f)?!1:!0}g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Wh(){this.c=0}l(Wh,xh);
function Xh(){var a=new Wh;a.c=0;a.a=null;a.b=nc(null);return a}function Qea(a){var b=new Wh;b.c=0;b.a=null;b.b=nc(a);return b}g=Wh.prototype;g.Aa=function(){this.a=null;this.c=0};g.ce=function(){var a=this.b;mc();return q(a,pba)?null:a};g.X=function(){var a=new Jea;a.b=this;a.a=this;return a};g.ph=function(a,b){return Nea(this,(Bh(),Cea),null,!1,a,b)};g.C=function(a,b){var c=new Nh;this.a=Rea(this,this.a,Kea(a,b),c);c.b||++this.c;this.a.b=!1;return c.a};
g.za=function(a){var b=new Nh;Sea(this,a,b);return b.a};g.va=function(){return this.c};g.Zf=function(a,b,c,d){return Nea(this,(Bh(),Dea),a,b,c,d)};g.Ee=function(a,b){return Nea(this,(Bh(),Eea),a,b,null,!1)};function Tea(a,b,c){for(var d=null,e=a.a;e;){var f=a.b.Oa(b,e.M());if(c&&0==f)return e;0<=f?e=e.a[1]:(d=e,e=e.a[0])}return d}function Uea(a,b,c){for(var d=null,e=a.a;e;){var f=a.b.Oa(b,e.M());if(c&&0==f)return e;0>=f?e=e.a[0]:(d=e,e=e.a[1])}return d}
g.Al=function(){var a=new Kh,b=(Bh(),Bea);a.b=this;var c=x();Uh(this,c,b,this.a,null,!1,null,!1);a.a=c.Bb(c.w());return a};g.$i=function(){var a=new Lh,b=(Bh(),Bea);a.b=this;var c=x();Uh(this,c,b,this.a,null,!1,null,!1);a.a=c.ae();return a};g.Ag=function(a){for(var b=this.a;b;){var c=this.b.Oa(a,b.M());if(0==c)return b;b=b.a[0>c?0:1]}return null};g.ej=function(){if(!this.a)return null;for(var a=this.a,b;b=a.a[0];)a=b;return a};
g.vk=function(){if(!this.a)return null;for(var a=this.a,b;b=a.a[1];)a=b;return a};g.cj=function(a){return Tea(this,a,!0)};g.fj=function(a){return Uea(this,a,!0)};g.gj=function(a){return Tea(this,a,!1)};g.ij=function(a){return Uea(this,a,!1)};g.Og=function(a){var b=new Nh;b.c=!0;b.a=a.N();return Sea(this,a.M(),b)};function Uh(a,b,c,d,e,f,h,k){if(d){var m=d.a[0];m&&Uh(a,b,c,m,e,f,h,k);m=d.M();c.f()&&Oea(a,m,e,!f)||c.g()&&Pea(a,m,h,!k)||b.add(d);(d=d.a[1])&&Uh(a,b,c,d,e,f,h,k)}}
function Rea(a,b,c,d){if(b){var e=a.b.Oa(c.M(),b.M());if(0==e)return d.a=b.Qc(c.N()),d.b=!0,b;e=0>e?0:1;xd(b.a,e,Rea(a,b.a[e],c,d));Yh(b.a[e])&&(Yh(b.a[1-e])?(b.b=!0,b.a[0].b=!1,b.a[1].b=!1):Yh(b.a[e].a[e])?b=Zh(b,1-e):Yh(b.a[e].a[1-e])&&(b=Vea(b,1-e)))}else return c;return b}function Yh(a){return!!a&&a.b}function Pea(a,b,c,d){a=a.b.Oa(b,c);return 0<a||d&&0==a}function Oea(a,b,c,d){a=a.b.Oa(b,c);return 0>a||d&&0==a}
function Sea(a,b,c){if(!a.a)return!1;var d=null,e=null,f=Kea(null,null),h=1;f.a[1]=a.a;for(var k=f;k.a[h];){var m=h,p=e;e=k;k=k.a[h];var t=a.b.Oa(b,k.M());h=0>t?0:1;0!=t||c.c&&!Xc(k.N(),c.a)||(d=k);if(!Yh(k)&&!Yh(k.a[h]))if(Yh(k.a[1-h]))e=xd(e.a,m,Zh(k,h));else if(!Yh(k.a[1-h])&&(t=e.a[1-m]))if(Yh(t.a[1-m])||Yh(t.a[m])){var v=q(p.a[1],e)?1:0;Yh(t.a[m])?xd(p.a,v,Vea(e,m)):Yh(t.a[1-m])&&xd(p.a,v,Zh(e,m));k.b=p.a[v].b=!0;p.a[v].a[0].b=!1;p.a[v].a[1].b=!1}else e.b=!1,t.b=!0,k.b=!0}if(d){c.b=!0;c.a=d.N();
if(!q(k,d)){b=Kea(k.M(),k.N());h=d;m=f;for(p=null==m.M()||0<a.b.Oa(h.M(),m.M())?1:0;!q(m.a[p],h);)m=m.a[p],p=0<a.b.Oa(h.M(),m.M())?1:0;m.a[p]=b;b.b=h.b;b.a[0]=h.a[0];b.a[1]=h.a[1];h.a[0]=null;h.a[1]=null;q(e,d)&&(e=b)}e.a[q(e.a[1],k)?1:0]=k.a[k.a[0]?0:1];a.c--}a.a=f.a[1];a.a&&(a.a.b=!1);return c.b}function Vea(a,b){var c=1-b;xd(a.a,c,Zh(a.a[c],c));return Zh(a,b)}function Zh(a,b){var c=1-b,d=a.a[c];a.a[c]=d.a[b];d.a[b]=a;a.b=!0;d.b=!1;return d}g.hb=function(a,b){return Ud(this,a,b)};
g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.ba=!0;function $h(){}l($h,n);$h.prototype.b=function(a){return jc(this.a.toLowerCase(),a.a.toLowerCase())};$h.prototype.P=function(){return Yg(this.a)};$h.prototype.J=function(a){return q(a,this)?!0:a instanceof $h?q(this.a,a.a):!1};$h.prototype.toString=function(){return this.a};
function Wea(){}var Xea;l(Wea,$h);function Yea(){Yea=function(){};Xea=Zea()}function ai(){}l(ai,Wea);function Zea(){Yea();var a=new ai;a.a="UTF-8";return a}
ai.prototype.c=function(a,b){for(var c=0,d=0;d<b;){++c;var e=a[d];if(128==(e&192))throw va("Invalid UTF8 sequence").s;if(0==(e&128))++d;else if(192==(e&224))d+=2;else if(224==(e&240))d+=3;else if(240==(e&248))d+=4;else throw va("Invalid UTF8 sequence").s;if(d>b)throw La("Invalid UTF8 sequence").s;}c=Ba([c],Ob,Pb,0);var f=0;for(e=d=0;e<b;){var h=a[e++];0==(h&128)?(d=1,h&=127):192==(h&224)?(d=2,h&=31):224==(h&240)?(d=3,h&=15):240==(h&248)?(d=4,h&=7):248==(h&252)&&(d=5,h&=3);for(;0<--d;){var k=a[e++];
if(128!=(k&192))throw va("Invalid UTF8 sequence at "+(e-1)+", byte="+r(na(k))).s;h=h<<6|k&63}k=f;var m=c;if(!(0<=h&&1114111>=h))throw lb().s;65536<=h?(xd(m,f++,55296+(h-65536>>10&1023)&65535),m[f]=56320+(h-65536&1023)&65535,f=2):(m[f]=h&65535,f=1);f=k+f}return c};ai.prototype.R=function(a){return Wea.prototype.b.call(this,a)};function $ea(){}var afa,bfa;l($ea,n);function cfa(){bi();return afa}function bi(){bi=function(){};bfa=new dfa;afa=new efa}function dfa(){}l(dfa,$ea);dfa.prototype.toString=function(){return""};
function efa(){}l(efa,$ea);efa.prototype.toString=function(){return"unknown"};function D(){}l(D,n);function ffa(a,b){a=cca(a);for(b=b.h();b.i();){var c=b.j();zd(a,c)}return a.toString()}function Ig(a){return String.fromCharCode(a)}function Tb(a,b,c){c=b+c;var d=a.length;if(0>b||c>d||c<b)throw a=new Uda,sa(a,"fromIndex: "+b+", toIndex: "+c+", length: "+d),a.a(Error(a)),a.s;for(d="";b<c;){var e=Math.min(b+1E4,c);d=r(d)+r(String.fromCharCode.apply(null,a.slice(b,e)));b=e}return d}
function Qg(a){return Tb(a,0,a.length)}function r(a){return null==a?"null":Be(a)}function gfa(a){for(var b=0;0<=(b=a.indexOf("\\",b));)a=36==a.charCodeAt(b+1)?r(ne(a,0,b))+"$"+r(Na(a,++b)):r(ne(a,0,b))+r(Na(a,++b));return a}function ci(a){if(65536<=a){var b=56320+(a-65536&1023)&65535;return r(Ig(55296+(a-65536>>10&1023)&65535))+r(Ig(b))}return Ig(a&65535)}function uh(a,b){return a.charCodeAt(b)}function jc(a,b){return a==b?0:a<b?-1:1}function hi(a,b){return-1!=a.indexOf(b.toString())}
function ii(a,b){var c=b.length;return q(a.substr(a.length-c,c),b)}function ji(a,b){return q(a,b)}function hfa(a,b){return null==b?!1:q(a,b)?!0:a.length==b.length&&q(a.toLowerCase(),b.toLowerCase())}function ki(a,b){b=ci(b);return a.indexOf(b)}function li(a,b,c){b=ci(b);return a.indexOf(b,c)}function ue(a){return 0==a.length}function mi(a,b){b=ci(b);return a.lastIndexOf(b)}function ifa(a,b){return(new RegExp("^("+r(b)+")$")).test(a)}
function ni(a,b,c,d,e,f){if(0>c||0>e||c+f>a.length||e+f>d.length)return!1;if(0>=f)return!0;a=a.substr(c,f);d=d.substr(e,f);return b?hfa(a,d):q(a,d)}function oi(a,b,c){b=na(b);b="\\u"+r("0000".substr(b.length))+r(b);return a.replace(new RegExp(b,"g"),String.fromCharCode(c))}function pi(a,b,c){b=qi(b.toString(),"([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])","\\\\$1");c=qi(qi(c.toString(),"\\\\","\\\\\\\\"),"\\$","\\\\$");return qi(a,b,c)}
function qi(a,b,c){c=gfa(c);return a.replace(new RegExp(b,"g"),c)}function jfa(a,b,c){c=gfa(c);return a.replace(new RegExp(b),c)}function ri(a,b,c){var d=new RegExp(b,"g");b=Ba([0],D,z,D.a);for(var e=0,f=a,h=null;;){var k=d.exec(f);if(!k||""===f||e==c-1&&0<c){b[e]=f;break}else{var m=k.index;b[e]=ne(f,0,m);f=ne(f,m+k[0].length,f.length);d.lastIndex=0;q(h,f)&&(b[e]=ne(f,0,1),f=f.substr(1));h=f;e++}}if(0==c&&0<a.length){for(a=b.length;0<a&&""===b[a-1];)--a;a<b.length&&(b.length=a)}return b}
function si(a,b){return q(a.substr(0,b.length),b)}function Na(a,b){return a.substr(b)}function ne(a,b,c){return a.substr(b,c-b)}function Ci(a){for(var b=a.length,c=Ba([b],Ob,Pb,0),d=0,e=0;d<b;)xd(c,e++,uh(a,d++));return c}function Di(a){var b=(bi(),bfa);return q(b,cfa())?a.toLocaleLowerCase():a.toLowerCase()}function kfa(a){var b=(bi(),bfa);return q(b,cfa())?a.toLocaleUpperCase():a.toUpperCase()}
function Ei(a){for(var b=a.length,c=0;c<b&&32>=a.charCodeAt(c);)c++;for(var d=b;d>c&&32>=a.charCodeAt(d-1);)d--;return 0<c||d<b?ne(a,c,d):a}function z(a){return"string"===typeof a}D.prototype.im=!0;D.prototype.ba=!0;function Ca(){this.a=0}l(Ca,n);Ca.prototype.J=function(a){return Da(a)?this.a==a.a&&q(this.f,a.f)&&q(this.c,a.c)&&q(this.b,a.b):!1};Ca.prototype.P=function(){return Bg([Dc(this.a),this.c,this.f,this.b])};
Ca.prototype.toString=function(){return r(this.c)+"."+r(this.f)+"("+r(null!=this.b?this.b:"Unknown Source")+String(0<=this.a?":"+this.a:"")+")"};function Da(a){return a instanceof Ca}Ca.prototype.ba=!0;function Fi(a,b,c,d,e){Jg(a);Jg(c);var f=a.length,h=c.length;if(0>b||0>d||0>e||b+e>f||d+e>h)throw xaa().s;0<e&&vd(a,b,c,d,e,!0)}function Gi(){return gb(Date.now())}function Hi(a){if(!a)throw lb().s;}function Ii(a,b){if(!a)throw va(r(b)).s;}function Ji(a,b,c){if(!a)throw va(Ki(b,[Dc(c)])).s;}
function Li(a,b,c){if(!a)throw va(Ki(b,[c])).s;}function E(a){if(!a)throw ob().s;}function F(a,b){if(!a)throw pb(r(b)).s;}function Mi(a,b,c){if(!a)throw pb(Ki(b,[c])).s;}function Ni(a,b,c,d){if(!a)throw pb(Ki(b,[c,d])).s;}function G(a){if(null==a)throw qb().s;return a}function Oi(a,b){if(null==a)throw rb(r(b)).s;return a}function Pi(a,b,c){if(null==a)throw rb(Ki(b,[c])).s;return a}
function Qi(a,b){if(0>a||a>=b){if(0>a)a=Ki("%s (%s) must not be negative",["index",Dc(a)]);else{if(0>b)throw va("negative size: "+b).s;a=Ki("%s (%s) must be less than size (%s)",["index",Dc(a),Dc(b)])}throw La(a).s;}}function Ri(a,b){if(0>a||a>b)throw La(lfa(a,b,"index")).s;}function lfa(a,b,c){if(0>a)return Ki("%s (%s) must not be negative",[c,Dc(a)]);if(0>b)throw va("negative size: "+b).s;return Ki("%s (%s) must not be greater than size (%s)",[c,Dc(a),Dc(b)])}
function mfa(a,b,c){if(0>a||b<a||b>c)throw a=0>a||a>c?lfa(a,c,"start index"):0>b||b>c?lfa(b,c,"end index"):Ki("end index (%s) must not be less than start index (%s)",[Dc(b),Dc(a)]),La(a).s;}function Si(a){return new Wi(a)}function Xi(){}l(Xi,n);
function nfa(){switch(le("0123456789_.")){case 0:return Yi(),Zi;case 1:return $i(me("0123456789_.",0));case 2:var a=me("0123456789_.",1),b=new aj;b.a=me("0123456789_.",0);b.b=a;return b;default:return a=new bj,a.a=Ci("0123456789_.".toString()),a.a.sort(Rda()),a}}g=Xi.prototype;g.cb=function(){var a=new cj;a.a=G(this);return a};g.Tf=function(a){var b=new dj;b.a=G(this);b.b=G(a);return b};g.sh=function(a){for(var b=le(a)-1;0<=b;b--)if(!this.Ac(me(a,b)))return!1;return!0};
g.Rk=function(a){return-1==this.Ll(a)};g.Ll=function(a){return this.mj(a,0)};g.mj=function(a,b){var c=le(a);for(Ri(b,c);b<c;b++)if(this.Ac(me(a,b)))return b;return-1};g.ne=function(a){return this.Ac(a.a)};g.toString=function(){return n.prototype.toString.call(this)};function ej(a){for(var b=B([92,117,0,0,0,0],Ob,Pb,1),c=0;4>c;c++)b[5-c]="0123456789ABCDEF".charCodeAt(a&15),a>>=4;return Qg(b)}g.Ca=function(a){return this.ea(a)};function Wi(a){this.a=a}l(Wi,n);
Wi.prototype.ea=function(a){var b;return b=this.a,b(a)};Wi.prototype.Ca=function(a){return this.ea(a)};Wi.prototype.cb=function(){return dd(this)};function fj(a){return new gj(a)}function gj(a){this.a=a}l(gj,n);gj.prototype.f=function(a){var b;return b=this.a,b(a)};gj.prototype.Tc=!0;function hj(a){return new ofa(a)}function ofa(a){this.a=a}l(ofa,n);ofa.prototype.Na=function(){var a;return a=this.a,a()};function ij(){}l(ij,n);ij.prototype.ba=!0;function pfa(){}var qfa;l(pfa,ij);
function jj(){rfa();return qfa}g=pfa.prototype;g.nn=function(){return!1};g.mn=function(){throw pb("Optional.get() cannot be called on an absent value").s;};g.Ng=function(a){return Oi(a,"use Optional.orNull() instead of Optional.or(null)")};g.$m=function(a){return G(a)};g.J=function(a){return q(a,this)};g.P=function(){return 2040732332};g.toString=function(){return"Optional.absent()"};function rfa(){rfa=function(){};qfa=new pfa}function sfa(){this.a=0}var tfa,ufa,vfa,wfa;l(sfa,A);
function kj(a,b){var c=new sfa;c.b=a;c.a=b;return c}sfa.prototype.R=function(a){return A.prototype.c.call(this,a)};function lj(){lj=function(){};tfa=kj("READY",0);ufa=kj("NOT_READY",1);vfa=kj("DONE",2);wfa=kj("FAILED",3)}function mj(){}l(mj,n);
mj.prototype.i=function(){E(!q(this.c,(lj(),wfa)));switch(this.c.a){case 2:return!1;case 0:return!0}var a;this.c=wfa;b:{for(a=this.a;-1!=this.a;){var b=a,c=this.D(this.a);if(-1==c){var d=le(this.b);this.a=-1}else d=c,this.a=this.A(c);if(this.a==a)this.a++,this.a>le(this.b)&&(this.a=-1);else{for(;b<d&&this.g.Ac(me(this.b,b));)b++;for(;d>b&&this.g.Ac(me(this.b,d-1));)d--;if(this.v&&b==d)a=this.a;else{if(1==this.f)for(d=le(this.b),this.a=-1;d>b&&this.g.Ac(me(this.b,d-1));)d--;else this.f--;a=bca(this.b,
b,d).toString();break b}}}this.c=vfa;a=null}this.u=a;q(this.c,vfa)?a=!1:(this.c=tfa,a=!0);return a};mj.prototype.j=function(){if(!this.i())throw Ld().s;this.c=(lj(),ufa);var a=this.u;this.u=null;return a};mj.prototype.ka=function(){throw vb().s;};mj.prototype.da=function(a){zb(this,a)};function nj(){}l(nj,ij);function oj(a){var b=new nj;b.a=a;return b}g=nj.prototype;g.nn=function(){return!0};g.mn=function(){return this.a};
g.Ng=function(a){Oi(a,"use Optional.orNull() instead of Optional.or(null)");return this.a};g.$m=function(a){G(a);return this};g.J=function(a){return a instanceof nj?Yc(this.a,a.a):!1};g.P=function(){return 1502476572+$c(this.a)};g.toString=function(){return"Optional.of("+r(this.a)+")"};function xfa(){this.a=0}var yfa;l(xfa,A);function pj(){pj=function(){};yfa=zfa()}var Afa=hb(1E6),Bfa=Va(2077252342,2147);function qj(){this.a=0}l(qj,xfa);
function zfa(){pj();var a=new qj;a.b="MILLISECONDS";a.a=2;return a}qj.prototype.f=function(){var a=Gi();pj();return 0<ab(a,Bfa)?Ub:0>ab(a,bb(Bfa))?dba:Za(a,Afa)};qj.prototype.R=function(a){return xfa.prototype.c.call(this,a)};function rj(){}var sj;l(rj,n);rj.prototype.a=function(){return"DUMMY"};rj.prototype.toString=function(){return this.a()};function tj(){tj=function(){};sj=new Cfa}rj.prototype.ba=!0;function Cfa(){}l(Cfa,rj);Cfa.prototype.a=function(){return"FINE"};function uj(){}l(uj,n);
function Dfa(){return new uj}uj.prototype.m=function(){return null};function vj(){return!1}
function Ki(a,b){a=r(a);if(b)for(var c=0;c<b.length;c++){var d=b,e=c;var f=b[c];try{var h=r(f)}catch(k){if(k=wa(k),Fa(k))h=k,f=r(ka(Jg(f)))+Ig(64)+r(na(wh(f))),tj(),r(f),h="<"+r(f)+" threw "+r(ka(Jg(h)))+">";else throw k.s;}d[e]=h}else b=["(Object[])null"];c=Og();for(e=d=0;e<b.length;){f=a.indexOf("%s",d);if(-1==f)break;Wf(c,a,d,f);Sg(c,b[e++]);d=f+2}Wf(c,a,d,a.length);if(e<b.length){y(c," [");for(Sg(c,b[e++]);e<b.length;)y(c,", "),Sg(c,b[e++]);Pg(c,93)}return c.toString()}function cj(){}l(cj,Xi);
g=cj.prototype;g.Ac=function(a){return!this.a.Ac(a)};g.sh=function(a){return this.a.Rk(a)};g.Rk=function(a){return this.a.sh(a)};g.cb=function(){return this.a};g.toString=function(){return r(this.a)+".negate()"};g.Ca=function(a){return this.ea(a)};g.ea=function(a){return Xi.prototype.ne.call(this,a)};function wj(){}l(wj,cj);wj.prototype.Ca=function(a){return this.ea(a)};wj.prototype.ea=function(a){return cj.prototype.ne.call(this,a)};function xj(){}l(xj,Xi);
xj.prototype.cb=function(){var a=new wj;a.a=G(this);return a};xj.prototype.Ca=function(a){return this.ea(a)};function yj(){}l(yj,xj);yj.prototype.toString=function(){return this.a};yj.prototype.Ca=function(a){return this.ea(a)};function Efa(){}var Ffa;l(Efa,yj);function Gfa(){var a=new Efa;a.a=G("CharMatcher.any()");return a}g=Efa.prototype;g.Ac=function(){return!0};g.Ll=function(a){return 0==le(a)?-1:0};g.mj=function(a,b){a=le(a);Ri(b,a);return b==a?-1:b};g.sh=function(a){G(a);return!0};
g.Rk=function(a){return 0==le(a)};g.Tf=function(a){G(a);return this};g.cb=function(){return Yi(),Zi};g.Ca=function(a){return this.ea(a)};g.ea=function(a){return yj.prototype.ne.call(this,a)};function Hfa(){Hfa=function(){};Ffa=Gfa()}function bj(){}l(bj,Xi);bj.prototype.Ac=function(a){var b=this.a;a:{for(var c=0,d=b.length-1;c<=d;){var e=c+(d-c>>1),f=b[e];if(f<a)c=e+1;else if(f>a)d=e-1;else{a=e;break a}}a=-c-1}return 0<=a};
bj.prototype.toString=function(){for(var a=ve('CharMatcher.anyOf("'),b=this.a,c=0;c<b.length;c++)y(a,ej(b[c]));y(a,'")');return a.toString()};bj.prototype.Ca=function(a){return this.ea(a)};bj.prototype.ea=function(a){return Xi.prototype.ne.call(this,a)};function zj(){this.a=this.b=0}l(zj,xj);function Aj(a,b){var c=new zj;Hi(b>=a);c.b=a;c.a=b;return c}zj.prototype.Ac=function(a){return this.b<=a&&a<=this.a};
zj.prototype.toString=function(){return"CharMatcher.inRange('"+r(ej(this.b))+"', '"+r(ej(this.a))+"')"};zj.prototype.Ca=function(a){return this.ea(a)};zj.prototype.ea=function(a){return xj.prototype.ne.call(this,a)};function Ifa(){this.a=0}l(Ifa,xj);function $i(a){var b=new Ifa;b.a=a;return b}g=Ifa.prototype;g.Ac=function(a){return a==this.a};g.Tf=function(a){return a.Ac(this.a)?a:xj.prototype.Tf.call(this,a)};g.cb=function(){var a=new Jfa;a.a=this.a;return a};
g.toString=function(){return"CharMatcher.is('"+r(ej(this.a))+"')"};g.Ca=function(a){return this.ea(a)};g.ea=function(a){return xj.prototype.ne.call(this,a)};function aj(){this.b=this.a=0}l(aj,xj);aj.prototype.Ac=function(a){return a==this.a||a==this.b};aj.prototype.toString=function(){return'CharMatcher.anyOf("'+r(ej(this.a))+r(ej(this.b))+'")'};aj.prototype.Ca=function(a){return this.ea(a)};aj.prototype.ea=function(a){return xj.prototype.ne.call(this,a)};function Jfa(){this.a=0}l(Jfa,xj);g=Jfa.prototype;
g.Ac=function(a){return a!=this.a};g.Tf=function(a){return a.Ac(this.a)?(Hfa(),Ffa):this};g.cb=function(){return $i(this.a)};g.toString=function(){return"CharMatcher.isNot('"+r(ej(this.a))+"')"};g.Ca=function(a){return this.ea(a)};g.ea=function(a){return xj.prototype.ne.call(this,a)};function Bj(){}var Kfa;l(Bj,Xi);Bj.prototype.Ac=function(a){return gea(a)};Bj.prototype.toString=function(){return"CharMatcher.javaLetterOrDigit()"};Bj.prototype.Ca=function(a){return this.ea(a)};
Bj.prototype.ea=function(a){return Xi.prototype.ne.call(this,a)};function Lfa(){Lfa=function(){};Kfa=new Bj}function Mfa(){}var Zi;l(Mfa,yj);function Nfa(){var a=new Mfa;a.a=G("CharMatcher.none()");return a}g=Mfa.prototype;g.Ac=function(){return!1};g.Ll=function(a){G(a);return-1};g.mj=function(a,b){Ri(b,le(a));return-1};g.sh=function(a){return 0==le(a)};g.Rk=function(a){G(a);return!0};g.Tf=function(a){return G(a)};g.cb=function(){return Hfa(),Ffa};g.Ca=function(a){return this.ea(a)};
g.ea=function(a){return yj.prototype.ne.call(this,a)};function Yi(){Yi=function(){};Zi=Nfa()}function dj(){}l(dj,Xi);dj.prototype.Ac=function(a){return this.a.Ac(a)||this.b.Ac(a)};dj.prototype.toString=function(){return"CharMatcher.or("+r(this.a)+", "+r(this.b)+")"};dj.prototype.Ca=function(a){return this.ea(a)};dj.prototype.ea=function(a){return Xi.prototype.ne.call(this,a)};function Fj(){}var Ofa;l(Fj,yj);function Pfa(){Qfa();var a=new Fj;a.a=G("CharMatcher.whitespace()");return a}
Fj.prototype.Ac=function(a){return"\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\x0B\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charCodeAt(1682554634*a>>>Rfa|0)==a};Fj.prototype.Ca=function(a){return this.ea(a)};Fj.prototype.ea=function(a){return yj.prototype.ne.call(this,a)};function Qfa(){Qfa=function(){};Rfa=qh(31);Ofa=Pfa()}var Rfa=0;var Sfa;
function Tfa(a,b){Gj();G(a);G(b);return Ef(Uc(function(){return Hj()}),Sd(function(c,d){c.L(a.f(d),b.f(d))}),new Cf(function(c,d){G(d);c.a.na(d.a);return c}),u(function(c){return c.Pb()}))}function Ufa(a){Gj();G(a);return Ef(Uc(function(){var b=new Ij;b.a=x();b.b=G(a);return b}),Sd(function(b,c){b.Y(c)}),new Cf(function(b,c){Jj.prototype.Cm.call(b,c);return b}),u(function(b){return b.ga()}))}
function Gj(){Gj=function(){};Sfa=Ef(Uc(function(){return Kj()}),Sd(function(a,b){a.Y(b)}),new Cf(function(a,b){G(b);a.a.na(b.a);return a}),u(function(a){return a.ga()}));Ef(Uc(function(){return Lj()}),Sd(function(a,b){a.Y(b)}),new Cf(function(a,b){return a.Cm(b)}),u(function(a){return a.ga()}))}function Mj(){}l(Mj,n);function Hj(){var a=new Mj;a.a=x();return a}g=Mj.prototype;g.L=function(a,b){this.a.add(Nj(a,b));return this};
g.dl=function(a){a instanceof Oj?(G(a.M()),G(a.N()),this.a.add(a)):this.a.add(Nj(a.M(),a.N()))};g.cl=function(a){return this.bm(a.X())};g.bm=function(a){for(a=a.h();a.i();){var b=a.j();this.dl(b)}return this};g.Pb=function(){if(this.c){var a=this.a;var b=Vfa(this.c);var c=(Pj(),Wfa);b=Xfa(c,b);Rca(a,b)}a:switch(a=this.a,Qj(),a.w()){case 0:a=Rj();break a;case 1:a=Sj(a);a=Tj(a.M(),a.N());break a;default:a=a.ob(Ba([a.w()],Nd,Od,Nd.a)),a=Yfa(a)}return a};
function Uj(a,b){if(null==a)throw rb("null key in entry: null="+r(b)).s;if(null==b)throw rb("null value in entry: "+r(a)+"=null").s;}function Vj(a,b){if(0>a)throw va(r(b)+" cannot be negative but was: "+a).s;return a}function Wj(a){F(a,"no calls to next() since the last call to remove()")}function Xj(){}l(Xj,n);Xj.prototype.toString=function(){return Be(this.Ab())};function ck(){}l(ck,Xj);g=ck.prototype;g.h=function(){return this.Ab().h()};g.w=function(){return this.Ab().w()};g.Qb=function(a){return this.Ab().Qb(a)};
g.G=function(){return this.Ab().G()};g.B=function(a){return this.Ab().B(a)};g.add=function(a){return this.Ab().add(a)};g.ra=function(a){return this.Ab().ra(a)};g.Db=function(a){return this.Ab().Db(a)};g.na=function(a){return this.Ab().na(a)};g.ia=function(){this.Ab().ia()};g.qc=function(){return this.Ab().qc()};g.ob=function(a){return this.Ab().ob(a)};g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;
function dk(){}l(dk,ck);g=dk.prototype;g.J=function(a){return q(a,this)||Yc(this.Ab(),a)};g.P=function(){return $c(this.Ab())};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;function Zfa(){}l(Zfa,dk);g=Zfa.prototype;g.Ab=function(){return this.a.a.X()};g.B=function(a){if(Od(a)&&null==a.M())return!1;try{return dk.prototype.B.call(this,a)}catch(b){throw b=wa(b),b.s;}};
g.ob=function(a){a=dk.prototype.ob.call(this,a);this.w()<a.length&&xd(a,this.w(),null);return a};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function ek(a,b){return q(a,b)||null!=a&&Yc(a,b)}function fk(){}l(fk,n);g=fk.prototype;g.ea=function(a){return Yc(this.a,a)};g.P=function(){return $c(this.a)};g.J=function(a){return a instanceof fk?Yc(this.a,a.a):!1};
g.toString=function(){return"Predicates.equalTo("+r(this.a)+")"};g.Ca=function(a){return this.ea(a)};g.cb=function(){return dd(this)};g.ba=!0;function gk(){this.a=0}var $fa,aga;l(gk,A);gk.prototype.Ca=function(a){return this.ea(a)};gk.prototype.cb=function(){return dd(this)};function hk(){hk=function(){};$fa=bga();aga=cga()}function dga(){this.a=0}l(dga,gk);function bga(){hk();var a=new dga;a.b="ALWAYS_TRUE";a.a=0;return a}g=dga.prototype;g.ea=function(){return!0};g.toString=function(){return"Predicates.alwaysTrue()"};
g.Ca=function(a){return this.ea(a)};g.cb=function(){return dd(this)};g.R=function(a){return gk.prototype.c.call(this,a)};function ega(){this.a=0}l(ega,gk);function cga(){hk();var a=new ega;a.b="IS_NULL";a.a=2;return a}g=ega.prototype;g.ea=function(a){return null==a};g.toString=function(){return"Predicates.isNull()"};g.Ca=function(a){return this.ea(a)};g.cb=function(){return dd(this)};g.R=function(a){return gk.prototype.c.call(this,a)};function ik(){return hk(),$fa}
function jk(a){if(null==a)a=(hk(),aga);else{var b=new fk;b.a=a;a=b}return a}function fga(){}l(fga,n);g=fga.prototype;g.wb=function(a){var b=this;return this.a.wb(yb(function(c){a.Ob(b.b.f(c))}))};g.da=function(a){var b=this;this.a.da(yb(function(c){a.Ob(b.b.f(c))}))};g.nd=function(){return this.a.nd()};g.sd=function(){return this.a.sd()&-262};g.gc=function(a){return pc(this,a)};function gga(){}l(gga,n);g=gga.prototype;g.Ob=function(a){this.a=a};
g.wb=function(a){for(;this.b.wb(this);)try{if(this.c.Ca(this.a))return a.Ob(this.a),!0}finally{this.a=null}return!1};g.nd=function(){return Paa(this.b.nd(),hb(2))};g.sd=function(){return this.b.sd()&277};g.da=function(a){oc(this,a)};g.gc=function(a){return pc(this,a)};function hga(){this.b=0}l(hga,n);g=hga.prototype;g.wb=function(a){var b=this;return this.a.Bf(new Cc(function(c){a.Ob($ca(b.c,c))}))};g.da=function(a){var b=this;this.a.bg(new Cc(function(c){a.Ob($ca(b.c,c))}))};g.nd=function(){return this.a.nd()};
g.sd=function(){return 16464|this.b};g.gc=function(a){return pc(this,a)};function kk(){this.c=0;this.b=hb(0)}l(kk,n);g=kk.prototype;g.wb=function(a){for(var b=this;;){if(null!=this.a&&this.a.wb(a))return this.b.J(Ub)||(this.b=Ya(this.b,hb(1))),!0;this.a=null;if(!this.f.wb(yb(function(c){b.a=b.g.f(c)})))return!1}};g.da=function(a){var b=this;null!=this.a&&(this.a.da(a),this.a=null);this.f.da(yb(function(c){(c=b.g.f(c))&&c.da(a)}));this.b=hb(0)};
g.nd=function(){null!=this.a&&(this.b=Nb(this.b,this.a.nd()));return Nb(this.b,hb(0))};g.sd=function(){return this.c};g.gc=function(a){return pc(this,a)};function iga(){kk.call(this)}l(iga,kk);iga.prototype.gc=function(a){return pc(this,a)};function jga(a,b){return kga(a,1296,b,null)}function kga(a,b,c,d){d&&Hi(0!=(b&4));if(0>=a)a=Fda();else if(--a,0>a)a=Fda();else{d=new Sda;var e=Ab(a+1);d.c=0;d.b=a;Kc(d,e,17493);d.a=d.c;a=Gda(d)}a=a.Ie();d=new hga;d.c=c;d.b=b;d.a=a;return d}
function lk(a,b){G(a);G(b);var c=new fga;c.a=a;c.b=b;return c}function mk(a,b,c,d){Ii(0==(c&16384),"flatMap does not support SUBSIZED characteristic");Ii(0==(c&4),"flatMap does not support SORTED characteristic");G(a);G(b);var e=new iga;e.a=null;e.f=a;e.g=b;e.c=c;e.b=d;return e}function nk(){}l(nk,n);function ok(a){var b=new nk;b.a=G(a);return b}nk.prototype.b=function(a,b){G(a);if(b.i())for(te(a,pk(b.j()));b.i();)te(a,this.a),te(a,pk(b.j()))};function qk(a,b,c){return lga(a,b,c.h())}
function lga(a,b,c){try{a.b(b,c)}catch(d){d=wa(d);if(Ga(d))throw jb(d).s;throw d.s;}return b}function rk(a,b){b=b.h();return lga(a,Ng(),b).toString()}function sk(a,b){return rk(a,hg(b))}function tk(a,b,c,d){G(d);var e=new mga;e.a=d;e.b=b;e.c=c;return rk(a,e)}function pk(a){G(a);return"string"===typeof a||null!=a&&1==a.im?a:Be(a)}function nga(){}l(nga,nk);
nga.prototype.b=function(a,b){Oi(a,"appendable");for(Oi(b,"parts");b.i();){var c=b.j();if(null!=c){te(a,pk(c));break}}for(;b.i();)c=b.j(),null!=c&&(te(a,this.a),te(a,pk(c)))};function mga(){}l(mga,Bd);g=mga.prototype;g.w=function(){return this.a.length+2};g.F=function(a){switch(a){case 0:return this.b;case 1:return this.c;default:return this.a[a-2]}};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function uk(){}l(uk,n);function oga(a){if(a instanceof uk)var b=a;else b=new vk,b.b=a,G(a),a=q(b,a)?null:a,a=null==a?jj():oj(a),b.a=a;return b}function pga(a){G(a);var b=new wk;b.b=a;b.a=jj();return b}function xk(a){for(var b=0;b<a.length;b++)G(a[b]);b=new yk;b.b=a;b.a=jj();return b}g=uk.prototype;g.toString=function(){return qga(this.a.Ng(this).h())};g.T=function(){return zk(this.a.Ng(this))};g.Z=function(a){uc(this,a)};g.W=function(){return wc(this)};g.Wa=!0;
function vk(){}l(vk,uk);vk.prototype.h=function(){return this.b.h()};vk.prototype.Z=function(a){uc(this,a)};vk.prototype.W=function(){return wc(this)};function Ak(){}l(Ak,n);Ak.prototype.ka=function(){throw vb().s;};Ak.prototype.da=function(a){zb(this,a)};function Bk(){}l(Bk,Ak);Bk.prototype.i=function(){return this.a.i()};Bk.prototype.j=function(){return this.a.j()};Bk.prototype.da=function(a){zb(this,a)};function Ck(){this.a=!1}l(Ck,Ak);Ck.prototype.i=function(){return!this.a};
Ck.prototype.j=function(){if(this.a)throw Ld().s;this.a=!0;return this.b};Ck.prototype.da=function(a){zb(this,a)};function rga(){this.a=0}var sga,tga,uga,vga;l(rga,A);function Dk(a,b){var c=new rga;c.b=a;c.a=b;return c}rga.prototype.R=function(a){return A.prototype.c.call(this,a)};function Ek(){Ek=function(){};sga=Dk("READY",0);tga=Dk("NOT_READY",1);uga=Dk("DONE",2);vga=Dk("FAILED",3)}function Fk(){}l(Fk,Ak);function Gk(a){a.b=(Ek(),uga);return null}
Fk.prototype.i=function(){E(!q(this.b,(Ek(),vga)));switch(this.b.a){case 2:return!1;case 0:return!0}this.b=vga;this.g=this.c();if(q(this.b,uga))var a=!1;else this.b=sga,a=!0;return a};Fk.prototype.j=function(){if(!this.i())throw Ld().s;this.b=(Ek(),tga);var a=this.g;this.g=null;return a};Fk.prototype.da=function(a){zb(this,a)};function Hk(a){a.b=(Ek(),tga)}function Ik(){}l(Ik,Fk);Ik.prototype.c=function(){for(;this.a.i();){var a=this.a.j();if(this.f.ea(a))return a}return Gk(this)};
Ik.prototype.da=function(a){zb(this,a)};function Jk(){}l(Jk,n);Jk.prototype.i=function(){return this.a.i()};Jk.prototype.j=function(){return this.b(this.a.j())};Jk.prototype.ka=function(){this.a.ka()};Jk.prototype.da=function(a){zb(this,a)};function Kk(){}l(Kk,Jk);function wga(a,b){var c=new Kk;c.c=a;c.a=G(b);return c}Kk.prototype.b=function(a){return this.c.f(a)};Kk.prototype.da=function(a){zb(this,a)};function Lk(){this.c=this.b=0}l(Lk,n);Lk.prototype.i=function(){return this.b<this.c&&this.a.i()};
Lk.prototype.j=function(){if(!this.i())throw Ld().s;this.b++;return this.a.j()};Lk.prototype.ka=function(){this.a.ka()};Lk.prototype.da=function(a){zb(this,a)};function Mk(){}l(Mk,Ak);Mk.prototype.te=function(){throw vb().s;};Mk.prototype.Ed=function(){throw vb().s;};Mk.prototype.da=function(a){zb(this,a)};function Nk(){this.a=this.b=0}l(Nk,Mk);g=Nk.prototype;g.i=function(){return this.a<this.b};g.j=function(){if(!this.i())throw Ld().s;return this.c(this.a++)};g.pd=function(){return this.a};
g.Ec=function(){return 0<this.a};g.Gc=function(){if(!this.Ec())throw Ld().s;return this.c(--this.a)};g.Od=function(){return this.a-1};g.da=function(a){zb(this,a)};function Ok(){Nk.call(this);this.f=0}var Pk;l(Ok,Nk);function xga(){Qk();var a=new Ok;Ri(0,0);a.b=0;a.a=0;a.g=[];a.f=0;return a}Ok.prototype.c=function(a){return this.g[this.f+a]};Ok.prototype.da=function(a){zb(this,a)};function Qk(){Qk=function(){};Pk=xga()}function Rk(){this.f=this.c=this.b=0}l(Rk,n);
Rk.prototype.i=function(){return this.b!=this.c};Rk.prototype.j=function(){Ic(this.i());this.b=this.b-1&this.a.a.length-1;var a=this.a.a[this.b];yga(this.c==this.a.b&&null!=a);this.f=this.b;return a};Rk.prototype.ka=function(){0<zga(this.a,this.f)&&(this.b=this.b+1&this.a.a.length-1,this.c=this.a.b);this.f=-1};Rk.prototype.da=function(a){zb(this,a)};function Uk(){this.f=this.c=this.b=0}l(Uk,n);Uk.prototype.i=function(){return this.b!=this.c};
Uk.prototype.j=function(){Ic(this.i());var a=this.a.a[this.b];yga(this.c==this.a.c&&null!=a);this.f=this.b;this.b=this.b+1&this.a.a.length-1;return a};Uk.prototype.ka=function(){0>zga(this.a,this.f)&&(this.b=this.b-1&this.a.a.length-1,this.c=this.a.c);this.f=-1};Uk.prototype.da=function(a){zb(this,a)};function Vk(){this.c=this.b=0}l(Vk,wd);function yga(a){if(!a)throw Oe().s;}function Wk(){var a=new Vk;a.a=Array(8);return a}
function Xk(a){var b=new Vk,c=a.w();b.a=Array(8);b.a.length=ph(Math.max(8,c))<<1;b.na(a);return b}function Aga(a){var b=new Vk;b.a=Array(8);b.a.length=ph(Math.max(8,a))<<1;return b}g=Vk.prototype;g.add=function(a){this.Bc(a);return!0};g.me=function(a){Af(a);this.b=this.b-1&this.a.length-1;this.a[this.b]=a;Bga(this)};g.Bc=function(a){Af(a);this.a[this.c]=a;this.c=this.c+1&this.a.length-1;Bga(this)};g.ia=function(){this.b!=this.c&&(this.a=Array(8),this.c=this.b=0)};
g.B=function(a){return Cga(this.h(),a)};g.pn=function(){var a=new Rk;a.a=this;a.b=a.a.c;a.c=a.a.b;a.f=-1;return a};g.yg=function(){return this.He()};g.He=function(){return this.a[this.b]};g.wk=function(){return Dga(this)};g.G=function(){return this.b==this.c};g.h=function(){var a=new Uk;a.a=this;a.b=a.a.b;a.c=a.a.c;a.f=-1;return a};g.Ul=function(a){this.Tl(a)};g.Tl=function(a){this.Bc(a)};g.Pa=function(){return this.Uf()};g.Uf=function(){return this.a[this.b]};g.Ce=function(){return Dga(this)};
g.xj=function(){return this.Ah()};g.Ah=function(){var a=this.a[this.b];if(null==a)return null;this.a[this.b]=null;this.b=this.b+1&this.a.length-1;return a};g.tn=function(){var a=Dga(this);if(null==a)return null;this.c=this.c-1&this.a.length-1;this.a[this.c]=null;return a};g.Ta=function(){return this.Pd()};g.Fa=function(a){this.me(a)};g.Tg=function(){return this.Pd()};g.ra=function(a){return this.bn(a)};g.Pd=function(){return this.Ah()};g.bn=function(a){var b=this.h();Cga(b,a)?(b.ka(),a=!0):a=!1;return a};
g.Vf=function(){return this.tn()};g.w=function(){return this.c-this.b&this.a.length-1};g.W=function(){return Sc(this,272)};g.ob=function(a){var b=this.w();a.length<b&&(a=sd(Array(b),a));Ega(this,a,b);a.length>b&&(a[b]=null);return a};function Cga(a,b){if(null==b)return!1;for(;a.i();)if(Yc(b,a.j()))return!0;return!1}function Dga(a){return a.a[a.c-1&a.a.length-1]}function Ega(a,b,c){for(var d=a.a.length-1,e=a.b,f=0;f<c;e=e+1&d,++f)b[f]=a.a[e]}
function Bga(a){if(a.b==a.c){var b=a.a.length,c=ph(Math.max(8,b))<<1;0!=a.b?(c=sd(Array(c),a.a),Ega(a,c,b),a.a=c,a.b=0):a.a.length=c;a.c=b}}function zga(a,b){var c=a.a.length-1,d=b-a.b&c,e=a.c-b&c;yga(d<(a.c-a.b&c));if(d>=e){c=a.a.length-1;for(a.c=a.c-1&c;b!=a.c;)d=b+1&c,a.a[b]=a.a[d],b=d;a.a[a.c]=null;return-1}for(c=a.a.length-1;b!=a.b;)d=b-1&c,a.a[b]=a.a[d],b=d;a.a[a.b]=null;a.b=a.b+1&c;return 1}g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};
g.Wa=!0;g.yb=!0;function Yk(){}l(Yk,n);function Fga(a){var b=new Yk;b.c=(Qk(),Pk);b.a=G(a);return b}Yk.prototype.i=function(){for(;!G(this.c).i();){a:{for(;!this.a||!this.a.i();)if(this.b&&!this.b.G())this.a=this.b.Pd();else{var a=null;break a}a=this.a}this.a=a;if(!this.a)return!1;this.c=this.a.j();if(this.c instanceof Yk){a=this.c;this.c=a.c;this.b||(this.b=Wk());this.b.me(this.a);if(a.b)for(;!a.b.G();)this.b.me(a.b.Vf());this.a=a.a}}return!0};
Yk.prototype.j=function(){if(this.i())return this.f=this.c,this.c.j();throw Ld().s;};Yk.prototype.ka=function(){Wj(!!this.f);this.f.ka();this.f=null};Yk.prototype.da=function(a){zb(this,a)};function Gga(){this.a=0}var Zk;l(Gga,A);function Hga(){var a=new Gga;a.b="INSTANCE";a.a=0;return a}g=Gga.prototype;g.i=function(){return!1};g.j=function(){throw Ld().s;};g.ka=function(){Wj(!1)};g.da=function(a){zb(this,a)};g.R=function(a){return A.prototype.c.call(this,a)};
function $k(){$k=function(){};Zk=Hga()}function al(){this.a=this.b=0}l(al,n);al.prototype.i=function(){return this.b<this.c.a.w()};al.prototype.j=function(){this.i();this.a=this.b++;return this.c.a.F(this.a)};al.prototype.ka=function(){Iga(this.c,this.b=this.a);this.a=-1};al.prototype.da=function(a){zb(this,a)};function Jga(){}l(Jga,kca);g=Jga.prototype;g.na=function(a){var b=this.a.w();for(a=a.h();a.i();){var c=a.j();this.a.add(Af(c))}return b!=this.a.w()?(bl(this,0),!0):!1};g.ia=function(){this.a.ia()};
g.B=function(a){return-1!=(null==a?-1:this.a.indexOf(a))};g.h=function(){var a=new al;a.c=this;a.b=0;a.a=-1;return a};g.Ul=function(a){Af(a);var b=this.a.w();for(this.a.add(a);0<b;){var c=b;b=(b-1)/2|0;if(0>=this.b.Oa(this.a.F(b),a)){this.a.Ub(c,a);return}this.a.Ub(c,this.a.F(b))}this.a.Ub(b,a)};g.Pa=function(){return this.a.G()?null:this.a.F(0)};g.xj=function(){var a=this.Pa();null!=a&&Iga(this,0);return a};g.ra=function(a){a=null==a?-1:this.a.indexOf(a);if(0>a)return!1;Iga(this,a);return!0};
g.Qb=function(a){return this.a.Qb(a)?(bl(this,0),!0):!1};g.w=function(){return this.a.w()};g.W=function(){return Sc(this,256)};g.qc=function(){return this.a.qc()};g.ob=function(a){return this.a.ob(a)};function bl(a,b){var c=a.a.w();2*b+1>=c||(bl(a,2*b+1),c=2*b+2,c<a.a.w()&&bl(a,c),Kga(a,b))}function Kga(a,b){for(var c=a.a.w(),d=a.a.F(b);!(2*b+1>=c);){var e=a,f=2*b+1,h=f+1;var k=f;h<c&&0>e.b.Oa(e.a.F(h),e.a.F(f))&&(k=h);if(0>a.b.Oa(d,a.a.F(k)))break;a.a.Ub(b,a.a.F(k));b=k}a.a.Ub(b,d)}
function Iga(a,b){var c=a.a.Ya(a.a.w()-1);b<a.a.w()&&(a.a.Ub(b,c),Kga(a,b))}g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function cl(){this.a=!1}l(cl,n);cl.prototype.i=function(){return this.a||this.b.i()};cl.prototype.j=function(){if(!this.a)return this.b.j();var a=this.c;this.a=!1;this.c=null;return a};cl.prototype.ka=function(){F(!this.a,"Can't remove after you've peeked at next");this.b.ka()};cl.prototype.da=function(a){zb(this,a)};
function dl(){}var Lga;l(dl,n);function Mga(a){var b=fba();Qj();return Tfa(a,b)}function Rj(){Qj();return Lga}function Tj(a,b){Qj();Uj(a,b);var c=new el,d=Pca(G(a),G(b));fl(c,d);c.u=a;c.g=b;return c}function Nga(a,b,c,d,e,f){Qj();return Yfa(B([Nj(a,b),Nj(c,d),Nj(e,f)],Nd,Od,1))}function gl(){Qj();return Hj()}function Nj(a,b){Qj();Uj(a,b);return hl(a,b)}
function il(a){var b;Qj();if(a instanceof dl&&!(a instanceof jl))return a;if(a instanceof kl){for(b=a.X().h();b.i();){var c=b.j();G(c.M());G(c.N())}b=new kl;b.a=Oga(a.a);b.b=ud(a.b,a.b.length);return Pga(b)}switch(a.va()){case 0:return Rj();case 1:return a=Sj(a.X()),Tj(a.M(),a.N());default:b=Of();for(a=a.X().h();a.i();)c=a.j(),b.C(G(c.M()),G(c.N()));return Qga(b)}}g=dl.prototype;g.C=function(){throw vb().s;};g.za=function(){throw vb().s;};g.Hd=function(){throw vb().s;};
g.Aa=function(){throw vb().s;};g.Ka=function(){return 0==this.va()};g.V=function(a){return null!=this.get(a)};g.Uc=function(a){return this.values().B(a)};g.X=function(){if(this.b)var a=this.b;else a=new Zfa,a.a=this,a=this.b=Rga(a);return a};g.pa=function(){return this.c?this.c:this.c=this.bf()};g.bf=function(){ll();var a=new Sga;a.a=this;return a};function Tga(a){return lk(a.X().W(),u(function(b){return b.M()}))}g.values=function(){return this.f?this.f:this.f=this.zh()};
g.zh=function(){ll();var a=new Uga;a.a=this;return a};g.J=function(a){a=q(this,a)?!0:fe(a)?Yc(this.X(),a.X()):!1;return a};g.P=function(){return this.X().P()};g.toString=function(){var a=this.va();Vj(a,"size");a=Pg(Og(),123);for(var b=!0,c=this.X().h();c.i();){var d=c.j();b||y(a,", ");b=!1;Sg(Pg(Sg(a,d.M()),61),d.N())}return Pg(a,125).toString()};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};
g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Qj(){Qj=function(){};Lga=Yfa(B([],Nd,Od,1))}g.td=!0;g.ba=!0;function ml(){}l(ml,dl);function fl(a,b){a.b=null;a.c=null;a.f=null;a.a=uf(b)}g=ml.prototype;g.Ka=function(){return this.a.Ka()};g.V=function(a){return nl(this.a,a)};g.Uc=function(a){return this.a.Uc(a)};g.get=function(a){return null==a?null:ol(this.a,a)};g.bf=function(){return Rga(this.a.pa())};
g.zh=function(){var a=this.a.values();ll();return Vga(a)};g.va=function(){return this.a.va()};g.J=function(a){return Yc(this.a,a)};g.P=function(){return $c(this.a)};g.toString=function(){return Be(this.a)};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function pl(){}l(pl,ml);
function Pga(a){Qj();for(var b=G(a).X().h();b.i();){var c=b.j();G(c.M());G(c.N())}b=new pl;fl(b,a);return b}g=pl.prototype;g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function ql(){}l(ql,Ak);ql.prototype.i=function(){return this.a.i()};ql.prototype.j=function(){return this.a.j().M()};
ql.prototype.da=function(a){zb(this,a)};function rl(){}l(rl,n);g=rl.prototype;g.Qc=function(){throw vb().s;};g.J=function(a){return Od(a)?ek(this.M(),a.M())&&ek(this.N(),a.N()):!1};g.P=function(){var a=this.M(),b=this.N();return(null==a?0:$c(a))^(null==b?0:$c(b))};g.toString=function(){return r(this.M())+"="+r(this.N())};g.tg=!0;function Oj(){}l(Oj,rl);function hl(a,b){var c=new Oj;c.f=a;c.c=b;return c}Oj.prototype.M=function(){return this.f};Oj.prototype.N=function(){return this.c};
Oj.prototype.Qc=function(){throw vb().s;};Oj.prototype.ba=!0;function sl(){}l(sl,Jk);sl.prototype.da=function(a){zb(this,a)};sl.prototype.b=function(a){return a.M()};function tl(){}l(tl,Jk);function Wga(a){var b=new tl;b.a=G(a);return b}tl.prototype.da=function(a){zb(this,a)};tl.prototype.b=function(a){return a.N()};function ul(){}l(ul,Jk);function Xga(a,b){var c=new ul;c.c=a;c.a=G(b);return c}ul.prototype.b=function(a){return Yga(a,this.c.f(a))};ul.prototype.da=function(a){zb(this,a)};
function vl(){}l(vl,we);function Al(){var a=new vl;a.a=af();return a}g=vl.prototype;g.mb=function(a,b){return this.V(a)?this.get(a):this.C(a,b)};g.ub=function(a,b){return this.V(a)&&Yc(this.get(a),b)?(this.za(a),!0):!1};g.V=function(a){if(null==a)throw qb().s;return this.a.V(a)};g.get=function(a){if(null==a)throw qb().s;return this.a.get(a)};g.C=function(a,b){if(null==a||null==b)throw qb().s;return this.a.C(a,b)};g.Uc=function(a){if(null==a)throw qb().s;return this.a.Uc(a)};
g.za=function(a){if(null==a)throw qb().s;return this.a.za(a)};g.X=function(){return this.a.X()};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.vb=function(a){ee(this,a)};g.td=!0;function Bl(){}l(Bl,n);Bl.prototype.Pe=function(a){G(a);for(var b=0;b<a.length;b++)this.Y(G(a[b]));return this};Bl.prototype.jb=function(a){G(a);for(a=a.h();a.i();){var b=a.j();this.Y(G(b))}return this};function Jj(){}
l(Jj,Bl);function Cl(){var a=new Jj;a.a=x();return a}g=Jj.prototype;g.Y=function(a){this.a.add(G(a));return this};g.Pe=function(a){G(a);this.a.w();Bl.prototype.Pe.call(this,a);return this};g.jb=function(a){jd(a)&&(this.a.w(),a.w());Bl.prototype.jb.call(this,a);return this};g.Cm=function(a){this.a.na(a.a);return this};g.ga=function(){return Zga(this.a.h())};function Ij(){}l(Ij,Jj);Ij.prototype.Y=function(a){Jj.prototype.Y.call(this,a);return this};
Ij.prototype.Pe=function(a){Jj.prototype.Pe.call(this,a);return this};Ij.prototype.jb=function(a){Jj.prototype.jb.call(this,a);return this};Ij.prototype.ga=function(){return $ga(this.b,this.a.h())};function Dl(){}l(Dl,n);function Vfa(a){if(!(a instanceof Dl)){var b=new El;b.a=G(a);a=b}return a}g=Dl.prototype;g.Cf=function(){var a=new Fl;a.a=G(this);return a};g.Mg=function(){var a=new Gl;a.a=this;return a};g.uh=function(){var a=new Hl;a.a=this;return a};g.ac=function(){return gc(this)};
g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};function Il(){}l(Il,Dl);function Xfa(a,b){var c=new Il;c.a=G(a);c.b=G(b);return c}g=Il.prototype;g.Oa=function(a,b){return this.b.Oa(this.a.f(a),this.a.f(b))};g.J=function(a){return q(a,this)?!0:a instanceof Il?this.a.J(a.a)&&Yc(this.b,a.b):!1};g.P=function(){return Bg([this.a,this.b])};g.toString=function(){return r(this.b)+".onResultOf("+r(this.a)+")"};g.ac=function(){return gc(this)};g.ic=function(a){return ac(this,a)};
g.oc=function(a){return bc(this,a)};g.ba=!0;function El(){}l(El,Dl);g=El.prototype;g.Oa=function(a,b){return this.a.Oa(a,b)};g.J=function(a){return q(a,this)?!0:a instanceof El?this.a.J(a.a):!1};g.P=function(){return $c(this.a)};g.toString=function(){return Be(this.a)};g.ac=function(){return gc(this)};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.ba=!0;function aha(){}var bha;l(aha,Dl);g=aha.prototype;g.Cf=function(){return Jl(),Kl};g.toString=function(){return"Ordering.natural().reverse()"};
g.ac=function(){return gc(this)};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.Oa=function(a,b){G(a);return q(a,b)?0:ic(b,a)};function cha(){cha=function(){};bha=new aha}g.ba=!0;function dha(){}var Kl;l(dha,Dl);g=dha.prototype;g.Mg=function(){var a=this.a;a||(a=this.a=Dl.prototype.Mg.call(this));return a};g.uh=function(){var a=this.b;a||(a=this.b=Dl.prototype.uh.call(this));return a};g.Cf=function(){return cha(),bha};g.toString=function(){return"Ordering.natural()"};
g.ac=function(){return gc(this)};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.Oa=function(a,b){G(a);G(b);return ic(a,b)};function Jl(){Jl=function(){};Kl=new dha}g.ba=!0;function Gl(){}l(Gl,Dl);g=Gl.prototype;g.Oa=function(a,b){return q(a,b)?0:null==a?-1:null==b?1:this.a.Oa(a,b)};g.Cf=function(){return this.a.Cf().uh()};g.Mg=function(){return this};g.uh=function(){return this.a.uh()};g.J=function(a){return q(a,this)?!0:a instanceof Gl?Yc(this.a,a.a):!1};
g.P=function(){return $c(this.a)^957692532};g.toString=function(){return r(this.a)+".nullsFirst()"};g.ac=function(){return gc(this)};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.ba=!0;function Hl(){}l(Hl,Dl);g=Hl.prototype;g.Oa=function(a,b){return q(a,b)?0:null==a?1:null==b?-1:this.a.Oa(a,b)};g.Cf=function(){return this.a.Cf().Mg()};g.Mg=function(){return this.a.Mg()};g.uh=function(){return this};g.J=function(a){return q(a,this)?!0:a instanceof Hl?Yc(this.a,a.a):!1};
g.P=function(){return $c(this.a)^-921210296};g.toString=function(){return r(this.a)+".nullsLast()"};g.ac=function(){return gc(this)};g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.ba=!0;function Fl(){}l(Fl,Dl);g=Fl.prototype;g.Oa=function(a,b){return this.a.Oa(b,a)};g.Cf=function(){return this.a};g.P=function(){return-$c(this.a)};g.J=function(a){return q(a,this)?!0:a instanceof Fl?Yc(this.a,a.a):!1};g.toString=function(){return r(this.a)+".reverse()"};g.ac=function(){return gc(this)};
g.ic=function(a){return ac(this,a)};g.oc=function(a){return bc(this,a)};g.ba=!0;function eha(){this.a=0}var fha,gha,hha,iha;l(eha,A);function Ll(a,b){var c=new eha;c.b=a;c.a=b;return c}eha.prototype.R=function(a){return A.prototype.c.call(this,a)};function jha(){jha=function(){};iha=Ll("CEILING",2);fha=Ll("HALF_UP",4);gha=Ll("HALF_EVEN",6);hha=Ll("UNNECESSARY",7)}function kha(a){if(!a)throw Baa("mode was UNNECESSARY, but rounding was necessary").s;}
function lha(a){return 0<ab(a,Ab(2147483647))?2147483647:0>ab(a,Ab(-2147483648))?-2147483648:a.a}function mha(){mha=function(){};B([9,9,9,8,8,8,7,7,7,6,6,6,6,5,5,5,4,4,4,3,3,3,3,2,2,2,1,1,1,0,0,0,0],qc,sc,1);B([1,10,100,1E3,1E4,1E5,1E6,1E7,1E8,1E9],w,Wc,1);B([3,31,316,3162,31622,316227,3162277,31622776,316227766,2147483647],w,Wc,1);B([1,1,2,6,24,120,720,5040,40320,362880,3628800,39916800,479001600],w,Wc,1);B([2147483647,2147483647,65536,2345,477,193,110,75,58,49,43,39,37,35,34,34,33],w,Wc,1)}
function Ml(){}l(Ml,wd);g=Ml.prototype;g.B=function(a){return null!=a&&wd.prototype.B.call(this,a)};g.add=function(){throw vb().s;};g.ra=function(){throw vb().s;};g.na=function(){throw vb().s;};g.Qb=function(){throw vb().s;};g.ia=function(){throw vb().s;};g.df=function(){var a=this.f;return a?a:this.f=this.lk()};g.lk=function(){switch(this.w()){case 0:return Nl();case 1:return Ol(this.h().j());default:var a=this.qc();Pl();var b=new Ql;a=Rl(a);b.b=this;b.a=a;return b}};g.Rd=function(){return!1};
g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function ll(){ll=function(){};Vga(kf())}g.ba=!0;function Sl(){}var nha;l(Sl,Ml);function Tl(){Pl();Gj();return Sfa}function Nl(){Pl();return nha}function Ol(a){Pl();var b=G(a);a=new oha;b=G(b);Cd();var c=new mca;c.a=b;a.a=c;return a}function Ul(a,b){Pl();return Vl(Wl([a,b]))}function pha(a,b,c,d,e,f){Pl();return Vl(Wl([a,b,c,d,e,f]))}
function qha(a,b,c,d,e,f,h,k,m,p,t,v,C){Pl();var M=Array(12+C.length);a=[a,b,c,d,e,f,h,k,m,p,t,v];Fi(a,0,M,0,a.length);Fi(C,0,M,12,C.length);return Vl(Wl(M))}function Xl(a){Pl();G(a);jd(a)?a=Yl(a):(a=a.h(),a=rha(Zl(a)));return a}function Yl(a){Pl();return a instanceof Ml?a.df():rha(a)}function $l(a){Pl();G(a);return Yl(hg(a))}function rha(a){a=a.qc();switch(a.length){case 0:return Nl();case 1:return Ol(a[0]);default:return Vl(Wl(a))}}
function cm(a){Pl();switch(a.w()){case 0:return Nl();case 1:return Ol(a.F(0));default:return Vl(a)}}function Rl(a){Pl();return cm(hg(a))}function sha(a,b){Pl();G(a);b=(jd(b)?b:Zl(b.h())).qc();for(var c=b.length,d=0;d<c;d++)if(null==b[d])throw rb("at index "+d).s;md(b,a);return Rl(b)}function Wl(a){for(var b=0,c=a.length;b<c;b++)if(null==a[b])throw rb("at index "+b).s;return hg(a)}g=Sl.prototype;
g.indexOf=function(a){if(null==a)a=-1;else a:if(pd(this))b:{var b=this.w();if(null==a)for(a=0;a<b;a++){if(null==this.F(a))break b}else for(var c=0;c<b;c++)if(Yc(a,this.F(c))){a=c;break b}a=-1}else{for(b=this.ae();b.i();)if(ek(a,b.j())){a=b.Od();break a}a=-1}return a};
g.lastIndexOf=function(a){if(null==a)a=-1;else a:if(pd(this))b:{if(null==a)for(a=this.w()-1;0<=a;a--){if(null==this.F(a))break b}else for(var b=this.w()-1;0<=b;b--)if(Yc(a,this.F(b))){a=b;break b}a=-1}else{for(b=this.Bb(this.w());b.Ec();)if(ek(a,b.Gc())){a=b.pd();break a}a=-1}return a};g.Ub=function(){throw vb().s;};g.lc=function(){throw vb().s;};g.Ya=function(){throw vb().s;};g.h=function(){return this.ae()};
g.Nb=function(a,b){if(pd(this)){var c=new tha;c.a=G(this)}else c=new uha,c.a=G(this);a=c.Nb(a,b);return cm(a)};g.ae=function(){return this.Bb(0)};g.Bb=function(a){var b=this.w(),c=new dm;c.f=this;Ri(a,b);c.b=b;c.a=a;return c};g.df=function(){return this};g.J=function(a){return vha(this,a)};g.P=function(){for(var a=1,b=this.h();b.i();){var c=b.j();a=31*a+(null==c?0:$c(c));a=~~a}return a};
g.Cf=function(){G(this);var a=jd(this)?Hd(this):Zl(this.h());Cd();if(pd(a))for(var b=0,c=a.w()-1;b<c;++b,--c){var d=a,e=b,f=c,h=d.F(e);d.Ub(e,d.F(f));d.Ub(f,h)}else for(b=a.ae(),c=a.Bb(a.w());b.pd()<c.Od();)d=b.j(),e=c.Gc(),b.Ed(e),c.Ed(d);return cm(a)};function Kj(){Pl();return em()}g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Pl(){Pl=function(){};ll();nha=Vl(kf())}g.Wa=!0;
g.yb=!0;g.Xg=!0;g.Je=!0;function fm(){}l(fm,Sl);g=fm.prototype;g.B=function(a){return this.Ue().B(a)};g.w=function(){return this.Ue().w()};g.G=function(){return this.Ue().G()};g.Rd=function(){return this.Ue().Rd()};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Ql(){}l(Ql,fm);g=Ql.prototype;g.Ue=function(){return this.b};g.Bb=function(a){return this.a.Bb(a)};g.F=function(a){return this.a.F(a)};
g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function wha(){}l(wha,Ql);g=wha.prototype;g.Ue=function(){return Ql.prototype.Ue.call(this)};g.Fd=function(){return this.Ue().Fd()};g.B=function(a){return 0<=this.indexOf(a)};g.W=function(){var a;return kga(this.w(),1301,(a=this.a,new Zca(function(b){return a.F(b)})),this.Fd())};g.nb=function(a){kd(this,a)};g.ca=function(a){return ed(this,a)};
g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;function gm(){}l(gm,Ml);function hm(){ll();return xha(),yha}function im(a,b){ll();return jm([a,b])}function km(a,b,c){ll();return jm([a,b,c])}function lm(a,b,c,d){ll();return jm([a,b,c,d])}function mm(a,b,c,d,e){ll();return jm([a,b,c,d,e])}function nm(a,b,c,d,e,f,h){ll();var k=Jd();Mca(k,[a,b,c,d,e,f]);Mca(k,h);return Zga(k.h())}
function zha(a){ll();G(a);switch(a.length){case 0:return hm();case 1:return om(a[0]);default:return jm(a)}}function pm(a){ll();return a instanceof gm&&!(a instanceof qm)?a:Zga(a.h())}function Zga(a){ll();if(!a.i())return hm();var b=a.j();if(!a.i())return om(b);var c=rm();c.add(G(b));do c.add(G(a.j()));while(a.i());return Rga(c)}function Rga(a){ll();switch(a.w()){case 0:return hm();case 1:return om(a.h().j());default:return Aha(a)}}
function jm(a){var b=rm();Mca(b,a);for(a=b.h();a.i();){var c=a.j();G(c)}switch(b.w()){case 0:return hm();case 1:return om(b.h().j());default:return Aha(b)}}g=gm.prototype;g.J=function(a){return Bha(this,a)};g.P=function(){return Cha(this)};function Lj(){ll();return Cl()}g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;function sm(){}l(sm,gm);g=sm.prototype;g.h=function(){return tm(this.a.h())};
g.B=function(a){return null!=a&&this.a.B(a)};g.Db=function(a){return this.a.Db(a)};g.w=function(){return this.a.w()};g.G=function(){return this.a.G()};g.qc=function(){return this.a.qc()};g.ob=function(a){return this.a.ob(a)};g.toString=function(){return Be(this.a)};g.P=function(){return $c(this.a)};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function qm(){}var um,Dha;l(qm,sm);function Eha(a){vm();return Ufa(a)}
function Fha(a){vm();var b=a.Fd();b||(b=um);return $ga(b,a.h())}function $ga(a,b){vm();G(a);if(!b.i()){G(a);var c;um.J(a)?c=Dha:c=Gha(wm(a));return c}for(a=wm(a);b.i();)c=b.j(),G(c),a.add(c);return Gha(a)}g=qm.prototype;g.Fd=function(){return this.b.Fd()};g.h=function(){return sm.prototype.h.call(this)};g.qc=function(){return Hha(this,Array(this.w()))};g.ob=function(a){var b=a;a=this.w();b.length<a&&(b=zg(b,0),b.length=a);Hha(this,b);b.length>a&&(b[a]=null);return b};
g.B=function(a){try{return null!=a&&this.b.B(a)}catch(b){throw b=wa(b),b.s;}};g.Db=function(a){for(var b=a.h();b.i();)if(null==b.j())return!1;try{return this.b.Db(a)}catch(c){throw c=wa(c),c.s;}};g.W=function(){return Ne(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function vm(){vm=function(){};ll();um=(Jl(),Kl);Dha=Gha(wm(um))}g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;g.Wa=!0;function xm(){this.c=!1}l(xm,qm);
function Gha(a){vm();var b=new xm;b.a=xf(a);b.b=Tca(a);b.c=!1;return b}g=xm.prototype;g.lk=function(){var a=Rl(this.qc());Pl();var b=new wha;b.b=this;b.a=a;return b};g.W=function(){return Ne(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function zm(){}l(zm,ge);function Am(){var a=new zm;a.a=Xh();return a}function wm(a){var b=new zm;b.a=Qea(a);return b}function Iha(a){var b=new zm;b.a=a;return b}g=zm.prototype;
g.add=function(a){return null==this.a.C(a,!1)};g.ia=function(){this.a.Aa()};g.Fd=function(){return this.a.ce()};g.B=function(a){return this.a.V(a)};g.Jf=function(){return Iha(this.a.sf())};g.h=function(){return this.a.pa().h()};g.ra=function(a){return null!=this.a.za(a)};g.w=function(){return this.a.va()};g.Qg=function(a,b){return Iha(this.a.Ee(a,b))};g.W=function(){return Ne(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;
g.Sc=!0;g.ee=!0;g.Yg=!0;g.ba=!0;function Bm(){}var yha;l(Bm,sm);function Aha(a){xha();var b=new Bm;b.a=xf(a);return b}Bm.prototype.W=function(){return Qd(this)};Bm.prototype.ca=function(a){return ed(this,a)};Bm.prototype.T=function(){return fd(this)};Bm.prototype.Z=function(a){uc(this,a)};function xha(){xha=function(){};ll();yha=Aha(lf())}function Jha(){}l(Jha,gm);function om(a){ll();var b=new Jha;b.a=G(a);return b}g=Jha.prototype;g.w=function(){return 1};g.h=function(){var a=new Ck;a.b=this.a;return a};
g.B=function(a){return Yc(this.a,a)};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Cm(){}l(Cm,ef);function rm(){var a=new Cm,b=Of();a.a=b;return a}function Dm(a){var b=new Cm,c=Of();b.a=c;b.na(a);return b}function Kha(){var a=new Cm,b=Uf();a.a=b;return a}g=Cm.prototype;g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;
g.yb=!0;g.Sc=!0;function Em(){}l(Em,sm);Em.prototype.W=function(){return Qd(this)};Em.prototype.ca=function(a){return ed(this,a)};Em.prototype.T=function(){return fd(this)};Em.prototype.Z=function(a){uc(this,a)};function Lha(){}function Fm(a){return null!=a&&!!a.gm}Lha.prototype.gm=!0;function Gm(){}l(Gm,Ml);Gm.prototype.ca=function(a){return ed(this,a)};Gm.prototype.W=function(){return Sc(this,0)};Gm.prototype.T=function(){return fd(this)};Gm.prototype.Z=function(a){uc(this,a)};
function Hm(){this.a=0}l(Hm,Ak);Hm.prototype.i=function(){return 0<this.a||this.b.i()};Hm.prototype.j=function(){if(0>=this.a){var a=this.b.j();this.c=a.b();this.a=a.a()}this.a--;return this.c};Hm.prototype.da=function(a){zb(this,a)};function Mha(){}l(Mha,fm);g=Mha.prototype;g.F=function(a){return this.a.a.F(a).b()};g.Ue=function(){return this.a};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function Nha(){}l(Nha,gm);g=Nha.prototype;g.h=function(){return this.df().h()};g.lk=function(){Pl();var a=new Mha;a.a=this;return a};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Oha(){}l(Oha,Nha);g=Oha.prototype;g.B=function(a){return this.b.B(a)};g.Rd=function(){return!0};g.w=function(){return this.a.w()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function Im(){}l(Im,n);Im.prototype.J=function(a){return Fm(a)?this.a()==a.a()&&ek(this.b(),a.b()):!1};Im.prototype.P=function(){var a=this.b();return(null==a?0:$c(a))^this.a()};Im.prototype.toString=function(){var a=r(this.b()),b=this.a();return 1==b?a:r(a)+" x "+b};Im.prototype.gm=!0;function Jm(){this.c=0}l(Jm,Im);Jm.prototype.b=function(){return this.f};Jm.prototype.a=function(){return this.c};Jm.prototype.ba=!0;
function Km(a,b){G(b);a.uc().Z(yb(function(c){var d=c.b();c=c.a();var e=b.a;e(d,c)}))}function Lm(a,b){G(b);a.uc().Z(yb(function(c){var d=c.b();c=c.a();for(var e=0;e<c;e++)b.Ob(d)}))}function Mm(a){return null!=a&&!!a.il}function Nm(){}l(Nm,Gm);function Om(){ll();return Pha(),Qha}g=Nm.prototype;g.h=function(){var a=this.uc().h(),b=new Hm;b.b=a;return b};g.df=function(){var a=this.c;return a?a:this.c=Gm.prototype.df.call(this)};g.B=function(a){return 0<this.wd(a)};g.Qe=function(){throw vb().s;};
g.Wf=function(){throw vb().s;};g.Sg=function(){throw vb().s;};g.vh=function(){throw vb().s;};g.J=function(a){return Rha(this,a)};g.P=function(){return Cha(this.uc())};g.toString=function(){return this.uc().toString()};g.uc=function(){var a=this.u;a||(this.G()?a=hm():(ll(),a=new Sha,a.a=this),a=this.u=a);return a};function Pm(){ll();var a=new Qm,b=Tha();a.a=b;return a}g.Z=function(a){Lm(this,a)};g.zg=function(a){Km(this,a)};g.W=function(){return Rm(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Wa=!0;g.yb=!0;g.il=!0;function Uha(){this.b=hb(0)}l(Uha,Nm);function Vha(a){ll();var b=a.ob(Ba([0],Lha,Fm,Lha.a));a=bf(Sm(b.length));for(var c=hb(0),d=0;d<b.length;d++){var e=b[d],f=e.a();c=c.add(Ab(f));var h=G(e.b());a.C(h,Dc(f));if(!(e instanceof Jm)){e=d;var k=new Jm,m=k;m.f=h;m.c=f;Vj(f,"count");b[e]=k}}b=Rl(b);d=new Uha;d.g=a;d.a=b;d.b=c;return d}g=Uha.prototype;g.wd=function(a){return this.g.ab(a,Dc(0)).Mb()};
g.oe=function(){var a=this.o;if(!a){a=this.a;ll();var b=new Oha;b.a=a;b.b=this;a=this.o=b}return a};g.Rd=function(){return!1};g.w=function(){return lha(this.b)};g.Z=function(a){Lm(this,a)};g.zg=function(a){Km(this,a)};g.W=function(){return Rm(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};function Tm(){}l(Tm,ge);g=Tm.prototype;g.Qb=function(a){return Wha(this,a)};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function Xha(){}l(Xha,Tm);g=Xha.prototype;g.ia=function(){this.a.ia()};g.B=function(a){return this.a.B(a)};g.Db=function(a){return this.a.Db(a)};g.G=function(){return this.a.G()};g.ra=function(a){return 0<this.a.Wf(a,2147483647)};g.w=function(){return this.a.uc().w()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Yha(){}l(Yha,Xha);g=Yha.prototype;
g.h=function(){var a=this.a,b=a.a.X().h(),c=new Um;c.c=a;c.b=b;return c};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Zha(){}l(Zha,Tm);g=Zha.prototype;g.B=function(a){return Fm(a)?0>=a.a()?!1:this.a.wd(a.b())==a.a():!1};g.ra=function(a){if(Fm(a)){var b=a.b();a=a.a();if(0!=a)return this.a.vh(b,a,0)}return!1};g.ia=function(){this.a.ia()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};
g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function $ha(){}l($ha,Zha);g=$ha.prototype;g.h=function(){return this.a.md()};g.w=function(){return this.a.a.va()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Vm(){}l(Vm,wd);g=Vm.prototype;g.G=function(){return this.uc().G()};g.B=function(a){return 0<this.wd(a)};g.add=function(a){this.Qe(a,1);return!0};g.Qe=function(){throw vb().s;};
g.ra=function(a){return 0<this.Wf(a,1)};g.Wf=function(){throw vb().s;};g.Sg=function(a,b){Vj(b,"count");var c=this.wd(a);b-=c;0<b?this.Qe(a,b):0>b&&this.Wf(a,-b);return c};g.vh=function(a,b,c){Vj(b,"oldCount");Vj(c,"newCount");this.wd(a)==b?(this.Sg(a,c),a=!0):a=!1;return a};g.na=function(a){G(this);G(a);return Mm(a)?aia(this,a):a.G()?!1:Wm(this,a.h())};g.Qb=function(a){a=Mm(a)?a.oe():a;return this.oe().Qb(a)};g.oe=function(){var a=this.c;a||(a=new Yha,a.a=this,this.c=a);return a};
g.uc=function(){var a=this.f;a||(a=new $ha,a.a=this,this.f=a);return a};g.J=function(a){return Rha(this,a)};g.P=function(){return $c(this.uc())};g.toString=function(){return Be(this.uc())};g.Z=function(a){Lm(this,a)};g.zg=function(a){Km(this,a)};g.W=function(){return Rm(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Wa=!0;g.yb=!0;g.il=!0;function Xm(){this.a=0}l(Xm,n);function bia(a){var b=new Xm;b.a=a;return b}function Ym(a,b){var c=a.a;a.a=b;return c}
Xm.prototype.P=function(){return this.a};Xm.prototype.J=function(a){return a instanceof Xm&&a.a==this.a};Xm.prototype.toString=function(){return""+this.a};Xm.prototype.ba=!0;function Um(){}l(Um,n);Um.prototype.i=function(){return this.b.i()};Um.prototype.j=function(){var a=this.b.j();this.a=a;return a.M()};Um.prototype.ka=function(){Wj(!!this.a);this.c.b=Db(this.c.b,Ab(Ym(this.a.N(),0)));this.b.ka();this.a=null};Um.prototype.da=function(a){zb(this,a)};function Zm(){}l(Zm,Im);Zm.prototype.b=function(){return this.c.M()};
Zm.prototype.a=function(){var a=this.c.N();if(!a||0==a.a){var b=this.f.a.a.get(this.b());if(b)return b.a}return a?a.a:0};function $m(){}l($m,n);$m.prototype.i=function(){return this.c.i()};$m.prototype.j=function(){var a=this.c.j();this.b=a;var b=new Zm;b.f=this;b.c=a;return b};$m.prototype.ka=function(){Wj(!!this.b);this.a.b=Db(this.a.b,Ab(Ym(this.b.N(),0)));this.c.ka();this.b=null};$m.prototype.da=function(a){zb(this,a)};function an(){this.b=0;this.c=!1}l(an,n);
an.prototype.i=function(){return 0<this.b||this.f.i()};an.prototype.j=function(){0==this.b&&(this.a=this.f.j(),this.b=this.a.N().a);this.b--;this.c=!0;return this.a.M()};an.prototype.ka=function(){Wj(this.c);if(0>=this.a.N().a)throw Oe().s;var a=this.a.N();0==(a.a+=-1)&&this.f.ka();this.g.b=Ya(this.g.b,hb(1));this.c=!1};an.prototype.da=function(a){zb(this,a)};function bn(){this.b=hb(0)}l(bn,Vm);g=bn.prototype;g.uc=function(){return Vm.prototype.uc.call(this)};
g.md=function(){var a=this.a.X().h(),b=new $m;b.a=this;b.c=a;return b};g.zg=function(a){G(a);this.a.kb(Sd(function(b,c){var d=a.a;d(b,c.a)}))};g.ia=function(){for(var a=this.a.values().h();a.i();)a.j().a=0;this.a.Aa();this.b=hb(0)};g.w=function(){return lha(this.b)};g.h=function(){var a=new an;a.g=this;a.f=this.a.X().h();return a};g.wd=function(a){return(a=ol(this.a,a))?a.a:0};
g.Qe=function(a,b){if(0==b)return this.wd(a);Ji(0<b,"occurrences cannot be negative: %s",b);var c=this.a.get(a);if(c){var d=c.a;a=Ab(d).add(Ab(b));if(!(0>=ab(a,Ab(2147483647))))throw va(Ki("too many occurrences: %s",[aba(a)])).s;c.a+=b}else d=0,this.a.C(a,bia(b));this.b=this.b.add(Ab(b));return d};g.Wf=function(a,b){if(0==b)return this.wd(a);Ji(0<b,"occurrences cannot be negative: %s",b);var c=this.a.get(a);if(!c)return 0;var d=c.a;d>b||(b=d,this.a.za(a));c.a+=-b;this.b=Ya(this.b,Ab(b));return d};
g.Sg=function(a,b){Vj(b,"count");var c;if(0==b)var d=(c=this.a.za(a))?Ym(c,b):0;else d=(c=this.a.get(a))?Ym(c,b):0,c||this.a.C(a,bia(b));this.b=this.b.add(Ab(b-d));return d};g.Z=function(a){Lm(this,a)};g.W=function(){return Rm(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.ba=!0;function cn(){this.b=hb(0)}l(cn,bn);function Tha(){var a=new cn,b=Of();Hi(b.Ka());a.a=b;return a}cn.prototype.Z=function(a){Lm(this,a)};cn.prototype.W=function(){return Rm(this)};
cn.prototype.ca=function(a){return ed(this,a)};cn.prototype.T=function(){return fd(this)};function Qm(){}l(Qm,Bl);Qm.prototype.Y=function(a){this.a.add(G(a));return this};Qm.prototype.Pe=function(a){Bl.prototype.Pe.call(this,a);return this};Qm.prototype.jb=function(a){var b=this;Mm(a)?a.zg(new lda(function(c,d){b.a.Qe(G(c),d)})):Bl.prototype.jb.call(this,a);return this};
Qm.prototype.ga=function(){var a=this.a;ll();if(!(a instanceof Nm)||a.Rd()){if(!Mm(a)){var b=Mm(a)?a.oe().w():11,c=new cn;b=Uf(Sm(b));Hi(b.Ka());c.a=b;dn(c,a);a=c}a=a.uc();a.G()?a=Om():(Pha(),a=a.G()?Om():Vha(a))}return a};function cia(){}l(cia,fm);g=cia.prototype;g.F=function(a){return this.a.el(a)};g.Rd=function(){return this.a.Rd()};g.w=function(){return this.a.w()};g.Ue=function(){return this.a};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};
g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function en(){}l(en,gm);g=en.prototype;g.h=function(){return this.df().h()};g.W=function(){var a=this;return jga(this.w(),new Zca(function(b){return a.el(b)}))};g.Z=function(a){G(a);for(var b=this.w(),c=0;c<b;c++)a.Ob(this.el(c))};g.lk=function(){Pl();var a=new cia;a.a=this;return a};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};function Sha(){}l(Sha,en);g=Sha.prototype;g.Rd=function(){return this.a.Rd()};g.el=function(a){return this.a.a.F(a)};
g.w=function(){return this.a.oe().w()};g.B=function(a){return Fm(a)?0>=a.a()?!1:this.a.wd(a.b())==a.a():!1};g.P=function(){return this.a.P()};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};var Qha;function Pha(){Pha=function(){};ll();Qha=Vha(Nl())}function fn(){}l(fn,ge);g=fn.prototype;g.Kl=function(){return pm(this)};g.add=function(){throw vb().s;};g.ra=function(){throw vb().s;};g.na=function(){throw vb().s;};g.Qb=function(){throw vb().s;};g.ca=function(){throw vb().s;};
g.ia=function(){throw vb().s;};g.W=function(){return Qd(this)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function dia(){}l(dia,ck);g=dia.prototype;g.wd=function(a){return this.Ab().wd(a)};g.Qe=function(a,b){return this.Ab().Qe(a,b)};g.Wf=function(a,b){return this.Ab().Wf(a,b)};g.oe=function(){return this.Ab().oe()};g.uc=function(){return this.Ab().uc()};g.J=function(a){return q(a,this)||this.Ab().J(a)};g.P=function(){return this.Ab().P()};
g.Sg=function(a,b){return this.Ab().Sg(a,b)};g.vh=function(a,b,c){return this.Ab().vh(a,b,c)};g.Z=function(a){Lm(this,a)};g.zg=function(a){Km(this,a)};g.W=function(){return Rm(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Wa=!0;g.yb=!0;g.il=!0;function gn(){}l(gn,dia);g=gn.prototype;g.Ab=function(){return this.a};g.oe=function(){var a=this.b;return a?a:this.b=xf(this.a.oe())};g.uc=function(){var a=this.c;return a?a:this.c=xf(this.a.uc())};g.h=function(){return tm(this.a.h())};
g.add=function(){throw vb().s;};g.Qe=function(){throw vb().s;};g.na=function(){throw vb().s;};g.ra=function(){throw vb().s;};g.Wf=function(){throw vb().s;};g.Qb=function(){throw vb().s;};g.ia=function(){throw vb().s;};g.Sg=function(){throw vb().s;};g.vh=function(){throw vb().s;};g.Z=function(a){Lm(this,a)};g.zg=function(a){Km(this,a)};g.W=function(){return Rm(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.ba=!0;
function Rha(a,b){if(q(b,a))return!0;if(Mm(b)){if(a.w()!=b.w()||a.uc().w()!=b.uc().w())return!1;for(b=b.uc().h();b.i();){var c=b.j();if(a.wd(c.b())!=c.a())return!1}return!0}return!1}function aia(a,b){if(b.G())return!1;b.zg(new lda(function(c,d){a.Qe(c,d)}));return!0}function Rm(a){var b=a.uc().W();return mk(b,u(function(c){return Oca(c.a(),c.b()).W()}),64|b.sd()&1296,Ab(a.w()))}function jn(){}l(jn,Fk);jn.prototype.c=function(){if(this.a.i())return this.a.j();for(;this.f.i();){var a=this.f.j();if(!this.o.B(a))return a}return Gk(this)};
jn.prototype.da=function(a){zb(this,a)};function eia(){}l(eia,fn);g=eia.prototype;g.w=function(){for(var a=this.a.w(),b=this.b.h();b.i();){var c=b.j();this.a.B(c)||a++}return a};g.G=function(){return this.a.G()&&this.b.G()};g.h=function(){var a=new jn,b=this.b;a.o=this.a;a.u=b;Hk(a);a.a=a.o.h();a.f=a.u.h();return a};g.T=function(){var a=this;return vda(this.a.T(),mg(this.b.T(),ad(function(b){return!a.a.B(b)})))};g.B=function(a){return this.a.B(a)||this.b.B(a)};g.Kl=function(){return Cl().jb(this.a).jb(this.b).ga()};
g.W=function(){return Qd(this)};g.Z=function(a){uc(this,a)};function kn(){}l(kn,Fk);kn.prototype.c=function(){for(;this.a.i();){var a=this.a.j();if(this.o.B(a))return a}return Gk(this)};kn.prototype.da=function(a){zb(this,a)};function fia(){}l(fia,fn);g=fia.prototype;g.h=function(){var a=new kn,b=this.b;a.f=this.a;a.o=b;Hk(a);a.a=a.f.h();return a};g.T=function(){var a=this;return mg(this.a.T(),ad(function(b){return a.b.B(b)}))};
g.w=function(){for(var a=0,b=this.a.h();b.i();){var c=b.j();this.b.B(c)&&a++}return a};g.G=function(){a:{var a=this.b,b=this.a;Cd();var c=a;var d=b;Rd(a)&&!Rd(b)&&(c=b,d=a);for(a=c.h();a.i();)if(b=a.j(),d.B(b)){d=!1;break a}d=!0}return d};g.B=function(a){return this.a.B(a)&&this.b.B(a)};g.Db=function(a){return this.a.Db(a)&&this.b.Db(a)};g.W=function(){return Qd(this)};g.Z=function(a){uc(this,a)};function ln(){}l(ln,Fk);ln.prototype.c=function(){for(;this.a.i();){var a=this.a.j();if(!this.o.B(a))return a}return Gk(this)};
ln.prototype.da=function(a){zb(this,a)};function gia(){}l(gia,fn);g=gia.prototype;g.h=function(){var a=new ln,b=this.b;a.f=this.a;a.o=b;Hk(a);a.a=a.f.h();return a};g.T=function(){var a=this;return mg(this.a.T(),ad(function(b){return!a.b.B(b)}))};g.w=function(){for(var a=0,b=this.a.h();b.i();){var c=b.j();this.b.B(c)||a++}return a};g.G=function(){return this.b.Db(this.a)};g.B=function(a){return this.a.B(a)&&!this.b.B(a)};g.W=function(){return Qd(this)};g.Z=function(a){uc(this,a)};function mn(){}
l(mn,n);function nn(a){var b=new mn;hia(b,a);return b}function hia(a,b){a.a=Ba([0],w,Wc,0);a.a.length=((b-1)/31|0)+1}function on(a){if(0>a)throw La("bitIndex < 0: "+a).s;}function iia(a,b){if(0>a||0>b||a>b)throw La("fromIndex: "+a+", toIndex: "+b).s;}function jia(a,b,c){var d=b/31|0,e=c/31|0;kia(a,e);b=b%31|0;c=c%31|0;if(d==e)lia(a,d,b,c);else for(lia(a,d,b,31),lia(a,e,0,c),d+=1;d<e;d++)a[d]=2147483647}function kia(a,b){b+=1;b>a.length&&(a.length=b)}
function pn(a){for(var b=a.length-1;0<=b&&0==(a[b]|0);--b);return b}function mia(a,b,c){0!=c&&(c=32-c,a[b]=((a[b]|0)^(-1<<c>>>c|0))&2147483647)}function lia(a,b,c,d){c!=d&&(d=32-d,a[b]=(a[b]|0|(-1>>>c|0)<<c+d>>>d|0)&2147483647)}function nia(a,b){if(q(a,b))a.a.length=0;else for(var c=Math.min(a.a.length,b.a.length),d=0;d<c;d++){var e=b.a[d]|0;if(0!=e){var f=a.a[d]|0;0!=f&&(a.a[d]=f&~e&2147483647)}}}function oia(a){a=yg(a.a,a.a.length);var b=new mn;b.a=a;return b}
mn.prototype.J=function(a){if(q(this,a))return!0;if(!pia(a))return!1;var b=pn(this.a);if(b!=pn(a.a))return!1;for(var c=0;c<=b;c++)if((this.a[c]|0)!=(a.a[c]|0))return!1;return!0};function qn(a,b){on(b);var c=b/31|0;return c<a.a.length&&1==(((a.a[c]|0)>>>(b%31|0)|0)&1)}mn.prototype.P=function(){for(var a=pn(this.a),b=-2128831035^a,c=0;c<=a;c++){var d=this.a[c]|0;b=16777619*b&-1^d&255;b=16777619*b&-1^(d>>>8|0)&255;b=16777619*b&-1^(d>>>16|0)&255;b=16777619*b&-1^(d>>>24|0)}return b};
function rn(a){var b=pn(a.a);return-1==b?0:31*b+(32-qh(a.a[b]|0))}function sn(a,b){on(b);var c=b/31|0,d=a.a.length;if(c>=d)return-1;for(b=(a.a[c]|0)&2147483647<<(b%31|0);0==b;){if(++c>=d)return-1;b=a.a[c]|0}return 31*c+sea(b)}function qia(a,b){if(-1==b)return-1;on(b);var c=b/31|0;if(c>=a.a.length)return rn(a)-1;for(b=(a.a[c]|0)&(2147483647>>>31-(b%31|0)-1|0);0==b;){if(0>--c)return-1;b=a.a[c]|0}return 31*c+(32-qh(b))-1}
function tn(a,b){if(!q(a,b)){kia(a.a,b.a.length-1);for(var c=0;c<b.a.length;c++){var d=b.a[c]|0;0!=d&&(a.a[c]=a.a[c]|0|d)}}}function un(a,b){on(b);var c=b/31|0;kia(a.a,c);a.a[c]=a.a[c]|0|1<<(b%31|0)}function ria(a,b,c){iia(b,c);b!=c&&jia(a.a,b,c)}mn.prototype.toString=function(){if(0==rn(this))return"{}";var a=ve("{"),b=sn(this,0);for(Rg(a,b);-1!=(b=sn(this,b+1));)y(a,", "),Rg(a,b);y(a,"}");return a.toString()};function pia(a){return a instanceof mn}function vn(){this.a=this.c=0}l(vn,n);
vn.prototype.i=function(){return this.c<this.b.w()};vn.prototype.j=function(){this.i();this.a=this.c++;return this.b.F(this.a)};vn.prototype.ka=function(){this.f.ra(this.b.F(this.a));this.a=-1};vn.prototype.da=function(a){zb(this,a)};function sia(){}l(sia,ge);function wn(){var a=new sia;a.a=ff();return a}g=sia.prototype;g.ra=function(a){return this.a.ra(a)};g.B=function(a){return this.a.B(a)};g.w=function(){return this.a.w()};g.ia=function(){this.a.ia()};
g.h=function(){var a=Hd(this.a);Qca(a);var b=new vn;b.f=this;b.b=a;b.c=0;b.a=-1;return b};function tia(a){var b=wn();b.add(a);return b}function xn(a,b){var c=wn();c.add(a);for(a=0;a<b.length;a++)c.add(b[a]);return c}function Oga(a){a.G();var b=wn();for(a=a.h();a.i();){var c=a.j();b.add(c)}return b}g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.add=function(a){return this.a.add(a)};function yn(){}l(yn,Bl);
function em(){var a=new yn;a.a=x();return a}yn.prototype.Y=function(a){this.a.add(G(a));return this};yn.prototype.jb=function(a){Bl.prototype.jb.call(this,a);return this};yn.prototype.Pe=function(a){G(a);Bl.prototype.Pe.call(this,a);return this};yn.prototype.ga=function(){return Yl(this.a)};function uia(){}l(uia,dk);g=uia.prototype;g.Fd=function(){return this.Ab().Fd()};g.W=function(){return Ne(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};
g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;function zn(){}l(zn,uia);function via(a){var b=new zn;b.a=G(a);b.c=Tca(a);return b}g=zn.prototype;g.Ab=function(){return this.c};g.ca=function(){throw vb().s;};g.T=function(){return this.a.T()};g.Z=function(a){this.a.Z(a)};g.Jf=function(){var a=this.b;a||(a=this.b=via(this.a.Jf()),a.b=this);return a};g.Qg=function(a,b){return wia(this.a.Qg(a,b))};g.W=function(){return Ne(this)};g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;g.Yg=!0;g.ba=!0;function xia(){}l(xia,Ye);
function sf(){var a=new xia;Ze(a);return a}g=xia.prototype;g.J=function(a){if(q(a,this))return!0;if(!fe(a)||this.va()!=a.va())return!1;for(a=a.X().h();a.i();){var b=a.j(),c=b.M();b=b.N();if(!this.V(c)||!q(b,this.get(c)))return!1}return!0};g.P=function(){for(var a=0,b=this.X().h();b.i();){var c=b.j();a+=wh(c.M());a+=wh(c.N())}return a};g.pk=function(a,b){return q(a,b)};g.uk=function(a){return ja(a)};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};
g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.td=!0;g.ba=!0;function yia(a,b){a:switch(a=xn(a,b),ll(),a.w()){case 0:a=hm();break a;case 1:a=om(Sj(a));break a;default:b=new Em,b.a=xf(a),a=b}return a}function zia(a,b){Oi(a,"set1");Oi(b,"set2");var c=new eia;c.a=a;c.b=b;return c}function Aia(a,b){Oi(a,"set1");Oi(b,"set2");var c=new gia;c.a=a;c.b=b;return c}
function Cha(a){var b=0;for(a=a.h();a.i();){var c=a.j();b+=null!=c?$c(c):0;b=~~b}return b}function Bha(a,b){if(q(a,b))return!0;if(Rd(b))try{return a.w()==b.w()&&a.Db(b)}catch(c){if(c=wa(c),!sb(c))throw c.s;}return!1}function wia(a){return a instanceof Ml||a instanceof zn?a:via(a)}function Bia(a,b){for(var c=!1;b.i();)c=!!(+c|+a.ra(b.j()));return c}
function Wha(a,b){G(b);Mm(b)&&(b=b.oe());if(Rd(b)&&b.w()>a.w()){a=a.h();G(b);for(var c=!1;a.i();)b.B(a.j())&&(a.ka(),c=!0);a=c}else a=Bia(a,b.h());return a}function Hha(a,b){var c=0;for(a=a.h();a.i();){var d=a.j();xd(b,c++,d)}return b}function An(){}l(An,Tm);g=An.prototype;g.Un=function(){return this.a};g.h=function(){var a=this.a.X().h(),b=new sl;b.a=G(a);return b};g.Z=function(a){G(a);this.a.kb(Sd(function(b){a.Ob(b)}))};g.w=function(){return this.a.va()};g.G=function(){return this.a.Ka()};
g.B=function(a){return this.a.V(a)};g.ra=function(a){return this.B(a)?(this.a.za(a),!0):!1};g.ia=function(){this.a.Aa()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};function Cia(){}l(Cia,wd);g=Cia.prototype;g.h=function(){return Wga(this.a.X().h())};g.Z=function(a){G(a);this.a.kb(Sd(function(b,c){a.Ob(c)}))};
g.ra=function(a){try{return wd.prototype.ra.call(this,a)}catch(d){d=wa(d);if(xb(d)){for(var b=this.a.X().h();b.i();){var c=b.j();if(ek(a,c.N()))return this.a.za(c.M()),!0}return!1}throw d.s;}};g.Qb=function(a){try{return wd.prototype.Qb.call(this,G(a))}catch(e){e=wa(e);if(xb(e)){for(var b=ff(),c=this.a.X().h();c.i();){var d=c.j();a.B(d.N())&&b.add(d.M())}return this.a.pa().Qb(b)}throw e.s;}};g.w=function(){return this.a.va()};g.G=function(){return this.a.Ka()};g.B=function(a){return this.a.Uc(a)};
g.ia=function(){this.a.Aa()};g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};function Bn(){}l(Bn,we);g=Bn.prototype;g.X=function(){var a=this.g;return a?a:this.g=this.cm()};g.pa=function(){var a=this.o;return a?a:this.o=this.fl()};g.fl=function(){var a=new An;a.a=G(this);return a};g.values=function(){var a=this.v;a||(a=new Cia,a.a=G(this),a=this.v=a);return a};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};
g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Cn(){}l(Cn,We);Cn.prototype.M=function(){return this.a};Cn.prototype.N=function(){return this.b.b[this.a.a]};Cn.prototype.Qc=function(a){return Dia(this.b,this.a.a,a)};function Dn(){}l(Dn,n);Dn.prototype.i=function(){return this.c.i()};
Dn.prototype.j=function(){this.b=this.c.j();var a=new Cn,b=this.b;a.b=this.a;a.a=b;return a};Dn.prototype.ka=function(){this.a.za(this.b);this.b=null};Dn.prototype.da=function(a){zb(this,a)};function Eia(){}l(Eia,ge);g=Eia.prototype;g.ia=function(){this.a.Aa()};g.B=function(a){return Od(a)?this.a.eh(a):!1};g.h=function(){var a=new Dn;a.a=this.a;a.c=a.a.a.h();return a};g.ra=function(a){return this.B(a)?(a=a.M(),this.a.za(a),!0):!1};g.w=function(){return this.a.va()};g.W=function(){return Qd(this)};
g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function kl(){}l(kl,we);function Fia(){var a=new kl;a.a=wn();a.b=Array(a.a.w());return a}g=kl.prototype;g.Aa=function(){this.a.ia();this.b=Array(this.b.length)};g.V=function(a){return this.a.B(a)};g.Uc=function(a){for(var b=this.a.h();b.i();){var c=b.j();if(Xc(a,this.b[c.a]))return!0}return!1};g.X=function(){var a=new Eia;a.a=this;return a};g.get=function(a){return this.a.B(a)?this.b[a.a]:null};
g.za=function(a){return this.a.ra(a)?Dia(this,a.a,null):null};g.va=function(){return this.a.w()};function Dia(a,b,c){var d=a.b[b];a.b[b]=c;return d}g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.C=function(a,b){this.a.add(a);return Dia(this,a.a,b)};function En(){}l(En,Tm);g=En.prototype;
g.w=function(){return this.cg().va()};g.ia=function(){this.cg().Aa()};g.B=function(a){if(Od(a)){var b=a.M(),c=ol(this.cg(),b);return ek(c,a.N())&&(null!=c||this.cg().V(b))}return!1};g.G=function(){return this.cg().Ka()};g.ra=function(a){return this.B(a)?this.cg().pa().ra(a.M()):!1};g.Qb=function(a){try{return Tm.prototype.Qb.call(this,G(a))}catch(b){b=wa(b);if(xb(b))return Bia(this,a.h());throw b.s;}};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function Fn(){this.a=0}var Gia,Wfa;l(Fn,A);function Pj(){Pj=function(){};Gia=Hia();Wfa=Iia()}Fn.prototype.Tc=!0;function Gn(){this.a=0}l(Gn,Fn);function Hia(){Pj();var a=new Gn;a.b="KEY";a.a=0;return a}Gn.prototype.R=function(a){return Fn.prototype.c.call(this,a)};Gn.prototype.f=function(a){return a.M()};function Hn(){this.a=0}l(Hn,Fn);function Iia(){Pj();var a=new Hn;a.b="VALUE";a.a=1;return a}Hn.prototype.R=function(a){return Fn.prototype.c.call(this,a)};
Hn.prototype.f=function(a){return a.N()};function In(){}l(In,Xj);g=In.prototype;g.M=function(){return this.Ab().M()};g.N=function(){return this.Ab().N()};g.Qc=function(a){return this.Ab().Qc(a)};g.J=function(a){return this.Ab().J(a)};g.P=function(){return this.Ab().P()};g.tg=!0;function Jia(){}l(Jia,En);g=Jia.prototype;g.cg=function(){return this.a};g.h=function(){return this.a.md()};g.W=function(){return this.a.on()};g.Z=function(a){this.a.md().da(a)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
function Jn(){}l(Jn,we);g=Jn.prototype;g.on=function(){var a=this.md(),b=Ab(this.va());return Iba(a,b,65)};g.X=function(){var a=new Jia;a.a=this;return a};g.Aa=function(){Kn(this.md())};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Kia(){}l(Kia,n);function Lia(){this.a=!1}l(Lia,n);
function Mia(a){var b=new Lia;b.b=new Kia;b.c=b.b;b.a=!1;b.f=G(a);return b}function Ln(a){a.a=!0;return a}function Mn(a,b,c){return Nn(a,b,c)}function On(a,b,c){return Nn(a,b,""+c)}function Pn(a,b,c){return Nn(a,b,""+c)}Lia.prototype.toString=function(){for(var a=this.a,b="",c=Pg(y(Og(),this.f),123),d=this.b.c;d;d=d.c){var e=d.a;a&&null==e||(y(c,b),b=", ",null!=d.b&&Pg(y(c,d.b),61),null!=e&&0!=Jg(e).a?(e=Pda([e],ff()),Wf(c,e,1,e.length-1)):Sg(c,e))}return Pg(c,125).toString()};
function Qn(a){var b=new Kia;return a.c=a.c.c=b}function Nn(a,b,c){var d=Qn(a);d.a=c;d.b=G(b);return a}function Rn(a,b){if(null!=a)return a;if(null!=b)return b;throw rb("Both parameters are null").s;}function Sn(a){return Mia(zaa(Jg(a)))}function Tn(){}l(Tn,n);g=Tn.prototype;g.Rg=function(){return 0==this.Qd()};g.Ej=function(a){for(var b=this.Yc().values().h();b.i();)if(b.j().B(a))return!0;return!1};function Un(a,b,c){a=a.Yc().get(b);return!!a&&a.B(c)}
g.ag=function(a,b){a=this.Yc().get(a);return!!a&&a.ra(b)};g.ya=function(a,b){return this.Va(a).add(b)};g.Gj=function(a,b){G(b);jd(b)?!b.G()&&this.Va(a).na(b):(b=b.h(),b.i()&&Wm(this.Va(a),b))};g.am=function(a){var b=!1;for(a=a.Ud().h();a.i();){var c=a.j();b=!!(+b|+this.ya(c.M(),c.N()))}};g.Ud=function(){var a=this.u;return a?a:this.u=this.xl()};g.Fj=function(){var a=this.md();return Iba(a,Ab(this.Qd()),null!=this&&this.jl?1:0)};g.Nc=function(){var a=this.v;return a?a:this.v=this.bf()};
g.Rc=function(){var a=this.A;return a?a:this.A=this.zh()};g.xh=function(){return Wga(this.Ud().h())};g.Zl=function(){var a=this.xh();return Iba(a,Ab(this.Qd()),0)};g.Yc=function(){var a=this.o;return a?a:this.o=this.Vi()};g.J=function(a){a=q(a,this)?!0:null!=a&&a.Dh?Yc(this.Yc(),a.Yc()):!1;return a};g.P=function(){return $c(this.Yc())};g.toString=function(){return Be(this.Yc())};g.Dh=!0;function Vn(){}l(Vn,Ak);Vn.prototype.i=function(){return this.a.i()||this.b.i()};
Vn.prototype.j=function(){if(!this.a.i()){var a=this.b.j();this.c=a.M();this.a=a.N().h()}return Yga(this.c,this.a.j())};Vn.prototype.da=function(a){zb(this,a)};function Wn(){}l(Wn,Ak);Wn.prototype.i=function(){return this.a.i()||this.b.i()};Wn.prototype.j=function(){this.a.i()||(this.a=this.b.j().h());return this.a.j()};Wn.prototype.da=function(a){zb(this,a)};function ao(){}l(ao,n);ao.prototype.f=function(a,b){Uj(a,b);var c=this.a.get(a);c||this.a.C(a,c=x());c.add(b)};
ao.prototype.c=function(a,b){if(null==a)throw rb("null key in entry: null="+r(qga(b.h()))).s;var c=this.a.get(a);if(c)for(b=b.h();b.i();){var d=b.j();Uj(a,d);c.add(d)}else if(b=b.h(),b.i()){for(c=x();b.i();)d=b.j(),Uj(a,d),c.add(d);this.a.C(a,c)}};
ao.prototype.b=function(){var a=this.a.X();if(this.g){var b=Vfa(this.g);var c=(Pj(),Gia);b=Xfa(c,b);a=sha(b,a)}var d=a;b=this.o;if(d.G())a=(Nia(),Oia);else{a=d.w();c=new Mj;Vj(a,"initialArraySize");c.a=Jd();a=0;for(d=d.h();d.i();){var e=d.j(),f=e.M();e=e.N();e=b?sha(b,e):Yl(e);e.G()||(c.L(f,e),a+=e.w())}b=c.Pb();c=new bo;c.a=b;c.b=a;a=c}return a};function Pia(){}l(Pia,Ml);g=Pia.prototype;g.h=function(){return this.a.md()};g.Rd=function(){return!1};g.w=function(){return this.a.Qd()};
g.B=function(a){return Od(a)?Un(this.a,a.M(),a.N()):!1};g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Qia(){}l(Qia,Ml);g=Qia.prototype;g.B=function(a){return this.a.Ej(a)};g.h=function(){return this.a.xh()};g.w=function(){return this.a.Qd()};g.Rd=function(){return!0};g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};
function co(){}l(co,Tn);function Ria(){this.b=0}l(Ria,co);g=Ria.prototype;g.Pc=function(){throw vb().s;};g.ue=function(){throw vb().s;};g.ya=function(){throw vb().s;};g.Gj=function(){throw vb().s;};g.am=function(){throw vb().s;};g.ag=function(){throw vb().s;};g.Zc=function(a){return this.a.V(a)};g.Ej=function(a){return null!=a&&co.prototype.Ej.call(this,a)};g.Qd=function(){return this.b};g.Nc=function(){return this.a.pa()};g.bf=function(){throw jb("unreachable").s;};g.Yc=function(){return this.a};
g.Vi=function(){throw jb("should never be called").s;};g.Ud=function(){return co.prototype.Ud.call(this)};g.xl=function(){ll();var a=new Pia;a.a=this;return a};g.md=function(){var a=new Vn;a.f=this;a.b=a.f.a.X().h();a.c=null;a.a=(Qk(),Pk);return a};g.Fj=function(){return mk(this.Yc().X().W(),u(function(a){var b=a.M();a=a.N();return lk(a.W(),u(function(c){return hl(b,c)}))}),64|(null!=this&&this.jl?1:0),Ab(this.Qd()))};g.Rc=function(){return co.prototype.Rc.call(this)};
g.zh=function(){ll();var a=new Qia;a.a=this;return a};g.xh=function(){var a=new Wn;a.c=this;a.b=a.c.a.values().h();a.a=(Qk(),Pk);return a};g.ba=!0;function bo(){this.b=0}l(bo,Ria);bo.prototype.Va=function(a){return(a=this.a.get(a))?a:Nl()};bo.prototype.Pc=function(){throw vb().s;};bo.prototype.Dh=!0;function Sia(){this.b=0}var Oia;l(Sia,bo);function Tia(){var a=new Sia,b=Rj();a.a=b;a.b=0;return a}function Nia(){Nia=function(){};Oia=Tia()}function eo(){}l(eo,ao);
eo.prototype.f=function(a,b){ao.prototype.f.call(this,a,b)};eo.prototype.c=function(a,b){ao.prototype.c.call(this,a,b)};eo.prototype.b=function(){return ao.prototype.b.call(this)};function fo(){}l(fo,n);function go(){Vj(8,"expectedKeys");var a=new Uia;a.b=8;return a}function Via(){Vj(8,"expectedKeys");var a=new Wia;a.b=8;return a}fo.prototype.b=function(a){var b=this.a();b.am(a);return b};function Xia(){}l(Xia,fo);Xia.prototype.b=function(a){return fo.prototype.b.call(this,a)};
function ho(){this.a=0}l(ho,n);ho.prototype.Na=function(){return Jd()};ho.prototype.ba=!0;function Yia(){this.c=0}l(Yia,Xia);Yia.prototype.a=function(){var a=this.f.a(),b=new ho;b.a=Vj(this.c,"expectedValuesPerKey");var c=new io;jo(c,a);c.c=G(b);return c};function ko(){}l(ko,Bd);g=ko.prototype;g.lc=function(a,b){this.Bb(a).te(b)};g.F=function(a){var b=this.Bb(a);try{return b.j()}catch(c){c=wa(c);if(Md(c))throw La("Can't get element "+a).s;throw c.s;}};g.h=function(){return this.ae()};
g.Ya=function(a){var b=this.Bb(a);try{var c=b.j();b.ka();return c}catch(d){d=wa(d);if(Md(d))throw La("Can't remove element "+a).s;throw d.s;}};g.Ub=function(a,b){var c=this.Bb(a);try{var d=c.j();c.Ed(b);return d}catch(e){e=wa(e);if(Md(e))throw La("Can't set element "+a).s;throw e.s;}};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function lo(){}l(lo,n);function Zia(){this.c=0}l(Zia,n);
function $ia(a,b,c){var d=new Zia;d.f=a;d.b=null;d.a=c;d.c=b;return d}g=Zia.prototype;g.te=function(a){aja(this.f,a,this.a.b,this.a);++this.c;this.b=null};g.i=function(){return!q(this.a,this.f.b)};g.Ec=function(){return!q(this.a.b,this.f.c)};g.j=function(){this.i();this.b=this.a;this.a=this.a.a;++this.c;return this.b.c};g.pd=function(){return this.c};g.Gc=function(){this.Ec();this.b=this.a=this.a.b;--this.c;return this.b.c};g.Od=function(){return this.c-1};
g.ka=function(){var a=this.b.a;bja(this.f,this.b);q(this.a,this.b)?this.a=a:--this.c;this.b=null};g.Ed=function(a){this.b.c=a};g.da=function(a){zb(this,a)};function mo(){}l(mo,n);mo.prototype.i=function(){return this.b.Ec()};mo.prototype.j=function(){return this.b.Gc()};mo.prototype.ka=function(){this.b.ka()};mo.prototype.da=function(a){zb(this,a)};function cja(){this.a=0}l(cja,ko);g=cja.prototype;g.add=function(a){this.Bc(a);return!0};g.me=function(a){aja(this,a,this.c,this.c.a)};
g.Bc=function(a){aja(this,a,this.b.b,this.b)};g.ia=function(){dja(this)};function dja(a){a.c.a=a.b;a.b.b=a.c;a.c.b=a.b.a=null;a.a=0}g.pn=function(){var a=new mo;a.a=this;a.b=$ia(a.a,a.a.a,a.a.b);return a};g.yg=function(){return this.He()};g.He=function(){return this.c.a.c};g.wk=function(){return this.b.b.c};g.Bb=function(a){if(a>=this.a>>1){var b=this.b;for(var c=this.a;c>a;--c)b=b.b}else for(b=this.c.a,c=0;c<a;++c)b=b.a;return $ia(this,a,b)};g.Ul=function(a){this.Tl(a)};g.Tl=function(a){this.Bc(a)};
g.Pa=function(){return this.Uf()};g.Uf=function(){return 0==this.a?null:this.He()};g.Ce=function(){return 0==this.a?null:this.wk()};g.xj=function(){return this.Ah()};g.Ah=function(){return 0==this.a?null:this.Pd()};g.tn=function(){return 0==this.a?null:this.Vf()};g.Ta=function(){return this.Pd()};g.Fa=function(a){this.me(a)};g.Tg=function(){return this.Pd()};g.Pd=function(){return bja(this,this.c.a)};g.bn=function(a){return this.ra(a)};g.Vf=function(){return bja(this,this.b.b)};g.w=function(){return this.a};
function aja(a,b,c,d){var e=new lo;e.c=b;e.b=c;e.a=d;d.b=c.a=e;++a.a}function bja(a,b){var c=b.c;b.a.b=b.b;b.b.a=b.a;b.a=b.b=null;b.c=null;--a.a;return c}g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Xg=!0;g.Wa=!0;g.yb=!0;g.ba=!0;function no(){}l(no,fo);no.prototype.b=function(a){return fo.prototype.b.call(this,a)};function oo(){this.a=0}l(oo,n);oo.prototype.Na=function(){return jf(Sm(this.a))};
oo.prototype.ba=!0;function eja(){this.c=0}l(eja,no);eja.prototype.a=function(){var a=this.f.a(),b=new oo;b.a=Vj(this.c,"expectedValuesPerKey");return fja(a,b)};function po(){this.a=0}l(po,n);po.prototype.Na=function(){return Kha(Sm(this.a))};po.prototype.ba=!0;function gja(){this.c=0}l(gja,no);gja.prototype.a=function(){var a=this.f.a(),b=new po;b.a=Vj(this.c,"expectedValuesPerKey");return fja(a,b)};function hja(){}l(hja,n);
function ija(a){Vj(2,"expectedValuesPerKey");var b=new Yia;b.f=a;b.c=2;return b}function qo(){var a=go();Vj(2,"expectedValuesPerKey");var b=new eja;b.f=a;b.c=2;return b}function jja(a){Vj(2,"expectedValuesPerKey");var b=new gja;b.f=a;b.c=2;return b}function Uia(){this.b=0}l(Uia,hja);Uia.prototype.a=function(){return bf(Sm(this.b))};function Wia(){this.b=0}l(Wia,hja);Wia.prototype.a=function(){return Uf(Sm(this.b))};function ro(){}l(ro,n);
function kja(a,b){a.o=b;a.c=b.b.X().h();a.f=null;a.b=null;a.a=($k(),Zk)}ro.prototype.i=function(){return this.c.i()||this.a.i()};ro.prototype.j=function(){if(!this.a.i()){var a=this.c.j();this.f=a.M();this.b=a.N();this.a=this.b.h()}return this.g(this.f,this.a.j())};ro.prototype.ka=function(){this.a.ka();this.b.G()&&this.c.ka();this.o.a--};ro.prototype.da=function(a){zb(this,a)};function so(){}l(so,ro);so.prototype.g=function(a,b){return b};so.prototype.da=function(a){zb(this,a)};function to(){}
l(to,ro);to.prototype.g=function(a,b){return hl(a,b)};to.prototype.da=function(a){zb(this,a)};function uo(){}l(uo,n);function lja(a){var b=new uo;b.a=a;b.c=b.a.a.X().h();return b}uo.prototype.i=function(){return this.c.i()};uo.prototype.j=function(){var a=this.c.j();this.b=a.N();return mja(this.a,a)};uo.prototype.ka=function(){Wj(!!this.b);this.c.ka();this.a.b.a-=this.b.w();this.b.ia();this.b=null};uo.prototype.da=function(a){zb(this,a)};function nja(){}l(nja,En);g=nja.prototype;g.cg=function(){return this.a};
g.h=function(){return lja(this.a)};g.W=function(){var a=this;return lk(this.a.a.X().W(),u(function(b){return mja(a.a,b)}))};g.B=function(a){return vo(this.a.a.X(),a)};g.ra=function(a){if(!this.B(a))return!1;var b=this.a.b;a=a.M();if(a=oja(b.b,a)){var c=a.w();a.ia();b.a-=c}return!0};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function wo(){}l(wo,Bn);function pja(a,b){var c=new wo;c.b=a;c.a=b;return c}g=wo.prototype;
g.V=function(a){return nl(this.a,a)};g.get=function(a){var b=ol(this.a,a);return b?this.b.yh(a,b):null};g.pa=function(){return this.b.Nc()};g.va=function(){return this.a.va()};g.za=function(a){a=this.a.za(a);if(!a)return null;var b=this.b.If();b.na(a);this.b.a-=a.w();a.ia();return b};g.J=function(a){return q(this,a)||Yc(this.a,a)};g.P=function(){return $c(this.a)};g.toString=function(){return Be(this.a)};g.Aa=function(){q(this.a,this.b.b)?this.b.ue():Kn(lja(this))};
function mja(a,b){var c=b.M();return Yga(c,a.b.yh(c,b.N()))}g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.cm=function(){var a=new nja;a.a=this;return a};function xo(){}l(xo,n);xo.prototype.i=function(){return this.b.i()};xo.prototype.j=function(){this.a=this.b.j();return this.a.M()};
xo.prototype.ka=function(){Wj(!!this.a);var a=this.a.N();this.b.ka();this.c.b.a-=a.w();a.ia();this.a=null};xo.prototype.da=function(a){zb(this,a)};function yo(){}l(yo,An);function qja(a,b){var c=new yo;c.b=a;c.a=G(b);return c}g=yo.prototype;g.h=function(){var a=this.a.X().h(),b=new xo;b.c=this;b.b=a;return b};g.W=function(){return this.a.pa().W()};g.ra=function(a){var b=0;if(a=this.a.za(a))b=a.w(),a.ia(),this.b.a-=b;return 0<b};g.ia=function(){Kn(this.h())};g.Db=function(a){return this.a.pa().Db(a)};
g.J=function(a){return q(this,a)||Yc(this.a.pa(),a)};g.P=function(){return $c(this.a.pa())};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};function zo(){}l(zo,yo);function rja(a,b){var c=new zo;c.b=a;c.a=G(b);return c}g=zo.prototype;g.Dj=function(){return yo.prototype.Un.call(this)};g.Fd=function(){return this.Dj().ce()};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;function Ao(){}l(Ao,wo);
function sja(a,b){var c=new Ao;c.f=a;c.b=a;c.a=b;return c}g=Ao.prototype;g.af=function(){return this.a};g.ce=function(){return this.af().ce()};g.Af=function(a){return sja(this.f,this.af().Af(a))};g.pa=function(){var a=this.u;return a?a:this.u=this.fl()};g.fl=function(){return rja(this.f,this.af())};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};
g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.td=!0;g.Eh=!0;function tja(){}l(tja,zo);function Bo(a,b){var c=new tja;c.c=a;c.b=a;c.a=G(b);return c}g=tja.prototype;g.Dj=function(){return zo.prototype.Dj.call(this)};g.Jf=function(){return Bo(this.c,this.Dj().sf())};g.Qg=function(a,b){return Bo(this.c,this.Dj().Ee(a,b))};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;g.Yg=!0;function uja(){}l(uja,Ao);
function Co(a,b){var c=new uja;c.c=a;c.f=a;c.b=a;c.a=b;return c}g=uja.prototype;g.af=function(){return Ao.prototype.af.call(this)};g.sf=function(){return Co(this.c,this.af().sf())};g.pa=function(){return Ao.prototype.pa.call(this)};g.fl=function(){return Bo(this.c,this.af())};g.Sk=function(){return this.pa()};g.Zf=function(a,b,c,d){return Co(this.c,this.af().Zf(a,b,c,d))};g.ph=function(a,b){return Co(this.c,this.af().ph(a,b))};g.Af=function(a){return this.Ee(a,!0)};
g.Ee=function(a,b){return Co(this.c,this.af().Ee(a,b))};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.td=!0;g.Eh=!0;g.jm=!0;function Do(){}l(Do,n);function vja(a,b){a.a=b;a.f=a.a.a;b=b.a;b=od(b)?b.ae():b.h();a.b=b}function wja(a){Eo(a.a);if(!q(a.a.a,a.f))throw Oe().s;}
Do.prototype.i=function(){wja(this);return this.b.i()};Do.prototype.j=function(){wja(this);return this.b.j()};Do.prototype.ka=function(){this.b.ka();this.a.b.a--;Fo(this.a)};Do.prototype.da=function(a){zb(this,a)};function Go(){}l(Go,wd);function Ho(a,b,c,d,e){a.b=b;a.g=c;a.a=d;a.c=e;a.o=e?e.a:null}function Eo(a){if(a.c){if(Eo(a.c),!q(a.c.a,a.o))throw Oe().s;}else if(a.a.G()){var b=a.b.b.get(a.g);b&&(a.a=b)}}function Fo(a){a.c?Fo(a.c):a.a.G()&&a.b.b.za(a.g)}
function Io(a){a.c?Io(a.c):a.b.b.C(a.g,a.a)}g=Go.prototype;g.w=function(){Eo(this);return this.a.w()};g.J=function(a){if(q(a,this))return!0;Eo(this);return Yc(this.a,a)};g.P=function(){Eo(this);return $c(this.a)};g.toString=function(){Eo(this);return Be(this.a)};g.h=function(){Eo(this);var a=new Do;vja(a,this);return a};g.W=function(){Eo(this);return this.a.W()};g.add=function(a){Eo(this);var b=this.a.G();if(a=this.a.add(a))this.b.a++,b&&Io(this);return a};
g.na=function(a){if(a.G())return!1;var b=this.w();if(a=this.a.na(a)){var c=this.a.w();this.b.a+=c-b;0==b&&Io(this)}return a};g.B=function(a){Eo(this);return this.a.B(a)};g.Db=function(a){Eo(this);return this.a.Db(a)};g.ia=function(){var a=this.w();0!=a&&(this.a.ia(),this.b.a-=a,Fo(this))};g.ra=function(a){Eo(this);if(a=this.a.ra(a))this.b.a--,Fo(this);return a};g.Qb=function(a){if(a.G())return!1;var b=this.w();if(a=this.a.Qb(a)){var c=this.a.w();this.b.a+=c-b;Fo(this)}return a};
g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Jo(){}l(Jo,Do);function Ko(a){wja(a);return a.b}g=Jo.prototype;g.Ec=function(){return Ko(this).Ec()};g.Gc=function(){return Ko(this).Gc()};g.pd=function(){return Ko(this).pd()};g.Od=function(){return Ko(this).Od()};g.Ed=function(a){Ko(this).Ed(a)};g.te=function(a){var b=this.c.G();Ko(this).te(a);this.c.f.a++;b&&Io(this.c)};g.da=function(a){zb(this,a)};function Lo(){}l(Lo,Go);g=Lo.prototype;
g.F=function(a){Eo(this);return this.a.F(a)};g.Ub=function(a,b){Eo(this);return this.a.Ub(a,b)};g.lc=function(a,b){Eo(this);var c=this.a.G();this.a.lc(a,b);this.f.a++;c&&Io(this)};g.Ya=function(a){Eo(this);a=this.a.Ya(a);this.f.a--;Fo(this);return a};g.indexOf=function(a){Eo(this);return this.a.indexOf(a)};g.lastIndexOf=function(a){Eo(this);return this.a.lastIndexOf(a)};g.ae=function(){Eo(this);var a=new Jo;a.c=this;vja(a,this);return a};
g.Bb=function(a){Eo(this);var b=new Jo;b.c=this;a=this.a.Bb(a);b.a=this;b.f=b.a.a;b.b=a;return b};g.Nb=function(a,b){Eo(this);return xja(this.f,this.g,this.a.Nb(a,b),this.c?this.c:this)};g.nb=function(a){kd(this,a)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Xg=!0;function yja(){}l(yja,Lo);g=yja.prototype;g.nb=function(a){kd(this,a)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};
g.Je=!0;function zja(){}l(zja,wd);g=zja.prototype;g.w=function(){return this.a.Qd()};g.B=function(a){return Od(a)?Un(this.a,a.M(),a.N()):!1};g.ra=function(a){return Od(a)?this.a.ag(a.M(),a.N()):!1};g.ia=function(){this.a.ue()};g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Mo(){}l(Mo,zja);g=Mo.prototype;g.h=function(){return this.a.md()};g.W=function(){return this.a.Fj()};g.ca=function(a){return ed(this,a)};
g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Aja(){}l(Aja,Mo);g=Aja.prototype;g.P=function(){return Cha(this)};g.J=function(a){return Bha(this,a)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;function Bja(){}l(Bja,wd);g=Bja.prototype;g.h=function(){return this.a.xh()};g.W=function(){return this.a.Zl()};g.w=function(){return this.a.Qd()};g.B=function(a){return this.a.Ej(a)};g.ia=function(){this.a.ue()};
g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function No(){this.a=0}l(No,Tn);function jo(a,b){Hi(b.Ka());a.b=b}g=No.prototype;g.yl=function(){return this.Bj(this.If())};g.wl=function(){return this.If()};g.Qd=function(){return this.a};g.Zc=function(a){return this.b.V(a)};
g.ya=function(a,b){var c=this.b.get(a);if(c)return c.add(b)?(this.a++,!0):!1;c=this.wl(a);if(c.add(b))return this.a++,this.b.C(a,c),!0;throw jb("New Collection violated the Collection spec").s;};g.Pc=function(a){a=this.b.za(a);if(!a)return this.yl();var b=this.If();b.na(a);this.a-=a.w();a.ia();return this.Bj(b)};g.Bj=function(a){return vf(a)};g.ue=function(){for(var a=this.b.values().h();a.i();)a.j().ia();this.b.Aa();this.a=0};
g.Va=function(a){var b=this.b.get(a);b||(b=this.wl(a));return this.yh(a,b)};g.yh=function(a,b){var c=new Go;Ho(c,this,a,b,null);return c};function xja(a,b,c,d){if(pd(c)){var e=new yja;e.f=a;Ho(e,a,b,c,d);a=e}else e=new Lo,e.f=a,Ho(e,a,b,c,d),a=e;return a}g.bf=function(){return qja(this,this.b)};function Cja(a){return wea(a.b)?Bo(a,a.b):vca(a.b)?rja(a,a.b):qja(a,a.b)}g.Rc=function(){return Tn.prototype.Rc.call(this)};g.zh=function(){var a=new Bja;a.a=this;return a};
g.xh=function(){var a=new so;kja(a,this);return a};g.Zl=function(){return mk(this.b.values().W(),u(function(a){return a.W()}),64,Ab(this.Qd()))};g.Ud=function(){return Tn.prototype.Ud.call(this)};g.xl=function(){if(null!=this&&this.jl){var a=new Aja;a.a=this}else a=new Mo,a.a=this;return a};g.md=function(){var a=new to;kja(a,this);return a};g.Fj=function(){return mk(this.b.X().W(),u(function(a){var b=a.M();a=a.N();return lk(a.W(),u(function(c){return hl(b,c)}))}),64,Ab(this.Qd()))};
g.Vi=function(){return pja(this,this.b)};function Dja(a){return wea(a.b)?Co(a,a.b):vca(a.b)?sja(a,a.b):pja(a,a.b)}g.ba=!0;function Oo(){this.a=0}l(Oo,No);g=Oo.prototype;g.yl=function(){return kf()};g.Bj=function(a){return tf(a)};g.yh=function(a,b){return xja(this,a,b,null)};g.Va=function(a){return No.prototype.Va.call(this,a)};g.Pc=function(a){return No.prototype.Pc.call(this,a)};g.ya=function(a,b){return No.prototype.ya.call(this,a,b)};g.Yc=function(){return No.prototype.Yc.call(this)};
g.J=function(a){return No.prototype.J.call(this,a)};g.Dh=!0;function io(){this.a=0}l(io,Oo);io.prototype.bf=function(){return Cja(this)};io.prototype.Vi=function(){return Dja(this)};io.prototype.If=function(){return this.c.Na()};function Po(){}l(Po,Go);g=Po.prototype;g.lj=function(){return this.a};g.Fd=function(){return this.lj().Fd()};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;function Qo(){}l(Qo,Po);g=Qo.prototype;
g.lj=function(){return Po.prototype.lj.call(this)};function Eja(a,b){var c=new Qo,d=a.f,e=a.g;a=a.c?a.c:a;c.f=d;Ho(c,d,e,b,a);return c}g.Jf=function(){return Eja(this,this.lj().Jf())};g.Qg=function(a,b){return Eja(this,this.lj().Qg(a,b))};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;g.ee=!0;g.Yg=!0;function Fja(){}l(Fja,Go);function Gja(a,b,c){var d=new Fja;d.f=a;Ho(d,a,b,c,null);return d}g=Fja.prototype;
g.Qb=function(a){if(a.G())return!1;var b=this.w();if(a=Wha(this.a,a)){var c=this.a.w();this.f.a+=c-b;Fo(this)}return a};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Wa=!0;g.yb=!0;g.Sc=!0;function Ro(){this.a=0}l(Ro,No);g=Ro.prototype;g.yl=function(){return lf()};g.Bj=function(a){return xf(a)};g.yh=function(a,b){return Gja(this,a,b)};g.Va=function(a){return No.prototype.Va.call(this,a)};g.Ud=function(){return No.prototype.Ud.call(this)};
g.Pc=function(a){return No.prototype.Pc.call(this,a)};g.Yc=function(){return No.prototype.Yc.call(this)};g.ya=function(a,b){return No.prototype.ya.call(this,a,b)};g.J=function(a){return No.prototype.J.call(this,a)};g.Dh=!0;g.jl=!0;function Hja(){this.a=0}l(Hja,Ro);function fja(a,b){var c=new Hja;jo(c,a);c.c=G(b);return c}g=Hja.prototype;g.bf=function(){return Cja(this)};g.Vi=function(){return Dja(this)};g.Bj=function(a){return null!=a&&a.Yg?wia(a):null!=a&&a.ee?Tca(a):xf(a)};
g.yh=function(a,b){if(null!=b&&b.Yg){var c=new Qo;c.f=this;Ho(c,this,a,b,null);a=c}else null!=b&&b.ee?(c=new Po,Ho(c,this,a,b,null),a=c):a=Gja(this,a,b);return a};g.If=function(){return this.c.Na()};function So(){}l(So,n);So.prototype.f=function(a){return this.a.a.a.Va(a)};So.prototype.Tc=!0;function Ija(){}l(Ija,En);g=Ija.prototype;g.cg=function(){return this.a};g.h=function(){var a=this.a.a.Nc(),b=new So;b.a=this;return Xga(b,a.h())};
g.ra=function(a){if(!this.B(a))return!1;a=a.M();this.a.a.Nc().ra(a);return!0};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Jja(){}l(Jja,Bn);g=Jja.prototype;g.va=function(){return this.a.Nc().w()};g.get=function(a){return this.V(a)?this.a.Va(a):null};g.za=function(a){return this.V(a)?this.a.Pc(a):null};g.pa=function(){return this.a.Nc()};g.Ka=function(){return this.a.Rg()};g.V=function(a){return this.a.Zc(a)};
g.Aa=function(){this.a.ue()};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.cm=function(){var a=new Ija;a.a=this;return a};
function Kja(a){if(a instanceof pl)return a;a=a.X().h();if(!a.i())return Rj();var b=a.j(),c=b.M(),d=b.N();Uj(c,d);b=Fia();for(b.C(c,d);a.i();)d=a.j(),c=d.M(),d=d.N(),Uj(c,d),b.C(c,d);return Pga(b)}function Sm(a){return 3>a?(Vj(a,"expectedSize"),a+1):1073741824>a?Fb(a/.75+1):2147483647}function Yga(a,b){return hl(a,b)}function ol(a,b){G(a);try{return a.get(b)}catch(c){c=wa(c);if(sb(c))return null;throw c.s;}}function nl(a,b){G(a);try{return a.V(b)}catch(c){c=wa(c);if(sb(c))return!1;throw c.s;}}
function oja(a,b){G(a);try{return a.za(b)}catch(c){c=wa(c);if(sb(c))return null;throw c.s;}}function Sga(){}l(Sga,en);g=Sga.prototype;g.w=function(){return this.a.va()};g.h=function(){var a=this.a.X().h(),b=new ql;b.a=a;return b};g.W=function(){return Tga(this.a)};g.B=function(a){return this.a.V(a)};g.el=function(a){return this.a.X().df().F(a).M()};g.Z=function(a){G(a);this.a.kb(Sd(function(b){a.Ob(b)}))};g.Rd=function(){return!0};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
function To(){}l(To,Ak);To.prototype.i=function(){return this.a.i()};To.prototype.j=function(){return this.a.j().N()};To.prototype.da=function(a){zb(this,a)};function Lja(){}l(Lja,fm);g=Lja.prototype;g.F=function(a){return this.a.F(a).N()};g.Ue=function(){return this.b};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Uga(){}l(Uga,Ml);g=Uga.prototype;g.w=function(){return this.a.va()};
g.h=function(){var a=new To;a.b=this;a.a=a.b.a.X().h();return a};g.W=function(){return lk(this.a.X().W(),u(function(a){return a.N()}))};g.B=function(a){return null!=a&&Mja(this.h(),a)};g.Rd=function(){return!0};g.df=function(){var a=this.a.X().df();Pl();var b=new Lja;b.b=this;b.a=a;return b};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Nja(){}l(Nja,Mj);g=Nja.prototype;g.L=function(a,b){this.a.add(Nj(a,b));return this};
g.dl=function(a){Mj.prototype.dl.call(this,a)};g.cl=function(a){return this.bm(a.X())};g.bm=function(a){for(a=a.h();a.i();){var b=a.j();this.dl(b)}return this};g.Pb=function(){for(var a=Oja(this.b),b=this.a.h();b.i();){var c=b.j();Pja(a,c)}a=Sca(a);return Qja(a,this.b)};function jl(){}var Rja;l(jl,ml);function Qja(a,b){Uo();var c=new jl;fl(c,a);c.g=b;c.o=a;return c}
function Sja(a){Uo();a:{var b=(Jl(),Kl);if(a instanceof jl){var c=a.ce();if(c?b.J(c):q(b,Rja)){b=a;break a}}c=Oja(b);for(a=a.X().h();a.i();){var d=a.j();Pja(c,d)}c=Sca(c);b=Qja(c,b)}return b}function Pja(a,b){Uo();var c=G(b.M());b=G(b.N());if(a.V(c))throw a=a.Af(c).X().h().j(),va("Duplicate keys in mappings "+r(a.M())+"="+r(a.N())+" and "+r(c)+"="+r(b)).s;a.C(c,b)}function Tja(){Uo();var a=(Jl(),Kl),b=new Nja;b.a=x();b.b=G(a);return b}g=jl.prototype;
g.pa=function(){var a=this.u;return a?a:this.u=this.bf()};g.bf=function(){var a=this.g;var b=this.o.pa();vm();G(a);G(a);var c=null!=b&&b.ee?(c=b.Fd())?a.J(c):q(a,(Jl(),Kl)):!1;a=c&&b instanceof qm&&!(b instanceof xm&&b.c)?b:$ga(a,b.h());return a};g.ce=function(){return this.g};g.Af=function(a){G(a);a=this.o.Af(a);return Qja(a,this.g)};function Oja(a){Uo();return Qea(Vfa(a).Mg())}g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};
g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Uo(){Uo=function(){};Qj();Rja=(Jl(),Kl)}g.td=!0;g.Eh=!0;function Vo(){}l(Vo,ml);function Qga(a){Qj();var b=new Vo;fl(b,a);return b}function Yfa(a){Qj();var b=new Vo;b.b=null;b.c=null;b.f=null;for(var c=Of(),d=0;d<a.length;d++){var e=a[d],f=G(e.M());if(null!=c.C(f,G(e.N())))throw va("duplicate key: "+r(f)).s;}b.a=uf(c);return b}g=Vo.prototype;
g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Wo(){}l(Wo,ml);function Uja(){Qj();return Xo(),Vja}g=Wo.prototype;g.values=function(){return this.cf().pa()};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};
g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.td=!0;function Yo(){}var Vja;l(Yo,Wo);function Wja(){Xo();var a=new Yo,b=Qga(af());fl(a,b);return a.g=a}g=Yo.prototype;g.cf=function(){return this.g};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};
g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Xo(){Xo=function(){};Qj();Vja=Wja()}function el(){}l(el,Wo);g=el.prototype;g.cf=function(){var a=this.o;if(!a){a=new el;var b=this.g,c=this.u,d=Pca(G(b),G(c));fl(a,d);a.u=b;a.g=c;a.o=this;a=this.o=a}return a};g.values=function(){return om(this.g)};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};
g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function dm(){Nk.call(this)}l(dm,Nk);dm.prototype.c=function(a){return this.f.F(a)};dm.prototype.da=function(a){zb(this,a)};function Zo(){}l(Zo,Sl);g=Zo.prototype;g.indexOf=function(a){return this.Gd().indexOf(a)};g.lastIndexOf=function(a){return this.Gd().lastIndexOf(a)};g.F=function(a){return this.Gd().F(a)};g.Nb=function(a,b){return cm(this.Gd().Nb(a,b))};g.qc=function(){return this.Gd().ob(Array(this.w()))};
g.J=function(a){return Yc(this.Gd(),a)};g.P=function(){return $c(this.Gd())};g.h=function(){return tm(this.Gd().h())};g.B=function(a){return null!=a&&this.Gd().B(a)};g.Db=function(a){return this.Gd().Db(a)};g.w=function(){return this.Gd().w()};g.G=function(){return this.Gd().G()};g.ob=function(a){return this.Gd().ob(a)};g.toString=function(){return Be(this.Gd())};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function Xja(){}l(Xja,Zo);function Vl(a){Pl();var b=new Xja;b.a=tf(a);return b}g=Xja.prototype;g.Gd=function(){return this.a};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function oha(){}l(oha,Zo);g=oha.prototype;g.Gd=function(){return this.a};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function $o(){}l($o,Bd);g=$o.prototype;g.lc=function(a,b){this.a.lc(a,b)};g.F=function(a){return this.a.F(a)};g.Ya=function(a){return this.a.Ya(a)};g.Ub=function(a,b){return this.a.Ub(a,b)};g.B=function(a){return this.a.B(a)};g.w=function(){return this.a.w()};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Yja(){}l(Yja,$o);g=Yja.prototype;
g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Je=!0;function tha(){}l(tha,Yja);g=tha.prototype;g.Bb=function(a){return this.a.Bb(a)};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function uha(){}l(uha,$o);g=uha.prototype;g.Bb=function(a){return this.a.Bb(a)};
g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Zja(){this.b=!1}l(Zja,n);g=Zja.prototype;g.te=function(a){this.a.te(a);this.a.Gc();this.b=!1};g.i=function(){return this.a.Ec()};g.Ec=function(){return this.a.i()};g.j=function(){if(!this.i())throw Ld().s;this.b=!0;return this.a.Gc()};g.pd=function(){return ap(this.c,this.a.pd())};
g.Gc=function(){if(!this.Ec())throw Ld().s;this.b=!0;return this.a.j()};g.Od=function(){return this.pd()-1};g.ka=function(){Wj(this.b);this.a.ka();this.b=!1};g.Ed=function(a){E(this.b);this.a.Ed(a)};g.da=function(a){zb(this,a)};function bp(){}l(bp,Bd);function $ja(a,b){a=a.w();Qi(b,a);return a-1-b}function ap(a,b){a=a.w();Ri(b,a);return a-b}g=bp.prototype;g.lc=function(a,b){this.a.lc(ap(this,a),b)};g.ia=function(){this.a.ia()};g.Ya=function(a){return this.a.Ya($ja(this,a))};
g.Vl=function(a,b){this.Nb(a,b).ia()};g.Ub=function(a,b){return this.a.Ub($ja(this,a),b)};g.F=function(a){return this.a.F($ja(this,a))};g.w=function(){return this.a.w()};g.Nb=function(a,b){mfa(a,b,this.w());return cp(this.a.Nb(ap(this,b),ap(this,a)))};g.h=function(){return this.ae()};g.Bb=function(a){a=ap(this,a);a=this.a.Bb(a);var b=new Zja;b.c=this;b.a=a;return b};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};
g.Z=function(a){uc(this,a)};function aka(){}l(aka,bp);g=aka.prototype;g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Je=!0;function bka(){}l(bka,Sl);function cka(a){Pl();var b=new bka;b.a=a;return b}g=bka.prototype;g.indexOf=function(a){return ah(a)?ki(this.a,a.a):-1};g.lastIndexOf=function(a){return ah(a)?mi(this.a,a.a):-1};
g.Nb=function(a,b){mfa(a,b,this.w());return cka(G(ne(this.a,a,b)))};g.Rd=function(){return!1};g.F=function(a){Qi(a,this.w());return eh(this.a.charCodeAt(a))};g.w=function(){return this.a.length};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function dp(){}l(dp,Jk);g=dp.prototype;g.Ec=function(){return this.a.Ec()};g.Gc=function(){return this.b(this.a.Gc())};g.pd=function(){return this.a.pd()};
g.Od=function(){return this.a.Od()};g.Ed=function(){throw vb().s;};g.te=function(){throw vb().s;};g.da=function(a){zb(this,a)};function ep(){}l(ep,dp);ep.prototype.b=function(a){return this.c.b.f(a)};ep.prototype.da=function(a){zb(this,a)};function dka(){}l(dka,Bd);g=dka.prototype;g.ia=function(){this.a.ia()};g.F=function(a){return this.b.f(this.a.F(a))};g.h=function(){return this.ae()};g.Bb=function(a){a=this.a.Bb(a);var b=new ep;b.c=this;b.a=G(a);return b};g.G=function(){return this.a.G()};
g.ca=function(a){var b=this;G(a);return this.a.ca(ad(function(c){return a.Ca(b.b.f(c))}))};g.Ya=function(a){return this.b.f(this.a.Ya(a))};g.w=function(){return this.a.w()};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Je=!0;g.ba=!0;function fp(){}l(fp,dp);fp.prototype.b=function(a){return this.c.b.f(a)};fp.prototype.da=function(a){zb(this,a)};function eka(){}l(eka,ko);g=eka.prototype;g.ia=function(){this.a.ia()};g.w=function(){return this.a.w()};
g.Bb=function(a){a=this.a.Bb(a);var b=new fp;b.c=this;b.a=G(a);return b};g.ca=function(a){var b=this;G(a);return this.a.ca(ad(function(c){return a.Ca(b.b.f(c))}))};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.ba=!0;function Zl(a){var b=x();Wm(b,a);return b}function cp(a){if(a instanceof Sl)a=a.Cf();else if(a instanceof bp)a=a.a;else if(pd(a)){var b=new aka;b.a=G(a);a=b}else b=new bp,b.a=G(a),a=b;return a}
function vha(a,b){if(q(b,G(a)))return!0;if(!od(b))return!1;var c=a.w();if(c!=b.w())return!1;if(pd(a)&&pd(b)){for(var d=0;d<c;d++)if(!ek(a.F(d),b.F(d)))return!1;return!0}a:{a=a.h();for(b=b.h();a.i();){if(!b.i()){b=!1;break a}c=a.j();d=b.j();if(!ek(c,d)){b=!1;break a}}b=!b.i()}return b}function tm(a){G(a);if(!(a instanceof Ak)){var b=new Bk;b.a=a;a=b}return a}function Mja(a,b){if(null==b)for(;a.i();){if(null==a.j())return!0}else for(;a.i();)if(Yc(b,a.j()))return!0;return!1}
function qga(a){for(var b=Pg(Ng(),91),c=!0;a.i();)c||y(b,", "),c=!1,Sg(b,a.j());return Pg(b,93).toString()}function Wm(a,b){G(a);G(b);for(var c=!1;b.i();)c=!!(+c|+a.add(b.j()));return c}function fka(a,b){G(a);Ii(0<=b,"numberToAdvance must be nonnegative");var c;for(c=0;c<b&&a.i();c++)a.j();return c}function Kn(a){for(G(a);a.i();)a.j(),a.ka()}function gka(){}l(gka,Ml);function Vga(a){ll();var b=new gka;b.a=a;return b}g=gka.prototype;g.h=function(){return tm(this.a.h())};
g.B=function(a){return null!=a&&this.a.B(a)};g.Db=function(a){return this.a.Db(a)};g.w=function(){return this.a.w()};g.G=function(){return this.a.G()};g.qc=function(){return this.a.qc()};g.ob=function(a){return this.a.ob(a)};g.toString=function(){return Be(this.a)};g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function zk(a){jd(a)?a=a.T():(a=a.W(),a=hd(null,a));return a}function gp(){}l(gp,n);gp.prototype.f=function(a){return a.h()};
gp.prototype.Tc=!0;function hp(){}l(hp,uk);hp.prototype.h=function(){var a=this.c.h(),b=this.b;G(a);G(b);var c=new Ik;c.a=a;c.f=b;Hk(c);return c};hp.prototype.Z=function(a){var b=this;G(a);this.c.Z(yb(function(c){b.b.Ca(c)&&a.Ob(c)}))};hp.prototype.W=function(){var a=this.c.W(),b=this.b;G(a);G(b);var c=new gga;c.b=a;c.c=b;c.a=null;return c};function ip(){}l(ip,uk);ip.prototype.h=function(){var a=this.b.h(),b=this.c;G(b);return wga(b,a)};ip.prototype.Z=function(a){var b=this;G(a);this.b.Z(yb(function(c){a.Ob(b.c.f(c))}))};
ip.prototype.W=function(){return lk(this.b.W(),this.c)};function jp(){this.a=!1}l(jp,n);jp.prototype.i=function(){return this.b.i()};jp.prototype.j=function(){var a=this.b.j();this.a=!1;return a};jp.prototype.ka=function(){Wj(!this.a);this.b.ka()};jp.prototype.da=function(a){zb(this,a)};function kp(){this.c=0}l(kp,uk);kp.prototype.h=function(){if(od(this.b)){var a=this.b,b=Math.min(a.w(),this.c);return a.Nb(b,a.w()).h()}a=this.b.h();fka(a,this.c);b=new jp;b.b=a;b.a=!0;return b};
kp.prototype.W=function(){if(od(this.b)){var a=this.b,b=Math.min(a.w(),this.c);return a.Nb(b,a.w()).W()}a=zk(this.b);b=Ab(this.c);Hf(a);if(!b.J(hb(0))){var c=new fg,d=a.a,e=d.gc(64)?Nb(hb(0),Db(d.nd(),b)):Ub;Kc(c,e,d.sd());c.a=b;c.b=d;a=hd(a,c)}return a.Ie()};kp.prototype.Z=function(a){uc(this,a)};function lp(){this.b=0}l(lp,uk);lp.prototype.h=function(){var a=this.c.h(),b=this.b;G(a);Ii(0<=b,"limit is negative");var c=new Lk;c.c=b;c.a=a;return c};
lp.prototype.W=function(){var a=zk(this.c),b=Ab(this.b);Hf(a);var c=new dg,d=a.a;if(d.gc(64)){var e=d.nd();e=0>ab(e,b)?e:b}else e=Ub;Kc(c,e,d.sd());c.a=0;c.b=b;c.c=d;return hd(a,c).Ie()};lp.prototype.Z=function(a){uc(this,a)};function Sj(a){a=a.h();var b=a.j();if(a.i()){b=Sg(y(Ng(),"expected one element but was: <"),b);for(var c=0;4>c&&a.i();c++)Sg(y(b,", "),a.j());a.i()&&y(b,", ...");Pg(b,62);throw va(b.toString()).s;}return b}function dn(a,b){jd(b)?a.na(b):Wm(a,G(b).h())}
function mp(a,b){return xk(B([a,b],tc,Ac,1))}function hka(a,b){G(a);G(b);var c=new hp;c.c=a;c.b=b;c.a=jj();return c}function tp(a,b){G(a);G(b);var c=new ip;c.b=a;c.c=b;c.a=jj();return c}function up(a,b){G(a);if(od(a))b=a.F(b);else{a=a.h();if(0>b)throw La("position ("+b+") must not be negative").s;var c=fka(a,b);if(!a.i())throw La("position ("+b+") must be less than the number of elements that remained ("+c+")").s;b=a.j()}return b}function vp(a,b){a=a.h();return a.i()?a.j():b}
function wp(a){if(od(a)){if(a.G())throw Ld().s;return a.F(a.w()-1)}a:for(a=a.h();;){var b=a.j();if(!a.i())break a}return b}function ika(a){G(a);Ii(!0,"number to skip cannot be negative");var b=new kp;b.b=a;b.c=1;b.a=jj();return b}function xp(a){return jd(a)?a.G():!a.h().i()}function yp(){this.b=hb(0)}l(yp,bn);function zp(){var a=new yp,b=af();Hi(b.Ka());a.a=b;return a}yp.prototype.Z=function(a){Lm(this,a)};yp.prototype.W=function(){return Rm(this)};yp.prototype.ca=function(a){return ed(this,a)};
yp.prototype.T=function(){return fd(this)};function vo(a,b){G(a);try{return a.B(b)}catch(c){c=wa(c);if(sb(c))return!1;throw c.s;}}function wk(){}l(wk,uk);wk.prototype.h=function(){var a=this.b.h();var b=new gp;G(b);a=wga(b,a);return Fga(a)};wk.prototype.Z=function(a){uc(this,a)};wk.prototype.W=function(){return wc(this)};function Ap(){Nk.call(this)}l(Ap,Nk);Ap.prototype.c=function(a){return this.f[a].h()};Ap.prototype.da=function(a){zb(this,a)};function yk(){}l(yk,uk);
yk.prototype.h=function(){var a=new Ap,b=this.b.length;a.f=this.b;Ri(0,b);a.b=b;a.a=0;return Fga(a)};yk.prototype.Z=function(a){uc(this,a)};yk.prototype.W=function(){return wc(this)};function jka(){this.a=0}l(jka,n);function kka(a){var b=new jka;b.a=0;b.b=Ba([a],w,Wc,0);return b}
function Bp(a,b){var c=a.a+1;if(c>a.b.length){var d=a.b.length;if(0>c)throw jb("cannot store more than MAX_VALUE elements").s;d=d+(d>>1)+1;d<c&&(d=ph(c-1)<<1);0>d&&(d=2147483647);c=Ba([d],w,Wc,0);Fi(a.b,0,c,0,a.a);a.b=c}a.b[a.a]=b;a.a+=1}function Cp(a){if(0==a.a)var b=(Dp(),lka);else{b=a.b;a=a.a;Dp();var c=new Ep;c.c=b;c.a=0;c.b=a;b=c}return b}function Ep(){this.b=this.a=0}var lka;l(Ep,n);function Fp(a){Dp();Ji(0<=a,"Invalid initialCapacity: %s",a);return kka(a)}
function mka(){var a=Ba([0],w,Wc,0),b=new Ep,c=a.length;b.c=a;b.a=0;b.b=c;return b}g=Ep.prototype;g.Qa=function(){return this.b-this.a};function Gp(a,b){Qi(b,a.Qa());return a.c[a.a+b]}g.T=function(){var a=this.c,b=this.a,c=this.b,d=a.length;if(b>c||0>b||c>d)throw Daa("fromIndex: "+b+", toIndex: "+c+", length: "+d).s;d=new Pc;d.a=b;d.b=c;d.f=17488;d.c=a;return Gda(d)};
g.J=function(a){if(q(a,this))return!0;if(!(a instanceof Ep)||this.Qa()!=a.Qa())return!1;for(var b=0;b<this.Qa();b++)if(Gp(this,b)!=Gp(a,b))return!1;return!0};g.P=function(){for(var a=1,b=this.a;b<this.b;b++)a*=31,a+=this.c[b];return a};g.toString=function(){if(this.b==this.a)return"[]";var a=Og();Rg(Pg(a,91),this.c[this.a]);for(var b=this.a+1;b<this.b;b++)Rg(y(a,", "),this.c[b]);Pg(a,93);return a.toString()};function Dp(){Dp=function(){};lka=mka()}g.ba=!0;function Hp(){}var nka;l(Hp,n);
function oka(){Ip();return nka}function Ip(){Ip=function(){};nka=pka()}function qka(){}l(qka,Hp);qka.prototype.c=function(a,b){Ji(1>=b,"Expected limit of at most 1, but found %s",b);var c=a.Qa();switch(c-this.b.Qa()){case 0:for(var d=b=0;d<c&&(Gp(a,d)==Gp(this.b,d)||0==b++);d++);return b;case 1:return rka(this.b,a);case -1:return rka(a,this.b);default:return 2}};function rka(a,b){for(var c=a.Qa(),d=0;d<c;d++)if(Gp(b,d)!=Gp(a,d)){for(;d<c;d++)if(Gp(b,d+1)!=Gp(a,d))return 2;break}return 1}
function Jp(){}l(Jp,n);function ska(){}var tka;l(ska,Jp);ska.prototype.a=function(a){Ip();var b=new qka;b.b=a;return b};function uka(){uka=function(){};tka=new ska}function Kp(){this.a=!1}l(Kp,n);Kp.prototype.Na=function(){if(!this.a&&!this.a){var a=this.b.Na();this.c=a;this.a=!0;return a}return this.c};Kp.prototype.toString=function(){return"Suppliers.memoize("+r(this.a?"<supplier that returned "+r(this.c)+">":this.b)+")"};Kp.prototype.ba=!0;function Lp(){this.b=!1}l(Lp,n);
Lp.prototype.Na=function(){if(!this.b&&!this.b){var a=this.a.Na();this.c=a;this.b=!0;this.a=null;return a}return this.c};Lp.prototype.toString=function(){var a=this.a;return"Suppliers.memoize("+r(a?a:"<supplier that returned "+r(this.c)+">")+")"};function Mp(){this.a=0}var vka;l(Mp,A);function wka(){var a=new Mp;a.b="INSTANCE";a.a=0;return a}Mp.prototype.toString=function(){return"Suppliers.supplierFunction()"};Mp.prototype.R=function(a){return A.prototype.c.call(this,a)};Mp.prototype.f=function(a){return a.Na()};
function xka(){xka=function(){};vka=wka()}Mp.prototype.Tc=!0;function Np(){}l(Np,n);function yka(a){var b=new Np;b.a=a;return b}g=Np.prototype;g.Na=function(){return this.a};g.J=function(a){return a instanceof Np?ek(this.a,a.a):!1};g.P=function(){return Bg([this.a])};g.toString=function(){return"Suppliers.ofInstance("+r(this.a)+")"};g.ba=!0;
function zka(a){if(!(a instanceof Lp||a instanceof Kp)){if(null==a)var b=!1;else b=typeof a,b="boolean"===b||"number"===b||"string"===b||a.ba||Array.isArray(a);b?(b=new Kp,b.b=G(a),a=b):(b=new Lp,b.a=G(a),a=b)}return a}function Aka(){}l(Aka,n);Aka.prototype.Na=function(){return(Bka(),Cka).a(this.a.b,this.a.f)};function Dka(){this.g=this.f=0}l(Dka,Hp);
Dka.prototype.c=function(a,b){var c=a.Qa(),d=Math.abs(this.g-c);if(b<d)return d;if(0>=b)return this.b.J(a)?0:1;if(1>=b)return(uka(),tka).a(this.b,b).c(a,1);d=this.a;return d?64<this.g&&b<(c/10|0)?this.a.c(a,b):this.o.Na().c(a,b):(this.a=d=(Eka(),Fka).a(this.b,this.f),d.c(a,b))};function Gka(){}var Hka;l(Gka,Jp);
Gka.prototype.a=function(a,b){switch(a.Qa()){case 0:return oka();case 1:return Ip(),Li(1==a.Qa(),"Expected seq of length 1, found ",a),b=new Ika,b.b=a,b;default:Ip();var c=new Dka;c.b=a;a=new Aka;a.a=c;c.o=zka(a);c.a=null;c.f=b;c.g=c.b.Qa();return c}};function Jka(){Jka=function(){};Hka=new Gka}function Kka(){}var Op;l(Kka,Hp);function Lka(a,b,c,d,e,f,h){var k=c.Qa(),m=d.Qa();b=0==b?0:Math.max(Math.max(f,h)+1,e);for(k=Math.min(m,k-a);b<k&&Gp(c,b+a)==Gp(d,b);)b++;return b}
Kka.prototype.c=function(a,b){var c=this.b,d=a.Qa(),e=c.Qa()-d,f=Math.abs(e);if(f>b)return 2147483647;if(0>=e){Mka(this,f,!1);for(var h=0;h<=f;h++)this.o[h]=f-h-1,this.v[h]=-1}else for(Nka(this,f,!1),h=0;h<=f;h++)this.a[h]=-1,this.u[h]=-1;for(h=!0;;){var k=(f-e)/2|0;Mka(this,k,!0);h&&(this.o[k]=-1);for(var m=-1;0<k;k--)xd(this.g,k,m=Lka(e+k,f-k,c,a,this.v[k-1],this.o[k],m));k=(f+e)/2|0;Nka(this,k,!0);h&&(this.a[k]=((f-e)/2|0)-1);for(var p=h?-1:(f-e)/2|0;0<k;k--)xd(this.f,k,p=Lka(e-k,f-k,c,a,p,this.a[k],
this.u[k-1]));k=Lka(e,f,c,a,p,this.a[0],m);if(k==d||++f>b||0>f)break;xd(this.f,0,this.g[0]=k);this.u=this.a;this.a=this.f;this.f=this.u;k=this.v;this.v=this.o;this.o=this.g;this.g=k;h=!h}return f};function Nka(a,b,c){a.f.length<=b&&(b++,a.u=Pp(a.u,b,c),a.a=Pp(a.a,b,c),a.f=Pp(a.f,b,!1))}function Mka(a,b,c){a.g.length<=b&&(b++,a.v=Pp(a.v,b,c),a.o=Pp(a.o,b,c),a.g=Pp(a.g,b,!1))}function Pp(a,b,c){b=Ba([b],w,Wc,0);c&&Fi(a,0,b,0,a.length);return b}
function Oka(){Oka=function(){};Ip();Op=Ba([0],w,Wc,0)}function Pka(){}var Fka;l(Pka,Jp);Pka.prototype.a=function(a){Oka();var b=new Kka;b.b=a;b.f=Op;b.a=Op;b.u=Op;b.g=Op;b.o=Op;b.v=Op;return b};function Eka(){Eka=function(){};Fka=new Pka}function Qp(){this.a=0}l(Qp,Hp);function Qka(a,b,c){a.b=b;a.a=b.Qa();a.o=c}function Rka(){this.f=this.g=this.a=0}l(Rka,Qp);
Rka.prototype.c=function(a,b){var c=Ba([this.f],w,Wc,0);Nda(c,0,c.length,2147483647);var d=Ba([this.f],w,Wc,0),e=this.a,f=a.Qa();b=b+f-this.a;0>b&&(b=2147483647);var h=0;a:for(;h<f;h++)for(var k=this.o[Gp(a,h)],m=0,p=1,t=0,v=0;v<this.f;v++){var C=d[v],M=k[v]|C,I=c[v];m=(I&M)+I+(m>>>31|0);M|=m&2147483647^I;C|=~(M|I);I&=M;if(v==this.f-1)if(0!=(I&this.g))e--;else if(0!=(C&this.g)){if(e++,0>(b-=2))break a}else if(0>--b)break a;C=C<<1|p;p=C>>>31|0;I=I<<1|t;t=I>>>31|0;c[v]=(I|~(M|C))&2147483647;d[v]=M&
C&2147483647}return e};function Ska(){this.f=this.a=0}l(Ska,Qp);Ska.prototype.c=function(a,b){var c=a.Qa();if(c-this.a>b||this.a-c>b)return b+1;var d=-1,e=0,f=this.a;b=b+c-this.a;0>b&&(b=2147483647);for(var h=0;h<c;h++){var k=this.o[Gp(a,h)]|e;k|=(k&d)+d^d;e|=~(k|d);d&=k;if(0!=(d&this.f))f--;else if(0!=(e&this.f)){if(f++,0>(b-=2))break}else if(0>--b)break;e=e<<1|1;d=d<<1|~(k|e);e&=k}return f};function Tka(){this.a=0;this.f=hb(0)}l(Tka,Qp);
Tka.prototype.c=function(a,b){var c=a.Qa();if(c-this.a>b||this.a-c>b)return b+1;var d=Ab(-1),e=hb(0),f=this.a;b=b+c-this.a;0>b&&(b=2147483647);for(var h=0;h<c;h++){var k=Eb(this.o[Gp(a,h)],e),m=k;k=k.and(d).add(d).xor(d);k=m.or(k);e=Eb(e,Faa(k.or(d)));d=k.and(d);if(!d.and(this.f).J(hb(0)))f--;else if(!e.and(this.f).J(hb(0))){if(f++,0>(b-=2))break}else if(0>--b)break;e=eb(e,1).or(hb(1));d=Eb(eb(d,1),Faa(k.or(e)));e=k.and(e)}return f};var Uka=hb(1);function Vka(){}var Cka;l(Vka,Jp);
Vka.prototype.a=function(a,b){var c=a.Qa();if(0==c)a=oka();else if(32>=c){Ip();c=new Ska;b=Ba([b],w,Wc,0);for(var d=a.Qa(),e=0;e<d;e++)b[Gp(a,e)]|=1<<e;Qka(c,a,b);c.f=1<<c.a-1;a=c}else if(64>=c){Ip();c=new Tka;b=Ba([b],Qb,Yaa,Zaa);d=a.Qa();for(e=0;e<d;e++){var f=b,h=Gp(a,e);xd(f,h,f[h].or(eb(Uka,e)))}Qka(c,a,b);c.f=eb(Uka,c.a-1);a=c}else{Ip();c=new Rka;b=Ba([b,null],w,Wc,0);d=a.Qa();e=(d+31-1)/31|0;f=Ba([e],w,Wc,0);Ag(b,b.length,f);for(var k=h=0,m=0;m<d;m++){var p=Gp(a,m),t=b[p];q(t,f)&&(t=xd(b,p,
Ba([e],w,Wc,0)));t[h]|=1<<k;31==++k&&(k=0,h++)}Qka(c,a,b);c.f=(c.a+31-1)/31|0;c.g=1<<((c.a-1)%31|0);a=c}return a};function Bka(){Bka=function(){};Cka=new Vka}function Wka(){}l(Wka,Hp);function pka(){Dp();var a=lka;Ip();var b=new Wka;b.b=a;return b}Wka.prototype.c=function(a){return a.Qa()};function Ika(){}l(Ika,Hp);Ika.prototype.c=function(a){if(a.b==a.a)a=1;else{var b=Gp(this.b,0);a:{for(var c=a.a;c<a.b;c++)if(a.c[c]==b){b=c-a.a;break a}b=-1}a=0<=b?a.Qa()-1:a.Qa()}return a};var Xka;
function Yka(){Yka=function(){};Rp((Zka(),$ka));Xka=Rp((ala(),bla));Rp((cla(),dla));Rp((ela(),fla))}function gla(){}l(gla,n);function Rp(a){var b=(Jka(),Hka),c=new gla;c.b=G(a);c.a=G(b);return c}function Sp(){}l(Sp,n);Sp.prototype.f=function(a){for(var b=Fp(le(a)),c=0;c<le(a);c++)Bp(b,me(a,c));return Cp(b)};Sp.prototype.Tc=!0;function hla(){}l(hla,n);hla.prototype.a=function(a,b){var c=this.b.f(a);a=c.c;var d=c.a;c=c.b;Dc(d);Dc(c);Kd(d,d,a.length);a=Kda(a,Ba([c-d],w,Wc,0),d,c);for(d=0;d<a.length;d++)b.a(Dc(a[d]))};
function ila(){}l(ila,n);ila.prototype.a=function(a){a=this.c.f.wd(a);0==a&&(a=0);Bp(this.b,a)};function jla(){}var kla;l(jla,n);
function lla(a,b){Tp();a:{var c=new Up;c.c=b;for(var d=a.h();d.i();){var e=d.j();e=b.f(e);for(var f=0;f<e.Qa();f++)if(0!=(Gp(e,f)&-128)){c=null;break a}}}if(c)return c;a:{c=Ba([256],w,Wc,0);c[0]=1;for(d=a.h();d.i();)for(e=d.j(),e=b.f(e),f=0;f<e.Qa();f++){var h=Gp(e,f),k=h&255;if(c[k]!=h){if((c[k]&255)==k){c=null;break a}c[k]=h}}d=new Vp;d.c=b;d.g=c;c=d}if(c)return c;c=new hla;c.b=b;return mla(a,c)}
function mla(a,b){Tp();var c=zp(),d=new nla;d.b=c;d.c=0;for(a=a.h();a.i();){var e=a.j();b.a(e,d)}c instanceof gn||c instanceof Nm?d=c:(c=G(c),d=new gn,d.a=c);c=new Wp;c.f=d;c.g=b;c.c=d.oe().w()+1;return c}function Tp(){Tp=function(){};kla=new Sp}function Wp(){this.c=0}l(Wp,jla);Wp.prototype.a=function(a){Dp();var b=kka(10);var c=new ila;c.c=this;c.b=b;this.g.a(a,c);return Cp(b)};Wp.prototype.b=function(){return this.c};function nla(){this.c=0}l(nla,n);
nla.prototype.a=function(a){this.b.B(a)||this.b.Sg(a,++this.c)};function Xp(){}l(Xp,jla);Xp.prototype.a=function(a){a=this.c.f(a);for(var b=Fp(a.Qa()),c=0;c<a.Qa();c++)Bp(b,this.f(Gp(a,c)));return Cp(b)};function Up(){}l(Up,Xp);Up.prototype.f=function(a){return 0==(a&-128)?a:128};Up.prototype.b=function(){return 129};function Vp(){}l(Vp,Xp);Vp.prototype.f=function(a){var b=a&255;return a==this.g[b]?b:256};Vp.prototype.b=function(){return 257};function Yp(){}l(Yp,n);Yp.prototype.toString=function(){return zaa(la(ma(this)))};
function Zp(){}l(Zp,n);Zp.prototype.f=function(a){for(var b=Fp(le(a)),c=0;c<le(a);c++)Bp(b,Ig(me(a,c)).toLowerCase().charCodeAt(0));return Cp(b)};Zp.prototype.Tc=!0;function ola(){}var bla;l(ola,Yp);ola.prototype.a=function(a){return lla(a,new Zp)};function ala(){ala=function(){};bla=new ola}function pla(){}var $ka;l(pla,Yp);pla.prototype.a=function(a){Tp();return lla(a,kla)};function Zka(){Zka=function(){};$ka=new pla}function $p(){}l($p,n);
$p.prototype.f=function(a){var b=a.toString();a=Fp(le(a));for(var c=0;c<b.length;){var d=void 0;var e=c,f=me(b,e++),h;if(h=55296<=f&&56319>=f&&e<b.length)e=d=me(b,e),h=56320<=e&&57343>=e;d=h?65536+((f&1023)<<10)+(d&1023):f;c+=65536<=d?2:1;Bp(a,d)}return Cp(a)};$p.prototype.Tc=!0;function qla(){}var fla,rla;l(qla,Yp);qla.prototype.a=function(a){return lla(a,rla)};function ela(){ela=function(){};fla=new qla;rla=new $p}function sla(){}l(sla,n);
sla.prototype.a=function(a,b){for(a=a.h();a.i();){var c=a.j();b.a(c)}};function tla(){}var dla;l(tla,Yp);function ula(){var a=new tla;a.b=new sla;return a}tla.prototype.a=function(a){return mla(a,this.b)};function cla(){cla=function(){};dla=ula()}function vla(){}l(vla,n);
function wla(a,b){if(null==a)return b;switch(typeof a){case "object":if(Array.isArray(a)){for(var c=0;c<a.length;c++)b=wla(a[c],b);a=b}else{for(c in a)isNaN(c)||(b=wla(a[c],b));a=b}return a;case "boolean":return 17*b+(a?1:3)|0;case "number":return 17*b+a|0;case "string":c=1;for(var d=a.length,e=d-4,f=0;f<e;)c=a.charCodeAt(f)+31*c|0,c=a.charCodeAt(f+1)+31*c|0,c=a.charCodeAt(f+2)+31*c|0,c=a.charCodeAt(f+3)+31*c|0,f+=4;for(;f<d;)c=a.charCodeAt(f++)+31*c|0;return 17*b+c|0;default:return b}}
function aq(a){return-1!=bq.toLowerCase().indexOf(a.toLowerCase())}var bq;a:{var xla=ha.navigator;if(xla){var yla=xla.userAgent;if(yla){bq=yla;break a}}bq=""}function cq(a){return-1!=bq.indexOf(a)}function zla(){return cq("Firefox")||cq("FxiOS")}function Ala(){return(cq("Chrome")||cq("CriOS"))&&!cq("Edge")}function Bla(){return cq("iPhone")&&!cq("iPod")&&!cq("iPad")}function Cla(){Bla()||cq("iPad")||cq("iPod")}cq("Opera");cq("Trident")||cq("MSIE");cq("Edge");
!cq("Gecko")||aq("WebKit")&&!cq("Edge")||cq("Trident")||cq("MSIE")||cq("Edge");aq("WebKit")&&!cq("Edge")&&cq("Mobile");cq("Macintosh");cq("Windows");cq("Linux")||cq("CrOS");var Dla=ha.navigator||null;Dla&&(Dla.appVersion||"").indexOf("X11");cq("Android");Bla();cq("iPad");cq("iPod");Cla();aq("KaiOS");aq("GAFP");zla();Bla()||cq("iPod");cq("iPad");!cq("Android")||Ala()||zla()||cq("Opera")||cq("Silk");Ala();
!cq("Safari")||Ala()||cq("Coast")||cq("Opera")||cq("Edge")||cq("Edg/")||cq("OPR")||zla()||cq("Silk")||cq("Android")||Cla();ha.Symbol&&ha.Symbol.iterator&&(ca(),da());ca();da();function Ela(){}function Fla(){}function Gla(a,b){for(var c in a)b(c)}function dq(a){for(var b=a.length,c=0;c<b;c++)if(eq(a.charCodeAt(c))){for(a=Ci(a);c<b;c++){var d=a[c];eq(d)&&(a[c]=(d^32)&65535)}return Qg(a)}return a}function Hla(a){return eq(a)?(a^32)&65535:a}
function fq(a){for(var b=a.length,c=0;c<b;c++){var d=a.charCodeAt(c);if(97<=d&&122>=d){for(a=Ci(a);c<b;c++)d=a[c],97<=d&&122>=d&&(a[c]=(d^32)&65535);return Qg(a)}}return a}function Ila(a){return 97<=a&&122>=a?(a^32)&65535:a}function eq(a){return 65<=a&&90>=a}function gq(){this.a=0}var hq,Jla,Kla,Lla;l(gq,A);function iq(a,b,c,d,e){a.b=b;a.a=c;a.v=d;a.u=e}function Mla(a,b){var c=Kla;G(c);G(b);return q(c,a)?b:a.f(c,b)}
gq.prototype.f=function(a,b){for(var c=null,d=0,e=-1;-1!=(e=this.v.mj(b,++e));)0==d?(c=Og(),y(c,a.o(ne(b,d,e)))):y(c,a.g(ne(b,d,e))),y(c,a.u),d=e+this.u.length;return 0==d?a.o(b):y(c,a.g(b.substr(d))).toString()};gq.prototype.o=function(a){return this.g(a)};function Nla(a){jq();return ue(a)?a:Ig(Ila(a.charCodeAt(0)))+r(dq(a.substr(1)))}function jq(){jq=function(){};hq=Ola();Jla=Pla();Qla();Kla=Rla();Lla=Sla()}function kq(){this.a=0}l(kq,gq);
function Ola(){var a=$i(45);jq();var b=new kq;iq(b,"LOWER_HYPHEN",0,a,"-");return b}kq.prototype.g=function(a){return dq(a)};kq.prototype.f=function(a,b){return q(a,(jq(),Jla))?oi(b,45,95):q(a,(jq(),Lla))?fq(oi(b,45,95)):gq.prototype.f.call(this,a,b)};kq.prototype.R=function(a){return gq.prototype.c.call(this,a)};function lq(){this.a=0}l(lq,gq);function Pla(){var a=$i(95);jq();var b=new lq;iq(b,"LOWER_UNDERSCORE",1,a,"_");return b}lq.prototype.g=function(a){return dq(a)};
lq.prototype.f=function(a,b){return q(a,(jq(),hq))?oi(b,95,45):q(a,(jq(),Lla))?fq(b):gq.prototype.f.call(this,a,b)};lq.prototype.R=function(a){return gq.prototype.c.call(this,a)};function mq(){this.a=0}l(mq,gq);function Qla(){var a=Aj(65,90);jq();iq(new mq,"LOWER_CAMEL",2,a,"")}mq.prototype.g=function(a){return Nla(a)};mq.prototype.o=function(a){return dq(a)};mq.prototype.R=function(a){return gq.prototype.c.call(this,a)};function nq(){this.a=0}l(nq,gq);
function Rla(){var a=Aj(65,90);jq();var b=new nq;iq(b,"UPPER_CAMEL",3,a,"");return b}nq.prototype.g=function(a){return Nla(a)};nq.prototype.R=function(a){return gq.prototype.c.call(this,a)};function oq(){this.a=0}l(oq,gq);function Sla(){var a=$i(95);jq();var b=new oq;iq(b,"UPPER_UNDERSCORE",4,a,"_");return b}oq.prototype.g=function(a){return fq(a)};oq.prototype.f=function(a,b){return q(a,(jq(),hq))?dq(oi(b,95,45)):q(a,(jq(),Jla))?dq(b):gq.prototype.f.call(this,a,b)};
oq.prototype.R=function(a){return gq.prototype.c.call(this,a)};function pq(){this.v=!1;this.f=this.a=0}l(pq,mj);function Tla(a,b,c){a.c=(lj(),ufa);a.a=0;a.g=b.f;a.v=b.c;a.f=b.b;a.b=c}pq.prototype.da=function(a){zb(this,a)};function qq(){pq.call(this)}l(qq,pq);qq.prototype.D=function(a){return this.o.mj(this.b,a)};qq.prototype.A=function(a){return a+1};qq.prototype.da=function(a){zb(this,a)};function Ula(){}l(Ula,n);Ula.prototype.a=function(a,b){var c=new qq;c.o=this.b;Tla(c,a,b);return c};
function rq(){pq.call(this)}l(rq,pq);rq.prototype.da=function(a){zb(this,a)};rq.prototype.A=function(a){return a+this.o.length};rq.prototype.D=function(a){a:{var b=this.o.length;var c=le(this.b)-b;b:for(;a<=c;a++){for(var d=0;d<b;d++)if(me(this.b,d+a)!=this.o.charCodeAt(d))continue b;b=a;break a}b=-1}return b};function Vla(){}l(Vla,n);Vla.prototype.a=function(a,b){var c=new rq;c.o=this.b;Tla(c,a,b);return c};function Wla(){}l(Wla,n);g=Wla.prototype;g.h=function(){var a=this.b;return a.a.a(a,this.a)};
g.toString=function(){return Pg(qk(ok(", "),Pg(Ng(),91),this),93).toString()};g.Z=function(a){uc(this,a)};g.W=function(){return wc(this)};g.Wa=!0;function Xla(){this.c=!1;this.b=0}l(Xla,n);function Yla(a){var b=new Xla,c=(Yi(),Zi);b.a=a;b.c=!1;b.f=c;b.b=2147483647;return b}function Zla(a,b,c,d){var e=new Xla;e.a=a;e.c=b;e.f=c;e.b=d;return e}function sq(a){a=$i(a);G(a);var b=new Ula;b.b=a;return Yla(b)}
function $la(a){Ii(0!=a.length,"The separator may not be the empty string.");if(1==a.length)a=sq(a.charCodeAt(0));else{var b=new Vla;b.b=a;a=Yla(b)}return a}function ama(a){return Zla(a.a,!0,a.f,a.b)}function bma(a){Ji(!0,"must be greater than zero: %s",2);return Zla(a.a,a.c,a.f,2)}function tq(a,b){G(b);var c=new Wla;c.b=a;c.a=b;return c}function uq(a,b){G(b);a=a.a.a(a,b);for(b=x();a.i();)b.add(a.j());return tf(b)}function cma(){}var dma;l(cma,n);function ema(){ema=function(){};dma=new fma}
function fma(){}l(fma,cma);fma.prototype.a=function(){return(pj(),yfa).f()};function gma(){var a=hb(0),b=hb(0),c=hb(0),d=hb(0),e=hb(0);Hi(Bb(hb(0)));Hi(Bb(a));Hi(Bb(b));Hi(Bb(c));Hi(Bb(d));Hi(Bb(e))}function hma(){}l(hma,n);function vq(a){this.a=a}l(vq,n);function ima(){}l(ima,n);function wq(){this.a=0}var xq,jma,kma,lma;l(wq,A);function yq(){yq=function(){};xq=mma();jma=nma();kma=oma();lma=pma()}function qma(){this.a=0}l(qma,wq);function mma(){yq();var a=new qma;a.b="EXPLICIT";a.a=0;return a}
qma.prototype.R=function(a){return wq.prototype.c.call(this,a)};function rma(){this.a=0}l(rma,wq);function nma(){yq();var a=new rma;a.b="REPLACED";a.a=1;return a}rma.prototype.R=function(a){return wq.prototype.c.call(this,a)};function sma(){this.a=0}l(sma,wq);function oma(){yq();var a=new sma;a.b="EXPIRED";a.a=3;return a}sma.prototype.R=function(a){return wq.prototype.c.call(this,a)};function tma(){this.a=0}l(tma,wq);function pma(){yq();var a=new tma;a.b="SIZE";a.a=4;return a}
tma.prototype.R=function(a){return wq.prototype.c.call(this,a)};function uma(){}l(uma,xea);function vma(a,b){var c=(yq(),lma);return wma(a,b,c)}function wma(a,b,c){var d=new uma;d.f=a;d.c=b;G(c);return d}function zq(){this.u=!1;this.g=this.o=0;this.b=hb(0);this.a=hb(0);this.f=hb(0);this.c=hb(0)}var xma;l(zq,n);function yma(){zma();var a=new zq;a.u=!0;a.o=-1;a.g=-1;a.b=Ab(-1);a.a=Ab(-1);a.f=Ab(-1);a.c=Ab(-1);a.D=xma;return a}
function Ama(a,b){a.oa?a.u?F(!a.a.J(Ab(-1)),"weigher requires maximumWeight"):a.a.J(Ab(-1))&&tj():F(a.a.J(Ab(-1)),"maximumWeight requires weigher");var c=new Aq,d=G(b);b=new Bma;b.o=d;b.g=a.A;b.c=a.c;b.f=a.f;b.A=a.D.Na();d=!a.b.J(Ab(-1));var e=new Cma,f=a.b,h=b.A,k=b.g;Ze(e);Sf(e);e.g=d;Tf(e);e.o=f;e.v=h;e.u=k;b.a=e;a=a.$;ema();b.b=Rn(a,dma);c.a=b;return c}
zq.prototype.toString=function(){var a=Sn(this);-1!=this.o&&Pn(a,"initialCapacity",this.o);-1!=this.g&&Pn(a,"concurrencyLevel",this.g);this.b.J(Ab(-1))||Nn(a,"maximumSize",""+this.b);this.a.J(Ab(-1))||Nn(a,"maximumWeight",""+this.a);!this.f.J(Ab(-1))&&Nn(a,"expireAfterWrite",this.f+"ns");!this.c.J(Ab(-1))&&Nn(a,"expireAfterAccess",this.c+"ns");this.v&&Mn(a,"keyStrength",dq(this.v.toString()));this.K&&Mn(a,"valueStrength",dq(this.K.toString()));this.U&&(Qn(a).a="keyEquivalence");this.ja&&(Qn(a).a=
"valueEquivalence");this.A&&(Qn(a).a="removalListener");return a.toString()};function zma(){zma=function(){};xma=yka(new ima);gma();ema();ka(la(zq))}function Dma(){}l(Dma,n);function Ema(){}l(Ema,Dma);function Fma(a){var b=new Ema;b.a=G(a);return b}Ema.prototype.ba=!0;function Gma(){}l(Gma,hma);function Aq(){}l(Aq,Gma);
function Dq(a,b){try{var c=a.a,d=c.get(b);if(null!=d)var e=d;else{var f=c.b.a();try{var h=c.o.a.f(G(b));c.C(b,h)}catch(v){v=wa(v);if(v instanceof Ha){var k=v;Db(c.b.a(),f);throw Hma(k).s;}if(Fa(v)){var m=v;Db(c.b.a(),f);k=new Ima;ua(k,m);k.a(Error(k));throw k.s;}if(Ra(v))throw k=v,Db(c.b.a(),f),m=new Jma,ua(m,k),m.a(Error(m)),m.s;throw v.s;}if(null==h){var p=r(c.o)+" returned null for key "+r(b)+".",t=new Kma;sa(t,p);t.a(Error(t));throw t.s;}Db(c.b.a(),f);e=h}return e}catch(v$0){v$0=wa(v$0);if(v$0 instanceof
Ima)throw Hma(v$0.g).s;throw v$0.s;}}Aq.prototype.f=function(a){return Dq(this,a)};Aq.prototype.Tc=!0;function Kma(){}l(Kma,Ha);function Cma(){this.g=!1;this.o=hb(0)}l(Cma,Nf);g=Cma.prototype;g.an=function(a){if(this.o.J(Ab(-1)))var b=!1;else b=Ab(this.va()),b=0<ab(b,this.o);this.u&&b&&this.u.f(vma(a.M(),a.N().a));return b};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};
g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Eq(){this.c=hb(0);this.b=hb(0)}l(Eq,n);function Lma(a,b){var c=new Eq;c.a=G(a);c.f=G(b);c.c=b.a();c.b=c.c;return c}Eq.prototype.J=function(a){return Yc(this.a,a)};Eq.prototype.P=function(){return $c(this.a)};function Ima(){}l(Ima,Ea);function Mma(){}l(Mma,Ha);function Hma(a){var b=new Mma;ua(b,a);b.a(Error(b));return b}function Fq(){}l(Fq,ge);g=Fq.prototype;g.w=function(){return this.a.va()};
g.G=function(){return this.a.Ka()};g.ia=function(){this.a.Aa()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Nma(){}l(Nma,n);g=Nma.prototype;g.M=function(){return this.a};g.N=function(){return this.b};g.J=function(a){return Od(a)?Yc(this.a,a.M())&&Yc(this.b,a.N()):!1};g.P=function(){return $c(this.a)^$c(this.b)};g.Qc=function(){throw vb().s;};g.toString=function(){return r(this.M())+"="+r(this.N())};g.tg=!0;
function Gq(){}l(Gq,n);function Oma(a){var b=new Gq;b.c=a;b.f=a.a.X().h();return b}Gq.prototype.j=function(){if(!this.b&&(this.i(),!this.b))throw Ld().s;this.a=this.b;this.b=null;var a=this.a.M(),b=this.a.N().a,c=new Nma;c.a=G(a);c.b=G(b);return c};Gq.prototype.i=function(){if(!this.b){for(;this.f.i();){var a=this.f.j();if(!Hq(this.c,a.N()))return this.b=a,!0}return!1}return!0};Gq.prototype.ka=function(){E(!!this.a);this.c.ub(this.a.M(),this.a.N());this.a=null};
Gq.prototype.da=function(a){zb(this,a)};function Pma(){}l(Pma,Fq);g=Pma.prototype;g.h=function(){return Oma(this.b)};g.B=function(a){if(!Od(a))return!1;var b=a.M();if(null==b)return!1;b=this.b.get(b);return null!=b&&Yc(a.N(),b)};g.ra=function(a){if(!Od(a))return!1;var b=a.M();return null!=b&&this.b.ub(b,a.N())};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Iq(){}l(Iq,n);Iq.prototype.i=function(){return this.a.i()};
Iq.prototype.j=function(){return this.a.j().M()};Iq.prototype.ka=function(){this.a.ka()};Iq.prototype.da=function(a){zb(this,a)};function Qma(){}l(Qma,Fq);g=Qma.prototype;g.h=function(){var a=new Iq;a.a=Oma(this.b);return a};g.B=function(a){return this.a.V(a)};g.ra=function(a){return null!=this.a.za(a)};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Jq(){}l(Jq,n);Jq.prototype.i=function(){return this.a.i()};
Jq.prototype.j=function(){return this.a.j().N()};Jq.prototype.ka=function(){this.a.ka()};Jq.prototype.da=function(a){zb(this,a)};function Rma(){}l(Rma,wd);g=Rma.prototype;g.h=function(){var a=new Jq;a.a=Oma(this.b);return a};g.B=function(a){return this.a.Uc(a)};g.w=function(){return this.a.va()};g.G=function(){return this.a.Ka()};g.ia=function(){this.a.Aa()};g.ca=function(a){return ed(this,a)};g.W=function(){return Sc(this,0)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};
function Jma(){}l(Jma,Pa);function Bma(){this.f=hb(0);this.c=hb(0)}l(Bma,n);g=Bma.prototype;g.va=function(){return this.a.va()};g.Ka=function(){return this.a.Ka()};g.get=function(a){G(a);var b=this.a.get(a);if(b){if(Hq(this,b))return Kq(this,a,b.a,(yq(),kma)),this.a.za(a),null;b.b=b.f.a();return b.a}return null};g.C=function(a,b){G(a);G(b);b=this.a.C(a,Lma(b,this.b));if(!b)return null;Kq(this,a,b.a,(yq(),jma));return b.a};
g.za=function(a){var b=this.a.za(a);if(b){var c=b.a;if(!Hq(this,b))return Kq(this,a,c,(yq(),xq)),c;Kq(this,a,c,(yq(),kma))}return null};g.Hd=function(a){for(a=a.X().h();a.i();){var b=a.j();this.C(b.M(),b.N())}};g.Aa=function(){if(this.g)for(var a=this.a.X().h();a.i();){var b=a.j();Kq(this,b.M(),b.N().a,(yq(),xq))}this.a.Aa()};g.mb=function(a,b){var c=this.get(a);return null!=c?c:this.C(a,b)};g.ub=function(a,b){return Yc(b,this.get(a))?(Kq(this,a,b,(yq(),xq)),this.za(a),!0):!1};
g.V=function(a){return this.a.V(a)&&!Hq(this,this.a.get(a))};g.Uc=function(a){for(var b=this.a.values().h();b.i();){var c=b.j();if(Yc(c.a,a)&&!Hq(this,c))return!0}return!1};function Hq(a,b){if(a.c.J(Ab(-1))&&a.f.J(Ab(-1)))return!1;var c=b.c.add(a.f);var d=a.b.a();c=0>=ab(c,d);b=b.b.add(a.c);d=a.b.a();b=0>=ab(b,d);return a.c.J(Ab(-1))?c:a.f.J(Ab(-1))?b:c||b}function Kq(a,b,c,d){a.g&&a.g.f(wma(b,c,d))}g.pa=function(){var a=this.v;a||(a=new Qma,a.b=this,a.a=this,a=this.v=a);return a};
g.values=function(){var a=this.D;a||(a=new Rma,a.b=this,a.a=this,a=this.D=a);return a};g.X=function(){var a=this.u;a||(a=new Pma,a.b=this,a.a=this,a=this.u=a);return a};g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.vb=function(a){ee(this,a)};g.td=!0;function Sma(){}l(Sma,ge);g=Sma.prototype;g.B=function(a){if(null!=a&&a.kl){var b=ol(Lq(this.a),a.b);return!!b&&vo(b.X(),hl(a.a,a.c))}return!1};
g.ra=function(a){if(null!=a&&a.kl){var b=ol(Lq(this.a),a.b),c;if(c=!!b){b=b.X();a=hl(a.a,a.c);G(b);try{c=b.ra(a)}catch(d){if(d=wa(d),sb(d))c=!1;else throw d.s;}}return c}return!1};g.ia=function(){this.a.Hj()};g.h=function(){var a=new Mq;a.f=this.a;a.c=a.f.a.X().h();a.a=($k(),Zk);return a};g.W=function(){return Tma(this.a)};g.w=function(){return Uma(this.a)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Mq(){}l(Mq,n);
Mq.prototype.i=function(){return this.c.i()||this.a.i()};Mq.prototype.j=function(){this.a.i()||(this.b=this.c.j(),this.a=this.b.N().X().h());var a=this.a.j(),b=this.b.M(),c=a.M();a=a.N();return Vma(b,c,a)};Mq.prototype.ka=function(){this.a.ka();this.b.N().Ka()&&(this.c.ka(),this.b=null)};Mq.prototype.da=function(a){zb(this,a)};function Wma(){}l(Wma,Tm);g=Wma.prototype;g.G=function(){return this.b.a.Ka()};g.ia=function(){this.b.a.Aa()};g.W=function(){return Qd(this)};
g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Nq(){}l(Nq,n);Nq.prototype.i=function(){return this.a.i()};Nq.prototype.j=function(){var a=this.a.j();return Xma(a)};Nq.prototype.ka=function(){this.a.ka();Yma(this.b)};Nq.prototype.da=function(a){zb(this,a)};function Oq(){}l(Oq,In);function Xma(a){var b=new Oq;b.a=a;return b}Oq.prototype.Ab=function(){return this.a};Oq.prototype.Qc=function(a){return In.prototype.Qc.call(this,G(a))};
Oq.prototype.J=function(a){a=Od(a)?ek(this.M(),a.M())&&ek(this.N(),a.N()):!1;return a};function Zma(){}l(Zma,Jn);function $ma(a,b){var c=new Zma;c.b=a;c.c=G(b);return c}function Pq(a){return!a.a||a.a.Ka()&&a.b.a.V(a.c)?a.a=a.b.a.get(a.c):a.a}function Yma(a){Pq(a)&&a.a.Ka()&&(a.b.a.za(a.c),a.a=null)}g=Zma.prototype;g.V=function(a){var b=Pq(this);return null!=a&&!!b&&nl(b,a)};g.get=function(a){var b=Pq(this);return null!=a&&b?ol(b,a):null};
g.C=function(a,b){G(a);G(b);return this.a&&!this.a.Ka()?this.a.C(a,b):this.b.dc(this.c,a,b)};g.za=function(a){var b=Pq(this);if(!b)return null;a=oja(b,a);Yma(this);return a};g.Aa=function(){var a=Pq(this);a&&a.Aa();Yma(this)};g.va=function(){var a=Pq(this);return a?a.va():0};g.md=function(){var a=Pq(this);if(!a)return $k(),Zk;a=a.X().h();var b=new Nq;b.b=this;b.a=a;return b};g.on=function(){var a=Pq(this);return a?lk(a.X().W(),u(function(b){return Xma(b)})):(Aba(),yba)};
g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};function Qq(){}l(Qq,n);Qq.prototype.f=function(a){return $ma(this.a.a.a,a)};Qq.prototype.Tc=!0;function ana(){}l(ana,Wma);g=ana.prototype;g.h=function(){var a=this.a.a.a.pa(),b=new Qq;b.a=this;return Xga(b,a.h())};g.w=function(){return this.a.a.a.va()};
g.B=function(a){return Od(a)?null!=a.M()&&fe(a.N())&&vo(this.a.a.a.X(),a):!1};g.ra=function(a){return Od(a)?null!=a.M()&&fe(a.N())&&this.a.a.a.X().ra(a):!1};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function bna(){}l(bna,Bn);g=bna.prototype;g.V=function(a){return this.a.Ti(a)};g.get=function(a){return this.a.Ti(a)?$ma(this.a,a):null};g.za=function(a){return null==a?null:this.a.a.za(a)};
g.hb=function(a,b){return Ud(this,a,b)};g.kb=function(a){Vd(this,a)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.vb=function(a){ee(this,a)};g.cm=function(){var a=new ana;a.a=this;a.b=this.a;return a};function Rq(){}l(Rq,n);g=Rq.prototype;g.Ti=function(a){return nl(Lq(this),a)};g.Ui=function(a,b){a=ol(Lq(this),a);return!!a&&nl(a,b)};
g.Yd=function(a,b){return(a=ol(Lq(this),a))?ol(a,b):null};g.al=function(){return 0==Uma(this)};g.Hj=function(){Kn(this.bh().h())};g.bl=function(a,b){return(a=ol(Lq(this),a))?oja(a,b):null};g.dc=function(a,b,c){return $ma(this,a).C(b,c)};g.bh=function(){var a=this.c;a||(a=new Sma,a.a=this,a=this.c=a);return a};g.J=function(a){a=q(a,this)?!0:null!=a&&a.Gn?Yc(this.bh(),a.bh()):!1;return a};g.P=function(){return $c(this.bh())};g.toString=function(){return Be(Lq(this))};g.Gn=!0;function Sq(){}l(Sq,Rq);
g=Sq.prototype;g.Ui=function(a,b){return null!=a&&null!=b&&Rq.prototype.Ui.call(this,a,b)};g.Ti=function(a){return null!=a&&nl(this.a,a)};g.Yd=function(a,b){return null==a||null==b?null:Rq.prototype.Yd.call(this,a,b)};g.al=function(){return this.a.Ka()};function Uma(a){var b=0;for(a=a.a.values().h();a.i();){var c=a.j();b+=c.va()}return b}g.Hj=function(){this.a.Aa()};g.dc=function(a,b,c){G(a);G(b);G(c);var d=this.a.get(a);d||(d=this.b.Na(),this.a.C(a,d));return d.C(b,c)};
g.bl=function(a,b){if(null==a||null==b)return null;var c=ol(this.a,a);if(!c)return null;b=c.za(b);c.Ka()&&this.a.za(a);return b};g.bh=function(){return Rq.prototype.bh.call(this)};function Tma(a){return mk(a.a.X().W(),u(function(b){return lk(b.N().X().W(),u(function(c){var d=b.M(),e=c.M();c=c.N();return Vma(d,e,c)}))}),65,Ab(Uma(a)))}function Lq(a){var b=a.f;b?a=b:(b=new bna,b.a=a,a=a.f=b);return a}g.ba=!0;function Tq(){}l(Tq,n);
Tq.prototype.J=function(a){return q(a,this)?!0:null!=a&&a.kl?ek(this.b,a.b)&&ek(this.a,a.a)&&ek(this.c,a.c):!1};Tq.prototype.P=function(){return Bg([this.b,this.a,this.c])};Tq.prototype.toString=function(){return"("+r(this.b)+","+r(this.a)+")="+r(this.c)};Tq.prototype.kl=!0;function cna(){}l(cna,Tq);function Vma(a,b,c){var d=new cna;d.b=a;d.a=b;d.c=c;return d}cna.prototype.ba=!0;function dna(a,b){Hi(a.Ka());G(b);var c=new Sq;c.a=a;c.b=b;return c}function ena(){this.a=0}l(ena,Oo);
function fna(){this.c=this.a=0}l(fna,ena);function Uq(){var a=new fna,b=bf(Sm(12));jo(a,b);Vj(3,"expectedValuesPerKey");a.c=3;return a}fna.prototype.If=function(){return Jd()};function gna(){}var hna,ina,jna;l(gna,n);function Vq(){Vq=function(){};hna=new Wq;ina=kna(-1);jna=kna(1)}function Wq(){}l(Wq,gna);Wq.prototype.a=function(a,b){a=ic(a,b);return 0>a?(Vq(),ina):0<a?(Vq(),jna):(Vq(),hna)};Wq.prototype.c=function(){return 0};function Xq(){this.b=0}l(Xq,gna);
function kna(a){Vq();var b=new Xq;b.b=a;return b}Xq.prototype.a=function(){return this};Xq.prototype.c=function(){return this.b};function Yq(){this.a=0}l(Yq,n);Yq.prototype.Na=function(){return Uf(Sm(this.a))};Yq.prototype.ba=!0;function lna(){}l(lna,Sq);function Zq(){var a=Of(),b=new Yq;b.a=0;var c=new lna;c.a=a;c.b=b;return c}g=lna.prototype;g.Ui=function(a,b){return Sq.prototype.Ui.call(this,a,b)};g.Ti=function(a){return Sq.prototype.Ti.call(this,a)};
g.Yd=function(a,b){return Sq.prototype.Yd.call(this,a,b)};g.J=function(a){return Sq.prototype.J.call(this,a)};g.bl=function(a,b){return Sq.prototype.bl.call(this,a,b)};function $q(){}l($q,rl);$q.prototype.M=function(){return this.a.f};$q.prototype.N=function(){return this.a.c};
$q.prototype.Qc=function(a){var b=this.a.c,c=ar(a);if(c==this.a.o&&ek(a,b))return a;Li(!br(this.b.f,a,c),"value already present: %s",a);cr(this.b.f,this.a);a=dr(this.a.f,this.a.g,a,c);er(this.b.f,a,this.a);this.a.b=null;this.a.a=null;this.b.b=this.b.f.a;q(this.b.c,this.a)&&(this.b.c=a);this.a=a;return b};function fr(){this.u=this.b=0}l(fr,n);fr.prototype.i=function(){if(this.a.a!=this.b)throw Oe().s;return!!this.o&&0<this.u};
fr.prototype.j=function(){if(!this.i())throw Ld().s;var a=this.o;this.o=a.a;this.c=a;this.u--;return this.g(a)};fr.prototype.ka=function(){if(this.a.a!=this.b)throw Oe().s;Wj(!!this.c);cr(this.a,this.c);this.b=this.a.a;this.c=null};fr.prototype.da=function(a){zb(this,a)};function gr(a){a.o=a.a.b;a.c=null;a.b=a.a.a;a.u=a.a.va()}function hr(){fr.call(this)}l(hr,fr);hr.prototype.g=function(a){var b=new $q;b.b=this;b.a=a;return b};hr.prototype.da=function(a){zb(this,a)};
function ir(){this.o=this.g=0}l(ir,Oj);function dr(a,b,c,d){var e=new ir;e.f=a;e.c=c;e.g=b;e.o=d;return e}function jr(a){return a instanceof ir}function kr(){}l(kr,rl);kr.prototype.M=function(){return this.a.c};kr.prototype.N=function(){return this.a.f};kr.prototype.Qc=function(a){var b=this.a.f,c=ar(a);if(c==this.a.g&&ek(a,b))return a;Li(!lr(this.b.f.a,a,c),"value already present: %s",a);cr(this.b.f.a,this.a);this.a=a=dr(a,c,this.a.c,this.a.o);er(this.b.f.a,a,null);this.b.b=this.b.f.a.a;return b};
function ar(a){a=Raa(Ab(null==a?0:$c(a)),mna).a;for(var b=15;0<b--;)a=a<<1|(0>a?1:0);return Za(nna,Ab(a)).a}function ona(a){a=Math.max(a,2);var b=ph(a);return a>Fb(b)?(b<<=1,0<b?b:1073741824):b}var mna=hb(-862048943),nna=hb(461845907);function mr(){fr.call(this)}l(mr,fr);mr.prototype.g=function(a){return a.c};mr.prototype.da=function(a){zb(this,a)};function pna(){}l(pna,An);g=pna.prototype;g.ra=function(a){return(a=br(this.b.a,a,ar(a)))?(cr(this.b.a,a),!0):!1};
g.h=function(){var a=new mr;a.a=this.b.a;gr(a);return a};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};function qna(){}l(qna,Jn);g=qna.prototype;g.va=function(){return this.a.g};g.Aa=function(){this.a.Aa()};g.V=function(a){return this.a.Uc(a)};g.get=function(a){return(a=br(this.a,a,ar(a)))?a.M():null};
g.C=function(a,b){var c=this.a,d=ar(a),e=ar(b),f=br(c,a,d),h=lr(c,b,e);if(f&&e==f.g&&ek(b,f.f))a=b;else{if(h)throw va("key already present: "+r(b)).s;f&&cr(c,f);h&&cr(c,h);er(c,dr(b,e,a,d),h);h&&(h.b=null,h.a=null);f&&(f.b=null,f.a=null);rna(c);a=f?f.M():null}return a};g.za=function(a){return(a=br(this.a,a,ar(a)))?(cr(this.a,a),a.b=null,a.a=null,a.f):null};g.cf=function(){return this.a};g.pa=function(){var a=new pna;a.b=this;a.a=G(this);return a};g.values=function(){return this.a.pa()};
g.md=function(){var a=new nr;a.f=this;a.a=this.a;gr(a);return a};g.kb=function(a){G(a);this.a.kb(Sd(function(b,c){var d=a.a;d(c,b)}))};g.vb=function(a){G(a);var b=this.a.b;for(this.Aa();b;b=b.a)this.C(b.c,a.a(b.c,b.f))};g.hb=function(a,b){return Ud(this,a,b)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.td=!0;g.ba=!0;function or(){fr.call(this)}l(or,fr);or.prototype.g=function(a){return a.f};
or.prototype.da=function(a){zb(this,a)};function sna(){}l(sna,An);g=sna.prototype;g.h=function(){var a=new or;a.a=this.b;gr(a);return a};g.ra=function(a){return(a=lr(this.b,a,ar(a)))?(cr(this.b,a),a.b=null,a.a=null,!0):!1};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};function tna(){this.a=this.f=this.g=0}l(tna,Jn);
function una(){var a=new tna;Vj(16,"expectedSize");var b=ona(16);a.c=Ba([b],ir,jr,ir.a);a.o=Ba([b],ir,jr,ir.a);a.b=null;a.u=null;a.g=0;a.f=b-1;a.a=0;return a}function cr(a,b){for(var c=b.g&a.f,d=null,e=a.c[c];;e=e.u){if(q(e,b)){d?d.u=b.u:a.c[c]=b.u;break}d=e}c=b.o&a.f;d=null;for(e=a.o[c];;e=e.v){if(q(e,b)){d?d.v=b.v:a.o[c]=b.v;break}d=e}b.b?b.b.a=b.a:a.b=b.a;b.a?b.a.b=b.b:a.u=b.b;a.g--;a.a++}
function er(a,b,c){var d=b.g&a.f;b.u=a.c[d];a.c[d]=b;d=b.o&a.f;b.v=a.o[d];a.o[d]=b;c?(b.b=c.b,b.b?b.b.a=b:a.b=b,b.a=c.a,b.a?b.a.b=b:a.u=b):(b.b=a.u,b.a=null,a.u?a.u.a=b:a.b=b,a.u=b);a.g++;a.a++}function lr(a,b,c){for(a=a.c[c&a.f];a;a=a.u)if(c==a.g&&ek(b,a.f))return a;return null}function br(a,b,c){for(a=a.o[c&a.f];a;a=a.v)if(c==a.o&&ek(b,a.c))return a;return null}g=tna.prototype;g.V=function(a){return!!lr(this,a,ar(a))};g.Uc=function(a){return!!br(this,a,ar(a))};
g.get=function(a){return(a=lr(this,a,ar(a)))?a.N():null};g.C=function(a,b){var c;var d=ar(a),e=ar(b);if((c=lr(this,a,d))&&e==c.o&&ek(b,c.c))c=b;else{if(br(this,b,e))throw va("value already present: "+r(b)).s;a=dr(a,d,b,e);c?(cr(this,c),er(this,a,c),c.b=null,c.a=null,c=c.c):(er(this,a,null),rna(this),c=null)}return c};function rna(a){var b=a.c,c=b.length;if(a.g>c&&1073741824>c){b=2*b.length;a.c=Ba([b],ir,jr,ir.a);a.o=Ba([b],ir,jr,ir.a);a.f=b-1;a.g=0;for(b=a.b;b;b=b.a)er(a,b,b);a.a++}}
g.za=function(a){return(a=lr(this,a,ar(a)))?(cr(this,a),a.b=null,a.a=null,a.c):null};g.Aa=function(){this.g=0;var a=this.c;Ag(a,a.length,null);a=this.o;Ag(a,a.length,null);this.u=this.b=null;this.a++};g.va=function(){return this.g};g.pa=function(){var a=new sna;a.b=this;a.a=G(this);return a};g.values=function(){return this.cf().pa()};g.md=function(){var a=new hr;a.f=this;a.a=this;gr(a);return a};g.kb=function(a){G(a);for(var b=this.b;b;b=b.a){var c=a.a;c(b.f,b.c)}};
g.vb=function(a){G(a);var b=this.b;for(this.Aa();b;b=b.a)this.C(b.f,a.a(b.f,b.c))};g.cf=function(){var a=this.v;a||(a=new qna,a.a=this,a=this.v=a);return a};g.hb=function(a,b){return Ud(this,a,b)};g.ab=function(a,b){return Xd(this,a,b)};g.tb=function(a,b,c){Yd(this,a,b,c)};g.mb=function(a,b){return $d(this,a,b)};g.ub=function(a,b){return ae(this,a,b)};g.td=!0;g.ba=!0;function nr(){fr.call(this)}l(nr,fr);nr.prototype.g=function(a){var b=new kr;b.b=this;b.a=a;return b};
nr.prototype.da=function(a){zb(this,a)};function vna(){this.a=0}l(vna,Ro);function wna(){this.c=this.a=0}l(wna,vna);function pr(){var a=new wna,b=bf(Sm(12));jo(a,b);a.c=2;Hi(!0);a.c=2;return a}wna.prototype.If=function(){return jf(Sm(this.c))};function qr(){}l(qr,n);qr.prototype.i=function(){return!q(this.a,this.c.c)};qr.prototype.j=function(){if(!this.i())throw Ld().s;var a=this.a;this.b=a;this.a=this.a.g;return a};qr.prototype.ka=function(){Wj(!!this.b);this.c.ag(this.b.M(),this.b.N());this.b=null};
qr.prototype.da=function(a){zb(this,a)};function rr(){this.b=0}l(rr,Oj);function xna(a,b,c){return a.b==c&&ek(a.N(),b)}rr.prototype.Lm=function(){return this.u};rr.prototype.oh=function(){return this.v};rr.prototype.dn=function(a){this.u=a};rr.prototype.en=function(a){this.v=a};function yna(a){return a instanceof rr}function sr(){this.b=0}l(sr,n);function zna(a){if(a.a.b!=a.b)throw Oe().s;}sr.prototype.i=function(){zna(this);return!q(this.c,this.a)};
sr.prototype.j=function(){if(!this.i())throw Ld().s;var a=this.c,b=a.N();this.f=a;this.c=a.oh();return b};sr.prototype.ka=function(){zna(this);Wj(!!this.f);this.a.ra(this.f.N());this.b=this.a.b;this.f=null};sr.prototype.da=function(a){zb(this,a)};function tr(){this.a=0}l(tr,Ro);function Ana(){this.f=this.a=0}l(Ana,tr);function ur(a,b){a.en(b);b.dn(a)}function vr(a,b){a.g=b;b.o=a}
function wr(){var a=new Ana,b=Uf(Sm(16));jo(a,b);a.f=2;Vj(2,"expectedValuesPerKey");a.f=2;b=new rr;b.f=null;b.c=null;b.b=0;b.a=null;a.c=b;vr(a.c,a.c);return a}g=Ana.prototype;g.If=function(){return Kha(Sm(this.f))};g.wl=function(a){var b=new Bna,c=this.f;b.o=this;b.f=0;b.b=0;b.u=a;b.c=b;b.g=b;b.a=Ba([ona(c)],rr,yna,rr.a);return b};g.Ud=function(){return tr.prototype.Ud.call(this)};g.Nc=function(){return tr.prototype.Nc.call(this)};g.Rc=function(){return tr.prototype.Rc.call(this)};
g.md=function(){var a=new qr;a.c=this;a.a=a.c.c.g;return a};g.Fj=function(){var a=this.Ud();return Sc(a,17)};g.xh=function(){return Wga(this.md())};g.Zl=function(){return lk(this.Fj(),u(function(a){return a.N()}))};g.ue=function(){tr.prototype.ue.call(this);vr(this.c,this.c)};function Bna(){this.b=this.f=0}l(Bna,Tm);g=Bna.prototype;g.Lm=function(){return this.g};g.oh=function(){return this.c};g.dn=function(a){this.g=a};g.en=function(a){this.c=a};
g.h=function(){var a=new sr;a.a=this;a.c=a.a.c;a.b=a.a.b;return a};g.Z=function(a){G(a);for(var b=this.c;!q(b,this);b=b.oh())a.Ob(b.N())};g.w=function(){return this.f};g.B=function(a){for(var b=ar(a),c=this.a[b&this.a.length-1];c;c=c.a)if(xna(c,a,b))return!0;return!1};
g.add=function(a){for(var b=ar(a),c=b&this.a.length-1,d=this.a[c],e=d;e;e=e.a)if(xna(e,a,b))return!1;e=new rr;e.f=this.u;e.c=a;e.b=b;e.a=d;ur(this.g,e);ur(e,this);vr(this.o.c.o,e);vr(e,this.o.c);this.a[c]=e;this.f++;this.b++;a=this.a.length;if(this.f>a&&1073741824>a)for(this.a=a=Ba([2*this.a.length],rr,yna,rr.a),b=a.length-1,c=this.c;!q(c,this);c=c.oh())d=c,e=d.b&b,d.a=a[e],a[e]=d;return!0};
g.ra=function(a){for(var b=ar(a),c=b&this.a.length-1,d=null,e=this.a[c];e;d=e,e=e.a)if(xna(e,a,b))return d?d.a=e.a:this.a[c]=e.a,ur(e.Lm(),e.oh()),vr(e.o,e.g),this.f--,this.b++,!0;return!1};g.ia=function(){var a=this.a;Ag(a,a.length,null);this.f=0;for(a=this.c;!q(a,this);a=a.oh()){var b=a;vr(b.o,b.g)}ur(this,this);this.b++};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};function Cna(){}l(Cna,ko);g=Cna.prototype;
g.w=function(){var a=this.b.a.get(this.a);return a?a.a:0};g.Bb=function(a){var b=new xr,c=this.b,d=this.a;b.g=c;var e=(c=c.a.get(d))?c.a:0;Ri(a,e);if(a>=(e/2|0))for(b.c=c?c.c:null,b.f=e;a++<e;)b.Gc();else for(b.b=c?c.b:null;0<a--;)b.j();b.o=d;b.a=null;return b};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Dna(){this.a=0}l(Dna,n);
function Ena(a){var b=new Dna;b.b=a;b.c=a;a.a=null;a.c=null;b.a=1;return b}function yr(){}l(yr,rl);yr.prototype.M=function(){return this.g};yr.prototype.N=function(){return this.o};yr.prototype.Qc=function(a){var b=this.o;this.o=a;return b};function xr(){this.f=0}l(xr,n);function Fna(a,b){var c=new xr;c.g=a;c.o=b;a=a.a.get(b);c.b=a?a.b:null;return c}g=xr.prototype;g.i=function(){return!!this.b};g.j=function(){zr(this.b);this.c=this.a=this.b;this.b=this.b.c;this.f++;return this.a.o};g.Ec=function(){return!!this.c};
g.Gc=function(){zr(this.c);this.b=this.a=this.c;this.c=this.c.a;this.f--;return this.a.o};g.pd=function(){return this.f};g.Od=function(){return this.f-1};g.ka=function(){Wj(!!this.a);q(this.a,this.b)?this.b=this.a.c:(this.c=this.a.a,this.f--);Gna(this.g,this.a);this.a=null};g.Ed=function(a){E(!!this.a);this.a.o=a};g.te=function(a){this.c=Hna(this.g,this.o,a,this.b);this.f++;this.a=null};g.da=function(a){zb(this,a)};function Ina(){}l(Ina,ko);g=Ina.prototype;g.w=function(){return this.a.f};
g.Bb=function(a){return Jna(this.a,a)};g.Z=function(a){G(a);for(var b=this.a.c;b;b=b.f)a.Ob(b)};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};function Kna(){this.o=this.f=0}l(Kna,n);function Jna(a,b){var c=new Kna;c.g=a;c.o=c.g.b;var d=a.Qd();Ri(b,d);if(b>=(d/2|0))for(c.c=a.g,c.f=d;b++<d;)c.Gc();else for(c.b=a.c;0<b--;)c.j();c.a=null;return c}function Ar(a){if(a.g.b!=a.o)throw Oe().s;}g=Kna.prototype;
g.i=function(){Ar(this);return!!this.b};g.j=function(){Ar(this);zr(this.b);this.c=this.a=this.b;this.b=this.b.f;this.f++;return this.a};g.ka=function(){Ar(this);Wj(!!this.a);q(this.a,this.b)?this.b=this.a.f:(this.c=this.a.b,this.f--);Gna(this.g,this.a);this.a=null;this.o=this.g.b};g.Ec=function(){Ar(this);return!!this.c};g.Gc=function(){Ar(this);zr(this.c);this.b=this.a=this.c;this.c=this.c.b;this.f--;return this.a};g.pd=function(){return this.f};g.Od=function(){return this.f-1};
g.da=function(a){zb(this,a)};g.te=function(){throw vb().s;};g.Ed=function(){throw vb().s;};function Br(){this.f=0}l(Br,n);function Lna(a){if(a.b.b!=a.f)throw Oe().s;}Br.prototype.i=function(){Lna(this);return!!this.a};Br.prototype.j=function(){Lna(this);zr(this.a);this.c=this.a;this.g.add(this.c.g);do this.a=this.a.f;while(this.a&&!this.g.add(this.a.g));return this.c.g};Br.prototype.ka=function(){Lna(this);Wj(!!this.c);Kn(Fna(this.b,this.c.g));this.c=null;this.f=this.b.b};
Br.prototype.da=function(a){zb(this,a)};function Mna(){}l(Mna,Tm);g=Mna.prototype;g.w=function(){return this.a.a.va()};g.h=function(){var a=new Br;a.b=this.a;a.g=jf(Sm(a.b.Nc().w()));a.a=a.b.c;a.f=a.b.b;return a};g.B=function(a){return this.a.Zc(a)};g.ra=function(a){return!this.a.Pc(a).G()};g.W=function(){return Qd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Cr(){}l(Cr,dp);Cr.prototype.Ed=function(a){var b=this.c;E(!!b.a);b.a.o=a};
Cr.prototype.da=function(a){zb(this,a)};Cr.prototype.b=function(a){return a.N()};function Nna(){}l(Nna,ko);g=Nna.prototype;g.w=function(){return this.a.f};g.Bb=function(a){a=Jna(this.a,a);var b=new Cr;b.c=a;b.a=G(a);return b};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};function Ona(){this.b=this.f=0}l(Ona,Tn);
function Hna(a,b,c,d){var e=new yr;e.g=b;e.o=c;a.c?d?(a.a.get(b).a++,e.b=d.b,e.a=d.a,e.f=d,e.c=d,d.a?d.a.c=e:a.a.get(b).b=e,d.b?d.b.f=e:a.c=e,d.b=e,d.a=e):(a.g.f=e,e.b=a.g,a.g=e,(c=a.a.get(b))?(c.a++,b=c.c,b.c=e,e.a=b,c.c=e):(a.a.C(b,Ena(e)),a.b++)):(a.c=a.g=e,a.a.C(b,Ena(e)),a.b++);a.f++;return e}function Gna(a,b){b.b?b.b.f=b.f:a.c=b.f;b.f?b.f.b=b.b:a.g=b.b;if(b.a||b.c){var c=a.a.get(b.g);c.a--;b.a?b.a.c=b.c:c.b=b.c;b.c?b.c.a=b.a:c.c=b.a}else a.a.za(b.g).a=0,a.b++;a.f--}
function zr(a){if(null==a)throw Ld().s;}g=Ona.prototype;g.Qd=function(){return this.f};g.Rg=function(){return!this.c};g.Zc=function(a){return this.a.V(a)};g.Ej=function(a){return this.Rc().B(a)};g.ya=function(a,b){Hna(this,a,b,null);return!0};g.Pc=function(a){var b=tf(Zl(Fna(this,a)));Kn(Fna(this,a));return b};g.ue=function(){this.g=this.c=null;this.a.Aa();this.f=0;this.b++};g.Va=function(a){var b=new Cna;b.b=this;b.a=a;return b};g.bf=function(){var a=new Mna;a.a=this;return a};g.Rc=function(){return Tn.prototype.Rc.call(this)};
g.zh=function(){var a=new Nna;a.a=this;return a};g.Ud=function(){return Tn.prototype.Ud.call(this)};g.xl=function(){var a=new Ina;a.a=this;return a};g.md=function(){throw jb("should never be called").s;};g.Vi=function(){var a=new Jja;a.a=G(this);return a};g.Dh=!0;g.ba=!0;function Dr(){this.f=this.c=this.a=0}l(Dr,n);
function Pna(a,b){var c=new Dr;c.u=G(a);c.b=G(b);try{a:{var d=b.length,e=(jha(),hha);mha();if(0>=d)throw va("x ("+d+") must be > 0").s;switch(e.a){case 7:kha(!!(+(0<d)&+(0==(d&d-1))));case 1:case 3:var f=31-qh(d);break a;case 0:case 2:f=32-qh(d-1);break a;case 5:case 4:case 6:var h=qh(d);f=31-h+(~~((-1257966797>>>h|0)-d)>>>31|0);break a;default:throw ib().s;}}c.a=f}catch(m){m=wa(m);if(m instanceof Oa)throw Laa("Illegal alphabet length "+b.length,m).s;throw m.s;}a=c.a;a=Math.min(8,a&-a);try{c.c=8/
a|0,c.f=c.a/a|0}catch(m$1){m$1=wa(m$1);if(m$1 instanceof Oa)throw c=m$1,Laa("Illegal alphabet "+r(Qg(b)),c).s;throw m$1.s;}a=Ba([128],qc,sc,0);f=a.length;for(d=0;d<f;++d)a[d]=-1;for(f=0;f<b.length;f++){d=b[f];if(!(d<a.length))throw va(Ki("Non-ASCII character: %s",[eh(d)])).s;if(-1!=a[d])throw va(Ki("Duplicate character: %s",[eh(d)])).s;a[d]=f<<24>>24}c.g=a;b=Ba([c.c],Vc,Lba,!1);for(a=0;a<c.f;a++){e=8*a;h=c.a;d=(jha(),iha);mha();G(d);if(0==h)throw Baa("/ by zero").s;f=e/h|0;var k=e-h*f;if(0!=k){e=
1|(e^h)>>31;switch(d.a){case 7:kha(0==k);case 1:d=!1;break;case 0:d=!0;break;case 2:d=0<e;break;case 3:d=0>e;break;case 6:case 5:case 4:k=Math.abs(k);h=k-(Math.abs(h)-k);d=0==h?q(d,fha)||!!(+q(d,gha)&+(0!=(f&1))):0<h;break;default:throw ib().s;}f=d?f+e:f}b[f]=!0}c.o=b;return c}function Er(a,b){if(127<b)throw Fr("Unrecognized character: 0x"+r(na(b))).s;a=a.g[b];if(-1==a){if(32>=b||127==b)throw Fr("Unrecognized character: 0x"+r(na(b))).s;throw Fr("Unrecognized character: "+Ig(b)).s;}return a}
Dr.prototype.toString=function(){return this.u};Dr.prototype.J=function(a){return a instanceof Dr?Lda(this.b,a.b):!1};Dr.prototype.P=function(){var a;if(a=this.b){for(var b=1,c=0;c<a.length;c++)b=31*b+a[c],b|=0;a=b}else a=0;return a};function Qna(){}l(Qna,vaa);function Fr(a){var b=new Qna;sa(b,a);b.a(Error(b));return b}function Rna(){}var Sna;l(Rna,n);Rna.prototype.Yk=function(a){return G(a)};
function Gr(){Gr=function(){};Sna=Tna("base64()","ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");Tna("base64Url()","ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");Una("base32()","ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");Una("base32Hex()","0123456789ABCDEFGHIJKLMNOPQRSTUV");Vna()}function Hr(){}l(Hr,Rna);function Una(a,b){var c=eh(61);Gr();Wna(new Hr,Pna(a,Ci(b)),c)}
function Wna(a,b,c){a.a=G(b);var d;(d=!c)||(d=c.a,d=!(d<b.g.length&&-1!=b.g[d]));Li(d,"Padding character %s was already in alphabet",c);a.b=c}g=Hr.prototype;g.Yk=function(a){G(a);if(!this.b)return a;var b=this.b.a,c;for(c=le(a)-1;0<=c&&me(a,c)==b;c--);return bca(a,0,c+1)};
g.zl=function(a,b){G(a);b=this.Yk(b);var c=this.a;if(!c.o[le(b)%c.c|0])throw Fr("Invalid input length "+le(b)).s;for(var d=c=0;d<le(b);d+=this.a.c){for(var e=hb(0),f=0,h=0;h<this.a.c;h++)e=eb(e,this.a.a),d+h<le(b)&&(e=Eb(e,Ab(Er(this.a,me(b,d+f++)))));f=8*this.a.f-f*this.a.a;for(h=8*(this.a.f-1);h>=f;h-=8){var k=c++,m=Gaa(e,h).and(hb(255));a[k]=m.a<<24>>24}}return c};
g.toString=function(){var a=ve("BaseEncoding.");y(a,this.a.toString());0!=(8%this.a.a|0)&&(this.b?y(Sg(y(a,".withPadChar('"),this.b),"')"):y(a,".omitPadding()"));return a.toString()};g.J=function(a){return a instanceof Hr?this.a.J(a.a)&&ek(this.b,a.b):!1};g.P=function(){return this.a.P()^Bg([this.b])};function Xna(){}l(Xna,Hr);
function Vna(){Gr();var a=new Xna,b=Pna("base16()",Ci("0123456789ABCDEF"));Wna(a,b,null);a.c=Ba([512],Ob,Pb,0);Hi(16==b.b.length);for(var c=0;256>c;++c)a.c[c]=b.b[c>>>4|0],a.c[c|256]=b.b[c&15]}Xna.prototype.zl=function(a,b){G(a);if(1==(le(b)%2|0))throw Fr("Invalid input length "+le(b)).s;for(var c=0,d=0;d<le(b);d+=2){var e=Er(this.a,me(b,d))<<4|Er(this.a,me(b,d+1));xd(a,c++,e<<24>>24)}return c};function Yna(){}l(Yna,Hr);
function Tna(a,b){var c=eh(61);Gr();var d=new Yna;a=Pna(a,Ci(b));Wna(d,a,c);Hi(64==a.b.length);return d}Yna.prototype.zl=function(a,b){G(a);b=this.Yk(b);var c=this.a;if(!c.o[le(b)%c.c|0])throw Fr("Invalid input length "+le(b)).s;for(var d=c=0;d<le(b);){var e=Er(this.a,me(b,d++))<<18;e|=Er(this.a,me(b,d++))<<12;xd(a,c++,(e>>>16|0)<<24>>24);d<le(b)&&(e|=Er(this.a,me(b,d++))<<6,xd(a,c++,((e>>>8|0)&255)<<24>>24),d<le(b)&&(e|=Er(this.a,me(b,d++)),xd(a,c++,(e&255)<<24>>24)))}return c};
function Ir(){this.c=this.a=0}l(Ir,Bd);g=Ir.prototype;g.w=function(){return this.c-this.a};g.G=function(){return!1};g.F=function(a){Qi(a,this.w());return eh(this.b[this.a+a])};g.B=function(a){return ah(a)&&-1!=Zna(this.b,a.a,this.a,this.c)};g.indexOf=function(a){return ah(a)&&(a=Zna(this.b,a.a,this.a,this.c),0<=a)?a-this.a:-1};g.lastIndexOf=function(a){if(ah(a)){a:{a=a.a;for(var b=this.c-1;b>=this.a;b--)if(this.b[b]==a){a=b;break a}a=-1}if(0<=a)return a-this.a}return-1};
g.Nb=function(a,b){var c=this.w();mfa(a,b,c);a==b?b=kf():(c=new Ir,a=this.a+a,b=this.a+b,c.b=this.b,c.a=a,c.c=b,b=c);return b};g.J=function(a){if(q(a,this))return!0;if(a instanceof Ir){var b=this.w();if(a.w()!=b)return!1;for(var c=0;c<b;c++)if(this.b[this.a+c]!=a.b[a.a+c])return!1;return!0}return Bd.prototype.J.call(this,a)};g.P=function(){for(var a=1,b=this.a;b<this.c;b++)a=31*a+this.b[b];return a};
g.toString=function(){var a=Og(3*this.w());Pg(Pg(a,91),this.b[this.a]);for(var b=this.a+1;b<this.c;b++)Pg(y(a,", "),this.b[b]);return Pg(a,93).toString()};g.nb=function(a){kd(this,a)};g.W=function(){return nd(this)};g.ca=function(a){return ed(this,a)};g.T=function(){return fd(this)};g.Z=function(a){uc(this,a)};g.Ub=function(a,b){Qi(a,this.w());var c=this.b[this.a+a];xd(this.b,this.a+a,G(b).a);return eh(c)};g.Je=!0;g.ba=!0;function Zna(a,b,c,d){for(;c<d;c++)if(a[c]==b)return c;return-1}
function $na(a){for(var b=0,c=0;c<a.length;c++)b+=a[c].length;b=Ba([b],Ob,Pb,0);for(var d=c=0;d<a.length;d++){var e=a[d];Fi(e,0,b,c,e.length);c+=e.length}return b}var aoa;function boa(){boa=function(){};Yea();aoa=Xea}var coa,doa;function eoa(){eoa=function(){};coa=B("Sun Mon Tue Wed Thu Fri Sat".split(" "),D,z,1);doa=B("Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" "),D,z,1)}function Jr(){}l(Jr,n);function Kr(a){return 10>a?"0"+a:""+a}g=Jr.prototype;
g.J=function(a){return a instanceof Jr&&Lr(this).J(Lr(a))};function Lr(a){return gb(a.a.getTime())}g.P=function(){var a=Lr(this);return a.xor(Gaa(a,32)).a};g.toString=function(){var a=-this.a.getTimezoneOffset(),b=String(0<=a?"+":"")+(a/60|0);a=Kr(Math.abs(a)%60|0);return r((eoa(),coa)[this.a.getDay()])+" "+r(doa[this.a.getMonth()])+" "+r(Kr(this.a.getDate()))+" "+r(Kr(this.a.getHours()))+":"+r(Kr(this.a.getMinutes()))+":"+r(Kr(this.a.getSeconds()))+" GMT"+r(b)+r(a)+" "+this.a.getFullYear()};
g.R=function(a){return $aa(Lr(this),Lr(a))};g.ba=!0;function Mr(){}l(Mr,Ha);Mr.prototype.M=function(){return this.f};function foa(a){this.a=a}l(foa,n);function goa(a,b){if(!Array.isArray(a)||!Array.isArray(b))return!1;if(a===b)return!0;for(var c=hoa(a),d=hoa(b),e=c?a.length-1:a.length,f=d?b.length-1:b.length,h=0;h<e;h++)if(!ioa(a[h],h,b,d,f))return!1;if(c)for(a=a[a.length-1],c=Object.keys(a),e=0;e<c.length;e++)if(h=+c[e],!ioa(a[h],h,b,d,f))return!1;return!0}
function ioa(a,b,c,d,e){if(b<e){if(!joa(a,c[b]))return!1}else{if(!d)return joa(a,null);if(!joa(a,c[c.length-1][b]))return!1}return!0}function joa(a,b){return null==a&&null==b?!0:Array.isArray(a)?goa(a,b)?!0:!1:"object"==typeof a||"object"==typeof b||a!==b?!1:!0}function hoa(a){return 0==a.length?!1:(a=a[a.length-1])&&"object"===typeof a?!Array.isArray(a):!1}function Nr(a,b){a=a[b];return null!=a?a|0:0}function Wr(a,b){a=a[b];a=null!=a?String(a):"";return a}ca();da();
function koa(a){return a.length&&0<a.length&&(a=a[a.length-1])&&"object"===typeof a&&!Array.isArray(a)?!0:!1}function loa(a){for(var b in a){var c=a[+b];!Array.isArray(c)||"$jspb_cached_msg_"in c||(a[+b]=c.slice())}}function Xr(a,b,c){this.a=a;this.b=b;this.c=c;this.f=0}function moa(a,b,c){b=koa(a)?a.length-1:0<b?b:Number.MAX_VALUE;c&&!a[0]&&(a[0]=c);return new Xr(a,b,c?0:-1)}function noa(a,b){return b.$jspb_cached_msg_||(b.$jspb_cached_msg_=new a(b))}
function ooa(a,b){a=a.a.slice();loa(a);if(koa(a)){var c=Object.assign({},a.pop());loa(c);a.push(c)}return noa(b,a)}Xr.prototype.freeze=function(){};Xr.prototype.J=function(a){if(this===a)var b=!0;else b=this.a,a=a.a,b=goa(b,a)?goa(a,b):!1;return b};Xr.prototype.P=function(){0===this.f&&(this.f=wla(this.a,0));return this.f};function Yr(a,b){if(b<a.b)return a.a;(b=a.a[a.b])||(b=a.a[a.b]={});return b}function Zr(a,b,c){b=b<a.b?b+a.c:b;a=Yr(a,b);return c(a,b)}function $r(a,b,c){this.mc=moa(a,b,c)}
l($r,Ela);function poa(a){return ia(qoa,void 0,function(){return noa(a,[])},function(){return a[oaa]||(a[oaa]=++paa)})}$r.prototype.J=function(a){return this===a?!0:a instanceof this.constructor?this.mc.J(a.mc):!1};$r.prototype.P=function(){return this.mc.P()};$r.prototype.getExtension=function(a){return a.a()(this)};function as(a){this.message=ooa(a.mc,a.constructor);this.mc=this.message.mc}l(as,Fla);function roa(a){a=a.message;a=ooa(a.mc,a.constructor);a.mc.freeze();return a}
as.prototype.getExtension=function(a){return this.message.getExtension(a)};function soa(a,b,c){var d=a.mc;b=b<d.b?b+d.c:b;Yr(d,b)[b]=c|0;return a}function toa(a,b,c){var d=a.mc;b=b<d.b?b+d.c:b;Yr(d,b)[b]=String(c);return a}var qoa={};function uoa(a){this.mc=moa(a,-1,0)}l(uoa,$r);uoa.prototype.a=function(){return new voa(this)};function voa(a){as.call(this,a)}l(voa,as);function woa(){this.b=this.a=0}l(woa,n);function bs(a,b){var c=new woa;c.a=a;c.b=b;return c}
woa.prototype.toString=function(){return Pn(Pn(Sn(this),"line",this.a),"column",this.b).toString()};function xoa(){this.v=this.f=this.o=this.g=this.a=this.u=0}l(xoa,n);function yoa(a,b){b.G()?a.b.a.add(null):a.b.a.add(b);a.u++;a.a=0}function zoa(a,b){return Aoa(a.c)&&Boa(a.c)==b?(a.c.a++,!0):!1}function Coa(a){if(!Aoa(a.c))return!0;a=Boa(a.c);return 59==a||44==a}function cs(){this.a=0}l(cs,n);cs.prototype.c=function(){return-1};cs.prototype.g=function(){return-1};cs.prototype.f=function(){return-1};
cs.prototype.b=function(){return-1};function ds(){this.o=this.v=this.u=this.a=0}l(ds,cs);ds.prototype.c=function(){return this.u};ds.prototype.g=function(){return this.v};ds.prototype.f=function(){return this.o};ds.prototype.b=function(){return-1};function Doa(){ds.call(this);this.A=0}l(Doa,ds);Doa.prototype.b=function(){return this.A};function Eoa(){this.b=0}l(Eoa,n);function Foa(){var a=new Eoa;a.a=null;a.o=Of();return a}
function Goa(a,b){if(3!=b.b)throw es("Unknown version: "+b.b).s;var c=b.c;if(null!=c&&ue(c))throw es("File entry is empty").s;if(b.o)try{if(0<=b.a||null!=b.f||b.u||b.g)throw es("Invalid map format").s;for(var d=Hoa(),e=b.o.h();e.i();){var f=e.j(),h=f.c;q(f.f,(fs(),Ioa))&&(h=null);if(null==h)throw es("Unable to retrieve: "+r(f.c)).s;c=void 0;var k=d,m=h,p=k,t=f.b,v=f.a;E(0<=t);E(0<=v);p.a=bs(t,v);var C=Foa();p=C;var M=Joa(m);Goa(p,M);var I=new Koa;I.a=k;c=I;k=!1;for(var ya=p=m=null,Wa=null,Ta=C.a.w(),
Vb=0;Vb<Ta;Vb++){var cc=C.a.F(Vb);if(cc)for(var dc=cc.w(),rc=0;rc<dc;rc++){var Cb=cc.F(rc);k&&(Loa(c.a,m,p,ya,Wa,bs(Vb,Cb.a)),k=!1);-1!=Cb.c()&&(k=!0,m=C.c[Cb.c()],p=-1!=Cb.b()?C.f[Cb.b()]:null,ya=bs(Cb.g(),Cb.f()),Wa=bs(Vb,Cb.a))}}}var kc=Ng(),Id=b.c;Moa(Noa(d),new Ooa);e=b=0;for(var gf=d.u.h();gf.i();){var Tc=gf.j();Tc.c&&(Tc.f=b++,e=Math.max(e,Tc.b.a))}var id=e+d.g.a+1;te(kc,"{\n");gs(kc,"version",!0);te(kc,"3");if(null!=Id){var Hc=hs(Id);gs(kc,"file",!1);te(kc,Hc)}Id=""+id;gs(kc,"lineCount",!1);
te(kc,Id);if(null!=d.K&&!ue(d.K)){var yc=hs(d.K);gs(kc,"sourceRoot",!1);te(kc,yc)}gs(kc,"mappings",!1);var Mc=new Poa;Mc.f=d;Mc.c=-1;Mc.b=0;Mc.a=kc;Mc.g=id;Pg(Mc.a,34);Moa(Noa(Mc.f),Mc);Pg(Mc.a,59);Pg(Mc.a,34);gs(kc,"sources",!1);te(kc,"[");Qoa(kc,d.b);te(kc,"]");id=!1;var Wb=d.b.va(),Rc=Jd();Rc.na(Oca(Wb,""));for(var ld=d.A.X().h();ld.i();){var Jf=ld.j(),Sb=d.b.get(Jf.M());Sb&&Sb.Mb()<Wb&&(Rc.Ub(Sb.Mb(),Jf.N()),id=!0)}if(id){gs(kc,"sourcesContent",!1);te(kc,"[");for(ld=0;ld<Wb;ld++){0!=ld&&te(kc,
",");var zc=Rc.F(ld);te(kc,hs(zc||""))}te(kc,"]")}gs(kc,"names",!1);te(kc,"[");Qoa(kc,d.f);te(kc,"]");for(var fc=d.D.pa().h();fc.i();){var Kb=fc.j(),vc=d.D.get(Kb);Rc=void 0;z(vc)?Rc=hs(vc):Rc=Be(vc);Wb=kc;gs(Wb,Kb,!1);te(Wb,Rc)}te(kc,"\n}\n");var cd=Joa(kc.toString());Goa(a,cd)}catch(De){De=wa(De);if(Ga(De))throw es("IO exception: "+r(De)).s;throw De.s;}else{a.b=b.a;a.c=b.u;a.g=b.A;a.f=b.g;a.a=0<=a.b?Jd():x();a.o.Hd(b.v);d=new xoa;kc=b.f;d.b=a;d.u=0;d.a=0;d.g=0;d.o=0;d.f=0;d.v=0;a=new Roa;a.a=0;
a.b=kc;a.c=kc.length;d.c=a;a=Ba([5],w,Wc,0);for(kc=x();Aoa(d.c);)if(zoa(d,59))yoa(d,kc),kc.G()||(kc=x());else{for(vc=0;!Coa(d);){fc=vc;Kb=d.c;Wb=cd=0;do Rc=uh(Kb.b,Kb.a++),is(),zc=js[Rc],Rc=0!=(zc&32),zc&=31,cd+=zc<<Wb,Wb+=5;while(Rc);Kb=cd;cd=1==(Kb&1);Kb=Kb>>>1|0;a[fc]=cd?-Kb|-2147483648:Kb;vc++}a:switch(fc=d,Kb=a,vc){case 1:vc=new cs;vc.a=Kb[0]+fc.a;Kb=vc;fc.a=Kb.a;fc=Kb;break a;case 4:cd=vc=new ds;Wb=Kb[1]+fc.g;Rc=Kb[2]+fc.o;zc=Kb[3]+fc.f;cd.a=Kb[0]+fc.a;cd.u=Wb;cd.v=Rc;cd.o=zc;Kb=vc;fc.a=Kb.a;
fc.g=Kb.c();fc.o=Kb.g();fc.f=Kb.f();fc=Kb;break a;case 5:cd=vc=new Doa;Wb=Kb[4]+fc.v;Rc=cd;zc=Kb[1]+fc.g;ld=Kb[2]+fc.o;Jf=Kb[3]+fc.f;Rc.a=Kb[0]+fc.a;Rc.u=zc;Rc.v=ld;Rc.o=Jf;cd.A=Wb;Kb=vc;fc.a=Kb.a;fc.g=Kb.c();fc.o=Kb.g();fc.f=Kb.f();fc.v=Kb.b();fc=Kb;break a;default:throw es("Unexpected number of values for entry:"+vc).s;}Kb=d;vc=fc;cd=Kb.b.b;if(!(0>Kb.b.b||Kb.u<Kb.b.b))throw pb(Ki("line=%s, lineCount=%s",[Dc(Kb.u),Dc(cd)])).s;E(-1==vc.c()||vc.c()<Kb.b.c.length);E(-1==vc.b()||vc.b()<Kb.b.f.length);
kc.add(fc);zoa(d,44)}kc.G()||yoa(d,kc)}}function Soa(a,b,c){b--;c--;if(0>b||b>=a.a.w())return null;E(0<=b);E(0<=c);if(!a.a.F(b))return Toa(a,b);var d=a.a.F(b);E(!d.G());if(d.F(0).a>c)return Toa(a,b);a:{b=c;c=d.w()-1;for(var e=0;;){var f=((c-e)/2|0)+e;var h=b;h=d.F(f).a-h;if(0==h){b=f;break a}if(0>h){if(e=f+1,e>c){b=c;break a}}else if(c=f-1,c<e){b=c;break a}}}if(!(0<=b))throw pb(Ki("unexpected:%s",[Dc(b)])).s;return Uoa(a,d.F(b))}
function Toa(a,b){do{if(0==b)return null;b--}while(!a.a.F(b));b=a.a.F(b);return Uoa(a,wp(b))}function Uoa(a,b){if(-1==b.c())return null;var c=void 0===c?poa(uoa):c;c=new voa(c);c=toa(c,1,a.c[b.c()]);c=soa(c,2,b.g()+1);c=soa(c,3,b.f()+1);-1!=b.b()&&toa(c,4,a.f[b.b()]);return roa(c)}function Voa(){this.a=0}var Ioa,Woa;l(Voa,A);function Xoa(a,b){var c=new Voa;c.b=a;c.a=b;return c}Voa.prototype.R=function(a){return A.prototype.c.call(this,a)};
function fs(){fs=function(){};Ioa=Xoa("URL",0);Woa=Xoa("MAP",1)}function Yoa(){this.a=this.b=0}l(Yoa,n);function Koa(){}l(Koa,n);var js;function Zoa(a){is();return"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charCodeAt(a)}function is(){is=function(){};js=Ba([256],w,Wc,0);Nda(js,0,js.length,-1);for(var a=0;64>a;a++)js["ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charCodeAt(a)]=a}
function ks(a,b){b=0>b?(-b<<1)+1:b<<1;do{var c=b&31;b=b>>>5|0;0<b&&(c|=32);Pg(a,Zoa(c))}while(0<b)}function Roa(){this.a=this.c=0}l(Roa,n);function Boa(a){return a.b.charCodeAt(a.a)}function Aoa(a){return a.a<a.c}function $oa(){}l($oa,Ea);function es(a){var b=new $oa;sa(b,a);b.a(Error(b));return b}function apa(){this.a=this.c=0}l(apa,n);function bpa(a,b){a.b=b}function cpa(a,b){a.f=b}function dpa(){this.a=this.b=0}l(dpa,n);
function epa(a,b,c,d,e,f,h,k,m){var p=new dpa;p.b=a;p.a=b;p.c=c;p.f=d;p.u=e;p.A=f;p.g=h;p.o=k;p.v=m;return p}function Joa(a){var b=JSON.parse(a);a=new apa;a.c=b.version;a.g=b.file;a.a=-1;a.o=b.mappings;a.A=b.sourceRoot;if(b.sections){for(var c=Kj(),d=b.sections,e=0;e<d.length;e++)c.Y(fpa(d[e]));bpa(a,c.ga())}else a.b=null;a.v=b.sources;a.u=b.names;var f=Of();Gla(b,function(h){si(h,"x_")&&f.C(h,b[h])});cpa(a,uf(f));return epa(a.c,a.a,a.g,a.o,a.v,a.D,a.u,a.b,a.f)}
function fpa(a){var b=a.offset.line,c=a.offset.column;if(null!=a.map&&null!=a.url)throw es("Invalid map format: section may not have both 'map' and 'url'").s;if(null!=a.url){a=a.url;var d=(fs(),Ioa),e=new Yoa;e.f=d;e.c=a;e.b=b;e.a=c;return e}if(null!=a.map)return a=r(a.map),d=(fs(),Woa),e=new Yoa,e.f=d,e.c=a,e.b=b,e.a=c,e;throw es("Invalid map format: section must have either 'map' or 'url'").s;}function gpa(){this.f=0;this.c=!1}l(gpa,n);function hpa(){this.b=this.a=0}l(hpa,n);
function Noa(a){var b=new hpa;b.c=a;return b}function Moa(a,b){for(var c=Wk(),d=a.c.u.h();d.i();){for(var e=d.j();!c.G()&&!ipa(c.Pa(),e);){var f=c.Ta();jpa(a,b,f)}var h=c.Pa();f=a;var k=b,m=e.a.a+f.c.g.a,p=kpa(f,e.a);E(f.a<m||f.b<=p);(f.a<m||f.a==m&&f.b<p)&&lpa(f,k,h,m,p);c.Fa(e)}for(;!c.G();)d=c.Ta(),jpa(a,b,d)}function kpa(a,b){var c=b.b;return 0!=b.a?c:c+a.c.g.b}function ipa(a,b){var c=a.b.a,d=b.a.a;a=a.b.b;b=b.a.b;return c==d&&a>=b||c>d}
function jpa(a,b,c){var d=c.b.a+a.c.g.a,e=kpa(a,c.b);(a.a<d||a.a==d&&a.b<e)&&lpa(a,b,c,d,e)}function lpa(a,b,c,d,e){E(a.a<=d);E(a.a<d||a.b<e);if(a.a==d&&a.b==e)throw ob().s;b.D(c,a.a,a.b,d,e);a.a=d;a.b=e}function Poa(){this.o=this.u=this.A=this.v=this.b=this.c=this.g=0}l(Poa,n);
Poa.prototype.D=function(a,b,c,d,e){this.c!=b&&(this.b=0);if(b!=d||c!=e)if(b<this.g){this.c==b&&Pg(this.a,44);ks(this.a,c-this.b);this.b=c;if(a){e=this.f;var f=a.u;if(!q(f,e.v)){e.v=f;var h=e.b.get(f);h?e.c=h.Mb():(e.c=e.b.va(),e.b.C(f,Dc(e.c)))}e=e.c;ks(this.a,e-this.v);this.v=e;e=a.o.a;f=a.o.b;ks(this.a,e-this.A);this.A=e;ks(this.a,f-this.u);this.u=f;null!=a.g&&(e=this.f,a=a.g,(f=e.f.get(a))?f=f.Mb():(f=e.f.va(),e.f.C(a,Dc(f))),a=f,ks(this.a,a-this.o),this.o=a)}this.c=b;this.b=c}else E(!a);for(;b<=
d&&b<this.g&&b!=d;b++)Pg(this.a,59)};function Ooa(){}l(Ooa,n);Ooa.prototype.D=function(a){a&&(a.c=!0)};var ls;
function hs(a){mpa();var b=Og();Pg(b,34);for(var c=0;c<a.length;c++){var d=a.charCodeAt(c);switch(d){case 10:y(b,"\\n");break;case 13:y(b,"\\r");break;case 9:y(b,"\\t");break;case 92:y(b,"\\\\");break;case 34:y(b,'\\"');break;case 39:y(b,"'");break;case 62:2<=c&&(45==a.charCodeAt(c-1)&&45==a.charCodeAt(c-2)||93==a.charCodeAt(c-1)&&93==a.charCodeAt(c-2))?y(b,"\\u003e"):Pg(b,d);break;case 60:ni(a,!0,c+1,"/script",0,7)?y(b,"\\u003c"):ni(a,!1,c+1,"!--",0,3)?y(b,"\\u003c"):Pg(b,d);break;default:31<d&&
127>=d?Pg(b,d):ms(b,d)}}Pg(b,34);return b.toString()}function ms(a,b){mpa();try{npa(b,a)}catch(c){c=wa(c);if(Ga(c))throw waa(c).s;throw c.s;}}function npa(a,b){65536<=a&&1114111>=a?(a=hea(a),npa(a[0],b),npa(a[1],b)):Pg(Pg(Pg(Pg(te(b,"\\u"),ls[(a>>>12|0)&15]),ls[(a>>>8|0)&15]),ls[(a>>>4|0)&15]),ls[a&15])}function mpa(){mpa=function(){};ls=B([48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102],Ob,Pb,1)}function opa(){this.c=0}l(opa,n);
function Hoa(){var a=new opa;a.u=x();a.b=Of();a.A=Of();a.f=Of();a.v=null;a.c=-1;a.a=bs(0,0);a.g=bs(0,0);a.D=Of();return a}
function Loa(a,b,c,d,e,f){if(!(null==b||0>d.a)){var h=e,k=f;if(0!=a.a.a||0!=a.a.b){k=a.a.a;var m=h=a.a.b;0<e.a&&(h=0);0<f.a&&(m=0);h=bs(e.a+k,e.b+h);k=bs(f.a+k,f.b+m)}e=new gpa;e.f=-1;e.c=!1;e.u=b;e.o=d;e.g=c;e.a=h;e.b=k;if(a.o){b=a.o.a.a;c=a.o.a.b;d=e.a.a;f=e.a.b;h=Dc(b);k=Dc(c);m=Dc(d);var p=Dc(f);if(!(d>b||d==b&&f>=c))throw pb(Ki("Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)",[h,k,m,p])).s;}a.o=e;a.u.add(e)}}
function Qoa(a,b){var c=0;for(b=b.X().h();b.i();){var d=b.j().M();0!=c&&te(a,",");te(a,hs(d));c++}}function gs(a,b,c){c||te(a,",\n");te(a,'"');te(a,b);te(a,'"');te(a,":")}function ppa(){this.a=0}var qpa;l(ppa,A);function rpa(){var a=new ppa;a.b="DEFAULT";a.a=0;return a}ppa.prototype.R=function(a){return A.prototype.c.call(this,a)};function spa(){spa=function(){};qpa=rpa()}function ns(){this.U=this.sa=this.f=!1;this.v=this.u=0}l(ns,n);g=ns.prototype;g.gn=function(){};g.Fm=function(){};g.Dm=function(){return!0};
function os(a,b){ps(a);if(!ue(b)){var c=b.charCodeAt(0);(qs(c)||92==c)&&qs(a.We())?a.vc(" "):47==c&&47==a.We()?a.vc(" "):34!=c&&39!=c||!qs(a.We())||a.Lb();c=0;for(var d=ki(b,10);0<=d;)d>c&&a.vc(ne(b,c,d)),a.zf(),c=d+1,d=li(b,10,c);b.length>c&&a.vc(b.substr(c))}}g.xm=function(a){os(this,a)};g.zm=function(){this.vc("{")};g.ym=function(){this.vc("}")};g.zf=function(){};g.yf=function(){this.th()};g.th=function(){};g.Td=function(){};g.Zm=function(){};
function rs(a){a.f&&(a.vc(";"),a.yf());a.zm();a.Td();a.f=!1}function ss(a,b){a.ym();b&&a.Td();a.f=!1}g.Kg=function(){os(this,",");this.yf()};g.sc=function(a){a?(this.vc(";"),this.yf(),this.f=!1):this.sa&&(this.f=!0)};function ps(a){a.f&&(a.vc(";"),a.yf(),a.Td(),a.f=!1);a.sa=!0}g.Zi=function(a){this.U=!0;a&&this.Td()};g.tl=function(){this.vc(":")};g.Bl=function(){};function ts(a){return a.u==a.v+1}g.Am=function(a){this.vc(a)};
function us(a,b,c){ps(a);var d=b.charCodeAt(0),e=a.We();43!=d&&45!=d||e!=d?ch(d)&&qs(e)?a.vc(" "):(45==e&&62==d||60==e&&33==d)&&a.vc(" "):a.vc(" ");a.Am(b,c);c&&a.th()}
g.qf=function(a){var b=this.We(),c=0==a&&0>1/a;(0>a||c)&&45==b&&os(this," ");if(c)this.Oe("-0");else if(Ua(gb(a))==a){c=b=gb(a);var d=0;if(100<=Math.abs(a))for(;Qaa(Raa(Xa(c,hb(10)),gb(Math.pow(10,d+1))),b);)c=Xa(c,hb(10)),d++;2<d?this.Oe(c+"E"+d):(a=0>ab(b,hb(0))?bb(b):b,0<ab(a,Va(-727379968,232))&&Rb(a,4).length+2<(""+a).length?this.Oe(String(0>ab(b,hb(0))?"-":"")+"0x"+r(Rb(a,4))):this.Oe(""+b))}else this.Oe(jfa(pi(""+a,".0E","E"),"^(-?)0\\.","$1."))};g.Oe=function(a){os(this,a)};
function qs(a){return 95==a||36==a||gea(a)}g.Yl=function(){return!1};g.Lb=function(){};g.gk=function(a,b){return b};g.mk=function(){};function tpa(a){a.f=!1;a.sa=!1;a.U=!1;a.u=0;a.v=0}function vs(){}l(vs,n);function ws(a){var b=new vs;b.a=a;return b}vs.prototype.P=function(){return Yg(this.a)};vs.prototype.J=function(a){return q(this,a)?!0:null!=a&&q(la(ma(this)),Jg(a))?q(this.a,a.a):!1};vs.prototype.toString=function(){return"InputId: "+r(this.a)};vs.prototype.ba=!0;function xs(){}l(xs,n);
xs.prototype.toString=function(){return Ln(Mn(Mn(Mn(Mn(Mn(Mn(Mn(Mn(Mn(Mn(Sn(this),"sourceComment",this.u),"markers",this.f),"parameters",this.a),"throwsDescriptions",this.b),"blockDescription",this.D),"fileOverview",this.v),"returnDescription",this.g),"version",this.A),"authors",this.c),"sees",this.o)).toString()};xs.prototype.ba=!0;function upa(){}l(upa,n);function ys(){this.b=this.c=this.f=this.g=0}l(ys,n);ys.prototype.o=function(a){this.a=a};
function zs(a,b,c,d,e){if(b>d)throw pb("Recorded bad position information\nstart-line: "+b+"\nend-line: "+d).s;if(b==d&&c>=e)throw pb("Recorded bad position information\nline: "+b+"\nstart-char: "+c+"\nend-char: "+e).s;a.g=b;a.f=c;a.c=d;a.b=e}function As(a){a.a=null;a.g=0;a.f=0;a.c=0;a.b=0}function vpa(){ys.call(this)}l(vpa,ys);function Bs(){ys.call(this)}l(Bs,ys);function wpa(){var a=new Bs;As(a);return a}
function xpa(a,b){return a||b?!a&&b||a&&!b?!1:q(a.a,b.a)&&a.g==b.g&&a.f==b.f&&a.c==b.c&&a.b==b.b:!0}function ypa(){ys.call(this)}l(ypa,Bs);function zpa(){var a=new ypa;As(a);return a}function Apa(a,b){Ii(32!=b.charCodeAt(0)&&32!=b.charCodeAt(b.length-1),"String has leading or trailing whitespace");Bs.prototype.o.call(a,b)}ypa.prototype.o=function(a){Apa(this,a)};function Bpa(){ys.call(this);this.u=!1}l(Bpa,ys);function Cpa(){this.a=0}var Cs,Ds,Es;l(Cpa,A);
function Dpa(a,b){var c=new Cpa;c.b=a;c.a=b;return c}Cpa.prototype.R=function(a){return A.prototype.c.call(this,a)};function Fs(){Fs=function(){};Cs=Dpa("STRONG",0);Ds=Dpa("WEAK",1);Es=Dpa("EXTERN",2)}function Epa(){}l(Epa,n);function Fpa(a,b){var c=new Epa;c.a=a;c.b=b;return c}g=Epa.prototype;g.xb=function(){return this.a};g.Dg=function(){return this.b};g.rn=function(a){if(1>a)throw pb("Should not call getLineOffset with line number "+a).s;return-2147483648};g.toString=function(){return this.a};
g.Vg=function(){return q(this.Dg(),(Fs(),Es))};g.Xe=function(){return q(this.Dg(),(Fs(),Ds))};g.ba=!0;function Gs(){this.a=0}
var Hs,Gpa,Hpa,Ipa,Is,Js,Ks,Jpa,Kpa,Lpa,Mpa,Npa,Opa,Ls,Ms,Ppa,Ns,Qpa,Os,Ps,Rpa,Spa,Qs,Rs,Ss,Ts,Us,Vs,Ws,Xs,Ys,Zs,$s,at,bt,ct,kt,lt,mt,nt,ot,pt,qt,rt,st,tt,ut,vt,wt,xt,yt,zt,At,Bt,Ct,Dt,Et,Ft,Gt,Ht,It,Jt,Kt,Lt,Mt,Nt,Ot,Pt,Qt,Rt,St,Tt,Ut,Vt,Wt,Xt,Yt,Zt,$t,au,bu,cu,du,eu,fu,gu,hu,iu,ju,Tpa,ku,lu,mu,nu,ou,pu,qu,ru,su,wu,xu,yu,zu,Au,Bu,Cu,Du,Eu,Upa,Fu,Gu,Hu,Iu,Vpa,Ju,Wpa,Ku,Xpa,Lu,Mu,Nu,Ou,Pu,Ypa,Zpa,$pa,aqa,bqa,cqa,dqa,eqa,fqa,gqa,hqa,iqa,jqa,kqa,Qu,lqa,mqa,Ru,nqa,Su,Tu,Uu,Vu,Wu,Xu,oqa,pqa,Yu,qqa,rqa,
sqa,tqa,Zu,$u,av,bv,cv,dv;l(Gs,A);function ev(a,b){var c=new Gs;c.b=a;c.a=b;return c}
function uqa(a){H();switch(a.a){case 143:case 42:case 148:case 82:case 81:case 74:case 28:case 152:case 88:case 75:case 89:case 146:case 149:case 72:case 66:case 150:case 151:case 23:case 43:case 45:case 144:case 147:case 38:case 0:case 85:case 145:case 91:case 67:case 120:case 44:case 76:case 103:return-1;case 80:case 34:case 108:case 90:case 161:case 29:case 32:case 30:case 31:case 122:case 33:case 35:return 0;case 104:case 20:case 163:case 92:case 64:case 69:case 24:case 84:case 86:case 63:case 162:case 114:case 116:case 98:case 136:case 22:case 19:case 115:case 117:case 21:case 87:case 121:case 39:case 25:case 159:case 79:return 1;
case 13:case 62:case 47:case 54:case 50:case 48:case 49:case 57:case 51:case 58:case 56:case 59:case 52:case 55:case 53:case 3:case 1:case 2:case 68:case 78:case 46:case 118:case 123:case 16:case 71:case 156:case 4:case 18:case 9:case 27:case 26:case 8:case 40:case 41:case 83:case 7:case 10:case 6:case 17:case 15:case 164:case 5:case 61:case 11:case 36:case 37:case 14:case 119:case 12:case 70:case 77:return 2;case 96:case 73:case 101:case 102:case 65:case 60:case 105:case 153:return 3;default:throw pb("No arity defined for "+
r(a)).s;}}Gs.prototype.R=function(a){return A.prototype.c.call(this,a)};
function H(){H=function(){};Hs=ev("RETURN",0);Gpa=ev("BITOR",1);Hpa=ev("BITXOR",2);Ipa=ev("BITAND",3);Is=ev("EQ",4);Js=ev("NE",5);Ks=ev("LT",6);Jpa=ev("LE",7);Kpa=ev("GT",8);Lpa=ev("GE",9);Mpa=ev("LSH",10);Npa=ev("RSH",11);Opa=ev("URSH",12);Ls=ev("ADD",13);Ms=ev("SUB",14);Ppa=ev("MUL",15);Ns=ev("DIV",16);Qpa=ev("MOD",17);Os=ev("EXPONENT",18);Ps=ev("NOT",19);Rpa=ev("BITNOT",20);Spa=ev("POS",21);Qs=ev("NEG",22);Rs=ev("NEW",23);Ss=ev("DELPROP",24);Ts=ev("TYPEOF",25);Us=ev("GETPROP",26);Vs=ev("GETELEM",
27);Ws=ev("CALL",28);Xs=ev("NAME",29);Ys=ev("NUMBER",30);Zs=ev("STRING",31);$s=ev("NULL",32);at=ev("THIS",33);bt=ev("FALSE",34);ct=ev("TRUE",35);kt=ev("SHEQ",36);lt=ev("SHNE",37);mt=ev("REGEXP",38);nt=ev("THROW",39);ot=ev("IN",40);pt=ev("INSTANCEOF",41);qt=ev("ARRAYLIT",42);rt=ev("OBJECTLIT",43);st=ev("TRY",44);tt=ev("PARAM_LIST",45);ut=ev("COMMA",46);vt=ev("ASSIGN",47);wt=ev("ASSIGN_BITOR",48);xt=ev("ASSIGN_BITXOR",49);yt=ev("ASSIGN_BITAND",50);zt=ev("ASSIGN_LSH",51);At=ev("ASSIGN_RSH",52);Bt=ev("ASSIGN_URSH",
53);Ct=ev("ASSIGN_ADD",54);Dt=ev("ASSIGN_SUB",55);Et=ev("ASSIGN_MUL",56);Ft=ev("ASSIGN_DIV",57);Gt=ev("ASSIGN_MOD",58);Ht=ev("ASSIGN_EXPONENT",59);It=ev("HOOK",60);Jt=ev("OR",61);Kt=ev("AND",62);Lt=ev("INC",63);Mt=ev("DEC",64);Nt=ev("FUNCTION",65);Ot=ev("IF",66);Pt=ev("SWITCH",67);Qt=ev("CASE",68);Rt=ev("DEFAULT_CASE",69);St=ev("WHILE",70);Tt=ev("DO",71);Ut=ev("FOR",72);Vt=ev("FOR_IN",73);Wt=ev("BREAK",74);Xt=ev("CONTINUE",75);Yt=ev("VAR",76);Zt=ev("WITH",77);$t=ev("CATCH",78);au=ev("VOID",79);bu=
ev("EMPTY",80);cu=ev("ROOT",81);du=ev("BLOCK",82);eu=ev("LABEL",83);fu=ev("EXPR_RESULT",84);gu=ev("SCRIPT",85);hu=ev("GETTER_DEF",86);iu=ev("SETTER_DEF",87);ju=ev("CONST",88);Tpa=ev("DEBUGGER",89);ku=ev("LABEL_NAME",90);lu=ev("STRING_KEY",91);mu=ev("CAST",92);nu=ev("ARRAY_PATTERN",93);ou=ev("OBJECT_PATTERN",94);pu=ev("DESTRUCTURING_LHS",95);qu=ev("CLASS",96);ru=ev("CLASS_MEMBERS",97);su=ev("MEMBER_FUNCTION_DEF",98);wu=ev("SUPER",99);xu=ev("LET",100);yu=ev("FOR_OF",101);zu=ev("FOR_AWAIT_OF",102);Au=
ev("YIELD",103);Bu=ev("AWAIT",104);Cu=ev("IMPORT",105);Du=ev("IMPORT_SPECS",106);Eu=ev("IMPORT_SPEC",107);Upa=ev("IMPORT_STAR",108);Fu=ev("EXPORT",109);Gu=ev("EXPORT_SPECS",110);Hu=ev("EXPORT_SPEC",111);Iu=ev("MODULE_BODY",112);Vpa=ev("DYNAMIC_IMPORT",113);Ju=ev("ITER_REST",114);Wpa=ev("OBJECT_REST",115);Ku=ev("ITER_SPREAD",116);Xpa=ev("OBJECT_SPREAD",117);Lu=ev("COMPUTED_PROP",118);Mu=ev("TAGGED_TEMPLATELIT",119);Nu=ev("TEMPLATELIT",120);Ou=ev("TEMPLATELIT_SUB",121);Pu=ev("TEMPLATELIT_STRING",122);
Ypa=ev("DEFAULT_VALUE",123);Zpa=ev("NEW_TARGET",124);$pa=ev("IMPORT_META",125);aqa=ev("STRING_TYPE",126);bqa=ev("BOOLEAN_TYPE",127);cqa=ev("NUMBER_TYPE",128);dqa=ev("FUNCTION_TYPE",129);eqa=ev("PARAMETERIZED_TYPE",130);fqa=ev("UNION_TYPE",131);gqa=ev("ANY_TYPE",132);hqa=ev("VOID_TYPE",134);iqa=ev("NAMED_TYPE",136);jqa=ev("RECORD_TYPE",138);kqa=ev("UNDEFINED_TYPE",139);Qu=ev("ARRAY_TYPE",140);lqa=ev("GENERIC_TYPE",141);mqa=ev("GENERIC_TYPE_LIST",142);Ru=ev("PIPE",144);nqa=ev("STAR",145);Su=ev("QMARK",
147);Tu=ev("BANG",148);Uu=ev("EQUALS",149);Vu=ev("LB",150);Wu=ev("LC",151);Xu=ev("COLON",152);oqa=ev("INTERFACE",153);pqa=ev("INTERFACE_EXTENDS",154);Yu=ev("INTERFACE_MEMBERS",155);qqa=ev("ENUM",156);rqa=ev("ENUM_MEMBERS",157);sqa=ev("IMPLEMENTS",158);tqa=ev("TYPE_ALIAS",159);Zu=ev("DECLARE",160);$u=ev("MEMBER_VARIABLE_DEF",161);av=ev("INDEX_SIGNATURE",162);bv=ev("CALL_SIGNATURE",163);cv=ev("NAMESPACE",164);dv=ev("NAMESPACE_ELEMENTS",165)}function fv(a){return a instanceof Gs}var vqa;
function wqa(){wqa=function(){};vqa=new gv}function gv(){}l(gv,n);gv.prototype.b=function(){};gv.prototype.a=function(){};function hv(){this.a=0}var iv,jv,kv;l(hv,A);function lv(a){mv();return a?iv:jv}function mv(){mv=function(){};jv=xqa();iv=yqa();kv=zqa()}function Aqa(){this.a=0}l(Aqa,hv);function xqa(){mv();var a=new Aqa;a.b="FALSE";a.a=0;return a}g=Aqa.prototype;g.Re=function(){return mv(),jv};g.Be=function(){return mv(),iv};g.wj=function(a){return a};g.rd=function(){return!1};g.toString=function(){return"false"};
g.R=function(a){return hv.prototype.c.call(this,a)};function Bqa(){this.a=0}l(Bqa,hv);function yqa(){mv();var a=new Bqa;a.b="TRUE";a.a=1;return a}g=Bqa.prototype;g.Re=function(a){return a};g.Be=function(){return mv(),jv};g.wj=function(){return mv(),iv};g.rd=function(){return!0};g.toString=function(){return"true"};g.R=function(a){return hv.prototype.c.call(this,a)};function Cqa(){this.a=0}l(Cqa,hv);function zqa(){mv();var a=new Cqa;a.b="UNKNOWN";a.a=2;return a}g=Cqa.prototype;
g.Re=function(a){return Yc((mv(),jv),a)?(mv(),jv):(mv(),kv)};g.Be=function(){return mv(),kv};g.wj=function(a){return Yc((mv(),iv),a)?(mv(),iv):(mv(),kv)};g.rd=function(a){return a};g.toString=function(){return"unknown"};g.R=function(a){return hv.prototype.c.call(this,a)};function Dqa(){this.a=0}var nv,ov,pv,qv;l(Dqa,A);function rv(a,b){var c=new Dqa;c.b=a;c.a=b;return c}
function sv(a){switch(a){case 0:return nv;case 1:return ov;case 2:return pv;case 3:return qv;default:throw va("Ordinal: "+a).s;}}function Eqa(a,b){switch(a.a){case 0:return!1;case 1:return b;case 2:return!b;case 3:return!0;default:throw La("Ordinal: "+a.a).s;}}function Fqa(a){tv();return a?ov:pv}function Gqa(a){return q(a,ov)?(mv(),iv):q(a,pv)?(mv(),jv):(mv(),kv)}Dqa.prototype.R=function(a){return A.prototype.c.call(this,a)};
function tv(){tv=function(){};nv=rv("EMPTY",0);ov=rv("TRUE",1);pv=rv("FALSE",2);qv=rv("BOTH",3)}function Hqa(){this.a=0}var uv,vv,wv;l(Hqa,A);function Iqa(a,b){var c=new Hqa;c.b=a;c.a=b;return c}Hqa.prototype.R=function(a){return A.prototype.c.call(this,a)};function xv(){xv=function(){};uv=Iqa("IDENTITY",0);vv=Iqa("DATA_FLOW",1);wv=Iqa("INVARIANT",2)}function yv(){this.a=0}
var zv,Av,Jqa,Bv,Kqa,Cv,Lqa,Dv,Ev,Fv,Gv,Hv,Iv,Jv,Kv,Lv,Mv,Nv,Mqa,Ov,Pv,Qv,Rv,Sv,Nqa,Tv,Uv,Oqa,Vv,Pqa,Wv,Xv,Yv,Zv,$v,aw,Qqa,bw,cw,dw,ew,fw,gw,hw,iw,jw,kw,lw,sw,tw,uw,vw,ww,xw,yw,zw,Aw,Bw,Cw,Rqa,Dw,Ew,Sqa,Fw,Gw,Hw,Iw;l(yv,A);function Jw(a,b){var c=new yv;c.b=a;c.a=b;return c}yv.prototype.R=function(a){return A.prototype.c.call(this,a)};
function J(){J=function(){};zv=Jw("ARRAY_TYPE",0);Av=Jw("ARRAY_FUNCTION_TYPE",1);Jqa=Jw("ASYNC_ITERABLE_FUNCTION_TYPE",2);Bv=Jw("ASYNC_ITERABLE_TYPE",3);Kqa=Jw("ASYNC_ITERATOR_FUNCTION_TYPE",4);Cv=Jw("ASYNC_ITERATOR_TYPE",5);Lqa=Jw("ASYNC_GENERATOR_FUNCTION_TYPE",6);Dv=Jw("ASYNC_GENERATOR_TYPE",7);Ev=Jw("BOOLEAN_TYPE",8);Fv=Jw("BOOLEAN_OBJECT_TYPE",9);Gv=Jw("BOOLEAN_OBJECT_FUNCTION_TYPE",10);Hv=Jw("CHECKED_UNKNOWN_TYPE",11);Iv=Jw("DATE_TYPE",12);Jv=Jw("DATE_FUNCTION_TYPE",13);Kv=Jw("FUNCTION_FUNCTION_TYPE",
14);Lv=Jw("FUNCTION_PROTOTYPE",15);Mv=Jw("GENERATOR_FUNCTION_TYPE",16);Nv=Jw("GENERATOR_TYPE",17);Mqa=Jw("I_ITERABLE_RESULT_FUNCTION_TYPE",18);Ov=Jw("I_ITERABLE_RESULT_TYPE",19);Pv=Jw("ITERABLE_FUNCTION_TYPE",20);Qv=Jw("ITERABLE_TYPE",21);Rv=Jw("ITERATOR_FUNCTION_TYPE",22);Sv=Jw("ITERATOR_TYPE",23);Nqa=Jw("I_ARRAY_LIKE_FUNCTION_TYPE",24);Tv=Jw("I_ARRAY_LIKE_TYPE",25);Uv=Jw("I_TEMPLATE_ARRAY_TYPE",26);Oqa=Jw("I_OBJECT_FUNCTION_TYPE",27);Vv=Jw("I_OBJECT_TYPE",28);Pqa=Jw("I_THENABLE_FUNCTION_TYPE",29);
Wv=Jw("I_THENABLE_TYPE",30);Xv=Jw("NULL_TYPE",31);Yv=Jw("NUMBER_TYPE",32);Zv=Jw("NUMBER_OBJECT_TYPE",33);$v=Jw("NUMBER_OBJECT_FUNCTION_TYPE",34);aw=Jw("PROMISE_TYPE",35);Qqa=Jw("PROMISE_FUNCTION_TYPE",36);bw=Jw("OBJECT_TYPE",37);cw=Jw("OBJECT_FUNCTION_TYPE",38);dw=Jw("OBJECT_PROTOTYPE",39);ew=Jw("REGEXP_TYPE",40);fw=Jw("REGEXP_FUNCTION_TYPE",41);gw=Jw("STRING_OBJECT_TYPE",42);hw=Jw("STRING_OBJECT_FUNCTION_TYPE",43);iw=Jw("STRING_TYPE",44);jw=Jw("SYMBOL_OBJECT_TYPE",45);kw=Jw("SYMBOL_OBJECT_FUNCTION_TYPE",
46);lw=Jw("SYMBOL_TYPE",47);sw=Jw("THENABLE_TYPE",48);tw=Jw("UNKNOWN_TYPE",49);uw=Jw("VOID_TYPE",50);vw=Jw("ALL_TYPE",51);ww=Jw("NO_TYPE",52);xw=Jw("NO_OBJECT_TYPE",53);yw=Jw("NO_RESOLVED_TYPE",54);zw=Jw("GLOBAL_THIS",55);Aw=Jw("U2U_CONSTRUCTOR_TYPE",56);Bw=Jw("U2U_FUNCTION_TYPE",57);Cw=Jw("LEAST_FUNCTION_TYPE",58);Rqa=Jw("GREATEST_FUNCTION_TYPE",59);Dw=Jw("NULL_VOID",60);Ew=Jw("NUMBER_STRING_BOOLEAN",61);Sqa=Jw("VALUE_TYPES",62);Fw=Jw("NUMBER_SYMBOL",63);Gw=Jw("STRING_SYMBOL",64);Hw=Jw("NUMBER_STRING",
65);Iw=Jw("NUMBER_STRING_SYMBOL",66)}function Kw(a){return a instanceof yv}function Lw(){return Mw((H(),bu))}function Tqa(a){return Nw((H(),Fu),a)}function Uqa(a,b,c){F(K(a)||Ow(a),a);F(Pw(b)||Qw(b)||Ow(b),b);F(Rw(c),c);return Sw((H(),Cu),a,b,c)}function Tw(a,b,c){E(K(a));E(Uw(b));E(Vw(c));return Sw((H(),Nt),a,b,c)}function Ww(a){for(var b=Mw((H(),tt)),c=0;c<a.length;c++){var d=a[c];E(K(d)||Xw(d));L(b,d)}return b}
function Yw(a){for(var b=Mw((H(),cu)),c=0;c<a.length;c++){var d=a[c];E(q(d.c,cu)||q(d.c,gu));L(b,d)}return b}function Zw(){return Mw((H(),du))}function $w(a){Mi(ax(a),"Block node cannot contain %s",a.c);return Nw((H(),du),a)}function bx(a){for(var b=Zw(),c=0;c<a.length;c++){var d=a[c];E(ax(d));L(b,d)}return b}function cx(){return Mw((H(),gu))}function dx(a,b){return ex(a,b,(H(),Yt))}function fx(a){return gx(a,(H(),Yt))}function hx(a,b){return ex(a,b,(H(),xu))}
function ix(a,b){return ex(a,b,(H(),ju))}function gx(a,b){F(K(a)||jx(a)||kx(a),a);jx(a)&&(a=Nw((H(),pu),a));return Nw(b,a)}function ex(a,b,c){K(a)?E(!a.a):(E(lx(a)||mx(a)),a=Nw((H(),pu),a));Mi(nx(b),"%s can't be an expression",b);L(a,b);return Nw(c,a)}function ox(a){E(nx(a));return Nw((H(),Hs),a)}function px(a){F(nx(a),a);return Nw((H(),fu),a)}function qx(a,b){E(nx(a));E(Vw(b));return rx((H(),Ot),a,b)}
function sx(a,b,c,d){E(tx(a)||ux(a)||vx(a)||wx(a));E(wx(b));E(wx(c));E(Vw(d));var e=(H(),Ut);N();var f=new xx;Hi(!a.o);Hi(!a.b);Hi(!a.g);Hi(!b.o);Hi(!b.b);Hi(!b.g);Hi(!c.o);Hi(!c.b);Hi(!c.g);Hi(!d.o);Hi(!d.b);Hi(!d.g);f.c=e;f.o=null;f.a=a;a.b=b;a.g=d;a.o=f;b.b=c;b.g=a;b.o=f;c.b=d;c.g=b;c.o=f;d.b=null;d.g=c;d.o=f;f.v=-1;return f}function Vqa(a,b){E(yx(a));E(ax(b));return rx((H(),eu),a,b)}function zx(a){E(!ue(a));return Ax((H(),ku),a)}function Wqa(a){E(yx(a));return Nw((H(),Wt),a)}
function Bx(a,b){a=Nw((H(),Ws),a);for(var c=0;c<b.length;c++){var d=b[c];F(nx(d)||Cx(d),d);L(a,d)}return a}function Xqa(a,b){a=Nw((H(),Rs),a);for(var c=0;c<b.length;c++){var d=b[c];F(nx(d)||Cx(d),d);L(a,d)}return a}function Dx(a){Mi(-1==ki(a,46),"Invalid name '%s'. Did you mean to use NodeUtil.newQName?",a);return Ax((H(),Xs),a)}function Ex(a,b){E(nx(a));E(Rw(b));return rx((H(),Us),a,b)}
function Yqa(a,b,c){E(nx(a));E(Rw(b));a=rx((H(),Us),a,b);for(b=0;b<c.length;b++){var d=c[b];E(Rw(d));a=rx(Us,a,d)}return a}function Fx(a,b,c){E(nx(a));a=rx((H(),Us),a,Gx(b));for(b=0;b<c.length;b++)a=rx(Us,a,Gx(c[b]));return a}function Hx(a,b){E(nx(a));E(nx(b));return rx((H(),Vs),a,b)}function Ix(a,b){F(Jx(a),a);F(nx(b),b);return rx((H(),vt),a,b)}function Kx(a,b,c){E(nx(a));E(nx(b));E(nx(c));return Sw((H(),It),a,b,c)}function Lx(a,b){return Mx((H(),ut),a,b)}
function Nx(a,b){return Mx((H(),Kt),a,b)}function Ox(a,b){return Mx((H(),Jt),a,b)}function Px(a){return Qx((H(),Ps),a)}function Zqa(a,b){return Mx((H(),kt),a,b)}function Rx(a){return Qx((H(),au),a)}function $qa(a){return Qx((H(),Qs),a)}function ara(a,b){a=Qx((H(),mu),a);Sx(a,b);return a}function bra(a){a=Qx((H(),Lt),a);Tx(a,(N(),Ux),!1);return a}function Vx(a,b){return Mx((H(),Ls),a,b)}
function Wx(a){for(var b=Mw((H(),rt)),c=0;c<a.length;c++){var d=a[c];switch(d.c.a){case 91:case 98:case 86:case 87:case 117:case 118:break;default:throw pb("Unexpected OBJECTLIT child: "+r(d)).s;}L(b,d)}return b}function cra(a,b){F(nx(a),a);F(nx(b),b);return rx((H(),Lu),a,b)}function dra(a,b){E(Xx(a));E(!a.a);E(nx(b));Yx(a,b);return a}function Zx(a){for(var b=Mw((H(),qt)),c=0;c<a.length;c++){var d=a[c];F(wx(d)||Cx(d),d);L(b,d)}return b}function $x(a){return Ax((H(),lu),a)}
function ay(a,b){E(nx(b));a=$x(a);Yx(a,b);return a}function by(){return Mw((H(),at))}function cy(){return Mw((H(),ct))}function dy(){return Mw((H(),bt))}function ey(){return Mw((H(),$s))}function Mx(a,b,c){F(nx(b),b);F(nx(c),c);return rx(a,b,c)}function Qx(a,b){E(nx(b));return Nw(a,b)}function wx(a){return Ow(a)||nx(a)}
function era(a){switch(a.c.a){case 80:case 65:return!0;case 82:case 74:case 96:case 88:case 75:case 89:case 71:case 84:case 72:case 73:case 101:case 102:case 66:case 83:case 100:case 67:case 39:case 44:case 76:case 70:case 77:return!0;default:return!1}}function ax(a){return era(a)?!0:fy(a)}
function nx(a){switch(a.c.a){case 65:case 96:return!0;case 13:case 62:case 42:case 47:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 59:case 57:case 58:case 104:case 3:case 1:case 20:case 2:case 28:case 92:case 46:case 64:case 24:case 16:case 4:case 18:case 34:case 9:case 26:case 27:case 8:case 60:case 125:case 40:case 63:case 41:case 7:case 10:case 6:case 17:case 15:case 29:case 5:case 22:case 23:case 124:case 19:case 30:case 32:case 43:case 61:case 21:case 38:case 11:case 36:case 37:case 31:case 14:case 99:case 120:case 119:case 33:case 25:case 35:case 12:case 79:case 103:return!0;default:return!1}}
function gy(){}l(gy,n);function hy(a){var b=0,c=Kj();do{var d=li(a,46,b);c.Y(ne(a,b,0>d?a.length:d));b=d+1}while(0<=d);a=c.ga();return fra(a,a.w())}gy.prototype.Ok=function(){var a=Ng();this.ek(a);return a.toString()};function gra(){}l(gra,gy);g=gra.prototype;g.Wg=function(){return this.a};g.Kf=function(){return this.b};g.Jg=function(){return!1};g.ek=function(a){this.a.ek(a);y(Pg(a,46),this.b)};g.be=function(a){return O(a)&&q(P(a).l(),this.b)&&this.a.be(a.a)};function hra(){this.a=0}l(hra,gy);
function fra(a,b){var c=new hra;c.b=a;c.a=b;return c}g=hra.prototype;g.Wg=function(){return 1<this.a?fra(this.b,this.a-1):null};g.Kf=function(){return this.b.F(this.a-1)};g.Jg=function(){return 1==this.a};g.ek=function(a){for(var b=0;b<this.a;b++)0<b&&Pg(a,46),y(a,this.b.F(b))};
g.be=function(a){for(var b=this.a-1;0<b&&O(a);){if(!q(P(a).l(),this.b.F(b)))return!1;b--;a=a.a}if(0<b)return!1;switch(a.c.a){case 29:case 98:return q(this.b.F(0),a.l());case 33:return"this"===this.b.F(0);case 99:return"super"===this.b.F(0);default:return!1}};function ira(){}l(ira,n);function jra(a){var b=new ira;b.a=a;return b}function iy(a,b){return Kg(b,n,saa)?jy(a.a,b):jy(a.a,[b])}function jy(a,b){for(var c=0;c<b.length;c++)for(var d="{"+c+"}";hi(a,d);)a=pi(a,d,r(b[c]));return a}
function kra(){}l(kra,n);function lra(a){for(var b=0;b<a.length;b++)if(32!=a.charCodeAt(b))return a.substr(b);return a}function mra(a){this.mc=moa(a,-1,0)}l(mra,$r);function nra(){var a=void 0===a?poa(mra):a;return new ora(a)}mra.prototype.a=function(){return new ora(this)};function ora(a){as.call(this,a)}l(ora,as);
var pra={"externs/es3.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview ECMAScript 3 Built-Ins. This include common extensions so this\n * is actually ES3+Reality.\n * @externs\n * @author acleung@google.com (Alan Leung)\n * @author stevey@google.com (Steve Yegge)\n * @author nicksantos@google.com (Nick Santos)\n * @author arv@google.com (Erik Arvidsson)\n * @author johnlenz@google.com (John Lenz)\n */\n\n\n// START ES6 RETROFIT CODE\n// symbol, Symbol and Symbol.iterator are actually ES6 types but some\n// base types require them to be part of their definition (such as Array).\n\n\n/**\n * @constructor\n * @param {*=} opt_description\n * @return {symbol}\n */\nfunction Symbol(opt_description) {}\n\n\n/**\n * @const {string|undefined}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/description\n */\nSymbol.prototype.description;\n\n\n/**\n * @param {string} sym\n * @return {symbol}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/for\n */\nSymbol.for = function(sym) {};\n\n\n/**\n * @param {symbol} sym\n * @return {string|undefined}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/keyFor\n */\nSymbol.keyFor = function(sym) {};\n\n\n// Well known symbols\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/asyncIterator\n * @const {symbol}\n */\nSymbol.asyncIterator;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/hasInstance\n * @const {symbol}\n */\nSymbol.hasInstance;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/isConcatSpreadable\n * @const {symbol}\n */\nSymbol.isConcatSpreadable;\n\n/**\n * @const {symbol}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/iterator\n */\nSymbol.iterator;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/match\n * @const {symbol}\n */\nSymbol.match;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/matchAll\n * @const {symbol}\n */\nSymbol.matchAll;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/replace\n * @const {symbol}\n */\nSymbol.replace;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/search\n * @const {symbol}\n */\nSymbol.search;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/species\n * @const {symbol}\n */\nSymbol.species;\n\n// /**\n//  * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/split\n//  * @const {symbol}\n//  */\n// Symbol.split;\n\n/**\n * @const {symbol}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/toPrimitive\n */\nSymbol.toPrimitive;\n\n/**\n * @const {symbol}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/toStringTag\n */\nSymbol.toStringTag;\n\n/**\n * @const {symbol}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/unscopables\n */\nSymbol.unscopables;\n\n\n/**\n * @record\n * @template VALUE\n */\nfunction IIterableResult() {};\n\n/** @type {boolean} */\nIIterableResult.prototype.done;\n\n/** @type {VALUE} */\nIIterableResult.prototype.value;\n\n\n\n/**\n * @interface\n * @template VALUE\n */\nfunction Iterable() {}\n\n// TODO(johnlenz): remove the suppression when the compiler understands\n// "symbol" natively\n/**\n * @return {!Iterator<VALUE>}\n * @suppress {externsValidation}\n */\nIterable.prototype[Symbol.iterator] = function() {};\n\n\n\n/**\n * TODO(b/142881197): UNUSED_RETURN_T and UNUSED_NEXT_T are not yet used for\n * anything. https://github.com/google/closure-compiler/issues/3489\n * @interface\n * @template VALUE, UNUSED_RETURN_T, UNUSED_NEXT_T\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/The_Iterator_protocol\n */\nfunction Iterator() {}\n\n/**\n * @param {?=} opt_value\n * @return {!IIterableResult<VALUE>}\n */\nIterator.prototype.next = function(opt_value) {};\n\n\n/**\n * Use this to indicate a type is both an Iterator and an Iterable.\n * TODO(b/142881197): UNUSED_RETURN_T and UNUSED_NEXT_T are not yet used for\n * anything. https://github.com/google/closure-compiler/issues/3489\n * @interface\n * @extends {Iterator<T>}\n * @extends {Iterable<T>}\n * @template T, UNUSED_RETURN_T, UNUSED_NEXT_T\n */\nfunction IteratorIterable() {}\n\n// END ES6 RETROFIT CODE\n\n\n/**\n * @interface\n * @template KEY1, VALUE1\n */\nfunction IObject() {}\n\n/**\n * @record\n * @extends {IObject<number, VALUE2>}\n * @template VALUE2\n */\nfunction IArrayLike() {}\n\n/** @type {number} */\nIArrayLike.prototype.length;\n\n/**\n * @constructor\n * @implements {IArrayLike<?>}\n * @implements {Iterable<?>}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions_and_function_scope/arguments\n */\nfunction Arguments() {}\n\n/**\n * @type {Function}\n * @see http://developer.mozilla.org/En/Core_JavaScript_1.5_Reference/Functions_and_function_scope/arguments/callee\n */\nArguments.prototype.callee;\n\n/**\n * Use the non-standard {@see Function.prototype.caller} property of a function\n * object instead.\n * @type {Function}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments/caller\n * @deprecated\n */\nArguments.prototype.caller;\n\n/**\n * @type {number}\n * @see http://developer.mozilla.org/En/Core_JavaScript_1.5_Reference/Functions_and_function_scope/arguments/length\n */\nArguments.prototype.length;\n\n/**\n * Not actually a global variable, when running in a browser environment. But\n * we need it in order for the type checker to typecheck the "arguments"\n * variable in a function correctly.\n *\n * TODO(tbreisacher): There should be a separate \'arguments\' variable of type\n * `Array<string>`, in the d8 externs.\n *\n * @type {!Arguments}\n * @see http://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Functions_and_function_scope/arguments\n */\nvar arguments;\n\n/**\n * @type {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Infinity\n * @const\n */\nvar Infinity;\n\n/**\n * @type {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NaN\n * @const\n */\nvar NaN;\n\n/**\n * @type {undefined}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/undefined\n * @const\n */\nvar undefined;\n\n/**\n * @param {string} uri\n * @return {string}\n * @throws {URIError} when used wrongly.\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/decodeURI\n */\nfunction decodeURI(uri) {}\n\n/**\n * @param {string} uri\n * @return {string}\n * @throws {URIError} when used wrongly.\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/decodeURIComponent\n */\nfunction decodeURIComponent(uri) {}\n\n/**\n * @param {string} uri\n * @return {string}\n * @throws {URIError} if one attempts to encode a surrogate which is not part of\n * a high-low pair.\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURI\n */\nfunction encodeURI(uri) {}\n\n/**\n * @param {string} uri\n * @return {string}\n * @throws {URIError} if one attempts to encode a surrogate which is not part of\n * a high-low pair.\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent\n */\nfunction encodeURIComponent(uri) {}\n\n/**\n * Should only be used in browsers where encode/decodeURIComponent\n * are not present, as the latter handle fancy Unicode characters.\n * @param {string} str\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/Core_JavaScript_1.5_Guide/Predefined_Functions/escape_and_unescape_Functions\n */\nfunction escape(str) {}\n\n/**\n * Should only be used in browsers where encode/decodeURIComponent\n * are not present, as the latter handle fancy Unicode characters.\n * @param {string} str\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/Core_JavaScript_1.5_Guide/Predefined_Functions/escape_and_unescape_Functions\n */\nfunction unescape(str) {}\n\n/**\n * @param {*} num\n * @return {boolean}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/isFinite\n */\nfunction isFinite(num) {}\n\n/**\n * @param {*} num\n * @return {boolean}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/isNaN\n */\nfunction isNaN(num) {}\n\n/**\n * @param {*} num\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseFloat\n */\nfunction parseFloat(num) {}\n\n/**\n * Parse an integer. Use of `parseInt` without `base` is strictly\n * banned in Google. If you really want to parse octal or hex based on the\n * leader, then pass `undefined` as the base.\n *\n * @param {*} num\n * @param {number|undefined} base\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseInt\n */\nfunction parseInt(num, base) {}\n\n/**\n * @param {string} code\n * @return {*}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/eval\n */\nfunction eval(code) {}\n\n\n\n/**\n * @constructor\n * @param {*=} opt_value\n * @return {!Object}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object\n */\nfunction Object(opt_value) {}\n\n/**\n * The constructor of the current object.\n * @type {Function}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/constructor\n */\nObject.prototype.constructor = function() {};\n\n/**\n * Binds an object\'s property to a function to be called when that property is\n * looked up.\n * Mozilla-only.\n *\n * @param {string} sprop\n * @param {Function} fun\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineGetter\n * @return {undefined}\n * @deprecated\n */\nObject.prototype.__defineGetter__ = function(sprop, fun) {};\n\n/**\n * Binds an object\'s property to a function to be called when an attempt is made\n * to set that property.\n * Mozilla-only.\n *\n * @param {string} sprop\n * @param {Function} fun\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineSetter\n * @return {undefined}\n * @deprecated\n */\nObject.prototype.__defineSetter__ = function(sprop, fun) {};\n\n/**\n * Returns whether the object has a property with the specified name.\n *\n * @param {*} propertyName Implicitly cast to a string.\n * @return {boolean}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/hasOwnProperty\n */\nObject.prototype.hasOwnProperty = function(propertyName) {};\n\n/**\n * Returns whether an object exists in another object\'s prototype chain.\n *\n * @param {Object} other\n * @return {boolean}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/isPrototypeOf\n */\nObject.prototype.isPrototypeOf = function(other) {};\n\n/**\n * Return the function bound as a getter to the specified property.\n * Mozilla-only.\n *\n * @param {string} sprop a string containing the name of the property whose\n * getter should be returned\n * @return {Function}\n * @nosideeffects\n * @deprecated\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/lookupGetter\n */\nObject.prototype.__lookupGetter__ = function(sprop) {};\n\n/**\n * Return the function bound as a setter to the specified property.\n * Mozilla-only.\n *\n * @param {string} sprop a string containing the name of the property whose\n *     setter should be returned.\n * @return {Function}\n * @nosideeffects\n * @deprecated\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/lookupSetter\n */\nObject.prototype.__lookupSetter__ = function(sprop) {};\n\n/**\n * Executes a function when a non-existent method is called on an object.\n * Mozilla-only.\n *\n * @param {Function} fun\n * @return {*}\n * @deprecated\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/noSuchMethod\n */\nObject.prototype.__noSuchMethod__ = function(fun) {};\n\n/**\n * Points to an object\'s context.  For top-level objects, this is the e.g. window.\n * Mozilla-only.\n *\n * @type {Object}\n * @deprecated\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/parent\n */\nObject.prototype.__parent__;\n\n/**\n * Points to the object which was used as prototype when the object was instantiated.\n * Mozilla-only.\n *\n * Will be null on Object.prototype.\n *\n * @type {Object}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/proto\n */\nObject.prototype.__proto__;\n\n/**\n * Determine whether the specified property in an object can be enumerated by a\n * for..in loop, with the exception of properties inherited through the\n * prototype chain.\n *\n * @param {string|symbol} propertyName\n * @return {boolean}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/propertyIsEnumerable\n */\nObject.prototype.propertyIsEnumerable = function(propertyName) {};\n\n/**\n * Returns a localized string representing the object.\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/toLocaleString\n */\nObject.prototype.toLocaleString = function() {};\n\n/**\n * Returns a string representing the source code of the object.\n * Mozilla-only.\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/toSource\n */\nObject.prototype.toSource = function() {};\n\n/**\n * Returns a string representing the object.\n * @this {*}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/toString\n */\nObject.prototype.toString = function() {};\n\n/**\n * Returns the object\'s `this` value.\n * @return {*}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/valueOf\n */\nObject.prototype.valueOf = function() {};\n\n/**\n * @constructor\n * @param {...*} var_args\n * @throws {Error}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function\n */\nfunction Function(var_args) {}\n\n/**\n * @param {...*} var_args\n * @return {*}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/call\n */\nFunction.prototype.call = function(var_args) {};\n\n/**\n * @param {...*} var_args\n * @return {*}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/apply\n */\nFunction.prototype.apply = function(var_args) {};\n\nFunction.prototype.arguments;\n\n/**\n * @type {number}\n * @deprecated\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/arity\n */\nFunction.prototype.arity;\n\n/**\n * Nonstandard; Mozilla and JScript only.\n * @type {Function}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/caller\n */\nFunction.prototype.caller;\n\n/**\n * Nonstandard.\n * @type {?}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/displayName\n */\nFunction.prototype.displayName;\n\n/**\n * Expected number of arguments.\n * @type {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/length\n */\nFunction.prototype.length;\n\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/name\n */\nFunction.prototype.name;\n\n/**\n * @this {Function}\n * @return {string}\n * @nosideeffects\n * @override\n */\nFunction.prototype.toString = function() {};\n\n\n/**\n * @constructor\n * @implements {IArrayLike<T>}\n * @implements {Iterable<T>}\n * @param {...*} var_args\n * @return {!Array<?>}\n * @nosideeffects\n * @template T\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array\n */\nfunction Array(var_args) {}\n\n/**\n * @return {Iterator<T>}\n * @suppress {externsValidation}\n */\nArray.prototype[Symbol.iterator] = function() {};\n\n// Functions:\n\n/**\n * Returns a new array comprised of this array joined with other array(s)\n * and/or value(s).\n *\n * @param {...*} var_args\n * @return {!Array<?>}\n * @this {*}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/concat\n */\nArray.prototype.concat = function(var_args) {};\n\n/**\n * Joins all elements of an array into a string.\n *\n * @param {*=} opt_separator Specifies a string to separate each element of the\n *     array. The separator is converted to a string if necessary. If omitted,\n *     the array elements are separated with a comma.\n * @return {string}\n * @this {IArrayLike<?>|string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/join\n */\nArray.prototype.join = function(opt_separator) {};\n\n/**\n * Removes the last element from an array and returns that element.\n *\n * @return {T}\n * @this {IArrayLike<T>}\n * @modifies {this}\n * @template T\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/pop\n */\nArray.prototype.pop = function() {};\n\n// TODO(bradfordcsmith): remove "undefined" from the var_args of push\n/**\n * Mutates an array by appending the given elements and returning the new\n * length of the array.\n *\n * @param {...(T|undefined)} var_args\n * @return {number} The new length of the array.\n * @this {IArrayLike<T>}\n * @template T\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/push\n */\nArray.prototype.push = function(var_args) {};\n\n/**\n * Transposes the elements of an array in place: the first array element becomes the\n * last and the last becomes the first. The mutated array is also returned.\n *\n * @return {THIS} A reference to the original modified array.\n * @this {THIS}\n * @template THIS\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reverse\n */\nArray.prototype.reverse = function() {};\n\n/**\n * Removes the first element from an array and returns that element. This\n * method changes the length of the array.\n *\n * @this {IArrayLike<T>}\n * @modifies {this}\n * @return {T}\n * @template T\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/shift\n */\nArray.prototype.shift = function() {};\n\n/**\n * Extracts a section of an array and returns a new array.\n *\n * @param {?number=} begin Zero-based index at which to begin extraction.\n * @param {?number=} end Zero-based index at which to end extraction.  slice\n *     extracts up to but not including end.\n * @return {!Array<T>}\n * @this {IArrayLike<T>|string}\n * @template T\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/slice\n */\nArray.prototype.slice = function(begin, end) {};\n\n/**\n * Sorts the elements of an array in place.\n *\n * @param {function(T,T):number=} opt_compareFn Specifies a function that\n *     defines the sort order.\n * @this {IArrayLike<T>}\n * @template T\n * @modifies {this}\n * @return {!Array<T>}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort\n */\nArray.prototype.sort = function(opt_compareFn) {};\n\n/**\n * Changes the content of an array, adding new elements while removing old\n * elements.\n *\n * @param {?number=} index Index at which to start changing the array. If\n *     negative, will begin that many elements from the end.\n * @param {?number=} howMany An integer indicating the number of old array\n *     elements to remove.\n * @param {...T} var_args\n * @return {!Array<T>}\n * @this {IArrayLike<T>}\n * @modifies {this}\n * @template T\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n */\nArray.prototype.splice = function(index, howMany, var_args) {};\n\n/**\n * @return {string}\n * @this {Object}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/toSource\n */\nArray.prototype.toSource;\n\n/**\n * @this {Array<?>}\n * @return {string}\n * @nosideeffects\n * @override\n */\nArray.prototype.toString = function() {};\n\n/**\n * Adds one or more elements to the beginning of an array and returns the new\n * length of the array.\n *\n * @param {...*} var_args\n * @return {number} The new length of the array\n * @this {IArrayLike<?>}\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/unshift\n */\nArray.prototype.unshift = function(var_args) {};\n\n/**\n * Apply a function simultaneously against two values of the array (from\n * left-to-right) as to reduce it to a single value.\n *\n * @param {?function(?, T, number, !Array<T>) : R} callback\n * @param {*=} opt_initialValue\n * @return {R}\n * @this {IArrayLike<T>|string}\n * @template T,R\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduce\n */\nArray.prototype.reduce = function(callback, opt_initialValue) {};\n\n/**\n * Apply a function simultaneously against two values of the array (from\n * right-to-left) as to reduce it to a single value.\n *\n * @param {?function(?, T, number, !Array<T>) : R} callback\n * @param {*=} opt_initialValue\n * @return {R}\n * @this {IArrayLike<T>|string}\n * @template T,R\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduceRight\n */\nArray.prototype.reduceRight = function(callback, opt_initialValue) {};\n\n/**\n * Available in ECMAScript 5, Mozilla 1.6+.\n * @param {?function(this:S, T, number, !Array<T>): ?} callback\n * @param {S=} opt_thisobj\n * @return {boolean}\n * @this {IArrayLike<T>|string}\n * @template T,S\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/every\n */\nArray.prototype.every = function(callback, opt_thisobj) {};\n\n/**\n * Available in ECMAScript 5, Mozilla 1.6+.\n * @param {?function(this:S, T, number, !Array<T>): ?} callback\n * @param {S=} opt_thisobj\n * @return {!Array<T>}\n * @this {IArrayLike<T>|string}\n * @template T,S\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter\n */\nArray.prototype.filter = function(callback, opt_thisobj) {};\n\n/**\n * Available in ECMAScript 5, Mozilla 1.6+.\n * @param {?function(this:S, T, number, !Array<T>): ?} callback\n * @param {S=} opt_thisobj\n * @this {IArrayLike<T>|string}\n * @template T,S\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach\n * @return {undefined}\n */\nArray.prototype.forEach = function(callback, opt_thisobj) {};\n\n/**\n * Available in ECMAScript 5, Mozilla 1.6+.\n * @param {T} obj\n * @param {number=} opt_fromIndex\n * @return {number}\n * @this {IArrayLike<T>|string}\n * @nosideeffects\n * @template T\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf\n */\nArray.prototype.indexOf = function(obj, opt_fromIndex) {};\n\n/**\n * Available in ECMAScript 5, Mozilla 1.6+.\n * @param {T} obj\n * @param {number=} opt_fromIndex\n * @return {number}\n * @this {IArrayLike<T>|string}\n * @nosideeffects\n * @template T\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/lastIndexOf\n */\nArray.prototype.lastIndexOf = function(obj, opt_fromIndex) {};\n\n/**\n * Available in ECMAScript 5, Mozilla 1.6+.\n * @param {?function(this:S, T, number, !Array<T>): R} callback\n * @param {S=} opt_thisobj\n * @return {!Array<R>}\n * @this {IArrayLike<T>|string}\n * @template T,S,R\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map\n */\nArray.prototype.map = function(callback, opt_thisobj) {};\n\n/**\n * Available in ECMAScript 5, Mozilla 1.6+.\n * @param {?function(this:S, T, number, !Array<T>): ?} callback\n * @param {S=} opt_thisobj\n * @return {boolean}\n * @this {IArrayLike<T>|string}\n * @template T,S\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some\n */\nArray.prototype.some = function(callback, opt_thisobj) {};\n\n/**\n * @type {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/index\n */\nArray.prototype.index;\n\n/**\n * @type {?string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/input\n */\nArray.prototype.input;\n\n/**\n * @type {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/length\n */\nArray.prototype.length;\n\n/**\n * Introduced in 1.8.5.\n * @param {*} arr\n * @return {boolean}\n * @nosideeffects\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/isArray\n */\nArray.isArray = function(arr) {};\n\n/**\n * @constructor\n * @param {*=} opt_value\n * @return {boolean}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean\n */\nfunction Boolean(opt_value) {}\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean/toSource\n * @override\n */\nBoolean.prototype.toSource = function() {};\n\n/**\n * @this {boolean|Boolean}\n * @return {string}\n * @nosideeffects\n * @override\n */\nBoolean.prototype.toString = function() {};\n\n/**\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean/valueOf\n * @override\n */\nBoolean.prototype.valueOf = function() {};\n\n/**\n * @constructor\n * @param {*=} opt_value\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number\n */\nfunction Number(opt_value) {}\n\n/**\n * @this {Number|number}\n * @param {number=} opt_fractionDigits\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toExponential\n */\nNumber.prototype.toExponential = function(opt_fractionDigits) {};\n\n/**\n * @this {Number|number}\n * @param {*=} opt_digits\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toFixed\n */\nNumber.prototype.toFixed = function(opt_digits) {};\n\n/**\n * @this {Number|number}\n * @param {number=} opt_precision\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toPrecision\n */\nNumber.prototype.toPrecision = function(opt_precision) {};\n\n/**\n * Returns a string representing the number.\n * @this {Number|number}\n * @param {(number|Number)=} opt_radix An optional radix.\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toString\n * @override\n */\nNumber.prototype.toString = function(opt_radix) {};\n\n// Properties.\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MAX_VALUE\n */\nNumber.MAX_VALUE;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MIN_VALUE\n */\nNumber.MIN_VALUE;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/NaN\n */\nNumber.NaN;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/NEGATIVE_INFINITY\n */\nNumber.NEGATIVE_INFINITY;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/POSITIVE_INFINITY\n */\nNumber.POSITIVE_INFINITY;\n\n\n/**\n * @const\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math\n */\nvar Math = {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/abs\n */\nMath.abs = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/acos\n */\nMath.acos = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/asin\n */\nMath.asin = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/atan\n */\nMath.atan = function(x) {};\n\n/**\n * @param {?} y\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/atan2\n */\nMath.atan2 = function(y, x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/ceil\n */\nMath.ceil = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/cos\n */\nMath.cos = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/exp\n */\nMath.exp = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/floor\n */\nMath.floor = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/log\n */\nMath.log = function(x) {};\n\n/**\n * @param {...?} var_args\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/max\n */\nMath.max = function(var_args) {};\n\n/**\n * @param {...?} var_args\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/min\n */\nMath.min = function(var_args) {};\n\n/**\n * @param {?} x\n * @param {?} y\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/pow\n */\nMath.pow = function(x, y) {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random\n */\nMath.random = function() {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/round\n */\nMath.round = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/sin\n */\nMath.sin = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/sqrt\n */\nMath.sqrt = function(x) {};\n\n/**\n * @param {?} x\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/tan\n */\nMath.tan = function(x) {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/toSource\n */\nMath.toSource = function() {};\n\n// Properties:\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/E\n */\nMath.E;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/LN2\n */\nMath.LN2;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/LN10\n */\nMath.LN10;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/LOG2E\n */\nMath.LOG2E;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/LOG10E\n */\nMath.LOG10E;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/PI\n */\nMath.PI;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/SQRT1_2\n */\nMath.SQRT1_2;\n\n/**\n * @const {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/SQRT2\n */\nMath.SQRT2;\n\n\n/**\n * @param {?=} opt_yr_num\n * @param {?=} opt_mo_num\n * @param {?=} opt_day_num\n * @param {?=} opt_hr_num\n * @param {?=} opt_min_num\n * @param {?=} opt_sec_num\n * @param {?=} opt_ms_num\n * @constructor\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date\n */\nfunction Date(opt_yr_num, opt_mo_num, opt_day_num, opt_hr_num, opt_min_num,\n    opt_sec_num, opt_ms_num) {}\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/now\n */\nDate.now = function() {};\n\n/**\n * Parses a string representation of a date, and returns the number\n * of milliseconds since January 1, 1970, 00:00:00, local time.\n * @param {*} date\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/parse\n */\nDate.parse = function(date) {};\n\n/**\n * @param {number} year\n * @param {number} month\n * @param {number=} opt_date\n * @param {number=} opt_hours\n * @param {number=} opt_minute\n * @param {number=} opt_second\n * @param {number=} opt_ms\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/UTC\n */\nDate.UTC = function(year, month,\n                    opt_date, opt_hours, opt_minute, opt_second, opt_ms) {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getDate\n */\nDate.prototype.getDate = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getDay\n */\nDate.prototype.getDay = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getMonth\n */\nDate.prototype.getMonth = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getFullYear\n */\nDate.prototype.getFullYear = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getYear\n */\nDate.prototype.getYear = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getHours\n */\nDate.prototype.getHours = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getMinutes\n */\nDate.prototype.getMinutes = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getSeconds\n */\nDate.prototype.getSeconds = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getMilliseconds\n */\nDate.prototype.getMilliseconds = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime\n */\nDate.prototype.getTime = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTimezoneOffset\n */\nDate.prototype.getTimezoneOffset = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCDate\n */\nDate.prototype.getUTCDate = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCDay\n */\nDate.prototype.getUTCDay = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCMonth\n */\nDate.prototype.getUTCMonth = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCFullYear\n */\nDate.prototype.getUTCFullYear = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCHours\n */\nDate.prototype.getUTCHours = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCMinutes\n */\nDate.prototype.getUTCMinutes = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCSeconds\n */\nDate.prototype.getUTCSeconds = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCMilliseconds\n */\nDate.prototype.getUTCMilliseconds = function() {};\n\n/**\n * Sets the day of the month for a specified date according to local time.\n *\n * @param {number} dayValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setDate\n * @return {number}\n */\nDate.prototype.setDate = function(dayValue) {};\n\n/**\n * Set the month for a specified date according to local time.\n *\n * @param {number} monthValue\n * @param {number=} opt_dayValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setMonth\n * @return {number}\n */\nDate.prototype.setMonth = function(monthValue, opt_dayValue) {};\n\n/**\n * Sets the full year for a specified date according to local time.\n *\n * @param {number} yearValue\n * @param {number=} opt_monthValue\n * @param {number=} opt_dayValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setFullYear\n * @return {number}\n */\nDate.prototype.setFullYear =\n    function(yearValue, opt_monthValue, opt_dayValue) {};\n\n/**\n * Sets the year for a specified date according to local time.\n *\n * @param {number} yearValue\n * @deprecated\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setYear\n * @return {number}\n */\nDate.prototype.setYear = function(yearValue) {};\n\n/**\n * Sets the hours for a specified date according to local time.\n *\n * @param {number} hoursValue\n * @param {number=} opt_minutesValue\n * @param {number=} opt_secondsValue\n * @param {number=} opt_msValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setHours\n * @return {number}\n */\nDate.prototype.setHours = function(hoursValue, opt_minutesValue,\n                                   opt_secondsValue, opt_msValue) {};\n\n/**\n * Sets the minutes for a specified date according to local time.\n *\n * @param {number} minutesValue\n * @param {number=} opt_secondsValue\n * @param {number=} opt_msValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setMinutes\n * @return {number}\n */\nDate.prototype.setMinutes =\n    function(minutesValue, opt_secondsValue, opt_msValue) {};\n\n/**\n * Sets the seconds for a specified date according to local time.\n *\n * @param {number} secondsValue\n * @param {number=} opt_msValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setSeconds\n * @return {number}\n */\nDate.prototype.setSeconds = function(secondsValue, opt_msValue) {};\n\n/**\n * Sets the milliseconds for a specified date according to local time.\n *\n * @param {number} millisecondsValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setMilliseconds\n * @return {number}\n */\nDate.prototype.setMilliseconds = function(millisecondsValue) {};\n\n/**\n * Sets the Date object to the time represented by a number of milliseconds\n * since January 1, 1970, 00:00:00 UTC.\n *\n * @param {number} timeValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setTime\n * @return {number}\n */\nDate.prototype.setTime = function(timeValue) {};\n\n/**\n * Sets the day of the month for a specified date according to universal time.\n *\n * @param {number} dayValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCDate\n * @return {number}\n */\nDate.prototype.setUTCDate = function(dayValue) {};\n\n/**\n * Sets the month for a specified date according to universal time.\n *\n * @param {number} monthValue\n * @param {number=} opt_dayValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCMonth\n * @return {number}\n */\nDate.prototype.setUTCMonth = function(monthValue, opt_dayValue) {};\n\n/**\n * Sets the full year for a specified date according to universal time.\n *\n * @param {number} yearValue\n * @param {number=} opt_monthValue\n * @param {number=} opt_dayValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCFullYear\n * @return {number}\n */\nDate.prototype.setUTCFullYear = function(yearValue, opt_monthValue,\n                                         opt_dayValue) {};\n\n/**\n * Sets the hour for a specified date according to universal time.\n *\n * @param {number} hoursValue\n * @param {number=} opt_minutesValue\n * @param {number=} opt_secondsValue\n * @param {number=} opt_msValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCHours\n * @return {number}\n */\nDate.prototype.setUTCHours = function(hoursValue, opt_minutesValue,\n                                      opt_secondsValue, opt_msValue) {};\n\n/**\n * Sets the minutes for a specified date according to universal time.\n *\n * @param {number} minutesValue\n * @param {number=} opt_secondsValue\n * @param {number=} opt_msValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCMinutes\n * @return {number}\n */\nDate.prototype.setUTCMinutes = function(minutesValue, opt_secondsValue,\n                                        opt_msValue) {};\n\n\n/**\n * Sets the seconds for a specified date according to universal time.\n *\n * @param {number} secondsValue\n * @param {number=} opt_msValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCSeconds\n * @return {number}\n */\nDate.prototype.setUTCSeconds = function(secondsValue, opt_msValue) {};\n\n/**\n * Sets the milliseconds for a specified date according to universal time.\n *\n * @param {number} millisecondsValue\n * @modifies {this}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCMilliseconds\n * @return {number}\n */\nDate.prototype.setUTCMilliseconds = function(millisecondsValue) {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toSource\n * @override\n */\nDate.prototype.toSource = function() {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Date/toDateString\n */\nDate.prototype.toDateString = function() {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toGMTString\n */\nDate.prototype.toGMTString = function() {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toTimeString\n */\nDate.prototype.toTimeString = function() {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toUTCString\n */\nDate.prototype.toUTCString = function() {};\n\n/**\n * @param {(string|Array<string>)=} opt_locales\n * @param {Object=} opt_options\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleDateString\n */\nDate.prototype.toLocaleDateString = function(opt_locales, opt_options) {};\n\n/**\n * @param {string} formatString\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleFormat\n */\nDate.prototype.toLocaleFormat = function(formatString) {};\n\n/**\n * @param {string|Array<string>=} opt_locales\n * @param {Object=} opt_options\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleString\n * @see http://www.ecma-international.org/ecma-402/1.0/#sec-13.3.1\n * @override\n */\nDate.prototype.toLocaleString = function(opt_locales, opt_options) {};\n\n/**\n * @param {(string|Array<string>)=} opt_locales\n * @param {Object=} opt_options\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleTimeString\n */\nDate.prototype.toLocaleTimeString = function(opt_locales, opt_options) {};\n\n/**\n * @this {Date}\n * @return {string}\n * @nosideeffects\n * @override\n */\nDate.prototype.toString = function() {};\n\n/**\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/valueOf\n */\nDate.prototype.valueOf;\n\n/**\n * @constructor\n * @implements {Iterable<string>}\n * @param {*=} opt_str\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String\n */\nfunction String(opt_str) {}\n\n/**\n * @param {...number} var_args\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fromCharCode\n */\nString.fromCharCode = function(var_args) {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/anchor\n */\nString.prototype.anchor = function() {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/big\n */\nString.prototype.big = function() {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/blink\n */\nString.prototype.blink = function() {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/bold\n */\nString.prototype.bold = function() {};\n\n/**\n * Returns the specified character from a string.\n *\n * @this {String|string}\n * @param {number} index\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/charAt\n */\nString.prototype.charAt = function(index) {};\n\n/**\n * Returns a number indicating the Unicode value of the character at the given\n * index.\n *\n * @this {String|string}\n * @param {number=} opt_index\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/charCodeAt\n */\nString.prototype.charCodeAt = function(opt_index) {};\n\n/**\n * Combines the text of two or more strings and returns a new string.\n *\n * @this {String|string}\n * @param {...*} var_args\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/concat\n */\nString.prototype.concat = function(var_args) {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fixed\n */\nString.prototype.fixed = function() {};\n\n/**\n * @this {String|string}\n * @param {string} color\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fontcolor\n */\nString.prototype.fontcolor = function(color) {};\n\n/**\n * @this {String|string}\n * @param {number} size\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fontsize\n */\nString.prototype.fontsize = function(size) {};\n\n/**\n * Returns the index within the calling String object of the first occurrence\n * of the specified value, starting the search at fromIndex, returns -1 if the\n * value is not found.\n *\n * @this {String|string}\n * @param {string|null} searchValue\n * @param {(number|null)=} opt_fromIndex\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/indexOf\n */\nString.prototype.indexOf = function(searchValue, opt_fromIndex) {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/italics\n */\nString.prototype.italics = function() {};\n\n/**\n * Returns the index within the calling String object of the last occurrence of\n * the specified value, or -1 if not found. The calling string is searched\n * backward, starting at fromIndex.\n *\n * @this {String|string}\n * @param {string|null} searchValue\n * @param {(number|null)=} opt_fromIndex\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/lastIndexOf\n */\nString.prototype.lastIndexOf = function(searchValue, opt_fromIndex) {};\n\n/**\n * @this {String|string}\n * @param {string} hrefAttribute\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/link\n */\nString.prototype.link = function(hrefAttribute) {};\n\n/**\n * Returns a number indicating whether a reference string comes before or after\n * or is the same as the given string in sort order.\n *\n * @this {*}\n * @param {?string} compareString\n * @param {string|Array<string>=} locales\n * @param {Object=} options\n * @return {number}\n * @nosideeffects\n * @see http://developer.mozilla.org/En/Core_JavaScript_1.5_Reference/Objects/String/localeCompare\n * @see http://www.ecma-international.org/ecma-402/1.0/#sec-13.1.1\n */\nString.prototype.localeCompare = function(compareString, locales, options) {};\n\n/**\n * Used to retrieve the matches when matching a string against a regular\n * expression.\n *\n * @this {String|string}\n * @param {*} regexp\n * @return {Array<string>} This should really return an Array with a few\n *     special properties, but we do not have a good way to model this in\n *     our type system. Also see Regexp.prototype.exec.\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/match\n */\nString.prototype.match = function(regexp) {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/quote\n */\nString.prototype.quote = function() {};\n\n/**\n * Finds a match between a regular expression and a string, and replaces the\n * matched substring with a new substring.\n *\n * This may have side-effects if the replacement function has side-effects.\n *\n * @this {String|string}\n * @param {RegExp|string} pattern\n * @param {?string|function(string, ...?):*} replacement\n * @return {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/replace\n */\nString.prototype.replace = function(pattern, replacement) {};\n\n/**\n * Executes the search for a match between a regular expression and this String\n * object.\n *\n * @this {String|string}\n * @param {RegExp|string} pattern\n * @return {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/search\n */\nString.prototype.search = function(pattern) {};\n\n/**\n * @this {String|string}\n * @param {number} begin\n * @param {number=} opt_end\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/slice\n */\nString.prototype.slice = function(begin, opt_end) {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/small\n */\nString.prototype.small = function() {};\n\n/**\n * @this {String|string}\n * @param {*=} opt_separator\n * @param {number=} opt_limit\n * @return {!Array<string>}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/split\n */\nString.prototype.split = function(opt_separator, opt_limit) {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/strike\n */\nString.prototype.strike = function() {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/sub\n */\nString.prototype.sub = function() {};\n\n/**\n * @this {String|string}\n * @param {number} start\n * @param {number=} opt_length\n * @return {string} The specified substring.\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/substr\n */\nString.prototype.substr = function(start, opt_length) {};\n\n/**\n * @this {String|string}\n * @param {number} start\n * @param {number=} opt_end\n * @return {string} The specified substring.\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/substring\n */\nString.prototype.substring = function(start, opt_end) {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/sup\n */\nString.prototype.sup = function() {};\n\n/**\n * @this {String|string}\n * @param {(string|Array<string>)=} opt_locales\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toLocaleUpperCase\n */\nString.prototype.toLocaleUpperCase = function(opt_locales) {};\n\n/**\n * @this {String|string}\n * @param {(string|Array<string>)=} opt_locales\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toLocaleLowerCase\n */\nString.prototype.toLocaleLowerCase = function(opt_locales) {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toLowerCase\n */\nString.prototype.toLowerCase = function() {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toUpperCase\n */\nString.prototype.toUpperCase = function() {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toSource\n * @override\n */\nString.prototype.toSource = function() {};\n\n/**\n * @this {string|String}\n * @return {string}\n * @nosideeffects\n * @override\n */\nString.prototype.toString = function() {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/valueOf\n */\nString.prototype.valueOf;\n\n/**\n * @type {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/length\n */\nString.prototype.length;\n\n/**\n * @constructor\n * @param {*=} opt_pattern\n * @param {*=} opt_flags\n * @return {!RegExp}\n * @throws {SyntaxError} if opt_pattern is an invalid pattern.\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nfunction RegExp(opt_pattern, opt_flags) {}\n\n/**\n * @param {*} pattern\n * @param {*=} opt_flags\n * @return {void}\n * @modifies {this}\n * @deprecated\n * @see http://msdn.microsoft.com/en-us/library/x9cswe0z(v=VS.85).aspx\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/compile\n */\nRegExp.prototype.compile = function(pattern, opt_flags) {};\n\n/**\n * @param {*} str The string to search.\n * @return {?RegExpResult}\n * @see http://msdn.microsoft.com/en-us/library/z908hy33(VS.85).aspx\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/exec\n */\nRegExp.prototype.exec = function(str) {};\n\n/**\n * @param {*} str The string to search.\n * @return {boolean} Whether the string was matched.\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/test\n */\nRegExp.prototype.test = function(str) {};\n\n/**\n * @this {RegExp}\n * @return {string}\n * @nosideeffects\n * @override\n */\nRegExp.prototype.toString = function() {};\n\n/**\n * @constructor\n * @extends {Array<string>}\n */\nvar RegExpResult = function() {};\n\n\n/** @type {number} */\nRegExpResult.prototype.index;\n\n\n/** @type {string} */\nRegExpResult.prototype.input;\n\n\n/** @type {number} */\nRegExpResult.prototype.length;\n\n\n/**\n * Not actually part of ES3; was added in 2018.\n * https://github.com/tc39/proposal-regexp-named-groups\n *\n * @type {!Object<string, string>}\n */\nRegExpResult.prototype.groups;\n\n\n// Constructor properties:\n\n/**\n * The string against which the last regexp was matched.\n * @type {string}\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_input.html\n */\nRegExp.input;\n\n/**\n * The last matched characters.\n * @type {string}\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_lastMatch.html\n */\nRegExp.lastMatch;\n\n/**\n * The last matched parenthesized substring, if any.\n * @type {string}\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_lastParen.html\n */\nRegExp.lastParen;\n\n/**\n * The substring of the input up to the characters most recently matched.\n * @type {string}\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_leftContext.html\n */\nRegExp.leftContext;\n\n/**\n * The substring of the input after the characters most recently matched.\n * @type {string}\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_rightContext.html\n */\nRegExp.rightContext;\n\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$1;\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$2;\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$3;\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$4;\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$5;\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$6;\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$7;\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$8;\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\n */\nRegExp.$9;\n\n// Prototype properties:\n\n/**\n * Whether to test the regular expression against all possible matches\n * in a string, or only against the first.\n * @type {boolean}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/global\n */\nRegExp.prototype.global;\n\n/**\n * Whether to ignore case while attempting a match in a string.\n * @type {boolean}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/ignoreCase\n */\nRegExp.prototype.ignoreCase;\n\n/**\n * The index at which to start the next match.\n * @type {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/lastIndex\n */\nRegExp.prototype.lastIndex;\n\n/**\n * Whether or not the regular expression uses lastIndex.\n * @type {boolean}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/sticky\n */\nRegExp.prototype.sticky;\n\n/**\n * Whether or not to search in strings across multiple lines.\n * @type {boolean}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/multiline\n */\nRegExp.prototype.multiline;\n\n/**\n * The text of the pattern.\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/source\n */\nRegExp.prototype.source;\n\n/**\n * The flags the regex was created with.\n * @type {string}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/flags\n */\nRegExp.prototype.flags;\n\n/**\n * @constructor\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!Error}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error\n */\nfunction Error(opt_message, opt_file, opt_line) {}\n\n\n/**\n * Chrome/v8 specific, altering the maximum depth of the stack trace\n * (10 by default).\n * @type {number}\n * @see http://code.google.com/p/v8/wiki/JavaScriptStackTraceApi\n */\nError.stackTraceLimit;\n\n\n/**\n * Chrome/v8 specific, adds a stack trace to the error object. The optional\n * constructorOpt parameter allows you to pass in a function value. When\n * collecting the stack trace all frames above the topmost call to this\n * function, including that call, will be left out of the stack trace.\n * @param {Object} error The object to add the stack trace to.\n * @param {Function=} opt_constructor A function in the stack trace\n * @see http://code.google.com/p/v8/wiki/JavaScriptStackTraceApi\n * @return {undefined}\n */\nError.captureStackTrace = function(error, opt_constructor){};\n\n\n/**\n * IE-only.\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/2w6a45b5.aspx\n */\nError.prototype.description;\n\n\n/**\n * Mozilla-only.\n * @type {number}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/lineNumber\n */\nError.prototype.lineNumber;\n\n/**\n * Mozilla-only\n * @type {string}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/fileName\n */\nError.prototype.fileName;\n\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/name\n */\nError.prototype.name;\n\n/**\n * @type {string}\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/message\n */\nError.prototype.message;\n\n/**\n * Doesn\'t seem to exist, but closure/debug.js references it.\n */\nError.prototype.sourceURL;\n\n/** @type {string} */\nError.prototype.stack;\n\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!EvalError}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/EvalError\n */\nfunction EvalError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!RangeError}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RangeError\n */\nfunction RangeError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!ReferenceError}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ReferenceError\n */\nfunction ReferenceError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!SyntaxError}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SyntaxError\n */\nfunction SyntaxError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!TypeError}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypeError\n */\nfunction TypeError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!URIError}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/URIError\n */\nfunction URIError(opt_message, opt_file, opt_line) {}\n\n\n// JScript extensions.\n// @see http://msdn.microsoft.com/en-us/library/894hfyb4(VS.80).aspx\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/7sw4ddf8.aspx\n * @type {function(new:?, string, string=)}\n * @deprecated\n */\nfunction ActiveXObject(progId, opt_location) {}\n',"externs/es5.js":'/*\n * Copyright 2009 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for ECMAScript 5.\n * @see https://es5.github.io/\n * @externs\n * @author djlee@google.com (DJ Lee)\n */\n\n\n/**\n * @param {?Object|undefined} selfObj Specifies the object to which |this|\n *     should point when the function is run. If the value is null or undefined,\n *     it will default to the global object.\n * @param {...*} var_args Additional arguments that are partially\n *     applied to fn.\n * @return {!Function} A partially-applied form of the Function on which\n *     bind() was invoked as a method.\n * @nosideeffects\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Function/bind\n */\nFunction.prototype.bind = function(selfObj, var_args) {};\n\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/String/Trim\n */\nString.prototype.trim = function() {};\n\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/String/TrimLeft\n */\nString.prototype.trimLeft = function() {};\n\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/String/TrimRight\n */\nString.prototype.trimRight = function() {};\n\n\n/**\n * A object property descriptor used by Object.create, Object.defineProperty,\n * Object.defineProperties, Object.getOwnPropertyDescriptor.\n *\n * @record\n * @template THIS\n */\nfunction ObjectPropertyDescriptor() {}\n\n/** @type {(*|undefined)} */\nObjectPropertyDescriptor.prototype.value;\n\n/** @type {(function(this: THIS):?)|undefined} */\nObjectPropertyDescriptor.prototype.get;\n\n/** @type {(function(this: THIS, ?):void)|undefined} */\nObjectPropertyDescriptor.prototype.set;\n\n/** @type {boolean|undefined} */\nObjectPropertyDescriptor.prototype.writable;\n\n/** @type {boolean|undefined} */\nObjectPropertyDescriptor.prototype.enumerable;\n\n/** @type {boolean|undefined} */\nObjectPropertyDescriptor.prototype.configurable;\n\n\n/**\n * @param {?Object} proto\n * @param {?Object=} opt_properties  A map of ObjectPropertyDescriptors.\n * @return {!Object}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/create\n */\nObject.create = function(proto, opt_properties) {};\n\n\n/**\n * @param {!Object} obj\n * @param {string|symbol} prop\n * @param {!Object} descriptor A ObjectPropertyDescriptor.\n * @return {!Object}\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/defineProperty\n */\nObject.defineProperty = function(obj, prop, descriptor) {};\n\n\n/**\n * @param {!Object} obj\n * @param {!Object} props A map of ObjectPropertyDescriptors.\n * @return {!Object}\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/defineProperties\n */\nObject.defineProperties = function(obj, props) {};\n\n\n/**\n * @param {T} obj\n * @param {string|symbol} prop\n * @return {!ObjectPropertyDescriptor<T>|undefined}\n * @nosideeffects\n * @template T\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/getOwnPropertyDescriptor\n */\nObject.getOwnPropertyDescriptor = function(obj, prop) {};\n\n\n/**\n * @param {!Object} obj\n * @return {!Array<string>}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/keys\n */\nObject.keys = function(obj) {};\n\n\n/**\n * @param {!Object} obj\n * @return {!Array<string>}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/getOwnPropertyNames\n */\nObject.getOwnPropertyNames = function(obj) {};\n\n\n/**\n * @param {!Object} obj\n * @return {Object}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/GetPrototypeOf\n */\nObject.getPrototypeOf = function(obj) {};\n\n\n/**\n * @param {T} obj\n * @return {T}\n * @template T\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/preventExtensions\n */\nObject.preventExtensions = function(obj) {};\n\n\n/**\n * @param {T} obj\n * @return {T}\n * @template T\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/seal\n */\nObject.seal = function(obj) {};\n\n\n/**\n * @param {T} obj\n * @return {T}\n * @template T\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/freeze\n */\nObject.freeze = function(obj) {};\n\n\n/**\n * @param {!Object} obj\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/isExtensible\n */\nObject.isExtensible = function(obj) {};\n\n\n/**\n * @param {!Object} obj\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/isSealed\n */\nObject.isSealed = function(obj) {};\n\n\n/**\n * @param {!Object} obj\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/isFrozen\n */\nObject.isFrozen = function(obj) {};\n\n\n/**\n * We acknowledge that this function does not exist on the `Object.prototype`\n * and is declared in this file for other reasons.\n *\n * When `toJSON` is defined as a property on an object it can be used in\n * conjunction with the JSON.stringify() function.\n *\n * It is defined here to:\n * (1) Prevent the compiler from renaming the property on internal classes.\n * (2) Enforce that the signature is correct for users defining it.\n *\n * @param {string=} opt_key The JSON key for this object.\n * @return {*} The serializable representation of this object. Note that this\n *     need not be a string. See http://goo.gl/PEUvs.\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/JSON/stringify#toJSON()_behavior\n */\nObject.prototype.toJSON = function(opt_key) {};\n\n\n/**\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Date/toISOString\n * @return {string}\n */\nDate.prototype.toISOString = function() {};\n\n\n/**\n * @param {*=} opt_ignoredKey\n * @return {string}\n * @override\n */\nDate.prototype.toJSON = function(opt_ignoredKey) {};\n\n\n/**\n * A fake type to model the JSON object.\n * @constructor\n */\nfunction JSONType() {}\n\n\n/**\n * @param {string} jsonStr The string to parse.\n * @param {(function(this:?, string, *) : *)=} opt_reviver\n * @return {*} The JSON object.\n * @throws {Error}\n */\nJSONType.prototype.parse = function(jsonStr, opt_reviver) {};\n\n\n/**\n * @param {*} jsonObj Input object.\n * @param {(Array<string>|(function(this:?, string, *) : *)|null)=} opt_replacer\n * @param {(number|string)=} opt_space\n * @return {string} JSON string which represents jsonObj.\n * @throws {Error}\n */\nJSONType.prototype.stringify = function(jsonObj, opt_replacer, opt_space) {};\n\n\n/**\n * @type {!JSONType}\n * @suppress {duplicate}\n */\nvar JSON;\n',
"externs/es6.js":"/*\n * Copyright 2014 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for ECMAScript 6 and later.\n * @see https://tc39.github.io/ecma262/\n * @see https://www.khronos.org/registry/typedarray/specs/latest/\n * @externs\n */\n\n/**\n * Some es6 definitions:\n * Symbol, IIterableResult, Iterable, IteratorIterable, Iterator,\n * IteratorIterable moved to es3 file, because some base type requires them, and\n * we want to keep them together. If you add new externs related to those types\n * define them together in the es3 file.\n */\n\n/**\n * TODO(b/142881197): UNUSED_RETURN_T and UNUSED_NEXT_T are not yet used for\n * anything. https://github.com/google/closure-compiler/issues/3489\n * @interface\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Generator\n * @extends {IteratorIterable<VALUE>}\n * @template VALUE, UNUSED_RETURN_T, UNUSED_NEXT_T\n */\nfunction Generator() {}\n\n/**\n * @param {?=} opt_value\n * @return {!IIterableResult<VALUE>}\n * @override\n */\nGenerator.prototype.next = function(opt_value) {};\n\n/**\n * @param {VALUE} value\n * @return {!IIterableResult<VALUE>}\n */\nGenerator.prototype.return = function(value) {};\n\n/**\n * @param {?} exception\n * @return {!IIterableResult<VALUE>}\n */\nGenerator.prototype.throw = function(exception) {};\n\n\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.log10 = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.log2 = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.log1p = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.expm1 = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.cosh = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.sinh = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.tanh = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.acosh = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.asinh = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.atanh = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.trunc = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.sign = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n */\nMath.cbrt = function(value) {};\n\n/**\n * @param {...number} var_args\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/hypot\n */\nMath.hypot = function(var_args) {};\n\n/**\n * @param {number} value1\n * @param {number} value2\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/imul\n */\nMath.imul = function(value1, value2) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/clz32\n */\nMath.clz32 = function(value) {};\n\n/**\n * @param {number} value\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/fround\n */\nMath.fround = function(value) {};\n\n\n/**\n * @param {*} a\n * @param {*} b\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is\n */\nObject.is;\n\n\n/**\n * Returns a language-sensitive string representation of this number.\n * @param {(string|!Array<string>)=} opt_locales\n * @param {Object=} opt_options\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number/toLocaleString\n * @see http://www.ecma-international.org/ecma-402/1.0/#sec-13.2.1\n * @override\n */\nNumber.prototype.toLocaleString = function(opt_locales, opt_options) {};\n\n/**\n * Returns the wrapped primitive value of this Number object.\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/valueOf\n * @override\n */\nNumber.prototype.valueOf = function() {};\n\n\n/**\n * Pads the end of the string so that it reaches the given length.\n * NOTE: this is an ES2017 (ES8) extern.\n *\n * @param {number} targetLength The target length.\n * @param {string=} opt_padString The string to pad with.\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/padEnd\n */\nString.prototype.padEnd = function(targetLength, opt_padString) {};\n\n/**\n * Pads the start of the string so that it reaches the given length.\n * NOTE: this is an ES2017 (ES8) extern.\n *\n * @param {number} targetLength The target length.\n * @param {string=} opt_padString The string to pad with.\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/padStart\n */\nString.prototype.padStart = function(targetLength, opt_padString) {};\n\n/**\n * Repeats the string the given number of times.\n *\n * @param {number} count The number of times the string is repeated.\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/repeat\n */\nString.prototype.repeat = function(count) {};\n\n/**\n * @constructor\n * @extends {Array<string>}\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-gettemplateobject\n */\nvar ITemplateArray = function() {};\n\n/**\n * @type {!Array<string>}\n */\nITemplateArray.prototype.raw;\n\n/**\n * @param {!ITemplateArray} template\n * @param {...*} var_args Substitution values.\n * @return {string}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/raw\n */\nString.raw = function(template, var_args) {};\n\n\n/**\n * @param {number} codePoint\n * @param {...number} var_args Additional codepoints\n * @return {string}\n */\nString.fromCodePoint = function(codePoint, var_args) {};\n\n\n/**\n * @param {number} index\n * @return {number}\n * @nosideeffects\n */\nString.prototype.codePointAt = function(index) {};\n\n\n/**\n * @param {string=} opt_form\n * @return {string}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/normalize\n */\nString.prototype.normalize = function(opt_form) {};\n\n\n/**\n * @param {string} searchString\n * @param {number=} opt_position\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/startsWith\n */\nString.prototype.startsWith = function(searchString, opt_position) {};\n\n/**\n * @param {string} searchString\n * @param {number=} opt_position\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith\n */\nString.prototype.endsWith = function(searchString, opt_position) {};\n\n/**\n * @param {string} searchString\n * @param {number=} opt_position\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/includes\n */\nString.prototype.includes = function(searchString, opt_position) {};\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/trimStart\n */\nString.prototype.trimStart = function() {};\n\n\n/**\n * @this {String|string}\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/trimEnd\n */\nString.prototype.trimEnd = function() {};\n\n\n/**\n * @see http://dev.w3.org/html5/postmsg/\n * @interface\n */\nfunction Transferable() {}\n\n/**\n * @param {number} length The length in bytes\n * @constructor\n * @throws {Error}\n * @implements {Transferable}\n */\nfunction ArrayBuffer(length) {}\n\n/** @type {number} */\nArrayBuffer.prototype.byteLength;\n\n/**\n * @param {number} begin\n * @param {number=} opt_end\n * @return {!ArrayBuffer}\n * @nosideeffects\n */\nArrayBuffer.prototype.slice = function(begin, opt_end) {};\n\n/**\n * @param {*} arg\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ArrayBuffer/isView\n */\nArrayBuffer.isView = function(arg) {};\n\n\n/**\n * @constructor\n */\nfunction ArrayBufferView() {}\n\n/** @type {!ArrayBuffer} */\nArrayBufferView.prototype.buffer;\n\n/** @type {number} */\nArrayBufferView.prototype.byteOffset;\n\n/** @type {number} */\nArrayBufferView.prototype.byteLength;\n\n\n/**\n * @param {number} length The length in bytes\n * @constructor\n * @throws {Error}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SharedArrayBuffer\n */\nfunction SharedArrayBuffer(length) {}\n\n/** @type {number} */\nSharedArrayBuffer.prototype.byteLength;\n\n/**\n * @param {number} begin\n * @param {number=} opt_end\n * @return {!SharedArrayBuffer}\n * @nosideeffects\n */\nSharedArrayBuffer.prototype.slice = function(begin, opt_end) {};\n\n\n/**\n * @typedef {!ArrayBuffer|!ArrayBufferView}\n */\nvar BufferSource;\n\n\n/**\n * @constructor\n * @implements {IArrayLike<number>}\n * @implements {Iterable<number>}\n * @extends {ArrayBufferView}\n */\nfunction TypedArray() {};\n\n/** @const {number} */\nTypedArray.prototype.BYTES_PER_ELEMENT;\n\n/**\n * @param {number} target\n * @param {number} start\n * @param {number=} opt_end\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/copyWithin\n */\nTypedArray.prototype.copyWithin = function(target, start, opt_end) {};\n\n/**\n * @return {!IteratorIterable<!Array<number>>}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/entries\n */\nTypedArray.prototype.entries = function() {};\n\n/**\n * @param {function(this:S, number, number, !TypedArray) : ?} callback\n * @param {S=} opt_thisArg\n * @return {boolean}\n * @template S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/every\n */\nTypedArray.prototype.every = function(callback, opt_thisArg) {};\n\n/**\n * @param {number} value\n * @param {number=} opt_begin\n * @param {number=} opt_end\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/fill\n */\nTypedArray.prototype.fill = function(value, opt_begin, opt_end) {};\n\n/**\n * @param {function(this:S, number, number, !TypedArray) : boolean} callback\n * @param {S=} opt_thisArg\n * @return {THIS}\n * @this {THIS}\n * @template THIS,S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/filter\n */\nTypedArray.prototype.filter = function(callback, opt_thisArg) {};\n\n/**\n * @param {function(this:S, number, number, !TypedArray) : boolean} callback\n * @param {S=} opt_thisArg\n * @return {(number|undefined)}\n * @template S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/find\n */\nTypedArray.prototype.find = function(callback, opt_thisArg) {};\n\n/**\n * @param {function(this:S, number, number, !TypedArray) : boolean} callback\n * @param {S=} opt_thisArg\n * @return {number}\n * @template S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/findIndex\n */\nTypedArray.prototype.findIndex = function(callback, opt_thisArg) {};\n\n/**\n * @param {function(this:S, number, number, !TypedArray) : ?} callback\n * @param {S=} opt_thisArg\n * @return {undefined}\n * @template S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/forEach\n */\nTypedArray.prototype.forEach = function(callback, opt_thisArg) {};\n\n/**\n * NOTE: this is an ES2016 (ES7) extern.\n * @param {number} searchElement\n * @param {number=} opt_fromIndex\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/includes\n */\nTypedArray.prototype.includes = function(searchElement, opt_fromIndex) {};\n\n/**\n * @param {number} searchElement\n * @param {number=} opt_fromIndex\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/indexOf\n */\nTypedArray.prototype.indexOf = function(searchElement, opt_fromIndex) {};\n\n/**\n * @param {string=} opt_separator\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/join\n */\nTypedArray.prototype.join = function(opt_separator) {};\n\n/**\n * @return {!IteratorIterable<number>}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/keys\n */\nTypedArray.prototype.keys = function() {};\n\n/**\n * @param {number} searchElement\n * @param {number=} opt_fromIndex\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/lastIndexOf\n */\nTypedArray.prototype.lastIndexOf = function(searchElement, opt_fromIndex) {};\n\n/** @type {number} */\nTypedArray.prototype.length;\n\n/**\n * @param {function(this:S, number, number, !TypedArray) : number} callback\n * @param {S=} opt_thisArg\n * @return {THIS}\n * @this {THIS}\n * @template THIS,S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/map\n */\nTypedArray.prototype.map = function(callback, opt_thisArg) {};\n\n/**\n * @param {function((number|INIT|RET), number, number, !TypedArray) : RET} callback\n * @param {INIT=} opt_initialValue\n * @return {RET}\n * @template INIT,RET\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/reduce\n */\nTypedArray.prototype.reduce = function(callback, opt_initialValue) {};\n\n/**\n * @param {function((number|INIT|RET), number, number, !TypedArray) : RET} callback\n * @param {INIT=} opt_initialValue\n * @return {RET}\n * @template INIT,RET\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/reduceRight\n */\nTypedArray.prototype.reduceRight = function(callback, opt_initialValue) {};\n\n/**\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/reverse\n */\nTypedArray.prototype.reverse = function() {};\n\n/**\n * @param {!ArrayBufferView|!Array<number>} array\n * @param {number=} opt_offset\n * @return {undefined}\n * @throws {!RangeError}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/set\n */\nTypedArray.prototype.set = function(array, opt_offset) {};\n\n/**\n * @param {number=} opt_begin\n * @param {number=} opt_end\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/slice\n */\nTypedArray.prototype.slice = function(opt_begin, opt_end) {};\n\n/**\n * @param {function(this:S, number, number, !TypedArray) : boolean} callback\n * @param {S=} opt_thisArg\n * @return {boolean}\n * @template S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/some\n */\nTypedArray.prototype.some = function(callback, opt_thisArg) {};\n\n/**\n * @param {(function(number, number) : number)=} opt_compareFunction\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/sort\n */\nTypedArray.prototype.sort = function(opt_compareFunction) {};\n\n/**\n * @param {number} begin\n * @param {number=} opt_end\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/subarray\n */\nTypedArray.prototype.subarray = function(begin, opt_end) {};\n\n/**\n * @return {!IteratorIterable<number>}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/values\n */\nTypedArray.prototype.values = function() {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/toLocaleString\n * @override\n */\nTypedArray.prototype.toLocaleString = function() {};\n\n/**\n * @return {string}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/toString\n * @override\n */\nTypedArray.prototype.toString = function() {};\n\n/** @override */\nTypedArray.prototype[Symbol.iterator] = function() {};\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments} If the user passes a backing array, then indexed\n *     accesses will modify the backing array. JSCompiler does not model\n *     this well. In other words, if you have:\n *     <code>\n *     var x = new ArrayBuffer(1);\n *     var y = new Int8Array(x);\n *     y[0] = 2;\n *     </code>\n *     JSCompiler will not recognize that the last assignment modifies x.\n *     We workaround this by marking all these arrays as @modifies {arguments},\n *     to introduce the possibility that x aliases y.\n */\nfunction Int8Array(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nInt8Array.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Int8Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nInt8Array.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Int8Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nInt8Array.of = function(var_args) {};\n\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments}\n */\nfunction Uint8Array(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nUint8Array.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Uint8Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nUint8Array.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Uint8Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nUint8Array.of = function(var_args) {};\n\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments}\n */\nfunction Uint8ClampedArray(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nUint8ClampedArray.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Uint8ClampedArray}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nUint8ClampedArray.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Uint8ClampedArray}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nUint8ClampedArray.of = function(var_args) {};\n\n\n/**\n * @typedef {Uint8ClampedArray}\n * @deprecated CanvasPixelArray has been replaced by Uint8ClampedArray\n *     in the latest spec.\n * @see http://www.w3.org/TR/2dcontext/#imagedata\n */\nvar CanvasPixelArray;\n\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments}\n */\nfunction Int16Array(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nInt16Array.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Int16Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nInt16Array.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Int16Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nInt16Array.of = function(var_args) {};\n\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments}\n */\nfunction Uint16Array(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nUint16Array.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Uint16Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nUint16Array.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Uint16Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nUint16Array.of = function(var_args) {};\n\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments}\n */\nfunction Int32Array(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nInt32Array.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Int32Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nInt32Array.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Int32Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nInt32Array.of = function(var_args) {};\n\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments}\n */\nfunction Uint32Array(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nUint32Array.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Uint32Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nUint32Array.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Uint32Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nUint32Array.of = function(var_args) {};\n\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments}\n */\nfunction Float32Array(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nFloat32Array.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Float32Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nFloat32Array.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Float32Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nFloat32Array.of = function(var_args) {};\n\n\n/**\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\n *     length or array or buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_length\n * @constructor\n * @extends {TypedArray}\n * @throws {Error}\n * @modifies {arguments}\n */\nfunction Float64Array(length, opt_byteOffset, opt_length) {}\n\n/** @const {number} */\nFloat64Array.BYTES_PER_ELEMENT;\n\n/**\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\n * @param {function(this:S, number): number=} opt_mapFn\n * @param {S=} opt_this\n * @template S\n * @return {!Float64Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\n */\nFloat64Array.from = function(source, opt_mapFn, opt_this) {};\n\n/**\n * @param {...number} var_args\n * @return {!Float64Array}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\n */\nFloat64Array.of = function(var_args) {};\n\n\n/**\n * @param {ArrayBuffer|SharedArrayBuffer} buffer\n * @param {number=} opt_byteOffset\n * @param {number=} opt_byteLength\n * @constructor\n * @extends {ArrayBufferView}\n * @throws {Error}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Typed_arrays/DataView\n */\nfunction DataView(buffer, opt_byteOffset, opt_byteLength) {}\n\n/**\n * @param {number} byteOffset\n * @return {number}\n * @throws {Error}\n */\nDataView.prototype.getInt8 = function(byteOffset) {};\n\n/**\n * @param {number} byteOffset\n * @return {number}\n * @throws {Error}\n */\nDataView.prototype.getUint8 = function(byteOffset) {};\n\n/**\n * @param {number} byteOffset\n * @param {boolean=} opt_littleEndian\n * @return {number}\n * @throws {Error}\n */\nDataView.prototype.getInt16 = function(byteOffset, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {boolean=} opt_littleEndian\n * @return {number}\n * @throws {Error}\n */\nDataView.prototype.getUint16 = function(byteOffset, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {boolean=} opt_littleEndian\n * @return {number}\n * @throws {Error}\n */\nDataView.prototype.getInt32 = function(byteOffset, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {boolean=} opt_littleEndian\n * @return {number}\n * @throws {Error}\n */\nDataView.prototype.getUint32 = function(byteOffset, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {boolean=} opt_littleEndian\n * @return {number}\n * @throws {Error}\n */\nDataView.prototype.getFloat32 = function(byteOffset, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {boolean=} opt_littleEndian\n * @return {number}\n * @throws {Error}\n */\nDataView.prototype.getFloat64 = function(byteOffset, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {number} value\n * @throws {Error}\n * @return {undefined}\n */\nDataView.prototype.setInt8 = function(byteOffset, value) {};\n\n/**\n * @param {number} byteOffset\n * @param {number} value\n * @throws {Error}\n * @return {undefined}\n */\nDataView.prototype.setUint8 = function(byteOffset, value) {};\n\n/**\n * @param {number} byteOffset\n * @param {number} value\n * @param {boolean=} opt_littleEndian\n * @throws {Error}\n * @return {undefined}\n */\nDataView.prototype.setInt16 = function(byteOffset, value, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {number} value\n * @param {boolean=} opt_littleEndian\n * @throws {Error}\n * @return {undefined}\n */\nDataView.prototype.setUint16 = function(byteOffset, value, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {number} value\n * @param {boolean=} opt_littleEndian\n * @throws {Error}\n * @return {undefined}\n */\nDataView.prototype.setInt32 = function(byteOffset, value, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {number} value\n * @param {boolean=} opt_littleEndian\n * @throws {Error}\n * @return {undefined}\n */\nDataView.prototype.setUint32 = function(byteOffset, value, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {number} value\n * @param {boolean=} opt_littleEndian\n * @throws {Error}\n * @return {undefined}\n */\nDataView.prototype.setFloat32 = function(\n    byteOffset, value, opt_littleEndian) {};\n\n/**\n * @param {number} byteOffset\n * @param {number} value\n * @param {boolean=} opt_littleEndian\n * @throws {Error}\n * @return {undefined}\n */\nDataView.prototype.setFloat64 = function(\n    byteOffset, value, opt_littleEndian) {};\n\n\n/**\n * @see https://github.com/promises-aplus/promises-spec\n * @typedef {{then: ?}}\n */\nvar Thenable;\n\n\n/**\n * This is not an official DOM interface. It is used to add generic typing\n * and respective type inference where available.\n * {@see goog.Thenable} inherits from this making all promises\n * interoperate.\n * @interface\n * @struct\n * @template TYPE\n */\nfunction IThenable() {}\n\n\n/**\n * @param {?(function(TYPE):VALUE)=} opt_onFulfilled\n * @param {?(function(*): *)=} opt_onRejected\n * @return {RESULT}\n * @template VALUE\n *\n * When a `Thenable` is fulfilled or rejected with another `Thenable`, the\n * payload of the second is used as the payload of the first.\n *\n * @template RESULT := type('IThenable',\n *     cond(isUnknown(VALUE), unknown(),\n *       mapunion(VALUE, (V) =>\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\n *           templateTypeOf(V, 0),\n *           cond(sub(V, 'Thenable'),\n *              unknown(),\n *              V)))))\n * =:\n */\nIThenable.prototype.then = function(opt_onFulfilled, opt_onRejected) {};\n\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise\n * @param {function(\n *             function((TYPE|IThenable<TYPE>|Thenable|null)=),\n *             function(*=))} resolver\n * @constructor\n * @implements {IThenable<TYPE>}\n * @template TYPE\n */\nfunction Promise(resolver) {}\n\n\n/**\n * @param {VALUE=} opt_value\n * @return {RESULT}\n * @template VALUE\n * @template RESULT := type('Promise',\n *     cond(isUnknown(VALUE), unknown(),\n *       mapunion(VALUE, (V) =>\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\n *           templateTypeOf(V, 0),\n *           cond(sub(V, 'Thenable'),\n *              unknown(),\n *              V)))))\n * =:\n */\nPromise.resolve = function(opt_value) {};\n\n\n/**\n * @param {*=} opt_error\n * @return {!Promise<?>}\n */\nPromise.reject = function(opt_error) {};\n\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise\n * @param {!Iterable<VALUE>} iterable\n * @return {!Promise<!Array<RESULT>>}\n * @template VALUE\n * @template RESULT := mapunion(VALUE, (V) =>\n *     cond(isUnknown(V),\n *         unknown(),\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\n *             templateTypeOf(V, 0),\n *             cond(sub(V, 'Thenable'), unknown(), V))))\n * =:\n */\nPromise.all = function(iterable) {};\n\n/**\n * Record type representing a single element of the array value one gets from\n * Promise.allSettled.\n *\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/allSettled\n * @record\n * @template VALUE\n */\nPromise.AllSettledResultElement = function() {};\n\n/**\n * 'fulfilled' or 'rejected' to indicate the final state of the corresponding\n * Promise.\n * @type {string}\n */\nPromise.AllSettledResultElement.prototype.status;\n\n/**\n * Exists only if the status field is 'fulfilled'\n * @type {VALUE|undefined}\n */\nPromise.AllSettledResultElement.prototype.value;\n\n/**\n * Exists only if the status field is 'rejected'\n * @type {*|undefined}\n */\nPromise.AllSettledResultElement.prototype.reason;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/allSettled\n * @param {!Iterable<VALUE>} iterable\n * @return {!Promise<!Array<!Promise.AllSettledResultElement<RESULT>>>}\n * @template VALUE\n * @template RESULT := mapunion(VALUE, (V) =>\n *     cond(isUnknown(V),\n *         unknown(),\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\n *             templateTypeOf(V, 0),\n *             cond(sub(V, 'Thenable'), unknown(), V))))\n * =:\n */\nPromise.allSettled = function(iterable) {};\n\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise\n * @param {!Iterable<VALUE>} iterable\n * @return {!Promise<RESULT>}\n * @template VALUE\n * @template RESULT := mapunion(VALUE, (V) =>\n *     cond(isUnknown(V),\n *         unknown(),\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\n *             templateTypeOf(V, 0),\n *             cond(sub(V, 'Thenable'), unknown(), V))))\n * =:\n */\nPromise.race = function(iterable) {};\n\n\n/**\n * @param {?(function(this:void, TYPE):VALUE)=} opt_onFulfilled\n * @param {?(function(this:void, *): *)=} opt_onRejected\n * @return {RESULT}\n * @template VALUE\n *\n * When a `Thenable` is fulfilled or rejected with another `Thenable`, the\n * payload of the second is used as the payload of the first.\n *\n * @template RESULT := type('Promise',\n *     cond(isUnknown(VALUE), unknown(),\n *       mapunion(VALUE, (V) =>\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\n *           templateTypeOf(V, 0),\n *           cond(sub(V, 'Thenable'),\n *              unknown(),\n *              V)))))\n * =:\n * @override\n */\nPromise.prototype.then = function(opt_onFulfilled, opt_onRejected) {};\n\n\n/**\n * @param {function(*):VALUE} onRejected\n * @return {!Promise<TYPE|RESULT>} A Promise of the original type or a possibly\n *     a different type depending on whether the parent promise was rejected.\n *\n * @template VALUE\n *\n * When a `Thenable` is rejected with another `Thenable`, the payload of the\n * second is used as the payload of the first.\n *\n * @template RESULT := cond(\n *     isUnknown(VALUE),\n *     unknown(),\n *     mapunion(VALUE, (V) =>\n *         cond(\n *             isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\n *             templateTypeOf(V, 0),\n *             cond(\n *                 sub(V, 'Thenable'),\n *                 unknown(),\n *                 V))))\n * =:\n */\nPromise.prototype.catch = function(onRejected) {};\n\n\n/**\n * @param {function()} callback\n * @return {!Promise<TYPE>}\n */\nPromise.prototype.finally = function(callback) {};\n\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/of\n * @param {...T} var_args\n * @return {!Array<T>}\n * @template T\n */\nArray.of = function(var_args) {};\n\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from\n * @param {string|!IArrayLike<T>|!Iterable<T>} arrayLike\n * @param {function(this:S, (string|T), number): R=} opt_mapFn\n * @param {S=} opt_this\n * @return {!Array<R>}\n * @template T,S,R\n */\nArray.from = function(arrayLike, opt_mapFn, opt_this) {};\n\n\n/** @return {!IteratorIterable<number>} */\nArray.prototype.keys;\n\n\n/**\n * @return {!IteratorIterable<T>}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/values\n */\nArray.prototype.values;\n\n\n/**\n * @return {!IteratorIterable<!Array<number|T>>} Iterator of [key, value] pairs.\n */\nArray.prototype.entries;\n\n\n/**\n * @param {function(this:S, T, number, !Array<T>): boolean} predicateFn\n * @param {S=} opt_this\n * @return {T|undefined}\n * @this {IArrayLike<T>|string}\n * @template T,S\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.find\n */\nArray.prototype.find = function(predicateFn, opt_this) {};\n\n\n/**\n * @param {function(this:S, T, number, !Array<T>): boolean} predicateFn\n * @param {S=} opt_this\n * @return {number}\n * @this {IArrayLike<T>|string}\n * @template T,S\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.findindex\n */\nArray.prototype.findIndex = function(predicateFn, opt_this) {};\n\n\n/**\n * @param {T} value\n * @param {number=} opt_begin\n * @param {number=} opt_end\n * @return {!Array<T>}\n * @this {!IArrayLike<T>|string}\n * @template T\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.fill\n */\nArray.prototype.fill = function(value, opt_begin, opt_end) {};\n\n\n/**\n * @param {number} target\n * @param {number} start\n * @param {number=} opt_end\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.copywithin\n * @this {!IArrayLike<T>|string}\n * @template T\n * @return {!Array<T>}\n */\nArray.prototype.copyWithin = function(target, start, opt_end) {};\n\n\n/**\n * NOTE: this is an ES2016 (ES7) extern.\n * @param {T} searchElement\n * @param {number=} opt_fromIndex\n * @return {boolean}\n * @this {!IArrayLike<T>|string}\n * @template T\n * @nosideeffects\n * @see https://tc39.github.io/ecma262/#sec-array.prototype.includes\n */\nArray.prototype.includes = function(searchElement, opt_fromIndex) {};\n\n/**\n * Generates an array by passing every element of this array to a callback that\n * returns an array of zero or more elements to be added to the result.\n *\n * NOTE: The specified behavior of the method is that the callback can return\n * either an Array, which will be flattened into the result, or a non-array,\n * which will simply be included.\n *\n * However, while defining that in the type information here is possible it's\n * very hard to understand both for humans and automated tools other than\n * closure-compiler that process these files. Also, we think it's best to\n * encourage writing callbacks that just always return an Array for the sake\n * of readability.\n *\n * The polyfill for this method provided by closure-compiler does behave as\n * defined in the specification, though.\n *\n * @param {function(this: THIS, T, number, !IArrayLike<T>): !Array<S>}\n *     callback\n * @param {THIS=} thisArg\n * @return {!Array<S>}\n * @this {!IArrayLike<T>}\n * @template T, THIS, S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/flatMap\n */\nArray.prototype.flatMap = function(callback, thisArg) {};\n\n/**\n * @param {number=} depth\n * @return {!Array<S>}\n * @this {!IArrayLike<T>}\n * @template T, S\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/flat\n */\nArray.prototype.flat = function(depth) {};\n\n/**\n * @param {!Object} obj\n * @return {!Array<symbol>}\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-object.getownpropertysymbols\n */\nObject.getOwnPropertySymbols = function(obj) {};\n\n\n/**\n * @param {!Object} obj\n * @param {?} proto\n * @return {!Object}\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-object.setprototypeof\n */\nObject.setPrototypeOf = function(obj, proto) {};\n\n\n/**\n * @const {number}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/EPSILON\n */\nNumber.EPSILON;\n\n/**\n * @const {number}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MIN_SAFE_INTEGER\n */\nNumber.MIN_SAFE_INTEGER;\n\n/**\n * @const {number}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MAX_SAFE_INTEGER\n */\nNumber.MAX_SAFE_INTEGER;\n\n\n\n/**\n * Parse an integer. Use of `parseInt` without `base` is strictly\n * banned in Google. If you really want to parse octal or hex based on the\n * leader, then pass `undefined` as the base.\n *\n * @param {string} string\n * @param {number|undefined} radix\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/parseInt\n */\nNumber.parseInt = function(string, radix) {};\n\n/**\n * @param {string} string\n * @return {number}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/parseFloat\n */\nNumber.parseFloat = function(string) {};\n\n/**\n * @param {number} value\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isNaN\n */\nNumber.isNaN = function(value) {};\n\n/**\n * @param {number} value\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isFinite\n */\nNumber.isFinite = function(value) {};\n\n/**\n * @param {number} value\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isInteger\n */\nNumber.isInteger = function(value) {};\n\n/**\n * @param {number} value\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isSafeInteger\n */\nNumber.isSafeInteger = function(value) {};\n\n\n\n/**\n * @param {!Object} target\n * @param {...(Object|null|undefined)} var_args\n * @return {!Object}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign\n */\nObject.assign = function(target, var_args) {};\n\n/**\n * TODO(dbeam): find a better place for ES2017 externs like this one.\n * NOTE: this is an ES2017 (ES8) extern.\n * @param {!Object<T>} obj\n * @return {!Array<T>} values\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/values\n * @throws {Error}\n * @template T\n */\nObject.values = function(obj) {};\n\n/**\n * NOTE: this is an ES2017 (ES8) extern.\n * @param {!Object<T>} obj\n * @return {!Array<!Array<(string|T)>>} entries\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/entries\n * @throws {Error}\n * @template T\n */\nObject.entries = function(obj) {};\n\n/**\n * @param {!Iterable<*>} iter\n * @return {!Object}\n * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/fromEntries\n */\nObject.fromEntries = function(iter) {};\n\n/**\n * NOTE: this is an ES2017 (ES8) extern.\n * @param {!Object} obj\n * @return {!Object<!ObjectPropertyDescriptor>} descriptors\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/getOwnPropertyDescriptors\n * @throws {Error}\n * @template T\n */\nObject.getOwnPropertyDescriptors = function(obj) {};\n\n\n\n/**\n * @const\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect\n */\nvar Reflect = {};\n\n/**\n * @param {function(this: THIS, ...?): RESULT} targetFn\n * @param {THIS} thisArg\n * @param {!Array<?>} argList\n * @return {RESULT}\n * @template THIS, RESULT\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/apply\n */\nReflect.apply = function(targetFn, thisArg, argList) {};\n\n/**\n * @param {function(new: ?, ...?)} targetConstructorFn\n * @param {!Array<?>} argList\n * @param {function(new: TARGET, ...?)=} opt_newTargetConstructorFn\n * @return {TARGET}\n * @template TARGET\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/construct\n */\nReflect.construct = function(targetConstructorFn, argList, opt_newTargetConstructorFn) {};\n\n/**\n * @param {!Object} target\n * @param {string} propertyKey\n * @param {!ObjectPropertyDescriptor} attributes\n * @return {boolean}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/defineProperty\n */\nReflect.defineProperty = function(target, propertyKey, attributes) {};\n\n/**\n * @param {!Object} target\n * @param {string} propertyKey\n * @return {boolean}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/deleteProperty\n */\nReflect.deleteProperty = function(target, propertyKey) {};\n\n/**\n * @param {!Object} target\n * @param {string} propertyKey\n * @param {!Object=} opt_receiver\n * @return {*}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/get\n */\nReflect.get = function(target, propertyKey, opt_receiver) {};\n\n/**\n * @param {!Object} target\n * @param {string} propertyKey\n * @return {?ObjectPropertyDescriptor}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/getOwnPropertyDescriptor\n */\nReflect.getOwnPropertyDescriptor = function(target, propertyKey) {};\n\n/**\n * @param {!Object} target\n * @return {?Object}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/getPrototypeOf\n */\nReflect.getPrototypeOf = function(target) {};\n\n/**\n * @param {!Object} target\n * @param {string} propertyKey\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/has\n */\nReflect.has = function(target, propertyKey) {};\n\n/**\n * @param {!Object} target\n * @return {boolean}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/isExtensible\n */\nReflect.isExtensible = function(target) {};\n\n/**\n * @param {!Object} target\n * @return {!Array<(string|symbol)>}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/ownKeys\n */\nReflect.ownKeys = function(target) {};\n\n/**\n * @param {!Object} target\n * @return {boolean}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/preventExtensions\n */\nReflect.preventExtensions = function(target) {};\n\n/**\n * @param {!Object} target\n * @param {string} propertyKey\n * @param {*} value\n * @param {!Object=} opt_receiver\n * @return {boolean}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/set\n */\nReflect.set = function(target, propertyKey, value, opt_receiver) {};\n\n/**\n * @param {!Object} target\n * @param {?Object} proto\n * @return {boolean}\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/setPrototypeOf\n */\nReflect.setPrototypeOf = function(target, proto) {};\n\n\n/**\n * @const\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Atomics\n */\nvar Atomics = {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @param {number} value\n * @return {number}\n */\nAtomics.add = function(typedArray, index, value) {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @param {number} value\n * @return {number}\n */\nAtomics.and = function(typedArray, index, value) {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @param {number} expectedValue\n * @param {number} replacementValue\n * @return {number}\n */\nAtomics.compareExchange = function(\n    typedArray, index, expectedValue, replacementValue) {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @param {number} value\n * @return {number}\n */\nAtomics.exchange = function(typedArray, index, value) {};\n\n/**\n * @param {number} size\n * @return {boolean}\n */\nAtomics.isLockFree = function(size) {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @return {number}\n */\nAtomics.load = function(typedArray, index) {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @param {number} value\n * @return {number}\n */\nAtomics.or = function(typedArray, index, value) {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @param {number} value\n * @return {number}\n */\nAtomics.store = function(typedArray, index, value) {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @param {number} value\n * @return {number}\n */\nAtomics.sub = function(typedArray, index, value) {};\n\n/**\n * @param {!Int32Array} typedArray\n * @param {number} index\n * @param {number} value\n * @param {number=} timeout\n * @return {String}\n */\nAtomics.wait = function(typedArray, index, value, timeout) {};\n\n/**\n * @param {!Int32Array} typedArray\n * @param {number} index\n * @param {number} count\n * @return {number}\n */\nAtomics.wake = function(typedArray, index, count) {};\n\n/**\n * @param {!TypedArray} typedArray\n * @param {number} index\n * @param {number} value\n * @return {number}\n */\nAtomics.xor = function(typedArray, index, value) {};\n\n\n/**\n * TODO(b/142881197): UNUSED_RETURN_T and UNUSED_NEXT_T are not yet used for\n * anything.\n * https://github.com/google/closure-compiler/issues/3489\n * @interface\n * @template VALUE, UNUSED_RETURN_T, UNUSED_NEXT_T\n * @see https://tc39.github.io/proposal-async-iteration/\n */\nfunction AsyncIterator() {}\n\n/**\n * @param {?=} opt_value\n * @return {!Promise<!IIterableResult<VALUE>>}\n */\nAsyncIterator.prototype.next;\n\n\n/**\n * @interface\n * @template VALUE\n */\nfunction AsyncIterable() {}\n\n\n/**\n * @return {!AsyncIterator<VALUE>}\n */\nAsyncIterable.prototype[Symbol.asyncIterator] = function() {};\n\n\n/**\n * @interface\n * @extends {AsyncIterator<VALUE>}\n * @extends {AsyncIterable<VALUE>}\n * @template VALUE\n * @see https://tc39.github.io/proposal-async-iteration/\n */\nfunction AsyncIteratorIterable() {}\n\n/**\n * @interface\n * @see https://tc39.github.io/proposal-async-iteration/\n * @extends {AsyncIteratorIterable<VALUE>}\n * @template VALUE\n */\nfunction AsyncGenerator() {}\n\n/**\n * @param {?=} opt_value\n * @return {!Promise<!IIterableResult<VALUE>>}\n * @override\n */\nAsyncGenerator.prototype.next = function(opt_value) {};\n\n/**\n * @param {VALUE} value\n * @return {!Promise<!IIterableResult<VALUE>>}\n */\nAsyncGenerator.prototype.return = function(value) {};\n\n/**\n * @param {?} exception\n * @return {!Promise<!IIterableResult<VALUE>>}\n */\nAsyncGenerator.prototype.throw = function(exception) {};\n",
"externs/es6_collections.js":'/*\n * Copyright 2014 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for ECMAScript 6.\n * @see http://wiki.ecmascript.org/doku.php?id=harmony:specification_drafts\n * @externs\n */\n\n// TODO(johnlenz): Use Tuples for the Map and Set iterators where appropriate.\n\n/**\n * @constructor @struct\n * @param {Iterable<!Array<KEY|VALUE>>|!Array<!Array<KEY|VALUE>>=} opt_iterable\n * @implements {Iterable<!Array<KEY|VALUE>>}\n * @template KEY, VALUE\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map\n */\nfunction Map(opt_iterable) {}\n\n/** @return {void} */\nMap.prototype.clear = function() {};\n\n/**\n * @param {KEY} key\n * @return {boolean}\n */\nMap.prototype.delete = function(key) {};\n\n/**\n * @return {!IteratorIterable<!Array<KEY|VALUE>>}\n * @nosideeffects\n */\nMap.prototype.entries = function() {};\n\n/**\n * @param {function(this:THIS, VALUE, KEY, MAP)} callback\n * @param {THIS=} opt_thisArg\n * @this {MAP}\n * @template MAP,THIS\n */\nMap.prototype.forEach = function(callback, opt_thisArg) {};\n\n/**\n * @param {KEY} key\n * @return {VALUE}\n * @nosideeffects\n */\nMap.prototype.get = function(key) {};\n\n/**\n * @param {KEY} key\n * @return {boolean}\n * @nosideeffects\n */\nMap.prototype.has = function(key) {};\n\n/**\n * @return {!IteratorIterable<KEY>}\n * @nosideeffects\n */\nMap.prototype.keys = function() {};\n\n/**\n * @param {KEY} key\n * @param {VALUE} value\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n */\nMap.prototype.set = function(key, value) {};\n\n/**\n * @type {number}\n * (readonly)\n */\nMap.prototype.size;\n\n/**\n * @return {!IteratorIterable<VALUE>}\n * @nosideeffects\n */\nMap.prototype.values = function() {};\n\n/**\n * @return {!Iterator<!Array<KEY|VALUE>>}\n */\nMap.prototype[Symbol.iterator] = function() {};\n\n\n/**\n * @constructor @struct\n * @param {Iterable<!Array<KEY|VALUE>>|!Array<!Array<KEY|VALUE>>=} opt_iterable\n * @template KEY, VALUE\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakMap\n */\nfunction WeakMap(opt_iterable) {}\n\n/** @return {void} */\nWeakMap.prototype.clear = function() {};\n\n/**\n * @param {KEY} key\n * @return {boolean}\n */\nWeakMap.prototype.delete = function(key) {};\n\n/**\n * @param {KEY} key\n * @return {VALUE}\n * @nosideeffects\n */\nWeakMap.prototype.get = function(key) {};\n\n/**\n * @param {KEY} key\n * @return {boolean}\n * @nosideeffects\n */\nWeakMap.prototype.has = function(key) {};\n\n/**\n * @param {KEY} key\n * @param {VALUE} value\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n */\nWeakMap.prototype.set = function(key, value) {};\n\n/**\n * @constructor @struct\n * @param {Iterable<VALUE>|Array<VALUE>=} opt_iterable\n * @implements {Iterable<VALUE>}\n * @template VALUE\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Set\n */\nfunction Set(opt_iterable) {}\n\n/**\n * @param {VALUE} value\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n */\nSet.prototype.add = function(value) {};\n\n/**\n * @return {void}\n */\nSet.prototype.clear = function() {};\n\n/**\n * @param {VALUE} value\n * @return {boolean}\n */\nSet.prototype.delete = function(value) {};\n\n/**\n * @return {!IteratorIterable<!Array<VALUE>>} Where each array has two entries:\n *     [value, value]\n * @nosideeffects\n */\nSet.prototype.entries = function() {};\n\n/**\n * @param {function(this: THIS, VALUE, VALUE, SET)} callback\n * @param {THIS=} opt_thisArg\n * @this {SET}\n * @template SET,THIS\n */\nSet.prototype.forEach = function(callback, opt_thisArg) {};\n\n/**\n * @param {VALUE} value\n * @return {boolean}\n * @nosideeffects\n */\nSet.prototype.has = function(value) {};\n\n/**\n * @type {number} (readonly)\n */\nSet.prototype.size;\n\n/**\n * @return {!IteratorIterable<VALUE>}\n * @nosideeffects\n */\nSet.prototype.keys = function() {};\n\n/**\n * @return {!IteratorIterable<VALUE>}\n * @nosideeffects\n */\nSet.prototype.values = function() {};\n\n/**\n * @return {!Iterator<VALUE>}\n */\nSet.prototype[Symbol.iterator] = function() {};\n\n\n\n/**\n * @constructor @struct\n * @param {Iterable<VALUE>|Array<VALUE>=} opt_iterable\n * @template VALUE\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Set\n */\nfunction WeakSet(opt_iterable) {}\n\n/**\n * @param {VALUE} value\n * @return {THIS}\n * @this {THIS}\n * @template THIS\n */\nWeakSet.prototype.add = function(value) {};\n\n/**\n * @return {void}\n */\nWeakSet.prototype.clear = function() {};\n\n/**\n * @param {VALUE} value\n * @return {boolean}\n */\nWeakSet.prototype.delete = function(value) {};\n\n/**\n * @param {VALUE} value\n * @return {boolean}\n * @nosideeffects\n */\nWeakSet.prototype.has = function(value) {};\n',
"externs/intl.js":'/*\n * Copyright 2013 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for the JS Internationalization API as defined in\n * http://www.ecma-international.org/ecma-402/1.0/\n *\n * @externs\n */\n\n/** @const */\nvar Intl = {};\n\n/**\n * NOTE: this API is not from ecma402 and is subject to change.\n * @param {string|Array<string>=} opt_locales\n * @param {{type: (string|undefined)}=}\n *         opt_options\n * @constructor\n */\nIntl.v8BreakIterator = function(opt_locales, opt_options) {};\n\n/**\n * @param {string} text\n * @return {undefined}\n */\nIntl.v8BreakIterator.prototype.adoptText = function(text) {};\n\n/**\n * @return {string}\n */\nIntl.v8BreakIterator.prototype.breakType = function() {};\n\n/**\n * @return {number}\n */\nIntl.v8BreakIterator.prototype.current = function() {};\n\n/**\n * @return {number}\n */\nIntl.v8BreakIterator.prototype.first = function() {};\n\n/**\n * @return {number}\n */\nIntl.v8BreakIterator.prototype.next = function() {};\n\n/**\n * @constructor\n * @param {string|Array<string>=} opt_locales\n * @param {{usage: (string|undefined), localeMatcher: (string|undefined),\n *     sensitivity: (string|undefined), ignorePunctuation: (boolean|undefined),\n *     numeric: (boolean|undefined), caseFirst: (string|undefined)}=}\n *         opt_options\n */\nIntl.Collator = function(opt_locales, opt_options) {};\n\n/**\n * @param {Array<string>} locales\n * @param {{localeMatcher: (string|undefined)}=} opt_options\n * @return {Array<string>}\n */\nIntl.Collator.supportedLocalesOf = function(locales, opt_options) {};\n\n/**\n * @param {string} arg1\n * @param {string} arg2\n * @return {number}\n */\nIntl.Collator.prototype.compare = function(arg1, arg2) {};\n\n/**\n * @return {{locale: string, usage: string, sensitivity: string,\n *     ignorePunctuation: boolean, collation: string, numeric: boolean,\n *     caseFirst: string}}\n */\nIntl.Collator.prototype.resolvedOptions = function() {};\n\n/**\n * @constructor\n * @param {string|Array<string>=} opt_locales\n * @param {{localeMatcher: (string|undefined), useGrouping: (boolean|undefined),\n *     numberingSystem: (string|undefined), style: (string|undefined),\n *     currency: (string|undefined), currencyDisplay: (string|undefined),\n *     minimumIntegerDigits: (number|undefined),\n *     minimumFractionDigits: (number|undefined),\n *     maximumFractionDigits: (number|undefined),\n *     minimumSignificantDigits: (number|undefined),\n *     maximumSignificantDigits: (number|undefined)}=}\n *         opt_options\n */\nIntl.NumberFormat = function(opt_locales, opt_options) {};\n\n/**\n * @param {Array<string>} locales\n * @param {{localeMatcher: (string|undefined)}=} opt_options\n * @return {Array<string>}\n */\nIntl.NumberFormat.supportedLocalesOf = function(locales, opt_options) {};\n\n/**\n * @param {number} num\n * @return {string}\n */\nIntl.NumberFormat.prototype.format = function(num) {};\n\n/**\n * @return {{locale: string, numberingSystem: string, style: string,\n *     currency: (string|undefined), currencyDisplay: (string|undefined),\n *     minimumIntegerDigits: number, minimumFractionDigits: number,\n *     maximumFractionDigits: number, minimumSignificantDigits: number,\n *     maximumSignificantDigits: number, useGrouping: boolean}}\n */\nIntl.NumberFormat.prototype.resolvedOptions = function() {};\n\n/**\n * @constructor\n * @param {string|Array<string>=} opt_locales\n * @param {{localeMatcher: (string|undefined),\n *    formatMatcher: (string|undefined), calendar: (string|undefined),\n *    numberingSystem: (string|undefined), tz: (string|undefined),\n *    weekday: (string|undefined), era: (string|undefined),\n *    year: (string|undefined), month: (string|undefined),\n *    day: (string|undefined), hour: (string|undefined),\n *    minute: (string|undefined), second: (string|undefined),\n *    timeZoneName: (string|undefined), hour12: (boolean|undefined)}=}\n *        opt_options\n */\nIntl.DateTimeFormat = function(opt_locales, opt_options) {};\n\n/**\n * @param {Array<string>} locales\n * @param {{localeMatcher: string}=} opt_options\n * @return {Array<string>}\n */\nIntl.DateTimeFormat.supportedLocalesOf = function(locales, opt_options) {};\n\n/**\n * @param {(!Date|number)=} date\n * @return {string}\n */\nIntl.DateTimeFormat.prototype.format = function(date) {};\n\n/**\n * @param {(!Date|number)=} date\n * @return {Array<{type: string, value: string}>}\n */\nIntl.DateTimeFormat.prototype.formatToParts = function(date) {};\n\n/**\n * @return {{locale: string, calendar: string, numberingSystem: string,\n *    timeZone: (string|undefined), weekday: (string|undefined),\n *    era: (string|undefined), year: (string|undefined),\n *    month: (string|undefined), day: (string|undefined),\n *    hour: (string|undefined), minute: (string|undefined),\n *    second: (string|undefined), timeZoneName: (string|undefined),\n *    hour12: (boolean|undefined)}}\n */\nIntl.DateTimeFormat.prototype.resolvedOptions = function() {};\n\n/**\n * @constructor\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/PluralRules#Syntax\n * @param {string|Array<string>=} opt_locales\n * @param {{localeMatcher: (string|undefined), type: (string|undefined)}=}\n *         opt_options\n */\nIntl.PluralRules = function(opt_locales, opt_options) {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/PluralRules/supportedLocalesOf#Syntax\n * @param {Array<string>} locales\n * @param {{localeMatcher: string}=} opt_options\n * @return {Array<string>}\n */\nIntl.PluralRules.supportedLocalesOf = function(locales, opt_options) {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/PluralRules/resolvedOptions#Syntax\n * @return {{locale: string, pluralCategories: Array<string>, type: string}}\n */\nIntl.PluralRules.prototype.resolvedOptions = function() {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/PluralRules/select#Syntax\n * @param {number} number\n * @return {string}\n */\nIntl.PluralRules.prototype.select = function(number) {};\n\n/**\n * @constructor\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RelativeTimeFormat#Syntax\n * @param {string|Array<string>=} opt_locales\n * @param {{localeMatcher: (string|undefined),\n *    numeric: (string|undefined),\n *    style: (string|undefined)}=}\n *        opt_options\n */\nIntl.RelativeTimeFormat = function(opt_locales, opt_options) {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RelativeTimeFormat/supportedLocalesOf#Syntax\n * @param {Array<string>} locales\n * @param {{localeMatcher: string}=} opt_options\n * @return {Array<string>}\n */\nIntl.RelativeTimeFormat.supportedLocalesOf = function(locales, opt_options) {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RelativeTimeFormat/format#Syntax\n * @param {number} value\n * @param {string} unit\n * @return {string}\n */\nIntl.RelativeTimeFormat.prototype.format = function(value, unit) {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RelativeTimeFormat/formatToParts#Syntax\n * @param {number} value\n * @param {string} unit\n * @return {Array<string>}\n */\nIntl.RelativeTimeFormat.prototype.formatToParts = function(value, unit) {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RelativeTimeFormat/resolvedOptions#Syntax\n * @return {{locale: string, pluralCategories: Array<string>, type: string}}\n */\nIntl.RelativeTimeFormat.prototype.resolvedOptions = function() {};\n',
"externs/w3c_event.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C\'s event specification.\n *  The whole file has been fully type annotated.\n *  Created from\n *   http://www.w3.org/TR/DOM-Level-2-Events/ecma-script-binding.html\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n */\n\n\n/**\n * @interface\n * @see https://dom.spec.whatwg.org/#interface-eventtarget\n */\nfunction EventTarget() {}\n\n/**\n * @param {string} type\n * @param {EventListener|function(!Event):*} listener\n * @param {(boolean|!AddEventListenerOptions)=} opt_options\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-eventtarget-addeventlistener\n */\nEventTarget.prototype.addEventListener = function(type, listener, opt_options) {\n};\n\n/**\n * @param {string} type\n * @param {EventListener|function(!Event):*} listener\n * @param {(boolean|!EventListenerOptions)=} opt_options\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-eventtarget-removeeventlistener\n */\nEventTarget.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/**\n * @param {!Event} evt\n * @return {boolean}\n * @see https://dom.spec.whatwg.org/#dom-eventtarget-dispatchevent\n */\nEventTarget.prototype.dispatchEvent = function(evt) {};\n\n/**\n * @interface\n */\nfunction EventListener() {}\n\n/**\n * @param {!Event} evt\n * @return {undefined}\n */\nEventListener.prototype.handleEvent = function(evt) {};\n\n// The EventInit interface and the parameters to the Event constructor are part\n// of DOM Level 3 (suggested) and the DOM "Living Standard" (mandated). They are\n// included here as externs cannot be redefined. The same applies to other\n// *EventInit interfaces and *Event constructors throughout this file. See:\n// http://www.w3.org/TR/DOM-Level-3-Events/#event-initializers\n// http://dom.spec.whatwg.org/#constructing-events\n// https://dvcs.w3.org/hg/d4e/raw-file/tip/source_respec.htm#event-constructors\n\n/**\n * @record\n * @see https://dom.spec.whatwg.org/#dictdef-eventinit\n */\nfunction EventInit() {}\n\n/** @type {(undefined|boolean)} */\nEventInit.prototype.bubbles;\n\n/** @type {(undefined|boolean)} */\nEventInit.prototype.cancelable;\n\n/** @type {(undefined|boolean)} */\nEventInit.prototype.composed;\n\n\n/**\n * @constructor\n * @param {string} type\n * @param {EventInit=} opt_eventInitDict\n */\nfunction Event(type, opt_eventInitDict) {}\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Events/ecma-script-binding.html\n */\nEvent.CAPTURING_PHASE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Events/ecma-script-binding.html\n */\nEvent.AT_TARGET;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Events/ecma-script-binding.html\n */\nEvent.BUBBLING_PHASE;\n\n/** @type {string} */\nEvent.prototype.type;\n\n/** @type {EventTarget} */\nEvent.prototype.target;\n\n/** @type {EventTarget} */\nEvent.prototype.currentTarget;\n\n/** @type {number} */\nEvent.prototype.eventPhase;\n\n/** @type {boolean} */\nEvent.prototype.bubbles;\n\n/** @type {boolean} */\nEvent.prototype.cancelable;\n\n/** @type {number} */\nEvent.prototype.timeStamp;\n\n/**\n * Present for events spawned in browsers that support shadow dom.\n * @type {Array<!Element>|undefined}\n */\nEvent.prototype.path;\n\n/**\n * Present for events spawned in browsers that support shadow dom.\n * @type {function():Array<!EventTarget>|undefined}\n * @see https://www.w3.org/TR/shadow-dom/#widl-Event-deepPath\n */\nEvent.prototype.deepPath;\n\n/**\n * @return {undefined}\n */\nEvent.prototype.stopPropagation = function() {};\n\n/**\n * @return {undefined}\n */\nEvent.prototype.preventDefault = function() {};\n\n/**\n * @param {string} eventTypeArg\n * @param {boolean=} canBubbleArg\n * @param {boolean=} cancelableArg\n * @return {undefined}\n */\nEvent.prototype.initEvent = function(eventTypeArg, canBubbleArg, cancelableArg) {};\n\n/**\n * @record\n * @extends {EventInit}\n * @template T\n * @see https://dom.spec.whatwg.org/#dictdef-customeventinit\n */\nfunction CustomEventInit() {}\n\n/** @type {(T|undefined)} */\nCustomEventInit.prototype.detail;\n\n/**\n * @constructor\n * @extends {Event}\n * @param {string} type\n * @param {CustomEventInit<T>=} opt_eventInitDict\n * @template T\n * @see http://www.w3.org/TR/DOM-Level-3-Events/#interface-CustomEvent\n */\nfunction CustomEvent(type, opt_eventInitDict) {}\n\n/**\n * @param {string} eventType\n * @param {boolean} bubbles\n * @param {boolean} cancelable\n * @param {T} detail\n * @return {undefined}\n */\nCustomEvent.prototype.initCustomEvent = function(\n    eventType, bubbles, cancelable, detail) {};\n\n/**\n * @type {T}\n */\nCustomEvent.prototype.detail;\n\n/**\n * @interface\n */\nfunction DocumentEvent() {}\n\n/**\n * @param {string} eventType\n * @return {!Event}\n */\nDocumentEvent.prototype.createEvent = function(eventType) {};\n\n/**\n * @record\n * @extends {EventInit}\n * @see https://w3c.github.io/uievents/#idl-uieventinit\n */\nfunction UIEventInit() {}\n\n/** @type {undefined|?Window} */\nUIEventInit.prototype.view;\n\n/** @type {undefined|number} */\nUIEventInit.prototype.detail;\n\n/**\n * @constructor\n * @extends {Event}\n * @param {string} type\n * @param {UIEventInit=} opt_eventInitDict\n */\nfunction UIEvent(type, opt_eventInitDict) {}\n\n/** @type {number} */\nUIEvent.prototype.detail;\n\n/**\n * @param {string} typeArg\n * @param {boolean} canBubbleArg\n * @param {boolean} cancelableArg\n * @param {Window} viewArg\n * @param {number} detailArg\n * @return {undefined}\n */\nUIEvent.prototype.initUIEvent = function(typeArg, canBubbleArg, cancelableArg,\n    viewArg, detailArg) {};\n\n/**\n * @record\n * @extends {UIEventInit}\n * @see https://w3c.github.io/uievents/#dictdef-eventmodifierinit\n */\nfunction EventModifierInit() {}\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.ctrlKey;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.shiftKey;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.altKey;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.metaKey;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierAltGraph;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierCapsLock;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierFn;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierFnLock;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierHyper;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierNumLock;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierScrollLock;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierSuper;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierSymbol;\n\n/** @type {undefined|boolean} */\nEventModifierInit.prototype.modifierSymbolLock;\n\n/**\n * @record\n * @extends {EventModifierInit}\n * @see https://w3c.github.io/uievents/#idl-mouseeventinit\n */\nfunction MouseEventInit() {}\n\n/** @type {undefined|number} */\nMouseEventInit.prototype.screenX;\n\n/** @type {undefined|number} */\nMouseEventInit.prototype.screenY;\n\n/** @type {undefined|number} */\nMouseEventInit.prototype.clientX;\n\n/** @type {undefined|number} */\nMouseEventInit.prototype.clientY;\n\n/** @type {undefined|number} */\nMouseEventInit.prototype.button;\n\n/** @type {undefined|number} */\nMouseEventInit.prototype.buttons;\n\n/** @type {undefined|?EventTarget} */\nMouseEventInit.prototype.relatedTarget;\n\n/**\n * @constructor\n * @extends {UIEvent}\n * @param {string} type\n * @param {MouseEventInit=} opt_eventInitDict\n */\nfunction MouseEvent(type, opt_eventInitDict) {}\n\n/** @type {number} */\nMouseEvent.prototype.screenX;\n\n/** @type {number} */\nMouseEvent.prototype.screenY;\n\n/** @type {number} */\nMouseEvent.prototype.clientX;\n\n/** @type {number} */\nMouseEvent.prototype.clientY;\n\n/** @type {boolean} */\nMouseEvent.prototype.ctrlKey;\n\n/** @type {boolean} */\nMouseEvent.prototype.shiftKey;\n\n/** @type {boolean} */\nMouseEvent.prototype.altKey;\n\n/** @type {boolean} */\nMouseEvent.prototype.metaKey;\n\n/** @type {number} */\nMouseEvent.prototype.button;\n\n/** @type {EventTarget} */\nMouseEvent.prototype.relatedTarget;\n\n\n/**\n * @constructor\n * @extends {Event}\n */\nfunction MutationEvent() {}\n\n/** @type {Node} */\nMutationEvent.prototype.relatedNode;\n\n/** @type {string} */\nMutationEvent.prototype.prevValue;\n\n/** @type {string} */\nMutationEvent.prototype.newValue;\n\n/** @type {string} */\nMutationEvent.prototype.attrName;\n\n/** @type {number} */\nMutationEvent.prototype.attrChange;\n\n/**\n * @param {string} typeArg\n * @param {boolean} canBubbleArg\n * @param {boolean} cancelableArg\n * @param {Node} relatedNodeArg\n * @param {string} prevValueArg\n * @param {string} newValueArg\n * @param {string} attrNameArg\n * @param {number} attrChangeArg\n * @return {undefined}\n */\nMutationEvent.prototype.initMutationEvent = function(typeArg, canBubbleArg, cancelableArg, relatedNodeArg, prevValueArg, newValueArg, attrNameArg, attrChangeArg) {};\n\n\n// DOM3\n/**\n * @record\n * @extends {EventModifierInit}\n * @see https://w3c.github.io/uievents/#idl-keyboardeventinit\n */\nfunction KeyboardEventInit() {}\n\n/** @type {undefined|string} */\nKeyboardEventInit.prototype.key;\n\n/** @type {undefined|string} */\nKeyboardEventInit.prototype.code;\n\n/** @type {undefined|number} */\nKeyboardEventInit.prototype.location;\n\n/** @type {undefined|boolean} */\nKeyboardEventInit.prototype.repeat;\n\n/** @type {undefined|boolean} */\nKeyboardEventInit.prototype.isComposing;\n\n/** @type {undefined|string} */\nKeyboardEventInit.prototype.char;\n\n/** @type {undefined|string} */\nKeyboardEventInit.prototype.locale;\n\n/**\n * @constructor\n * @extends {UIEvent}\n * @param {string} type\n * @param {KeyboardEventInit=} opt_eventInitDict\n */\nfunction KeyboardEvent(type, opt_eventInitDict) {}\n\n/** @type {string} */\nKeyboardEvent.prototype.keyIdentifier;\n\n/** @type {boolean} */\nKeyboardEvent.prototype.ctrlKey;\n\n/** @type {boolean} */\nKeyboardEvent.prototype.shiftKey;\n\n/** @type {boolean} */\nKeyboardEvent.prototype.altKey;\n\n/** @type {boolean} */\nKeyboardEvent.prototype.metaKey;\n\n/**\n * @param {string} keyIdentifierArg\n * @return {boolean}\n */\nKeyboardEvent.prototype.getModifierState = function(keyIdentifierArg) {};\n\n/**\n * @record\n * @extends {UIEventInit}\n * @see https://w3c.github.io/uievents/#idl-focuseventinit\n */\nfunction FocusEventInit() {}\n\n/** @type {undefined|?EventTarget} */\nFocusEventInit.prototype.relatedTarget;\n\n\n/**\n * The FocusEvent interface provides specific contextual information associated\n * with Focus events.\n * http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent\n *\n * @constructor\n * @extends {UIEvent}\n * @param {string} type\n * @param {FocusEventInit=} opt_eventInitDict\n */\nfunction FocusEvent(type, opt_eventInitDict) {}\n\n/** @type {EventTarget} */\nFocusEvent.prototype.relatedTarget;\n\n\n/**\n * See https://dom.spec.whatwg.org/#dictdef-eventlisteneroptions\n * @record\n */\nvar EventListenerOptions = function() {};\n\n/** @type {boolean|undefined} */\nEventListenerOptions.prototype.capture;\n\n/**\n * See https://dom.spec.whatwg.org/#dictdef-addeventlisteneroptions\n * @record\n * @extends {EventListenerOptions}\n */\nvar AddEventListenerOptions = function() {};\n\n/** @type {boolean|undefined} */\nAddEventListenerOptions.prototype.passive;\n\n/** @type {boolean|undefined} */\nAddEventListenerOptions.prototype.once;\n\n/**\n * @record\n * @extends {UIEventInit}\n * @see https://w3c.github.io/uievents/#idl-inputeventinit\n * @see https://w3c.github.io/input-events/#interface-InputEvent\n */\nfunction InputEventInit() {}\n\n/** @type {undefined|?string} */\nInputEventInit.prototype.data;\n\n/** @type {undefined|boolean} */\nInputEventInit.prototype.isComposing;\n\n/** @type {undefined|string} */\nInputEventInit.prototype.inputType;\n\n/** @type {undefined|?DataTransfer} */\nInputEventInit.prototype.dataTransfer;\n\n\n// TODO(charleyroy): Add getTargetRanges() once a consensus has been made\n// regarding how to structure these values. See\n// https://github.com/w3c/input-events/issues/38.\n/**\n * @constructor\n * @extends {UIEvent}\n * @param {string} type\n * @param {InputEventInit=} opt_eventInitDict\n * @see https://www.w3.org/TR/uievents/#interface-inputevent\n * @see https://w3c.github.io/input-events/#interface-InputEvent\n */\nfunction InputEvent(type, opt_eventInitDict) {}\n\n/** @type {string} */\nInputEvent.prototype.data;\n\n/** @type {boolean} */\nInputEvent.prototype.isComposed;\n\n/** @type {string} */\nInputEvent.prototype.inputType;\n\n/** @type {?DataTransfer} */\nInputEvent.prototype.dataTransfer;\n',
"externs/w3c_event3.js":'/*\n * Copyright 2010 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C\'s event Level 3 specification.\n *  This file depends on w3c_event.js.\n *  The whole file has been partially type annotated.\n *  Created from\n *   http://www.w3.org/TR/DOM-Level-3-Events/#ecma-script-binding-ecma-binding\n *\n * @externs\n * @author ericdingle@google.com (Eric Dingle)\n */\n\n/**\n * @param {string} typeArg\n * @param {boolean} canBubbleArg\n * @param {boolean} cancelableArg\n * @param {Window} viewArg\n * @param {string} keyIdentifierArg\n * @param {number} keyLocationArg\n * @param {string} modifiersList\n * @return {undefined}\n */\nKeyboardEvent.prototype.initKeyboardEvent = function(typeArg, canBubbleArg, cancelableArg, viewArg, keyIdentifierArg, keyLocationArg, modifiersList) {};\n\n/** @type {string} */\nKeyboardEvent.prototype.char;\n\n/** @type {string} */\nKeyboardEvent.prototype.code;\n\n/** @type {string} */\nKeyboardEvent.prototype.key;\n\n/** @type {number} */\nKeyboardEvent.prototype.location;\n\n/** @type {boolean} */\nKeyboardEvent.prototype.repeat;\n\n/** @type {string} */\nKeyboardEvent.prototype.locale;\n\n/** @type {number} */\nMouseEvent.prototype.buttons;\n\n/**\n * @param {string} keyIdentifierArg\n * @return {boolean}\n */\nMouseEvent.prototype.getModifierState = function(keyIdentifierArg) {};\n\n/** @type {boolean} */\nEvent.prototype.defaultPrevented;\n\n/** @type {string} */\nEvent.prototype.namespaceURI;\n\n/** @return {undefined} */\nEvent.prototype.stopImmediatePropagation = function() {};\n',
"externs/gecko_event.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for all the extensions over\n *  W3C\'s event specification by Gecko. This file depends on\n *  w3c_event.js.\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n */\n\n// TODO: Almost all of it has not been annotated with types.\n\n/** @const {number} */ Event.prototype.HORIZONTAL_AXIS;\n/** @const {number} */ Event.prototype.VERTICAL_AXIS;\n/** @type {boolean} */ Event.prototype.altKey;\n/** @type {number} */ Event.prototype.axis;\n/** @type {number} */ Event.prototype.button;\n/** @type {boolean} */ Event.prototype.cancelBubble;\n/** @type {number} */ Event.prototype.charCode;\n/** @type {number} */ Event.prototype.clientX;\n/** @type {number} */ Event.prototype.clientY;\n/** @type {boolean} */ Event.prototype.ctrlKey;\n/** @type {EventTarget} */ Event.prototype.explicitOriginalTarget;\n/** @type {boolean} */ Event.prototype.isChar;\n/** @type {boolean} */ Event.prototype.isTrusted;\n/** @type {number} */ Event.prototype.keyCode;\n/** @type {number} */ Event.prototype.layerX;\n/** @type {number} */ Event.prototype.layerY;\n/** @type {boolean} */ Event.prototype.metaKey;\n/** @type {EventTarget} */ Event.prototype.originalTarget;\n/** @type {number} */ Event.prototype.pageX;\n/** @type {number} */ Event.prototype.pageY;\n/** @type {EventTarget|undefined} */ Event.prototype.relatedTarget;\n/** @type {number} */ Event.prototype.screenX;\n/** @type {number} */ Event.prototype.screenY;\n/** @type {boolean} */ Event.prototype.shiftKey;\n/** @type {Window} */ Event.prototype.view;\n/** @type {number} */ Event.prototype.which;\n\n/** @constructor */ function nsIDOMPageTransitionEvent() {}\n/** @type {boolean} */ nsIDOMPageTransitionEvent.prototype.persisted;\n\n//Methods\nEvent.prototype.initKeyEvent;\n/**\n * @param {string} typeArg\n * @param {boolean=} canBubbleArg\n * @param {boolean=} cancelableArg\n * @param {?Window=} viewArg\n * @param {?number=} detailArg\n * @param {number=} screenXArg\n * @param {number=} screenYArg\n * @param {number=} clientXArg\n * @param {number=} clientYArg\n * @param {boolean=} ctrlKeyArg\n * @param {boolean=} altKeyArg\n * @param {boolean=} shiftKeyArg\n * @param {boolean=} metaKeyArg\n * @param {?number=} buttonArg\n * @param {?EventTarget=} relatedTargetArg\n */\nEvent.prototype.initMouseEvent = function(typeArg, canBubbleArg, cancelableArg, viewArg, detailArg, screenXArg, screenYArg, clientXArg, clientYArg, ctrlKeyArg, altKeyArg, shiftKeyArg, metaKeyArg, buttonArg, relatedTargetArg) {};\nEvent.prototype.initUIEvent;\nEvent.prototype.initMessageEvent;\nEvent.prototype.preventBubble;\nEvent.prototype.preventCapture;\n',
"externs/ie_event.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for all the extensions over the\n *  W3C\'s event specification by IE in JScript. This file depends on\n *  w3c_event.js.\n *\n * @see http://msdn.microsoft.com/en-us/library/ms535863.aspx\n * @externs\n * @author acleung@google.com (Alan Leung)\n */\n\n/** @type {string} */\nEvent.prototype.Abstract;\n\n/** @type {boolean} */\nEvent.prototype.altLeft;\n\n/** @type {string} */\nEvent.prototype.Banner;\n\n/**\n * A ClipboardData on IE, but a DataTransfer on WebKit.\n * @see http://msdn.microsoft.com/en-us/library/ms535220.aspx\n * @type {(ClipboardData|undefined)}\n */\nEvent.prototype.clipboardData;\n\n/** @type {boolean} */\nEvent.prototype.contentOverflow;\n\n/** @type {boolean} */\nEvent.prototype.ctrlLeft;\n\n/** @type {string} */\nEvent.prototype.dataFld;\n\nEvent.prototype.domain;\n\n/** @type {Element} */\nEvent.prototype.fromElement;\n\n/** @type {string} */\nEvent.prototype.MoreInfo;\n\n/** @type {string} */\nEvent.prototype.nextPage;\n\n/** @type {number} */\nEvent.prototype.offsetX;\n\n/** @type {number} */\nEvent.prototype.offsetY;\n\n/** @type {string} */\nEvent.prototype.propertyName;\n\n/** @type {string} */\nEvent.prototype.qualifier;\n\n/** @type {number} */\nEvent.prototype.reason;\n\n/** @type {Object<*>} */\nEvent.prototype.recordset;\n\n/** @type {boolean} */\nEvent.prototype.repeat;\n\n/** @type {(boolean|string|undefined)} */\nEvent.prototype.returnValue;\n\n/** @type {string} */\nEvent.prototype.saveType;\n\nEvent.prototype.scheme;\n\n/** @type {boolean} */\nEvent.prototype.shiftLeft;\n\n/** @type {Window} */\nEvent.prototype.source;\n\n/** @type {Element} */\nEvent.prototype.srcElement;\n\nEvent.prototype.srcFilter;\n\n/** @type {string} */\nEvent.prototype.srcUrn;\n\n/** @type {Element} */\nEvent.prototype.toElement;\n\nEvent.prototype.userName;\n\n/** @type {number} */\nEvent.prototype.wheelDelta;\n\n/** @type {number} */\nEvent.prototype.x;\n\n/** @type {number} */\nEvent.prototype.y;\n\n/**\n * @constructor\n * @see http://msdn.microsoft.com/en-us/library/windows/apps/hh441257.aspx\n */\nfunction MSPointerPoint() {}\n\n/** @type {number} */\nMSPointerPoint.prototype.pointerId;\n\n/** @type {number} */\nMSPointerPoint.prototype.pointerType;\n\n/**\n * @constructor\n * @extends {Event}\n * @see http://msdn.microsoft.com/en-us/library/windows/apps/hh441233.aspx\n */\nfunction MSPointerEvent() {}\n\n/** @const {number} */\nMSPointerEvent.MSPOINTER_TYPE_MOUSE;\n\n/** @const {number} */\nMSPointerEvent.MSPOINTER_TYPE_PEN;\n\n/** @const {number} */\nMSPointerEvent.MSPOINTER_TYPE_TOUCH;\n\n/** @type {number} */\nMSPointerEvent.prototype.height;\n\n/** @type {number} */\nMSPointerEvent.prototype.hwTimestamp;\n\n/** @type {boolean} */\nMSPointerEvent.prototype.isPrimary;\n\n/** @type {number} */\nMSPointerEvent.prototype.pointerId;\n\n/** @type {number} */\nMSPointerEvent.prototype.pointerType;\n\n/** @type {number} */\nMSPointerEvent.prototype.pressure;\n\n/** @type {number} */\nMSPointerEvent.prototype.rotation;\n\n/** @type {number} */\nMSPointerEvent.prototype.tiltX;\n\n/** @type {number} */\nMSPointerEvent.prototype.tiltY;\n\n/** @type {number} */\nMSPointerEvent.prototype.timeStamp;\n\n/** @type {number} */\nMSPointerEvent.prototype.width;\n\n/**\n * @param {number} pointerId\n * @return {undefined}\n */\nMSPointerEvent.prototype.msReleasePointerCapture;\n\n/**\n * @param {number} pointerId\n * @return {undefined}\n */\nMSPointerEvent.prototype.msSetPointerCapture;\n\n/**\n * @param {string} typeArg\n * @param {boolean} canBubbleArg\n * @param {boolean} cancelableArg\n * @param {Window} viewArg\n * @param {number} detailArg\n * @param {number} screenXArg\n * @param {number} screenYArg\n * @param {number} clientXArg\n * @param {number} clientYArg\n * @param {boolean} ctrlKeyArg\n * @param {boolean} altKeyArg\n * @param {boolean} shiftKeyArg\n * @param {boolean} metaKeyArg\n * @param {number} buttonArg\n * @param {Element} relatedTargetArg\n * @param {number} offsetXArg\n * @param {number} offsetYArg\n * @param {number} widthArg\n * @param {number} heightArg\n * @param {number} pressure\n * @param {number} rotation\n * @param {number} tiltX\n * @param {number} tiltY\n * @param {number} pointerIdArg\n * @param {number} pointerType\n * @param {number} hwTimestampArg\n * @param {boolean} isPrimary\n * @return {undefined}\n * @see http://msdn.microsoft.com/en-us/library/windows/apps/hh441246.aspx\n */\nMSPointerEvent.prototype.initPointerEvent;\n\n/**\n * @constructor\n * @see http://msdn.microsoft.com/en-us/library/ie/hh968249(v=vs.85).aspx\n */\nfunction MSGesture() {}\n\n/**\n * @type {Element}\n */\nMSGesture.prototype.target;\n\n/**\n * @param {number} pointerId\n * @return {undefined}\n */\nMSGesture.prototype.addPointer = function(pointerId) {};\n\nMSGesture.prototype.stop = function() {};\n\n/**\n * @constructor\n * @extends {Event}\n * @see http://msdn.microsoft.com/en-us/library/ie/hh772076(v=vs.85).aspx\n */\nfunction MSGestureEvent() {}\n\n/** @type {number} */\nMSGestureEvent.prototype.expansion;\n\n/** @type {!MSGesture} */\nMSGestureEvent.prototype.gestureObject;\n\n/** @type {number} */\nMSGestureEvent.prototype.hwTimestamp;\n\n/** @type {number} */\nMSGestureEvent.prototype.rotation;\n\n/** @type {number} */\nMSGestureEvent.prototype.scale;\n\n/** @type {number} */\nMSGestureEvent.prototype.translationX;\n\n/** @type {number} */\nMSGestureEvent.prototype.translationY;\n\n/** @type {number} */\nMSGestureEvent.prototype.velocityAngular;\n\n/** @type {number} */\nMSGestureEvent.prototype.velocityExpansion;\n\n/** @type {number} */\nMSGestureEvent.prototype.velocityX;\n\n/** @type {number} */\nMSGestureEvent.prototype.velocityY;\n\n/**\n * @param {string} typeArg\n * @param {boolean} canBubbleArg\n * @param {boolean} cancelableArg\n * @param {Window} viewArg\n * @param {number} detailArg\n * @param {number} screenXArg\n * @param {number} screenYArg\n * @param {number} clientXArg\n * @param {number} clientYArg\n * @param {number} offsetXArg\n * @param {number} offsetYArg\n * @param {number} translationXArg\n * @param {number} translationYArg\n * @param {number} scaleArg\n * @param {number} expansionArg\n * @param {number} rotationArg\n * @param {number} velocityXArg\n * @param {number} velocityYArg\n * @param {number} velocityExpansionArg\n * @param {number} velocityAngularArg\n * @param {number} hwTimestampArg\n * @param {EventTarget} relatedTargetArg\n * @return {undefined}\n * @see http://msdn.microsoft.com/en-us/library/windows/apps/hh441187.aspx\n */\nMSGestureEvent.prototype.initGestureEvent;\n',
"externs/webkit_event.js":'/*\n * Copyright 2009 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for all the extensions over W3C\'s\n *  event specification by WebKit. This file depends on w3c_event.js.\n *  All the provided definitions have been type annotated\n *\n * @externs\n * @author djlee@google.com (DJ Lee)\n */\n\n/** @type {number} */\nEvent.prototype.wheelDeltaX;\n\n/** @type {number} */\nEvent.prototype.wheelDeltaY;\n\n/**\n * @constructor\n * @extends {Event}\n * @see http://developer.apple.com/library/safari/documentation/AudioVideo/Reference/WebKitAnimationEventClassReference/WebKitAnimationEvent/WebKitAnimationEvent.html\n */\nfunction WebKitAnimationEvent() {}\n\n/**\n * @const {string}\n */\nWebKitAnimationEvent.prototype.animationName;\n\n/**\n * @const {number}\n */\nWebKitAnimationEvent.prototype.elapsedTime;\n',
"externs/w3c_device_sensor_event.js":'/*\n * Copyright 2013 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C\'s device orientation and device motion\n *  events specification.\n *  This file depends on w3c_event.js.\n *  The whole file has been partially type annotated.\n *  Created from http://dev.w3.org/geo/api/spec-source-orientation.\n *\n * @externs\n * @author lukaszbk@google.com (Lukasz Bieniasz-Krzywiec)\n */\n\n/**\n * @record\n * @extends {EventInit}\n * @see https://w3c.github.io/deviceorientation/spec-source-orientation.html#deviceorientation\n */\nfunction DeviceOrientationEventInit() {}\n\n/** @type {number|undefined} */\nDeviceOrientationEventInit.prototype.alpha;\n\n/** @type {number|undefined} */\nDeviceOrientationEventInit.prototype.beta;\n\n/** @type {number|undefined} */\nDeviceOrientationEventInit.prototype.gamma;\n\n/** @type {boolean|undefined} */\nDeviceOrientationEventInit.prototype.absolute;\n\n/**\n * @constructor\n * @extends {Event}\n * @param {string} type\n * @param {!DeviceOrientationEventInit=} opt_eventInitDict\n */\nfunction DeviceOrientationEvent(type, opt_eventInitDict) {}\n\n/** @type {?number} */\nDeviceOrientationEvent.prototype.alpha;\n\n/** @type {?number} */\nDeviceOrientationEvent.prototype.beta;\n\n/** @type {?number} */\nDeviceOrientationEvent.prototype.gamma;\n\n/** @type {boolean} */\nDeviceOrientationEvent.prototype.absolute;\n\n/**\n * @type {?number}\n * @see https://developer.apple.com/library/safari/documentation/SafariDOMAdditions/Reference/DeviceOrientationEventClassRef/DeviceOrientationEvent/DeviceOrientationEvent.html#//apple_ref/javascript/instp/DeviceOrientationEvent/webkitCompassAccuracy\n */\nDeviceOrientationEvent.prototype.webkitCompassAccuracy;\n\n/**\n * @type {?number}\n * @see https://developer.apple.com/library/safari/documentation/SafariDOMAdditions/Reference/DeviceOrientationEventClassRef/DeviceOrientationEvent/DeviceOrientationEvent.html#//apple_ref/javascript/instp/DeviceOrientationEvent/webkitCompassHeading\n */\nDeviceOrientationEvent.prototype.webkitCompassHeading;\n\n/**\n * @constructor\n */\nfunction DeviceAcceleration() {}\n\n/** @type {?number} */\nDeviceAcceleration.prototype.x;\n\n/** @type {?number} */\nDeviceAcceleration.prototype.y;\n\n/** @type {?number} */\nDeviceAcceleration.prototype.z;\n\n/**\n * @constructor\n */\nfunction DeviceRotationRate() {}\n\n/** @type {?number} */\nDeviceRotationRate.prototype.alpha;\n\n/** @type {?number} */\nDeviceRotationRate.prototype.beta;\n\n/** @type {?number} */\nDeviceRotationRate.prototype.gamma;\n\n/**\n * @constructor\n * @extends {Event}\n */\nfunction DeviceMotionEvent() {}\n\n/** @type {?DeviceAcceleration} */\nDeviceMotionEvent.prototype.acceleration;\n\n/** @type {?DeviceAcceleration} */\nDeviceMotionEvent.prototype.accelerationIncludingGravity;\n\n/** @type {?DeviceRotationRate} */\nDeviceMotionEvent.prototype.rotationRate;\n\n/** @type {?number} */\nDeviceMotionEvent.prototype.interval;\n',
"externs/web_app_manifest.js":"/*\n * Copyright 2017 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n/**\n * @fileoverview Externs for web app manifest APIs.\n *\n * @see https://www.w3.org/TR/appmanifest/\n * @externs\n */\n\n/**\n * @see https://www.w3.org/TR/appmanifest/#beforeinstallpromptevent-interface\n * @constructor\n * @extends {Event}\n */\nfunction BeforeInstallPromptEvent() {}\n\n/** @type {!Promise<{outcome: !AppBannerPromptOutcome}>} */\nBeforeInstallPromptEvent.prototype.userChoice;\n\n/** @return {!Promise<!PromptResponseObject>} */\nBeforeInstallPromptEvent.prototype.prompt = function() {};\n\n/**\n * @typedef {string}\n * @see https://www.w3.org/TR/appmanifest/#appbannerpromptoutcome-enum\n * Possible values: 'accepted', 'dismissed'\n */\nvar AppBannerPromptOutcome;\n\n/** @typedef {{userChoice: !AppBannerPromptOutcome}} */\nvar PromptResponseObject;\n\n/** @type {?function(!BeforeInstallPromptEvent)} */\nWindow.prototype.onbeforeinstallprompt;\n\n/** @type {?function(!Event)} */\nWindow.prototype.onappinstalled;\n",
"externs/w3c_selection.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C\'s Selection API.\n *\n * @see https://w3c.github.io/selection-api/\n *\n * @externs\n */\n\n/**\n * @constructor\n * @see http://w3c.github.io/selection-api/#selection-interface\n */\nfunction Selection() {}\n\n/**\n * @type {?Node}\n * @see https://w3c.github.io/selection-api/#dom-selection-anchornode\n */\nSelection.prototype.anchorNode;\n\n/**\n * @type {number}\n * @see https://w3c.github.io/selection-api/#dom-selection-anchoroffset\n */\nSelection.prototype.anchorOffset;\n\n/**\n * @type {?Node}\n * @see https://w3c.github.io/selection-api/#dom-selection-focusnode\n */\nSelection.prototype.focusNode;\n\n/**\n * @type {number}\n * @see https://w3c.github.io/selection-api/#dom-selection-focusoffset\n */\nSelection.prototype.focusOffset;\n\n/**\n * @type {boolean}\n * @see https://w3c.github.io/selection-api/#dom-selection-iscollapsed\n */\nSelection.prototype.isCollapsed;\n\n/**\n * @type {number}\n * @see https://w3c.github.io/selection-api/#dom-selection-rangecount\n */\nSelection.prototype.rangeCount;\n\n/**\n * @type {string}\n * @see https://w3c.github.io/selection-api/#dom-selection-type\n */\nSelection.prototype.type;\n\n/**\n * @param {number} index\n * @return {!Range}\n * @nosideeffects\n * @see https://w3c.github.io/selection-api/#dom-selection-getrangeat\n */\nSelection.prototype.getRangeAt = function(index) {};\n\n/**\n * TODO(tjgq): Clean up internal usages and make the `range` parameter a\n * `!Range` per the spec.\n * @param {?Range} range\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-addrange\n */\nSelection.prototype.addRange = function(range) {};\n\n/**\n * @param {!Range} range\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-removerange\n */\nSelection.prototype.removeRange = function(range) {};\n\n/**\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-removeallranges\n */\nSelection.prototype.removeAllRanges = function() {};\n\n/**\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-empty\n */\nSelection.prototype.empty = function() {};\n\n/**\n * @param {?Node} node\n * @param {number=} offset\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-collapse\n */\nSelection.prototype.collapse = function(node, offset) {};\n\n/**\n * @param {?Node} node\n * @param {number=} offset\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-setposition\n */\nSelection.prototype.setPosition = function(node, offset) {};\n\n/**\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-collapsetostart\n */\nSelection.prototype.collapseToStart = function() {};\n\n/**\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-collapsetoend\n */\nSelection.prototype.collapseToEnd = function() {};\n\n/**\n * TODO(tjgq): Clean up internal usages and make the `node` parameter a `!Node`\n * per the spec.\n * @param {?Node} node\n * @param {number=} offset\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-extend\n */\nSelection.prototype.extend = function(node, offset) {};\n\n/**\n * TODO(tjgq): Clean up internal usages and make the `anchorNode` and\n * `focusNode` parameters `!Node` per the spec.\n * @param {?Node} anchorNode\n * @param {number} anchorOffset\n * @param {?Node} focusNode\n * @param {number} focusOffset\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-setbaseandextent\n */\nSelection.prototype.setBaseAndExtent = function(anchorNode, anchorOffset, focusNode, focusOffset) {};\n\n/**\n * TODO(tjgq): Clean up internal usages and make the `node` parameter a `!Node`\n * per the spec.\n * @param {?Node} node\n * @return {undefined}\n * @see http://w3c.github.io/selection-api/#dom-selection-selectallchildren\n */\nSelection.prototype.selectAllChildren = function(node) {};\n\n/**\n * @return {undefined}\n * @see https://w3c.github.io/selection-api/#dom-selection-deletefromdocument\n */\nSelection.prototype.deleteFromDocument = function() {};\n\n/**\n * @param {!Node} node\n * @param {boolean=} allowPartialContainment\n * @return {boolean}\n * @nosideeffects\n * @see https://w3c.github.io/selection-api/#dom-selection-containsnode\n */\nSelection.prototype.containsNode = function(node, allowPartialContainment) {};\n\n/**\n * @return {?Selection}\n * @nosideeffects\n * @see https://w3c.github.io/selection-api/#dom-window-getselection\n */\nWindow.prototype.getSelection = function() {};\n\n/**\n * @return {?Selection}\n * @nosideeffects\n * @see https://w3c.github.io/selection-api/#dom-document-getselection\n */\nDocument.prototype.getSelection = function() {};\n\n/**\n * TODO(tjgq): Clean up internal usages and make this `?function(!Event): void`\n * per the spec.\n * @type {?function(?Event)}\n * @see https://w3c.github.io/selection-api/#dom-globaleventhandlers-onselectstart\n */\nElement.prototype.onselectstart;\n\n/**\n * @type {?function(!Event): void}\n * @see https://w3c.github.io/selection-api/#dom-globaleventhandlers-onselectionchange\n */\nElement.prototype.onselectionchange;\n',
"externs/nonstandard_selection.js":'/*\n * Copyright 2011 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Nonstandard enhancements to W3C\'s Selection API.\n *\n * @externs\n */\n\n// The following were sources from the webkit externs.\n\n/** @type {?Node} */\nSelection.prototype.baseNode;\n\n/** @type {number} */\nSelection.prototype.baseOffset;\n\n/** @type {?Node} */\nSelection.prototype.extentNode;\n\n/** @type {number} */\nSelection.prototype.extentOffset;\n\n/**\n * @param {string} alter\n * @param {string} direction\n * @param {string} granularity\n * @return {undefined}\n */\nSelection.prototype.modify = function(alter, direction, granularity) {};\n\n\n// The following were sources from the gecko externs.\n\n\n/**\n * @see https://developer.mozilla.org/en/DOM/Selection/selectionLanguageChange\n */\nSelection.prototype.selectionLanguageChange;\n\n\n// The following were sources from the ie externs.\n\n\n/**\n * @type {?Selection}\n * @see http://msdn.microsoft.com/en-us/library/ms535869(VS.85).aspx\n */\nDocument.prototype.selection;\n\n/**\n * @return {undefined}\n * @see http://msdn.microsoft.com/en-us/library/ms536418(VS.85).aspx\n */\nSelection.prototype.clear = function() {};\n\n/**\n * @return {?TextRange|?ControlRange}\n * @see http://msdn.microsoft.com/en-us/library/ms536394(VS.85).aspx\n */\nSelection.prototype.createRange = function() {};\n\n/**\n * @return {?Array<?TextRange>}\n * @see http://msdn.microsoft.com/en-us/library/ms536396(VS.85).aspx\n */\nSelection.prototype.createRangeCollection = function() {};\n',
"externs/w3c_trusted_types.js":'/*\n * Copyright 2018 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C\'s Trusted Types specification.\n * @see https://github.com/WICG/trusted-types\n * @externs\n */\n\n\n/** @constructor */\nfunction TrustedHTML() {}\n\n/** @constructor */\nfunction TrustedScript() {}\n\n/** @constructor */\nfunction TrustedScriptURL() {}\n\n/** @constructor */\nfunction TrustedURL() {}\n\n\n/** @constructor */\nfunction TrustedTypePolicy() {}\n\n/**\n * @param {string} s\n * @return {!TrustedHTML}\n */\nTrustedTypePolicy.prototype.createHTML = function(s) {};\n\n/**\n * @param {string} s\n * @return {!TrustedScript}\n */\nTrustedTypePolicy.prototype.createScript = function(s) {};\n\n/**\n * @param {string} s\n * @return {!TrustedScriptURL}\n */\nTrustedTypePolicy.prototype.createScriptURL = function(s) {};\n\n/**\n * @param {string} s\n * @return {!TrustedURL}\n */\nTrustedTypePolicy.prototype.createURL = function(s) {};\n\n\n/** @constructor */\nfunction TrustedTypePolicyFactory() {}\n\n/** @record @private */\nfunction TrustedTypePolicyOptions() {};\n\n/**\n *  @type {(function(string, ...*): string)|undefined},\n */\nTrustedTypePolicyOptions.prototype.createHTML;\n\n/**\n *  @type {(function(string, ...*): string)|undefined},\n */\nTrustedTypePolicyOptions.prototype.createScript;\n\n/**\n *  @type {(function(string, ...*): string)|undefined},\n */\nTrustedTypePolicyOptions.prototype.createScriptURL;\n\n/**\n *  @type {(function(string, ...*): string)|undefined},\n */\nTrustedTypePolicyOptions.prototype.createURL;\n\n/**\n * @param {string} name\n * @param {!TrustedTypePolicyOptions} policy\n * @param {boolean=} opt_expose\n * @return {!TrustedTypePolicy}\n */\nTrustedTypePolicyFactory.prototype.createPolicy = function(\n    name, policy, opt_expose) {};\n\n/**\n * @param {string} name\n * @return {!TrustedTypePolicy}\n * @deprecated\n */\nTrustedTypePolicyFactory.prototype.getExposedPolicy = function(name) {};\n\n/** @return {!Array<string>} */\nTrustedTypePolicyFactory.prototype.getPolicyNames = function() {};\n\n/**\n * @param {*} obj\n * @return {boolean}\n */\nTrustedTypePolicyFactory.prototype.isHTML = function(obj) {};\n\n/**\n * @param {*} obj\n * @return {boolean}\n */\nTrustedTypePolicyFactory.prototype.isScript = function(obj) {};\n\n/**\n * @param {*} obj\n * @return {boolean}\n */\nTrustedTypePolicyFactory.prototype.isScriptURL = function(obj) {};\n\n/**\n * @param {*} obj\n * @return {boolean}\n * @deprecated\n */\nTrustedTypePolicyFactory.prototype.isURL = function(obj) {};\n\n/** @type {!TrustedHTML} */\nTrustedTypePolicyFactory.prototype.emptyHTML;\n\n/**\n * @type {!TrustedTypePolicyFactory}\n * @deprecated\n */\nvar TrustedTypes;\n\n/** @type {!TrustedTypePolicyFactory} */\nvar trustedTypes;\n',
"externs/w3c_dom1.js":"/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C's DOM Level 1 specification.\n *  The whole file has been fully type annotated. Created from\n *  http://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n * @author stevey@google.com (Steve Yegge)\n */\n\n/**\n * @constructor\n * @param {string=} message\n * @param {string=} name\n * @see https://heycam.github.io/webidl/#idl-DOMException\n */\nfunction DOMException(message, name) {}\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.INDEX_SIZE_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.DOMSTRING_SIZE_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.HIERARCHY_REQUEST_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.WRONG_DOCUMENT_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.INVALID_CHARACTER_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.NO_DATA_ALLOWED_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.NO_MODIFICATION_ALLOWED_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.NOT_FOUND_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.NOT_SUPPORTED_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nDOMException.INUSE_ATTRIBUTE_ERR;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\n */\nfunction ExceptionCode() {}\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-102161490\n */\nfunction DOMImplementation() {}\n\n/**\n * @param {string} feature\n * @param {string} version\n * @return {boolean}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-5CED94D7\n * @nosideeffects\n */\nDOMImplementation.prototype.hasFeature = function(feature, version) {};\n\n/**\n * @constructor\n * @implements {EventTarget}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nfunction Node() {}\n\n/** @override */\nNode.prototype.addEventListener = function(type, listener, opt_options) {};\n\n/** @override */\nNode.prototype.removeEventListener = function(type, listener, opt_options) {};\n\n/** @override */\nNode.prototype.dispatchEvent = function(evt) {};\n\n/**\n * @type {NamedNodeMap<!Attr>}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-attributes\n */\nNode.prototype.attributes;\n\n/**\n * @type {!NodeList<!Node>}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-childNodes\n */\nNode.prototype.childNodes;\n\n/**\n * @type {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-firstChild\n */\nNode.prototype.firstChild;\n\n/**\n * @type {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-lastChild\n */\nNode.prototype.lastChild;\n\n/**\n * @type {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-nextSibling\n */\nNode.prototype.nextSibling;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-nodeName\n */\nNode.prototype.nodeName;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-nodeValue\n */\nNode.prototype.nodeValue;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-nodeType\n */\nNode.prototype.nodeType;\n\n/**\n * @type {Document}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-ownerDocument\n */\nNode.prototype.ownerDocument;\n\n/**\n * @type {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-parentNode\n */\nNode.prototype.parentNode;\n\n/**\n * @type {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-previousSibling\n */\nNode.prototype.previousSibling;\n\n/**\n * @param {Node} newChild\n * @return {!Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-appendChild\n */\nNode.prototype.appendChild = function(newChild) {};\n\n/**\n * @param {boolean} deep\n * @return {!Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-cloneNode\n * @nosideeffects\n */\nNode.prototype.cloneNode = function(deep) {};\n\n/**\n * @return {boolean}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-hasChildNodes\n * @nosideeffects\n */\nNode.prototype.hasChildNodes = function() {};\n\n/**\n * @param {Node} newChild\n * @param {Node} refChild\n * @return {!Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-insertBefore\n */\nNode.prototype.insertBefore = function(newChild, refChild) {};\n\n/**\n * @param {Node} oldChild\n * @return {!Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-removeChild\n */\nNode.prototype.removeChild = function(oldChild) {};\n\n/**\n * @param {Node} newChild\n * @param {Node} oldChild\n * @return {!Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-replaceChild\n */\nNode.prototype.replaceChild = function(newChild, oldChild) {};\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.ATTRIBUTE_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.CDATA_SECTION_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.COMMENT_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.DOCUMENT_FRAGMENT_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.DOCUMENT_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.DOCUMENT_TYPE_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.ELEMENT_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.ENTITY_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.ENTITY_REFERENCE_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.PROCESSING_INSTRUCTION_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.TEXT_NODE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\n */\nNode.NOTATION_NODE;\n\n/**\n * @constructor\n * @extends {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-B63ED1A3\n */\nfunction DocumentFragment() {}\n\n/**\n * @constructor\n * @extends {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#i-Document\n */\nfunction Document() {}\n\n/**\n * @type {DocumentType}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-doctype\n */\nDocument.prototype.doctype;\n\n/**\n * @type {!HTMLHtmlElement}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-documentElement\n */\nDocument.prototype.documentElement;\n\n/**\n * @type {DOMImplementation}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-implementation\n */\nDocument.prototype.implementation;\n\n/**\n * @param {string} name\n * @return {!Attr}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createAttribute\n * @nosideeffects\n */\nDocument.prototype.createAttribute = function(name) {};\n\n/**\n * @param {string} data\n * @return {!Comment}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createComment\n * @nosideeffects\n */\nDocument.prototype.createComment = function(data) {};\n\n/**\n * @param {string} data\n * @return {!CDATASection}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createCDATASection\n * @nosideeffects\n */\nDocument.prototype.createCDATASection = function(data) {};\n\n/**\n * @return {!DocumentFragment}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createDocumentFragment\n * @nosideeffects\n */\nDocument.prototype.createDocumentFragment = function() {};\n\n/**\n * Create a DOM element.\n *\n * Web components introduced the second parameter as a way of extending existing\n * tags (e.g. document.createElement('button', 'fancy-button')).\n *\n * @param {string} tagName\n * @param {string=} opt_typeExtension\n * @return {!Element}\n * @nosideeffects\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createElement\n * @see http://w3c.github.io/webcomponents/spec/custom/#extensions-to-document-interface-to-instantiate\n */\nDocument.prototype.createElement = function(tagName, opt_typeExtension) {};\n\n/**\n * @param {string} target\n * @param {string} data\n * @return {!ProcessingInstruction}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createProcessingInstruction\n * @nosideeffects\n */\nDocument.prototype.createProcessingInstruction = function(target, data) {};\n\n/**\n * @param {number|string} data\n * @return {!Text}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createTextNode\n * @nosideeffects\n */\nDocument.prototype.createTextNode = function(data) {};\n\n/**\n * @param {string} tagname\n * @return {!NodeList<!Element>}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-A6C9094\n * @nosideeffects\n */\nDocument.prototype.getElementsByTagName = function(tagname) {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Document/open\n * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-document-open\n */\nDocument.prototype.open;\n\n/**\n * @return {undefined}\n * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-document-close\n */\nDocument.prototype.close = function() {};\n\n/**\n * @param {!TrustedHTML|string} text\n * @return {undefined}\n * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-document-write\n */\nDocument.prototype.write = function(text) {};\n\n/**\n * @param {!TrustedHTML|string} text\n * @return {undefined}\n * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-document-writeln\n */\nDocument.prototype.writeln = function(text) {};\n\n/**\n * @constructor\n * @implements {IArrayLike<T>}\n * @implements {Iterable<T>}\n * @template T\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-536297177\n */\nfunction NodeList() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-203510337\n */\nNodeList.prototype.length;\n\n/**\n * @param {number} index\n * @return {T|null}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-844377136\n */\nNodeList.prototype.item = function(index) {};\n\n/**\n * @param {?function(this:S, T, number, !NodeList<T>): ?} callback\n * @param {S=} opt_thisobj\n * @template S\n * @return {undefined}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/NodeList/forEach\n */\nNodeList.prototype.forEach = function(callback, opt_thisobj) {};\n\n/**\n * @constructor\n * @implements {IObject<(string|number), T>}\n * @implements {IArrayLike<T>}\n * @implements {Iterable<T>}\n * @template T\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1780488922\n */\nfunction NamedNodeMap() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-6D0FB19E\n */\nNamedNodeMap.prototype.length;\n\n/**\n * @param {string} name\n * @return {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1074577549\n * @nosideeffects\n */\nNamedNodeMap.prototype.getNamedItem = function(name) {};\n\n/**\n * @param {number} index\n * @return {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-349467F9\n * @nosideeffects\n */\nNamedNodeMap.prototype.item = function(index) {};\n\n/**\n * @param {string} name\n * @return {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-D58B193\n */\nNamedNodeMap.prototype.removeNamedItem = function(name) {};\n\n/**\n * @param {Node} arg\n * @return {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1025163788\n */\nNamedNodeMap.prototype.setNamedItem = function(arg) {};\n\n/**\n * @constructor\n * @extends {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-FF21A306\n */\nfunction CharacterData() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-72AB8359\n */\nCharacterData.prototype.data;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-7D61178C\n */\nCharacterData.prototype.length;\n\n/**\n * @param {string} arg\n * @return {undefined}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-32791A2F\n */\nCharacterData.prototype.appendData = function(arg) {};\n\n/**\n * @param {number} offset\n * @param {number} count\n * @return {undefined}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-7C603781\n */\nCharacterData.prototype.deleteData = function(offset, count) {};\n\n/**\n * @param {number} offset\n * @param {string} arg\n * @return {undefined}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-3EDB695F\n */\nCharacterData.prototype.insertData = function(offset, arg) {};\n\n/**\n * @param {number} offset\n * @param {number} count\n * @param {string} arg\n * @return {undefined}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-E5CBA7FB\n */\nCharacterData.prototype.replaceData = function(offset, count, arg) {};\n\n/**\n * @param {number} offset\n * @param {number} count\n * @return {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-6531BCCF\n * @nosideeffects\n */\nCharacterData.prototype.substringData = function(offset, count) {};\n\n/**\n * @constructor\n * @extends {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-637646024\n */\nfunction Attr() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1112119403\n */\nAttr.prototype.name;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-862529273\n */\nAttr.prototype.specified;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-221662474\n */\nAttr.prototype.value;\n\n/**\n * @constructor\n * @extends {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-745549614\n */\nfunction Element() {}\n\n/**\n * @type {string}\n * @implicitCast\n * @see https://dom.spec.whatwg.org/index.html#dom-element-id\n */\nElement.prototype.id;\n\n/**\n * An Element always contains a non-null NamedNodeMap containing the attributes\n * of this node.\n * @type {!NamedNodeMap<!Attr>}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-attributes\n */\nElement.prototype.attributes;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-tagName\n */\nElement.prototype.tagName;\n\n/**\n * @implicitCast\n * @type {?}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Element/className\n *    We type it as ? even though it is a string, because some SVG elements have\n *    className that is an object, which isn't a subtype of string.\n *    Alternative: TypeScript types this as string and types className on\n *    SVGElement as ?.\n */\nElement.prototype.className;\n\n/**\n * @param {string} name\n * @param {?number=} flags\n * @return {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-getAttribute\n * @see http://msdn.microsoft.com/en-us/library/ms536429(VS.85).aspx\n * @nosideeffects\n */\nElement.prototype.getAttribute = function(name, flags) {};\n\n/**\n * @param {string} name\n * @return {Attr}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-getAttributeNode\n * @nosideeffects\n */\nElement.prototype.getAttributeNode = function(name) {};\n\n/**\n * @param {string} tagname\n * @return {!NodeList<!Element>}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1938918D\n * @nosideeffects\n */\nElement.prototype.getElementsByTagName = function(tagname) {};\n\n/**\n * @param {string} name\n * @return {undefined}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-removeAttribute\n */\nElement.prototype.removeAttribute = function(name) {};\n\n/**\n * @param {Attr} oldAttr\n * @return {?Attr}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-removeAttributeNode\n */\nElement.prototype.removeAttributeNode = function(oldAttr) {};\n\n/**\n * @param {string} name\n * @param {string|number|boolean|!TrustedHTML|!TrustedScriptURL|!TrustedURL}\n *     value Values are converted to strings with ToString, so we accept number\n *     and boolean since both convert easily to strings.\n * @return {undefined}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-setAttribute\n */\nElement.prototype.setAttribute = function(name, value) {};\n\n/**\n * @param {Attr} newAttr\n * @return {?Attr}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-setAttributeNode\n */\nElement.prototype.setAttributeNode = function(newAttr) {};\n\n// Event handlers\n// The DOM level 3 spec has a good index of these\n// http://www.w3.org/TR/DOM-Level-3-Events/#event-types\n\n/** @type {?function (Event)} */ Element.prototype.onabort;\n/** @type {?function (Event)} */ Element.prototype.onbeforeinput;\n/** @type {?function (Event)} */ Element.prototype.onbeforeunload;\n/** @type {?function (Event)} */ Element.prototype.onblur;\n/** @type {?function (Event)} */ Element.prototype.onchange;\n/** @type {?function (Event)} */ Element.prototype.onclick;\n/** @type {?function (Event)} */ Element.prototype.oncompositionstart;\n/** @type {?function (Event)} */ Element.prototype.oncompositionupdate;\n/** @type {?function (Event)} */ Element.prototype.oncompositionend;\n/** @type {?function (Event)} */ Element.prototype.oncontextmenu;\n/** @type {?function (Event)} */ Element.prototype.oncopy;\n/** @type {?function (Event)} */ Element.prototype.oncut;\n/** @type {?function (Event)} */ Element.prototype.ondblclick;\n/** @type {?function (Event)} */ Element.prototype.onerror;\n/** @type {?function (Event)} */ Element.prototype.onfocus;\n/** @type {?function (Event)} */ Element.prototype.onfocusin;\n/** @type {?function (Event)} */ Element.prototype.onfocusout;\n/** @type {?function (Event)} */ Element.prototype.oninput;\n/** @type {?function (Event)} */ Element.prototype.onkeydown;\n/** @type {?function (Event)} */ Element.prototype.onkeypress;\n/** @type {?function (Event)} */ Element.prototype.onkeyup;\n/** @type {?function (Event): void} */ Element.prototype.onload;\n/** @type {?function (Event): void} */ Element.prototype.onunload;\n/** @type {?function (Event)} */ Element.prototype.onmousedown;\n/** @type {?function (Event)} */ Element.prototype.onmousemove;\n/** @type {?function (Event)} */ Element.prototype.onmouseout;\n/** @type {?function (Event)} */ Element.prototype.onmouseover;\n/** @type {?function (Event)} */ Element.prototype.onmouseup;\n/** @type {?function (Event)} */ Element.prototype.onmousewheel;\n/** @type {?function (Event)} */ Element.prototype.onpaste;\n/** @type {?function (Event)} */ Element.prototype.onreset;\n/** @type {?function (Event)} */ Element.prototype.onresize;\n/** @type {?function (Event)} */ Element.prototype.onscroll;\n/** @type {?function (Event)} */ Element.prototype.onselect;\n/** @type {?function (Event=)} */ Element.prototype.onsubmit;\n/** @type {?function (Event)} */ Element.prototype.ontextinput;\n/** @type {?function (Event)} */ Element.prototype.onwheel;\n\n/**\n * @constructor\n * @extends {CharacterData}\n * @param {string=} contents Optional textual content.\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1312295772\n */\nfunction Text(contents) {}\n\n/**\n * @param {number} offset\n * @return {Text}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-38853C1D\n */\nText.prototype.splitText = function(offset) {};\n\n/**\n * @constructor\n * @extends {CharacterData}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1728279322\n */\nfunction Comment() {}\n\n/**\n * @constructor\n * @extends {Text}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-667469212\n */\nfunction CDATASection() {}\n\n/**\n * @constructor\n * @extends {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-412266927\n */\nfunction DocumentType() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1844763134\n */\nDocumentType.prototype.name;\n\n/**\n * @constructor\n * @extends {Node}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1004215813\n */\nfunction ProcessingInstruction() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-837822393\n */\nProcessingInstruction.prototype.data;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1478689192\n */\nProcessingInstruction.prototype.target;\n\n\n/**\n * @constructor\n * @implements {EventTarget}\n */\nfunction Window() {}\nWindow.prototype.Window;\n\n/** @override */\nWindow.prototype.addEventListener = function(type, listener, opt_options) {};\n\n/** @override */\nWindow.prototype.removeEventListener = function(type, listener, opt_options) {};\n\n/** @override */\nWindow.prototype.dispatchEvent = function(evt) {};\n\n/** @type {?function (Event)} */ Window.prototype.onabort;\n/** @type {?function (Event)} */ Window.prototype.onbeforeunload;\n/** @type {?function (Event)} */ Window.prototype.onblur;\n/** @type {?function (Event)} */ Window.prototype.onchange;\n/** @type {?function (Event)} */ Window.prototype.onclick;\n/** @type {?function (Event)} */ Window.prototype.onclose;\n/** @type {?function (Event)} */ Window.prototype.oncontextmenu;\n/** @type {?function (Event)} */ Window.prototype.ondblclick;\n/** @type {?function (Event)} */ Window.prototype.ondragdrop;\n// onerror has a special signature.\n// See\n//  https://developer.mozilla.org/en-US/docs/Web/API/GlobalEventHandlers/onerror\n/**\n * @type {?function (string, string, number, number, !Error):?}\n */\nWindow.prototype.onerror;\n/** @type {?function (Event)} */ Window.prototype.onfocus;\n/** @type {?function (Event)} */ Window.prototype.onhashchange;\n/** @type {?function (Event)} */ Window.prototype.onkeydown;\n/** @type {?function (Event)} */ Window.prototype.onkeypress;\n/** @type {?function (Event)} */ Window.prototype.onkeyup;\n/** @type {?function (Event)} */ Window.prototype.onload;\n/** @type {?function (Event)} */ Window.prototype.onmousedown;\n/** @type {?function (Event)} */ Window.prototype.onmousemove;\n/** @type {?function (Event)} */ Window.prototype.onmouseout;\n/** @type {?function (Event)} */ Window.prototype.onmouseover;\n/** @type {?function (Event)} */ Window.prototype.onmouseup;\n/** @type {?function (Event)} */ Window.prototype.onmousewheel;\n/** @type {?function (Event)} */ Window.prototype.onpaint;\n/** @type {?function (Event)} */ Window.prototype.onpopstate;\n/** @type {?function (Event)} */ Window.prototype.onreset;\n/** @type {?function (Event)} */ Window.prototype.onresize;\n/** @type {?function (Event)} */ Window.prototype.onscroll;\n/** @type {?function (Event)} */ Window.prototype.onselect;\n/** @type {?function (Event=)} */ Window.prototype.onsubmit;\n/** @type {?function (Event)} */ Window.prototype.onunhandledrejection;\n/** @type {?function (Event)} */ Window.prototype.onunload;\n/** @type {?function (Event)} */ Window.prototype.onwheel;\n",
"externs/w3c_dom2.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C\'s DOM Level 2 specification.\n *  This file depends on w3c_dom1.js.\n *  The whole file has been fully type annotated.\n *  Created from\n *  http://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html\n *\n * @externs\n */\n\n/**\n * @param {string} s id.\n * @return {Element}\n * @nosideeffects\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#ID-getElBId\n */\nDocument.prototype.getElementById = function(s) {};\n\n/**\n * @param {?string} namespaceURI\n * @param {string} qualifiedName\n * @param {string=} opt_typeExtension\n * @return {!Element}\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#ID-DocCrElNS\n */\nDocument.prototype.createElementNS =\n    function(namespaceURI, qualifiedName, opt_typeExtension) {};\n\n/**\n * @param {?string} namespaceURI\n * @param {string} qualifiedName\n * @return {!Attr}\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#ID-DocCrElNS\n */\nDocument.prototype.createAttributeNS =\n    function(namespaceURI, qualifiedName) {};\n\n/**\n * @param {Node} root\n * @param {number=} whatToShow\n * @param {NodeFilter=} filter\n * @param {boolean=} entityReferenceExpansion\n * @return {!NodeIterator}\n * @see https://www.w3.org/TR/2000/REC-DOM-Level-2-Traversal-Range-20001113/traversal.html#Traversal-Document\n * @see https://dom.spec.whatwg.org/#interface-document\n * @nosideeffects\n */\nDocument.prototype.createNodeIterator = function(\n    root, whatToShow, filter, entityReferenceExpansion) {};\n\n/**\n * @param {Node} root\n * @param {number=} whatToShow\n * @param {NodeFilter=} filter\n * @param {boolean=} entityReferenceExpansion\n * @return {!TreeWalker}\n * @see https://www.w3.org/TR/2000/REC-DOM-Level-2-Traversal-Range-20001113/traversal.html#Traversal-Document\n * @see https://dom.spec.whatwg.org/#interface-document\n * @nosideeffects\n */\nDocument.prototype.createTreeWalker = function(\n    root, whatToShow, filter, entityReferenceExpansion) {};\n\n/**\n * @param {string} namespace\n * @param {string} name\n * @return {!NodeList<!Element>}\n * @nosideeffects\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#ID-getElBTNNS\n */\nDocument.prototype.getElementsByTagNameNS = function(namespace, name) {};\n\n/**\n * @param {!Node} externalNode\n * @param {boolean=} deep\n * @return {!Node}\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#Core-Document-importNode\n */\nDocument.prototype.importNode = function(externalNode, deep) {};\n\n/**\n * @constructor\n * @implements {IObject<(string|number),T>}\n * @implements {IArrayLike<T>}\n * @implements {Iterable<T>}\n * @template T\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75708506\n */\nfunction HTMLCollection() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40057551\n */\nHTMLCollection.prototype.length;\n\n/**\n * @param {number} index\n * @return {T|null}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33262535\n * @nosideeffects\n */\nHTMLCollection.prototype.item = function(index) {};\n\n/**\n * @param {string} name\n * @return {T|null}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-21069976\n * @nosideeffects\n */\nHTMLCollection.prototype.namedItem = function(name) {};\n\n/**\n * @constructor\n * @extends {HTMLCollection<HTMLOptionElement>}\n * @see https://html.spec.whatwg.org/multipage/common-dom-interfaces.html#htmloptionscollection\n */\nfunction HTMLOptionsCollection() {}\n\n/**\n * @type {number}\n * @see https://html.spec.whatwg.org/multipage/common-dom-interfaces.html#dom-htmloptionscollection-length\n * @nosideeffects\n */\nHTMLOptionsCollection.prototype.length;\n\n/**\n * @param {HTMLOptionElement|HTMLOptGroupElement} element\n * @param {HTMLElement|number=} before\n * @return {undefined}\n * @see https://html.spec.whatwg.org/multipage/common-dom-interfaces.html#dom-htmloptionscollection-add\n */\nHTMLOptionsCollection.prototype.add = function(element, before) {};\n\n/**\n * NOTE(tjgq): The HTMLOptionsCollection#item method is inherited from\n * HTMLCollection, but it must be declared explicitly to work around an error\n * when building a jsinterop library for GWT.\n * @param {number} index\n * @return {HTMLOptionElement}\n * @override\n * @nosideeffects\n */\nHTMLOptionsCollection.prototype.item = function(index) {};\n\n/**\n * @param {number} index\n * @return {undefined}\n * @see https://html.spec.whatwg.org/multipage/common-dom-interfaces.html#dom-htmloptionscollection-remove\n */\nHTMLOptionsCollection.prototype.remove = function(index) {};\n\n/**\n * @constructor\n * @extends {Document}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26809268\n */\nfunction HTMLDocument() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18446827\n */\nHTMLDocument.prototype.title;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-95229140\n */\nHTMLDocument.prototype.referrer;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-2250147\n */\nHTMLDocument.prototype.domain;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46183437\n */\nHTMLDocument.prototype.URL;\n\n/**\n * @type {!HTMLBodyElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-56360201\n */\nHTMLDocument.prototype.body;\n\n/**\n * @type {!HTMLCollection<!HTMLImageElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-90379117\n */\nHTMLDocument.prototype.images;\n\n/**\n * @type {!HTMLCollection<!HTMLAppletElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85113862\n */\nHTMLDocument.prototype.applets;\n\n/**\n * @type {!HTMLCollection<(!HTMLAnchorElement|!HTMLAreaElement)>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7068919\n */\nHTMLDocument.prototype.links;\n\n/**\n * @type {!HTMLCollection<!HTMLFormElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-1689064\n */\nHTMLDocument.prototype.forms;\n\n/**\n * @type {!HTMLCollection<!HTMLAnchorElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7577272\n */\nHTMLDocument.prototype.anchors;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8747038\n */\nHTMLDocument.prototype.cookie;\n\n/**\n * @param {string=} opt_mimeType\n * @param {string=} opt_replace\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-72161170\n * Even though official spec says "no parameters" some old browsers might take\n * optional parameters: https://msdn.microsoft.com/en-us/library/ms536652(v=vs.85).aspx\n * @override\n */\nHTMLDocument.prototype.open = function(opt_mimeType, opt_replace) {};\n\n/**\n * @param {string} elementName\n * @return {!NodeList<!Element>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-71555259\n * @nosideeffects\n */\nHTMLDocument.prototype.getElementsByName = function(elementName) {};\n\n\n/** @typedef {{\n  createNodeIterator: function(Node, number=, NodeFilter=, boolean=) : NodeIterator,\n  createTreeWalker: function(Node, number=, NodeFilter=, boolean=) : TreeWalker\n}} */\nvar TraversalDocument;\n\n/**\n * @record\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeFilter\n*/\nfunction NodeFilter() {}\n\n/* Constants for whatToShow */\n/** @const {number} */ NodeFilter.SHOW_ALL;\n/** @const {number} */ NodeFilter.SHOW_ATTRIBUTE;\n/** @const {number} */ NodeFilter.SHOW_CDATA_SECTION;\n/** @const {number} */ NodeFilter.SHOW_COMMENT;\n/** @const {number} */ NodeFilter.SHOW_DOCUMENT;\n/** @const {number} */ NodeFilter.SHOW_DOCUMENT_FRAGMENT;\n/** @const {number} */ NodeFilter.SHOW_DOCUMENT_TYPE;\n/** @const {number} */ NodeFilter.SHOW_ELEMENT;\n/** @const {number} */ NodeFilter.SHOW_ENTITY;\n/** @const {number} */ NodeFilter.SHOW_ENTITY_REFERENCE;\n/** @const {number} */ NodeFilter.SHOW_NOTATION;\n/** @const {number} */ NodeFilter.SHOW_PROCESSING_INSTRUCTION;\n/** @const {number} */ NodeFilter.SHOW_TEXT;\n\n/* Consants for acceptNode */\n/** @const {number} */ NodeFilter.FILTER_ACCEPT;\n/** @const {number} */ NodeFilter.FILTER_REJECT;\n/** @const {number} */ NodeFilter.FILTER_SKIP;\n\n/**\n * @param {Node} n\n * @return {number} Any of NodeFilter.FILTER_* constants.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeFilter-acceptNode\n*/\nNodeFilter.prototype.acceptNode = function(n) {};\n\n/**\n * @interface\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator\n*/\nfunction NodeIterator() {}\n\n/**\n * Detach and invalidate the NodeIterator.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-detach\n * @return {undefined}\n */\nNodeIterator.prototype.detach = function() {};\n\n/**\n * @return {Node} Next node in the set.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-nextNode\n */\nNodeIterator.prototype.nextNode = function() {};\n\n/**\n * @return {Node} Previous node in the set.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-previousNode\n */\nNodeIterator.prototype.previousNode = function() {};\n\n/**\n * @interface\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker\n*/\nfunction TreeWalker() {}\n\n/**\n * @return {?Node} The new Node or null.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-firstChild\n */\nTreeWalker.prototype.firstChild = function() {};\n\n/**\n * @return {?Node} The new Node or null..\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-lastChild\n */\nTreeWalker.prototype.lastChild = function() {};\n\n/**\n * @return {?Node} The new Node or null.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-nextNode\n */\nTreeWalker.prototype.nextNode = function() {};\n\n/**\n * @return {?Node} The new Node or null.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-nextSibling\n */\nTreeWalker.prototype.nextSibling = function() {};\n\n/**\n * @return {?Node} The new Node or null.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-parentNode\n */\nTreeWalker.prototype.parentNode = function() {};\n\n/**\n * @return {?Node} The new Node or null.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-previousNode\n */\nTreeWalker.prototype.previousNode = function() {};\n\n/**\n * @return {?Node} The new Node or null.\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-previousSibling\n */\nTreeWalker.prototype.previousSibling = function() {};\n\n/**\n * @type {Node}\n */\nTreeWalker.prototype.root;\n\n/**\n * @type {number}\n */\nTreeWalker.prototype.whatToShow;\n\n/**\n * @type {NodeFilter}\n */\nTreeWalker.prototype.filter;\n\n/**\n * @type {boolean}\n */\nTreeWalker.prototype.expandEntityReference;\n\n/**\n * @type {Node}\n */\nTreeWalker.prototype.currentNode;\n\n/**\n * @constructor\n * @extends {Element}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58190037\n */\nfunction HTMLElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-78276800\n */\nHTMLElement.prototype.title;\n\n/**\n * @type {!CSSStyleDeclaration}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-ElementCSSInlineStyle\n */\nHTMLElement.prototype.style;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59132807\n */\nHTMLElement.prototype.lang;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52460740\n */\nHTMLElement.prototype.dir;\n\n/**\n * @implicitCast\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-95362176\n */\nHTMLElement.prototype.className;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40676705\n */\nHTMLElement.prototype.tabIndex;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33759296\n */\nfunction HTMLHtmlElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-9383775\n */\nHTMLHtmlElement.prototype.version;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77253168\n */\nfunction HTMLHeadElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96921909\n */\nHTMLHeadElement.prototype.profile;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @implements {LinkStyle}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35143001\n */\nfunction HTMLLinkElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87355129\n */\nHTMLLinkElement.prototype.disabled;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63954491\n */\nHTMLLinkElement.prototype.charset;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33532588\n */\nHTMLLinkElement.prototype.href;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85145682\n */\nHTMLLinkElement.prototype.hreflang;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75813125\n */\nHTMLLinkElement.prototype.media;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-41369587\n */\nHTMLLinkElement.prototype.rel;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40715461\n */\nHTMLLinkElement.prototype.rev;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84183095\n */\nHTMLLinkElement.prototype.target;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32498296\n */\nHTMLLinkElement.prototype.type;\n\n/** @type {StyleSheet} */\nHTMLLinkElement.prototype.sheet;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79243169\n */\nfunction HTMLTitleElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77500413\n */\nHTMLTitleElement.prototype.text;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-37041454\n */\nfunction HTMLMetaElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87670826\n */\nHTMLMetaElement.prototype.content;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77289449\n */\nHTMLMetaElement.prototype.httpEquiv;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-31037081\n */\nHTMLMetaElement.prototype.name;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35993789\n */\nHTMLMetaElement.prototype.scheme;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-73629039\n */\nfunction HTMLBaseElement() {}\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-65382887\n */\nHTMLBaseElement.prototype.href;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-73844298\n */\nHTMLBaseElement.prototype.target;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85283003\n */\nfunction HTMLIsIndexElement() {}\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87069980\n */\nHTMLIsIndexElement.prototype.form;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33589862\n */\nHTMLIsIndexElement.prototype.prompt;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @implements {LinkStyle}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-16428977\n */\nfunction HTMLStyleElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-51162010\n */\nHTMLStyleElement.prototype.disabled;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76412738\n */\nHTMLStyleElement.prototype.media;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22472002\n */\nHTMLStyleElement.prototype.type;\n\n/** @type {StyleSheet} */\nHTMLStyleElement.prototype.sheet;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-62018039\n */\nfunction HTMLBodyElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59424581\n */\nHTMLBodyElement.prototype.aLink;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-37574810\n */\nHTMLBodyElement.prototype.background;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-24940084\n */\nHTMLBodyElement.prototype.bgColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7662206\n */\nHTMLBodyElement.prototype.link;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-73714763\n */\nHTMLBodyElement.prototype.text;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83224305\n */\nHTMLBodyElement.prototype.vLink;\n\n/**\n * @constructor\n * @extends {HTMLCollection<T>}\n * @implements {IObject<string, (T|RadioNodeList<T>)>}\n * @implements {IArrayLike<T>}\n * @template T\n * @see https://html.spec.whatwg.org/multipage/infrastructure.html#the-htmlformcontrolscollection-interface\n */\nfunction HTMLFormControlsCollection() {}\n\n/**\n * @param {string} name\n * @return {T|RadioNodeList<T>|null}\n * @see https://html.spec.whatwg.org/multipage/infrastructure.html#dom-htmlformcontrolscollection-nameditem\n * @nosideeffects\n * @override\n */\nHTMLFormControlsCollection.prototype.namedItem = function(name) {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40002357\n */\nfunction HTMLFormElement() {}\n\n/**\n * @type {!HTMLFormControlsCollection<!HTMLElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76728479\n */\nHTMLFormElement.prototype.elements;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#HTML-HTMLFormElement-length\n */\nHTMLFormElement.prototype.length;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22051454\n */\nHTMLFormElement.prototype.name;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-19661795\n */\nHTMLFormElement.prototype.acceptCharset;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-74049184\n */\nHTMLFormElement.prototype.action;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84227810\n */\nHTMLFormElement.prototype.enctype;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-82545539\n */\nHTMLFormElement.prototype.method;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6512890\n */\nHTMLFormElement.prototype.target;\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76767676\n */\nHTMLFormElement.prototype.submit = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76767677\n */\nHTMLFormElement.prototype.reset = function() {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-94282980\n */\nfunction HTMLSelectElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58783172\n */\nHTMLSelectElement.prototype.type;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85676760\n */\nHTMLSelectElement.prototype.selectedIndex;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59351919\n */\nHTMLSelectElement.prototype.value;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-5933486\n */\nHTMLSelectElement.prototype.length;\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-20489458\n */\nHTMLSelectElement.prototype.form;\n\n/**\n * @type {!HTMLOptionsCollection}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-30606413\n */\nHTMLSelectElement.prototype.options;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79102918\n */\nHTMLSelectElement.prototype.disabled;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13246613\n */\nHTMLSelectElement.prototype.multiple;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-41636323\n */\nHTMLSelectElement.prototype.name;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18293826\n */\nHTMLSelectElement.prototype.size;\n\n/**\n * @param {HTMLElement} element\n * @param {HTMLElement=} opt_before\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14493106\n */\nHTMLSelectElement.prototype.add = function(element, opt_before) {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-28216144\n * @override\n */\nHTMLSelectElement.prototype.blur = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32130014\n * @override\n */\nHTMLSelectElement.prototype.focus = function() {};\n\n/**\n * @param {number=} opt_index\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33404570\n * @override\n */\nHTMLSelectElement.prototype.remove = function(opt_index) {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38450247\n */\nfunction HTMLOptGroupElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-15518803\n */\nHTMLOptGroupElement.prototype.disabled;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-95806054\n */\nHTMLOptGroupElement.prototype.label;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70901257\n */\nfunction HTMLOptionElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-37770574\n */\nHTMLOptionElement.prototype.defaultSelected;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-23482473\n */\nHTMLOptionElement.prototype.disabled;\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-17116503\n */\nHTMLOptionElement.prototype.form;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14038413\n */\nHTMLOptionElement.prototype.index;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40736115\n */\nHTMLOptionElement.prototype.label;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70874476\n */\nHTMLOptionElement.prototype.selected;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-48154426\n */\nHTMLOptionElement.prototype.text;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6185554\n */\nHTMLOptionElement.prototype.value;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6043025\n */\nfunction HTMLInputElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-15328520\n */\nHTMLInputElement.prototype.accept;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59914154\n */\nHTMLInputElement.prototype.accessKey;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96991182\n */\nHTMLInputElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-92701314\n */\nHTMLInputElement.prototype.alt;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-30233917\n */\nHTMLInputElement.prototype.checked;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-20509171\n */\nHTMLInputElement.prototype.defaultChecked;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26091157\n */\nHTMLInputElement.prototype.defaultValue;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-50886781\n */\nHTMLInputElement.prototype.disabled;\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63239895\n */\nHTMLInputElement.prototype.form;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-54719353\n */\nHTMLInputElement.prototype.maxLength;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-89658498\n */\nHTMLInputElement.prototype.name;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88461592\n */\nHTMLInputElement.prototype.readOnly;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79659438\n */\nHTMLInputElement.prototype.size;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-97320704\n */\nHTMLInputElement.prototype.src;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-62176355\n */\nHTMLInputElement.prototype.tabIndex;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-62883744\n */\nHTMLInputElement.prototype.type;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32463706\n */\nHTMLInputElement.prototype.useMap;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-49531485\n */\nHTMLInputElement.prototype.value;\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26838235\n * @override\n */\nHTMLInputElement.prototype.blur = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-2651361\n * @override\n */\nHTMLInputElement.prototype.click = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-65996295\n * @override\n */\nHTMLInputElement.prototype.focus = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-34677168\n */\nHTMLInputElement.prototype.select = function() {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-24874179\n */\nfunction HTMLTextAreaElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-93102991\n */\nHTMLTextAreaElement.prototype.accessKey;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-51387225\n */\nHTMLTextAreaElement.prototype.cols;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-36152213\n */\nHTMLTextAreaElement.prototype.defaultValue;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-98725443\n */\nHTMLTextAreaElement.prototype.disabled;\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18911464\n */\nHTMLTextAreaElement.prototype.form;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70715578\n */\nHTMLTextAreaElement.prototype.name;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39131423\n */\nHTMLTextAreaElement.prototype.readOnly;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46975887\n */\nHTMLTextAreaElement.prototype.rows;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-60363303\n */\nHTMLTextAreaElement.prototype.tabIndex;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#HTML-HTMLTextAreaElement-type\n */\nHTMLTextAreaElement.prototype.type;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70715579\n */\nHTMLTextAreaElement.prototype.value;\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6750689\n * @override\n */\nHTMLTextAreaElement.prototype.blur = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39055426\n * @override\n */\nHTMLTextAreaElement.prototype.focus = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-48880622\n */\nHTMLTextAreaElement.prototype.select = function() {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-34812697\n */\nfunction HTMLButtonElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-73169431\n */\nHTMLButtonElement.prototype.accessKey;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-92757155\n */\nHTMLButtonElement.prototype.disabled;\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-71254493\n */\nHTMLButtonElement.prototype.form;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11029910\n */\nHTMLButtonElement.prototype.name;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39190908\n */\nHTMLButtonElement.prototype.tabIndex;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-27430092\n */\nHTMLButtonElement.prototype.type;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-72856782\n */\nHTMLButtonElement.prototype.value;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13691394\n */\nfunction HTMLLabelElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-43589892\n */\nHTMLLabelElement.prototype.accessKey;\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32480901\n */\nHTMLLabelElement.prototype.form;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96509813\n */\nHTMLLabelElement.prototype.htmlFor;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7365882\n */\nfunction HTMLFieldSetElement() {}\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75392630\n */\nHTMLFieldSetElement.prototype.form;\n\n/**\n * @type {boolean}\n * @see https://www.w3.org/TR/html5/forms.html#attr-fieldset-disabled\n */\nHTMLFieldSetElement.prototype.disabled;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-21482039\n */\nfunction HTMLLegendElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11297832\n */\nHTMLLegendElement.prototype.accessKey;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79538067\n */\nHTMLLegendElement.prototype.align;\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-29594519\n */\nHTMLLegendElement.prototype.form;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-86834457\n */\nfunction HTMLUListElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39864178\n */\nHTMLUListElement.prototype.compact;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96874670\n */\nHTMLUListElement.prototype.type;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58056027\n */\nfunction HTMLOListElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76448506\n */\nHTMLOListElement.prototype.compact;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14793325\n */\nHTMLOListElement.prototype.start;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40971103\n */\nHTMLOListElement.prototype.type;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52368974\n */\nfunction HTMLDListElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-21738539\n */\nHTMLDListElement.prototype.compact;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-71600284\n */\nfunction HTMLDirectoryElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75317739\n */\nHTMLDirectoryElement.prototype.compact;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-72509186\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html#the-menu-element\n */\nfunction HTMLMenuElement() {}\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68436464\n */\nHTMLMenuElement.prototype.compact;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-74680021\n */\nfunction HTMLLIElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52387668\n */\nHTMLLIElement.prototype.type;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-45496263\n */\nHTMLLIElement.prototype.value;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22445964\n */\nfunction HTMLDivElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70908791\n */\nHTMLDivElement.prototype.align;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84675076\n */\nfunction HTMLParagraphElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53465507\n */\nHTMLParagraphElement.prototype.align;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-43345119\n */\nfunction HTMLHeadingElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6796462\n */\nHTMLHeadingElement.prototype.align;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70319763\n */\nfunction HTMLQuoteElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53895598\n */\nHTMLQuoteElement.prototype.cite;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11383425\n */\nfunction HTMLPreElement() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13894083\n */\nHTMLPreElement.prototype.width;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-56836063\n */\nfunction HTMLBRElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-82703081\n */\nHTMLBRElement.prototype.clear;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32774408\n */\nfunction HTMLBaseFontElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87502302\n */\nHTMLBaseFontElement.prototype.color;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88128969\n */\nHTMLBaseFontElement.prototype.face;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38930424\n */\nHTMLBaseFontElement.prototype.size;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-43943847\n */\nfunction HTMLFontElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53532975\n */\nHTMLFontElement.prototype.color;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-55715655\n */\nHTMLFontElement.prototype.face;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-90127284\n */\nHTMLFontElement.prototype.size;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68228811\n */\nfunction HTMLHRElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-15235012\n */\nHTMLHRElement.prototype.align;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79813978\n */\nHTMLHRElement.prototype.noShade;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77612587\n */\nHTMLHRElement.prototype.size;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87744198\n */\nHTMLHRElement.prototype.width;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79359609\n */\nfunction HTMLModElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75101708\n */\nHTMLModElement.prototype.cite;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88432678\n */\nHTMLModElement.prototype.dateTime;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-48250443\n */\nfunction HTMLAnchorElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-89647724\n */\nHTMLAnchorElement.prototype.accessKey;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67619266\n */\nHTMLAnchorElement.prototype.charset;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-92079539\n */\nHTMLAnchorElement.prototype.coords;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88517319\n */\nHTMLAnchorElement.prototype.href;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87358513\n */\nHTMLAnchorElement.prototype.hreflang;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32783304\n */\nHTMLAnchorElement.prototype.name;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-3815891\n */\nHTMLAnchorElement.prototype.rel;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58259771\n */\nHTMLAnchorElement.prototype.rev;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-49899808\n */\nHTMLAnchorElement.prototype.shape;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-41586466\n */\nHTMLAnchorElement.prototype.tabIndex;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6414197\n */\nHTMLAnchorElement.prototype.target;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63938221\n */\nHTMLAnchorElement.prototype.type;\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-65068939\n * @override\n */\nHTMLAnchorElement.prototype.blur = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-47150313\n * @override\n */\nHTMLAnchorElement.prototype.focus = function() {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-17701901\n */\nfunction HTMLImageElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-3211094\n */\nHTMLImageElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-95636861\n */\nHTMLImageElement.prototype.alt;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-136671\n */\nHTMLImageElement.prototype.border;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-91561496\n */\nHTMLImageElement.prototype.height;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53675471\n */\nHTMLImageElement.prototype.hspace;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58983880\n */\nHTMLImageElement.prototype.isMap;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77376969\n */\nHTMLImageElement.prototype.longDesc;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-91256910\n */\nHTMLImageElement.prototype.lowSrc;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-47534097\n */\nHTMLImageElement.prototype.name;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87762984\n */\nHTMLImageElement.prototype.src;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35981181\n */\nHTMLImageElement.prototype.useMap;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85374897\n */\nHTMLImageElement.prototype.vspace;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13839076\n */\nHTMLImageElement.prototype.width;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-9893177\n */\nfunction HTMLObjectElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-16962097\n */\nHTMLObjectElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-47783837\n */\nHTMLObjectElement.prototype.archive;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-82818419\n */\nHTMLObjectElement.prototype.border;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75241146\n */\nHTMLObjectElement.prototype.code;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-25709136\n */\nHTMLObjectElement.prototype.codeBase;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-19945008\n */\nHTMLObjectElement.prototype.codeType;\n\n/**\n * @type {Document}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38538621\n */\nHTMLObjectElement.prototype.contentDocument;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-81766986\n */\nHTMLObjectElement.prototype.data;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-942770\n */\nHTMLObjectElement.prototype.declare;\n\n/**\n * @type {HTMLFormElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46094773\n */\nHTMLObjectElement.prototype.form;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88925838\n */\nHTMLObjectElement.prototype.height;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-17085376\n */\nHTMLObjectElement.prototype.hspace;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-20110362\n */\nHTMLObjectElement.prototype.name;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-25039673\n */\nHTMLObjectElement.prototype.standby;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-27083787\n */\nHTMLObjectElement.prototype.tabIndex;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-91665621\n */\nHTMLObjectElement.prototype.type;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6649772\n */\nHTMLObjectElement.prototype.useMap;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8682483\n */\nHTMLObjectElement.prototype.vspace;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38538620\n */\nHTMLObjectElement.prototype.width;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-64077273\n */\nfunction HTMLParamElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59871447\n */\nHTMLParamElement.prototype.name;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18179888\n */\nHTMLParamElement.prototype.type;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77971357\n */\nHTMLParamElement.prototype.value;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-23931872\n */\nHTMLParamElement.prototype.valueType;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-31006348\n */\nfunction HTMLAppletElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8049912\n */\nHTMLAppletElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58610064\n */\nHTMLAppletElement.prototype.alt;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14476360\n */\nHTMLAppletElement.prototype.archive;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-61509645\n */\nHTMLAppletElement.prototype.code;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6581160\n */\nHTMLAppletElement.prototype.codeBase;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-90184867\n */\nHTMLAppletElement.prototype.height;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-1567197\n */\nHTMLAppletElement.prototype.hspace;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39843695\n */\nHTMLAppletElement.prototype.name;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-93681523\n */\nHTMLAppletElement.prototype.object;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22637173\n */\nHTMLAppletElement.prototype.vspace;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-16526327\n */\nHTMLAppletElement.prototype.width;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-94109203\n */\nfunction HTMLMapElement() {}\n\n/**\n * @type {HTMLCollection<!HTMLAreaElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-71838730\n */\nHTMLMapElement.prototype.areas;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52696514\n */\nHTMLMapElement.prototype.name;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26019118\n */\nfunction HTMLAreaElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-57944457\n */\nHTMLAreaElement.prototype.accessKey;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39775416\n */\nHTMLAreaElement.prototype.alt;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-66021476\n */\nHTMLAreaElement.prototype.coords;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-34672936\n */\nHTMLAreaElement.prototype.href;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-61826871\n */\nHTMLAreaElement.prototype.noHref;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85683271\n */\nHTMLAreaElement.prototype.shape;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8722121\n */\nHTMLAreaElement.prototype.tabIndex;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46054682\n */\nHTMLAreaElement.prototype.target;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-81598695\n */\nfunction HTMLScriptElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35305677\n */\nHTMLScriptElement.prototype.charset;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-93788534\n */\nHTMLScriptElement.prototype.defer;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-56700403\n */\nHTMLScriptElement.prototype.event;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-66979266\n */\nHTMLScriptElement.prototype.htmlFor;\n\n/**\n * @type {?function(!Event)}\n */\nHTMLScriptElement.prototype.onreadystatechange;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75147231\n */\nHTMLScriptElement.prototype.src;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46872999\n */\nHTMLScriptElement.prototype.text;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-30534818\n */\nHTMLScriptElement.prototype.type;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-64060425\n */\nfunction HTMLTableElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-23180977\n */\nHTMLTableElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83532985\n */\nHTMLTableElement.prototype.bgColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-50969400\n */\nHTMLTableElement.prototype.border;\n\n/**\n * @type {HTMLTableCaptionElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14594520\n */\nHTMLTableElement.prototype.caption;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59162158\n */\nHTMLTableElement.prototype.cellPadding;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68907883\n */\nHTMLTableElement.prototype.cellSpacing;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-64808476\n */\nHTMLTableElement.prototype.frame;\n\n/**\n * @type {HTMLCollection<!HTMLTableRowElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6156016\n */\nHTMLTableElement.prototype.rows;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26347553\n */\nHTMLTableElement.prototype.rules;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-44998528\n */\nHTMLTableElement.prototype.summary;\n\n/**\n * @type {HTMLCollection<!HTMLTableSectionElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63206416\n */\nHTMLTableElement.prototype.tBodies;\n\n/**\n * @type {HTMLTableSectionElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-64197097\n */\nHTMLTableElement.prototype.tFoot;\n\n/**\n * @type {HTMLTableSectionElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-9530944\n */\nHTMLTableElement.prototype.tHead;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77447361\n */\nHTMLTableElement.prototype.width;\n\n/**\n * @return {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96920263\n */\nHTMLTableElement.prototype.createCaption = function() {};\n\n/**\n * @return {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8453710\n */\nHTMLTableElement.prototype.createTFoot = function() {};\n\n/**\n * @return {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70313345\n */\nHTMLTableElement.prototype.createTHead = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22930071\n */\nHTMLTableElement.prototype.deleteCaption = function() {};\n\n/**\n * @param {number} index\n * @return {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13114938\n */\nHTMLTableElement.prototype.deleteRow = function(index) {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-78363258\n */\nHTMLTableElement.prototype.deleteTFoot = function() {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38310198\n */\nHTMLTableElement.prototype.deleteTHead = function() {};\n\n/**\n * @param {number=} opt_index\n * @return {HTMLElement}\n * @see https://www.w3.org/TR/html5/tabular-data.html#htmltableelement\n */\nHTMLTableElement.prototype.insertRow = function(opt_index) {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-12035137\n */\nfunction HTMLTableCaptionElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79875068\n */\nHTMLTableCaptionElement.prototype.align;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84150186\n */\nfunction HTMLTableColElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-31128447\n */\nHTMLTableColElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-9447412\n */\nHTMLTableColElement.prototype.ch;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-57779225\n */\nHTMLTableColElement.prototype.chOff;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96511335\n */\nHTMLTableColElement.prototype.span;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83291710\n */\nHTMLTableColElement.prototype.vAlign;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-25196799\n */\nHTMLTableColElement.prototype.width;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67417573\n */\nfunction HTMLTableSectionElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40530119\n */\nHTMLTableSectionElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83470012\n */\nHTMLTableSectionElement.prototype.ch;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53459732\n */\nHTMLTableSectionElement.prototype.chOff;\n\n/**\n * @type {HTMLCollection<!HTMLTableRowElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52092650\n */\nHTMLTableSectionElement.prototype.rows;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-4379116\n */\nHTMLTableSectionElement.prototype.vAlign;\n\n/**\n * @param {number} index\n * @return {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-5625626\n */\nHTMLTableSectionElement.prototype.deleteRow = function(index) {};\n\n/**\n * @param {number=} opt_index\n * @return {HTMLElement}\n * @see https://www.w3.org/TR/html5/tabular-data.html#htmltablesectionelement\n */\nHTMLTableSectionElement.prototype.insertRow = function(opt_index) {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6986576\n */\nfunction HTMLTableRowElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-74098257\n */\nHTMLTableRowElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18161327\n */\nHTMLTableRowElement.prototype.bgColor;\n\n/**\n * @type {HTMLCollection<!HTMLTableCellElement>}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67349879\n */\nHTMLTableRowElement.prototype.cells;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-16230502\n */\nHTMLTableRowElement.prototype.ch;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68207461\n */\nHTMLTableRowElement.prototype.chOff;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67347567\n */\nHTMLTableRowElement.prototype.rowIndex;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79105901\n */\nHTMLTableRowElement.prototype.sectionRowIndex;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-90000058\n */\nHTMLTableRowElement.prototype.vAlign;\n\n/**\n * @param {number} index\n * @return {undefined}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11738598\n */\nHTMLTableRowElement.prototype.deleteCell = function(index) {};\n\n/**\n * @param {number} index\n * @return {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68927016\n */\nHTMLTableRowElement.prototype.insertCell = function(index) {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-82915075\n */\nfunction HTMLTableCellElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-74444037\n */\nHTMLTableCellElement.prototype.abbr;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-98433879\n */\nHTMLTableCellElement.prototype.align;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76554418\n */\nHTMLTableCellElement.prototype.axis;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88135431\n */\nHTMLTableCellElement.prototype.bgColor;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-80748363\n */\nHTMLTableCellElement.prototype.cellIndex;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-30914780\n */\nHTMLTableCellElement.prototype.ch;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-20144310\n */\nHTMLTableCellElement.prototype.chOff;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84645244\n */\nHTMLTableCellElement.prototype.colSpan;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-89104817\n */\nHTMLTableCellElement.prototype.headers;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83679212\n */\nHTMLTableCellElement.prototype.height;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-62922045\n */\nHTMLTableCellElement.prototype.noWrap;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-48237625\n */\nHTMLTableCellElement.prototype.rowSpan;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-36139952\n */\nHTMLTableCellElement.prototype.scope;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58284221\n */\nHTMLTableCellElement.prototype.vAlign;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-27480795\n */\nHTMLTableCellElement.prototype.width;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-43829095\n */\nfunction HTMLFrameSetElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-98869594\n */\nHTMLFrameSetElement.prototype.cols;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-19739247\n */\nHTMLFrameSetElement.prototype.rows;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-97790553\n */\nfunction HTMLFrameElement() {}\n\n/**\n * @type {Document}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-78799536\n */\nHTMLFrameElement.prototype.contentDocument;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11858633\n */\nHTMLFrameElement.prototype.frameBorder;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7836998\n */\nHTMLFrameElement.prototype.longDesc;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-55569778\n */\nHTMLFrameElement.prototype.marginHeight;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8369969\n */\nHTMLFrameElement.prototype.marginWidth;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-91128709\n */\nHTMLFrameElement.prototype.name;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-80766578\n */\nHTMLFrameElement.prototype.noResize;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-45411424\n */\nHTMLFrameElement.prototype.scrolling;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-78799535\n */\nHTMLFrameElement.prototype.src;\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-50708718\n */\nfunction HTMLIFrameElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11309947\n */\nHTMLIFrameElement.prototype.align;\n\n/**\n * @type {Document}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67133006\n */\nHTMLIFrameElement.prototype.contentDocument;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22463410\n */\nHTMLIFrameElement.prototype.frameBorder;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-1678118\n */\nHTMLIFrameElement.prototype.height;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70472105\n */\nHTMLIFrameElement.prototype.longDesc;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-91371294\n */\nHTMLIFrameElement.prototype.marginHeight;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-66486595\n */\nHTMLIFrameElement.prototype.marginWidth;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96819659\n */\nHTMLIFrameElement.prototype.name;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-36369822\n */\nHTMLIFrameElement.prototype.scrolling;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-43933957\n */\nHTMLIFrameElement.prototype.src;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67133005\n */\nHTMLIFrameElement.prototype.width;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-258A00AF\n */\nDOMException.INVALID_STATE_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-258A00AF\n */\nDOMException.SYNTAX_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-258A00AF\n */\nDOMException.INVALID_MODIFICATION_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-258A00AF\n */\nDOMException.NAMESPACE_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-258A00AF\n */\nDOMException.INVALID_ACCESS_ERR;\n/**\n * @type {boolean}\n * @see https://developer.mozilla.org/en/DOM/window.closed\n */\nWindow.prototype.closed;\n\n/**\n * @type {HTMLObjectElement|HTMLIFrameElement|null}\n * @see https://developer.mozilla.org/en/DOM/window.frameElement\n */\nWindow.prototype.frameElement;\n\n/**\n * Allows lookup of frames by index or by name.\n * @type {!Window}\n * @see https://developer.mozilla.org/en/DOM/window.frames\n */\nWindow.prototype.frames;\n\n/**\n * @type {!History}\n * @suppress {duplicate}\n * @see https://developer.mozilla.org/en/DOM/window.history\n */\nvar history;\n\n/**\n * @type {!History}\n * @see https://developer.mozilla.org/en/DOM/window.history\n */\nWindow.prototype.history;\n\n/**\n * Returns the number of frames (either frame or iframe elements) in the\n * window.\n *\n * @type {number}\n * @see https://developer.mozilla.org/en/DOM/window.length\n */\nWindow.prototype.length;\n\n/**\n * Location has an exception in the DeclaredGlobalExternsOnWindow pass\n * so we have to manually include it:\n * https://github.com/google/closure-compiler/blob/master/src/com/google/javascript/jscomp/DeclaredGlobalExternsOnWindow.java#L116\n *\n * @type {!Location}\n * @implicitCast\n * @see https://developer.mozilla.org/en/DOM/window.location\n */\nWindow.prototype.location;\n\n/**\n\n * @type {string}\n * @see https://developer.mozilla.org/en/DOM/window.name\n */\nWindow.prototype.name;\n\n/**\n * @type {Navigator}\n * @see https://developer.mozilla.org/en/DOM/window.navigator\n */\nWindow.prototype.navigator;\n\n/**\n * @type {?Window}\n * @see https://developer.mozilla.org/en/DOM/window.opener\n */\nWindow.prototype.opener;\n\n/**\n * @type {!Window}\n * @see https://developer.mozilla.org/en/DOM/window.parent\n */\nWindow.prototype.parent;\n\n/**\n * @type {!Window}\n * @see https://developer.mozilla.org/en/DOM/window.self\n */\nWindow.prototype.self;\n\n/**\n * @type {?string}\n * @see https://developer.mozilla.org/en/DOM/window.status\n */\nWindow.prototype.status;\n\n/**\n * @interface\n * @see https://html.spec.whatwg.org/multipage/window-object.html#the-status-bar-barprop-object\n */\nfunction BarProp() {}\n\n/** @const {boolean} */\nBarProp.prototype.visible;\n\n/**\n * @type {!BarProp}\n * @see https://developer.mozilla.org/en/DOM/window.locationbar\n */\nWindow.prototype.locationbar;\n\n/**\n * @type {!BarProp}\n * @see https://developer.mozilla.org/en/DOM/window.menubar\n */\nWindow.prototype.menubar;\n\n/**\n * @type {!BarProp}\n * @see https://developer.mozilla.org/en/DOM/window.personalbar\n */\nWindow.prototype.personalbar;\n\n\n/**\n * @type {!BarProp}\n * @see https://developer.mozilla.org/en/DOM/window.scrollbars\n */\nWindow.prototype.scrollbars;\n\n/**\n * @type {!BarProp}\n * @see https://developer.mozilla.org/en/DOM/window.statusbar\n */\nWindow.prototype.statusbar;\n\n/**\n * @type {!BarProp}\n * @see https://developer.mozilla.org/en/DOM/window.toolbar\n */\nWindow.prototype.toolbar;\n\n/**\n * @type {!Window}\n * @see https://developer.mozilla.org/en/DOM/window.self\n */\nWindow.prototype.top;\n\n/**\n * @type {!Window}\n * @see https://developer.mozilla.org/en/DOM/window.self\n */\nWindow.prototype.window;\n\n/**\n * @param {*} message\n * @see https://developer.mozilla.org/en/DOM/window.alert\n * @return {undefined}\n */\nWindow.prototype.alert = function(message) {};\n\n/**\n * @param {*} message\n * @return {boolean}\n * @see https://developer.mozilla.org/en/DOM/window.confirm\n */\nWindow.prototype.confirm = function(message) {};\n\n/**\n * @param {string} message\n * @param {string=} value\n * @return {?string}\n * @see https://developer.mozilla.org/en/DOM/window.prompt\n */\nWindow.prototype.prompt = function(message, value) {};\n\n/**\n * @see https://developer.mozilla.org/en/DOM/window.blur\n * @return {undefined}\n */\nWindow.prototype.blur = function() {};\n\n/**\n * @see https://developer.mozilla.org/en/DOM/window.close\n * @return {undefined}\n */\nWindow.prototype.close = function() {};\n\n/**\n * @see https://developer.mozilla.org/en/DOM/window.focus\n * @return {undefined}\n */\nWindow.prototype.focus = function() {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Window/print\n * @return {undefined}\n */\nWindow.prototype.print = function() {};\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Window/stop\n * @return {undefined}\n */\nWindow.prototype.stop = function() {};\n\n/**\n * @param {*=} url\n * @param {string=} windowName\n * @param {string=} windowFeatures\n * @param {boolean=} replace\n * @return {Window}\n * @see http://msdn.microsoft.com/en-us/library/ms536651(VS.85).aspx\n */\nWindow.prototype.open = function(url, windowName, windowFeatures, replace) {};\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Element/innerHTML\n * @implicitCast\n */\nElement.prototype.innerHTML;\n\n/**\n * @type {string}\n * @implicitCast\n * @see https://w3c.github.io/DOM-Parsing/#extensions-to-the-element-interface\n */\nElement.prototype.outerHTML;\n\n',
"externs/w3c_dom3.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C\'s DOM Level 3 specification.\n *  This file depends on w3c_dom2.js.\n *  The whole file has been fully type annotated.\n *  Created from\n *   http://www.w3.org/TR/DOM-Level-3-Core/ecma-script-binding.html\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n * @author stevey@google.com (Steve Yegge)\n */\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-258A00AF\n */\nDOMException.prototype.code;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-258A00AF\n */\nDOMException.VALIDATION_ERR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-258A00AF\n */\nDOMException.TYPE_MISMATCH_ERR;\n\n/**\n * @constructor\n * @implements {IArrayLike<string>}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMStringList\n */\nfunction DOMStringList() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMStringList-length\n */\nDOMStringList.prototype.length;\n\n/**\n * @param {string} str\n * @return {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMStringList-contains\n * @nosideeffects\n */\nDOMStringList.prototype.contains = function(str) {};\n\n/**\n * @param {number} index\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMStringList-item\n * @nosideeffects\n */\nDOMStringList.prototype.item = function(index) {};\n\n/**\n * @constructor\n * @implements {IArrayLike<!DOMImplementation>}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMImplementationList\n */\nfunction DOMImplementationList() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMImplementationList-length\n */\nDOMImplementationList.prototype.length;\n\n/**\n * @param {number} index\n * @return {DOMImplementation}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMImplementationList-item\n * @nosideeffects\n */\nDOMImplementationList.prototype.item = function(index) {};\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMImplementationSource\n */\nfunction DOMImplementationSource() {}\n\n/**\n * @param {?string} namespaceURI\n * @param {string} publicId\n * @param {DocumentType} doctype\n * @return {Document}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Level-2-Core-DOM-createDocument\n * @nosideeffects\n */\nDOMImplementation.prototype.createDocument = function(namespaceURI, publicId, doctype) {};\n\n/**\n * @param {string} qualifiedName\n * @param {string} publicId\n * @param {string} systemId\n * @return {DocumentType}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Level-2-Core-DOM-createDocType\n * @nosideeffects\n */\nDOMImplementation.prototype.createDocumentType = function(qualifiedName, publicId, systemId) {};\n\n/**\n * @param {string} features\n * @return {DOMImplementation}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-getDOMImpl\n * @nosideeffects\n */\nDOMImplementationSource.prototype.getDOMImplementation = function(features) {};\n\n/**\n * @param {string} features\n * @return {DOMImplementationList}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-getDOMImpls\n * @nosideeffects\n */\nDOMImplementationSource.prototype.getDOMImplementationList = function(features) {};\n\n/**\n * @param {Node} externalNode\n * @return {Node}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Document3-adoptNode\n */\nDocument.prototype.adoptNode = function(externalNode) {};\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Document3-documentURI\n */\nDocument.prototype.documentURI;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Document3-inputEncoding\n */\nDocument.prototype.inputEncoding;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Document3-encoding\n */\nDocument.prototype.xmlEncoding;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Document3-standalone\n */\nDocument.prototype.xmlStandalone;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Document3-version\n */\nDocument.prototype.xmlVersion;\n\n/**\n * @type {?string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-baseURI\n */\nNode.prototype.baseURI;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-NodeNSLocalN\n */\nNode.prototype.localName;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-NodeNSname\n */\nNode.prototype.namespaceURI;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-NodeNSPrefix\n */\nNode.prototype.prefix;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-textContent\n */\nNode.prototype.textContent;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node-DOCUMENT_POSITION_DISCONNECTED\n */\nNode.DOCUMENT_POSITION_DISCONNECTED;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node-DOCUMENT_POSITION_PRECEDING\n */\nNode.DOCUMENT_POSITION_PRECEDING;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node-DOCUMENT_POSITION_FOLLOWING\n */\nNode.DOCUMENT_POSITION_FOLLOWING;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node-DOCUMENT_POSITION_CONTAINS\n */\nNode.DOCUMENT_POSITION_CONTAINS;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node-DOCUMENT_POSITION_CONTAINED_BY\n */\nNode.DOCUMENT_POSITION_CONTAINED_BY;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node-DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC\n */\nNode.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC;\n\n/**\n * @param {Node} other\n * @return {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-compareDocumentPosition\n * @nosideeffects\n */\nNode.prototype.compareDocumentPosition = function(other) {};\n\n/**\n * @param {string} feature\n * @param {string} version\n * @return {Object}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-getFeature\n * @nosideeffects\n */\nNode.prototype.getFeature = function(feature, version) {};\n\n/**\n * @param {string} key\n * @return {Object}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-getUserData\n * @nosideeffects\n */\nNode.prototype.getUserData = function(key) {};\n\n/**\n * @return {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-NodeHasAttrs\n * @nosideeffects\n */\nNode.prototype.hasAttributes = function() {};\n\n/**\n * @param {?string} namespaceURI\n * @return {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-isDefaultNamespace\n * @nosideeffects\n */\nNode.prototype.isDefaultNamespace = function(namespaceURI) {};\n\n/**\n * @param {Node} arg\n * @return {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-isEqualNode\n * @nosideeffects\n */\nNode.prototype.isEqualNode = function(arg) {};\n\n/**\n * @param {Node} other\n * @return {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-isSameNode\n * @nosideeffects\n */\nNode.prototype.isSameNode = function(other) {};\n\n/**\n * @param {string} prefix\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-lookupNamespaceURI\n * @nosideeffects\n */\nNode.prototype.lookupNamespaceURI = function(prefix) {};\n\n/**\n * @param {?string} namespaceURI\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-lookupNamespacePrefix\n * @nosideeffects\n */\nNode.prototype.lookupPrefix = function(namespaceURI) {};\n\n/**\n * @return {undefined}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-normalize\n */\nNode.prototype.normalize = function() {};\n\n/**\n * @param {string} query\n * @return {?Element}\n * @see http://www.w3.org/TR/selectors-api/#queryselector\n * @nosideeffects\n */\nNode.prototype.querySelector = function(query) {};\n\n/**\n * @param {string} query\n * @return {!NodeList<!Element>}\n * @see http://www.w3.org/TR/selectors-api/#queryselectorall\n * @nosideeffects\n */\nNode.prototype.querySelectorAll = function(query) {};\n\n/**\n * @type {Element}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Attr-ownerElement\n */\nAttr.prototype.ownerElement;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Attr-isId\n */\nAttr.prototype.isId;\n\n/**\n * @param {?string} namespaceURI\n * @param {string} localName\n * @return {Attr}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElGetAtNodeNS\n * @nosideeffects\n */\nElement.prototype.getAttributeNodeNS = function(namespaceURI, localName) {};\n\n/**\n * @param {?string} namespaceURI\n * @param {string} localName\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElGetAttrNS\n * @nosideeffects\n */\nElement.prototype.getAttributeNS = function(namespaceURI, localName) {};\n\n/**\n * @param {?string} namespaceURI\n * @param {string} localName\n * @return {!NodeList<!Element>}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-A6C90942\n * @nosideeffects\n */\nElement.prototype.getElementsByTagNameNS = function(namespaceURI, localName) {};\n\n/**\n * @param {string} name\n * @return {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElHasAttr\n * @nosideeffects\n */\nElement.prototype.hasAttribute = function(name) {};\n\n/**\n * @param {?string} namespaceURI\n * @param {string} localName\n * @return {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElHasAttrNS\n * @nosideeffects\n */\nElement.prototype.hasAttributeNS = function(namespaceURI, localName) {};\n\n/**\n * @param {?string} namespaceURI\n * @param {string} localName\n * @return {undefined}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElRemAtNS\n */\nElement.prototype.removeAttributeNS = function(namespaceURI, localName) {};\n\n/**\n * @param {Attr} newAttr\n * @return {Attr}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElSetAtNodeNS\n */\nElement.prototype.setAttributeNodeNS = function(newAttr) {};\n\n/**\n * @param {?string} namespaceURI\n * @param {string} qualifiedName\n * @param {string|number|boolean} value Values are converted to strings with\n *     ToString, so we accept number and boolean since both convert easily to\n *     strings.\n * @return {undefined}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElSetAttrNS\n */\nElement.prototype.setAttributeNS = function(namespaceURI, qualifiedName, value) {};\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Text3-wholeText\n */\nText.prototype.wholeText;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-Interfaces-DOMError\n */\nfunction DOMError() {}\n\n/**\n * @type {DOMLocator}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-location\n */\nDOMError.prototype.location;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-message\n */\nDOMError.prototype.message;\n\n/**\n * @type {Object}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-relatedData\n */\nDOMError.prototype.relatedData;\n\n/**\n * @type {Object}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-relatedException\n */\nDOMError.prototype.relatedException;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-severity-warning\n */\nDOMError.SEVERITY_WARNING;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-severity-error\n */\nDOMError.SEVERITY_ERROR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-severity-fatal-error\n */\nDOMError.SEVERITY_FATAL_ERROR;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-severity\n */\nDOMError.prototype.severity;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-DOMError-type\n */\nDOMError.prototype.type;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/dom/#domerror\n */\nDOMError.prototype.name;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-Interfaces-DOMErrorHandler\n */\nfunction DOMErrorHandler() {}\n\n/**\n * @param {DOMError} error\n * @return {boolean}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ERRORS-DOMErrorHandler-handleError\n */\nDOMErrorHandler.prototype.handleError = function(error) {};\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#Interfaces-DOMLocator\n */\nfunction DOMLocator() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMLocator-byteOffset\n */\nDOMLocator.prototype.byteOffset;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMLocator-column-number\n */\nDOMLocator.prototype.columnNumber;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMLocator-line-number\n */\nDOMLocator.prototype.lineNumber;\n\n/**\n * @type {Node}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMLocator-node\n */\nDOMLocator.prototype.relatedNode;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMLocator-uri\n */\nDOMLocator.prototype.uri;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMLocator-utf16Offset\n */\nDOMLocator.prototype.utf16Offset;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-Core-DocType-publicId\n */\nDocumentType.prototype.publicId;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-Core-DocType-systemId\n */\nDocumentType.prototype.systemId;\n',
"externs/w3c_dom4.js":'/*\n * Copyright 2016 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C\'s DOM4 specification. This file depends on\n * w3c_dom3.js. The whole file has been fully type annotated. Created from\n * https://www.w3.org/TR/domcore/.\n *\n * @externs\n * @author zhoumotongxue008@gmail.com (Michael Zhou)\n */\n\n/**\n * @typedef {?(DocumentType|Element|CharacterData)}\n * @see https://www.w3.org/TR/domcore/#interface-childnode\n */\nvar ChildNode;\n\n/**\n * @return {undefined}\n * @see https://www.w3.org/TR/domcore/#dom-childnode-remove\n */\nDocumentType.prototype.remove = function() {};\n\n/**\n * @return {undefined}\n * @see https://www.w3.org/TR/domcore/#dom-childnode-remove\n */\nElement.prototype.remove = function() {};\n\n/**\n * @return {undefined}\n * @see https://www.w3.org/TR/domcore/#dom-childnode-remove\n */\nCharacterData.prototype.remove = function() {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-replacewith\n */\nDocumentType.prototype.replaceWith = function(nodes) {};\n\n/**\n * @const {string}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#sec-domerror\n */\nDOMException.prototype.name;\n\n/**\n * @const {string}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#sec-domerror\n */\nDOMException.prototype.message;\n\n/**\n * @const {number}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#dfn-error-names-table\n */\nDOMException.SECURITY_ERR;\n\n/**\n * @const {number}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#dfn-error-names-table\n */\nDOMException.NETWORK_ERR;\n\n/**\n * @const {number}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#dfn-error-names-table\n */\nDOMException.ABORT_ERR;\n\n/**\n * @const {number}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#dfn-error-names-table\n */\nDOMException.URL_MISMATCH_ERR;\n\n/**\n * @const {number}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#dfn-error-names-table\n */\nDOMException.QUOTA_EXCEEDED_ERR;\n\n/**\n * @const {number}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#dfn-error-names-table\n */\nDOMException.TIMEOUT_ERR;\n\n/**\n * @const {number}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#dfn-error-names-table\n */\nDOMException.INVALID_NODE_TYPE_ERR;\n\n/**\n * @const {number}\n * @see https://www.w3.org/TR/2015/REC-dom-20151119/#dfn-error-names-table\n */\nDOMException.DATA_CLONE_ERR;\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-replacewith\n */\nElement.prototype.replaceWith = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-replacewith\n */\nCharacterData.prototype.replaceWith = function(nodes) {};\n\n/**\n * @return {!Array<string>}\n * @see https://dom.spec.whatwg.org/#dom-element-getattributenames\n */\nElement.prototype.getAttributeNames = function() {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-parentnode-append\n */\nElement.prototype.append = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-parentnode-append\n */\nDocument.prototype.append = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-parentnode-append\n */\nDocumentFragment.prototype.append = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-parentnode-prepend\n */\nElement.prototype.prepend = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-parentnode-prepend\n */\nDocument.prototype.prepend = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-parentnode-prepend\n */\nDocumentFragment.prototype.prepend = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-before\n */\nElement.prototype.before = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-before\n */\nDocumentType.prototype.before = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-before\n */\nCharacterData.prototype.before = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-after\n */\nElement.prototype.after = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-after\n */\nDocumentType.prototype.after = function(nodes) {};\n\n/**\n * @param {...(!Node|string)} nodes\n * @return {undefined}\n * @see https://dom.spec.whatwg.org/#dom-childnode-after\n */\nCharacterData.prototype.after = function(nodes) {};\n\n/**\n * @param {string} name\n * @param {boolean=} force\n * @return {boolean}\n * @throws {DOMException}\n * @see https://dom.spec.whatwg.org/#dom-element-toggleattribute\n */\nElement.prototype.toggleAttribute = function(name, force) {};\n\n/**\n * @type {Element}\n * @see http://msdn.microsoft.com/en-us/library/ms534327(VS.85).aspx\n */\nNode.prototype.parentElement;\n\n/**\n * @param {string} name\n * @return {!HTMLCollection<!Element>}\n * @nosideeffects\n * @see https://dom.spec.whatwg.org/#dom-document-getelementsbyclassname-classnames-classnames\n */\nDocument.prototype.getElementsByClassName = function(name) {};\n\n/**\n * @param {string} classNames\n * @return {!HTMLCollection<!Element>}\n * @nosideeffects\n * @see https://dom.spec.whatwg.org/#dom-element-getelementsbyclassname-classnames-classnames\n */\nElement.prototype.getElementsByClassName = function(classNames) {};\n',
"externs/gecko_dom.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for all the extensions over\n *  W3C\'s DOM specification by Gecko. This file depends on\n *  w3c_dom2.js.\n *\n * When a non-standard extension appears in both Gecko and IE, we put\n * it in gecko_dom.js\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n */\n\n// TODO: Almost all of it has not been annotated with types.\n\n// Gecko DOM;\n\n/**\n * Mozilla only???\n * @constructor\n * @extends {HTMLElement}\n */\nfunction HTMLSpanElement() {}\n\n/**\n * @see https://developer.mozilla.org/en/Components_object\n */\nWindow.prototype.Components;\n\n/**\n * @type {Window}\n * @see https://developer.mozilla.org/en/DOM/window.content\n */\nWindow.prototype.content;\n\n/** @see https://developer.mozilla.org/en/DOM/window.controllers */\nWindow.prototype.controllers;\n\n/** @see https://developer.mozilla.org/en/DOM/window.crypto */\nWindow.prototype.crypto;\n\n/**\n * Gets/sets the status bar text for the given window.\n * @type {string}\n * @see https://developer.mozilla.org/en/DOM/window.defaultStatus\n */\nWindow.prototype.defaultStatus;\n\n/** @see https://developer.mozilla.org/en/DOM/window.dialogArguments */\nWindow.prototype.dialogArguments;\n\n/** @see https://developer.mozilla.org/en/DOM/window.directories */\nWindow.prototype.directories;\n\n/**\n * @type {boolean}\n * @see https://developer.mozilla.org/en/DOM/window.fullScreen\n */\nWindow.prototype.fullScreen;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/Storage#globalStorage\n */\nWindow.prototype.globalStorage;\n\n/** @see https://developer.mozilla.org/en/DOM/window.pkcs11 */\nWindow.prototype.pkcs11;\n\n/** @see https://developer.mozilla.org/en/DOM/window */\nWindow.prototype.returnValue;\n\n/**\n * @type {number}\n * @see https://developer.mozilla.org/En/DOM/window.scrollMaxX\n */\nWindow.prototype.scrollMaxX;\n\n/**\n * @type {number}\n * @see https://developer.mozilla.org/En/DOM/window.scrollMaxY\n */\nWindow.prototype.scrollMaxY;\n\n/** @see https://developer.mozilla.org/en/DOM/Storage#sessionStorage */\nWindow.prototype.sessionStorage;\n\n/** @see https://developer.mozilla.org/en/DOM/window.sidebar */\nWindow.prototype.sidebar;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/window.back\n * @return {undefined}\n */\nWindow.prototype.back = function() {};\n\n/** @deprecated */\nWindow.prototype.captureEvents;\n\n/**@see https://developer.mozilla.org/en/DOM/window.find */\nWindow.prototype.find;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/window.forward\n * @return {undefined}\n */\nWindow.prototype.forward = function() {};\n\n/**\n * @see https://developer.mozilla.org/en/DOM/window.getAttention\n * @return {undefined}\n */\nWindow.prototype.getAttention = function() {};\n\n/**\n * @see https://developer.mozilla.org/en/DOM/window.home\n * @return {undefined}\n */\nWindow.prototype.home = function() {};\n\nWindow.prototype.openDialog;\nWindow.prototype.releaseEvents;\nWindow.prototype.scrollByLines;\nWindow.prototype.scrollByPages;\n\n/**\n * @param {string} uri\n * @param {?=} opt_arguments\n * @param {string=} opt_options\n * @see https://developer.mozilla.org/en/DOM/window.showModalDialog\n */\nWindow.prototype.showModalDialog;\n\nWindow.prototype.sizeToContent;\n\nWindow.prototype.updateCommands;\n\n// properties of Document\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.alinkColor\n * @type {string}\n */\nDocument.prototype.alinkColor;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.anchors\n * @type {HTMLCollection<!HTMLAnchorElement>}\n */\nDocument.prototype.anchors;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.applets\n * @type {HTMLCollection<!HTMLAppletElement>}\n */\nDocument.prototype.applets;\n/** @type {?string} */ Document.prototype.baseURI;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.bgColor\n * @type {string}\n */\nDocument.prototype.bgColor;\n\n/** @type {HTMLBodyElement} */ Document.prototype.body;\nDocument.prototype.characterSet;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.compatMode\n * @type {string}\n */\nDocument.prototype.compatMode;\n\nDocument.prototype.contentType;\n/** @type {string} */ Document.prototype.cookie;\n\n/**\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Document/defaultView\n * @type {?Window}\n */\nDocument.prototype.defaultView;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.designMode\n * @type {string}\n */\nDocument.prototype.designMode;\n\nDocument.prototype.documentURIObject;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.domain\n * @type {string}\n */\nDocument.prototype.domain;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.embeds\n * @type {HTMLCollection<!HTMLEmbedElement>}\n */\nDocument.prototype.embeds;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.fgColor\n * @type {string}\n */\nDocument.prototype.fgColor;\n\n/** @type {Element} */ Document.prototype.firstChild;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.forms\n * @type {HTMLCollection<!HTMLFormElement>}\n */\nDocument.prototype.forms;\n\n/** @type {HTMLCollection<!HTMLImageElement>} */\nDocument.prototype.images;\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/DOM/document.lastModified\n */\nDocument.prototype.lastModified;\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/DOM/document.linkColor\n */\nDocument.prototype.linkColor;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.links\n * @type {HTMLCollection<(!HTMLAreaElement|!HTMLAnchorElement)>}\n */\nDocument.prototype.links;\n\n/**\n * @type {!Location}\n * @implicitCast\n */\nDocument.prototype.location;\n\nDocument.prototype.namespaceURI;\nDocument.prototype.nodePrincipal;\nDocument.prototype.plugins;\nDocument.prototype.popupNode;\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/DOM/document.referrer\n */\nDocument.prototype.referrer;\n\n/**\n * @type {StyleSheetList}\n * @see https://developer.mozilla.org/en/DOM/document.styleSheets\n */\nDocument.prototype.styleSheets;\n\n/** @type {?string} */ Document.prototype.title;\nDocument.prototype.tooltipNode;\n/** @type {string} */ Document.prototype.URL;\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/DOM/document.vlinkColor\n */\nDocument.prototype.vlinkColor;\n\n/** @type {number} */ Document.prototype.width;\n\n// Methods of Document\n/**\n * @see https://developer.mozilla.org/en/DOM/document.clear\n * @return {undefined}\n */\nDocument.prototype.clear = function() {};\n\n/**\n * @param {string} type\n * @return {Event}\n */\nDocument.prototype.createEvent = function(type) {};\nDocument.prototype.createNSResolver;\n/** @return {Range} */ Document.prototype.createRange = function() {};\nDocument.prototype.createTreeWalker;\n\nDocument.prototype.evaluate;\n\n/**\n * @param {string} commandName\n * @param {?boolean=} opt_showUi\n * @param {*=} opt_value\n * @see https://developer.mozilla.org/en/Rich-Text_Editing_in_Mozilla#Executing_Commands\n */\nDocument.prototype.execCommand;\n\nDocument.prototype.loadOverlay;\n\n/**\n * @see https://developer.mozilla.org/en/Midas\n * @see http://msdn.microsoft.com/en-us/library/ms536676(VS.85).aspx\n */\nDocument.prototype.queryCommandEnabled;\n\n/**\n * @see https://developer.mozilla.org/en/Midas\n * @see http://msdn.microsoft.com/en-us/library/ms536678(VS.85).aspx\n */\nDocument.prototype.queryCommandIndeterm;\n\n/**\n * @see https://developer.mozilla.org/en/Midas\n * @see http://msdn.microsoft.com/en-us/library/ms536679(VS.85).aspx\n */\nDocument.prototype.queryCommandState;\n\n/**\n * @see https://developer.mozilla.org/en/DOM/document.queryCommandSupported\n * @see http://msdn.microsoft.com/en-us/library/ms536681(VS.85).aspx\n * @param {string} command\n * @return {?} Implementation-specific.\n */\nDocument.prototype.queryCommandSupported;\n\n/**\n * @see https://developer.mozilla.org/en/Midas\n * @see http://msdn.microsoft.com/en-us/library/ms536683(VS.85).aspx\n */\nDocument.prototype.queryCommandValue;\n\nDocument.prototype.ononline;\nDocument.prototype.onoffline;\n\n// XUL\n/**\n * @see http://developer.mozilla.org/en/DOM/document.getBoxObjectFor\n * @return {BoxObject}\n * @nosideeffects\n */\nDocument.prototype.getBoxObjectFor = function(element) {};\n\n// From:\n// http://lxr.mozilla.org/mozilla1.8/source/dom/public/idl/range/nsIDOMNSRange.idl\n\n/**\n * @param {!TrustedHTML|string} tag\n * @return {DocumentFragment}\n */\nRange.prototype.createContextualFragment;\n\n/**\n * @param {Node} parent\n * @param {number} offset\n * @return {boolean}\n * @nosideeffects\n */\nRange.prototype.isPointInRange;\n\n/**\n * @param {Node} parent\n * @param {number} offset\n * @return {number}\n * @nosideeffects\n */\nRange.prototype.comparePoint;\n\n/**\n * @param {Node} n\n * @return {boolean}\n * @nosideeffects\n */\nRange.prototype.intersectsNode;\n\n/**\n * @param {Node} n\n * @return {number}\n * @nosideeffects\n */\nRange.prototype.compareNode;\n\n/**\n * @type {!NodeList<!Element>}\n * @see https://developer.mozilla.org/en/DOM/element.children\n */\nElement.prototype.children;\n\n/**\n * Firebug sets this property on elements it is inserting into the DOM.\n * @type {boolean}\n */\nElement.prototype.firebugIgnore;\n\n/**\n * Note: According to the spec, name is defined on specific types of\n * HTMLElements, rather than on Node, Element, or HTMLElement directly.\n * Ignore this.\n * @type {string}\n */\nElement.prototype.name;\n\nElement.prototype.nodePrincipal;\n\n/**\n * @type {!CSSStyleDeclaration}\n * This belongs on HTMLElement rather than Element, but that\n * breaks a lot.\n * TODO(rdcronin): Remove this declaration once the breakage is fixed.\n */\nElement.prototype.style;\n\n/**\n * @override\n * @return {!Element}\n */\nElement.prototype.cloneNode = function(deep) {};\n\n/** @return {undefined} */\nElement.prototype.click = function() {};\n\n/** @type {number} */\nHTMLTextAreaElement.prototype.selectionStart;\n\n/** @type {number} */\nHTMLTextAreaElement.prototype.selectionEnd;\n\n/**\n * @param {number} selectionStart\n * @param {number} selectionEnd\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/editing.html#dom-textarea/input-setselectionrange\n * @return {undefined}\n */\nHTMLTextAreaElement.prototype.setSelectionRange =\n    function(selectionStart, selectionEnd) {};\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/Navigator.buildID\n */\nNavigator.prototype.buildID;\n\n/**\n * @type {!Array<string>|undefined}\n * @see https://developer.mozilla.org/en/Navigator.languages\n */\nNavigator.prototype.languages;\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/Navigator.oscpu\n */\nNavigator.prototype.oscpu;\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/Navigator.productSub\n */\nNavigator.prototype.productSub;\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/Navigator.securityPolicy\n */\nNavigator.prototype.securityPolicy;\n\n/**\n * @param {string} url\n * @param {ArrayBufferView|Blob|string|FormData=} opt_data\n * @return {boolean}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/navigator.sendBeacon\n */\nNavigator.prototype.sendBeacon = function(url, opt_data) {};\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/Navigator.vendor\n */\nNavigator.prototype.vendor;\n\n/**\n * @type {string}\n * @see https://developer.mozilla.org/en/Navigator.vendorSub\n */\nNavigator.prototype.vendorSub;\n\n\n/** @constructor */\nfunction BoxObject() {}\n\n/** @type {Element} */\nBoxObject.prototype.element;\n\n/** @type {number} */\nBoxObject.prototype.screenX;\n\n/** @type {number} */\nBoxObject.prototype.screenY;\n\n/** @type {number} */\nBoxObject.prototype.x;\n\n/** @type {number} */\nBoxObject.prototype.y;\n\n/** @type {number} */\nBoxObject.prototype.width;\n\n\n/**\n * @param {Element} element\n * @param {?string=} pseudoElt\n * @return {?CSSStyleDeclaration}\n * @nosideeffects\n * @see https://bugzilla.mozilla.org/show_bug.cgi?id=548397\n */\nfunction getComputedStyle(element, pseudoElt) {}\n',
"externs/ie_dom.js":"/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for all the extensions over the\n *  W3C's DOM specification by IE in JScript. This file depends on\n *  w3c_dom2.js. The whole file has NOT been fully type annotated.\n *\n * When a non-standard extension appears in both Gecko and IE, we put\n * it in gecko_dom.js\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n * @author stevey@google.com (Steve Yegge)\n */\n\n// TODO(nicksantos): Rewrite all the DOM interfaces as interfaces, instead\n// of kludging them as an inheritance hierarchy.\n\n/**\n * @constructor\n * @extends {Document}\n * @see http://msdn.microsoft.com/en-us/library/ms757878(VS.85).aspx\n */\nfunction XMLDOMDocument() {}\n\n/**\n * @type {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms761398(VS.85).aspx\n */\nXMLDOMDocument.prototype.async;\n\n/**\n * @type {!Function}\n * @see http://msdn.microsoft.com/en-us/library/ms762647(VS.85).aspx\n */\nXMLDOMDocument.prototype.ondataavailable;\n\n/**\n * @type {!Function}\n * @see http://msdn.microsoft.com/en-us/library/ms764640(VS.85).aspx\n */\nXMLDOMDocument.prototype.onreadystatechange;\n\n/**\n * @type {!Function}\n * @see http://msdn.microsoft.com/en-us/library/ms753795(VS.85).aspx\n */\nXMLDOMDocument.prototype.ontransformnode;\n\n/**\n * @type {Object}\n * @see http://msdn.microsoft.com/en-us/library/ms756041(VS.85).aspx\n */\nXMLDOMDocument.prototype.parseError;\n\n/**\n * @type {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms761353(VS.85).aspx\n */\nXMLDOMDocument.prototype.preserveWhiteSpace;\n\n/**\n * @type {number}\n * @see http://msdn.microsoft.com/en-us/library/ms753702(VS.85).aspx\n */\nXMLDOMDocument.prototype.readyState;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms762283(VS.85).aspx\n * @type {boolean}\n */\nXMLDOMDocument.prototype.resolveExternals;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms760290(v=vs.85).aspx\n * @param {string} name\n * @param {*} value\n * @return {undefined}\n */\nXMLDOMDocument.prototype.setProperty = function(name, value) {};\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms767669(VS.85).aspx\n */\nXMLDOMDocument.prototype.url;\n\n/**\n * @type {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms762791(VS.85).aspx\n */\nXMLDOMDocument.prototype.validateOnParse;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms763830(VS.85).aspx\n * @return {undefined}\n */\nXMLDOMDocument.prototype.abort = function() {};\n\n/**\n * @param {*} type\n * @param {string} name\n * @param {string} namespaceURI\n * @return {Node}\n * @see http://msdn.microsoft.com/en-us/library/ms757901(VS.85).aspx\n * @nosideeffects\n */\nXMLDOMDocument.prototype.createNode = function(type, name, namespaceURI) {};\n\n/**\n * @param {string} xmlString\n * @return {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms754585(VS.85).aspx\n * @override\n */\nXMLDOMDocument.prototype.loadXML = function(xmlString) {};\n\n/**\n * @param {string} id\n * @return {Node}\n * @see http://msdn.microsoft.com/en-us/library/ms766397(VS.85).aspx\n */\nXMLDOMDocument.prototype.nodeFromID = function(id) {};\n\n//==============================================================================\n// XMLNode methods and properties\n// In a real DOM hierarchy, XMLDOMDocument inherits from XMLNode and Document.\n// Since we can't express that in our type system, we put XMLNode properties\n// on Node.\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms767570(VS.85).aspx\n */\nNode.prototype.baseName;\n\n/**\n * @type {?string}\n * @see http://msdn.microsoft.com/en-us/library/ms762763(VS.85).aspx\n */\nNode.prototype.dataType;\n\n/**\n * @type {Node}\n * @see http://msdn.microsoft.com/en-us/library/ms764733(VS.85).aspx\n */\nNode.prototype.definition;\n\n/**\n * IE5 used document instead of ownerDocument.\n * Old versions of WebKit used document instead of contentDocument.\n * @type {Document}\n */\nNode.prototype.document;\n\n\n/**\n * Inserts the given HTML text into the element at the location.\n * @param {string} sWhere Where to insert the HTML text, one of 'beforeBegin',\n *     'afterBegin', 'beforeEnd', 'afterEnd'.\n * @param {!TrustedHTML|string} sText HTML text to insert.\n * @see http://msdn.microsoft.com/en-us/library/ms536452(VS.85).aspx\n * @return {undefined}\n */\nNode.prototype.insertAdjacentHTML = function(sWhere, sText) {};\n\n/**\n * @type {*}\n * @see http://msdn.microsoft.com/en-us/library/ms762308(VS.85).aspx\n */\nNode.prototype.nodeTypedValue;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms757895(VS.85).aspx\n */\nNode.prototype.nodeTypeString;\n\n/**\n * @type {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms762237(VS.85).aspx\n */\nNode.prototype.parsed;\n\n/**\n * @type {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms753816(VS.85).aspx\n */\nNode.prototype.specified;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms762687(VS.85).aspx\n */\nNode.prototype.text;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms755989(VS.85).aspx\n */\nNode.prototype.xml;\n\n/**\n * @param {string} expression An XPath expression.\n * @return {!NodeList<!Node>}\n * @see http://msdn.microsoft.com/en-us/library/ms754523(VS.85).aspx\n * @nosideeffects\n */\nNode.prototype.selectNodes = function(expression) {};\n\n/**\n * @param {string} expression An XPath expression.\n * @return {Node}\n * @see http://msdn.microsoft.com/en-us/library/ms757846(VS.85).aspx\n * @nosideeffects\n */\nNode.prototype.selectSingleNode = function(expression) {};\n\n/**\n * @param {Node} stylesheet XSLT stylesheet.\n * @return {string}\n * @see http://msdn.microsoft.com/en-us/library/ms761399(VS.85).aspx\n * @nosideeffects\n */\nNode.prototype.transformNode = function(stylesheet) {};\n\n/**\n * @param {Node} stylesheet XSLT stylesheet.\n * @param {Object} outputObject\n * @see http://msdn.microsoft.com/en-us/library/ms766561(VS.85).aspx\n * @return {Object}\n */\nNode.prototype.transformNodeToObject =\n    function(stylesheet, outputObject) {};\n\n//==============================================================================\n// Node methods\n\n/**\n * @param {boolean=} opt_bRemoveChildren Whether to remove the entire sub-tree.\n *    Defaults to false.\n * @return {Node} The object that was removed.\n * @see http://msdn.microsoft.com/en-us/library/ms536708(VS.85).aspx\n */\nNode.prototype.removeNode = function(opt_bRemoveChildren) {};\n\n/**\n * @constructor\n */\nfunction ClipboardData() {}\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535220(VS.85).aspx\n * @param {string=} opt_type Type of clipboard data to clear. 'Text' or\n *     'URL' or 'File' or 'HTML' or 'Image'.\n * @return {undefined}\n */\nClipboardData.prototype.clearData = function(opt_type) {};\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535220(VS.85).aspx\n * @param {string} type Type of clipboard data to set ('Text' or 'URL').\n * @param {string} data Data to set\n * @return {boolean} Whether the data were set correctly.\n */\nClipboardData.prototype.setData = function(type, data) {};\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535220(VS.85).aspx\n * @param {string} type Type of clipboard data to get ('Text' or 'URL').\n * @return {string} The current data\n */\nClipboardData.prototype.getData = function(type) { };\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535220(VS.85).aspx\n * @type {ClipboardData}\n */\nWindow.prototype.clipboardData;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533724(VS.85).aspx\n */\nWindow.prototype.dialogHeight;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533725(VS.85).aspx\n */\nWindow.prototype.dialogLeft;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533726(VS.85).aspx\n */\nWindow.prototype.dialogTop;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533727(VS.85).aspx\n */\nWindow.prototype.dialogWidth;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535863(VS.85).aspx\n */\nWindow.prototype.event;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/cc197012(VS.85).aspx\n */\nWindow.prototype.maxConnectionsPer1_0Server;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/cc197013(VS.85).aspx\n */\nWindow.prototype.maxConnectionsPerServer;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534198(VS.85).aspx\n */\nWindow.prototype.offscreenBuffering;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534389(VS.85).aspx\n * @type {number|undefined}\n */\nWindow.prototype.screenLeft;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534389(VS.85).aspx\n * @type {number|undefined}\n */\nWindow.prototype.screenTop;\n\n// Functions\n\n/**\n * @param {string} event\n * @param {Function} handler\n * @see http://msdn.microsoft.com/en-us/library/ms536343(VS.85).aspx\n */\nWindow.prototype.attachEvent;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536392(VS.85).aspx\n */\nWindow.prototype.createPopup;\n\n/**\n * @param {string} event\n * @param {Function} handler\n * @see http://msdn.microsoft.com/en-us/library/ms536411(VS.85).aspx\n */\nWindow.prototype.detachEvent;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536420(VS.85).aspx\n */\nWindow.prototype.execScript;\n\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536638(VS.85).aspx\n */\nWindow.prototype.navigate;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536738(VS.85).aspx\n */\nWindow.prototype.setActive;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536758(VS.85).aspx\n */\nWindow.prototype.showHelp;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536761(VS.85).aspx\n */\nWindow.prototype.showModelessDialog;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535246%28v=vs.85%29.aspx\n * @const {!Object}\n */\nWindow.prototype.external;\n\n/**\n * @see https://msdn.microsoft.com/en-us/ie/dn265046(v=vs.94)\n * @const {!Object}\n */\nWindow.prototype.msCrypto;\n\n/**\n * @type {boolean}\n * @implicitCast\n * @see http://msdn.microsoft.com/en-us/library/ie/ms533072(v=vs.85).aspx\n */\nHTMLFrameElement.prototype.allowTransparency;\n\n/**\n * @type {Window}\n * @see http://msdn.microsoft.com/en-us/library/ms533692(VS.85).aspx\n */\nHTMLFrameElement.prototype.contentWindow;\n\n/**\n * @type {boolean}\n * @implicitCast\n * @see http://msdn.microsoft.com/en-us/library/ie/ms533072(v=vs.85).aspx\n */\nHTMLIFrameElement.prototype.allowTransparency;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536385(VS.85).aspx\n */\nHTMLBodyElement.prototype.createControlRange;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms534359(VS.85).aspx\n */\nHTMLScriptElement.prototype.readyState;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms534359(VS.85).aspx\n */\nHTMLIFrameElement.prototype.readyState;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms534359(VS.85).aspx\n */\nHTMLImageElement.prototype.readyState;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms534359(VS.85).aspx\n */\nHTMLObjectElement.prototype.readyState;\n\n\n/**\n * @constructor\n */\nfunction ControlRange() {}\n\nControlRange.prototype.add;\nControlRange.prototype.addElement;\nControlRange.prototype.execCommand;\nControlRange.prototype.item;\nControlRange.prototype.queryCommandEnabled;\nControlRange.prototype.queryCommandIndeterm;\nControlRange.prototype.queryCommandState;\nControlRange.prototype.queryCommandSupported;\nControlRange.prototype.queryCommandValue;\nControlRange.prototype.remove;\nControlRange.prototype.scrollIntoView;\nControlRange.prototype.select;\n\n/**\n * @constructor\n * @see http://msdn.microsoft.com/en-us/library/ms535872.aspx\n */\nfunction TextRange() {}\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533538(VS.85).aspx\n */\nTextRange.prototype.boundingHeight;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533539(VS.85).aspx\n */\nTextRange.prototype.boundingLeft;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533540(VS.85).aspx\n */\nTextRange.prototype.boundingTop;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533541(VS.85).aspx\n */\nTextRange.prototype.boundingWidth;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533874(VS.85).aspx\n */\nTextRange.prototype.htmlText;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534200(VS.85).aspx\n */\nTextRange.prototype.offsetLeft;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534303(VS.85).aspx\n */\nTextRange.prototype.offsetTop;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms534676(VS.85).aspx\n */\nTextRange.prototype.text;\n\n/**\n * @param {boolean=} opt_toStart\n * @see http://msdn.microsoft.com/en-us/library/ms536371(VS.85).aspx\n */\nTextRange.prototype.collapse;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536373(VS.85).aspx\n */\nTextRange.prototype.compareEndPoints;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536416(VS.85).aspx\n */\nTextRange.prototype.duplicate;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536419(VS.85).aspx\n */\nTextRange.prototype.execCommand;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536421(VS.85).aspx\n */\nTextRange.prototype.expand;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536422(VS.85).aspx\n */\nTextRange.prototype.findText;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536432(VS.85).aspx\n */\nTextRange.prototype.getBookmark;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536433(VS.85).aspx\n */\nTextRange.prototype.getBoundingClientRect;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536435(VS.85).aspx\n */\nTextRange.prototype.getClientRects;\n\n/**\n * @param {TextRange|ControlRange} range\n * @return {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms536450(VS.85).aspx\n */\nTextRange.prototype.inRange;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536458(VS.85).aspx\n */\nTextRange.prototype.isEqual;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536616(VS.85).aspx\n */\nTextRange.prototype.move;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536620(VS.85).aspx\n */\nTextRange.prototype.moveEnd;\n\n/**\n * @param {string} unit\n * @param {number=} opt_count\n * @see http://msdn.microsoft.com/en-us/library/ms536623(VS.85).aspx\n */\nTextRange.prototype.moveStart;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536628(VS.85).aspx\n */\nTextRange.prototype.moveToBookmark;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536630(VS.85).aspx\n */\nTextRange.prototype.moveToElementText;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536632(VS.85).aspx\n */\nTextRange.prototype.moveToPoint;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536654(VS.85).aspx\n * @return {?Element}\n */\nTextRange.prototype.parentElement;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536656(VS.85).aspx\n */\nTextRange.prototype.pasteHTML;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536676(VS.85).aspx\n */\nTextRange.prototype.queryCommandEnabled;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536678(VS.85).aspx\n */\nTextRange.prototype.queryCommandIndeterm;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536679(VS.85).aspx\n */\nTextRange.prototype.queryCommandState;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536681(VS.85).aspx\n */\nTextRange.prototype.queryCommandSupported;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536683(VS.85).aspx\n */\nTextRange.prototype.queryCommandValue;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536730(VS.85).aspx\n */\nTextRange.prototype.scrollIntoView;\n\n/**\n * @return {undefined}\n * @see http://msdn.microsoft.com/en-us/library/ms536735(VS.85).aspx\n */\nTextRange.prototype.select = function() {};\n\n/**\n * @param {string} how\n * @param {TextRange|ControlRange} sourceRange\n * @see http://msdn.microsoft.com/en-us/library/ms536745(VS.85).aspx\n */\nTextRange.prototype.setEndPoint;\n\n/**\n * @constructor\n * @see http://msdn.microsoft.com/en-us/library/ms537447(VS.85).aspx\n */\nfunction controlRange() {}\n\n\nDocument.prototype.loadXML;\n\n\n// http://msdn.microsoft.com/en-us/library/ms531073(VS.85).aspx\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533553(VS.85).aspx\n */\nDocument.prototype.charset;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533693(VS.85).aspx\n */\nDocument.prototype.cookie;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533731(VS.85).aspx\n */\nDocument.prototype.dir;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/cc196988(VS.85).aspx\n */\nDocument.prototype.documentMode;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533747(VS.85).aspx\n */\nDocument.prototype.expando;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533750(VS.85).aspx\n */\nDocument.prototype.fileCreatedDate;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533751(VS.85).aspx\n */\nDocument.prototype.fileModifiedDate;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms533752(VS.85).aspx\n */\nDocument.prototype.fileSize;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534331(VS.85).aspx\n * @type {?Window}\n */\nDocument.prototype.parentWindow;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534353(VS.85).aspx\n */\nDocument.prototype.protocol;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms534359(VS.85).aspx\n */\nHTMLDocument.prototype.readyState;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534704(VS.85).aspx\n */\nDocument.prototype.uniqueID;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534709(VS.85).aspx\n */\nDocument.prototype.URLUnencoded;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535155(VS.85).aspx\n */\nDocument.prototype.XMLDocument;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535163(VS.85).aspx\n */\nDocument.prototype.XSLDocument;\n\n// functions\n\n/**\n * @param {string} event\n * @param {Function} handler\n * @see http://msdn.microsoft.com/en-us/library/ms536343(VS.85).aspx\n */\nDocument.prototype.attachEvent;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536390(VS.85).aspx\n */\nDocument.prototype.createEventObject;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms531194(VS.85).aspx\n */\nDocument.prototype.createStyleSheet;\n\n/**\n * @param {string} event\n * @param {Function} handler\n * @see http://msdn.microsoft.com/en-us/library/ms536411(VS.85).aspx\n */\nDocument.prototype.detachEvent;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536425(VS.85).aspx\n */\nDocument.prototype.focus;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536614(VS.85).aspx\n */\nDocument.prototype.mergeAttributes;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536685(VS.85).aspx\n */\nDocument.prototype.recalc;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536689(VS.85).aspx\n */\nDocument.prototype.releaseCapture;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536738(VS.85).aspx\n */\nDocument.prototype.setActive;\n\n\n// collections\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms537434(VS.85).aspx\n */\nDocument.prototype.all;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms537445(VS.85).aspx\n */\nDocument.prototype.childNodes;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms537459(VS.85).aspx\n */\nDocument.prototype.frames;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms537470(VS.85).aspx\n */\nDocument.prototype.namespaces;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms537487(VS.85).aspx\n * @type {!HTMLCollection<!HTMLScriptElement>}\n */\nDocument.prototype.scripts;\n\n/**\n * @param {string} sUrl\n * @return {number}\n * @see http://msdn.microsoft.com/en-us/library/ms535922(VS.85).aspx\n */\nElement.prototype.addBehavior = function(sUrl) {};\n\n/**\n * @param {string} event\n * @param {Function} handler\n * @see http://msdn.microsoft.com/en-us/library/mm536343(v=vs.85).aspx\n */\nElement.prototype.attachEvent;\n\n/**\n * @type {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms533546(VS.85).aspx\n */\nElement.prototype.canHaveChildren;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms533559(v=vs.85).aspx\n */\nElement.prototype.classid;\n\n/**\n * @param {number} iCoordX Integer that specifies the client window coordinate\n *     of x.\n * @param {number} iCoordY Integer that specifies the client window coordinate\n *     of y.\n * @return {string} The component of an element located at the specified\n *     coordinates.\n * @see http://msdn.microsoft.com/en-us/library/ms536375(VS.85).aspx\n * @nosideeffects\n */\nElement.prototype.componentFromPoint = function(iCoordX, iCoordY) {};\n\n\n/**\n * TODO(tjgq): Make this string once existing usages have been migrated.\n * @type {string|boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms533690(VS.85).aspx\n */\nElement.prototype.contentEditable;\n\n/**\n * @return {TextRange}\n * @see http://msdn.microsoft.com/en-us/library/ms536401(VS.85).aspx\n */\nElement.prototype.createTextRange;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms535231(VS.85).aspx\n * @type {?CSSStyleDeclaration}\n */\nElement.prototype.currentStyle;\n\n/**\n * @param {string} event\n * @param {Function} handler\n * @see http://msdn.microsoft.com/en-us/library/ie/ms536411(v=vs.85).aspx\n */\nElement.prototype.detachEvent;\n\n/**\n * @param {string=} opt_action\n * @see http://msdn.microsoft.com/en-us/library/ms536414%28VS.85%29.aspx\n * @return {undefined}\n */\nElement.prototype.doScroll = function(opt_action) {};\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536423(VS.85).aspx\n */\nElement.prototype.fireEvent;\n\n/**\n * @type {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms533783(VS.85).aspx\n */\nElement.prototype.hideFocus;\n\n/**\n * @type {string}\n * @implicitCast\n *\n * TODO(lharker): remove the @implicitCast to enforce assigning an explicit\n * string to innerText instead of relying on coercion.\n *\n * @see http://msdn.microsoft.com/en-us/library/ms533899.aspx\n */\nElement.prototype.innerText;\n\n/**\n * @type {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms537838(VS.85).aspx\n */\nElement.prototype.isContentEditable;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms531395(v=vs.85).aspx\n * NOTE: Left untyped to avoid conflict with subclasses.\n */\nElement.prototype.load;\n\n/**\n * @param {number} pointerId Id of the pointer that is assign to the element.\n * @see http://msdn.microsoft.com/en-us/library/ie/hh771882(v=vs.85).aspx\n * @return {undefined}\n */\nElement.prototype.msSetPointerCapture = function(pointerId) {};\n\n/**\n * @param {number} pointerId\n * @see http://msdn.microsoft.com/en-us/library/ie/hh771880.aspx\n * @return {undefined}\n */\nElement.prototype.msReleasePointerCapture = function(pointerId) {};\n\n/**\n * @type {?function(Event)}\n * @see http://msdn.microsoft.com/en-us/library/ms536903(v=vs.85).aspx\n */\nElement.prototype.onbeforedeactivate;\n\n/**\n * @type {?function(Event)}\n * @see http://msdn.microsoft.com/en-us/library/ms536945(VS.85).aspx\n */\nElement.prototype.onmouseenter;\n\n/**\n * @type {?function(Event)}\n * @see http://msdn.microsoft.com/en-us/library/ms536946(VS.85).aspx\n */\nElement.prototype.onmouseleave;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms536689(VS.85).aspx\n * @return {undefined}\n */\nElement.prototype.releaseCapture = function() {};\n\n/**\n * @param {number} iID\n * @return {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms536700(VS.85).aspx\n */\nElement.prototype.removeBehavior = function(iID) {};\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/aa703996(VS.85).aspx\n */\nElement.prototype.runtimeStyle;\n\n/**\n * @param {string} sStoreName The arbitrary name assigned to a persistent object\n *     in a UserData store.\n * @see http://msdn.microsoft.com/en-us/library/ms531403(v=vs.85).aspx\n * @return {undefined}\n */\nElement.prototype.save = function(sStoreName) {};\n\n/**\n * @param {boolean=} opt_bContainerCapture Events originating in a container are\n *     captured by the container. Defaults to true.\n * @see http://msdn.microsoft.com/en-us/library/ms536742(VS.85).aspx\n * @return {undefined}\n */\nElement.prototype.setCapture = function(opt_bContainerCapture) {};\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms534635(VS.85).aspx\n */\nElement.prototype.sourceIndex;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms537840.aspx\n */\nElement.prototype.unselectable;\n\n/**\n * @constructor\n * @see http://msdn.microsoft.com/en-us/library/aa752462(v=vs.85).aspx\n */\nfunction HTMLFiltersCollection() {}\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/aa752463(v=vs.85).aspx\n * @type {number}\n */\nHTMLFiltersCollection.prototype.length;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms537452(v=vs.85).aspx\n * @type {HTMLFiltersCollection}\n */\nElement.prototype.filters;\n\n/**\n * @constructor\n * @see http://msdn.microsoft.com/en-us/library/ms532853(v=vs.85).aspx\n */\nfunction HTMLFilter() {}\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms532954(v=vs.85).aspx\n * @return {undefined}\n */\nHTMLFilter.prototype.apply = function() {};\n\n/**\n * @constructor\n * @extends {HTMLFilter}\n * @see http://msdn.microsoft.com/en-us/library/ms532967(v=vs.85).aspx\n */\nfunction AlphaFilter() {}\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms532910(v=vs.85).aspx\n * @type {number}\n */\nAlphaFilter.prototype.Opacity;\n\n/**\n * @constructor\n * @extends {HTMLFilter}\n * @see http://msdn.microsoft.com/en-us/library/ms532969(v=vs.85).aspx\n */\nfunction AlphaImageLoaderFilter() {}\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ms532920(v=vs.85).aspx\n * @type {string}\n */\nAlphaImageLoaderFilter.prototype.sizingMethod;\n\n// For IE, returns an object representing key-value pairs for all the global\n// variables prefixed with str, e.g. test*\n\n/** @param {*=} opt_str\n */\nfunction RuntimeObject(opt_str) {}\n\n\n/**\n * @type {StyleSheet}\n * @see http://msdn.microsoft.com/en-us/library/dd347030(VS.85).aspx\n */\nHTMLStyleElement.prototype.styleSheet;\n\n\n/**\n * IE implements Cross Origin Resource Sharing (cross-domain XMLHttpRequests)\n * via the XDomainRequest object.\n *\n * @constructor\n * @see http://msdn.microsoft.com/en-us/library/cc288060(v=vs.85).aspx\n * @see http://www.w3.org/TR/cors/\n */\nfunction XDomainRequest() {}\n\n/**\n * Aborts the request.\n * @see http://msdn.microsoft.com/en-us/library/cc288129(v=vs.85).aspx\n * @return {undefined}\n */\nXDomainRequest.prototype.abort = function() {};\n\n/**\n * Sets the method and URL for the request.\n * @param {string} bstrMethod Either \"GET\" or \"POST\"\n * @param {string} bstrUrl The target URL\n * @see http://msdn.microsoft.com/en-us/library/cc288168(v=vs.85).aspx\n * @return {undefined}\n */\nXDomainRequest.prototype.open = function(bstrMethod, bstrUrl) {};\n\n/**\n * Sends the request.\n * @param {string=} varBody The POST body to send to the server. If omitted,\n *     the behavior is identical to sending an empty string.\n * @see http://msdn.microsoft.com/en-us/library/cc288207(v=vs.85).aspx\n * @return {undefined}\n */\nXDomainRequest.prototype.send = function(varBody) {};\n\n/**\n * Called if the request could not be completed. Note that error information is\n * not available.\n * @see http://msdn.microsoft.com/en-us/library/ms536930%28v=VS.85%29.aspx\n * @type {?function()}\n */\nXDomainRequest.prototype.onerror;\n\n/**\n * Called when the response has finished.\n * @see http://msdn.microsoft.com/en-us/library/ms536942%28v=VS.85%29.aspx\n * @type {?function()}\n */\nXDomainRequest.prototype.onload;\n\n/**\n * Called every time part of the response has been received.\n * @see http://msdn.microsoft.com/en-us/library/cc197058%28v=VS.85%29.aspx\n * @type {?function()}\n */\nXDomainRequest.prototype.onprogress;\n\n/**\n * Called if the timeout period has elapsed.\n * @see http://msdn.microsoft.com/en-us/library/cc197061%28v=VS.85%29.aspx\n * @type {?function()}\n */\nXDomainRequest.prototype.ontimeout;\n\n/**\n * The current response body.\n * @see http://msdn.microsoft.com/en-us/library/cc287956%28v=VS.85%29.aspx\n * @type {string}\n */\nXDomainRequest.prototype.responseText;\n\n/**\n * The timeout (in milliseconds) for the request.\n * @type {number}\n */\nXDomainRequest.prototype.timeout;\n\n/**\n * The Content-Type of the response, or an empty string.\n * @type {string}\n */\nXDomainRequest.prototype.contentType;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms533542(v=vs.85).aspx\n */\nNavigator.prototype.browserLanguage;\n\n/**\n * @type {number}\n * @see https://msdn.microsoft.com/en-us/library/ie/hh772144(v=vs.85).aspx\n */\nNavigator.prototype.msMaxTouchPoints;\n\n/**\n * @type {boolean}\n * @see http://blogs.msdn.com/b/ie/archive/2011/09/20/touch-input-for-ie10-and-metro-style-apps.aspx\n */\nNavigator.prototype.msPointerEnabled;\n\n/**\n * @param {(!File|!Blob)} blob\n * @param {string=} opt_defaultName\n * @return {boolean}\n * @see https://msdn.microsoft.com/en-us/library/hh772331(v=vs.85).aspx\n */\nNavigator.prototype.msSaveBlob = function(blob, opt_defaultName) {};\n\n/**\n * @param {(!File|!Blob)} blob\n * @param {string=} opt_defaultName\n * @return {boolean}\n * @see https://msdn.microsoft.com/en-us/library/hh772332(v=vs.85).aspx\n */\nNavigator.prototype.msSaveOrOpenBlob = function(blob, opt_defaultName) {};\n\n/**\n * @type {number}\n * @see http://msdn.microsoft.com/en-us/library/ms533721(v=vs.85).aspx\n */\nScreen.prototype.deviceXDPI;\n\n/**\n * @type {number}\n * @see http://msdn.microsoft.com/en-us/library/ms534128%28v=vs.85%29.aspx\n */\nScreen.prototype.logicalXDPI;\n\n/**\n * @type {number}\n * @see http://msdn.microsoft.com/en-us/library/ms534130%28v=vs.85%29.aspx\n */\nScreen.prototype.logicalYDPI;\n",
"externs/webkit_dom.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for all the extensions over W3C\'s DOM\n *  specification by WebKit. This file depends on w3c_dom2.js.\n *  All the provided definitions has been type annotated\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n */\n\n/**\n * @param {boolean=} opt_center\n * @see https://bugzilla.mozilla.org/show_bug.cgi?id=403510\n * @return {undefined}\n */\nElement.prototype.scrollIntoViewIfNeeded = function(opt_center) {};\n\n/**\n * @constructor\n * @see http://trac.webkit.org/browser/trunk/Source/WebCore/inspector/ScriptProfileNode.idl\n */\nfunction ScriptProfileNode() {};\n\n/** @type {string} */\nScriptProfileNode.prototype.functionName;\n\n/** @type {string} */\nScriptProfileNode.prototype.url;\n\n/** @type {number} */\nScriptProfileNode.prototype.lineNumber;\n\n/** @type {number} */\nScriptProfileNode.prototype.totalTime;\n\n/** @type {number} */\nScriptProfileNode.prototype.selfTime;\n\n/** @type {number} */\nScriptProfileNode.prototype.numberOfCalls;\n\n/** @type {Array<ScriptProfileNode>} */\nScriptProfileNode.prototype.children;\n\n/** @type {boolean} */\nScriptProfileNode.prototype.visible;\n\n/** @type {number} */\nScriptProfileNode.prototype.callUID;\n\n/**\n * @constructor\n * @see http://trac.webkit.org/browser/trunk/Source/WebCore/inspector/ScriptProfile.idl\n */\nfunction ScriptProfile() {};\n\n/** @type {string} */\nScriptProfile.prototype.title;\n\n/** @type {number} */\nScriptProfile.prototype.uid;\n\n/** @type {ScriptProfileNode} */\nScriptProfile.prototype.head;\n\n/**\n * @type {number}\n * @see http://developer.android.com/reference/android/webkit/WebView.html\n */\nWindow.prototype.devicePixelRatio;\n\n/**\n * @param {string} contextId\n * @param {string} name\n * @param {number} width\n * @param {number} height\n * @nosideeffects\n * @return {undefined}\n */\nDocument.prototype.getCSSCanvasContext =\n    function(contextId, name, width, height) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {?Range}\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Document/caretRangeFromPoint\n */\nDocument.prototype.caretRangeFromPoint = function(x, y) {};\n\n/**\n * @return {!Promise<boolean>}\n * @nosideeffects\n * @see https://webkit.org/blog/8124/introducing-storage-access-api\n */\nDocument.prototype.hasStorageAccess = function() {};\n\n/**\n * @return {!Promise<void>}\n * @see https://webkit.org/blog/8124/introducing-storage-access-api\n * @see https://developer.mozilla.org/docs/Web/API/Document/requestStorageAccess#Syntax\n */\nDocument.prototype.requestStorageAccess = function() {};\n',
"externs/w3c_css.js":"/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for W3C's CSS specification\n *  The whole file has been fully type annotated.\n *  http://www.w3.org/TR/DOM-Level-2-Style/css.html\n * @externs\n * @author acleung@google.com (Alan Leung)\n * @author stevey@google.com (Steve Yegge)\n *\n * TODO(nicksantos): When there are no more occurrences of w3c_range.js and\n * gecko_dom.js being included directly in BUILD files, bug dbeam to split the\n * bottom part of this file into a separate externs.\n */\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet\n */\nfunction StyleSheet() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-type\n */\nStyleSheet.prototype.type;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-disabled\n */\nStyleSheet.prototype.disabled;\n\n/**\n * @type {Node}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-owner\n */\nStyleSheet.prototype.ownerNode;\n\n/**\n * @type {StyleSheet}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-parentStyleSheet\n */\nStyleSheet.prototype.parentStyleSheet;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-href\n */\nStyleSheet.prototype.href;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-title\n */\nStyleSheet.prototype.title;\n\n/**\n * @type {MediaList}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-media\n */\nStyleSheet.prototype.media;\n\n/**\n * @constructor\n * @implements {IArrayLike<!StyleSheet>}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheetList\n */\nfunction StyleSheetList() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheetList-length\n */\nStyleSheetList.prototype.length;\n\n/**\n * @param {number} index\n * @return {StyleSheet}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheetList-item\n */\nStyleSheetList.prototype.item = function(index) {};\n\n/**\n * @constructor\n * @implements {IArrayLike<!MediaList>}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-MediaList\n */\nfunction MediaList() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-MediaList-mediaText\n */\nMediaList.prototype.mediaText;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-MediaList-length\n */\nMediaList.prototype.length;\n\n/**\n * @param {number} index\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-MediaList-item\n */\nMediaList.prototype.item = function(index) {};\n\n/**\n * @interface\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-LinkStyle\n */\nfunction LinkStyle() {}\n\n/**\n * @type {StyleSheet}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-LinkStyle-sheet\n */\nLinkStyle.prototype.sheet;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-DocumentStyle\n */\nfunction DocumentStyle() {}\n\n/**\n * @type {StyleSheetList}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-DocumentStyle-styleSheets\n */\nDocumentStyle.prototype.styleSheets;\n\n/**\n * @constructor\n * @extends {StyleSheet}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleSheet\n */\nfunction CSSStyleSheet() {}\n\n/**\n * @type {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleSheet-ownerRule\n */\nCSSStyleSheet.prototype.ownerRule;\n\n/**\n * @type {CSSRuleList}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleSheet-cssRules\n */\nCSSStyleSheet.prototype.cssRules;\n\n/**\n * @param {string} rule\n * @param {number} index\n * @return {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleSheet-insertRule\n */\nCSSStyleSheet.prototype.insertRule = function(rule, index) {};\n\n/**\n * @param {number} index\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleSheet-deleteRule\n * @return {undefined}\n */\nCSSStyleSheet.prototype.deleteRule = function(index) {};\n\n/**\n * @constructor\n * @implements {IArrayLike<!CSSRule>}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRuleList\n */\nfunction CSSRuleList() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRuleList-length\n */\nCSSRuleList.prototype.length;\n\n/**\n * @param {number} index\n * @return {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRuleList-item\n */\nCSSRuleList.prototype.item = function(index) {};\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule\n */\nfunction CSSRule() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-ruleType\n */\nCSSRule.prototype.type;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-cssText\n */\nCSSRule.prototype.cssText;\n\n/**\n * @type {CSSStyleSheet}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-sheet\n */\nCSSRule.prototype.parentStyleSheet;\n\n/**\n * @type {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-parentRule\n */\nCSSRule.prototype.parentRule;\n\n/**\n * @type {CSSStyleDeclaration}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleRule\n */\nCSSRule.prototype.style;\n\n/**\n * Indicates that the rule is a {@see CSSUnknownRule}.\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-ruleType\n */\nCSSRule.UNKNOWN_RULE;\n\n/**\n * Indicates that the rule is a {@see CSSStyleRule}.\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-ruleType\n */\nCSSRule.STYLE_RULE;\n\n/**\n * Indicates that the rule is a {@see CSSCharsetRule}.\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-ruleType\n */\nCSSRule.CHARSET_RULE;\n\n/**\n * Indicates that the rule is a {@see CSSImportRule}.\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-ruleType\n */\nCSSRule.IMPORT_RULE;\n\n/**\n * Indicates that the rule is a {@see CSSMediaRule}.\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-ruleType\n */\nCSSRule.MEDIA_RULE;\n\n/**\n * Indicates that the rule is a {@see CSSFontFaceRule}.\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-ruleType\n */\nCSSRule.FONT_FACE_RULE;\n\n/**\n * Indicates that the rule is a {@see CSSPageRule}.\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSRule-ruleType\n */\nCSSRule.PAGE_RULE;\n\n/**\n * @constructor\n * @extends {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleRule\n */\nfunction CSSStyleRule() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleRule-selectorText\n */\nCSSStyleRule.prototype.selectorText;\n\n/**\n * @type {CSSStyleDeclaration}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleRule-style\n */\nCSSStyleRule.prototype.style;\n\n/**\n * @constructor\n * @extends {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSMediaRule\n */\nfunction CSSMediaRule() {}\n\n/**\n * @type {MediaList}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSMediaRule-mediaTypes\n */\nCSSMediaRule.prototype.media;\n\n/**\n * @type {CSSRuleList}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSMediaRule-cssRules\n */\nCSSMediaRule.prototype.cssRules;\n\n/**\n * @param {string} rule\n * @param {number} index\n * @return {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSMediaRule-insertRule\n */\nCSSMediaRule.prototype.insertRule = function(rule, index) {};\n\n/**\n * @param {number} index\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSMediaRule-deleteRule\n * @return {undefined}\n */\nCSSMediaRule.prototype.deleteRule = function(index) {};\n\n/**\n * @constructor\n * @extends {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSFontFaceRule\n */\nfunction CSSFontFaceRule() {}\n\n/**\n * @type {CSSStyleDeclaration}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSFontFaceRule-style\n */\nCSSFontFaceRule.prototype.style;\n\n/**\n * @constructor\n * @extends {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPageRule\n */\nfunction CSSPageRule() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPageRule-name\n */\nCSSPageRule.prototype.selectorText;\n\n/**\n * @type {CSSStyleDeclaration}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPageRule-style\n */\nCSSPageRule.prototype.style;\n\n/**\n * @constructor\n * @extends {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSImportRule\n */\nfunction CSSImportRule() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSImportRule-href\n */\nCSSImportRule.prototype.href;\n\n/**\n * @type {MediaList}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSImportRule-media\n */\nCSSImportRule.prototype.media;\n\n/**\n * @type {CSSStyleSheet}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSImportRule-styleSheet\n */\nCSSImportRule.prototype.styleSheet;\n\n/**\n * @constructor\n * @extends {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSCharsetRule\n */\nfunction CSSCharsetRule() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSCharsetRule-encoding\n */\nCSSCharsetRule.prototype.encoding;\n\n/**\n * @constructor\n * @extends {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSUnknownRule\n */\nfunction CSSUnknownRule() {}\n\n/**\n * @constructor\n * @extends {CSSProperties}\n * @implements {IObject<(string|number), string>}\n * @implements {IArrayLike<string>}\n * @implements {Iterable<string>}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration\n */\nfunction CSSStyleDeclaration() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-cssText\n */\nCSSStyleDeclaration.prototype.cssText;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-length\n */\nCSSStyleDeclaration.prototype.length;\n\n/**\n * @type {CSSRule}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-parentRule\n */\nCSSStyleDeclaration.prototype.parentRule;\n\n/**\n * @param {string} propertyName\n * @return {CSSValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-getPropertyCSSValue\n */\nCSSStyleDeclaration.prototype.getPropertyCSSValue = function(propertyName) {};\n\n/**\n * @param {string} propertyName\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-getPropertyPriority\n */\nCSSStyleDeclaration.prototype.getPropertyPriority = function(propertyName) {};\n\n/**\n * @param {string} propertyName\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-getPropertyValue\n */\nCSSStyleDeclaration.prototype.getPropertyValue = function(propertyName) {};\n\n/**\n * @param {number} index\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-item\n */\nCSSStyleDeclaration.prototype.item = function(index) {};\n\n/**\n * @param {string} propertyName\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-removeProperty\n */\nCSSStyleDeclaration.prototype.removeProperty = function(propertyName) {};\n\n/**\n * @param {string} propertyName\n * @param {string} value\n * @param {string=} opt_priority\n * @return {undefined}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration-setProperty\n */\nCSSStyleDeclaration.prototype.setProperty = function(propertyName, value, opt_priority) {};\n\n// IE-specific\n\n/**\n * @param {string} name\n * @param {number=} opt_flags\n * @return {string|number|boolean|null}\n * @see http://msdn.microsoft.com/en-us/library/ms536429(VS.85).aspx\n */\nCSSStyleDeclaration.prototype.getAttribute = function(name, opt_flags) {};\n\n/**\n * @param {string} name\n * @return {string|number|boolean|null}\n * @see http://msdn.microsoft.com/en-us/library/aa358797(VS.85).aspx\n */\nCSSStyleDeclaration.prototype.getExpression = function(name) {};\n\n/**\n * @param {string} name\n * @param {number=} opt_flags\n * @return {boolean}\n * @see http://msdn.microsoft.com/en-us/library/ms536696(VS.85).aspx\n */\nCSSStyleDeclaration.prototype.removeAttribute =\n    function(name, opt_flags) {};\n\n/**\n * @param {string} name\n * @return {boolean}\n * @see http://msdn.microsoft.com/en-us/library/aa358798(VS.85).aspx\n */\nCSSStyleDeclaration.prototype.removeExpression = function(name) {};\n\n/**\n * @deprecated\n * @param {string} name\n * @param {*} value\n * @param {number=} opt_flags\n * @see http://msdn.microsoft.com/en-us/library/ms536739(VS.85).aspx\n * @return {undefined}\n */\nCSSStyleDeclaration.prototype.setAttribute = function(name, value, opt_flags) {};\n\n/**\n * @param {string} name\n * @param {string} expr\n * @param {string=} opt_language\n * @return {undefined}\n * @see http://msdn.microsoft.com/en-us/library/ms531196(VS.85).aspx\n */\nCSSStyleDeclaration.prototype.setExpression =\n    function(name, expr, opt_language) {};\n\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue\n */\nfunction CSSValue() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue-cssText\n */\nCSSValue.prototype.cssText;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue-cssValueType\n */\nCSSValue.prototype.cssValueType;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue-types\n */\nCSSValue.CSS_INHERIT;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue-types\n */\nCSSValue.CSS_PRIMITIVE_VALUE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue-types\n */\nCSSValue.CSS_VALUE_LIST;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue-types\n */\nCSSValue.CSS_CUSTOM;\n\n/**\n * @constructor\n * @extends {CSSValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nfunction CSSPrimitiveValue() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.prototype.primitiveType;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_UNKNOWN;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_NUMBER;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_PERCENTAGE;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_EMS;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_EXS;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_PX;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_CM;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_MM;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_IN;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_PT;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_PC;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_DEG;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_RAD;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_GRAD;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_MS;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_S;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_HZ;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_KHZ;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_DIMENSION;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_STRING;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_URI;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_IDENT;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_ATTR;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_COUNTER;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_RECT;\n\n/**\n * @const {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue\n */\nCSSPrimitiveValue.CSS_RGBCOLOR;\n\n/**\n * @return {Counter}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue-getCounterValue\n * @throws DOMException {@see DomException.INVALID_ACCESS_ERR}\n */\nCSSPrimitiveValue.prototype.getCounterValue = function() {};\n\n/**\n * @param {number} unitType\n * @return {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue-getFloatValue\n * @throws DOMException {@see DomException.INVALID_ACCESS_ERR}\n */\nCSSPrimitiveValue.prototype.getFloatValue = function(unitType) {};\n\n/**\n * @return {RGBColor}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue-getRGBColorValue\n * @throws DOMException {@see DomException.INVALID_ACCESS_ERR}\n */\nCSSPrimitiveValue.prototype.getRGBColorValue = function() {};\n\n/**\n * @return {Rect}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue-getRectValue\n * @throws DOMException {@see DomException.INVALID_ACCESS_ERR}\n */\nCSSPrimitiveValue.prototype.getRectValue = function() {};\n\n/**\n * @return {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue-getStringValue\n * @throws DOMException {@see DomException.INVALID_ACCESS_ERR}\n */\nCSSPrimitiveValue.prototype.getStringValue = function() {};\n\n/**\n * @param {number} unitType\n * @param {number} floatValue\n * @return {undefined}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue-setFloatValue\n * @throws DOMException {@see DomException.INVALID_ACCESS_ERR},\n *                      {@see DomException.NO_MODIFICATION_ALLOWED_ERR}\n */\nCSSPrimitiveValue.prototype.setFloatValue = function(unitType, floatValue) {};\n\n/**\n * @param {number} stringType\n * @param {string} stringValue\n * @return {undefined}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue-setStringValue\n * @throws DOMException {@see DomException.INVALID_ACCESS_ERR},\n *                      {@see DomException.NO_MODIFICATION_ALLOWED_ERR}\n */\nCSSPrimitiveValue.prototype.setStringValue = function(stringType, stringValue) {};\n\n/**\n * @constructor\n * @extends {CSSValue}\n * @implements {IArrayLike<!CSSValue>}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValueList\n */\nfunction CSSValueList() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValueList-length\n */\nCSSValueList.prototype.length;\n\n/**\n * @param {number} index\n * @return {CSSValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValueList-item\n */\nCSSValueList.prototype.item = function(index) {};\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-RGBColor\n */\nfunction RGBColor() {}\n\n/**\n * @type {CSSPrimitiveValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-RGBColor-red\n */\nRGBColor.prototype.red;\n\n/**\n * @type {CSSPrimitiveValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-RGBColor-green\n */\nRGBColor.prototype.green;\n\n/**\n * @type {CSSPrimitiveValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-RGBColor-blue\n */\nRGBColor.prototype.blue;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Rect\n */\nfunction Rect() {}\n\n/**\n * @type {CSSPrimitiveValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Rect-top\n */\nRect.prototype.top;\n\n/**\n * @type {CSSPrimitiveValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Rect-right\n */\nRect.prototype.right;\n\n/**\n * @type {CSSPrimitiveValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Rect-bottom\n */\nRect.prototype.bottom;\n\n/**\n * @type {CSSPrimitiveValue}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Rect-left\n */\nRect.prototype.left;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Counter\n */\nfunction Counter() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Counter-identifier\n */\nCounter.prototype.identifier;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Counter-listStyle\n */\nCounter.prototype.listStyle;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-Counter-separator\n */\nCounter.prototype.separator;\n\n/**\n * @interface\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-ViewCSS\n */\nfunction ViewCSS() {}\n\n/**\n * @param {Element} elt\n * @param {?string=} opt_pseudoElt This argument is required according to the\n *     CSS2 specification, but optional in all major browsers. See the note at\n *     https://developer.mozilla.org/en-US/docs/Web/API/Window.getComputedStyle\n * @return {?CSSStyleDeclaration}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSview-getComputedStyle\n * @see https://bugzilla.mozilla.org/show_bug.cgi?id=548397\n */\nViewCSS.prototype.getComputedStyle = function(elt, opt_pseudoElt) {};\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-DocumentCSS\n */\nfunction DocumentCSS() {}\n\n/**\n * @param {Element} elt\n * @param {string} pseudoElt\n * @return {CSSStyleDeclaration}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-DocumentCSS-getOverrideStyle\n */\nDocumentCSS.prototype.getOverrideStyle = function(elt, pseudoElt) {};\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-DOMImplementationCSS\n */\nfunction DOMImplementationCSS() {}\n\n/**\n * @param {string} title\n * @param {string} media\n * @return {CSSStyleSheet}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-DOMImplementationCSS-createCSSStyleSheet\n * @throws DOMException {@see DomException.SYNTAX_ERR}\n */\nDOMImplementationCSS.prototype.createCSSStyleSheet = function(title, media) {};\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-ElementCSSInlineStyle\n */\nfunction ElementCSSInlineStyle() {}\n\n/**\n * @type {CSSStyleDeclaration}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-ElementCSSInlineStyle-style\n */\nElementCSSInlineStyle.prototype.style;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties\n */\nfunction CSSProperties() {}\n\n// CSS 2 properties\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-azimuth\n */\nCSSProperties.prototype.azimuth;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-background\n */\nCSSProperties.prototype.background;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-backgroundAttachment\n */\nCSSProperties.prototype.backgroundAttachment;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-backgroundColor\n */\nCSSProperties.prototype.backgroundColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-backgroundImage\n */\nCSSProperties.prototype.backgroundImage;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-backgroundPosition\n */\nCSSProperties.prototype.backgroundPosition;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-backgroundRepeat\n */\nCSSProperties.prototype.backgroundRepeat;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-background/#the-background-size\n */\nCSSProperties.prototype.backgroundSize;\n\n/**\n * @implicitCast\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-border\n */\nCSSProperties.prototype.border;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderCollapse\n */\nCSSProperties.prototype.borderCollapse;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderColor\n */\nCSSProperties.prototype.borderColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderSpacing\n */\nCSSProperties.prototype.borderSpacing;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSPrimitiveValue-borderStyle\n */\nCSSProperties.prototype.borderStyle;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderTop\n */\nCSSProperties.prototype.borderTop;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderRight\n */\nCSSProperties.prototype.borderRight;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderBottom\n */\nCSSProperties.prototype.borderBottom;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderLeft\n */\nCSSProperties.prototype.borderLeft;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderTopColor\n */\nCSSProperties.prototype.borderTopColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderRightColor\n */\nCSSProperties.prototype.borderRightColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderBottomColor\n */\nCSSProperties.prototype.borderBottomColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderLeftColor\n */\nCSSProperties.prototype.borderLeftColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderTopStyle\n */\nCSSProperties.prototype.borderTopStyle;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderRightStyle\n */\nCSSProperties.prototype.borderRightStyle;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderBottomStyle\n */\nCSSProperties.prototype.borderBottomStyle;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderLeftStyle\n */\nCSSProperties.prototype.borderLeftStyle;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderTopWidth\n */\nCSSProperties.prototype.borderTopWidth;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderRightWidth\n */\nCSSProperties.prototype.borderRightWidth;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderBottomWidth\n */\nCSSProperties.prototype.borderBottomWidth;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderLeftWidth\n */\nCSSProperties.prototype.borderLeftWidth;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-borderWidth\n */\nCSSProperties.prototype.borderWidth;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-background/#the-border-radius\n */\nCSSProperties.prototype.borderRadius;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-background/#the-border-radius\n */\nCSSProperties.prototype.borderBottomLeftRadius;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-background/#the-border-radius\n */\nCSSProperties.prototype.borderBottomRightRadius;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-background/#the-border-radius\n */\nCSSProperties.prototype.borderTopLeftRadius;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-background/#the-border-radius\n */\nCSSProperties.prototype.borderTopRightRadius;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-background/#the-border-image-source\n */\nCSSProperties.prototype.borderImageSource;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-background/#the-border-image-slice\n */\nCSSProperties.prototype.borderImageSlice;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-background/#the-border-image-width\n */\nCSSProperties.prototype.borderImageWidth;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-background/#the-border-image-outset\n */\nCSSProperties.prototype.borderImageOutset;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-background/#the-border-image-repeat\n */\nCSSProperties.prototype.borderImageRepeat;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-background/#the-border-image\n */\nCSSProperties.prototype.borderImage;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/1998/REC-CSS2-19980512/visuren.html#propdef-bottom\n */\nCSSProperties.prototype.bottom;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-captionSide\n */\nCSSProperties.prototype.captionSide;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-clear\n */\nCSSProperties.prototype.clear;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-clip\n */\nCSSProperties.prototype.clip;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-color\n */\nCSSProperties.prototype.color;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-content\n */\nCSSProperties.prototype.content;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-counterIncrement\n */\nCSSProperties.prototype.counterIncrement;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-counterReset\n */\nCSSProperties.prototype.counterReset;\n\n/**\n * This is not an official part of the W3C spec. In practice, this is a settable\n * property that works cross-browser. It is used in goog.dom.setProperties() and\n * needs to be extern'd so the --disambiguate_properties JS compiler pass works.\n * @type {string}\n */\nCSSProperties.prototype.cssText;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-cue\n */\nCSSProperties.prototype.cue;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-cueAfter\n */\nCSSProperties.prototype.cueAfter;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-cueBefore\n */\nCSSProperties.prototype.cueBefore;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-cursor\n */\nCSSProperties.prototype.cursor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-direction\n */\nCSSProperties.prototype.direction;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-display\n */\nCSSProperties.prototype.display;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-elevation\n */\nCSSProperties.prototype.elevation;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-emptyCells\n */\nCSSProperties.prototype.emptyCells;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-cssFloat\n */\nCSSProperties.prototype.cssFloat;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-font\n */\nCSSProperties.prototype.font;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-fontFamily\n */\nCSSProperties.prototype.fontFamily;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-fontSize\n */\nCSSProperties.prototype.fontSize;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-fontSizeAdjust\n */\nCSSProperties.prototype.fontSizeAdjust;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-fontStretch\n */\nCSSProperties.prototype.fontStretch;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-fontStyle\n */\nCSSProperties.prototype.fontStyle;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-fontVariant\n */\nCSSProperties.prototype.fontVariant;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-fontWeight\n */\nCSSProperties.prototype.fontWeight;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-height\n */\nCSSProperties.prototype.height;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/1998/REC-CSS2-19980512/visuren.html#propdef-left\n */\nCSSProperties.prototype.left;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-letterSpacing\n */\nCSSProperties.prototype.letterSpacing;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-lineHeight\n */\nCSSProperties.prototype.lineHeight;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-listStyle\n */\nCSSProperties.prototype.listStyle;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-listStyleImage\n */\nCSSProperties.prototype.listStyleImage;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-listStylePosition\n */\nCSSProperties.prototype.listStylePosition;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-listStyleType\n */\nCSSProperties.prototype.listStyleType;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-margin\n */\nCSSProperties.prototype.margin;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-marginTop\n */\nCSSProperties.prototype.marginTop;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-marginRight\n */\nCSSProperties.prototype.marginRight;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-marginBottom\n */\nCSSProperties.prototype.marginBottom;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-marginLeft\n */\nCSSProperties.prototype.marginLeft;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-markerOffset\n */\nCSSProperties.prototype.markerOffset;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-marks\n */\nCSSProperties.prototype.marks;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-maxHeight\n */\nCSSProperties.prototype.maxHeight;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-maxWidth\n */\nCSSProperties.prototype.maxWidth;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-minHeight\n */\nCSSProperties.prototype.minHeight;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-minWidth\n */\nCSSProperties.prototype.minWidth;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-orphans\n */\nCSSProperties.prototype.orphans;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-outline\n */\nCSSProperties.prototype.outline;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-outlineColor\n */\nCSSProperties.prototype.outlineColor;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-outlineStyle\n */\nCSSProperties.prototype.outlineStyle;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-outlineWidth\n */\nCSSProperties.prototype.outlineWidth;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-overflow\n */\nCSSProperties.prototype.overflow;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-padding\n */\nCSSProperties.prototype.padding;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-paddingTop\n */\nCSSProperties.prototype.paddingTop;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-paddingRight\n */\nCSSProperties.prototype.paddingRight;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-paddingBottom\n */\nCSSProperties.prototype.paddingBottom;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-paddingLeft\n */\nCSSProperties.prototype.paddingLeft;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-page\n */\nCSSProperties.prototype.page;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-pageBreakAfter\n */\nCSSProperties.prototype.pageBreakAfter;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-pageBreakBefore\n */\nCSSProperties.prototype.pageBreakBefore;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-pageBreakInside\n */\nCSSProperties.prototype.pageBreakInside;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-pause\n */\nCSSProperties.prototype.pause;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-pauseAfter\n */\nCSSProperties.prototype.pauseAfter;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-pauseBefore\n */\nCSSProperties.prototype.pauseBefore;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-pitch\n */\nCSSProperties.prototype.pitch;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-pitchRange\n */\nCSSProperties.prototype.pitchRange;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-playDuring\n */\nCSSProperties.prototype.playDuring;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-position\n */\nCSSProperties.prototype.position;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-quotes\n */\nCSSProperties.prototype.quotes;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-ui/#resize\n */\nCSSProperties.prototype.resize;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-richness\n */\nCSSProperties.prototype.richness;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/1998/REC-CSS2-19980512/visuren.html#propdef-right\n */\nCSSProperties.prototype.right;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-size\n */\nCSSProperties.prototype.size;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-speak\n */\nCSSProperties.prototype.speak;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-speakHeader\n */\nCSSProperties.prototype.speakHeader;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-speakNumeral\n */\nCSSProperties.prototype.speakNumeral;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-speakPunctuation\n */\nCSSProperties.prototype.speakPunctuation;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-speechRate\n */\nCSSProperties.prototype.speechRate;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-stress\n */\nCSSProperties.prototype.stress;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-tableLayout\n */\nCSSProperties.prototype.tableLayout;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-textAlign\n */\nCSSProperties.prototype.textAlign;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-textDecoration\n */\nCSSProperties.prototype.textDecoration;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-textIndent\n */\nCSSProperties.prototype.textIndent;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-textShadow\n */\nCSSProperties.prototype.textShadow;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-textTransform\n */\nCSSProperties.prototype.textTransform;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/1998/REC-CSS2-19980512/visuren.html#propdef-top\n */\nCSSProperties.prototype.top;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-unicodeBidi\n */\nCSSProperties.prototype.unicodeBidi;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-verticalAlign\n */\nCSSProperties.prototype.verticalAlign;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-visibility\n */\nCSSProperties.prototype.visibility;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-voiceFamily\n */\nCSSProperties.prototype.voiceFamily;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-volume\n */\nCSSProperties.prototype.volume;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-whiteSpace\n */\nCSSProperties.prototype.whiteSpace;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-widows\n */\nCSSProperties.prototype.widows;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-width\n */\nCSSProperties.prototype.width;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-wordSpacing\n */\nCSSProperties.prototype.wordSpacing;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-wordWrap\n */\nCSSProperties.prototype.wordWrap;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSProperties-zIndex\n */\nCSSProperties.prototype.zIndex;\n\n// CSS 3 properties\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-background/#box-shadow\n */\nCSSProperties.prototype.boxShadow;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-ui/#box-sizing\n */\nCSSProperties.prototype.boxSizing;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-color/#transparency\n */\nCSSProperties.prototype.opacity;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-ui/#text-overflow\n */\nCSSProperties.prototype.textOverflow;\n\n// CSS 3 animations\n\n/**\n * @type {string|number}\n * @see https://www.w3.org/TR/css-animations-1/#animation\n */\nCSSProperties.prototype.animation;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-animations-1/#animation-delay\n */\nCSSProperties.prototype.animationDelay;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-animations-1/#animation-direction\n */\nCSSProperties.prototype.animationDirection;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-animations-1/#animation-duration\n */\nCSSProperties.prototype.animationDuration;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-animations-1/#animation-fill-mode\n */\nCSSProperties.prototype.animationFillMode;\n\n/**\n * @type {string|number}\n * @see https://www.w3.org/TR/css-animations-1/#animation-iteration-count\n */\nCSSProperties.prototype.animationIterationCount;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-animations-1/#animation-name\n */\nCSSProperties.prototype.animationName;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-animations-1/#animation-play-state\n */\nCSSProperties.prototype.animationPlayState;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-animations-1/#animation-timing-function\n */\nCSSProperties.prototype.animationTimingFunction;\n\n// CSS 3 transforms\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-2d-transforms/#backface-visibility-property\n */\nCSSProperties.prototype.backfaceVisibility;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-2d-transforms/#perspective\n */\nCSSProperties.prototype.perspective;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-2d-transforms/#perspective-origin\n */\nCSSProperties.prototype.perspectiveOrigin;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-2d-transforms/#effects\n */\nCSSProperties.prototype.transform;\n\n/**\n * @type {string|number}\n * @see http://www.w3.org/TR/css3-2d-transforms/#transform-origin\n */\nCSSProperties.prototype.transformOrigin;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-2d-transforms/#transform-style\n */\nCSSProperties.prototype.transformStyle;\n\n// CSS 3 transitions\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-transitions/#transition\n */\nCSSProperties.prototype.transition;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-transitions/#transition-delay\n */\nCSSProperties.prototype.transitionDelay;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-transitions/#transition-duration\n */\nCSSProperties.prototype.transitionDuration;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-transitions/#transition-property-property\n */\nCSSProperties.prototype.transitionProperty;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css3-transitions/#transition-timing-function\n */\nCSSProperties.prototype.transitionTimingFunction;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/SVG11/interact.html#PointerEventsProperty\n */\nCSSProperties.prototype.pointerEvents;\n\n\n// CSS Flexbox 1\n\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#align-content-property\n */\nCSSProperties.prototype.alignContent;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#align-items-property\n */\nCSSProperties.prototype.alignItems;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#align-items-property\n */\nCSSProperties.prototype.alignSelf;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#flex-property\n */\nCSSProperties.prototype.flex;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#flex-basis-property\n */\nCSSProperties.prototype.flexBasis;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#flex-direction-property\n */\nCSSProperties.prototype.flexDirection;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#flex-flow-property\n */\nCSSProperties.prototype.flexFlow;\n\n/**\n * @type {number}\n * @see https://www.w3.org/TR/css-flexbox-1/#flex-grow-property\n */\nCSSProperties.prototype.flexGrow;\n\n/**\n * @type {number}\n * @see https://www.w3.org/TR/css-flexbox-1/#flex-shrink-property\n */\nCSSProperties.prototype.flexShrink;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#flex-wrap-property\n */\nCSSProperties.prototype.flexWrap;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-flexbox-1/#justify-content-property\n */\nCSSProperties.prototype.justifyContent;\n\n/**\n * @type {number}\n * @see https://www.w3.org/TR/css-flexbox-1/#order-property\n */\nCSSProperties.prototype.order;\n\n// Externs for CSS Will Change Module Level 1\n// http://www.w3.org/TR/css-will-change/\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/css-will-change-1/#will-change\n */\nCSSProperties.prototype.willChange;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-ui-4/#propdef-user-select\n */\nCSSProperties.prototype.userSelect;\n\n// CSS 3 Images\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css3-images/#the-object-fit\n */\nCSSProperties.prototype.objectFit;\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css3-images/#object-position\n */\nCSSProperties.prototype.objectPosition;\n\n// CSS Masking\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-masking-1/\n */\nCSSProperties.prototype.clipPath;\n\n// CSS Containment\n\n/**\n * @type {string}\n * @see https://www.w3.org/TR/css-contain-1/\n */\nCSSProperties.prototype.contain;\n\n/**\n * TODO(dbeam): Put this in separate file named w3c_cssom.js.\n * Externs for the CSSOM View Module.\n * @see http://www.w3.org/TR/cssom-view/\n */\n\n// http://www.w3.org/TR/cssom-view/#extensions-to-the-window-interface\n\n/**\n * @param {string} media_query_list\n * @return {!MediaQueryList}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-matchmedia\n */\nWindow.prototype.matchMedia = function(media_query_list) {};\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-innerwidth\n */\nWindow.prototype.innerWidth;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-innerheight\n */\nWindow.prototype.innerHeight;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-scrollx\n */\nWindow.prototype.scrollX;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-pagexoffset\n */\nWindow.prototype.pageXOffset;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-scrolly\n */\nWindow.prototype.scrollY;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-pageyoffset\n */\nWindow.prototype.pageYOffset;\n\n/**\n * @typedef {{\n *   left: (number|undefined),\n *   top: (number|undefined),\n *   behavior: (string|undefined)\n * }}\n * @see https://www.w3.org/TR/cssom-view/#dictdef-scrolltooptions\n */\nvar ScrollToOptions;\n\n/**\n * @record\n * @see https://www.w3.org/TR/cssom-view/#dictdef-scrollintoviewoptions\n */\nfunction ScrollIntoViewOptions () {}\n\n/** @type {string|undefined} */\nScrollIntoViewOptions.prototype.behavior;\n\n/** @type {string|undefined} */\nScrollIntoViewOptions.prototype.block;\n\n/** @type {string|undefined} */\nScrollIntoViewOptions.prototype.inline;\n\n/**\n * @param {number|!ScrollToOptions} scrollToOptionsOrX\n * @param {number=} opt_y\n * @see http://www.w3.org/TR/cssom-view/#dom-window-scroll\n * @return {undefined}\n */\nWindow.prototype.scroll = function(scrollToOptionsOrX, opt_y) {};\n\n/**\n * @param {number|!ScrollToOptions} scrollToOptionsOrX\n * @param {number=} opt_y\n * @see http://www.w3.org/TR/cssom-view/#dom-window-scrollto\n * @return {undefined}\n */\nWindow.prototype.scrollTo = function(scrollToOptionsOrX, opt_y) {};\n\n/**\n * @param {number|!ScrollToOptions} scrollToOptionsOrX\n * @param {number=} opt_y\n * @see http://www.w3.org/TR/cssom-view/#dom-window-scrollby\n * @return {undefined}\n */\nWindow.prototype.scrollBy = function(scrollToOptionsOrX, opt_y) {};\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-screenx\n */\nWindow.prototype.screenX;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-screeny\n */\nWindow.prototype.screenY;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-outerwidth\n */\nWindow.prototype.outerWidth;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-window-outerheight\n */\nWindow.prototype.outerHeight;\n\n/**\n * @type {number}\n * @see https://www.w3.org/TR/cssom-view/#dom-window-devicepixelratio\n */\nWindow.prototype.devicePixelRatio;\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @see https://www.w3.org/TR/cssom-view/#dom-window-moveto\n */\nWindow.prototype.moveTo = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @see https://www.w3.org/TR/cssom-view/#dom-window-moveby\n */\nWindow.prototype.moveBy = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @see https://www.w3.org/TR/cssom-view/#dom-window-resizeto\n */\nWindow.prototype.resizeTo = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @see https://www.w3.org/TR/cssom-view/#dom-window-resizeby\n */\nWindow.prototype.resizeBy = function(x, y) {};\n\n/**\n * @constructor\n * @implements {EventTarget}\n * @see http://www.w3.org/TR/cssom-view/#mediaquerylist\n */\nfunction MediaQueryList() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/cssom-view/#dom-mediaquerylist-media\n */\nMediaQueryList.prototype.media;\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/cssom-view/#dom-mediaquerylist-matches\n */\nMediaQueryList.prototype.matches;\n\n/**\n * @param {MediaQueryListListener} listener\n * @see http://www.w3.org/TR/cssom-view/#dom-mediaquerylist-addlistener\n * @return {undefined}\n */\nMediaQueryList.prototype.addListener = function(listener) {};\n\n/**\n * @param {MediaQueryListListener} listener\n * @see http://www.w3.org/TR/cssom-view/#dom-mediaquerylist-removelistener\n * @return {undefined}\n */\nMediaQueryList.prototype.removeListener = function(listener) {};\n\n/** @override Not available in some browsers; use addListener instead. */\nMediaQueryList.prototype.addEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override Not available in old browsers; use removeListener instead. */\nMediaQueryList.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nMediaQueryList.prototype.dispatchEvent = function(evt) {};\n\n/**\n * @typedef {(function(!MediaQueryList) : void)}\n * @see http://www.w3.org/TR/cssom-view/#mediaquerylistlistener\n */\nvar MediaQueryListListener;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/cssom-view/#screen\n */\nfunction Screen() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-screen-availwidth\n */\nScreen.prototype.availWidth;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-screen-availheight\n */\nScreen.prototype.availHeight;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-screen-width\n */\nScreen.prototype.width;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-screen-height\n */\nScreen.prototype.height;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-screen-colordepth\n */\nScreen.prototype.colorDepth;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-screen-pixeldepth\n */\nScreen.prototype.pixelDepth;\n\n\n// http://www.w3.org/TR/cssom-view/#extensions-to-the-document-interface\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {?Element}\n * @see http://www.w3.org/TR/cssom-view/#dom-document-elementfrompoint\n */\nDocument.prototype.elementFromPoint = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {!IArrayLike<!Element>}\n * @see http://www.w3.org/TR/cssom-view/#dom-document-elementsfrompoint\n */\nDocument.prototype.elementsFromPoint = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {CaretPosition}\n * @see http://www.w3.org/TR/cssom-view/#dom-document-caretpositionfrompoint\n */\nDocument.prototype.caretPositionFromPoint = function(x, y) {};\n\n/**\n * @type {Element}\n * @see http://dev.w3.org/csswg/cssom-view/#dom-document-scrollingelement\n */\nDocument.prototype.scrollingElement;\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/cssom-view/#caretposition\n */\nfunction CaretPosition() {}\n\n/**\n * @type {Node}\n * @see http://www.w3.org/TR/cssom-view/#dom-caretposition-offsetnode\n */\nCaretPosition.prototype.offsetNode;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-caretposition-offset\n */\nCaretPosition.prototype.offset;\n\n\n// http://www.w3.org/TR/cssom-view/#extensions-to-the-element-interface\n\n/**\n * @return {!ClientRectList}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-getclientrects\n */\nElement.prototype.getClientRects = function() {};\n\n/**\n * @return {!DOMRect}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-getboundingclientrect\n */\nElement.prototype.getBoundingClientRect = function() {};\n\n/**\n * @param {(boolean|ScrollIntoViewOptions)=} top\n * @see http://www.w3.org/TR/cssom-view/#dom-element-scrollintoview\n * @return {undefined}\n */\nElement.prototype.scrollIntoView = function(top) {};\n\n/**\n * @param {number|!ScrollToOptions} scrollToOptionsOrX\n * @param {number=} opt_y\n * @see https://www.w3.org/TR/cssom-view/#extension-to-the-element-interface\n * @return {undefined}\n */\nElement.prototype.scrollTo = function(scrollToOptionsOrX, opt_y) {};\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-scrolltop\n */\nElement.prototype.scrollTop;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-scrollleft\n */\nElement.prototype.scrollLeft;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-scrollwidth\n */\nElement.prototype.scrollWidth;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-scrollheight\n */\nElement.prototype.scrollHeight;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-clienttop\n */\nElement.prototype.clientTop;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-clientleft\n */\nElement.prototype.clientLeft;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-clientwidth\n */\nElement.prototype.clientWidth;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-element-clientheight\n */\nElement.prototype.clientHeight;\n\n// http://www.w3.org/TR/cssom-view/#extensions-to-the-htmlelement-interface\n\n/**\n * @type {Element}\n * @see http://www.w3.org/TR/cssom-view/#dom-htmlelement-offsetparent\n */\nHTMLElement.prototype.offsetParent;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-htmlelement-offsettop\n */\nHTMLElement.prototype.offsetTop;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-htmlelement-offsetleft\n */\nHTMLElement.prototype.offsetLeft;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-htmlelement-offsetwidth\n */\nHTMLElement.prototype.offsetWidth;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-htmlelement-offsetheight\n */\nHTMLElement.prototype.offsetHeight;\n\n\n// http://www.w3.org/TR/cssom-view/#extensions-to-the-range-interface\n\n/**\n * @return {!ClientRectList}\n * @see http://www.w3.org/TR/cssom-view/#dom-range-getclientrects\n */\nRange.prototype.getClientRects = function() {};\n\n/**\n * @return {!DOMRect}\n * @see http://www.w3.org/TR/cssom-view/#dom-range-getboundingclientrect\n */\nRange.prototype.getBoundingClientRect = function() {};\n\n\n// http://www.w3.org/TR/cssom-view/#extensions-to-the-mouseevent-interface\n\n// MouseEvent: screen{X,Y} and client{X,Y} are in DOM Level 2/3 Event as well,\n// so it seems like a specification issue. I've emailed www-style@w3.org in\n// hopes of resolving the conflict, but in the mean time they can live here\n// (http://lists.w3.org/Archives/Public/www-style/2012May/0039.html).\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-screenx\n */\n//MouseEvent.prototype.screenX;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-screeny\n */\n//MouseEvent.prototype.screenY;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-pagex\n */\nMouseEvent.prototype.pageX;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-pagey\n */\nMouseEvent.prototype.pageY;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-clientx\n */\n//MouseEvent.prototype.clientX;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-clienty\n */\n//MouseEvent.prototype.clientY;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-x\n */\nMouseEvent.prototype.x;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-y\n */\nMouseEvent.prototype.y;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-offsetx\n */\nMouseEvent.prototype.offsetX;\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-mouseevent-offsety\n */\nMouseEvent.prototype.offsetY;\n\n\n// http://www.w3.org/TR/cssom-view/#rectangles\n\n/**\n * @constructor\n * @see http://www.w3.org/TR/cssom-view/#the-clientrectlist-interface\n * @implements {IArrayLike<!DOMRect>}\n */\nfunction ClientRectList() {}\n\n/**\n * @type {number}\n * @see http://www.w3.org/TR/cssom-view/#dom-clientrectlist-length\n */\nClientRectList.prototype.length;\n\n/**\n * @param {number} index\n * @return {?DOMRect}\n * @see http://www.w3.org/TR/cssom-view/#dom-clientrectlist-item\n */\nClientRectList.prototype.item = function(index) {};\n\n/**\n * @constructor\n * http://www.w3.org/TR/css3-conditional/#CSS-interface\n */\nfunction CSSInterface() {}\n\n/**\n * @param {string} ident\n * @return {string}\n * @see http://www.w3.org/TR/cssom/#the-css.escape()-method\n * @throws DOMException {@see DOMException.INVALID_CHARACTER_ERR}\n */\nCSSInterface.prototype.escape = function(ident) {};\n\n/**\n * @param {string} property\n * @param {string=} opt_value\n * @return {boolean}\n */\nCSSInterface.prototype.supports = function(property, opt_value) {};\n\n/**\n * TODO(nicksantos): This suppress tag probably isn't needed, and\n * should be removed.\n * @suppress {duplicate}\n * @type {CSSInterface}\n */\nvar CSS;\n\n/** @type {CSSInterface} */\nWindow.prototype.CSS;\n\n// http://dev.w3.org/csswg/css-font-loading/\n\n/**\n * Set of possible string values: 'error', 'loaded', 'loading', 'unloaded'.\n * @typedef {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#enumdef-fontfaceloadstatus\n */\nvar FontFaceLoadStatus;\n\n/**\n * @typedef {{\n *   style: (string|undefined),\n *   weight: (string|undefined),\n *   stretch: (string|undefined),\n *   unicodeRange: (string|undefined),\n *   variant: (string|undefined),\n *   featureSettings: (string|undefined)\n * }}\n * @see http://dev.w3.org/csswg/css-font-loading/#dictdef-fontfacedescriptors\n */\nvar FontFaceDescriptors;\n\n/**\n * @constructor\n * @param {string} fontFamily\n * @param {(string|ArrayBuffer|ArrayBufferView)} source\n * @param {!FontFaceDescriptors=} opt_descriptors\n * @see http://dev.w3.org/csswg/css-font-loading/#font-face-constructor\n */\nfunction FontFace(fontFamily, source, opt_descriptors) {}\n\n/**\n * @type {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontface-family\n */\nFontFace.prototype.family;\n\n/**\n * @type {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontface-style\n */\nFontFace.prototype.style;\n\n/**\n * @type {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontface-weight\n */\nFontFace.prototype.weight;\n\n/**\n * @type {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontface-stretch\n */\nFontFace.prototype.stretch;\n\n/**\n * @type {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontface-unicoderange\n */\nFontFace.prototype.unicodeRange;\n\n/**\n * @type {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontface-variant\n */\nFontFace.prototype.variant;\n\n/**\n * @type {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontface-featuresettings\n */\nFontFace.prototype.featureSettings;\n\n/**\n * @type {FontFaceLoadStatus}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontface-status\n */\nFontFace.prototype.status;\n\n/**\n * @return {!Promise<!FontFace>}\n * @see http://dev.w3.org/csswg/css-font-loading/#font-face-load\n */\nFontFace.prototype.load = function() {};\n\n/**\n * Set of possible string values: 'loaded', 'loading'.\n * @typedef {string}\n * @see http://dev.w3.org/csswg/css-font-loading/#enumdef-fontfacesetloadstatus\n */\nvar FontFaceSetLoadStatus;\n\n/**\n * @interface\n * @extends {EventTarget}\n * @see http://dev.w3.org/csswg/css-font-loading/#FontFaceSet-interface\n */\nfunction FontFaceSet() {}\n\n// Event handlers\n// http://dev.w3.org/csswg/css-font-loading/#FontFaceSet-events\n\n/** @type {?function (Event)} */ FontFaceSet.prototype.onloading;\n/** @type {?function (Event)} */ FontFaceSet.prototype.onloadingdone;\n/** @type {?function (Event)} */ FontFaceSet.prototype.onloadingerror;\n\n/**\n * @param {!FontFace} value\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-add\n * @return {undefined}\n */\nFontFaceSet.prototype.add = function(value) {};\n\n/**\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-clear\n * @return {undefined}\n */\nFontFaceSet.prototype.clear = function() {};\n\n/**\n * @param {!FontFace} value\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-delete\n * @return {undefined}\n */\nFontFaceSet.prototype.delete = function(value) {};\n\n/**\n * @param {!FontFace} font\n * @return {boolean}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-has\n */\nFontFaceSet.prototype.has = function(font) {};\n\n/**\n * @param {function(!FontFace, number, !FontFaceSet)} callback\n * @param {?Object=} selfObj\n * see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-foreach\n * @return {undefined}\n */\nFontFaceSet.prototype.forEach = function(callback, selfObj) {};\n\n/**\n * @param {string} font\n * @param {string=} opt_text\n * @return {!Promise<!Array<!FontFace>>}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-load\n */\nFontFaceSet.prototype.load = function(font, opt_text) {};\n\n/**\n * @param {string} font\n * @param {string=} opt_text\n * @return {boolean}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-check\n */\nFontFaceSet.prototype.check = function(font, opt_text) {};\n\n/**\n * @type {!Promise<!FontFaceSet>}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-ready\n */\nFontFaceSet.prototype.ready;\n\n/**\n * @type {FontFaceSetLoadStatus}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfaceset-status\n */\nFontFaceSet.prototype.status;\n\n/**\n * @constructor\n * @param {string} type\n * @param {{\n *   animationName: (string|undefined),\n *   elapsedTime: (number|undefined),\n *   pseudoElement: (string|undefined)\n * }=} opt_animationEventInitDict\n * @extends {Event}\n * @see https://drafts.csswg.org/css-animations/#interface-animationevent\n */\nfunction AnimationEvent(type, opt_animationEventInitDict) {};\n\n/**\n * @type {string}\n * @see https://drafts.csswg.org/css-animations/#dom-animationevent-animationname\n */\nAnimationEvent.prototype.animationName;\n\n/**\n * @type {number}\n * @see https://drafts.csswg.org/css-animations/#dom-animationevent-elapsedtime\n */\nAnimationEvent.prototype.elapsedTime;\n\n/**\n * @type {string}\n * @see https://drafts.csswg.org/css-animations/#dom-animationevent-pseudoelement\n */\nAnimationEvent.prototype.pseudoElement;\n\n/**\n * @record\n * @see http://dev.w3.org/csswg/css-animations/#csskeyframerule\n */\nfunction CSSKeyframeRule() {}\n\n/**\n * @type {string}\n * @see https://drafts.csswg.org/css-animations/#dom-csskeyframerule-keytext\n */\nCSSKeyframeRule.prototype.keyText;\n\n/**\n * @type {!CSSStyleDeclaration}\n * @see https://drafts.csswg.org/css-animations/#dom-csskeyframerule-style\n */\nCSSKeyframeRule.prototype.style;\n\n\n/**\n * @record\n * @see http://dev.w3.org/csswg/css-animations/#csskeyframesrule\n */\nfunction CSSKeyframesRule() {}\n\n/**\n * @see https://drafts.csswg.org/css-animations/#dom-csskeyframesrule-name\n * @type {string}\n */\nCSSKeyframesRule.prototype.name;\n\n/**\n * @see https://drafts.csswg.org/css-animations/#dom-csskeyframesrule-cssrules\n * @type {!CSSRuleList}\n */\nCSSKeyframesRule.prototype.cssRules;\n\n/**\n * @see https://drafts.csswg.org/css-animations/#dom-csskeyframesrule-findrule\n * @param {string} key The key text for the rule to find.\n * @return {?CSSKeyframeRule}\n */\nCSSKeyframesRule.prototype.findRule = function(key) {};\n\n/**\n * @see https://drafts.csswg.org/css-animations/#dom-csskeyframesrule-appendrule\n * @param {string} rule The text for the rule to append.\n */\nCSSKeyframesRule.prototype.appendRule = function(rule) {};\n\n/**\n * @see https://drafts.csswg.org/css-animations/#dom-csskeyframesrule-deleterule\n * @param {string} key The key text for the rule to delete.\n */\nCSSKeyframesRule.prototype.deleteRule = function(key) {};\n",
"externs/gecko_css.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for Gecko\'s custom CSS properties. Copied from:\n * http://mxr.mozilla.org/mozilla2.0/source/dom/interfaces/css/nsIDOMCSS2Properties.idl\n *\n * @externs\n * @author nicksantos@google.com (Nick Santos)\n */\n\n\n/** @type {string} */ CSSProperties.prototype.MozAppearance;\n/** @type {string} */ CSSProperties.prototype.MozBackfaceVisibility;\n/** @type {string} */ CSSProperties.prototype.MozBackgroundClip;\n/** @type {string} */ CSSProperties.prototype.MozBackgroundInlinePolicy;\n/** @type {string} */ CSSProperties.prototype.MozBackgroundOrigin;\n/** @type {string} */ CSSProperties.prototype.MozBinding;\n/** @type {string} */ CSSProperties.prototype.MozBorderBottomColors;\n/** @type {string} */ CSSProperties.prototype.MozBorderEnd;\n/** @type {string} */ CSSProperties.prototype.MozBorderEndColor;\n/** @type {string} */ CSSProperties.prototype.MozBorderEndStyle;\n/** @type {string} */ CSSProperties.prototype.MozBorderEndWidth;\n/** @type {string} */ CSSProperties.prototype.MozBorderImage;\n/** @type {string} */ CSSProperties.prototype.MozBorderLeftColors;\n/** @type {string} */ CSSProperties.prototype.MozBorderRadius;\n/** @type {string} */ CSSProperties.prototype.MozBorderRadiusTopleft;\n/** @type {string} */ CSSProperties.prototype.MozBorderRadiusTopright;\n/** @type {string} */ CSSProperties.prototype.MozBorderRadiusBottomleft;\n/** @type {string} */ CSSProperties.prototype.MozBorderRadiusBottomright;\n/** @type {string} */ CSSProperties.prototype.MozBorderRightColors;\n/** @type {string} */ CSSProperties.prototype.MozBorderStart;\n/** @type {string} */ CSSProperties.prototype.MozBorderStartColor;\n/** @type {string} */ CSSProperties.prototype.MozBorderStartStyle;\n/** @type {string} */ CSSProperties.prototype.MozBorderStartWidth;\n/** @type {string} */ CSSProperties.prototype.MozBorderTopColors;\n/** @type {string} */ CSSProperties.prototype.MozBoxAlign;\n/** @type {string} */ CSSProperties.prototype.MozBoxDirection;\n/** @type {string} */ CSSProperties.prototype.MozBoxFlex;\n/** @type {string} */ CSSProperties.prototype.MozBoxOrdinalGroup;\n/** @type {string} */ CSSProperties.prototype.MozBoxOrient;\n/** @type {string} */ CSSProperties.prototype.MozBoxPack;\n/** @type {string} */ CSSProperties.prototype.MozBoxSizing;\n/** @type {string} */ CSSProperties.prototype.MozBoxShadow;\n/** @type {string} */ CSSProperties.prototype.MozColumnCount;\n/** @type {string} */ CSSProperties.prototype.MozColumnGap;\n/** @type {string} */ CSSProperties.prototype.MozColumnRule;\n/** @type {string} */ CSSProperties.prototype.MozColumnRuleColor;\n/** @type {string} */ CSSProperties.prototype.MozColumnRuleStyle;\n/** @type {string} */ CSSProperties.prototype.MozColumnRuleWidth;\n/** @type {string} */ CSSProperties.prototype.MozColumnWidth;\n/** @type {string} */ CSSProperties.prototype.MozFloatEdge;\n/** @type {string} */ CSSProperties.prototype.MozFontFeatureSettings;\n/** @type {string} */ CSSProperties.prototype.MozFontLanguageOverride;\n/** @type {string} */ CSSProperties.prototype.MozForceBrokenImageIcon;\n/** @type {string} */ CSSProperties.prototype.MozImageRegion;\n/** @type {string} */ CSSProperties.prototype.MozMarginEnd;\n/** @type {string} */ CSSProperties.prototype.MozMarginStart;\n/** @type {number|string} */ CSSProperties.prototype.MozOpacity;\n/** @type {string} */ CSSProperties.prototype.MozOutline;\n/** @type {string} */ CSSProperties.prototype.MozOutlineColor;\n/** @type {string} */ CSSProperties.prototype.MozOutlineOffset;\n/** @type {string} */ CSSProperties.prototype.MozOutlineRadius;\n/** @type {string} */ CSSProperties.prototype.MozOutlineRadiusBottomleft;\n/** @type {string} */ CSSProperties.prototype.MozOutlineRadiusBottomright;\n/** @type {string} */ CSSProperties.prototype.MozOutlineRadiusTopleft;\n/** @type {string} */ CSSProperties.prototype.MozOutlineRadiusTopright;\n/** @type {string} */ CSSProperties.prototype.MozOutlineStyle;\n/** @type {string} */ CSSProperties.prototype.MozOutlineWidth;\n/** @type {string} */ CSSProperties.prototype.MozPaddingEnd;\n/** @type {string} */ CSSProperties.prototype.MozPaddingStart;\n/** @type {string} */ CSSProperties.prototype.MozPerspective;\n/** @type {string} */ CSSProperties.prototype.MozStackSizing;\n/** @type {string} */ CSSProperties.prototype.MozTabSize;\n/** @type {string} */ CSSProperties.prototype.MozTransform;\n/** @type {string} */ CSSProperties.prototype.MozTransformOrigin;\n/** @type {string} */ CSSProperties.prototype.MozTransition;\n/** @type {string} */ CSSProperties.prototype.MozTransitionDelay;\n/** @type {string} */ CSSProperties.prototype.MozTransitionDuration;\n/** @type {string} */ CSSProperties.prototype.MozTransitionProperty;\n/** @type {string} */ CSSProperties.prototype.MozTransitionTimingFunction;\n/** @type {string} */ CSSProperties.prototype.MozUserFocus;\n/** @type {string} */ CSSProperties.prototype.MozUserInput;\n/** @type {string} */ CSSProperties.prototype.MozUserModify;\n/** @type {string} */ CSSProperties.prototype.MozUserSelect;\n/** @type {string} */ CSSProperties.prototype.MozWindowShadow;\n\n\n// These are non-standard Gecko CSSOM properties on Window.prototype.screen.\n\n/**\n * @type {number}\n * @see https://developer.mozilla.org/En/DOM/window.screen.availTop\n */\nScreen.prototype.availTop;\n\n/**\n * @type {number}\n * @see https://developer.mozilla.org/En/DOM/window.screen.availLeft\n */\nScreen.prototype.availLeft;\n\n/**\n * @type {number}\n * @see https://developer.mozilla.org/En/DOM/window.screen.left\n */\nScreen.prototype.left;\n\n/**\n * @type {number}\n * @see https://developer.mozilla.org/En/DOM/window.screen.top\n */\nScreen.prototype.top;\n',
"externs/ie_css.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for IE\'s custom CSS properties, as defined here:\n * http://msdn.microsoft.com/en-us/library/aa768661(VS.85).aspx\n *\n * This page is also useful for the IDL definitions:\n * http://source.winehq.org/source/include/mshtml.idl\n *\n * @externs\n * @author nicksantos@google.com\n */\n\n/** @type {Element} */\nStyleSheet.prototype.owningElement;\n\n/** @type {boolean} */\nStyleSheet.prototype.readOnly;\n\n/** @type {StyleSheetList} */\nStyleSheet.prototype.imports;\n\n/** @type {string} */\nStyleSheet.prototype.id;\n\n/**\n * @param {string} bstrURL\n * @param {number} lIndex\n * @return {number}\n */\nStyleSheet.prototype.addImport;\n\n/**\n * @param {string} bstrSelector\n * @param {string} bstrStyle\n * @param {number=} opt_iIndex\n * @return {number}\n * @see http://msdn.microsoft.com/en-us/library/aa358796%28v=vs.85%29.aspx\n */\nStyleSheet.prototype.addRule;\n\n/**\n * @param {number} lIndex\n */\nStyleSheet.prototype.removeImport;\n\n/**\n * @param {number} lIndex\n */\nStyleSheet.prototype.removeRule;\n\n/** @type {string} */\nStyleSheet.prototype.cssText;\n\n/** @type {CSSRuleList} */\nStyleSheet.prototype.rules;\n\n// StyleSheet methods\n\n/**\n * @param {string} propName\n * @return {string}\n * @see http://msdn.microsoft.com/en-us/library/aa358797(VS.85).aspx\n */\nStyleSheet.prototype.getExpression;\n\n/**\n * @param {string} name\n * @param {string} expression\n * @return {undefined}\n * @see http://msdn.microsoft.com/en-us/library/ms531196(VS.85).aspx\n */\nStyleSheet.prototype.setExpression;\n\n/**\n * @param {string} expression\n * @return {undefined}\n * @see http://msdn.microsoft.com/en-us/library/aa358798(VS.85).aspx\n */\nStyleSheet.prototype.removeExpression;\n\n// IE-only CSS style names.\n\n/** @type {string} */ CSSProperties.prototype.backgroundPositionX;\n\n/** @type {string} */ CSSProperties.prototype.backgroundPositionY;\n\n/**\n * @see http://msdn.microsoft.com/en-us/library/ie/ms531081(v=vs.85).aspx\n * NOTE: Left untyped to avoid conflict with caller.\n */\nCSSProperties.prototype.behavior;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms533883.aspx\n */\nCSSProperties.prototype.imeMode;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms534176(VS.85).aspx\n */\nCSSProperties.prototype.msInterpolationMode;\n\n/** @type {string} */ CSSProperties.prototype.overflowX;\n\n/** @type {string} */ CSSProperties.prototype.overflowY;\n\n/** @type {number} */ CSSProperties.prototype.pixelWidth;\n\n/** @type {number} */ CSSProperties.prototype.pixelHeight;\n\n/** @type {number} */ CSSProperties.prototype.pixelLeft;\n\n/** @type {number} */ CSSProperties.prototype.pixelTop;\n\n/** @type {string} */ CSSProperties.prototype.styleFloat;\n\n/**\n * @type {string|number}\n * @see http://msdn.microsoft.com/en-us/library/ms535169(VS.85).aspx\n */\nCSSProperties.prototype.zoom;\n\n/**\n * @type {string}\n * @see http://msdn.microsoft.com/en-us/library/ms535153(VS.85).aspx\n */\nCSSProperties.prototype.writingMode;\n\n/**\n * IE-specific extensions.\n * @see http://blogs.msdn.com/b/ie/archive/2008/09/08/microsoft-css-vendor-extensions.aspx\n */\n\n/** @type {string} */\nCSSProperties.prototype.MsAccelerator;\n\n/** @type {string} */\nCSSProperties.prototype.MsBackgroundPositionX;\n\n/** @type {string} */\nCSSProperties.prototype.MsBackgroundPositionY;\n\n/** @type {string} */\nCSSProperties.prototype.MsBehavior;\n\n/** @type {string} */\nCSSProperties.prototype.MsBlockProgression;\n\n/** @type {string} */\nCSSProperties.prototype.MsFilter;\n\n/** @type {string} */\nCSSProperties.prototype.MsImeMode;\n\n/** @type {string} */\nCSSProperties.prototype.MsLayoutGrid;\n\n/** @type {string} */\nCSSProperties.prototype.MsLayoutGridChar;\n\n/** @type {string} */\nCSSProperties.prototype.MsLayoutGridLine;\n\n/** @type {string} */\nCSSProperties.prototype.MsLayoutGridMode;\n\n/** @type {string} */\nCSSProperties.prototype.MsLayoutGridType;\n\n/** @type {string} */\nCSSProperties.prototype.MsLineBreak;\n\n/** @type {string} */\nCSSProperties.prototype.MsLineGridMode;\n\n/** @type {string} */\nCSSProperties.prototype.MsInterpolationMode;\n\n/** @type {string} */\nCSSProperties.prototype.MsOverflowX;\n\n/** @type {string} */\nCSSProperties.prototype.MsOverflowY;\n\n/** @type {string} */\nCSSProperties.prototype.MsScrollbar3dlightColor;\n\n/** @type {string} */\nCSSProperties.prototype.MsScrollbarArrowColor;\n\n/** @type {string} */\nCSSProperties.prototype.MsScrollbarBaseColor;\n\n/** @type {string} */\nCSSProperties.prototype.MsScrollbarDarkshadowColor;\n\n/** @type {string} */\nCSSProperties.prototype.MsScrollbarFaceColor;\n\nCSSProperties.prototype.MsScrollbarHighlightColor;\n\n/** @type {string} */\nCSSProperties.prototype.MsScrollbarShadowColor;\n\n/** @type {string} */\nCSSProperties.prototype.MsScrollbarTrackColor;\n\n/** @type {string} */\nCSSProperties.prototype.MsTextAlignLast;\n\n/** @type {string} */\nCSSProperties.prototype.MsTextAutospace;\n\n/** @type {string} */\nCSSProperties.prototype.MsTextJustify;\n\n/** @type {string} */\nCSSProperties.prototype.MsTextKashidaSpace;\n\n/** @type {string} */\nCSSProperties.prototype.MsTextOverflow;\n\n/** @type {string} */\nCSSProperties.prototype.MsTextUnderlinePosition;\n\n/** @type {string} */\nCSSProperties.prototype.MsWordBreak;\n\n/** @type {string} */\nCSSProperties.prototype.MsWordWrap;\n\n/** @type {string} */\nCSSProperties.prototype.MsWritingMode;\n\n/** @type {string} */\nCSSProperties.prototype.MsZoom;\n\n/** @type {string} */\nCSSProperties.prototype.MsUserSelect;\n\n// See: http://msdn.microsoft.com/en-us/library/windows/apps/Hh702466.aspx\n\n/** @type {string} */\nCSSProperties.prototype.msContentZooming;\n\n/** @type {string} */\nCSSProperties.prototype.msTouchAction;\n\n/** @type {string} */\nCSSProperties.prototype.msTransform;\n\n/** @type {string} */\nCSSProperties.prototype.msTransition;\n',
"externs/webkit_css.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for WebKit\'s custom CSS properties. Copied from:\n * {@link\n * http://trac.webkit.org/browser/trunk/Source/WebCore/css/CSSPropertyNames.in}\n *\n * If you make changes to this file, notice that every property appears\n * twice: once as an uppercase name and once as a lowercase name.\n * WebKit allows both. The uppercase version is preferred.\n *\n * @externs\n * @author nicksantos@google.com (Nick Santos)\n * @author mastepien@google.com (Marek Stepien)\n */\n\n/** @type {string} */ CSSProperties.prototype.WebkitAlignContent;\n/** @type {string} */ CSSProperties.prototype.WebkitAlignItems;\n/** @type {string} */ CSSProperties.prototype.WebkitAlignSelf;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimation;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimationDelay;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimationDirection;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimationDuration;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimationFillMode;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimationIterationCount;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimationName;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimationPlayState;\n/** @type {string} */ CSSProperties.prototype.WebkitAnimationTimingFunction;\n/** @type {string} */ CSSProperties.prototype.WebkitAppearance;\n/** @type {string} */ CSSProperties.prototype.WebkitAppRegion;\n/** @type {string} */ CSSProperties.prototype.WebkitAspectRatio;\n/** @type {string} */ CSSProperties.prototype.WebkitBackfaceVisibility;\n/** @type {string} */ CSSProperties.prototype.WebkitBackgroundClip;\n/** @type {string} */ CSSProperties.prototype.WebkitBackgroundComposite;\n/** @type {string} */ CSSProperties.prototype.WebkitBackgroundOrigin;\n/** @type {string} */ CSSProperties.prototype.WebkitBackgroundSize;\n/** @type {string} */ CSSProperties.prototype.WebkitBinding;\n/** @type {string} */ CSSProperties.prototype.WebkitBlendMode;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderAfter;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderAfterColor;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderAfterStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderAfterWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderBefore;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderBeforeColor;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderBeforeStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderBeforeWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderBottomLeftRadius;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderBottomRightRadius;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderEnd;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderEndColor;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderEndStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderEndWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderFit;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderHorizontalSpacing;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderImage;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderRadius;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderStart;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderStartColor;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderStartStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderStartWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderTopLeftRadius;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderTopRightRadius;\n/** @type {string} */ CSSProperties.prototype.WebkitBorderVerticalSpacing;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxAlign;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxDecorationBreak;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxDirection;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxFlex;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxFlexGroup;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxLines;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxOrdinalGroup;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxOrient;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxPack;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxReflect;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxShadow;\n/** @type {string} */ CSSProperties.prototype.WebkitBoxSizing;\n/** @type {string} */ CSSProperties.prototype.WebkitColorCorrection;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnAxis;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnBreakAfter;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnBreakBefore;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnBreakInside;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnCount;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnGap;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnProgression;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnRule;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnRuleColor;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnRuleStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnRuleWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitColumns;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnSpan;\n/** @type {string} */ CSSProperties.prototype.WebkitColumnWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitDashboardRegion;\n/** @type {string} */ CSSProperties.prototype.WebkitFilter;\n/** @type {string} */ CSSProperties.prototype.WebkitFlex;\n/** @type {string} */ CSSProperties.prototype.WebkitFlexBasis;\n/** @type {string} */ CSSProperties.prototype.WebkitFlexDirection;\n/** @type {string} */ CSSProperties.prototype.WebkitFlexFlow;\n/** @type {string} */ CSSProperties.prototype.WebkitFlexGrow;\n/** @type {string} */ CSSProperties.prototype.WebkitFlexShrink;\n/** @type {string} */ CSSProperties.prototype.WebkitFlexWrap;\n/** @type {string} */ CSSProperties.prototype.WebkitFlowFrom;\n/** @type {string} */ CSSProperties.prototype.WebkitFlowInto;\n/** @type {string} */ CSSProperties.prototype.WebkitFontSizeDelta;\n/** @type {string} */ CSSProperties.prototype.WebkitFontSmoothing;\n/** @type {string} */ CSSProperties.prototype.WebkitGridColumn;\n/** @type {string} */ CSSProperties.prototype.WebkitGridColumns;\n/** @type {string} */ CSSProperties.prototype.WebkitGridRow;\n/** @type {string} */ CSSProperties.prototype.WebkitGridRows;\n/** @type {string} */ CSSProperties.prototype.WebkitHighlight;\n/** @type {string} */ CSSProperties.prototype.WebkitHyphenateCharacter;\n/** @type {string} */ CSSProperties.prototype.WebkitHyphenateLimitAfter;\n/** @type {string} */ CSSProperties.prototype.WebkitHyphenateLimitBefore;\n/** @type {string} */ CSSProperties.prototype.WebkitHyphenateLimitLines;\n/** @type {string} */ CSSProperties.prototype.WebkitHyphens;\n/** @type {string} */ CSSProperties.prototype.WebkitJustifyContent;\n/** @type {string} */ CSSProperties.prototype.WebkitLineAlign;\n/** @type {string} */ CSSProperties.prototype.WebkitLineBoxContain;\n/** @type {string} */ CSSProperties.prototype.WebkitLineBreak;\n/** @type {string} */ CSSProperties.prototype.WebkitLineClamp;\n/** @type {string} */ CSSProperties.prototype.WebkitLineGrid;\n/** @type {string} */ CSSProperties.prototype.WebkitLineSnap;\n/** @type {string} */ CSSProperties.prototype.WebkitLocale;\n/** @type {string} */ CSSProperties.prototype.WebkitLogicalHeight;\n/** @type {string} */ CSSProperties.prototype.WebkitLogicalWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginAfter;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginAfterCollapse;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginBefore;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginBeforeCollapse;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginBottomCollapse;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginCollapse;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginEnd;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginStart;\n/** @type {string} */ CSSProperties.prototype.WebkitMarginTopCollapse;\n/** @type {string} */ CSSProperties.prototype.WebkitMarquee;\n/** @type {string} */ CSSProperties.prototype.WebkitMarqueeDirection;\n/** @type {string} */ CSSProperties.prototype.WebkitMarqueeIncrement;\n/** @type {string} */ CSSProperties.prototype.WebkitMarqueeRepetition;\n/** @type {string} */ CSSProperties.prototype.WebkitMarqueeSpeed;\n/** @type {string} */ CSSProperties.prototype.WebkitMarqueeStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitMask;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskAttachment;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskBoxImage;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskBoxImageOutset;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskBoxImageRepeat;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskBoxImageSlice;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskBoxImageSource;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskBoxImageWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskClip;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskComposite;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskImage;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskOrigin;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskPosition;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskPositionX;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskPositionY;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskRepeat;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskRepeatX;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskRepeatY;\n/** @type {string} */ CSSProperties.prototype.WebkitMaskSize;\n/** @type {string} */\nCSSProperties.prototype.WebkitMatchNearestMailBlockquoteColor;\n/** @type {string} */ CSSProperties.prototype.WebkitMaxLogicalHeight;\n/** @type {string} */ CSSProperties.prototype.WebkitMaxLogicalWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitMinLogicalHeight;\n/** @type {string} */ CSSProperties.prototype.WebkitMinLogicalWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitNbspMode;\n/** @type {string} */ CSSProperties.prototype.WebkitOrder;\n/** @type {string} */ CSSProperties.prototype.WebkitOverflowScrolling;\n/** @type {string} */ CSSProperties.prototype.WebkitPaddingAfter;\n/** @type {string} */ CSSProperties.prototype.WebkitPaddingBefore;\n/** @type {string} */ CSSProperties.prototype.WebkitPaddingEnd;\n/** @type {string} */ CSSProperties.prototype.WebkitPaddingStart;\n/** @type {string} */ CSSProperties.prototype.WebkitPerspective;\n/** @type {string} */ CSSProperties.prototype.WebkitPerspectiveOrigin;\n/** @type {string} */ CSSProperties.prototype.WebkitPerspectiveOriginX;\n/** @type {string} */ CSSProperties.prototype.WebkitPerspectiveOriginY;\n/** @type {string} */ CSSProperties.prototype.WebkitPrintColorAdjust;\n/** @type {string} */ CSSProperties.prototype.WebkitRegionBreakAfter;\n/** @type {string} */ CSSProperties.prototype.WebkitRegionBreakBefore;\n/** @type {string} */ CSSProperties.prototype.WebkitRegionBreakInside;\n/** @type {string} */ CSSProperties.prototype.WebkitRegionOverflow;\n/** @type {string} */ CSSProperties.prototype.WebkitRtlOrdering;\n/** @type {string} */ CSSProperties.prototype.WebkitRubyPosition;\n/** @type {string} */ CSSProperties.prototype.WebkitShapeInside;\n/** @type {string} */ CSSProperties.prototype.WebkitShapeMargin;\n/** @type {string} */ CSSProperties.prototype.WebkitShapeOutside;\n/** @type {string} */ CSSProperties.prototype.WebkitShapePadding;\n/** @type {string} */ CSSProperties.prototype.WebkitTapHighlightColor;\n/** @type {string} */ CSSProperties.prototype.WebkitTextAlignLast;\n/** @type {string} */ CSSProperties.prototype.WebkitTextCombine;\n/** @type {string} */ CSSProperties.prototype.WebkitTextDecorationLine;\n/** @type {string} */ CSSProperties.prototype.WebkitTextDecorationsInEffect;\n/** @type {string} */ CSSProperties.prototype.WebkitTextDecorationStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitTextEmphasis;\n/** @type {string} */ CSSProperties.prototype.WebkitTextEmphasisColor;\n/** @type {string} */ CSSProperties.prototype.WebkitTextEmphasisPosition;\n/** @type {string} */ CSSProperties.prototype.WebkitTextEmphasisStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitTextFillColor;\n/** @type {string} */ CSSProperties.prototype.WebkitTextOrientation;\n/** @type {string} */ CSSProperties.prototype.WebkitTextSecurity;\n/** @type {string} */ CSSProperties.prototype.WebkitTextSizeAdjust;\n/** @type {string} */ CSSProperties.prototype.WebkitTextStroke;\n/** @type {string} */ CSSProperties.prototype.WebkitTextStrokeColor;\n/** @type {string} */ CSSProperties.prototype.WebkitTextStrokeWidth;\n/** @type {string} */ CSSProperties.prototype.WebkitTransform;\n/** @type {string} */ CSSProperties.prototype.WebkitTransformOrigin;\n/** @type {string} */ CSSProperties.prototype.WebkitTransformOriginX;\n/** @type {string} */ CSSProperties.prototype.WebkitTransformOriginY;\n/** @type {string} */ CSSProperties.prototype.WebkitTransformOriginZ;\n/** @type {string} */ CSSProperties.prototype.WebkitTransformStyle;\n/** @type {string} */ CSSProperties.prototype.WebkitTransition;\n/** @type {string} */ CSSProperties.prototype.WebkitTransitionDelay;\n/** @type {string} */ CSSProperties.prototype.WebkitTransitionDuration;\n/** @type {string} */ CSSProperties.prototype.WebkitTransitionProperty;\n/** @type {string} */ CSSProperties.prototype.WebkitTransitionRepeatCount;\n/** @type {string} */ CSSProperties.prototype.WebkitTransitionTimingFunction;\n/** @type {string} */ CSSProperties.prototype.WebkitUserDrag;\n/** @type {string} */ CSSProperties.prototype.WebkitUserModify;\n/** @type {string} */ CSSProperties.prototype.WebkitUserSelect;\n/** @type {string} */ CSSProperties.prototype.WebkitWrap;\n/** @type {string} */ CSSProperties.prototype.WebkitWrapFlow;\n/** @type {string} */ CSSProperties.prototype.WebkitWrapThrough;\n/** @type {string} */ CSSProperties.prototype.WebkitWritingMode;\n\n// WebKit also adds bindings for the lowercase versions of these properties.\n// The uppercase version is preferred.\n\n/** @type {string} */ CSSProperties.prototype.webkitAlignContent;\n/** @type {string} */ CSSProperties.prototype.webkitAlignItems;\n/** @type {string} */ CSSProperties.prototype.webkitAlignSelf;\n/** @type {string} */ CSSProperties.prototype.webkitAnimation;\n/** @type {string} */ CSSProperties.prototype.webkitAnimationDelay;\n/** @type {string} */ CSSProperties.prototype.webkitAnimationDirection;\n/** @type {string} */ CSSProperties.prototype.webkitAnimationDuration;\n/** @type {string} */ CSSProperties.prototype.webkitAnimationFillMode;\n/** @type {string} */ CSSProperties.prototype.webkitAnimationIterationCount;\n/** @type {string} */ CSSProperties.prototype.webkitAnimationName;\n/** @type {string} */ CSSProperties.prototype.webkitAnimationPlayState;\n/** @type {string} */ CSSProperties.prototype.webkitAnimationTimingFunction;\n/** @type {string} */ CSSProperties.prototype.webkitAppearance;\n/** @type {string} */ CSSProperties.prototype.webkitAppRegion;\n/** @type {string} */ CSSProperties.prototype.webkitAspectRatio;\n/** @type {string} */ CSSProperties.prototype.webkitBackfaceVisibility;\n/** @type {string} */ CSSProperties.prototype.webkitBackgroundClip;\n/** @type {string} */ CSSProperties.prototype.webkitBackgroundComposite;\n/** @type {string} */ CSSProperties.prototype.webkitBackgroundOrigin;\n/** @type {string} */ CSSProperties.prototype.webkitBackgroundSize;\n/** @type {string} */ CSSProperties.prototype.webkitBinding;\n/** @type {string} */ CSSProperties.prototype.webkitBlendMode;\n/** @type {string} */ CSSProperties.prototype.webkitBorderAfter;\n/** @type {string} */ CSSProperties.prototype.webkitBorderAfterColor;\n/** @type {string} */ CSSProperties.prototype.webkitBorderAfterStyle;\n/** @type {string} */ CSSProperties.prototype.webkitBorderAfterWidth;\n/** @type {string} */ CSSProperties.prototype.webkitBorderBefore;\n/** @type {string} */ CSSProperties.prototype.webkitBorderBeforeColor;\n/** @type {string} */ CSSProperties.prototype.webkitBorderBeforeStyle;\n/** @type {string} */ CSSProperties.prototype.webkitBorderBeforeWidth;\n/** @type {string} */ CSSProperties.prototype.webkitBorderBottomLeftRadius;\n/** @type {string} */ CSSProperties.prototype.webkitBorderBottomRightRadius;\n/** @type {string} */ CSSProperties.prototype.webkitBorderEnd;\n/** @type {string} */ CSSProperties.prototype.webkitBorderEndColor;\n/** @type {string} */ CSSProperties.prototype.webkitBorderEndStyle;\n/** @type {string} */ CSSProperties.prototype.webkitBorderEndWidth;\n/** @type {string} */ CSSProperties.prototype.webkitBorderFit;\n/** @type {string} */ CSSProperties.prototype.webkitBorderHorizontalSpacing;\n/** @type {string} */ CSSProperties.prototype.webkitBorderImage;\n/** @type {string} */ CSSProperties.prototype.webkitBorderRadius;\n/** @type {string} */ CSSProperties.prototype.webkitBorderStart;\n/** @type {string} */ CSSProperties.prototype.webkitBorderStartColor;\n/** @type {string} */ CSSProperties.prototype.webkitBorderStartStyle;\n/** @type {string} */ CSSProperties.prototype.webkitBorderStartWidth;\n/** @type {string} */ CSSProperties.prototype.webkitBorderTopLeftRadius;\n/** @type {string} */ CSSProperties.prototype.webkitBorderTopRightRadius;\n/** @type {string} */ CSSProperties.prototype.webkitBorderVerticalSpacing;\n/** @type {string} */ CSSProperties.prototype.webkitBoxAlign;\n/** @type {string} */ CSSProperties.prototype.webkitBoxDecorationBreak;\n/** @type {string} */ CSSProperties.prototype.webkitBoxDirection;\n/** @type {string} */ CSSProperties.prototype.webkitBoxFlex;\n/** @type {string} */ CSSProperties.prototype.webkitBoxFlexGroup;\n/** @type {string} */ CSSProperties.prototype.webkitBoxLines;\n/** @type {string} */ CSSProperties.prototype.webkitBoxOrdinalGroup;\n/** @type {string} */ CSSProperties.prototype.webkitBoxOrient;\n/** @type {string} */ CSSProperties.prototype.webkitBoxPack;\n/** @type {string} */ CSSProperties.prototype.webkitBoxReflect;\n/** @type {string} */ CSSProperties.prototype.webkitBoxShadow;\n/** @type {string} */ CSSProperties.prototype.webkitBoxSizing;\n/** @type {string} */ CSSProperties.prototype.webkitColorCorrection;\n/** @type {string} */ CSSProperties.prototype.webkitColumnAxis;\n/** @type {string} */ CSSProperties.prototype.webkitColumnBreakAfter;\n/** @type {string} */ CSSProperties.prototype.webkitColumnBreakBefore;\n/** @type {string} */ CSSProperties.prototype.webkitColumnBreakInside;\n/** @type {string} */ CSSProperties.prototype.webkitColumnCount;\n/** @type {string} */ CSSProperties.prototype.webkitColumnGap;\n/** @type {string} */ CSSProperties.prototype.webkitColumnProgression;\n/** @type {string} */ CSSProperties.prototype.webkitColumnRule;\n/** @type {string} */ CSSProperties.prototype.webkitColumnRuleColor;\n/** @type {string} */ CSSProperties.prototype.webkitColumnRuleStyle;\n/** @type {string} */ CSSProperties.prototype.webkitColumnRuleWidth;\n/** @type {string} */ CSSProperties.prototype.webkitColumns;\n/** @type {string} */ CSSProperties.prototype.webkitColumnSpan;\n/** @type {string} */ CSSProperties.prototype.webkitColumnWidth;\n/** @type {string} */ CSSProperties.prototype.webkitDashboardRegion;\n/** @type {string} */ CSSProperties.prototype.webkitFilter;\n/** @type {string} */ CSSProperties.prototype.webkitFlex;\n/** @type {string} */ CSSProperties.prototype.webkitFlexBasis;\n/** @type {string} */ CSSProperties.prototype.webkitFlexDirection;\n/** @type {string} */ CSSProperties.prototype.webkitFlexFlow;\n/** @type {string} */ CSSProperties.prototype.webkitFlexGrow;\n/** @type {string} */ CSSProperties.prototype.webkitFlexShrink;\n/** @type {string} */ CSSProperties.prototype.webkitFlexWrap;\n/** @type {string} */ CSSProperties.prototype.webkitFlowFrom;\n/** @type {string} */ CSSProperties.prototype.webkitFlowInto;\n/** @type {string} */ CSSProperties.prototype.webkitFontSizeDelta;\n/** @type {string} */ CSSProperties.prototype.webkitFontSmoothing;\n/** @type {string} */ CSSProperties.prototype.webkitGridColumn;\n/** @type {string} */ CSSProperties.prototype.webkitGridColumns;\n/** @type {string} */ CSSProperties.prototype.webkitGridRow;\n/** @type {string} */ CSSProperties.prototype.webkitGridRows;\n/** @type {string} */ CSSProperties.prototype.webkitHighlight;\n/** @type {string} */ CSSProperties.prototype.webkitHyphenateCharacter;\n/** @type {string} */ CSSProperties.prototype.webkitHyphenateLimitAfter;\n/** @type {string} */ CSSProperties.prototype.webkitHyphenateLimitBefore;\n/** @type {string} */ CSSProperties.prototype.webkitHyphenateLimitLines;\n/** @type {string} */ CSSProperties.prototype.webkitHyphens;\n/** @type {string} */ CSSProperties.prototype.webkitJustifyContent;\n/** @type {string} */ CSSProperties.prototype.webkitLineAlign;\n/** @type {string} */ CSSProperties.prototype.webkitLineBoxContain;\n/** @type {string} */ CSSProperties.prototype.webkitLineBreak;\n/** @type {string} */ CSSProperties.prototype.webkitLineClamp;\n/** @type {string} */ CSSProperties.prototype.webkitLineGrid;\n/** @type {string} */ CSSProperties.prototype.webkitLineSnap;\n/** @type {string} */ CSSProperties.prototype.webkitLocale;\n/** @type {string} */ CSSProperties.prototype.webkitLogicalHeight;\n/** @type {string} */ CSSProperties.prototype.webkitLogicalWidth;\n/** @type {string} */ CSSProperties.prototype.webkitMarginAfter;\n/** @type {string} */ CSSProperties.prototype.webkitMarginAfterCollapse;\n/** @type {string} */ CSSProperties.prototype.webkitMarginBefore;\n/** @type {string} */ CSSProperties.prototype.webkitMarginBeforeCollapse;\n/** @type {string} */ CSSProperties.prototype.webkitMarginBottomCollapse;\n/** @type {string} */ CSSProperties.prototype.webkitMarginCollapse;\n/** @type {string} */ CSSProperties.prototype.webkitMarginEnd;\n/** @type {string} */ CSSProperties.prototype.webkitMarginStart;\n/** @type {string} */ CSSProperties.prototype.webkitMarginTopCollapse;\n/** @type {string} */ CSSProperties.prototype.webkitMarquee;\n/** @type {string} */ CSSProperties.prototype.webkitMarqueeDirection;\n/** @type {string} */ CSSProperties.prototype.webkitMarqueeIncrement;\n/** @type {string} */ CSSProperties.prototype.webkitMarqueeRepetition;\n/** @type {string} */ CSSProperties.prototype.webkitMarqueeSpeed;\n/** @type {string} */ CSSProperties.prototype.webkitMarqueeStyle;\n/** @type {string} */ CSSProperties.prototype.webkitMask;\n/** @type {string} */ CSSProperties.prototype.webkitMaskAttachment;\n/** @type {string} */ CSSProperties.prototype.webkitMaskBoxImage;\n/** @type {string} */ CSSProperties.prototype.webkitMaskBoxImageOutset;\n/** @type {string} */ CSSProperties.prototype.webkitMaskBoxImageRepeat;\n/** @type {string} */ CSSProperties.prototype.webkitMaskBoxImageSlice;\n/** @type {string} */ CSSProperties.prototype.webkitMaskBoxImageSource;\n/** @type {string} */ CSSProperties.prototype.webkitMaskBoxImageWidth;\n/** @type {string} */ CSSProperties.prototype.webkitMaskClip;\n/** @type {string} */ CSSProperties.prototype.webkitMaskComposite;\n/** @type {string} */ CSSProperties.prototype.webkitMaskImage;\n/** @type {string} */ CSSProperties.prototype.webkitMaskOrigin;\n/** @type {string} */ CSSProperties.prototype.webkitMaskPosition;\n/** @type {string} */ CSSProperties.prototype.webkitMaskPositionX;\n/** @type {string} */ CSSProperties.prototype.webkitMaskPositionY;\n/** @type {string} */ CSSProperties.prototype.webkitMaskRepeat;\n/** @type {string} */ CSSProperties.prototype.webkitMaskRepeatX;\n/** @type {string} */ CSSProperties.prototype.webkitMaskRepeatY;\n/** @type {string} */ CSSProperties.prototype.webkitMaskSize;\n/** @type {string} */\nCSSProperties.prototype.webkitMatchNearestMailBlockquoteColor;\n/** @type {string} */ CSSProperties.prototype.webkitMaxLogicalHeight;\n/** @type {string} */ CSSProperties.prototype.webkitMaxLogicalWidth;\n/** @type {string} */ CSSProperties.prototype.webkitMinLogicalHeight;\n/** @type {string} */ CSSProperties.prototype.webkitMinLogicalWidth;\n/** @type {string} */ CSSProperties.prototype.webkitNbspMode;\n/** @type {string} */ CSSProperties.prototype.webkitOrder;\n/** @type {string} */ CSSProperties.prototype.webkitOverflowScrolling;\n/** @type {string} */ CSSProperties.prototype.webkitPaddingAfter;\n/** @type {string} */ CSSProperties.prototype.webkitPaddingBefore;\n/** @type {string} */ CSSProperties.prototype.webkitPaddingEnd;\n/** @type {string} */ CSSProperties.prototype.webkitPaddingStart;\n/** @type {string} */ CSSProperties.prototype.webkitPerspective;\n/** @type {string} */ CSSProperties.prototype.webkitPerspectiveOrigin;\n/** @type {string} */ CSSProperties.prototype.webkitPerspectiveOriginX;\n/** @type {string} */ CSSProperties.prototype.webkitPerspectiveOriginY;\n/** @type {string} */ CSSProperties.prototype.webkitPrintColorAdjust;\n/** @type {string} */ CSSProperties.prototype.webkitRegionBreakAfter;\n/** @type {string} */ CSSProperties.prototype.webkitRegionBreakBefore;\n/** @type {string} */ CSSProperties.prototype.webkitRegionBreakInside;\n/** @type {string} */ CSSProperties.prototype.webkitRegionOverflow;\n/** @type {string} */ CSSProperties.prototype.webkitRtlOrdering;\n/** @type {string} */ CSSProperties.prototype.webkitRubyPosition;\n/** @type {string} */ CSSProperties.prototype.webkitShapeInside;\n/** @type {string} */ CSSProperties.prototype.webkitShapeMargin;\n/** @type {string} */ CSSProperties.prototype.webkitShapeOutside;\n/** @type {string} */ CSSProperties.prototype.webkitShapePadding;\n/** @type {string} */ CSSProperties.prototype.webkitTapHighlightColor;\n/** @type {string} */ CSSProperties.prototype.webkitTextAlignLast;\n/** @type {string} */ CSSProperties.prototype.webkitTextCombine;\n/** @type {string} */ CSSProperties.prototype.webkitTextDecorationLine;\n/** @type {string} */ CSSProperties.prototype.webkitTextDecorationsInEffect;\n/** @type {string} */ CSSProperties.prototype.webkitTextDecorationStyle;\n/** @type {string} */ CSSProperties.prototype.webkitTextEmphasis;\n/** @type {string} */ CSSProperties.prototype.webkitTextEmphasisColor;\n/** @type {string} */ CSSProperties.prototype.webkitTextEmphasisPosition;\n/** @type {string} */ CSSProperties.prototype.webkitTextEmphasisStyle;\n/** @type {string} */ CSSProperties.prototype.webkitTextFillColor;\n/** @type {string} */ CSSProperties.prototype.webkitTextOrientation;\n/** @type {string} */ CSSProperties.prototype.webkitTextSecurity;\n/** @type {string} */ CSSProperties.prototype.webkitTextSizeAdjust;\n/** @type {string} */ CSSProperties.prototype.webkitTextStroke;\n/** @type {string} */ CSSProperties.prototype.webkitTextStrokeColor;\n/** @type {string} */ CSSProperties.prototype.webkitTextStrokeWidth;\n/** @type {string} */ CSSProperties.prototype.webkitTransform;\n/** @type {string} */ CSSProperties.prototype.webkitTransformOrigin;\n/** @type {string} */ CSSProperties.prototype.webkitTransformOriginX;\n/** @type {string} */ CSSProperties.prototype.webkitTransformOriginY;\n/** @type {string} */ CSSProperties.prototype.webkitTransformOriginZ;\n/** @type {string} */ CSSProperties.prototype.webkitTransformStyle;\n/** @type {string} */ CSSProperties.prototype.webkitTransition;\n/** @type {string} */ CSSProperties.prototype.webkitTransitionDelay;\n/** @type {string} */ CSSProperties.prototype.webkitTransitionDuration;\n/** @type {string} */ CSSProperties.prototype.webkitTransitionProperty;\n/** @type {string} */ CSSProperties.prototype.webkitTransitionRepeatCount;\n/** @type {string} */ CSSProperties.prototype.webkitTransitionTimingFunction;\n/** @type {string} */ CSSProperties.prototype.webkitUserDrag;\n/** @type {string} */ CSSProperties.prototype.webkitUserModify;\n/** @type {string} */ CSSProperties.prototype.webkitUserSelect;\n/** @type {string} */ CSSProperties.prototype.webkitWrap;\n/** @type {string} */ CSSProperties.prototype.webkitWrapFlow;\n/** @type {string} */ CSSProperties.prototype.webkitWrapThrough;\n/** @type {string} */ CSSProperties.prototype.webkitWritingMode;\n\n/**\n * @constructor\n * @param {number} x\n * @param {number} y\n */\nfunction WebKitPoint(x, y) {}\n\n/** @type {number} */\nWebKitPoint.prototype.x;\n\n/** @type {number} */\nWebKitPoint.prototype.y;\n',
"externs/google_legacy.js":'/*\n * Copyright 2010 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Declaration of the type level google namespace.\n * @externs\n * @author nicksantos@google.com (Nick Santos)\n */\n\n/**\n * Suppresses the compiler warning when multiple externs files declare the\n * google namespace.\n * @suppress {duplicate,strictMissingProperties}\n * NOTE: This definition should be marked \\@const, and when it is we can remove\n * the "strictMissingProperties" suppression.\n */\n// TODO(nicksantos): Consolidate to one google namespace declaration.\nvar google = {};\n',
"externs/deprecated.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview JavaScript Built-Ins that are not part of any specifications\n * but are still needed in some project\'s build.\n * @externs\n */\nvar opera = {};\n\nopera.postError;\n\n/** @nosideeffects */\nopera.version = function() {};\n\n/** @constructor */\nfunction XSLTProcessor() {}\n\n/**\n * @constructor\n * @extends {HTMLOptionElement}\n * @param {*=} opt_text\n * @param {*=} opt_value\n * @param {*=} opt_defaultSelected\n * @param {*=} opt_selected\n */\nfunction Option(opt_text, opt_value, opt_defaultSelected, opt_selected) {}\n\n\n// The "methods" object is a place to hang arbitrary external\n// properties. It is a throwback to pre-typed days, and should\n// not be used for any new definitions; it exists only to bridge\n// the gap between the old way and the new way.\nvar methods = {};\n\n/**\n * FF 1.5+ only\n * @param {IArrayLike<T>} arr\n * @param {?function(this:S, T, number, ?) : ?} callback\n * @param {S=} opt_context\n * @return {boolean}\n * @template T,S\n * @deprecated\n */\nArray.every = function(arr, callback, opt_context) {};\n\n/**\n * @param {IArrayLike<T>} arr\n * @param {?function(this:S, T, number, ?) : ?} callback\n * @param {S=} opt_context\n * @return {!Array<T>}\n * @template T,S\n * @deprecated\n */\nArray.filter = function(arr, callback, opt_context) {};\n\n/**\n * @param {IArrayLike<T>} arr\n * @param {?function(this:S, T, number, ?) : ?} callback\n * @param {S=} opt_context\n * @template T,S\n * @return {undefined}\n * @deprecated\n */\nArray.forEach = function(arr, callback, opt_context) {};\n\n/**\n * Mozilla 1.6+ only.\n * @param {IArrayLike<T>} arr\n * @param {T} obj\n * @param {number=} opt_fromIndex\n * @return {number}\n * @template T\n * @nosideeffects\n * @deprecated\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf\n */\nArray.indexOf = function(arr, obj, opt_fromIndex) {};\n\n/**\n * Mozilla 1.6+ only.\n * @param {IArrayLike<T>} arr\n * @param {T} obj\n * @param {number=} opt_fromIndex\n * @return {number}\n * @template T\n * @nosideeffects\n * @deprecated\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/lastIndexOf\n */\nArray.lastIndexOf = function(arr, obj, opt_fromIndex) {};\n\n/**\n * @param {IArrayLike<T>} arr\n * @param {?function(this:S, T, number, !Array<T>): R} callback\n * @param {S=} opt_context\n * @return {!Array<R>}\n * @deprecated\n * @template T,S,R\n */\nArray.map = function(arr, callback, opt_context) {};\n\n/**\n * @param {IArrayLike<T>} arr\n * @param {?function(this:S, T, number, ?) : ?} callback\n * @param {S=} opt_context\n * @return {boolean}\n * @deprecated\n * @template T,S\n */\nArray.some = function(arr, callback, opt_context) {};\n',
"externs/es6_proxy.js":'/*\n * Copyright 2018 The Closure Compiler Authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for ECMAScript 6 Proxy objects.\n * @see https://tc39.github.io/ecma262/#sec-proxy-objects\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy\n * @externs\n */\n\n\n/**\n * @record\n * @template TARGET\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler\n */\nfunction ProxyHandler() {}\n\n/**\n * @type {(function(TARGET):?Object)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-getprototypeof\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/getPrototypeOf\n */\nProxyHandler.prototype.getPrototypeOf /* = function(target) {} */;\n\n/**\n * @type {(function(TARGET, ?Object):boolean)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-setprototypeof-v\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/setPrototypeOf\n */\nProxyHandler.prototype.setPrototypeOf /* = function(target, proto) {} */;\n\n/**\n * @type {(function(TARGET):boolean)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-isextensible\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/isExtensible\n */\nProxyHandler.prototype.isExtensible /* = function(target) {} */;\n\n/**\n * @type {(function(TARGET):boolean)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-preventextensions\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/preventExtensions\n */\nProxyHandler.prototype.preventExtensions /* = function(target) {} */;\n\n/**\n * @type {(function(TARGET, (string|symbol)):(!ObjectPropertyDescriptor|undefined))|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-getownproperty-p\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/getOwnPropertyDescriptor\n */\nProxyHandler.prototype.getOwnPropertyDescriptor /* = function(target, prop) {} */;\n\n/**\n * @type {(function(TARGET, (string|symbol), !ObjectPropertyDescriptor):boolean)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-defineownproperty-p-desc\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/defineProperty\n */\nProxyHandler.prototype.defineProperty /* = function(target, prop, desc) {} */;\n\n/**\n * @type {(function(TARGET, (string|symbol)):boolean)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-hasproperty-p\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/has\n */\nProxyHandler.prototype.has /* = function(target, prop) {} */;\n\n/**\n * @type {(function(TARGET, (string|symbol), !Object):*)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-get-p-receiver\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/get\n */\nProxyHandler.prototype.get /* = function(target, prop, receiver) {} */;\n\n/**\n * @type {(function(TARGET, (string|symbol), *, !Object):boolean)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-set-p-v-receiver\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/set\n */\nProxyHandler.prototype.set /* = function(target, prop, value, receiver) {} */;\n\n/**\n * @type {(function(TARGET, (string|symbol)):boolean)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-delete-p\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/deleteProperty\n */\nProxyHandler.prototype.deleteProperty /* = function (target, prop) {} */;\n\n/**\n * @type {(function(TARGET):!Array<(string|symbol)>)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-ownpropertykeys\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/ownKeys\n */\nProxyHandler.prototype.ownKeys /* = function(target) {} */;\n\n/**\n * @type {(function(TARGET, *, !Array):*)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-call-thisargument-argumentslist\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/apply\n */\nProxyHandler.prototype.apply /* = function(target, thisArg, argList) {} */;\n\n/**\n * @type {(function(TARGET, !Array, function(new: ?, ...?)):!Object)|undefined}\n * @see https://tc39.github.io/ecma262/#sec-proxy-object-internal-methods-and-internal-slots-construct-argumentslist-newtarget\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/construct\n */\nProxyHandler.prototype.construct /* = function(target, argList, newTarget) {} */;\n\n\n/**\n * @constructor\n * @param {TARGET} target\n * @param {!ProxyHandler<TARGET>} handler\n * @template TARGET\n * @see https://tc39.github.io/ecma262/#sec-proxy-constructor\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy#Syntax\n */\nfunction Proxy(target, handler) {}\n\n/**\n * @param {TARGET} target\n * @param {!ProxyHandler<TARGET>} handler\n * @return {{proxy: !Proxy<TARGET>, revoke: function():void}}\n * @template TARGET\n * @see https://tc39.github.io/ecma262/#sec-proxy.revocable\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/revocable\n */\nProxy.revocable = function(target, handler) {};\n',
"externs/fido.js":'/*\n * Copyright 2018 The Closure Compiler Authors.\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions from the FIDO Specifications\n * @see https://fidoalliance.org/download/\n *\n * @externs\n * @author arnarbi@gmail.com (Arnar Birgisson)\n */\n\n/**\n * U2F JavaScript API namespace\n * @see https://fidoalliance.org/specs/fido-u2f-v1.2-ps-20170411/fido-u2f-javascript-api-v1.2-ps-20170411.html\n * @const\n */\nvar u2f = {};\n\n/**\n * Data object for a single sign request.\n * @typedef {string}\n */\nu2f.Transport;\n\n/**\n * Data object for a registered key.\n * @typedef {{\n *   version: string,\n *   keyHandle: string,\n *   transports: (!Array<!u2f.Transport>|undefined),\n *   appId: ?string\n * }}\n */\nu2f.RegisteredKey;\n\n/**\n * An error object for responses\n * @typedef {{\n *   errorCode: number,\n *   errorMessage: ?string\n * }}\n */\nu2f.Error;\n\n/**\n * Data object for a sign response.\n * @typedef {{\n *   keyHandle: string,\n *   signatureData: string,\n *   clientData: string\n * }}\n */\nu2f.SignResponse;\n\n/**\n * @typedef {{\n *   version: string,\n *   challenge: string\n * }}\n */\nu2f.RegisterRequest\n\n/**\n * @param {string} appId\n * @param {string} challenge\n * @param {!Array<!u2f.RegisteredKey>} registeredKeys\n * @param {function((!u2f.Error|!u2f.SignResponse))} callback\n * @param {number=} opt_timeoutSeconds\n */\nu2f.sign = function(\n    appId, challenge, registeredKeys, callback, opt_timeoutSeconds) {};\n\n/**\n * @param {string} appId\n * @param {!Array<!u2f.RegisterRequest>} registerRequests\n * @param {!Array<!u2f.RegisteredKey>} registeredKeys\n * @param {function((!u2f.Error|!u2f.SignResponse))} callback\n * @param {number=} opt_timeoutSeconds\n */\nu2f.register = function(\n    appId, registerRequests, registeredKeys, callback, opt_timeoutSeconds) {};\n',
"externs/w3c_fileapi.js":'/*\n * Copyright 2010 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n/**\n * @fileoverview Definitions for objects in the File API, File Writer API, and\n * File System API. Details of the API are at:\n * http://www.w3.org/TR/FileAPI/\n *\n * @externs\n */\n\n/** @record */\nfunction BlobPropertyBag() {};\n\n/** @type {(string|undefined)} */\nBlobPropertyBag.prototype.type;\n\n/**\n * @see http://dev.w3.org/2006/webapi/FileAPI/#dfn-Blob\n * @param {Array<ArrayBuffer|ArrayBufferView|Blob|string>=} opt_blobParts\n * @param {BlobPropertyBag=} opt_options\n * @constructor\n * @nosideeffects\n */\nfunction Blob(opt_blobParts, opt_options) {}\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-size\n * @type {number}\n */\nBlob.prototype.size;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-type\n * @type {string}\n */\nBlob.prototype.type;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-slice\n * @param {number=} start\n * @param {number=} length\n * @param {string=} opt_contentType\n * @return {!Blob}\n * @nosideeffects\n */\nBlob.prototype.slice = function(start, length, opt_contentType) {};\n\n\n/**\n * @record\n * @extends {BlobPropertyBag}\n **/\nfunction FilePropertyBag() {};\n\n/** @type {(number|undefined)} */\nFilePropertyBag.prototype.lastModified;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-file\n * @param {!Array<string|!Blob|!ArrayBuffer>=} contents\n * @param {string=} name\n * @param {FilePropertyBag=} properties\n * @constructor\n * @extends {Blob}\n */\nfunction File(contents, name, properties) {}\n\n/**\n * Chrome uses this instead of name.\n * @deprecated Use name instead.\n * @type {string}\n */\nFile.prototype.fileName;\n\n/**\n * Chrome uses this instead of size.\n * @deprecated Use size instead.\n * @type {string}\n */\nFile.prototype.fileSize;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-name\n * @type {string}\n */\nFile.prototype.name;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-lastModifiedDate\n * @type {Date}\n */\nFile.prototype.lastModifiedDate;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-lastModified\n * @type {number}\n */\nFile.prototype.lastModified;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-filereader\n * @constructor\n * @implements {EventTarget}\n */\nfunction FileReader() {}\n\n/** @override */\nFileReader.prototype.addEventListener = function(type, listener, opt_options) {\n};\n\n/** @override */\nFileReader.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nFileReader.prototype.dispatchEvent = function(evt) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readAsArrayBuffer\n * @param {!Blob} blob\n * @return {undefined}\n */\nFileReader.prototype.readAsArrayBuffer = function(blob) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readAsBinaryStringAsync\n * @param {!Blob} blob\n * @return {undefined}\n */\nFileReader.prototype.readAsBinaryString = function(blob) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readAsText\n * @param {!Blob} blob\n * @param {string=} encoding\n * @return {undefined}\n */\nFileReader.prototype.readAsText = function(blob, encoding) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readAsDataURL\n * @param {!Blob} blob\n * @return {undefined}\n */\nFileReader.prototype.readAsDataURL = function(blob) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-abort\n * @return {undefined}\n */\nFileReader.prototype.abort = function() {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-empty\n * @const {number}\n */\nFileReader.prototype.EMPTY;\n\n/** @const {number} */\nFileReader.EMPTY;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-loading\n * @const {number}\n */\nFileReader.prototype.LOADING;\n\n/** @const {number} */\nFileReader.LOADING;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-done\n * @const {number}\n */\nFileReader.prototype.DONE;\n\n/** @const {number} */\nFileReader.DONE;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readystate\n * @type {number}\n */\nFileReader.prototype.readyState;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-result\n * @type {string|Blob|ArrayBuffer}\n */\nFileReader.prototype.result;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-error\n * @type {DOMError}\n */\nFileReader.prototype.error;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-onloadstart\n * @type {?function(!ProgressEvent<!FileReader>)}\n */\nFileReader.prototype.onloadstart;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-onprogress\n * @type {?function(!ProgressEvent<!FileReader>)}\n */\nFileReader.prototype.onprogress;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-onload\n * @type {?function(!ProgressEvent<!FileReader>)}\n */\nFileReader.prototype.onload;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-onabort\n * @type {?function(!ProgressEvent<!FileReader>)}\n */\nFileReader.prototype.onabort;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-onerror\n * @type {?function(!ProgressEvent<!FileReader>)}\n */\nFileReader.prototype.onerror;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-onloadend\n * @type {?function(!ProgressEvent<!FileReader>)}\n */\nFileReader.prototype.onloadend;\n\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#FileReaderSyncSync\n * @constructor\n */\nfunction FileReaderSync() {}\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readAsArrayBufferSync\n * @param {!Blob} blob\n * @return {!ArrayBuffer}\n */\nFileReaderSync.prototype.readAsArrayBuffer = function(blob) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readAsBinaryStringSync\n * @param {!Blob} blob\n * @return {string}\n */\nFileReaderSync.prototype.readAsBinaryString = function(blob) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readAsTextSync\n * @param {!Blob} blob\n * @param {string=} encoding\n * @return {string}\n */\nFileReaderSync.prototype.readAsText = function(blob, encoding) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-readAsDataURLSync\n * @param {!Blob} blob\n * @return {string}\n */\nFileReaderSync.prototype.readAsDataURL = function(blob) {};\n',
"externs/nonstandard_fileapi.js":"/*\n * Copyright 2019 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for file api implemented in\n *     various browsers but not part of https://www.w3.org/TR/FileAPI.\n * @externs\n */\n\n/**\n * This replaces Blob.slice in Chrome since WebKit revision 84005.\n * @see http://lists.w3.org/Archives/Public/public-webapps/2011AprJun/0222.html\n * @param {number=} start\n * @param {number=} end\n * @param {string=} contentType\n * @return {!Blob}\n * @nosideeffects\n */\nBlob.prototype.webkitSlice = function(start, end, contentType) {};\n\n/**\n * This replaces Blob.slice in Firefox.\n * @see http://lists.w3.org/Archives/Public/public-webapps/2011AprJun/0222.html\n * @param {number=} start\n * @param {number=} end\n * @param {string=} contentType\n * @return {!Blob}\n * @nosideeffects\n */\nBlob.prototype.mozSlice = function(start, end, contentType) {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#the-blobbuilder-interface\n * @constructor\n */\nfunction BlobBuilder() {}\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-BlobBuilder-append0\n * @see http://www.w3.org/TR/file-writer-api/#widl-BlobBuilder-append1\n * @see http://www.w3.org/TR/file-writer-api/#widl-BlobBuilder-append2\n * @param {string|Blob|ArrayBuffer} data\n * @param {string=} endings\n * @return {undefined}\n */\nBlobBuilder.prototype.append = function(data, endings) {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-BlobBuilder-getBlob\n * @param {string=} contentType\n * @return {!Blob}\n */\nBlobBuilder.prototype.getBlob = function(contentType) {};\n\n/**\n * This has replaced BlobBuilder in Chrome since WebKit revision 84008.\n * @see http://lists.w3.org/Archives/Public/public-webapps/2011AprJun/0222.html\n * @constructor\n */\nfunction WebKitBlobBuilder() {}\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-BlobBuilder-append0\n * @see http://www.w3.org/TR/file-writer-api/#widl-BlobBuilder-append1\n * @see http://www.w3.org/TR/file-writer-api/#widl-BlobBuilder-append2\n * @param {string|Blob|ArrayBuffer} data\n * @param {string=} endings\n * @return {undefined}\n */\nWebKitBlobBuilder.prototype.append = function(data, endings) {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-BlobBuilder-getBlob\n * @param {string=} contentType\n * @return {!Blob}\n */\nWebKitBlobBuilder.prototype.getBlob = function(contentType) {};\n\n/**\n * @record\n * @see https://dev.w3.org/2009/dap/file-system/file-dir-sys.html#the-flags-dictionary\n */\nfunction FileSystemFlags() {};\n\n/** @type {(undefined|boolean)} */\nFileSystemFlags.prototype.create;\n\n/** @type {(undefined|boolean)} */\nFileSystemFlags.prototype.exclusive;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-directoryentry-interface\n * @constructor\n * @extends {Entry}\n */\nfunction DirectoryEntry() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryEntry-createReader\n * @return {!DirectoryReader}\n */\nDirectoryEntry.prototype.createReader = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryEntry-getFile\n * @param {string} path\n * @param {!FileSystemFlags=} options\n * @param {function(!FileEntry)=} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nDirectoryEntry.prototype.getFile = function(\n    path, options, successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryEntry-getDirectory\n * @param {string} path\n * @param {!FileSystemFlags=} options\n * @param {function(!DirectoryEntry)=} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nDirectoryEntry.prototype.getDirectory = function(\n    path, options, successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryEntry-removeRecursively\n * @param {function()} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nDirectoryEntry.prototype.removeRecursively = function(\n    successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-directoryreader-interface\n * @constructor\n */\nfunction DirectoryReader() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryReader-readEntries\n * @param {function(!Array<!Entry>)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nDirectoryReader.prototype.readEntries = function(\n    successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-entry-interface\n * @constructor\n */\nfunction Entry() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-isFile\n * @type {boolean}\n */\nEntry.prototype.isFile;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-isDirectory\n * @type {boolean}\n */\nEntry.prototype.isDirectory;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-name\n * @type {string}\n */\nEntry.prototype.name;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-fullPath\n * @type {string}\n */\nEntry.prototype.fullPath;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-filesystem\n * @type {!FileSystem}\n */\nEntry.prototype.filesystem;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-moveTo\n * @param {!DirectoryEntry} parent\n * @param {string=} newName\n * @param {function(!Entry)=} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nEntry.prototype.moveTo = function(\n    parent, newName, successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-copyTo\n * @param {!DirectoryEntry} parent\n * @param {string=} newName\n * @param {function(!Entry)=} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nEntry.prototype.copyTo = function(\n    parent, newName, successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-toURL\n * @param {string=} mimeType\n * @return {string}\n */\nEntry.prototype.toURL = function(mimeType) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-remove\n * @param {function()} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nEntry.prototype.remove = function(successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-getMetadata\n * @param {function(!Metadata)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nEntry.prototype.getMetadata = function(successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Entry-getParent\n * @param {function(!Entry)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nEntry.prototype.getParent = function(successCallback, errorCallback) {};\n\n/**\n * @return {?Entry} The Entry corresponding to this item, or null. Note that\n * despite its name,this method only works in Chrome, and will eventually\n * be renamed to {@code getAsEntry}.\n * @nosideeffects\n */\nDataTransferItem.prototype.webkitGetAsEntry = function() {};\n\n/**\n * @see https://wicg.github.io/entries-api/#dom-file-webkitrelativepath\n * @type {string}\n */\nFile.prototype.webkitRelativePath;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-fileentry-interface\n * @constructor\n * @extends {Entry}\n */\nfunction FileEntry() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileEntry-createWriter\n * @param {function(!FileWriter)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nFileEntry.prototype.createWriter = function(successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileEntry-file\n * @param {function(!File)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nFileEntry.prototype.file = function(successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#FileErrorInterface\n * @constructor\n * @extends {DOMError}\n */\nfunction FileError() {}\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-NOT_FOUND_ERR\n * @const {number}\n */\nFileError.prototype.NOT_FOUND_ERR;\n\n/** @const {number} */\nFileError.NOT_FOUND_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-SECURITY_ERR\n * @const {number}\n */\nFileError.prototype.SECURITY_ERR;\n\n/** @const {number} */\nFileError.SECURITY_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-ABORT_ERR\n * @const {number}\n */\nFileError.prototype.ABORT_ERR;\n\n/** @const {number} */\nFileError.ABORT_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-NOT_READABLE_ERR\n * @const {number}\n */\nFileError.prototype.NOT_READABLE_ERR;\n\n/** @const {number} */\nFileError.NOT_READABLE_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-ENCODING_ERR\n * @const {number}\n */\nFileError.prototype.ENCODING_ERR;\n\n/** @const {number} */\nFileError.ENCODING_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileError-NO_MODIFICATION_ALLOWED_ERR\n * @const {number}\n */\nFileError.prototype.NO_MODIFICATION_ALLOWED_ERR;\n\n/** @const {number} */\nFileError.NO_MODIFICATION_ALLOWED_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileException-INVALID_STATE_ERR\n * @const {number}\n */\nFileError.prototype.INVALID_STATE_ERR;\n\n/** @const {number} */\nFileError.INVALID_STATE_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileException-SYNTAX_ERR\n * @const {number}\n */\nFileError.prototype.SYNTAX_ERR;\n\n/** @const {number} */\nFileError.SYNTAX_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileError-INVALID_MODIFICATION_ERR\n * @const {number}\n */\nFileError.prototype.INVALID_MODIFICATION_ERR;\n\n/** @const {number} */\nFileError.INVALID_MODIFICATION_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileError-QUOTA_EXCEEDED_ERR\n * @const {number}\n */\nFileError.prototype.QUOTA_EXCEEDED_ERR;\n\n/** @const {number} */\nFileError.QUOTA_EXCEEDED_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileException-TYPE_MISMATCH_ERR\n * @const {number}\n */\nFileError.prototype.TYPE_MISMATCH_ERR;\n\n/** @const {number} */\nFileError.TYPE_MISMATCH_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileException-PATH_EXISTS_ERR\n * @const {number}\n */\nFileError.prototype.PATH_EXISTS_ERR;\n\n/** @const {number} */\nFileError.PATH_EXISTS_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-code-exception\n * @type {number}\n * @deprecated Use the 'name' or 'message' attributes of DOMError rather than\n * 'code'\n */\nFileError.prototype.code;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#idl-def-FileSaver\n * @constructor\n */\nfunction FileSaver() {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-abort\n * @return {undefined}\n */\nFileSaver.prototype.abort = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-INIT\n * @const {number}\n */\nFileSaver.prototype.INIT;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-WRITING\n * @const {number}\n */\nFileSaver.prototype.WRITING;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-DONE\n * @const {number}\n */\nFileSaver.prototype.DONE;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-readyState\n * @type {number}\n */\nFileSaver.prototype.readyState;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-error\n * @type {FileError}\n */\nFileSaver.prototype.error;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-onwritestart\n * @type {?function(!ProgressEvent<!FileSaver>)}\n */\nFileSaver.prototype.onwritestart;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-onprogress\n * @type {?function(!ProgressEvent<!FileSaver>)}\n */\nFileSaver.prototype.onprogress;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-onwrite\n * @type {?function(!ProgressEvent<!FileSaver>)}\n */\nFileSaver.prototype.onwrite;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-onabort\n * @type {?function(!ProgressEvent<!FileSaver>)}\n */\nFileSaver.prototype.onabort;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-onerror\n * @type {?function(!ProgressEvent<!FileSaver>)}\n */\nFileSaver.prototype.onerror;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileSaver-onwriteend\n * @type {?function(!ProgressEvent<!FileSaver>)}\n */\nFileSaver.prototype.onwriteend;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-filesystem-interface\n * @constructor\n */\nfunction FileSystem() {}\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileSystem-name\n * @type {string}\n */\nFileSystem.prototype.name;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileSystem-root\n * @type {!DirectoryEntry}\n */\nFileSystem.prototype.root;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#idl-def-FileWriter\n * @constructor\n * @extends {FileSaver}\n */\nfunction FileWriter() {}\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriter-position\n * @type {number}\n */\nFileWriter.prototype.position;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriter-length\n * @type {number}\n */\nFileWriter.prototype.length;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriter-write\n * @param {!Blob} blob\n * @return {undefined}\n */\nFileWriter.prototype.write = function(blob) {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriter-seek\n * @param {number} offset\n * @return {undefined}\n */\nFileWriter.prototype.seek = function(offset) {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriter-truncate\n * @param {number} size\n * @return {undefined}\n */\nFileWriter.prototype.truncate = function(size) {};\n\n/**\n * LocalFileSystem interface, implemented by Window and WorkerGlobalScope.\n * @see http://www.w3.org/TR/file-system-api/#idl-def-LocalFileSystem\n * @constructor\n */\nfunction LocalFileSystem() {}\n\n/**\n * Metadata interface.\n * @see http://www.w3.org/TR/file-system-api/#idl-def-Metadata\n * @constructor\n */\nfunction Metadata() {}\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Metadata-modificationTime\n * @type {!Date}\n */\nMetadata.prototype.modificationTime;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-Metadata-size\n * @type {number}\n */\nMetadata.prototype.size;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-TEMPORARY\n * @const {number}\n */\nWindow.prototype.TEMPORARY;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-PERSISTENT\n * @const {number}\n */\nWindow.prototype.PERSISTENT;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-requestFileSystem\n * @param {number} type\n * @param {number} size\n * @param {function(!FileSystem)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nfunction requestFileSystem(type, size, successCallback, errorCallback) {}\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-requestFileSystem\n * @param {number} type\n * @param {number} size\n * @param {function(!FileSystem)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nWindow.prototype.requestFileSystem = function(\n    type, size, successCallback, errorCallback) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-resolveLocalFileSystemURI\n * @param {string} uri\n * @param {function(!Entry)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nfunction resolveLocalFileSystemURI(uri, successCallback, errorCallback) {}\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-resolveLocalFileSystemURI\n * @param {string} uri\n * @param {function(!Entry)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nWindow.prototype.resolveLocalFileSystemURI =\n    function(uri, successCallback, errorCallback) {}\n\n/**\n * This has replaced requestFileSystem in Chrome since WebKit revision 84224.\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-requestFileSystem\n * @param {number} type\n * @param {number} size\n * @param {function(!FileSystem)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nfunction webkitRequestFileSystem(type, size, successCallback, errorCallback) {}\n\n/**\n * This has replaced requestFileSystem in Chrome since WebKit revision 84224.\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-requestFileSystem\n * @param {number} type\n * @param {number} size\n * @param {function(!FileSystem)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nWindow.prototype.webkitRequestFileSystem = function(type, size, successCallback,\n    errorCallback) {};\n\n/**\n * This has replaced resolveLocalFileSystemURI in Chrome since WebKit revision\n * 84224.\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-resolveLocalFileSystemURI\n * @param {string} uri\n * @param {function(!Entry)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nfunction webkitResolveLocalFileSystemURI(uri, successCallback, errorCallback) {}\n\n/**\n * This has replaced resolveLocalFileSystemURI in Chrome since WebKit revision\n * 84224.\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystem-resolveLocalFileSystemURI\n * @param {string} uri\n * @param {function(!Entry)} successCallback\n * @param {function(!FileError)=} errorCallback\n * @return {undefined}\n */\nWindow.prototype.webkitResolveLocalFileSystemURI = function(\n    uri, successCallback, errorCallback) {}\n\n// WindowBlobURIMethods interface, implemented by Window and WorkerGlobalScope.\n// There are three APIs for this: the old specced API, the new specced API, and\n// the webkit-prefixed API.\n// @see http://www.w3.org/TR/FileAPI/#creating-revoking\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-createObjectURL\n * @param {!Object} obj\n * @return {string}\n */\nfunction createObjectURL(obj) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-createObjectURL\n * @param {!Object} obj\n * @return {string}\n */\nWindow.prototype.createObjectURL = function(obj) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-revokeObjectURL\n * @param {string} url\n * @return {undefined}\n */\nfunction revokeObjectURL(url) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-revokeObjectURL\n * @param {string} url\n * @return {undefined}\n */\nWindow.prototype.revokeObjectURL = function(url) {};\n\n/**\n * This has been replaced by URL in Chrome since WebKit revision 75739.\n * @constructor\n * @param {string} urlString\n * @param {string=} base\n */\nfunction webkitURL(urlString, base) {}\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-createObjectURL\n * @param {!Object} obj\n * @return {string}\n */\nwebkitURL.createObjectURL = function(obj) {};\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-revokeObjectURL\n * @param {string} url\n * @return {undefined}\n */\nwebkitURL.revokeObjectURL = function(url) {};\n\n/**\n * @see https://developers.google.com/chrome/whitepapers/storage\n * @constructor\n */\nfunction StorageInfo() {}\n\n/**\n * @see https://developers.google.com/chrome/whitepapers/storage\n * @const {number}\n * */\nStorageInfo.prototype.TEMPORARY;\n\n/**\n * @see https://developers.google.com/chrome/whitepapers/storage\n * @const {number}\n */\nStorageInfo.prototype.PERSISTENT;\n\n/**\n * @see https://developers.google.com/chrome/whitepapers/storage#requestQuota\n * @param {number} type\n * @param {number} size\n * @param {function(number)} successCallback\n * @param {function(!DOMException)=} errorCallback\n * @return {undefined}\n */\nStorageInfo.prototype.requestQuota = function(\n    type, size, successCallback, errorCallback) {};\n\n/**\n * @see https://developers.google.com/chrome/whitepapers/storage#queryUsageAndQuota\n * @param {number} type\n * @param {function(number, number)} successCallback\n * @param {function(!DOMException)=} errorCallback\n * @return {undefined}\n */\nStorageInfo.prototype.queryUsageAndQuota = function(\n    type, successCallback, errorCallback) {};\n\n/**\n * @see https://developers.google.com/chrome/whitepapers/storage\n * @type {!StorageInfo}\n */\nWindow.prototype.webkitStorageInfo;\n\n/**\n * @see https://dvcs.w3.org/hg/quota/raw-file/tip/Overview.html#storagequota-interface.\n * @constructor\n */\nfunction StorageQuota() {}\n\n/**\n * @param {number} size\n * @param {function(number)=} successCallback\n * @param {function(!DOMException)=} errorCallback\n * @return {undefined}\n */\nStorageQuota.prototype.requestQuota = function(\n    size, successCallback, errorCallback) {};\n\n/**\n * @param {function(number, number)} successCallback\n * @param {function(!DOMException)=} errorCallback\n * @return {undefined}\n */\nStorageQuota.prototype.queryUsageAndQuota = function(\n    successCallback, errorCallback) {};\n\n/**\n * @type {!StorageQuota}\n * @see https://developer.chrome.com/apps/offline_storage\n */\nNavigator.prototype.webkitPersistentStorage;\n\n/**\n * @type {!StorageQuota}\n * @see https://developer.chrome.com/apps/offline_storage\n */\nNavigator.prototype.webkitTemporaryStorage;\n\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#idl-def-FileWriterSync\n * @constructor\n */\nfunction FileWriterSync() {}\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriterSync-position\n * @type {number}\n * @const\n */\nFileWriterSync.prototype.position;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriterSync-length\n * @type {number}\n * @const\n */\nFileWriterSync.prototype.length;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriter-write\n * @param {!Blob} blob\n * @return {undefined}\n */\nFileWriterSync.prototype.write = function(blob) {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriterSync-seek\n * @param {number} offset\n * @return {undefined}\n */\nFileWriterSync.prototype.seek = function(offset) {};\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileWriterSync-truncate\n * @param {number} size\n * @return {undefined}\n */\nFileWriterSync.prototype.truncate = function(size) {};\n\n/**\n * LocalFileSystemSync interface, implemented by WorkerGlobalScope.\n * @see http://www.w3.org/TR/file-system-api/#idl-def-LocalFileSystemSync\n * @constructor\n */\nfunction LocalFileSystemSync() {}\n\n/**\n * @see http://www.w3.org/TR/file-system-api/\n *     #the-synchronous-filesystem-interface\n * @constructor\n */\nfunction FileSystemSync() {}\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileSystemSync-name\n * @type {string}\n * @const\n */\nFileSystemSync.prototype.name;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileSystemSync-root\n * @type {!DirectoryEntrySync}\n * @const\n */\nFileSystemSync.prototype.root;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystemSync-requestFileSystemSync-FileSystemSync-unsigned-short-type-unsigned-long-long-size\n * @param {number} type\n * @param {number} size\n * @return {!FileSystemSync}\n */\nfunction requestFileSystemSync(type, size) {}\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-LocalFileSystemSync-requestFileSystemSync-FileSystemSync-unsigned-short-type-unsigned-long-long-size\n * @param {number} type\n * @param {number} size\n * @return {!FileSystemSync}\n */\nfunction webkitRequestFileSystemSync(type, size) {}\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-entrysync-interface\n * @constructor\n */\nfunction EntrySync() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-isFile\n * @type {boolean}\n * @const\n */\nEntrySync.prototype.isFile;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-isDirectory\n * @type {boolean}\n * @const\n */\nEntrySync.prototype.isDirectory;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-name\n * @type {string}\n * @const\n */\nEntrySync.prototype.name;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-fullPath\n * @type {string}\n * @const\n */\nEntrySync.prototype.fullPath;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-filesystem\n * @type {!FileSystemSync}\n * @const\n */\nEntrySync.prototype.filesystem;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-moveTo\n * @param {!DirectoryEntrySync} parent\n * @param {string=} newName\n * @return {!EntrySync}\n */\nEntrySync.prototype.moveTo = function(parent, newName) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-copyTo\n * @param {!DirectoryEntrySync} parent\n * @param {string=} newName\n * @return {!EntrySync}\n */\nEntrySync.prototype.copyTo = function(parent, newName) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-toURL\n * @param {string=} mimeType\n * @return {string}\n */\nEntrySync.prototype.toURL = function(mimeType) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-remove\n * @return {undefined}\n */\nEntrySync.prototype.remove = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-getMetadata\n * @return {!Metadata}\n */\nEntrySync.prototype.getMetadata = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-EntrySync-getParent\n * @return {!DirectoryEntrySync}\n */\nEntrySync.prototype.getParent = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-directoryentrysync-interface\n * @constructor\n * @extends {EntrySync}\n */\nfunction DirectoryEntrySync() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryEntrySync-createReader\n * @return {!DirectoryReaderSync}\n */\nDirectoryEntrySync.prototype.createReader = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryEntrySync-getFile\n * @param {string} path\n * @param {Object=} options\n * @return {!FileEntrySync}\n */\nDirectoryEntrySync.prototype.getFile = function(path, options) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryEntrySync-getDirectory\n * @param {string} path\n * @param {Object=} options\n * @return {!DirectoryEntrySync}\n */\nDirectoryEntrySync.prototype.getDirectory = function(path, options) {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryEntrySync-removeRecursively\n * @return {undefined}\n */\nDirectoryEntrySync.prototype.removeRecursively = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-directoryreadersync-interface\n * @constructor\n */\nfunction DirectoryReaderSync() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-DirectoryReaderSync-readEntries\n * @return {!Array<!EntrySync>}\n */\nDirectoryReaderSync.prototype.readEntries = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-fileentrysync-interface\n * @constructor\n * @extends {EntrySync}\n */\nfunction FileEntrySync() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileEntrySync-createWriter\n * @return {!FileWriterSync}\n */\nFileEntrySync.prototype.createWriter = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileEntrySync-file\n * @return {!File}\n */\nFileEntrySync.prototype.file = function() {};\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#the-fileexception-exception\n * @constructor\n */\nfunction FileException() {}\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-NOT_FOUND_ERR\n * @type {number}\n */\nFileException.prototype.NOT_FOUND_ERR;\n\n/** @type {number} */\nFileException.NOT_FOUND_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-SECURITY_ERR\n * @type {number}\n */\nFileException.prototype.SECURITY_ERR;\n\n/** @type {number} */\nFileException.SECURITY_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#widl-FileException-ABORT_ERR\n * @type {number}\n */\nFileException.prototype.ABORT_ERR;\n\n/** @type {number} */\nFileException.ABORT_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#widl-FileException-NOT_READABLE_ERR\n * @type {number}\n */\nFileException.prototype.NOT_READABLE_ERR;\n\n/** @type {number} */\nFileException.NOT_READABLE_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#widl-FileException-ENCODING_ERR\n * @type {number}\n */\nFileException.prototype.ENCODING_ERR;\n\n/** @type {number} */\nFileException.ENCODING_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileException-NO_MODIFICATION_ALLOWED_ERR\n * @type {number}\n */\nFileException.prototype.NO_MODIFICATION_ALLOWED_ERR;\n\n/** @type {number} */\nFileException.NO_MODIFICATION_ALLOWED_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileException-INVALID_STATE_ERR\n * @type {number}\n */\nFileException.prototype.INVALID_STATE_ERR;\n\n/** @type {number} */\nFileException.INVALID_STATE_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-writer-api/#widl-FileException-SYNTAX_ERR\n * @type {number}\n */\nFileException.prototype.SYNTAX_ERR;\n\n/** @type {number} */\nFileException.SYNTAX_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileException-INVALID_MODIFICATION_ERR\n * @type {number}\n */\nFileException.prototype.INVALID_MODIFICATION_ERR;\n\n/** @type {number} */\nFileException.INVALID_MODIFICATION_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileException-QUOTA_EXCEEDED_ERR\n * @type {number}\n */\nFileException.prototype.QUOTA_EXCEEDED_ERR;\n\n/** @type {number} */\nFileException.QUOTA_EXCEEDED_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileException-TYPE_MISMATCH_ERR\n * @type {number}\n */\nFileException.prototype.TYPE_MISMATCH_ERR;\n\n/** @type {number} */\nFileException.TYPE_MISMATCH_ERR;\n\n/**\n * @see http://www.w3.org/TR/file-system-api/#widl-FileException-PATH_EXISTS_ERR\n * @type {number}\n */\nFileException.prototype.PATH_EXISTS_ERR;\n\n/** @type {number} */\nFileException.PATH_EXISTS_ERR;\n\n/**\n * @see http://www.w3.org/TR/FileAPI/#dfn-code-exception\n * @type {number}\n */\nFileException.prototype.code;\n",
"externs/flash.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n/**\n * @fileoverview Definitions for all the Flash Object JavaScript methods. This\n * file depends on w3c_dom2.js.\n * Created from\n * http://www.adobe.com/support/flash/publishexport/scriptingwithflash/scriptingwithflash_03.html\n *\n * @externs\n * @author ajp@google.com (Andy Perelson)\n */\n\n\n// Standard Methods.\n\n/**\n * Call a Flash function exported by ExternalInterface.\n * @param {string} xmlString The XML string passed to Flash. The outer element\n *     should be {@code <invoke>}. A sample invocation string:\n *     {@code <invoke name="function_name" returntype="javascript">\n *     <string>test</string></invoke>}\n * @return {string} The serialized return value from Flash that you can eval.\n */\nHTMLObjectElement.prototype.CallFunction = function(xmlString) {};\n\n/**\n * Returns the value of the Flash variable specified by varName or null if the\n * variable does not exist.\n * @param {string} varName The variable name.\n * @return {?string} The variable value.\n */\nHTMLObjectElement.prototype.GetVariable = function(varName) {};\n\n/**\n * Activates the frame number specified by `frameNumber` in the current\n * movie.\n * @param {number} frameNumber A non-negative integer frame number.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.GotoFrame = function(frameNumber) {};\n\n/**\n * @return {boolean} Whether the movie is currently playing.\n */\nHTMLObjectElement.prototype.IsPlaying = function() {};\n\n/**\n * Loads the movie identified by `url` to the layer specified by\n * `layerNumber`.\n * @param {number} layerNumber The layer number.\n * @param {string} url The movie URL.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.LoadMovie = function(layerNumber, url) {};\n\n/**\n * Pans a zoomed-in movie to the coordinates specified by x and y. Use mode to\n * specify whether the values for x and y are pixels or a percent of the window.\n * When mode is 0, the coordinates are pixels; when mode is 1, the coordinates\n * are percent of the window.\n * @param {number} x The x-coordinate.\n * @param {number} y The y-coordinate.\n * @param {number} mode The mode.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.Pan = function(x, y, mode) {};\n\n/**\n * @return {number} The percent of the Flash Player movie that has streamed\n *     into the browser so far; Possible values are from 0 to 100.\n */\nHTMLObjectElement.prototype.PercentLoaded = function() {};\n\n/**\n * Starts playing the movie.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.Play = function() {};\n\n/**\n * Goes to the first frame.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.Rewind = function() {};\n\n/**\n * Sets the value of the flash variable.\n * @param {string} variableName The variable name.\n * @param {string} value The value.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.SetVariable = function(variableName, value) {};\n\n/**\n * Zooms in on a rectangular area of the movie. The units of the coordinates\n * are in twips (1440 units per inch).\n * @param {number} left The left coordinate.\n * @param {number} top The top coordinate.\n * @param {number} right The right coordinate.\n * @param {number} bottom The bottom coordinate.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.SetZoomRect = function(left, top, right, bottom) {};\n\n/**\n * Stops playing the movie.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.StopPlay = function() {};\n\n/**\n * @return {number} The total number of frames in the movie.\n */\nHTMLObjectElement.prototype.TotalFrames = function() {};\n\n/**\n * Zooms the view by a relative scale factor.\n * @param {number} percent The percentage scale factor, should be an integer.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.Zoom = function(percent) {};\n\n\n// TellTarget Methods.\n\n/**\n * Executes the action in the timeline specified by `target` in the\n * specified frame.\n * @param {string} target The timeline.\n * @param {number} frameNumber The frame number.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.TCallFrame = function(target, frameNumber) {};\n\n/**\n * Executes the action in the timeline specified by `target` in the\n * specified frame.\n * @param {string} target The timeline.\n * @param {string} label The frame label.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.TCallLabel = function(target, label) {};\n\n/**\n * Returns the number of the current frame for the specified timeline.\n * @param {string} target The timeline.\n * @return {number} The number of the current frame.\n */\nHTMLObjectElement.prototype.TCurentFrame = function(target) {};\n\n/**\n * Returns the label of the current frame for the specified timeline.\n * @param {string} target The timeline.\n * @return {string} The label of the current frame, empty string if no\n *     current frame.\n */\nHTMLObjectElement.prototype.TCurrentLabel = function(target) {};\n\n/**\n * Returns a string indicating the value of the property in the\n * specified timeline.\n * @param {string} target The timeline.\n * @param {number} property The integer corresponding to the desired property.\n * @return {string} The value of the property.\n */\nHTMLObjectElement.prototype.TGetProperty = function(target, property) {};\n\n/**\n * Returns a number indicating the value of the property in the specified\n * timeline.\n * @param {string} target The timeline.\n * @param {number} property The integer corresponding to the desired property.\n * @return {number} A number indicating the value of the property.\n */\nHTMLObjectElement.prototype.TGetPropertyAsNumber = function(target, property) {};\n\n/**\n * Goes to the specified frame number in the specified timeline.\n * @param {string} target The timeline.\n * @param {number} frameNumber The frame number.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.TGotoFrame = function(target, frameNumber) {};\n\n/**\n * Goes to the specified frame label in the specified timeline.\n * @param {string} target The timeline.\n * @param {string} label The framelabel.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.TGotoLabel = function(target, label) {};\n\n/**\n * Plays the specified timeline.\n * @param {number} target The timeline.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.TPlay = function(target) {};\n\n/**\n * Sets the value of the property in the specified timeline.\n * @param {number} target The timeline.\n * @param {number} property The integer corresponding to the desired property.\n * @param {string|number} value The value.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.TSetProperty = function(target, property, value) {};\n\n/**\n * Stops the specified timeline.\n * @param {number} target The timeline.\n * @return {undefined}\n */\nHTMLObjectElement.prototype.TStopPlay = function(target) {};\n',
"externs/gecko_xml.js":'/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the "License");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an "AS IS" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * @fileoverview Definitions for all the extensions over some of the\n *  W3C\'s XML specifications by Gecko. This file depends on\n *  w3c_xml.js. The whole file has been fully type annotated.\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n */\n\n/**\n * XMLSerializer can be used to convert DOM subtree or DOM document into text.\n * XMLSerializer is available to unprivileged scripts.\n *\n * XMLSerializer is mainly useful for applications and extensions based on\n * Mozilla platform. While it\'s available to web pages, it\'s not part of any\n * standard and level of support in other browsers is unknown.\n *\n * @constructor\n */\nfunction XMLSerializer() {}\n\n/**\n * Returns the serialized subtree in the form of a string\n * @param {Node} subtree\n * @return {string}\n */\nXMLSerializer.prototype.serializeToString = function(subtree) {};\n\n/**\n * The subtree rooted by the specified element is serialized to a byte stream\n * using the character set specified.\n *\n * @param {Node} subtree\n * @return {Object}\n */\nXMLSerializer.prototype.serializeToStream = function(subtree) {};\n\n/**\n * DOMParser is mainly useful for applications and extensions based on Mozilla\n * platform. While it\'s available to web pages, it\'s not part of any standard and\n * level of support in other browsers is unknown.\n *\n * @constructor\n */\nfunction DOMParser() {}\n\n/**\n * The string passed in is parsed into a DOM document.\n *\n * Example:\n *  var parser = new DOMParser();\n *  var doc = parser.parseFromString(aStr, "text/xml");\n *\n * @param {!TrustedHTML|string} src The UTF16 string to be parsed.\n * @param {string} type The content type of the string.\n * @return {Document}\n */\nDOMParser.prototype.parseFromString = function(src, type) {};\n',
"externs/html5.js":"/*\n * Copyright 2008 The Closure Compiler Authors\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n/**\n * @fileoverview Definitions for all the extensions over the\n *  W3C's DOM3 specification in HTML5. This file depends on\n *  w3c_dom3.js. The whole file has been fully type annotated.\n *\n *  @see http://www.whatwg.org/specs/web-apps/current-work/multipage/index.html\n *  @see http://dev.w3.org/html5/spec/Overview.html\n *\n *  This also includes Typed Array definitions from\n *  http://www.khronos.org/registry/typedarray/specs/latest/\n *\n *  This relies on w3c_event.js being included first.\n *\n * @externs\n * @author acleung@google.com (Alan Leung)\n */\n\n/** @type {?HTMLSlotElement} */\nNode.prototype.assignedSlot;\n\n/**\n * @type {string}\n * @see https://dom.spec.whatwg.org/#dom-element-slot\n */\nElement.prototype.slot;\n\n/**\n * Note: In IE, the contains() method only exists on Elements, not Nodes.\n * Therefore, it is recommended that you use the Conformance framework to\n * prevent calling this on Nodes which are not Elements.\n * @see https://connect.microsoft.com/IE/feedback/details/780874/node-contains-is-incorrect\n *\n * @param {Node} n The node to check\n * @return {boolean} If 'n' is this Node, or is contained within this Node.\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Node.contains\n * @nosideeffects\n */\nNode.prototype.contains = function(n) {};\n\n/** @type {boolean} */\nNode.prototype.isConnected;\n\n/**\n * Inserts the given HTML Element into the node at the location.\n * @param {string} where Where to insert the HTML text, one of 'beforeBegin',\n *     'afterBegin', 'beforeEnd', 'afterEnd'.\n * @param {!Element} element DOM Element to insert.\n * @return {?Element} The element that was inserted, or null, if the\n *     insertion failed.\n * @see https://dom.spec.whatwg.org/#dom-element-insertadjacentelement\n */\nNode.prototype.insertAdjacentElement = function(where, element) {};\n\n/**\n * @type {boolean}\n * @see https://html.spec.whatwg.org/multipage/scripting.html#the-script-element\n */\nHTMLScriptElement.prototype.async;\n\n/**\n * @constructor\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#the-canvas-element\n * @extends {HTMLElement}\n */\nfunction HTMLCanvasElement() {}\n\n/** @type {number} */\nHTMLCanvasElement.prototype.width;\n\n/** @type {number} */\nHTMLCanvasElement.prototype.height;\n\n/**\n * @see https://www.w3.org/TR/html5/scripting-1.html#dom-canvas-toblob\n * @param {function(!Blob)} callback\n * @param {string=} opt_type\n * @param {...*} var_args\n * @throws {Error}\n */\nHTMLCanvasElement.prototype.toBlob = function(callback, opt_type, var_args) {};\n\n/**\n * @param {string=} opt_type\n * @param {...*} var_args\n * @return {string}\n * @throws {Error}\n */\nHTMLCanvasElement.prototype.toDataURL = function(opt_type, var_args) {};\n\n/**\n * @modifies {this}\n * @param {string} contextId\n * @param {Object=} opt_args\n * @return {Object}\n */\nHTMLCanvasElement.prototype.getContext = function(contextId, opt_args) {};\n\n/**\n * @see https://www.w3.org/TR/mediacapture-fromelement/\n * @param {number=} opt_framerate\n * @return {!MediaStream}\n * @throws {Error}\n * */\nHTMLCanvasElement.prototype.captureStream = function(opt_framerate) {};\n\n/**\n * @see https://html.spec.whatwg.org/multipage/canvas.html#dom-canvas-transfercontroltooffscreen\n * @return {!OffscreenCanvas}\n * @throws {Error}\n * */\nHTMLCanvasElement.prototype.transferControlToOffscreen = function() {};\n\n/**\n * @see https://html.spec.whatwg.org/multipage/canvas.html#the-offscreencanvas-interface\n * @implements {EventTarget}\n * @implements {Transferable}\n * @param {number} width\n * @param {number} height\n * @nosideeffects\n * @constructor\n */\nfunction OffscreenCanvas(width, height) {}\n\n/** @override */\nOffscreenCanvas.prototype.addEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nOffscreenCanvas.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nOffscreenCanvas.prototype.dispatchEvent = function(evt) {};\n\n/** @type {number} */\nOffscreenCanvas.prototype.width;\n\n/** @type {number} */\nOffscreenCanvas.prototype.height;\n\n/**\n * @param {string} contextId\n * @param {!Object=} opt_options\n * @modifies {this}\n * @return {!Object}\n */\nOffscreenCanvas.prototype.getContext = function(contextId, opt_options) {};\n\n/**\n * @return {!ImageBitmap}\n */\nOffscreenCanvas.prototype.transferToImageBitmap = function() {};\n\n/**\n * @param {{type: (string|undefined), quality: (number|undefined)}=} opt_options\n * @return {!Promise<!Blob>}\n */\nOffscreenCanvas.prototype.convertToBlob = function(opt_options) {};\n\n// TODO(tjgq): Find a way to add SVGImageElement to this typedef without making\n// svg.js part of core.\n/**\n * @typedef {HTMLImageElement|HTMLVideoElement|HTMLCanvasElement|ImageBitmap|\n *     OffscreenCanvas}\n */\nvar CanvasImageSource;\n\n/**\n * @interface\n * @see https://www.w3.org/TR/2dcontext/#canvaspathmethods\n */\nfunction CanvasPathMethods() {}\n\n/**\n * @return {undefined}\n */\nCanvasPathMethods.prototype.closePath = function() {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n */\nCanvasPathMethods.prototype.moveTo = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n */\nCanvasPathMethods.prototype.lineTo = function(x, y) {};\n\n/**\n * @param {number} cpx\n * @param {number} cpy\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n */\nCanvasPathMethods.prototype.quadraticCurveTo = function(cpx, cpy, x, y) {};\n\n/**\n * @param {number} cp1x\n * @param {number} cp1y\n * @param {number} cp2x\n * @param {number} cp2y\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n */\nCanvasPathMethods.prototype.bezierCurveTo = function(\n    cp1x, cp1y, cp2x, cp2y, x, y) {};\n\n/**\n * @param {number} x1\n * @param {number} y1\n * @param {number} x2\n * @param {number} y2\n * @param {number} radius\n * @return {undefined}\n */\nCanvasPathMethods.prototype.arcTo = function(x1, y1, x2, y2, radius) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} w\n * @param {number} h\n * @return {undefined}\n */\nCanvasPathMethods.prototype.rect = function(x, y, w, h) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} radius\n * @param {number} startAngle\n * @param {number} endAngle\n * @param {boolean=} opt_anticlockwise\n * @return {undefined}\n */\nCanvasPathMethods.prototype.arc = function(\n    x, y, radius, startAngle, endAngle, opt_anticlockwise) {};\n\n/**\n * @constructor\n * @implements {CanvasPathMethods}\n * @see https://html.spec.whatwg.org/multipage/scripting.html#path2d-objects\n */\nfunction Path2D() {}\n\n/**\n * @return {undefined}\n * @override\n */\nPath2D.prototype.closePath = function() {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @override\n */\nPath2D.prototype.moveTo = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @override\n */\nPath2D.prototype.lineTo = function(x, y) {};\n\n/**\n * @param {number} cpx\n * @param {number} cpy\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @override\n */\nPath2D.prototype.quadraticCurveTo = function(cpx, cpy, x, y) {};\n\n/**\n * @param {number} cp1x\n * @param {number} cp1y\n * @param {number} cp2x\n * @param {number} cp2y\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @override\n */\nPath2D.prototype.bezierCurveTo = function(\n    cp1x, cp1y, cp2x, cp2y, x, y) {};\n\n/**\n * @param {number} x1\n * @param {number} y1\n * @param {number} x2\n * @param {number} y2\n * @param {number} radius\n * @return {undefined}\n * @override\n */\nPath2D.prototype.arcTo = function(x1, y1, x2, y2, radius) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} w\n * @param {number} h\n * @return {undefined}\n * @override\n */\nPath2D.prototype.rect = function(x, y, w, h) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} radius\n * @param {number} startAngle\n * @param {number} endAngle\n * @param {boolean=} optAnticlockwise\n * @return {undefined}\n * @override\n */\nPath2D.prototype.arc = function(\n    x, y, radius, startAngle, endAngle, optAnticlockwise) {};\n\n/**\n * @param {Path2D} path\n * @return {undefined}\n */\nPath2D.prototype.addPath = function(path) {};\n\n/**\n * @interface\n * @see https://www.w3.org/TR/2dcontext/#canvasdrawingstyles\n */\nfunction CanvasDrawingStyles() {}\n\n/** @type {number} */\nCanvasDrawingStyles.prototype.lineWidth;\n\n/** @type {string} */\nCanvasDrawingStyles.prototype.lineCap;\n\n/** @type {string} */\nCanvasDrawingStyles.prototype.lineJoin;\n\n/** @type {number} */\nCanvasDrawingStyles.prototype.miterLimit;\n\n/**\n * @param {Array<number>} segments\n * @return {undefined}\n */\nCanvasDrawingStyles.prototype.setLineDash = function(segments) {};\n\n/**\n * @return {!Array<number>}\n */\nCanvasDrawingStyles.prototype.getLineDash = function() {};\n\n/** @type {string} */\nCanvasDrawingStyles.prototype.font;\n\n/** @type {string} */\nCanvasDrawingStyles.prototype.textAlign;\n\n/** @type {string} */\nCanvasDrawingStyles.prototype.textBaseline;\n\n// TODO(dramaix): replace this with @record.\n/**\n * @constructor\n * @abstract\n * @implements {CanvasDrawingStyles}\n * @implements {CanvasPathMethods}\n * @see http://www.w3.org/TR/2dcontext/#canvasrenderingcontext2d\n */\nfunction BaseRenderingContext2D() {}\n\n/** @const {!HTMLCanvasElement|!OffscreenCanvas} */\nBaseRenderingContext2D.prototype.canvas;\n\n/**\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.save = function() {};\n\n/**\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.restore = function() {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.scale = function(x, y) {};\n\n/**\n * @param {number} angle\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.rotate = function(angle) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.translate = function(x, y) {};\n\n/**\n * @param {number} m11\n * @param {number} m12\n * @param {number} m21\n * @param {number} m22\n * @param {number} dx\n * @param {number} dy\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.transform = function(\n    m11, m12, m21, m22, dx, dy) {};\n\n/**\n * @param {number} m11\n * @param {number} m12\n * @param {number} m21\n * @param {number} m22\n * @param {number} dx\n * @param {number} dy\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.setTransform = function(\n    m11, m12, m21, m22, dx, dy) {};\n\n/**\n * @param {number} x0\n * @param {number} y0\n * @param {number} x1\n * @param {number} y1\n * @return {!CanvasGradient}\n * @throws {Error}\n */\nBaseRenderingContext2D.prototype.createLinearGradient = function(\n    x0, y0, x1, y1) {};\n\n/**\n * @param {number} x0\n * @param {number} y0\n * @param {number} r0\n * @param {number} x1\n * @param {number} y1\n * @param {number} r1\n * @return {!CanvasGradient}\n * @throws {Error}\n */\nBaseRenderingContext2D.prototype.createRadialGradient = function(\n    x0, y0, r0, x1, y1, r1) {};\n\n/**\n * @param {CanvasImageSource} image\n * @param {string} repetition\n * @return {?CanvasPattern}\n * @throws {Error}\n * @see https://html.spec.whatwg.org/multipage/scripting.html#dom-context-2d-createpattern\n */\nBaseRenderingContext2D.prototype.createPattern = function(\n    image, repetition) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} w\n * @param {number} h\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.clearRect = function(x, y, w, h) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} w\n * @param {number} h\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.fillRect = function(x, y, w, h) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} w\n * @param {number} h\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.strokeRect = function(x, y, w, h) {};\n\n/**\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.beginPath = function() {};\n\n/**\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.closePath = function() {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.moveTo = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.lineTo = function(x, y) {};\n\n/**\n * @param {number} cpx\n * @param {number} cpy\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.quadraticCurveTo = function(\n    cpx, cpy, x, y) {};\n\n/**\n * @param {number} cp1x\n * @param {number} cp1y\n * @param {number} cp2x\n * @param {number} cp2y\n * @param {number} x\n * @param {number} y\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.bezierCurveTo = function(\n    cp1x, cp1y, cp2x, cp2y, x, y) {};\n\n/**\n * @param {number} x1\n * @param {number} y1\n * @param {number} x2\n * @param {number} y2\n * @param {number} radius\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.arcTo = function(x1, y1, x2, y2, radius) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} w\n * @param {number} h\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.rect = function(x, y, w, h) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} radius\n * @param {number} startAngle\n * @param {number} endAngle\n * @param {boolean=} opt_anticlockwise\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.arc = function(\n    x, y, radius, startAngle, endAngle, opt_anticlockwise) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {number} radiusX\n * @param {number} radiusY\n * @param {number} rotation\n * @param {number} startAngle\n * @param {number} endAngle\n * @param {boolean=} opt_anticlockwise\n * @return {undefined}\n * @see http://developer.mozilla.org/en/docs/Web/API/CanvasRenderingContext2D/ellipse\n */\nBaseRenderingContext2D.prototype.ellipse = function(\n    x, y, radiusX, radiusY, rotation, startAngle, endAngle, opt_anticlockwise) {\n};\n\n/**\n * @param {Path2D|string=} optFillRuleOrPath\n * @param {string=} optFillRule\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.fill = function(optFillRuleOrPath, optFillRule) {};\n\n/**\n * @param {Path2D=} optStroke\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.stroke = function(optStroke) {};\n\n/**\n * @param {Element} element\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.drawFocusIfNeeded = function(element) {};\n\n/**\n * @param {Path2D|string=} optFillRuleOrPath\n * @param {string=} optFillRule\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.clip = function(optFillRuleOrPath, optFillRule) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {boolean}\n * @nosideeffects\n * @see http://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/isPointInStroke\n */\nBaseRenderingContext2D.prototype.isPointInStroke = function(x, y) {};\n\n/**\n * @param {number} x\n * @param {number} y\n * @param {string=} opt_fillRule\n * @return {boolean}\n * @nosideeffects\n */\nBaseRenderingContext2D.prototype.isPointInPath = function(\n    x, y, opt_fillRule) {};\n\n/**\n * @param {string} text\n * @param {number} x\n * @param {number} y\n * @param {number=} opt_maxWidth\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.fillText = function(\n    text, x, y, opt_maxWidth) {};\n\n/**\n * @param {string} text\n * @param {number} x\n * @param {number} y\n * @param {number=} opt_maxWidth\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.strokeText = function(\n    text, x, y, opt_maxWidth) {};\n\n/**\n * @param {string} text\n * @return {!TextMetrics}\n * @nosideeffects\n */\nBaseRenderingContext2D.prototype.measureText = function(text) {};\n\n/**\n * @param {CanvasImageSource} image\n * @param {number} dx Destination x coordinate.\n * @param {number} dy Destination y coordinate.\n * @param {number=} opt_dw Destination box width.  Defaults to the image width.\n * @param {number=} opt_dh Destination box height.\n *     Defaults to the image height.\n * @param {number=} opt_sx Source box x coordinate.  Used to select a portion of\n *     the source image to draw.  Defaults to 0.\n * @param {number=} opt_sy Source box y coordinate.  Used to select a portion of\n *     the source image to draw.  Defaults to 0.\n * @param {number=} opt_sw Source box width.  Used to select a portion of\n *     the source image to draw.  Defaults to the full image width.\n * @param {number=} opt_sh Source box height.  Used to select a portion of\n *     the source image to draw.  Defaults to the full image height.\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.drawImage = function(\n    image, dx, dy, opt_dw, opt_dh, opt_sx, opt_sy, opt_sw, opt_sh) {};\n\n/**\n * @param {number} sw\n * @param {number} sh\n * @return {!ImageData}\n * @throws {Error}\n * @nosideeffects\n */\nBaseRenderingContext2D.prototype.createImageData = function(sw, sh) {};\n\n/**\n * @param {number} sx\n * @param {number} sy\n * @param {number} sw\n * @param {number} sh\n * @return {!ImageData}\n * @throws {Error}\n */\nBaseRenderingContext2D.prototype.getImageData = function(sx, sy, sw, sh) {};\n\n/**\n * @param {ImageData} imagedata\n * @param {number} dx\n * @param {number} dy\n * @param {number=} opt_dirtyX\n * @param {number=} opt_dirtyY\n * @param {number=} opt_dirtyWidth\n * @param {number=} opt_dirtyHeight\n * @return {undefined}\n */\nBaseRenderingContext2D.prototype.putImageData = function(imagedata, dx, dy,\n    opt_dirtyX, opt_dirtyY, opt_dirtyWidth, opt_dirtyHeight) {};\n\n/**\n * Note: WebKit only\n * @param {number|string=} opt_a\n * @param {number=} opt_b\n * @param {number=} opt_c\n * @param {number=} opt_d\n * @param {number=} opt_e\n * @see http://developer.apple.com/library/safari/#documentation/appleapplications/reference/WebKitDOMRef/CanvasRenderingContext2D_idl/Classes/CanvasRenderingContext2D/index.html\n * @return {undefined}\n * @deprecated\n */\nBaseRenderingContext2D.prototype.setFillColor = function(\n    opt_a, opt_b, opt_c, opt_d, opt_e) {};\n\n/**\n * Note: WebKit only\n * @param {number|string=} opt_a\n * @param {number=} opt_b\n * @param {number=} opt_c\n * @param {number=} opt_d\n * @param {number=} opt_e\n * @see http://developer.apple.com/library/safari/#documentation/appleapplications/reference/WebKitDOMRef/CanvasRenderingContext2D_idl/Classes/CanvasRenderingContext2D/index.html\n * @return {undefined}\n * @deprecated\n */\nBaseRenderingContext2D.prototype.setStrokeColor = function(\n    opt_a, opt_b, opt_c, opt_d, opt_e) {};\n\n/**\n * @return {!Array<number>}\n * @override\n */\nBaseRenderingContext2D.prototype.getLineDash = function() {};\n\n/**\n * @param {Array<number>} segments\n * @return {undefined}\n * @override\n */\nBaseRenderingContext2D.prototype.setLineDash = function(segments) {};\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.fillColor;\n\n/**\n * @type {string|!CanvasGradient|!CanvasPattern}\n * @see https://html.spec.whatwg.org/multipage/scripting.html#fill-and-stroke-styles:dom-context-2d-fillstyle\n * @implicitCast\n */\nBaseRenderingContext2D.prototype.fillStyle;\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.font;\n\n/** @type {number} */\nBaseRenderingContext2D.prototype.globalAlpha;\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.globalCompositeOperation;\n\n/** @type {number} */\nBaseRenderingContext2D.prototype.lineWidth;\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.lineCap;\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.lineJoin;\n\n/** @type {number} */\nBaseRenderingContext2D.prototype.miterLimit;\n\n/** @type {number} */\nBaseRenderingContext2D.prototype.shadowBlur;\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.shadowColor;\n\n/** @type {number} */\nBaseRenderingContext2D.prototype.shadowOffsetX;\n\n/** @type {number} */\nBaseRenderingContext2D.prototype.shadowOffsetY;\n\n/** @type {boolean} */\nBaseRenderingContext2D.prototype.imageSmoothingEnabled;\n\n/**\n * @type {string|!CanvasGradient|!CanvasPattern}\n * @see https://html.spec.whatwg.org/multipage/scripting.html#fill-and-stroke-styles:dom-context-2d-strokestyle\n * @implicitCast\n */\nBaseRenderingContext2D.prototype.strokeStyle;\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.strokeColor;\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.textAlign;\n\n/** @type {string} */\nBaseRenderingContext2D.prototype.textBaseline;\n\n/** @type {number} */\nBaseRenderingContext2D.prototype.lineDashOffset;\n\n/**\n * @constructor\n * @extends {BaseRenderingContext2D}\n * @see http://www.w3.org/TR/2dcontext/#canvasrenderingcontext2d\n */\nfunction CanvasRenderingContext2D() {}\n\n/** @const {!HTMLCanvasElement} */\nCanvasRenderingContext2D.prototype.canvas;\n\n/**\n * @constructor\n * @extends {BaseRenderingContext2D}\n * @see http://www.w3.org/TR/2dcontext/#canvasrenderingcontext2d\n */\nfunction OffscreenCanvasRenderingContext2D() {}\n\n/** @const {!OffscreenCanvas} */\nOffscreenCanvasRenderingContext2D.prototype.canvas;\n\n/**\n * @constructor\n */\nfunction CanvasGradient() {}\n\n/**\n * @param {number} offset\n * @param {string} color\n * @return {undefined}\n */\nCanvasGradient.prototype.addColorStop = function(offset, color) {};\n\n/**\n * @constructor\n */\nfunction CanvasPattern() {}\n\n/**\n * @constructor\n */\nfunction TextMetrics() {}\n\n/** @const {number} */\nTextMetrics.prototype.width;\n\n/**\n * @param {!Uint8ClampedArray|number} dataOrWidth In the first form, this is the\n *     array of pixel data.  In the second form, this is the image width.\n * @param {number} widthOrHeight In the first form, this is the image width.  In\n *     the second form, this is the image height.\n * @param {number=} opt_height In the first form, this is the optional image\n *     height.  The second form omits this argument.\n * @see https://html.spec.whatwg.org/multipage/scripting.html#imagedata\n * @constructor\n */\nfunction ImageData(dataOrWidth, widthOrHeight, opt_height) {}\n\n/** @const {!Uint8ClampedArray} */\nImageData.prototype.data;\n\n/** @const {number} */\nImageData.prototype.width;\n\n/** @const {number} */\nImageData.prototype.height;\n\n/**\n * @see https://www.w3.org/TR/html51/webappapis.html#webappapis-images\n * @interface\n */\nfunction ImageBitmap() {}\n\n/**\n * @const {number}\n */\nImageBitmap.prototype.width;\n\n/**\n * @const {number}\n */\nImageBitmap.prototype.height;\n\n/**\n * @typedef {{\n *   imageOrientation: (string|undefined),\n *   premultiplyAlpha: (string|undefined),\n *   colorSpaceConversion: (string|undefined),\n *   resizeWidth: (number|undefined),\n *   resizeHeight: (number|undefined),\n *   resizeQuality: (string|undefined)\n * }}\n * @see https://html.spec.whatwg.org/multipage/imagebitmap-and-animations.html#images-2\n */\nvar ImageBitmapOptions;\n\n/**\n * @param {(!HTMLCanvasElement|!Blob|!HTMLVideoElement|!HTMLImageElement|!ImageBitmap|!CanvasRenderingContext2D|!ImageData)}\n *     image\n * @param {(number|!ImageBitmapOptions)=} sxOrOptions\n * @param {number=} sy\n * @param {number=} sw\n * @param {number=} sh\n * @param {!ImageBitmapOptions=} options\n * @return {!Promise<!ImageBitmap>}\n * @see * https://html.spec.whatwg.org/multipage/imagebitmap-and-animations.html#dom-createimagebitmap\n */\nfunction createImageBitmap(image, sxOrOptions, sy, sw, sh, options) {}\n\n\n/**\n * @constructor\n */\nfunction ClientInformation() {}\n\n/** @type {boolean} */\nClientInformation.prototype.onLine;\n\n/**\n * @param {string} protocol\n * @param {string} uri\n * @param {string} title\n * @return {undefined}\n */\nClientInformation.prototype.registerProtocolHandler = function(\n    protocol, uri, title) {};\n\n/**\n * @param {string} mimeType\n * @param {string} uri\n * @param {string} title\n * @return {undefined}\n */\nClientInformation.prototype.registerContentHandler = function(\n    mimeType, uri, title) {};\n\n// HTML5 Database objects\n/**\n * @constructor\n */\nfunction Database() {}\n\n/**\n * @type {string}\n */\nDatabase.prototype.version;\n\n/**\n * @param {function(!SQLTransaction) : void} callback\n * @param {(function(!SQLError) : void)=} opt_errorCallback\n * @param {Function=} opt_Callback\n * @return {undefined}\n */\nDatabase.prototype.transaction = function(\n    callback, opt_errorCallback, opt_Callback) {};\n\n/**\n * @param {function(!SQLTransaction) : void} callback\n * @param {(function(!SQLError) : void)=} opt_errorCallback\n * @param {Function=} opt_Callback\n * @return {undefined}\n */\nDatabase.prototype.readTransaction = function(\n    callback, opt_errorCallback, opt_Callback) {};\n\n/**\n * @param {string} oldVersion\n * @param {string} newVersion\n * @param {function(!SQLTransaction) : void} callback\n * @param {function(!SQLError) : void} errorCallback\n * @param {Function} successCallback\n * @return {undefined}\n */\nDatabase.prototype.changeVersion = function(\n    oldVersion, newVersion, callback, errorCallback, successCallback) {};\n\n/**\n * @interface\n */\nfunction DatabaseCallback() {}\n\n/**\n * @param {!Database} db\n * @return {undefined}\n */\nDatabaseCallback.prototype.handleEvent = function(db) {};\n\n/**\n * @constructor\n */\nfunction SQLError() {}\n\n/**\n * @type {number}\n */\nSQLError.prototype.code;\n\n/**\n * @type {string}\n */\nSQLError.prototype.message;\n\n/**\n * @constructor\n */\nfunction SQLTransaction() {}\n\n/**\n * @param {string} sqlStatement\n * @param {Array<*>=} opt_queryArgs\n * @param {SQLStatementCallback=} opt_callback\n * @param {(function(!SQLTransaction, !SQLError) : (boolean|void))=}\n *     opt_errorCallback\n * @return {undefined}\n */\nSQLTransaction.prototype.executeSql = function(\n    sqlStatement, opt_queryArgs, opt_callback, opt_errorCallback) {};\n\n/**\n * @typedef {(function(!SQLTransaction, !SQLResultSet) : void)}\n */\nvar SQLStatementCallback;\n\n/**\n * @constructor\n */\nfunction SQLResultSet() {}\n\n/**\n * @type {number}\n */\nSQLResultSet.prototype.insertId;\n\n/**\n * @type {number}\n */\nSQLResultSet.prototype.rowsAffected;\n\n/**\n * @type {!SQLResultSetRowList}\n */\nSQLResultSet.prototype.rows;\n\n/**\n * @constructor\n * @implements {IArrayLike<!Object>}\n * @see http://www.w3.org/TR/webdatabase/#sqlresultsetrowlist\n */\nfunction SQLResultSetRowList() {}\n\n/**\n * @type {number}\n */\nSQLResultSetRowList.prototype.length;\n\n/**\n * @param {number} index\n * @return {Object}\n * @nosideeffects\n */\nSQLResultSetRowList.prototype.item = function(index) {};\n\n/**\n * @param {string} name\n * @param {string} version\n * @param {string} description\n * @param {number} size\n * @param {(DatabaseCallback|function(Database))=} opt_callback\n * @return {!Database}\n */\nfunction openDatabase(name, version, description, size, opt_callback) {}\n\n/**\n * @param {string} name\n * @param {string} version\n * @param {string} description\n * @param {number} size\n * @param {(DatabaseCallback|function(Database))=} opt_callback\n * @return {!Database}\n */\nWindow.prototype.openDatabase =\n    function(name, version, description, size, opt_callback) {};\n\n/**\n * @type {boolean}\n * @see https://www.w3.org/TR/html5/embedded-content-0.html#dom-img-complete\n */\nHTMLImageElement.prototype.complete;\n\n/**\n * @type {number}\n * @see https://www.w3.org/TR/html5/embedded-content-0.html#dom-img-naturalwidth\n */\nHTMLImageElement.prototype.naturalWidth;\n\n/**\n * @type {number}\n * @see https://www.w3.org/TR/html5/embedded-content-0.html#dom-img-naturalheight\n */\nHTMLImageElement.prototype.naturalHeight;\n\n/**\n * @type {string}\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/embedded-content-1.html#attr-img-crossorigin\n */\nHTMLImageElement.prototype.crossOrigin;\n\n/**\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/embedded-content.html#dom-img-currentsrc\n */\nHTMLImageElement.prototype.currentSrc;\n\n/**\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/images.html#image-decoding-hint\n */\nHTMLImageElement.prototype.decoding;\n\n/**\n * @return {!Promise<undefined>}\n * @see https://html.spec.whatwg.org/multipage/embedded-content.html#dom-img-decode\n */\nHTMLImageElement.prototype.decode;\n\n\n/**\n * This is a superposition of the Window and Worker postMessage methods.\n * @param {*} message\n * @param {(string|!Array<!Transferable>)=} opt_targetOriginOrTransfer\n * @param {(string|!Array<!MessagePort>|!Array<!Transferable>)=}\n *     opt_targetOriginOrPortsOrTransfer\n * @return {void}\n */\nfunction postMessage(message, opt_targetOriginOrTransfer,\n    opt_targetOriginOrPortsOrTransfer) {}\n\n/**\n * @param {*} message\n * @param {string=} targetOrigin\n * @param {(!Array<!Transferable>)=} transfer\n * @return {void}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Window/postMessage\n */\nWindow.prototype.postMessage = function(message, targetOrigin, transfer) {};\n\n/**\n * The postMessage method (as implemented in Opera).\n * @param {string} message\n */\nDocument.prototype.postMessage = function(message) {};\n\n/**\n * Document head accessor.\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/dom.html#the-head-element-0\n * @type {HTMLHeadElement}\n */\nDocument.prototype.head;\n\n/**\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/dom.html#current-document-readiness\n */\nDocument.prototype.readyState;\n\n/**\n * @see https://html.spec.whatwg.org/#application-cache-api\n * @constructor\n * @implements {EventTarget}\n */\nfunction ApplicationCache() {}\n\n/** @override */\nApplicationCache.prototype.addEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nApplicationCache.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nApplicationCache.prototype.dispatchEvent = function(evt) {};\n\n/**\n * The object isn't associated with an application cache. This can occur if the\n * update process fails and there is no previous cache to revert to, or if there\n * is no manifest file.\n * @const {number}\n */\nApplicationCache.prototype.UNCACHED;\n\n/**\n * The object isn't associated with an application cache. This can occur if the\n * update process fails and there is no previous cache to revert to, or if there\n * is no manifest file.\n * @const {number}\n */\nApplicationCache.UNCACHED;\n\n/**\n * The cache is idle.\n * @const {number}\n */\nApplicationCache.prototype.IDLE;\n\n/**\n * The cache is idle.\n * @const {number}\n */\nApplicationCache.IDLE;\n\n/**\n * The update has started but the resources are not downloaded yet - for\n * example, this can happen when the manifest file is fetched.\n * @const {number}\n */\nApplicationCache.prototype.CHECKING;\n\n/**\n * The update has started but the resources are not downloaded yet - for\n * example, this can happen when the manifest file is fetched.\n * @const {number}\n */\nApplicationCache.CHECKING;\n\n/**\n * The resources are being downloaded into the cache.\n * @const {number}\n */\nApplicationCache.prototype.DOWNLOADING;\n\n/**\n * The resources are being downloaded into the cache.\n * @const {number}\n */\nApplicationCache.DOWNLOADING;\n\n/**\n * Resources have finished downloading and the new cache is ready to be used.\n * @const {number}\n */\nApplicationCache.prototype.UPDATEREADY;\n\n/**\n * Resources have finished downloading and the new cache is ready to be used.\n * @const {number}\n */\nApplicationCache.UPDATEREADY;\n\n/**\n * The cache is obsolete.\n * @const {number}\n */\nApplicationCache.prototype.OBSOLETE;\n\n/**\n * The cache is obsolete.\n * @const {number}\n */\nApplicationCache.OBSOLETE;\n\n/**\n * The current status of the application cache.\n * @type {number}\n */\nApplicationCache.prototype.status;\n\n/**\n * Sent when the update process finishes for the first time; that is, the first\n * time an application cache is saved.\n * @type {?function(!Event): void}\n */\nApplicationCache.prototype.oncached;\n\n/**\n * Sent when the cache update process begins.\n * @type {?function(!Event): void}\n */\nApplicationCache.prototype.onchecking;\n\n/**\n * Sent when the update process begins downloading resources in the manifest\n * file.\n * @type {?function(!Event): void}\n */\nApplicationCache.prototype.ondownloading;\n\n/**\n * Sent when an error occurs.\n * @type {?function(!Event): void}\n */\nApplicationCache.prototype.onerror;\n\n/**\n * Sent when the update process finishes but the manifest file does not change.\n * @type {?function(!Event): void}\n */\nApplicationCache.prototype.onnoupdate;\n\n/**\n * Sent when each resource in the manifest file begins to download.\n * @type {?function(!Event): void}\n */\nApplicationCache.prototype.onprogress;\n\n/**\n * Sent when there is an existing application cache, the update process\n * finishes, and there is a new application cache ready for use.\n * @type {?function(!Event): void}\n */\nApplicationCache.prototype.onupdateready;\n\n/**\n * Replaces the active cache with the latest version.\n * @throws {DOMException}\n * @return {undefined}\n */\nApplicationCache.prototype.swapCache = function() {};\n\n/**\n * Manually triggers the update process.\n * @throws {DOMException}\n * @return {undefined}\n */\nApplicationCache.prototype.update = function() {};\n\n/** @type {?ApplicationCache} */\nvar applicationCache;\n\n/** @type {ApplicationCache} */\nWindow.prototype.applicationCache;\n\n/**\n * @see https://developer.mozilla.org/En/DOM/Worker/Functions_available_to_workers\n * @param {...!TrustedScriptURL|string} var_args\n * @return {undefined}\n */\nWindow.prototype.importScripts = function(var_args) {};\n\n/**\n * Decodes a string of data which has been encoded using base-64 encoding.\n *\n * @param {string} encodedData\n * @return {string}\n * @nosideeffects\n * @see https://html.spec.whatwg.org/multipage/webappapis.html#dom-atob\n */\nfunction atob(encodedData) {}\n\n/**\n * @param {string} stringToEncode\n * @return {string}\n * @nosideeffects\n * @see https://html.spec.whatwg.org/multipage/webappapis.html#dom-btoa\n */\nfunction btoa(stringToEncode) {}\n\n/**\n * @see https://developer.mozilla.org/En/DOM/Worker/Functions_available_to_workers\n * @param {...!TrustedScriptURL|string} var_args\n * @return {undefined}\n */\nfunction importScripts(var_args) {}\n\n/**\n * @see http://dev.w3.org/html5/workers/\n * @constructor\n * @implements {EventTarget}\n */\nfunction WebWorker() {}\n\n/** @override */\nWebWorker.prototype.addEventListener = function(type, listener, opt_options) {};\n\n/** @override */\nWebWorker.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nWebWorker.prototype.dispatchEvent = function(evt) {};\n\n/**\n * Stops the worker process\n * @return {undefined}\n */\nWebWorker.prototype.terminate = function() {};\n\n/**\n * Posts a message to the worker thread.\n * @param {string} message\n * @return {undefined}\n */\nWebWorker.prototype.postMessage = function(message) {};\n\n/**\n * Sent when the worker thread posts a message to its creator.\n * @type {?function(!MessageEvent<*>): void}\n */\nWebWorker.prototype.onmessage;\n\n/**\n * Sent when the worker thread encounters an error.\n * @type {?function(!ErrorEvent): void}\n */\nWebWorker.prototype.onerror;\n\n/**\n * @see http://dev.w3.org/html5/workers/\n * @param {string} scriptURL\n * @param {!WorkerOptions=} opt_options\n * @constructor\n * @implements {EventTarget}\n */\nfunction Worker(scriptURL, opt_options) {}\n\n/** @override */\nWorker.prototype.addEventListener = function(type, listener, opt_options) {};\n\n/** @override */\nWorker.prototype.removeEventListener = function(type, listener, opt_options) {};\n\n/** @override */\nWorker.prototype.dispatchEvent = function(evt) {};\n\n/**\n * Stops the worker process\n * @return {undefined}\n */\nWorker.prototype.terminate = function() {};\n\n/**\n * Posts a message to the worker thread.\n * @param {*} message\n * @param {Array<!Transferable>=} opt_transfer\n * @return {undefined}\n */\nWorker.prototype.postMessage = function(message, opt_transfer) {};\n\n/**\n * Posts a message to the worker thread.\n * @param {*} message\n * @param {Array<!Transferable>=} opt_transfer\n * @return {undefined}\n */\nWorker.prototype.webkitPostMessage = function(message, opt_transfer) {};\n\n/**\n * Sent when the worker thread posts a message to its creator.\n * @type {?function(!MessageEvent<*>): void}\n */\nWorker.prototype.onmessage;\n\n/**\n * Sent when the worker thread encounters an error.\n * @type {?function(!ErrorEvent): void}\n */\nWorker.prototype.onerror;\n\n/**\n * @see http://dev.w3.org/html5/workers/\n * @record\n */\nfunction WorkerOptions() {}\n\n/**\n * Defines a name for the new global environment of the worker, primarily for\n * debugging purposes.\n * @type {string|undefined}\n */\nWorkerOptions.prototype.name;\n\n/**\n * 'classic' or 'module'. Default: 'classic'.\n * Specifying 'module' ensures the worker environment supports JavaScript\n * modules.\n * @type {string|undefined}\n */\nWorkerOptions.prototype.type;\n\n// WorkerOptions.prototype.credentials is defined in fetchapi.js.\n// if type = 'module', it specifies how scriptURL is fetched.\n\n/**\n * @see http://dev.w3.org/html5/workers/\n * @param {string} scriptURL The URL of the script to run in the SharedWorker.\n * @param {string=} opt_name A name that can later be used to obtain a\n *     reference to the same SharedWorker.\n * @constructor\n * @implements {EventTarget}\n */\nfunction SharedWorker(scriptURL, opt_name) {}\n\n/** @override */\nSharedWorker.prototype.addEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nSharedWorker.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nSharedWorker.prototype.dispatchEvent = function(evt) {};\n\n/**\n * @type {!MessagePort}\n */\nSharedWorker.prototype.port;\n\n/**\n * Called on network errors for loading the initial script.\n * @type {?function(!ErrorEvent): void}\n */\nSharedWorker.prototype.onerror;\n\n/**\n * @see http://dev.w3.org/html5/workers/\n * @see http://www.w3.org/TR/url-1/#dom-urlutilsreadonly\n * @interface\n */\nfunction WorkerLocation() {}\n\n/** @type {string} */\nWorkerLocation.prototype.href;\n\n/** @type {string} */\nWorkerLocation.prototype.origin;\n\n/** @type {string} */\nWorkerLocation.prototype.protocol;\n\n/** @type {string} */\nWorkerLocation.prototype.host;\n\n/** @type {string} */\nWorkerLocation.prototype.hostname;\n\n/** @type {string} */\nWorkerLocation.prototype.port;\n\n/** @type {string} */\nWorkerLocation.prototype.pathname;\n\n/** @type {string} */\nWorkerLocation.prototype.search;\n\n/** @type {string} */\nWorkerLocation.prototype.hash;\n\n/**\n * @see http://dev.w3.org/html5/workers/\n * @interface\n * @extends {EventTarget}\n */\nfunction WorkerGlobalScope() {}\n\n/** @type {!WorkerGlobalScope} */\nWorkerGlobalScope.prototype.self;\n\n/** @type {!WorkerLocation} */\nWorkerGlobalScope.prototype.location;\n\n/**\n * Closes the worker represented by this WorkerGlobalScope.\n * @return {undefined}\n */\nWorkerGlobalScope.prototype.close = function() {};\n\n/**\n * Sent when the worker encounters an error.\n * @type {?function(string, string, number, number, !Error): void}\n */\nWorkerGlobalScope.prototype.onerror;\n\n/**\n * Sent when the worker goes offline.\n * @type {?function(!Event): void}\n */\nWorkerGlobalScope.prototype.onoffline;\n\n/**\n * Sent when the worker goes online.\n * @type {?function(!Event): void}\n */\nWorkerGlobalScope.prototype.ononline;\n\n/** @type {!WorkerPerformance} */\nWorkerGlobalScope.prototype.performance;\n\n/** @type {!WorkerNavigator} */\nWorkerGlobalScope.prototype.navigator;\n\n/**\n * Worker postMessage method.\n * @param {*} message\n * @param {(!Array<!Transferable>)=} transfer\n * @return {void}\n */\nWorkerGlobalScope.prototype.postMessage = function(message, transfer) {};\n\n/**\n * @see http://dev.w3.org/html5/workers/\n * @interface\n * @extends {WorkerGlobalScope}\n */\nfunction DedicatedWorkerGlobalScope() {}\n\n/**\n * Posts a message to creator of this worker.\n * @param {*} message\n * @param {Array<!Transferable>=} opt_transfer\n * @return {undefined}\n */\nDedicatedWorkerGlobalScope.prototype.postMessage =\n    function(message, opt_transfer) {};\n\n/**\n * Posts a message to creator of this worker.\n * @param {*} message\n * @param {Array<!Transferable>=} opt_transfer\n * @return {undefined}\n */\nDedicatedWorkerGlobalScope.prototype.webkitPostMessage =\n    function(message, opt_transfer) {};\n\n/**\n * Sent when the creator posts a message to this worker.\n * @type {?function(!MessageEvent<*>): void}\n */\nDedicatedWorkerGlobalScope.prototype.onmessage;\n\n/**\n * @see http://dev.w3.org/html5/workers/\n * @interface\n * @extends {WorkerGlobalScope}\n */\nfunction SharedWorkerGlobalScope() {}\n\n/** @type {string} */\nSharedWorkerGlobalScope.prototype.name;\n\n/**\n * Sent when a connection to this worker is opened.\n * @type {?function(!Event)}\n */\nSharedWorkerGlobalScope.prototype.onconnect;\n\n/** @type {!Array<string>|undefined} */\nHTMLElement.observedAttributes;\n\n/**\n * @param {!Document} oldDocument\n * @param {!Document} newDocument\n */\nHTMLElement.prototype.adoptedCallback = function(oldDocument, newDocument) {};\n\n/**\n * @param {!{mode: string}} options\n * @return {!ShadowRoot}\n */\nHTMLElement.prototype.attachShadow = function(options) {};\n\n/**\n * @param {string} attributeName\n * @param {?string} oldValue\n * @param {?string} newValue\n * @param {?string} namespace\n */\nHTMLElement.prototype.attributeChangedCallback = function(attributeName, oldValue, newValue, namespace) {};\n\n/** @type {function()|undefined} */\nHTMLElement.prototype.connectedCallback;\n\n/** @type {Element} */\nHTMLElement.prototype.contextMenu;\n\n/** @type {function()|undefined} */\nHTMLElement.prototype.disconnectedCallback;\n\n/** @type {boolean} */\nHTMLElement.prototype.draggable;\n\n/**\n * This is actually a DOMSettableTokenList property. However since that\n * interface isn't currently defined and no known browsers implement this\n * feature, just define the property for now.\n *\n * @const {Object}\n */\nHTMLElement.prototype.dropzone;\n\n/** @type {boolean} */\nHTMLElement.prototype.hidden;\n\n/** @type {boolean} */\nHTMLElement.prototype.spellcheck;\n\n/**\n * @see https://dom.spec.whatwg.org/#dictdef-getrootnodeoptions\n * @typedef {{\n *   composed: boolean\n * }}\n */\nvar GetRootNodeOptions;\n\n/**\n * @see https://dom.spec.whatwg.org/#dom-node-getrootnode\n * @param {GetRootNodeOptions=} opt_options\n * @return {!Node}\n */\nNode.prototype.getRootNode = function(opt_options) {};\n\n/**\n * @see http://www.w3.org/TR/components-intro/\n * @return {!ShadowRoot}\n */\nHTMLElement.prototype.createShadowRoot;\n\n/**\n * @see http://www.w3.org/TR/components-intro/\n * @return {!ShadowRoot}\n */\nHTMLElement.prototype.webkitCreateShadowRoot;\n\n/**\n * @see http://www.w3.org/TR/shadow-dom/\n * @type {ShadowRoot}\n */\nHTMLElement.prototype.shadowRoot;\n\n/**\n * @see http://www.w3.org/TR/shadow-dom/\n * @return {!NodeList<!Node>}\n */\nHTMLElement.prototype.getDestinationInsertionPoints = function() {};\n\n/**\n * @see http://www.w3.org/TR/components-intro/\n * @type {function()}\n */\nHTMLElement.prototype.createdCallback;\n\n/**\n * @see http://w3c.github.io/webcomponents/explainer/#lifecycle-callbacks\n * @type {function()}\n */\nHTMLElement.prototype.attachedCallback;\n\n/**\n * @see http://w3c.github.io/webcomponents/explainer/#lifecycle-callbacks\n * @type {function()}\n */\nHTMLElement.prototype.detachedCallback;\n\n/**\n * Cryptographic nonce used by Content Security Policy.\n * @see https://html.spec.whatwg.org/multipage/dom.html#elements-in-the-dom:noncedelement\n * @type {?string}\n */\nHTMLElement.prototype.nonce;\n\n/** @type {string} */\nHTMLAnchorElement.prototype.download;\n\n/** @type {string} */\nHTMLAnchorElement.prototype.hash;\n\n/** @type {string} */\nHTMLAnchorElement.prototype.host;\n\n/** @type {string} */\nHTMLAnchorElement.prototype.hostname;\n\n/** @type {string} */\nHTMLAnchorElement.prototype.pathname;\n\n/**\n * The 'ping' attribute is known to be supported in recent versions (as of\n * mid-2014) of Chrome, Safari, and Firefox, and is not supported in any\n * current version of Internet Explorer.\n *\n * @type {string}\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/semantics.html#hyperlink-auditing\n */\nHTMLAnchorElement.prototype.ping;\n\n/** @type {string} */\nHTMLAnchorElement.prototype.port;\n\n/** @type {string} */\nHTMLAnchorElement.prototype.protocol;\n\n/** @type {!DOMTokenList} */\nHTMLAnchorElement.prototype.relList;\n\n/** @type {string} */\nHTMLAnchorElement.prototype.search;\n\n/** @type {string} */\nHTMLAreaElement.prototype.download;\n\n/**\n * @type {string}\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/semantics.html#hyperlink-auditing\n */\nHTMLAreaElement.prototype.ping;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/html-markup/iframe.html#iframe.attrs.srcdoc\n */\nHTMLIFrameElement.prototype.srcdoc;\n\n/**\n * @type {?DOMTokenList}\n * @see http://www.w3.org/TR/2012/WD-html5-20121025/the-iframe-element.html#attr-iframe-sandbox\n */\nHTMLIFrameElement.prototype.sandbox;\n\n/**\n * @type {Window}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLIFrameElement/contentWindow\n */\nHTMLIFrameElement.prototype.contentWindow;\n\n/** @type {string} */\nHTMLInputElement.prototype.autocomplete;\n\n/** @type {string} */\nHTMLInputElement.prototype.dirname;\n\n/** @type {FileList} */\nHTMLInputElement.prototype.files;\n\n/**\n * @type {boolean}\n * @see https://www.w3.org/TR/html5/forms.html#dom-input-indeterminate\n */\nHTMLInputElement.prototype.indeterminate;\n\n/** @type {string} */\nHTMLInputElement.prototype.list;\n\n/** @implicitCast @type {string} */\nHTMLInputElement.prototype.max;\n\n/** @implicitCast @type {string} */\nHTMLInputElement.prototype.min;\n\n/** @type {string} */\nHTMLInputElement.prototype.pattern;\n\n/** @type {boolean} */\nHTMLInputElement.prototype.multiple;\n\n/** @type {string} */\nHTMLInputElement.prototype.placeholder;\n\n/** @type {boolean} */\nHTMLInputElement.prototype.required;\n\n/** @implicitCast @type {string} */\nHTMLInputElement.prototype.step;\n\n/** @type {Date} */\nHTMLInputElement.prototype.valueAsDate;\n\n/** @type {number} */\nHTMLInputElement.prototype.valueAsNumber;\n\n/**\n * Changes the form control's value by the value given in the step attribute\n * multiplied by opt_n.\n * @param {number=} opt_n step multiplier.  Defaults to 1.\n * @return {undefined}\n */\nHTMLInputElement.prototype.stepDown = function(opt_n) {};\n\n/**\n * Changes the form control's value by the value given in the step attribute\n * multiplied by opt_n.\n * @param {number=} opt_n step multiplier.  Defaults to 1.\n * @return {undefined}\n */\nHTMLInputElement.prototype.stepUp = function(opt_n) {};\n\n\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLMediaElement\n */\nfunction HTMLMediaElement() {}\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-network_empty\n * @const {number}\n */\nHTMLMediaElement.NETWORK_EMPTY;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-network_empty\n * @const {number}\n */\nHTMLMediaElement.prototype.NETWORK_EMPTY;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-network_idle\n * @const {number}\n */\nHTMLMediaElement.NETWORK_IDLE;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-network_idle\n * @const {number}\n */\nHTMLMediaElement.prototype.NETWORK_IDLE;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-network_loading\n * @const {number}\n */\nHTMLMediaElement.NETWORK_LOADING;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-network_loading\n * @const {number}\n */\nHTMLMediaElement.prototype.NETWORK_LOADING;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-network_no_source\n * @const {number}\n */\nHTMLMediaElement.NETWORK_NO_SOURCE;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-network_no_source\n * @const {number}\n */\nHTMLMediaElement.prototype.NETWORK_NO_SOURCE;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_nothing\n * @const {number}\n */\nHTMLMediaElement.HAVE_NOTHING;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_nothing\n * @const {number}\n */\nHTMLMediaElement.prototype.HAVE_NOTHING;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_metadata\n * @const {number}\n */\nHTMLMediaElement.HAVE_METADATA;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_metadata\n * @const {number}\n */\nHTMLMediaElement.prototype.HAVE_METADATA;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_current_data\n * @const {number}\n */\nHTMLMediaElement.HAVE_CURRENT_DATA;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_current_data\n * @const {number}\n */\nHTMLMediaElement.prototype.HAVE_CURRENT_DATA;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_future_data\n * @const {number}\n */\nHTMLMediaElement.HAVE_FUTURE_DATA;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_future_data\n * @const {number}\n */\nHTMLMediaElement.prototype.HAVE_FUTURE_DATA;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_enough_data\n * @const {number}\n */\nHTMLMediaElement.HAVE_ENOUGH_DATA;\n\n/**\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-have_enough_data\n * @const {number}\n */\nHTMLMediaElement.prototype.HAVE_ENOUGH_DATA;\n\n/** @type {MediaError} */\nHTMLMediaElement.prototype.error;\n\n/** @type {string} @implicitCast */\nHTMLMediaElement.prototype.src;\n\n/** @type {string} */\nHTMLMediaElement.prototype.currentSrc;\n\n/** @type {number} */\nHTMLMediaElement.prototype.networkState;\n\n/** @type {boolean} */\nHTMLMediaElement.prototype.autobuffer;\n\n/** @type {!TimeRanges} */\nHTMLMediaElement.prototype.buffered;\n\n/** @type {?MediaStream} */\nHTMLMediaElement.prototype.srcObject;\n\n/**\n * Loads the media element.\n * @return {undefined}\n */\nHTMLMediaElement.prototype.load = function() {};\n\n/**\n * @param {string} type Type of the element in question in question.\n * @return {string} Whether it can play the type.\n * @nosideeffects\n */\nHTMLMediaElement.prototype.canPlayType = function(type) {};\n\n/** Event handlers */\n\n/** @type {?function(Event)} */\nHTMLMediaElement.prototype.onabort;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.oncanplay;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.oncanplaythrough;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.ondurationchange;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onemptied;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onended;\n\n/** @type {?function(Event)} */\nHTMLMediaElement.prototype.onerror;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onloadeddata;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onloadedmetadata;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onloadstart;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onpause;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onplay;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onplaying;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onprogress;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onratechange;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onseeked;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onseeking;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onstalled;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onsuspend;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.ontimeupdate;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onvolumechange;\n\n/** @type {?function(!Event)} */\nHTMLMediaElement.prototype.onwaiting;\n\n/** @type {?function(Event)} */\nHTMLImageElement.prototype.onload;\n\n/** @type {?function(Event)} */\nHTMLImageElement.prototype.onerror;\n\n/** @type {string} */\nHTMLMediaElement.prototype.preload;\n\n/** @type {number} */\nHTMLMediaElement.prototype.readyState;\n\n/** @type {boolean} */\nHTMLMediaElement.prototype.seeking;\n\n/**\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/media.html#dom-media-crossorigin\n */\nHTMLMediaElement.prototype.crossOrigin;\n\n/**\n * The current time, in seconds.\n * @type {number}\n */\nHTMLMediaElement.prototype.currentTime;\n\n/**\n * The absolute timeline offset.\n * @return {!Date}\n */\nHTMLMediaElement.prototype.getStartDate = function() {};\n\n/**\n * The length of the media in seconds.\n * @type {number}\n */\nHTMLMediaElement.prototype.duration;\n\n/** @type {boolean} */\nHTMLMediaElement.prototype.paused;\n\n/** @type {number} */\nHTMLMediaElement.prototype.defaultPlaybackRate;\n\n/** @type {number} */\nHTMLMediaElement.prototype.playbackRate;\n\n/** @type {TimeRanges} */\nHTMLMediaElement.prototype.played;\n\n/** @type {TimeRanges} */\nHTMLMediaElement.prototype.seekable;\n\n/** @type {boolean} */\nHTMLMediaElement.prototype.ended;\n\n/** @type {boolean} */\nHTMLMediaElement.prototype.autoplay;\n\n/** @type {boolean} */\nHTMLMediaElement.prototype.loop;\n\n/**\n * Starts playing the media.\n * @return {?Promise<undefined>} This is a *nullable* Promise on purpose unlike\n *     the HTML5 spec because supported older browsers (incl. Smart TVs) don't\n *     return a Promise.\n */\nHTMLMediaElement.prototype.play = function() {};\n\n/**\n * Pauses the media.\n * @return {undefined}\n */\nHTMLMediaElement.prototype.pause = function() {};\n\n/** @type {boolean} */\nHTMLMediaElement.prototype.controls;\n\n/**\n * The audio volume, from 0.0 (silent) to 1.0 (loudest).\n * @type {number}\n */\nHTMLMediaElement.prototype.volume;\n\n/** @type {boolean} */\nHTMLMediaElement.prototype.muted;\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-video-element.html#dom-media-addtexttrack\n * @param {string} kind Kind of the text track.\n * @param {string=} opt_label Label of the text track.\n * @param {string=} opt_language Language of the text track.\n * @return {!TextTrack} TextTrack object added to the media element.\n */\nHTMLMediaElement.prototype.addTextTrack =\n    function(kind, opt_label, opt_language) {};\n\n/** @type {!TextTrackList} */\nHTMLMediaElement.prototype.textTracks;\n\n/**\n * The ID of the audio device through which output is being delivered, or an\n * empty string if using the default device.\n *\n * Implemented as a draft spec in Chrome 49+.\n *\n * @see https://w3c.github.io/mediacapture-output/#htmlmediaelement-extensions\n * @type {string}\n */\nHTMLMediaElement.prototype.sinkId;\n\n/**\n * Sets the audio device through which output should be delivered.\n *\n * Implemented as a draft spec in Chrome 49+.\n *\n * @param {string} sinkId The ID of the audio output device, or empty string\n * for default device.\n *\n * @see https://w3c.github.io/mediacapture-output/#htmlmediaelement-extensions\n * @return {!Promise<void>}\n */\nHTMLMediaElement.prototype.setSinkId = function(sinkId) {};\n\n\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see https://html.spec.whatwg.org/multipage/dom.html#htmlunknownelement\n * @see https://html.spec.whatwg.org/multipage/scripting.html#customized-built-in-element-restrictions\n * @see https://w3c.github.io/webcomponents/spec/custom/#custom-elements-api\n */\nfunction HTMLUnknownElement() {}\n\n\n\n/**\n * @see http://www.w3.org/TR/shadow-dom/\n * @return {!NodeList<!Node>}\n */\nText.prototype.getDestinationInsertionPoints = function() {};\n\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-video-element.html#texttracklist\n * @constructor\n * @implements {IArrayLike<!TextTrack>}\n */\nfunction TextTrackList() {}\n\n/** @type {number} */\nTextTrackList.prototype.length;\n\n/**\n * @param {string} id\n * @return {TextTrack}\n */\nTextTrackList.prototype.getTrackById = function(id) {};\n\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-video-element.html#texttrack\n * @constructor\n * @implements {EventTarget}\n */\nfunction TextTrack() {}\n\n/**\n * @param {TextTrackCue} cue\n * @return {undefined}\n */\nTextTrack.prototype.addCue = function(cue) {};\n\n/**\n * @param {TextTrackCue} cue\n * @return {undefined}\n */\nTextTrack.prototype.removeCue = function(cue) {};\n\n/**\n * @const {TextTrackCueList}\n */\nTextTrack.prototype.activeCues;\n\n/**\n * @const {TextTrackCueList}\n */\nTextTrack.prototype.cues;\n\n/**\n * @type {string}\n */\nTextTrack.prototype.mode;\n\n/** @override */\nTextTrack.prototype.addEventListener = function(\n    type, listener, opt_useCapture) {};\n\n/** @override */\nTextTrack.prototype.dispatchEvent = function(evt) {};\n\n/** @override */\nTextTrack.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-video-element.html#texttrackcuelist\n * @constructor\n * @implements {IArrayLike<!TextTrackCue>}\n */\nfunction TextTrackCueList() {}\n\n/** @const {number} */\nTextTrackCueList.prototype.length;\n\n/**\n * @param {string} id\n * @return {TextTrackCue}\n */\nTextTrackCueList.prototype.getCueById = function(id) {};\n\n\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-video-element.html#texttrackcue\n * @constructor\n * @param {number} startTime\n * @param {number} endTime\n * @param {string} text\n */\nfunction TextTrackCue(startTime, endTime, text) {}\n\n/** @type {string} */\nTextTrackCue.prototype.id;\n\n/** @type {number} */\nTextTrackCue.prototype.startTime;\n\n/** @type {number} */\nTextTrackCue.prototype.endTime;\n\n/** @type {string} */\nTextTrackCue.prototype.text;\n\n\n\n/**\n * @see https://w3c.github.io/webvtt/#vttregion\n * @constructor\n */\nfunction VTTRegion() {}\n\n/** @type {string} */\nVTTRegion.prototype.id;\n\n/** @type {number} */\nVTTRegion.prototype.width;\n\n/** @type {number} */\nVTTRegion.prototype.lines;\n\n/** @type {number} */\nVTTRegion.prototype.regionAnchorX;\n\n/** @type {number} */\nVTTRegion.prototype.regionAnchorY;\n\n/** @type {number} */\nVTTRegion.prototype.viewportAnchorX;\n\n/** @type {number} */\nVTTRegion.prototype.viewportAnchorY;\n\n/**\n * @see https://w3c.github.io/webvtt/#enumdef-scrollsetting\n * @type {string}\n */\nVTTRegion.prototype.scroll;\n\n\n\n/**\n * @see http://dev.w3.org/html5/webvtt/#the-vttcue-interface\n * @constructor\n * @extends {TextTrackCue}\n * @param {number} startTime\n * @param {number} endTime\n * @param {string} text\n */\nfunction VTTCue(startTime, endTime, text) {}\n\n/** @type {?VTTRegion} */\nVTTCue.prototype.region;\n\n/**\n * @see https://w3c.github.io/webvtt/#enumdef-directionsetting\n * @type {string}\n */\nVTTCue.prototype.vertical;\n\n/** @type {boolean} */\nVTTCue.prototype.snapToLines;\n\n/** @type {(number|string)} */\nVTTCue.prototype.line;\n\n/**\n * @see https://w3c.github.io/webvtt/#enumdef-linealignsetting\n * @type {string}\n */\nVTTCue.prototype.lineAlign;\n\n/** @type {(number|string)} */\nVTTCue.prototype.position;\n\n/**\n * @see https://w3c.github.io/webvtt/#enumdef-positionalignsetting\n * @type {string}\n */\nVTTCue.prototype.positionAlign;\n\n/** @type {number} */\nVTTCue.prototype.size;\n\n/**\n * @see https://w3c.github.io/webvtt/#enumdef-alignsetting\n * @type {string}\n */\nVTTCue.prototype.align;\n\n/** @type {string} */\nVTTCue.prototype.text;\n\n/** @return {!DocumentFragment} */\nVTTCue.prototype.getCueAsHTML = function() {};\n\n\n/**\n * @constructor\n * @extends {HTMLMediaElement}\n */\nfunction HTMLAudioElement() {}\n\n/**\n * @constructor\n * @extends {HTMLMediaElement}\n * The webkit-prefixed attributes are defined in\n * https://cs.chromium.org/chromium/src/third_party/WebKit/Source/core/html/media/HTMLMediaElement.idl\n */\nfunction HTMLVideoElement() {}\n\n/**\n * Starts displaying the video in full screen mode.\n * @return {undefined}\n */\nHTMLVideoElement.prototype.webkitEnterFullscreen = function() {};\n\n/**\n * Starts displaying the video in full screen mode.\n * @return {undefined}\n */\nHTMLVideoElement.prototype.webkitEnterFullScreen = function() {};\n\n/**\n * Stops displaying the video in full screen mode.\n * @return {undefined}\n */\nHTMLVideoElement.prototype.webkitExitFullscreen = function() {};\n\n/**\n * Stops displaying the video in full screen mode.\n * @return {undefined}\n */\nHTMLVideoElement.prototype.webkitExitFullScreen = function() {};\n\n/** @type {number} */\nHTMLVideoElement.prototype.width;\n\n/** @type {number} */\nHTMLVideoElement.prototype.height;\n\n/** @type {number} */\nHTMLVideoElement.prototype.videoWidth;\n\n/** @type {number} */\nHTMLVideoElement.prototype.videoHeight;\n\n/** @type {string} */\nHTMLVideoElement.prototype.poster;\n\n/** @type {boolean} */\nHTMLVideoElement.prototype.webkitSupportsFullscreen;\n\n/** @type {boolean} */\nHTMLVideoElement.prototype.webkitDisplayingFullscreen;\n\n/** @type {number} */\nHTMLVideoElement.prototype.webkitDecodedFrameCount;\n\n/** @type {number} */\nHTMLVideoElement.prototype.webkitDroppedFrameCount;\n\n/**\n * @typedef {{\n *    creationTime: number,\n *    totalVideoFrames: number,\n *    droppedVideoFrames: number,\n *    corruptedVideoFrames: number,\n *    totalFrameDelay: number\n * }}\n */\nvar VideoPlaybackQuality;\n\n/**\n * @see https://w3c.github.io/media-source/#htmlvideoelement-extensions\n * @return {!VideoPlaybackQuality} Stats about the current playback.\n */\nHTMLVideoElement.prototype.getVideoPlaybackQuality = function() {};\n\n\n/**\n * @constructor\n * @see https://html.spec.whatwg.org/multipage/media.html#error-codes\n */\nfunction MediaError() {}\n\n/** @type {number} */\nMediaError.prototype.code;\n\n/** @type {string} */\nMediaError.prototype.message;\n\n/**\n * The fetching process for the media resource was aborted by the user agent at\n * the user's request.\n * @const {number}\n */\nMediaError.MEDIA_ERR_ABORTED;\n\n/**\n * A network error of some description caused the user agent to stop fetching\n * the media resource, after the resource was established to be usable.\n * @const {number}\n */\nMediaError.MEDIA_ERR_NETWORK;\n\n/**\n * An error of some description occurred while decoding the media resource,\n * after the resource was established to be usable.\n * @const {number}\n */\nMediaError.MEDIA_ERR_DECODE;\n\n/**\n * The media resource indicated by the src attribute was not suitable.\n * @const {number}\n */\nMediaError.MEDIA_ERR_SRC_NOT_SUPPORTED;\n\n// HTML5 MessageChannel\n/**\n * @see http://dev.w3.org/html5/spec/comms.html#messagechannel\n * @constructor\n */\nfunction MessageChannel() {}\n\n/**\n * Returns the first port.\n * @type {!MessagePort}\n */\nMessageChannel.prototype.port1;\n\n/**\n * Returns the second port.\n * @type {!MessagePort}\n */\nMessageChannel.prototype.port2;\n\n// HTML5 MessagePort\n/**\n * @see http://dev.w3.org/html5/spec/comms.html#messageport\n * @constructor\n * @implements {EventTarget}\n * @implements {Transferable}\n */\nfunction MessagePort() {}\n\n/** @override */\nMessagePort.prototype.addEventListener = function(type, listener, opt_options) {\n};\n\n/** @override */\nMessagePort.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nMessagePort.prototype.dispatchEvent = function(evt) {};\n\n\n/**\n * Posts a message through the channel, optionally with the given\n * Array of Transferables.\n * @param {*} message\n * @param {Array<!Transferable>=} opt_transfer\n * @return {undefined}\n */\nMessagePort.prototype.postMessage = function(message, opt_transfer) {\n};\n\n/**\n * Begins dispatching messages received on the port.\n * @return {undefined}\n */\nMessagePort.prototype.start = function() {};\n\n/**\n * Disconnects the port, so that it is no longer active.\n * @return {undefined}\n */\nMessagePort.prototype.close = function() {};\n\n/**\n * TODO(blickly): Change this to MessageEvent<*> and add casts as needed\n * @type {?function(!MessageEvent<?>): void}\n */\nMessagePort.prototype.onmessage;\n\n// HTML5 MessageEvent class\n/**\n * @typedef {Window|MessagePort|ServiceWorker}\n * @see https://html.spec.whatwg.org/multipage/comms.html#messageeventsource\n */\nvar MessageEventSource;\n\n\n/**\n * @record\n * @extends {EventInit}\n * @template T\n * @see https://html.spec.whatwg.org/multipage/comms.html#messageeventinit\n */\nfunction MessageEventInit() {}\n\n/** @type {T|undefined} */\nMessageEventInit.prototype.data;\n\n/** @type {(string|undefined)} */\nMessageEventInit.prototype.origin;\n\n/** @type {(string|undefined)} */\nMessageEventInit.prototype.lastEventId;\n\n/** @type {(?MessageEventSource|undefined)} */\nMessageEventInit.prototype.source;\n\n/** @type {(!Array<MessagePort>|undefined)} */\nMessageEventInit.prototype.ports;\n\n\n/**\n * @see https://html.spec.whatwg.org/multipage/comms.html#messageevent\n * @constructor\n * @extends {Event}\n * @param {string} type\n * @param {MessageEventInit<T>=} opt_eventInitDict\n * @template T\n */\nfunction MessageEvent(type, opt_eventInitDict) {}\n\n/**\n * The data payload of the message.\n * @type {T}\n */\nMessageEvent.prototype.data;\n\n/**\n * The origin of the message, for server-sent events and cross-document\n * messaging.\n * @type {string}\n */\nMessageEvent.prototype.origin;\n\n/**\n * The last event ID, for server-sent events.\n * @type {string}\n */\nMessageEvent.prototype.lastEventId;\n\n/**\n * The window that dispatched the event.\n * @type {Window}\n */\nMessageEvent.prototype.source;\n\n/**\n * The Array of MessagePorts sent with the message, for cross-document\n * messaging and channel messaging.\n * @type {!Array<MessagePort>}\n */\nMessageEvent.prototype.ports;\n\n/**\n * Initializes the event in a manner analogous to the similarly-named methods in\n * the DOM Events interfaces.\n * @param {string} typeArg\n * @param {boolean=} canBubbleArg\n * @param {boolean=} cancelableArg\n * @param {T=} dataArg\n * @param {string=} originArg\n * @param {string=} lastEventIdArg\n * @param {?MessageEventSource=} sourceArg\n * @param {!Array<MessagePort>=} portsArg\n * @return {undefined}\n */\nMessageEvent.prototype.initMessageEvent = function(typeArg, canBubbleArg,\n    cancelableArg, dataArg, originArg, lastEventIdArg, sourceArg, portsArg) {};\n\n/**\n * Initializes the event in a manner analogous to the similarly-named methods in\n * the DOM Events interfaces.\n * @param {string} namespaceURI\n * @param {string=} typeArg\n * @param {boolean=} canBubbleArg\n * @param {boolean=} cancelableArg\n * @param {T=} dataArg\n * @param {string=} originArg\n * @param {string=} lastEventIdArg\n * @param {?MessageEventSource=} sourceArg\n * @param {!Array<MessagePort>=} portsArg\n * @return {undefined}\n */\nMessageEvent.prototype.initMessageEventNS = function(namespaceURI, typeArg,\n    canBubbleArg, cancelableArg, dataArg, originArg, lastEventIdArg, sourceArg,\n    portsArg) {};\n\n/**\n * @record\n * @extends {EventInit}\n * @see https://html.spec.whatwg.org/multipage/web-sockets.html#the-closeevent-interface\n */\nfunction CloseEventInit() {}\n\n/**\n * @type {undefined|boolean}\n */\nCloseEventInit.prototype.wasClean;\n\n/**\n * @type {undefined|number}\n */\nCloseEventInit.prototype.code;\n\n/**\n * @type {undefined|string}\n */\nCloseEventInit.prototype.reason;\n\n/**\n * @constructor\n * @extends {Event}\n * @param {string} type\n * @param {!CloseEventInit=} opt_init\n */\nvar CloseEvent = function(type, opt_init) {};\n\n/**\n * @type {boolean}\n */\nCloseEvent.prototype.wasClean;\n\n/**\n * @type {number}\n */\nCloseEvent.prototype.code;\n\n/**\n * @type {string}\n */\nCloseEvent.prototype.reason;\n\n/**\n * HTML5 BroadcastChannel class.\n * @param {string} channelName\n * @see https://developer.mozilla.org/en-US/docs/Web/API/BroadcastChannel\n * @see https://html.spec.whatwg.org/multipage/comms.html#dom-broadcastchannel\n * @implements {EventTarget}\n * @constructor\n */\nfunction BroadcastChannel(channelName) {}\n\n/**\n * Sends the message, of any type of object, to each BroadcastChannel object\n * listening to the same channel.\n * @param {*} message\n */\nBroadcastChannel.prototype.postMessage = function(message) {};\n\n/**\n * Closes the channel object, indicating it won't get any new messages, and\n * allowing it to be, eventually, garbage collected.\n * @return {void}\n */\nBroadcastChannel.prototype.close = function() {};\n\n/** @override */\nBroadcastChannel.prototype.addEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nBroadcastChannel.prototype.dispatchEvent = function(evt) {};\n\n/** @override */\nBroadcastChannel.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/**\n * An EventHandler property that specifies the function to execute when a\n * message event is fired on this object.\n * @type {?function(!MessageEvent<*>)}\n */\nBroadcastChannel.prototype.onmessage;\n\n/**\n * The name of the channel.\n * @type {string}\n */\nBroadcastChannel.prototype.name;\n\n/**\n * HTML5 DataTransfer class.\n *\n * @see http://www.w3.org/TR/2011/WD-html5-20110113/dnd.html\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/dnd.html\n * @see http://developers.whatwg.org/dnd.html#datatransferitem\n * @constructor\n */\nfunction DataTransfer() {}\n\n/** @type {string} */\nDataTransfer.prototype.dropEffect;\n\n/** @type {string} */\nDataTransfer.prototype.effectAllowed;\n\n/** @type {!Array<string>} */\nDataTransfer.prototype.types;\n\n/** @type {!FileList} */\nDataTransfer.prototype.files;\n\n/**\n * @param {string=} opt_format Format for which to remove data.\n * @return {undefined}\n */\nDataTransfer.prototype.clearData = function(opt_format) {};\n\n/**\n * @param {string} format Format for which to set data.\n * @param {string} data Data to add.\n * @return {boolean}\n */\nDataTransfer.prototype.setData = function(format, data) {};\n\n/**\n * @param {string} format Format for which to set data.\n * @return {string} Data for the given format.\n */\nDataTransfer.prototype.getData = function(format) { return ''; };\n\n/**\n * @param {HTMLElement} img The image to use when dragging.\n * @param {number} x Horizontal position of the cursor.\n * @param {number} y Vertical position of the cursor.\n * @return {undefined}\n */\nDataTransfer.prototype.setDragImage = function(img, x, y) {};\n\n/**\n * @param {HTMLElement} elem Element to receive drag result events.\n * @return {undefined}\n */\nDataTransfer.prototype.addElement = function(elem) {};\n\n/**\n * Addition for accessing clipboard file data that are part of the proposed\n * HTML5 spec.\n * @type {DataTransfer}\n */\nMouseEvent.prototype.dataTransfer;\n\n/**\n * @record\n * @extends {MouseEventInit}\n * @see https://w3c.github.io/uievents/#idl-wheeleventinit\n */\nfunction WheelEventInit() {}\n\n/** @type {undefined|number} */\nWheelEventInit.prototype.deltaX;\n\n/** @type {undefined|number} */\nWheelEventInit.prototype.deltaY;\n\n/** @type {undefined|number} */\nWheelEventInit.prototype.deltaZ;\n\n/** @type {undefined|number} */\nWheelEventInit.prototype.deltaMode;\n\n/**\n * @param {string} type\n * @param {WheelEventInit=} opt_eventInitDict\n * @see http://www.w3.org/TR/DOM-Level-3-Events/#interface-WheelEvent\n * @constructor\n * @extends {MouseEvent}\n */\nfunction WheelEvent(type, opt_eventInitDict) {}\n\n/** @const {number} */\nWheelEvent.DOM_DELTA_PIXEL;\n\n/** @const {number} */\nWheelEvent.DOM_DELTA_LINE;\n\n/** @const {number} */\nWheelEvent.DOM_DELTA_PAGE;\n\n/** @const {number} */\nWheelEvent.prototype.deltaX;\n\n/** @const {number} */\nWheelEvent.prototype.deltaY;\n\n/** @const {number} */\nWheelEvent.prototype.deltaZ;\n\n/** @const {number} */\nWheelEvent.prototype.deltaMode;\n\n/**\n * HTML5 DataTransferItem class.\n *\n * @see http://www.w3.org/TR/2011/WD-html5-20110113/dnd.html\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/dnd.html\n * @see http://developers.whatwg.org/dnd.html#datatransferitem\n * @constructor\n */\nfunction DataTransferItem() {}\n\n/** @type {string} */\nDataTransferItem.prototype.kind;\n\n/** @type {string} */\nDataTransferItem.prototype.type;\n\n/**\n * @param {function(string)} callback\n * @return {undefined}\n */\nDataTransferItem.prototype.getAsString = function(callback) {};\n\n/**\n * @return {?File} The file corresponding to this item, or null.\n * @nosideeffects\n */\nDataTransferItem.prototype.getAsFile = function() { return null; };\n\n/**\n * HTML5 DataTransferItemList class. There are some discrepancies in the docs\n * on the whatwg.org site. When in doubt, these prototypes match what is\n * implemented as of Chrome 30.\n *\n * @see http://www.w3.org/TR/2011/WD-html5-20110113/dnd.html\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/dnd.html\n * @see http://developers.whatwg.org/dnd.html#datatransferitem\n * @constructor\n * @implements {IArrayLike<!DataTransferItem>}\n */\nfunction DataTransferItemList() {}\n\n/** @type {number} */\nDataTransferItemList.prototype.length;\n\n/**\n * @param {number} i File to return from the list.\n * @return {DataTransferItem} The ith DataTransferItem in the list, or null.\n * @nosideeffects\n */\nDataTransferItemList.prototype.item = function(i) { return null; };\n\n/**\n * Adds an item to the list.\n * @param {string|!File} data Data for the item being added.\n * @param {string=} opt_type Mime type of the item being added. MUST be present\n *     if the {@code data} parameter is a string.\n * @return {DataTransferItem}\n */\nDataTransferItemList.prototype.add = function(data, opt_type) {};\n\n/**\n * Removes an item from the list.\n * @param {number} i File to remove from the list.\n * @return {undefined}\n */\nDataTransferItemList.prototype.remove = function(i) {};\n\n/**\n * Removes all items from the list.\n * @return {undefined}\n */\nDataTransferItemList.prototype.clear = function() {};\n\n/** @type {!DataTransferItemList} */\nDataTransfer.prototype.items;\n\n/**\n * @record\n * @extends {MouseEventInit}\n * @see http://w3c.github.io/html/editing.html#dictdef-drageventinit\n */\nfunction DragEventInit() {}\n\n/** @type {undefined|?DataTransfer} */\nDragEventInit.prototype.dataTransfer;\n\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/dnd.html#the-dragevent-interface\n * @constructor\n * @extends {MouseEvent}\n * @param {string} type\n * @param {DragEventInit=} opt_eventInitDict\n */\nfunction DragEvent(type, opt_eventInitDict) {}\n\n/** @type {DataTransfer} */\nDragEvent.prototype.dataTransfer;\n\n\n/**\n * @record\n * @extends {EventInit}\n * @see https://www.w3.org/TR/progress-events/#progresseventinit\n */\nfunction ProgressEventInit() {}\n\n/** @type {undefined|boolean} */\nProgressEventInit.prototype.lengthComputable;\n\n/** @type {undefined|number} */\nProgressEventInit.prototype.loaded;\n\n/** @type {undefined|number} */\nProgressEventInit.prototype.total;\n\n/**\n * @constructor\n * @template TARGET\n * @param {string} type\n * @param {ProgressEventInit=} opt_progressEventInitDict\n * @extends {Event}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/ProgressEvent\n */\nfunction ProgressEvent(type, opt_progressEventInitDict) {}\n\n/**\n * @override\n * @type {TARGET}\n */\nProgressEvent.prototype.target;\n\n/** @type {number} */\nProgressEvent.prototype.total;\n\n/** @type {number} */\nProgressEvent.prototype.loaded;\n\n/** @type {boolean} */\nProgressEvent.prototype.lengthComputable;\n\n\n/**\n * @constructor\n */\nfunction TimeRanges() {}\n\n/** @type {number} */\nTimeRanges.prototype.length;\n\n/**\n * @param {number} index The index.\n * @return {number} The start time of the range at index.\n * @throws {DOMException}\n */\nTimeRanges.prototype.start = function(index) { return 0; };\n\n/**\n * @param {number} index The index.\n * @return {number} The end time of the range at index.\n * @throws {DOMException}\n */\nTimeRanges.prototype.end = function(index) { return 0; };\n\n\n// HTML5 Web Socket class\n/**\n * @see https://html.spec.whatwg.org/multipage/web-sockets.html\n * @constructor\n * @param {string} url\n * @param {(string|!Array<string>)=} opt_protocol\n * @implements {EventTarget}\n */\nfunction WebSocket(url, opt_protocol) {}\n\n/**\n * The connection has not yet been established.\n * @const {number}\n */\nWebSocket.CONNECTING;\n\n/**\n * The connection has not yet been established.\n * @const {number}\n */\nWebSocket.prototype.CONNECTING;\n\n/**\n * The WebSocket connection is established and communication is possible.\n * @const {number}\n */\nWebSocket.OPEN;\n\n/**\n * The WebSocket connection is established and communication is possible.\n * @const {number}\n */\nWebSocket.prototype.OPEN;\n\n/**\n * The connection is going through the closing handshake, or the close() method has been invoked.\n * @const {number}\n */\nWebSocket.CLOSING;\n\n/**\n * The connection is going through the closing handshake, or the close() method has been invoked.\n * @const {number}\n */\nWebSocket.prototype.CLOSING;\n\n/**\n * The connection has been closed or could not be opened.\n * @const {number}\n */\nWebSocket.CLOSED;\n\n/**\n * The connection has been closed or could not be opened.\n * @const {number}\n */\nWebSocket.prototype.CLOSED;\n\n/** @override */\nWebSocket.prototype.addEventListener = function(type, listener, opt_options) {};\n\n/** @override */\nWebSocket.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nWebSocket.prototype.dispatchEvent = function(evt) {};\n\n/**\n * Returns the URL value that was passed to the constructor.\n * @type {string}\n */\nWebSocket.prototype.url;\n\n/**\n * Represents the state of the connection.\n * @type {number}\n */\nWebSocket.prototype.readyState;\n\n/**\n * Returns the number of bytes that have been queued but not yet sent.\n * @type {number}\n */\nWebSocket.prototype.bufferedAmount;\n\n/**\n * An event handler called on error event.\n * @type {?function(!Event): void}\n */\nWebSocket.prototype.onerror;\n\n/**\n * An event handler called on open event.\n * @type {?function(!Event): void}\n */\nWebSocket.prototype.onopen;\n\n/**\n * An event handler called on message event.\n * @type {?function(!MessageEvent<string|!ArrayBuffer|!Blob>): void}\n */\nWebSocket.prototype.onmessage;\n\n/**\n * An event handler called on close event.\n * @type {?function(!CloseEvent): void}\n */\nWebSocket.prototype.onclose;\n\n/**\n * Transmits data using the connection.\n * @param {string|!ArrayBuffer|!ArrayBufferView|!Blob} data\n * @return {void}\n */\nWebSocket.prototype.send = function(data) {};\n\n/**\n * Closes the Web Socket connection or connection attempt, if any.\n * @param {number=} opt_code\n * @param {string=} opt_reason\n * @return {undefined}\n */\nWebSocket.prototype.close = function(opt_code, opt_reason) {};\n\n/**\n * @type {string} Sets the type of data (blob or arraybuffer) for binary data.\n */\nWebSocket.prototype.binaryType;\n\n// HTML5 History\n/**\n * @constructor\n * @see http://w3c.github.io/html/browsers.html#the-history-interface\n */\nfunction History() {}\n\n/**\n * Goes back one step in the joint session history.\n * If there is no previous page, does nothing.\n *\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-history-back\n * @param {number=} opt_distance the number of entries to go back\n *     (Mozilla doesn't support distance -- use #go instead)\n *\n * @return {undefined}\n */\nHistory.prototype.back = function(opt_distance) {};\n\n/**\n * Goes forward one step in the joint session history.\n * If there is no next page, does nothing.\n *\n * @return {undefined}\n */\nHistory.prototype.forward = function() {};\n\n/**\n * The number of entries in the joint session history.\n *\n * @type {number}\n */\nHistory.prototype.length;\n\n/**\n * Goes back or forward the specified number of steps in the joint session\n * history. A zero delta will reload the current page. If the delta is out of\n * range, does nothing.\n *\n * @param {number} delta The number of entries to go back.\n * @return {undefined}\n */\nHistory.prototype.go = function(delta) {};\n\n/**\n * Pushes a new state into the session history.\n * @see http://www.w3.org/TR/html5/history.html#the-history-interface\n * @param {*} data New state.\n * @param {string} title The title for a new session history entry.\n * @param {string=} opt_url The URL for a new session history entry.\n * @return {undefined}\n */\nHistory.prototype.pushState = function(data, title, opt_url) {};\n\n/**\n * Replaces the current state in the session history.\n * @see http://www.w3.org/TR/html5/history.html#the-history-interface\n * @param {*} data New state.\n * @param {string} title The title for a session history entry.\n * @param {string=} opt_url The URL for a new session history entry.\n * @return {undefined}\n */\nHistory.prototype.replaceState = function(data, title, opt_url) {};\n\n/**\n * Pending state object.\n * @see https://developer.mozilla.org/en-US/docs/Web/Guide/API/DOM/Manipulating_the_browser_history#Reading_the_current_state\n * @type {*}\n */\nHistory.prototype.state;\n\n/**\n * Allows web applications to explicitly set default scroll restoration behavior\n * on history navigation. This property can be either auto or manual.\n *\n * Non-standard. Only supported in Chrome 46+.\n *\n * @see https://developer.mozilla.org/en-US/docs/Web/API/History\n * @see https://majido.github.io/scroll-restoration-proposal/history-based-api.html\n * @type {string}\n */\nHistory.prototype.scrollRestoration;\n\n/**\n * Add history property to Window.\n *\n * @type {!History}\n */\nWindow.prototype.history;\n\n/**\n * @constructor\n * @see https://html.spec.whatwg.org/multipage/history.html#the-location-interface\n */\nfunction Location() {}\n\n/**\n * Returns the Location object's URL. Can be set, to navigate to the given URL.\n * @implicitCast\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-href\n */\nLocation.prototype.href;\n\n/**\n * Returns the Location object's URL's origin.\n * @const {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-origin\n */\nLocation.prototype.origin;\n\n/**\n * Returns the Location object's URL's scheme. Can be set, to navigate to the\n * same URL with a changed scheme.\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-protocol\n */\nLocation.prototype.protocol;\n\n/**\n * Returns the Location object's URL's host and port (if different from the\n * default port for the scheme). Can be set, to navigate to the same URL with\n * a changed host and port.\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-host\n */\nLocation.prototype.host;\n\n/**\n * Returns the Location object's URL's host. Can be set, to navigate to the\n * same URL with a changed host.\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-hostname\n */\nLocation.prototype.hostname;\n\n/**\n * Returns the Location object's URL's port. Can be set, to navigate to the\n * same URL with a changed port.\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#the-location-interface:dom-location-port\n */\nLocation.prototype.port;\n\n/**\n * Returns the Location object's URL's path. Can be set, to navigate to the\n * same URL with a changed path.\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-pathname\n */\nLocation.prototype.pathname;\n\n/**\n * Returns the Location object's URL's query (includes leading \"?\" if\n * non-empty). Can be set, to navigate to the same URL with a changed query\n * (ignores leading \"?\").\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-search\n */\nLocation.prototype.search;\n\n/**\n * Returns the Location object's URL's fragment (includes leading \"#\" if\n * non-empty). Can be set, to navigate to the same URL with a changed fragment\n * (ignores leading \"#\").\n * @type {string}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-hash\n */\nLocation.prototype.hash;\n\n/**\n * Navigates to the given page.\n * @param {!TrustedURL|string} url\n * @return {undefined}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-assign\n */\nLocation.prototype.assign = function(url) {};\n\n/**\n * Removes the current page from the session history and navigates to the given\n * page.\n * @param {!TrustedURL|string} url\n * @return {undefined}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-replace\n */\nLocation.prototype.replace = function(url) {};\n\n/**\n * Reloads the current page.\n * @param {boolean=} forceReload If true, reloads the page from\n *     the server. Defaults to false.\n * @return {undefined}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-reload\n */\nLocation.prototype.reload = function(forceReload) {};\n\n/**\n * Returns a DOMStringList object listing the origins of the ancestor browsing\n * contexts, from the parent browsing context to the top-level browsing\n * context.\n * @type {DOMStringList}\n * @see https://html.spec.whatwg.org/multipage/history.html#dom-location-ancestororigins\n */\nLocation.prototype.ancestorOrigins;\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/#popstateevent\n * @constructor\n * @extends {Event}\n *\n * @param {string} type\n * @param {{state: *}=} opt_eventInitDict\n */\nfunction PopStateEvent(type, opt_eventInitDict) {}\n\n/**\n * @type {*}\n */\nPopStateEvent.prototype.state;\n\n/**\n * Initializes the event after it has been created with document.createEvent\n * @param {string} typeArg\n * @param {boolean} canBubbleArg\n * @param {boolean} cancelableArg\n * @param {*} stateArg\n * @return {undefined}\n */\nPopStateEvent.prototype.initPopStateEvent = function(typeArg, canBubbleArg,\n    cancelableArg, stateArg) {};\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/#hashchangeevent\n * @constructor\n * @extends {Event}\n *\n * @param {string} type\n * @param {{oldURL: string, newURL: string}=} opt_eventInitDict\n */\nfunction HashChangeEvent(type, opt_eventInitDict) {}\n\n/** @type {string} */\nHashChangeEvent.prototype.oldURL;\n\n/** @type {string} */\nHashChangeEvent.prototype.newURL;\n\n/**\n * Initializes the event after it has been created with document.createEvent\n * @param {string} typeArg\n * @param {boolean} canBubbleArg\n * @param {boolean} cancelableArg\n * @param {string} oldURLArg\n * @param {string} newURLArg\n * @return {undefined}\n */\nHashChangeEvent.prototype.initHashChangeEvent = function(typeArg, canBubbleArg,\n    cancelableArg, oldURLArg, newURLArg) {};\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/#pagetransitionevent\n * @constructor\n * @extends {Event}\n *\n * @param {string} type\n * @param {{persisted: boolean}=} opt_eventInitDict\n */\nfunction PageTransitionEvent(type, opt_eventInitDict) {}\n\n/** @type {boolean} */\nPageTransitionEvent.prototype.persisted;\n\n/**\n * Initializes the event after it has been created with document.createEvent\n * @param {string} typeArg\n * @param {boolean} canBubbleArg\n * @param {boolean} cancelableArg\n * @param {*} persistedArg\n * @return {undefined}\n */\nPageTransitionEvent.prototype.initPageTransitionEvent = function(typeArg,\n    canBubbleArg, cancelableArg, persistedArg) {};\n\n/**\n * @constructor\n * @implements {IArrayLike<!File>}\n */\nfunction FileList() {}\n\n/** @type {number} */\nFileList.prototype.length;\n\n/**\n * @param {number} i File to return from the list.\n * @return {File} The ith file in the list.\n * @nosideeffects\n */\nFileList.prototype.item = function(i) { return null; };\n\n/**\n * @type {boolean}\n * @see http://dev.w3.org/2006/webapi/XMLHttpRequest-2/#withcredentials\n */\nXMLHttpRequest.prototype.withCredentials;\n\n/**\n * @type {?function(!ProgressEvent): void}\n * @see https://xhr.spec.whatwg.org/#handler-xhr-onloadstart\n */\nXMLHttpRequest.prototype.onloadstart;\n\n/**\n * @type {?function(!ProgressEvent): void}\n * @see https://dvcs.w3.org/hg/xhr/raw-file/tip/Overview.html#handler-xhr-onprogress\n */\nXMLHttpRequest.prototype.onprogress;\n\n/**\n * @type {?function(!ProgressEvent): void}\n * @see https://xhr.spec.whatwg.org/#handler-xhr-onabort\n */\nXMLHttpRequest.prototype.onabort;\n\n/**\n * @type {?function(!ProgressEvent): void}\n * @see https://xhr.spec.whatwg.org/#handler-xhr-onload\n */\nXMLHttpRequest.prototype.onload;\n\n/**\n * @type {?function(!ProgressEvent): void}\n * @see https://xhr.spec.whatwg.org/#handler-xhr-ontimeout\n */\nXMLHttpRequest.prototype.ontimeout;\n\n/**\n * @type {?function(!ProgressEvent): void}\n * @see https://xhr.spec.whatwg.org/#handler-xhr-onloadend\n */\nXMLHttpRequest.prototype.onloadend;\n\n/**\n * @type {XMLHttpRequestUpload}\n * @see http://dev.w3.org/2006/webapi/XMLHttpRequest-2/#the-upload-attribute\n */\nXMLHttpRequest.prototype.upload;\n\n/**\n * @param {string} mimeType The mime type to override with.\n * @return {undefined}\n */\nXMLHttpRequest.prototype.overrideMimeType = function(mimeType) {};\n\n/**\n * @type {string}\n * @see http://dev.w3.org/2006/webapi/XMLHttpRequest-2/#the-responsetype-attribute\n */\nXMLHttpRequest.prototype.responseType;\n\n/**\n * @type {?(ArrayBuffer|Blob|Document|Object|string)}\n * @see http://dev.w3.org/2006/webapi/XMLHttpRequest-2/#the-response-attribute\n */\nXMLHttpRequest.prototype.response;\n\n\n/**\n * @type {ArrayBuffer}\n * Implemented as a draft spec in Firefox 4 as the way to get a requested array\n * buffer from an XMLHttpRequest.\n * @see https://developer.mozilla.org/En/Using_XMLHttpRequest#Receiving_binary_data_using_JavaScript_typed_arrays\n *\n * This property is not used anymore and should be removed.\n * @see https://github.com/google/closure-compiler/pull/1389\n */\nXMLHttpRequest.prototype.mozResponseArrayBuffer;\n\n/**\n * XMLHttpRequestEventTarget defines events for checking the status of a data\n * transfer between a client and a server. This should be a common base class\n * for XMLHttpRequest and XMLHttpRequestUpload.\n *\n * @constructor\n * @implements {EventTarget}\n */\nfunction XMLHttpRequestEventTarget() {}\n\n/** @override */\nXMLHttpRequestEventTarget.prototype.addEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nXMLHttpRequestEventTarget.prototype.removeEventListener = function(\n    type, listener, opt_options) {};\n\n/** @override */\nXMLHttpRequestEventTarget.prototype.dispatchEvent = function(evt) {};\n\n/**\n * An event target to track the status of an upload.\n *\n * @constructor\n * @extends {XMLHttpRequestEventTarget}\n */\nfunction XMLHttpRequestUpload() {}\n\n/**\n * @type {?function(!ProgressEvent): void}\n * @see https://dvcs.w3.org/hg/xhr/raw-file/tip/Overview.html#handler-xhr-onprogress\n */\nXMLHttpRequestUpload.prototype.onprogress;\n\n/**\n * @param {number=} opt_width\n * @param {number=} opt_height\n * @constructor\n * @extends {HTMLImageElement}\n */\nfunction Image(opt_width, opt_height) {}\n\n\n/**\n * Dataset collection.\n * This is really a DOMStringMap but it behaves close enough to an object to\n * pass as an object.\n * @const {!Object<string, string>}\n */\nHTMLElement.prototype.dataset;\n\n\n/**\n * @constructor\n * @implements {IArrayLike<string>}\n * @see https://dom.spec.whatwg.org/#interface-domtokenlist\n */\nfunction DOMTokenList() {}\n\n/**\n * Returns the number of CSS classes applied to this Element.\n * @type {number}\n */\nDOMTokenList.prototype.length;\n\n/**\n * Returns the string value applied to this Element.\n * @type {string|undefined}\n */\nDOMTokenList.prototype.value;\n\n/**\n * @param {number} index The index of the item to return.\n * @return {string} The CSS class at the specified index.\n * @nosideeffects\n */\nDOMTokenList.prototype.item = function(index) {};\n\n/**\n * @param {string} token The CSS class to check for.\n * @return {boolean} Whether the CSS class has been applied to the Element.\n * @nosideeffects\n */\nDOMTokenList.prototype.contains = function(token) {};\n\n/**\n * @param {...string} var_args The CSS class(es) to add to this element.\n * @return {undefined}\n */\nDOMTokenList.prototype.add = function(var_args) {};\n\n/**\n * @param {...string} var_args The CSS class(es) to remove from this element.\n * @return {undefined}\n */\nDOMTokenList.prototype.remove = function(var_args) {};\n\n/**\n * Replaces token with newToken.\n * @param {string} token The CSS class to replace.\n * @param {string} newToken The new CSS class to use.\n * @return {undefined}\n */\nDOMTokenList.prototype.replace = function(token, newToken) {};\n\n/**\n * @param {string} token The token to query for.\n * @return {boolean} Whether the token was found.\n * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMTokenList/supports\n * @nosideeffects\n */\nDOMTokenList.prototype.supports = function(token) {};\n\n/**\n * @param {string} token The CSS class to toggle from this element.\n * @param {boolean=} opt_force True to add the class whether it exists\n *     or not. False to remove the class whether it exists or not.\n *     This argument is not supported on IE 10 and below, according to\n *     the MDN page linked below.\n * @return {boolean} False if the token was removed; True otherwise.\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Element.classList\n */\nDOMTokenList.prototype.toggle = function(token, opt_force) {};\n\n/**\n * @return {string} A stringified representation of CSS classes.\n * @nosideeffects\n * @override\n */\nDOMTokenList.prototype.toString = function() {};\n\n/**\n * @return {!IteratorIterable<string>} An iterator to go through all values of\n *     the key/value pairs contained in this object.\n * @nosideeffects\n * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMTokenList/values\n */\nDOMTokenList.prototype.values = function() {};\n\n/**\n * A better interface to CSS classes than className.\n * @const {!DOMTokenList}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Element/classList\n */\nElement.prototype.classList;\n\n/**\n * Constraint Validation API properties and methods\n * @see http://www.w3.org/TR/2009/WD-html5-20090423/forms.html#the-constraint-validation-api\n */\n\n/** @return {boolean} */\nHTMLFormElement.prototype.checkValidity = function() {};\n\n/** @return {boolean} */\nHTMLFormElement.prototype.reportValidity = function() {};\n\n/** @type {boolean} */\nHTMLFormElement.prototype.noValidate;\n\n/** @constructor */\nfunction ValidityState() {}\n\n/** @type {boolean} */\nValidityState.prototype.badInput;\n\n/** @type {boolean} */\nValidityState.prototype.customError;\n\n/** @type {boolean} */\nValidityState.prototype.patternMismatch;\n\n/** @type {boolean} */\nValidityState.prototype.rangeOverflow;\n\n/** @type {boolean} */\nValidityState.prototype.rangeUnderflow;\n\n/** @type {boolean} */\nValidityState.prototype.stepMismatch;\n\n/** @type {boolean} */\nValidityState.prototype.typeMismatch;\n\n/** @type {boolean} */\nValidityState.prototype.tooLong;\n\n/** @type {boolean} */\nValidityState.prototype.tooShort;\n\n/** @type {boolean} */\nValidityState.prototype.valid;\n\n/** @type {boolean} */\nValidityState.prototype.valueMissing;\n\n\n/** @type {boolean} */\nHTMLButtonElement.prototype.autofocus;\n\n/**\n * Can return null when hidden.\n * See https://html.spec.whatwg.org/multipage/forms.html#dom-lfe-labels\n * @const {?NodeList<!HTMLLabelElement>}\n */\nHTMLButtonElement.prototype.labels;\n\n/** @type {string} */\nHTMLButtonElement.prototype.validationMessage;\n\n/**\n * @const {ValidityState}\n */\nHTMLButtonElement.prototype.validity;\n\n/** @type {boolean} */\nHTMLButtonElement.prototype.willValidate;\n\n/** @return {boolean} */\nHTMLButtonElement.prototype.checkValidity = function() {};\n\n/** @return {boolean} */\nHTMLButtonElement.prototype.reportValidity = function() {};\n\n/**\n * @param {string} message\n * @return {undefined}\n */\nHTMLButtonElement.prototype.setCustomValidity = function(message) {};\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/html5/forms.html#attr-fs-formaction\n */\nHTMLButtonElement.prototype.formAction;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/forms.html#attr-fs-formenctype\n */\nHTMLButtonElement.prototype.formEnctype;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/forms.html#attr-fs-formmethod\n */\nHTMLButtonElement.prototype.formMethod;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/forms.html#attr-fs-formtarget\n */\nHTMLButtonElement.prototype.formTarget;\n\n/** @type {boolean} */\nHTMLInputElement.prototype.autofocus;\n\n/** @type {boolean} */\nHTMLInputElement.prototype.formNoValidate;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/html5/forms.html#attr-fs-formaction\n */\nHTMLInputElement.prototype.formAction;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/forms.html#attr-fs-formenctype\n */\nHTMLInputElement.prototype.formEnctype;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/forms.html#attr-fs-formmethod\n */\nHTMLInputElement.prototype.formMethod;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/forms.html#attr-fs-formtarget\n */\nHTMLInputElement.prototype.formTarget;\n\n/**\n * Can return null when hidden.\n * See https://html.spec.whatwg.org/multipage/forms.html#dom-lfe-labels\n * @const {?NodeList<!HTMLLabelElement>}\n */\nHTMLInputElement.prototype.labels;\n\n/** @type {string} */\nHTMLInputElement.prototype.validationMessage;\n\n/**\n * @type {number}\n * @implicitCast\n */\nHTMLInputElement.prototype.selectionStart;\n\n/**\n * @type {number}\n * @implicitCast\n */\nHTMLInputElement.prototype.selectionEnd;\n\n/** @type {string} */\nHTMLInputElement.prototype.selectionDirection;\n\n/**\n * @param {number} start\n * @param {number} end\n * @param {string=} direction\n * @see https://html.spec.whatwg.org/#dom-textarea/input-setselectionrange\n * @return {undefined}\n */\nHTMLInputElement.prototype.setSelectionRange = function(start, end, direction) {};\n\n/**\n * @const {ValidityState}\n */\nHTMLInputElement.prototype.validity;\n\n/** @type {boolean} */\nHTMLInputElement.prototype.willValidate;\n\n/** @return {boolean} */\nHTMLInputElement.prototype.checkValidity = function() {};\n\n/** @return {boolean} */\nHTMLInputElement.prototype.reportValidity = function() {};\n\n/**\n * @param {string} message\n * @return {undefined}\n */\nHTMLInputElement.prototype.setCustomValidity = function(message) {};\n\n/** @type {Element} */\nHTMLLabelElement.prototype.control;\n\n/** @type {boolean} */\nHTMLSelectElement.prototype.autofocus;\n\n/**\n * Can return null when hidden.\n * See https://html.spec.whatwg.org/multipage/forms.html#dom-lfe-labels\n * @const {?NodeList<!HTMLLabelElement>}\n */\nHTMLSelectElement.prototype.labels;\n\n/** @type {HTMLCollection<!HTMLOptionElement>} */\nHTMLSelectElement.prototype.selectedOptions;\n\n/** @type {string} */\nHTMLSelectElement.prototype.validationMessage;\n\n/**\n * @const {ValidityState}\n */\nHTMLSelectElement.prototype.validity;\n\n/** @type {boolean} */\nHTMLSelectElement.prototype.willValidate;\n\n/** @return {boolean} */\nHTMLSelectElement.prototype.checkValidity = function() {};\n\n/** @return {boolean} */\nHTMLSelectElement.prototype.reportValidity = function() {};\n\n/**\n * @param {string} message\n * @return {undefined}\n */\nHTMLSelectElement.prototype.setCustomValidity = function(message) {};\n\n/** @type {boolean} */\nHTMLTextAreaElement.prototype.autofocus;\n\n/**\n * Can return null when hidden.\n * See https://html.spec.whatwg.org/multipage/forms.html#dom-lfe-labels\n * @const {?NodeList<!HTMLLabelElement>}\n */\nHTMLTextAreaElement.prototype.labels;\n\n/** @type {string} */\nHTMLTextAreaElement.prototype.placeholder;\n\n/** @type {string} */\nHTMLTextAreaElement.prototype.validationMessage;\n\n/**\n * @const {ValidityState}\n */\nHTMLTextAreaElement.prototype.validity;\n\n/** @type {boolean} */\nHTMLTextAreaElement.prototype.willValidate;\n\n/** @return {boolean} */\nHTMLTextAreaElement.prototype.checkValidity = function() {};\n\n/** @return {boolean} */\nHTMLTextAreaElement.prototype.reportValidity = function() {};\n\n/**\n * @param {string} message\n * @return {undefined}\n */\nHTMLTextAreaElement.prototype.setCustomValidity = function(message) {};\n\n/**\n * @constructor\n * @extends {HTMLElement}\n * @see http://www.w3.org/TR/html5/the-embed-element.html#htmlembedelement\n */\nfunction HTMLEmbedElement() {}\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/dimension-attributes.html#dom-dim-width\n */\nHTMLEmbedElement.prototype.width;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/dimension-attributes.html#dom-dim-height\n */\nHTMLEmbedElement.prototype.height;\n\n/**\n * @type {string}\n * @implicitCast\n * @see http://www.w3.org/TR/html5/the-embed-element.html#dom-embed-src\n */\nHTMLEmbedElement.prototype.src;\n\n/**\n * @type {string}\n * @see http://www.w3.org/TR/html5/the-embed-element.html#dom-embed-type\n */\nHTMLEmbedElement.prototype.type;\n\n// Fullscreen APIs.\n\n/**\n * @record\n * @see https://fullscreen.spec.whatwg.org/#dictdef-fullscreenoptions\n */\nfunction FullscreenOptions() {}\n\n/** @type {string} */\nFullscreenOptions.prototype.navigationUI;\n\n/**\n * @see https://fullscreen.spec.whatwg.org/#dom-element-requestfullscreen\n * @param {!FullscreenOptions=} options\n * @return {undefined}\n */\nElement.prototype.requestFullscreen = function(options) {};\n\n/**\n * @type {boolean}\n * @see http://www.w3.org/TR/2012/WD-fullscreen-20120703/#dom-document-fullscreenenabled\n */\nDocument.prototype.fullscreenEnabled;\n\n/**\n * @type {Element}\n * @see http://www.w3.org/TR/2012/WD-fullscreen-20120703/#dom-document-fullscreenelement\n */\nDocument.prototype.fullscreenElement;\n\n/**\n * @see http://www.w3.org/TR/2012/WD-fullscreen-20120703/#dom-document-exitfullscreen\n * @return {undefined}\n */\nDocument.prototype.exitFullscreen = function() {};\n\n// Externs definitions of browser current implementations.\n// Firefox 10 implementation.\nElement.prototype.mozRequestFullScreen = function() {};\n\nElement.prototype.mozRequestFullScreenWithKeys = function() {};\n\n/** @type {boolean} */\nDocument.prototype.mozFullScreen;\n\nDocument.prototype.mozCancelFullScreen = function() {};\n\n/** @type {Element} */\nDocument.prototype.mozFullScreenElement;\n\n/** @type {boolean} */\nDocument.prototype.mozFullScreenEnabled;\n\n// Chrome 21 implementation.\n/**\n * The current fullscreen element for the document is set to this element.\n * Valid only for Webkit browsers.\n * @param {number=} opt_allowKeyboardInput Whether keyboard input is desired.\n *     Should use ALLOW_KEYBOARD_INPUT constant.\n * @return {undefined}\n */\nElement.prototype.webkitRequestFullScreen = function(opt_allowKeyboardInput) {};\n\n/**\n * The current fullscreen element for the document is set to this element.\n * Valid only for Webkit browsers.\n * @param {number=} opt_allowKeyboardInput Whether keyboard input is desired.\n *     Should use ALLOW_KEYBOARD_INPUT constant.\n * @return {undefined}\n */\nElement.prototype.webkitRequestFullscreen = function(opt_allowKeyboardInput) {};\n\n/** @type {boolean} */\nDocument.prototype.webkitIsFullScreen;\n\nDocument.prototype.webkitCancelFullScreen = function() {};\n\n/** @type {boolean} */\nDocument.prototype.webkitFullscreenEnabled;\n\n/** @type {Element} */\nDocument.prototype.webkitCurrentFullScreenElement;\n\n/** @type {Element} */\nDocument.prototype.webkitFullscreenElement;\n\n/** @type {boolean} */\nDocument.prototype.webkitFullScreenKeyboardInputAllowed;\n\n// IE 11 implementation.\n// http://msdn.microsoft.com/en-us/library/ie/dn265028(v=vs.85).aspx\n/** @return {void} */\nElement.prototype.msRequestFullscreen = function() {};\n\n/** @return {void} */\nDocument.prototype.msExitFullscreen = function() {};\n\n/** @type {boolean} */\nDocument.prototype.msFullscreenEnabled;\n\n/** @type {Element} */\nDocument.prototype.msFullscreenElement;\n\n/** @const {number} */\nElement.ALLOW_KEYBOARD_INPUT;\n\n/** @const {number} */\nElement.prototype.ALLOW_KEYBOARD_INPUT;\n\n\n/**\n * @typedef {{\n *   childList: (boolean|undefined),\n *   attributes: (boolean|undefined),\n *   characterData: (boolean|undefined),\n *   subtree: (boolean|undefined),\n *   attributeOldValue: (boolean|undefined),\n *   characterDataOldValue: (boolean|undefined),\n *   attributeFilter: (!Array<string>|undefined)\n * }}\n */\nvar MutationObserverInit;\n\n\n/** @constructor */\nfunction MutationRecord() {}\n\n/** @type {string} */\nMutationRecord.prototype.type;\n\n/** @type {Node} */\nMutationRecord.prototype.target;\n\n/** @type {!NodeList<!Node>} */\nMutationRecord.prototype.addedNodes;\n\n/** @type {!NodeList<!Node>} */\nMutationRecord.prototype.removedNodes;\n\n/** @type {?Node} */\nMutationRecord.prototype.previousSibling;\n\n/** @type {?Node} */\nMutationRecord.prototype.nextSibling;\n\n/** @type {?string} */\nMutationRecord.prototype.attributeName;\n\n/** @type {?string} */\nMutationRecord.prototype.attributeNamespace;\n\n/** @type {?string} */\nMutationRecord.prototype.oldValue;\n\n\n/**\n * @see http://www.w3.org/TR/domcore/#mutation-observers\n * @param {function(!Array<!MutationRecord>, !MutationObserver)} callback\n * @constructor\n */\nfunction MutationObserver(callback) {}\n\n/**\n * @param {Node} target\n * @param {MutationObserverInit=} options\n * @return {undefined}\n */\nMutationObserver.prototype.observe = function(target, options) {};\n\nMutationObserver.prototype.disconnect = function() {};\n\n/**\n * @return {!Array<!MutationRecord>}\n */\nMutationObserver.prototype.takeRecords = function() {};\n\n/**\n * @type {function(new:MutationObserver, function(Array<MutationRecord>))}\n */\nWindow.prototype.WebKitMutationObserver;\n\n/**\n * @type {function(new:MutationObserver, function(Array<MutationRecord>))}\n */\nWindow.prototype.MozMutationObserver;\n\n\n/**\n * @see http://www.w3.org/TR/page-visibility/\n * @type {VisibilityState}\n */\nDocument.prototype.visibilityState;\n\n/**\n * @type {string}\n */\nDocument.prototype.mozVisibilityState;\n\n/**\n * @type {string}\n */\nDocument.prototype.webkitVisibilityState;\n\n/**\n * @type {string}\n */\nDocument.prototype.msVisibilityState;\n\n/**\n * @see http://www.w3.org/TR/page-visibility/\n * @type {boolean}\n */\nDocument.prototype.hidden;\n\n/**\n * @type {boolean}\n */\nDocument.prototype.mozHidden;\n\n/**\n * @type {boolean}\n */\nDocument.prototype.webkitHidden;\n\n/**\n * @type {boolean}\n */\nDocument.prototype.msHidden;\n\n/**\n * @see http://www.w3.org/TR/components-intro/\n * @see http://w3c.github.io/webcomponents/spec/custom/#extensions-to-document-interface-to-register\n * @param {string} type\n * @param {{extends: (string|undefined), prototype: (Object|undefined)}=}\n *     options\n * @return {function(new:Element, ...*)} a constructor for the new tag.\n * @deprecated document.registerElement() is deprecated in favor of\n *     customElements.define()\n */\nDocument.prototype.registerElement = function(type, options) {};\n\n/**\n * @see http://www.w3.org/TR/components-intro/\n * @see http://w3c.github.io/webcomponents/spec/custom/#extensions-to-document-interface-to-register\n * @param {string} type\n * @param {{extends: (string|undefined), prototype: (Object|undefined)}} options\n * @deprecated This method has been removed and will be removed soon from this file.\n */\nDocument.prototype.register = function(type, options) {};\n\n/**\n * @type {!FontFaceSet}\n * @see http://dev.w3.org/csswg/css-font-loading/#dom-fontfacesource-fonts\n */\nDocument.prototype.fonts;\n\n\n/**\n * @type {?HTMLScriptElement}\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Document/currentScript\n */\nDocument.prototype.currentScript;\n\n/**\n * Definition of ShadowRoot interface,\n * @see http://www.w3.org/TR/shadow-dom/#api-shadow-root\n * @constructor\n * @extends {DocumentFragment}\n */\nfunction ShadowRoot() {}\n\n/**\n * The host element that a ShadowRoot is attached to.\n * Note: this is not yet W3C standard but is undergoing development.\n * W3C feature tracking bug:\n * https://www.w3.org/Bugs/Public/show_bug.cgi?id=22399\n * Draft specification:\n * https://dvcs.w3.org/hg/webcomponents/raw-file/6743f1ace623/spec/shadow/index.html#shadow-root-object\n * @type {!Element}\n */\nShadowRoot.prototype.host;\n\n/**\n * @param {string} id id.\n * @return {HTMLElement}\n * @nosideeffects\n */\nShadowRoot.prototype.getElementById = function(id) {};\n\n\n/**\n * @return {Selection}\n * @nosideeffects\n */\nShadowRoot.prototype.getSelection = function() {};\n\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {Element}\n * @nosideeffects\n */\nShadowRoot.prototype.elementFromPoint = function(x, y) {};\n\n\n/**\n * @param {number} x\n * @param {number} y\n * @return {!IArrayLike<!Element>}\n * @nosideeffects\n */\nShadowRoot.prototype.elementsFromPoint = function(x, y) {};\n\n\n/**\n * @type {?Element}\n */\nShadowRoot.prototype.activeElement;\n\n\n/**\n * @type {string}\n */\nShadowRoot.prototype.mode;\n\n\n/**\n * @type {?ShadowRoot}\n * @deprecated\n */\nShadowRoot.prototype.olderShadowRoot;\n\n\n/**\n * @type {string}\n * @implicitCast\n */\nShadowRoot.prototype.innerHTML;\n\n\n/**\n * @type {!StyleSheetList}\n */\nShadowRoot.prototype.styleSheets;\n\n\n\n/**\n * @see http://www.w3.org/TR/shadow-dom/#the-content-element\n * @constructor\n * @extends {HTMLElement}\n */\nfunction HTMLContentElement() {}\n\n/**\n * @type {string}\n */\nHTMLContentElement.prototype.select;\n\n/**\n * @return {!NodeList<!Node>}\n */\nHTMLContentElement.prototype.getDistributedNodes = function() {};\n\n\n/**\n * @see http://www.w3.org/TR/shadow-dom/#the-shadow-element\n * @constructor\n * @extends {HTMLElement}\n */\nfunction HTMLShadowElement() {}\n\n/**\n * @return {!NodeList<!Node>}\n */\nHTMLShadowElement.prototype.getDistributedNodes = function() {};\n\n\n/**\n * @see http://www.w3.org/TR/html5/webappapis.html#the-errorevent-interface\n *\n * @constructor\n * @extends {Event}\n *\n * @param {string} type\n * @param {ErrorEventInit=} opt_eventInitDict\n */\nfunction ErrorEvent(type, opt_eventInitDict) {}\n\n/** @const {string} */\nErrorEvent.prototype.message;\n\n/** @const {string} */\nErrorEvent.prototype.filename;\n\n/** @const {number} */\nErrorEvent.prototype.lineno;\n\n/** @const {number} */\nErrorEvent.prototype.colno;\n\n/** @const {*} */\nErrorEvent.prototype.error;\n\n\n/**\n * @record\n * @extends {EventInit}\n * @see https://www.w3.org/TR/html5/webappapis.html#erroreventinit\n */\nfunction ErrorEventInit() {}\n\n/** @type {undefined|string} */\nErrorEventInit.prototype.message;\n\n/** @type {undefined|string} */\nErrorEventInit.prototype.filename;\n\n/** @type {undefined|number} */\nErrorEventInit.prototype.lineno;\n\n/** @type {undefined|number} */\nErrorEventInit.prototype.colno;\n\n/** @type {*} */\nErrorEventInit.prototype.error;\n\n\n/**\n * @see http://dom.spec.whatwg.org/#dom-domimplementation-createhtmldocument\n * @param {string=} opt_title A title to give the new HTML document\n * @return {!HTMLDocument}\n */\nDOMImplementation.prototype.createHTMLDocument = function(opt_title) {};\n\n\n\n/**\n * @constructor\n * @see https://html.spec.whatwg.org/multipage/embedded-content.html#the-picture-element\n * @extends {HTMLElement}\n */\nfunction HTMLPictureElement() {}\n\n/**\n * @constructor\n * @see https://html.spec.whatwg.org/multipage/embedded-content.html#the-picture-element\n * @extends {HTMLElement}\n */\nfunction HTMLSourceElement() {}\n\n/** @type {string} */\nHTMLSourceElement.prototype.media;\n\n/** @type {string} */\nHTMLSourceElement.prototype.sizes;\n\n/** @type {string} @implicitCast */\nHTMLSourceElement.prototype.src;\n\n/** @type {string} */\nHTMLSourceElement.prototype.srcset;\n\n/** @type {string} */\nHTMLSourceElement.prototype.type;\n\n/** @type {string} */\nHTMLImageElement.prototype.sizes;\n\n/** @type {string} */\nHTMLImageElement.prototype.srcset;\n\n\n/**\n * 4.11 Interactive elements\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html\n */\n\n/**\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html#the-details-element\n * @constructor\n * @extends {HTMLElement}\n */\nfunction HTMLDetailsElement() {}\n\n/**\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html#dom-details-open\n * @type {boolean}\n */\nHTMLDetailsElement.prototype.open;\n\n\n// As of 2/20/2015, <summary> has no special web IDL interface nor global\n// constructor (i.e. HTMLSummaryElement).\n\n\n/**\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html#dom-menu-type\n * @type {string}\n */\nHTMLMenuElement.prototype.type;\n\n/**\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html#dom-menu-label\n * @type {string}\n */\nHTMLMenuElement.prototype.label;\n\n\n/**\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html#the-menuitem-element\n * @constructor\n * @extends {HTMLElement}\n */\nfunction HTMLMenuItemElement() {}\n\n/**\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html#dom-menuit