// Copyright 2011 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

goog.module('goog.math.tdmaTest');
goog.setTestOnly();

const tdma = goog.require('goog.math.tdma');
const testSuite = goog.require('goog.testing.testSuite');

testSuite({
  testTdmaSolver() {
    const supDiag = [1, 1, 1, 1, 1];
    const mainDiag = [-1, -2, -2, -2, -2, -2];
    const subDiag = [1, 1, 1, 1, 1];
    const vecRight = [1, 2, 3, 4, 5, 6];
    const expected = [-56, -55, -52, -46, -36, -21];
    const result = [];
    tdma.solve(subDiag, mainDiag, supDiag, vecRight, result);
    assertElementsEquals(expected, result);
  },
});
