// Copyright 2019 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// AUTOGENERATED. DO NOT EDIT.
// clang-format off

goog.provide('goog.html.htmlTestVectors');
goog.setTestOnly();

goog.html.htmlTestVectors.HTML_TEST_VECTORS = [
    {input: "<body onload=alert('xss')>",
     acceptable: [
         "",
     ],
     name: "body_onload"},
    {input: "<form><input name=\"children\"></form>",
     acceptable: [
         "",
         "<form><input></form>",
     ],
     name: "clobbering_children"},
    {input: "<form><input name=\"firstChild\"></form>",
     acceptable: [
         "",
         "<form><input></form>",
     ],
     name: "clobbering_firstchild"},
    {input: "<form><input name=\"__proto__\"></form>",
     acceptable: [
         "",
         "<form><input></form>",
     ],
     name: "clobbering_proto"},
    {input: "<form><input name=\"tagName\"></form>",
     acceptable: [
         "",
     ],
     name: "clobbering_tagname"},
    {input: "<details open ontoggle=\"alert('xss')\">",
     acceptable: [
         "",
         "<details></details>",
         "<details open></details>",
         "<details open=\"\"></details>",
         "<DETAILS open=\"\" />",
         "<DETAILS open=\"\"></DETAILS>",
     ],
     name: "details"},
    {input: "<iframe src=\"javascript:alert('xss')\">",
     acceptable: [
         "",
         "<iframe></iframe>",
     ],
     name: "iframe_src"},
    {input: "<iframe srcdoc=\"&lt;img src&equals;x:x onerror&equals;alert&lpar;xss&rpar;&gt;\" />",
     acceptable: [
         "",
         "<iframe srcdoc=\"&lt;img src=&#34;about:invalid#zGoSafez&#34;/&gt;\"></iframe>",
         "<iframe srcdoc=\"&lt;img src=&quot;about:invalid#zCSafez&quot;&gt;\"></iframe>",
         "<iframe srcdoc=\"<img src=&quot;about:invalid#zCSafez&quot;>\"></iframe>",
     ],
     name: "iframe_srcdoc"},
    {input: "<img src=\"javascript:alert('xss');\">",
     acceptable: [
         "<img src=\"javascript:void(0);\">",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"about:invalid#zCSafez\">",
         "<img>",
         "<img />",
     ],
     name: "img"},
    {input: "<!--<img src=\"--><img src=x onerror=alert('xss')//\">",
     acceptable: [
         "<img />",
         "<img src=x>",
         "<img src=\"x\">",
         "<img src=\"x\"/>",
         "<img src=\"javascript:void(0);\">",
     ],
     name: "img_comment"},
    {input: "<img \"\"\"><script>alert('xss')</script>\">",
     acceptable: [
         "<img/>&#34;&gt;",
         "<img>&quot;&gt;",
         "<img>\"&gt;",
         "<img />\"&gt;",
     ],
     name: "img_malformed"},
    {input: "<img src=x onerror=\"alert('xxs')\">",
     acceptable: [
         "<img src=\"x\"/>",
         "<img src=\"x\">",
         "<img src=x>",
         "<img src=\"javascript:void(0);\">",
         "<img />",
     ],
     name: "img_onerror"},
    {input: "<img src=javascript:alert(&quot;XSS&quot;)>",
     acceptable: [
         "<img src=\"javascript:void(0);\">",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"about:invalid#zCSafez\">",
         "<img>",
         "<img />",
     ],
     name: "img_quot"},
    {input: "<style><img src=\"</style><img src=x onerror=alert('xss')//\">",
     acceptable: [
         "",
         "<img />",
         "<img src=x>",
         "<img src=\"x\"/>",
         "<img src=\"x\">",
         "<img src=\"javascript:void(0);\">",
     ],
     name: "img_style"},
    {input: "<img src=\"jav&#x09;ascript:alert('xss');\">",
     acceptable: [
         "<img src=\"javascript:void(0);\">",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"about:invalid#zCSafez\">",
         "<img>",
         "<img />",
     ],
     name: "img_tab"},
    {input: "<input type=\"image\" src=\"javascript:alert('xss');\">",
     acceptable: [
         "",
         "<input type=\"image\">",
         "<input type=\"image\" />",
         "<input type=\"image\" src=\"about:invalid#zCSafez\">",
     ],
     name: "input"},
    {input: "<a><a<a>a><a style=\"<a><a<a>a><a\"<a><a<a>a><a >",
     acceptable: [
         "<a>a&gt;<a>a&gt;<a></a></a></a>",
         "<a></a><a></a><a></a>",
         "<a><span>a&gt;</span></a><a><span>a&gt;</span></a><a></a>",
         "<a><span>a&gt;</span></a><a><span>a&gt;</span></a><a />",
     ],
     name: "mess_of_anchors"},
    {input: "<a><a></a></a>",
     acceptable: [
         "<a><a></a></a>",
         "<a></a><a></a>",
         "<a /><a />",
     ],
     name: "nested_anchors"},
    {input: "<object data=\"data:text/html;base64,PHNjcmlwdD5hbGVydCgxKTwvc2NyaXB0Pg==\"></object>",
     acceptable: [
         "",
     ],
     name: "object"},
    {input: "javascript:/*--></title></style></textarea></script></xmp><svg/onload='+/\"/+/onmouseover=1/+/[*/[]/+alert(xss)//'>",
     acceptable: [
         "javascript:/*--&gt;",
     ],
     name: "polygot"},
    {input: "javascript:x//*/javascript:javascript:\"/*'/*`/*--></noscript></title></textarea></style></template></noembed></script><html \" onmouseover=/*&lt;svg/*/onload=xonload=x//><svg onload=x><svg onload=x>*/</style><script>x</script><style>",
     acceptable: [
         "javascript:x//*/javascript:javascript:&quot;/*&#39;/*`/*--&gt;",
         "javascript:x//*/javascript:javascript:&#34;/*&#39;/*`/*--&gt;",
         "javascript:x//*/javascript:javascript:&quot;/*&#39;/*`/*--&gt;*/",
         "javascript:x//*/javascript:javascript:\"/*'/*`/*--&gt;",
         "javascript:x//*/javascript:javascript:\"/*'/*`/*--&gt;*/",
     ],
     name: "polygot_inquisition"},
    {input: "'\"",
     acceptable: [
         "'\"",
         "&#39;&quot;",
         "&#39;&#34;",
     ],
     name: "quotes"},
    {input: "<LINK REL=\"stylesheet\" HREF=\"javascript:alert('xss')\">",
     acceptable: [
         "",
         "<link rel=\"stylesheet\"/>",
         "<link rel=stylesheet>",
         "<link rel=\"stylesheet\">",
     ],
     name: "remote_stylesheet"},
    {input: "<STYLE>@import'javascript:alert('xss')';</STYLE>",
     acceptable: [
         "",
     ],
     name: "remote_stylesheet2"},
    {input: "<script>alert('xss')</script>",
     acceptable: [
         "",
     ],
     name: "script_alert"},
    {input: "<scrIpt>alert('xss')</scrIpt>",
     acceptable: [
         "",
     ],
     name: "script_case"},
    {input: "<<script>alert('xss');//<</script>",
     acceptable: [
         "&lt;",
     ],
     name: "script_extra"},
    {input: "<<s<script>script>alert()<</script>/script>",
     acceptable: [
         "&lt;",
         "&lt;script&gt;alert()&lt;/script&gt;",
         "&lt;<span>script&gt;alert()&lt;/script&gt;</span>",
     ],
     name: "script_inception"},
    {input: "<script/xss src=\"/xss.js\"><\\/script>",
     acceptable: [
         "",
     ],
     name: "script_nondigit"},
    {input: "<script src=\"/xss.js\"< b >",
     acceptable: [
         "",
     ],
     name: "script_open"},
    {input: "<script src=\"/xss.js\"></script>",
     acceptable: [
         "",
     ],
     name: "script_src"},
    {input: "</title><script>alert('xss');</script>",
     acceptable: [
         "",
     ],
     name: "script_title"},
    {input: "<svg onload=\"javascript:alert('xss')\" xmlns=\"http://www.google.com\"></svg>",
     acceptable: [
         "",
     ],
     name: "svg"},
    {input: "<img src=&#106;&#97;&#118;&#97;&#115;&#99;&#114;&#105;&#112;&#116;&#58;&#97;&#108;&#101;&#114;&#116;&#40;&#39;&#88;&#83;&#83;&#39;&#41;>",
     acceptable: [
         "<img src=\"javascript:void(0);\">",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"about:invalid#zCSafez\">",
         "<img>",
         "<img />",
     ],
     name: "unicode"},
    {input: "<html></html>",
     acceptable: [
         "<html>",
         "<html />",
         "<html></html>",
         "<table><html></html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_plain"},
    {input: "<html><script>alert()</script></html>",
     acceptable: [
         "<html>",
         "<html />",
         "<html></html>",
         "<table><html></html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<span></span>",
         "<span />",
         "",
         "<table><html><td></td></html></table>",
         "<table><html></html><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_html_scriptinside"},
    {input: "<html media=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_media"},
    {input: "<html nonce=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_nonce"},
    {input: "<html srcset=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_srcset"},
    {input: "<html srcdoc=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_srcdoc"},
    {input: "<html poster=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_poster"},
    {input: "<html autoplay=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_autoplay"},
    {input: "<html controls=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_controls"},
    {input: "<html formaction=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_formaction"},
    {input: "<html formmethod=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_formmethod"},
    {input: "<html pattern=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_pattern"},
    {input: "<html icon=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_icon"},
    {input: "<html select=\"x\">",
     acceptable: [
         "<html></html>",
         "<html>",
         "<html/>",
         "<html />",
         "<table><html></html></table>",
         "<table><html></table>",
         "<HTML />",
         "<HTML></HTML>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_html_select"},
    {input: "<head></head>",
     acceptable: [
         "<head>",
         "<head />",
         "<head></head>",
         "<table><head></head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_plain"},
    {input: "<head><script>alert()</script></head>",
     acceptable: [
         "<head>",
         "<head />",
         "<head></head>",
         "<table><head></head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<span></span>",
         "<span />",
         "",
         "<table><head><td></td></head></table>",
         "<table><head></head><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_head_scriptinside"},
    {input: "<head media=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_media"},
    {input: "<head nonce=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_nonce"},
    {input: "<head srcset=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_srcset"},
    {input: "<head srcdoc=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_srcdoc"},
    {input: "<head poster=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_poster"},
    {input: "<head autoplay=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_autoplay"},
    {input: "<head controls=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_controls"},
    {input: "<head formaction=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_formaction"},
    {input: "<head formmethod=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_formmethod"},
    {input: "<head pattern=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_pattern"},
    {input: "<head icon=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_icon"},
    {input: "<head select=\"x\">",
     acceptable: [
         "<head></head>",
         "<head>",
         "<head/>",
         "<head />",
         "<table><head></head></table>",
         "<table><head></table>",
         "<HEAD />",
         "<HEAD></HEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_head_select"},
    {input: "<title></title>",
     acceptable: [
         "<title></title>",
         "<title />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_plain"},
    {input: "<title><script>alert()</script></title>",
     acceptable: [
         "<title></title>",
         "<title />",
         "<span></span>",
         "<span />",
         "",
         "<title>&lt;script&gt;alert()&lt;/script&gt;</title>",
         "<span>&lt;script&gt;alert()&lt;/script&gt;</span>",
         "&lt;script&gt;alert()&lt;/script&gt;",
     ],
     name: "contract_title_scriptinside"},
    {input: "<title media=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_media"},
    {input: "<title nonce=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_nonce"},
    {input: "<title srcset=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_srcset"},
    {input: "<title srcdoc=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_srcdoc"},
    {input: "<title poster=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_poster"},
    {input: "<title autoplay=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_autoplay"},
    {input: "<title controls=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_controls"},
    {input: "<title formaction=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_formaction"},
    {input: "<title formmethod=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_formmethod"},
    {input: "<title pattern=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_pattern"},
    {input: "<title icon=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_icon"},
    {input: "<title select=\"x\">",
     acceptable: [
         "<title></title>",
         "<title>",
         "<title/>",
         "<title />",
         "<table><title></title></table>",
         "<table><title></table>",
         "<TITLE />",
         "<TITLE></TITLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_title_select"},
    {input: "<base></base>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_plain"},
    {input: "<base><script>alert()</script></base>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_scriptinside"},
    {input: "<base media=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_media"},
    {input: "<base nonce=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_nonce"},
    {input: "<base srcset=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_srcset"},
    {input: "<base srcdoc=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_srcdoc"},
    {input: "<base poster=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_poster"},
    {input: "<base autoplay=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_autoplay"},
    {input: "<base controls=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_controls"},
    {input: "<base formaction=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_formaction"},
    {input: "<base formmethod=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_formmethod"},
    {input: "<base pattern=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_pattern"},
    {input: "<base icon=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_icon"},
    {input: "<base select=\"x\">",
     acceptable: [
         "<base></base>",
         "<base>",
         "<base/>",
         "<base />",
         "<table><base></base></table>",
         "<table><base></table>",
         "<BASE />",
         "<BASE></BASE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_base_select"},
    {input: "<meta></meta>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_plain"},
    {input: "<meta><script>alert()</script></meta>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_scriptinside"},
    {input: "<meta media=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_media"},
    {input: "<meta nonce=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_nonce"},
    {input: "<meta srcset=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_srcset"},
    {input: "<meta srcdoc=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_srcdoc"},
    {input: "<meta poster=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_poster"},
    {input: "<meta autoplay=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_autoplay"},
    {input: "<meta controls=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_controls"},
    {input: "<meta formaction=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_formaction"},
    {input: "<meta formmethod=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_formmethod"},
    {input: "<meta pattern=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_pattern"},
    {input: "<meta icon=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_icon"},
    {input: "<meta select=\"x\">",
     acceptable: [
         "<meta></meta>",
         "<meta>",
         "<meta/>",
         "<meta />",
         "<table><meta></meta></table>",
         "<table><meta></table>",
         "<META />",
         "<META></META>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meta_select"},
    {input: "<style></style>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_plain"},
    {input: "<style><script>alert()</script></style>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_scriptinside"},
    {input: "<style srcset=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_srcset"},
    {input: "<style srcdoc=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_srcdoc"},
    {input: "<style poster=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_poster"},
    {input: "<style autoplay=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_autoplay"},
    {input: "<style controls=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_controls"},
    {input: "<style formaction=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_formaction"},
    {input: "<style formmethod=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_formmethod"},
    {input: "<style pattern=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_pattern"},
    {input: "<style icon=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_icon"},
    {input: "<style select=\"x\">",
     acceptable: [
         "<style></style>",
         "<style>",
         "<style/>",
         "<style />",
         "<table><style></style></table>",
         "<table><style></table>",
         "<STYLE />",
         "<STYLE></STYLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_style_select"},
    {input: "<body></body>",
     acceptable: [
         "<body>",
         "<body />",
         "<body></body>",
         "<table><body></body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_plain"},
    {input: "<body><script>alert()</script></body>",
     acceptable: [
         "<body>",
         "<body />",
         "<body></body>",
         "<table><body></body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<span></span>",
         "<span />",
         "",
         "<table><body><td></td></body></table>",
         "<table><body></body><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_body_scriptinside"},
    {input: "<body media=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_media"},
    {input: "<body nonce=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_nonce"},
    {input: "<body srcset=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_srcset"},
    {input: "<body srcdoc=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_srcdoc"},
    {input: "<body poster=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_poster"},
    {input: "<body autoplay=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_autoplay"},
    {input: "<body controls=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_controls"},
    {input: "<body formaction=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_formaction"},
    {input: "<body formmethod=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_formmethod"},
    {input: "<body pattern=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_pattern"},
    {input: "<body icon=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_icon"},
    {input: "<body select=\"x\">",
     acceptable: [
         "<body></body>",
         "<body>",
         "<body/>",
         "<body />",
         "<table><body></body></table>",
         "<table><body></table>",
         "<BODY />",
         "<BODY></BODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_body_select"},
    {input: "<article></article>",
     acceptable: [
         "<article>",
         "<article />",
         "<article></article>",
         "<table><article></article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_plain"},
    {input: "<article><script>alert()</script></article>",
     acceptable: [
         "<article>",
         "<article />",
         "<article></article>",
         "<table><article></article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<span></span>",
         "<span />",
         "",
         "<table><article><td></td></article></table>",
         "<table><article></article><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_article_scriptinside"},
    {input: "<article media=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_media"},
    {input: "<article nonce=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_nonce"},
    {input: "<article srcset=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_srcset"},
    {input: "<article srcdoc=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_srcdoc"},
    {input: "<article poster=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_poster"},
    {input: "<article autoplay=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_autoplay"},
    {input: "<article controls=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_controls"},
    {input: "<article formaction=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_formaction"},
    {input: "<article formmethod=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_formmethod"},
    {input: "<article pattern=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_pattern"},
    {input: "<article icon=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_icon"},
    {input: "<article select=\"x\">",
     acceptable: [
         "<article></article>",
         "<article>",
         "<article/>",
         "<article />",
         "<table><article></article></table>",
         "<table><article></table>",
         "<ARTICLE />",
         "<ARTICLE></ARTICLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_article_select"},
    {input: "<section></section>",
     acceptable: [
         "<section>",
         "<section />",
         "<section></section>",
         "<table><section></section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_plain"},
    {input: "<section><script>alert()</script></section>",
     acceptable: [
         "<section>",
         "<section />",
         "<section></section>",
         "<table><section></section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<span></span>",
         "<span />",
         "",
         "<table><section><td></td></section></table>",
         "<table><section></section><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_section_scriptinside"},
    {input: "<section media=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_media"},
    {input: "<section nonce=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_nonce"},
    {input: "<section srcset=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_srcset"},
    {input: "<section srcdoc=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_srcdoc"},
    {input: "<section poster=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_poster"},
    {input: "<section autoplay=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_autoplay"},
    {input: "<section controls=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_controls"},
    {input: "<section formaction=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_formaction"},
    {input: "<section formmethod=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_formmethod"},
    {input: "<section pattern=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_pattern"},
    {input: "<section icon=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_icon"},
    {input: "<section select=\"x\">",
     acceptable: [
         "<section></section>",
         "<section>",
         "<section/>",
         "<section />",
         "<table><section></section></table>",
         "<table><section></table>",
         "<SECTION />",
         "<SECTION></SECTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_section_select"},
    {input: "<nav></nav>",
     acceptable: [
         "<nav>",
         "<nav />",
         "<nav></nav>",
         "<table><nav></nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_plain"},
    {input: "<nav><script>alert()</script></nav>",
     acceptable: [
         "<nav>",
         "<nav />",
         "<nav></nav>",
         "<table><nav></nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<span></span>",
         "<span />",
         "",
         "<table><nav><td></td></nav></table>",
         "<table><nav></nav><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_nav_scriptinside"},
    {input: "<nav media=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_media"},
    {input: "<nav nonce=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_nonce"},
    {input: "<nav srcset=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_srcset"},
    {input: "<nav srcdoc=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_srcdoc"},
    {input: "<nav poster=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_poster"},
    {input: "<nav autoplay=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_autoplay"},
    {input: "<nav controls=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_controls"},
    {input: "<nav formaction=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_formaction"},
    {input: "<nav formmethod=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_formmethod"},
    {input: "<nav pattern=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_pattern"},
    {input: "<nav icon=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_icon"},
    {input: "<nav select=\"x\">",
     acceptable: [
         "<nav></nav>",
         "<nav>",
         "<nav/>",
         "<nav />",
         "<table><nav></nav></table>",
         "<table><nav></table>",
         "<NAV />",
         "<NAV></NAV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_nav_select"},
    {input: "<aside></aside>",
     acceptable: [
         "<aside>",
         "<aside />",
         "<aside></aside>",
         "<table><aside></aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_plain"},
    {input: "<aside><script>alert()</script></aside>",
     acceptable: [
         "<aside>",
         "<aside />",
         "<aside></aside>",
         "<table><aside></aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<span></span>",
         "<span />",
         "",
         "<table><aside><td></td></aside></table>",
         "<table><aside></aside><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_aside_scriptinside"},
    {input: "<aside media=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_media"},
    {input: "<aside nonce=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_nonce"},
    {input: "<aside srcset=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_srcset"},
    {input: "<aside srcdoc=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_srcdoc"},
    {input: "<aside poster=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_poster"},
    {input: "<aside autoplay=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_autoplay"},
    {input: "<aside controls=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_controls"},
    {input: "<aside formaction=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_formaction"},
    {input: "<aside formmethod=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_formmethod"},
    {input: "<aside pattern=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_pattern"},
    {input: "<aside icon=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_icon"},
    {input: "<aside select=\"x\">",
     acceptable: [
         "<aside></aside>",
         "<aside>",
         "<aside/>",
         "<aside />",
         "<table><aside></aside></table>",
         "<table><aside></table>",
         "<ASIDE />",
         "<ASIDE></ASIDE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_aside_select"},
    {input: "<h1></h1>",
     acceptable: [
         "<h1>",
         "<h1 />",
         "<h1></h1>",
         "<table><h1></h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_plain"},
    {input: "<h1><script>alert()</script></h1>",
     acceptable: [
         "<h1>",
         "<h1 />",
         "<h1></h1>",
         "<table><h1></h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<span></span>",
         "<span />",
         "",
         "<table><h1><td></td></h1></table>",
         "<table><h1></h1><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h1_scriptinside"},
    {input: "<h1 media=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_media"},
    {input: "<h1 nonce=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_nonce"},
    {input: "<h1 srcset=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_srcset"},
    {input: "<h1 srcdoc=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_srcdoc"},
    {input: "<h1 poster=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_poster"},
    {input: "<h1 autoplay=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_autoplay"},
    {input: "<h1 controls=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_controls"},
    {input: "<h1 formaction=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_formaction"},
    {input: "<h1 formmethod=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_formmethod"},
    {input: "<h1 pattern=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_pattern"},
    {input: "<h1 icon=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_icon"},
    {input: "<h1 select=\"x\">",
     acceptable: [
         "<h1></h1>",
         "<h1>",
         "<h1/>",
         "<h1 />",
         "<table><h1></h1></table>",
         "<table><h1></table>",
         "<H1 />",
         "<H1></H1>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h1_select"},
    {input: "<h2></h2>",
     acceptable: [
         "<h2>",
         "<h2 />",
         "<h2></h2>",
         "<table><h2></h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_plain"},
    {input: "<h2><script>alert()</script></h2>",
     acceptable: [
         "<h2>",
         "<h2 />",
         "<h2></h2>",
         "<table><h2></h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<span></span>",
         "<span />",
         "",
         "<table><h2><td></td></h2></table>",
         "<table><h2></h2><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h2_scriptinside"},
    {input: "<h2 media=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_media"},
    {input: "<h2 nonce=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_nonce"},
    {input: "<h2 srcset=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_srcset"},
    {input: "<h2 srcdoc=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_srcdoc"},
    {input: "<h2 poster=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_poster"},
    {input: "<h2 autoplay=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_autoplay"},
    {input: "<h2 controls=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_controls"},
    {input: "<h2 formaction=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_formaction"},
    {input: "<h2 formmethod=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_formmethod"},
    {input: "<h2 pattern=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_pattern"},
    {input: "<h2 icon=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_icon"},
    {input: "<h2 select=\"x\">",
     acceptable: [
         "<h2></h2>",
         "<h2>",
         "<h2/>",
         "<h2 />",
         "<table><h2></h2></table>",
         "<table><h2></table>",
         "<H2 />",
         "<H2></H2>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h2_select"},
    {input: "<h3></h3>",
     acceptable: [
         "<h3>",
         "<h3 />",
         "<h3></h3>",
         "<table><h3></h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_plain"},
    {input: "<h3><script>alert()</script></h3>",
     acceptable: [
         "<h3>",
         "<h3 />",
         "<h3></h3>",
         "<table><h3></h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<span></span>",
         "<span />",
         "",
         "<table><h3><td></td></h3></table>",
         "<table><h3></h3><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h3_scriptinside"},
    {input: "<h3 media=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_media"},
    {input: "<h3 nonce=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_nonce"},
    {input: "<h3 srcset=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_srcset"},
    {input: "<h3 srcdoc=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_srcdoc"},
    {input: "<h3 poster=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_poster"},
    {input: "<h3 autoplay=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_autoplay"},
    {input: "<h3 controls=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_controls"},
    {input: "<h3 formaction=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_formaction"},
    {input: "<h3 formmethod=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_formmethod"},
    {input: "<h3 pattern=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_pattern"},
    {input: "<h3 icon=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_icon"},
    {input: "<h3 select=\"x\">",
     acceptable: [
         "<h3></h3>",
         "<h3>",
         "<h3/>",
         "<h3 />",
         "<table><h3></h3></table>",
         "<table><h3></table>",
         "<H3 />",
         "<H3></H3>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h3_select"},
    {input: "<h4></h4>",
     acceptable: [
         "<h4>",
         "<h4 />",
         "<h4></h4>",
         "<table><h4></h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_plain"},
    {input: "<h4><script>alert()</script></h4>",
     acceptable: [
         "<h4>",
         "<h4 />",
         "<h4></h4>",
         "<table><h4></h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<span></span>",
         "<span />",
         "",
         "<table><h4><td></td></h4></table>",
         "<table><h4></h4><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h4_scriptinside"},
    {input: "<h4 media=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_media"},
    {input: "<h4 nonce=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_nonce"},
    {input: "<h4 srcset=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_srcset"},
    {input: "<h4 srcdoc=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_srcdoc"},
    {input: "<h4 poster=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_poster"},
    {input: "<h4 autoplay=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_autoplay"},
    {input: "<h4 controls=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_controls"},
    {input: "<h4 formaction=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_formaction"},
    {input: "<h4 formmethod=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_formmethod"},
    {input: "<h4 pattern=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_pattern"},
    {input: "<h4 icon=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_icon"},
    {input: "<h4 select=\"x\">",
     acceptable: [
         "<h4></h4>",
         "<h4>",
         "<h4/>",
         "<h4 />",
         "<table><h4></h4></table>",
         "<table><h4></table>",
         "<H4 />",
         "<H4></H4>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h4_select"},
    {input: "<h5></h5>",
     acceptable: [
         "<h5>",
         "<h5 />",
         "<h5></h5>",
         "<table><h5></h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_plain"},
    {input: "<h5><script>alert()</script></h5>",
     acceptable: [
         "<h5>",
         "<h5 />",
         "<h5></h5>",
         "<table><h5></h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<span></span>",
         "<span />",
         "",
         "<table><h5><td></td></h5></table>",
         "<table><h5></h5><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h5_scriptinside"},
    {input: "<h5 media=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_media"},
    {input: "<h5 nonce=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_nonce"},
    {input: "<h5 srcset=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_srcset"},
    {input: "<h5 srcdoc=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_srcdoc"},
    {input: "<h5 poster=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_poster"},
    {input: "<h5 autoplay=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_autoplay"},
    {input: "<h5 controls=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_controls"},
    {input: "<h5 formaction=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_formaction"},
    {input: "<h5 formmethod=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_formmethod"},
    {input: "<h5 pattern=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_pattern"},
    {input: "<h5 icon=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_icon"},
    {input: "<h5 select=\"x\">",
     acceptable: [
         "<h5></h5>",
         "<h5>",
         "<h5/>",
         "<h5 />",
         "<table><h5></h5></table>",
         "<table><h5></table>",
         "<H5 />",
         "<H5></H5>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h5_select"},
    {input: "<h6></h6>",
     acceptable: [
         "<h6>",
         "<h6 />",
         "<h6></h6>",
         "<table><h6></h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_plain"},
    {input: "<h6><script>alert()</script></h6>",
     acceptable: [
         "<h6>",
         "<h6 />",
         "<h6></h6>",
         "<table><h6></h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<span></span>",
         "<span />",
         "",
         "<table><h6><td></td></h6></table>",
         "<table><h6></h6><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_h6_scriptinside"},
    {input: "<h6 media=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_media"},
    {input: "<h6 nonce=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_nonce"},
    {input: "<h6 srcset=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_srcset"},
    {input: "<h6 srcdoc=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_srcdoc"},
    {input: "<h6 poster=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_poster"},
    {input: "<h6 autoplay=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_autoplay"},
    {input: "<h6 controls=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_controls"},
    {input: "<h6 formaction=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_formaction"},
    {input: "<h6 formmethod=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_formmethod"},
    {input: "<h6 pattern=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_pattern"},
    {input: "<h6 icon=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_icon"},
    {input: "<h6 select=\"x\">",
     acceptable: [
         "<h6></h6>",
         "<h6>",
         "<h6/>",
         "<h6 />",
         "<table><h6></h6></table>",
         "<table><h6></table>",
         "<H6 />",
         "<H6></H6>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_h6_select"},
    {input: "<header></header>",
     acceptable: [
         "<header>",
         "<header />",
         "<header></header>",
         "<table><header></header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_plain"},
    {input: "<header><script>alert()</script></header>",
     acceptable: [
         "<header>",
         "<header />",
         "<header></header>",
         "<table><header></header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<span></span>",
         "<span />",
         "",
         "<table><header><td></td></header></table>",
         "<table><header></header><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_header_scriptinside"},
    {input: "<header media=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_media"},
    {input: "<header nonce=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_nonce"},
    {input: "<header srcset=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_srcset"},
    {input: "<header srcdoc=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_srcdoc"},
    {input: "<header poster=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_poster"},
    {input: "<header autoplay=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_autoplay"},
    {input: "<header controls=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_controls"},
    {input: "<header formaction=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_formaction"},
    {input: "<header formmethod=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_formmethod"},
    {input: "<header pattern=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_pattern"},
    {input: "<header icon=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_icon"},
    {input: "<header select=\"x\">",
     acceptable: [
         "<header></header>",
         "<header>",
         "<header/>",
         "<header />",
         "<table><header></header></table>",
         "<table><header></table>",
         "<HEADER />",
         "<HEADER></HEADER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_header_select"},
    {input: "<footer></footer>",
     acceptable: [
         "<footer>",
         "<footer />",
         "<footer></footer>",
         "<table><footer></footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_plain"},
    {input: "<footer><script>alert()</script></footer>",
     acceptable: [
         "<footer>",
         "<footer />",
         "<footer></footer>",
         "<table><footer></footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<span></span>",
         "<span />",
         "",
         "<table><footer><td></td></footer></table>",
         "<table><footer></footer><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_footer_scriptinside"},
    {input: "<footer media=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_media"},
    {input: "<footer nonce=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_nonce"},
    {input: "<footer srcset=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_srcset"},
    {input: "<footer srcdoc=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_srcdoc"},
    {input: "<footer poster=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_poster"},
    {input: "<footer autoplay=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_autoplay"},
    {input: "<footer controls=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_controls"},
    {input: "<footer formaction=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_formaction"},
    {input: "<footer formmethod=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_formmethod"},
    {input: "<footer pattern=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_pattern"},
    {input: "<footer icon=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_icon"},
    {input: "<footer select=\"x\">",
     acceptable: [
         "<footer></footer>",
         "<footer>",
         "<footer/>",
         "<footer />",
         "<table><footer></footer></table>",
         "<table><footer></table>",
         "<FOOTER />",
         "<FOOTER></FOOTER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_footer_select"},
    {input: "<address></address>",
     acceptable: [
         "<address>",
         "<address />",
         "<address></address>",
         "<table><address></address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_plain"},
    {input: "<address><script>alert()</script></address>",
     acceptable: [
         "<address>",
         "<address />",
         "<address></address>",
         "<table><address></address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<span></span>",
         "<span />",
         "",
         "<table><address><td></td></address></table>",
         "<table><address></address><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_address_scriptinside"},
    {input: "<address media=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_media"},
    {input: "<address nonce=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_nonce"},
    {input: "<address srcset=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_srcset"},
    {input: "<address srcdoc=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_srcdoc"},
    {input: "<address poster=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_poster"},
    {input: "<address autoplay=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_autoplay"},
    {input: "<address controls=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_controls"},
    {input: "<address formaction=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_formaction"},
    {input: "<address formmethod=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_formmethod"},
    {input: "<address pattern=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_pattern"},
    {input: "<address icon=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_icon"},
    {input: "<address select=\"x\">",
     acceptable: [
         "<address></address>",
         "<address>",
         "<address/>",
         "<address />",
         "<table><address></address></table>",
         "<table><address></table>",
         "<ADDRESS />",
         "<ADDRESS></ADDRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_address_select"},
    {input: "<p></p>",
     acceptable: [
         "<p>",
         "<p />",
         "<p></p>",
         "<table><p></p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_plain"},
    {input: "<p><script>alert()</script></p>",
     acceptable: [
         "<p>",
         "<p />",
         "<p></p>",
         "<table><p></p></table>",
         "<P />",
         "<P></P>",
         "<span></span>",
         "<span />",
         "",
         "<table><p><td></td></p></table>",
         "<table><p></p><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_p_scriptinside"},
    {input: "<p media=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_media"},
    {input: "<p nonce=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_nonce"},
    {input: "<p srcset=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_srcset"},
    {input: "<p srcdoc=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_srcdoc"},
    {input: "<p poster=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_poster"},
    {input: "<p autoplay=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_autoplay"},
    {input: "<p controls=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_controls"},
    {input: "<p formaction=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_formaction"},
    {input: "<p formmethod=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_formmethod"},
    {input: "<p pattern=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_pattern"},
    {input: "<p icon=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_icon"},
    {input: "<p select=\"x\">",
     acceptable: [
         "<p></p>",
         "<p>",
         "<p/>",
         "<p />",
         "<table><p></p></table>",
         "<table><p></table>",
         "<P />",
         "<P></P>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_p_select"},
    {input: "<hr></hr>",
     acceptable: [
         "<hr>",
         "<hr />",
         "<hr/>",
         "<hr><hr>",
         "<hr/><hr/>",
         "<hr /><hr />",
         "<table><hr></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_plain"},
    {input: "<hr><script>alert()</script></hr>",
     acceptable: [
         "<hr>",
         "<hr />",
         "<hr/>",
         "<hr><hr>",
         "<hr/><hr/>",
         "<hr /><hr />",
         "<table><hr></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><hr><td></td></table>",
     ],
     name: "contract_hr_scriptinside"},
    {input: "<hr media=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_media"},
    {input: "<hr nonce=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_nonce"},
    {input: "<hr srcset=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_srcset"},
    {input: "<hr srcdoc=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_srcdoc"},
    {input: "<hr poster=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_poster"},
    {input: "<hr autoplay=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_autoplay"},
    {input: "<hr controls=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_controls"},
    {input: "<hr formaction=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_formaction"},
    {input: "<hr formmethod=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_formmethod"},
    {input: "<hr pattern=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_pattern"},
    {input: "<hr icon=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_icon"},
    {input: "<hr select=\"x\">",
     acceptable: [
         "<hr></hr>",
         "<hr>",
         "<hr/>",
         "<hr />",
         "<table><hr></hr></table>",
         "<table><hr></table>",
         "<HR />",
         "<HR></HR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_hr_select"},
    {input: "<pre></pre>",
     acceptable: [
         "<pre>",
         "<pre />",
         "<pre></pre>",
         "<table><pre></pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_plain"},
    {input: "<pre><script>alert()</script></pre>",
     acceptable: [
         "<pre>",
         "<pre />",
         "<pre></pre>",
         "<table><pre></pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<span></span>",
         "<span />",
         "",
         "<table><pre><td></td></pre></table>",
         "<table><pre></pre><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_pre_scriptinside"},
    {input: "<pre media=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_media"},
    {input: "<pre nonce=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_nonce"},
    {input: "<pre srcset=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_srcset"},
    {input: "<pre srcdoc=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_srcdoc"},
    {input: "<pre poster=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_poster"},
    {input: "<pre autoplay=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_autoplay"},
    {input: "<pre controls=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_controls"},
    {input: "<pre formaction=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_formaction"},
    {input: "<pre formmethod=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_formmethod"},
    {input: "<pre pattern=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_pattern"},
    {input: "<pre icon=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_icon"},
    {input: "<pre select=\"x\">",
     acceptable: [
         "<pre></pre>",
         "<pre>",
         "<pre/>",
         "<pre />",
         "<table><pre></pre></table>",
         "<table><pre></table>",
         "<PRE />",
         "<PRE></PRE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_pre_select"},
    {input: "<blockquote></blockquote>",
     acceptable: [
         "<blockquote>",
         "<blockquote />",
         "<blockquote></blockquote>",
         "<table><blockquote></blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_plain"},
    {input: "<blockquote><script>alert()</script></blockquote>",
     acceptable: [
         "<blockquote>",
         "<blockquote />",
         "<blockquote></blockquote>",
         "<table><blockquote></blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<span></span>",
         "<span />",
         "",
         "<table><blockquote><td></td></blockquote></table>",
         "<table><blockquote></blockquote><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_blockquote_scriptinside"},
    {input: "<blockquote cite=\"javascript:xss\">",
     acceptable: [
         "<blockquote cite=\"about:invalid#zCSafez\"></blockquote>",
         "<blockquote cite=\"about:invalid#zCSafez\">",
         "<blockquote cite=\"about:invalid#zGoSafez\"></blockquote>",
         "<blockquote cite=\"about:invalid#zGoSafez\"/>",
         "<blockquote cite=\"javascript:void(0);\"></blockquote>",
         "<blockquote cite=\"javascript:void(0);\">",
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_cite"},
    {input: "<blockquote media=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_media"},
    {input: "<blockquote nonce=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_nonce"},
    {input: "<blockquote srcset=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_srcset"},
    {input: "<blockquote srcdoc=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_srcdoc"},
    {input: "<blockquote poster=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_poster"},
    {input: "<blockquote autoplay=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_autoplay"},
    {input: "<blockquote controls=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_controls"},
    {input: "<blockquote formaction=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_formaction"},
    {input: "<blockquote formmethod=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_formmethod"},
    {input: "<blockquote pattern=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_pattern"},
    {input: "<blockquote icon=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_icon"},
    {input: "<blockquote select=\"x\">",
     acceptable: [
         "<blockquote></blockquote>",
         "<blockquote>",
         "<blockquote/>",
         "<blockquote />",
         "<table><blockquote></blockquote></table>",
         "<table><blockquote></table>",
         "<BLOCKQUOTE />",
         "<BLOCKQUOTE></BLOCKQUOTE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_blockquote_select"},
    {input: "<ol></ol>",
     acceptable: [
         "<ol>",
         "<ol />",
         "<ol></ol>",
         "<table><ol></ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_plain"},
    {input: "<ol><script>alert()</script></ol>",
     acceptable: [
         "<ol>",
         "<ol />",
         "<ol></ol>",
         "<table><ol></ol></table>",
         "<OL />",
         "<OL></OL>",
         "<span></span>",
         "<span />",
         "",
         "<table><ol><td></td></ol></table>",
         "<table><ol></ol><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_ol_scriptinside"},
    {input: "<ol media=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_media"},
    {input: "<ol nonce=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_nonce"},
    {input: "<ol srcset=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_srcset"},
    {input: "<ol srcdoc=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_srcdoc"},
    {input: "<ol poster=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_poster"},
    {input: "<ol autoplay=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_autoplay"},
    {input: "<ol controls=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_controls"},
    {input: "<ol formaction=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_formaction"},
    {input: "<ol formmethod=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_formmethod"},
    {input: "<ol pattern=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_pattern"},
    {input: "<ol icon=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_icon"},
    {input: "<ol select=\"x\">",
     acceptable: [
         "<ol></ol>",
         "<ol>",
         "<ol/>",
         "<ol />",
         "<table><ol></ol></table>",
         "<table><ol></table>",
         "<OL />",
         "<OL></OL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ol_select"},
    {input: "<ul></ul>",
     acceptable: [
         "<ul>",
         "<ul />",
         "<ul></ul>",
         "<table><ul></ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_plain"},
    {input: "<ul><script>alert()</script></ul>",
     acceptable: [
         "<ul>",
         "<ul />",
         "<ul></ul>",
         "<table><ul></ul></table>",
         "<UL />",
         "<UL></UL>",
         "<span></span>",
         "<span />",
         "",
         "<table><ul><td></td></ul></table>",
         "<table><ul></ul><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_ul_scriptinside"},
    {input: "<ul media=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_media"},
    {input: "<ul nonce=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_nonce"},
    {input: "<ul srcset=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_srcset"},
    {input: "<ul srcdoc=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_srcdoc"},
    {input: "<ul poster=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_poster"},
    {input: "<ul autoplay=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_autoplay"},
    {input: "<ul controls=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_controls"},
    {input: "<ul formaction=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_formaction"},
    {input: "<ul formmethod=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_formmethod"},
    {input: "<ul pattern=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_pattern"},
    {input: "<ul icon=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_icon"},
    {input: "<ul select=\"x\">",
     acceptable: [
         "<ul></ul>",
         "<ul>",
         "<ul/>",
         "<ul />",
         "<table><ul></ul></table>",
         "<table><ul></table>",
         "<UL />",
         "<UL></UL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ul_select"},
    {input: "<li></li>",
     acceptable: [
         "<li>",
         "<li />",
         "<li></li>",
         "<table><li></li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_plain"},
    {input: "<li><script>alert()</script></li>",
     acceptable: [
         "<li>",
         "<li />",
         "<li></li>",
         "<table><li></li></table>",
         "<LI />",
         "<LI></LI>",
         "<span></span>",
         "<span />",
         "",
         "<table><li><td></td></li></table>",
         "<table><li></li><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_li_scriptinside"},
    {input: "<li media=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_media"},
    {input: "<li nonce=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_nonce"},
    {input: "<li srcset=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_srcset"},
    {input: "<li srcdoc=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_srcdoc"},
    {input: "<li poster=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_poster"},
    {input: "<li autoplay=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_autoplay"},
    {input: "<li controls=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_controls"},
    {input: "<li formaction=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_formaction"},
    {input: "<li formmethod=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_formmethod"},
    {input: "<li pattern=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_pattern"},
    {input: "<li icon=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_icon"},
    {input: "<li select=\"x\">",
     acceptable: [
         "<li></li>",
         "<li>",
         "<li/>",
         "<li />",
         "<table><li></li></table>",
         "<table><li></table>",
         "<LI />",
         "<LI></LI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_li_select"},
    {input: "<dl></dl>",
     acceptable: [
         "<dl>",
         "<dl />",
         "<dl></dl>",
         "<table><dl></dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_plain"},
    {input: "<dl><script>alert()</script></dl>",
     acceptable: [
         "<dl>",
         "<dl />",
         "<dl></dl>",
         "<table><dl></dl></table>",
         "<DL />",
         "<DL></DL>",
         "<span></span>",
         "<span />",
         "",
         "<table><dl><td></td></dl></table>",
         "<table><dl></dl><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dl_scriptinside"},
    {input: "<dl media=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_media"},
    {input: "<dl nonce=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_nonce"},
    {input: "<dl srcset=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_srcset"},
    {input: "<dl srcdoc=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_srcdoc"},
    {input: "<dl poster=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_poster"},
    {input: "<dl autoplay=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_autoplay"},
    {input: "<dl controls=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_controls"},
    {input: "<dl formaction=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_formaction"},
    {input: "<dl formmethod=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_formmethod"},
    {input: "<dl pattern=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_pattern"},
    {input: "<dl icon=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_icon"},
    {input: "<dl select=\"x\">",
     acceptable: [
         "<dl></dl>",
         "<dl>",
         "<dl/>",
         "<dl />",
         "<table><dl></dl></table>",
         "<table><dl></table>",
         "<DL />",
         "<DL></DL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dl_select"},
    {input: "<dt></dt>",
     acceptable: [
         "<dt>",
         "<dt />",
         "<dt></dt>",
         "<table><dt></dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_plain"},
    {input: "<dt><script>alert()</script></dt>",
     acceptable: [
         "<dt>",
         "<dt />",
         "<dt></dt>",
         "<table><dt></dt></table>",
         "<DT />",
         "<DT></DT>",
         "<span></span>",
         "<span />",
         "",
         "<table><dt><td></td></dt></table>",
         "<table><dt></dt><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dt_scriptinside"},
    {input: "<dt media=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_media"},
    {input: "<dt nonce=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_nonce"},
    {input: "<dt srcset=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_srcset"},
    {input: "<dt srcdoc=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_srcdoc"},
    {input: "<dt poster=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_poster"},
    {input: "<dt autoplay=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_autoplay"},
    {input: "<dt controls=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_controls"},
    {input: "<dt formaction=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_formaction"},
    {input: "<dt formmethod=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_formmethod"},
    {input: "<dt pattern=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_pattern"},
    {input: "<dt icon=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_icon"},
    {input: "<dt select=\"x\">",
     acceptable: [
         "<dt></dt>",
         "<dt>",
         "<dt/>",
         "<dt />",
         "<table><dt></dt></table>",
         "<table><dt></table>",
         "<DT />",
         "<DT></DT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dt_select"},
    {input: "<dd></dd>",
     acceptable: [
         "<dd>",
         "<dd />",
         "<dd></dd>",
         "<table><dd></dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_plain"},
    {input: "<dd><script>alert()</script></dd>",
     acceptable: [
         "<dd>",
         "<dd />",
         "<dd></dd>",
         "<table><dd></dd></table>",
         "<DD />",
         "<DD></DD>",
         "<span></span>",
         "<span />",
         "",
         "<table><dd><td></td></dd></table>",
         "<table><dd></dd><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dd_scriptinside"},
    {input: "<dd media=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_media"},
    {input: "<dd nonce=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_nonce"},
    {input: "<dd srcset=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_srcset"},
    {input: "<dd srcdoc=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_srcdoc"},
    {input: "<dd poster=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_poster"},
    {input: "<dd autoplay=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_autoplay"},
    {input: "<dd controls=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_controls"},
    {input: "<dd formaction=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_formaction"},
    {input: "<dd formmethod=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_formmethod"},
    {input: "<dd pattern=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_pattern"},
    {input: "<dd icon=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_icon"},
    {input: "<dd select=\"x\">",
     acceptable: [
         "<dd></dd>",
         "<dd>",
         "<dd/>",
         "<dd />",
         "<table><dd></dd></table>",
         "<table><dd></table>",
         "<DD />",
         "<DD></DD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dd_select"},
    {input: "<figure></figure>",
     acceptable: [
         "<figure>",
         "<figure />",
         "<figure></figure>",
         "<table><figure></figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_plain"},
    {input: "<figure><script>alert()</script></figure>",
     acceptable: [
         "<figure>",
         "<figure />",
         "<figure></figure>",
         "<table><figure></figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<span></span>",
         "<span />",
         "",
         "<table><figure><td></td></figure></table>",
         "<table><figure></figure><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_figure_scriptinside"},
    {input: "<figure media=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_media"},
    {input: "<figure nonce=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_nonce"},
    {input: "<figure srcset=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_srcset"},
    {input: "<figure srcdoc=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_srcdoc"},
    {input: "<figure poster=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_poster"},
    {input: "<figure autoplay=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_autoplay"},
    {input: "<figure controls=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_controls"},
    {input: "<figure formaction=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_formaction"},
    {input: "<figure formmethod=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_formmethod"},
    {input: "<figure pattern=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_pattern"},
    {input: "<figure icon=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_icon"},
    {input: "<figure select=\"x\">",
     acceptable: [
         "<figure></figure>",
         "<figure>",
         "<figure/>",
         "<figure />",
         "<table><figure></figure></table>",
         "<table><figure></table>",
         "<FIGURE />",
         "<FIGURE></FIGURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figure_select"},
    {input: "<figcaption></figcaption>",
     acceptable: [
         "<figcaption>",
         "<figcaption />",
         "<figcaption></figcaption>",
         "<table><figcaption></figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_plain"},
    {input: "<figcaption><script>alert()</script></figcaption>",
     acceptable: [
         "<figcaption>",
         "<figcaption />",
         "<figcaption></figcaption>",
         "<table><figcaption></figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<span></span>",
         "<span />",
         "",
         "<table><figcaption><td></td></figcaption></table>",
         "<table><figcaption></figcaption><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_figcaption_scriptinside"},
    {input: "<figcaption media=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_media"},
    {input: "<figcaption nonce=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_nonce"},
    {input: "<figcaption srcset=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_srcset"},
    {input: "<figcaption srcdoc=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_srcdoc"},
    {input: "<figcaption poster=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_poster"},
    {input: "<figcaption autoplay=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_autoplay"},
    {input: "<figcaption controls=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_controls"},
    {input: "<figcaption formaction=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_formaction"},
    {input: "<figcaption formmethod=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_formmethod"},
    {input: "<figcaption pattern=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_pattern"},
    {input: "<figcaption icon=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_icon"},
    {input: "<figcaption select=\"x\">",
     acceptable: [
         "<figcaption></figcaption>",
         "<figcaption>",
         "<figcaption/>",
         "<figcaption />",
         "<table><figcaption></figcaption></table>",
         "<table><figcaption></table>",
         "<FIGCAPTION />",
         "<FIGCAPTION></FIGCAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_figcaption_select"},
    {input: "<main></main>",
     acceptable: [
         "<main>",
         "<main />",
         "<main></main>",
         "<table><main></main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_plain"},
    {input: "<main><script>alert()</script></main>",
     acceptable: [
         "<main>",
         "<main />",
         "<main></main>",
         "<table><main></main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<span></span>",
         "<span />",
         "",
         "<table><main><td></td></main></table>",
         "<table><main></main><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_main_scriptinside"},
    {input: "<main media=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_media"},
    {input: "<main nonce=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_nonce"},
    {input: "<main srcset=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_srcset"},
    {input: "<main srcdoc=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_srcdoc"},
    {input: "<main poster=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_poster"},
    {input: "<main autoplay=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_autoplay"},
    {input: "<main controls=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_controls"},
    {input: "<main formaction=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_formaction"},
    {input: "<main formmethod=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_formmethod"},
    {input: "<main pattern=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_pattern"},
    {input: "<main icon=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_icon"},
    {input: "<main select=\"x\">",
     acceptable: [
         "<main></main>",
         "<main>",
         "<main/>",
         "<main />",
         "<table><main></main></table>",
         "<table><main></table>",
         "<MAIN />",
         "<MAIN></MAIN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_main_select"},
    {input: "<div></div>",
     acceptable: [
         "<div>",
         "<div />",
         "<div></div>",
         "<table><div></div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_plain"},
    {input: "<div><script>alert()</script></div>",
     acceptable: [
         "<div>",
         "<div />",
         "<div></div>",
         "<table><div></div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<span></span>",
         "<span />",
         "",
         "<table><div><td></td></div></table>",
         "<table><div></div><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_div_scriptinside"},
    {input: "<div media=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_media"},
    {input: "<div nonce=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_nonce"},
    {input: "<div srcset=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_srcset"},
    {input: "<div srcdoc=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_srcdoc"},
    {input: "<div poster=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_poster"},
    {input: "<div autoplay=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_autoplay"},
    {input: "<div controls=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_controls"},
    {input: "<div formaction=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_formaction"},
    {input: "<div formmethod=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_formmethod"},
    {input: "<div pattern=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_pattern"},
    {input: "<div icon=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_icon"},
    {input: "<div select=\"x\">",
     acceptable: [
         "<div></div>",
         "<div>",
         "<div/>",
         "<div />",
         "<table><div></div></table>",
         "<table><div></table>",
         "<DIV />",
         "<DIV></DIV>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_div_select"},
    {input: "<a></a>",
     acceptable: [
         "<a>",
         "<a />",
         "<a></a>",
         "<table><a></a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_plain"},
    {input: "<a><script>alert()</script></a>",
     acceptable: [
         "<a>",
         "<a />",
         "<a></a>",
         "<table><a></a></table>",
         "<A />",
         "<A></A>",
         "<span></span>",
         "<span />",
         "",
         "<table><a><td></td></a></table>",
         "<table><a></a><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_a_scriptinside"},
    {input: "<a href=\"javascript:xss\">",
     acceptable: [
         "<a href=\"about:invalid#zCSafez\"></a>",
         "<a href=\"about:invalid#zCSafez\">",
         "<a href=\"about:invalid#zGoSafez\"></a>",
         "<a href=\"about:invalid#zGoSafez\"/>",
         "<a href=\"javascript:void(0);\"></a>",
         "<a href=\"javascript:void(0);\">",
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_href"},
    {input: "<a media=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_media"},
    {input: "<a nonce=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_nonce"},
    {input: "<a srcset=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_srcset"},
    {input: "<a srcdoc=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_srcdoc"},
    {input: "<a poster=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_poster"},
    {input: "<a autoplay=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_autoplay"},
    {input: "<a controls=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_controls"},
    {input: "<a formaction=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_formaction"},
    {input: "<a formmethod=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_formmethod"},
    {input: "<a pattern=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_pattern"},
    {input: "<a icon=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_icon"},
    {input: "<a select=\"x\">",
     acceptable: [
         "<a></a>",
         "<a>",
         "<a/>",
         "<a />",
         "<table><a></a></table>",
         "<table><a></table>",
         "<A />",
         "<A></A>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_a_select"},
    {input: "<area></area>",
     acceptable: [
         "<area>",
         "<area />",
         "<area/>",
         "<area><area>",
         "<area/><area/>",
         "<area /><area />",
         "<table><area></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_plain"},
    {input: "<area><script>alert()</script></area>",
     acceptable: [
         "<area>",
         "<area />",
         "<area/>",
         "<area><area>",
         "<area/><area/>",
         "<area /><area />",
         "<table><area></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><area><td></td></table>",
     ],
     name: "contract_area_scriptinside"},
    {input: "<area href=\"javascript:xss\">",
     acceptable: [
         "<area href=\"about:invalid#zCSafez\"></area>",
         "<area href=\"about:invalid#zCSafez\">",
         "<area href=\"about:invalid#zGoSafez\"></area>",
         "<area href=\"about:invalid#zGoSafez\"/>",
         "<area href=\"javascript:void(0);\"></area>",
         "<area href=\"javascript:void(0);\">",
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_href"},
    {input: "<area media=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_media"},
    {input: "<area nonce=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_nonce"},
    {input: "<area srcset=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_srcset"},
    {input: "<area srcdoc=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_srcdoc"},
    {input: "<area poster=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_poster"},
    {input: "<area autoplay=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_autoplay"},
    {input: "<area controls=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_controls"},
    {input: "<area formaction=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_formaction"},
    {input: "<area formmethod=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_formmethod"},
    {input: "<area pattern=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_pattern"},
    {input: "<area icon=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_icon"},
    {input: "<area select=\"x\">",
     acceptable: [
         "<area></area>",
         "<area>",
         "<area/>",
         "<area />",
         "<table><area></area></table>",
         "<table><area></table>",
         "<AREA />",
         "<AREA></AREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_area_select"},
    {input: "<em></em>",
     acceptable: [
         "<em>",
         "<em />",
         "<em></em>",
         "<table><em></em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_plain"},
    {input: "<em><script>alert()</script></em>",
     acceptable: [
         "<em>",
         "<em />",
         "<em></em>",
         "<table><em></em></table>",
         "<EM />",
         "<EM></EM>",
         "<span></span>",
         "<span />",
         "",
         "<table><em><td></td></em></table>",
         "<table><em></em><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_em_scriptinside"},
    {input: "<em media=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_media"},
    {input: "<em nonce=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_nonce"},
    {input: "<em srcset=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_srcset"},
    {input: "<em srcdoc=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_srcdoc"},
    {input: "<em poster=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_poster"},
    {input: "<em autoplay=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_autoplay"},
    {input: "<em controls=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_controls"},
    {input: "<em formaction=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_formaction"},
    {input: "<em formmethod=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_formmethod"},
    {input: "<em pattern=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_pattern"},
    {input: "<em icon=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_icon"},
    {input: "<em select=\"x\">",
     acceptable: [
         "<em></em>",
         "<em>",
         "<em/>",
         "<em />",
         "<table><em></em></table>",
         "<table><em></table>",
         "<EM />",
         "<EM></EM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_em_select"},
    {input: "<strong></strong>",
     acceptable: [
         "<strong>",
         "<strong />",
         "<strong></strong>",
         "<table><strong></strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_plain"},
    {input: "<strong><script>alert()</script></strong>",
     acceptable: [
         "<strong>",
         "<strong />",
         "<strong></strong>",
         "<table><strong></strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<span></span>",
         "<span />",
         "",
         "<table><strong><td></td></strong></table>",
         "<table><strong></strong><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_strong_scriptinside"},
    {input: "<strong media=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_media"},
    {input: "<strong nonce=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_nonce"},
    {input: "<strong srcset=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_srcset"},
    {input: "<strong srcdoc=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_srcdoc"},
    {input: "<strong poster=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_poster"},
    {input: "<strong autoplay=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_autoplay"},
    {input: "<strong controls=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_controls"},
    {input: "<strong formaction=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_formaction"},
    {input: "<strong formmethod=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_formmethod"},
    {input: "<strong pattern=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_pattern"},
    {input: "<strong icon=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_icon"},
    {input: "<strong select=\"x\">",
     acceptable: [
         "<strong></strong>",
         "<strong>",
         "<strong/>",
         "<strong />",
         "<table><strong></strong></table>",
         "<table><strong></table>",
         "<STRONG />",
         "<STRONG></STRONG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_strong_select"},
    {input: "<small></small>",
     acceptable: [
         "<small>",
         "<small />",
         "<small></small>",
         "<table><small></small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_plain"},
    {input: "<small><script>alert()</script></small>",
     acceptable: [
         "<small>",
         "<small />",
         "<small></small>",
         "<table><small></small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<span></span>",
         "<span />",
         "",
         "<table><small><td></td></small></table>",
         "<table><small></small><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_small_scriptinside"},
    {input: "<small media=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_media"},
    {input: "<small nonce=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_nonce"},
    {input: "<small srcset=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_srcset"},
    {input: "<small srcdoc=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_srcdoc"},
    {input: "<small poster=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_poster"},
    {input: "<small autoplay=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_autoplay"},
    {input: "<small controls=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_controls"},
    {input: "<small formaction=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_formaction"},
    {input: "<small formmethod=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_formmethod"},
    {input: "<small pattern=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_pattern"},
    {input: "<small icon=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_icon"},
    {input: "<small select=\"x\">",
     acceptable: [
         "<small></small>",
         "<small>",
         "<small/>",
         "<small />",
         "<table><small></small></table>",
         "<table><small></table>",
         "<SMALL />",
         "<SMALL></SMALL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_small_select"},
    {input: "<s></s>",
     acceptable: [
         "<s>",
         "<s />",
         "<s></s>",
         "<table><s></s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_plain"},
    {input: "<s><script>alert()</script></s>",
     acceptable: [
         "<s>",
         "<s />",
         "<s></s>",
         "<table><s></s></table>",
         "<S />",
         "<S></S>",
         "<span></span>",
         "<span />",
         "",
         "<table><s><td></td></s></table>",
         "<table><s></s><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_s_scriptinside"},
    {input: "<s media=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_media"},
    {input: "<s nonce=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_nonce"},
    {input: "<s srcset=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_srcset"},
    {input: "<s srcdoc=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_srcdoc"},
    {input: "<s poster=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_poster"},
    {input: "<s autoplay=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_autoplay"},
    {input: "<s controls=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_controls"},
    {input: "<s formaction=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_formaction"},
    {input: "<s formmethod=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_formmethod"},
    {input: "<s pattern=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_pattern"},
    {input: "<s icon=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_icon"},
    {input: "<s select=\"x\">",
     acceptable: [
         "<s></s>",
         "<s>",
         "<s/>",
         "<s />",
         "<table><s></s></table>",
         "<table><s></table>",
         "<S />",
         "<S></S>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_s_select"},
    {input: "<cite></cite>",
     acceptable: [
         "<cite>",
         "<cite />",
         "<cite></cite>",
         "<table><cite></cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_plain"},
    {input: "<cite><script>alert()</script></cite>",
     acceptable: [
         "<cite>",
         "<cite />",
         "<cite></cite>",
         "<table><cite></cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<span></span>",
         "<span />",
         "",
         "<table><cite><td></td></cite></table>",
         "<table><cite></cite><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_cite_scriptinside"},
    {input: "<cite media=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_media"},
    {input: "<cite nonce=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_nonce"},
    {input: "<cite srcset=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_srcset"},
    {input: "<cite srcdoc=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_srcdoc"},
    {input: "<cite poster=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_poster"},
    {input: "<cite autoplay=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_autoplay"},
    {input: "<cite controls=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_controls"},
    {input: "<cite formaction=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_formaction"},
    {input: "<cite formmethod=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_formmethod"},
    {input: "<cite pattern=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_pattern"},
    {input: "<cite icon=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_icon"},
    {input: "<cite select=\"x\">",
     acceptable: [
         "<cite></cite>",
         "<cite>",
         "<cite/>",
         "<cite />",
         "<table><cite></cite></table>",
         "<table><cite></table>",
         "<CITE />",
         "<CITE></CITE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_cite_select"},
    {input: "<q></q>",
     acceptable: [
         "<q>",
         "<q />",
         "<q></q>",
         "<table><q></q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_plain"},
    {input: "<q><script>alert()</script></q>",
     acceptable: [
         "<q>",
         "<q />",
         "<q></q>",
         "<table><q></q></table>",
         "<Q />",
         "<Q></Q>",
         "<span></span>",
         "<span />",
         "",
         "<table><q><td></td></q></table>",
         "<table><q></q><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_q_scriptinside"},
    {input: "<q cite=\"javascript:xss\">",
     acceptable: [
         "<q cite=\"about:invalid#zCSafez\"></q>",
         "<q cite=\"about:invalid#zCSafez\">",
         "<q cite=\"about:invalid#zGoSafez\"></q>",
         "<q cite=\"about:invalid#zGoSafez\"/>",
         "<q cite=\"javascript:void(0);\"></q>",
         "<q cite=\"javascript:void(0);\">",
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_cite"},
    {input: "<q media=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_media"},
    {input: "<q nonce=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_nonce"},
    {input: "<q srcset=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_srcset"},
    {input: "<q srcdoc=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_srcdoc"},
    {input: "<q poster=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_poster"},
    {input: "<q autoplay=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_autoplay"},
    {input: "<q controls=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_controls"},
    {input: "<q formaction=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_formaction"},
    {input: "<q formmethod=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_formmethod"},
    {input: "<q pattern=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_pattern"},
    {input: "<q icon=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_icon"},
    {input: "<q select=\"x\">",
     acceptable: [
         "<q></q>",
         "<q>",
         "<q/>",
         "<q />",
         "<table><q></q></table>",
         "<table><q></table>",
         "<Q />",
         "<Q></Q>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_q_select"},
    {input: "<dfn></dfn>",
     acceptable: [
         "<dfn>",
         "<dfn />",
         "<dfn></dfn>",
         "<table><dfn></dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_plain"},
    {input: "<dfn><script>alert()</script></dfn>",
     acceptable: [
         "<dfn>",
         "<dfn />",
         "<dfn></dfn>",
         "<table><dfn></dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<span></span>",
         "<span />",
         "",
         "<table><dfn><td></td></dfn></table>",
         "<table><dfn></dfn><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dfn_scriptinside"},
    {input: "<dfn media=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_media"},
    {input: "<dfn nonce=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_nonce"},
    {input: "<dfn srcset=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_srcset"},
    {input: "<dfn srcdoc=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_srcdoc"},
    {input: "<dfn poster=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_poster"},
    {input: "<dfn autoplay=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_autoplay"},
    {input: "<dfn controls=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_controls"},
    {input: "<dfn formaction=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_formaction"},
    {input: "<dfn formmethod=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_formmethod"},
    {input: "<dfn pattern=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_pattern"},
    {input: "<dfn icon=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_icon"},
    {input: "<dfn select=\"x\">",
     acceptable: [
         "<dfn></dfn>",
         "<dfn>",
         "<dfn/>",
         "<dfn />",
         "<table><dfn></dfn></table>",
         "<table><dfn></table>",
         "<DFN />",
         "<DFN></DFN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dfn_select"},
    {input: "<abbr></abbr>",
     acceptable: [
         "<abbr>",
         "<abbr />",
         "<abbr></abbr>",
         "<table><abbr></abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_plain"},
    {input: "<abbr><script>alert()</script></abbr>",
     acceptable: [
         "<abbr>",
         "<abbr />",
         "<abbr></abbr>",
         "<table><abbr></abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<span></span>",
         "<span />",
         "",
         "<table><abbr><td></td></abbr></table>",
         "<table><abbr></abbr><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_abbr_scriptinside"},
    {input: "<abbr media=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_media"},
    {input: "<abbr nonce=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_nonce"},
    {input: "<abbr srcset=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_srcset"},
    {input: "<abbr srcdoc=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_srcdoc"},
    {input: "<abbr poster=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_poster"},
    {input: "<abbr autoplay=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_autoplay"},
    {input: "<abbr controls=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_controls"},
    {input: "<abbr formaction=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_formaction"},
    {input: "<abbr formmethod=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_formmethod"},
    {input: "<abbr pattern=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_pattern"},
    {input: "<abbr icon=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_icon"},
    {input: "<abbr select=\"x\">",
     acceptable: [
         "<abbr></abbr>",
         "<abbr>",
         "<abbr/>",
         "<abbr />",
         "<table><abbr></abbr></table>",
         "<table><abbr></table>",
         "<ABBR />",
         "<ABBR></ABBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_abbr_select"},
    {input: "<ruby></ruby>",
     acceptable: [
         "<ruby>",
         "<ruby />",
         "<ruby></ruby>",
         "<table><ruby></ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_plain"},
    {input: "<ruby><script>alert()</script></ruby>",
     acceptable: [
         "<ruby>",
         "<ruby />",
         "<ruby></ruby>",
         "<table><ruby></ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<span></span>",
         "<span />",
         "",
         "<table><ruby><td></td></ruby></table>",
         "<table><ruby></ruby><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_ruby_scriptinside"},
    {input: "<ruby media=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_media"},
    {input: "<ruby nonce=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_nonce"},
    {input: "<ruby srcset=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_srcset"},
    {input: "<ruby srcdoc=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_srcdoc"},
    {input: "<ruby poster=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_poster"},
    {input: "<ruby autoplay=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_autoplay"},
    {input: "<ruby controls=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_controls"},
    {input: "<ruby formaction=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_formaction"},
    {input: "<ruby formmethod=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_formmethod"},
    {input: "<ruby pattern=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_pattern"},
    {input: "<ruby icon=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_icon"},
    {input: "<ruby select=\"x\">",
     acceptable: [
         "<ruby></ruby>",
         "<ruby>",
         "<ruby/>",
         "<ruby />",
         "<table><ruby></ruby></table>",
         "<table><ruby></table>",
         "<RUBY />",
         "<RUBY></RUBY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ruby_select"},
    {input: "<rb></rb>",
     acceptable: [
         "<rb>",
         "<rb />",
         "<rb></rb>",
         "<table><rb></rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_plain"},
    {input: "<rb><script>alert()</script></rb>",
     acceptable: [
         "<rb>",
         "<rb />",
         "<rb></rb>",
         "<table><rb></rb></table>",
         "<RB />",
         "<RB></RB>",
         "<span></span>",
         "<span />",
         "",
         "<table><rb><td></td></rb></table>",
         "<table><rb></rb><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_rb_scriptinside"},
    {input: "<rb media=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_media"},
    {input: "<rb nonce=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_nonce"},
    {input: "<rb srcset=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_srcset"},
    {input: "<rb srcdoc=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_srcdoc"},
    {input: "<rb poster=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_poster"},
    {input: "<rb autoplay=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_autoplay"},
    {input: "<rb controls=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_controls"},
    {input: "<rb formaction=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_formaction"},
    {input: "<rb formmethod=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_formmethod"},
    {input: "<rb pattern=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_pattern"},
    {input: "<rb icon=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_icon"},
    {input: "<rb select=\"x\">",
     acceptable: [
         "<rb></rb>",
         "<rb>",
         "<rb/>",
         "<rb />",
         "<table><rb></rb></table>",
         "<table><rb></table>",
         "<RB />",
         "<RB></RB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rb_select"},
    {input: "<rt></rt>",
     acceptable: [
         "<rt>",
         "<rt />",
         "<rt></rt>",
         "<table><rt></rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_plain"},
    {input: "<rt><script>alert()</script></rt>",
     acceptable: [
         "<rt>",
         "<rt />",
         "<rt></rt>",
         "<table><rt></rt></table>",
         "<RT />",
         "<RT></RT>",
         "<span></span>",
         "<span />",
         "",
         "<table><rt><td></td></rt></table>",
         "<table><rt></rt><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_rt_scriptinside"},
    {input: "<rt media=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_media"},
    {input: "<rt nonce=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_nonce"},
    {input: "<rt srcset=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_srcset"},
    {input: "<rt srcdoc=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_srcdoc"},
    {input: "<rt poster=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_poster"},
    {input: "<rt autoplay=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_autoplay"},
    {input: "<rt controls=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_controls"},
    {input: "<rt formaction=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_formaction"},
    {input: "<rt formmethod=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_formmethod"},
    {input: "<rt pattern=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_pattern"},
    {input: "<rt icon=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_icon"},
    {input: "<rt select=\"x\">",
     acceptable: [
         "<rt></rt>",
         "<rt>",
         "<rt/>",
         "<rt />",
         "<table><rt></rt></table>",
         "<table><rt></table>",
         "<RT />",
         "<RT></RT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rt_select"},
    {input: "<rtc></rtc>",
     acceptable: [
         "<rtc>",
         "<rtc />",
         "<rtc></rtc>",
         "<table><rtc></rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_plain"},
    {input: "<rtc><script>alert()</script></rtc>",
     acceptable: [
         "<rtc>",
         "<rtc />",
         "<rtc></rtc>",
         "<table><rtc></rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<span></span>",
         "<span />",
         "",
         "<table><rtc><td></td></rtc></table>",
         "<table><rtc></rtc><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_rtc_scriptinside"},
    {input: "<rtc media=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_media"},
    {input: "<rtc nonce=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_nonce"},
    {input: "<rtc srcset=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_srcset"},
    {input: "<rtc srcdoc=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_srcdoc"},
    {input: "<rtc poster=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_poster"},
    {input: "<rtc autoplay=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_autoplay"},
    {input: "<rtc controls=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_controls"},
    {input: "<rtc formaction=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_formaction"},
    {input: "<rtc formmethod=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_formmethod"},
    {input: "<rtc pattern=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_pattern"},
    {input: "<rtc icon=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_icon"},
    {input: "<rtc select=\"x\">",
     acceptable: [
         "<rtc></rtc>",
         "<rtc>",
         "<rtc/>",
         "<rtc />",
         "<table><rtc></rtc></table>",
         "<table><rtc></table>",
         "<RTC />",
         "<RTC></RTC>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rtc_select"},
    {input: "<rp></rp>",
     acceptable: [
         "<rp>",
         "<rp />",
         "<rp></rp>",
         "<table><rp></rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_plain"},
    {input: "<rp><script>alert()</script></rp>",
     acceptable: [
         "<rp>",
         "<rp />",
         "<rp></rp>",
         "<table><rp></rp></table>",
         "<RP />",
         "<RP></RP>",
         "<span></span>",
         "<span />",
         "",
         "<table><rp><td></td></rp></table>",
         "<table><rp></rp><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_rp_scriptinside"},
    {input: "<rp media=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_media"},
    {input: "<rp nonce=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_nonce"},
    {input: "<rp srcset=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_srcset"},
    {input: "<rp srcdoc=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_srcdoc"},
    {input: "<rp poster=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_poster"},
    {input: "<rp autoplay=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_autoplay"},
    {input: "<rp controls=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_controls"},
    {input: "<rp formaction=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_formaction"},
    {input: "<rp formmethod=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_formmethod"},
    {input: "<rp pattern=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_pattern"},
    {input: "<rp icon=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_icon"},
    {input: "<rp select=\"x\">",
     acceptable: [
         "<rp></rp>",
         "<rp>",
         "<rp/>",
         "<rp />",
         "<table><rp></rp></table>",
         "<table><rp></table>",
         "<RP />",
         "<RP></RP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_rp_select"},
    {input: "<data></data>",
     acceptable: [
         "<data>",
         "<data />",
         "<data></data>",
         "<table><data></data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_plain"},
    {input: "<data><script>alert()</script></data>",
     acceptable: [
         "<data>",
         "<data />",
         "<data></data>",
         "<table><data></data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<span></span>",
         "<span />",
         "",
         "<table><data><td></td></data></table>",
         "<table><data></data><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_data_scriptinside"},
    {input: "<data media=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_media"},
    {input: "<data nonce=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_nonce"},
    {input: "<data srcset=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_srcset"},
    {input: "<data srcdoc=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_srcdoc"},
    {input: "<data poster=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_poster"},
    {input: "<data autoplay=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_autoplay"},
    {input: "<data controls=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_controls"},
    {input: "<data formaction=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_formaction"},
    {input: "<data formmethod=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_formmethod"},
    {input: "<data pattern=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_pattern"},
    {input: "<data icon=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_icon"},
    {input: "<data select=\"x\">",
     acceptable: [
         "<data></data>",
         "<data>",
         "<data/>",
         "<data />",
         "<table><data></data></table>",
         "<table><data></table>",
         "<DATA />",
         "<DATA></DATA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_data_select"},
    {input: "<time></time>",
     acceptable: [
         "<time>",
         "<time />",
         "<time></time>",
         "<table><time></time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_plain"},
    {input: "<time><script>alert()</script></time>",
     acceptable: [
         "<time>",
         "<time />",
         "<time></time>",
         "<table><time></time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<span></span>",
         "<span />",
         "",
         "<table><time><td></td></time></table>",
         "<table><time></time><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_time_scriptinside"},
    {input: "<time media=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_media"},
    {input: "<time nonce=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_nonce"},
    {input: "<time srcset=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_srcset"},
    {input: "<time srcdoc=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_srcdoc"},
    {input: "<time poster=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_poster"},
    {input: "<time autoplay=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_autoplay"},
    {input: "<time controls=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_controls"},
    {input: "<time formaction=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_formaction"},
    {input: "<time formmethod=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_formmethod"},
    {input: "<time pattern=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_pattern"},
    {input: "<time icon=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_icon"},
    {input: "<time select=\"x\">",
     acceptable: [
         "<time></time>",
         "<time>",
         "<time/>",
         "<time />",
         "<table><time></time></table>",
         "<table><time></table>",
         "<TIME />",
         "<TIME></TIME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_time_select"},
    {input: "<code></code>",
     acceptable: [
         "<code>",
         "<code />",
         "<code></code>",
         "<table><code></code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_plain"},
    {input: "<code><script>alert()</script></code>",
     acceptable: [
         "<code>",
         "<code />",
         "<code></code>",
         "<table><code></code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<span></span>",
         "<span />",
         "",
         "<table><code><td></td></code></table>",
         "<table><code></code><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_code_scriptinside"},
    {input: "<code media=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_media"},
    {input: "<code nonce=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_nonce"},
    {input: "<code srcset=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_srcset"},
    {input: "<code srcdoc=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_srcdoc"},
    {input: "<code poster=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_poster"},
    {input: "<code autoplay=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_autoplay"},
    {input: "<code controls=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_controls"},
    {input: "<code formaction=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_formaction"},
    {input: "<code formmethod=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_formmethod"},
    {input: "<code pattern=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_pattern"},
    {input: "<code icon=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_icon"},
    {input: "<code select=\"x\">",
     acceptable: [
         "<code></code>",
         "<code>",
         "<code/>",
         "<code />",
         "<table><code></code></table>",
         "<table><code></table>",
         "<CODE />",
         "<CODE></CODE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_code_select"},
    {input: "<var></var>",
     acceptable: [
         "<var>",
         "<var />",
         "<var></var>",
         "<table><var></var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_plain"},
    {input: "<var><script>alert()</script></var>",
     acceptable: [
         "<var>",
         "<var />",
         "<var></var>",
         "<table><var></var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<span></span>",
         "<span />",
         "",
         "<table><var><td></td></var></table>",
         "<table><var></var><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_var_scriptinside"},
    {input: "<var media=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_media"},
    {input: "<var nonce=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_nonce"},
    {input: "<var srcset=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_srcset"},
    {input: "<var srcdoc=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_srcdoc"},
    {input: "<var poster=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_poster"},
    {input: "<var autoplay=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_autoplay"},
    {input: "<var controls=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_controls"},
    {input: "<var formaction=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_formaction"},
    {input: "<var formmethod=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_formmethod"},
    {input: "<var pattern=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_pattern"},
    {input: "<var icon=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_icon"},
    {input: "<var select=\"x\">",
     acceptable: [
         "<var></var>",
         "<var>",
         "<var/>",
         "<var />",
         "<table><var></var></table>",
         "<table><var></table>",
         "<VAR />",
         "<VAR></VAR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_var_select"},
    {input: "<samp></samp>",
     acceptable: [
         "<samp>",
         "<samp />",
         "<samp></samp>",
         "<table><samp></samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_plain"},
    {input: "<samp><script>alert()</script></samp>",
     acceptable: [
         "<samp>",
         "<samp />",
         "<samp></samp>",
         "<table><samp></samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<span></span>",
         "<span />",
         "",
         "<table><samp><td></td></samp></table>",
         "<table><samp></samp><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_samp_scriptinside"},
    {input: "<samp media=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_media"},
    {input: "<samp nonce=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_nonce"},
    {input: "<samp srcset=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_srcset"},
    {input: "<samp srcdoc=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_srcdoc"},
    {input: "<samp poster=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_poster"},
    {input: "<samp autoplay=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_autoplay"},
    {input: "<samp controls=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_controls"},
    {input: "<samp formaction=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_formaction"},
    {input: "<samp formmethod=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_formmethod"},
    {input: "<samp pattern=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_pattern"},
    {input: "<samp icon=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_icon"},
    {input: "<samp select=\"x\">",
     acceptable: [
         "<samp></samp>",
         "<samp>",
         "<samp/>",
         "<samp />",
         "<table><samp></samp></table>",
         "<table><samp></table>",
         "<SAMP />",
         "<SAMP></SAMP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_samp_select"},
    {input: "<kbd></kbd>",
     acceptable: [
         "<kbd>",
         "<kbd />",
         "<kbd></kbd>",
         "<table><kbd></kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_plain"},
    {input: "<kbd><script>alert()</script></kbd>",
     acceptable: [
         "<kbd>",
         "<kbd />",
         "<kbd></kbd>",
         "<table><kbd></kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<span></span>",
         "<span />",
         "",
         "<table><kbd><td></td></kbd></table>",
         "<table><kbd></kbd><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_kbd_scriptinside"},
    {input: "<kbd media=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_media"},
    {input: "<kbd nonce=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_nonce"},
    {input: "<kbd srcset=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_srcset"},
    {input: "<kbd srcdoc=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_srcdoc"},
    {input: "<kbd poster=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_poster"},
    {input: "<kbd autoplay=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_autoplay"},
    {input: "<kbd controls=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_controls"},
    {input: "<kbd formaction=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_formaction"},
    {input: "<kbd formmethod=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_formmethod"},
    {input: "<kbd pattern=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_pattern"},
    {input: "<kbd icon=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_icon"},
    {input: "<kbd select=\"x\">",
     acceptable: [
         "<kbd></kbd>",
         "<kbd>",
         "<kbd/>",
         "<kbd />",
         "<table><kbd></kbd></table>",
         "<table><kbd></table>",
         "<KBD />",
         "<KBD></KBD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_kbd_select"},
    {input: "<sub></sub>",
     acceptable: [
         "<sub>",
         "<sub />",
         "<sub></sub>",
         "<table><sub></sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_plain"},
    {input: "<sub><script>alert()</script></sub>",
     acceptable: [
         "<sub>",
         "<sub />",
         "<sub></sub>",
         "<table><sub></sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<span></span>",
         "<span />",
         "",
         "<table><sub><td></td></sub></table>",
         "<table><sub></sub><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_sub_scriptinside"},
    {input: "<sub media=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_media"},
    {input: "<sub nonce=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_nonce"},
    {input: "<sub srcset=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_srcset"},
    {input: "<sub srcdoc=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_srcdoc"},
    {input: "<sub poster=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_poster"},
    {input: "<sub autoplay=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_autoplay"},
    {input: "<sub controls=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_controls"},
    {input: "<sub formaction=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_formaction"},
    {input: "<sub formmethod=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_formmethod"},
    {input: "<sub pattern=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_pattern"},
    {input: "<sub icon=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_icon"},
    {input: "<sub select=\"x\">",
     acceptable: [
         "<sub></sub>",
         "<sub>",
         "<sub/>",
         "<sub />",
         "<table><sub></sub></table>",
         "<table><sub></table>",
         "<SUB />",
         "<SUB></SUB>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sub_select"},
    {input: "<sup></sup>",
     acceptable: [
         "<sup>",
         "<sup />",
         "<sup></sup>",
         "<table><sup></sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_plain"},
    {input: "<sup><script>alert()</script></sup>",
     acceptable: [
         "<sup>",
         "<sup />",
         "<sup></sup>",
         "<table><sup></sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<span></span>",
         "<span />",
         "",
         "<table><sup><td></td></sup></table>",
         "<table><sup></sup><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_sup_scriptinside"},
    {input: "<sup media=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_media"},
    {input: "<sup nonce=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_nonce"},
    {input: "<sup srcset=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_srcset"},
    {input: "<sup srcdoc=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_srcdoc"},
    {input: "<sup poster=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_poster"},
    {input: "<sup autoplay=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_autoplay"},
    {input: "<sup controls=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_controls"},
    {input: "<sup formaction=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_formaction"},
    {input: "<sup formmethod=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_formmethod"},
    {input: "<sup pattern=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_pattern"},
    {input: "<sup icon=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_icon"},
    {input: "<sup select=\"x\">",
     acceptable: [
         "<sup></sup>",
         "<sup>",
         "<sup/>",
         "<sup />",
         "<table><sup></sup></table>",
         "<table><sup></table>",
         "<SUP />",
         "<SUP></SUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_sup_select"},
    {input: "<i></i>",
     acceptable: [
         "<i>",
         "<i />",
         "<i></i>",
         "<table><i></i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_plain"},
    {input: "<i><script>alert()</script></i>",
     acceptable: [
         "<i>",
         "<i />",
         "<i></i>",
         "<table><i></i></table>",
         "<I />",
         "<I></I>",
         "<span></span>",
         "<span />",
         "",
         "<table><i><td></td></i></table>",
         "<table><i></i><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_i_scriptinside"},
    {input: "<i media=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_media"},
    {input: "<i nonce=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_nonce"},
    {input: "<i srcset=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_srcset"},
    {input: "<i srcdoc=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_srcdoc"},
    {input: "<i poster=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_poster"},
    {input: "<i autoplay=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_autoplay"},
    {input: "<i controls=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_controls"},
    {input: "<i formaction=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_formaction"},
    {input: "<i formmethod=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_formmethod"},
    {input: "<i pattern=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_pattern"},
    {input: "<i icon=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_icon"},
    {input: "<i select=\"x\">",
     acceptable: [
         "<i></i>",
         "<i>",
         "<i/>",
         "<i />",
         "<table><i></i></table>",
         "<table><i></table>",
         "<I />",
         "<I></I>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_i_select"},
    {input: "<b></b>",
     acceptable: [
         "<b>",
         "<b />",
         "<b></b>",
         "<table><b></b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_plain"},
    {input: "<b><script>alert()</script></b>",
     acceptable: [
         "<b>",
         "<b />",
         "<b></b>",
         "<table><b></b></table>",
         "<B />",
         "<B></B>",
         "<span></span>",
         "<span />",
         "",
         "<table><b><td></td></b></table>",
         "<table><b></b><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_b_scriptinside"},
    {input: "<b media=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_media"},
    {input: "<b nonce=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_nonce"},
    {input: "<b srcset=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_srcset"},
    {input: "<b srcdoc=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_srcdoc"},
    {input: "<b poster=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_poster"},
    {input: "<b autoplay=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_autoplay"},
    {input: "<b controls=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_controls"},
    {input: "<b formaction=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_formaction"},
    {input: "<b formmethod=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_formmethod"},
    {input: "<b pattern=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_pattern"},
    {input: "<b icon=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_icon"},
    {input: "<b select=\"x\">",
     acceptable: [
         "<b></b>",
         "<b>",
         "<b/>",
         "<b />",
         "<table><b></b></table>",
         "<table><b></table>",
         "<B />",
         "<B></B>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_b_select"},
    {input: "<u></u>",
     acceptable: [
         "<u>",
         "<u />",
         "<u></u>",
         "<table><u></u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_plain"},
    {input: "<u><script>alert()</script></u>",
     acceptable: [
         "<u>",
         "<u />",
         "<u></u>",
         "<table><u></u></table>",
         "<U />",
         "<U></U>",
         "<span></span>",
         "<span />",
         "",
         "<table><u><td></td></u></table>",
         "<table><u></u><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_u_scriptinside"},
    {input: "<u media=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_media"},
    {input: "<u nonce=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_nonce"},
    {input: "<u srcset=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_srcset"},
    {input: "<u srcdoc=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_srcdoc"},
    {input: "<u poster=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_poster"},
    {input: "<u autoplay=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_autoplay"},
    {input: "<u controls=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_controls"},
    {input: "<u formaction=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_formaction"},
    {input: "<u formmethod=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_formmethod"},
    {input: "<u pattern=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_pattern"},
    {input: "<u icon=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_icon"},
    {input: "<u select=\"x\">",
     acceptable: [
         "<u></u>",
         "<u>",
         "<u/>",
         "<u />",
         "<table><u></u></table>",
         "<table><u></table>",
         "<U />",
         "<U></U>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_u_select"},
    {input: "<mark></mark>",
     acceptable: [
         "<mark>",
         "<mark />",
         "<mark></mark>",
         "<table><mark></mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_plain"},
    {input: "<mark><script>alert()</script></mark>",
     acceptable: [
         "<mark>",
         "<mark />",
         "<mark></mark>",
         "<table><mark></mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<span></span>",
         "<span />",
         "",
         "<table><mark><td></td></mark></table>",
         "<table><mark></mark><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_mark_scriptinside"},
    {input: "<mark media=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_media"},
    {input: "<mark nonce=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_nonce"},
    {input: "<mark srcset=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_srcset"},
    {input: "<mark srcdoc=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_srcdoc"},
    {input: "<mark poster=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_poster"},
    {input: "<mark autoplay=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_autoplay"},
    {input: "<mark controls=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_controls"},
    {input: "<mark formaction=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_formaction"},
    {input: "<mark formmethod=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_formmethod"},
    {input: "<mark pattern=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_pattern"},
    {input: "<mark icon=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_icon"},
    {input: "<mark select=\"x\">",
     acceptable: [
         "<mark></mark>",
         "<mark>",
         "<mark/>",
         "<mark />",
         "<table><mark></mark></table>",
         "<table><mark></table>",
         "<MARK />",
         "<MARK></MARK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_mark_select"},
    {input: "<bdi></bdi>",
     acceptable: [
         "<bdi>",
         "<bdi />",
         "<bdi></bdi>",
         "<table><bdi></bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_plain"},
    {input: "<bdi><script>alert()</script></bdi>",
     acceptable: [
         "<bdi>",
         "<bdi />",
         "<bdi></bdi>",
         "<table><bdi></bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<span></span>",
         "<span />",
         "",
         "<table><bdi><td></td></bdi></table>",
         "<table><bdi></bdi><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_bdi_scriptinside"},
    {input: "<bdi media=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_media"},
    {input: "<bdi nonce=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_nonce"},
    {input: "<bdi srcset=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_srcset"},
    {input: "<bdi srcdoc=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_srcdoc"},
    {input: "<bdi poster=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_poster"},
    {input: "<bdi autoplay=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_autoplay"},
    {input: "<bdi controls=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_controls"},
    {input: "<bdi formaction=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_formaction"},
    {input: "<bdi formmethod=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_formmethod"},
    {input: "<bdi pattern=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_pattern"},
    {input: "<bdi icon=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_icon"},
    {input: "<bdi select=\"x\">",
     acceptable: [
         "<bdi></bdi>",
         "<bdi>",
         "<bdi/>",
         "<bdi />",
         "<table><bdi></bdi></table>",
         "<table><bdi></table>",
         "<BDI />",
         "<BDI></BDI>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdi_select"},
    {input: "<bdo></bdo>",
     acceptable: [
         "<bdo>",
         "<bdo />",
         "<bdo></bdo>",
         "<table><bdo></bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_plain"},
    {input: "<bdo><script>alert()</script></bdo>",
     acceptable: [
         "<bdo>",
         "<bdo />",
         "<bdo></bdo>",
         "<table><bdo></bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<span></span>",
         "<span />",
         "",
         "<table><bdo><td></td></bdo></table>",
         "<table><bdo></bdo><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_bdo_scriptinside"},
    {input: "<bdo media=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_media"},
    {input: "<bdo nonce=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_nonce"},
    {input: "<bdo srcset=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_srcset"},
    {input: "<bdo srcdoc=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_srcdoc"},
    {input: "<bdo poster=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_poster"},
    {input: "<bdo autoplay=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_autoplay"},
    {input: "<bdo controls=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_controls"},
    {input: "<bdo formaction=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_formaction"},
    {input: "<bdo formmethod=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_formmethod"},
    {input: "<bdo pattern=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_pattern"},
    {input: "<bdo icon=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_icon"},
    {input: "<bdo select=\"x\">",
     acceptable: [
         "<bdo></bdo>",
         "<bdo>",
         "<bdo/>",
         "<bdo />",
         "<table><bdo></bdo></table>",
         "<table><bdo></table>",
         "<BDO />",
         "<BDO></BDO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_bdo_select"},
    {input: "<span></span>",
     acceptable: [
         "<span>",
         "<span />",
         "<span></span>",
         "<table><span></span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
     ],
     name: "contract_span_plain"},
    {input: "<span><script>alert()</script></span>",
     acceptable: [
         "<span>",
         "<span />",
         "<span></span>",
         "<table><span></span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "",
         "<table><span><td></td></span></table>",
         "<table><span></span><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_span_scriptinside"},
    {input: "<span media=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_media"},
    {input: "<span nonce=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_nonce"},
    {input: "<span srcset=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_srcset"},
    {input: "<span srcdoc=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_srcdoc"},
    {input: "<span poster=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_poster"},
    {input: "<span autoplay=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_autoplay"},
    {input: "<span controls=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_controls"},
    {input: "<span formaction=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_formaction"},
    {input: "<span formmethod=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_formmethod"},
    {input: "<span pattern=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_pattern"},
    {input: "<span icon=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_icon"},
    {input: "<span select=\"x\">",
     acceptable: [
         "<span></span>",
         "<span>",
         "<span/>",
         "<span />",
         "<table><span></span></table>",
         "<table><span></table>",
         "<SPAN />",
         "<SPAN></SPAN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "",
     ],
     name: "contract_span_select"},
    {input: "<br></br>",
     acceptable: [
         "<br>",
         "<br />",
         "<br/>",
         "<br><br>",
         "<br/><br/>",
         "<br /><br />",
         "<table><br></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_plain"},
    {input: "<br><script>alert()</script></br>",
     acceptable: [
         "<br>",
         "<br />",
         "<br/>",
         "<br><br>",
         "<br/><br/>",
         "<br /><br />",
         "<table><br></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><br><td></td></table>",
     ],
     name: "contract_br_scriptinside"},
    {input: "<br media=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_media"},
    {input: "<br nonce=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_nonce"},
    {input: "<br srcset=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_srcset"},
    {input: "<br srcdoc=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_srcdoc"},
    {input: "<br poster=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_poster"},
    {input: "<br autoplay=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_autoplay"},
    {input: "<br controls=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_controls"},
    {input: "<br formaction=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_formaction"},
    {input: "<br formmethod=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_formmethod"},
    {input: "<br pattern=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_pattern"},
    {input: "<br icon=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_icon"},
    {input: "<br select=\"x\">",
     acceptable: [
         "<br></br>",
         "<br>",
         "<br/>",
         "<br />",
         "<table><br></br></table>",
         "<table><br></table>",
         "<BR />",
         "<BR></BR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_br_select"},
    {input: "<wbr></wbr>",
     acceptable: [
         "<wbr>",
         "<wbr />",
         "<wbr/>",
         "<wbr><wbr>",
         "<wbr/><wbr/>",
         "<wbr /><wbr />",
         "<table><wbr></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_plain"},
    {input: "<wbr><script>alert()</script></wbr>",
     acceptable: [
         "<wbr>",
         "<wbr />",
         "<wbr/>",
         "<wbr><wbr>",
         "<wbr/><wbr/>",
         "<wbr /><wbr />",
         "<table><wbr></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><wbr><td></td></table>",
     ],
     name: "contract_wbr_scriptinside"},
    {input: "<wbr media=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_media"},
    {input: "<wbr nonce=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_nonce"},
    {input: "<wbr srcset=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_srcset"},
    {input: "<wbr srcdoc=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_srcdoc"},
    {input: "<wbr poster=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_poster"},
    {input: "<wbr autoplay=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_autoplay"},
    {input: "<wbr controls=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_controls"},
    {input: "<wbr formaction=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_formaction"},
    {input: "<wbr formmethod=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_formmethod"},
    {input: "<wbr pattern=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_pattern"},
    {input: "<wbr icon=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_icon"},
    {input: "<wbr select=\"x\">",
     acceptable: [
         "<wbr></wbr>",
         "<wbr>",
         "<wbr/>",
         "<wbr />",
         "<table><wbr></wbr></table>",
         "<table><wbr></table>",
         "<WBR />",
         "<WBR></WBR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_wbr_select"},
    {input: "<link></link>",
     acceptable: [
         "<link>",
         "<link />",
         "<link/>",
         "<link><link>",
         "<link/><link/>",
         "<link /><link />",
         "<table><link></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_plain"},
    {input: "<link><script>alert()</script></link>",
     acceptable: [
         "<link>",
         "<link />",
         "<link/>",
         "<link><link>",
         "<link/><link/>",
         "<link /><link />",
         "<table><link></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><link><td></td></table>",
     ],
     name: "contract_link_scriptinside"},
    {input: "<link rel=\"alternate\" href=\"x\">",
     acceptable: [
         "<link href=x rel=alternate>",
         "<link href=x rel=\"alternate\">",
         "<link rel=\"alternate\" href=\"x\">",
         "<link rel=\"alternate\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_alternate"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_alternate_x"},
    {input: "<link rel=\"author\" href=\"x\">",
     acceptable: [
         "<link href=x rel=author>",
         "<link href=x rel=\"author\">",
         "<link rel=\"author\" href=\"x\">",
         "<link rel=\"author\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_author"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_author_x"},
    {input: "<link rel=\"bookmark\" href=\"x\">",
     acceptable: [
         "<link href=x rel=bookmark>",
         "<link href=x rel=\"bookmark\">",
         "<link rel=\"bookmark\" href=\"x\">",
         "<link rel=\"bookmark\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_bookmark"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_bookmark_x"},
    {input: "<link rel=\"canonical\" href=\"x\">",
     acceptable: [
         "<link href=x rel=canonical>",
         "<link href=x rel=\"canonical\">",
         "<link rel=\"canonical\" href=\"x\">",
         "<link rel=\"canonical\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_canonical"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_canonical_x"},
    {input: "<link rel=\"cite\" href=\"x\">",
     acceptable: [
         "<link href=x rel=cite>",
         "<link href=x rel=\"cite\">",
         "<link rel=\"cite\" href=\"x\">",
         "<link rel=\"cite\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_cite"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_cite_x"},
    {input: "<link rel=\"help\" href=\"x\">",
     acceptable: [
         "<link href=x rel=help>",
         "<link href=x rel=\"help\">",
         "<link rel=\"help\" href=\"x\">",
         "<link rel=\"help\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_help"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_help_x"},
    {input: "<link rel=\"icon\" href=\"x\">",
     acceptable: [
         "<link href=x rel=icon>",
         "<link href=x rel=\"icon\">",
         "<link rel=\"icon\" href=\"x\">",
         "<link rel=\"icon\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_icon"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_icon_x"},
    {input: "<link rel=\"license\" href=\"x\">",
     acceptable: [
         "<link href=x rel=license>",
         "<link href=x rel=\"license\">",
         "<link rel=\"license\" href=\"x\">",
         "<link rel=\"license\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_license"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_license_x"},
    {input: "<link rel=\"next\" href=\"x\">",
     acceptable: [
         "<link href=x rel=next>",
         "<link href=x rel=\"next\">",
         "<link rel=\"next\" href=\"x\">",
         "<link rel=\"next\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_next"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_next_x"},
    {input: "<link rel=\"prefetch\" href=\"x\">",
     acceptable: [
         "<link href=x rel=prefetch>",
         "<link href=x rel=\"prefetch\">",
         "<link rel=\"prefetch\" href=\"x\">",
         "<link rel=\"prefetch\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_prefetch"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_prefetch_x"},
    {input: "<link rel=\"dns-prefetch\" href=\"x\">",
     acceptable: [
         "<link href=x rel=dns-prefetch>",
         "<link href=x rel=\"dns-prefetch\">",
         "<link rel=\"dns-prefetch\" href=\"x\">",
         "<link rel=\"dns-prefetch\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_dns-prefetch"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_dns-prefetch_x"},
    {input: "<link rel=\"prerender\" href=\"x\">",
     acceptable: [
         "<link href=x rel=prerender>",
         "<link href=x rel=\"prerender\">",
         "<link rel=\"prerender\" href=\"x\">",
         "<link rel=\"prerender\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_prerender"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_prerender_x"},
    {input: "<link rel=\"preconnect\" href=\"x\">",
     acceptable: [
         "<link href=x rel=preconnect>",
         "<link href=x rel=\"preconnect\">",
         "<link rel=\"preconnect\" href=\"x\">",
         "<link rel=\"preconnect\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_preconnect"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_preconnect_x"},
    {input: "<link rel=\"preload\" href=\"x\">",
     acceptable: [
         "<link href=x rel=preload>",
         "<link href=x rel=\"preload\">",
         "<link rel=\"preload\" href=\"x\">",
         "<link rel=\"preload\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_preload"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_preload_x"},
    {input: "<link rel=\"prev\" href=\"x\">",
     acceptable: [
         "<link href=x rel=prev>",
         "<link href=x rel=\"prev\">",
         "<link rel=\"prev\" href=\"x\">",
         "<link rel=\"prev\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_prev"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_prev_x"},
    {input: "<link rel=\"search\" href=\"x\">",
     acceptable: [
         "<link href=x rel=search>",
         "<link href=x rel=\"search\">",
         "<link rel=\"search\" href=\"x\">",
         "<link rel=\"search\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_search"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_search_x"},
    {input: "<link rel=\"subresource\" href=\"x\">",
     acceptable: [
         "<link href=x rel=subresource>",
         "<link href=x rel=\"subresource\">",
         "<link rel=\"subresource\" href=\"x\">",
         "<link rel=\"subresource\" href=\"x\"/>",
         "",
     ],
     name: "contract_link_rel_subresource"},
    {input: "<link rel=\"x\" href=\"x\">",
     acceptable: [
         "<link rel=x>",
         "<link rel=\"x\">",
         "<link rel=\"x\"/>",
         "",
     ],
     name: "link_subresource_x"},
    {input: "<link srcset=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_srcset"},
    {input: "<link srcdoc=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_srcdoc"},
    {input: "<link poster=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_poster"},
    {input: "<link autoplay=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_autoplay"},
    {input: "<link controls=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_controls"},
    {input: "<link formaction=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_formaction"},
    {input: "<link formmethod=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_formmethod"},
    {input: "<link pattern=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_pattern"},
    {input: "<link icon=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_icon"},
    {input: "<link select=\"x\">",
     acceptable: [
         "<link></link>",
         "<link>",
         "<link/>",
         "<link />",
         "<table><link></link></table>",
         "<table><link></table>",
         "<LINK />",
         "<LINK></LINK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_link_select"},
    {input: "<ins></ins>",
     acceptable: [
         "<ins>",
         "<ins />",
         "<ins></ins>",
         "<table><ins></ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_plain"},
    {input: "<ins><script>alert()</script></ins>",
     acceptable: [
         "<ins>",
         "<ins />",
         "<ins></ins>",
         "<table><ins></ins></table>",
         "<INS />",
         "<INS></INS>",
         "<span></span>",
         "<span />",
         "",
         "<table><ins><td></td></ins></table>",
         "<table><ins></ins><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_ins_scriptinside"},
    {input: "<ins cite=\"javascript:xss\">",
     acceptable: [
         "<ins cite=\"about:invalid#zCSafez\"></ins>",
         "<ins cite=\"about:invalid#zCSafez\">",
         "<ins cite=\"about:invalid#zGoSafez\"></ins>",
         "<ins cite=\"about:invalid#zGoSafez\"/>",
         "<ins cite=\"javascript:void(0);\"></ins>",
         "<ins cite=\"javascript:void(0);\">",
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_cite"},
    {input: "<ins media=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_media"},
    {input: "<ins nonce=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_nonce"},
    {input: "<ins srcset=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_srcset"},
    {input: "<ins srcdoc=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_srcdoc"},
    {input: "<ins poster=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_poster"},
    {input: "<ins autoplay=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_autoplay"},
    {input: "<ins controls=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_controls"},
    {input: "<ins formaction=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_formaction"},
    {input: "<ins formmethod=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_formmethod"},
    {input: "<ins pattern=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_pattern"},
    {input: "<ins icon=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_icon"},
    {input: "<ins select=\"x\">",
     acceptable: [
         "<ins></ins>",
         "<ins>",
         "<ins/>",
         "<ins />",
         "<table><ins></ins></table>",
         "<table><ins></table>",
         "<INS />",
         "<INS></INS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_ins_select"},
    {input: "<del></del>",
     acceptable: [
         "<del>",
         "<del />",
         "<del></del>",
         "<table><del></del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_plain"},
    {input: "<del><script>alert()</script></del>",
     acceptable: [
         "<del>",
         "<del />",
         "<del></del>",
         "<table><del></del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<span></span>",
         "<span />",
         "",
         "<table><del><td></td></del></table>",
         "<table><del></del><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_del_scriptinside"},
    {input: "<del cite=\"javascript:xss\">",
     acceptable: [
         "<del cite=\"about:invalid#zCSafez\"></del>",
         "<del cite=\"about:invalid#zCSafez\">",
         "<del cite=\"about:invalid#zGoSafez\"></del>",
         "<del cite=\"about:invalid#zGoSafez\"/>",
         "<del cite=\"javascript:void(0);\"></del>",
         "<del cite=\"javascript:void(0);\">",
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_cite"},
    {input: "<del media=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_media"},
    {input: "<del nonce=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_nonce"},
    {input: "<del srcset=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_srcset"},
    {input: "<del srcdoc=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_srcdoc"},
    {input: "<del poster=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_poster"},
    {input: "<del autoplay=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_autoplay"},
    {input: "<del controls=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_controls"},
    {input: "<del formaction=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_formaction"},
    {input: "<del formmethod=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_formmethod"},
    {input: "<del pattern=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_pattern"},
    {input: "<del icon=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_icon"},
    {input: "<del select=\"x\">",
     acceptable: [
         "<del></del>",
         "<del>",
         "<del/>",
         "<del />",
         "<table><del></del></table>",
         "<table><del></table>",
         "<DEL />",
         "<DEL></DEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_del_select"},
    {input: "<picture></picture>",
     acceptable: [
         "<picture>",
         "<picture />",
         "<picture></picture>",
         "<table><picture></picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_plain"},
    {input: "<picture><script>alert()</script></picture>",
     acceptable: [
         "<picture>",
         "<picture />",
         "<picture></picture>",
         "<table><picture></picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<span></span>",
         "<span />",
         "",
         "<table><picture><td></td></picture></table>",
         "<table><picture></picture><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_picture_scriptinside"},
    {input: "<picture media=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_media"},
    {input: "<picture nonce=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_nonce"},
    {input: "<picture srcset=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_srcset"},
    {input: "<picture srcdoc=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_srcdoc"},
    {input: "<picture poster=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_poster"},
    {input: "<picture autoplay=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_autoplay"},
    {input: "<picture controls=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_controls"},
    {input: "<picture formaction=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_formaction"},
    {input: "<picture formmethod=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_formmethod"},
    {input: "<picture pattern=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_pattern"},
    {input: "<picture icon=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_icon"},
    {input: "<picture select=\"x\">",
     acceptable: [
         "<picture></picture>",
         "<picture>",
         "<picture/>",
         "<picture />",
         "<table><picture></picture></table>",
         "<table><picture></table>",
         "<PICTURE />",
         "<PICTURE></PICTURE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_picture_select"},
    {input: "<source></source>",
     acceptable: [
         "<source>",
         "<source />",
         "<source/>",
         "<source><source>",
         "<source/><source/>",
         "<source /><source />",
         "<table><source></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_plain"},
    {input: "<source><script>alert()</script></source>",
     acceptable: [
         "<source>",
         "<source />",
         "<source/>",
         "<source><source>",
         "<source/><source/>",
         "<source /><source />",
         "<table><source></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><source><td></td></table>",
     ],
     name: "contract_source_scriptinside"},
    {input: "<source src=\"javascript:xss\">",
     acceptable: [
         "<source src=\"about:invalid#zCSafez\"></source>",
         "<source src=\"about:invalid#zCSafez\">",
         "<source src=\"about:invalid#zGoSafez\"></source>",
         "<source src=\"about:invalid#zGoSafez\"/>",
         "<source src=\"javascript:void(0);\"></source>",
         "<source src=\"javascript:void(0);\">",
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_src"},
    {input: "<source srcset=\"javascript:xss\">",
     acceptable: [
         "<source srcset=\"about:invalid#zCSafez\"></source>",
         "<source srcset=\"about:invalid#zCSafez\">",
         "<source srcset=\"about:invalid#zGoSafez\"></source>",
         "<source srcset=\"about:invalid#zGoSafez\"/>",
         "<source srcset=\"javascript:void(0);\"></source>",
         "<source srcset=\"javascript:void(0);\">",
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_srcset"},
    {input: "<source nonce=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_nonce"},
    {input: "<source srcdoc=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_srcdoc"},
    {input: "<source poster=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_poster"},
    {input: "<source autoplay=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_autoplay"},
    {input: "<source controls=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_controls"},
    {input: "<source formaction=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_formaction"},
    {input: "<source formmethod=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_formmethod"},
    {input: "<source pattern=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_pattern"},
    {input: "<source icon=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_icon"},
    {input: "<source select=\"x\">",
     acceptable: [
         "<source></source>",
         "<source>",
         "<source/>",
         "<source />",
         "<table><source></source></table>",
         "<table><source></table>",
         "<SOURCE />",
         "<SOURCE></SOURCE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_source_select"},
    {input: "<img></img>",
     acceptable: [
         "<img>",
         "<img />",
         "<img/>",
         "<img><img>",
         "<img/><img/>",
         "<img /><img />",
         "<table><img></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_plain"},
    {input: "<img><script>alert()</script></img>",
     acceptable: [
         "<img>",
         "<img />",
         "<img/>",
         "<img><img>",
         "<img/><img/>",
         "<img /><img />",
         "<table><img></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><img><td></td></table>",
     ],
     name: "contract_img_scriptinside"},
    {input: "<img src=\"javascript:xss\">",
     acceptable: [
         "<img src=\"about:invalid#zCSafez\"></img>",
         "<img src=\"about:invalid#zCSafez\">",
         "<img src=\"about:invalid#zGoSafez\"></img>",
         "<img src=\"about:invalid#zGoSafez\"/>",
         "<img src=\"javascript:void(0);\"></img>",
         "<img src=\"javascript:void(0);\">",
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_src"},
    {input: "<img srcset=\"javascript:xss\">",
     acceptable: [
         "<img srcset=\"about:invalid#zCSafez\"></img>",
         "<img srcset=\"about:invalid#zCSafez\">",
         "<img srcset=\"about:invalid#zGoSafez\"></img>",
         "<img srcset=\"about:invalid#zGoSafez\"/>",
         "<img srcset=\"javascript:void(0);\"></img>",
         "<img srcset=\"javascript:void(0);\">",
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_srcset"},
    {input: "<img media=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_media"},
    {input: "<img nonce=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_nonce"},
    {input: "<img srcdoc=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_srcdoc"},
    {input: "<img poster=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_poster"},
    {input: "<img autoplay=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_autoplay"},
    {input: "<img controls=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_controls"},
    {input: "<img formaction=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_formaction"},
    {input: "<img formmethod=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_formmethod"},
    {input: "<img pattern=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_pattern"},
    {input: "<img icon=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_icon"},
    {input: "<img select=\"x\">",
     acceptable: [
         "<img></img>",
         "<img>",
         "<img/>",
         "<img />",
         "<table><img></img></table>",
         "<table><img></table>",
         "<IMG />",
         "<IMG></IMG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_img_select"},
    {input: "<iframe></iframe>",
     acceptable: [
         "<iframe>",
         "<iframe />",
         "<iframe></iframe>",
         "<table><iframe></iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_plain"},
    {input: "<iframe><script>alert()</script></iframe>",
     acceptable: [
         "<iframe>",
         "<iframe />",
         "<iframe></iframe>",
         "<table><iframe></iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<span></span>",
         "<span />",
         "",
         "<table><iframe><td></td></iframe></table>",
         "<table><iframe></iframe><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_iframe_scriptinside"},
    {input: "<iframe srcdoc=\"<script>alert()</script>\">",
     acceptable: [
         "<iframe srcdoc></iframe>",
         "<iframe srcdoc=\"\"></iframe>",
         "",
     ],
     name: "contract_iframe_srcdoc"},
    {input: "<iframe media=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_media"},
    {input: "<iframe nonce=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_nonce"},
    {input: "<iframe srcset=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_srcset"},
    {input: "<iframe poster=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_poster"},
    {input: "<iframe autoplay=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_autoplay"},
    {input: "<iframe controls=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_controls"},
    {input: "<iframe formaction=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_formaction"},
    {input: "<iframe formmethod=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_formmethod"},
    {input: "<iframe pattern=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_pattern"},
    {input: "<iframe icon=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_icon"},
    {input: "<iframe select=\"x\">",
     acceptable: [
         "<iframe></iframe>",
         "<iframe>",
         "<iframe/>",
         "<iframe />",
         "<table><iframe></iframe></table>",
         "<table><iframe></table>",
         "<IFRAME />",
         "<IFRAME></IFRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_iframe_select"},
    {input: "<embed></embed>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_plain"},
    {input: "<embed><script>alert()</script></embed>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_scriptinside"},
    {input: "<embed media=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_media"},
    {input: "<embed nonce=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_nonce"},
    {input: "<embed srcset=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_srcset"},
    {input: "<embed srcdoc=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_srcdoc"},
    {input: "<embed poster=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_poster"},
    {input: "<embed autoplay=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_autoplay"},
    {input: "<embed controls=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_controls"},
    {input: "<embed formaction=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_formaction"},
    {input: "<embed formmethod=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_formmethod"},
    {input: "<embed pattern=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_pattern"},
    {input: "<embed icon=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_icon"},
    {input: "<embed select=\"x\">",
     acceptable: [
         "<embed></embed>",
         "<embed>",
         "<embed/>",
         "<embed />",
         "<table><embed></embed></table>",
         "<table><embed></table>",
         "<EMBED />",
         "<EMBED></EMBED>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_embed_select"},
    {input: "<object></object>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_plain"},
    {input: "<object><script>alert()</script></object>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_scriptinside"},
    {input: "<object media=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_media"},
    {input: "<object nonce=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_nonce"},
    {input: "<object srcset=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_srcset"},
    {input: "<object srcdoc=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_srcdoc"},
    {input: "<object poster=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_poster"},
    {input: "<object autoplay=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_autoplay"},
    {input: "<object controls=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_controls"},
    {input: "<object formaction=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_formaction"},
    {input: "<object formmethod=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_formmethod"},
    {input: "<object pattern=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_pattern"},
    {input: "<object icon=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_icon"},
    {input: "<object select=\"x\">",
     acceptable: [
         "<object></object>",
         "<object>",
         "<object/>",
         "<object />",
         "<table><object></object></table>",
         "<table><object></table>",
         "<OBJECT />",
         "<OBJECT></OBJECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_object_select"},
    {input: "<param></param>",
     acceptable: [
         "<param>",
         "<param />",
         "<param/>",
         "<param><param>",
         "<param/><param/>",
         "<param /><param />",
         "<table><param></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_plain"},
    {input: "<param><script>alert()</script></param>",
     acceptable: [
         "<param>",
         "<param />",
         "<param/>",
         "<param><param>",
         "<param/><param/>",
         "<param /><param />",
         "<table><param></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><param><td></td></table>",
     ],
     name: "contract_param_scriptinside"},
    {input: "<param media=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_media"},
    {input: "<param nonce=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_nonce"},
    {input: "<param srcset=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_srcset"},
    {input: "<param srcdoc=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_srcdoc"},
    {input: "<param poster=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_poster"},
    {input: "<param autoplay=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_autoplay"},
    {input: "<param controls=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_controls"},
    {input: "<param formaction=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_formaction"},
    {input: "<param formmethod=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_formmethod"},
    {input: "<param pattern=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_pattern"},
    {input: "<param icon=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_icon"},
    {input: "<param select=\"x\">",
     acceptable: [
         "<param></param>",
         "<param>",
         "<param/>",
         "<param />",
         "<table><param></param></table>",
         "<table><param></table>",
         "<PARAM />",
         "<PARAM></PARAM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_param_select"},
    {input: "<video></video>",
     acceptable: [
         "<video>",
         "<video />",
         "<video></video>",
         "<table><video></video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_plain"},
    {input: "<video><script>alert()</script></video>",
     acceptable: [
         "<video>",
         "<video />",
         "<video></video>",
         "<table><video></video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<span></span>",
         "<span />",
         "",
         "<table><video><td></td></video></table>",
         "<table><video></video><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_video_scriptinside"},
    {input: "<video src=\"javascript:xss\">",
     acceptable: [
         "<video src=\"about:invalid#zCSafez\"></video>",
         "<video src=\"about:invalid#zCSafez\">",
         "<video src=\"about:invalid#zGoSafez\"></video>",
         "<video src=\"about:invalid#zGoSafez\"/>",
         "<video src=\"javascript:void(0);\"></video>",
         "<video src=\"javascript:void(0);\">",
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_src"},
    {input: "<video poster=\"javascript:xss\">",
     acceptable: [
         "<video poster=\"about:invalid#zCSafez\"></video>",
         "<video poster=\"about:invalid#zCSafez\">",
         "<video poster=\"about:invalid#zGoSafez\"></video>",
         "<video poster=\"about:invalid#zGoSafez\"/>",
         "<video poster=\"javascript:void(0);\"></video>",
         "<video poster=\"javascript:void(0);\">",
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_poster"},
    {input: "<video media=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_media"},
    {input: "<video nonce=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_nonce"},
    {input: "<video srcset=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_srcset"},
    {input: "<video srcdoc=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_srcdoc"},
    {input: "<video formaction=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_formaction"},
    {input: "<video formmethod=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_formmethod"},
    {input: "<video pattern=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_pattern"},
    {input: "<video icon=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_icon"},
    {input: "<video select=\"x\">",
     acceptable: [
         "<video></video>",
         "<video>",
         "<video/>",
         "<video />",
         "<table><video></video></table>",
         "<table><video></table>",
         "<VIDEO />",
         "<VIDEO></VIDEO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_video_select"},
    {input: "<audio></audio>",
     acceptable: [
         "<audio>",
         "<audio />",
         "<audio></audio>",
         "<table><audio></audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_plain"},
    {input: "<audio><script>alert()</script></audio>",
     acceptable: [
         "<audio>",
         "<audio />",
         "<audio></audio>",
         "<table><audio></audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<span></span>",
         "<span />",
         "",
         "<table><audio><td></td></audio></table>",
         "<table><audio></audio><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_audio_scriptinside"},
    {input: "<audio src=\"javascript:xss\">",
     acceptable: [
         "<audio src=\"about:invalid#zCSafez\"></audio>",
         "<audio src=\"about:invalid#zCSafez\">",
         "<audio src=\"about:invalid#zGoSafez\"></audio>",
         "<audio src=\"about:invalid#zGoSafez\"/>",
         "<audio src=\"javascript:void(0);\"></audio>",
         "<audio src=\"javascript:void(0);\">",
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_src"},
    {input: "<audio media=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_media"},
    {input: "<audio nonce=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_nonce"},
    {input: "<audio srcset=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_srcset"},
    {input: "<audio srcdoc=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_srcdoc"},
    {input: "<audio poster=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_poster"},
    {input: "<audio autoplay=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_autoplay"},
    {input: "<audio controls=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_controls"},
    {input: "<audio formaction=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_formaction"},
    {input: "<audio formmethod=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_formmethod"},
    {input: "<audio pattern=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_pattern"},
    {input: "<audio icon=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_icon"},
    {input: "<audio select=\"x\">",
     acceptable: [
         "<audio></audio>",
         "<audio>",
         "<audio/>",
         "<audio />",
         "<table><audio></audio></table>",
         "<table><audio></table>",
         "<AUDIO />",
         "<AUDIO></AUDIO>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_audio_select"},
    {input: "<track></track>",
     acceptable: [
         "<track>",
         "<track />",
         "<track/>",
         "<track><track>",
         "<track/><track/>",
         "<track /><track />",
         "<table><track></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_plain"},
    {input: "<track><script>alert()</script></track>",
     acceptable: [
         "<track>",
         "<track />",
         "<track/>",
         "<track><track>",
         "<track/><track/>",
         "<track /><track />",
         "<table><track></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><track><td></td></table>",
     ],
     name: "contract_track_scriptinside"},
    {input: "<track media=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_media"},
    {input: "<track nonce=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_nonce"},
    {input: "<track srcset=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_srcset"},
    {input: "<track srcdoc=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_srcdoc"},
    {input: "<track poster=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_poster"},
    {input: "<track autoplay=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_autoplay"},
    {input: "<track controls=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_controls"},
    {input: "<track formaction=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_formaction"},
    {input: "<track formmethod=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_formmethod"},
    {input: "<track pattern=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_pattern"},
    {input: "<track icon=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_icon"},
    {input: "<track select=\"x\">",
     acceptable: [
         "<track></track>",
         "<track>",
         "<track/>",
         "<track />",
         "<table><track></track></table>",
         "<table><track></table>",
         "<TRACK />",
         "<TRACK></TRACK>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_track_select"},
    {input: "<map></map>",
     acceptable: [
         "<map>",
         "<map />",
         "<map></map>",
         "<table><map></map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_plain"},
    {input: "<map><script>alert()</script></map>",
     acceptable: [
         "<map>",
         "<map />",
         "<map></map>",
         "<table><map></map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<span></span>",
         "<span />",
         "",
         "<table><map><td></td></map></table>",
         "<table><map></map><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_map_scriptinside"},
    {input: "<map media=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_media"},
    {input: "<map nonce=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_nonce"},
    {input: "<map srcset=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_srcset"},
    {input: "<map srcdoc=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_srcdoc"},
    {input: "<map poster=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_poster"},
    {input: "<map autoplay=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_autoplay"},
    {input: "<map controls=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_controls"},
    {input: "<map formaction=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_formaction"},
    {input: "<map formmethod=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_formmethod"},
    {input: "<map pattern=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_pattern"},
    {input: "<map icon=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_icon"},
    {input: "<map select=\"x\">",
     acceptable: [
         "<map></map>",
         "<map>",
         "<map/>",
         "<map />",
         "<table><map></map></table>",
         "<table><map></table>",
         "<MAP />",
         "<MAP></MAP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_map_select"},
    {input: "<table></table>",
     acceptable: [
         "<table>",
         "<table />",
         "<table></table>",
         "<table><table></table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_plain"},
    {input: "<table><script>alert()</script></table>",
     acceptable: [
         "<table>",
         "<table />",
         "<table></table>",
         "<table><table></table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<span></span>",
         "<span />",
         "",
         "<table><table><td></td></table></table>",
         "<table><table></table><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_table_scriptinside"},
    {input: "<table media=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_media"},
    {input: "<table nonce=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_nonce"},
    {input: "<table srcset=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_srcset"},
    {input: "<table srcdoc=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_srcdoc"},
    {input: "<table poster=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_poster"},
    {input: "<table autoplay=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_autoplay"},
    {input: "<table controls=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_controls"},
    {input: "<table formaction=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_formaction"},
    {input: "<table formmethod=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_formmethod"},
    {input: "<table pattern=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_pattern"},
    {input: "<table icon=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_icon"},
    {input: "<table select=\"x\">",
     acceptable: [
         "<table></table>",
         "<table>",
         "<table/>",
         "<table />",
         "<table><table></table></table>",
         "<table><table></table>",
         "<TABLE />",
         "<TABLE></TABLE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_table_select"},
    {input: "<caption></caption>",
     acceptable: [
         "<caption>",
         "<caption />",
         "<caption></caption>",
         "<table><caption></caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_plain"},
    {input: "<caption><script>alert()</script></caption>",
     acceptable: [
         "<caption>",
         "<caption />",
         "<caption></caption>",
         "<table><caption></caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<span></span>",
         "<span />",
         "",
         "<table><caption><td></td></caption></table>",
         "<table><caption></caption><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_caption_scriptinside"},
    {input: "<caption media=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_media"},
    {input: "<caption nonce=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_nonce"},
    {input: "<caption srcset=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_srcset"},
    {input: "<caption srcdoc=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_srcdoc"},
    {input: "<caption poster=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_poster"},
    {input: "<caption autoplay=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_autoplay"},
    {input: "<caption controls=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_controls"},
    {input: "<caption formaction=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_formaction"},
    {input: "<caption formmethod=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_formmethod"},
    {input: "<caption pattern=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_pattern"},
    {input: "<caption icon=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_icon"},
    {input: "<caption select=\"x\">",
     acceptable: [
         "<caption></caption>",
         "<caption>",
         "<caption/>",
         "<caption />",
         "<table><caption></caption></table>",
         "<table><caption></table>",
         "<CAPTION />",
         "<CAPTION></CAPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_caption_select"},
    {input: "<colgroup></colgroup>",
     acceptable: [
         "<colgroup>",
         "<colgroup />",
         "<colgroup></colgroup>",
         "<table><colgroup></colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_plain"},
    {input: "<colgroup><script>alert()</script></colgroup>",
     acceptable: [
         "<colgroup>",
         "<colgroup />",
         "<colgroup></colgroup>",
         "<table><colgroup></colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<span></span>",
         "<span />",
         "",
         "<table><colgroup><td></td></colgroup></table>",
         "<table><colgroup></colgroup><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_colgroup_scriptinside"},
    {input: "<colgroup media=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_media"},
    {input: "<colgroup nonce=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_nonce"},
    {input: "<colgroup srcset=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_srcset"},
    {input: "<colgroup srcdoc=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_srcdoc"},
    {input: "<colgroup poster=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_poster"},
    {input: "<colgroup autoplay=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_autoplay"},
    {input: "<colgroup controls=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_controls"},
    {input: "<colgroup formaction=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_formaction"},
    {input: "<colgroup formmethod=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_formmethod"},
    {input: "<colgroup pattern=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_pattern"},
    {input: "<colgroup icon=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_icon"},
    {input: "<colgroup select=\"x\">",
     acceptable: [
         "<colgroup></colgroup>",
         "<colgroup>",
         "<colgroup/>",
         "<colgroup />",
         "<table><colgroup></colgroup></table>",
         "<table><colgroup></table>",
         "<COLGROUP />",
         "<COLGROUP></COLGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_colgroup_select"},
    {input: "<col></col>",
     acceptable: [
         "<col>",
         "<col />",
         "<col/>",
         "<col><col>",
         "<col/><col/>",
         "<col /><col />",
         "<table><col></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_plain"},
    {input: "<col><script>alert()</script></col>",
     acceptable: [
         "<col>",
         "<col />",
         "<col/>",
         "<col><col>",
         "<col/><col/>",
         "<col /><col />",
         "<table><col></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><col><td></td></table>",
     ],
     name: "contract_col_scriptinside"},
    {input: "<col media=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_media"},
    {input: "<col nonce=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_nonce"},
    {input: "<col srcset=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_srcset"},
    {input: "<col srcdoc=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_srcdoc"},
    {input: "<col poster=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_poster"},
    {input: "<col autoplay=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_autoplay"},
    {input: "<col controls=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_controls"},
    {input: "<col formaction=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_formaction"},
    {input: "<col formmethod=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_formmethod"},
    {input: "<col pattern=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_pattern"},
    {input: "<col icon=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_icon"},
    {input: "<col select=\"x\">",
     acceptable: [
         "<col></col>",
         "<col>",
         "<col/>",
         "<col />",
         "<table><col></col></table>",
         "<table><col></table>",
         "<COL />",
         "<COL></COL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_col_select"},
    {input: "<tbody></tbody>",
     acceptable: [
         "<tbody>",
         "<tbody />",
         "<tbody></tbody>",
         "<table><tbody></tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_plain"},
    {input: "<tbody><script>alert()</script></tbody>",
     acceptable: [
         "<tbody>",
         "<tbody />",
         "<tbody></tbody>",
         "<table><tbody></tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<span></span>",
         "<span />",
         "",
         "<table><tbody><td></td></tbody></table>",
         "<table><tbody></tbody><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_tbody_scriptinside"},
    {input: "<tbody media=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_media"},
    {input: "<tbody nonce=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_nonce"},
    {input: "<tbody srcset=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_srcset"},
    {input: "<tbody srcdoc=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_srcdoc"},
    {input: "<tbody poster=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_poster"},
    {input: "<tbody autoplay=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_autoplay"},
    {input: "<tbody controls=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_controls"},
    {input: "<tbody formaction=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_formaction"},
    {input: "<tbody formmethod=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_formmethod"},
    {input: "<tbody pattern=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_pattern"},
    {input: "<tbody icon=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_icon"},
    {input: "<tbody select=\"x\">",
     acceptable: [
         "<tbody></tbody>",
         "<tbody>",
         "<tbody/>",
         "<tbody />",
         "<table><tbody></tbody></table>",
         "<table><tbody></table>",
         "<TBODY />",
         "<TBODY></TBODY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tbody_select"},
    {input: "<thead></thead>",
     acceptable: [
         "<thead>",
         "<thead />",
         "<thead></thead>",
         "<table><thead></thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_plain"},
    {input: "<thead><script>alert()</script></thead>",
     acceptable: [
         "<thead>",
         "<thead />",
         "<thead></thead>",
         "<table><thead></thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<span></span>",
         "<span />",
         "",
         "<table><thead><td></td></thead></table>",
         "<table><thead></thead><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_thead_scriptinside"},
    {input: "<thead media=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_media"},
    {input: "<thead nonce=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_nonce"},
    {input: "<thead srcset=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_srcset"},
    {input: "<thead srcdoc=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_srcdoc"},
    {input: "<thead poster=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_poster"},
    {input: "<thead autoplay=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_autoplay"},
    {input: "<thead controls=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_controls"},
    {input: "<thead formaction=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_formaction"},
    {input: "<thead formmethod=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_formmethod"},
    {input: "<thead pattern=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_pattern"},
    {input: "<thead icon=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_icon"},
    {input: "<thead select=\"x\">",
     acceptable: [
         "<thead></thead>",
         "<thead>",
         "<thead/>",
         "<thead />",
         "<table><thead></thead></table>",
         "<table><thead></table>",
         "<THEAD />",
         "<THEAD></THEAD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_thead_select"},
    {input: "<tfoot></tfoot>",
     acceptable: [
         "<tfoot>",
         "<tfoot />",
         "<tfoot></tfoot>",
         "<table><tfoot></tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_plain"},
    {input: "<tfoot><script>alert()</script></tfoot>",
     acceptable: [
         "<tfoot>",
         "<tfoot />",
         "<tfoot></tfoot>",
         "<table><tfoot></tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<span></span>",
         "<span />",
         "",
         "<table><tfoot><td></td></tfoot></table>",
         "<table><tfoot></tfoot><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_tfoot_scriptinside"},
    {input: "<tfoot media=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_media"},
    {input: "<tfoot nonce=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_nonce"},
    {input: "<tfoot srcset=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_srcset"},
    {input: "<tfoot srcdoc=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_srcdoc"},
    {input: "<tfoot poster=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_poster"},
    {input: "<tfoot autoplay=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_autoplay"},
    {input: "<tfoot controls=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_controls"},
    {input: "<tfoot formaction=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_formaction"},
    {input: "<tfoot formmethod=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_formmethod"},
    {input: "<tfoot pattern=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_pattern"},
    {input: "<tfoot icon=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_icon"},
    {input: "<tfoot select=\"x\">",
     acceptable: [
         "<tfoot></tfoot>",
         "<tfoot>",
         "<tfoot/>",
         "<tfoot />",
         "<table><tfoot></tfoot></table>",
         "<table><tfoot></table>",
         "<TFOOT />",
         "<TFOOT></TFOOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tfoot_select"},
    {input: "<tr></tr>",
     acceptable: [
         "<tr>",
         "<tr />",
         "<tr></tr>",
         "<table><tr></tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_plain"},
    {input: "<tr><script>alert()</script></tr>",
     acceptable: [
         "<tr>",
         "<tr />",
         "<tr></tr>",
         "<table><tr></tr></table>",
         "<TR />",
         "<TR></TR>",
         "<span></span>",
         "<span />",
         "",
         "<table><tr><td></td></tr></table>",
         "<table><tr></tr><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_tr_scriptinside"},
    {input: "<tr media=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_media"},
    {input: "<tr nonce=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_nonce"},
    {input: "<tr srcset=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_srcset"},
    {input: "<tr srcdoc=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_srcdoc"},
    {input: "<tr poster=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_poster"},
    {input: "<tr autoplay=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_autoplay"},
    {input: "<tr controls=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_controls"},
    {input: "<tr formaction=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_formaction"},
    {input: "<tr formmethod=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_formmethod"},
    {input: "<tr pattern=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_pattern"},
    {input: "<tr icon=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_icon"},
    {input: "<tr select=\"x\">",
     acceptable: [
         "<tr></tr>",
         "<tr>",
         "<tr/>",
         "<tr />",
         "<table><tr></tr></table>",
         "<table><tr></table>",
         "<TR />",
         "<TR></TR>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_tr_select"},
    {input: "<td></td>",
     acceptable: [
         "<td>",
         "<td />",
         "<td></td>",
         "<table><td></td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_plain"},
    {input: "<td><script>alert()</script></td>",
     acceptable: [
         "<td>",
         "<td />",
         "<td></td>",
         "<table><td></td></table>",
         "<TD />",
         "<TD></TD>",
         "<span></span>",
         "<span />",
         "",
         "<table><td><td></td></td></table>",
         "<table><td></td><td></td></table>",
     ],
     name: "contract_td_scriptinside"},
    {input: "<td media=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_media"},
    {input: "<td nonce=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_nonce"},
    {input: "<td srcset=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_srcset"},
    {input: "<td srcdoc=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_srcdoc"},
    {input: "<td poster=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_poster"},
    {input: "<td autoplay=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_autoplay"},
    {input: "<td controls=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_controls"},
    {input: "<td formaction=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_formaction"},
    {input: "<td formmethod=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_formmethod"},
    {input: "<td pattern=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_pattern"},
    {input: "<td icon=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_icon"},
    {input: "<td select=\"x\">",
     acceptable: [
         "<td></td>",
         "<td>",
         "<td/>",
         "<td />",
         "<table><td></td></table>",
         "<table><td></table>",
         "<TD />",
         "<TD></TD>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_td_select"},
    {input: "<th></th>",
     acceptable: [
         "<th>",
         "<th />",
         "<th></th>",
         "<table><th></th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_plain"},
    {input: "<th><script>alert()</script></th>",
     acceptable: [
         "<th>",
         "<th />",
         "<th></th>",
         "<table><th></th></table>",
         "<TH />",
         "<TH></TH>",
         "<span></span>",
         "<span />",
         "",
         "<table><th><td></td></th></table>",
         "<table><th></th><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_th_scriptinside"},
    {input: "<th media=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_media"},
    {input: "<th nonce=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_nonce"},
    {input: "<th srcset=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_srcset"},
    {input: "<th srcdoc=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_srcdoc"},
    {input: "<th poster=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_poster"},
    {input: "<th autoplay=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_autoplay"},
    {input: "<th controls=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_controls"},
    {input: "<th formaction=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_formaction"},
    {input: "<th formmethod=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_formmethod"},
    {input: "<th pattern=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_pattern"},
    {input: "<th icon=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_icon"},
    {input: "<th select=\"x\">",
     acceptable: [
         "<th></th>",
         "<th>",
         "<th/>",
         "<th />",
         "<table><th></th></table>",
         "<table><th></table>",
         "<TH />",
         "<TH></TH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_th_select"},
    {input: "<form></form>",
     acceptable: [
         "<form>",
         "<form />",
         "<form></form>",
         "<table><form></form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_plain"},
    {input: "<form><script>alert()</script></form>",
     acceptable: [
         "<form>",
         "<form />",
         "<form></form>",
         "<table><form></form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<span></span>",
         "<span />",
         "",
         "<table><form><td></td></form></table>",
         "<table><form></form><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_form_scriptinside"},
    {input: "<form action=\"javascript:xss\">",
     acceptable: [
         "<form action=\"about:invalid#zCSafez\"></form>",
         "<form action=\"about:invalid#zCSafez\">",
         "<form action=\"about:invalid#zGoSafez\"></form>",
         "<form action=\"about:invalid#zGoSafez\"/>",
         "<form action=\"javascript:void(0);\"></form>",
         "<form action=\"javascript:void(0);\">",
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_action"},
    {input: "<form media=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_media"},
    {input: "<form nonce=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_nonce"},
    {input: "<form srcset=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_srcset"},
    {input: "<form srcdoc=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_srcdoc"},
    {input: "<form poster=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_poster"},
    {input: "<form autoplay=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_autoplay"},
    {input: "<form controls=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_controls"},
    {input: "<form formaction=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_formaction"},
    {input: "<form formmethod=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_formmethod"},
    {input: "<form pattern=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_pattern"},
    {input: "<form icon=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_icon"},
    {input: "<form select=\"x\">",
     acceptable: [
         "<form></form>",
         "<form>",
         "<form/>",
         "<form />",
         "<table><form></form></table>",
         "<table><form></table>",
         "<FORM />",
         "<FORM></FORM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_form_select"},
    {input: "<label></label>",
     acceptable: [
         "<label>",
         "<label />",
         "<label></label>",
         "<table><label></label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_plain"},
    {input: "<label><script>alert()</script></label>",
     acceptable: [
         "<label>",
         "<label />",
         "<label></label>",
         "<table><label></label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<span></span>",
         "<span />",
         "",
         "<table><label><td></td></label></table>",
         "<table><label></label><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_label_scriptinside"},
    {input: "<label media=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_media"},
    {input: "<label nonce=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_nonce"},
    {input: "<label srcset=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_srcset"},
    {input: "<label srcdoc=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_srcdoc"},
    {input: "<label poster=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_poster"},
    {input: "<label autoplay=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_autoplay"},
    {input: "<label controls=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_controls"},
    {input: "<label formaction=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_formaction"},
    {input: "<label formmethod=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_formmethod"},
    {input: "<label pattern=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_pattern"},
    {input: "<label icon=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_icon"},
    {input: "<label select=\"x\">",
     acceptable: [
         "<label></label>",
         "<label>",
         "<label/>",
         "<label />",
         "<table><label></label></table>",
         "<table><label></table>",
         "<LABEL />",
         "<LABEL></LABEL>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_label_select"},
    {input: "<input></input>",
     acceptable: [
         "<input>",
         "<input />",
         "<input/>",
         "<input><input>",
         "<input/><input/>",
         "<input /><input />",
         "<table><input></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_plain"},
    {input: "<input><script>alert()</script></input>",
     acceptable: [
         "<input>",
         "<input />",
         "<input/>",
         "<input><input>",
         "<input/><input/>",
         "<input /><input />",
         "<table><input></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><input><td></td></table>",
     ],
     name: "contract_input_scriptinside"},
    {input: "<input formaction=\"javascript:xss\">",
     acceptable: [
         "<input formaction=\"about:invalid#zCSafez\"></input>",
         "<input formaction=\"about:invalid#zCSafez\">",
         "<input formaction=\"about:invalid#zGoSafez\"></input>",
         "<input formaction=\"about:invalid#zGoSafez\"/>",
         "<input formaction=\"javascript:void(0);\"></input>",
         "<input formaction=\"javascript:void(0);\">",
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_formaction"},
    {input: "<input src=\"javascript:xss\">",
     acceptable: [
         "<input src=\"about:invalid#zCSafez\"></input>",
         "<input src=\"about:invalid#zCSafez\">",
         "<input src=\"about:invalid#zGoSafez\"></input>",
         "<input src=\"about:invalid#zGoSafez\"/>",
         "<input src=\"javascript:void(0);\"></input>",
         "<input src=\"javascript:void(0);\">",
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_src"},
    {input: "<input media=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_media"},
    {input: "<input nonce=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_nonce"},
    {input: "<input srcset=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_srcset"},
    {input: "<input srcdoc=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_srcdoc"},
    {input: "<input poster=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_poster"},
    {input: "<input autoplay=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_autoplay"},
    {input: "<input controls=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_controls"},
    {input: "<input icon=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_icon"},
    {input: "<input select=\"x\">",
     acceptable: [
         "<input></input>",
         "<input>",
         "<input/>",
         "<input />",
         "<table><input></input></table>",
         "<table><input></table>",
         "<INPUT />",
         "<INPUT></INPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_input_select"},
    {input: "<command></command>",
     acceptable: [
         "<command>",
         "<command />",
         "<command></command>",
         "<table><command></command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_plain"},
    {input: "<command><script>alert()</script></command>",
     acceptable: [
         "<command>",
         "<command />",
         "<command></command>",
         "<table><command></command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<span></span>",
         "<span />",
         "",
         "<table><command><td></td></command></table>",
         "<table><command></command><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_command_scriptinside"},
    {input: "<command media=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_media"},
    {input: "<command nonce=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_nonce"},
    {input: "<command srcset=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_srcset"},
    {input: "<command srcdoc=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_srcdoc"},
    {input: "<command poster=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_poster"},
    {input: "<command autoplay=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_autoplay"},
    {input: "<command controls=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_controls"},
    {input: "<command formaction=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_formaction"},
    {input: "<command formmethod=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_formmethod"},
    {input: "<command pattern=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_pattern"},
    {input: "<command icon=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_icon"},
    {input: "<command select=\"x\">",
     acceptable: [
         "<command></command>",
         "<command>",
         "<command/>",
         "<command />",
         "<table><command></command></table>",
         "<table><command></table>",
         "<COMMAND />",
         "<COMMAND></COMMAND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_command_select"},
    {input: "<button></button>",
     acceptable: [
         "<button>",
         "<button />",
         "<button></button>",
         "<table><button></button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_plain"},
    {input: "<button><script>alert()</script></button>",
     acceptable: [
         "<button>",
         "<button />",
         "<button></button>",
         "<table><button></button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<span></span>",
         "<span />",
         "",
         "<table><button><td></td></button></table>",
         "<table><button></button><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_button_scriptinside"},
    {input: "<button formaction=\"javascript:xss\">",
     acceptable: [
         "<button formaction=\"about:invalid#zCSafez\"></button>",
         "<button formaction=\"about:invalid#zCSafez\">",
         "<button formaction=\"about:invalid#zGoSafez\"></button>",
         "<button formaction=\"about:invalid#zGoSafez\"/>",
         "<button formaction=\"javascript:void(0);\"></button>",
         "<button formaction=\"javascript:void(0);\">",
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_formaction"},
    {input: "<button media=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_media"},
    {input: "<button nonce=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_nonce"},
    {input: "<button srcset=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_srcset"},
    {input: "<button srcdoc=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_srcdoc"},
    {input: "<button poster=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_poster"},
    {input: "<button autoplay=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_autoplay"},
    {input: "<button controls=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_controls"},
    {input: "<button pattern=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_pattern"},
    {input: "<button icon=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_icon"},
    {input: "<button select=\"x\">",
     acceptable: [
         "<button></button>",
         "<button>",
         "<button/>",
         "<button />",
         "<table><button></button></table>",
         "<table><button></table>",
         "<BUTTON />",
         "<BUTTON></BUTTON>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_button_select"},
    {input: "<select></select>",
     acceptable: [
         "<select>",
         "<select />",
         "<select></select>",
         "<table><select></select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_plain"},
    {input: "<select><script>alert()</script></select>",
     acceptable: [
         "<select>",
         "<select />",
         "<select></select>",
         "<table><select></select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<span></span>",
         "<span />",
         "",
         "<table><select><td></td></select></table>",
         "<table><select></select><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_select_scriptinside"},
    {input: "<select media=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_media"},
    {input: "<select nonce=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_nonce"},
    {input: "<select srcset=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_srcset"},
    {input: "<select srcdoc=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_srcdoc"},
    {input: "<select poster=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_poster"},
    {input: "<select autoplay=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_autoplay"},
    {input: "<select controls=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_controls"},
    {input: "<select formaction=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_formaction"},
    {input: "<select formmethod=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_formmethod"},
    {input: "<select pattern=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_pattern"},
    {input: "<select icon=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_icon"},
    {input: "<select select=\"x\">",
     acceptable: [
         "<select></select>",
         "<select>",
         "<select/>",
         "<select />",
         "<table><select></select></table>",
         "<table><select></table>",
         "<SELECT />",
         "<SELECT></SELECT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_select_select"},
    {input: "<datalist></datalist>",
     acceptable: [
         "<datalist>",
         "<datalist />",
         "<datalist></datalist>",
         "<table><datalist></datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_plain"},
    {input: "<datalist><script>alert()</script></datalist>",
     acceptable: [
         "<datalist>",
         "<datalist />",
         "<datalist></datalist>",
         "<table><datalist></datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<span></span>",
         "<span />",
         "",
         "<table><datalist><td></td></datalist></table>",
         "<table><datalist></datalist><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_datalist_scriptinside"},
    {input: "<datalist media=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_media"},
    {input: "<datalist nonce=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_nonce"},
    {input: "<datalist srcset=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_srcset"},
    {input: "<datalist srcdoc=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_srcdoc"},
    {input: "<datalist poster=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_poster"},
    {input: "<datalist autoplay=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_autoplay"},
    {input: "<datalist controls=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_controls"},
    {input: "<datalist formaction=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_formaction"},
    {input: "<datalist formmethod=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_formmethod"},
    {input: "<datalist pattern=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_pattern"},
    {input: "<datalist icon=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_icon"},
    {input: "<datalist select=\"x\">",
     acceptable: [
         "<datalist></datalist>",
         "<datalist>",
         "<datalist/>",
         "<datalist />",
         "<table><datalist></datalist></table>",
         "<table><datalist></table>",
         "<DATALIST />",
         "<DATALIST></DATALIST>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_datalist_select"},
    {input: "<optgroup></optgroup>",
     acceptable: [
         "<optgroup>",
         "<optgroup />",
         "<optgroup></optgroup>",
         "<table><optgroup></optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_plain"},
    {input: "<optgroup><script>alert()</script></optgroup>",
     acceptable: [
         "<optgroup>",
         "<optgroup />",
         "<optgroup></optgroup>",
         "<table><optgroup></optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<span></span>",
         "<span />",
         "",
         "<table><optgroup><td></td></optgroup></table>",
         "<table><optgroup></optgroup><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_optgroup_scriptinside"},
    {input: "<optgroup media=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_media"},
    {input: "<optgroup nonce=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_nonce"},
    {input: "<optgroup srcset=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_srcset"},
    {input: "<optgroup srcdoc=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_srcdoc"},
    {input: "<optgroup poster=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_poster"},
    {input: "<optgroup autoplay=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_autoplay"},
    {input: "<optgroup controls=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_controls"},
    {input: "<optgroup formaction=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_formaction"},
    {input: "<optgroup formmethod=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_formmethod"},
    {input: "<optgroup pattern=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_pattern"},
    {input: "<optgroup icon=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_icon"},
    {input: "<optgroup select=\"x\">",
     acceptable: [
         "<optgroup></optgroup>",
         "<optgroup>",
         "<optgroup/>",
         "<optgroup />",
         "<table><optgroup></optgroup></table>",
         "<table><optgroup></table>",
         "<OPTGROUP />",
         "<OPTGROUP></OPTGROUP>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_optgroup_select"},
    {input: "<option></option>",
     acceptable: [
         "<option>",
         "<option />",
         "<option></option>",
         "<table><option></option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_plain"},
    {input: "<option><script>alert()</script></option>",
     acceptable: [
         "<option>",
         "<option />",
         "<option></option>",
         "<table><option></option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<span></span>",
         "<span />",
         "",
         "<table><option><td></td></option></table>",
         "<table><option></option><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_option_scriptinside"},
    {input: "<option media=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_media"},
    {input: "<option nonce=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_nonce"},
    {input: "<option srcset=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_srcset"},
    {input: "<option srcdoc=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_srcdoc"},
    {input: "<option poster=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_poster"},
    {input: "<option autoplay=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_autoplay"},
    {input: "<option controls=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_controls"},
    {input: "<option formaction=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_formaction"},
    {input: "<option formmethod=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_formmethod"},
    {input: "<option pattern=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_pattern"},
    {input: "<option icon=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_icon"},
    {input: "<option select=\"x\">",
     acceptable: [
         "<option></option>",
         "<option>",
         "<option/>",
         "<option />",
         "<table><option></option></table>",
         "<table><option></table>",
         "<OPTION />",
         "<OPTION></OPTION>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_option_select"},
    {input: "<textarea></textarea>",
     acceptable: [
         "<textarea></textarea>",
         "<textarea />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_plain"},
    {input: "<textarea><script>alert()</script></textarea>",
     acceptable: [
         "<textarea></textarea>",
         "<textarea />",
         "<span></span>",
         "<span />",
         "",
         "<textarea>&lt;script&gt;alert()&lt;/script&gt;</textarea>",
         "<span>&lt;script&gt;alert()&lt;/script&gt;</span>",
         "&lt;script&gt;alert()&lt;/script&gt;",
     ],
     name: "contract_textarea_scriptinside"},
    {input: "<textarea media=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_media"},
    {input: "<textarea nonce=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_nonce"},
    {input: "<textarea srcset=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_srcset"},
    {input: "<textarea srcdoc=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_srcdoc"},
    {input: "<textarea poster=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_poster"},
    {input: "<textarea autoplay=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_autoplay"},
    {input: "<textarea controls=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_controls"},
    {input: "<textarea formaction=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_formaction"},
    {input: "<textarea formmethod=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_formmethod"},
    {input: "<textarea pattern=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_pattern"},
    {input: "<textarea icon=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_icon"},
    {input: "<textarea select=\"x\">",
     acceptable: [
         "<textarea></textarea>",
         "<textarea>",
         "<textarea/>",
         "<textarea />",
         "<table><textarea></textarea></table>",
         "<table><textarea></table>",
         "<TEXTAREA />",
         "<TEXTAREA></TEXTAREA>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_textarea_select"},
    {input: "<keygen></keygen>",
     acceptable: [
         "<keygen>",
         "<keygen />",
         "<keygen/>",
         "<keygen><keygen>",
         "<keygen/><keygen/>",
         "<keygen /><keygen />",
         "<table><keygen></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_plain"},
    {input: "<keygen><script>alert()</script></keygen>",
     acceptable: [
         "<keygen>",
         "<keygen />",
         "<keygen/>",
         "<keygen><keygen>",
         "<keygen/><keygen/>",
         "<keygen /><keygen />",
         "<table><keygen></table>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
         "<table><keygen><td></td></table>",
     ],
     name: "contract_keygen_scriptinside"},
    {input: "<keygen media=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_media"},
    {input: "<keygen nonce=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_nonce"},
    {input: "<keygen srcset=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_srcset"},
    {input: "<keygen srcdoc=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_srcdoc"},
    {input: "<keygen poster=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_poster"},
    {input: "<keygen autoplay=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_autoplay"},
    {input: "<keygen controls=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_controls"},
    {input: "<keygen formaction=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_formaction"},
    {input: "<keygen formmethod=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_formmethod"},
    {input: "<keygen pattern=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_pattern"},
    {input: "<keygen icon=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_icon"},
    {input: "<keygen select=\"x\">",
     acceptable: [
         "<keygen></keygen>",
         "<keygen>",
         "<keygen/>",
         "<keygen />",
         "<table><keygen></keygen></table>",
         "<table><keygen></table>",
         "<KEYGEN />",
         "<KEYGEN></KEYGEN>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_keygen_select"},
    {input: "<output></output>",
     acceptable: [
         "<output>",
         "<output />",
         "<output></output>",
         "<table><output></output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_plain"},
    {input: "<output><script>alert()</script></output>",
     acceptable: [
         "<output>",
         "<output />",
         "<output></output>",
         "<table><output></output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<span></span>",
         "<span />",
         "",
         "<table><output><td></td></output></table>",
         "<table><output></output><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_output_scriptinside"},
    {input: "<output media=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_media"},
    {input: "<output nonce=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_nonce"},
    {input: "<output srcset=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_srcset"},
    {input: "<output srcdoc=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_srcdoc"},
    {input: "<output poster=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_poster"},
    {input: "<output autoplay=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_autoplay"},
    {input: "<output controls=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_controls"},
    {input: "<output formaction=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_formaction"},
    {input: "<output formmethod=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_formmethod"},
    {input: "<output pattern=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_pattern"},
    {input: "<output icon=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_icon"},
    {input: "<output select=\"x\">",
     acceptable: [
         "<output></output>",
         "<output>",
         "<output/>",
         "<output />",
         "<table><output></output></table>",
         "<table><output></table>",
         "<OUTPUT />",
         "<OUTPUT></OUTPUT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_output_select"},
    {input: "<progress></progress>",
     acceptable: [
         "<progress>",
         "<progress />",
         "<progress></progress>",
         "<table><progress></progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_plain"},
    {input: "<progress><script>alert()</script></progress>",
     acceptable: [
         "<progress>",
         "<progress />",
         "<progress></progress>",
         "<table><progress></progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<span></span>",
         "<span />",
         "",
         "<table><progress><td></td></progress></table>",
         "<table><progress></progress><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_progress_scriptinside"},
    {input: "<progress media=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_media"},
    {input: "<progress nonce=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_nonce"},
    {input: "<progress srcset=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_srcset"},
    {input: "<progress srcdoc=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_srcdoc"},
    {input: "<progress poster=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_poster"},
    {input: "<progress autoplay=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_autoplay"},
    {input: "<progress controls=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_controls"},
    {input: "<progress formaction=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_formaction"},
    {input: "<progress formmethod=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_formmethod"},
    {input: "<progress pattern=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_pattern"},
    {input: "<progress icon=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_icon"},
    {input: "<progress select=\"x\">",
     acceptable: [
         "<progress></progress>",
         "<progress>",
         "<progress/>",
         "<progress />",
         "<table><progress></progress></table>",
         "<table><progress></table>",
         "<PROGRESS />",
         "<PROGRESS></PROGRESS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_progress_select"},
    {input: "<meter></meter>",
     acceptable: [
         "<meter>",
         "<meter />",
         "<meter></meter>",
         "<table><meter></meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_plain"},
    {input: "<meter><script>alert()</script></meter>",
     acceptable: [
         "<meter>",
         "<meter />",
         "<meter></meter>",
         "<table><meter></meter></table>",
         "<METER />",
         "<METER></METER>",
         "<span></span>",
         "<span />",
         "",
         "<table><meter><td></td></meter></table>",
         "<table><meter></meter><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_meter_scriptinside"},
    {input: "<meter media=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_media"},
    {input: "<meter nonce=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_nonce"},
    {input: "<meter srcset=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_srcset"},
    {input: "<meter srcdoc=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_srcdoc"},
    {input: "<meter poster=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_poster"},
    {input: "<meter autoplay=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_autoplay"},
    {input: "<meter controls=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_controls"},
    {input: "<meter formaction=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_formaction"},
    {input: "<meter formmethod=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_formmethod"},
    {input: "<meter pattern=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_pattern"},
    {input: "<meter icon=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_icon"},
    {input: "<meter select=\"x\">",
     acceptable: [
         "<meter></meter>",
         "<meter>",
         "<meter/>",
         "<meter />",
         "<table><meter></meter></table>",
         "<table><meter></table>",
         "<METER />",
         "<METER></METER>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_meter_select"},
    {input: "<fieldset></fieldset>",
     acceptable: [
         "<fieldset>",
         "<fieldset />",
         "<fieldset></fieldset>",
         "<table><fieldset></fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_plain"},
    {input: "<fieldset><script>alert()</script></fieldset>",
     acceptable: [
         "<fieldset>",
         "<fieldset />",
         "<fieldset></fieldset>",
         "<table><fieldset></fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<span></span>",
         "<span />",
         "",
         "<table><fieldset><td></td></fieldset></table>",
         "<table><fieldset></fieldset><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_fieldset_scriptinside"},
    {input: "<fieldset media=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_media"},
    {input: "<fieldset nonce=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_nonce"},
    {input: "<fieldset srcset=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_srcset"},
    {input: "<fieldset srcdoc=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_srcdoc"},
    {input: "<fieldset poster=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_poster"},
    {input: "<fieldset autoplay=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_autoplay"},
    {input: "<fieldset controls=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_controls"},
    {input: "<fieldset formaction=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_formaction"},
    {input: "<fieldset formmethod=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_formmethod"},
    {input: "<fieldset pattern=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_pattern"},
    {input: "<fieldset icon=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_icon"},
    {input: "<fieldset select=\"x\">",
     acceptable: [
         "<fieldset></fieldset>",
         "<fieldset>",
         "<fieldset/>",
         "<fieldset />",
         "<table><fieldset></fieldset></table>",
         "<table><fieldset></table>",
         "<FIELDSET />",
         "<FIELDSET></FIELDSET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_fieldset_select"},
    {input: "<legend></legend>",
     acceptable: [
         "<legend>",
         "<legend />",
         "<legend></legend>",
         "<table><legend></legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_plain"},
    {input: "<legend><script>alert()</script></legend>",
     acceptable: [
         "<legend>",
         "<legend />",
         "<legend></legend>",
         "<table><legend></legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<span></span>",
         "<span />",
         "",
         "<table><legend><td></td></legend></table>",
         "<table><legend></legend><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_legend_scriptinside"},
    {input: "<legend media=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_media"},
    {input: "<legend nonce=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_nonce"},
    {input: "<legend srcset=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_srcset"},
    {input: "<legend srcdoc=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_srcdoc"},
    {input: "<legend poster=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_poster"},
    {input: "<legend autoplay=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_autoplay"},
    {input: "<legend controls=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_controls"},
    {input: "<legend formaction=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_formaction"},
    {input: "<legend formmethod=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_formmethod"},
    {input: "<legend pattern=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_pattern"},
    {input: "<legend icon=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_icon"},
    {input: "<legend select=\"x\">",
     acceptable: [
         "<legend></legend>",
         "<legend>",
         "<legend/>",
         "<legend />",
         "<table><legend></legend></table>",
         "<table><legend></table>",
         "<LEGEND />",
         "<LEGEND></LEGEND>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_legend_select"},
    {input: "<details></details>",
     acceptable: [
         "<details>",
         "<details />",
         "<details></details>",
         "<table><details></details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_plain"},
    {input: "<details><script>alert()</script></details>",
     acceptable: [
         "<details>",
         "<details />",
         "<details></details>",
         "<table><details></details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<span></span>",
         "<span />",
         "",
         "<table><details><td></td></details></table>",
         "<table><details></details><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_details_scriptinside"},
    {input: "<details media=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_media"},
    {input: "<details nonce=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_nonce"},
    {input: "<details srcset=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_srcset"},
    {input: "<details srcdoc=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_srcdoc"},
    {input: "<details poster=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_poster"},
    {input: "<details autoplay=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_autoplay"},
    {input: "<details controls=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_controls"},
    {input: "<details formaction=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_formaction"},
    {input: "<details formmethod=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_formmethod"},
    {input: "<details pattern=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_pattern"},
    {input: "<details icon=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_icon"},
    {input: "<details select=\"x\">",
     acceptable: [
         "<details></details>",
         "<details>",
         "<details/>",
         "<details />",
         "<table><details></details></table>",
         "<table><details></table>",
         "<DETAILS />",
         "<DETAILS></DETAILS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_details_select"},
    {input: "<summary></summary>",
     acceptable: [
         "<summary>",
         "<summary />",
         "<summary></summary>",
         "<table><summary></summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_plain"},
    {input: "<summary><script>alert()</script></summary>",
     acceptable: [
         "<summary>",
         "<summary />",
         "<summary></summary>",
         "<table><summary></summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<span></span>",
         "<span />",
         "",
         "<table><summary><td></td></summary></table>",
         "<table><summary></summary><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_summary_scriptinside"},
    {input: "<summary media=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_media"},
    {input: "<summary nonce=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_nonce"},
    {input: "<summary srcset=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_srcset"},
    {input: "<summary srcdoc=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_srcdoc"},
    {input: "<summary poster=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_poster"},
    {input: "<summary autoplay=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_autoplay"},
    {input: "<summary controls=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_controls"},
    {input: "<summary formaction=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_formaction"},
    {input: "<summary formmethod=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_formmethod"},
    {input: "<summary pattern=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_pattern"},
    {input: "<summary icon=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_icon"},
    {input: "<summary select=\"x\">",
     acceptable: [
         "<summary></summary>",
         "<summary>",
         "<summary/>",
         "<summary />",
         "<table><summary></summary></table>",
         "<table><summary></table>",
         "<SUMMARY />",
         "<SUMMARY></SUMMARY>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_summary_select"},
    {input: "<menu></menu>",
     acceptable: [
         "<menu>",
         "<menu />",
         "<menu></menu>",
         "<table><menu></menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_plain"},
    {input: "<menu><script>alert()</script></menu>",
     acceptable: [
         "<menu>",
         "<menu />",
         "<menu></menu>",
         "<table><menu></menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<span></span>",
         "<span />",
         "",
         "<table><menu><td></td></menu></table>",
         "<table><menu></menu><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_menu_scriptinside"},
    {input: "<menu media=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_media"},
    {input: "<menu nonce=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_nonce"},
    {input: "<menu srcset=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_srcset"},
    {input: "<menu srcdoc=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_srcdoc"},
    {input: "<menu poster=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_poster"},
    {input: "<menu autoplay=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_autoplay"},
    {input: "<menu controls=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_controls"},
    {input: "<menu formaction=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_formaction"},
    {input: "<menu formmethod=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_formmethod"},
    {input: "<menu pattern=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_pattern"},
    {input: "<menu icon=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_icon"},
    {input: "<menu select=\"x\">",
     acceptable: [
         "<menu></menu>",
         "<menu>",
         "<menu/>",
         "<menu />",
         "<table><menu></menu></table>",
         "<table><menu></table>",
         "<MENU />",
         "<MENU></MENU>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menu_select"},
    {input: "<menuitem></menuitem>",
     acceptable: [
         "<menuitem>",
         "<menuitem />",
         "<menuitem></menuitem>",
         "<table><menuitem></menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_plain"},
    {input: "<menuitem><script>alert()</script></menuitem>",
     acceptable: [
         "<menuitem>",
         "<menuitem />",
         "<menuitem></menuitem>",
         "<table><menuitem></menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<span></span>",
         "<span />",
         "",
         "<table><menuitem><td></td></menuitem></table>",
         "<table><menuitem></menuitem><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_menuitem_scriptinside"},
    {input: "<menuitem icon=\"javascript:xss\">",
     acceptable: [
         "<menuitem icon=\"about:invalid#zCSafez\"></menuitem>",
         "<menuitem icon=\"about:invalid#zCSafez\">",
         "<menuitem icon=\"about:invalid#zGoSafez\"></menuitem>",
         "<menuitem icon=\"about:invalid#zGoSafez\"/>",
         "<menuitem icon=\"javascript:void(0);\"></menuitem>",
         "<menuitem icon=\"javascript:void(0);\">",
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_icon"},
    {input: "<menuitem media=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_media"},
    {input: "<menuitem nonce=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_nonce"},
    {input: "<menuitem srcset=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_srcset"},
    {input: "<menuitem srcdoc=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_srcdoc"},
    {input: "<menuitem poster=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_poster"},
    {input: "<menuitem autoplay=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_autoplay"},
    {input: "<menuitem controls=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_controls"},
    {input: "<menuitem formaction=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_formaction"},
    {input: "<menuitem formmethod=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_formmethod"},
    {input: "<menuitem pattern=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_pattern"},
    {input: "<menuitem select=\"x\">",
     acceptable: [
         "<menuitem></menuitem>",
         "<menuitem>",
         "<menuitem/>",
         "<menuitem />",
         "<table><menuitem></menuitem></table>",
         "<table><menuitem></table>",
         "<MENUITEM />",
         "<MENUITEM></MENUITEM>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_menuitem_select"},
    {input: "<dialog></dialog>",
     acceptable: [
         "<dialog>",
         "<dialog />",
         "<dialog></dialog>",
         "<table><dialog></dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_plain"},
    {input: "<dialog><script>alert()</script></dialog>",
     acceptable: [
         "<dialog>",
         "<dialog />",
         "<dialog></dialog>",
         "<table><dialog></dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<span></span>",
         "<span />",
         "",
         "<table><dialog><td></td></dialog></table>",
         "<table><dialog></dialog><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_dialog_scriptinside"},
    {input: "<dialog media=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_media"},
    {input: "<dialog nonce=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_nonce"},
    {input: "<dialog srcset=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_srcset"},
    {input: "<dialog srcdoc=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_srcdoc"},
    {input: "<dialog poster=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_poster"},
    {input: "<dialog autoplay=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_autoplay"},
    {input: "<dialog controls=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_controls"},
    {input: "<dialog formaction=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_formaction"},
    {input: "<dialog formmethod=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_formmethod"},
    {input: "<dialog pattern=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_pattern"},
    {input: "<dialog icon=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_icon"},
    {input: "<dialog select=\"x\">",
     acceptable: [
         "<dialog></dialog>",
         "<dialog>",
         "<dialog/>",
         "<dialog />",
         "<table><dialog></dialog></table>",
         "<table><dialog></table>",
         "<DIALOG />",
         "<DIALOG></DIALOG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_dialog_select"},
    {input: "<script></script>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_plain"},
    {input: "<script><script>alert()</script></script>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_scriptinside"},
    {input: "<script media=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_media"},
    {input: "<script srcset=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_srcset"},
    {input: "<script srcdoc=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_srcdoc"},
    {input: "<script poster=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_poster"},
    {input: "<script autoplay=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_autoplay"},
    {input: "<script controls=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_controls"},
    {input: "<script formaction=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_formaction"},
    {input: "<script formmethod=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_formmethod"},
    {input: "<script pattern=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_pattern"},
    {input: "<script icon=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_icon"},
    {input: "<script select=\"x\">",
     acceptable: [
         "<script></script>",
         "<script>",
         "<script/>",
         "<script />",
         "<table><script></script></table>",
         "<table><script></table>",
         "<SCRIPT />",
         "<SCRIPT></SCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_script_select"},
    {input: "<noscript media=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_media"},
    {input: "<noscript nonce=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_nonce"},
    {input: "<noscript srcset=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_srcset"},
    {input: "<noscript srcdoc=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_srcdoc"},
    {input: "<noscript poster=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_poster"},
    {input: "<noscript autoplay=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_autoplay"},
    {input: "<noscript controls=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_controls"},
    {input: "<noscript formaction=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_formaction"},
    {input: "<noscript formmethod=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_formmethod"},
    {input: "<noscript pattern=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_pattern"},
    {input: "<noscript icon=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_icon"},
    {input: "<noscript select=\"x\">",
     acceptable: [
         "<noscript></noscript>",
         "<noscript>",
         "<noscript/>",
         "<noscript />",
         "<table><noscript></noscript></table>",
         "<table><noscript></table>",
         "<NOSCRIPT />",
         "<NOSCRIPT></NOSCRIPT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_noscript_select"},
    {input: "<template></template>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_plain"},
    {input: "<template><script>alert()</script></template>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_scriptinside"},
    {input: "<template media=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_media"},
    {input: "<template nonce=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_nonce"},
    {input: "<template srcset=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_srcset"},
    {input: "<template srcdoc=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_srcdoc"},
    {input: "<template poster=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_poster"},
    {input: "<template autoplay=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_autoplay"},
    {input: "<template controls=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_controls"},
    {input: "<template formaction=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_formaction"},
    {input: "<template formmethod=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_formmethod"},
    {input: "<template pattern=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_pattern"},
    {input: "<template icon=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_icon"},
    {input: "<template select=\"x\">",
     acceptable: [
         "<template></template>",
         "<template>",
         "<template/>",
         "<template />",
         "<table><template></template></table>",
         "<table><template></table>",
         "<TEMPLATE />",
         "<TEMPLATE></TEMPLATE>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_template_select"},
    {input: "<slot></slot>",
     acceptable: [
         "<slot>",
         "<slot />",
         "<slot></slot>",
         "<table><slot></slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_plain"},
    {input: "<slot><script>alert()</script></slot>",
     acceptable: [
         "<slot>",
         "<slot />",
         "<slot></slot>",
         "<table><slot></slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<span></span>",
         "<span />",
         "",
         "<table><slot><td></td></slot></table>",
         "<table><slot></slot><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_slot_scriptinside"},
    {input: "<slot media=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_media"},
    {input: "<slot nonce=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_nonce"},
    {input: "<slot srcset=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_srcset"},
    {input: "<slot srcdoc=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_srcdoc"},
    {input: "<slot poster=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_poster"},
    {input: "<slot autoplay=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_autoplay"},
    {input: "<slot controls=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_controls"},
    {input: "<slot formaction=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_formaction"},
    {input: "<slot formmethod=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_formmethod"},
    {input: "<slot pattern=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_pattern"},
    {input: "<slot icon=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_icon"},
    {input: "<slot select=\"x\">",
     acceptable: [
         "<slot></slot>",
         "<slot>",
         "<slot/>",
         "<slot />",
         "<table><slot></slot></table>",
         "<table><slot></table>",
         "<SLOT />",
         "<SLOT></SLOT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_slot_select"},
    {input: "<canvas></canvas>",
     acceptable: [
         "<canvas>",
         "<canvas />",
         "<canvas></canvas>",
         "<table><canvas></canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_plain"},
    {input: "<canvas><script>alert()</script></canvas>",
     acceptable: [
         "<canvas>",
         "<canvas />",
         "<canvas></canvas>",
         "<table><canvas></canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<span></span>",
         "<span />",
         "",
         "<table><canvas><td></td></canvas></table>",
         "<table><canvas></canvas><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_canvas_scriptinside"},
    {input: "<canvas media=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_media"},
    {input: "<canvas nonce=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_nonce"},
    {input: "<canvas srcset=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_srcset"},
    {input: "<canvas srcdoc=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_srcdoc"},
    {input: "<canvas poster=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_poster"},
    {input: "<canvas autoplay=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_autoplay"},
    {input: "<canvas controls=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_controls"},
    {input: "<canvas formaction=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_formaction"},
    {input: "<canvas formmethod=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_formmethod"},
    {input: "<canvas pattern=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_pattern"},
    {input: "<canvas icon=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_icon"},
    {input: "<canvas select=\"x\">",
     acceptable: [
         "<canvas></canvas>",
         "<canvas>",
         "<canvas/>",
         "<canvas />",
         "<table><canvas></canvas></table>",
         "<table><canvas></table>",
         "<CANVAS />",
         "<CANVAS></CANVAS>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_canvas_select"},
    {input: "<applet></applet>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_plain"},
    {input: "<applet><script>alert()</script></applet>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_scriptinside"},
    {input: "<applet media=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_media"},
    {input: "<applet nonce=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_nonce"},
    {input: "<applet srcset=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_srcset"},
    {input: "<applet srcdoc=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_srcdoc"},
    {input: "<applet poster=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_poster"},
    {input: "<applet autoplay=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_autoplay"},
    {input: "<applet controls=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_controls"},
    {input: "<applet formaction=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_formaction"},
    {input: "<applet formmethod=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_formmethod"},
    {input: "<applet pattern=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_pattern"},
    {input: "<applet icon=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_icon"},
    {input: "<applet select=\"x\">",
     acceptable: [
         "<applet></applet>",
         "<applet>",
         "<applet/>",
         "<applet />",
         "<table><applet></applet></table>",
         "<table><applet></table>",
         "<APPLET />",
         "<APPLET></APPLET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_applet_select"},
    {input: "<math></math>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_plain"},
    {input: "<math><script>alert()</script></math>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_scriptinside"},
    {input: "<math media=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_media"},
    {input: "<math nonce=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_nonce"},
    {input: "<math srcset=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_srcset"},
    {input: "<math srcdoc=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_srcdoc"},
    {input: "<math poster=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_poster"},
    {input: "<math autoplay=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_autoplay"},
    {input: "<math controls=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_controls"},
    {input: "<math formaction=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_formaction"},
    {input: "<math formmethod=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_formmethod"},
    {input: "<math pattern=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_pattern"},
    {input: "<math icon=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_icon"},
    {input: "<math select=\"x\">",
     acceptable: [
         "<math></math>",
         "<math>",
         "<math/>",
         "<math />",
         "<table><math></math></table>",
         "<table><math></table>",
         "<MATH />",
         "<MATH></MATH>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_math_select"},
    {input: "<svg></svg>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_plain"},
    {input: "<svg><script>alert()</script></svg>",
     acceptable: [
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_scriptinside"},
    {input: "<svg media=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_media"},
    {input: "<svg nonce=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_nonce"},
    {input: "<svg srcset=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_srcset"},
    {input: "<svg srcdoc=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_srcdoc"},
    {input: "<svg poster=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_poster"},
    {input: "<svg autoplay=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_autoplay"},
    {input: "<svg controls=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_controls"},
    {input: "<svg formaction=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_formaction"},
    {input: "<svg formmethod=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_formmethod"},
    {input: "<svg pattern=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_pattern"},
    {input: "<svg icon=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_icon"},
    {input: "<svg select=\"x\">",
     acceptable: [
         "<svg></svg>",
         "<svg>",
         "<svg/>",
         "<svg />",
         "<table><svg></svg></table>",
         "<table><svg></table>",
         "<SVG />",
         "<SVG></SVG>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_svg_select"},
    {input: "<frameset></frameset>",
     acceptable: [
         "<frameset>",
         "<frameset />",
         "<frameset></frameset>",
         "<table><frameset></frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_plain"},
    {input: "<frameset><script>alert()</script></frameset>",
     acceptable: [
         "<frameset>",
         "<frameset />",
         "<frameset></frameset>",
         "<table><frameset></frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<span></span>",
         "<span />",
         "",
         "<table><frameset><td></td></frameset></table>",
         "<table><frameset></frameset><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_frameset_scriptinside"},
    {input: "<frameset media=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_media"},
    {input: "<frameset nonce=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_nonce"},
    {input: "<frameset srcset=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_srcset"},
    {input: "<frameset srcdoc=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_srcdoc"},
    {input: "<frameset poster=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_poster"},
    {input: "<frameset autoplay=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_autoplay"},
    {input: "<frameset controls=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_controls"},
    {input: "<frameset formaction=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_formaction"},
    {input: "<frameset formmethod=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_formmethod"},
    {input: "<frameset pattern=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_pattern"},
    {input: "<frameset icon=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_icon"},
    {input: "<frameset select=\"x\">",
     acceptable: [
         "<frameset></frameset>",
         "<frameset>",
         "<frameset/>",
         "<frameset />",
         "<table><frameset></frameset></table>",
         "<table><frameset></table>",
         "<FRAMESET />",
         "<FRAMESET></FRAMESET>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frameset_select"},
    {input: "<frame></frame>",
     acceptable: [
         "<frame>",
         "<frame />",
         "<frame></frame>",
         "<table><frame></frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_plain"},
    {input: "<frame><script>alert()</script></frame>",
     acceptable: [
         "<frame>",
         "<frame />",
         "<frame></frame>",
         "<table><frame></frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<span></span>",
         "<span />",
         "",
         "<table><frame><td></td></frame></table>",
         "<table><frame></frame><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_frame_scriptinside"},
    {input: "<frame media=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_media"},
    {input: "<frame nonce=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_nonce"},
    {input: "<frame srcset=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_srcset"},
    {input: "<frame srcdoc=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_srcdoc"},
    {input: "<frame poster=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_poster"},
    {input: "<frame autoplay=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_autoplay"},
    {input: "<frame controls=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_controls"},
    {input: "<frame formaction=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_formaction"},
    {input: "<frame formmethod=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_formmethod"},
    {input: "<frame pattern=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_pattern"},
    {input: "<frame icon=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_icon"},
    {input: "<frame select=\"x\">",
     acceptable: [
         "<frame></frame>",
         "<frame>",
         "<frame/>",
         "<frame />",
         "<table><frame></frame></table>",
         "<table><frame></table>",
         "<FRAME />",
         "<FRAME></FRAME>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_frame_select"},
    {input: "<font></font>",
     acceptable: [
         "<font>",
         "<font />",
         "<font></font>",
         "<table><font></font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_plain"},
    {input: "<font><script>alert()</script></font>",
     acceptable: [
         "<font>",
         "<font />",
         "<font></font>",
         "<table><font></font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<span></span>",
         "<span />",
         "",
         "<table><font><td></td></font></table>",
         "<table><font></font><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_font_scriptinside"},
    {input: "<font media=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_media"},
    {input: "<font nonce=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_nonce"},
    {input: "<font srcset=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_srcset"},
    {input: "<font srcdoc=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_srcdoc"},
    {input: "<font poster=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_poster"},
    {input: "<font autoplay=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_autoplay"},
    {input: "<font controls=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_controls"},
    {input: "<font formaction=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_formaction"},
    {input: "<font formmethod=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_formmethod"},
    {input: "<font pattern=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_pattern"},
    {input: "<font icon=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_icon"},
    {input: "<font select=\"x\">",
     acceptable: [
         "<font></font>",
         "<font>",
         "<font/>",
         "<font />",
         "<table><font></font></table>",
         "<table><font></table>",
         "<FONT />",
         "<FONT></FONT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_font_select"},
    {input: "<content></content>",
     acceptable: [
         "<content>",
         "<content />",
         "<content></content>",
         "<table><content></content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_plain"},
    {input: "<content><script>alert()</script></content>",
     acceptable: [
         "<content>",
         "<content />",
         "<content></content>",
         "<table><content></content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<span></span>",
         "<span />",
         "",
         "<table><content><td></td></content></table>",
         "<table><content></content><td></td></table>",
         "<table><td></td></table>",
     ],
     name: "contract_content_scriptinside"},
    {input: "<content media=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_media"},
    {input: "<content nonce=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_nonce"},
    {input: "<content srcset=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_srcset"},
    {input: "<content srcdoc=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_srcdoc"},
    {input: "<content poster=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_poster"},
    {input: "<content autoplay=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_autoplay"},
    {input: "<content controls=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_controls"},
    {input: "<content formaction=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_formaction"},
    {input: "<content formmethod=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_formmethod"},
    {input: "<content pattern=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_pattern"},
    {input: "<content icon=\"x\">",
     acceptable: [
         "<content></content>",
         "<content>",
         "<content/>",
         "<content />",
         "<table><content></content></table>",
         "<table><content></table>",
         "<CONTENT />",
         "<CONTENT></CONTENT>",
         "<select><option>High Grade</option><option>Medium Grade</option></select>",
         "<span></span>",
         "<span />",
         "",
     ],
     name: "contract_content_icon"},
    {input: "<p style=\"javascript:xss\"></p>",
     acceptable: [
         "<p style=\"about:invalid#zCSafez\"></p>",
         "<p style=\"about:invalid#zGoSafez\"></p>",
         "<p style=\"javascript:void(0);\"></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_style"},
    {input: "<p aria-activedescendant=\"javascript:xss\"></p>",
     acceptable: [
         "<p aria-activedescendant=\"about:invalid#zCSafez\"></p>",
         "<p aria-activedescendant=\"about:invalid#zGoSafez\"></p>",
         "<p aria-activedescendant=\"javascript:void(0);\"></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_aria-activedescendant"},
    {input: "<p async=\"x\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_async"},
    {input: "<p async=\"async\"></p>",
     acceptable: [
         "<p async=\"async\"></p>",
         "<p async=async></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_async_async"},
    {input: "<p for=\"javascript:xss\"></p>",
     acceptable: [
         "<p for=\"about:invalid#zCSafez\"></p>",
         "<p for=\"about:invalid#zGoSafez\"></p>",
         "<p for=\"javascript:void(0);\"></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_for"},
    {input: "<p id=\"javascript:xss\"></p>",
     acceptable: [
         "<p id=\"about:invalid#zCSafez\"></p>",
         "<p id=\"about:invalid#zGoSafez\"></p>",
         "<p id=\"javascript:void(0);\"></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_id"},
    {input: "<p list=\"javascript:xss\"></p>",
     acceptable: [
         "<p list=\"about:invalid#zCSafez\"></p>",
         "<p list=\"about:invalid#zGoSafez\"></p>",
         "<p list=\"javascript:void(0);\"></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_list"},
    {input: "<p name=\"javascript:xss\"></p>",
     acceptable: [
         "<p name=\"about:invalid#zCSafez\"></p>",
         "<p name=\"about:invalid#zGoSafez\"></p>",
         "<p name=\"javascript:void(0);\"></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_name"},
    {input: "<p src=\"x\"></p>",
     acceptable: [
         "<p src=\"javascript:void(0);\"></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_src"},
    {input: "<p target=\"x\"></p>",
     acceptable: [
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_target"},
    {input: "<p target=\"_self\"></p>",
     acceptable: [
         "<p target=\"_self\"></p>",
         "<p target=_self></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_target__self"},
    {input: "<p target=\"_blank\"></p>",
     acceptable: [
         "<p target=\"_blank\"></p>",
         "<p target=_blank></p>",
         "<p></p>",
         "<p />",
         "",
     ],
     name: "contract_target__blank"},
];
