if ("__addLocaleData" in Intl.ListFormat) {
    Intl.ListFormat.__addLocaleData({
        locale: "sd",
        data: {
            formats: {
                conjunction: {
                    'long': {
                        Pair: '{0} ۽ {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0}، ۽ {1}'
                    },
                    'short': {
                        Pair: '{0} ۽ {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0}، ۽ {1}'
                    },
                    narrow: {
                        Pair: '{0}, {1}',
                        Start: '{0}, {1}',
                        Middle: undefined,
                        End: '{0}, {1}'
                    }
                },
                disjunction: {
                    'long': {
                        Pair: '{0} يا {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0}, يا {1}'
                    },
                    'short': {
                        Pair: '{0} يا {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0}, يا {1}'
                    },
                    narrow: {
                        Pair: '{0} يا {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0}, يا {1}'
                    }
                },
                unit: {
                    'long': {
                        Pair: '{0}, {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0}, {1}'
                    },
                    'short': {
                        Pair: '{0}, {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0}, {1}'
                    },
                    narrow: {
                        Pair: '{0}, {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0}, {1}'
                    }
                }
            }
        }
    });
}
