if ("__addLocaleData" in Intl.ListFormat) {
    Intl.ListFormat.__addLocaleData({
        locale: "gd",
        data: {
            formats: {
                conjunction: {
                    'long': {
                        Pair: '{0} agus {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0} agus {1}'
                    },
                    'short': {
                        Pair: '{0} ⁊ {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0} ⁊ {1}'
                    },
                    narrow: {
                        Pair: '{0}, {1}',
                        Start: undefined,
                        Middle: undefined,
                        End: '{0}, {1}'
                    }
                },
                disjunction: {
                    'long': {
                        Pair: '{0} no {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0} no {1}'
                    },
                    'short': {
                        Pair: '{0} no {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0} no {1}'
                    },
                    narrow: {
                        Pair: '{0} no {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0} no {1}'
                    }
                },
                unit: {
                    'long': {
                        Pair: '{0} agus {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0} agus {1}'
                    },
                    'short': {
                        Pair: '{0} ’s {1}',
                        Start: '{0}, {1}',
                        Middle: '{0}, {1}',
                        End: '{0} ’s {1}'
                    },
                    narrow: {
                        Pair: '{0} {1}',
                        Start: '{0} {1}',
                        Middle: '{0} {1}',
                        End: '{0} {1}'
                    }
                }
            }
        }
    });
}
