(function () {
  'use strict';

  var SUPPORTS_LIST_FORMAT = "ListFormat" in Intl;

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  

  

  

  var TYPE = ["conjunction", "disjunction", "unit"];

  var STYLE = ["long", "short", "narrow"];

  var LOCALE_MATCHER = ["lookup", "best fit"];

  

  

  

  

  

  function _typeof2(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof2 = function _typeof2(obj) { return typeof obj; }; } else { _typeof2 = function _typeof2(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof2(obj); }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  /* tslint:disable:use-primitive-type no-construct no-any */

  /**
   * The abstract operation ToObject converts argument to a value of type Object.
   *
   * https://tc39.github.io/ecma262/#sec-toobject
   * @param {T} argument
   * @returns{T extends boolean ? Boolean : T extends number ? Number : T extends string ? String : T extends symbol ? symbol : T}
   */
  function toObject(argument) {
    if (argument == null) {
      throw new TypeError("Argument ".concat(argument, " cannot be converted to an Object"));
    }

    if (typeof argument === "boolean") {
      return new Boolean(argument);
    }

    if (typeof argument === "number") {
      return new Number(argument);
    }

    if (typeof argument === "string") {
      return new String(argument);
    }

    if (_typeof(argument) === "symbol") {
      return new Object(argument);
    }

    return argument;
  }

  /**
   * Must represent the structurally valid (6.2.2) and canonicalized (6.2.3) BCP 47 language tag for the host environment's current locale.
   *
   * https://tc39.github.io/ecma402/#sec-defaultlocale
   * @type {Locale?}
   */

  var _defaultLocale;
  /**
   * Sets the default locale
   * @param {Locale} locale
   */


  function setDefaultLocale(locale) {
    _defaultLocale = locale;
  }
  /**
   * The DefaultLocale abstract operation returns a String value representing the structurally valid (6.2.2) and canonicalized (6.2.3) BCP 47 language tag for the host environment's current locale.
   * https://tc39.github.io/ecma402/#sec-defaultlocale
   * @returns{Locale | undefined}
   */

  function getDefaultLocale() {
    return _defaultLocale;
  }
  /**
   * Retrieves the default locale if it is set, and throws otherwise
   * @returns{Locale}
   */

  function ensureDefaultLocale() {
    if (_defaultLocale == null) {
      throw new ReferenceError("Could not determine locale: No default locale has been configured");
    }

    return _defaultLocale;
  }

  

  

  

  /**
   * A WeakMap between ListFormat instances and their internal slot members
   * @type {WeakMap<ListFormat, ListFormatInstanceInternals>}
   */

  var LIST_FORMAT_INSTANCE_INTERNAL_MAP = new WeakMap();
  /**
   * Contains the internal static for ListFormat
   * @type {ListFormatStaticInternals}
   */

  var LIST_FORMAT_STATIC_INTERNALS = {
    /**
     * The value of the [[RelevantExtensionKeys]] internal slot is « ».
     * http://tc39.github.io/proposal-intl-list-format/#sec-Intl.ListFormat-internal-slots
     */
    relevantExtensionKeys: [],

    /**
     * The value of the [[LocaleData]] internal slot is implementation defined within the constraints described in 9.1
     * http://tc39.github.io/proposal-intl-list-format/#sec-Intl.ListFormat-internal-slots
     */
    localeData: {},

    /**
     * The value of the [[AvailableLocales]] internal slot is implementation defined within the constraints described in 9.1.
     * http://tc39.github.io/proposal-intl-list-format/#sec-Intl.ListFormat-internal-slots
     */
    availableLocales: []
  };
  /**
   * Sets the value for a property in an internal slot for an instance of ListFormat
   * @param {ListFormat} instance
   * @param {T} property
   * @param {ListFormatInstanceInternals[T]} value
   */

  function setInternalSlot(instance, property, value) {
    var record = LIST_FORMAT_INSTANCE_INTERNAL_MAP.get(instance);

    if (record == null) {
      record = Object.create(null);
      LIST_FORMAT_INSTANCE_INTERNAL_MAP.set(instance, record);
    } // Update the property with the given value


    record[property] = value;
  }
  /**
   * Gets the value associated with the given property on the internal slots of the given instance of ListFormat
   * @param {ListFormat} instance
   * @param {T} property
   * @returns{ListFormatInstanceInternals[T]}
   */

  function getInternalSlot(instance, property) {
    var record = LIST_FORMAT_INSTANCE_INTERNAL_MAP.get(instance);

    if (record == null) {
      throw new ReferenceError("No internal slots has been allocated for the given instance of ListFormat");
    }

    return record[property];
  }
  /**
   * Returns true if the given property on the internal slots of the given instance of ListFormat exists
   * @param {ListFormat} instance
   * @param {T} property
   * @returns{ListFormatInstanceInternals[T]}
   */

  function hasInternalSlot(instance, property) {
    var record = LIST_FORMAT_INSTANCE_INTERNAL_MAP.get(instance);
    return record != null && property in record;
  }

  

  /**
   * A Regular Expression that matches Unicode extension sequences
   * @type {RegExp}
   */
  var UNICODE_EXTENSION_SEQUENCE_REGEXP = /-u(?:-[0-9a-z]{2,8})+/gi;
  /**
   * Removes all Unicode characters from the given string
   * @param {string} str
   * @returns{string}
   */

  function removeUnicodeExtensionSequences(str) {
    return str.replace(UNICODE_EXTENSION_SEQUENCE_REGEXP, "");
  }

  /**
   * The BestAvailableLocale abstract operation compares the provided argument locale,
   * which must be a String value with a structurally valid and canonicalized BCP 47 language tag,
   * against the locales in availableLocales and returns either the longest non-empty prefix of locale
   * that is an element of availableLocales, or undefined if there is no such element. It uses the fallback
   * mechanism of RFC 4647, section 3.4.
   *
   * https://tc39.github.io/ecma402/#sec-bestavailablelocale
   * @param {Locales} availableLocales
   * @param {Locale} locale
   * @returns{string}
   */

  function bestAvailableLocale(availableLocales, locale) {
    // Let candidate be locale.
    var candidate = locale; // Repeat

    while (true) {
      // If availableLocales contains an element equal to candidate, return candidate.
      if (availableLocales.includes(candidate)) {
        return candidate;
      } // Let pos be the character index of the last occurrence of "-" (U+002D) within candidate.


      var pos = candidate.lastIndexOf("-"); // If that character does not occur, return undefined.

      if (pos === -1) return undefined; // If pos ≥ 2 and the character "-" occurs at index pos-2 of candidate, decrease pos by 2.

      if (pos >= 2 && candidate.charAt(pos - 2) === "-") {
        pos -= 2;
      } // Let candidate be the substring of candidate from position 0, inclusive, to position pos, exclusive.


      candidate = candidate.slice(0, pos);
    }
  }

  /**
   * The LookupSupportedLocales abstract operation returns the subset of the provided BCP 47 language priority list
   * requestedLocales for which availableLocales has a matching locale when using the BCP 47 Lookup algorithm.
   * Locales appear in the same order in the returned list as in requestedLocales.
   *
   * https://tc39.github.io/ecma402/#sec-bestfitsupportedlocales
   * @param {Locales} availableLocales
   * @param {Locales} requestedLocales
   * @returns{Locales}
   */

  function lookupSupportedLocales(availableLocales, requestedLocales) {
    // Let subset be a new empty List.
    var subset = []; // For each element locale of requestedLocales in List order, do

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = requestedLocales[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var locale = _step.value;
        // Let noExtensionsLocale be the String value that is locale with all Unicode locale extension sequences removed.
        var noExtensionsLocale = removeUnicodeExtensionSequences(locale); // Let availableLocale be BestAvailableLocale(availableLocales, noExtensionsLocale).

        var availableLocale = bestAvailableLocale(availableLocales, noExtensionsLocale); // If availableLocale is not undefined, append locale to the end of subset.

        if (availableLocale !== undefined) {
          subset.push(locale);
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return subset;
  }

  /**
   * The BestFitSupportedLocales abstract operation returns the subset of the provided BCP 47 language priority list
   * requestedLocales for which availableLocales has a matching locale when using the Best Fit Matcher algorithm.
   * Locales appear in the same order in the returned list as in requestedLocales.
   *
   * https://tc39.github.io/ecma402/#sec-bestfitsupportedlocales
   * @param {Locales} availableLocales
   * @param {Locales} requestedLocales
   * @returns{Locales}
   */

  function bestFitSupportedLocales(availableLocales, requestedLocales) {
    return lookupSupportedLocales(availableLocales, requestedLocales);
  }

  /**
   * The abstract operation IsPropertyKey determines if argument, which must be an ECMAScript language value, is a value that may be used as a property key.
   * https://tc39.es/ecma262/#sec-ispropertykey
   * @param {*} argument
   * @returns {boolean}
   */
  function isPropertyKey(argument) {
    // If Type(argument) is String, return true.
    if (typeof argument === "string") return true; // If Type(argument) is Symbol, return true.

    if (_typeof(argument) === "symbol") return true; // Return false.

    return false;
  }

  /**
   * The abstract operation Get is used to retrieve the value of a specific property of an object. The operation is called with arguments O and P where O is the object and P is the property key.
   * https://tc39.es/ecma262/#sec-get-o-p
   * @param {O} o
   * @param {P} p
   * @returns {O[P]}
   */

  function get(o, p) {
    // Assert: Type(O) is Object.
    if (_typeof(o) !== "object") {
      throw new TypeError("Given argument ".concat(o, " must be of type Object"));
    } // Assert: IsPropertyKey(P) is true.


    if (!isPropertyKey(p)) {
      throw new TypeError("Given argument ".concat(p, " must be a PropertyKey"));
    }

    return o[p];
  }

  /**
   * The abstract operation ToBoolean converts argument to a value of type Boolean
   * https://tc39.es/ecma262/#sec-toboolean
   * @param {*} argument
   * @returns {boolean}
   */
  function toBoolean(argument) {
    return Boolean(argument);
  }

  /**
   * The abstract operation ToString converts argument to a value of type String
   * https://tc39.es/ecma262/#sec-tostring
   * @param {*} argument
   * @returns {boolean}
   */
  function toString(argument) {
    return argument + "";
  }

  /**
   * https://tc39.es/ecma402/#sec-getoption
   * @param {Options} options
   * @param {Property} property
   * @param {Type} type
   * @param {Values} values
   * @param {Fallback} fallback
   * @returns {Return}
   */

  function getOption(options, property, type, values, fallback) {
    // Let value be ? Get(options, property).
    var value = get(options, property); // If value is not undefined, then

    if (value !== undefined) {
      // Assert: type is "boolean" or "string".
      if (type !== "boolean" && type !== "string") {
        throw new TypeError("Expected type ".concat(type, " to be 'boolean' or 'string"));
      } // If type is "boolean", then


      if (type === "boolean") {
        // Let value be ToBoolean(value).
        value = toBoolean(value);
      } // If type is "string", then


      if (type === "string") {
        // Let value be ? ToString(value).
        value = toString(value);
      } // If values is not undefined, then


      if (values !== undefined) {
        // If values does not contain an element equal to value, throw a RangeError exception.
        // tslint:disable-next-line:no-collapsible-if
        if (!values.includes(value)) {
          throw new RangeError("Value ".concat(value, " out of range for options property ").concat(property));
        }
      } // Return value.


      return value;
    } // Else, return fallback.
    else {
        return fallback;
      }
  }

  /**
   * The SupportedLocales abstract operation returns the subset of the provided BCP 47 language priority list
   * requestedLocales for which availableLocales has a matching locale. Two algorithms are available to match
   * the locales: the Lookup algorithm described in RFC 4647 section 3.4, and an implementation dependent
   * best-fit algorithm. Locales appear in the same order in the returned list as in requestedLocales.
   *
   * https://tc39.github.io/ecma402/#sec-supportedlocales
   * @param {Locales} availableLocales
   * @param {Locales} requestedLocales
   * @param {SupportedLocalesOptions} [options]
   * @returns{Locales}
   */

  function supportedLocales(availableLocales, requestedLocales, options) {
    var matcher; // If options is not undefined, then

    if (options !== undefined) {
      // Let options be ? ToObject(options).
      options = toObject(options); // Let matcher be ? GetOption(options, "localeMatcher", "string", « "lookup", "best fit" », "best fit").

      matcher = getOption(options, "localeMatcher", "string", LOCALE_MATCHER, "best fit");
    } // Else, let matcher be "best fit".
    else {
        matcher = "best fit";
      } // If matcher is "best fit", then let supportedLocales be BestFitSupportedLocales(availableLocales, requestedLocales).
    // Else let supportedLocales be LookupSupportedLocales(availableLocales, requestedLocales).
    // Return CreateArrayFromList(supportedLocales).


    return matcher === "best fit" ? bestFitSupportedLocales(availableLocales, requestedLocales) : lookupSupportedLocales(availableLocales, requestedLocales);
  }

  

  

  

  

  /**
   * The LookupMatcher abstract operation compares requestedLocales, which must be a List as returned by CanonicalizeLocaleList,
   * against the locales in availableLocales and determines the best available language to meet the request.
   *
   * https://tc39.github.io/ecma402/#sec-lookupmatcher
   * @param {MatcherOptions} options
   * @returns{MatcherResult}
   */

  function lookupMatcher(_ref) {
    var availableLocales = _ref.availableLocales,
        requestedLocales = _ref.requestedLocales;
    // Let result be a new Record.
    var result = Object.create(null); // For each element locale of requestedLocales in List order, do

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = requestedLocales[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var locale = _step.value;
        // Let noExtensionsLocale be the String value that is locale with all Unicode locale extension sequences removed.
        var noExtensionsLocale = removeUnicodeExtensionSequences(locale); // Let availableLocale be BestAvailableLocale(availableLocales, noExtensionsLocale).

        var availableLocale = bestAvailableLocale(availableLocales, noExtensionsLocale); // If availableLocale is not undefined, then

        if (availableLocale !== undefined) {
          // Set result.[[locale]] to availableLocale.
          result.locale = availableLocale; // If locale and noExtensionsLocale are not the same String value, then

          if (locale !== noExtensionsLocale) {
            // Let extension be the String value consisting of the first substring of local
            // that is a Unicode locale extension sequence.
            var extensionMatch = locale.match(UNICODE_EXTENSION_SEQUENCE_REGEXP); // Set result.[[extension]] to extension.

            result.extension = extensionMatch == null ? "" : extensionMatch[0];
          }

          return result;
        }
      } // Let defLocale be DefaultLocale().

    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    var defLocale = ensureDefaultLocale(); // Set result.[[locale]] to defLocale.

    result.locale = defLocale; // Return result.

    return result;
  }

  /**
   * The BestFitMatcher abstract operation compares requestedLocales,
   * which must be a List as returned by CanonicalizeLocaleList,
   * against the locales in availableLocales and determines the best available language to meet the request.
   * The algorithm is implementation dependent, but should produce results that a typical user of the requested
   * locales would perceive as at least as good as those produced by the LookupMatcher abstract operation.
   * ListFormatOptions specified through Unicode locale extension sequences must be ignored by the algorithm.
   * Information about such subsequences is returned separately. The abstract operation returns a record
   * with a [[locale]] field, whose value is the language tag of the selected locale,
   * which must be an element of availableLocales.
   * If the language tag of the request locale that led to the selected locale contained a Unicode locale extension sequence,
   * then the returned record also contains an [[extension]] field whose value is the first Unicode locale extension sequence
   * within the request locale language tag.
   *
   * https://tc39.github.io/ecma402/#sec-bestfitmatcher
   * @param {MatcherOptions} options
   * @returns{MatcherResult}
   */

  function bestFitMatcher(options) {
    return lookupMatcher(options);
  }

  /**
   * The ResolveLocale abstract operation compares a BCP 47 language priority list
   * requestedLocales against the locales in availableLocales and determines the best available language to meet the request.
   * availableLocales, requestedLocales, and relevantExtensionKeys must be provided as List values,
   * options and localeData as Records.
   *
   * https://tc39.github.io/ecma402/#sec-resolvelocale
   * @param {Locales} availableLocales
   * @param {Locales} requestedLocales
   * @param {ResolveLocaleOptions} options
   * @param {RelevantExtensionKey[]} _relevantExtensionKeys
   * @param {LocaleData} _localeData
   * @returns {ResolveLocaleResult}
   */

  function resolveLocale(availableLocales, requestedLocales, options, _relevantExtensionKeys, _localeData) {
    // Let matcher be options.[[localeMatcher]].
    var matcher = options.localeMatcher; // If matcher is "lookup", then
    // (a) Let r be LookupMatcher(availableLocales, requestedLocales).
    // (b) Let r be BestFitMatcher(availableLocales, requestedLocales).

    var r = matcher === "lookup" ? lookupMatcher({
      availableLocales: availableLocales,
      requestedLocales: requestedLocales
    }) : bestFitMatcher({
      availableLocales: availableLocales,
      requestedLocales: requestedLocales
    }); // Let foundLocale be r.[[locale]].

    var foundLocale = r.locale; // Let result be a new Record.

    var result = Object.create(null); // Set result.[[dataLocale]] to foundLocale.

    result.dataLocale = foundLocale; // Let supportedExtension be "-u"

    var supportedExtension = "-u"; // For each element key of relevantExtensionKeys in List order, do
    // CORRECTION: According to the spec, there _are_ no relevant extension keys, so there's no point in walking through them
    // If the number of elements in supportedExtension is greater than 2, then

    if (supportedExtension.length > 2) {
      // Let privateIndex be Call(%StringProto_indexOf%, foundLocale, « "-x-" »).
      var privateIndex = String.prototype.indexOf.call(foundLocale, "-x-"); // If privateIndex = -1, then

      if (privateIndex === -1) {
        // Let foundLocale be the concatenation of foundLocale and supportedExtension.
        foundLocale = "".concat(foundLocale).concat(supportedExtension);
      } // Else,
      else {
          // Let preExtension be the substring of foundLocale from position 0, inclusive, to position privateIndex, exclusive.
          var preExtension = foundLocale.slice(0, privateIndex); // Let postExtension be the substring of foundLocale from position privateIndex to the end of the string.

          var postExtension = foundLocale.slice(privateIndex); // Let foundLocale be the concatenation of preExtension, supportedExtension, and postExtension.

          foundLocale = "".concat(preExtension).concat(supportedExtension).concat(postExtension);
        } // Assert: IsStructurallyValidLanguageTag(foundLocale) is true.
      // Let foundLocale be CanonicalizeLanguageTag(foundLocale).
      // Intl.getCanonicalLocales will throw a TypeError if the locale isn't structurally valid


      foundLocale = Intl.getCanonicalLocales(foundLocale)[0];
    } // Set result.[[locale]] to foundLocale.


    result.locale = foundLocale; // Return result.

    return result;
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  /**
   * Creates a String list from an iterable.
   * Algorithm: http://tc39.github.io/proposal-intl-list-format/#sec-createstringlistfromiterable
   * "This algorithm raises exceptions when it encounters values that are not Strings
   * because there is no obvious locale-aware coercion for arbitrary values."
   * @param {Iterable<string>} iterable
   * @return {string[]}
   */
  function stringListFromIterable(iterable) {
    // If iterable is undefined, then
    if (iterable === undefined) {
      // Return a new empty List.
      return [];
    } // Spread into an array


    var arr = _toConsumableArray(iterable); // If any of the elements isn't a string, throw a TypeError


    if (arr.some(function (element) {
      return typeof element !== "string";
    })) {
      throw new TypeError("All List items must be strings");
    }

    return arr;
  }

  

  

  /**
   * Returns true if the given item is a record
   * @param {T} item
   * @return {item is T}
   */
  function isRecord(item) {
    return Object.prototype.toString.call(item) === "[object Object]";
  }

  /**
   * Returns true if the given item is a List
   * @param {T} item
   * @return {item is T}
   */

  function isList(item) {
    return Array.isArray(item) || isRecord(item);
  }

  /**
   * The DeconstructPattern abstract operation is called with arguments pattern
   * (which must be a String) and placeables (which must be a Record),
   * and deconstructs the pattern string into a list of parts.
   * The placeables record is a record whose keys are placeables tokens used in the pattern string,
   * and values are parts records which will be used in the result List to represent the token part.
   *
   * http://tc39.github.io/proposal-intl-list-format/#sec-deconstructpattern
   * @param {string} pattern
   * @param {Placeables} placeables
   * @return {ListPartition[]}
   */

  function deconstructPattern(pattern, placeables) {
    // Let result be a new empty List.
    var result = []; // Let beginIndex be ! Call(%StringProto_indexOf%, pattern, « "{", 0 »).

    var beginIndex = String.prototype.indexOf.call(pattern, "{", 0); // Let nextIndex be 0.

    var nextIndex = 0; // Let length be the number of code units in pattern.

    var length = pattern.length; // Repeat, while beginIndex is an integer index into pattern

    while (pattern[beginIndex] !== undefined) {
      // Let endIndex to ! Call(%StringProto_indexOf%, pattern, « "}", beginIndex »).
      var endIndex = String.prototype.indexOf.call(pattern, "}", beginIndex); // Assert: endIndex is greater than beginIndex.

      if (endIndex <= beginIndex) {
        throw new TypeError("Expected endIndex: ".concat(endIndex, " to be greater than beginIndex: ").concat(beginIndex));
      } // If beginIndex is greater than nextIndex, then


      if (beginIndex > nextIndex) {
        // Let literal be a substring of pattern from position nextIndex, inclusive, to position beginIndex, exclusive.
        var literal = pattern.slice(nextIndex, beginIndex); // Append a new Record { [[Type]]: "literal", [[Value]]: literal } as the last element of result

        result.push({
          type: "literal",
          value: literal
        });
      } // Let part be the substring of pattern from position beginIndex, exclusive, to position endIndex, exclusive.


      var part = pattern.slice(beginIndex + 1, endIndex); // Assert: placeables has a field [[<part>]].

      if (placeables[Number(part)] == null) {
        throw new TypeError("Expected placeables to have a part for PropertyKey: ".concat(part));
      } // Let subst be placeables.[[<part>]].


      var subst = placeables[Number(part)]; // If Type(subst) is List, then

      if (isList(subst.value)) {
        // For each element s of subst in List order, do
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = subst.value[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var s = _step.value;
            // Append s as the last element of result.
            result.push(s);
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return != null) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      } // Else,
      else {
          // Append subst as the last element of result.
          result.push(subst);
        } // Set nextIndex to endIndex + 1.


      nextIndex = endIndex + 1; // Set beginIndex to ! Call(%StringProto_indexOf%, pattern, « "{", nextIndex »).

      beginIndex = String.prototype.indexOf.call(pattern, "{", nextIndex);
    } // If nextIndex is less than length, then


    if (nextIndex < length) {
      // Let literal be the substring of pattern from position nextIndex, inclusive, to position length, exclusive.
      var _literal = pattern.slice(nextIndex, length); // Append a new Record { [[Type]]: "literal", [[Value]]: literal } as the last element of result.


      result.push({
        type: "literal",
        value: _literal
      });
    } // Return result


    return result;
  }

  /**
   * The CreatePartsFromList abstract operation is called with arguments listFormat
   * (which must be an object initialized as a ListFormat) and list (which must be a List of String values),
   * and creates the corresponding list of parts according to the effective locale and the formatting options of listFormat.
   * Each part is a Record with two fields: [[Type]], which must be a string with values "element" or "literal",
   * and [[Value]] which must be a string or a number.
   * @param {ListFormat} listFormat
   * @param {string[]} list
   * @return {ListPartitions}
   */

  function createPartsFromList(listFormat, list) {
    var pattern; // Let size be the number of elements of list.

    var size = list.length; // If size is 0, then

    if (size === 0) {
      // Return a new empty List.
      return [];
    } // If size is 2, then


    if (size === 2) {
      // Let pattern be listFormat.[[TemplatePair]].
      pattern = getInternalSlot(listFormat, "templatePair"); // Let first be a new Record { [[Type]]: "element", [[Value]]: list[0] }.

      var first = {
        type: "element",
        value: list[0]
      }; // Let second be a new Record { [[Type]]: "element", [[Value]]: list[1] }.

      var second = {
        type: "element",
        value: list[1]
      }; // Let placeables be a new Record { [[0]]: first, [[1]]: second }.

      var placeables = {
        0: first,
        1: second
      }; // Return DeconstructPattern(pattern, placeables).

      return deconstructPattern(pattern, placeables);
    } // Let last be a new Record { [[Type]]: "element", [[Value]]: list[size - 1] }.


    var last = {
      type: "element",
      value: list[size - 1]
    }; // Let parts be « last ».

    var parts = [last]; // Let i be size - 2.

    var i = size - 2; // Repeat, while i ≥ 0

    while (i >= 0) {
      // If i is 0, then
      if (i === 0) {
        // Let pattern be listFormat.[[TemplateStart]].
        pattern = getInternalSlot(listFormat, "templateStart");
      } // Else, if i is less than size - 2, then
      else if (i < size - 2) {
          // Let pattern be listFormat.[[TemplateMiddle]].
          pattern = getInternalSlot(listFormat, "templateMiddle");
        } // Else,
        else {
            // Let pattern be listFormat.[[TemplateEnd]].
            pattern = getInternalSlot(listFormat, "templateEnd");
          } // Let head be a new Record { [[Type]]: "element", [[Value]]: list[i] }.


      var head = {
        type: "element",
        value: list[i]
      }; // Let tail be a new Record { [[Type]]: "element", [[Value]]: parts }.

      var tail = {
        type: "element",
        value: parts
      }; // Let placeables be a new Record { [[0]]: head, [[1]]: tail }.

      var _placeables = {
        0: head,
        1: tail
      }; // Set parts to DeconstructPattern(pattern, placeables).

      parts = deconstructPattern(pattern, _placeables); // Decrement i by 1.

      i--;
    } // Return parts.


    return parts;
  }

  /**
   * The FormatList abstract operation is called with arguments listFormat
   * (which must be an object initialized as a ListFormat) and list (which must be a List of String values)
   *
   * http://tc39.github.io/proposal-intl-list-format/#sec-formatlist
   * @param {ListFormat} listFormat
   * @param {string[]} list
   * @returns {string}
   */

  function formatList(listFormat, list) {
    // Let parts be CreatePartsFromList(listFormat, list).
    var parts = createPartsFromList(listFormat, list); // Let result be an empty String.

    var result = ""; // For each part in parts, do

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = parts[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var part = _step.value;
        // Set result to a String value produced by concatenating result and part.[[Value]].
        result += part.value;
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return result;
  }

  /**
   * The FormatListToParts abstract operation is called with arguments listFormat
   * (which must be an object initialized as a ListFormat) and list (which must be a List of String values)
   *
   * http://tc39.github.io/proposal-intl-list-format/#sec-formatlisttoparts
   * @param {ListFormat} listFormat
   * @param {string[]} list
   * @returns {ListPartitions}
   */

  function formatListToParts(listFormat, list) {
    return createPartsFromList(listFormat, list);
  }

  /**
   * The ListFormat constructor is the %ListFormat% intrinsic object and a standard built-in property of the Intl object.
   * Behaviour common to all service constructor properties of the Intl object is specified in 9.1.
   *
   * http://tc39.github.io/proposal-intl-list-format/#sec-intl-listformat-constructor
   */

  var ListFormat =
  /*#__PURE__*/
  function () {
    // The spec states that the constructor must have a length of 0 and therefore be parameter-less
    function ListFormat() {
      _classCallCheck(this, ListFormat);

      var locales = arguments[0];
      var options = arguments[1]; // If NewTarget is undefined, throw a TypeError exception.

      if ((this instanceof ListFormat ? this.constructor : void 0) === undefined) {
        throw new TypeError("Constructor Intl.ListFormat requires 'new'");
      } // Let requestedLocales be ? CanonicalizeLocaleList(locales).


      var requestedLocales = Intl.getCanonicalLocales(locales); // If options is undefined, then (a) Let options be ObjectCreate(null).
      // Else (b) Let options be ? ToObject(options).

      options = options === undefined ? Object.create(null) : toObject(options); // Let opt be a new Record.

      var opt = Object.create(null); // Let matcher be ? GetOption(options, "localeMatcher", "string", « "lookup", "best fit" »,  "best fit").

      var matcher = getOption(options, "localeMatcher", "string", LOCALE_MATCHER, "best fit"); // Set opt.[[localeMatcher]] to matcher.

      opt.localeMatcher = matcher; // Let type be GetOption(options, "type", "string", « "conjunction", "disjunction", "unit" »,  "conjunction").

      var type = getOption(options, "type", "string", TYPE, "conjunction"); // Set listFormat.[[Type]] to type.

      setInternalSlot(this, "type", type); // Let style be GetOption(options, "style", "string", « "long", "short", "narrow" », "long").

      var style = getOption(options, "style", "string", STYLE, "long"); // Set listFormat.[[Style]] to style.

      setInternalSlot(this, "style", style); // Let localeData be %ListFormat%.[[LocaleData]].

      var localeData = LIST_FORMAT_STATIC_INTERNALS.localeData; // Let r be ResolveLocale(%ListFormat%.[[AvailableLocales]], requestedLocales, opt, %ListFormat%.[[RelevantExtensionKeys]], localeData).

      var r = resolveLocale(LIST_FORMAT_STATIC_INTERNALS.availableLocales, requestedLocales, opt); // Let dataLocale be r.[[dataLocale]].

      var dataLocale = r.dataLocale; // Let dataLocaleData be localeData.[[<dataLocale>]].

      var dataLocaleData = localeData[dataLocale]; // Let dataLocaleTypes be dataLocaleData.[[<type>]].

      var dataLocaleTypes = dataLocaleData.formats[type]; // Let templates be dataLocaleTypes.[[<style>]].

      var templates = dataLocaleTypes[style]; // Set listFormat.[[TemplatePair]] to templates.[[Pair]].

      setInternalSlot(this, "templatePair", templates.Pair); // Set listFormat.[[TemplateStart]] to templates.[[Start]].

      setInternalSlot(this, "templateStart", templates.Start); // Set listFormat.[[TemplateMiddle]] to templates.[[Middle]].

      setInternalSlot(this, "templateMiddle", templates.Middle); // Set listFormat.[[TemplateEnd]] to templates.[[End]].

      setInternalSlot(this, "templateEnd", templates.End); // Set listFormat.[[Locale]] to r.[[locale]].

      setInternalSlot(this, "locale", r.locale); // Intl.ListFormat instances have an [[InitializedListFormat]] internal slot.

      setInternalSlot(this, "initializedListFormat", this);
    }
    /**
     * Returns an array containing those of the provided locales that are supported without having to fall back to the runtime's default locale.
     * @param {Locale | Locales} locales
     * @returns{Locales}
     */


    _createClass(ListFormat, [{
      key: "format",

      /**
       * Formats the given list into a locale-sensitive string representation
       * @param {Iterable<string>} [list]
       * @returns{string}
       */
      value: function format(list) {
        // Let lf be the this value.
        var lf = this; // If Type(lf) is not Object, throw a TypeError exception.

        if (!(lf instanceof Object)) {
          throw new TypeError("Method Intl.ListFormat.prototype.format called on incompatible receiver ".concat(this.toString()));
        } // If ListFormat does not have an [[InitializedListFormat]] internal slot, throw a TypeError exception.


        if (!hasInternalSlot(lf, "initializedListFormat")) {
          throw new TypeError("Method Intl.ListFormat.prototype.format called on incompatible receiver ".concat(this.toString()));
        } // Let stringList be ? StringListFromIterable(list).


        var stringList = stringListFromIterable(list); // Return FormatList(lf, stringList).

        return formatList(lf, stringList);
      }
      /**
       * Formats the given list into locale-sensitive partitions
       * @param {Iterable<string>} [list]
       * @returns{ListPartitions}
       */

    }, {
      key: "formatToParts",
      value: function formatToParts(list) {
        // Let lf be the this value.
        var lf = this; // If Type(lf) is not Object, throw a TypeError exception.

        if (!(lf instanceof Object)) {
          throw new TypeError("Method Intl.ListFormat.prototype.formatToParts called on incompatible receiver ".concat(this.toString()));
        } // If listFormat does not have an [[InitializedListFormat]] internal slot, throw a TypeError exception.


        if (!hasInternalSlot(lf, "initializedListFormat")) {
          throw new TypeError("Method Intl.ListFormat.prototype.formatToParts called on incompatible receiver ".concat(this.toString()));
        } // Let stringList be ? StringListFromIterable(list).


        var stringList = stringListFromIterable(list); // Return FormatListToParts(lf, stringList).

        return formatListToParts(lf, stringList);
      }
      /**
       * This method provides access to the locale and options computed during initialization of the object.
       * @returns {ResolvedListFormatOptions}
       */

    }, {
      key: "resolvedOptions",
      value: function resolvedOptions() {
        // Let lf be the this value.
        var lf = this; // If Type(lf) is not Object, throw a TypeError exception.

        if (!(lf instanceof Object)) {
          throw new TypeError("Method Intl.ListFormat.prototype.resolvedOptions called on incompatible receiver ".concat(this.toString()));
        } // If listFormat does not have an [[InitializedListFormat]] internal slot, throw a TypeError exception.


        if (!hasInternalSlot(lf, "initializedListFormat")) {
          throw new TypeError("Method Intl.ListFormat.prototype.resolvedOptions called on incompatible receiver ".concat(this.toString()));
        }

        var locale = getInternalSlot(this, "locale");
        var type = getInternalSlot(this, "type");
        var style = getInternalSlot(this, "style");
        return {
          locale: locale,
          type: type,
          style: style
        };
      }
    }], [{
      key: "supportedLocalesOf",
      value: function supportedLocalesOf(locales) {
        // The spec states that the 'length' value of supportedLocalesOf must be equal to 1,
        // so we have to pull the options argument out of the method signature
        var options = arguments[1]; // Let availableLocales be %ListFormat%.[[AvailableLocales]].

        var availableLocales = LIST_FORMAT_STATIC_INTERNALS.availableLocales; // Let requestedLocales be ? CanonicalizeLocaleList(locales).

        var requestedLocales = Intl.getCanonicalLocales(locales);
        return supportedLocales(availableLocales, requestedLocales, options);
      }
      /**
       * Adds locale data to the internal slot.
       * This API exactly mimics that of the Intl polyfill (https://github.com/andyearnshaw/Intl.js)
       * @private
       * @internal
       * @param {InputLocaleDataEntry} data
       * @param {Locale} locale
       */

    }, {
      key: "__addLocaleData",
      value: function __addLocaleData(_ref) {
        var data = _ref.data,
            locale = _ref.locale;
        // Use the locale as the default one if none is configured
        var defaultLocale = getDefaultLocale();

        if (defaultLocale == null) {
          setDefaultLocale(locale);
        }

        LIST_FORMAT_STATIC_INTERNALS.localeData[locale] = data;

        if (!LIST_FORMAT_STATIC_INTERNALS.availableLocales.includes(locale)) {
          LIST_FORMAT_STATIC_INTERNALS.availableLocales.push(locale);
        }
      }
    }]);

    return ListFormat;
  }();
  /**
   * The initial value of the @@toStringTag property is the string value "Intl.ListFormat".
   * This property has the attributes { [[Writable]]: false, [[Enumerable]]: false, [[Configurable]]: true }.
   * @type {string}
   */

  Object.defineProperty(ListFormat.prototype, Symbol.toStringTag, {
    writable: false,
    enumerable: false,
    value: "Intl.ListFormat",
    configurable: true
  });

  /**
   * Patches Intl with Intl.ListFormat
   */

  function patch() {
    if (typeof Intl === "undefined") {
      throw new TypeError("Could not define Intl.ListFormat: Expected 'Intl' to exist. Remember to include polyfill for Intl.getCanonicalLocales before applying this polyfill");
    }

    Intl.ListFormat = ListFormat;
  }

  if (!SUPPORTS_LIST_FORMAT) {
    patch();
  }

}());
//# sourceMappingURL=index.js.map
