/*
 * Copyright (C) 2011 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

import * as i18n from '../i18n/i18n.js';

import {VBox} from './Widget.js';
import {XLink} from './XLink.js';

export const UIStrings = {
  /**
  *@description Text that is usually a hyperlink to more documentation
  */
  learnMore: 'Learn more',
};
const str_ = i18n.i18n.registerUIStrings('ui/EmptyWidget.js', UIStrings);
const i18nString = i18n.i18n.getLocalizedString.bind(undefined, str_);

export class EmptyWidget extends VBox {
  /**
   * @param {string} text
   */
  constructor(text) {
    super();
    this.registerRequiredCSS('ui/emptyWidget.css', {enableLegacyPatching: false});
    this.element.classList.add('empty-view-scroller');
    this._contentElement = this.element.createChild('div', 'empty-view');
    this._textElement = this._contentElement.createChild('div', 'empty-bold-text');
    this._textElement.textContent = text;
  }

  /**
   * @return {!Element}
   */
  appendParagraph() {
    return this._contentElement.createChild('p');
  }

  /**
   * @param {string} link
   * @return {!HTMLElement}
   */
  appendLink(link) {
    return /** @type {!HTMLElement} */ (
        this._contentElement.appendChild(XLink.create(link, i18nString(UIStrings.learnMore))));
  }

  /**
   * @param {string} text
   */
  set text(text) {
    this._textElement.textContent = text;
  }
}
