/*
 * Copyright (C) 2019 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

import './utilities.js';

import * as ArrayUtilities from './array-utilities.js';
import * as DateUtilities from './date-utilities.js';
import * as KeyboardUtilities from './keyboard-utilities.js';
import * as MapUtilities from './map-utilities.js';
import * as NumberUtilities from './number-utilities.js';
import * as SetUtilities from './set-utilities.js';
import * as StringUtilities from './string-utilities.js';
import * as TypeScriptUtilities from './typescript-utilities.js';
import * as UIString from './UIString.js';

/* We expose `ls` directly to make importing + referring to it easy
 * as it's such a commonly referenced and used utility.
 */
export const {ls} = UIString;
/* `assertNotNull` also need to be exposed, as TypeScript does not
 * allow `asserts` functions to be used with qualified access
 * (e.g. `Platform.TypeScriptUtilities.assertNotNull` causes a
 * compiler error)
 */
export {assertNotNull} from './typescript-utilities.js';

export {runOnWindowLoad, assertNever} from './utilities.js';
export {
  ArrayUtilities,
  TypeScriptUtilities,
  DateUtilities,
  MapUtilities,
  KeyboardUtilities,
  NumberUtilities,
  SetUtilities,
  StringUtilities,
  UIString,
};
