// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

export const generatedProperties = [
  {'name': '-webkit-app-region', 'keywords': ['none', 'drag', 'no-drag']},
  {'name': '-webkit-border-horizontal-spacing', 'inherited': true},
  {'name': '-webkit-border-image'},
  {'name': '-webkit-border-vertical-spacing', 'inherited': true},
  {'name': '-webkit-box-align', 'keywords': ['stretch', 'start', 'center', 'end', 'baseline']},
  {'name': '-webkit-box-decoration-break', 'keywords': ['slice', 'clone']},
  {'name': '-webkit-box-direction', 'inherited': true, 'keywords': ['normal', 'reverse']},
  {'name': '-webkit-box-flex'},
  {'name': '-webkit-box-ordinal-group'},
  {'name': '-webkit-box-orient', 'keywords': ['horizontal', 'vertical']},
  {'name': '-webkit-box-pack', 'keywords': ['start', 'center', 'end', 'justify']},
  {'name': '-webkit-box-reflect'},
  {'longhands': ['break-after'], 'name': '-webkit-column-break-after'},
  {'longhands': ['break-before'], 'name': '-webkit-column-break-before'},
  {'longhands': ['break-inside'], 'name': '-webkit-column-break-inside'},
  {'name': '-webkit-font-smoothing', 'inherited': true},
  {'name': '-webkit-highlight', 'inherited': true},
  {'name': '-webkit-hyphenate-character', 'inherited': true},
  {
    'name': '-webkit-line-break',
    'inherited': true,
    'keywords': ['auto', 'loose', 'normal', 'strict', 'after-white-space', 'anywhere']
  },
  {'name': '-webkit-line-clamp'},
  {'name': '-webkit-locale', 'inherited': true},
  {
    'longhands': [
      '-webkit-mask-image', '-webkit-mask-position-x', '-webkit-mask-position-y', '-webkit-mask-size',
      '-webkit-mask-repeat-x', '-webkit-mask-repeat-y', '-webkit-mask-origin', '-webkit-mask-clip'
    ],
    'name': '-webkit-mask'
  },
  {
    'longhands': [
      '-webkit-mask-box-image-source', '-webkit-mask-box-image-slice', '-webkit-mask-box-image-width',
      '-webkit-mask-box-image-outset', '-webkit-mask-box-image-repeat'
    ],
    'name': '-webkit-mask-box-image'
  },
  {'name': '-webkit-mask-box-image-outset'},
  {'name': '-webkit-mask-box-image-repeat'},
  {'name': '-webkit-mask-box-image-slice'},
  {'name': '-webkit-mask-box-image-source'},
  {'name': '-webkit-mask-box-image-width'},
  {'name': '-webkit-mask-clip'},
  {'name': '-webkit-mask-composite'},
  {'name': '-webkit-mask-image'},
  {'name': '-webkit-mask-origin'},
  {'longhands': ['-webkit-mask-position-x', '-webkit-mask-position-y'], 'name': '-webkit-mask-position'},
  {'name': '-webkit-mask-position-x'},
  {'name': '-webkit-mask-position-y'},
  {'longhands': ['-webkit-mask-repeat-x', '-webkit-mask-repeat-y'], 'name': '-webkit-mask-repeat'},
  {'name': '-webkit-mask-repeat-x'},
  {'name': '-webkit-mask-repeat-y'},
  {'name': '-webkit-mask-size'},
  {'name': '-webkit-perspective-origin-x'},
  {'name': '-webkit-perspective-origin-y'},
  {'name': '-webkit-print-color-adjust', 'inherited': true, 'keywords': ['economy', 'exact']},
  {'name': '-webkit-rtl-ordering', 'inherited': true, 'keywords': ['logical', 'visual']},
  {'name': '-webkit-ruby-position', 'inherited': true, 'keywords': ['before', 'after']},
  {'name': '-webkit-tap-highlight-color', 'inherited': true},
  {'name': '-webkit-text-combine', 'inherited': true},
  {'name': '-webkit-text-decorations-in-effect', 'inherited': true},
  {
    'longhands': ['-webkit-text-emphasis-style', '-webkit-text-emphasis-color'],
    'name': '-webkit-text-emphasis',
    'inherited': true
  },
  {'name': '-webkit-text-emphasis-color', 'inherited': true},
  {'name': '-webkit-text-emphasis-position', 'inherited': true},
  {'name': '-webkit-text-emphasis-style', 'inherited': true},
  {'name': '-webkit-text-fill-color', 'inherited': true},
  {'name': '-webkit-text-orientation', 'inherited': true},
  {'name': '-webkit-text-security', 'inherited': true, 'keywords': ['none', 'disc', 'circle', 'square']},
  {
    'longhands': ['-webkit-text-stroke-width', '-webkit-text-stroke-color'],
    'name': '-webkit-text-stroke',
    'inherited': true
  },
  {'name': '-webkit-text-stroke-color', 'inherited': true},
  {'name': '-webkit-text-stroke-width', 'inherited': true},
  {'name': '-webkit-transform-origin-x'},
  {'name': '-webkit-transform-origin-y'},
  {'name': '-webkit-transform-origin-z'},
  {'name': '-webkit-user-drag', 'keywords': ['auto', 'none', 'element']},
  {
    'name': '-webkit-user-modify',
    'inherited': true,
    'keywords': ['read-only', 'read-write', 'read-write-plaintext-only']
  },
  {'name': '-webkit-writing-mode', 'inherited': true},
  {'name': 'additive-symbols'},
  {'name': 'advance-override'},
  {'name': 'advance-proportional-override'},
  {'name': 'align-content'},
  {'name': 'align-items'},
  {'name': 'align-self'},
  {
    'keywords': ['baseline', 'alphabetic', 'ideographic', 'middle', 'central', 'mathematical'],
    'svg': true,
    'name': 'alignment-baseline'
  },
  {'name': 'all'},
  {
    'longhands': [
      'animation-duration', 'animation-timing-function', 'animation-delay', 'animation-iteration-count',
      'animation-direction', 'animation-fill-mode', 'animation-play-state', 'animation-name', 'animation-timeline'
    ],
    'name': 'animation'
  },
  {'name': 'animation-delay'},
  {'name': 'animation-direction', 'keywords': ['normal', 'reverse', 'alternate', 'alternate-reverse']},
  {'name': 'animation-duration'},
  {'name': 'animation-fill-mode', 'keywords': ['none', 'forwards', 'backwards', 'both']},
  {'name': 'animation-iteration-count', 'keywords': ['infinite']},
  {'name': 'animation-name', 'keywords': ['none']},
  {'name': 'animation-play-state', 'keywords': ['running', 'paused']},
  {'name': 'animation-timeline', 'keywords': ['none', 'auto']},
  {
    'name': 'animation-timing-function',
    'keywords': [
      'linear', 'ease', 'ease-in', 'ease-out', 'ease-in-out', 'jump-both', 'jump-end', 'jump-none', 'jump-start',
      'step-start', 'step-end'
    ]
  },
  {'name': 'appearance'},
  {'name': 'ascent-override'},
  {'name': 'aspect-ratio', 'keywords': ['auto']},
  {'name': 'backdrop-filter', 'keywords': ['none']},
  {'name': 'backface-visibility', 'keywords': ['visible', 'hidden']},
  {
    'longhands': [
      'background-image', 'background-position-x', 'background-position-y', 'background-size', 'background-repeat-x',
      'background-repeat-y', 'background-attachment', 'background-origin', 'background-clip', 'background-color'
    ],
    'name': 'background'
  },
  {'name': 'background-attachment', 'keywords': ['scroll', 'fixed', 'local']},
  {
    'name': 'background-blend-mode',
    'keywords': [
      'normal', 'multiply', 'screen', 'overlay', 'darken', 'lighten', 'color-dodge', 'color-burn', 'hard-light',
      'soft-light', 'difference', 'exclusion', 'hue', 'saturation', 'color', 'luminosity'
    ]
  },
  {'name': 'background-clip', 'keywords': ['border-box', 'padding-box', 'content-box']},
  {'name': 'background-color', 'keywords': ['currentcolor']},
  {'name': 'background-image', 'keywords': ['auto', 'none']},
  {'name': 'background-origin', 'keywords': ['border-box', 'padding-box', 'content-box']},
  {'longhands': ['background-position-x', 'background-position-y'], 'name': 'background-position'},
  {'name': 'background-position-x'},
  {'name': 'background-position-y'},
  {'longhands': ['background-repeat-x', 'background-repeat-y'], 'name': 'background-repeat'},
  {'name': 'background-repeat-x'},
  {'name': 'background-repeat-y'},
  {'name': 'background-size', 'keywords': ['auto', 'cover', 'contain']},
  {'name': 'baseline-shift', 'svg': true, 'keywords': ['sub', 'super']},
  {'name': 'block-size', 'keywords': ['auto']},
  {
    'longhands': [
      'border-top-color', 'border-top-style', 'border-top-width', 'border-right-color', 'border-right-style',
      'border-right-width', 'border-bottom-color', 'border-bottom-style', 'border-bottom-width', 'border-left-color',
      'border-left-style', 'border-left-width', 'border-image-source', 'border-image-slice', 'border-image-width',
      'border-image-outset', 'border-image-repeat'
    ],
    'name': 'border'
  },
  {
    'longhands': [
      'border-block-start-color', 'border-block-start-style', 'border-block-start-width', 'border-block-end-color',
      'border-block-end-style', 'border-block-end-width'
    ],
    'name': 'border-block'
  },
  {'longhands': ['border-block-start-color', 'border-block-end-color'], 'name': 'border-block-color'},
  {
    'longhands': ['border-block-end-width', 'border-block-end-style', 'border-block-end-color'],
    'name': 'border-block-end'
  },
  {'name': 'border-block-end-color'},
  {'name': 'border-block-end-style'},
  {'name': 'border-block-end-width'},
  {
    'longhands': ['border-block-start-width', 'border-block-start-style', 'border-block-start-color'],
    'name': 'border-block-start'
  },
  {'name': 'border-block-start-color'},
  {'name': 'border-block-start-style'},
  {'name': 'border-block-start-width'},
  {'longhands': ['border-block-start-style', 'border-block-end-style'], 'name': 'border-block-style'},
  {'longhands': ['border-block-start-width', 'border-block-end-width'], 'name': 'border-block-width'},
  {'longhands': ['border-bottom-width', 'border-bottom-style', 'border-bottom-color'], 'name': 'border-bottom'},
  {'name': 'border-bottom-color', 'keywords': ['currentcolor']},
  {'name': 'border-bottom-left-radius'},
  {'name': 'border-bottom-right-radius'},
  {
    'name': 'border-bottom-style',
    'keywords': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']
  },
  {'name': 'border-bottom-width', 'keywords': ['thin', 'medium', 'thick']},
  {'name': 'border-collapse', 'inherited': true, 'keywords': ['separate', 'collapse']},
  {
    'longhands': ['border-top-color', 'border-right-color', 'border-bottom-color', 'border-left-color'],
    'name': 'border-color'
  },
  {'name': 'border-end-end-radius'},
  {'name': 'border-end-start-radius'},
  {
    'longhands': [
      'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset', 'border-image-repeat'
    ],
    'name': 'border-image'
  },
  {'name': 'border-image-outset'},
  {'name': 'border-image-repeat', 'keywords': ['stretch', 'repeat', 'round', 'space']},
  {'name': 'border-image-slice'},
  {'name': 'border-image-source', 'keywords': ['none']},
  {'name': 'border-image-width', 'keywords': ['auto']},
  {
    'longhands': [
      'border-inline-start-color', 'border-inline-start-style', 'border-inline-start-width', 'border-inline-end-color',
      'border-inline-end-style', 'border-inline-end-width'
    ],
    'name': 'border-inline'
  },
  {'longhands': ['border-inline-start-color', 'border-inline-end-color'], 'name': 'border-inline-color'},
  {
    'longhands': ['border-inline-end-width', 'border-inline-end-style', 'border-inline-end-color'],
    'name': 'border-inline-end'
  },
  {'name': 'border-inline-end-color'},
  {'name': 'border-inline-end-style'},
  {'name': 'border-inline-end-width'},
  {
    'longhands': ['border-inline-start-width', 'border-inline-start-style', 'border-inline-start-color'],
    'name': 'border-inline-start'
  },
  {'name': 'border-inline-start-color'},
  {'name': 'border-inline-start-style'},
  {'name': 'border-inline-start-width'},
  {'longhands': ['border-inline-start-style', 'border-inline-end-style'], 'name': 'border-inline-style'},
  {'longhands': ['border-inline-start-width', 'border-inline-end-width'], 'name': 'border-inline-width'},
  {'longhands': ['border-left-width', 'border-left-style', 'border-left-color'], 'name': 'border-left'},
  {'name': 'border-left-color', 'keywords': ['currentcolor']},
  {
    'name': 'border-left-style',
    'keywords': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']
  },
  {'name': 'border-left-width', 'keywords': ['thin', 'medium', 'thick']},
  {
    'longhands': [
      'border-top-left-radius', 'border-top-right-radius', 'border-bottom-right-radius', 'border-bottom-left-radius'
    ],
    'name': 'border-radius'
  },
  {'longhands': ['border-right-width', 'border-right-style', 'border-right-color'], 'name': 'border-right'},
  {'name': 'border-right-color', 'keywords': ['currentcolor']},
  {
    'name': 'border-right-style',
    'keywords': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']
  },
  {'name': 'border-right-width', 'keywords': ['thin', 'medium', 'thick']},
  {
    'longhands': ['-webkit-border-horizontal-spacing', '-webkit-border-vertical-spacing'],
    'name': 'border-spacing',
    'inherited': true
  },
  {'name': 'border-start-end-radius'},
  {'name': 'border-start-start-radius'},
  {
    'keywords': ['none'],
    'longhands': ['border-top-style', 'border-right-style', 'border-bottom-style', 'border-left-style'],
    'name': 'border-style'
  },
  {'longhands': ['border-top-width', 'border-top-style', 'border-top-color'], 'name': 'border-top'},
  {'name': 'border-top-color', 'keywords': ['currentcolor']},
  {'name': 'border-top-left-radius'},
  {'name': 'border-top-right-radius'},
  {
    'name': 'border-top-style',
    'keywords': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']
  },
  {'name': 'border-top-width', 'keywords': ['thin', 'medium', 'thick']},
  {
    'longhands': ['border-top-width', 'border-right-width', 'border-bottom-width', 'border-left-width'],
    'name': 'border-width'
  },
  {'name': 'bottom', 'keywords': ['auto']},
  {'name': 'box-shadow', 'keywords': ['none']},
  {'name': 'box-sizing', 'keywords': ['content-box', 'border-box']},
  {
    'name': 'break-after',
    'keywords': ['auto', 'avoid', 'avoid-column', 'avoid-page', 'column', 'left', 'page', 'recto', 'right', 'verso']
  },
  {
    'name': 'break-before',
    'keywords': ['auto', 'avoid', 'avoid-column', 'avoid-page', 'column', 'left', 'page', 'recto', 'right', 'verso']
  },
  {'name': 'break-inside', 'keywords': ['auto', 'avoid', 'avoid-column', 'avoid-page']},
  {'svg': true, 'name': 'buffered-rendering'},
  {'name': 'caption-side', 'inherited': true, 'keywords': ['top', 'bottom']},
  {'name': 'caret-color', 'inherited': true, 'keywords': ['auto', 'currentcolor']},
  {'name': 'clear', 'keywords': ['none', 'left', 'right', 'both', 'inline-start', 'inline-end']},
  {'name': 'clip', 'keywords': ['auto']},
  {'name': 'clip-path', 'keywords': ['none']},
  {'name': 'clip-rule', 'svg': true, 'inherited': true, 'keywords': ['nonzero', 'evenodd']},
  {'name': 'color', 'inherited': true, 'keywords': ['currentcolor']},
  {'name': 'color-interpolation', 'svg': true, 'inherited': true, 'keywords': ['auto', 'srgb', 'linearrgb']},
  {'svg': true, 'name': 'color-interpolation-filters', 'inherited': true},
  {'name': 'color-rendering', 'svg': true, 'inherited': true, 'keywords': ['auto', 'optimizespeed', 'optimizequality']},
  {'name': 'color-scheme', 'inherited': true},
  {'name': 'column-count', 'keywords': ['auto']},
  {'name': 'column-fill', 'keywords': ['balance', 'auto']},
  {'name': 'column-gap', 'keywords': ['normal']},
  {'longhands': ['column-rule-width', 'column-rule-style', 'column-rule-color'], 'name': 'column-rule'},
  {'name': 'column-rule-color', 'keywords': ['currentcolor']},
  {
    'name': 'column-rule-style',
    'keywords': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']
  },
  {'name': 'column-rule-width', 'keywords': ['thin', 'medium', 'thick']},
  {'name': 'column-span', 'keywords': ['none', 'all']},
  {'name': 'column-width', 'keywords': ['auto']},
  {'longhands': ['column-width', 'column-count'], 'name': 'columns'},
  {'name': 'contain', 'keywords': ['none', 'strict', 'content', 'size', 'layout', 'style', 'paint']},
  {'name': 'contain-intrinsic-size', 'keywords': ['auto']},
  {'name': 'content'},
  {'name': 'content-visibility', 'keywords': ['visible', 'auto', 'hidden', 'hidden-matchable']},
  {'name': 'counter-increment', 'keywords': ['none']},
  {'name': 'counter-reset', 'keywords': ['none']},
  {'name': 'counter-set', 'keywords': ['none']},
  {
    'name': 'cursor',
    'inherited': true,
    'keywords': [
      'auto',        'default',   'none',      'context-menu',  'help',        'pointer',    'progress',   'wait',
      'cell',        'crosshair', 'text',      'vertical-text', 'alias',       'copy',       'move',       'no-drop',
      'not-allowed', 'e-resize',  'n-resize',  'ne-resize',     'nw-resize',   's-resize',   'se-resize',  'sw-resize',
      'w-resize',    'ew-resize', 'ns-resize', 'nesw-resize',   'nwse-resize', 'col-resize', 'row-resize', 'all-scroll',
      'zoom-in',     'zoom-out',  'grab',      'grabbing'
    ]
  },
  {'svg': true, 'name': 'cx'},
  {'svg': true, 'name': 'cy'},
  {'name': 'd', 'svg': true, 'keywords': ['none']},
  {'name': 'descent-override'},
  {'name': 'direction', 'inherited': true, 'keywords': ['ltr', 'rtl']},
  {
    'keywords': [
      'inline',
      'block',
      'list-item',
      'inline-block',
      'table',
      'inline-table',
      'table-row-group',
      'table-header-group',
      'table-footer-group',
      'table-row',
      'table-column-group',
      'table-column',
      'table-cell',
      'table-caption',
      '-webkit-box',
      '-webkit-inline-box',
      'flex',
      'inline-flex',
      'grid',
      'inline-grid',
      'contents',
      'flow-root',
      'none'
    ],
    'name': 'display'
  },
  {
    'name': 'dominant-baseline',
    'svg': true,
    'inherited': true,
    'keywords': ['auto', 'alphabetic', 'ideographic', 'middle', 'central', 'mathematical', 'hanging']
  },
  {'name': 'empty-cells', 'inherited': true, 'keywords': ['show', 'hide']},
  {'name': 'end'},
  {'name': 'fallback'},
  {'name': 'fill', 'svg': true, 'inherited': true},
  {'svg': true, 'inherited': true, 'name': 'fill-opacity'},
  {'name': 'fill-rule', 'svg': true, 'inherited': true, 'keywords': ['nonzero', 'evenodd']},
  {'name': 'filter', 'keywords': ['none']},
  {'longhands': ['flex-grow', 'flex-shrink', 'flex-basis'], 'name': 'flex'},
  {'name': 'flex-basis', 'keywords': ['auto']},
  {'name': 'flex-direction', 'keywords': ['row', 'row-reverse', 'column', 'column-reverse']},
  {'longhands': ['flex-direction', 'flex-wrap'], 'name': 'flex-flow'},
  {'name': 'flex-grow'},
  {'name': 'flex-shrink'},
  {'name': 'flex-wrap', 'keywords': ['nowrap', 'wrap', 'wrap-reverse']},
  {'name': 'float', 'keywords': ['none', 'left', 'right', 'inline-start', 'inline-end']},
  {'name': 'flood-color', 'svg': true, 'keywords': ['currentcolor']},
  {'name': 'flood-opacity', 'svg': true},
  {
    'longhands': [
      'font-style', 'font-variant-ligatures', 'font-variant-caps', 'font-variant-numeric', 'font-variant-east-asian',
      'font-weight', 'font-stretch', 'font-size', 'line-height', 'font-family'
    ],
    'name': 'font',
    'inherited': true
  },
  {'name': 'font-display'},
  {'name': 'font-family', 'inherited': true},
  {'name': 'font-feature-settings', 'inherited': true, 'keywords': ['normal']},
  {'name': 'font-kerning', 'inherited': true, 'keywords': ['auto', 'normal', 'none']},
  {'name': 'font-optical-sizing', 'inherited': true, 'keywords': ['auto', 'none']},
  {
    'name': 'font-size',
    'inherited': true,
    'keywords': [
      'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large', 'xxx-large', 'larger', 'smaller',
      '-webkit-xxx-large'
    ]
  },
  {'name': 'font-size-adjust', 'inherited': true, 'keywords': ['none']},
  {
    'name': 'font-stretch',
    'inherited': true,
    'keywords': [
      'normal', 'ultra-condensed', 'extra-condensed', 'condensed', 'semi-condensed', 'semi-expanded', 'expanded',
      'extra-expanded', 'ultra-expanded'
    ]
  },
  {'name': 'font-style', 'inherited': true, 'keywords': ['normal', 'italic', 'oblique']},
  {
    'longhands': ['font-variant-ligatures', 'font-variant-caps', 'font-variant-numeric', 'font-variant-east-asian'],
    'name': 'font-variant',
    'inherited': true
  },
  {
    'inherited': true,
    'keywords': ['normal', 'small-caps', 'all-small-caps', 'petite-caps', 'all-petite-caps', 'unicase', 'titling-caps'],
    'name': 'font-variant-caps'
  },
  {
    'inherited': true,
    'keywords': [
      'normal', 'jis78', 'jis83', 'jis90', 'jis04', 'simplified', 'traditional', 'full-width', 'proportional-width',
      'ruby'
    ],
    'name': 'font-variant-east-asian'
  },
  {
    'name': 'font-variant-ligatures',
    'inherited': true,
    'keywords': [
      'normal', 'none', 'common-ligatures', 'no-common-ligatures', 'discretionary-ligatures',
      'no-discretionary-ligatures', 'historical-ligatures', 'no-historical-ligatures', 'contextual', 'no-contextual'
    ]
  },
  {
    'inherited': true,
    'keywords': [
      'normal', 'lining-nums', 'oldstyle-nums', 'proportional-nums', 'tabular-nums', 'diagonal-fractions',
      'stacked-fractions', 'ordinal', 'slashed-zero'
    ],
    'name': 'font-variant-numeric'
  },
  {'name': 'font-variation-settings', 'inherited': true, 'keywords': ['normal']},
  {'name': 'font-weight', 'inherited': true, 'keywords': ['normal', 'bold', 'bolder', 'lighter']},
  {'name': 'forced-color-adjust', 'inherited': true, 'keywords': ['auto', 'none']},
  {'longhands': ['row-gap', 'column-gap'], 'name': 'gap'},
  {
    'longhands': [
      'grid-template-rows', 'grid-template-columns', 'grid-template-areas', 'grid-auto-flow', 'grid-auto-rows',
      'grid-auto-columns'
    ],
    'name': 'grid'
  },
  {'longhands': ['grid-row-start', 'grid-column-start', 'grid-row-end', 'grid-column-end'], 'name': 'grid-area'},
  {'name': 'grid-auto-columns', 'keywords': ['auto', 'min-content', 'max-content']},
  {'name': 'grid-auto-flow', 'keywords': ['row', 'column']},
  {'name': 'grid-auto-rows', 'keywords': ['auto', 'min-content', 'max-content']},
  {'longhands': ['grid-column-start', 'grid-column-end'], 'name': 'grid-column'},
  {'name': 'grid-column-end', 'keywords': ['auto']},
  {'longhands': ['column-gap'], 'name': 'grid-column-gap'},
  {'name': 'grid-column-start', 'keywords': ['auto']},
  {'longhands': ['row-gap', 'column-gap'], 'name': 'grid-gap'},
  {'longhands': ['grid-row-start', 'grid-row-end'], 'name': 'grid-row'},
  {'name': 'grid-row-end', 'keywords': ['auto']},
  {'longhands': ['row-gap'], 'name': 'grid-row-gap'},
  {'name': 'grid-row-start', 'keywords': ['auto']},
  {'longhands': ['grid-template-rows', 'grid-template-columns', 'grid-template-areas'], 'name': 'grid-template'},
  {'keywords': ['none'], 'name': 'grid-template-areas'},
  {'name': 'grid-template-columns', 'keywords': ['none']},
  {'name': 'grid-template-rows', 'keywords': ['none']},
  {'name': 'height', 'keywords': ['auto', 'fit-content', 'min-content', 'max-content']},
  {'name': 'hyphens', 'inherited': true, 'keywords': ['none', 'manual', 'auto']},
  {'name': 'image-orientation', 'inherited': true},
  {
    'name': 'image-rendering',
    'inherited': true,
    'keywords': ['auto', 'optimizespeed', 'optimizequality', '-webkit-optimize-contrast', 'pixelated']
  },
  {'name': 'inherits'},
  {'name': 'initial-value'},
  {'name': 'inline-size', 'keywords': ['auto']},
  {'longhands': ['top', 'right', 'bottom', 'left'], 'name': 'inset'},
  {'longhands': ['inset-block-start', 'inset-block-end'], 'name': 'inset-block'},
  {'name': 'inset-block-end'},
  {'name': 'inset-block-start'},
  {'longhands': ['inset-inline-start', 'inset-inline-end'], 'name': 'inset-inline'},
  {'name': 'inset-inline-end'},
  {'name': 'inset-inline-start'},
  {'name': 'isolation', 'keywords': ['auto', 'isolate']},
  {'name': 'justify-content'},
  {'name': 'justify-items'},
  {'name': 'justify-self'},
  {'name': 'left', 'keywords': ['auto']},
  {'inherited': true, 'keywords': ['normal'], 'name': 'letter-spacing'},
  {'name': 'lighting-color', 'svg': true, 'keywords': ['currentcolor']},
  {'name': 'line-break', 'inherited': true, 'keywords': ['auto', 'loose', 'normal', 'strict', 'anywhere']},
  {'name': 'line-gap-override'},
  {'name': 'line-height', 'inherited': true, 'keywords': ['normal']},
  {'name': 'line-height-step', 'inherited': true},
  {
    'longhands': ['list-style-position', 'list-style-image', 'list-style-type'],
    'name': 'list-style',
    'inherited': true
  },
  {'name': 'list-style-image', 'inherited': true, 'keywords': ['none']},
  {'name': 'list-style-position', 'inherited': true, 'keywords': ['outside', 'inside']},
  {
    'name': 'list-style-type',
    'inherited': true,
    'keywords': [
      'disc',
      'circle',
      'square',
      'disclosure-open',
      'disclosure-closed',
      'decimal',
      'decimal-leading-zero',
      'arabic-indic',
      'bengali',
      'cambodian',
      'khmer',
      'devanagari',
      'gujarati',
      'gurmukhi',
      'kannada',
      'lao',
      'malayalam',
      'mongolian',
      'myanmar',
      'oriya',
      'persian',
      'urdu',
      'telugu',
      'tibetan',
      'thai',
      'lower-roman',
      'upper-roman',
      'lower-greek',
      'lower-alpha',
      'lower-latin',
      'upper-alpha',
      'upper-latin',
      'cjk-earthly-branch',
      'cjk-heavenly-stem',
      'ethiopic-halehame',
      'ethiopic-halehame-am',
      'ethiopic-halehame-ti-er',
      'ethiopic-halehame-ti-et',
      'hangul',
      'hangul-consonant',
      'korean-hangul-formal',
      'korean-hanja-formal',
      'korean-hanja-informal',
      'hebrew',
      'armenian',
      'lower-armenian',
      'upper-armenian',
      'georgian',
      'cjk-ideographic',
      'simp-chinese-formal',
      'simp-chinese-informal',
      'trad-chinese-formal',
      'trad-chinese-informal',
      'hiragana',
      'katakana',
      'hiragana-iroha',
      'katakana-iroha',
      'none'
    ]
  },
  {'longhands': ['margin-top', 'margin-right', 'margin-bottom', 'margin-left'], 'name': 'margin'},
  {'longhands': ['margin-block-start', 'margin-block-end'], 'name': 'margin-block'},
  {'name': 'margin-block-end', 'keywords': ['auto']},
  {'name': 'margin-block-start', 'keywords': ['auto']},
  {'name': 'margin-bottom', 'keywords': ['auto']},
  {'longhands': ['margin-inline-start', 'margin-inline-end'], 'name': 'margin-inline'},
  {'name': 'margin-inline-end', 'keywords': ['auto']},
  {'name': 'margin-inline-start', 'keywords': ['auto']},
  {'name': 'margin-left', 'keywords': ['auto']},
  {'name': 'margin-right', 'keywords': ['auto']},
  {'name': 'margin-top', 'keywords': ['auto']},
  {'longhands': ['marker-start', 'marker-mid', 'marker-end'], 'inherited': true, 'name': 'marker', 'svg': true},
  {'svg': true, 'inherited': true, 'keywords': ['none'], 'name': 'marker-end'},
  {'svg': true, 'inherited': true, 'keywords': ['none'], 'name': 'marker-mid'},
  {'svg': true, 'inherited': true, 'keywords': ['none'], 'name': 'marker-start'},
  {'svg': true, 'name': 'mask'},
  {'keywords': ['luminance', 'alpha'], 'svg': true, 'name': 'mask-type'},
  {'name': 'math-depth', 'inherited': true},
  {'name': 'math-shift', 'inherited': true, 'keywords': ['normal', 'compact']},
  {'name': 'math-style', 'inherited': true, 'keywords': ['normal', 'compact']},
  {'keywords': ['none'], 'name': 'max-block-size'},
  {'name': 'max-height', 'keywords': ['none']},
  {'keywords': ['none'], 'name': 'max-inline-size'},
  {'name': 'max-width', 'keywords': ['none']},
  {'name': 'max-zoom'},
  {'name': 'min-block-size'},
  {'name': 'min-height'},
  {'name': 'min-inline-size'},
  {'name': 'min-width'},
  {'name': 'min-zoom'},
  {
    'name': 'mix-blend-mode',
    'keywords': [
      'normal', 'multiply', 'screen', 'overlay', 'darken', 'lighten', 'color-dodge', 'color-burn', 'hard-light',
      'soft-light', 'difference', 'exclusion', 'hue', 'saturation', 'color', 'luminosity'
    ]
  },
  {'name': 'negative'},
  {'name': 'object-fit', 'keywords': ['fill', 'contain', 'cover', 'none', 'scale-down']},
  {'name': 'object-position'},
  {
    'longhands': ['offset-position', 'offset-path', 'offset-distance', 'offset-rotate', 'offset-anchor'],
    'name': 'offset'
  },
  {'name': 'offset-anchor', 'keywords': ['auto']},
  {'name': 'offset-distance'},
  {'name': 'offset-path', 'keywords': ['none']},
  {'name': 'offset-position', 'keywords': ['auto']},
  {'name': 'offset-rotate', 'keywords': ['auto', 'reverse']},
  {'name': 'opacity'},
  {'name': 'order'},
  {'name': 'orientation'},
  {'name': 'origin-trial-test-property', 'keywords': ['normal', 'none']},
  {'name': 'orphans', 'inherited': true},
  {'longhands': ['outline-color', 'outline-style', 'outline-width'], 'name': 'outline'},
  {'name': 'outline-color', 'keywords': ['currentcolor']},
  {'name': 'outline-offset'},
  {
    'name': 'outline-style',
    'keywords': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']
  },
  {'name': 'outline-width', 'keywords': ['thin', 'medium', 'thick']},
  {'longhands': ['overflow-x', 'overflow-y'], 'name': 'overflow'},
  {'name': 'overflow-anchor', 'inherited': false, 'keywords': ['visible', 'none', 'auto']},
  {'name': 'overflow-block'},
  {'name': 'overflow-clip-margin'},
  {'name': 'overflow-inline'},
  {'name': 'overflow-wrap', 'inherited': true, 'keywords': ['normal', 'break-word', 'anywhere']},
  {'name': 'overflow-x', 'keywords': ['visible', 'hidden', 'scroll', 'auto', 'overlay', 'clip']},
  {'name': 'overflow-y', 'keywords': ['visible', 'hidden', 'scroll', 'auto', 'overlay', 'clip']},
  {'longhands': ['overscroll-behavior-x', 'overscroll-behavior-y'], 'name': 'overscroll-behavior'},
  {'name': 'overscroll-behavior-block'},
  {'name': 'overscroll-behavior-inline'},
  {'name': 'overscroll-behavior-x', 'keywords': ['auto', 'contain', 'none']},
  {'name': 'overscroll-behavior-y', 'keywords': ['auto', 'contain', 'none']},
  {'name': 'pad'},
  {'longhands': ['padding-top', 'padding-right', 'padding-bottom', 'padding-left'], 'name': 'padding'},
  {'longhands': ['padding-block-start', 'padding-block-end'], 'name': 'padding-block'},
  {'name': 'padding-block-end'},
  {'name': 'padding-block-start'},
  {'name': 'padding-bottom'},
  {'longhands': ['padding-inline-start', 'padding-inline-end'], 'name': 'padding-inline'},
  {'name': 'padding-inline-end'},
  {'name': 'padding-inline-start'},
  {'name': 'padding-left'},
  {'name': 'padding-right'},
  {'name': 'padding-top'},
  {'name': 'page', 'keywords': ['auto']},
  {'longhands': ['break-after'], 'name': 'page-break-after'},
  {'longhands': ['break-before'], 'name': 'page-break-before'},
  {'longhands': ['break-inside'], 'name': 'page-break-inside'},
  {'name': 'page-orientation'},
  {'svg': true, 'inherited': true, 'keywords': ['normal', 'fill', 'stroke', 'markers'], 'name': 'paint-order'},
  {'name': 'perspective', 'keywords': ['none']},
  {'name': 'perspective-origin'},
  {'longhands': ['align-content', 'justify-content'], 'name': 'place-content'},
  {'longhands': ['align-items', 'justify-items'], 'name': 'place-items'},
  {'longhands': ['align-self', 'justify-self'], 'name': 'place-self'},
  {
    'name': 'pointer-events',
    'inherited': true,
    'keywords': [
      'none', 'auto', 'stroke', 'fill', 'painted', 'visible', 'visiblestroke', 'visiblefill', 'visiblepainted',
      'bounding-box', 'all'
    ]
  },
  {'name': 'position', 'keywords': ['static', 'relative', 'absolute', 'fixed', 'sticky']},
  {'name': 'prefix'},
  {'name': 'quotes', 'inherited': true, 'keywords': ['auto', 'none']},
  {'svg': true, 'name': 'r'},
  {'name': 'range'},
  {'name': 'resize', 'keywords': ['none', 'both', 'horizontal', 'vertical', 'block', 'inline']},
  {'name': 'right', 'keywords': ['auto']},
  {'name': 'rotate'},
  {'name': 'row-gap', 'keywords': ['normal']},
  {'inherited': true, 'name': 'ruby-position'},
  {'name': 'rx', 'svg': true, 'keywords': ['auto']},
  {'name': 'ry', 'svg': true, 'keywords': ['auto']},
  {'name': 'scale'},
  {'name': 'scroll-behavior', 'keywords': ['auto', 'smooth']},
  {'name': 'scroll-customization'},
  {
    'longhands': ['scroll-margin-top', 'scroll-margin-right', 'scroll-margin-bottom', 'scroll-margin-left'],
    'name': 'scroll-margin'
  },
  {'longhands': ['scroll-margin-block-start', 'scroll-margin-block-end'], 'name': 'scroll-margin-block'},
  {'name': 'scroll-margin-block-end'},
  {'name': 'scroll-margin-block-start'},
  {'name': 'scroll-margin-bottom'},
  {'longhands': ['scroll-margin-inline-start', 'scroll-margin-inline-end'], 'name': 'scroll-margin-inline'},
  {'name': 'scroll-margin-inline-end'},
  {'name': 'scroll-margin-inline-start'},
  {'name': 'scroll-margin-left'},
  {'name': 'scroll-margin-right'},
  {'name': 'scroll-margin-top'},
  {
    'longhands': ['scroll-padding-top', 'scroll-padding-right', 'scroll-padding-bottom', 'scroll-padding-left'],
    'name': 'scroll-padding'
  },
  {'longhands': ['scroll-padding-block-start', 'scroll-padding-block-end'], 'name': 'scroll-padding-block'},
  {'name': 'scroll-padding-block-end', 'keywords': ['auto']},
  {'name': 'scroll-padding-block-start', 'keywords': ['auto']},
  {'name': 'scroll-padding-bottom', 'keywords': ['auto']},
  {'longhands': ['scroll-padding-inline-start', 'scroll-padding-inline-end'], 'name': 'scroll-padding-inline'},
  {'name': 'scroll-padding-inline-end', 'keywords': ['auto']},
  {'name': 'scroll-padding-inline-start', 'keywords': ['auto']},
  {'name': 'scroll-padding-left', 'keywords': ['auto']},
  {'name': 'scroll-padding-right', 'keywords': ['auto']},
  {'name': 'scroll-padding-top', 'keywords': ['auto']},
  {'name': 'scroll-snap-align', 'keywords': ['none', 'start', 'end', 'center']},
  {'name': 'scroll-snap-stop', 'keywords': ['normal', 'always']},
  {'name': 'scroll-snap-type', 'keywords': ['none', 'x', 'y', 'block', 'inline', 'both', 'mandatory', 'proximity']},
  {'name': 'scrollbar-gutter', 'inherited': false, 'keywords': ['auto', 'stable', 'always']},
  {'name': 'scrollbar-width', 'inherited': false, 'keywords': ['auto', 'thin', 'none']},
  {'name': 'shape-image-threshold'},
  {'name': 'shape-margin', 'keywords': ['none']},
  {'name': 'shape-outside', 'keywords': ['none']},
  {
    'name': 'shape-rendering',
    'svg': true,
    'inherited': true,
    'keywords': ['auto', 'optimizespeed', 'crispedges', 'geometricprecision']
  },
  {'name': 'size'},
  {'name': 'source'},
  {
    'name': 'speak',
    'inherited': true,
    'keywords': ['none', 'normal', 'spell-out', 'digits', 'literal-punctuation', 'no-punctuation']
  },
  {'name': 'speak-as'},
  {'name': 'src'},
  {'name': 'start'},
  {'name': 'stop-color', 'svg': true, 'keywords': ['currentcolor']},
  {'name': 'stop-opacity', 'svg': true},
  {'name': 'stroke', 'svg': true, 'inherited': true},
  {'name': 'stroke-dasharray', 'svg': true, 'inherited': true, 'keywords': ['none']},
  {'name': 'stroke-dashoffset', 'svg': true, 'inherited': true},
  {'name': 'stroke-linecap', 'svg': true, 'inherited': true, 'keywords': ['butt', 'round', 'square']},
  {'name': 'stroke-linejoin', 'svg': true, 'inherited': true, 'keywords': ['miter', 'bevel', 'round']},
  {'name': 'stroke-miterlimit', 'svg': true, 'inherited': true},
  {'svg': true, 'inherited': true, 'name': 'stroke-opacity'},
  {'svg': true, 'inherited': true, 'name': 'stroke-width'},
  {'name': 'suffix'},
  {'name': 'symbols'},
  {'name': 'syntax'},
  {'name': 'system'},
  {'name': 'tab-size', 'inherited': true},
  {'name': 'table-layout', 'keywords': ['auto', 'fixed']},
  {
    'name': 'text-align',
    'inherited': true,
    'keywords':
        ['left', 'right', 'center', 'justify', '-webkit-left', '-webkit-right', '-webkit-center', 'start', 'end']
  },
  {
    'name': 'text-align-last',
    'inherited': true,
    'keywords': ['auto', 'start', 'end', 'left', 'right', 'center', 'justify']
  },
  {'name': 'text-anchor', 'svg': true, 'inherited': true, 'keywords': ['start', 'middle', 'end']},
  {'name': 'text-combine-upright', 'inherited': true, 'keywords': ['none', 'all']},
  {
    'longhands':
        ['text-decoration-line', 'text-decoration-thickness', 'text-decoration-style', 'text-decoration-color'],
    'name': 'text-decoration'
  },
  {'name': 'text-decoration-color', 'keywords': ['currentcolor']},
  {'name': 'text-decoration-line', 'keywords': ['none', 'underline', 'overline', 'line-through', 'blink']},
  {'name': 'text-decoration-skip-ink', 'inherited': true, 'keywords': ['none', 'auto']},
  {'name': 'text-decoration-style', 'keywords': ['solid', 'double', 'dotted', 'dashed', 'wavy']},
  {'name': 'text-decoration-thickness', 'inherited': true, 'keywords': ['auto', 'from-font']},
  {'name': 'text-indent', 'inherited': true},
  {'name': 'text-justify', 'inherited': true, 'keywords': ['auto', 'none', 'inter-word', 'distribute']},
  {'name': 'text-orientation', 'inherited': true, 'keywords': ['sideways', 'mixed', 'upright']},
  {'name': 'text-overflow', 'keywords': ['clip', 'ellipsis']},
  {
    'name': 'text-rendering',
    'inherited': true,
    'keywords': ['auto', 'optimizespeed', 'optimizelegibility', 'geometricprecision']
  },
  {'name': 'text-shadow', 'inherited': true, 'keywords': ['none']},
  {'name': 'text-size-adjust', 'inherited': true, 'keywords': ['none', 'auto']},
  {
    'name': 'text-transform',
    'inherited': true,
    'keywords': ['capitalize', 'uppercase', 'lowercase', 'none', 'math-auto']
  },
  {'name': 'text-underline-offset', 'inherited': true, 'keywords': ['auto']},
  {'name': 'text-underline-position', 'inherited': true, 'keywords': ['auto', 'from-font', 'under', 'left', 'right']},
  {'name': 'time-range'},
  {'name': 'top', 'keywords': ['auto']},
  {
    'name': 'touch-action',
    'keywords':
        ['auto', 'none', 'pan-x', 'pan-left', 'pan-right', 'pan-y', 'pan-up', 'pan-down', 'pinch-zoom', 'manipulation']
  },
  {'name': 'transform', 'keywords': ['none']},
  {'name': 'transform-box', 'keywords': ['fill-box', 'view-box']},
  {'name': 'transform-origin'},
  {'name': 'transform-style', 'keywords': ['flat', 'preserve-3d']},
  {
    'longhands': ['transition-property', 'transition-duration', 'transition-timing-function', 'transition-delay'],
    'name': 'transition'
  },
  {'name': 'transition-delay'},
  {'name': 'transition-duration'},
  {'name': 'transition-property', 'keywords': ['none']},
  {
    'name': 'transition-timing-function',
    'keywords': [
      'linear', 'ease', 'ease-in', 'ease-out', 'ease-in-out', 'jump-both', 'jump-end', 'jump-none', 'jump-start',
      'step-start', 'step-end'
    ]
  },
  {'name': 'translate'},
  {
    'name': 'unicode-bidi',
    'keywords': ['normal', 'embed', 'bidi-override', 'isolate', 'plaintext', 'isolate-override']
  },
  {'name': 'unicode-range'},
  {'name': 'user-select', 'inherited': true, 'keywords': ['auto', 'none', 'text', 'all']},
  {'name': 'user-zoom'},
  {'keywords': ['none', 'non-scaling-stroke'], 'svg': true, 'name': 'vector-effect'},
  {'name': 'vertical-align', 'keywords': ['baseline', 'sub', 'super', 'text-top', 'text-bottom', 'middle']},
  {'name': 'viewport-fit'},
  {'name': 'visibility', 'inherited': true, 'keywords': ['visible', 'hidden', 'collapse']},
  {
    'name': 'white-space',
    'inherited': true,
    'keywords': ['none', 'normal', 'pre', 'pre-wrap', 'pre-line', 'nowrap', '-webkit-nowrap', 'break-spaces']
  },
  {'name': 'widows', 'inherited': true},
  {'name': 'width', 'keywords': ['auto', 'fit-content', 'min-content', 'max-content']},
  {'keywords': ['auto'], 'name': 'will-change'},
  {'name': 'word-break', 'inherited': true, 'keywords': ['normal', 'break-all', 'keep-all', 'break-word']},
  {'inherited': true, 'keywords': ['normal'], 'name': 'word-spacing'},
  {'name': 'writing-mode', 'inherited': true, 'keywords': ['horizontal-tb', 'vertical-rl', 'vertical-lr']},
  {'svg': true, 'name': 'x'},
  {'svg': true, 'name': 'y'},
  {'name': 'z-index', 'keywords': ['auto']},
  {'name': 'zoom'}
];
export const generatedPropertyValues = {
  '-webkit-app-region': {'values': ['none', 'drag', 'no-drag']},
  '-webkit-box-align': {'values': ['stretch', 'start', 'center', 'end', 'baseline']},
  '-webkit-box-decoration-break': {'values': ['slice', 'clone']},
  '-webkit-box-direction': {'values': ['normal', 'reverse']},
  '-webkit-box-orient': {'values': ['horizontal', 'vertical']},
  '-webkit-box-pack': {'values': ['start', 'center', 'end', 'justify']},
  '-webkit-line-break': {'values': ['auto', 'loose', 'normal', 'strict', 'after-white-space', 'anywhere']},
  '-webkit-print-color-adjust': {'values': ['economy', 'exact']},
  '-webkit-rtl-ordering': {'values': ['logical', 'visual']},
  '-webkit-ruby-position': {'values': ['before', 'after']},
  '-webkit-text-security': {'values': ['none', 'disc', 'circle', 'square']},
  '-webkit-user-drag': {'values': ['auto', 'none', 'element']},
  '-webkit-user-modify': {'values': ['read-only', 'read-write', 'read-write-plaintext-only']},
  'alignment-baseline': {'values': ['baseline', 'alphabetic', 'ideographic', 'middle', 'central', 'mathematical']},
  'animation-direction': {'values': ['normal', 'reverse', 'alternate', 'alternate-reverse']},
  'animation-fill-mode': {'values': ['none', 'forwards', 'backwards', 'both']},
  'animation-iteration-count': {'values': ['infinite']},
  'animation-name': {'values': ['none']},
  'animation-play-state': {'values': ['running', 'paused']},
  'animation-timeline': {'values': ['none', 'auto']},
  'animation-timing-function': {
    'values': [
      'linear', 'ease', 'ease-in', 'ease-out', 'ease-in-out', 'jump-both', 'jump-end', 'jump-none', 'jump-start',
      'step-start', 'step-end'
    ]
  },
  'aspect-ratio': {'values': ['auto']},
  'backdrop-filter': {'values': ['none']},
  'backface-visibility': {'values': ['visible', 'hidden']},
  'background-attachment': {'values': ['scroll', 'fixed', 'local']},
  'background-blend-mode': {
    'values': [
      'normal', 'multiply', 'screen', 'overlay', 'darken', 'lighten', 'color-dodge', 'color-burn', 'hard-light',
      'soft-light', 'difference', 'exclusion', 'hue', 'saturation', 'color', 'luminosity'
    ]
  },
  'background-clip': {'values': ['border-box', 'padding-box', 'content-box']},
  'background-color': {'values': ['currentcolor']},
  'background-image': {'values': ['auto', 'none']},
  'background-origin': {'values': ['border-box', 'padding-box', 'content-box']},
  'background-size': {'values': ['auto', 'cover', 'contain']},
  'baseline-shift': {'values': ['sub', 'super']},
  'block-size': {'values': ['auto']},
  'border-bottom-color': {'values': ['currentcolor']},
  'border-bottom-style':
      {'values': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']},
  'border-bottom-width': {'values': ['thin', 'medium', 'thick']},
  'border-collapse': {'values': ['separate', 'collapse']},
  'border-image-repeat': {'values': ['stretch', 'repeat', 'round', 'space']},
  'border-image-source': {'values': ['none']},
  'border-image-width': {'values': ['auto']},
  'border-left-color': {'values': ['currentcolor']},
  'border-left-style':
      {'values': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']},
  'border-left-width': {'values': ['thin', 'medium', 'thick']},
  'border-right-color': {'values': ['currentcolor']},
  'border-right-style':
      {'values': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']},
  'border-right-width': {'values': ['thin', 'medium', 'thick']},
  'border-style': {'values': ['none']},
  'border-top-color': {'values': ['currentcolor']},
  'border-top-style':
      {'values': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']},
  'border-top-width': {'values': ['thin', 'medium', 'thick']},
  'bottom': {'values': ['auto']},
  'box-shadow': {'values': ['none']},
  'box-sizing': {'values': ['content-box', 'border-box']},
  'break-after':
      {'values': ['auto', 'avoid', 'avoid-column', 'avoid-page', 'column', 'left', 'page', 'recto', 'right', 'verso']},
  'break-before':
      {'values': ['auto', 'avoid', 'avoid-column', 'avoid-page', 'column', 'left', 'page', 'recto', 'right', 'verso']},
  'break-inside': {'values': ['auto', 'avoid', 'avoid-column', 'avoid-page']},
  'caption-side': {'values': ['top', 'bottom']},
  'caret-color': {'values': ['auto', 'currentcolor']},
  'clear': {'values': ['none', 'left', 'right', 'both', 'inline-start', 'inline-end']},
  'clip': {'values': ['auto']},
  'clip-path': {'values': ['none']},
  'clip-rule': {'values': ['nonzero', 'evenodd']},
  'color': {'values': ['currentcolor']},
  'color-interpolation': {'values': ['auto', 'srgb', 'linearrgb']},
  'color-rendering': {'values': ['auto', 'optimizespeed', 'optimizequality']},
  'column-count': {'values': ['auto']},
  'column-fill': {'values': ['balance', 'auto']},
  'column-gap': {'values': ['normal']},
  'column-rule-color': {'values': ['currentcolor']},
  'column-rule-style':
      {'values': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']},
  'column-rule-width': {'values': ['thin', 'medium', 'thick']},
  'column-span': {'values': ['none', 'all']},
  'column-width': {'values': ['auto']},
  'contain': {'values': ['none', 'strict', 'content', 'size', 'layout', 'style', 'paint']},
  'contain-intrinsic-size': {'values': ['auto']},
  'content-visibility': {'values': ['visible', 'auto', 'hidden', 'hidden-matchable']},
  'counter-increment': {'values': ['none']},
  'counter-reset': {'values': ['none']},
  'counter-set': {'values': ['none']},
  'cursor': {
    'values': [
      'auto',        'default',   'none',      'context-menu',  'help',        'pointer',    'progress',   'wait',
      'cell',        'crosshair', 'text',      'vertical-text', 'alias',       'copy',       'move',       'no-drop',
      'not-allowed', 'e-resize',  'n-resize',  'ne-resize',     'nw-resize',   's-resize',   'se-resize',  'sw-resize',
      'w-resize',    'ew-resize', 'ns-resize', 'nesw-resize',   'nwse-resize', 'col-resize', 'row-resize', 'all-scroll',
      'zoom-in',     'zoom-out',  'grab',      'grabbing'
    ]
  },
  'd': {'values': ['none']},
  'direction': {'values': ['ltr', 'rtl']},
  'display': {
    'values': [
      'inline',
      'block',
      'list-item',
      'inline-block',
      'table',
      'inline-table',
      'table-row-group',
      'table-header-group',
      'table-footer-group',
      'table-row',
      'table-column-group',
      'table-column',
      'table-cell',
      'table-caption',
      '-webkit-box',
      '-webkit-inline-box',
      'flex',
      'inline-flex',
      'grid',
      'inline-grid',
      'contents',
      'flow-root',
      'none'
    ]
  },
  'dominant-baseline':
      {'values': ['auto', 'alphabetic', 'ideographic', 'middle', 'central', 'mathematical', 'hanging']},
  'empty-cells': {'values': ['show', 'hide']},
  'fill-rule': {'values': ['nonzero', 'evenodd']},
  'filter': {'values': ['none']},
  'flex-basis': {'values': ['auto']},
  'flex-direction': {'values': ['row', 'row-reverse', 'column', 'column-reverse']},
  'flex-wrap': {'values': ['nowrap', 'wrap', 'wrap-reverse']},
  'float': {'values': ['none', 'left', 'right', 'inline-start', 'inline-end']},
  'flood-color': {'values': ['currentcolor']},
  'font-feature-settings': {'values': ['normal']},
  'font-kerning': {'values': ['auto', 'normal', 'none']},
  'font-optical-sizing': {'values': ['auto', 'none']},
  'font-size': {
    'values': [
      'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large', 'xxx-large', 'larger', 'smaller',
      '-webkit-xxx-large'
    ]
  },
  'font-size-adjust': {'values': ['none']},
  'font-stretch': {
    'values': [
      'normal', 'ultra-condensed', 'extra-condensed', 'condensed', 'semi-condensed', 'semi-expanded', 'expanded',
      'extra-expanded', 'ultra-expanded'
    ]
  },
  'font-style': {'values': ['normal', 'italic', 'oblique']},
  'font-variant-caps': {
    'values': ['normal', 'small-caps', 'all-small-caps', 'petite-caps', 'all-petite-caps', 'unicase', 'titling-caps']
  },
  'font-variant-east-asian': {
    'values': [
      'normal', 'jis78', 'jis83', 'jis90', 'jis04', 'simplified', 'traditional', 'full-width', 'proportional-width',
      'ruby'
    ]
  },
  'font-variant-ligatures': {
    'values': [
      'normal', 'none', 'common-ligatures', 'no-common-ligatures', 'discretionary-ligatures',
      'no-discretionary-ligatures', 'historical-ligatures', 'no-historical-ligatures', 'contextual', 'no-contextual'
    ]
  },
  'font-variant-numeric': {
    'values': [
      'normal', 'lining-nums', 'oldstyle-nums', 'proportional-nums', 'tabular-nums', 'diagonal-fractions',
      'stacked-fractions', 'ordinal', 'slashed-zero'
    ]
  },
  'font-variation-settings': {'values': ['normal']},
  'font-weight': {'values': ['normal', 'bold', 'bolder', 'lighter']},
  'forced-color-adjust': {'values': ['auto', 'none']},
  'grid-auto-columns': {'values': ['auto', 'min-content', 'max-content']},
  'grid-auto-flow': {'values': ['row', 'column']},
  'grid-auto-rows': {'values': ['auto', 'min-content', 'max-content']},
  'grid-column-end': {'values': ['auto']},
  'grid-column-start': {'values': ['auto']},
  'grid-row-end': {'values': ['auto']},
  'grid-row-start': {'values': ['auto']},
  'grid-template-areas': {'values': ['none']},
  'grid-template-columns': {'values': ['none']},
  'grid-template-rows': {'values': ['none']},
  'height': {'values': ['auto', 'fit-content', 'min-content', 'max-content']},
  'hyphens': {'values': ['none', 'manual', 'auto']},
  'image-rendering': {'values': ['auto', 'optimizespeed', 'optimizequality', '-webkit-optimize-contrast', 'pixelated']},
  'inline-size': {'values': ['auto']},
  'isolation': {'values': ['auto', 'isolate']},
  'left': {'values': ['auto']},
  'letter-spacing': {'values': ['normal']},
  'lighting-color': {'values': ['currentcolor']},
  'line-break': {'values': ['auto', 'loose', 'normal', 'strict', 'anywhere']},
  'line-height': {'values': ['normal']},
  'list-style-image': {'values': ['none']},
  'list-style-position': {'values': ['outside', 'inside']},
  'list-style-type': {
    'values': [
      'disc',
      'circle',
      'square',
      'disclosure-open',
      'disclosure-closed',
      'decimal',
      'decimal-leading-zero',
      'arabic-indic',
      'bengali',
      'cambodian',
      'khmer',
      'devanagari',
      'gujarati',
      'gurmukhi',
      'kannada',
      'lao',
      'malayalam',
      'mongolian',
      'myanmar',
      'oriya',
      'persian',
      'urdu',
      'telugu',
      'tibetan',
      'thai',
      'lower-roman',
      'upper-roman',
      'lower-greek',
      'lower-alpha',
      'lower-latin',
      'upper-alpha',
      'upper-latin',
      'cjk-earthly-branch',
      'cjk-heavenly-stem',
      'ethiopic-halehame',
      'ethiopic-halehame-am',
      'ethiopic-halehame-ti-er',
      'ethiopic-halehame-ti-et',
      'hangul',
      'hangul-consonant',
      'korean-hangul-formal',
      'korean-hanja-formal',
      'korean-hanja-informal',
      'hebrew',
      'armenian',
      'lower-armenian',
      'upper-armenian',
      'georgian',
      'cjk-ideographic',
      'simp-chinese-formal',
      'simp-chinese-informal',
      'trad-chinese-formal',
      'trad-chinese-informal',
      'hiragana',
      'katakana',
      'hiragana-iroha',
      'katakana-iroha',
      'none'
    ]
  },
  'margin-block-end': {'values': ['auto']},
  'margin-block-start': {'values': ['auto']},
  'margin-bottom': {'values': ['auto']},
  'margin-inline-end': {'values': ['auto']},
  'margin-inline-start': {'values': ['auto']},
  'margin-left': {'values': ['auto']},
  'margin-right': {'values': ['auto']},
  'margin-top': {'values': ['auto']},
  'marker-end': {'values': ['none']},
  'marker-mid': {'values': ['none']},
  'marker-start': {'values': ['none']},
  'mask-type': {'values': ['luminance', 'alpha']},
  'math-shift': {'values': ['normal', 'compact']},
  'math-style': {'values': ['normal', 'compact']},
  'max-block-size': {'values': ['none']},
  'max-height': {'values': ['none']},
  'max-inline-size': {'values': ['none']},
  'max-width': {'values': ['none']},
  'mix-blend-mode': {
    'values': [
      'normal', 'multiply', 'screen', 'overlay', 'darken', 'lighten', 'color-dodge', 'color-burn', 'hard-light',
      'soft-light', 'difference', 'exclusion', 'hue', 'saturation', 'color', 'luminosity'
    ]
  },
  'object-fit': {'values': ['fill', 'contain', 'cover', 'none', 'scale-down']},
  'offset-anchor': {'values': ['auto']},
  'offset-path': {'values': ['none']},
  'offset-position': {'values': ['auto']},
  'offset-rotate': {'values': ['auto', 'reverse']},
  'origin-trial-test-property': {'values': ['normal', 'none']},
  'outline-color': {'values': ['currentcolor']},
  'outline-style':
      {'values': ['none', 'hidden', 'inset', 'groove', 'outset', 'ridge', 'dotted', 'dashed', 'solid', 'double']},
  'outline-width': {'values': ['thin', 'medium', 'thick']},
  'overflow-anchor': {'values': ['visible', 'none', 'auto']},
  'overflow-wrap': {'values': ['normal', 'break-word', 'anywhere']},
  'overflow-x': {'values': ['visible', 'hidden', 'scroll', 'auto', 'overlay', 'clip']},
  'overflow-y': {'values': ['visible', 'hidden', 'scroll', 'auto', 'overlay', 'clip']},
  'overscroll-behavior-x': {'values': ['auto', 'contain', 'none']},
  'overscroll-behavior-y': {'values': ['auto', 'contain', 'none']},
  'page': {'values': ['auto']},
  'paint-order': {'values': ['normal', 'fill', 'stroke', 'markers']},
  'perspective': {'values': ['none']},
  'pointer-events': {
    'values': [
      'none', 'auto', 'stroke', 'fill', 'painted', 'visible', 'visiblestroke', 'visiblefill', 'visiblepainted',
      'bounding-box', 'all'
    ]
  },
  'position': {'values': ['static', 'relative', 'absolute', 'fixed', 'sticky']},
  'quotes': {'values': ['auto', 'none']},
  'resize': {'values': ['none', 'both', 'horizontal', 'vertical', 'block', 'inline']},
  'right': {'values': ['auto']},
  'row-gap': {'values': ['normal']},
  'rx': {'values': ['auto']},
  'ry': {'values': ['auto']},
  'scroll-behavior': {'values': ['auto', 'smooth']},
  'scroll-padding-block-end': {'values': ['auto']},
  'scroll-padding-block-start': {'values': ['auto']},
  'scroll-padding-bottom': {'values': ['auto']},
  'scroll-padding-inline-end': {'values': ['auto']},
  'scroll-padding-inline-start': {'values': ['auto']},
  'scroll-padding-left': {'values': ['auto']},
  'scroll-padding-right': {'values': ['auto']},
  'scroll-padding-top': {'values': ['auto']},
  'scroll-snap-align': {'values': ['none', 'start', 'end', 'center']},
  'scroll-snap-stop': {'values': ['normal', 'always']},
  'scroll-snap-type': {'values': ['none', 'x', 'y', 'block', 'inline', 'both', 'mandatory', 'proximity']},
  'scrollbar-gutter': {'values': ['auto', 'stable', 'always']},
  'scrollbar-width': {'values': ['auto', 'thin', 'none']},
  'shape-margin': {'values': ['none']},
  'shape-outside': {'values': ['none']},
  'shape-rendering': {'values': ['auto', 'optimizespeed', 'crispedges', 'geometricprecision']},
  'speak': {'values': ['none', 'normal', 'spell-out', 'digits', 'literal-punctuation', 'no-punctuation']},
  'stop-color': {'values': ['currentcolor']},
  'stroke-dasharray': {'values': ['none']},
  'stroke-linecap': {'values': ['butt', 'round', 'square']},
  'stroke-linejoin': {'values': ['miter', 'bevel', 'round']},
  'table-layout': {'values': ['auto', 'fixed']},
  'text-align': {
    'values': ['left', 'right', 'center', 'justify', '-webkit-left', '-webkit-right', '-webkit-center', 'start', 'end']
  },
  'text-align-last': {'values': ['auto', 'start', 'end', 'left', 'right', 'center', 'justify']},
  'text-anchor': {'values': ['start', 'middle', 'end']},
  'text-combine-upright': {'values': ['none', 'all']},
  'text-decoration-color': {'values': ['currentcolor']},
  'text-decoration-line': {'values': ['none', 'underline', 'overline', 'line-through', 'blink']},
  'text-decoration-skip-ink': {'values': ['none', 'auto']},
  'text-decoration-style': {'values': ['solid', 'double', 'dotted', 'dashed', 'wavy']},
  'text-decoration-thickness': {'values': ['auto', 'from-font']},
  'text-justify': {'values': ['auto', 'none', 'inter-word', 'distribute']},
  'text-orientation': {'values': ['sideways', 'mixed', 'upright']},
  'text-overflow': {'values': ['clip', 'ellipsis']},
  'text-rendering': {'values': ['auto', 'optimizespeed', 'optimizelegibility', 'geometricprecision']},
  'text-shadow': {'values': ['none']},
  'text-size-adjust': {'values': ['none', 'auto']},
  'text-transform': {'values': ['capitalize', 'uppercase', 'lowercase', 'none', 'math-auto']},
  'text-underline-offset': {'values': ['auto']},
  'text-underline-position': {'values': ['auto', 'from-font', 'under', 'left', 'right']},
  'top': {'values': ['auto']},
  'touch-action': {
    'values':
        ['auto', 'none', 'pan-x', 'pan-left', 'pan-right', 'pan-y', 'pan-up', 'pan-down', 'pinch-zoom', 'manipulation']
  },
  'transform': {'values': ['none']},
  'transform-box': {'values': ['fill-box', 'view-box']},
  'transform-style': {'values': ['flat', 'preserve-3d']},
  'transition-property': {'values': ['none']},
  'transition-timing-function': {
    'values': [
      'linear', 'ease', 'ease-in', 'ease-out', 'ease-in-out', 'jump-both', 'jump-end', 'jump-none', 'jump-start',
      'step-start', 'step-end'
    ]
  },
  'unicode-bidi': {'values': ['normal', 'embed', 'bidi-override', 'isolate', 'plaintext', 'isolate-override']},
  'user-select': {'values': ['auto', 'none', 'text', 'all']},
  'vector-effect': {'values': ['none', 'non-scaling-stroke']},
  'vertical-align': {'values': ['baseline', 'sub', 'super', 'text-top', 'text-bottom', 'middle']},
  'visibility': {'values': ['visible', 'hidden', 'collapse']},
  'white-space':
      {'values': ['none', 'normal', 'pre', 'pre-wrap', 'pre-line', 'nowrap', '-webkit-nowrap', 'break-spaces']},
  'width': {'values': ['auto', 'fit-content', 'min-content', 'max-content']},
  'will-change': {'values': ['auto']},
  'word-break': {'values': ['normal', 'break-all', 'keep-all', 'break-word']},
  'word-spacing': {'values': ['normal']},
  'writing-mode': {'values': ['horizontal-tb', 'vertical-rl', 'vertical-lr']},
  'z-index': {'values': ['auto']}
};
export const generatedAliasesFor = new Map([
  ['-epub-caption-side', 'caption-side'],
  ['-epub-text-combine', '-webkit-text-combine'],
  ['-epub-text-emphasis', '-webkit-text-emphasis'],
  ['-epub-text-emphasis-color', '-webkit-text-emphasis-color'],
  ['-epub-text-emphasis-style', '-webkit-text-emphasis-style'],
  ['-epub-text-orientation', '-webkit-text-orientation'],
  ['-epub-text-transform', 'text-transform'],
  ['-epub-word-break', 'word-break'],
  ['-epub-writing-mode', '-webkit-writing-mode'],
  ['-webkit-align-content', 'align-content'],
  ['-webkit-align-items', 'align-items'],
  ['-webkit-align-self', 'align-self'],
  ['-webkit-animation', 'animation'],
  ['-webkit-animation-delay', 'animation-delay'],
  ['-webkit-animation-direction', 'animation-direction'],
  ['-webkit-animation-duration', 'animation-duration'],
  ['-webkit-animation-fill-mode', 'animation-fill-mode'],
  ['-webkit-animation-iteration-count', 'animation-iteration-count'],
  ['-webkit-animation-name', 'animation-name'],
  ['-webkit-animation-play-state', 'animation-play-state'],
  ['-webkit-animation-timing-function', 'animation-timing-function'],
  ['-webkit-appearance', 'appearance'],
  ['-webkit-backface-visibility', 'backface-visibility'],
  ['-webkit-background-clip', 'background-clip'],
  ['-webkit-background-origin', 'background-origin'],
  ['-webkit-background-size', 'background-size'],
  ['-webkit-border-after', 'border-block-end'],
  ['-webkit-border-after-color', 'border-block-end-color'],
  ['-webkit-border-after-style', 'border-block-end-style'],
  ['-webkit-border-after-width', 'border-block-end-width'],
  ['-webkit-border-before', 'border-block-start'],
  ['-webkit-border-before-color', 'border-block-start-color'],
  ['-webkit-border-before-style', 'border-block-start-style'],
  ['-webkit-border-before-width', 'border-block-start-width'],
  ['-webkit-border-bottom-left-radius', 'border-bottom-left-radius'],
  ['-webkit-border-bottom-right-radius', 'border-bottom-right-radius'],
  ['-webkit-border-end', 'border-inline-end'],
  ['-webkit-border-end-color', 'border-inline-end-color'],
  ['-webkit-border-end-style', 'border-inline-end-style'],
  ['-webkit-border-end-width', 'border-inline-end-width'],
  ['-webkit-border-radius', 'border-radius'],
  ['-webkit-border-start', 'border-inline-start'],
  ['-webkit-border-start-color', 'border-inline-start-color'],
  ['-webkit-border-start-style', 'border-inline-start-style'],
  ['-webkit-border-start-width', 'border-inline-start-width'],
  ['-webkit-border-top-left-radius', 'border-top-left-radius'],
  ['-webkit-border-top-right-radius', 'border-top-right-radius'],
  ['-webkit-box-shadow', 'box-shadow'],
  ['-webkit-box-sizing', 'box-sizing'],
  ['-webkit-clip-path', 'clip-path'],
  ['-webkit-column-count', 'column-count'],
  ['-webkit-column-gap', 'column-gap'],
  ['-webkit-column-rule', 'column-rule'],
  ['-webkit-column-rule-color', 'column-rule-color'],
  ['-webkit-column-rule-style', 'column-rule-style'],
  ['-webkit-column-rule-width', 'column-rule-width'],
  ['-webkit-column-span', 'column-span'],
  ['-webkit-column-width', 'column-width'],
  ['-webkit-columns', 'columns'],
  ['-webkit-filter', 'filter'],
  ['-webkit-flex', 'flex'],
  ['-webkit-flex-basis', 'flex-basis'],
  ['-webkit-flex-direction', 'flex-direction'],
  ['-webkit-flex-flow', 'flex-flow'],
  ['-webkit-flex-grow', 'flex-grow'],
  ['-webkit-flex-shrink', 'flex-shrink'],
  ['-webkit-flex-wrap', 'flex-wrap'],
  ['-webkit-font-feature-settings', 'font-feature-settings'],
  ['-webkit-justify-content', 'justify-content'],
  ['-webkit-logical-height', 'block-size'],
  ['-webkit-logical-width', 'inline-size'],
  ['-webkit-margin-after', 'margin-block-end'],
  ['-webkit-margin-before', 'margin-block-start'],
  ['-webkit-margin-end', 'margin-inline-end'],
  ['-webkit-margin-start', 'margin-inline-start'],
  ['-webkit-max-logical-height', 'max-block-size'],
  ['-webkit-max-logical-width', 'max-inline-size'],
  ['-webkit-min-logical-height', 'min-block-size'],
  ['-webkit-min-logical-width', 'min-inline-size'],
  ['-webkit-opacity', 'opacity'],
  ['-webkit-order', 'order'],
  ['-webkit-padding-after', 'padding-block-end'],
  ['-webkit-padding-before', 'padding-block-start'],
  ['-webkit-padding-end', 'padding-inline-end'],
  ['-webkit-padding-start', 'padding-inline-start'],
  ['-webkit-perspective', 'perspective'],
  ['-webkit-perspective-origin', 'perspective-origin'],
  ['-webkit-shape-image-threshold', 'shape-image-threshold'],
  ['-webkit-shape-margin', 'shape-margin'],
  ['-webkit-shape-outside', 'shape-outside'],
  ['-webkit-text-size-adjust', 'text-size-adjust'],
  ['-webkit-transform', 'transform'],
  ['-webkit-transform-origin', 'transform-origin'],
  ['-webkit-transform-style', 'transform-style'],
  ['-webkit-transition', 'transition'],
  ['-webkit-transition-delay', 'transition-delay'],
  ['-webkit-transition-duration', 'transition-duration'],
  ['-webkit-transition-property', 'transition-property'],
  ['-webkit-transition-timing-function', 'transition-timing-function'],
  ['-webkit-user-select', 'user-select'],
  ['word-wrap', 'overflow-wrap']
]);
