// Copyright (c) 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// File is generated by devtools-frontend/scripts/build/code_generator_frontend.py


/**
 * @typedef {{
 *  registerCommand: function(string, !Array.<!{name: string, type: string, optional: boolean}>, !Array.<string>):void,
 *  registerEnum: function(string, !Object<string, string>):void,
 *  registerEvent: function(string, !Array<string>):void,
 * }}
 */
// @ts-ignore typedef
export let InspectorBackendAPI;

/**
 * @param {!InspectorBackendAPI} inspectorBackend
 */
export function registerCommands(inspectorBackend) {
  // Accessibility.
  inspectorBackend.registerEnum('Accessibility.AXValueType', {
    Boolean: 'boolean',
    Tristate: 'tristate',
    BooleanOrUndefined: 'booleanOrUndefined',
    Idref: 'idref',
    IdrefList: 'idrefList',
    Integer: 'integer',
    Node: 'node',
    NodeList: 'nodeList',
    Number: 'number',
    String: 'string',
    ComputedString: 'computedString',
    Token: 'token',
    TokenList: 'tokenList',
    DomRelation: 'domRelation',
    Role: 'role',
    InternalRole: 'internalRole',
    ValueUndefined: 'valueUndefined'
  });
  inspectorBackend.registerEnum('Accessibility.AXValueSourceType', {
    Attribute: 'attribute',
    Implicit: 'implicit',
    Style: 'style',
    Contents: 'contents',
    Placeholder: 'placeholder',
    RelatedElement: 'relatedElement'
  });
  inspectorBackend.registerEnum('Accessibility.AXValueNativeSourceType', {
    Figcaption: 'figcaption',
    Label: 'label',
    Labelfor: 'labelfor',
    Labelwrapped: 'labelwrapped',
    Legend: 'legend',
    Rubyannotation: 'rubyannotation',
    Tablecaption: 'tablecaption',
    Title: 'title',
    Other: 'other'
  });
  inspectorBackend.registerEnum('Accessibility.AXPropertyName', {
    Busy: 'busy',
    Disabled: 'disabled',
    Editable: 'editable',
    Focusable: 'focusable',
    Focused: 'focused',
    Hidden: 'hidden',
    HiddenRoot: 'hiddenRoot',
    Invalid: 'invalid',
    Keyshortcuts: 'keyshortcuts',
    Settable: 'settable',
    Roledescription: 'roledescription',
    Live: 'live',
    Atomic: 'atomic',
    Relevant: 'relevant',
    Root: 'root',
    Autocomplete: 'autocomplete',
    HasPopup: 'hasPopup',
    Level: 'level',
    Multiselectable: 'multiselectable',
    Orientation: 'orientation',
    Multiline: 'multiline',
    Readonly: 'readonly',
    Required: 'required',
    Valuemin: 'valuemin',
    Valuemax: 'valuemax',
    Valuetext: 'valuetext',
    Checked: 'checked',
    Expanded: 'expanded',
    Modal: 'modal',
    Pressed: 'pressed',
    Selected: 'selected',
    Activedescendant: 'activedescendant',
    Controls: 'controls',
    Describedby: 'describedby',
    Details: 'details',
    Errormessage: 'errormessage',
    Flowto: 'flowto',
    Labelledby: 'labelledby',
    Owns: 'owns'
  });
  inspectorBackend.registerCommand('Accessibility.disable', [], []);
  inspectorBackend.registerCommand('Accessibility.enable', [], []);
  inspectorBackend.registerCommand(
      'Accessibility.getPartialAXTree',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true},
        {'name': 'fetchRelatives', 'type': 'boolean', 'optional': true}
      ],
      ['nodes']);
  inspectorBackend.registerCommand(
      'Accessibility.getFullAXTree', [{'name': 'max_depth', 'type': 'number', 'optional': true}], ['nodes']);
  inspectorBackend.registerCommand(
      'Accessibility.getChildAXNodes', [{'name': 'id', 'type': 'string', 'optional': false}], ['nodes']);
  inspectorBackend.registerCommand(
      'Accessibility.queryAXTree',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true},
        {'name': 'accessibleName', 'type': 'string', 'optional': true},
        {'name': 'role', 'type': 'string', 'optional': true}
      ],
      ['nodes']);

  // Animation.
  inspectorBackend.registerEnum(
      'Animation.AnimationType',
      {CSSTransition: 'CSSTransition', CSSAnimation: 'CSSAnimation', WebAnimation: 'WebAnimation'});
  inspectorBackend.registerEvent('Animation.animationCanceled', ['id']);
  inspectorBackend.registerEvent('Animation.animationCreated', ['id']);
  inspectorBackend.registerEvent('Animation.animationStarted', ['animation']);
  inspectorBackend.registerCommand('Animation.disable', [], []);
  inspectorBackend.registerCommand('Animation.enable', [], []);
  inspectorBackend.registerCommand(
      'Animation.getCurrentTime', [{'name': 'id', 'type': 'string', 'optional': false}], ['currentTime']);
  inspectorBackend.registerCommand('Animation.getPlaybackRate', [], ['playbackRate']);
  inspectorBackend.registerCommand(
      'Animation.releaseAnimations', [{'name': 'animations', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Animation.resolveAnimation', [{'name': 'animationId', 'type': 'string', 'optional': false}], ['remoteObject']);
  inspectorBackend.registerCommand(
      'Animation.seekAnimations',
      [
        {'name': 'animations', 'type': 'object', 'optional': false},
        {'name': 'currentTime', 'type': 'number', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Animation.setPaused',
      [
        {'name': 'animations', 'type': 'object', 'optional': false},
        {'name': 'paused', 'type': 'boolean', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Animation.setPlaybackRate', [{'name': 'playbackRate', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Animation.setTiming',
      [
        {'name': 'animationId', 'type': 'string', 'optional': false},
        {'name': 'duration', 'type': 'number', 'optional': false},
        {'name': 'delay', 'type': 'number', 'optional': false}
      ],
      []);

  // ApplicationCache.
  inspectorBackend.registerEvent(
      'ApplicationCache.applicationCacheStatusUpdated', ['frameId', 'manifestURL', 'status']);
  inspectorBackend.registerEvent('ApplicationCache.networkStateUpdated', ['isNowOnline']);
  inspectorBackend.registerCommand('ApplicationCache.enable', [], []);
  inspectorBackend.registerCommand(
      'ApplicationCache.getApplicationCacheForFrame', [{'name': 'frameId', 'type': 'string', 'optional': false}],
      ['applicationCache']);
  inspectorBackend.registerCommand('ApplicationCache.getFramesWithManifests', [], ['frameIds']);
  inspectorBackend.registerCommand(
      'ApplicationCache.getManifestForFrame', [{'name': 'frameId', 'type': 'string', 'optional': false}],
      ['manifestURL']);

  // Audits.
  inspectorBackend.registerEnum('Audits.SameSiteCookieExclusionReason', {
    ExcludeSameSiteUnspecifiedTreatedAsLax: 'ExcludeSameSiteUnspecifiedTreatedAsLax',
    ExcludeSameSiteNoneInsecure: 'ExcludeSameSiteNoneInsecure',
    ExcludeSameSiteLax: 'ExcludeSameSiteLax',
    ExcludeSameSiteStrict: 'ExcludeSameSiteStrict'
  });
  inspectorBackend.registerEnum('Audits.SameSiteCookieWarningReason', {
    WarnSameSiteUnspecifiedCrossSiteContext: 'WarnSameSiteUnspecifiedCrossSiteContext',
    WarnSameSiteNoneInsecure: 'WarnSameSiteNoneInsecure',
    WarnSameSiteUnspecifiedLaxAllowUnsafe: 'WarnSameSiteUnspecifiedLaxAllowUnsafe',
    WarnSameSiteStrictLaxDowngradeStrict: 'WarnSameSiteStrictLaxDowngradeStrict',
    WarnSameSiteStrictCrossDowngradeStrict: 'WarnSameSiteStrictCrossDowngradeStrict',
    WarnSameSiteStrictCrossDowngradeLax: 'WarnSameSiteStrictCrossDowngradeLax',
    WarnSameSiteLaxCrossDowngradeStrict: 'WarnSameSiteLaxCrossDowngradeStrict',
    WarnSameSiteLaxCrossDowngradeLax: 'WarnSameSiteLaxCrossDowngradeLax'
  });
  inspectorBackend.registerEnum('Audits.SameSiteCookieOperation', {SetCookie: 'SetCookie', ReadCookie: 'ReadCookie'});
  inspectorBackend.registerEnum('Audits.MixedContentResolutionStatus', {
    MixedContentBlocked: 'MixedContentBlocked',
    MixedContentAutomaticallyUpgraded: 'MixedContentAutomaticallyUpgraded',
    MixedContentWarning: 'MixedContentWarning'
  });
  inspectorBackend.registerEnum('Audits.MixedContentResourceType', {
    Audio: 'Audio',
    Beacon: 'Beacon',
    CSPReport: 'CSPReport',
    Download: 'Download',
    EventSource: 'EventSource',
    Favicon: 'Favicon',
    Font: 'Font',
    Form: 'Form',
    Frame: 'Frame',
    Image: 'Image',
    Import: 'Import',
    Manifest: 'Manifest',
    Ping: 'Ping',
    PluginData: 'PluginData',
    PluginResource: 'PluginResource',
    Prefetch: 'Prefetch',
    Resource: 'Resource',
    Script: 'Script',
    ServiceWorker: 'ServiceWorker',
    SharedWorker: 'SharedWorker',
    Stylesheet: 'Stylesheet',
    Track: 'Track',
    Video: 'Video',
    Worker: 'Worker',
    XMLHttpRequest: 'XMLHttpRequest',
    XSLT: 'XSLT'
  });
  inspectorBackend.registerEnum('Audits.BlockedByResponseReason', {
    CoepFrameResourceNeedsCoepHeader: 'CoepFrameResourceNeedsCoepHeader',
    CoopSandboxedIFrameCannotNavigateToCoopPage: 'CoopSandboxedIFrameCannotNavigateToCoopPage',
    CorpNotSameOrigin: 'CorpNotSameOrigin',
    CorpNotSameOriginAfterDefaultedToSameOriginByCoep: 'CorpNotSameOriginAfterDefaultedToSameOriginByCoep',
    CorpNotSameSite: 'CorpNotSameSite'
  });
  inspectorBackend.registerEnum(
      'Audits.HeavyAdResolutionStatus', {HeavyAdBlocked: 'HeavyAdBlocked', HeavyAdWarning: 'HeavyAdWarning'});
  inspectorBackend.registerEnum(
      'Audits.HeavyAdReason',
      {NetworkTotalLimit: 'NetworkTotalLimit', CpuTotalLimit: 'CpuTotalLimit', CpuPeakLimit: 'CpuPeakLimit'});
  inspectorBackend.registerEnum('Audits.ContentSecurityPolicyViolationType', {
    KInlineViolation: 'kInlineViolation',
    KEvalViolation: 'kEvalViolation',
    KURLViolation: 'kURLViolation',
    KTrustedTypesSinkViolation: 'kTrustedTypesSinkViolation',
    KTrustedTypesPolicyViolation: 'kTrustedTypesPolicyViolation'
  });
  inspectorBackend.registerEnum(
      'Audits.SharedArrayBufferIssueType', {TransferIssue: 'TransferIssue', CreationIssue: 'CreationIssue'});
  inspectorBackend.registerEnum(
      'Audits.TwaQualityEnforcementViolationType',
      {KHttpError: 'kHttpError', KUnavailableOffline: 'kUnavailableOffline', KDigitalAssetLinks: 'kDigitalAssetLinks'});
  inspectorBackend.registerEnum('Audits.InspectorIssueCode', {
    SameSiteCookieIssue: 'SameSiteCookieIssue',
    MixedContentIssue: 'MixedContentIssue',
    BlockedByResponseIssue: 'BlockedByResponseIssue',
    HeavyAdIssue: 'HeavyAdIssue',
    ContentSecurityPolicyIssue: 'ContentSecurityPolicyIssue',
    SharedArrayBufferIssue: 'SharedArrayBufferIssue',
    TrustedWebActivityIssue: 'TrustedWebActivityIssue',
    LowTextContrastIssue: 'LowTextContrastIssue',
    CorsIssue: 'CorsIssue'
  });
  inspectorBackend.registerEvent('Audits.issueAdded', ['issue']);
  inspectorBackend.registerEnum('Audits.GetEncodedResponseRequestEncoding', {Webp: 'webp', Jpeg: 'jpeg', Png: 'png'});
  inspectorBackend.registerCommand(
      'Audits.getEncodedResponse',
      [
        {'name': 'requestId', 'type': 'string', 'optional': false},
        {'name': 'encoding', 'type': 'string', 'optional': false},
        {'name': 'quality', 'type': 'number', 'optional': true},
        {'name': 'sizeOnly', 'type': 'boolean', 'optional': true}
      ],
      ['body', 'originalSize', 'encodedSize']);
  inspectorBackend.registerCommand('Audits.disable', [], []);
  inspectorBackend.registerCommand('Audits.enable', [], []);
  inspectorBackend.registerCommand('Audits.checkContrast', [], []);

  // BackgroundService.
  inspectorBackend.registerEnum('BackgroundService.ServiceName', {
    BackgroundFetch: 'backgroundFetch',
    BackgroundSync: 'backgroundSync',
    PushMessaging: 'pushMessaging',
    Notifications: 'notifications',
    PaymentHandler: 'paymentHandler',
    PeriodicBackgroundSync: 'periodicBackgroundSync'
  });
  inspectorBackend.registerEvent('BackgroundService.recordingStateChanged', ['isRecording', 'service']);
  inspectorBackend.registerEvent('BackgroundService.backgroundServiceEventReceived', ['backgroundServiceEvent']);
  inspectorBackend.registerCommand(
      'BackgroundService.startObserving', [{'name': 'service', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'BackgroundService.stopObserving', [{'name': 'service', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'BackgroundService.setRecording',
      [
        {'name': 'shouldRecord', 'type': 'boolean', 'optional': false},
        {'name': 'service', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'BackgroundService.clearEvents', [{'name': 'service', 'type': 'string', 'optional': false}], []);

  // Browser.
  inspectorBackend.registerEnum(
      'Browser.WindowState',
      {Normal: 'normal', Minimized: 'minimized', Maximized: 'maximized', Fullscreen: 'fullscreen'});
  inspectorBackend.registerEnum('Browser.PermissionType', {
    AccessibilityEvents: 'accessibilityEvents',
    AudioCapture: 'audioCapture',
    BackgroundSync: 'backgroundSync',
    BackgroundFetch: 'backgroundFetch',
    ClipboardReadWrite: 'clipboardReadWrite',
    ClipboardSanitizedWrite: 'clipboardSanitizedWrite',
    DisplayCapture: 'displayCapture',
    DurableStorage: 'durableStorage',
    Flash: 'flash',
    Geolocation: 'geolocation',
    Midi: 'midi',
    MidiSysex: 'midiSysex',
    Nfc: 'nfc',
    Notifications: 'notifications',
    PaymentHandler: 'paymentHandler',
    PeriodicBackgroundSync: 'periodicBackgroundSync',
    ProtectedMediaIdentifier: 'protectedMediaIdentifier',
    Sensors: 'sensors',
    VideoCapture: 'videoCapture',
    VideoCapturePanTiltZoom: 'videoCapturePanTiltZoom',
    IdleDetection: 'idleDetection',
    WakeLockScreen: 'wakeLockScreen',
    WakeLockSystem: 'wakeLockSystem'
  });
  inspectorBackend.registerEnum('Browser.PermissionSetting', {Granted: 'granted', Denied: 'denied', Prompt: 'prompt'});
  inspectorBackend.registerEnum(
      'Browser.BrowserCommandId', {OpenTabSearch: 'openTabSearch', CloseTabSearch: 'closeTabSearch'});
  inspectorBackend.registerCommand(
      'Browser.setPermission',
      [
        {'name': 'permission', 'type': 'object', 'optional': false},
        {'name': 'setting', 'type': 'string', 'optional': false},
        {'name': 'origin', 'type': 'string', 'optional': true},
        {'name': 'browserContextId', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Browser.grantPermissions',
      [
        {'name': 'permissions', 'type': 'object', 'optional': false},
        {'name': 'origin', 'type': 'string', 'optional': true},
        {'name': 'browserContextId', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Browser.resetPermissions', [{'name': 'browserContextId', 'type': 'string', 'optional': true}], []);
  inspectorBackend.registerEnum(
      'Browser.SetDownloadBehaviorRequestBehavior',
      {Deny: 'deny', Allow: 'allow', AllowAndName: 'allowAndName', Default: 'default'});
  inspectorBackend.registerCommand(
      'Browser.setDownloadBehavior',
      [
        {'name': 'behavior', 'type': 'string', 'optional': false},
        {'name': 'browserContextId', 'type': 'string', 'optional': true},
        {'name': 'downloadPath', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('Browser.close', [], []);
  inspectorBackend.registerCommand('Browser.crash', [], []);
  inspectorBackend.registerCommand('Browser.crashGpuProcess', [], []);
  inspectorBackend.registerCommand(
      'Browser.getVersion', [], ['protocolVersion', 'product', 'revision', 'userAgent', 'jsVersion']);
  inspectorBackend.registerCommand('Browser.getBrowserCommandLine', [], ['arguments']);
  inspectorBackend.registerCommand(
      'Browser.getHistograms',
      [{'name': 'query', 'type': 'string', 'optional': true}, {'name': 'delta', 'type': 'boolean', 'optional': true}],
      ['histograms']);
  inspectorBackend.registerCommand(
      'Browser.getHistogram',
      [{'name': 'name', 'type': 'string', 'optional': false}, {'name': 'delta', 'type': 'boolean', 'optional': true}],
      ['histogram']);
  inspectorBackend.registerCommand(
      'Browser.getWindowBounds', [{'name': 'windowId', 'type': 'number', 'optional': false}], ['bounds']);
  inspectorBackend.registerCommand(
      'Browser.getWindowForTarget', [{'name': 'targetId', 'type': 'string', 'optional': true}], ['windowId', 'bounds']);
  inspectorBackend.registerCommand(
      'Browser.setWindowBounds',
      [
        {'name': 'windowId', 'type': 'number', 'optional': false},
        {'name': 'bounds', 'type': 'object', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Browser.setDockTile',
      [
        {'name': 'badgeLabel', 'type': 'string', 'optional': true},
        {'name': 'image', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Browser.executeBrowserCommand', [{'name': 'commandId', 'type': 'string', 'optional': false}], []);

  // CSS.
  inspectorBackend.registerEnum(
      'CSS.StyleSheetOrigin',
      {Injected: 'injected', UserAgent: 'user-agent', Inspector: 'inspector', Regular: 'regular'});
  inspectorBackend.registerEnum(
      'CSS.CSSMediaSource',
      {MediaRule: 'mediaRule', ImportRule: 'importRule', LinkedSheet: 'linkedSheet', InlineSheet: 'inlineSheet'});
  inspectorBackend.registerEvent('CSS.fontsUpdated', ['font']);
  inspectorBackend.registerEvent('CSS.mediaQueryResultChanged', []);
  inspectorBackend.registerEvent('CSS.styleSheetAdded', ['header']);
  inspectorBackend.registerEvent('CSS.styleSheetChanged', ['styleSheetId']);
  inspectorBackend.registerEvent('CSS.styleSheetRemoved', ['styleSheetId']);
  inspectorBackend.registerCommand(
      'CSS.addRule',
      [
        {'name': 'styleSheetId', 'type': 'string', 'optional': false},
        {'name': 'ruleText', 'type': 'string', 'optional': false},
        {'name': 'location', 'type': 'object', 'optional': false}
      ],
      ['rule']);
  inspectorBackend.registerCommand(
      'CSS.collectClassNames', [{'name': 'styleSheetId', 'type': 'string', 'optional': false}], ['classNames']);
  inspectorBackend.registerCommand(
      'CSS.createStyleSheet', [{'name': 'frameId', 'type': 'string', 'optional': false}], ['styleSheetId']);
  inspectorBackend.registerCommand('CSS.disable', [], []);
  inspectorBackend.registerCommand('CSS.enable', [], []);
  inspectorBackend.registerCommand(
      'CSS.forcePseudoState',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'forcedPseudoClasses', 'type': 'object', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'CSS.getBackgroundColors', [{'name': 'nodeId', 'type': 'number', 'optional': false}],
      ['backgroundColors', 'computedFontSize', 'computedFontWeight']);
  inspectorBackend.registerCommand(
      'CSS.getComputedStyleForNode', [{'name': 'nodeId', 'type': 'number', 'optional': false}], ['computedStyle']);
  inspectorBackend.registerCommand(
      'CSS.getInlineStylesForNode', [{'name': 'nodeId', 'type': 'number', 'optional': false}],
      ['inlineStyle', 'attributesStyle']);
  inspectorBackend.registerCommand(
      'CSS.getMatchedStylesForNode', [{'name': 'nodeId', 'type': 'number', 'optional': false}],
      ['inlineStyle', 'attributesStyle', 'matchedCSSRules', 'pseudoElements', 'inherited', 'cssKeyframesRules']);
  inspectorBackend.registerCommand('CSS.getMediaQueries', [], ['medias']);
  inspectorBackend.registerCommand(
      'CSS.getPlatformFontsForNode', [{'name': 'nodeId', 'type': 'number', 'optional': false}], ['fonts']);
  inspectorBackend.registerCommand(
      'CSS.getStyleSheetText', [{'name': 'styleSheetId', 'type': 'string', 'optional': false}], ['text']);
  inspectorBackend.registerCommand(
      'CSS.trackComputedStyleUpdates', [{'name': 'propertiesToTrack', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand('CSS.takeComputedStyleUpdates', [], ['nodeIds']);
  inspectorBackend.registerCommand(
      'CSS.setEffectivePropertyValueForNode',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'propertyName', 'type': 'string', 'optional': false},
        {'name': 'value', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'CSS.setKeyframeKey',
      [
        {'name': 'styleSheetId', 'type': 'string', 'optional': false},
        {'name': 'range', 'type': 'object', 'optional': false}, {'name': 'keyText', 'type': 'string', 'optional': false}
      ],
      ['keyText']);
  inspectorBackend.registerCommand(
      'CSS.setMediaText',
      [
        {'name': 'styleSheetId', 'type': 'string', 'optional': false},
        {'name': 'range', 'type': 'object', 'optional': false}, {'name': 'text', 'type': 'string', 'optional': false}
      ],
      ['media']);
  inspectorBackend.registerCommand(
      'CSS.setRuleSelector',
      [
        {'name': 'styleSheetId', 'type': 'string', 'optional': false},
        {'name': 'range', 'type': 'object', 'optional': false},
        {'name': 'selector', 'type': 'string', 'optional': false}
      ],
      ['selectorList']);
  inspectorBackend.registerCommand(
      'CSS.setStyleSheetText',
      [
        {'name': 'styleSheetId', 'type': 'string', 'optional': false},
        {'name': 'text', 'type': 'string', 'optional': false}
      ],
      ['sourceMapURL']);
  inspectorBackend.registerCommand(
      'CSS.setStyleTexts', [{'name': 'edits', 'type': 'object', 'optional': false}], ['styles']);
  inspectorBackend.registerCommand('CSS.startRuleUsageTracking', [], []);
  inspectorBackend.registerCommand('CSS.stopRuleUsageTracking', [], ['ruleUsage']);
  inspectorBackend.registerCommand('CSS.takeCoverageDelta', [], ['coverage', 'timestamp']);
  inspectorBackend.registerCommand(
      'CSS.setLocalFontsEnabled', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);

  // CacheStorage.
  inspectorBackend.registerEnum('CacheStorage.CachedResponseType', {
    Basic: 'basic',
    Cors: 'cors',
    Default: 'default',
    Error: 'error',
    OpaqueResponse: 'opaqueResponse',
    OpaqueRedirect: 'opaqueRedirect'
  });
  inspectorBackend.registerCommand(
      'CacheStorage.deleteCache', [{'name': 'cacheId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'CacheStorage.deleteEntry',
      [
        {'name': 'cacheId', 'type': 'string', 'optional': false},
        {'name': 'request', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'CacheStorage.requestCacheNames', [{'name': 'securityOrigin', 'type': 'string', 'optional': false}], ['caches']);
  inspectorBackend.registerCommand(
      'CacheStorage.requestCachedResponse',
      [
        {'name': 'cacheId', 'type': 'string', 'optional': false},
        {'name': 'requestURL', 'type': 'string', 'optional': false},
        {'name': 'requestHeaders', 'type': 'object', 'optional': false}
      ],
      ['response']);
  inspectorBackend.registerCommand(
      'CacheStorage.requestEntries',
      [
        {'name': 'cacheId', 'type': 'string', 'optional': false},
        {'name': 'skipCount', 'type': 'number', 'optional': true},
        {'name': 'pageSize', 'type': 'number', 'optional': true},
        {'name': 'pathFilter', 'type': 'string', 'optional': true}
      ],
      ['cacheDataEntries', 'returnCount']);

  // Cast.
  inspectorBackend.registerEvent('Cast.sinksUpdated', ['sinks']);
  inspectorBackend.registerEvent('Cast.issueUpdated', ['issueMessage']);
  inspectorBackend.registerCommand(
      'Cast.enable', [{'name': 'presentationUrl', 'type': 'string', 'optional': true}], []);
  inspectorBackend.registerCommand('Cast.disable', [], []);
  inspectorBackend.registerCommand(
      'Cast.setSinkToUse', [{'name': 'sinkName', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Cast.startTabMirroring', [{'name': 'sinkName', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand('Cast.stopCasting', [{'name': 'sinkName', 'type': 'string', 'optional': false}], []);

  // DOM.
  inspectorBackend.registerEnum('DOM.PseudoType', {
    FirstLine: 'first-line',
    FirstLetter: 'first-letter',
    Before: 'before',
    After: 'after',
    Marker: 'marker',
    Backdrop: 'backdrop',
    Selection: 'selection',
    TargetText: 'target-text',
    SpellingError: 'spelling-error',
    GrammarError: 'grammar-error',
    FirstLineInherited: 'first-line-inherited',
    Scrollbar: 'scrollbar',
    ScrollbarThumb: 'scrollbar-thumb',
    ScrollbarButton: 'scrollbar-button',
    ScrollbarTrack: 'scrollbar-track',
    ScrollbarTrackPiece: 'scrollbar-track-piece',
    ScrollbarCorner: 'scrollbar-corner',
    Resizer: 'resizer',
    InputListButton: 'input-list-button'
  });
  inspectorBackend.registerEnum('DOM.ShadowRootType', {UserAgent: 'user-agent', Open: 'open', Closed: 'closed'});
  inspectorBackend.registerEvent('DOM.attributeModified', ['nodeId', 'name', 'value']);
  inspectorBackend.registerEvent('DOM.attributeRemoved', ['nodeId', 'name']);
  inspectorBackend.registerEvent('DOM.characterDataModified', ['nodeId', 'characterData']);
  inspectorBackend.registerEvent('DOM.childNodeCountUpdated', ['nodeId', 'childNodeCount']);
  inspectorBackend.registerEvent('DOM.childNodeInserted', ['parentNodeId', 'previousNodeId', 'node']);
  inspectorBackend.registerEvent('DOM.childNodeRemoved', ['parentNodeId', 'nodeId']);
  inspectorBackend.registerEvent('DOM.distributedNodesUpdated', ['insertionPointId', 'distributedNodes']);
  inspectorBackend.registerEvent('DOM.documentUpdated', []);
  inspectorBackend.registerEvent('DOM.inlineStyleInvalidated', ['nodeIds']);
  inspectorBackend.registerEvent('DOM.pseudoElementAdded', ['parentId', 'pseudoElement']);
  inspectorBackend.registerEvent('DOM.pseudoElementRemoved', ['parentId', 'pseudoElementId']);
  inspectorBackend.registerEvent('DOM.setChildNodes', ['parentId', 'nodes']);
  inspectorBackend.registerEvent('DOM.shadowRootPopped', ['hostId', 'rootId']);
  inspectorBackend.registerEvent('DOM.shadowRootPushed', ['hostId', 'root']);
  inspectorBackend.registerCommand(
      'DOM.collectClassNamesFromSubtree', [{'name': 'nodeId', 'type': 'number', 'optional': false}], ['classNames']);
  inspectorBackend.registerCommand(
      'DOM.copyTo',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'targetNodeId', 'type': 'number', 'optional': false},
        {'name': 'insertBeforeNodeId', 'type': 'number', 'optional': true}
      ],
      ['nodeId']);
  inspectorBackend.registerCommand(
      'DOM.describeNode',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true}, {'name': 'depth', 'type': 'number', 'optional': true},
        {'name': 'pierce', 'type': 'boolean', 'optional': true}
      ],
      ['node']);
  inspectorBackend.registerCommand(
      'DOM.scrollIntoViewIfNeeded',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true}, {'name': 'rect', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('DOM.disable', [], []);
  inspectorBackend.registerCommand(
      'DOM.discardSearchResults', [{'name': 'searchId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand('DOM.enable', [], []);
  inspectorBackend.registerCommand(
      'DOM.focus',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'DOM.getAttributes', [{'name': 'nodeId', 'type': 'number', 'optional': false}], ['attributes']);
  inspectorBackend.registerCommand(
      'DOM.getBoxModel',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true}
      ],
      ['model']);
  inspectorBackend.registerCommand(
      'DOM.getContentQuads',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true}
      ],
      ['quads']);
  inspectorBackend.registerCommand(
      'DOM.getDocument',
      [{'name': 'depth', 'type': 'number', 'optional': true}, {'name': 'pierce', 'type': 'boolean', 'optional': true}],
      ['root']);
  inspectorBackend.registerCommand(
      'DOM.getFlattenedDocument',
      [{'name': 'depth', 'type': 'number', 'optional': true}, {'name': 'pierce', 'type': 'boolean', 'optional': true}],
      ['nodes']);
  inspectorBackend.registerCommand(
      'DOM.getNodesForSubtreeByStyle',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'computedStyles', 'type': 'object', 'optional': false},
        {'name': 'pierce', 'type': 'boolean', 'optional': true}
      ],
      ['nodeIds']);
  inspectorBackend.registerCommand(
      'DOM.getNodeForLocation',
      [
        {'name': 'x', 'type': 'number', 'optional': false}, {'name': 'y', 'type': 'number', 'optional': false},
        {'name': 'includeUserAgentShadowDOM', 'type': 'boolean', 'optional': true},
        {'name': 'ignorePointerEventsNone', 'type': 'boolean', 'optional': true}
      ],
      ['backendNodeId', 'frameId', 'nodeId']);
  inspectorBackend.registerCommand(
      'DOM.getOuterHTML',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true}
      ],
      ['outerHTML']);
  inspectorBackend.registerCommand(
      'DOM.getRelayoutBoundary', [{'name': 'nodeId', 'type': 'number', 'optional': false}], ['nodeId']);
  inspectorBackend.registerCommand(
      'DOM.getSearchResults',
      [
        {'name': 'searchId', 'type': 'string', 'optional': false},
        {'name': 'fromIndex', 'type': 'number', 'optional': false},
        {'name': 'toIndex', 'type': 'number', 'optional': false}
      ],
      ['nodeIds']);
  inspectorBackend.registerCommand('DOM.hideHighlight', [], []);
  inspectorBackend.registerCommand('DOM.highlightNode', [], []);
  inspectorBackend.registerCommand('DOM.highlightRect', [], []);
  inspectorBackend.registerCommand('DOM.markUndoableState', [], []);
  inspectorBackend.registerCommand(
      'DOM.moveTo',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'targetNodeId', 'type': 'number', 'optional': false},
        {'name': 'insertBeforeNodeId', 'type': 'number', 'optional': true}
      ],
      ['nodeId']);
  inspectorBackend.registerCommand(
      'DOM.performSearch',
      [
        {'name': 'query', 'type': 'string', 'optional': false},
        {'name': 'includeUserAgentShadowDOM', 'type': 'boolean', 'optional': true}
      ],
      ['searchId', 'resultCount']);
  inspectorBackend.registerCommand(
      'DOM.pushNodeByPathToFrontend', [{'name': 'path', 'type': 'string', 'optional': false}], ['nodeId']);
  inspectorBackend.registerCommand(
      'DOM.pushNodesByBackendIdsToFrontend', [{'name': 'backendNodeIds', 'type': 'object', 'optional': false}],
      ['nodeIds']);
  inspectorBackend.registerCommand(
      'DOM.querySelector',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'selector', 'type': 'string', 'optional': false}
      ],
      ['nodeId']);
  inspectorBackend.registerCommand(
      'DOM.querySelectorAll',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'selector', 'type': 'string', 'optional': false}
      ],
      ['nodeIds']);
  inspectorBackend.registerCommand('DOM.redo', [], []);
  inspectorBackend.registerCommand(
      'DOM.removeAttribute',
      [{'name': 'nodeId', 'type': 'number', 'optional': false}, {'name': 'name', 'type': 'string', 'optional': false}],
      []);
  inspectorBackend.registerCommand('DOM.removeNode', [{'name': 'nodeId', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'DOM.requestChildNodes',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false}, {'name': 'depth', 'type': 'number', 'optional': true},
        {'name': 'pierce', 'type': 'boolean', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'DOM.requestNode', [{'name': 'objectId', 'type': 'string', 'optional': false}], ['nodeId']);
  inspectorBackend.registerCommand(
      'DOM.resolveNode',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectGroup', 'type': 'string', 'optional': true},
        {'name': 'executionContextId', 'type': 'number', 'optional': true}
      ],
      ['object']);
  inspectorBackend.registerCommand(
      'DOM.setAttributeValue',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false}, {'name': 'name', 'type': 'string', 'optional': false},
        {'name': 'value', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'DOM.setAttributesAsText',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false}, {'name': 'text', 'type': 'string', 'optional': false},
        {'name': 'name', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'DOM.setFileInputFiles',
      [
        {'name': 'files', 'type': 'object', 'optional': false}, {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'DOM.setNodeStackTracesEnabled', [{'name': 'enable', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'DOM.getNodeStackTraces', [{'name': 'nodeId', 'type': 'number', 'optional': false}], ['creation']);
  inspectorBackend.registerCommand(
      'DOM.getFileInfo', [{'name': 'objectId', 'type': 'string', 'optional': false}], ['path']);
  inspectorBackend.registerCommand(
      'DOM.setInspectedNode', [{'name': 'nodeId', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'DOM.setNodeName',
      [{'name': 'nodeId', 'type': 'number', 'optional': false}, {'name': 'name', 'type': 'string', 'optional': false}],
      ['nodeId']);
  inspectorBackend.registerCommand(
      'DOM.setNodeValue',
      [{'name': 'nodeId', 'type': 'number', 'optional': false}, {'name': 'value', 'type': 'string', 'optional': false}],
      []);
  inspectorBackend.registerCommand(
      'DOM.setOuterHTML',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'outerHTML', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand('DOM.undo', [], []);
  inspectorBackend.registerCommand(
      'DOM.getFrameOwner', [{'name': 'frameId', 'type': 'string', 'optional': false}], ['backendNodeId', 'nodeId']);

  // DOMDebugger.
  inspectorBackend.registerEnum(
      'DOMDebugger.DOMBreakpointType',
      {SubtreeModified: 'subtree-modified', AttributeModified: 'attribute-modified', NodeRemoved: 'node-removed'});
  inspectorBackend.registerEnum('DOMDebugger.CSPViolationType', {
    TrustedtypeSinkViolation: 'trustedtype-sink-violation',
    TrustedtypePolicyViolation: 'trustedtype-policy-violation'
  });
  inspectorBackend.registerCommand(
      'DOMDebugger.getEventListeners',
      [
        {'name': 'objectId', 'type': 'string', 'optional': false},
        {'name': 'depth', 'type': 'number', 'optional': true}, {'name': 'pierce', 'type': 'boolean', 'optional': true}
      ],
      ['listeners']);
  inspectorBackend.registerCommand(
      'DOMDebugger.removeDOMBreakpoint',
      [{'name': 'nodeId', 'type': 'number', 'optional': false}, {'name': 'type', 'type': 'string', 'optional': false}],
      []);
  inspectorBackend.registerCommand(
      'DOMDebugger.removeEventListenerBreakpoint',
      [
        {'name': 'eventName', 'type': 'string', 'optional': false},
        {'name': 'targetName', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'DOMDebugger.removeInstrumentationBreakpoint', [{'name': 'eventName', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'DOMDebugger.removeXHRBreakpoint', [{'name': 'url', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'DOMDebugger.setBreakOnCSPViolation', [{'name': 'violationTypes', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'DOMDebugger.setDOMBreakpoint',
      [{'name': 'nodeId', 'type': 'number', 'optional': false}, {'name': 'type', 'type': 'string', 'optional': false}],
      []);
  inspectorBackend.registerCommand(
      'DOMDebugger.setEventListenerBreakpoint',
      [
        {'name': 'eventName', 'type': 'string', 'optional': false},
        {'name': 'targetName', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'DOMDebugger.setInstrumentationBreakpoint', [{'name': 'eventName', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'DOMDebugger.setXHRBreakpoint', [{'name': 'url', 'type': 'string', 'optional': false}], []);

  // DOMSnapshot.
  inspectorBackend.registerCommand('DOMSnapshot.disable', [], []);
  inspectorBackend.registerCommand('DOMSnapshot.enable', [], []);
  inspectorBackend.registerCommand(
      'DOMSnapshot.getSnapshot',
      [
        {'name': 'computedStyleWhitelist', 'type': 'object', 'optional': false},
        {'name': 'includeEventListeners', 'type': 'boolean', 'optional': true},
        {'name': 'includePaintOrder', 'type': 'boolean', 'optional': true},
        {'name': 'includeUserAgentShadowTree', 'type': 'boolean', 'optional': true}
      ],
      ['domNodes', 'layoutTreeNodes', 'computedStyles']);
  inspectorBackend.registerCommand(
      'DOMSnapshot.captureSnapshot',
      [
        {'name': 'computedStyles', 'type': 'object', 'optional': false},
        {'name': 'includePaintOrder', 'type': 'boolean', 'optional': true},
        {'name': 'includeDOMRects', 'type': 'boolean', 'optional': true}
      ],
      ['documents', 'strings']);

  // DOMStorage.
  inspectorBackend.registerEvent('DOMStorage.domStorageItemAdded', ['storageId', 'key', 'newValue']);
  inspectorBackend.registerEvent('DOMStorage.domStorageItemRemoved', ['storageId', 'key']);
  inspectorBackend.registerEvent('DOMStorage.domStorageItemUpdated', ['storageId', 'key', 'oldValue', 'newValue']);
  inspectorBackend.registerEvent('DOMStorage.domStorageItemsCleared', ['storageId']);
  inspectorBackend.registerCommand(
      'DOMStorage.clear', [{'name': 'storageId', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand('DOMStorage.disable', [], []);
  inspectorBackend.registerCommand('DOMStorage.enable', [], []);
  inspectorBackend.registerCommand(
      'DOMStorage.getDOMStorageItems', [{'name': 'storageId', 'type': 'object', 'optional': false}], ['entries']);
  inspectorBackend.registerCommand(
      'DOMStorage.removeDOMStorageItem',
      [
        {'name': 'storageId', 'type': 'object', 'optional': false}, {'name': 'key', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'DOMStorage.setDOMStorageItem',
      [
        {'name': 'storageId', 'type': 'object', 'optional': false},
        {'name': 'key', 'type': 'string', 'optional': false}, {'name': 'value', 'type': 'string', 'optional': false}
      ],
      []);

  // Database.
  inspectorBackend.registerEvent('Database.addDatabase', ['database']);
  inspectorBackend.registerCommand('Database.disable', [], []);
  inspectorBackend.registerCommand('Database.enable', [], []);
  inspectorBackend.registerCommand(
      'Database.executeSQL',
      [
        {'name': 'databaseId', 'type': 'string', 'optional': false},
        {'name': 'query', 'type': 'string', 'optional': false}
      ],
      ['columnNames', 'values', 'sqlError']);
  inspectorBackend.registerCommand(
      'Database.getDatabaseTableNames', [{'name': 'databaseId', 'type': 'string', 'optional': false}], ['tableNames']);

  // DeviceOrientation.
  inspectorBackend.registerCommand('DeviceOrientation.clearDeviceOrientationOverride', [], []);
  inspectorBackend.registerCommand(
      'DeviceOrientation.setDeviceOrientationOverride',
      [
        {'name': 'alpha', 'type': 'number', 'optional': false}, {'name': 'beta', 'type': 'number', 'optional': false},
        {'name': 'gamma', 'type': 'number', 'optional': false}
      ],
      []);

  // Emulation.
  inspectorBackend.registerEnum('Emulation.ScreenOrientationType', {
    PortraitPrimary: 'portraitPrimary',
    PortraitSecondary: 'portraitSecondary',
    LandscapePrimary: 'landscapePrimary',
    LandscapeSecondary: 'landscapeSecondary'
  });
  inspectorBackend.registerEnum(
      'Emulation.DisplayFeatureOrientation', {Vertical: 'vertical', Horizontal: 'horizontal'});
  inspectorBackend.registerEnum(
      'Emulation.VirtualTimePolicy',
      {Advance: 'advance', Pause: 'pause', PauseIfNetworkFetchesPending: 'pauseIfNetworkFetchesPending'});
  inspectorBackend.registerEnum('Emulation.DisabledImageType', {Avif: 'avif', Webp: 'webp'});
  inspectorBackend.registerEvent('Emulation.virtualTimeBudgetExpired', []);
  inspectorBackend.registerCommand('Emulation.canEmulate', [], ['result']);
  inspectorBackend.registerCommand('Emulation.clearDeviceMetricsOverride', [], []);
  inspectorBackend.registerCommand('Emulation.clearGeolocationOverride', [], []);
  inspectorBackend.registerCommand('Emulation.resetPageScaleFactor', [], []);
  inspectorBackend.registerCommand(
      'Emulation.setFocusEmulationEnabled', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setCPUThrottlingRate', [{'name': 'rate', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setDefaultBackgroundColorOverride', [{'name': 'color', 'type': 'object', 'optional': true}], []);
  inspectorBackend.registerCommand(
      'Emulation.setDeviceMetricsOverride',
      [
        {'name': 'width', 'type': 'number', 'optional': false}, {'name': 'height', 'type': 'number', 'optional': false},
        {'name': 'deviceScaleFactor', 'type': 'number', 'optional': false},
        {'name': 'mobile', 'type': 'boolean', 'optional': false}, {'name': 'scale', 'type': 'number', 'optional': true},
        {'name': 'screenWidth', 'type': 'number', 'optional': true},
        {'name': 'screenHeight', 'type': 'number', 'optional': true},
        {'name': 'positionX', 'type': 'number', 'optional': true},
        {'name': 'positionY', 'type': 'number', 'optional': true},
        {'name': 'dontSetVisibleSize', 'type': 'boolean', 'optional': true},
        {'name': 'screenOrientation', 'type': 'object', 'optional': true},
        {'name': 'viewport', 'type': 'object', 'optional': true},
        {'name': 'displayFeature', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Emulation.setScrollbarsHidden', [{'name': 'hidden', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setDocumentCookieDisabled', [{'name': 'disabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerEnum(
      'Emulation.SetEmitTouchEventsForMouseRequestConfiguration', {Mobile: 'mobile', Desktop: 'desktop'});
  inspectorBackend.registerCommand(
      'Emulation.setEmitTouchEventsForMouse',
      [
        {'name': 'enabled', 'type': 'boolean', 'optional': false},
        {'name': 'configuration', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Emulation.setEmulatedMedia',
      [{'name': 'media', 'type': 'string', 'optional': true}, {'name': 'features', 'type': 'object', 'optional': true}],
      []);
  inspectorBackend.registerEnum('Emulation.SetEmulatedVisionDeficiencyRequestType', {
    None: 'none',
    Achromatopsia: 'achromatopsia',
    BlurredVision: 'blurredVision',
    Deuteranopia: 'deuteranopia',
    Protanopia: 'protanopia',
    Tritanopia: 'tritanopia'
  });
  inspectorBackend.registerCommand(
      'Emulation.setEmulatedVisionDeficiency', [{'name': 'type', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setGeolocationOverride',
      [
        {'name': 'latitude', 'type': 'number', 'optional': true},
        {'name': 'longitude', 'type': 'number', 'optional': true},
        {'name': 'accuracy', 'type': 'number', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Emulation.setIdleOverride',
      [
        {'name': 'isUserActive', 'type': 'boolean', 'optional': false},
        {'name': 'isScreenUnlocked', 'type': 'boolean', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand('Emulation.clearIdleOverride', [], []);
  inspectorBackend.registerCommand(
      'Emulation.setNavigatorOverrides', [{'name': 'platform', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setPageScaleFactor', [{'name': 'pageScaleFactor', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setScriptExecutionDisabled', [{'name': 'value', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setTouchEmulationEnabled',
      [
        {'name': 'enabled', 'type': 'boolean', 'optional': false},
        {'name': 'maxTouchPoints', 'type': 'number', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Emulation.setVirtualTimePolicy',
      [
        {'name': 'policy', 'type': 'string', 'optional': false}, {'name': 'budget', 'type': 'number', 'optional': true},
        {'name': 'maxVirtualTimeTaskStarvationCount', 'type': 'number', 'optional': true},
        {'name': 'waitForNavigation', 'type': 'boolean', 'optional': true},
        {'name': 'initialVirtualTime', 'type': 'number', 'optional': true}
      ],
      ['virtualTimeTicksBase']);
  inspectorBackend.registerCommand(
      'Emulation.setLocaleOverride', [{'name': 'locale', 'type': 'string', 'optional': true}], []);
  inspectorBackend.registerCommand(
      'Emulation.setTimezoneOverride', [{'name': 'timezoneId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setVisibleSize',
      [{'name': 'width', 'type': 'number', 'optional': false}, {'name': 'height', 'type': 'number', 'optional': false}],
      []);
  inspectorBackend.registerCommand(
      'Emulation.setDisabledImageTypes', [{'name': 'imageTypes', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Emulation.setUserAgentOverride',
      [
        {'name': 'userAgent', 'type': 'string', 'optional': false},
        {'name': 'acceptLanguage', 'type': 'string', 'optional': true},
        {'name': 'platform', 'type': 'string', 'optional': true},
        {'name': 'userAgentMetadata', 'type': 'object', 'optional': true}
      ],
      []);

  // HeadlessExperimental.
  inspectorBackend.registerEnum('HeadlessExperimental.ScreenshotParamsFormat', {Jpeg: 'jpeg', Png: 'png'});
  inspectorBackend.registerEvent('HeadlessExperimental.needsBeginFramesChanged', ['needsBeginFrames']);
  inspectorBackend.registerCommand(
      'HeadlessExperimental.beginFrame',
      [
        {'name': 'frameTimeTicks', 'type': 'number', 'optional': true},
        {'name': 'interval', 'type': 'number', 'optional': true},
        {'name': 'noDisplayUpdates', 'type': 'boolean', 'optional': true},
        {'name': 'screenshot', 'type': 'object', 'optional': true}
      ],
      ['hasDamage', 'screenshotData']);
  inspectorBackend.registerCommand('HeadlessExperimental.disable', [], []);
  inspectorBackend.registerCommand('HeadlessExperimental.enable', [], []);

  // IO.
  inspectorBackend.registerCommand('IO.close', [{'name': 'handle', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'IO.read',
      [
        {'name': 'handle', 'type': 'string', 'optional': false}, {'name': 'offset', 'type': 'number', 'optional': true},
        {'name': 'size', 'type': 'number', 'optional': true}
      ],
      ['base64Encoded', 'data', 'eof']);
  inspectorBackend.registerCommand(
      'IO.resolveBlob', [{'name': 'objectId', 'type': 'string', 'optional': false}], ['uuid']);

  // IndexedDB.
  inspectorBackend.registerEnum(
      'IndexedDB.KeyType', {Number: 'number', String: 'string', Date: 'date', Array: 'array'});
  inspectorBackend.registerEnum('IndexedDB.KeyPathType', {Null: 'null', String: 'string', Array: 'array'});
  inspectorBackend.registerCommand(
      'IndexedDB.clearObjectStore',
      [
        {'name': 'securityOrigin', 'type': 'string', 'optional': false},
        {'name': 'databaseName', 'type': 'string', 'optional': false},
        {'name': 'objectStoreName', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'IndexedDB.deleteDatabase',
      [
        {'name': 'securityOrigin', 'type': 'string', 'optional': false},
        {'name': 'databaseName', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'IndexedDB.deleteObjectStoreEntries',
      [
        {'name': 'securityOrigin', 'type': 'string', 'optional': false},
        {'name': 'databaseName', 'type': 'string', 'optional': false},
        {'name': 'objectStoreName', 'type': 'string', 'optional': false},
        {'name': 'keyRange', 'type': 'object', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand('IndexedDB.disable', [], []);
  inspectorBackend.registerCommand('IndexedDB.enable', [], []);
  inspectorBackend.registerCommand(
      'IndexedDB.requestData',
      [
        {'name': 'securityOrigin', 'type': 'string', 'optional': false},
        {'name': 'databaseName', 'type': 'string', 'optional': false},
        {'name': 'objectStoreName', 'type': 'string', 'optional': false},
        {'name': 'indexName', 'type': 'string', 'optional': false},
        {'name': 'skipCount', 'type': 'number', 'optional': false},
        {'name': 'pageSize', 'type': 'number', 'optional': false},
        {'name': 'keyRange', 'type': 'object', 'optional': true}
      ],
      ['objectStoreDataEntries', 'hasMore']);
  inspectorBackend.registerCommand(
      'IndexedDB.getMetadata',
      [
        {'name': 'securityOrigin', 'type': 'string', 'optional': false},
        {'name': 'databaseName', 'type': 'string', 'optional': false},
        {'name': 'objectStoreName', 'type': 'string', 'optional': false}
      ],
      ['entriesCount', 'keyGeneratorValue']);
  inspectorBackend.registerCommand(
      'IndexedDB.requestDatabase',
      [
        {'name': 'securityOrigin', 'type': 'string', 'optional': false},
        {'name': 'databaseName', 'type': 'string', 'optional': false}
      ],
      ['databaseWithObjectStores']);
  inspectorBackend.registerCommand(
      'IndexedDB.requestDatabaseNames', [{'name': 'securityOrigin', 'type': 'string', 'optional': false}],
      ['databaseNames']);

  // Input.
  inspectorBackend.registerEnum('Input.GestureSourceType', {Default: 'default', Touch: 'touch', Mouse: 'mouse'});
  inspectorBackend.registerEnum(
      'Input.MouseButton',
      {None: 'none', Left: 'left', Middle: 'middle', Right: 'right', Back: 'back', Forward: 'forward'});
  inspectorBackend.registerEnum(
      'Input.DispatchKeyEventRequestType',
      {KeyDown: 'keyDown', KeyUp: 'keyUp', RawKeyDown: 'rawKeyDown', Char: 'char'});
  inspectorBackend.registerCommand(
      'Input.dispatchKeyEvent',
      [
        {'name': 'type', 'type': 'string', 'optional': false},
        {'name': 'modifiers', 'type': 'number', 'optional': true},
        {'name': 'timestamp', 'type': 'number', 'optional': true}, {'name': 'text', 'type': 'string', 'optional': true},
        {'name': 'unmodifiedText', 'type': 'string', 'optional': true},
        {'name': 'keyIdentifier', 'type': 'string', 'optional': true},
        {'name': 'code', 'type': 'string', 'optional': true}, {'name': 'key', 'type': 'string', 'optional': true},
        {'name': 'windowsVirtualKeyCode', 'type': 'number', 'optional': true},
        {'name': 'nativeVirtualKeyCode', 'type': 'number', 'optional': true},
        {'name': 'autoRepeat', 'type': 'boolean', 'optional': true},
        {'name': 'isKeypad', 'type': 'boolean', 'optional': true},
        {'name': 'isSystemKey', 'type': 'boolean', 'optional': true},
        {'name': 'location', 'type': 'number', 'optional': true},
        {'name': 'commands', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('Input.insertText', [{'name': 'text', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerEnum('Input.DispatchMouseEventRequestType', {
    MousePressed: 'mousePressed',
    MouseReleased: 'mouseReleased',
    MouseMoved: 'mouseMoved',
    MouseWheel: 'mouseWheel'
  });
  inspectorBackend.registerEnum('Input.DispatchMouseEventRequestPointerType', {Mouse: 'mouse', Pen: 'pen'});
  inspectorBackend.registerCommand(
      'Input.dispatchMouseEvent',
      [
        {'name': 'type', 'type': 'string', 'optional': false}, {'name': 'x', 'type': 'number', 'optional': false},
        {'name': 'y', 'type': 'number', 'optional': false}, {'name': 'modifiers', 'type': 'number', 'optional': true},
        {'name': 'timestamp', 'type': 'number', 'optional': true},
        {'name': 'button', 'type': 'string', 'optional': true}, {'name': 'buttons', 'type': 'number', 'optional': true},
        {'name': 'clickCount', 'type': 'number', 'optional': true},
        {'name': 'force', 'type': 'number', 'optional': true},
        {'name': 'tangentialPressure', 'type': 'number', 'optional': true},
        {'name': 'tiltX', 'type': 'number', 'optional': true}, {'name': 'tiltY', 'type': 'number', 'optional': true},
        {'name': 'twist', 'type': 'number', 'optional': true}, {'name': 'deltaX', 'type': 'number', 'optional': true},
        {'name': 'deltaY', 'type': 'number', 'optional': true},
        {'name': 'pointerType', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerEnum(
      'Input.DispatchTouchEventRequestType',
      {TouchStart: 'touchStart', TouchEnd: 'touchEnd', TouchMove: 'touchMove', TouchCancel: 'touchCancel'});
  inspectorBackend.registerCommand(
      'Input.dispatchTouchEvent',
      [
        {'name': 'type', 'type': 'string', 'optional': false},
        {'name': 'touchPoints', 'type': 'object', 'optional': false},
        {'name': 'modifiers', 'type': 'number', 'optional': true},
        {'name': 'timestamp', 'type': 'number', 'optional': true}
      ],
      []);
  inspectorBackend.registerEnum('Input.EmulateTouchFromMouseEventRequestType', {
    MousePressed: 'mousePressed',
    MouseReleased: 'mouseReleased',
    MouseMoved: 'mouseMoved',
    MouseWheel: 'mouseWheel'
  });
  inspectorBackend.registerCommand(
      'Input.emulateTouchFromMouseEvent',
      [
        {'name': 'type', 'type': 'string', 'optional': false}, {'name': 'x', 'type': 'number', 'optional': false},
        {'name': 'y', 'type': 'number', 'optional': false}, {'name': 'button', 'type': 'string', 'optional': false},
        {'name': 'timestamp', 'type': 'number', 'optional': true},
        {'name': 'deltaX', 'type': 'number', 'optional': true}, {'name': 'deltaY', 'type': 'number', 'optional': true},
        {'name': 'modifiers', 'type': 'number', 'optional': true},
        {'name': 'clickCount', 'type': 'number', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Input.setIgnoreInputEvents', [{'name': 'ignore', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Input.synthesizePinchGesture',
      [
        {'name': 'x', 'type': 'number', 'optional': false}, {'name': 'y', 'type': 'number', 'optional': false},
        {'name': 'scaleFactor', 'type': 'number', 'optional': false},
        {'name': 'relativeSpeed', 'type': 'number', 'optional': true},
        {'name': 'gestureSourceType', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Input.synthesizeScrollGesture',
      [
        {'name': 'x', 'type': 'number', 'optional': false}, {'name': 'y', 'type': 'number', 'optional': false},
        {'name': 'xDistance', 'type': 'number', 'optional': true},
        {'name': 'yDistance', 'type': 'number', 'optional': true},
        {'name': 'xOverscroll', 'type': 'number', 'optional': true},
        {'name': 'yOverscroll', 'type': 'number', 'optional': true},
        {'name': 'preventFling', 'type': 'boolean', 'optional': true},
        {'name': 'speed', 'type': 'number', 'optional': true},
        {'name': 'gestureSourceType', 'type': 'string', 'optional': true},
        {'name': 'repeatCount', 'type': 'number', 'optional': true},
        {'name': 'repeatDelayMs', 'type': 'number', 'optional': true},
        {'name': 'interactionMarkerName', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Input.synthesizeTapGesture',
      [
        {'name': 'x', 'type': 'number', 'optional': false}, {'name': 'y', 'type': 'number', 'optional': false},
        {'name': 'duration', 'type': 'number', 'optional': true},
        {'name': 'tapCount', 'type': 'number', 'optional': true},
        {'name': 'gestureSourceType', 'type': 'string', 'optional': true}
      ],
      []);

  // Inspector.
  inspectorBackend.registerEvent('Inspector.detached', ['reason']);
  inspectorBackend.registerEvent('Inspector.targetCrashed', []);
  inspectorBackend.registerEvent('Inspector.targetReloadedAfterCrash', []);
  inspectorBackend.registerCommand('Inspector.disable', [], []);
  inspectorBackend.registerCommand('Inspector.enable', [], []);

  // LayerTree.
  inspectorBackend.registerEnum('LayerTree.ScrollRectType', {
    RepaintsOnScroll: 'RepaintsOnScroll',
    TouchEventHandler: 'TouchEventHandler',
    WheelEventHandler: 'WheelEventHandler'
  });
  inspectorBackend.registerEvent('LayerTree.layerPainted', ['layerId', 'clip']);
  inspectorBackend.registerEvent('LayerTree.layerTreeDidChange', ['layers']);
  inspectorBackend.registerCommand(
      'LayerTree.compositingReasons', [{'name': 'layerId', 'type': 'string', 'optional': false}],
      ['compositingReasons', 'compositingReasonIds']);
  inspectorBackend.registerCommand('LayerTree.disable', [], []);
  inspectorBackend.registerCommand('LayerTree.enable', [], []);
  inspectorBackend.registerCommand(
      'LayerTree.loadSnapshot', [{'name': 'tiles', 'type': 'object', 'optional': false}], ['snapshotId']);
  inspectorBackend.registerCommand(
      'LayerTree.makeSnapshot', [{'name': 'layerId', 'type': 'string', 'optional': false}], ['snapshotId']);
  inspectorBackend.registerCommand(
      'LayerTree.profileSnapshot',
      [
        {'name': 'snapshotId', 'type': 'string', 'optional': false},
        {'name': 'minRepeatCount', 'type': 'number', 'optional': true},
        {'name': 'minDuration', 'type': 'number', 'optional': true},
        {'name': 'clipRect', 'type': 'object', 'optional': true}
      ],
      ['timings']);
  inspectorBackend.registerCommand(
      'LayerTree.releaseSnapshot', [{'name': 'snapshotId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'LayerTree.replaySnapshot',
      [
        {'name': 'snapshotId', 'type': 'string', 'optional': false},
        {'name': 'fromStep', 'type': 'number', 'optional': true},
        {'name': 'toStep', 'type': 'number', 'optional': true}, {'name': 'scale', 'type': 'number', 'optional': true}
      ],
      ['dataURL']);
  inspectorBackend.registerCommand(
      'LayerTree.snapshotCommandLog', [{'name': 'snapshotId', 'type': 'string', 'optional': false}], ['commandLog']);

  // Log.
  inspectorBackend.registerEnum('Log.LogEntrySource', {
    XML: 'xml',
    Javascript: 'javascript',
    Network: 'network',
    Storage: 'storage',
    Appcache: 'appcache',
    Rendering: 'rendering',
    Security: 'security',
    Deprecation: 'deprecation',
    Worker: 'worker',
    Violation: 'violation',
    Intervention: 'intervention',
    Recommendation: 'recommendation',
    Other: 'other'
  });
  inspectorBackend.registerEnum(
      'Log.LogEntryLevel', {Verbose: 'verbose', Info: 'info', Warning: 'warning', Error: 'error'});
  inspectorBackend.registerEnum('Log.ViolationSettingName', {
    LongTask: 'longTask',
    LongLayout: 'longLayout',
    BlockedEvent: 'blockedEvent',
    BlockedParser: 'blockedParser',
    DiscouragedAPIUse: 'discouragedAPIUse',
    Handler: 'handler',
    RecurringHandler: 'recurringHandler'
  });
  inspectorBackend.registerEvent('Log.entryAdded', ['entry']);
  inspectorBackend.registerCommand('Log.clear', [], []);
  inspectorBackend.registerCommand('Log.disable', [], []);
  inspectorBackend.registerCommand('Log.enable', [], []);
  inspectorBackend.registerCommand(
      'Log.startViolationsReport', [{'name': 'config', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand('Log.stopViolationsReport', [], []);

  // Memory.
  inspectorBackend.registerEnum('Memory.PressureLevel', {Moderate: 'moderate', Critical: 'critical'});
  inspectorBackend.registerCommand('Memory.getDOMCounters', [], ['documents', 'nodes', 'jsEventListeners']);
  inspectorBackend.registerCommand('Memory.prepareForLeakDetection', [], []);
  inspectorBackend.registerCommand('Memory.forciblyPurgeJavaScriptMemory', [], []);
  inspectorBackend.registerCommand(
      'Memory.setPressureNotificationsSuppressed', [{'name': 'suppressed', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Memory.simulatePressureNotification', [{'name': 'level', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Memory.startSampling',
      [
        {'name': 'samplingInterval', 'type': 'number', 'optional': true},
        {'name': 'suppressRandomness', 'type': 'boolean', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('Memory.stopSampling', [], []);
  inspectorBackend.registerCommand('Memory.getAllTimeSamplingProfile', [], ['profile']);
  inspectorBackend.registerCommand('Memory.getBrowserSamplingProfile', [], ['profile']);
  inspectorBackend.registerCommand('Memory.getSamplingProfile', [], ['profile']);

  // Network.
  inspectorBackend.registerEnum('Network.ResourceType', {
    Document: 'Document',
    Stylesheet: 'Stylesheet',
    Image: 'Image',
    Media: 'Media',
    Font: 'Font',
    Script: 'Script',
    TextTrack: 'TextTrack',
    XHR: 'XHR',
    Fetch: 'Fetch',
    EventSource: 'EventSource',
    WebSocket: 'WebSocket',
    Manifest: 'Manifest',
    SignedExchange: 'SignedExchange',
    Ping: 'Ping',
    CSPViolationReport: 'CSPViolationReport',
    Preflight: 'Preflight',
    Other: 'Other'
  });
  inspectorBackend.registerEnum('Network.ErrorReason', {
    Failed: 'Failed',
    Aborted: 'Aborted',
    TimedOut: 'TimedOut',
    AccessDenied: 'AccessDenied',
    ConnectionClosed: 'ConnectionClosed',
    ConnectionReset: 'ConnectionReset',
    ConnectionRefused: 'ConnectionRefused',
    ConnectionAborted: 'ConnectionAborted',
    ConnectionFailed: 'ConnectionFailed',
    NameNotResolved: 'NameNotResolved',
    InternetDisconnected: 'InternetDisconnected',
    AddressUnreachable: 'AddressUnreachable',
    BlockedByClient: 'BlockedByClient',
    BlockedByResponse: 'BlockedByResponse'
  });
  inspectorBackend.registerEnum('Network.ConnectionType', {
    None: 'none',
    Cellular2g: 'cellular2g',
    Cellular3g: 'cellular3g',
    Cellular4g: 'cellular4g',
    Bluetooth: 'bluetooth',
    Ethernet: 'ethernet',
    Wifi: 'wifi',
    Wimax: 'wimax',
    Other: 'other'
  });
  inspectorBackend.registerEnum('Network.CookieSameSite', {Strict: 'Strict', Lax: 'Lax', None: 'None'});
  inspectorBackend.registerEnum('Network.CookiePriority', {Low: 'Low', Medium: 'Medium', High: 'High'});
  inspectorBackend.registerEnum(
      'Network.CookieSourceScheme', {Unset: 'Unset', NonSecure: 'NonSecure', Secure: 'Secure'});
  inspectorBackend.registerEnum(
      'Network.ResourcePriority',
      {VeryLow: 'VeryLow', Low: 'Low', Medium: 'Medium', High: 'High', VeryHigh: 'VeryHigh'});
  inspectorBackend.registerEnum('Network.RequestReferrerPolicy', {
    UnsafeUrl: 'unsafe-url',
    NoReferrerWhenDowngrade: 'no-referrer-when-downgrade',
    NoReferrer: 'no-referrer',
    Origin: 'origin',
    OriginWhenCrossOrigin: 'origin-when-cross-origin',
    SameOrigin: 'same-origin',
    StrictOrigin: 'strict-origin',
    StrictOriginWhenCrossOrigin: 'strict-origin-when-cross-origin'
  });
  inspectorBackend.registerEnum(
      'Network.CertificateTransparencyCompliance',
      {Unknown: 'unknown', NotCompliant: 'not-compliant', Compliant: 'compliant'});
  inspectorBackend.registerEnum('Network.BlockedReason', {
    Other: 'other',
    Csp: 'csp',
    MixedContent: 'mixed-content',
    Origin: 'origin',
    Inspector: 'inspector',
    SubresourceFilter: 'subresource-filter',
    ContentType: 'content-type',
    CollapsedByClient: 'collapsed-by-client',
    CoepFrameResourceNeedsCoepHeader: 'coep-frame-resource-needs-coep-header',
    CoopSandboxedIframeCannotNavigateToCoopPage: 'coop-sandboxed-iframe-cannot-navigate-to-coop-page',
    CorpNotSameOrigin: 'corp-not-same-origin',
    CorpNotSameOriginAfterDefaultedToSameOriginByCoep: 'corp-not-same-origin-after-defaulted-to-same-origin-by-coep',
    CorpNotSameSite: 'corp-not-same-site'
  });
  inspectorBackend.registerEnum('Network.CorsError', {
    DisallowedByMode: 'DisallowedByMode',
    InvalidResponse: 'InvalidResponse',
    WildcardOriginNotAllowed: 'WildcardOriginNotAllowed',
    MissingAllowOriginHeader: 'MissingAllowOriginHeader',
    MultipleAllowOriginValues: 'MultipleAllowOriginValues',
    InvalidAllowOriginValue: 'InvalidAllowOriginValue',
    AllowOriginMismatch: 'AllowOriginMismatch',
    InvalidAllowCredentials: 'InvalidAllowCredentials',
    CorsDisabledScheme: 'CorsDisabledScheme',
    PreflightInvalidStatus: 'PreflightInvalidStatus',
    PreflightDisallowedRedirect: 'PreflightDisallowedRedirect',
    PreflightWildcardOriginNotAllowed: 'PreflightWildcardOriginNotAllowed',
    PreflightMissingAllowOriginHeader: 'PreflightMissingAllowOriginHeader',
    PreflightMultipleAllowOriginValues: 'PreflightMultipleAllowOriginValues',
    PreflightInvalidAllowOriginValue: 'PreflightInvalidAllowOriginValue',
    PreflightAllowOriginMismatch: 'PreflightAllowOriginMismatch',
    PreflightInvalidAllowCredentials: 'PreflightInvalidAllowCredentials',
    PreflightMissingAllowExternal: 'PreflightMissingAllowExternal',
    PreflightInvalidAllowExternal: 'PreflightInvalidAllowExternal',
    InvalidAllowMethodsPreflightResponse: 'InvalidAllowMethodsPreflightResponse',
    InvalidAllowHeadersPreflightResponse: 'InvalidAllowHeadersPreflightResponse',
    MethodDisallowedByPreflightResponse: 'MethodDisallowedByPreflightResponse',
    HeaderDisallowedByPreflightResponse: 'HeaderDisallowedByPreflightResponse',
    RedirectContainsCredentials: 'RedirectContainsCredentials',
    InsecurePrivateNetwork: 'InsecurePrivateNetwork'
  });
  inspectorBackend.registerEnum(
      'Network.ServiceWorkerResponseSource',
      {CacheStorage: 'cache-storage', HttpCache: 'http-cache', FallbackCode: 'fallback-code', Network: 'network'});
  inspectorBackend.registerEnum('Network.TrustTokenParamsRefreshPolicy', {UseCached: 'UseCached', Refresh: 'Refresh'});
  inspectorBackend.registerEnum(
      'Network.TrustTokenOperationType', {Issuance: 'Issuance', Redemption: 'Redemption', Signing: 'Signing'});
  inspectorBackend.registerEnum('Network.InitiatorType', {
    Parser: 'parser',
    Script: 'script',
    Preload: 'preload',
    SignedExchange: 'SignedExchange',
    Preflight: 'preflight',
    Other: 'other'
  });
  inspectorBackend.registerEnum('Network.SetCookieBlockedReason', {
    SecureOnly: 'SecureOnly',
    SameSiteStrict: 'SameSiteStrict',
    SameSiteLax: 'SameSiteLax',
    SameSiteUnspecifiedTreatedAsLax: 'SameSiteUnspecifiedTreatedAsLax',
    SameSiteNoneInsecure: 'SameSiteNoneInsecure',
    UserPreferences: 'UserPreferences',
    SyntaxError: 'SyntaxError',
    SchemeNotSupported: 'SchemeNotSupported',
    OverwriteSecure: 'OverwriteSecure',
    InvalidDomain: 'InvalidDomain',
    InvalidPrefix: 'InvalidPrefix',
    UnknownError: 'UnknownError',
    SchemefulSameSiteStrict: 'SchemefulSameSiteStrict',
    SchemefulSameSiteLax: 'SchemefulSameSiteLax',
    SchemefulSameSiteUnspecifiedTreatedAsLax: 'SchemefulSameSiteUnspecifiedTreatedAsLax',
    SamePartyFromCrossPartyContext: 'SamePartyFromCrossPartyContext',
    SamePartyConflictsWithOtherAttributes: 'SamePartyConflictsWithOtherAttributes'
  });
  inspectorBackend.registerEnum('Network.CookieBlockedReason', {
    SecureOnly: 'SecureOnly',
    NotOnPath: 'NotOnPath',
    DomainMismatch: 'DomainMismatch',
    SameSiteStrict: 'SameSiteStrict',
    SameSiteLax: 'SameSiteLax',
    SameSiteUnspecifiedTreatedAsLax: 'SameSiteUnspecifiedTreatedAsLax',
    SameSiteNoneInsecure: 'SameSiteNoneInsecure',
    UserPreferences: 'UserPreferences',
    UnknownError: 'UnknownError',
    SchemefulSameSiteStrict: 'SchemefulSameSiteStrict',
    SchemefulSameSiteLax: 'SchemefulSameSiteLax',
    SchemefulSameSiteUnspecifiedTreatedAsLax: 'SchemefulSameSiteUnspecifiedTreatedAsLax',
    SamePartyFromCrossPartyContext: 'SamePartyFromCrossPartyContext'
  });
  inspectorBackend.registerEnum('Network.AuthChallengeSource', {Server: 'Server', Proxy: 'Proxy'});
  inspectorBackend.registerEnum(
      'Network.AuthChallengeResponseResponse',
      {Default: 'Default', CancelAuth: 'CancelAuth', ProvideCredentials: 'ProvideCredentials'});
  inspectorBackend.registerEnum('Network.InterceptionStage', {Request: 'Request', HeadersReceived: 'HeadersReceived'});
  inspectorBackend.registerEnum('Network.SignedExchangeErrorField', {
    SignatureSig: 'signatureSig',
    SignatureIntegrity: 'signatureIntegrity',
    SignatureCertUrl: 'signatureCertUrl',
    SignatureCertSha256: 'signatureCertSha256',
    SignatureValidityUrl: 'signatureValidityUrl',
    SignatureTimestamps: 'signatureTimestamps'
  });
  inspectorBackend.registerEnum('Network.PrivateNetworkRequestPolicy', {
    Allow: 'Allow',
    BlockFromInsecureToMorePrivate: 'BlockFromInsecureToMorePrivate',
    WarnFromInsecureToMorePrivate: 'WarnFromInsecureToMorePrivate'
  });
  inspectorBackend.registerEnum(
      'Network.IPAddressSpace', {Local: 'Local', Private: 'Private', Public: 'Public', Unknown: 'Unknown'});
  inspectorBackend.registerEnum('Network.CrossOriginOpenerPolicyValue', {
    SameOrigin: 'SameOrigin',
    SameOriginAllowPopups: 'SameOriginAllowPopups',
    UnsafeNone: 'UnsafeNone',
    SameOriginPlusCoep: 'SameOriginPlusCoep'
  });
  inspectorBackend.registerEnum('Network.CrossOriginEmbedderPolicyValue', {None: 'None', RequireCorp: 'RequireCorp'});
  inspectorBackend.registerEvent('Network.dataReceived', ['requestId', 'timestamp', 'dataLength', 'encodedDataLength']);
  inspectorBackend.registerEvent(
      'Network.eventSourceMessageReceived', ['requestId', 'timestamp', 'eventName', 'eventId', 'data']);
  inspectorBackend.registerEvent(
      'Network.loadingFailed',
      ['requestId', 'timestamp', 'type', 'errorText', 'canceled', 'blockedReason', 'corsErrorStatus']);
  inspectorBackend.registerEvent(
      'Network.loadingFinished', ['requestId', 'timestamp', 'encodedDataLength', 'shouldReportCorbBlocking']);
  inspectorBackend.registerEvent('Network.requestIntercepted', [
    'interceptionId', 'request', 'frameId', 'resourceType', 'isNavigationRequest', 'isDownload', 'redirectUrl',
    'authChallenge', 'responseErrorReason', 'responseStatusCode', 'responseHeaders', 'requestId'
  ]);
  inspectorBackend.registerEvent('Network.requestServedFromCache', ['requestId']);
  inspectorBackend.registerEvent('Network.requestWillBeSent', [
    'requestId', 'loaderId', 'documentURL', 'request', 'timestamp', 'wallTime', 'initiator', 'redirectResponse', 'type',
    'frameId', 'hasUserGesture'
  ]);
  inspectorBackend.registerEvent('Network.resourceChangedPriority', ['requestId', 'newPriority', 'timestamp']);
  inspectorBackend.registerEvent('Network.signedExchangeReceived', ['requestId', 'info']);
  inspectorBackend.registerEvent(
      'Network.responseReceived', ['requestId', 'loaderId', 'timestamp', 'type', 'response', 'frameId']);
  inspectorBackend.registerEvent('Network.webSocketClosed', ['requestId', 'timestamp']);
  inspectorBackend.registerEvent('Network.webSocketCreated', ['requestId', 'url', 'initiator']);
  inspectorBackend.registerEvent('Network.webSocketFrameError', ['requestId', 'timestamp', 'errorMessage']);
  inspectorBackend.registerEvent('Network.webSocketFrameReceived', ['requestId', 'timestamp', 'response']);
  inspectorBackend.registerEvent('Network.webSocketFrameSent', ['requestId', 'timestamp', 'response']);
  inspectorBackend.registerEvent('Network.webSocketHandshakeResponseReceived', ['requestId', 'timestamp', 'response']);
  inspectorBackend.registerEvent(
      'Network.webSocketWillSendHandshakeRequest', ['requestId', 'timestamp', 'wallTime', 'request']);
  inspectorBackend.registerEvent('Network.webTransportCreated', ['transportId', 'url', 'timestamp', 'initiator']);
  inspectorBackend.registerEvent('Network.webTransportConnectionEstablished', ['transportId', 'timestamp']);
  inspectorBackend.registerEvent('Network.webTransportClosed', ['transportId', 'timestamp']);
  inspectorBackend.registerEvent(
      'Network.requestWillBeSentExtraInfo', ['requestId', 'associatedCookies', 'headers', 'clientSecurityState']);
  inspectorBackend.registerEvent(
      'Network.responseReceivedExtraInfo',
      ['requestId', 'blockedCookies', 'headers', 'resourceIPAddressSpace', 'headersText']);
  inspectorBackend.registerEnum('Network.TrustTokenOperationDoneEventStatus', {
    Ok: 'Ok',
    InvalidArgument: 'InvalidArgument',
    FailedPrecondition: 'FailedPrecondition',
    ResourceExhausted: 'ResourceExhausted',
    AlreadyExists: 'AlreadyExists',
    Unavailable: 'Unavailable',
    BadResponse: 'BadResponse',
    InternalError: 'InternalError',
    UnknownError: 'UnknownError',
    FulfilledLocally: 'FulfilledLocally'
  });
  inspectorBackend.registerEvent(
      'Network.trustTokenOperationDone',
      ['status', 'type', 'requestId', 'topLevelOrigin', 'issuerOrigin', 'issuedTokenCount']);
  inspectorBackend.registerCommand('Network.canClearBrowserCache', [], ['result']);
  inspectorBackend.registerCommand('Network.canClearBrowserCookies', [], ['result']);
  inspectorBackend.registerCommand('Network.canEmulateNetworkConditions', [], ['result']);
  inspectorBackend.registerCommand('Network.clearBrowserCache', [], []);
  inspectorBackend.registerCommand('Network.clearBrowserCookies', [], []);
  inspectorBackend.registerCommand(
      'Network.continueInterceptedRequest',
      [
        {'name': 'interceptionId', 'type': 'string', 'optional': false},
        {'name': 'errorReason', 'type': 'string', 'optional': true},
        {'name': 'rawResponse', 'type': 'string', 'optional': true},
        {'name': 'url', 'type': 'string', 'optional': true}, {'name': 'method', 'type': 'string', 'optional': true},
        {'name': 'postData', 'type': 'string', 'optional': true},
        {'name': 'headers', 'type': 'object', 'optional': true},
        {'name': 'authChallengeResponse', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Network.deleteCookies',
      [
        {'name': 'name', 'type': 'string', 'optional': false}, {'name': 'url', 'type': 'string', 'optional': true},
        {'name': 'domain', 'type': 'string', 'optional': true}, {'name': 'path', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('Network.disable', [], []);
  inspectorBackend.registerCommand(
      'Network.emulateNetworkConditions',
      [
        {'name': 'offline', 'type': 'boolean', 'optional': false},
        {'name': 'latency', 'type': 'number', 'optional': false},
        {'name': 'downloadThroughput', 'type': 'number', 'optional': false},
        {'name': 'uploadThroughput', 'type': 'number', 'optional': false},
        {'name': 'connectionType', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Network.enable',
      [
        {'name': 'maxTotalBufferSize', 'type': 'number', 'optional': true},
        {'name': 'maxResourceBufferSize', 'type': 'number', 'optional': true},
        {'name': 'maxPostDataSize', 'type': 'number', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('Network.getAllCookies', [], ['cookies']);
  inspectorBackend.registerCommand(
      'Network.getCertificate', [{'name': 'origin', 'type': 'string', 'optional': false}], ['tableNames']);
  inspectorBackend.registerCommand(
      'Network.getCookies', [{'name': 'urls', 'type': 'object', 'optional': true}], ['cookies']);
  inspectorBackend.registerCommand(
      'Network.getResponseBody', [{'name': 'requestId', 'type': 'string', 'optional': false}],
      ['body', 'base64Encoded']);
  inspectorBackend.registerCommand(
      'Network.getRequestPostData', [{'name': 'requestId', 'type': 'string', 'optional': false}], ['postData']);
  inspectorBackend.registerCommand(
      'Network.getResponseBodyForInterception', [{'name': 'interceptionId', 'type': 'string', 'optional': false}],
      ['body', 'base64Encoded']);
  inspectorBackend.registerCommand(
      'Network.takeResponseBodyForInterceptionAsStream',
      [{'name': 'interceptionId', 'type': 'string', 'optional': false}], ['stream']);
  inspectorBackend.registerCommand(
      'Network.replayXHR', [{'name': 'requestId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Network.searchInResponseBody',
      [
        {'name': 'requestId', 'type': 'string', 'optional': false},
        {'name': 'query', 'type': 'string', 'optional': false},
        {'name': 'caseSensitive', 'type': 'boolean', 'optional': true},
        {'name': 'isRegex', 'type': 'boolean', 'optional': true}
      ],
      ['result']);
  inspectorBackend.registerCommand(
      'Network.setBlockedURLs', [{'name': 'urls', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Network.setBypassServiceWorker', [{'name': 'bypass', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Network.setCacheDisabled', [{'name': 'cacheDisabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Network.setCookie',
      [
        {'name': 'name', 'type': 'string', 'optional': false}, {'name': 'value', 'type': 'string', 'optional': false},
        {'name': 'url', 'type': 'string', 'optional': true}, {'name': 'domain', 'type': 'string', 'optional': true},
        {'name': 'path', 'type': 'string', 'optional': true}, {'name': 'secure', 'type': 'boolean', 'optional': true},
        {'name': 'httpOnly', 'type': 'boolean', 'optional': true},
        {'name': 'sameSite', 'type': 'string', 'optional': true},
        {'name': 'expires', 'type': 'number', 'optional': true},
        {'name': 'priority', 'type': 'string', 'optional': true},
        {'name': 'sameParty', 'type': 'boolean', 'optional': true},
        {'name': 'sourceScheme', 'type': 'string', 'optional': true},
        {'name': 'sourcePort', 'type': 'number', 'optional': true}
      ],
      ['success']);
  inspectorBackend.registerCommand(
      'Network.setCookies', [{'name': 'cookies', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Network.setDataSizeLimitsForTest',
      [
        {'name': 'maxTotalSize', 'type': 'number', 'optional': false},
        {'name': 'maxResourceSize', 'type': 'number', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Network.setExtraHTTPHeaders', [{'name': 'headers', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Network.setAttachDebugStack', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Network.setRequestInterception', [{'name': 'patterns', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Network.setUserAgentOverride',
      [
        {'name': 'userAgent', 'type': 'string', 'optional': false},
        {'name': 'acceptLanguage', 'type': 'string', 'optional': true},
        {'name': 'platform', 'type': 'string', 'optional': true},
        {'name': 'userAgentMetadata', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Network.getSecurityIsolationStatus', [{'name': 'frameId', 'type': 'string', 'optional': true}], ['status']);
  inspectorBackend.registerCommand(
      'Network.loadNetworkResource',
      [
        {'name': 'frameId', 'type': 'string', 'optional': false}, {'name': 'url', 'type': 'string', 'optional': false},
        {'name': 'options', 'type': 'object', 'optional': false}
      ],
      ['resource']);

  // Overlay.
  inspectorBackend.registerEnum('Overlay.LineStylePattern', {Dashed: 'dashed', Dotted: 'dotted'});
  inspectorBackend.registerEnum('Overlay.ContrastAlgorithm', {Aa: 'aa', Aaa: 'aaa', Apca: 'apca'});
  inspectorBackend.registerEnum('Overlay.ColorFormat', {Rgb: 'rgb', Hsl: 'hsl', Hex: 'hex'});
  inspectorBackend.registerEnum('Overlay.InspectMode', {
    SearchForNode: 'searchForNode',
    SearchForUAShadowDOM: 'searchForUAShadowDOM',
    CaptureAreaScreenshot: 'captureAreaScreenshot',
    ShowDistances: 'showDistances',
    None: 'none'
  });
  inspectorBackend.registerEvent('Overlay.inspectNodeRequested', ['backendNodeId']);
  inspectorBackend.registerEvent('Overlay.nodeHighlightRequested', ['nodeId']);
  inspectorBackend.registerEvent('Overlay.screenshotRequested', ['viewport']);
  inspectorBackend.registerEvent('Overlay.inspectModeCanceled', []);
  inspectorBackend.registerCommand('Overlay.disable', [], []);
  inspectorBackend.registerCommand('Overlay.enable', [], []);
  inspectorBackend.registerCommand(
      'Overlay.getHighlightObjectForTest',
      [
        {'name': 'nodeId', 'type': 'number', 'optional': false},
        {'name': 'includeDistance', 'type': 'boolean', 'optional': true},
        {'name': 'includeStyle', 'type': 'boolean', 'optional': true},
        {'name': 'colorFormat', 'type': 'string', 'optional': true},
        {'name': 'showAccessibilityInfo', 'type': 'boolean', 'optional': true}
      ],
      ['highlight']);
  inspectorBackend.registerCommand(
      'Overlay.getGridHighlightObjectsForTest', [{'name': 'nodeIds', 'type': 'object', 'optional': false}],
      ['highlights']);
  inspectorBackend.registerCommand(
      'Overlay.getSourceOrderHighlightObjectForTest', [{'name': 'nodeId', 'type': 'number', 'optional': false}],
      ['highlight']);
  inspectorBackend.registerCommand('Overlay.hideHighlight', [], []);
  inspectorBackend.registerCommand(
      'Overlay.highlightFrame',
      [
        {'name': 'frameId', 'type': 'string', 'optional': false},
        {'name': 'contentColor', 'type': 'object', 'optional': true},
        {'name': 'contentOutlineColor', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Overlay.highlightNode',
      [
        {'name': 'highlightConfig', 'type': 'object', 'optional': false},
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true},
        {'name': 'selector', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Overlay.highlightQuad',
      [
        {'name': 'quad', 'type': 'object', 'optional': false}, {'name': 'color', 'type': 'object', 'optional': true},
        {'name': 'outlineColor', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Overlay.highlightRect',
      [
        {'name': 'x', 'type': 'number', 'optional': false}, {'name': 'y', 'type': 'number', 'optional': false},
        {'name': 'width', 'type': 'number', 'optional': false}, {'name': 'height', 'type': 'number', 'optional': false},
        {'name': 'color', 'type': 'object', 'optional': true},
        {'name': 'outlineColor', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Overlay.highlightSourceOrder',
      [
        {'name': 'sourceOrderConfig', 'type': 'object', 'optional': false},
        {'name': 'nodeId', 'type': 'number', 'optional': true},
        {'name': 'backendNodeId', 'type': 'number', 'optional': true},
        {'name': 'objectId', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Overlay.setInspectMode',
      [
        {'name': 'mode', 'type': 'string', 'optional': false},
        {'name': 'highlightConfig', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Overlay.setShowAdHighlights', [{'name': 'show', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setPausedInDebuggerMessage', [{'name': 'message', 'type': 'string', 'optional': true}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowDebugBorders', [{'name': 'show', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowFPSCounter', [{'name': 'show', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowGridOverlays', [{'name': 'gridNodeHighlightConfigs', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowFlexOverlays', [{'name': 'flexNodeHighlightConfigs', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowPaintRects', [{'name': 'result', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowLayoutShiftRegions', [{'name': 'result', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowScrollBottleneckRects', [{'name': 'show', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowHitTestBorders', [{'name': 'show', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowWebVitals', [{'name': 'show', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowViewportSizeOnResize', [{'name': 'show', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Overlay.setShowHinge', [{'name': 'hingeConfig', 'type': 'object', 'optional': true}], []);

  // Page.
  inspectorBackend.registerEnum('Page.AdFrameType', {None: 'none', Child: 'child', Root: 'root'});
  inspectorBackend.registerEnum('Page.SecureContextType', {
    Secure: 'Secure',
    SecureLocalhost: 'SecureLocalhost',
    InsecureScheme: 'InsecureScheme',
    InsecureAncestor: 'InsecureAncestor'
  });
  inspectorBackend.registerEnum(
      'Page.CrossOriginIsolatedContextType',
      {Isolated: 'Isolated', NotIsolated: 'NotIsolated', NotIsolatedFeatureDisabled: 'NotIsolatedFeatureDisabled'});
  inspectorBackend.registerEnum('Page.GatedAPIFeatures', {
    SharedArrayBuffers: 'SharedArrayBuffers',
    SharedArrayBuffersTransferAllowed: 'SharedArrayBuffersTransferAllowed',
    PerformanceMeasureMemory: 'PerformanceMeasureMemory',
    PerformanceProfile: 'PerformanceProfile'
  });
  inspectorBackend.registerEnum('Page.PermissionsPolicyFeature', {
    Accelerometer: 'accelerometer',
    AmbientLightSensor: 'ambient-light-sensor',
    Autoplay: 'autoplay',
    Camera: 'camera',
    ChDpr: 'ch-dpr',
    ChDeviceMemory: 'ch-device-memory',
    ChDownlink: 'ch-downlink',
    ChEct: 'ch-ect',
    ChLang: 'ch-lang',
    ChRtt: 'ch-rtt',
    ChUa: 'ch-ua',
    ChUaArch: 'ch-ua-arch',
    ChUaPlatform: 'ch-ua-platform',
    ChUaModel: 'ch-ua-model',
    ChUaMobile: 'ch-ua-mobile',
    ChUaFullVersion: 'ch-ua-full-version',
    ChUaPlatformVersion: 'ch-ua-platform-version',
    ChViewportWidth: 'ch-viewport-width',
    ChWidth: 'ch-width',
    ClipboardRead: 'clipboard-read',
    ClipboardWrite: 'clipboard-write',
    ConversionMeasurement: 'conversion-measurement',
    CrossOriginIsolated: 'cross-origin-isolated',
    DisplayCapture: 'display-capture',
    DocumentDomain: 'document-domain',
    EncryptedMedia: 'encrypted-media',
    ExecutionWhileOutOfViewport: 'execution-while-out-of-viewport',
    ExecutionWhileNotRendered: 'execution-while-not-rendered',
    FocusWithoutUserActivation: 'focus-without-user-activation',
    Fullscreen: 'fullscreen',
    Frobulate: 'frobulate',
    Gamepad: 'gamepad',
    Geolocation: 'geolocation',
    Gyroscope: 'gyroscope',
    Hid: 'hid',
    IdleDetection: 'idle-detection',
    InterestCohort: 'interest-cohort',
    Magnetometer: 'magnetometer',
    Microphone: 'microphone',
    Midi: 'midi',
    OtpCredentials: 'otp-credentials',
    Payment: 'payment',
    PictureInPicture: 'picture-in-picture',
    PublickeyCredentialsGet: 'publickey-credentials-get',
    ScreenWakeLock: 'screen-wake-lock',
    Serial: 'serial',
    StorageAccessAPI: 'storage-access-api',
    SyncXhr: 'sync-xhr',
    TrustTokenRedemption: 'trust-token-redemption',
    Usb: 'usb',
    VerticalScroll: 'vertical-scroll',
    WebShare: 'web-share',
    XrSpatialTracking: 'xr-spatial-tracking'
  });
  inspectorBackend.registerEnum(
      'Page.PermissionsPolicyBlockReason', {Header: 'Header', IframeAttribute: 'IframeAttribute'});
  inspectorBackend.registerEnum('Page.TransitionType', {
    Link: 'link',
    Typed: 'typed',
    Address_bar: 'address_bar',
    Auto_bookmark: 'auto_bookmark',
    Auto_subframe: 'auto_subframe',
    Manual_subframe: 'manual_subframe',
    Generated: 'generated',
    Auto_toplevel: 'auto_toplevel',
    Form_submit: 'form_submit',
    Reload: 'reload',
    Keyword: 'keyword',
    Keyword_generated: 'keyword_generated',
    Other: 'other'
  });
  inspectorBackend.registerEnum(
      'Page.DialogType', {Alert: 'alert', Confirm: 'confirm', Prompt: 'prompt', Beforeunload: 'beforeunload'});
  inspectorBackend.registerEnum('Page.ClientNavigationReason', {
    FormSubmissionGet: 'formSubmissionGet',
    FormSubmissionPost: 'formSubmissionPost',
    HttpHeaderRefresh: 'httpHeaderRefresh',
    ScriptInitiated: 'scriptInitiated',
    MetaTagRefresh: 'metaTagRefresh',
    PageBlockInterstitial: 'pageBlockInterstitial',
    Reload: 'reload',
    AnchorClick: 'anchorClick'
  });
  inspectorBackend.registerEnum(
      'Page.ClientNavigationDisposition',
      {CurrentTab: 'currentTab', NewTab: 'newTab', NewWindow: 'newWindow', Download: 'download'});
  inspectorBackend.registerEnum('Page.ReferrerPolicy', {
    NoReferrer: 'noReferrer',
    NoReferrerWhenDowngrade: 'noReferrerWhenDowngrade',
    Origin: 'origin',
    OriginWhenCrossOrigin: 'originWhenCrossOrigin',
    SameOrigin: 'sameOrigin',
    StrictOrigin: 'strictOrigin',
    StrictOriginWhenCrossOrigin: 'strictOriginWhenCrossOrigin',
    UnsafeUrl: 'unsafeUrl'
  });
  inspectorBackend.registerEvent('Page.domContentEventFired', ['timestamp']);
  inspectorBackend.registerEnum(
      'Page.FileChooserOpenedEventMode', {SelectSingle: 'selectSingle', SelectMultiple: 'selectMultiple'});
  inspectorBackend.registerEvent('Page.fileChooserOpened', ['frameId', 'backendNodeId', 'mode']);
  inspectorBackend.registerEvent('Page.frameAttached', ['frameId', 'parentFrameId', 'stack']);
  inspectorBackend.registerEvent('Page.frameClearedScheduledNavigation', ['frameId']);
  inspectorBackend.registerEnum('Page.FrameDetachedEventReason', {Remove: 'remove', Swap: 'swap'});
  inspectorBackend.registerEvent('Page.frameDetached', ['frameId', 'reason']);
  inspectorBackend.registerEvent('Page.frameNavigated', ['frame']);
  inspectorBackend.registerEvent('Page.documentOpened', ['frame']);
  inspectorBackend.registerEvent('Page.frameResized', []);
  inspectorBackend.registerEvent('Page.frameRequestedNavigation', ['frameId', 'reason', 'url', 'disposition']);
  inspectorBackend.registerEvent('Page.frameScheduledNavigation', ['frameId', 'delay', 'reason', 'url']);
  inspectorBackend.registerEvent('Page.frameStartedLoading', ['frameId']);
  inspectorBackend.registerEvent('Page.frameStoppedLoading', ['frameId']);
  inspectorBackend.registerEvent('Page.downloadWillBegin', ['frameId', 'guid', 'url', 'suggestedFilename']);
  inspectorBackend.registerEnum(
      'Page.DownloadProgressEventState', {InProgress: 'inProgress', Completed: 'completed', Canceled: 'canceled'});
  inspectorBackend.registerEvent('Page.downloadProgress', ['guid', 'totalBytes', 'receivedBytes', 'state']);
  inspectorBackend.registerEvent('Page.interstitialHidden', []);
  inspectorBackend.registerEvent('Page.interstitialShown', []);
  inspectorBackend.registerEvent('Page.javascriptDialogClosed', ['result', 'userInput']);
  inspectorBackend.registerEvent(
      'Page.javascriptDialogOpening', ['url', 'message', 'type', 'hasBrowserHandler', 'defaultPrompt']);
  inspectorBackend.registerEvent('Page.lifecycleEvent', ['frameId', 'loaderId', 'name', 'timestamp']);
  inspectorBackend.registerEvent('Page.loadEventFired', ['timestamp']);
  inspectorBackend.registerEvent('Page.navigatedWithinDocument', ['frameId', 'url']);
  inspectorBackend.registerEvent('Page.screencastFrame', ['data', 'metadata', 'sessionId']);
  inspectorBackend.registerEvent('Page.screencastVisibilityChanged', ['visible']);
  inspectorBackend.registerEvent('Page.windowOpen', ['url', 'windowName', 'windowFeatures', 'userGesture']);
  inspectorBackend.registerEvent('Page.compilationCacheProduced', ['url', 'data']);
  inspectorBackend.registerCommand(
      'Page.addScriptToEvaluateOnLoad', [{'name': 'scriptSource', 'type': 'string', 'optional': false}],
      ['identifier']);
  inspectorBackend.registerCommand(
      'Page.addScriptToEvaluateOnNewDocument',
      [
        {'name': 'source', 'type': 'string', 'optional': false},
        {'name': 'worldName', 'type': 'string', 'optional': true}
      ],
      ['identifier']);
  inspectorBackend.registerCommand('Page.bringToFront', [], []);
  inspectorBackend.registerEnum('Page.CaptureScreenshotRequestFormat', {Jpeg: 'jpeg', Png: 'png'});
  inspectorBackend.registerCommand(
      'Page.captureScreenshot',
      [
        {'name': 'format', 'type': 'string', 'optional': true}, {'name': 'quality', 'type': 'number', 'optional': true},
        {'name': 'clip', 'type': 'object', 'optional': true},
        {'name': 'fromSurface', 'type': 'boolean', 'optional': true},
        {'name': 'captureBeyondViewport', 'type': 'boolean', 'optional': true}
      ],
      ['data']);
  inspectorBackend.registerEnum('Page.CaptureSnapshotRequestFormat', {MHTML: 'mhtml'});
  inspectorBackend.registerCommand(
      'Page.captureSnapshot', [{'name': 'format', 'type': 'string', 'optional': true}], ['data']);
  inspectorBackend.registerCommand('Page.clearDeviceMetricsOverride', [], []);
  inspectorBackend.registerCommand('Page.clearDeviceOrientationOverride', [], []);
  inspectorBackend.registerCommand('Page.clearGeolocationOverride', [], []);
  inspectorBackend.registerCommand(
      'Page.createIsolatedWorld',
      [
        {'name': 'frameId', 'type': 'string', 'optional': false},
        {'name': 'worldName', 'type': 'string', 'optional': true},
        {'name': 'grantUniveralAccess', 'type': 'boolean', 'optional': true}
      ],
      ['executionContextId']);
  inspectorBackend.registerCommand(
      'Page.deleteCookie',
      [
        {'name': 'cookieName', 'type': 'string', 'optional': false},
        {'name': 'url', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand('Page.disable', [], []);
  inspectorBackend.registerCommand('Page.enable', [], []);
  inspectorBackend.registerCommand('Page.getAppManifest', [], ['url', 'errors', 'data', 'parsed']);
  inspectorBackend.registerCommand('Page.getInstallabilityErrors', [], ['installabilityErrors']);
  inspectorBackend.registerCommand('Page.getManifestIcons', [], ['primaryIcon']);
  inspectorBackend.registerCommand('Page.getCookies', [], ['cookies']);
  inspectorBackend.registerCommand('Page.getFrameTree', [], ['frameTree']);
  inspectorBackend.registerCommand('Page.getLayoutMetrics', [], ['layoutViewport', 'visualViewport', 'contentSize']);
  inspectorBackend.registerCommand('Page.getNavigationHistory', [], ['currentIndex', 'entries']);
  inspectorBackend.registerCommand('Page.resetNavigationHistory', [], []);
  inspectorBackend.registerCommand(
      'Page.getResourceContent',
      [{'name': 'frameId', 'type': 'string', 'optional': false}, {'name': 'url', 'type': 'string', 'optional': false}],
      ['content', 'base64Encoded']);
  inspectorBackend.registerCommand('Page.getResourceTree', [], ['frameTree']);
  inspectorBackend.registerCommand(
      'Page.handleJavaScriptDialog',
      [
        {'name': 'accept', 'type': 'boolean', 'optional': false},
        {'name': 'promptText', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Page.navigate',
      [
        {'name': 'url', 'type': 'string', 'optional': false}, {'name': 'referrer', 'type': 'string', 'optional': true},
        {'name': 'transitionType', 'type': 'string', 'optional': true},
        {'name': 'frameId', 'type': 'string', 'optional': true},
        {'name': 'referrerPolicy', 'type': 'string', 'optional': true}
      ],
      ['frameId', 'loaderId', 'errorText']);
  inspectorBackend.registerCommand(
      'Page.navigateToHistoryEntry', [{'name': 'entryId', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerEnum(
      'Page.PrintToPDFRequestTransferMode', {ReturnAsBase64: 'ReturnAsBase64', ReturnAsStream: 'ReturnAsStream'});
  inspectorBackend.registerCommand(
      'Page.printToPDF',
      [
        {'name': 'landscape', 'type': 'boolean', 'optional': true},
        {'name': 'displayHeaderFooter', 'type': 'boolean', 'optional': true},
        {'name': 'printBackground', 'type': 'boolean', 'optional': true},
        {'name': 'scale', 'type': 'number', 'optional': true},
        {'name': 'paperWidth', 'type': 'number', 'optional': true},
        {'name': 'paperHeight', 'type': 'number', 'optional': true},
        {'name': 'marginTop', 'type': 'number', 'optional': true},
        {'name': 'marginBottom', 'type': 'number', 'optional': true},
        {'name': 'marginLeft', 'type': 'number', 'optional': true},
        {'name': 'marginRight', 'type': 'number', 'optional': true},
        {'name': 'pageRanges', 'type': 'string', 'optional': true},
        {'name': 'ignoreInvalidPageRanges', 'type': 'boolean', 'optional': true},
        {'name': 'headerTemplate', 'type': 'string', 'optional': true},
        {'name': 'footerTemplate', 'type': 'string', 'optional': true},
        {'name': 'preferCSSPageSize', 'type': 'boolean', 'optional': true},
        {'name': 'transferMode', 'type': 'string', 'optional': true}
      ],
      ['data', 'stream']);
  inspectorBackend.registerCommand(
      'Page.reload',
      [
        {'name': 'ignoreCache', 'type': 'boolean', 'optional': true},
        {'name': 'scriptToEvaluateOnLoad', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Page.removeScriptToEvaluateOnLoad', [{'name': 'identifier', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Page.removeScriptToEvaluateOnNewDocument', [{'name': 'identifier', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Page.screencastFrameAck', [{'name': 'sessionId', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Page.searchInResource',
      [
        {'name': 'frameId', 'type': 'string', 'optional': false}, {'name': 'url', 'type': 'string', 'optional': false},
        {'name': 'query', 'type': 'string', 'optional': false},
        {'name': 'caseSensitive', 'type': 'boolean', 'optional': true},
        {'name': 'isRegex', 'type': 'boolean', 'optional': true}
      ],
      ['result']);
  inspectorBackend.registerCommand(
      'Page.setAdBlockingEnabled', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Page.setBypassCSP', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Page.getPermissionsPolicyState', [{'name': 'frameId', 'type': 'string', 'optional': false}], ['states']);
  inspectorBackend.registerCommand(
      'Page.setDeviceMetricsOverride',
      [
        {'name': 'width', 'type': 'number', 'optional': false}, {'name': 'height', 'type': 'number', 'optional': false},
        {'name': 'deviceScaleFactor', 'type': 'number', 'optional': false},
        {'name': 'mobile', 'type': 'boolean', 'optional': false}, {'name': 'scale', 'type': 'number', 'optional': true},
        {'name': 'screenWidth', 'type': 'number', 'optional': true},
        {'name': 'screenHeight', 'type': 'number', 'optional': true},
        {'name': 'positionX', 'type': 'number', 'optional': true},
        {'name': 'positionY', 'type': 'number', 'optional': true},
        {'name': 'dontSetVisibleSize', 'type': 'boolean', 'optional': true},
        {'name': 'screenOrientation', 'type': 'object', 'optional': true},
        {'name': 'viewport', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Page.setDeviceOrientationOverride',
      [
        {'name': 'alpha', 'type': 'number', 'optional': false}, {'name': 'beta', 'type': 'number', 'optional': false},
        {'name': 'gamma', 'type': 'number', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Page.setFontFamilies', [{'name': 'fontFamilies', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Page.setFontSizes', [{'name': 'fontSizes', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Page.setDocumentContent',
      [{'name': 'frameId', 'type': 'string', 'optional': false}, {'name': 'html', 'type': 'string', 'optional': false}],
      []);
  inspectorBackend.registerEnum(
      'Page.SetDownloadBehaviorRequestBehavior', {Deny: 'deny', Allow: 'allow', Default: 'default'});
  inspectorBackend.registerCommand(
      'Page.setDownloadBehavior',
      [
        {'name': 'behavior', 'type': 'string', 'optional': false},
        {'name': 'downloadPath', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Page.setGeolocationOverride',
      [
        {'name': 'latitude', 'type': 'number', 'optional': true},
        {'name': 'longitude', 'type': 'number', 'optional': true},
        {'name': 'accuracy', 'type': 'number', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Page.setLifecycleEventsEnabled', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerEnum(
      'Page.SetTouchEmulationEnabledRequestConfiguration', {Mobile: 'mobile', Desktop: 'desktop'});
  inspectorBackend.registerCommand(
      'Page.setTouchEmulationEnabled',
      [
        {'name': 'enabled', 'type': 'boolean', 'optional': false},
        {'name': 'configuration', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerEnum('Page.StartScreencastRequestFormat', {Jpeg: 'jpeg', Png: 'png'});
  inspectorBackend.registerCommand(
      'Page.startScreencast',
      [
        {'name': 'format', 'type': 'string', 'optional': true}, {'name': 'quality', 'type': 'number', 'optional': true},
        {'name': 'maxWidth', 'type': 'number', 'optional': true},
        {'name': 'maxHeight', 'type': 'number', 'optional': true},
        {'name': 'everyNthFrame', 'type': 'number', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('Page.stopLoading', [], []);
  inspectorBackend.registerCommand('Page.crash', [], []);
  inspectorBackend.registerCommand('Page.close', [], []);
  inspectorBackend.registerEnum('Page.SetWebLifecycleStateRequestState', {Frozen: 'frozen', Active: 'active'});
  inspectorBackend.registerCommand(
      'Page.setWebLifecycleState', [{'name': 'state', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand('Page.stopScreencast', [], []);
  inspectorBackend.registerCommand(
      'Page.setProduceCompilationCache', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Page.addCompilationCache',
      [{'name': 'url', 'type': 'string', 'optional': false}, {'name': 'data', 'type': 'string', 'optional': false}],
      []);
  inspectorBackend.registerCommand('Page.clearCompilationCache', [], []);
  inspectorBackend.registerCommand(
      'Page.generateTestReport',
      [{'name': 'message', 'type': 'string', 'optional': false}, {'name': 'group', 'type': 'string', 'optional': true}],
      []);
  inspectorBackend.registerCommand('Page.waitForDebugger', [], []);
  inspectorBackend.registerCommand(
      'Page.setInterceptFileChooserDialog', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);

  // Performance.
  inspectorBackend.registerEvent('Performance.metrics', ['metrics', 'title']);
  inspectorBackend.registerCommand('Performance.disable', [], []);
  inspectorBackend.registerEnum(
      'Performance.EnableRequestTimeDomain', {TimeTicks: 'timeTicks', ThreadTicks: 'threadTicks'});
  inspectorBackend.registerCommand(
      'Performance.enable', [{'name': 'timeDomain', 'type': 'string', 'optional': true}], []);
  inspectorBackend.registerEnum(
      'Performance.SetTimeDomainRequestTimeDomain', {TimeTicks: 'timeTicks', ThreadTicks: 'threadTicks'});
  inspectorBackend.registerCommand(
      'Performance.setTimeDomain', [{'name': 'timeDomain', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand('Performance.getMetrics', [], ['metrics']);

  // PerformanceTimeline.
  inspectorBackend.registerEvent('PerformanceTimeline.timelineEventAdded', ['event']);
  inspectorBackend.registerCommand(
      'PerformanceTimeline.enable', [{'name': 'eventTypes', 'type': 'object', 'optional': false}], []);

  // Security.
  inspectorBackend.registerEnum(
      'Security.MixedContentType', {Blockable: 'blockable', OptionallyBlockable: 'optionally-blockable', None: 'none'});
  inspectorBackend.registerEnum('Security.SecurityState', {
    Unknown: 'unknown',
    Neutral: 'neutral',
    Insecure: 'insecure',
    Secure: 'secure',
    Info: 'info',
    InsecureBroken: 'insecure-broken'
  });
  inspectorBackend.registerEnum('Security.SafetyTipStatus', {BadReputation: 'badReputation', Lookalike: 'lookalike'});
  inspectorBackend.registerEnum('Security.CertificateErrorAction', {Continue: 'continue', Cancel: 'cancel'});
  inspectorBackend.registerEvent('Security.certificateError', ['eventId', 'errorType', 'requestURL']);
  inspectorBackend.registerEvent('Security.visibleSecurityStateChanged', ['visibleSecurityState']);
  inspectorBackend.registerEvent(
      'Security.securityStateChanged',
      ['securityState', 'schemeIsCryptographic', 'explanations', 'insecureContentStatus', 'summary']);
  inspectorBackend.registerCommand('Security.disable', [], []);
  inspectorBackend.registerCommand('Security.enable', [], []);
  inspectorBackend.registerCommand(
      'Security.setIgnoreCertificateErrors', [{'name': 'ignore', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Security.handleCertificateError',
      [
        {'name': 'eventId', 'type': 'number', 'optional': false},
        {'name': 'action', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Security.setOverrideCertificateErrors', [{'name': 'override', 'type': 'boolean', 'optional': false}], []);

  // ServiceWorker.
  inspectorBackend.registerEnum(
      'ServiceWorker.ServiceWorkerVersionRunningStatus',
      {Stopped: 'stopped', Starting: 'starting', Running: 'running', Stopping: 'stopping'});
  inspectorBackend.registerEnum('ServiceWorker.ServiceWorkerVersionStatus', {
    New: 'new',
    Installing: 'installing',
    Installed: 'installed',
    Activating: 'activating',
    Activated: 'activated',
    Redundant: 'redundant'
  });
  inspectorBackend.registerEvent('ServiceWorker.workerErrorReported', ['errorMessage']);
  inspectorBackend.registerEvent('ServiceWorker.workerRegistrationUpdated', ['registrations']);
  inspectorBackend.registerEvent('ServiceWorker.workerVersionUpdated', ['versions']);
  inspectorBackend.registerCommand(
      'ServiceWorker.deliverPushMessage',
      [
        {'name': 'origin', 'type': 'string', 'optional': false},
        {'name': 'registrationId', 'type': 'string', 'optional': false},
        {'name': 'data', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand('ServiceWorker.disable', [], []);
  inspectorBackend.registerCommand(
      'ServiceWorker.dispatchSyncEvent',
      [
        {'name': 'origin', 'type': 'string', 'optional': false},
        {'name': 'registrationId', 'type': 'string', 'optional': false},
        {'name': 'tag', 'type': 'string', 'optional': false},
        {'name': 'lastChance', 'type': 'boolean', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'ServiceWorker.dispatchPeriodicSyncEvent',
      [
        {'name': 'origin', 'type': 'string', 'optional': false},
        {'name': 'registrationId', 'type': 'string', 'optional': false},
        {'name': 'tag', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand('ServiceWorker.enable', [], []);
  inspectorBackend.registerCommand(
      'ServiceWorker.inspectWorker', [{'name': 'versionId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'ServiceWorker.setForceUpdateOnPageLoad',
      [{'name': 'forceUpdateOnPageLoad', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'ServiceWorker.skipWaiting', [{'name': 'scopeURL', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'ServiceWorker.startWorker', [{'name': 'scopeURL', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand('ServiceWorker.stopAllWorkers', [], []);
  inspectorBackend.registerCommand(
      'ServiceWorker.stopWorker', [{'name': 'versionId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'ServiceWorker.unregister', [{'name': 'scopeURL', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'ServiceWorker.updateRegistration', [{'name': 'scopeURL', 'type': 'string', 'optional': false}], []);

  // Storage.
  inspectorBackend.registerEnum('Storage.StorageType', {
    Appcache: 'appcache',
    Cookies: 'cookies',
    File_systems: 'file_systems',
    Indexeddb: 'indexeddb',
    Local_storage: 'local_storage',
    Shader_cache: 'shader_cache',
    Websql: 'websql',
    Service_workers: 'service_workers',
    Cache_storage: 'cache_storage',
    All: 'all',
    Other: 'other'
  });
  inspectorBackend.registerEvent('Storage.cacheStorageContentUpdated', ['origin', 'cacheName']);
  inspectorBackend.registerEvent('Storage.cacheStorageListUpdated', ['origin']);
  inspectorBackend.registerEvent('Storage.indexedDBContentUpdated', ['origin', 'databaseName', 'objectStoreName']);
  inspectorBackend.registerEvent('Storage.indexedDBListUpdated', ['origin']);
  inspectorBackend.registerCommand(
      'Storage.clearDataForOrigin',
      [
        {'name': 'origin', 'type': 'string', 'optional': false},
        {'name': 'storageTypes', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Storage.getCookies', [{'name': 'browserContextId', 'type': 'string', 'optional': true}], ['cookies']);
  inspectorBackend.registerCommand(
      'Storage.setCookies',
      [
        {'name': 'cookies', 'type': 'object', 'optional': false},
        {'name': 'browserContextId', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Storage.clearCookies', [{'name': 'browserContextId', 'type': 'string', 'optional': true}], []);
  inspectorBackend.registerCommand(
      'Storage.getUsageAndQuota', [{'name': 'origin', 'type': 'string', 'optional': false}],
      ['usage', 'quota', 'overrideActive', 'usageBreakdown']);
  inspectorBackend.registerCommand(
      'Storage.overrideQuotaForOrigin',
      [
        {'name': 'origin', 'type': 'string', 'optional': false},
        {'name': 'quotaSize', 'type': 'number', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Storage.trackCacheStorageForOrigin', [{'name': 'origin', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Storage.trackIndexedDBForOrigin', [{'name': 'origin', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Storage.untrackCacheStorageForOrigin', [{'name': 'origin', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Storage.untrackIndexedDBForOrigin', [{'name': 'origin', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand('Storage.getTrustTokens', [], ['tokens']);

  // SystemInfo.
  inspectorBackend.registerEnum('SystemInfo.SubsamplingFormat', {Yuv420: 'yuv420', Yuv422: 'yuv422', Yuv444: 'yuv444'});
  inspectorBackend.registerEnum('SystemInfo.ImageType', {Jpeg: 'jpeg', Webp: 'webp', Unknown: 'unknown'});
  inspectorBackend.registerCommand('SystemInfo.getInfo', [], ['gpu', 'modelName', 'modelVersion', 'commandLine']);
  inspectorBackend.registerCommand('SystemInfo.getProcessInfo', [], ['processInfo']);

  // Target.
  inspectorBackend.registerEvent('Target.attachedToTarget', ['sessionId', 'targetInfo', 'waitingForDebugger']);
  inspectorBackend.registerEvent('Target.detachedFromTarget', ['sessionId', 'targetId']);
  inspectorBackend.registerEvent('Target.receivedMessageFromTarget', ['sessionId', 'message', 'targetId']);
  inspectorBackend.registerEvent('Target.targetCreated', ['targetInfo']);
  inspectorBackend.registerEvent('Target.targetDestroyed', ['targetId']);
  inspectorBackend.registerEvent('Target.targetCrashed', ['targetId', 'status', 'errorCode']);
  inspectorBackend.registerEvent('Target.targetInfoChanged', ['targetInfo']);
  inspectorBackend.registerCommand(
      'Target.activateTarget', [{'name': 'targetId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Target.attachToTarget',
      [
        {'name': 'targetId', 'type': 'string', 'optional': false},
        {'name': 'flatten', 'type': 'boolean', 'optional': true}
      ],
      ['sessionId']);
  inspectorBackend.registerCommand('Target.attachToBrowserTarget', [], ['sessionId']);
  inspectorBackend.registerCommand(
      'Target.closeTarget', [{'name': 'targetId', 'type': 'string', 'optional': false}], ['success']);
  inspectorBackend.registerCommand(
      'Target.exposeDevToolsProtocol',
      [
        {'name': 'targetId', 'type': 'string', 'optional': false},
        {'name': 'bindingName', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Target.createBrowserContext',
      [
        {'name': 'disposeOnDetach', 'type': 'boolean', 'optional': true},
        {'name': 'proxyServer', 'type': 'string', 'optional': true},
        {'name': 'proxyBypassList', 'type': 'string', 'optional': true}
      ],
      ['browserContextId']);
  inspectorBackend.registerCommand('Target.getBrowserContexts', [], ['browserContextIds']);
  inspectorBackend.registerCommand(
      'Target.createTarget',
      [
        {'name': 'url', 'type': 'string', 'optional': false}, {'name': 'width', 'type': 'number', 'optional': true},
        {'name': 'height', 'type': 'number', 'optional': true},
        {'name': 'browserContextId', 'type': 'string', 'optional': true},
        {'name': 'enableBeginFrameControl', 'type': 'boolean', 'optional': true},
        {'name': 'newWindow', 'type': 'boolean', 'optional': true},
        {'name': 'background', 'type': 'boolean', 'optional': true}
      ],
      ['targetId']);
  inspectorBackend.registerCommand(
      'Target.detachFromTarget',
      [
        {'name': 'sessionId', 'type': 'string', 'optional': true},
        {'name': 'targetId', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Target.disposeBrowserContext', [{'name': 'browserContextId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Target.getTargetInfo', [{'name': 'targetId', 'type': 'string', 'optional': true}], ['targetInfo']);
  inspectorBackend.registerCommand('Target.getTargets', [], ['targetInfos']);
  inspectorBackend.registerCommand(
      'Target.sendMessageToTarget',
      [
        {'name': 'message', 'type': 'string', 'optional': false},
        {'name': 'sessionId', 'type': 'string', 'optional': true},
        {'name': 'targetId', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Target.setAutoAttach',
      [
        {'name': 'autoAttach', 'type': 'boolean', 'optional': false},
        {'name': 'waitForDebuggerOnStart', 'type': 'boolean', 'optional': false},
        {'name': 'flatten', 'type': 'boolean', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Target.setDiscoverTargets', [{'name': 'discover', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Target.setRemoteLocations', [{'name': 'locations', 'type': 'object', 'optional': false}], []);

  // Tethering.
  inspectorBackend.registerEvent('Tethering.accepted', ['port', 'connectionId']);
  inspectorBackend.registerCommand('Tethering.bind', [{'name': 'port', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand('Tethering.unbind', [{'name': 'port', 'type': 'number', 'optional': false}], []);

  // Tracing.
  inspectorBackend.registerEnum('Tracing.TraceConfigRecordMode', {
    RecordUntilFull: 'recordUntilFull',
    RecordContinuously: 'recordContinuously',
    RecordAsMuchAsPossible: 'recordAsMuchAsPossible',
    EchoToConsole: 'echoToConsole'
  });
  inspectorBackend.registerEnum('Tracing.StreamFormat', {Json: 'json', Proto: 'proto'});
  inspectorBackend.registerEnum('Tracing.StreamCompression', {None: 'none', Gzip: 'gzip'});
  inspectorBackend.registerEnum(
      'Tracing.MemoryDumpLevelOfDetail', {Background: 'background', Light: 'light', Detailed: 'detailed'});
  inspectorBackend.registerEvent('Tracing.bufferUsage', ['percentFull', 'eventCount', 'value']);
  inspectorBackend.registerEvent('Tracing.dataCollected', ['value']);
  inspectorBackend.registerEvent(
      'Tracing.tracingComplete', ['dataLossOccurred', 'stream', 'traceFormat', 'streamCompression']);
  inspectorBackend.registerCommand('Tracing.end', [], []);
  inspectorBackend.registerCommand('Tracing.getCategories', [], ['categories']);
  inspectorBackend.registerCommand(
      'Tracing.recordClockSyncMarker', [{'name': 'syncId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Tracing.requestMemoryDump',
      [
        {'name': 'deterministic', 'type': 'boolean', 'optional': true},
        {'name': 'levelOfDetail', 'type': 'string', 'optional': true}
      ],
      ['dumpGuid', 'success']);
  inspectorBackend.registerEnum(
      'Tracing.StartRequestTransferMode', {ReportEvents: 'ReportEvents', ReturnAsStream: 'ReturnAsStream'});
  inspectorBackend.registerCommand(
      'Tracing.start',
      [
        {'name': 'categories', 'type': 'string', 'optional': true},
        {'name': 'options', 'type': 'string', 'optional': true},
        {'name': 'bufferUsageReportingInterval', 'type': 'number', 'optional': true},
        {'name': 'transferMode', 'type': 'string', 'optional': true},
        {'name': 'streamFormat', 'type': 'string', 'optional': true},
        {'name': 'streamCompression', 'type': 'string', 'optional': true},
        {'name': 'traceConfig', 'type': 'object', 'optional': true},
        {'name': 'perfettoConfig', 'type': 'string', 'optional': true}
      ],
      []);

  // Fetch.
  inspectorBackend.registerEnum('Fetch.RequestStage', {Request: 'Request', Response: 'Response'});
  inspectorBackend.registerEnum('Fetch.AuthChallengeSource', {Server: 'Server', Proxy: 'Proxy'});
  inspectorBackend.registerEnum(
      'Fetch.AuthChallengeResponseResponse',
      {Default: 'Default', CancelAuth: 'CancelAuth', ProvideCredentials: 'ProvideCredentials'});
  inspectorBackend.registerEvent('Fetch.requestPaused', [
    'requestId', 'request', 'frameId', 'resourceType', 'responseErrorReason', 'responseStatusCode', 'responseHeaders',
    'networkId'
  ]);
  inspectorBackend.registerEvent(
      'Fetch.authRequired', ['requestId', 'request', 'frameId', 'resourceType', 'authChallenge']);
  inspectorBackend.registerCommand('Fetch.disable', [], []);
  inspectorBackend.registerCommand(
      'Fetch.enable',
      [
        {'name': 'patterns', 'type': 'object', 'optional': true},
        {'name': 'handleAuthRequests', 'type': 'boolean', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Fetch.failRequest',
      [
        {'name': 'requestId', 'type': 'string', 'optional': false},
        {'name': 'errorReason', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Fetch.fulfillRequest',
      [
        {'name': 'requestId', 'type': 'string', 'optional': false},
        {'name': 'responseCode', 'type': 'number', 'optional': false},
        {'name': 'responseHeaders', 'type': 'object', 'optional': true},
        {'name': 'binaryResponseHeaders', 'type': 'string', 'optional': true},
        {'name': 'body', 'type': 'string', 'optional': true},
        {'name': 'responsePhrase', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Fetch.continueRequest',
      [
        {'name': 'requestId', 'type': 'string', 'optional': false}, {'name': 'url', 'type': 'string', 'optional': true},
        {'name': 'method', 'type': 'string', 'optional': true},
        {'name': 'postData', 'type': 'string', 'optional': true},
        {'name': 'headers', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Fetch.continueWithAuth',
      [
        {'name': 'requestId', 'type': 'string', 'optional': false},
        {'name': 'authChallengeResponse', 'type': 'object', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Fetch.getResponseBody', [{'name': 'requestId', 'type': 'string', 'optional': false}], ['body', 'base64Encoded']);
  inspectorBackend.registerCommand(
      'Fetch.takeResponseBodyAsStream', [{'name': 'requestId', 'type': 'string', 'optional': false}], ['stream']);

  // WebAudio.
  inspectorBackend.registerEnum('WebAudio.ContextType', {Realtime: 'realtime', Offline: 'offline'});
  inspectorBackend.registerEnum(
      'WebAudio.ContextState', {Suspended: 'suspended', Running: 'running', Closed: 'closed'});
  inspectorBackend.registerEnum(
      'WebAudio.ChannelCountMode', {ClampedMax: 'clamped-max', Explicit: 'explicit', Max: 'max'});
  inspectorBackend.registerEnum('WebAudio.ChannelInterpretation', {Discrete: 'discrete', Speakers: 'speakers'});
  inspectorBackend.registerEnum('WebAudio.AutomationRate', {ARate: 'a-rate', KRate: 'k-rate'});
  inspectorBackend.registerEvent('WebAudio.contextCreated', ['context']);
  inspectorBackend.registerEvent('WebAudio.contextWillBeDestroyed', ['contextId']);
  inspectorBackend.registerEvent('WebAudio.contextChanged', ['context']);
  inspectorBackend.registerEvent('WebAudio.audioListenerCreated', ['listener']);
  inspectorBackend.registerEvent('WebAudio.audioListenerWillBeDestroyed', ['contextId', 'listenerId']);
  inspectorBackend.registerEvent('WebAudio.audioNodeCreated', ['node']);
  inspectorBackend.registerEvent('WebAudio.audioNodeWillBeDestroyed', ['contextId', 'nodeId']);
  inspectorBackend.registerEvent('WebAudio.audioParamCreated', ['param']);
  inspectorBackend.registerEvent('WebAudio.audioParamWillBeDestroyed', ['contextId', 'nodeId', 'paramId']);
  inspectorBackend.registerEvent(
      'WebAudio.nodesConnected',
      ['contextId', 'sourceId', 'destinationId', 'sourceOutputIndex', 'destinationInputIndex']);
  inspectorBackend.registerEvent(
      'WebAudio.nodesDisconnected',
      ['contextId', 'sourceId', 'destinationId', 'sourceOutputIndex', 'destinationInputIndex']);
  inspectorBackend.registerEvent(
      'WebAudio.nodeParamConnected', ['contextId', 'sourceId', 'destinationId', 'sourceOutputIndex']);
  inspectorBackend.registerEvent(
      'WebAudio.nodeParamDisconnected', ['contextId', 'sourceId', 'destinationId', 'sourceOutputIndex']);
  inspectorBackend.registerCommand('WebAudio.enable', [], []);
  inspectorBackend.registerCommand('WebAudio.disable', [], []);
  inspectorBackend.registerCommand(
      'WebAudio.getRealtimeData', [{'name': 'contextId', 'type': 'string', 'optional': false}], ['realtimeData']);

  // WebAuthn.
  inspectorBackend.registerEnum('WebAuthn.AuthenticatorProtocol', {U2f: 'u2f', Ctap2: 'ctap2'});
  inspectorBackend.registerEnum('WebAuthn.Ctap2Version', {Ctap2_0: 'ctap2_0', Ctap2_1: 'ctap2_1'});
  inspectorBackend.registerEnum(
      'WebAuthn.AuthenticatorTransport', {Usb: 'usb', Nfc: 'nfc', Ble: 'ble', Cable: 'cable', Internal: 'internal'});
  inspectorBackend.registerCommand('WebAuthn.enable', [], []);
  inspectorBackend.registerCommand('WebAuthn.disable', [], []);
  inspectorBackend.registerCommand(
      'WebAuthn.addVirtualAuthenticator', [{'name': 'options', 'type': 'object', 'optional': false}],
      ['authenticatorId']);
  inspectorBackend.registerCommand(
      'WebAuthn.removeVirtualAuthenticator', [{'name': 'authenticatorId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'WebAuthn.addCredential',
      [
        {'name': 'authenticatorId', 'type': 'string', 'optional': false},
        {'name': 'credential', 'type': 'object', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'WebAuthn.getCredential',
      [
        {'name': 'authenticatorId', 'type': 'string', 'optional': false},
        {'name': 'credentialId', 'type': 'string', 'optional': false}
      ],
      ['credential']);
  inspectorBackend.registerCommand(
      'WebAuthn.getCredentials', [{'name': 'authenticatorId', 'type': 'string', 'optional': false}], ['credentials']);
  inspectorBackend.registerCommand(
      'WebAuthn.removeCredential',
      [
        {'name': 'authenticatorId', 'type': 'string', 'optional': false},
        {'name': 'credentialId', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'WebAuthn.clearCredentials', [{'name': 'authenticatorId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'WebAuthn.setUserVerified',
      [
        {'name': 'authenticatorId', 'type': 'string', 'optional': false},
        {'name': 'isUserVerified', 'type': 'boolean', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'WebAuthn.setAutomaticPresenceSimulation',
      [
        {'name': 'authenticatorId', 'type': 'string', 'optional': false},
        {'name': 'enabled', 'type': 'boolean', 'optional': false}
      ],
      []);

  // Media.
  inspectorBackend.registerEnum(
      'Media.PlayerMessageLevel', {Error: 'error', Warning: 'warning', Info: 'info', Debug: 'debug'});
  inspectorBackend.registerEnum(
      'Media.PlayerErrorType', {Pipeline_error: 'pipeline_error', Media_error: 'media_error'});
  inspectorBackend.registerEvent('Media.playerPropertiesChanged', ['playerId', 'properties']);
  inspectorBackend.registerEvent('Media.playerEventsAdded', ['playerId', 'events']);
  inspectorBackend.registerEvent('Media.playerMessagesLogged', ['playerId', 'messages']);
  inspectorBackend.registerEvent('Media.playerErrorsRaised', ['playerId', 'errors']);
  inspectorBackend.registerEvent('Media.playersCreated', ['players']);
  inspectorBackend.registerCommand('Media.enable', [], []);
  inspectorBackend.registerCommand('Media.disable', [], []);

  // Debugger.
  inspectorBackend.registerEnum('Debugger.ScopeType', {
    Global: 'global',
    Local: 'local',
    With: 'with',
    Closure: 'closure',
    Catch: 'catch',
    Block: 'block',
    Script: 'script',
    Eval: 'eval',
    Module: 'module',
    WasmExpressionStack: 'wasm-expression-stack'
  });
  inspectorBackend.registerEnum(
      'Debugger.BreakLocationType', {DebuggerStatement: 'debuggerStatement', Call: 'call', Return: 'return'});
  inspectorBackend.registerEnum('Debugger.ScriptLanguage', {JavaScript: 'JavaScript', WebAssembly: 'WebAssembly'});
  inspectorBackend.registerEnum(
      'Debugger.DebugSymbolsType',
      {None: 'None', SourceMap: 'SourceMap', EmbeddedDWARF: 'EmbeddedDWARF', ExternalDWARF: 'ExternalDWARF'});
  inspectorBackend.registerEvent('Debugger.breakpointResolved', ['breakpointId', 'location']);
  inspectorBackend.registerEnum('Debugger.PausedEventReason', {
    Ambiguous: 'ambiguous',
    Assert: 'assert',
    CSPViolation: 'CSPViolation',
    DebugCommand: 'debugCommand',
    DOM: 'DOM',
    EventListener: 'EventListener',
    Exception: 'exception',
    Instrumentation: 'instrumentation',
    OOM: 'OOM',
    Other: 'other',
    PromiseRejection: 'promiseRejection',
    XHR: 'XHR'
  });
  inspectorBackend.registerEvent('Debugger.paused', [
    'callFrames', 'reason', 'data', 'hitBreakpoints', 'asyncStackTrace', 'asyncStackTraceId', 'asyncCallStackTraceId'
  ]);
  inspectorBackend.registerEvent('Debugger.resumed', []);
  inspectorBackend.registerEvent('Debugger.scriptFailedToParse', [
    'scriptId', 'url', 'startLine', 'startColumn', 'endLine', 'endColumn', 'executionContextId', 'hash',
    'executionContextAuxData', 'sourceMapURL', 'hasSourceURL', 'isModule', 'length', 'stackTrace', 'codeOffset',
    'scriptLanguage', 'embedderName'
  ]);
  inspectorBackend.registerEvent('Debugger.scriptParsed', [
    'scriptId', 'url', 'startLine', 'startColumn', 'endLine', 'endColumn', 'executionContextId', 'hash',
    'executionContextAuxData', 'isLiveEdit', 'sourceMapURL', 'hasSourceURL', 'isModule', 'length', 'stackTrace',
    'codeOffset', 'scriptLanguage', 'debugSymbols', 'embedderName'
  ]);
  inspectorBackend.registerEnum('Debugger.ContinueToLocationRequestTargetCallFrames', {Any: 'any', Current: 'current'});
  inspectorBackend.registerCommand(
      'Debugger.continueToLocation',
      [
        {'name': 'location', 'type': 'object', 'optional': false},
        {'name': 'targetCallFrames', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('Debugger.disable', [], []);
  inspectorBackend.registerCommand(
      'Debugger.enable', [{'name': 'maxScriptsCacheSize', 'type': 'number', 'optional': true}], ['debuggerId']);
  inspectorBackend.registerCommand(
      'Debugger.evaluateOnCallFrame',
      [
        {'name': 'callFrameId', 'type': 'string', 'optional': false},
        {'name': 'expression', 'type': 'string', 'optional': false},
        {'name': 'objectGroup', 'type': 'string', 'optional': true},
        {'name': 'includeCommandLineAPI', 'type': 'boolean', 'optional': true},
        {'name': 'silent', 'type': 'boolean', 'optional': true},
        {'name': 'returnByValue', 'type': 'boolean', 'optional': true},
        {'name': 'generatePreview', 'type': 'boolean', 'optional': true},
        {'name': 'throwOnSideEffect', 'type': 'boolean', 'optional': true},
        {'name': 'timeout', 'type': 'number', 'optional': true}
      ],
      ['result', 'exceptionDetails']);
  inspectorBackend.registerCommand(
      'Debugger.getPossibleBreakpoints',
      [
        {'name': 'start', 'type': 'object', 'optional': false}, {'name': 'end', 'type': 'object', 'optional': true},
        {'name': 'restrictToFunction', 'type': 'boolean', 'optional': true}
      ],
      ['locations']);
  inspectorBackend.registerCommand(
      'Debugger.getScriptSource', [{'name': 'scriptId', 'type': 'string', 'optional': false}],
      ['scriptSource', 'bytecode']);
  inspectorBackend.registerCommand(
      'Debugger.getWasmBytecode', [{'name': 'scriptId', 'type': 'string', 'optional': false}], ['bytecode']);
  inspectorBackend.registerCommand(
      'Debugger.getStackTrace', [{'name': 'stackTraceId', 'type': 'object', 'optional': false}], ['stackTrace']);
  inspectorBackend.registerCommand('Debugger.pause', [], []);
  inspectorBackend.registerCommand(
      'Debugger.pauseOnAsyncCall', [{'name': 'parentStackTraceId', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Debugger.removeBreakpoint', [{'name': 'breakpointId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Debugger.restartFrame', [{'name': 'callFrameId', 'type': 'string', 'optional': false}],
      ['callFrames', 'asyncStackTrace', 'asyncStackTraceId']);
  inspectorBackend.registerCommand(
      'Debugger.resume', [{'name': 'terminateOnResume', 'type': 'boolean', 'optional': true}], []);
  inspectorBackend.registerCommand(
      'Debugger.searchInContent',
      [
        {'name': 'scriptId', 'type': 'string', 'optional': false},
        {'name': 'query', 'type': 'string', 'optional': false},
        {'name': 'caseSensitive', 'type': 'boolean', 'optional': true},
        {'name': 'isRegex', 'type': 'boolean', 'optional': true}
      ],
      ['result']);
  inspectorBackend.registerCommand(
      'Debugger.setAsyncCallStackDepth', [{'name': 'maxDepth', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Debugger.setBlackboxPatterns', [{'name': 'patterns', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Debugger.setBlackboxedRanges',
      [
        {'name': 'scriptId', 'type': 'string', 'optional': false},
        {'name': 'positions', 'type': 'object', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Debugger.setBreakpoint',
      [
        {'name': 'location', 'type': 'object', 'optional': false},
        {'name': 'condition', 'type': 'string', 'optional': true}
      ],
      ['breakpointId', 'actualLocation']);
  inspectorBackend.registerEnum('Debugger.SetInstrumentationBreakpointRequestInstrumentation', {
    BeforeScriptExecution: 'beforeScriptExecution',
    BeforeScriptWithSourceMapExecution: 'beforeScriptWithSourceMapExecution'
  });
  inspectorBackend.registerCommand(
      'Debugger.setInstrumentationBreakpoint', [{'name': 'instrumentation', 'type': 'string', 'optional': false}],
      ['breakpointId']);
  inspectorBackend.registerCommand(
      'Debugger.setBreakpointByUrl',
      [
        {'name': 'lineNumber', 'type': 'number', 'optional': false},
        {'name': 'url', 'type': 'string', 'optional': true}, {'name': 'urlRegex', 'type': 'string', 'optional': true},
        {'name': 'scriptHash', 'type': 'string', 'optional': true},
        {'name': 'columnNumber', 'type': 'number', 'optional': true},
        {'name': 'condition', 'type': 'string', 'optional': true}
      ],
      ['breakpointId', 'locations']);
  inspectorBackend.registerCommand(
      'Debugger.setBreakpointOnFunctionCall',
      [
        {'name': 'objectId', 'type': 'string', 'optional': false},
        {'name': 'condition', 'type': 'string', 'optional': true}
      ],
      ['breakpointId']);
  inspectorBackend.registerCommand(
      'Debugger.setBreakpointsActive', [{'name': 'active', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerEnum(
      'Debugger.SetPauseOnExceptionsRequestState', {None: 'none', Uncaught: 'uncaught', All: 'all'});
  inspectorBackend.registerCommand(
      'Debugger.setPauseOnExceptions', [{'name': 'state', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Debugger.setReturnValue', [{'name': 'newValue', 'type': 'object', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Debugger.setScriptSource',
      [
        {'name': 'scriptId', 'type': 'string', 'optional': false},
        {'name': 'scriptSource', 'type': 'string', 'optional': false},
        {'name': 'dryRun', 'type': 'boolean', 'optional': true}
      ],
      ['callFrames', 'stackChanged', 'asyncStackTrace', 'asyncStackTraceId', 'exceptionDetails']);
  inspectorBackend.registerCommand(
      'Debugger.setSkipAllPauses', [{'name': 'skip', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Debugger.setVariableValue',
      [
        {'name': 'scopeNumber', 'type': 'number', 'optional': false},
        {'name': 'variableName', 'type': 'string', 'optional': false},
        {'name': 'newValue', 'type': 'object', 'optional': false},
        {'name': 'callFrameId', 'type': 'string', 'optional': false}
      ],
      []);
  inspectorBackend.registerCommand(
      'Debugger.stepInto',
      [
        {'name': 'breakOnAsyncCall', 'type': 'boolean', 'optional': true},
        {'name': 'skipList', 'type': 'object', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand('Debugger.stepOut', [], []);
  inspectorBackend.registerCommand('Debugger.stepOver', [{'name': 'skipList', 'type': 'object', 'optional': true}], []);

  // HeapProfiler.
  inspectorBackend.registerEvent('HeapProfiler.addHeapSnapshotChunk', ['chunk']);
  inspectorBackend.registerEvent('HeapProfiler.heapStatsUpdate', ['statsUpdate']);
  inspectorBackend.registerEvent('HeapProfiler.lastSeenObjectId', ['lastSeenObjectId', 'timestamp']);
  inspectorBackend.registerEvent('HeapProfiler.reportHeapSnapshotProgress', ['done', 'total', 'finished']);
  inspectorBackend.registerEvent('HeapProfiler.resetProfiles', []);
  inspectorBackend.registerCommand(
      'HeapProfiler.addInspectedHeapObject', [{'name': 'heapObjectId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand('HeapProfiler.collectGarbage', [], []);
  inspectorBackend.registerCommand('HeapProfiler.disable', [], []);
  inspectorBackend.registerCommand('HeapProfiler.enable', [], []);
  inspectorBackend.registerCommand(
      'HeapProfiler.getHeapObjectId', [{'name': 'objectId', 'type': 'string', 'optional': false}],
      ['heapSnapshotObjectId']);
  inspectorBackend.registerCommand(
      'HeapProfiler.getObjectByHeapObjectId',
      [
        {'name': 'objectId', 'type': 'string', 'optional': false},
        {'name': 'objectGroup', 'type': 'string', 'optional': true}
      ],
      ['result']);
  inspectorBackend.registerCommand('HeapProfiler.getSamplingProfile', [], ['profile']);
  inspectorBackend.registerCommand(
      'HeapProfiler.startSampling', [{'name': 'samplingInterval', 'type': 'number', 'optional': true}], []);
  inspectorBackend.registerCommand(
      'HeapProfiler.startTrackingHeapObjects', [{'name': 'trackAllocations', 'type': 'boolean', 'optional': true}], []);
  inspectorBackend.registerCommand('HeapProfiler.stopSampling', [], ['profile']);
  inspectorBackend.registerCommand(
      'HeapProfiler.stopTrackingHeapObjects',
      [
        {'name': 'reportProgress', 'type': 'boolean', 'optional': true},
        {'name': 'treatGlobalObjectsAsRoots', 'type': 'boolean', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'HeapProfiler.takeHeapSnapshot',
      [
        {'name': 'reportProgress', 'type': 'boolean', 'optional': true},
        {'name': 'treatGlobalObjectsAsRoots', 'type': 'boolean', 'optional': true}
      ],
      []);

  // Profiler.
  inspectorBackend.registerEvent('Profiler.consoleProfileFinished', ['id', 'location', 'profile', 'title']);
  inspectorBackend.registerEvent('Profiler.consoleProfileStarted', ['id', 'location', 'title']);
  inspectorBackend.registerEvent('Profiler.preciseCoverageDeltaUpdate', ['timestamp', 'occassion', 'result']);
  inspectorBackend.registerCommand('Profiler.disable', [], []);
  inspectorBackend.registerCommand('Profiler.enable', [], []);
  inspectorBackend.registerCommand('Profiler.getBestEffortCoverage', [], ['result']);
  inspectorBackend.registerCommand(
      'Profiler.setSamplingInterval', [{'name': 'interval', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand('Profiler.start', [], []);
  inspectorBackend.registerCommand(
      'Profiler.startPreciseCoverage',
      [
        {'name': 'callCount', 'type': 'boolean', 'optional': true},
        {'name': 'detailed', 'type': 'boolean', 'optional': true},
        {'name': 'allowTriggeredUpdates', 'type': 'boolean', 'optional': true}
      ],
      ['timestamp']);
  inspectorBackend.registerCommand('Profiler.startTypeProfile', [], []);
  inspectorBackend.registerCommand('Profiler.stop', [], ['profile']);
  inspectorBackend.registerCommand('Profiler.stopPreciseCoverage', [], []);
  inspectorBackend.registerCommand('Profiler.stopTypeProfile', [], []);
  inspectorBackend.registerCommand('Profiler.takePreciseCoverage', [], ['result', 'timestamp']);
  inspectorBackend.registerCommand('Profiler.takeTypeProfile', [], ['result']);
  inspectorBackend.registerCommand('Profiler.enableCounters', [], []);
  inspectorBackend.registerCommand('Profiler.disableCounters', [], []);
  inspectorBackend.registerCommand('Profiler.getCounters', [], ['result']);
  inspectorBackend.registerCommand('Profiler.enableRuntimeCallStats', [], []);
  inspectorBackend.registerCommand('Profiler.disableRuntimeCallStats', [], []);
  inspectorBackend.registerCommand('Profiler.getRuntimeCallStats', [], ['result']);

  // Runtime.
  inspectorBackend.registerEnum('Runtime.RemoteObjectType', {
    Object: 'object',
    Function: 'function',
    Undefined: 'undefined',
    String: 'string',
    Number: 'number',
    Boolean: 'boolean',
    Symbol: 'symbol',
    Bigint: 'bigint'
  });
  inspectorBackend.registerEnum('Runtime.RemoteObjectSubtype', {
    Array: 'array',
    Null: 'null',
    Node: 'node',
    Regexp: 'regexp',
    Date: 'date',
    Map: 'map',
    Set: 'set',
    Weakmap: 'weakmap',
    Weakset: 'weakset',
    Iterator: 'iterator',
    Generator: 'generator',
    Error: 'error',
    Proxy: 'proxy',
    Promise: 'promise',
    Typedarray: 'typedarray',
    Arraybuffer: 'arraybuffer',
    Dataview: 'dataview',
    Webassemblymemory: 'webassemblymemory',
    Wasmvalue: 'wasmvalue'
  });
  inspectorBackend.registerEnum('Runtime.ObjectPreviewType', {
    Object: 'object',
    Function: 'function',
    Undefined: 'undefined',
    String: 'string',
    Number: 'number',
    Boolean: 'boolean',
    Symbol: 'symbol',
    Bigint: 'bigint'
  });
  inspectorBackend.registerEnum('Runtime.ObjectPreviewSubtype', {
    Array: 'array',
    Null: 'null',
    Node: 'node',
    Regexp: 'regexp',
    Date: 'date',
    Map: 'map',
    Set: 'set',
    Weakmap: 'weakmap',
    Weakset: 'weakset',
    Iterator: 'iterator',
    Generator: 'generator',
    Error: 'error',
    Proxy: 'proxy',
    Promise: 'promise',
    Typedarray: 'typedarray',
    Arraybuffer: 'arraybuffer',
    Dataview: 'dataview',
    Webassemblymemory: 'webassemblymemory',
    Wasmvalue: 'wasmvalue'
  });
  inspectorBackend.registerEnum('Runtime.PropertyPreviewType', {
    Object: 'object',
    Function: 'function',
    Undefined: 'undefined',
    String: 'string',
    Number: 'number',
    Boolean: 'boolean',
    Symbol: 'symbol',
    Accessor: 'accessor',
    Bigint: 'bigint'
  });
  inspectorBackend.registerEnum('Runtime.PropertyPreviewSubtype', {
    Array: 'array',
    Null: 'null',
    Node: 'node',
    Regexp: 'regexp',
    Date: 'date',
    Map: 'map',
    Set: 'set',
    Weakmap: 'weakmap',
    Weakset: 'weakset',
    Iterator: 'iterator',
    Generator: 'generator',
    Error: 'error',
    Proxy: 'proxy',
    Promise: 'promise',
    Typedarray: 'typedarray',
    Arraybuffer: 'arraybuffer',
    Dataview: 'dataview',
    Webassemblymemory: 'webassemblymemory',
    Wasmvalue: 'wasmvalue'
  });
  inspectorBackend.registerEvent('Runtime.bindingCalled', ['name', 'payload', 'executionContextId']);
  inspectorBackend.registerEnum('Runtime.ConsoleAPICalledEventType', {
    Log: 'log',
    Debug: 'debug',
    Info: 'info',
    Error: 'error',
    Warning: 'warning',
    Dir: 'dir',
    DirXML: 'dirxml',
    Table: 'table',
    Trace: 'trace',
    Clear: 'clear',
    StartGroup: 'startGroup',
    StartGroupCollapsed: 'startGroupCollapsed',
    EndGroup: 'endGroup',
    Assert: 'assert',
    Profile: 'profile',
    ProfileEnd: 'profileEnd',
    Count: 'count',
    TimeEnd: 'timeEnd'
  });
  inspectorBackend.registerEvent(
      'Runtime.consoleAPICalled', ['type', 'args', 'executionContextId', 'timestamp', 'stackTrace', 'context']);
  inspectorBackend.registerEvent('Runtime.exceptionRevoked', ['reason', 'exceptionId']);
  inspectorBackend.registerEvent('Runtime.exceptionThrown', ['timestamp', 'exceptionDetails']);
  inspectorBackend.registerEvent('Runtime.executionContextCreated', ['context']);
  inspectorBackend.registerEvent('Runtime.executionContextDestroyed', ['executionContextId']);
  inspectorBackend.registerEvent('Runtime.executionContextsCleared', []);
  inspectorBackend.registerEvent('Runtime.inspectRequested', ['object', 'hints']);
  inspectorBackend.registerCommand(
      'Runtime.awaitPromise',
      [
        {'name': 'promiseObjectId', 'type': 'string', 'optional': false},
        {'name': 'returnByValue', 'type': 'boolean', 'optional': true},
        {'name': 'generatePreview', 'type': 'boolean', 'optional': true}
      ],
      ['result', 'exceptionDetails']);
  inspectorBackend.registerCommand(
      'Runtime.callFunctionOn',
      [
        {'name': 'functionDeclaration', 'type': 'string', 'optional': false},
        {'name': 'objectId', 'type': 'string', 'optional': true},
        {'name': 'arguments', 'type': 'object', 'optional': true},
        {'name': 'silent', 'type': 'boolean', 'optional': true},
        {'name': 'returnByValue', 'type': 'boolean', 'optional': true},
        {'name': 'generatePreview', 'type': 'boolean', 'optional': true},
        {'name': 'userGesture', 'type': 'boolean', 'optional': true},
        {'name': 'awaitPromise', 'type': 'boolean', 'optional': true},
        {'name': 'executionContextId', 'type': 'number', 'optional': true},
        {'name': 'objectGroup', 'type': 'string', 'optional': true}
      ],
      ['result', 'exceptionDetails']);
  inspectorBackend.registerCommand(
      'Runtime.compileScript',
      [
        {'name': 'expression', 'type': 'string', 'optional': false},
        {'name': 'sourceURL', 'type': 'string', 'optional': false},
        {'name': 'persistScript', 'type': 'boolean', 'optional': false},
        {'name': 'executionContextId', 'type': 'number', 'optional': true}
      ],
      ['scriptId', 'exceptionDetails']);
  inspectorBackend.registerCommand('Runtime.disable', [], []);
  inspectorBackend.registerCommand('Runtime.discardConsoleEntries', [], []);
  inspectorBackend.registerCommand('Runtime.enable', [], []);
  inspectorBackend.registerCommand(
      'Runtime.evaluate',
      [
        {'name': 'expression', 'type': 'string', 'optional': false},
        {'name': 'objectGroup', 'type': 'string', 'optional': true},
        {'name': 'includeCommandLineAPI', 'type': 'boolean', 'optional': true},
        {'name': 'silent', 'type': 'boolean', 'optional': true},
        {'name': 'contextId', 'type': 'number', 'optional': true},
        {'name': 'returnByValue', 'type': 'boolean', 'optional': true},
        {'name': 'generatePreview', 'type': 'boolean', 'optional': true},
        {'name': 'userGesture', 'type': 'boolean', 'optional': true},
        {'name': 'awaitPromise', 'type': 'boolean', 'optional': true},
        {'name': 'throwOnSideEffect', 'type': 'boolean', 'optional': true},
        {'name': 'timeout', 'type': 'number', 'optional': true},
        {'name': 'disableBreaks', 'type': 'boolean', 'optional': true},
        {'name': 'replMode', 'type': 'boolean', 'optional': true},
        {'name': 'allowUnsafeEvalBlockedByCSP', 'type': 'boolean', 'optional': true},
        {'name': 'uniqueContextId', 'type': 'string', 'optional': true}
      ],
      ['result', 'exceptionDetails']);
  inspectorBackend.registerCommand('Runtime.getIsolateId', [], ['id']);
  inspectorBackend.registerCommand('Runtime.getHeapUsage', [], ['usedSize', 'totalSize']);
  inspectorBackend.registerCommand(
      'Runtime.getProperties',
      [
        {'name': 'objectId', 'type': 'string', 'optional': false},
        {'name': 'ownProperties', 'type': 'boolean', 'optional': true},
        {'name': 'accessorPropertiesOnly', 'type': 'boolean', 'optional': true},
        {'name': 'generatePreview', 'type': 'boolean', 'optional': true}
      ],
      ['result', 'internalProperties', 'privateProperties', 'exceptionDetails']);
  inspectorBackend.registerCommand(
      'Runtime.globalLexicalScopeNames', [{'name': 'executionContextId', 'type': 'number', 'optional': true}],
      ['names']);
  inspectorBackend.registerCommand(
      'Runtime.queryObjects',
      [
        {'name': 'prototypeObjectId', 'type': 'string', 'optional': false},
        {'name': 'objectGroup', 'type': 'string', 'optional': true}
      ],
      ['objects']);
  inspectorBackend.registerCommand(
      'Runtime.releaseObject', [{'name': 'objectId', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Runtime.releaseObjectGroup', [{'name': 'objectGroup', 'type': 'string', 'optional': false}], []);
  inspectorBackend.registerCommand('Runtime.runIfWaitingForDebugger', [], []);
  inspectorBackend.registerCommand(
      'Runtime.runScript',
      [
        {'name': 'scriptId', 'type': 'string', 'optional': false},
        {'name': 'executionContextId', 'type': 'number', 'optional': true},
        {'name': 'objectGroup', 'type': 'string', 'optional': true},
        {'name': 'silent', 'type': 'boolean', 'optional': true},
        {'name': 'includeCommandLineAPI', 'type': 'boolean', 'optional': true},
        {'name': 'returnByValue', 'type': 'boolean', 'optional': true},
        {'name': 'generatePreview', 'type': 'boolean', 'optional': true},
        {'name': 'awaitPromise', 'type': 'boolean', 'optional': true}
      ],
      ['result', 'exceptionDetails']);
  inspectorBackend.registerCommand(
      'Runtime.setAsyncCallStackDepth', [{'name': 'maxDepth', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Runtime.setCustomObjectFormatterEnabled', [{'name': 'enabled', 'type': 'boolean', 'optional': false}], []);
  inspectorBackend.registerCommand(
      'Runtime.setMaxCallStackSizeToCapture', [{'name': 'size', 'type': 'number', 'optional': false}], []);
  inspectorBackend.registerCommand('Runtime.terminateExecution', [], []);
  inspectorBackend.registerCommand(
      'Runtime.addBinding',
      [
        {'name': 'name', 'type': 'string', 'optional': false},
        {'name': 'executionContextId', 'type': 'number', 'optional': true},
        {'name': 'executionContextName', 'type': 'string', 'optional': true}
      ],
      []);
  inspectorBackend.registerCommand(
      'Runtime.removeBinding', [{'name': 'name', 'type': 'string', 'optional': false}], []);

  // Schema.
  inspectorBackend.registerCommand('Schema.getDomains', [], ['domains']);
}
