// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.

/** @fileoverview Interface for settingsPrivate that can be overriden. */

/** @interface */
function SettingsPrivate() {}

SettingsPrivate.prototype = {
  /**
   * Sets a settings value.
   * @param {string} name The name of the pref.
   * @param {*} value The new value of the pref.
   * @param {string} pageId The user metrics identifier or null.
   * @param {function(boolean):void} callback The callback for whether the pref
   *     was set or not.
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-setPref
   */
  setPref: function(name, value, pageId, callback) {},

  /**
   * Gets an array of all the prefs.
   * @param {function(!Array<!chrome.settingsPrivate.PrefObject>):void} callback
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-getAllPrefs
   */
  getAllPrefs: function(callback) {},

  /**
   * Gets the value of a specific pref.
   * @param {string} name
   * @param {function(!chrome.settingsPrivate.PrefObject):void} callback
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-getPref
   */
  getPref: function(name, callback) {},

  /**
   * Gets the default page zoom factor. Possible values are currently between
   * 0.25 and 5. For a full list, see zoom::kPresetZoomFactors.
   * @param {function(number):void} callback
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-getDefaultZoom
   */
  getDefaultZoom: function(callback) {},

  /**
   * Sets the page zoom factor. Must be less than 0.001 different than a value
   * in zoom::kPresetZoomFactors.
   * @param {number} zoom
   * @param {function(boolean):void=} callback
   * @see https://developer.chrome.com/extensions/settingsPrivate#method-setDefaultZoom
   */
  setDefaultZoom: function(zoom, callback) {},
};

/**
 * <p>Fired when a set of prefs has changed.</p><p>|prefs| The prefs that
 * changed.</p>
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/settingsPrivate#event-onPrefsChanged
 */
SettingsPrivate.prototype.onPrefsChanged;
