// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   ./tools/json_schema_compiler/compiler.py.

/** @fileoverview Interface for bluetoothPrivate that can be overriden. */

/** @interface */
function BluetoothPrivate() {}

BluetoothPrivate.prototype = {
  /**
   * Changes the state of the Bluetooth adapter.
   * @param {!chrome.bluetoothPrivate.NewAdapterState} adapterState The new
   *     state of the adapter.
   * @param {function(): void=} callback Called when all the state changes have
   *     been completed.
   */
  setAdapterState: function(adapterState, callback) {},

  /**
   * @param {!chrome.bluetoothPrivate.SetPairingResponseOptions} options
   * @param {function(): void=} callback
   */
  setPairingResponse: function(options, callback) {},

  /**
   * Tears down all connections to the given device.
   * @param {string} deviceAddress
   * @param {function(): void=} callback
   */
  disconnectAll: function(deviceAddress, callback) {},

  /**
   * Forgets the given device.
   * @param {string} deviceAddress
   * @param {function(): void=} callback
   */
  forgetDevice: function(deviceAddress, callback) {},

  /**
   * Set or clear discovery filter.
   * @param {!chrome.bluetoothPrivate.DiscoveryFilter} discoveryFilter
   * @param {function(): void=} callback
   */
  setDiscoveryFilter: function(discoveryFilter, callback) {},

  /**
   * Connects to the given device. This will only throw an error if the device
   * address is invalid or the device is already connected. Otherwise this will
   * succeed and invoke |callback| with ConnectResultType.
   * @param {string} deviceAddress
   * @param {function(!chrome.bluetoothPrivate.ConnectResultType): void=}
   *     callback
   */
  connect: function(deviceAddress, callback) {},

  /**
   * Pairs the given device.
   * @param {string} deviceAddress
   * @param {function(): void=} callback
   */
  pair: function(deviceAddress, callback) {},

  /**
   * Record that a pairing attempt finished. Ignores cancellations.
   * @param {!chrome.bluetoothPrivate.TransportType} transport
   * @param {number} pairingDurationMs
   * @param {!chrome.bluetoothPrivate.ConnectResultType=} result
   */
  recordPairing: function(transport, pairingDurationMs, result) {},

  /**
   * Record that a user-initiated reconnection attempt to an already paired
   * device finished. Ignores cancellations.
   * @param {!chrome.bluetoothPrivate.ConnectResultType=} result
   */
  recordReconnection: function(result) {},

  /**
   * Record that a user selected a device to connect to.
   * @param {number} selectionDurationMs
   * @param {boolean} wasPaired
   * @param {!chrome.bluetoothPrivate.TransportType} transport
   */
  recordDeviceSelection: function(selectionDurationMs, wasPaired, transport) {},
};

/**
 * Fired when a pairing event occurs.
 * @type {!ChromeEvent}
 */
BluetoothPrivate.prototype.onPairing;

/**
 * Fired when a Bluetooth device changed its address.
 * @type {!ChromeEvent}
 */
BluetoothPrivate.prototype.onDeviceAddressChanged;
