// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.usersPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: usersPrivate */

/** @const */
chrome.usersPrivate = {};

/**
 * @typedef {{
 *   email: string,
 *   displayEmail: string,
 *   name: string,
 *   isOwner: boolean,
 *   isSupervised: boolean,
 *   isChild: boolean
 * }}
 */
chrome.usersPrivate.User;

/**
 * @typedef {{
 *   isLoggedIn: boolean,
 *   isScreenLocked: boolean
 * }}
 */
chrome.usersPrivate.LoginStatusDict;

/**
 * Gets a list of known users.
 * @param {function(!Array<!chrome.usersPrivate.User>): void} callback
 */
chrome.usersPrivate.getUsers = function(callback) {};

/**
 * Checks to see if the user is already present in the user list.
 * @param {string} email
 * @param {function(boolean): void} callback
 */
chrome.usersPrivate.isUserInList = function(email, callback) {};

/**
 * Adds a new user with the given email to the user list. The callback is called
 * with true if the user was added succesfully, or with false if not (e.g.
 * because the user was already present, or the current user isn't the owner).
 * @param {string} email
 * @param {function(boolean): void} callback
 */
chrome.usersPrivate.addUser = function(email, callback) {};

/**
 * Removes the user with the given email from the user list. The callback is
 * called with true if the user was removed succesfully, or with false if not
 * (e.g. because the user was not already present, or the current user isn't the
 * owner).
 * @param {string} email
 * @param {function(boolean): void} callback
 */
chrome.usersPrivate.removeUser = function(email, callback) {};

/**
 * Whether the user list is managed by enterprise.
 * @param {function(boolean): void} callback
 */
chrome.usersPrivate.isUserListManaged = function(callback) {};

/**
 * Returns the current user.
 * @param {function(!chrome.usersPrivate.User): void} callback
 */
chrome.usersPrivate.getCurrentUser = function(callback) {};

/**
 * Get login status.
 * @param {function(!chrome.usersPrivate.LoginStatusDict): void} callback
 */
chrome.usersPrivate.getLoginStatus = function(callback) {};
