// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.tts.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: tts */

/** @const */
chrome.tts = {};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/tts#type-EventType
 */
chrome.tts.EventType = {
  START: 'start',
  END: 'end',
  WORD: 'word',
  SENTENCE: 'sentence',
  MARKER: 'marker',
  INTERRUPTED: 'interrupted',
  CANCELLED: 'cancelled',
  ERROR: 'error',
  PAUSE: 'pause',
  RESUME: 'resume',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/tts#type-VoiceGender
 */
chrome.tts.VoiceGender = {
  MALE: 'male',
  FEMALE: 'female',
};

/**
 * The speech options for the TTS engine.
 * @constructor
 * @private
 * @see https://developer.chrome.com/extensions/tts#type-TtsOptions
 */
chrome.tts.TtsOptions = function() {};

/**
 * If true, enqueues this utterance if TTS is already in progress. If false (the default), interrupts any current speech and flushes the speech queue before speaking this new utterance.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-enqueue
 */
chrome.tts.TtsOptions.prototype.enqueue;

/**
 * The name of the voice to use for synthesis. If empty, uses any available voice.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-voiceName
 */
chrome.tts.TtsOptions.prototype.voiceName;

/**
 * The extension ID of the speech engine to use, if known.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-extensionId
 */
chrome.tts.TtsOptions.prototype.extensionId;

/**
 * The language to be used for synthesis, in the form <em>language</em>-<em>region</em>. Examples: 'en', 'en-US', 'en-GB', 'zh-CN'.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-lang
 */
chrome.tts.TtsOptions.prototype.lang;

/**
 * Gender of voice for synthesized speech.
 * @type {(!chrome.tts.VoiceGender|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-gender
 */
chrome.tts.TtsOptions.prototype.gender;

/**
 * Speaking rate relative to the default rate for this voice. 1.0 is the default rate, normally around 180 to 220 words per minute. 2.0 is twice as fast, and 0.5 is half as fast. Values below 0.1 or above 10.0 are strictly disallowed, but many voices will constrain the minimum and maximum rates further&mdash;for example a particular voice may not actually speak faster than 3 times normal even if you specify a value larger than 3.0.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-rate
 */
chrome.tts.TtsOptions.prototype.rate;

/**
 * Speaking pitch between 0 and 2 inclusive, with 0 being lowest and 2 being highest. 1.0 corresponds to a voice's default pitch.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-pitch
 */
chrome.tts.TtsOptions.prototype.pitch;

/**
 * Speaking volume between 0 and 1 inclusive, with 0 being lowest and 1 being highest, with a default of 1.0.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-volume
 */
chrome.tts.TtsOptions.prototype.volume;

/**
 * The TTS event types the voice must support.
 * @type {(!Array<string>|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-requiredEventTypes
 */
chrome.tts.TtsOptions.prototype.requiredEventTypes;

/**
 * The TTS event types that you are interested in listening to. If missing, all event types may be sent.
 * @type {(!Array<string>|undefined)}
 * @see https://developer.chrome.com/extensions/tts#type-desiredEventTypes
 */
chrome.tts.TtsOptions.prototype.desiredEventTypes;

/**
 * This function is called with events that occur in the process of speaking the
 * utterance.
 * @param {!chrome.tts.TtsEvent} event The update event from the text-to-speech
 *     engine indicating the status of this utterance.
 * @see https://developer.chrome.com/extensions/tts#method-onEvent
 */
chrome.tts.TtsOptions.prototype.onEvent = function(event) {};


/**
 * An event from the TTS engine to communicate the status of an utterance.
 * @typedef {{
 *   type: !chrome.tts.EventType,
 *   charIndex: (number|undefined),
 *   errorMessage: (string|undefined),
 *   srcId: (number|undefined),
 *   isFinalEvent: (boolean|undefined),
 *   length: (number|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/tts#type-TtsEvent
 */
chrome.tts.TtsEvent;

/**
 * A description of a voice available for speech synthesis.
 * @typedef {{
 *   voiceName: (string|undefined),
 *   lang: (string|undefined),
 *   gender: (!chrome.tts.VoiceGender|undefined),
 *   remote: (boolean|undefined),
 *   extensionId: (string|undefined),
 *   eventTypes: (!Array<!chrome.tts.EventType>|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/tts#type-TtsVoice
 */
chrome.tts.TtsVoice;

/**
 * Speaks text using a text-to-speech engine.
 * @param {string} utterance The text to speak, either plain text or a complete,
 *     well-formed SSML document. Speech engines that do not support SSML will
 *     strip away the tags and speak the text. The maximum length of the text is
 *     32,768 characters.
 * @param {!chrome.tts.TtsOptions=} options The speech options.
 * @param {function(): void=} callback Called right away, before speech
 *     finishes. Check $(ref:runtime.lastError) to make sure there were no
 *     errors. Use options.onEvent to get more detailed feedback.
 * @see https://developer.chrome.com/extensions/tts#method-speak
 */
chrome.tts.speak = function(utterance, options, callback) {};

/**
 * Stops any current speech and flushes the queue of any pending utterances. In
 * addition, if speech was paused, it will now be un-paused for the next call to
 * speak.
 * @see https://developer.chrome.com/extensions/tts#method-stop
 */
chrome.tts.stop = function() {};

/**
 * Pauses speech synthesis, potentially in the middle of an utterance. A call to
 * resume or stop will un-pause speech.
 * @see https://developer.chrome.com/extensions/tts#method-pause
 */
chrome.tts.pause = function() {};

/**
 * If speech was paused, resumes speaking where it left off.
 * @see https://developer.chrome.com/extensions/tts#method-resume
 */
chrome.tts.resume = function() {};

/**
 * Checks whether the engine is currently speaking. On Mac OS X, the result is
 * true whenever the system speech engine is speaking, even if the speech wasn't
 * initiated by Chrome.
 * @param {function(boolean): void=} callback
 * @see https://developer.chrome.com/extensions/tts#method-isSpeaking
 */
chrome.tts.isSpeaking = function(callback) {};

/**
 * Gets an array of all available voices.
 * @param {function(!Array<!chrome.tts.TtsVoice>): void=} callback
 * @see https://developer.chrome.com/extensions/tts#method-getVoices
 */
chrome.tts.getVoices = function(callback) {};

/**
 * Used to pass events back to the function calling speak().
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tts#event-onEvent
 */
chrome.tts.onEvent;
