// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.tabs.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

// IMPORTANT NOTE: Work-around for crbug.com/543822
// s/chrome.tabs.extensionTypes.ImageDetails/chrome.extensionTypes.ImageDetails/
// s/chrome.tabs.extensionTypes.InjectDetails/chrome.extensionTypes.InjectDetails/
// s/chrome.tabs.runtime.Port/chrome.runtime.Port/
// s/chrome.tabs.windows.Window/chrome.windows.Window/

/** @fileoverview Externs generated from namespace: tabs */

/** @const */
chrome.tabs = {};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/tabs#type-TabStatus
 */
chrome.tabs.TabStatus = {
  UNLOADED: 'unloaded',
  LOADING: 'loading',
  COMPLETE: 'complete',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/tabs#type-MutedInfoReason
 */
chrome.tabs.MutedInfoReason = {
  USER: 'user',
  CAPTURE: 'capture',
  EXTENSION: 'extension',
};

/**
 * The tab's muted state and the reason for the last state change.
 * @typedef {{
 *   muted: boolean,
 *   reason: (!chrome.tabs.MutedInfoReason|undefined),
 *   extensionId: (string|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/tabs#type-MutedInfo
 */
chrome.tabs.MutedInfo;

/**
 * @typedef {{
 *   id: (number|undefined),
 *   index: number,
 *   groupId: number,
 *   windowId: number,
 *   openerTabId: (number|undefined),
 *   selected: boolean,
 *   highlighted: boolean,
 *   active: boolean,
 *   pinned: boolean,
 *   audible: (boolean|undefined),
 *   discarded: boolean,
 *   autoDiscardable: boolean,
 *   mutedInfo: (!chrome.tabs.MutedInfo|undefined),
 *   url: (string|undefined),
 *   pendingUrl: (string|undefined),
 *   title: (string|undefined),
 *   favIconUrl: (string|undefined),
 *   status: (!chrome.tabs.TabStatus|undefined),
 *   incognito: boolean,
 *   width: (number|undefined),
 *   height: (number|undefined),
 *   sessionId: (string|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/tabs#type-Tab
 */
chrome.tabs.Tab;

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/tabs#type-ZoomSettingsMode
 */
chrome.tabs.ZoomSettingsMode = {
  AUTOMATIC: 'automatic',
  MANUAL: 'manual',
  DISABLED: 'disabled',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/tabs#type-ZoomSettingsScope
 */
chrome.tabs.ZoomSettingsScope = {
  PER_ORIGIN: 'per-origin',
  PER_TAB: 'per-tab',
};

/**
 * Defines how zoom changes in a tab are handled and at what scope.
 * @typedef {{
 *   mode: (!chrome.tabs.ZoomSettingsMode|undefined),
 *   scope: (!chrome.tabs.ZoomSettingsScope|undefined),
 *   defaultZoomFactor: (number|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/tabs#type-ZoomSettings
 */
chrome.tabs.ZoomSettings;

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/tabs#type-WindowType
 */
chrome.tabs.WindowType = {
  NORMAL: 'normal',
  POPUP: 'popup',
  PANEL: 'panel',
  APP: 'app',
  DEVTOOLS: 'devtools',
};

/**
 * An ID that represents the absence of a browser tab.
 * @type {number}
 * @see https://developer.chrome.com/extensions/tabs#type-TAB_ID_NONE
 */
chrome.tabs.TAB_ID_NONE;

/**
 * Retrieves details about the specified tab.
 * @param {number} tabId
 * @param {function(!chrome.tabs.Tab): void} callback
 * @see https://developer.chrome.com/extensions/tabs#method-get
 */
chrome.tabs.get = function(tabId, callback) {};

/**
 * Gets the tab that this script call is being made from. May be undefined if
 * called from a non-tab context (for example, a background page or popup view).
 * @param {function((!chrome.tabs.Tab|undefined)): void} callback
 * @see https://developer.chrome.com/extensions/tabs#method-getCurrent
 */
chrome.tabs.getCurrent = function(callback) {};

/**
 * Connects to the content script(s) in the specified tab. The
 * $(ref:runtime.onConnect) event is fired in each content script running in the
 * specified tab for the current extension. For more details, see <a
 * href='messaging'>Content Script Messaging</a>.
 * @param {number} tabId
 * @param {{
 *   name: (string|undefined),
 *   frameId: (number|undefined)
 * }=} connectInfo
 * @return {!chrome.runtime.Port} A port that can be used to communicate
 *     with the content scripts running in the specified tab. The port's
 *     $(ref:runtime.Port) event is fired if the tab closes or does not exist.
 * @see https://developer.chrome.com/extensions/tabs#method-connect
 */
chrome.tabs.connect = function(tabId, connectInfo) {};

/**
 * Sends a single request to the content script(s) in the specified tab, with an
 * optional callback to run when a response is sent back.  The
 * $(ref:extension.onRequest) event is fired in each content script running in
 * the specified tab for the current extension.
 * @param {number} tabId
 * @param {*} request
 * @param {function(*): void=} responseCallback
 * @deprecated Please use $(ref:runtime.sendMessage).
 * @see https://developer.chrome.com/extensions/tabs#method-sendRequest
 */
chrome.tabs.sendRequest = function(tabId, request, responseCallback) {};

/**
 * Sends a single message to the content script(s) in the specified tab, with an
 * optional callback to run when a response is sent back.  The
 * $(ref:runtime.onMessage) event is fired in each content script running in the
 * specified tab for the current extension.
 * @param {number} tabId
 * @param {*} message The message to send. This message should be a JSON-ifiable
 *     object.
 * @param {{
 *   frameId: (number|undefined)
 * }=} options
 * @param {function(*): void=} responseCallback
 * @see https://developer.chrome.com/extensions/tabs#method-sendMessage
 */
chrome.tabs.sendMessage = function(tabId, message, options, responseCallback) {};

/**
 * Gets the tab that is selected in the specified window.
 * @param {?number|undefined} windowId Defaults to the <a
 *     href='windows#current-window'>current window</a>.
 * @param {function(!chrome.tabs.Tab): void} callback
 * @deprecated Please use $(ref:tabs.query) <code>{active: true}</code>.
 * @see https://developer.chrome.com/extensions/tabs#method-getSelected
 */
chrome.tabs.getSelected = function(windowId, callback) {};

/**
 * Gets details about all tabs in the specified window.
 * @param {?number|undefined} windowId Defaults to the <a
 *     href='windows#current-window'>current window</a>.
 * @param {function(!Array<!chrome.tabs.Tab>): void} callback
 * @deprecated Please use $(ref:tabs.query) <code>{windowId: windowId}</code>.
 * @see https://developer.chrome.com/extensions/tabs#method-getAllInWindow
 */
chrome.tabs.getAllInWindow = function(windowId, callback) {};

/**
 * Creates a new tab.
 * @param {{
 *   windowId: (number|undefined),
 *   index: (number|undefined),
 *   url: (string|undefined),
 *   active: (boolean|undefined),
 *   selected: (boolean|undefined),
 *   pinned: (boolean|undefined),
 *   openerTabId: (number|undefined)
 * }} createProperties
 * @param {function(!chrome.tabs.Tab): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-create
 */
chrome.tabs.create = function(createProperties, callback) {};

/**
 * Duplicates a tab.
 * @param {number} tabId The ID of the tab to duplicate.
 * @param {function((!chrome.tabs.Tab|undefined)): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-duplicate
 */
chrome.tabs.duplicate = function(tabId, callback) {};

/**
 * Gets all tabs that have the specified properties, or all tabs if no
 * properties are specified.
 * @param {{
 *   active: (boolean|undefined),
 *   pinned: (boolean|undefined),
 *   audible: (boolean|undefined),
 *   muted: (boolean|undefined),
 *   highlighted: (boolean|undefined),
 *   discarded: (boolean|undefined),
 *   autoDiscardable: (boolean|undefined),
 *   currentWindow: (boolean|undefined),
 *   lastFocusedWindow: (boolean|undefined),
 *   status: (!chrome.tabs.TabStatus|undefined),
 *   title: (string|undefined),
 *   url: ((string|!Array<string>)|undefined),
 *   groupId: (number|undefined),
 *   windowId: (number|undefined),
 *   windowType: (!chrome.tabs.WindowType|undefined),
 *   index: (number|undefined)
 * }} queryInfo
 * @param {function(!Array<!chrome.tabs.Tab>): void} callback
 * @see https://developer.chrome.com/extensions/tabs#method-query
 */
chrome.tabs.query = function(queryInfo, callback) {};

/**
 * Highlights the given tabs and focuses on the first of group. Will appear to
 * do nothing if the specified tab is currently active.
 * @param {{
 *   windowId: (number|undefined),
 *   tabs: (!Array<number>|number)
 * }} highlightInfo
 * @param {function(!chrome.windows.Window): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-highlight
 */
chrome.tabs.highlight = function(highlightInfo, callback) {};

/**
 * Modifies the properties of a tab. Properties that are not specified in
 * <var>updateProperties</var> are not modified.
 * @param {?number|undefined} tabId Defaults to the selected tab of the <a
 *     href='windows#current-window'>current window</a>.
 * @param {{
 *   url: (string|undefined),
 *   active: (boolean|undefined),
 *   highlighted: (boolean|undefined),
 *   selected: (boolean|undefined),
 *   pinned: (boolean|undefined),
 *   muted: (boolean|undefined),
 *   openerTabId: (number|undefined),
 *   autoDiscardable: (boolean|undefined)
 * }} updateProperties
 * @param {function((!chrome.tabs.Tab|undefined)): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-update
 */
chrome.tabs.update = function(tabId, updateProperties, callback) {};

/**
 * Moves one or more tabs to a new position within its window, or to a new
 * window. Note that tabs can only be moved to and from normal (window.type ===
 * "normal") windows.
 * @param {(number|!Array<number>)} tabIds The tab ID or list of tab IDs to
 *     move.
 * @param {{
 *   windowId: (number|undefined),
 *   index: number
 * }} moveProperties
 * @param {function((!chrome.tabs.Tab|!Array<!chrome.tabs.Tab>)): void=}
 *     callback
 * @see https://developer.chrome.com/extensions/tabs#method-move
 */
chrome.tabs.move = function(tabIds, moveProperties, callback) {};

/**
 * Reload a tab.
 * @param {number=} tabId The ID of the tab to reload; defaults to the selected
 *     tab of the current window.
 * @param {{
 *   bypassCache: (boolean|undefined)
 * }=} reloadProperties
 * @param {function(): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-reload
 */
chrome.tabs.reload = function(tabId, reloadProperties, callback) {};

/**
 * Closes one or more tabs.
 * @param {(number|!Array<number>)} tabIds The tab ID or list of tab IDs to
 *     close.
 * @param {function(): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-remove
 */
chrome.tabs.remove = function(tabIds, callback) {};

/**
 * Adds one or more tabs to a specified group, or if no group is specified, adds
 * the given tabs to a newly created group.
 * @param {{
 *   tabIds: (number|!Array<number>),
 *   groupId: (number|undefined),
 *   createProperties: ({
 *     windowId: (number|undefined)
 *   }|undefined)
 * }} options
 * @param {function(number): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-group
 */
chrome.tabs.group = function(options, callback) {};

/**
 * Removes one or more tabs from their respective groups. If any groups become
 * empty, they are deleted.
 * @param {(number|!Array<number>)} tabIds The tab ID or list of tab IDs to
 *     remove from their respective groups.
 * @param {function(): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-ungroup
 */
chrome.tabs.ungroup = function(tabIds, callback) {};

/**
 * Detects the primary language of the content in a tab.
 * @param {?number|undefined} tabId Defaults to the active tab of the <a
 *     href='windows#current-window'>current window</a>.
 * @param {function(string): void} callback
 * @see https://developer.chrome.com/extensions/tabs#method-detectLanguage
 */
chrome.tabs.detectLanguage = function(tabId, callback) {};

/**
 * Captures the visible area of the currently active tab in the specified
 * window. In order to call this method, the extension must have either the <a
 * href='declare_permissions'>&lt;all_urls&gt;</a> permission or the <a
 * href='activeTab'>activeTab</a> permission. In addition to sites that
 * extensions can normally access, this method allows extensions to capture
 * sensitive sites that are otherwise restricted, including chrome:-scheme
 * pages, other extensions' pages, and data: URLs. These sensitive sites can
 * only be captured with the activeTab permission. File URLs may be captured
 * only if the extension has been granted file access.
 * @param {?number|undefined} windowId The target window. Defaults to the <a
 *     href='windows#current-window'>current window</a>.
 * @param {?chrome.extensionTypes.ImageDetails|undefined} options
 * @param {function(string): void} callback
 * @see https://developer.chrome.com/extensions/tabs#method-captureVisibleTab
 */
chrome.tabs.captureVisibleTab = function(windowId, options, callback) {};

/**
 * Injects JavaScript code into a page. For details, see the <a
 * href='content_scripts#pi'>programmatic injection</a> section of the content
 * scripts doc.
 * @param {?number|undefined} tabId The ID of the tab in which to run the
 *     script; defaults to the active tab of the current window.
 * @param {!chrome.extensionTypes.InjectDetails} details Details of the
 *     script to run. Either the code or the file property must be set, but both
 *     may not be set at the same time.
 * @param {function((!Array<*>|undefined)): void=} callback Called after all the
 *     JavaScript has been executed.
 * @see https://developer.chrome.com/extensions/tabs#method-executeScript
 */
chrome.tabs.executeScript = function(tabId, details, callback) {};

/**
 * Injects CSS into a page. For details, see the <a
 * href='content_scripts#pi'>programmatic injection</a> section of the content
 * scripts doc.
 * @param {?number|undefined} tabId The ID of the tab in which to insert the
 *     CSS; defaults to the active tab of the current window.
 * @param {!chrome.extensionTypes.InjectDetails} details Details of the CSS
 *     text to insert. Either the code or the file property must be set, but
 *     both may not be set at the same time.
 * @param {function(): void=} callback Called when all the CSS has been
 *     inserted.
 * @see https://developer.chrome.com/extensions/tabs#method-insertCSS
 */
chrome.tabs.insertCSS = function(tabId, details, callback) {};

/**
 * Zooms a specified tab.
 * @param {?number|undefined} tabId The ID of the tab to zoom; defaults to the
 *     active tab of the current window.
 * @param {number} zoomFactor The new zoom factor. A value of <code>0</code>
 *     sets the tab to its current default zoom factor. Values greater than
 *     <code>0</code> specify a (possibly non-default) zoom factor for the tab.
 * @param {function(): void=} callback Called after the zoom factor has been
 *     changed.
 * @see https://developer.chrome.com/extensions/tabs#method-setZoom
 */
chrome.tabs.setZoom = function(tabId, zoomFactor, callback) {};

/**
 * Gets the current zoom factor of a specified tab.
 * @param {?number|undefined} tabId The ID of the tab to get the current zoom
 *     factor from; defaults to the active tab of the current window.
 * @param {function(number): void} callback Called with the tab's current zoom
 *     factor after it has been fetched.
 * @see https://developer.chrome.com/extensions/tabs#method-getZoom
 */
chrome.tabs.getZoom = function(tabId, callback) {};

/**
 * Sets the zoom settings for a specified tab, which define how zoom changes are
 * handled. These settings are reset to defaults upon navigating the tab.
 * @param {?number|undefined} tabId The ID of the tab to change the zoom
 *     settings for; defaults to the active tab of the current window.
 * @param {!chrome.tabs.ZoomSettings} zoomSettings Defines how zoom changes are
 *     handled and at what scope.
 * @param {function(): void=} callback Called after the zoom settings are
 *     changed.
 * @see https://developer.chrome.com/extensions/tabs#method-setZoomSettings
 */
chrome.tabs.setZoomSettings = function(tabId, zoomSettings, callback) {};

/**
 * Gets the current zoom settings of a specified tab.
 * @param {?number|undefined} tabId The ID of the tab to get the current zoom
 *     settings from; defaults to the active tab of the current window.
 * @param {function(!chrome.tabs.ZoomSettings): void} callback Called with the
 *     tab's current zoom settings.
 * @see https://developer.chrome.com/extensions/tabs#method-getZoomSettings
 */
chrome.tabs.getZoomSettings = function(tabId, callback) {};

/**
 * Discards a tab from memory. Discarded tabs are still visible on the tab strip
 * and are reloaded when activated.
 * @param {number=} tabId The ID of the tab to be discarded. If specified, the
 *     tab is discarded unless it is active or already discarded. If omitted,
 *     the browser discards the least important tab. This can fail if no
 *     discardable tabs exist.
 * @param {function((!chrome.tabs.Tab|undefined)): void=} callback Called after
 *     the operation is completed.
 * @see https://developer.chrome.com/extensions/tabs#method-discard
 */
chrome.tabs.discard = function(tabId, callback) {};

/**
 * Go foward to the next page, if one is available.
 * @param {number=} tabId The ID of the tab to navigate forward; defaults to the
 *     selected tab of the current window.
 * @param {function(): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-goForward
 */
chrome.tabs.goForward = function(tabId, callback) {};

/**
 * Go back to the previous page, if one is available.
 * @param {number=} tabId The ID of the tab to navigate back; defaults to the
 *     selected tab of the current window.
 * @param {function(): void=} callback
 * @see https://developer.chrome.com/extensions/tabs#method-goBack
 */
chrome.tabs.goBack = function(tabId, callback) {};

/**
 * Fired when a tab is created. Note that the tab's URL may not be set at the
 * time this event is fired, but you can listen to onUpdated events so as to be
 * notified when a URL is set.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onCreated
 */
chrome.tabs.onCreated;

/**
 * Fired when a tab is updated.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onUpdated
 */
chrome.tabs.onUpdated;

/**
 * Fired when a tab is moved within a window. Only one move event is fired,
 * representing the tab the user directly moved. Move events are not fired for
 * the other tabs that must move in response to the manually-moved tab. This
 * event is not fired when a tab is moved between windows; for details, see
 * $(ref:tabs.onDetached).
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onMoved
 */
chrome.tabs.onMoved;

/**
 * Fires when the selected tab in a window changes.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onSelectionChanged
 */
chrome.tabs.onSelectionChanged;

/**
 * Fires when the selected tab in a window changes. Note that the tab's URL may
 * not be set at the time this event fired, but you can listen to
 * $(ref:tabs.onUpdated) events so as to be notified when a URL is set.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onActiveChanged
 */
chrome.tabs.onActiveChanged;

/**
 * Fires when the active tab in a window changes. Note that the tab's URL may
 * not be set at the time this event fired, but you can listen to onUpdated
 * events so as to be notified when a URL is set.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onActivated
 */
chrome.tabs.onActivated;

/**
 * Fired when the highlighted or selected tabs in a window changes.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onHighlightChanged
 */
chrome.tabs.onHighlightChanged;

/**
 * Fired when the highlighted or selected tabs in a window changes.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onHighlighted
 */
chrome.tabs.onHighlighted;

/**
 * Fired when a tab is detached from a window; for example, because it was moved
 * between windows.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onDetached
 */
chrome.tabs.onDetached;

/**
 * Fired when a tab is attached to a window; for example, because it was moved
 * between windows.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onAttached
 */
chrome.tabs.onAttached;

/**
 * Fired when a tab is closed.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onRemoved
 */
chrome.tabs.onRemoved;

/**
 * Fired when a tab is replaced with another tab due to prerendering or instant.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onReplaced
 */
chrome.tabs.onReplaced;

/**
 * Fired when a tab is zoomed.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabs#event-onZoomChange
 */
chrome.tabs.onZoomChange;
