// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.tabGroups.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: tabGroups */

/** @const */
chrome.tabGroups = {};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/tabGroups#type-Color
 */
chrome.tabGroups.Color = {
  GREY: 'grey',
  BLUE: 'blue',
  RED: 'red',
  YELLOW: 'yellow',
  GREEN: 'green',
  PINK: 'pink',
  PURPLE: 'purple',
  CYAN: 'cyan',
};

/**
 * @typedef {{
 *   id: number,
 *   collapsed: boolean,
 *   color: !chrome.tabGroups.Color,
 *   title: (string|undefined),
 *   windowId: number
 * }}
 * @see https://developer.chrome.com/extensions/tabGroups#type-TabGroup
 */
chrome.tabGroups.TabGroup;

/**
 * An ID that represents the absence of a group.
 * @type {number}
 * @see https://developer.chrome.com/extensions/tabGroups#type-TAB_GROUP_ID_NONE
 */
chrome.tabGroups.TAB_GROUP_ID_NONE;

/**
 * Retrieves details about the specified group.
 * @param {number} groupId
 * @param {function(!chrome.tabGroups.TabGroup): void} callback
 * @see https://developer.chrome.com/extensions/tabGroups#method-get
 */
chrome.tabGroups.get = function(groupId, callback) {};

/**
 * Gets all groups that have the specified properties, or all groups if no
 * properties are specified.
 * @param {{
 *   collapsed: (boolean|undefined),
 *   color: (!chrome.tabGroups.Color|undefined),
 *   title: (string|undefined),
 *   windowId: (number|undefined)
 * }} queryInfo
 * @param {function(!Array<!chrome.tabGroups.TabGroup>): void} callback
 * @see https://developer.chrome.com/extensions/tabGroups#method-query
 */
chrome.tabGroups.query = function(queryInfo, callback) {};

/**
 * Modifies the properties of a group. Properties that are not specified in
 * <var>updateProperties</var> are not modified.
 * @param {number} groupId The ID of the group to modify.
 * @param {{
 *   collapsed: (boolean|undefined),
 *   color: (!chrome.tabGroups.Color|undefined),
 *   title: (string|undefined)
 * }} updateProperties
 * @param {function((!chrome.tabGroups.TabGroup|undefined)): void=} callback
 * @see https://developer.chrome.com/extensions/tabGroups#method-update
 */
chrome.tabGroups.update = function(groupId, updateProperties, callback) {};

/**
 * Moves the group and all its tabs within its window, or to a new window.
 * @param {number} groupId The ID of the group to move.
 * @param {{
 *   windowId: (number|undefined),
 *   index: number
 * }} moveProperties
 * @param {function((!chrome.tabGroups.TabGroup|undefined)): void=} callback
 * @see https://developer.chrome.com/extensions/tabGroups#method-move
 */
chrome.tabGroups.move = function(groupId, moveProperties, callback) {};

/**
 * Fired when a group is created.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabGroups#event-onCreated
 */
chrome.tabGroups.onCreated;

/**
 * Fired when a group is updated.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabGroups#event-onUpdated
 */
chrome.tabGroups.onUpdated;

/**
 * Fired when a group is moved within a window. Move events are still fired for
 * the individual tabs within the group, as well as for the group itself. This
 * event is not fired when a group is moved between windows; instead, it will be
 * removed from one window and created in another.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabGroups#event-onMoved
 */
chrome.tabGroups.onMoved;

/**
 * Fired when a group is closed, either directly by the user or automatically
 * because it contained zero tabs.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/tabGroups#event-onRemoved
 */
chrome.tabGroups.onRemoved;
