// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.safeBrowsingPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: safeBrowsingPrivate */

/** @const */
chrome.safeBrowsingPrivate = {};

/**
 * @enum {string}
 */
chrome.safeBrowsingPrivate.URLType = {
  EVENT_URL: 'EVENT_URL',
  LANDING_PAGE: 'LANDING_PAGE',
  LANDING_REFERRER: 'LANDING_REFERRER',
  CLIENT_REDIRECT: 'CLIENT_REDIRECT',
  RECENT_NAVIGATION: 'RECENT_NAVIGATION',
  REFERRER: 'REFERRER',
};

/**
 * @enum {string}
 */
chrome.safeBrowsingPrivate.NavigationInitiation = {
  BROWSER_INITIATED: 'BROWSER_INITIATED',
  RENDERER_INITIATED_WITHOUT_USER_GESTURE: 'RENDERER_INITIATED_WITHOUT_USER_GESTURE',
  RENDERER_INITIATED_WITH_USER_GESTURE: 'RENDERER_INITIATED_WITH_USER_GESTURE',
};

/**
 * @typedef {{
 *   url: string,
 *   userName: string,
 *   isPhishingUrl: boolean
 * }}
 */
chrome.safeBrowsingPrivate.PolicySpecifiedPasswordReuse;

/**
 * @typedef {{
 *   url: string,
 *   fileName: string,
 *   downloadDigestSha256: string,
 *   userName: string
 * }}
 */
chrome.safeBrowsingPrivate.DangerousDownloadInfo;

/**
 * @typedef {{
 *   url: string,
 *   reason: string,
 *   netErrorCode: (string|undefined),
 *   userName: string
 * }}
 */
chrome.safeBrowsingPrivate.InterstitialInfo;

/**
 * @typedef {{
 *   url: (string|undefined)
 * }}
 */
chrome.safeBrowsingPrivate.ServerRedirect;

/**
 * @typedef {{
 *   url: string,
 *   mainFrameUrl: (string|undefined),
 *   urlType: !chrome.safeBrowsingPrivate.URLType,
 *   ipAddresses: (!Array<string>|undefined),
 *   referrerUrl: (string|undefined),
 *   referrerMainFrameUrl: (string|undefined),
 *   isRetargeting: (boolean|undefined),
 *   navigationTimeMs: (number|undefined),
 *   serverRedirectChain: (!Array<!chrome.safeBrowsingPrivate.ServerRedirect>|undefined),
 *   navigationInitiation: (!chrome.safeBrowsingPrivate.NavigationInitiation|undefined),
 *   maybeLaunchedByExternalApp: (boolean|undefined)
 * }}
 */
chrome.safeBrowsingPrivate.ReferrerChainEntry;

/**
 * Gets referrer chain for the specified tab.
 * @param {number} tabId Id of the tab from which to retrieve the referrer.
 * @param {function(!Array<!chrome.safeBrowsingPrivate.ReferrerChainEntry>): void}
 *     callback Called with the list of referrer chain entries.
 */
chrome.safeBrowsingPrivate.getReferrerChain = function(tabId, callback) {};

/**
 * Fired when Chrome detects a reuse of a policy specified password.
 * @type {!ChromeEvent}
 */
chrome.safeBrowsingPrivate.onPolicySpecifiedPasswordReuseDetected;

/**
 * Fired when the user changed their policy specified password.
 * @type {!ChromeEvent}
 */
chrome.safeBrowsingPrivate.onPolicySpecifiedPasswordChanged;

/**
 * Fired when the user opened a dangerous download.
 * @type {!ChromeEvent}
 */
chrome.safeBrowsingPrivate.onDangerousDownloadOpened;

/**
 * Fired when a security interstitial is shown to the user.
 * @type {!ChromeEvent}
 */
chrome.safeBrowsingPrivate.onSecurityInterstitialShown;

/**
 * Fired when the user clicked-through a security interstitial.
 * @type {!ChromeEvent}
 */
chrome.safeBrowsingPrivate.onSecurityInterstitialProceeded;
