// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.resourcesPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: resourcesPrivate */

/** @const */
chrome.resourcesPrivate = {};

/**
 * @enum {string}
 */
chrome.resourcesPrivate.Component = {
  IDENTITY: 'identity',
  PDF: 'pdf',
};

/**
 * Gets localized strings for a component extension. Includes default WebUI
 * loadTimeData values for text and language settings (fontsize, fontfamily,
 * language, textdirection). See
 * chrome/browser/extensions/api/resources_private/resources_private_api.cc for
 * instructions on adding a new component to this API.
 * @param {!chrome.resourcesPrivate.Component} component Internal chrome
 *     component to get strings for.
 * @param {function(Object): void} callback Called with a dictionary mapping
 *     names to strings.
 */
chrome.resourcesPrivate.getStrings = function(component, callback) {};
