// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.quickUnlockPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: quickUnlockPrivate */

/** @const */
chrome.quickUnlockPrivate = {};

/**
 * @typedef {{
 *   token: string,
 *   lifetimeSeconds: number
 * }}
 */
chrome.quickUnlockPrivate.TokenInfo;

/**
 * @enum {string}
 */
chrome.quickUnlockPrivate.QuickUnlockMode = {
  PIN: 'PIN',
};

/**
 * @enum {string}
 */
chrome.quickUnlockPrivate.CredentialProblem = {
  TOO_SHORT: 'TOO_SHORT',
  TOO_LONG: 'TOO_LONG',
  TOO_WEAK: 'TOO_WEAK',
  CONTAINS_NONDIGIT: 'CONTAINS_NONDIGIT',
};

/**
 * @typedef {{
 *   errors: !Array<!chrome.quickUnlockPrivate.CredentialProblem>,
 *   warnings: !Array<!chrome.quickUnlockPrivate.CredentialProblem>
 * }}
 */
chrome.quickUnlockPrivate.CredentialCheck;

/**
 * @typedef {{
 *   minLength: number,
 *   maxLength: number
 * }}
 */
chrome.quickUnlockPrivate.CredentialRequirements;

/**
 * Returns a token that can be used for future operations and the number of
 * seconds until the token expires.
 * @param {string} accountPassword The account password for the logged in user.
 * @param {function(!chrome.quickUnlockPrivate.TokenInfo): void} onComplete
 */
chrome.quickUnlockPrivate.getAuthToken = function(accountPassword, onComplete) {};

/**
 * Sets the lock screen enabled state. NOTE: The lock enabled state is reflected
 * in the settings.enable_screen_lock pref, which can be read but not written
 * using the settings_private API (which also provides policy information). This
 * API must be used to change the pref.
 * @param {string} token The token returned by $(ref:getAuthToken).
 * @param {boolean} enabled Whether to enable the lock screen.
 * @param {function(): void=} onComplete
 */
chrome.quickUnlockPrivate.setLockScreenEnabled = function(token, enabled, onComplete) {};

/**
 * Sets the PIN auto submit enabled state. NOTE: The PIN autosubmit state is
 * reflected in the pin_unlock_autosubmit_enabled pref, which can be read but
 * not written using the settings_private API (which also provides policy
 * information). This API must be used to change the pref.
 * @param {string} token The authentication token.
 * @param {string} pin The PIN of the logged in user.
 * @param {boolean} enabled Whether to enable PIN auto submit.
 * @param {function(boolean): void} onComplete Called with true if the quick
 *     unlock state was updated,     false otherwise. The update is treated as a
 *     single atomic operation.
 */
chrome.quickUnlockPrivate.setPinAutosubmitEnabled = function(token, pin, enabled, onComplete) {};

/**
 * Tests wether it is currently possible to authenticate using PIN.
 * @param {function(boolean): void} onComplete
 */
chrome.quickUnlockPrivate.canAuthenticatePin = function(onComplete) {};

/**
 * Returns the set of quick unlock modes that are available for the user to use.
 * Some quick unlock modes may be disabled by policy.
 * @param {function(!Array<!chrome.quickUnlockPrivate.QuickUnlockMode>): void}
 *     onComplete
 */
chrome.quickUnlockPrivate.getAvailableModes = function(onComplete) {};

/**
 * Returns the quick unlock modes that are currently enabled and usable on the
 * lock screen.
 * @param {function(!Array<!chrome.quickUnlockPrivate.QuickUnlockMode>): void}
 *     onComplete
 */
chrome.quickUnlockPrivate.getActiveModes = function(onComplete) {};

/**
 * Checks if the given credential can be used for the given unlock mode.
 * Enterprise policy can change credential requirements.
 * @param {!chrome.quickUnlockPrivate.QuickUnlockMode} mode The quick unlock
 *     mode that is used.
 * @param {string} credential The given credential.
 * @param {function(!chrome.quickUnlockPrivate.CredentialCheck): void}
 *     onComplete Called with a list of warnings and errors the given
 *     |credential| has (or an empty list if there are none).
 */
chrome.quickUnlockPrivate.checkCredential = function(mode, credential, onComplete) {};

/**
 * Gets the credential requirements for the given unlock mode.
 * @param {!chrome.quickUnlockPrivate.QuickUnlockMode} mode The quick unlock
 *     mode that is used.
 * @param {function(!chrome.quickUnlockPrivate.CredentialRequirements): void}
 *     onComplete Called with the credential requirements of the given
 *     |mode|.
 */
chrome.quickUnlockPrivate.getCredentialRequirements = function(mode, onComplete) {};

/**
 * Update the set of quick unlock modes that are currently active/enabled.
 * @param {string} token The token returned by $(ref:getAuthToken).
 * @param {!Array<!chrome.quickUnlockPrivate.QuickUnlockMode>} modes The quick
 *     unlock modes that should be active.
 * @param {!Array<string>} credentials The associated credential for each mode.
 *     To keep the     credential the same for the associated mode, pass an
 *     empty string.
 * @param {function(): void} onComplete Called with true if the quick unlock
 *     state was updated,     false otherwise. The update is treated as a single
 *     atomic operation.
 */
chrome.quickUnlockPrivate.setModes = function(token, modes, credentials, onComplete) {};

/**
 * Called after the active set of quick unlock modes has changed.
 * @type {!ChromeEvent}
 */
chrome.quickUnlockPrivate.onActiveModesChanged;
