// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.networkingPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: networkingPrivate */

/** @const */
chrome.networkingPrivate = {};

/**
 * @enum {string}
 */
chrome.networkingPrivate.ActivationStateType = {
  ACTIVATED: 'Activated',
  ACTIVATING: 'Activating',
  NOT_ACTIVATED: 'NotActivated',
  PARTIALLY_ACTIVATED: 'PartiallyActivated',
};

/**
 * @enum {string}
 */
chrome.networkingPrivate.CaptivePortalStatus = {
  UNKNOWN: 'Unknown',
  OFFLINE: 'Offline',
  ONLINE: 'Online',
  PORTAL: 'Portal',
  PROXY_AUTH_REQUIRED: 'ProxyAuthRequired',
};

/**
 * @enum {string}
 */
chrome.networkingPrivate.ConnectionStateType = {
  CONNECTED: 'Connected',
  CONNECTING: 'Connecting',
  NOT_CONNECTED: 'NotConnected',
};

/**
 * @enum {string}
 */
chrome.networkingPrivate.DeviceStateType = {
  UNINITIALIZED: 'Uninitialized',
  DISABLED: 'Disabled',
  ENABLING: 'Enabling',
  ENABLED: 'Enabled',
  PROHIBITED: 'Prohibited',
};

/**
 * @enum {string}
 */
chrome.networkingPrivate.IPConfigType = {
  DHCP: 'DHCP',
  STATIC: 'Static',
};

/**
 * @enum {string}
 */
chrome.networkingPrivate.NetworkType = {
  ALL: 'All',
  CELLULAR: 'Cellular',
  ETHERNET: 'Ethernet',
  TETHER: 'Tether',
  VPN: 'VPN',
  WIRELESS: 'Wireless',
  WI_FI: 'WiFi',
};

/**
 * @enum {string}
 */
chrome.networkingPrivate.ProxySettingsType = {
  DIRECT: 'Direct',
  MANUAL: 'Manual',
  PAC: 'PAC',
  WPAD: 'WPAD',
};

/**
 * @typedef {{
 *   Active: (boolean|undefined),
 *   Effective: (string|undefined),
 *   UserPolicy: (boolean|undefined),
 *   DevicePolicy: (boolean|undefined),
 *   UserSetting: (boolean|undefined),
 *   SharedSetting: (boolean|undefined),
 *   UserEditable: (boolean|undefined),
 *   DeviceEditable: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedBoolean;

/**
 * @typedef {{
 *   Active: (number|undefined),
 *   Effective: (string|undefined),
 *   UserPolicy: (number|undefined),
 *   DevicePolicy: (number|undefined),
 *   UserSetting: (number|undefined),
 *   SharedSetting: (number|undefined),
 *   UserEditable: (boolean|undefined),
 *   DeviceEditable: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedLong;

/**
 * @typedef {{
 *   Active: (string|undefined),
 *   Effective: (string|undefined),
 *   UserPolicy: (string|undefined),
 *   DevicePolicy: (string|undefined),
 *   UserSetting: (string|undefined),
 *   SharedSetting: (string|undefined),
 *   UserEditable: (boolean|undefined),
 *   DeviceEditable: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedDOMString;

/**
 * @typedef {{
 *   Active: (!Array<string>|undefined),
 *   Effective: (string|undefined),
 *   UserPolicy: (!Array<string>|undefined),
 *   DevicePolicy: (!Array<string>|undefined),
 *   UserSetting: (!Array<string>|undefined),
 *   SharedSetting: (!Array<string>|undefined),
 *   UserEditable: (boolean|undefined),
 *   DeviceEditable: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedDOMStringList;

/**
 * @typedef {{
 *   Active: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   Effective: (string|undefined),
 *   UserPolicy: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   DevicePolicy: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   UserSetting: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   SharedSetting: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   UserEditable: (boolean|undefined),
 *   DeviceEditable: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedIPConfigType;

/**
 * @typedef {{
 *   Active: (!chrome.networkingPrivate.ProxySettingsType|undefined),
 *   Effective: (string|undefined),
 *   UserPolicy: (!chrome.networkingPrivate.ProxySettingsType|undefined),
 *   DevicePolicy: (!chrome.networkingPrivate.ProxySettingsType|undefined),
 *   UserSetting: (!chrome.networkingPrivate.ProxySettingsType|undefined),
 *   SharedSetting: (!chrome.networkingPrivate.ProxySettingsType|undefined),
 *   UserEditable: (boolean|undefined),
 *   DeviceEditable: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedProxySettingsType;

/**
 * @typedef {{
 *   AccessPointName: string,
 *   Authentication: (string|undefined),
 *   Language: (string|undefined),
 *   LocalizedName: (string|undefined),
 *   Name: (string|undefined),
 *   Password: (string|undefined),
 *   Username: (string|undefined)
 * }}
 */
chrome.networkingPrivate.APNProperties;

/**
 * @typedef {{
 *   AccessPointName: !chrome.networkingPrivate.ManagedDOMString,
 *   Authentication: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Language: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   LocalizedName: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Name: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Password: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Username: (!chrome.networkingPrivate.ManagedDOMString|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedAPNProperties;

/**
 * @typedef {{
 *   Active: (!Array<!chrome.networkingPrivate.APNProperties>|undefined),
 *   Effective: (string|undefined),
 *   UserPolicy: (!Array<!chrome.networkingPrivate.APNProperties>|undefined),
 *   DevicePolicy: (!Array<!chrome.networkingPrivate.APNProperties>|undefined),
 *   UserSetting: (!Array<!chrome.networkingPrivate.APNProperties>|undefined),
 *   SharedSetting: (!Array<!chrome.networkingPrivate.APNProperties>|undefined),
 *   UserEditable: (boolean|undefined),
 *   DeviceEditable: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedAPNList;

/**
 * @typedef {{
 *   Name: string,
 *   Code: string,
 *   Country: (string|undefined)
 * }}
 */
chrome.networkingPrivate.CellularProviderProperties;

/**
 * @typedef {{
 *   requirePin: boolean,
 *   currentPin: string,
 *   newPin: (string|undefined)
 * }}
 */
chrome.networkingPrivate.CellularSimState;

/**
 * @typedef {{
 *   CommonName: (string|undefined),
 *   Locality: (string|undefined),
 *   Organization: (string|undefined),
 *   OrganizationalUnit: (string|undefined)
 * }}
 */
chrome.networkingPrivate.IssuerSubjectPattern;

/**
 * @typedef {{
 *   CommonName: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Locality: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Organization: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   OrganizationalUnit: (!chrome.networkingPrivate.ManagedDOMString|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedIssuerSubjectPattern;

/**
 * @typedef {{
 *   EnrollmentURI: (!Array<string>|undefined),
 *   Issuer: (!chrome.networkingPrivate.IssuerSubjectPattern|undefined),
 *   IssuerCAPEMs: (!Array<string>|undefined),
 *   IssuerCARef: (!Array<string>|undefined),
 *   Subject: (!chrome.networkingPrivate.IssuerSubjectPattern|undefined)
 * }}
 */
chrome.networkingPrivate.CertificatePattern;

/**
 * @typedef {{
 *   EnrollmentURI: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   Issuer: (!chrome.networkingPrivate.ManagedIssuerSubjectPattern|undefined),
 *   IssuerCARef: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   Subject: (!chrome.networkingPrivate.ManagedIssuerSubjectPattern|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedCertificatePattern;

/**
 * @typedef {{
 *   AnonymousIdentity: (string|undefined),
 *   ClientCertPattern: (!chrome.networkingPrivate.CertificatePattern|undefined),
 *   ClientCertPKCS11Id: (string|undefined),
 *   ClientCertRef: (string|undefined),
 *   ClientCertType: (string|undefined),
 *   Identity: (string|undefined),
 *   Inner: (string|undefined),
 *   Outer: (string|undefined),
 *   Password: (string|undefined),
 *   SaveCredentials: (boolean|undefined),
 *   ServerCAPEMs: (!Array<string>|undefined),
 *   ServerCARefs: (!Array<string>|undefined),
 *   SubjectMatch: (string|undefined),
 *   TLSVersionMax: (string|undefined),
 *   UseProactiveKeyCaching: (boolean|undefined),
 *   UseSystemCAs: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.EAPProperties;

/**
 * @typedef {{
 *   AnonymousIdentity: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ClientCertPattern: (!chrome.networkingPrivate.ManagedCertificatePattern|undefined),
 *   ClientCertPKCS11Id: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ClientCertRef: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ClientCertType: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Identity: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Inner: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Outer: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Password: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   SaveCredentials: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   ServerCAPEMs: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   ServerCARefs: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   SubjectMatch: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   TLSVersionMax: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   UseProactiveKeyCaching: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   UseSystemCAs: (!chrome.networkingPrivate.ManagedBoolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedEAPProperties;

/**
 * @typedef {{
 *   Status: string,
 *   NetworkId: string,
 *   Technology: string,
 *   ShortName: (string|undefined),
 *   LongName: (string|undefined)
 * }}
 */
chrome.networkingPrivate.FoundNetworkProperties;

/**
 * @typedef {{
 *   Gateway: (string|undefined),
 *   IPAddress: (string|undefined),
 *   ExcludedRoutes: (!Array<string>|undefined),
 *   IncludedRoutes: (!Array<string>|undefined),
 *   NameServers: (!Array<string>|undefined),
 *   SearchDomains: (!Array<string>|undefined),
 *   RoutingPrefix: (number|undefined),
 *   Type: (string|undefined),
 *   WebProxyAutoDiscoveryUrl: (string|undefined)
 * }}
 */
chrome.networkingPrivate.IPConfigProperties;

/**
 * @typedef {{
 *   Gateway: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   IPAddress: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   NameServers: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   RoutingPrefix: (!chrome.networkingPrivate.ManagedLong|undefined),
 *   Type: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   WebProxyAutoDiscoveryUrl: (!chrome.networkingPrivate.ManagedDOMString|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedIPConfigProperties;

/**
 * @typedef {{
 *   Password: (string|undefined),
 *   SaveCredentials: (boolean|undefined),
 *   Username: (string|undefined)
 * }}
 */
chrome.networkingPrivate.XAUTHProperties;

/**
 * @typedef {{
 *   Password: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   SaveCredentials: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   Username: (!chrome.networkingPrivate.ManagedDOMString|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedXAUTHProperties;

/**
 * @typedef {{
 *   AuthenticationType: string,
 *   ClientCertPattern: (!chrome.networkingPrivate.CertificatePattern|undefined),
 *   ClientCertPKCS11Id: (string|undefined),
 *   ClientCertRef: (string|undefined),
 *   ClientCertType: (string|undefined),
 *   EAP: (!chrome.networkingPrivate.EAPProperties|undefined),
 *   Group: (string|undefined),
 *   IKEVersion: (number|undefined),
 *   PSK: (string|undefined),
 *   SaveCredentials: (boolean|undefined),
 *   ServerCAPEMs: (!Array<string>|undefined),
 *   ServerCARefs: (!Array<string>|undefined),
 *   XAUTH: (!chrome.networkingPrivate.XAUTHProperties|undefined)
 * }}
 */
chrome.networkingPrivate.IPSecProperties;

/**
 * @typedef {{
 *   AuthenticationType: !chrome.networkingPrivate.ManagedDOMString,
 *   ClientCertPattern: (!chrome.networkingPrivate.ManagedCertificatePattern|undefined),
 *   ClientCertPKCS11Id: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ClientCertRef: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ClientCertType: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   EAP: (!chrome.networkingPrivate.ManagedEAPProperties|undefined),
 *   Group: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   IKEVersion: (!chrome.networkingPrivate.ManagedLong|undefined),
 *   PSK: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   SaveCredentials: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   ServerCAPEMs: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   ServerCARefs: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   XAUTH: (!chrome.networkingPrivate.ManagedXAUTHProperties|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedIPSecProperties;

/**
 * @typedef {{
 *   LcpEchoDisabled: (boolean|undefined),
 *   Password: (string|undefined),
 *   SaveCredentials: (boolean|undefined),
 *   Username: (string|undefined)
 * }}
 */
chrome.networkingPrivate.L2TPProperties;

/**
 * @typedef {{
 *   LcpEchoDisabled: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   Password: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   SaveCredentials: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   Username: (!chrome.networkingPrivate.ManagedDOMString|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedL2TPProperties;

/**
 * @typedef {{
 *   Method: string,
 *   PostData: (string|undefined),
 *   Url: (string|undefined)
 * }}
 */
chrome.networkingPrivate.PaymentPortal;

/**
 * @typedef {{
 *   Host: string,
 *   Port: number
 * }}
 */
chrome.networkingPrivate.ProxyLocation;

/**
 * @typedef {{
 *   Host: !chrome.networkingPrivate.ManagedDOMString,
 *   Port: !chrome.networkingPrivate.ManagedLong
 * }}
 */
chrome.networkingPrivate.ManagedProxyLocation;

/**
 * @typedef {{
 *   HTTPProxy: (!chrome.networkingPrivate.ProxyLocation|undefined),
 *   SecureHTTPProxy: (!chrome.networkingPrivate.ProxyLocation|undefined),
 *   FTPProxy: (!chrome.networkingPrivate.ProxyLocation|undefined),
 *   SOCKS: (!chrome.networkingPrivate.ProxyLocation|undefined)
 * }}
 */
chrome.networkingPrivate.ManualProxySettings;

/**
 * @typedef {{
 *   HTTPProxy: (!chrome.networkingPrivate.ManagedProxyLocation|undefined),
 *   SecureHTTPProxy: (!chrome.networkingPrivate.ManagedProxyLocation|undefined),
 *   FTPProxy: (!chrome.networkingPrivate.ManagedProxyLocation|undefined),
 *   SOCKS: (!chrome.networkingPrivate.ManagedProxyLocation|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedManualProxySettings;

/**
 * @typedef {{
 *   Type: !chrome.networkingPrivate.ProxySettingsType,
 *   Manual: (!chrome.networkingPrivate.ManualProxySettings|undefined),
 *   ExcludeDomains: (!Array<string>|undefined),
 *   PAC: (string|undefined)
 * }}
 */
chrome.networkingPrivate.ProxySettings;

/**
 * @typedef {{
 *   Type: !chrome.networkingPrivate.ManagedProxySettingsType,
 *   Manual: (!chrome.networkingPrivate.ManagedManualProxySettings|undefined),
 *   ExcludeDomains: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   PAC: (!chrome.networkingPrivate.ManagedDOMString|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedProxySettings;

/**
 * @typedef {{
 *   Name: (string|undefined),
 *   Type: (string|undefined)
 * }}
 */
chrome.networkingPrivate.VerifyX509;

/**
 * @typedef {{
 *   Name: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Type: (!chrome.networkingPrivate.ManagedDOMString|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedVerifyX509;

/**
 * @typedef {{
 *   Auth: (string|undefined),
 *   AuthRetry: (string|undefined),
 *   AuthNoCache: (boolean|undefined),
 *   Cipher: (string|undefined),
 *   ClientCertPKCS11Id: (string|undefined),
 *   ClientCertPattern: (!chrome.networkingPrivate.CertificatePattern|undefined),
 *   ClientCertRef: (string|undefined),
 *   ClientCertType: (string|undefined),
 *   CompLZO: (string|undefined),
 *   CompNoAdapt: (boolean|undefined),
 *   ExtraHosts: (!Array<string>|undefined),
 *   IgnoreDefaultRoute: (boolean|undefined),
 *   KeyDirection: (string|undefined),
 *   NsCertType: (string|undefined),
 *   OTP: (string|undefined),
 *   Password: (string|undefined),
 *   Port: (number|undefined),
 *   Proto: (string|undefined),
 *   PushPeerInfo: (boolean|undefined),
 *   RemoteCertEKU: (string|undefined),
 *   RemoteCertKU: (!Array<string>|undefined),
 *   RemoteCertTLS: (string|undefined),
 *   RenegSec: (number|undefined),
 *   SaveCredentials: (boolean|undefined),
 *   ServerCAPEMs: (!Array<string>|undefined),
 *   ServerCARefs: (!Array<string>|undefined),
 *   ServerCertRef: (string|undefined),
 *   ServerPollTimeout: (number|undefined),
 *   Shaper: (number|undefined),
 *   StaticChallenge: (string|undefined),
 *   TLSAuthContents: (string|undefined),
 *   TLSRemote: (string|undefined),
 *   TLSVersionMin: (string|undefined),
 *   UserAuthenticationType: (string|undefined),
 *   Username: (string|undefined),
 *   Verb: (string|undefined),
 *   VerifyHash: (string|undefined),
 *   VerifyX509: (!chrome.networkingPrivate.VerifyX509|undefined)
 * }}
 */
chrome.networkingPrivate.OpenVPNProperties;

/**
 * @typedef {{
 *   Auth: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   AuthRetry: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   AuthNoCache: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   Cipher: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ClientCertPKCS11Id: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ClientCertPattern: (!chrome.networkingPrivate.ManagedCertificatePattern|undefined),
 *   ClientCertRef: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ClientCertType: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   CompLZO: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   CompNoAdapt: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   ExtraHosts: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   IgnoreDefaultRoute: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   KeyDirection: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   NsCertType: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   OTP: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Password: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Port: (!chrome.networkingPrivate.ManagedLong|undefined),
 *   Proto: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   PushPeerInfo: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   RemoteCertEKU: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   RemoteCertKU: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   RemoteCertTLS: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   RenegSec: (!chrome.networkingPrivate.ManagedLong|undefined),
 *   SaveCredentials: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   ServerCAPEMs: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   ServerCARefs: (!chrome.networkingPrivate.ManagedDOMStringList|undefined),
 *   ServerCertRef: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   ServerPollTimeout: (!chrome.networkingPrivate.ManagedLong|undefined),
 *   Shaper: (!chrome.networkingPrivate.ManagedLong|undefined),
 *   StaticChallenge: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   TLSAuthContents: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   TLSRemote: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   TLSVersionMin: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   UserAuthenticationType: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Username: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Verb: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   VerifyHash: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   VerifyX509: (!chrome.networkingPrivate.ManagedVerifyX509|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedOpenVPNProperties;

/**
 * @typedef {{
 *   LockType: string,
 *   LockEnabled: boolean,
 *   RetriesLeft: (number|undefined)
 * }}
 */
chrome.networkingPrivate.SIMLockStatus;

/**
 * @typedef {{
 *   ExtensionID: string,
 *   ProviderName: (string|undefined)
 * }}
 */
chrome.networkingPrivate.ThirdPartyVPNProperties;

/**
 * @typedef {{
 *   ExtensionID: !chrome.networkingPrivate.ManagedDOMString,
 *   ProviderName: (string|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedThirdPartyVPNProperties;

/**
 * @typedef {{
 *   AutoConnect: (boolean|undefined),
 *   APN: (!chrome.networkingPrivate.APNProperties|undefined),
 *   APNList: (!Array<!chrome.networkingPrivate.APNProperties>|undefined),
 *   ActivationType: (string|undefined),
 *   ActivationState: (!chrome.networkingPrivate.ActivationStateType|undefined),
 *   AllowRoaming: (boolean|undefined),
 *   ESN: (string|undefined),
 *   Family: (string|undefined),
 *   FirmwareRevision: (string|undefined),
 *   FoundNetworks: (!Array<!chrome.networkingPrivate.FoundNetworkProperties>|undefined),
 *   HardwareRevision: (string|undefined),
 *   HomeProvider: (!chrome.networkingPrivate.CellularProviderProperties|undefined),
 *   ICCID: (string|undefined),
 *   IMEI: (string|undefined),
 *   LastGoodAPN: (!chrome.networkingPrivate.APNProperties|undefined),
 *   Manufacturer: (string|undefined),
 *   MDN: (string|undefined),
 *   MEID: (string|undefined),
 *   MIN: (string|undefined),
 *   ModelID: (string|undefined),
 *   NetworkTechnology: (string|undefined),
 *   PaymentPortal: (!chrome.networkingPrivate.PaymentPortal|undefined),
 *   RoamingState: (string|undefined),
 *   Scanning: (boolean|undefined),
 *   ServingOperator: (!chrome.networkingPrivate.CellularProviderProperties|undefined),
 *   SIMLockStatus: (!chrome.networkingPrivate.SIMLockStatus|undefined),
 *   SIMPresent: (boolean|undefined),
 *   SignalStrength: (number|undefined),
 *   SupportNetworkScan: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.CellularProperties;

/**
 * @typedef {{
 *   AutoConnect: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   APN: (!chrome.networkingPrivate.ManagedAPNProperties|undefined),
 *   APNList: (!chrome.networkingPrivate.ManagedAPNList|undefined),
 *   ActivationType: (string|undefined),
 *   ActivationState: (!chrome.networkingPrivate.ActivationStateType|undefined),
 *   AllowRoaming: (boolean|undefined),
 *   ESN: (string|undefined),
 *   Family: (string|undefined),
 *   FirmwareRevision: (string|undefined),
 *   FoundNetworks: (!Array<!chrome.networkingPrivate.FoundNetworkProperties>|undefined),
 *   HardwareRevision: (string|undefined),
 *   HomeProvider: (!chrome.networkingPrivate.CellularProviderProperties|undefined),
 *   ICCID: (string|undefined),
 *   IMEI: (string|undefined),
 *   LastGoodAPN: (!chrome.networkingPrivate.APNProperties|undefined),
 *   Manufacturer: (string|undefined),
 *   MDN: (string|undefined),
 *   MEID: (string|undefined),
 *   MIN: (string|undefined),
 *   ModelID: (string|undefined),
 *   NetworkTechnology: (string|undefined),
 *   PaymentPortal: (!chrome.networkingPrivate.PaymentPortal|undefined),
 *   RoamingState: (string|undefined),
 *   Scanning: (boolean|undefined),
 *   ServingOperator: (!chrome.networkingPrivate.CellularProviderProperties|undefined),
 *   SIMLockStatus: (!chrome.networkingPrivate.SIMLockStatus|undefined),
 *   SIMPresent: (boolean|undefined),
 *   SignalStrength: (number|undefined),
 *   SupportNetworkScan: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedCellularProperties;

/**
 * @typedef {{
 *   ActivationState: (!chrome.networkingPrivate.ActivationStateType|undefined),
 *   NetworkTechnology: (string|undefined),
 *   RoamingState: (string|undefined),
 *   Scanning: (boolean|undefined),
 *   SIMPresent: (boolean|undefined),
 *   SignalStrength: (number|undefined)
 * }}
 */
chrome.networkingPrivate.CellularStateProperties;

/**
 * @typedef {{
 *   Outer: (string|undefined)
 * }}
 */
chrome.networkingPrivate.EAPStateProperties;

/**
 * @typedef {{
 *   AutoConnect: (boolean|undefined),
 *   Authentication: (string|undefined),
 *   EAP: (!chrome.networkingPrivate.EAPProperties|undefined)
 * }}
 */
chrome.networkingPrivate.EthernetProperties;

/**
 * @typedef {{
 *   AutoConnect: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   Authentication: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   EAP: (!chrome.networkingPrivate.ManagedEAPProperties|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedEthernetProperties;

/**
 * @typedef {{
 *   Authentication: string
 * }}
 */
chrome.networkingPrivate.EthernetStateProperties;

/**
 * @typedef {{
 *   BatteryPercentage: (number|undefined),
 *   Carrier: (string|undefined),
 *   HasConnectedToHost: boolean,
 *   SignalStrength: (number|undefined)
 * }}
 */
chrome.networkingPrivate.TetherProperties;

/**
 * @typedef {{
 *   AutoConnect: (boolean|undefined),
 *   Host: (string|undefined),
 *   IPsec: (!chrome.networkingPrivate.IPSecProperties|undefined),
 *   L2TP: (!chrome.networkingPrivate.L2TPProperties|undefined),
 *   OpenVPN: (!chrome.networkingPrivate.OpenVPNProperties|undefined),
 *   ThirdPartyVPN: (!chrome.networkingPrivate.ThirdPartyVPNProperties|undefined),
 *   Type: (string|undefined)
 * }}
 */
chrome.networkingPrivate.VPNProperties;

/**
 * @typedef {{
 *   AutoConnect: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   Host: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   IPsec: (!chrome.networkingPrivate.ManagedIPSecProperties|undefined),
 *   L2TP: (!chrome.networkingPrivate.ManagedL2TPProperties|undefined),
 *   OpenVPN: (!chrome.networkingPrivate.ManagedOpenVPNProperties|undefined),
 *   ThirdPartyVPN: (!chrome.networkingPrivate.ManagedThirdPartyVPNProperties|undefined),
 *   Type: (!chrome.networkingPrivate.ManagedDOMString|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedVPNProperties;

/**
 * @typedef {{
 *   Type: string,
 *   IPsec: (!chrome.networkingPrivate.IPSecProperties|undefined),
 *   ThirdPartyVPN: (!chrome.networkingPrivate.ThirdPartyVPNProperties|undefined)
 * }}
 */
chrome.networkingPrivate.VPNStateProperties;

/**
 * @typedef {{
 *   AllowGatewayARPPolling: (boolean|undefined),
 *   AutoConnect: (boolean|undefined),
 *   BSSID: (string|undefined),
 *   EAP: (!chrome.networkingPrivate.EAPProperties|undefined),
 *   Frequency: (number|undefined),
 *   FrequencyList: (!Array<number>|undefined),
 *   HexSSID: (string|undefined),
 *   HiddenSSID: (boolean|undefined),
 *   Passphrase: (string|undefined),
 *   SSID: (string|undefined),
 *   Security: (string|undefined),
 *   SignalStrength: (number|undefined),
 * }}
 */
chrome.networkingPrivate.WiFiProperties;

/**
 * @typedef {{
 *   AllowGatewayARPPolling: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   AutoConnect: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   BSSID: (string|undefined),
 *   EAP: (!chrome.networkingPrivate.ManagedEAPProperties|undefined),
 *   Frequency: (number|undefined),
 *   FrequencyList: (!Array<number>|undefined),
 *   HexSSID: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   HiddenSSID: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   Passphrase: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   SSID: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   Security: !chrome.networkingPrivate.ManagedDOMString,
 *   SignalStrength: (number|undefined),
 * }}
 */
chrome.networkingPrivate.ManagedWiFiProperties;

/**
 * @typedef {{
 *   BSSID: (string|undefined),
 *   EAP: (!chrome.networkingPrivate.EAPStateProperties|undefined),
 *   Frequency: (number|undefined),
 *   HexSSID: (string|undefined),
 *   Security: string,
 *   SignalStrength: (number|undefined),
 *   SSID: (string|undefined),
 * }}
 */
chrome.networkingPrivate.WiFiStateProperties;

/**
 * @typedef {{
 *   Cellular: (!chrome.networkingPrivate.CellularProperties|undefined),
 *   Ethernet: (!chrome.networkingPrivate.EthernetProperties|undefined),
 *   GUID: (string|undefined),
 *   IPAddressConfigType: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   Name: (string|undefined),
 *   NameServersConfigType: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   Priority: (number|undefined),
 *   ProxySettings: (!chrome.networkingPrivate.ProxySettings|undefined),
 *   StaticIPConfig: (!chrome.networkingPrivate.IPConfigProperties|undefined),
 *   Type: (!chrome.networkingPrivate.NetworkType|undefined),
 *   VPN: (!chrome.networkingPrivate.VPNProperties|undefined),
 *   WiFi: (!chrome.networkingPrivate.WiFiProperties|undefined)
 * }}
 */
chrome.networkingPrivate.NetworkConfigProperties;

/**
 * @typedef {{
 *   Cellular: (!chrome.networkingPrivate.CellularProperties|undefined),
 *   Connectable: (boolean|undefined),
 *   ConnectionState: (!chrome.networkingPrivate.ConnectionStateType|undefined),
 *   ErrorState: (string|undefined),
 *   Ethernet: (!chrome.networkingPrivate.EthernetProperties|undefined),
 *   GUID: string,
 *   IPAddressConfigType: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   IPConfigs: (!Array<!chrome.networkingPrivate.IPConfigProperties>|undefined),
 *   MacAddress: (string|undefined),
 *   Metered: (boolean|undefined),
 *   Name: (string|undefined),
 *   NameServersConfigType: (!chrome.networkingPrivate.IPConfigType|undefined),
 *   Priority: (number|undefined),
 *   ProxySettings: (!chrome.networkingPrivate.ProxySettings|undefined),
 *   RestrictedConnectivity: (boolean|undefined),
 *   StaticIPConfig: (!chrome.networkingPrivate.IPConfigProperties|undefined),
 *   SavedIPConfig: (!chrome.networkingPrivate.IPConfigProperties|undefined),
 *   Source: (string|undefined),
 *   Tether: (!chrome.networkingPrivate.TetherProperties|undefined),
 *   Type: !chrome.networkingPrivate.NetworkType,
 *   VPN: (!chrome.networkingPrivate.VPNProperties|undefined),
 *   WiFi: (!chrome.networkingPrivate.WiFiProperties|undefined)
 * }}
 */
chrome.networkingPrivate.NetworkProperties;

/**
 * @typedef {{
 *   Cellular: (!chrome.networkingPrivate.ManagedCellularProperties|undefined),
 *   Connectable: (boolean|undefined),
 *   ConnectionState: (!chrome.networkingPrivate.ConnectionStateType|undefined),
 *   ErrorState: (string|undefined),
 *   Ethernet: (!chrome.networkingPrivate.ManagedEthernetProperties|undefined),
 *   GUID: string,
 *   IPAddressConfigType: (!chrome.networkingPrivate.ManagedIPConfigType|undefined),
 *   IPConfigs: (!Array<!chrome.networkingPrivate.IPConfigProperties>|undefined),
 *   MacAddress: (string|undefined),
 *   Metered: (!chrome.networkingPrivate.ManagedBoolean|undefined),
 *   Name: (!chrome.networkingPrivate.ManagedDOMString|undefined),
 *   NameServersConfigType: (!chrome.networkingPrivate.ManagedIPConfigType|undefined),
 *   Priority: (!chrome.networkingPrivate.ManagedLong|undefined),
 *   ProxySettings: (!chrome.networkingPrivate.ManagedProxySettings|undefined),
 *   RestrictedConnectivity: (boolean|undefined),
 *   StaticIPConfig: (!chrome.networkingPrivate.ManagedIPConfigProperties|undefined),
 *   SavedIPConfig: (!chrome.networkingPrivate.IPConfigProperties|undefined),
 *   Source: (string|undefined),
 *   Tether: (!chrome.networkingPrivate.TetherProperties|undefined),
 *   Type: !chrome.networkingPrivate.NetworkType,
 *   VPN: (!chrome.networkingPrivate.ManagedVPNProperties|undefined),
 *   WiFi: (!chrome.networkingPrivate.ManagedWiFiProperties|undefined)
 * }}
 */
chrome.networkingPrivate.ManagedProperties;

/**
 * @typedef {{
 *   Cellular: (!chrome.networkingPrivate.CellularStateProperties|undefined),
 *   Connectable: (boolean|undefined),
 *   ConnectionState: (!chrome.networkingPrivate.ConnectionStateType|undefined),
 *   Ethernet: (!chrome.networkingPrivate.EthernetStateProperties|undefined),
 *   ErrorState: (string|undefined),
 *   GUID: string,
 *   Name: (string|undefined),
 *   Priority: (number|undefined),
 *   Source: (string|undefined),
 *   Tether: (!chrome.networkingPrivate.TetherProperties|undefined),
 *   Type: !chrome.networkingPrivate.NetworkType,
 *   VPN: (!chrome.networkingPrivate.VPNStateProperties|undefined),
 *   WiFi: (!chrome.networkingPrivate.WiFiStateProperties|undefined)
 * }}
 */
chrome.networkingPrivate.NetworkStateProperties;

/**
 * @typedef {{
 *   Scanning: (boolean|undefined),
 *   SIMLockStatus: (!chrome.networkingPrivate.SIMLockStatus|undefined),
 *   SIMPresent: (boolean|undefined),
 *   State: !chrome.networkingPrivate.DeviceStateType,
 *   Type: !chrome.networkingPrivate.NetworkType,
 *   ManagedNetworkAvailable: (boolean|undefined)
 * }}
 */
chrome.networkingPrivate.DeviceStateProperties;

/**
 * @typedef {{
 *   certificate: string,
 *   intermediateCertificates: (!Array<string>|undefined),
 *   publicKey: string,
 *   nonce: string,
 *   signedData: string,
 *   deviceSerial: string,
 *   deviceSsid: string,
 *   deviceBssid: string
 * }}
 */
chrome.networkingPrivate.VerificationProperties;

/**
 * @typedef {{
 *   networkType: !chrome.networkingPrivate.NetworkType,
 *   visible: (boolean|undefined),
 *   configured: (boolean|undefined),
 *   limit: (number|undefined)
 * }}
 */
chrome.networkingPrivate.NetworkFilter;

/**
 * @typedef {{
 *   AllowOnlyPolicyNetworksToAutoconnect: (boolean|undefined),
 *   AllowOnlyPolicyNetworksToConnect: (boolean|undefined),
 *   AllowOnlyPolicyNetworksToConnectIfAvailable: (boolean|undefined),
 *   BlockedHexSSIDs: (!Array<string>|undefined)
 * }}
 */
chrome.networkingPrivate.GlobalPolicy;

/**
 * @typedef {{
 *   hash: string,
 *   issuedBy: string,
 *   issuedTo: string,
 *   pem: (string|undefined),
 *   PKCS11Id: (string|undefined),
 *   hardwareBacked: boolean,
 *   deviceWide: boolean
 * }}
 */
chrome.networkingPrivate.Certificate;

/**
 * @typedef {{
 *   serverCaCertificates: !Array<!chrome.networkingPrivate.Certificate>,
 *   userCertificates: !Array<!chrome.networkingPrivate.Certificate>
 * }}
 */
chrome.networkingPrivate.CertificateLists;

/**
 * Gets all the properties of the network with id networkGuid. Includes all
 * properties of the network (read-only and read/write values).
 * @param {string} networkGuid The GUID of the network to get properties for.
 * @param {function(!chrome.networkingPrivate.NetworkProperties): void} callback
 *     Called with the network properties when received.
 */
chrome.networkingPrivate.getProperties = function(networkGuid, callback) {};

/**
 * Gets the merged properties of the network with id networkGuid from the
 * sources: User settings, shared settings, user policy, device policy and the
 * currently active settings.
 * @param {string} networkGuid The GUID of the network to get properties for.
 * @param {function(!chrome.networkingPrivate.ManagedProperties): void} callback
 *     Called with the managed network properties when received.
 */
chrome.networkingPrivate.getManagedProperties = function(networkGuid, callback) {};

/**
 * Gets the cached read-only properties of the network with id networkGuid. This
 * is meant to be a higher performance function than $(ref:getProperties), which
 * requires a round trip to query the networking subsystem. The following
 * properties are returned for all networks: GUID, Type, Name, WiFi.Security.
 * Additional properties are provided for visible networks: ConnectionState,
 * ErrorState, WiFi.SignalStrength, Cellular.NetworkTechnology,
 * Cellular.ActivationState, Cellular.RoamingState.
 * @param {string} networkGuid The GUID of the network to get properties for.
 * @param {function(!chrome.networkingPrivate.NetworkStateProperties): void}
 *     callback Called immediately with the network state properties.
 */
chrome.networkingPrivate.getState = function(networkGuid, callback) {};

/**
 * Sets the properties of the network with id |networkGuid|. This is only valid
 * for configured networks (Source != None). Unconfigured visible networks
 * should use createNetwork instead.
 * @param {string} networkGuid The GUID of the network to set properties for.
 * @param {!chrome.networkingPrivate.NetworkConfigProperties} properties The
 *     properties to set.
 * @param {function(): void=} callback Called when the operation has completed.
 */
chrome.networkingPrivate.setProperties = function(networkGuid, properties, callback) {};

/**
 * Creates a new network configuration from properties. If a matching configured
 * network already exists, this will fail. Otherwise returns the guid of the new
 * network.
 * @param {boolean} shared If true, share this network configuration with other
 *     users.
 * @param {!chrome.networkingPrivate.NetworkConfigProperties} properties The
 *     properties to configure the new network with.
 * @param {function(string): void=} callback Called with the GUID for the new
 *     network configuration once     the network has been created.
 */
chrome.networkingPrivate.createNetwork = function(shared, properties, callback) {};

/**
 * Forgets a network configuration by clearing any configured properties for the
 * network with GUID 'networkGuid'. This may also include any other networks
 * with matching identifiers (e.g. WiFi SSID and Security). If no such
 * configuration exists, an error will be set and the operation will fail.
 * @param {string} networkGuid The GUID of the network to forget.
 * @param {function(): void=} callback Called when the operation has completed.
 */
chrome.networkingPrivate.forgetNetwork = function(networkGuid, callback) {};

/**
 * Returns a list of network objects with the same properties provided by
 * $(ref:networkingPrivate.getState). A filter is provided to specify the type
 * of networks returned and to limit the number of networks. Networks are
 * ordered by the system based on their priority, with connected or connecting
 * networks listed first.
 * @param {!chrome.networkingPrivate.NetworkFilter} filter Describes which
 *     networks to return.
 * @param {function(!Array<!chrome.networkingPrivate.NetworkStateProperties>): void}
 *     callback Called with a dictionary of networks and their state
 *     properties when received.
 */
chrome.networkingPrivate.getNetworks = function(filter, callback) {};

/**
 * Deprecated. Please use $(ref:networkingPrivate.getNetworks) with
 * filter.visible = true instead.
 * @param {!chrome.networkingPrivate.NetworkType} networkType
 * @param {function(!Array<!chrome.networkingPrivate.NetworkStateProperties>): void}
 *     callback
 * @deprecated Use getNetworks.
 */
chrome.networkingPrivate.getVisibleNetworks = function(networkType, callback) {};

/**
 * Deprecated. Please use $(ref:networkingPrivate.getDeviceStates) instead.
 * @param {function(!Array<!chrome.networkingPrivate.NetworkType>): void}
 *     callback
 * @deprecated Use getDeviceStates.
 */
chrome.networkingPrivate.getEnabledNetworkTypes = function(callback) {};

/**
 * Returns a list of $(ref:networkingPrivate.DeviceStateProperties) objects.
 * @param {function(!Array<!chrome.networkingPrivate.DeviceStateProperties>): void}
 *     callback Called with a list of devices and their state.
 */
chrome.networkingPrivate.getDeviceStates = function(callback) {};

/**
 * Enables any devices matching the specified network type. Note, the type might
 * represent multiple network types (e.g. 'Wireless').
 * @param {!chrome.networkingPrivate.NetworkType} networkType The type of
 *     network to enable.
 */
chrome.networkingPrivate.enableNetworkType = function(networkType) {};

/**
 * Disables any devices matching the specified network type. See note for
 * $(ref:networkingPrivate.enableNetworkType).
 * @param {!chrome.networkingPrivate.NetworkType} networkType The type of
 *     network to disable.
 */
chrome.networkingPrivate.disableNetworkType = function(networkType) {};

/**
 * Requests that the networking subsystem scan for new networks and update the
 * list returned by $(ref:getVisibleNetworks). This is only a request: the
 * network subsystem can choose to ignore it.  If the list is updated, then the
 * $(ref:onNetworkListChanged) event will be fired.
 * @param {!chrome.networkingPrivate.NetworkType=} networkType If provided,
 *     requests a scan specific to the type.     For Cellular a mobile network
 *     scan will be requested if supported.
 */
chrome.networkingPrivate.requestNetworkScan = function(networkType) {};

/**
 * Starts a connection to the network with networkGuid.
 * @param {string} networkGuid The GUID of the network to connect to.
 * @param {function(): void=} callback Called when the connect request has been
 *     sent. Note: the     connection may not have completed. Observe
 *     $(ref:onNetworksChanged)     to be notified when a network state changes.
 *     If the connect request     immediately failed (e.g. the network is
 *     unconfigured),     $(ref:runtime.lastError) will be set with a failure
 *     reason.
 */
chrome.networkingPrivate.startConnect = function(networkGuid, callback) {};

/**
 * Starts a disconnect from the network with networkGuid.
 * @param {string} networkGuid The GUID of the network to disconnect from.
 * @param {function(): void=} callback Called when the disconnect request has
 *     been sent. See note     for $(ref:startConnect).
 */
chrome.networkingPrivate.startDisconnect = function(networkGuid, callback) {};

/**
 * Starts activation of the Cellular network with networkGuid. If called for a
 * network that is already activated, or for a network with a carrier that can
 * not be directly activated, this will show the account details page for the
 * carrier if possible.
 * @param {string} networkGuid The GUID of the Cellular network to activate.
 * @param {string=} carrier Optional name of carrier to activate.
 * @param {function(): void=} callback Called when the activation request has
 *     been sent. See note     for $(ref:startConnect).
 */
chrome.networkingPrivate.startActivate = function(networkGuid, carrier, callback) {};

/**
 * Verifies that the device is a trusted device.
 * @param {!chrome.networkingPrivate.VerificationProperties} properties
 *     Properties of the destination to use in verifying that it     is a
 *     trusted device.
 * @param {function(boolean): void} callback A callback function that indicates
 *     whether or not the device     is a trusted device.
 * @deprecated Use networking.castPrivate API.
 */
chrome.networkingPrivate.verifyDestination = function(properties, callback) {};

/**
 * Verifies that the device is a trusted device and encrypts supplied data with
 * device public key.
 * @param {!chrome.networkingPrivate.VerificationProperties} properties
 *     Properties of the destination to use in verifying that it     is a
 *     trusted device.
 * @param {string} data A string containing the base64-encoded data to encrypt.
 * @param {function(string): void} callback A callback function that receives
 *     base64-encoded encrypted     data to send to a trusted device.
 * @deprecated Use networking.castPrivate API.
 */
chrome.networkingPrivate.verifyAndEncryptData = function(properties, data, callback) {};

/**
 * Deprecated. Enables TDLS for WiFi traffic with a specified peer if available.
 * @param {string} ip_or_mac_address The IP or MAC address of the peer with
 *     which to     enable a TDLS connection. |enabled| If true, enable TDLS,
 *     otherwise disable TDLS.
 * @param {boolean} enabled
 * @param {function(string): void=} callback A callback function that receives a
 *     string with an error or     the current TDLS status. 'Failed' indicates
 *     that the request failed     (e.g. MAC address lookup failed). 'Timeout'
 *     indicates that the lookup     timed out. Otherwise a valid status is
 *     returned (see     $(ref:getWifiTDLSStatus)).
 * @deprecated True
 */
chrome.networkingPrivate.setWifiTDLSEnabledState = function(ip_or_mac_address, enabled, callback) {};

/**
 * Deprecated. Returns the current TDLS status for the specified peer.
 * @param {string} ip_or_mac_address The IP or MAC address of the peer.
 * @param {function(string): void} callback A callback function that receives a
 *     string with the current     TDLS status which can be 'Connected',
 *     'Disabled', 'Disconnected',     'Nonexistent', or 'Unknown'.
 * @deprecated True
 */
chrome.networkingPrivate.getWifiTDLSStatus = function(ip_or_mac_address, callback) {};

/**
 * Returns captive portal status for the network matching 'networkGuid'.
 * @param {string} networkGuid The GUID of the network to get captive portal
 *     status for.
 * @param {function(!chrome.networkingPrivate.CaptivePortalStatus): void}
 *     callback A callback function that returns the results of the query for
 *     network captive portal status.
 */
chrome.networkingPrivate.getCaptivePortalStatus = function(networkGuid, callback) {};

/**
 * Unlocks a Cellular SIM card. * If the SIM is PIN locked, |pin| will be used
 * to unlock the SIM and   the |puk| argument will be ignored if provided. * If
 * the SIM is PUK locked, |puk| and |pin| must be provided. If the   operation
 * succeeds (|puk| is valid), the PIN will be set to |pin|.   (If |pin| is empty
 * or invalid the operation will fail).
 * @param {string} networkGuid The GUID of the cellular network to unlock.
 *     If empty, the default cellular device will be used.
 * @param {string} pin The current SIM PIN, or the new PIN if PUK is provided.
 * @param {string=} puk The operator provided PUK for unblocking a blocked SIM.
 * @param {function(): void=} callback Called when the operation has completed.
 */
chrome.networkingPrivate.unlockCellularSim = function(networkGuid, pin, puk, callback) {};

/**
 * Sets whether or not SIM locking is enabled (i.e a PIN will be required when
 * the device is powered) and changes the PIN if a new PIN is specified. If the
 * new PIN is provided but not valid (e.g. too short) the operation will fail.
 * This will not lock the SIM; that is handled automatically by the device.
 * NOTE: If the SIM is locked, it must first be unlocked with
 * unlockCellularSim() before this can be called (otherwise it will fail and
 * $(ref:runtime.lastError) will be set to Error.SimLocked).
 * @param {string} networkGuid The GUID of the cellular network to set the SIM
 *     state of.     If empty, the default cellular device will be used.
 * @param {!chrome.networkingPrivate.CellularSimState} simState The SIM state to
 *     set.
 * @param {function(): void=} callback Called when the operation has completed.
 */
chrome.networkingPrivate.setCellularSimState = function(networkGuid, simState, callback) {};

/**
 * Selects which Cellular Mobile Network to use. |networkId| must be the
 * NetworkId property of a member of Cellular.FoundNetworks from the network
 * properties for the specified Cellular network.
 * @param {string} networkGuid The GUID of the cellular network to select the
 *     network     for. If empty, the default cellular device will be used.
 * @param {string} networkId The networkId to select.
 * @param {function(): void=} callback Called when the operation has completed.
 */
chrome.networkingPrivate.selectCellularMobileNetwork = function(networkGuid, networkId, callback) {};

/**
 * Gets the global policy properties. These properties are not expected to
 * change during a session.
 * @param {function(!chrome.networkingPrivate.GlobalPolicy): void} callback
 */
chrome.networkingPrivate.getGlobalPolicy = function(callback) {};

/**
 * Gets the lists of certificates available for network configuration.
 * @param {function(!chrome.networkingPrivate.CertificateLists): void} callback
 */
chrome.networkingPrivate.getCertificateLists = function(callback) {};

/**
 * Fired when the properties change on any of the networks.  Sends a list of
 * GUIDs for networks whose properties have changed.
 * @type {!ChromeEvent}
 */
chrome.networkingPrivate.onNetworksChanged;

/**
 * Fired when the list of networks has changed.  Sends a complete list of GUIDs
 * for all the current networks.
 * @type {!ChromeEvent}
 */
chrome.networkingPrivate.onNetworkListChanged;

/**
 * Fired when the list of devices has changed or any device state properties
 * have changed.
 * @type {!ChromeEvent}
 */
chrome.networkingPrivate.onDeviceStateListChanged;

/**
 * Fired when a portal detection for a network completes. Sends the guid of the
 * network and the corresponding captive portal status.
 * @type {!ChromeEvent}
 */
chrome.networkingPrivate.onPortalDetectionCompleted;

/**
 * Fired when any certificate list has changed.
 * @type {!ChromeEvent}
 */
chrome.networkingPrivate.onCertificateListsChanged;
