// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.loginState.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: loginState */

/** @const */
chrome.loginState = {};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/loginState#type-ProfileType
 */
chrome.loginState.ProfileType = {
  SIGNIN_PROFILE: 'SIGNIN_PROFILE',
  USER_PROFILE: 'USER_PROFILE',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/loginState#type-SessionState
 */
chrome.loginState.SessionState = {
  UNKNOWN: 'UNKNOWN',
  IN_OOBE_SCREEN: 'IN_OOBE_SCREEN',
  IN_LOGIN_SCREEN: 'IN_LOGIN_SCREEN',
  IN_SESSION: 'IN_SESSION',
  IN_LOCK_SCREEN: 'IN_LOCK_SCREEN',
};

/**
 * Gets the type of the profile the extension is in.
 * @param {function(!chrome.loginState.ProfileType): void} callback
 * @see https://developer.chrome.com/extensions/loginState#method-getProfileType
 */
chrome.loginState.getProfileType = function(callback) {};

/**
 * Gets the current session state.
 * @param {function(!chrome.loginState.SessionState): void} callback
 * @see https://developer.chrome.com/extensions/loginState#method-getSessionState
 */
chrome.loginState.getSessionState = function(callback) {};

/**
 * Dispatched when the session state changes. <code>sessionState</code> is the
 * new session state.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/loginState#event-onSessionStateChanged
 */
chrome.loginState.onSessionStateChanged;
