// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.languageSettingsPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: languageSettingsPrivate */

/** @const */
chrome.languageSettingsPrivate = {};

/**
 * @enum {string}
 */
chrome.languageSettingsPrivate.MoveType = {
  TOP: 'TOP',
  UP: 'UP',
  DOWN: 'DOWN',
  UNKNOWN: 'UNKNOWN',
};

/**
 * @typedef {{
 *   code: string,
 *   displayName: string,
 *   nativeDisplayName: string,
 *   supportsUI: (boolean|undefined),
 *   supportsSpellcheck: (boolean|undefined),
 *   supportsTranslate: (boolean|undefined),
 *   isProhibitedLanguage: (boolean|undefined)
 * }}
 */
chrome.languageSettingsPrivate.Language;

/**
 * @typedef {{
 *   languageCode: string,
 *   isReady: boolean,
 *   isDownloading: (boolean|undefined),
 *   downloadFailed: (boolean|undefined)
 * }}
 */
chrome.languageSettingsPrivate.SpellcheckDictionaryStatus;

/**
 * @typedef {{
 *   id: string,
 *   displayName: string,
 *   languageCodes: !Array<string>,
 *   tags: !Array<string>,
 *   enabled: (boolean|undefined),
 *   hasOptionsPage: (boolean|undefined),
 *   isProhibitedByPolicy: (boolean|undefined)
 * }}
 */
chrome.languageSettingsPrivate.InputMethod;

/**
 * @typedef {{
 *   componentExtensionImes: !Array<!chrome.languageSettingsPrivate.InputMethod>,
 *   thirdPartyExtensionImes: !Array<!chrome.languageSettingsPrivate.InputMethod>
 * }}
 */
chrome.languageSettingsPrivate.InputMethodLists;

/**
 * Gets languages available for translate, spell checking, input and locale.
 * @param {function(!Array<!chrome.languageSettingsPrivate.Language>): void}
 *     callback
 */
chrome.languageSettingsPrivate.getLanguageList = function(callback) {};

/**
 * Enables a language, adding it to the Accept-Language list (used to decide
 * which languages to translate, generate the Accept-Language header, etc.).
 * @param {string} languageCode
 */
chrome.languageSettingsPrivate.enableLanguage = function(languageCode) {};

/**
 * Disables a language, removing it from the Accept-Language list.
 * @param {string} languageCode
 */
chrome.languageSettingsPrivate.disableLanguage = function(languageCode) {};

/**
 * Enables or disables translation for a given language.
 * @param {string} languageCode
 * @param {boolean} enable
 */
chrome.languageSettingsPrivate.setEnableTranslationForLanguage = function(languageCode, enable) {};

/**
 * Moves a language inside the language list.
 * @param {string} languageCode
 * @param {!chrome.languageSettingsPrivate.MoveType} moveType
 */
chrome.languageSettingsPrivate.moveLanguage = function(languageCode, moveType) {};

/**
 * Gets the current status of the chosen spell check dictionaries.
 * @param {function(!Array<!chrome.languageSettingsPrivate.SpellcheckDictionaryStatus>): void}
 *     callback
 */
chrome.languageSettingsPrivate.getSpellcheckDictionaryStatuses = function(callback) {};

/**
 * Gets the custom spell check words, in sorted order.
 * @param {function(!Array<string>): void} callback
 */
chrome.languageSettingsPrivate.getSpellcheckWords = function(callback) {};

/**
 * Adds a word to the custom dictionary.
 * @param {string} word
 */
chrome.languageSettingsPrivate.addSpellcheckWord = function(word) {};

/**
 * Removes a word from the custom dictionary.
 * @param {string} word
 */
chrome.languageSettingsPrivate.removeSpellcheckWord = function(word) {};

/**
 * Gets the translate target language (in most cases, the display locale).
 * @param {function(string): void} callback
 */
chrome.languageSettingsPrivate.getTranslateTargetLanguage = function(callback) {};

/**
 * Gets all supported input methods, including third-party IMEs. Chrome OS only.
 * @param {function(!chrome.languageSettingsPrivate.InputMethodLists): void}
 *     callback
 */
chrome.languageSettingsPrivate.getInputMethodLists = function(callback) {};

/**
 * Adds the input method to the current user's list of enabled input methods,
 * enabling the input method for the current user. Chrome OS only.
 * @param {string} inputMethodId
 */
chrome.languageSettingsPrivate.addInputMethod = function(inputMethodId) {};

/**
 * Removes the input method from the current user's list of enabled input
 * methods, disabling the input method for the current user. Chrome OS only.
 * @param {string} inputMethodId
 */
chrome.languageSettingsPrivate.removeInputMethod = function(inputMethodId) {};

/**
 * Tries to download the dictionary after a failed download.
 * @param {string} languageCode
 */
chrome.languageSettingsPrivate.retryDownloadDictionary = function(languageCode) {};

/**
 * Called when the pref for the dictionaries used for spell checking changes or
 * the status of one of the spell check dictionaries changes.
 * @type {!ChromeEvent}
 */
chrome.languageSettingsPrivate.onSpellcheckDictionariesChanged;

/**
 * Called when words are added to and/or removed from the custom spell check
 * dictionary.
 * @type {!ChromeEvent}
 */
chrome.languageSettingsPrivate.onCustomDictionaryChanged;

/**
 * Called when an input method is added.
 * @type {!ChromeEvent}
 */
chrome.languageSettingsPrivate.onInputMethodAdded;

/**
 * Called when an input method is removed.
 * @type {!ChromeEvent}
 */
chrome.languageSettingsPrivate.onInputMethodRemoved;
