// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.events.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: events */

/** @const */
chrome.events = {};

/**
 * Description of a declarative rule for handling events.
 * @typedef {{
 *   id: (string|undefined),
 *   tags: (!Array<string>|undefined),
 *   conditions: !Array<*>,
 *   actions: !Array<*>,
 *   priority: (number|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/events#type-Rule
 */
chrome.events.Rule;

/**
 * An object which allows the addition and removal of listeners for a Chrome event.
 * @typedef {Object}
 * @see https://developer.chrome.com/extensions/events#type-Event
 */
chrome.events.Event;

/**
 * Filters URLs for various criteria. See <a href='events#filtered'>event filtering</a>. All criteria are case sensitive.
 * @typedef {{
 *   hostContains: (string|undefined),
 *   hostEquals: (string|undefined),
 *   hostPrefix: (string|undefined),
 *   hostSuffix: (string|undefined),
 *   pathContains: (string|undefined),
 *   pathEquals: (string|undefined),
 *   pathPrefix: (string|undefined),
 *   pathSuffix: (string|undefined),
 *   queryContains: (string|undefined),
 *   queryEquals: (string|undefined),
 *   queryPrefix: (string|undefined),
 *   querySuffix: (string|undefined),
 *   urlContains: (string|undefined),
 *   urlEquals: (string|undefined),
 *   urlMatches: (string|undefined),
 *   originAndPathMatches: (string|undefined),
 *   urlPrefix: (string|undefined),
 *   urlSuffix: (string|undefined),
 *   schemes: (!Array<string>|undefined),
 *   ports: (!Array<(number|!Array<number>)>|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/events#type-UrlFilter
 */
chrome.events.UrlFilter;
