// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.crashReportPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See
// https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: crashReportPrivate */

/** @const */
chrome.crashReportPrivate = {};

/**
 * @typedef {{
 *   message: string,
 *   url: string,
 *   product: (string|undefined),
 *   version: (string|undefined),
 *   lineNumber: (number|undefined),
 *   columnNumber: (number|undefined),
 *   stackTrace: (string|undefined)
 * }}
 */
chrome.crashReportPrivate.ErrorInfo;

/**
 * Report and upload an error to Crash.
 * @param {!chrome.crashReportPrivate.ErrorInfo} info Information about the
 *     error.
 * @param {function(): void} callback Called when the error has been uploaded.
 */
chrome.crashReportPrivate.reportError = function(info, callback) {};
