// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   ./tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.bluetoothPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

// IMPORTANT NOTE: Work-around for crbug.com/543822
// s/chrome.bluetoothPrivate.bluetooth.Device/chrome.bluetooth.Device/

/** @fileoverview Externs generated from namespace: bluetoothPrivate */

/** @const */
chrome.bluetoothPrivate = {};

/**
 * @enum {string}
 */
chrome.bluetoothPrivate.PairingEventType = {
  REQUEST_PINCODE: 'requestPincode',
  DISPLAY_PINCODE: 'displayPincode',
  REQUEST_PASSKEY: 'requestPasskey',
  DISPLAY_PASSKEY: 'displayPasskey',
  KEYS_ENTERED: 'keysEntered',
  CONFIRM_PASSKEY: 'confirmPasskey',
  REQUEST_AUTHORIZATION: 'requestAuthorization',
  COMPLETE: 'complete',
};

/**
 * @enum {string}
 */
chrome.bluetoothPrivate.ConnectResultType = {
  ALREADY_CONNECTED: 'alreadyConnected',
  AUTH_CANCELED: 'authCanceled',
  AUTH_FAILED: 'authFailed',
  AUTH_REJECTED: 'authRejected',
  AUTH_TIMEOUT: 'authTimeout',
  FAILED: 'failed',
  IN_PROGRESS: 'inProgress',
  SUCCESS: 'success',
  UNKNOWN_ERROR: 'unknownError',
  UNSUPPORTED_DEVICE: 'unsupportedDevice',
};

/**
 * @enum {string}
 */
chrome.bluetoothPrivate.PairingResponse = {
  CONFIRM: 'confirm',
  REJECT: 'reject',
  CANCEL: 'cancel',
};

/**
 * @enum {string}
 */
chrome.bluetoothPrivate.TransportType = {
  LE: 'le',
  BREDR: 'bredr',
  DUAL: 'dual',
};

/**
 * @typedef {{
 *   pairing: !chrome.bluetoothPrivate.PairingEventType,
 *   device: !chrome.bluetooth.Device,
 *   pincode: (string|undefined),
 *   passkey: (number|undefined),
 *   enteredKey: (number|undefined)
 * }}
 */
chrome.bluetoothPrivate.PairingEvent;

/**
 * @typedef {{
 *   name: (string|undefined),
 *   powered: (boolean|undefined),
 *   discoverable: (boolean|undefined)
 * }}
 */
chrome.bluetoothPrivate.NewAdapterState;

/**
 * @typedef {{
 *   device: !chrome.bluetooth.Device,
 *   response: !chrome.bluetoothPrivate.PairingResponse,
 *   pincode: (string|undefined),
 *   passkey: (number|undefined)
 * }}
 */
chrome.bluetoothPrivate.SetPairingResponseOptions;

/**
 * @typedef {{
 *   transport: (!chrome.bluetoothPrivate.TransportType|undefined),
 *   uuids: ((string|!Array<string>)|undefined),
 *   rssi: (number|undefined),
 *   pathloss: (number|undefined)
 * }}
 */
chrome.bluetoothPrivate.DiscoveryFilter;

/**
 * Changes the state of the Bluetooth adapter.
 * @param {!chrome.bluetoothPrivate.NewAdapterState} adapterState The new state
 *     of the adapter.
 * @param {function(): void=} callback Called when all the state changes have
 *     been completed.
 */
chrome.bluetoothPrivate.setAdapterState = function(adapterState, callback) {};

/**
 * @param {!chrome.bluetoothPrivate.SetPairingResponseOptions} options
 * @param {function(): void=} callback
 */
chrome.bluetoothPrivate.setPairingResponse = function(options, callback) {};

/**
 * Tears down all connections to the given device.
 * @param {string} deviceAddress
 * @param {function(): void=} callback
 */
chrome.bluetoothPrivate.disconnectAll = function(deviceAddress, callback) {};

/**
 * Forgets the given device.
 * @param {string} deviceAddress
 * @param {function(): void=} callback
 */
chrome.bluetoothPrivate.forgetDevice = function(deviceAddress, callback) {};

/**
 * Set or clear discovery filter.
 * @param {!chrome.bluetoothPrivate.DiscoveryFilter} discoveryFilter
 * @param {function(): void=} callback
 */
chrome.bluetoothPrivate.setDiscoveryFilter = function(discoveryFilter, callback) {};

/**
 * Connects to the given device. This will only throw an error if the device
 * address is invalid or the device is already connected. Otherwise this will
 * succeed and invoke |callback| with ConnectResultType.
 * @param {string} deviceAddress
 * @param {function(!chrome.bluetoothPrivate.ConnectResultType): void=} callback
 */
chrome.bluetoothPrivate.connect = function(deviceAddress, callback) {};

/**
 * Pairs the given device.
 * @param {string} deviceAddress
 * @param {function(): void=} callback
 */
chrome.bluetoothPrivate.pair = function(deviceAddress, callback) {};

/**
 * Record that a pairing attempt finished. Ignores cancellations.
 * @param {!chrome.bluetooth.Transport} transport
 * @param {number} pairingDurationMs
 * @param {!chrome.bluetoothPrivate.ConnectResultType=} result
 */
chrome.bluetoothPrivate.recordPairing = function(transport, pairingDurationMs, result) {};

/**
 * Record that a user-initiated reconnection attempt to an already paired device
 * finished. Ignores cancellations.
 * @param {!chrome.bluetoothPrivate.ConnectResultType=} result
 */
chrome.bluetoothPrivate.recordReconnection = function(result) {};

/**
 * Record that a user selected a device to connect to.
 * @param {number} selectionDurationMs
 * @param {boolean} wasPaired
 * @param {!chrome.bluetooth.Transport} transport
 */
chrome.bluetoothPrivate.recordDeviceSelection = function(selectionDurationMs, wasPaired, transport) {};

/**
 * Fired when a pairing event occurs.
 * @type {!ChromeEvent}
 */
chrome.bluetoothPrivate.onPairing;

/**
 * Fired when a Bluetooth device changed its address.
 * @type {!ChromeEvent}
 */
chrome.bluetoothPrivate.onDeviceAddressChanged;
