// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.bluetooth.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: bluetooth */

/**
 * @const
 */
chrome.bluetooth = {};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/bluetooth#type-VendorIdSource
 */
chrome.bluetooth.VendorIdSource = {
  BLUETOOTH: 'bluetooth',
  USB: 'usb',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/bluetooth#type-DeviceType
 */
chrome.bluetooth.DeviceType = {
  COMPUTER: 'computer',
  PHONE: 'phone',
  MODEM: 'modem',
  AUDIO: 'audio',
  CAR_AUDIO: 'carAudio',
  VIDEO: 'video',
  PERIPHERAL: 'peripheral',
  JOYSTICK: 'joystick',
  GAMEPAD: 'gamepad',
  KEYBOARD: 'keyboard',
  MOUSE: 'mouse',
  TABLET: 'tablet',
  KEYBOARD_MOUSE_COMBO: 'keyboardMouseCombo',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/bluetooth#type-FilterType
 */
chrome.bluetooth.FilterType = {
  ALL: 'all',
  KNOWN: 'known',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/bluetooth#type-Transport
 */
chrome.bluetooth.Transport = {
  INVALID: 'invalid',
  CLASSIC: 'classic',
  LE: 'le',
  DUAL: 'dual',
};

/**
 * @typedef {{
 *   address: string,
 *   name: string,
 *   powered: boolean,
 *   available: boolean,
 *   discovering: boolean
 * }}
 * @see https://developer.chrome.com/extensions/bluetooth#type-AdapterState
 */
chrome.bluetooth.AdapterState;

/**
 * @typedef {{
 *   address: string,
 *   name: (string|undefined),
 *   deviceClass: (number|undefined),
 *   vendorIdSource: (!chrome.bluetooth.VendorIdSource|undefined),
 *   vendorId: (number|undefined),
 *   productId: (number|undefined),
 *   deviceId: (number|undefined),
 *   type: (!chrome.bluetooth.DeviceType|undefined),
 *   paired: (boolean|undefined),
 *   connected: (boolean|undefined),
 *   connecting: (boolean|undefined),
 *   connectable: (boolean|undefined),
 *   uuids: (!Array<string>|undefined),
 *   inquiryRssi: (number|undefined),
 *   inquiryTxPower: (number|undefined),
 *   transport: (!chrome.bluetooth.Transport|undefined),
 *   batteryPercentage: (number|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/bluetooth#type-Device
 */
chrome.bluetooth.Device;

/**
 * @typedef {{
 *   filterType: (!chrome.bluetooth.FilterType|undefined),
 *   limit: (number|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/bluetooth#type-BluetoothFilter
 */
chrome.bluetooth.BluetoothFilter;

/**
 * Get information about the Bluetooth adapter.
 * @param {function(!chrome.bluetooth.AdapterState): void} callback Called with
 *     an AdapterState object describing the adapter state.
 * @see https://developer.chrome.com/extensions/bluetooth#method-getAdapterState
 */
chrome.bluetooth.getAdapterState = function(callback) {};

/**
 * Get information about a Bluetooth device known to the system.
 * @param {string} deviceAddress Address of device to get.
 * @param {function(!chrome.bluetooth.Device): void} callback Called with the
 *     Device object describing the device.
 * @see https://developer.chrome.com/extensions/bluetooth#method-getDevice
 */
chrome.bluetooth.getDevice = function(deviceAddress, callback) {};

/**
 * Get a list of Bluetooth devices known to the system, including paired and
 * recently discovered devices.
 * @param {!chrome.bluetooth.BluetoothFilter=} filter Some criteria to filter
 *     the list of returned bluetooth devices. If the filter is not set or set
 *     to <code>{}</code>, returned device list will contain all bluetooth
 *     devices. Right now this is only supported in ChromeOS, for other
 *     platforms, a full list is returned.
 * @param {function(!Array<!chrome.bluetooth.Device>): void=} callback Called when
 *     the search is completed.
 * @see https://developer.chrome.com/extensions/bluetooth#method-getDevices
 */
chrome.bluetooth.getDevices = function(filter, callback) {};

/**
 * <p>Start discovery. Newly discovered devices will be returned via the
 * onDeviceAdded event. Previously discovered devices already known to the
 * adapter must be obtained using getDevices and will only be updated using the
 * |onDeviceChanged| event if information about them changes.</p><p>Discovery
 * will fail to start if this application has already called startDiscovery.
 * Discovery can be resource intensive: stopDiscovery should be called as soon
 * as possible.</p>
 * @param {function(): void=} callback Called to indicate success or failure.
 * @see https://developer.chrome.com/extensions/bluetooth#method-startDiscovery
 */
chrome.bluetooth.startDiscovery = function(callback) {};

/**
 * Stop discovery.
 * @param {function(): void=} callback Called to indicate success or failure.
 * @see https://developer.chrome.com/extensions/bluetooth#method-stopDiscovery
 */
chrome.bluetooth.stopDiscovery = function(callback) {};

/**
 * Fired when the state of the Bluetooth adapter changes.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/bluetooth#event-onAdapterStateChanged
 */
chrome.bluetooth.onAdapterStateChanged;

/**
 * Fired when information about a new Bluetooth device is available.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/bluetooth#event-onDeviceAdded
 */
chrome.bluetooth.onDeviceAdded;

/**
 * Fired when information about a known Bluetooth device has changed.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/bluetooth#event-onDeviceChanged
 */
chrome.bluetooth.onDeviceChanged;

/**
 * Fired when a Bluetooth device that was previously discovered has been out of
 * range for long enough to be considered unavailable again, and when a paired
 * device is removed.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/bluetooth#event-onDeviceRemoved
 */
chrome.bluetooth.onDeviceRemoved;
