// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.automation.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: automation */

/** @const */
chrome.automation = {};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-EventType
 */
chrome.automation.EventType = {
  ACCESS_KEY_CHANGED: 'accessKeyChanged',
  ACTIVE_DESCENDANT_CHANGED: 'activeDescendantChanged',
  ALERT: 'alert',
  ARIA_ATTRIBUTE_CHANGED: 'ariaAttributeChanged',
  ARIA_CURRENT_CHANGED: 'ariaCurrentChanged',
  ATOMIC_CHANGED: 'atomicChanged',
  AUTO_COMPLETE_CHANGED: 'autoCompleteChanged',
  AUTOCORRECTION_OCCURED: 'autocorrectionOccured',
  BLUR: 'blur',
  BUSY_CHANGED: 'busyChanged',
  CHECKED_STATE_CHANGED: 'checkedStateChanged',
  CHILDREN_CHANGED: 'childrenChanged',
  CLASS_NAME_CHANGED: 'classNameChanged',
  CLICKED: 'clicked',
  COLLAPSED: 'collapsed',
  CONTROLS_CHANGED: 'controlsChanged',
  DESCRIBED_BY_CHANGED: 'describedByChanged',
  DESCRIPTION_CHANGED: 'descriptionChanged',
  DOCUMENT_SELECTION_CHANGED: 'documentSelectionChanged',
  DOCUMENT_TITLE_CHANGED: 'documentTitleChanged',
  DROPEFFECT_CHANGED: 'dropeffectChanged',
  EDITABLE_TEXT_CHANGED: 'editableTextChanged',
  ENABLED_CHANGED: 'enabledChanged',
  END_OF_TEST: 'endOfTest',
  EXPANDED: 'expanded',
  EXPANDED_CHANGED: 'expandedChanged',
  FLOW_FROM_CHANGED: 'flowFromChanged',
  FLOW_TO_CHANGED: 'flowToChanged',
  FOCUS: 'focus',
  FOCUS_AFTER_MENU_CLOSE: 'focusAfterMenuClose',
  FOCUS_CHANGED: 'focusChanged',
  FOCUS_CONTEXT: 'focusContext',
  GRABBED_CHANGED: 'grabbedChanged',
  HASPOPUP_CHANGED: 'haspopupChanged',
  HIDE: 'hide',
  HIERARCHICAL_LEVEL_CHANGED: 'hierarchicalLevelChanged',
  HIT_TEST_RESULT: 'hitTestResult',
  HOVER: 'hover',
  IGNORED_CHANGED: 'ignoredChanged',
  IMAGE_ANNOTATION_CHANGED: 'imageAnnotationChanged',
  IMAGE_FRAME_UPDATED: 'imageFrameUpdated',
  INVALID_STATUS_CHANGED: 'invalidStatusChanged',
  KEY_SHORTCUTS_CHANGED: 'keyShortcutsChanged',
  LABELED_BY_CHANGED: 'labeledByChanged',
  LANGUAGE_CHANGED: 'languageChanged',
  LAYOUT_COMPLETE: 'layoutComplete',
  LAYOUT_INVALIDATED: 'layoutInvalidated',
  LIVE_REGION_CHANGED: 'liveRegionChanged',
  LIVE_REGION_CREATED: 'liveRegionCreated',
  LIVE_REGION_NODE_CHANGED: 'liveRegionNodeChanged',
  LIVE_RELEVANT_CHANGED: 'liveRelevantChanged',
  LIVE_STATUS_CHANGED: 'liveStatusChanged',
  LOAD_COMPLETE: 'loadComplete',
  LOAD_START: 'loadStart',
  LOCATION_CHANGED: 'locationChanged',
  MEDIA_STARTED_PLAYING: 'mediaStartedPlaying',
  MEDIA_STOPPED_PLAYING: 'mediaStoppedPlaying',
  MENU_END: 'menuEnd',
  MENU_ITEM_SELECTED: 'menuItemSelected',
  MENU_LIST_ITEM_SELECTED: 'menuListItemSelected',
  MENU_LIST_VALUE_CHANGED: 'menuListValueChanged',
  MENU_POPUP_END: 'menuPopupEnd',
  MENU_POPUP_START: 'menuPopupStart',
  MENU_START: 'menuStart',
  MOUSE_CANCELED: 'mouseCanceled',
  MOUSE_DRAGGED: 'mouseDragged',
  MOUSE_MOVED: 'mouseMoved',
  MOUSE_PRESSED: 'mousePressed',
  MOUSE_RELEASED: 'mouseReleased',
  MULTILINE_STATE_CHANGED: 'multilineStateChanged',
  MULTISELECTABLE_STATE_CHANGED: 'multiselectableStateChanged',
  NAME_CHANGED: 'nameChanged',
  OBJECT_ATTRIBUTE_CHANGED: 'objectAttributeChanged',
  OTHER_ATTRIBUTE_CHANGED: 'otherAttributeChanged',
  PARENT_CHANGED: 'parentChanged',
  PLACEHOLDER_CHANGED: 'placeholderChanged',
  PORTAL_ACTIVATED: 'portalActivated',
  POSITION_IN_SET_CHANGED: 'positionInSetChanged',
  RANGE_VALUE_CHANGED: 'rangeValueChanged',
  RANGE_VALUE_MAX_CHANGED: 'rangeValueMaxChanged',
  RANGE_VALUE_MIN_CHANGED: 'rangeValueMinChanged',
  RANGE_VALUE_STEP_CHANGED: 'rangeValueStepChanged',
  READONLY_CHANGED: 'readonlyChanged',
  RELATED_NODE_CHANGED: 'relatedNodeChanged',
  REQUIRED_STATE_CHANGED: 'requiredStateChanged',
  ROLE_CHANGED: 'roleChanged',
  ROW_COLLAPSED: 'rowCollapsed',
  ROW_COUNT_CHANGED: 'rowCountChanged',
  ROW_EXPANDED: 'rowExpanded',
  SCROLL_HORIZONTAL_POSITION_CHANGED: 'scrollHorizontalPositionChanged',
  SCROLL_POSITION_CHANGED: 'scrollPositionChanged',
  SCROLL_VERTICAL_POSITION_CHANGED: 'scrollVerticalPositionChanged',
  SCROLLED_TO_ANCHOR: 'scrolledToAnchor',
  SELECTED_CHANGED: 'selectedChanged',
  SELECTED_CHILDREN_CHANGED: 'selectedChildrenChanged',
  SELECTED_VALUE_CHANGED: 'selectedValueChanged',
  SELECTION: 'selection',
  SELECTION_ADD: 'selectionAdd',
  SELECTION_IN_TEXT_FIELD_CHANGED: 'selectionInTextFieldChanged',
  SELECTION_REMOVE: 'selectionRemove',
  SET_SIZE_CHANGED: 'setSizeChanged',
  SHOW: 'show',
  SORT_CHANGED: 'sortChanged',
  STATE_CHANGED: 'stateChanged',
  SUBTREE_CREATED: 'subtreeCreated',
  TEXT_ATTRIBUTE_CHANGED: 'textAttributeChanged',
  TEXT_SELECTION_CHANGED: 'textSelectionChanged',
  TEXT_CHANGED: 'textChanged',
  TOOLTIP_CLOSED: 'tooltipClosed',
  TOOLTIP_OPENED: 'tooltipOpened',
  TREE_CHANGED: 'treeChanged',
  VALUE_IN_TEXT_FIELD_CHANGED: 'valueInTextFieldChanged',
  VALUE_CHANGED: 'valueChanged',
  WINDOW_ACTIVATED: 'windowActivated',
  WINDOW_DEACTIVATED: 'windowDeactivated',
  WINDOW_VISIBILITY_CHANGED: 'windowVisibilityChanged',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-RoleType
 */
chrome.automation.RoleType = {
  ABBR: 'abbr',
  ALERT: 'alert',
  ALERT_DIALOG: 'alertDialog',
  ANCHOR: 'anchor',
  APPLICATION: 'application',
  ARTICLE: 'article',
  AUDIO: 'audio',
  BANNER: 'banner',
  BLOCKQUOTE: 'blockquote',
  BUTTON: 'button',
  CANVAS: 'canvas',
  CAPTION: 'caption',
  CARET: 'caret',
  CELL: 'cell',
  CHECK_BOX: 'checkBox',
  CLIENT: 'client',
  CODE: 'code',
  COLOR_WELL: 'colorWell',
  COLUMN: 'column',
  COLUMN_HEADER: 'columnHeader',
  COMBO_BOX_GROUPING: 'comboBoxGrouping',
  COMBO_BOX_MENU_BUTTON: 'comboBoxMenuButton',
  COMMENT: 'comment',
  COMPLEMENTARY: 'complementary',
  CONTENT_DELETION: 'contentDeletion',
  CONTENT_INSERTION: 'contentInsertion',
  CONTENT_INFO: 'contentInfo',
  DATE: 'date',
  DATE_TIME: 'dateTime',
  DEFINITION: 'definition',
  DESCRIPTION_LIST: 'descriptionList',
  DESCRIPTION_LIST_DETAIL: 'descriptionListDetail',
  DESCRIPTION_LIST_TERM: 'descriptionListTerm',
  DESKTOP: 'desktop',
  DETAILS: 'details',
  DIALOG: 'dialog',
  DIRECTORY: 'directory',
  DISCLOSURE_TRIANGLE: 'disclosureTriangle',
  DOC_ABSTRACT: 'docAbstract',
  DOC_ACKNOWLEDGMENTS: 'docAcknowledgments',
  DOC_AFTERWORD: 'docAfterword',
  DOC_APPENDIX: 'docAppendix',
  DOC_BACK_LINK: 'docBackLink',
  DOC_BIBLIO_ENTRY: 'docBiblioEntry',
  DOC_BIBLIOGRAPHY: 'docBibliography',
  DOC_BIBLIO_REF: 'docBiblioRef',
  DOC_CHAPTER: 'docChapter',
  DOC_COLOPHON: 'docColophon',
  DOC_CONCLUSION: 'docConclusion',
  DOC_COVER: 'docCover',
  DOC_CREDIT: 'docCredit',
  DOC_CREDITS: 'docCredits',
  DOC_DEDICATION: 'docDedication',
  DOC_ENDNOTE: 'docEndnote',
  DOC_ENDNOTES: 'docEndnotes',
  DOC_EPIGRAPH: 'docEpigraph',
  DOC_EPILOGUE: 'docEpilogue',
  DOC_ERRATA: 'docErrata',
  DOC_EXAMPLE: 'docExample',
  DOC_FOOTNOTE: 'docFootnote',
  DOC_FOREWORD: 'docForeword',
  DOC_GLOSSARY: 'docGlossary',
  DOC_GLOSS_REF: 'docGlossRef',
  DOC_INDEX: 'docIndex',
  DOC_INTRODUCTION: 'docIntroduction',
  DOC_NOTE_REF: 'docNoteRef',
  DOC_NOTICE: 'docNotice',
  DOC_PAGE_BREAK: 'docPageBreak',
  DOC_PAGE_FOOTER: 'docPageFooter',
  DOC_PAGE_HEADER: 'docPageHeader',
  DOC_PAGE_LIST: 'docPageList',
  DOC_PART: 'docPart',
  DOC_PREFACE: 'docPreface',
  DOC_PROLOGUE: 'docPrologue',
  DOC_PULLQUOTE: 'docPullquote',
  DOC_QNA: 'docQna',
  DOC_SUBTITLE: 'docSubtitle',
  DOC_TIP: 'docTip',
  DOC_TOC: 'docToc',
  DOCUMENT: 'document',
  EMBEDDED_OBJECT: 'embeddedObject',
  EMPHASIS: 'emphasis',
  FEED: 'feed',
  FIGCAPTION: 'figcaption',
  FIGURE: 'figure',
  FOOTER: 'footer',
  FOOTER_AS_NON_LANDMARK: 'footerAsNonLandmark',
  FORM: 'form',
  GENERIC_CONTAINER: 'genericContainer',
  GRAPHICS_DOCUMENT: 'graphicsDocument',
  GRAPHICS_OBJECT: 'graphicsObject',
  GRAPHICS_SYMBOL: 'graphicsSymbol',
  GRID: 'grid',
  GROUP: 'group',
  HEADER: 'header',
  HEADER_AS_NON_LANDMARK: 'headerAsNonLandmark',
  HEADING: 'heading',
  IFRAME: 'iframe',
  IFRAME_PRESENTATIONAL: 'iframePresentational',
  IGNORED: 'ignored',
  IMAGE: 'image',
  IMAGE_MAP: 'imageMap',
  IME_CANDIDATE: 'imeCandidate',
  INLINE_TEXT_BOX: 'inlineTextBox',
  INPUT_TIME: 'inputTime',
  KEYBOARD: 'keyboard',
  LABEL_TEXT: 'labelText',
  LAYOUT_TABLE: 'layoutTable',
  LAYOUT_TABLE_CELL: 'layoutTableCell',
  LAYOUT_TABLE_ROW: 'layoutTableRow',
  LEGEND: 'legend',
  LINE_BREAK: 'lineBreak',
  LINK: 'link',
  LIST: 'list',
  LIST_BOX: 'listBox',
  LIST_BOX_OPTION: 'listBoxOption',
  LIST_GRID: 'listGrid',
  LIST_ITEM: 'listItem',
  LIST_MARKER: 'listMarker',
  LOG: 'log',
  MAIN: 'main',
  MARK: 'mark',
  MARQUEE: 'marquee',
  MATH: 'math',
  MENU: 'menu',
  MENU_BAR: 'menuBar',
  MENU_ITEM: 'menuItem',
  MENU_ITEM_CHECK_BOX: 'menuItemCheckBox',
  MENU_ITEM_RADIO: 'menuItemRadio',
  MENU_LIST_OPTION: 'menuListOption',
  MENU_LIST_POPUP: 'menuListPopup',
  METER: 'meter',
  NAVIGATION: 'navigation',
  NOTE: 'note',
  PANE: 'pane',
  PARAGRAPH: 'paragraph',
  PDF_ACTIONABLE_HIGHLIGHT: 'pdfActionableHighlight',
  PDF_ROOT: 'pdfRoot',
  PLUGIN_OBJECT: 'pluginObject',
  POP_UP_BUTTON: 'popUpButton',
  PORTAL: 'portal',
  PRE: 'pre',
  PRESENTATIONAL: 'presentational',
  PROGRESS_INDICATOR: 'progressIndicator',
  RADIO_BUTTON: 'radioButton',
  RADIO_GROUP: 'radioGroup',
  REGION: 'region',
  ROOT_WEB_AREA: 'rootWebArea',
  ROW: 'row',
  ROW_GROUP: 'rowGroup',
  ROW_HEADER: 'rowHeader',
  RUBY: 'ruby',
  RUBY_ANNOTATION: 'rubyAnnotation',
  SCROLL_BAR: 'scrollBar',
  SCROLL_VIEW: 'scrollView',
  SEARCH: 'search',
  SEARCH_BOX: 'searchBox',
  SECTION: 'section',
  SLIDER: 'slider',
  SPIN_BUTTON: 'spinButton',
  SPLITTER: 'splitter',
  STATIC_TEXT: 'staticText',
  STATUS: 'status',
  STRONG: 'strong',
  SUGGESTION: 'suggestion',
  SVG_ROOT: 'svgRoot',
  SWITCH: 'switch',
  TAB: 'tab',
  TAB_LIST: 'tabList',
  TAB_PANEL: 'tabPanel',
  TABLE: 'table',
  TABLE_HEADER_CONTAINER: 'tableHeaderContainer',
  TERM: 'term',
  TEXT_FIELD: 'textField',
  TEXT_FIELD_WITH_COMBO_BOX: 'textFieldWithComboBox',
  TIME: 'time',
  TIMER: 'timer',
  TITLE_BAR: 'titleBar',
  TOGGLE_BUTTON: 'toggleButton',
  TOOLBAR: 'toolbar',
  TOOLTIP: 'tooltip',
  TREE: 'tree',
  TREE_GRID: 'treeGrid',
  TREE_ITEM: 'treeItem',
  UNKNOWN: 'unknown',
  VIDEO: 'video',
  WEB_VIEW: 'webView',
  WINDOW: 'window',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-StateType
 */
chrome.automation.StateType = {
  AUTOFILL_AVAILABLE: 'autofillAvailable',
  COLLAPSED: 'collapsed',
  DEFAULT: 'default',
  EDITABLE: 'editable',
  EXPANDED: 'expanded',
  FOCUSABLE: 'focusable',
  FOCUSED: 'focused',
  HORIZONTAL: 'horizontal',
  HOVERED: 'hovered',
  IGNORED: 'ignored',
  INVISIBLE: 'invisible',
  LINKED: 'linked',
  MULTILINE: 'multiline',
  MULTISELECTABLE: 'multiselectable',
  OFFSCREEN: 'offscreen',
  PROTECTED: 'protected',
  REQUIRED: 'required',
  RICHLY_EDITABLE: 'richlyEditable',
  VERTICAL: 'vertical',
  VISITED: 'visited',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-ActionType
 */
chrome.automation.ActionType = {
  ANNOTATE_PAGE_IMAGES: 'annotatePageImages',
  BLUR: 'blur',
  CLEAR_ACCESSIBILITY_FOCUS: 'clearAccessibilityFocus',
  COLLAPSE: 'collapse',
  CUSTOM_ACTION: 'customAction',
  DECREMENT: 'decrement',
  DO_DEFAULT: 'doDefault',
  EXPAND: 'expand',
  FOCUS: 'focus',
  GET_IMAGE_DATA: 'getImageData',
  GET_TEXT_LOCATION: 'getTextLocation',
  HIDE_TOOLTIP: 'hideTooltip',
  HIT_TEST: 'hitTest',
  INCREMENT: 'increment',
  INTERNAL_INVALIDATE_TREE: 'internalInvalidateTree',
  LOAD_INLINE_TEXT_BOXES: 'loadInlineTextBoxes',
  REPLACE_SELECTED_TEXT: 'replaceSelectedText',
  SCROLL_BACKWARD: 'scrollBackward',
  SCROLL_DOWN: 'scrollDown',
  SCROLL_FORWARD: 'scrollForward',
  SCROLL_LEFT: 'scrollLeft',
  SCROLL_RIGHT: 'scrollRight',
  SCROLL_UP: 'scrollUp',
  SCROLL_TO_MAKE_VISIBLE: 'scrollToMakeVisible',
  SCROLL_TO_POINT: 'scrollToPoint',
  SET_ACCESSIBILITY_FOCUS: 'setAccessibilityFocus',
  SET_SCROLL_OFFSET: 'setScrollOffset',
  SET_SELECTION: 'setSelection',
  SET_SEQUENTIAL_FOCUS_NAVIGATION_STARTING_POINT: 'setSequentialFocusNavigationStartingPoint',
  SET_VALUE: 'setValue',
  SHOW_CONTEXT_MENU: 'showContextMenu',
  SIGNAL_END_OF_TEST: 'signalEndOfTest',
  SHOW_TOOLTIP: 'showTooltip',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-TreeChangeType
 */
chrome.automation.TreeChangeType = {
  NODE_CREATED: 'nodeCreated',
  SUBTREE_CREATED: 'subtreeCreated',
  NODE_CHANGED: 'nodeChanged',
  TEXT_CHANGED: 'textChanged',
  NODE_REMOVED: 'nodeRemoved',
  SUBTREE_UPDATE_END: 'subtreeUpdateEnd',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-NameFromType
 */
chrome.automation.NameFromType = {
  UNINITIALIZED: 'uninitialized',
  ATTRIBUTE: 'attribute',
  ATTRIBUTE_EXPLICITLY_EMPTY: 'attributeExplicitlyEmpty',
  CAPTION: 'caption',
  CONTENTS: 'contents',
  PLACEHOLDER: 'placeholder',
  RELATED_ELEMENT: 'relatedElement',
  TITLE: 'title',
  VALUE: 'value',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-DescriptionFromType
 */
chrome.automation.DescriptionFromType = {
  UNINITIALIZED: 'uninitialized',
  ATTRIBUTE: 'attribute',
  CONTENTS: 'contents',
  RELATED_ELEMENT: 'relatedElement',
  TITLE: 'title',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-Restriction
 */
chrome.automation.Restriction = {
  DISABLED: 'disabled',
  READ_ONLY: 'readOnly',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-HasPopup
 */
chrome.automation.HasPopup = {
  TRUE: 'true',
  MENU: 'menu',
  LISTBOX: 'listbox',
  TREE: 'tree',
  GRID: 'grid',
  DIALOG: 'dialog',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-DefaultActionVerb
 */
chrome.automation.DefaultActionVerb = {
  ACTIVATE: 'activate',
  CHECK: 'check',
  CLICK: 'click',
  CLICK_ANCESTOR: 'clickAncestor',
  JUMP: 'jump',
  OPEN: 'open',
  PRESS: 'press',
  SELECT: 'select',
  UNCHECK: 'uncheck',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-MarkerType
 */
chrome.automation.MarkerType = {
  SPELLING: 'spelling',
  GRAMMAR: 'grammar',
  TEXT_MATCH: 'textMatch',
  ACTIVE_SUGGESTION: 'activeSuggestion',
  SUGGESTION: 'suggestion',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-IntentCommandType
 */
chrome.automation.IntentCommandType = {
  CLEAR_SELECTION: 'clearSelection',
  DELETE: 'delete',
  DICTATE: 'dictate',
  EXTEND_SELECTION: 'extendSelection',
  FORMAT: 'format',
  HISTORY: 'history',
  INSERT: 'insert',
  MARKER: 'marker',
  MOVE_SELECTION: 'moveSelection',
  SET_SELECTION: 'setSelection',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-IntentInputEventType
 */
chrome.automation.IntentInputEventType = {
  INSERT_TEXT: 'insertText',
  INSERT_LINE_BREAK: 'insertLineBreak',
  INSERT_PARAGRAPH: 'insertParagraph',
  INSERT_ORDERED_LIST: 'insertOrderedList',
  INSERT_UNORDERED_LIST: 'insertUnorderedList',
  INSERT_HORIZONTAL_RULE: 'insertHorizontalRule',
  INSERT_FROM_PASTE: 'insertFromPaste',
  INSERT_FROM_DROP: 'insertFromDrop',
  INSERT_FROM_YANK: 'insertFromYank',
  INSERT_TRANSPOSE: 'insertTranspose',
  INSERT_REPLACEMENT_TEXT: 'insertReplacementText',
  INSERT_COMPOSITION_TEXT: 'insertCompositionText',
  DELETE_WORD_BACKWARD: 'deleteWordBackward',
  DELETE_WORD_FORWARD: 'deleteWordForward',
  DELETE_SOFT_LINE_BACKWARD: 'deleteSoftLineBackward',
  DELETE_SOFT_LINE_FORWARD: 'deleteSoftLineForward',
  DELETE_HARD_LINE_BACKWARD: 'deleteHardLineBackward',
  DELETE_HARD_LINE_FORWARD: 'deleteHardLineForward',
  DELETE_CONTENT_BACKWARD: 'deleteContentBackward',
  DELETE_CONTENT_FORWARD: 'deleteContentForward',
  DELETE_BY_CUT: 'deleteByCut',
  DELETE_BY_DRAG: 'deleteByDrag',
  HISTORY_UNDO: 'historyUndo',
  HISTORY_REDO: 'historyRedo',
  FORMAT_BOLD: 'formatBold',
  FORMAT_ITALIC: 'formatItalic',
  FORMAT_UNDERLINE: 'formatUnderline',
  FORMAT_STRIKE_THROUGH: 'formatStrikeThrough',
  FORMAT_SUPERSCRIPT: 'formatSuperscript',
  FORMAT_SUBSCRIPT: 'formatSubscript',
  FORMAT_JUSTIFY_CENTER: 'formatJustifyCenter',
  FORMAT_JUSTIFY_FULL: 'formatJustifyFull',
  FORMAT_JUSTIFY_RIGHT: 'formatJustifyRight',
  FORMAT_JUSTIFY_LEFT: 'formatJustifyLeft',
  FORMAT_INDENT: 'formatIndent',
  FORMAT_OUTDENT: 'formatOutdent',
  FORMAT_REMOVE: 'formatRemove',
  FORMAT_SET_BLOCK_TEXT_DIRECTION: 'formatSetBlockTextDirection',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-IntentTextBoundaryType
 */
chrome.automation.IntentTextBoundaryType = {
  CHARACTER: 'character',
  FORMAT: 'format',
  LINE_END: 'lineEnd',
  LINE_START: 'lineStart',
  LINE_START_OR_END: 'lineStartOrEnd',
  OBJECT: 'object',
  PAGE_END: 'pageEnd',
  PAGE_START: 'pageStart',
  PAGE_START_OR_END: 'pageStartOrEnd',
  PARAGRAPH_END: 'paragraphEnd',
  PARAGRAPH_START: 'paragraphStart',
  PARAGRAPH_START_OR_END: 'paragraphStartOrEnd',
  SENTENCE_END: 'sentenceEnd',
  SENTENCE_START: 'sentenceStart',
  SENTENCE_START_OR_END: 'sentenceStartOrEnd',
  WEB_PAGE: 'webPage',
  WORD_END: 'wordEnd',
  WORD_START: 'wordStart',
  WORD_START_OR_END: 'wordStartOrEnd',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-IntentMoveDirectionType
 */
chrome.automation.IntentMoveDirectionType = {
  BACKWARD: 'backward',
  FORWARD: 'forward',
};

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-SortDirectionType
 */
chrome.automation.SortDirectionType = {
  UNSORTED: 'unsorted',
  ASCENDING: 'ascending',
  DESCENDING: 'descending',
  OTHER: 'other',
};

/**
 * @typedef {{
 *   left: number,
 *   top: number,
 *   width: number,
 *   height: number
 * }}
 * @see https://developer.chrome.com/extensions/automation#type-Rect
 */
chrome.automation.Rect;

/**
 * @typedef {{
 *   role: (!chrome.automation.RoleType|undefined),
 *   state: (Object|undefined),
 *   attributes: (Object|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/automation#type-FindParams
 */
chrome.automation.FindParams;

/**
 * @typedef {{
 *   anchorObject: chrome.automation.AutomationNode,
 *   anchorOffset: number,
 *   focusObject: chrome.automation.AutomationNode,
 *   focusOffset: number
 * }}
 * @see https://developer.chrome.com/extensions/automation#type-SetDocumentSelectionParams
 */
chrome.automation.SetDocumentSelectionParams;

/**
 * @typedef {{
 *   command: !chrome.automation.IntentCommandType,
 *   textBoundary: !chrome.automation.IntentTextBoundaryType,
 *   moveDirection: !chrome.automation.IntentMoveDirectionType
 * }}
 * @see https://developer.chrome.com/extensions/automation#type-AutomationIntent
 */
chrome.automation.AutomationIntent;

/**
 * @constructor
 * @private
 * @see https://developer.chrome.com/extensions/automation#type-AutomationEvent
 */
chrome.automation.AutomationEvent = function() {};

/**
 * The $(ref:automation.AutomationNode) to which the event was targeted.
 * @type {!chrome.automation.AutomationNode}
 * @see https://developer.chrome.com/extensions/automation#type-target
 */
chrome.automation.AutomationEvent.prototype.target;

/**
 * The type of the event.
 * @type {!chrome.automation.EventType}
 * @see https://developer.chrome.com/extensions/automation#type-type
 */
chrome.automation.AutomationEvent.prototype.type;

/**
 * The source of this event.
 * @type {string}
 * @see https://developer.chrome.com/extensions/automation#type-eventFrom
 */
chrome.automation.AutomationEvent.prototype.eventFrom;

/**
 * Any mouse coordinates associated with this event.
 * @type {number}
 * @see https://developer.chrome.com/extensions/automation#type-mouseX
 */
chrome.automation.AutomationEvent.prototype.mouseX;

/**
 * @type {number}
 * @see https://developer.chrome.com/extensions/automation#type-mouseY
 */
chrome.automation.AutomationEvent.prototype.mouseY;

/**
 * A list of $(ref:automation.AutomationIntent)s associated with this event.
 * @type {!Array<!chrome.automation.AutomationIntent>}
 * @see https://developer.chrome.com/extensions/automation#type-intents
 */
chrome.automation.AutomationEvent.prototype.intents;

/**
 * Stops this event from further processing except for any remaining listeners
 * on $(ref:automation.AutomationEvent.target).
 * @see https://developer.chrome.com/extensions/automation#method-stopPropagation
 */
chrome.automation.AutomationEvent.prototype.stopPropagation = function() {};


/**
 * @typedef {{
 *   target: !chrome.automation.AutomationNode,
 *   type: !chrome.automation.TreeChangeType
 * }}
 * @see https://developer.chrome.com/extensions/automation#type-TreeChange
 */
chrome.automation.TreeChange;

/**
 * @enum {string}
 * @see https://developer.chrome.com/extensions/automation#type-TreeChangeObserverFilter
 */
chrome.automation.TreeChangeObserverFilter = {
  NO_TREE_CHANGES: 'noTreeChanges',
  LIVE_REGION_TREE_CHANGES: 'liveRegionTreeChanges',
  TEXT_MARKER_CHANGES: 'textMarkerChanges',
  ALL_TREE_CHANGES: 'allTreeChanges',
};

/**
 * @typedef {{
 *   id: number,
 *   description: string
 * }}
 * @see https://developer.chrome.com/extensions/automation#type-CustomAction
 */
chrome.automation.CustomAction;

/**
 * @typedef {{
 *   startIndex: number,
 *   endIndex: number,
 *   language: string,
 *   probability: number
 * }}
 * @see https://developer.chrome.com/extensions/automation#type-LanguageSpan
 */
chrome.automation.LanguageSpan;

/**
 * @typedef {{
 *   startOffset: number,
 *   endOffset: number,
 *   flags: Object
 * }}
 * @see https://developer.chrome.com/extensions/automation#type-Marker
 */
chrome.automation.Marker;

/**
 * @constructor
 * @private
 * @see https://developer.chrome.com/extensions/automation#type-AutomationPosition
 */
chrome.automation.AutomationPosition = function() {};

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-node
 */
chrome.automation.AutomationPosition.prototype.node;

/**
 * @type {number}
 * @see https://developer.chrome.com/extensions/automation#type-childIndex
 */
chrome.automation.AutomationPosition.prototype.childIndex;

/**
 * @type {number}
 * @see https://developer.chrome.com/extensions/automation#type-textOffset
 */
chrome.automation.AutomationPosition.prototype.textOffset;

/**
 * @type {string}
 * @see https://developer.chrome.com/extensions/automation#type-affinity
 */
chrome.automation.AutomationPosition.prototype.affinity;

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-isNullPosition
 */
chrome.automation.AutomationPosition.prototype.isNullPosition = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-isTreePosition
 */
chrome.automation.AutomationPosition.prototype.isTreePosition = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-isTextPosition
 */
chrome.automation.AutomationPosition.prototype.isTextPosition = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-isLeafTextPosition
 */
chrome.automation.AutomationPosition.prototype.isLeafTextPosition = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atStartOfAnchor
 */
chrome.automation.AutomationPosition.prototype.atStartOfAnchor = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atEndOfAnchor
 */
chrome.automation.AutomationPosition.prototype.atEndOfAnchor = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atStartOfWord
 */
chrome.automation.AutomationPosition.prototype.atStartOfWord = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atEndOfWord
 */
chrome.automation.AutomationPosition.prototype.atEndOfWord = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atStartOfLine
 */
chrome.automation.AutomationPosition.prototype.atStartOfLine = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atEndOfLine
 */
chrome.automation.AutomationPosition.prototype.atEndOfLine = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atStartOfParagraph
 */
chrome.automation.AutomationPosition.prototype.atStartOfParagraph = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atEndOfParagraph
 */
chrome.automation.AutomationPosition.prototype.atEndOfParagraph = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atStartOfPage
 */
chrome.automation.AutomationPosition.prototype.atStartOfPage = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atEndOfPage
 */
chrome.automation.AutomationPosition.prototype.atEndOfPage = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atStartOfFormat
 */
chrome.automation.AutomationPosition.prototype.atStartOfFormat = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atEndOfFormat
 */
chrome.automation.AutomationPosition.prototype.atEndOfFormat = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atStartOfDocument
 */
chrome.automation.AutomationPosition.prototype.atStartOfDocument = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-atEndOfDocument
 */
chrome.automation.AutomationPosition.prototype.atEndOfDocument = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-asTreePosition
 */
chrome.automation.AutomationPosition.prototype.asTreePosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-asTextPosition
 */
chrome.automation.AutomationPosition.prototype.asTextPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-asLeafTextPosition
 */
chrome.automation.AutomationPosition.prototype.asLeafTextPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPositionAtStartOfAnchor
 */
chrome.automation.AutomationPosition.prototype.moveToPositionAtStartOfAnchor = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPositionAtEndOfAnchor
 */
chrome.automation.AutomationPosition.prototype.moveToPositionAtEndOfAnchor = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPositionAtStartOfDocument
 */
chrome.automation.AutomationPosition.prototype.moveToPositionAtStartOfDocument = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPositionAtEndOfDocument
 */
chrome.automation.AutomationPosition.prototype.moveToPositionAtEndOfDocument = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToParentPosition
 */
chrome.automation.AutomationPosition.prototype.moveToParentPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextLeafTreePosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextLeafTreePosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousLeafTreePosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousLeafTreePosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextLeafTextPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextLeafTextPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousLeafTextPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousLeafTextPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextCharacterPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextCharacterPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousCharacterPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousCharacterPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextWordStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextWordStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousWordStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousWordStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextWordEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextWordEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousWordEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousWordEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextLineStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextLineStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousLineStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousLineStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextLineEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextLineEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousLineEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousLineEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousFormatStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousFormatStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextFormatEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextFormatEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextParagraphStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextParagraphStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousParagraphStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousParagraphStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextParagraphEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextParagraphEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousParagraphEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousParagraphEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextPageStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextPageStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousPageStartPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousPageStartPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextPageEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextPageEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousPageEndPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousPageEndPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToNextAnchorPosition
 */
chrome.automation.AutomationPosition.prototype.moveToNextAnchorPosition = function() {};

/**
 * @see https://developer.chrome.com/extensions/automation#method-moveToPreviousAnchorPosition
 */
chrome.automation.AutomationPosition.prototype.moveToPreviousAnchorPosition = function() {};

/**
 * @return {number}
 * @see https://developer.chrome.com/extensions/automation#method-maxTextOffset
 */
chrome.automation.AutomationPosition.prototype.maxTextOffset = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-isInLineBreak
 */
chrome.automation.AutomationPosition.prototype.isInLineBreak = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-isInTextObject
 */
chrome.automation.AutomationPosition.prototype.isInTextObject = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-isInWhiteSpace
 */
chrome.automation.AutomationPosition.prototype.isInWhiteSpace = function() {};

/**
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-isValid
 */
chrome.automation.AutomationPosition.prototype.isValid = function() {};

/**
 * @return {string}
 * @see https://developer.chrome.com/extensions/automation#method-getText
 */
chrome.automation.AutomationPosition.prototype.getText = function() {};


/**
 * @constructor
 * @private
 * @see https://developer.chrome.com/extensions/automation#type-AutomationNode
 */
chrome.automation.AutomationNode = function() {};

/**
 * The root node of the tree containing this AutomationNode.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-root
 */
chrome.automation.AutomationNode.prototype.root;

/**
 * Whether this AutomationNode is a root node.
 * @type {boolean}
 * @see https://developer.chrome.com/extensions/automation#type-isRootNode
 */
chrome.automation.AutomationNode.prototype.isRootNode;

/**
 * The role of this node.
 * @type {(!chrome.automation.RoleType|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-role
 */
chrome.automation.AutomationNode.prototype.role;

/**
 * The $(ref:automation.StateType)s describing this node.
 * @type {Object<chrome.automation.StateType, boolean>}
 * @see https://developer.chrome.com/extensions/automation#type-state
 */
chrome.automation.AutomationNode.prototype.state;

/**
 * The rendered location (as a bounding box) of this node in global screen coordinates.
 * @type {(!chrome.automation.Rect|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-location
 */
chrome.automation.AutomationNode.prototype.location;

/**
 * Determines the location of the text within the node specified by |startIndex|
 * and |endIndex|, inclusively. Invokes |callback| with the bounding rectangle,
 * in screen coordinates. |callback| can be invoked either synchronously or
 * asynchronously. The bounds are clipped to ancestors.
 * @param {number} startIndex
 * @param {number} endIndex
 * @param {function(!chrome.automation.Rect): void} callback
 * @see https://developer.chrome.com/extensions/automation#method-boundsForRange
 */
chrome.automation.AutomationNode.prototype.boundsForRange = function(startIndex, endIndex, callback) {};

/**
 * Determines the location of the text within the node specified by |startIndex|
 * and |endIndex|, inclusively. Invokes |callback| with the bounding rectangle,
 * in screen coordinates. |callback| can be invoked either synchronously or
 * asynchronously. The bounds are not clipped to ancestors.
 * @param {number} startIndex
 * @param {number} endIndex
 * @param {function(!chrome.automation.Rect): void} callback
 * @see https://developer.chrome.com/extensions/automation#method-unclippedBoundsForRange
 */
chrome.automation.AutomationNode.prototype.unclippedBoundsForRange = function(startIndex, endIndex, callback) {};

/**
 * The location (as a bounding box) of this node in global screen coordinates without applying any clipping from ancestors.
 * @type {(!chrome.automation.Rect|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-unclippedLocation
 */
chrome.automation.AutomationNode.prototype.unclippedLocation;

/**
 * The purpose of the node, other than the role, if any.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-description
 */
chrome.automation.AutomationNode.prototype.description;

/**
 * Description of the state of the checkbox. Used only when the node is checkable.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-checkedStateDescription
 */
chrome.automation.AutomationNode.prototype.checkedStateDescription;

/**
 * The placeholder for this text field, if any.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-placeholder
 */
chrome.automation.AutomationNode.prototype.placeholder;

/**
 * The role description for this node.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-roleDescription
 */
chrome.automation.AutomationNode.prototype.roleDescription;

/**
 * The accessible name for this node, via the <a href="http://www.w3.org/TR/wai-aria/#namecalculation"> Accessible Name Calculation</a> process.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-name
 */
chrome.automation.AutomationNode.prototype.name;

/**
 * The tooltip of the node, if any.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tooltip
 */
chrome.automation.AutomationNode.prototype.tooltip;

/**
 * The source of the name.
 * @type {(!chrome.automation.NameFromType|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-nameFrom
 */
chrome.automation.AutomationNode.prototype.nameFrom;

/**
 * The image annotation for image nodes, which may be a human-readable string that is the contextualized annotation or a status string related to annotations.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-imageAnnotation
 */
chrome.automation.AutomationNode.prototype.imageAnnotation;

/**
 * The value for this node: for example the <code>value</code> attribute of an <code>&lt;input&gt; element.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-value
 */
chrome.automation.AutomationNode.prototype.value;

/**
 * The HTML tag for this element, if this node is an HTML element.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-htmlTag
 */
chrome.automation.AutomationNode.prototype.htmlTag;

/**
 * The level of a heading or tree item.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-hierarchicalLevel
 */
chrome.automation.AutomationNode.prototype.hierarchicalLevel;

/**
 * The start and end index of each word in an inline text box.
 * @type {(!Array<number>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-wordStarts
 */
chrome.automation.AutomationNode.prototype.wordStarts;

/**
 * @type {(!Array<number>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-wordEnds
 */
chrome.automation.AutomationNode.prototype.wordEnds;

/**
 * The start indexes of each sentence within the node's name.
 * @type {(!Array<number>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-sentenceStarts
 */
chrome.automation.AutomationNode.prototype.sentenceStarts;

/**
 * The end indexes of each sentence within the node's name. For most nodes, the
 * size of sentenceStarts array should be equal to the size of sentenceEnds
 * array. Two exceptions are (1) node at the begining of a paragraph but the end
 * of the node's sentences is in its following node. Such a node has one more
 * start index. (2) Node at the end of a paragraph but the start of the node's
 * sentences is in its previous node. Such a node has one more end index. For
 * example, <p><b>Hello</b> world.</p> has two nodes. The first one has one
 * start index (i.e., 0) but no end index. The second node has one end index
 * (i.e., 7) but no start index.
 * @type {(!Array<number>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-sentenceEnds
 */
chrome.automation.AutomationNode.prototype.sentenceEnds;

/**
 * The start index of each word within the node's name. This is different from wordStarts because it is not restricted to inline text boxes and can be used for any type of element.
 * @type {(!Array<number>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-nonInlineTextWordStarts
 */
chrome.automation.AutomationNode.prototype.nonInlineTextWordStarts;

/**
 * The end index of each word within the node's name. This is different from wordEnds because it is not restricted to inline text boxes and can be used for any type of element.
 * @type {(!Array<number>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-nonInlineTextWordEnds
 */
chrome.automation.AutomationNode.prototype.nonInlineTextWordEnds;

/**
 * The nodes, if any, which this node is specified to control via <a href="http://www.w3.org/TR/wai-aria/#aria-controls"> <code>aria-controls</code></a>.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-controls
 */
chrome.automation.AutomationNode.prototype.controls;

/**
 * The nodes, if any, which form a description for this node.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-describedBy
 */
chrome.automation.AutomationNode.prototype.describedBy;

/**
 * The nodes, if any, which may optionally be navigated to after this one. See <a href="http://www.w3.org/TR/wai-aria/#aria-flowto"> <code>aria-flowto</code></a>.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-flowTo
 */
chrome.automation.AutomationNode.prototype.flowTo;

/**
 * The nodes, if any, which form a label for this element. Generally, the text from these elements will also be exposed as the element's accessible name, via the $(ref:automation.AutomationNode.name) attribute.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-labelledBy
 */
chrome.automation.AutomationNode.prototype.labelledBy;

/**
 * The node referred to by <code>aria-activedescendant</code>, where applicable
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-activeDescendant
 */
chrome.automation.AutomationNode.prototype.activeDescendant;

/**
 * Reverse relationship for active descendant.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-activeDescendantFor
 */
chrome.automation.AutomationNode.prototype.activeDescendantFor;

/**
 * The target of an in-page link.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-inPageLinkTarget
 */
chrome.automation.AutomationNode.prototype.inPageLinkTarget;

/**
 * A node that provides more details about the current node.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-details
 */
chrome.automation.AutomationNode.prototype.details;

/**
 * A node that provides an error message for a current node.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-errorMessage
 */
chrome.automation.AutomationNode.prototype.errorMessage;

/**
 * Reverse relationship for details.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-detailsFor
 */
chrome.automation.AutomationNode.prototype.detailsFor;

/**
 * Reverse relationship for errorMessage.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-errorMessageFor
 */
chrome.automation.AutomationNode.prototype.errorMessageFor;

/**
 * Reverse relationship for controls.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-controlledBy
 */
chrome.automation.AutomationNode.prototype.controlledBy;

/**
 * Reverse relationship for describedBy.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-descriptionFor
 */
chrome.automation.AutomationNode.prototype.descriptionFor;

/**
 * Reverse relationship for flowTo.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-flowFrom
 */
chrome.automation.AutomationNode.prototype.flowFrom;

/**
 * Reverse relationship for labelledBy.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-labelFor
 */
chrome.automation.AutomationNode.prototype.labelFor;

/**
 * The column header nodes for a table cell.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableCellColumnHeaders
 */
chrome.automation.AutomationNode.prototype.tableCellColumnHeaders;

/**
 * The row header nodes for a table cell.
 * @type {(!Array<!chrome.automation.AutomationNode>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableCellRowHeaders
 */
chrome.automation.AutomationNode.prototype.tableCellRowHeaders;

/**
 * An array of standard actions available on this node.
 * @type {(!Array<!chrome.automation.ActionType>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-standardActions
 */
chrome.automation.AutomationNode.prototype.standardActions;

/**
 * An array of custom actions.
 * @type {(!Array<!chrome.automation.CustomAction>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-customActions
 */
chrome.automation.AutomationNode.prototype.customActions;

/**
 * The action taken by calling <code>doDefault</code>.
 * @type {(!chrome.automation.DefaultActionVerb|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-defaultActionVerb
 */
chrome.automation.AutomationNode.prototype.defaultActionVerb;

/**
 * The URL that this link will navigate to.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-url
 */
chrome.automation.AutomationNode.prototype.url;

/**
 * The URL of this document.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-docUrl
 */
chrome.automation.AutomationNode.prototype.docUrl;

/**
 * The title of this document.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-docTitle
 */
chrome.automation.AutomationNode.prototype.docTitle;

/**
 * Whether this document has finished loading.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-docLoaded
 */
chrome.automation.AutomationNode.prototype.docLoaded;

/**
 * The proportion (out of 1.0) that this doc has completed loading.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-docLoadingProgress
 */
chrome.automation.AutomationNode.prototype.docLoadingProgress;

/**
 * Scrollable container attributes.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-scrollX
 */
chrome.automation.AutomationNode.prototype.scrollX;

/**
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-scrollXMin
 */
chrome.automation.AutomationNode.prototype.scrollXMin;

/**
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-scrollXMax
 */
chrome.automation.AutomationNode.prototype.scrollXMax;

/**
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-scrollY
 */
chrome.automation.AutomationNode.prototype.scrollY;

/**
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-scrollYMin
 */
chrome.automation.AutomationNode.prototype.scrollYMin;

/**
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-scrollYMax
 */
chrome.automation.AutomationNode.prototype.scrollYMax;

/**
 * Indicates whether this node is scrollable.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-scrollable
 */
chrome.automation.AutomationNode.prototype.scrollable;

/**
 * The character index of the start of the selection within this editable text element; -1 if no selection.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-textSelStart
 */
chrome.automation.AutomationNode.prototype.textSelStart;

/**
 * The character index of the end of the selection within this editable text element; -1 if no selection.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-textSelEnd
 */
chrome.automation.AutomationNode.prototype.textSelEnd;

/**
 * The input type, like email or number.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-textInputType
 */
chrome.automation.AutomationNode.prototype.textInputType;

/**
 * An array of Marker objects for this node.
 * @type {(!Array<!chrome.automation.Marker>|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-markers
 */
chrome.automation.AutomationNode.prototype.markers;

/**
 * If a selection is present, whether the anchor of the selection comes after its focus in the accessibility tree.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-isSelectionBackward
 */
chrome.automation.AutomationNode.prototype.isSelectionBackward;

/**
 * The anchor node of the tree selection, if any.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-anchorObject
 */
chrome.automation.AutomationNode.prototype.anchorObject;

/**
 * The anchor offset of the tree selection, if any.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-anchorOffset
 */
chrome.automation.AutomationNode.prototype.anchorOffset;

/**
 * The affinity of the tree selection anchor, if any.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-anchorAffinity
 */
chrome.automation.AutomationNode.prototype.anchorAffinity;

/**
 * The focus node of the tree selection, if any.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-focusObject
 */
chrome.automation.AutomationNode.prototype.focusObject;

/**
 * The focus offset of the tree selection, if any.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-focusOffset
 */
chrome.automation.AutomationNode.prototype.focusOffset;

/**
 * The affinity of the tree selection focus, if any.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-focusAffinity
 */
chrome.automation.AutomationNode.prototype.focusAffinity;

/**
 * The selection start node of the tree selection, if any.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-selectionStartObject
 */
chrome.automation.AutomationNode.prototype.selectionStartObject;

/**
 * The selection start offset of the tree selection, if any.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-selectionStartOffset
 */
chrome.automation.AutomationNode.prototype.selectionStartOffset;

/**
 * The affinity of the tree selection start, if any.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-selectionStartAffinity
 */
chrome.automation.AutomationNode.prototype.selectionStartAffinity;

/**
 * The selection end node of the tree selection, if any.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-selectionEndObject
 */
chrome.automation.AutomationNode.prototype.selectionEndObject;

/**
 * The selection end offset of the tree selection, if any.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-selectionEndOffset
 */
chrome.automation.AutomationNode.prototype.selectionEndOffset;

/**
 * The affinity of the tree selection end, if any.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-selectionEndAffinity
 */
chrome.automation.AutomationNode.prototype.selectionEndAffinity;

/**
 * Indicates that the node is marked user-select:none
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-notUserSelectableStyle
 */
chrome.automation.AutomationNode.prototype.notUserSelectableStyle;

/**
 * The current value for this range.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-valueForRange
 */
chrome.automation.AutomationNode.prototype.valueForRange;

/**
 * The minimum possible value for this range.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-minValueForRange
 */
chrome.automation.AutomationNode.prototype.minValueForRange;

/**
 * The maximum possible value for this range.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-maxValueForRange
 */
chrome.automation.AutomationNode.prototype.maxValueForRange;

/**
 * The 1-based index of an item in a set.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-posInSet
 */
chrome.automation.AutomationNode.prototype.posInSet;

/**
 * The number of items in a set;
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-setSize
 */
chrome.automation.AutomationNode.prototype.setSize;

/**
 * The number of rows in this table as specified in the DOM.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableRowCount
 */
chrome.automation.AutomationNode.prototype.tableRowCount;

/**
 * The number of rows in this table as specified by the page author.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-ariaRowCount
 */
chrome.automation.AutomationNode.prototype.ariaRowCount;

/**
 * The number of columns in this table as specified in the DOM.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableColumnCount
 */
chrome.automation.AutomationNode.prototype.tableColumnCount;

/**
 * The number of columns in this table as specified by the page author.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-ariaColumnCount
 */
chrome.automation.AutomationNode.prototype.ariaColumnCount;

/**
 * The zero-based index of the column that this cell is in as specified in the DOM.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableCellColumnIndex
 */
chrome.automation.AutomationNode.prototype.tableCellColumnIndex;

/**
 * The ARIA column index as specified by the page author.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableCellAriaColumnIndex
 */
chrome.automation.AutomationNode.prototype.tableCellAriaColumnIndex;

/**
 * The number of columns that this cell spans (default is 1).
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableCellColumnSpan
 */
chrome.automation.AutomationNode.prototype.tableCellColumnSpan;

/**
 * The zero-based index of the row that this cell is in as specified in the DOM.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableCellRowIndex
 */
chrome.automation.AutomationNode.prototype.tableCellRowIndex;

/**
 * The ARIA row index as specified by the page author.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableCellAriaRowIndex
 */
chrome.automation.AutomationNode.prototype.tableCellAriaRowIndex;

/**
 * The number of rows that this cell spans (default is 1).
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableCellRowSpan
 */
chrome.automation.AutomationNode.prototype.tableCellRowSpan;

/**
 * The corresponding column header for this cell.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableColumnHeader
 */
chrome.automation.AutomationNode.prototype.tableColumnHeader;

/**
 * The corresponding row header for this cell.
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableRowHeader
 */
chrome.automation.AutomationNode.prototype.tableRowHeader;

/**
 * The column index of this column node.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableColumnIndex
 */
chrome.automation.AutomationNode.prototype.tableColumnIndex;

/**
 * The row index of this row node.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-tableRowIndex
 */
chrome.automation.AutomationNode.prototype.tableRowIndex;

/**
 * The type of region if this is the root of a live region. Possible values are 'polite' and 'assertive'.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-liveStatus
 */
chrome.automation.AutomationNode.prototype.liveStatus;

/**
 * The value of aria-relevant for a live region.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-liveRelevant
 */
chrome.automation.AutomationNode.prototype.liveRelevant;

/**
 * The value of aria-atomic for a live region.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-liveAtomic
 */
chrome.automation.AutomationNode.prototype.liveAtomic;

/**
 * The value of aria-busy for a live region or any other element.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-busy
 */
chrome.automation.AutomationNode.prototype.busy;

/**
 * The type of live region if this node is inside a live region.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-containerLiveStatus
 */
chrome.automation.AutomationNode.prototype.containerLiveStatus;

/**
 * The value of aria-relevant if this node is inside a live region.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-containerLiveRelevant
 */
chrome.automation.AutomationNode.prototype.containerLiveRelevant;

/**
 * The value of aria-atomic if this node is inside a live region.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-containerLiveAtomic
 */
chrome.automation.AutomationNode.prototype.containerLiveAtomic;

/**
 * The value of aria-busy if this node is inside a live region.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-containerLiveBusy
 */
chrome.automation.AutomationNode.prototype.containerLiveBusy;

/**
 * Aria auto complete.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-autoComplete
 */
chrome.automation.AutomationNode.prototype.autoComplete;

/**
 * The name of the programmatic backing object.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-className
 */
chrome.automation.AutomationNode.prototype.className;

/**
 * Marks this subtree as modal.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-modal
 */
chrome.automation.AutomationNode.prototype.modal;

/**
 * A map containing all HTML attributes and their values
 * @type {Object<string>}
 * @see https://developer.chrome.com/extensions/automation#type-htmlAttributes
 */
chrome.automation.AutomationNode.prototype.htmlAttributes;

/**
 * The input type of a text field, such as "text" or "email".
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-inputType
 */
chrome.automation.AutomationNode.prototype.inputType;

/**
 * The key that activates this widget.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-accessKey
 */
chrome.automation.AutomationNode.prototype.accessKey;

/**
 * The value of the aria-invalid attribute, indicating the error type.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-ariaInvalidValue
 */
chrome.automation.AutomationNode.prototype.ariaInvalidValue;

/**
 * The CSS display attribute for this node, if applicable.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-display
 */
chrome.automation.AutomationNode.prototype.display;

/**
 * A data url with the contents of this object's image or thumbnail.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-imageDataUrl
 */
chrome.automation.AutomationNode.prototype.imageDataUrl;

/**
 * The author-provided language code for this subtree.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-language
 */
chrome.automation.AutomationNode.prototype.language;

/**
 * The detected language code for this subtree.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-detectedLanguage
 */
chrome.automation.AutomationNode.prototype.detectedLanguage;

/**
 * Indicates the availability and type of interactive popup element true - the popup is a menu menu - the popup is a menu listbox - the popup is a listbox tree - the popup is a tree grid - the popup is a grid dialog - the popup is a dialog
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-hasPopup
 */
chrome.automation.AutomationNode.prototype.hasPopup;

/**
 * Input restriction, if any, such as readonly or disabled: undefined - enabled control or other object that is not disabled Restriction.DISABLED - disallows input in itself + any descendants Restriction.READONLY - allow focus/selection but not input
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-restriction
 */
chrome.automation.AutomationNode.prototype.restriction;

/**
 * Tri-state describing checkbox or radio button: 'false' | 'true' | 'mixed'
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-checked
 */
chrome.automation.AutomationNode.prototype.checked;

/**
 * The inner html of this element. Only populated for math content.
 * @type {(string|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-innerHtml
 */
chrome.automation.AutomationNode.prototype.innerHtml;

/**
 * The RGBA foreground color of this subtree, as an integer.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-color
 */
chrome.automation.AutomationNode.prototype.color;

/**
 * The RGBA background color of this subtree, as an integer.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-backgroundColor
 */
chrome.automation.AutomationNode.prototype.backgroundColor;

/**
 * The RGBA color of an input element whose value is a color.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-colorValue
 */
chrome.automation.AutomationNode.prototype.colorValue;

/**
 * Indicates node text is subscript.
 * @type {boolean}
 * @see https://developer.chrome.com/extensions/automation#type-subscript
 */
chrome.automation.AutomationNode.prototype.subscript;

/**
 * Indicates node text is superscript.
 * @type {boolean}
 * @see https://developer.chrome.com/extensions/automation#type-superscript
 */
chrome.automation.AutomationNode.prototype.superscript;

/**
 * Indicates node text is bold.
 * @type {boolean}
 * @see https://developer.chrome.com/extensions/automation#type-bold
 */
chrome.automation.AutomationNode.prototype.bold;

/**
 * Indicates node text is italic.
 * @type {boolean}
 * @see https://developer.chrome.com/extensions/automation#type-italic
 */
chrome.automation.AutomationNode.prototype.italic;

/**
 * Indicates node text is underline.
 * @type {boolean}
 * @see https://developer.chrome.com/extensions/automation#type-underline
 */
chrome.automation.AutomationNode.prototype.underline;

/**
 * Indicates node text is line through.
 * @type {boolean}
 * @see https://developer.chrome.com/extensions/automation#type-lineThrough
 */
chrome.automation.AutomationNode.prototype.lineThrough;

/**
 * Indicates whether this node is selected, unselected, or neither.
 * @type {(boolean|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-selected
 */
chrome.automation.AutomationNode.prototype.selected;

/**
 * Indicates the font size of this node.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-fontSize
 */
chrome.automation.AutomationNode.prototype.fontSize;

/**
 * Indicates the font family.
 * @type {string}
 * @see https://developer.chrome.com/extensions/automation#type-fontFamily
 */
chrome.automation.AutomationNode.prototype.fontFamily;

/**
 * Indicates whether this is a root of an editable subtree.
 * @type {boolean}
 * @see https://developer.chrome.com/extensions/automation#type-editableRoot
 */
chrome.automation.AutomationNode.prototype.editableRoot;

/**
 * Walking the tree.
 * @type {!Array<!chrome.automation.AutomationNode>}
 * @see https://developer.chrome.com/extensions/automation#type-children
 */
chrome.automation.AutomationNode.prototype.children;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-parent
 */
chrome.automation.AutomationNode.prototype.parent;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-firstChild
 */
chrome.automation.AutomationNode.prototype.firstChild;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-lastChild
 */
chrome.automation.AutomationNode.prototype.lastChild;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-previousSibling
 */
chrome.automation.AutomationNode.prototype.previousSibling;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-nextSibling
 */
chrome.automation.AutomationNode.prototype.nextSibling;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-previousOnLine
 */
chrome.automation.AutomationNode.prototype.previousOnLine;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-nextOnLine
 */
chrome.automation.AutomationNode.prototype.nextOnLine;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-previousFocus
 */
chrome.automation.AutomationNode.prototype.previousFocus;

/**
 * @type {(!chrome.automation.AutomationNode|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-nextFocus
 */
chrome.automation.AutomationNode.prototype.nextFocus;

/**
 * The index of this node in its parent node's list of children. If this is the root node, this will be undefined.
 * @type {(number|undefined)}
 * @see https://developer.chrome.com/extensions/automation#type-indexInParent
 */
chrome.automation.AutomationNode.prototype.indexInParent;

/**
 * The sort direction of this node.
 * @type {!chrome.automation.SortDirectionType}
 * @see https://developer.chrome.com/extensions/automation#type-sortDirection
 */
chrome.automation.AutomationNode.prototype.sortDirection;

/**
 * Does the default action based on this node's role. This is generally the same
 * action that would result from clicking the node such as expanding a treeitem,
 * toggling a checkbox, selecting a radiobutton, or activating a button.
 * @see https://developer.chrome.com/extensions/automation#method-doDefault
 */
chrome.automation.AutomationNode.prototype.doDefault = function() {};

/**
 * Places focus on this node.
 * @see https://developer.chrome.com/extensions/automation#method-focus
 */
chrome.automation.AutomationNode.prototype.focus = function() {};

/**
 * Request a data url for the contents of an image, optionally resized.  Pass
 * zero for maxWidth and/or maxHeight for the original size.
 * @param {number} maxWidth
 * @param {number} maxHeight
 * @see https://developer.chrome.com/extensions/automation#method-getImageData
 */
chrome.automation.AutomationNode.prototype.getImageData = function(maxWidth, maxHeight) {};

/**
 * Does a hit test of the given global screen coordinates, and fires eventToFire
 * on the resulting object.
 * @param {number} x
 * @param {number} y
 * @param {!chrome.automation.EventType} eventToFire
 * @see https://developer.chrome.com/extensions/automation#method-hitTest
 */
chrome.automation.AutomationNode.prototype.hitTest = function(x, y, eventToFire) {};

/**
 * Does a $(ref:automation.AutomationNode.hitTest), and receives a callback with
 * the resulting hit node.
 * @param {number} x
 * @param {number} y
 * @param {function(!chrome.automation.AutomationNode): void} callback
 * @see https://developer.chrome.com/extensions/automation#method-hitTestWithReply
 */
chrome.automation.AutomationNode.prototype.hitTestWithReply = function(x, y, callback) {};

/**
 * Scrolls this node to make it visible.
 * @see https://developer.chrome.com/extensions/automation#method-makeVisible
 */
chrome.automation.AutomationNode.prototype.makeVisible = function() {};

/**
 * Performs custom action.
 * @param {number} customActionId
 * @see https://developer.chrome.com/extensions/automation#method-performCustomAction
 */
chrome.automation.AutomationNode.prototype.performCustomAction = function(customActionId) {};

/**
 * Convenience method to perform a standard action supported by this node. For
 * actions requiring additional arguments, call the specific binding e.g.
 * <code>setSelection</code>.
 * @param {!chrome.automation.ActionType} actionType
 * @see https://developer.chrome.com/extensions/automation#method-performStandardAction
 */
chrome.automation.AutomationNode.prototype.performStandardAction = function(actionType) {};

/**
 * Replaces the selected text within a text field.
 * @param {string} value
 * @see https://developer.chrome.com/extensions/automation#method-replaceSelectedText
 */
chrome.automation.AutomationNode.prototype.replaceSelectedText = function(value) {};

/**
 * Sets accessibility focus. Accessibility focus is the node on which an
 * extension tracks a user's focus. This may be conveyed through a focus ring or
 * or speech output by the extension. Automation will dispatch more events to
 * the accessibility focus such as location changes.
 * @see https://developer.chrome.com/extensions/automation#method-setAccessibilityFocus
 */
chrome.automation.AutomationNode.prototype.setAccessibilityFocus = function() {};

/**
 * Sets selection within a text field.
 * @param {number} startIndex
 * @param {number} endIndex
 * @see https://developer.chrome.com/extensions/automation#method-setSelection
 */
chrome.automation.AutomationNode.prototype.setSelection = function(startIndex, endIndex) {};

/**
 * Clears focus and sets this node as the starting point for the next time the
 * user presses Tab or Shift+Tab.
 * @see https://developer.chrome.com/extensions/automation#method-setSequentialFocusNavigationStartingPoint
 */
chrome.automation.AutomationNode.prototype.setSequentialFocusNavigationStartingPoint = function() {};

/**
 * Sets the value of a text field.
 * @param {string} value
 * @see https://developer.chrome.com/extensions/automation#method-setValue
 */
chrome.automation.AutomationNode.prototype.setValue = function(value) {};

/**
 * Show the context menu for this element, as if the user right-clicked.
 * @see https://developer.chrome.com/extensions/automation#method-showContextMenu
 */
chrome.automation.AutomationNode.prototype.showContextMenu = function() {};

/**
 * Resume playing any media within this tree.
 * @see https://developer.chrome.com/extensions/automation#method-resumeMedia
 */
chrome.automation.AutomationNode.prototype.resumeMedia = function() {};

/**
 * Start ducking any media within this tree.
 * @see https://developer.chrome.com/extensions/automation#method-startDuckingMedia
 */
chrome.automation.AutomationNode.prototype.startDuckingMedia = function() {};

/**
 * Stop ducking any media within this tree.
 * @see https://developer.chrome.com/extensions/automation#method-stopDuckingMedia
 */
chrome.automation.AutomationNode.prototype.stopDuckingMedia = function() {};

/**
 * Suspend any media playing within this tree.
 * @see https://developer.chrome.com/extensions/automation#method-suspendMedia
 */
chrome.automation.AutomationNode.prototype.suspendMedia = function() {};

/**
 * Scrolls this scrollable container backward.
 * @param {function(boolean): void=} callback Callback called for actions with a
 *     response.
 * @see https://developer.chrome.com/extensions/automation#method-scrollBackward
 */
chrome.automation.AutomationNode.prototype.scrollBackward = function(callback) {};

/**
 * Scrolls this scrollable container forward.
 * @param {function(boolean): void=} callback Callback called for actions with a
 *     response.
 * @see https://developer.chrome.com/extensions/automation#method-scrollForward
 */
chrome.automation.AutomationNode.prototype.scrollForward = function(callback) {};

/**
 * Scrolls this scrollable container up.
 * @param {function(boolean): void=} callback Callback called for actions with a
 *     response.
 * @see https://developer.chrome.com/extensions/automation#method-scrollUp
 */
chrome.automation.AutomationNode.prototype.scrollUp = function(callback) {};

/**
 * Scrolls this scrollable container down.
 * @param {function(boolean): void=} callback Callback called for actions with a
 *     response.
 * @see https://developer.chrome.com/extensions/automation#method-scrollDown
 */
chrome.automation.AutomationNode.prototype.scrollDown = function(callback) {};

/**
 * Scrolls this scrollable container left.
 * @param {function(boolean): void=} callback Callback called for actions with a
 *     response.
 * @see https://developer.chrome.com/extensions/automation#method-scrollLeft
 */
chrome.automation.AutomationNode.prototype.scrollLeft = function(callback) {};

/**
 * Scrolls this scrollable container right.
 * @param {function(boolean): void=} callback Callback called for actions with a
 *     response.
 * @see https://developer.chrome.com/extensions/automation#method-scrollRight
 */
chrome.automation.AutomationNode.prototype.scrollRight = function(callback) {};

/**
 * Scrolls this scrollable container to the given point.
 * @param {number} x
 * @param {number} y
 * @see https://developer.chrome.com/extensions/automation#method-scrollToPoint
 */
chrome.automation.AutomationNode.prototype.scrollToPoint = function(x, y) {};

/**
 * Sets this scrollable container's scroll offset.
 * @param {number} x
 * @param {number} y
 * @see https://developer.chrome.com/extensions/automation#method-setScrollOffset
 */
chrome.automation.AutomationNode.prototype.setScrollOffset = function(x, y) {};

/**
 * Adds a listener for the given event type and event phase.
 * @param {!chrome.automation.EventType} eventType
 * @param {function(!chrome.automation.AutomationEvent): void} listener A
 *     listener for events on an <code>AutomationNode</code>.
 * @param {boolean} capture
 * @see https://developer.chrome.com/extensions/automation#method-addEventListener
 */
chrome.automation.AutomationNode.prototype.addEventListener = function(eventType, listener, capture) {};

/**
 * Removes a listener for the given event type and event phase.
 * @param {!chrome.automation.EventType} eventType
 * @param {function(!chrome.automation.AutomationEvent): void} listener A
 *     listener for events on an <code>AutomationNode</code>.
 * @param {boolean} capture
 * @see https://developer.chrome.com/extensions/automation#method-removeEventListener
 */
chrome.automation.AutomationNode.prototype.removeEventListener = function(eventType, listener, capture) {};

/**
 * <p>Gets the first node in this node's subtree which matches the given CSS
 * selector and is within the same DOM context.</p><p>If this node doesn't
 * correspond directly with an HTML node in the DOM, querySelector will be run
 * on this node's nearest HTML node ancestor. Note that this may result in the
 * query returning a node which is not a descendant of this node.</p><p>If the
 * selector matches a node which doesn't directly correspond to an automation
 * node (for example an element within an ARIA widget, where the ARIA widget
 * forms one node of the automation tree, or an element which is hidden from
 * accessibility via hiding it using CSS or using aria-hidden), this will return
 * the nearest ancestor which does correspond to an automation node.</p>
 * @param {string} selector
 * @param {function(!chrome.automation.AutomationNode): void} callback Called
 *     when the result for a <code>query</code> is available.
 * @see https://developer.chrome.com/extensions/automation#method-domQuerySelector
 */
chrome.automation.AutomationNode.prototype.domQuerySelector = function(selector, callback) {};

/**
 * Finds the first AutomationNode in this node's subtree which matches the given
 * search parameters.
 * @param {!chrome.automation.FindParams} params
 * @return {!chrome.automation.AutomationNode}
 * @see https://developer.chrome.com/extensions/automation#method-find
 */
chrome.automation.AutomationNode.prototype.find = function(params) {};

/**
 * Finds all the AutomationNodes in this node's subtree which matches the given
 * search parameters.
 * @param {!chrome.automation.FindParams} params
 * @return {!Array<!chrome.automation.AutomationNode>}
 * @see https://developer.chrome.com/extensions/automation#method-findAll
 */
chrome.automation.AutomationNode.prototype.findAll = function(params) {};

/**
 * Returns whether this node matches the given $(ref:automation.FindParams).
 * @param {!chrome.automation.FindParams} params
 * @return {boolean}
 * @see https://developer.chrome.com/extensions/automation#method-matches
 */
chrome.automation.AutomationNode.prototype.matches = function(params) {};

/**
 * @param {string} searchStr
 * @param {boolean} backward
 * @return {!chrome.automation.AutomationNode}
 * @see https://developer.chrome.com/extensions/automation#method-getNextTextMatch
 */
chrome.automation.AutomationNode.prototype.getNextTextMatch = function(searchStr, backward) {};

/**
 * Returns the detected languages for the provided string attribute as an array
 * of LanguageSpan objects. There are several guarantees about the format of the
 * LanguageSpan array: 1. Is either empty or contains LanguageSpans that cover
 * all indices in the associated string attribute value. 2. Is sorted by
 * increasing startIndex (those with smaller startIndex appear first). 3.
 * LanguageSpans are non-overlapping and contain exactly one language.
 * @param {string} attribute
 * @return {!Array<!chrome.automation.LanguageSpan>}
 * @see https://developer.chrome.com/extensions/automation#method-languageAnnotationForStringAttribute
 */
chrome.automation.AutomationNode.prototype.languageAnnotationForStringAttribute = function(attribute) {};

/**
 * Creates a position object backed by Chrome's accessibility position support.
 * @param {number} offset
 * @param {boolean=} isUpstream
 * @return {!chrome.automation.AutomationPosition}
 * @see https://developer.chrome.com/extensions/automation#method-createPosition
 */
chrome.automation.AutomationNode.prototype.createPosition = function(offset, isUpstream) {};


/**
 * Get the automation tree for the tab with the given tabId, or the current tab
 * if no tabID is given, enabling automation if necessary. Returns a tree with a
 * placeholder root node; listen for the "loadComplete" event to get a
 * notification that the tree has fully loaded (the previous root node reference
 * will stop working at or before this point).
 * @param {number=} tabId
 * @param {function(!chrome.automation.AutomationNode): void=} callback Called
 *     when the <code>AutomationNode</code> for the page is available.
 * @see https://developer.chrome.com/extensions/automation#method-getTree
 */
chrome.automation.getTree = function(tabId, callback) {};

/**
 * Get the automation tree for the whole desktop which consists of all on screen
 * views. Note this API is currently only supported on Chrome OS.
 * @param {function(!chrome.automation.AutomationNode): void} callback Called
 *     when the <code>AutomationNode</code> for the page is available.
 * @see https://developer.chrome.com/extensions/automation#method-getDesktop
 */
chrome.automation.getDesktop = function(callback) {};

/**
 * Get the automation node that currently has focus, globally. Will return null
 * if none of the nodes in any loaded trees have focus.
 * @param {function(!chrome.automation.AutomationNode): void} callback Called
 *     with the <code>AutomationNode</code> that currently has focus.
 * @see https://developer.chrome.com/extensions/automation#method-getFocus
 */
chrome.automation.getFocus = function(callback) {};

/**
 * Get the automation node that currently has accessibility focus, globally.
 * Will return null if none of the nodes in any loaded trees have accessibility
 * focus.
 * @param {function(!chrome.automation.AutomationNode): void} callback Called
 *     with the <code>AutomationNode</code> that currently has accessibility
 *     focus.
 * @see https://developer.chrome.com/extensions/automation#method-getAccessibilityFocus
 */
chrome.automation.getAccessibilityFocus = function(callback) {};

/**
 * Add a tree change observer. Tree change observers are static/global, they
 * listen to changes across all trees. Pass a filter to determine what specific
 * tree changes to listen to, and note that listnening to all tree changes can
 * be expensive.
 * @param {!chrome.automation.TreeChangeObserverFilter} filter
 * @param {function(!chrome.automation.TreeChange): void} observer A listener
 *     for changes on the <code>AutomationNode</code> tree.
 * @see https://developer.chrome.com/extensions/automation#method-addTreeChangeObserver
 */
chrome.automation.addTreeChangeObserver = function(filter, observer) {};

/**
 * Remove a tree change observer.
 * @param {function(!chrome.automation.TreeChange): void} observer A listener
 *     for changes on the <code>AutomationNode</code> tree.
 * @see https://developer.chrome.com/extensions/automation#method-removeTreeChangeObserver
 */
chrome.automation.removeTreeChangeObserver = function(observer) {};

/**
 * Sets the selection in a tree. This creates a selection in a single tree
 * (anchorObject and focusObject must have the same root). Everything in the
 * tree between the two node/offset pairs gets included in the selection. The
 * anchor is where the user started the selection, while the focus is the point
 * at which the selection gets extended e.g. when dragging with a mouse or using
 * the keyboard. For nodes with the role staticText, the offset gives the
 * character offset within the value where the selection starts or ends,
 * respectively.
 * @param {!chrome.automation.SetDocumentSelectionParams} params
 * @see https://developer.chrome.com/extensions/automation#method-setDocumentSelection
 */
chrome.automation.setDocumentSelection = function(params) {};
