// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.accessibilityFeatures.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md
// NOTE: This file was modified by hand after it was generated. All instances of
// chrome.accessibilityFeatures.types.ChromeSetting must be changed to
// ChromeSetting after this file is generated.

/** @fileoverview Externs generated from namespace: accessibilityFeatures */

/** @const */
chrome.accessibilityFeatures = {};

/**
 * <p><strong>ChromeOS only.</strong></p><p>Spoken feedback (text-to-speech). The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-spokenFeedback
 */
chrome.accessibilityFeatures.spokenFeedback;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Enlarged cursor. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-largeCursor
 */
chrome.accessibilityFeatures.largeCursor;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Sticky modifier keys (like shift or alt). The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-stickyKeys
 */
chrome.accessibilityFeatures.stickyKeys;

/**
 * <p><strong>ChromeOS only.</strong></p><p>High contrast rendering mode. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-highContrast
 */
chrome.accessibilityFeatures.highContrast;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Full screen magnification. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-screenMagnifier
 */
chrome.accessibilityFeatures.screenMagnifier;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Auto mouse click after mouse stops moving. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-autoclick
 */
chrome.accessibilityFeatures.autoclick;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Virtual on-screen keyboard. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-virtualKeyboard
 */
chrome.accessibilityFeatures.virtualKeyboard;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Caret highlighting. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-caretHighlight
 */
chrome.accessibilityFeatures.caretHighlight;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Cursor highlighting. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-cursorHighlight
 */
chrome.accessibilityFeatures.cursorHighlight;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Cursor color. The value indicates whether the feature is enabled or not, doesn't indicate the color of it. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-cursorColor
 */
chrome.accessibilityFeatures.cursorColor;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Docked magnifier. The value indicates whether docked magnifier feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-dockedMagnifier
 */
chrome.accessibilityFeatures.dockedMagnifier;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Focus highlighting. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-focusHighlight
 */
chrome.accessibilityFeatures.focusHighlight;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Select-to-speak. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-selectToSpeak
 */
chrome.accessibilityFeatures.selectToSpeak;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Switch Access. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-switchAccess
 */
chrome.accessibilityFeatures.switchAccess;

/**
 * <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-animationPolicy
 */
chrome.accessibilityFeatures.animationPolicy;

/**
 * <p><strong>ChromeOS only.</strong></p><p>Dictation. The value indicates whether the feature is enabled or not. <code>get()</code> requires <code>accessibilityFeatures.read</code> permission. <code>set()</code> and <code>clear()</code> require <code>accessibilityFeatures.modify</code> permission.</p>
 * @type {!ChromeSetting}
 * @see https://developer.chrome.com/extensions/accessibilityFeatures#type-dictation
 */
chrome.accessibilityFeatures.dictation;
