#!/usr/bin/env vpython
# Copyright (C) 2012 Google Inc. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution.
#     * Neither the name of Google Inc. nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""Runs a WebSocket server for WebSocket tests.

Some tests require both an HTTP server and WebSocket server. You can start
both servers by running both run_blink_httpd.py and
run_blink_websocketserver.py.

Tests served by the HTTP server have paths relative to web_tests/http/tests/.
For example, to run a test http/tests/websocket/binary-type.html which depends
on WebSocket, you can navigate to:
    http://127.0.0.1:8000/websocket/close-unref-websocket.html
"""
import sys
import optparse

from blinkpy.common import version_check  # pylint: disable=unused-import
from blinkpy.web_tests.servers import cli_wrapper
from blinkpy.web_tests.servers import pywebsocket

option, args = cli_wrapper.parse_python_server_options()
cli_wrapper.main(
    pywebsocket.PyWebSocket,
    argv=args,
    description=__doc__,
    python_executable=option.python_executable)
