// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/platform/wtf/text/math_transform.h"

#include "testing/gtest/include/gtest/gtest.h"

namespace WTF {

namespace {

// https://mathml-refresh.github.io/mathml-core/#italic-mappings
TEST(MathTransform, Italics) {
  static struct ItalicsTestData {
    UChar32 code_point;
    UChar32 expected;
  } italics_test_data[] = {
      {0x2202, 0x1D715}, {0x2207, 0x1D6FB}, {0x0237, 0x1D6A5},
      {0x0041, 0x1D434}, {0x0042, 0x1D435}, {0x0043, 0x1D436},
      {0x0044, 0x1D437}, {0x0045, 0x1D438}, {0x0046, 0x1D439},
      {0x0047, 0x1D43A}, {0x0048, 0x1D43B}, {0x0049, 0x1D43C},
      {0x004A, 0x1D43D}, {0x004B, 0x1D43E}, {0x004C, 0x1D43F},
      {0x004D, 0x1D440}, {0x004E, 0x1D441}, {0x004F, 0x1D442},
      {0x0050, 0x1D443}, {0x0051, 0x1D444}, {0x0052, 0x1D445},
      {0x0053, 0x1D446}, {0x0054, 0x1D447}, {0x0055, 0x1D448},
      {0x0056, 0x1D449}, {0x0057, 0x1D44A}, {0x0058, 0x1D44B},
      {0x0059, 0x1D44C}, {0x005A, 0x1D44D}, {0x0061, 0x1D44E},
      {0x0062, 0x1D44F}, {0x0063, 0x1D450}, {0x0064, 0x1D451},
      {0x0065, 0x1D452}, {0x0066, 0x1D453}, {0x0067, 0x1D454},
      {0x0068, 0x0210E}, {0x0069, 0x1D456}, {0x006A, 0x1D457},
      {0x006B, 0x1D458}, {0x006C, 0x1D459}, {0x006D, 0x1D45A},
      {0x006E, 0x1D45B}, {0x006F, 0x1D45C}, {0x0070, 0x1D45D},
      {0x0071, 0x1D45E}, {0x0072, 0x1D45F}, {0x0073, 0x1D460},
      {0x0074, 0x1D461}, {0x0075, 0x1D462}, {0x0076, 0x1D463},
      {0x0077, 0x1D464}, {0x0078, 0x1D465}, {0x0079, 0x1D466},
      {0x007A, 0x1D467}, {0x0131, 0x1D6A4}, {0x0391, 0x1D6E2},
      {0x0392, 0x1D6E3}, {0x0393, 0x1D6E4}, {0x0394, 0x1D6E5},
      {0x0395, 0x1D6E6}, {0x0396, 0x1D6E7}, {0x0397, 0x1D6E8},
      {0x0398, 0x1D6E9}, {0x0399, 0x1D6EA}, {0x039A, 0x1D6EB},
      {0x039B, 0x1D6EC}, {0x039C, 0x1D6ED}, {0x039D, 0x1D6EE},
      {0x039E, 0x1D6EF}, {0x039F, 0x1D6F0}, {0x03A0, 0x1D6F1},
      {0x03A1, 0x1D6F2}, {0x03A3, 0x1D6F4}, {0x03A4, 0x1D6F5},
      {0x03A5, 0x1D6F6}, {0x03A6, 0x1D6F7}, {0x03A7, 0x1D6F8},
      {0x03A8, 0x1D6F9}, {0x03A9, 0x1D6FA}, {0x03B1, 0x1D6FC},
      {0x03B2, 0x1D6FD}, {0x03B3, 0x1D6FE}, {0x03B4, 0x1D6FF},
      {0x03B5, 0x1D700}, {0x03B6, 0x1D701}, {0x03B7, 0x1D702},
      {0x03B8, 0x1D703}, {0x03B9, 0x1D704}, {0x03BA, 0x1D705},
      {0x03BB, 0x1D706}, {0x03BC, 0x1D707}, {0x03BD, 0x1D708},
      {0x03BE, 0x1D709}, {0x03BF, 0x1D70A}, {0x03C0, 0x1D70B},
      {0x03C1, 0x1D70C}, {0x03C2, 0x1D70D}, {0x03C3, 0x1D70E},
      {0x03C4, 0x1D70F}, {0x03C5, 0x1D710}, {0x03C6, 0x1D711},
      {0x03C7, 0x1D712}, {0x03C8, 0x1D713}, {0x03C9, 0x1D714},
      {0x03D1, 0x1D717}, {0x03D5, 0x1D719}, {0x03D6, 0x1D71B},
      {0x03F0, 0x1D718}, {0x03F1, 0x1D71A}, {0x03F4, 0x1D6F3},
      {0x03F5, 0x1D716}};

  for (auto& test_data : italics_test_data)
    EXPECT_EQ(MathVariant(test_data.code_point), test_data.expected);
}

}  // anonymous namespace
}  // namespace WTF
